{⠭, 騥   ணࠬ ࠡ  ଠ⮬ ZXA}
Unit ZXA;

Interface

Uses
  Speccy;

Const
  ZXF_ID:string       = 'ZXF';  { ଠ ZXF 䠩}
  ZXF_Version:byte    = $01;    { ଠ ZXF 䠩}
  ZXF_HeaderDataSize  = 5;      {    㯠 }

  ZXA_ID:string       = 'ZXA';  { ଠ ZXA 䠩}
  ZXA_Version:byte    = $01;    { ଠ ZXA 䠩}
  ZXA_HeaderDataSize  = 2;      {    樨}
  ZXA_FrameHeaderSize = 4;      {    㯠 }
                                {  ࠭  ZXA}

  ID_Size:byte        = 3;      { ᨣ ଠ 䠩}
                                {    ZXF  ZXA 䠩}
Const
{⢮  ⢥   ⨯ 権}
  qSkip     = 32;
  qInverse  = 16;
  qByte     = 32;
  qFillFF   = 50;
  qFillZero = 50;
  qSpecByte = 32;
  qSequence = 43;
  qEnd      = 1;

{砫    ⨯ 権}
  bSkip     = 0;
  bInverse  = bSkip+qSkip;
  bByte     = bInverse+qInverse;
  bFillFF   = bByte+qByte;
  bFillZero = bFillFF+qFillFF;
  bSpecByte = bFillZero+qFillZero;
  bSequence = bSpecByte+qSpecByte;
  bEnd      = bSequence+qSequence;

{ ᯥ樠 ⮢}
  SpecBytes : array [$00..$0F] of byte =
   ($01,$03,$07,$0F,$1F,$3F,$7F,$FF,
    $FE,$FC,$F8,$F0,$E0,$C0,$80,$00);

  SpecByteSet : set of byte = [$01,$03,$07,$0F,$1F,$3F,$7F,$FF,
                               $FE,$FC,$F8,$F0,$E0,$C0,$80,$00];

{ }
  ptNormal = 0;         {ଠ}
  ptLaced  = 1;         {१}
  ptC64    = 2;         {C64 like}

{ ࠭塞  䫠 }
  flg_ptNormal    = ptNormal;  { ᯮ㥬 }
  flg_ptLaced     = ptLaced;   {                        }
  flg_ptC64       = ptC64;     {                        }
  flg_Columns     = $08;       {=1 ᫨ 뫠 ᯮ짮 ஢   ⮫栬}
  flg_Independent = $10;       {=1 ᫨ ᦨ ᨬ }
                               { 䫠 ᯮ ⮫쪮  ଠ ZXA}

  PlayerTypeMask  = $07;       { 䨪 ⨯  ⢮ 3 }
                               { ᮬ  饥}
Type
  PByteArray = ^TByteArray;
  TByteArray = array [0..6143] of byte;

  TFileType = (ft_PCX, ft_Hobeta, ft_SCR, ft_ZXF, ft_ZXA, ft_Invalid);

{㭪 ।  頥 ⨯ 䠩   FName}
{ন ⨯ 䠩 ᠭ  TFileType}
Function CheckScreen(FName:string):TFileType;
{ ⥪饣     ࠭ ଠ}
{FName -  䠩 (७ ᮧ ⮬᪨)}
{SaveType - ⨯ 㦠 䠩}
{Buf - 㪠⥫    ஬ ࠭ ⥪騩 .}
Procedure SaveScreen(FName:string;Buf:PSpeccyScreen);

Var
  SaveType:TFileType;

Implementation

Uses
  DOS,
  Video,
  StringsUnit,
  ExitUnit;

{㭪 ।  頥 ⨯ 䠩   FName}
{ন ⨯ 䠩 ᠭ  TFileType}
Function CheckScreen(FName:string):TFileType;
var
  valid:boolean;
  b:boolean;
  f:file;
  fs:longint;
  Info:THobetaInfo;
  D:DirStr;
  N:NameStr;
  E:ExtStr;
  s:string;
  v:byte;
begin
{஢塞     PCX}
  if CheckPCX(FName) then
  begin
    CheckScreen:=ft_PCX;
    exit;
  end;
{஢塞     ࠭ 䠩 㬠  Hobeta ଠ}
  if GetHobetaInfo(FName,Info) then
  begin
    CheckScreen:=ft_Hobeta;
    exit;
  end;
{஢塞     ࠭ 䠩 㬠}
{᫨  ७ - SCR  ࠧ ࠢ 6144  6912 ,  ⠥}
{  㬮᪨ ࠭}
  FSplit(FName,D,N,E);
  if (StrUpCase(E)='.SCR') then
  begin
    CheckScreen:=ft_SCR;
    exit;
  end;
  Assign(f,FName);
{$I-}
  Reset(f,1);
{$I+}
  if IOResult<>0 then
  begin
    ErrorMessage:=FName;
    halt(exit_ErrorOpenFile);
  end;
  fs:=FileSize(f);
  if (fs=6144) or (fs=6912) then
  begin
    CheckScreen:=ft_SCR;
    close(f);
    exit;
  end;
{஢塞     ZXF 䠩}
  s[0]:=char(ID_Size);
  BlockRead(f,s[1],ID_Size);    {뢠 䨪 䠩}
  BlockRead(f,v,SizeOf(byte));  {뢠  ଠ 䠩}
  if (s=ZXF_ID) then
    if (v<=ZXF_Version) then    { ଠ     ⮩}
    begin                       { ᯮ   }
      CheckScreen:=ft_ZXF;
      close(f);
      exit;
    end;
{஢塞     ZXA 䠩}
  if (s=ZXA_ID) then
    if (v<=ZXA_Version) then    { ଠ     ⮩}
    begin                       { ᯮ   }
      CheckScreen:=ft_ZXA;
      close(f);
      exit;
    end;
  CheckScreen:=ft_Invalid;
  close(f);
end;

{ ⥪饣     ࠭ ଠ}
{FName -  䠩 (७ ᮧ ⮬᪨)}
{SaveType - ⨯ 㦠 䠩}
{Buf - 㪠⥫    ஬ ࠭ ⥪騩 .}
Procedure SaveScreen(FName:string;Buf:PSpeccyScreen);
var
  D:DirStr;
  N:NameStr;
  E:ExtStr;
  r:byte;
  f:file;
  Info:THobetaInfo;
  i:integer;
begin
  FSplit(FName,D,N,E);
  SetSpeccyScreen(Buf);
  case SaveType of
    ft_PCX:
      begin
        ClearScr;
        FillChar(Palette,SizeOf(Palette),0);
        for i:=0 to 15 do
        begin
          Palette[i,1]:=SpeccyPalette[i,1];
          Palette[i,2]:=SpeccyPalette[i,2];
          Palette[i,3]:=SpeccyPalette[i,3];
        end;
        ViewSpeccyScreen(ScreenBuf,0,0);
        FName:=D+N+'.pcx';
        r:=WritePCX(FName,GetPScreen(ScreenBuf),0,0,256,192,@Palette);
        if r<>exit_Ok then
          halt(r);
      end;
    ft_SCR:
      begin
        FName:=D+N+'.scr';
        Assign(f,FName);
{$I-}
        Rewrite(f,1);
{$I+}
        if IOResult<>0 then
        begin
          ErrorMessage:=FName;
          halt(exit_ErrorOpenFile);
        end;
        BlockWrite(f,Buf^,SizeOf(Buf^));
        close(f);
      end;
    ft_Hobeta:
      begin
        FName:=D+N+'.$c';
        Info.Name:=N;
        Info.Ext:='C';
        Info.Start:=$4000;
        Info.Length:=$1B00;
        WriteHobetaFile(FName,Info,Buf,SizeOf(Buf^));
      end;
  end;
end;

END.
