;------------------------.
; CHUNK ANIMATONS PLAYER |-.
; (c) 1998 by Flying/DR  | |
;________________________; |
  ;________________________;

;=== SOME WORDS ABOUT MEMORY USAGE ===

;AREA #8000-#8FFF IS USED FOR STORING NECESSARY TABLES AND 
;PROCEDURES FOR CHUNK BUFFER RENDERING ROUTINE

;IM2 TABLE IS PLACED AT #BE00

;IM2 STACK IS PLACED AT #BFC2-#BFFF

;TRY TO CHANGE THESE OPTIONS TO MAKE SOME DIFFRENCES:
;USE_2_SCREENS
;CHUNK_TYPE
;PLAY_SPEED
;USE_FAST_PLAYER

;=== COMMON ===

;THIS EQUS IS ONLY NEEDED TO SET SOME CONFIGURATON FLAGS

YES     EQU 0
NO      EQU 1

USE_2_SCREENS EQU NO

;SPECIFY CHUNK BUFFER SIZE AND SCREEN ADDRESS, WHERE IT WILL
;BE RENDERED

BUF_XS  EQU 64          ;CHUNK BUFFER X SIZE
BUF_YS  EQU 32          ;CHUNK BUFFER Y SIZE
.IF USE_2_SCREENS
SCRADR  EQU #C080       ;SCREEN ADDRESS
.ELSE
SCRADR  EQU #4080       ;SCREEN ADDRESS
.ENDIF

;=== FAST_OUT ===

;SOME EQUS TO CONFIGURING CHUNK BUFFER RENDERING ROUTINES

USE_CLEAR EQU NO        ;ENABLE THIS SWITCH WHEN YOU NEED
                        ;TO CLEAR YOUR CHUNK BUFFER
                        ;YOU MUST JUST CALL ~CLEAR~ ROUTINE,
                        ;ALL OTHER THINGS ARE MAKES
                        ;AUTOMATICALLY

CHUNK_DITHER EQU 0
CHUNK_PIXEL  EQU 1

CHUNK_TYPE EQU CHUNK_DITHER
                        ;USE THIS VARIABLE TO SET PREFERED
                        ;CHUNK TYPE

;=== OTHER EQUS ===

DEPACKER        EQU #5B00       ;HRUST DEPACKER PLACE

IMTABLE         EQU #BE00       ;IM2 TABLE

IM2_STACK      EQU IMTABLE+#200 ;AREA FOR STORING IM2 ROUTINE
                                ;CUSTOM STACK

START_ADR       EQU #9000       ;PROGRAM START ADDRESS

PLAY_SPEED      EQU 3           ;ANIMATON PLAY SPEED
USE_FAST_PLAYER EQU YES         ;YOU CAN CHOOSE PLAYER, WHICH
                                ;YOU WANT TO USE.
                                ;FAST PLAYER IS MORE OPTIMIZED
                                ;AND BIGGER A BIT.
                                ;SLOW PLAYER IS ONLY FOR
                                ;DEMONSTRATING YOU A DEPACKING
                                ;ALGORITHM

;--------------------------------------------.
; THERE IS INFORMATON ABOUT ANIMATION BLOCKS |-.
;____________________________________________; |
  ;____________________________________________;

;START ADDRESSES OF IT
ANIM_1     EQU #C000
ANIM_2     EQU #C000
ANIM_3     EQU #C000

;PAGES WHERE ANIMATION BLOCKS ARE STORED
ANIM_1_PG  EQU #10
ANIM_2_PG  EQU #11
ANIM_3_PG  EQU #13

        ORG DEPACKER
        .INCBIN DEHRUST

        .PAGE ANIM_1_PG
        ORG ANIM_1
        .INCBIN town01*

        .PAGE ANIM_2_PG
        ORG ANIM_2
        .INCBIN town02*

        .PAGE ANIM_3_PG
        ORG ANIM_3
        .INCBIN town03*

        .PAGE #10
        ORG START_ADR

;...INITIALIZE ALL SYSTEMS...
        LD (EXIT_SP+1),SP       ;STORE SP FOR CORRECT EXIT
        CALL CLEAR_TWO_SCREENS  ;CLEAR SCREENS
        LD HL,SCRBUF            ;CLEAR CHUNK BUFFER. THIS IS
        LD DE,SCRBUF+1          ;NECESSARY, COZ BUFFER _MUST_ BE
        LD BC,BUF_XS*BUF_YS-1   ;EMPTY WHEN ANIMATON STARTS TO
        LD (HL),0               ;PLAY
        LDIR
        CALL OUTPUT_INIT      ;INITIALIZE CHUNK OUTPUT ROUTINES
.IF USE_2_SCREENS
        LD A,#17
        LD (_PAGE_+1),A
.ENDIF
        LD A,PLAY_SPEED
        LD (INT_COUNTER+1),A
        CALL SETIM2           ;SET IM2 MODE. NECESSARY TO MAKE
                              ;CORRECT WORK OF CHUNK OUTPUT
                              ;ROUTINES

;...UNPACK ANIMATON...
        LD A,ANIM_1_PG
        LD HL,ANIM_1
        LD DE,ANIM_1
        CALL UNPACK_ANIM
        LD A,ANIM_2_PG
        LD HL,ANIM_2
        LD DE,ANIM_2
        CALL UNPACK_ANIM
        LD A,ANIM_3_PG
        LD HL,ANIM_3
        LD DE,ANIM_3
        CALL UNPACK_ANIM

;...PLAY ANIMATION...
        LD A,ANIM_1_PG
        LD HL,ANIM_1
        LD B,20
        CALL DO_FRAME
        LD A,ANIM_2_PG
        LD HL,ANIM_2
        LD B,24
        CALL DO_FRAME
        LD A,ANIM_3_PG
        LD HL,ANIM_3
        LD B,7
        CALL DO_FRAME

;...EXIT...
        DI
        IM 1
        LD A,#3F
        LD I,A
        LD IY,#5C3A
        LD HL,#2758
        EXX
        LD A,#10
        CALL SET_PAGE_SCR
EXIT_SP LD SP,00000
        EI
        RET

UNPACK_ANIM
        ;UNPACK ANIMATON BLOCK
        ;AT ENTER:
        ;   A  - PAGE NUMBER, WHERE ANIMATION BLOCK IS STORED
        ;   HL - ADDRESS OF PACKED ANIMATION BLOCK
        ;   DE - ADDRESS WHERE TO UNPACK
        CALL SET_PAGE_NOSCR
        CALL DEPACKER
        RET

DO_FRAME
        ;VIEW PART OF ANIMATION
        ;   HL - POINTER ON ANIMATION
        ;   B  - FRAMES QUANTITY
        ;   A  - PAGE NUMBER
.IF USE_2_SCREENS
        CALL SET_PAGE_NOSCR
DO_FRM  PUSH BC
        CALL UNPACK_FRAME
        HALT
        LD A,(PAGE)
        PUSH AF
_PAGE_  LD A,00
        XOR #0A
        LD (_PAGE_+1),A
        CALL SET_PAGE_SCR
        PUSH HL
        CALL OUTPUT
_WAIT   HALT
INT_COUNTER
        LD A,00
        OR A
        JR NZ,_WAIT
        LD A,PLAY_SPEED
        LD (INT_COUNTER+1),A
        POP HL
        POP AF
        CALL SET_PAGE_NOSCR
        POP BC
        DJNZ DO_FRM
        RET
.ELSE
        CALL SET_PAGE_NOSCR
DO_FRM  PUSH BC
        CALL UNPACK_FRAME
        HALT
        PUSH HL
        CALL OUTPUT
_WAIT   HALT
INT_COUNTER
        LD A,00
        OR A
        JR NZ,_WAIT
        LD A,PLAY_SPEED
        LD (INT_COUNTER+1),A
        POP HL
        POP BC
        DJNZ DO_FRM
        RET
.ENDIF

UNPACK_FRAME
        ;UNPACK ANIMATON FRAME TO SCRBUF
        ;AT ENTER:
        ;   HL - POINTER ON PACKED FRAME
        ;AT EXIT:
        ;   HL - POINTER ON NEXT PACKED FRAME

;... THERE IS FAST PLAYER...
.IF USE_FAST_PLAYER
        LD D,H
        LD E,L
        PUSH HL
        LD HL,BUF_XS*BUF_YS/8   ;SIZE OF CHANGING FLAGS SET 
        ADD HL,DE
        LD DE,SCRBUF
        POP IX
        XOR A
        LD (DFR_DATA_1+1),A
        LD (DFR_DATA_2+1),A
        LD B,BUF_YS
DFR_1   PUSH BC
        LD A,BUF_XS/8
DFR_2   EX AF,AF'
        LD C,(IX+0)
DFR_DATA_1
        LD A,00
        RL C
        JR NC,DFR_01
        RLD
        LD (DE),A
        JP DFR_11
DFR_01  INC DE
        RL C
        JR NC,DFR_02
        RLD
        LD (DE),A
        JP DFR_12
DFR_02  INC DE
        RL C
        JR NC,DFR_03
        RLD
        LD (DE),A
        JP DFR_13
DFR_03  INC DE
        RL C
        JR NC,DFR_04
        RLD
        LD (DE),A
        JP DFR_14
DFR_04  INC DE
        RL C
        JR NC,DFR_05
        RLD
        LD (DE),A
        JP DFR_15
DFR_05  INC DE
        RL C
        JR NC,DFR_06
        RLD
        LD (DE),A
        JP DFR_16
DFR_06  INC DE
        RL C
        JR NC,DFR_07
        RLD
        LD (DE),A
        JP DFR_17
DFR_07  INC DE
        RL C
        JR NC,DFR_08
        RLD
        LD (DE),A
        JP DFR_18
DFR_08  INC DE
        LD (DFR_DATA_1+1),A
        LD (DFR_DATA_2+1),A
        INC IX
        EX AF,AF'
        DEC A
        JP NZ,DFR_2
        POP BC
        DEC B
        JP NZ,DFR_1
        RET

DFR_1_  PUSH BC
        LD A,BUF_XS/8
DFR_2_  EX AF,AF'
        LD C,(IX+0)
DFR_DATA_2
        LD A,00
        RL C
        JR NC,DFR_11
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_01
DFR_11  INC DE
        RL C
        JR NC,DFR_12
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_02
DFR_12  INC DE
        RL C
        JR NC,DFR_13
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_03
DFR_13  INC DE
        RL C
        JR NC,DFR_14
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_04
DFR_14  INC DE
        RL C
        JR NC,DFR_15
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_05
DFR_15  INC DE
        RL C
        JR NC,DFR_16
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_06
DFR_16  INC DE
        RL C
        JR NC,DFR_17
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_07
DFR_17  INC DE
        RL C
        JR NC,DFR_18
        RLD
        LD (DE),A
        RLD
        INC HL
        JP DFR_08
DFR_18  INC DE
        LD (DFR_DATA_1+1),A
        LD (DFR_DATA_2+1),A
        INC IX
        EX AF,AF'
        DEC A
        JP NZ,DFR_2_
        POP BC
        DEC B
        JP NZ,DFR_1_
        LD A,(DFR_DATA_1+1)
        RLD
        RLD
        INC HL
        RET

;... SLOW PLAYER ...
.ELSE
        LD D,H
        LD E,L
        PUSH HL
        LD HL,BUF_XS*BUF_YS/8   ;SIZE OF CHANGING FLAGS SET 
        ADD HL,DE
        LD DE,SCRBUF
        POP IX
        XOR A
        LD (DFR_CARRY+1),A
        LD B,BUF_YS
DFR_1   PUSH BC
        LD B,BUF_XS/8
DFR_2   PUSH BC
        LD C,(IX+0)
        LD B,8
DFR_3   RL C
        JR NC,DFR_9
DFR_CARRY
        LD A,00
        OR A
        JR NZ,DFR_4
        LD A,(HL)
        RRCA
        RRCA
        RRCA
        RRCA
        AND #0F
        LD (DE),A
        JR DFR_5
DFR_4   LD A,(HL)
        AND #0F
        LD (DE),A
        INC HL
DFR_5   LD A,(DFR_CARRY+1)
        CPL
        LD (DFR_CARRY+1),A
DFR_9   INC DE
        DJNZ DFR_3
        INC IX
        POP BC
        DJNZ DFR_2
        POP BC
        DJNZ DFR_1
        LD A,(DFR_CARRY+1)
        OR A
        RET Z
        INC HL
        RET
.ENDIF

CLEAR_TWO_SCREENS
        EI
        HALT
        XOR A
        OUT (#FE),A
        LD HL,#5AFF
        LD DE,#5AFE
        LD BC,#1B00
        LD (HL),A
        LDDR
        LD HL,#5800
        LD DE,#5801
        LD BC,#2FF
        LD (HL),#47
        LDIR
        LD A,#17
        CALL SET_PAGE_SCR
        LD HL,#4000
        LD DE,#C000
        LD BC,#1B00
        LDIR
        LD A,#10
        CALL SET_PAGE_SCR
        RET

SET_PAGE_SCR
        PUSH BC
        LD BC,#7FFD
        OR #10
        LD (PAGE),A
        OUT (C),A
        POP BC
        RET

SET_PAGE_NOSCR
        PUSH BC
        AND #F7
        LD C,A
        LD A,(PAGE)
        AND 8
        OR C
        OR #10
        LD BC,#7FFD
        LD (PAGE),A
        OUT (C),A
        POP BC
        RET

SETIM2  DI
        LD HL,IMTABLE
        LD DE,IMTABLE+1
        LD BC,#100
        LD (HL),IMTABLE/#100+1
        LDIR
        LD A,#C3
        LD (((IMTABLE/#100+1)*256)+(IMTABLE/#100+1)),A
        LD HL,IM2
        LD (((IMTABLE/#100+1)*256)+(IMTABLE/#100+1)+1),HL
        LD A,IMTABLE/#100
        LD I,A
        IM 2
        EI
        RET

NLINDE  INC D
        LD A,D
        AND 7
        RET NZ
        LD A,E
        ADD A,#20
        LD E,A
        RET C
        LD A,D
        SUB 8
        LD D,A
        RET

;LOAD CHUNK BUFFER RENDERING MODULE
        .INCLUDE FAST_OUT

;IM2 ROUTINE.
;_IM2_START AND _IM2_END - THIS IS MACROSES SPECIFIED INTO
;FAST_OUT MODULE. THEY ARE MUST BE USED INTO IM2 ROUTINE TO
;MAKE FAST_OUT MODULE WORK CORRECTLY

IM2
        _IM2_START
        LD A,(INT_COUNTER+1)
        OR A
        JR Z,IM21
        DEC A
        LD (INT_COUNTER+1),A
IM21
        _IM2_END

PAGE    DEFB 0

                                                                                                                                                                                                                                                          