/* Definitions of target machine for GNU compiler for m68k targets using
   assemblers derived from AT&T "SGS" releases.
   Copyright (C) 1991, 1993 Free Software Foundation, Inc.
   Written by Fred Fish (fnf@cygnus.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Created by Martin Day, SN Systems, November 1994 */

#define MOTOROLA		/* Use Motorola syntax rather than "MIT" */

#include "m68k.h"

/* Output at beginning of assembler file.  */

#undef ASM_FILE_START
#define ASM_FILE_START(FILE)	\
( fprintf (FILE, "!NO_APP\n"), \
  output_file_directive ((FILE), main_input_filename))

/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#undef ASM_APP_ON
#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#undef ASM_APP_OFF
#define ASM_APP_OFF ""

#define TARGET_DEFAULT 0

/* Don't try using XFmode.  */
#undef LONG_DOUBLE_TYPE_SIZE
#define LONG_DOUBLE_TYPE_SIZE 64

#define CPP_PREDEFINES "-Dmc68k -D__motorola__ -Acpu(m68k) -Amachine(m68k)"

#undef CPP_SPEC
#define CPP_SPEC "%{m68881:-D__HAVE_68881__} \
%{!ansi:%{m68020:-Dmc68020}%{mc68020:-Dmc68020}%{!mc68020:%{!m68020:-Dmc68010}}}"

#undef LIB_SPEC
#define LIB_SPEC "%{!shlib:%{p:-L/lib/libp} %{pg:-L/lib/libp} -lc}"

#define MACHINE_TYPE	"M68000"

#define DOLLARS_IN_IDENTIFIERS 0

#define STRUCTURE_SIZE_BOUNDARY 16

#define SDB_DEBUGGING_INFO
