// Parts based on http://www.physics.emory.edu/~weeks/software/mandel.c

#include <stdio.h>
#include <inttypes.h>

#define ITERMAX	4095
#define XRES	640
#define YRES	480

#define SEXYDATATYPE	uint32_t
#define INTERMEDIATE_DATA_TYPE	uint64_t

// 8.24
#define SHIFTY	24
#define MULLY	(1 << SHIFTY)

#define TOFIXED(a)	(MULLY * (a))

static inline uint32_t MULT(const uint32_t a_in, const uint32_t b_in)
{
 uint32_t ret;
 uint32_t sign_temp[2];
 uint32_t a, b;

 a = a_in;
 b = b_in;

 sign_temp[0] = a >> 31;
 sign_temp[0] ^= 1;
 sign_temp[0]--;

 a ^= sign_temp[0];
 a += sign_temp[0] & 1;
 
 sign_temp[1] = b >> 31;
 sign_temp[1] ^= 1;
 sign_temp[1]--;

 b ^= sign_temp[1];
 b += sign_temp[1] & 1;


 // Now, do the actual multiply
 ret = ((INTERMEDIATE_DATA_TYPE)a * b) >> SHIFTY;



 sign_temp[0] ^= sign_temp[1];
 ret ^= sign_temp[0];
 ret += sign_temp[0] & 1;

 return(ret);
}

int main(int argc, char *argv[])
{
        const SEXYDATATYPE x0_start = (SEXYDATATYPE)(int32_t)TOFIXED(-2.0);
        const SEXYDATATYPE y0_start = (SEXYDATATYPE)(int32_t)TOFIXED(1.0);
        const SEXYDATATYPE x0_step = (SEXYDATATYPE)(int32_t)TOFIXED(3.0 / XRES);
        const SEXYDATATYPE y0_step = (SEXYDATATYPE)(int32_t)TOFIXED(-2.0 / YRES);

	unsigned int px, py;
	unsigned int iteration;

	SEXYDATATYPE x,y;
	SEXYDATATYPE x0, y0;
        SEXYDATATYPE xtemp;
        SEXYDATATYPE xx;
        SEXYDATATYPE yy;
	SEXYDATATYPE xx_yy;

	// PPM header
	printf("P6\n%d %d\n255\n", XRES, YRES);

	y0 = y0_start;
	py = YRES;

	YLoop:

	 x0 = x0_start;
	 px = XRES;

	 XLoop:

	  x = x0;
	  y = y0;

	  iteration = 0;

	  if((MULT(x,x) + MULT(y, y)) >= TOFIXED(2 * 2))
	   goto SkipIterLoop;
	  
	  IterLoop:

	   xx = MULT(x, x);
	   yy = MULT(y, y);
	   xx_yy = xx + yy;

	   xtemp = xx;
	   xtemp -= yy;
	   xtemp += x0;

	   y = MULT(x, y);
	   y = y << 1;
	   y += y0;

	   x = xtemp;
	   iteration++;

 	   if(iteration < ITERMAX && xx_yy < TOFIXED(2 * 2))
	    goto IterLoop;


	  SkipIterLoop: ;

	  // Output the PPM pixel
	  {
	   int red = 0;
	   int green = 0;
 	   int blue = 0;

	   blue = iteration & 0xF0;
	   red = (iteration & 0x0F) << 4;
	   green = (iteration & 0xF00) >> 4;

	   fputc(red, stdout);	// Red
	   fputc(green, stdout); // Green
	   fputc(blue, stdout);	// Blue
	  }

         px--;
	 x0 += x0_step;
	 if(px)
	  goto XLoop;

	py--;
	y0 += y0_step;
	if(py)
	 goto YLoop;

}

