/* main.c */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <allegro.h>


#include "main.h"
#include "e900h.h"
#include "e900h.c"
#include "d900h.h"
#include "d900h.c"
#include "memory.c"
#include "functs.c"



PALLETE  the_pallete;
BITMAP   *buffer;     //screen buffer
BITMAP   *bg;
BITMAP   *dbgWndB;
BITMAP   *regWndB;
BITMAP   *gfxWndB;
BITMAP   *memWndB;


#define VERSION "NGPCdebug build #1999-12-24"


#define GFX_DEPTH   16
#define GFX_WIDTH	640
#define GFX_HEIGHT	480

int main(int argc, char *argv[]) {

    /* Allegro initializion */
    allegro_init();
    install_keyboard(); 
    install_mouse();

    printf("%s\n\n",VERSION);


    if (argc==1) {
        printf("Syntax : %s image.ngp [-o cntbp | -b hexbp]\n\n",argv[0]);

        return 0;
    }
    if (argc==4) { /* check for -o or -b */

	if (!strcmp(argv[2],"-o")) { /* opcode count breakpoint */
	    bp_type=BPOPCNT;
	    bp_opcnt=atoi(argv[3]);	    
	} else if (!strcmp(argv[2],"-b")) { /* hexaddress breakpoint */
	    bp_type=BPHEX;
	    strcpy(dbuf,argv[3]);
    	    bp_hex=str2hex(dbuf);
	} else {
	    printf("Unrecognized parameter: %s\n",argv[2]);
	    exit(0);
	}
    }

    rom_name = argv[1];


    //printf("Loading %s ...\n",rom_name);
    load_file();


    /* Load the GUI */
    load_gui();

    show_mouse(NULL);

    destroy_bitmap(bg);
    destroy_bitmap(buffer);
    destroy_bitmap(dbgWndB);
    destroy_bitmap(regWndB);
    destroy_bitmap(gfxWndB);
    destroy_bitmap(memWndB);

    return 0;
} END_OF_MAIN();   /* stupid allegro shit */


void load_gui() {
    ulong Tmp32;
    uint  Tmp16;
    int   c,d;

    char  dbgT=0,regT=0,gfxT=0,memT=0;
    short dbgTx=0,dbgTy=0,regTx=0,regTy=0,gfxTx=0,gfxTy=0,memTx=0,memTy=0;

    load_regs();  /* load 900/h registers */

    dbgWnd.x=25;
    dbgWnd.y=5;
    dbgWnd.w=590;
    dbgWnd.h=364;
    dbgWnd.col=60;
    dbgWnd.active=1;
    dbgWnd.visible=1;
    dbgWnd.locked=0;

    regWnd.x=25;
    regWnd.y=401;
    regWnd.w=590;
    regWnd.h=74;
    regWnd.col=60;
    regWnd.active=0;
    regWnd.visible=1;
    regWnd.locked=0;

    gfxWnd.x=490;
    gfxWnd.y=100;
    gfxWnd.w=130;
    gfxWnd.h=151;
    gfxWnd.col=60;
    gfxWnd.active=0;
    gfxWnd.visible=0;
    gfxWnd.locked=0;

    memWnd.x=100;
    memWnd.y=200;
    memWnd.w=351;
    memWnd.h=214;
    memWnd.col=60;
    memWnd.active=0;
    memWnd.visible=0;
    memWnd.locked=0;


    /* Set up display */


    set_color_depth(GFX_DEPTH);
    if (set_gfx_mode(GFX_AUTODETECT,GFX_WIDTH,GFX_HEIGHT,0,0) != 0) {
        printf("Error setting video mode %dx%d, %dbpp.\n",GFX_WIDTH,GFX_HEIGHT,GFX_DEPTH);
        exit(-1);
    }

    clear(screen);
    text_mode(-1); //=draw text transparent

    buffer = create_bitmap(SCREEN_W, SCREEN_H);
    clear(buffer);



    /* Load background */
    bg = load_bitmap(*bgn,the_pallete);


    /* Set up mouse cursor */
    //set_mouse_sprite_focus(0, 0); //upper left


  

    /* creates and fills debug window */
    dbgWndB = create_bitmap(dbgWnd.w,dbgWnd.h);
    clear(dbgWndB);
    floodfill(dbgWndB,0,0,40);
    rect(dbgWndB,0,0,dbgWnd.w-1,dbgWnd.h-1,dbgWnd.col);
    hline(dbgWndB,0,11,dbgWnd.w-1,dbgWnd.col);

    dPC=0x200000; dPCc=dPC;


  
    /* creates and fills register window */
    regWndB = create_bitmap(regWnd.w,regWnd.h);
    clear(regWndB);
    floodfill(regWndB,0,0,40);
    rect(regWndB,0,0,regWnd.w-1,regWnd.h-1,regWnd.col);
    hline(regWndB,0,11,regWnd.w-1,regWnd.col);



    /* creates tile browser window */
    gfxWndB = create_bitmap(gfxWnd.w,gfxWnd.h);
    clear(gfxWndB);
    floodfill(gfxWndB,0,0,40);
    rect(gfxWndB,0,0,gfxWnd.w-1,gfxWnd.h-1,gfxWnd.col);
    hline(gfxWndB,0,11,gfxWnd.w-1,gfxWnd.col);
    gfxP=0x200000;



    /* creates memory browser window */
    memWndB = create_bitmap(memWnd.w,memWnd.h);
    clear(memWndB);
    floodfill(memWndB,0,0,40);
    rect(memWndB,0,0,memWnd.w-1,memWnd.h-1,memWnd.col);
    hline(memWndB,0,11,memWnd.w-1,memWnd.col);
    mPC=0x140000;




    REFRESH_DISASM;
    REFRESH_REGS;
    REFRESH_TILES;
    REFRESH_MEM;


    /* draw screen */
    REFRESH_WND;
    REFRESH_SCREEN;



    /* Make sure regpointers is updated properly */
    UPDATE_REGBANK;

    show_mouse(screen);
    opcnt=0;
    
    do {
        if (mouse_b & 1) {  //left button pressed
            if ( ((mouse_x>=memWnd.x)&&(mouse_x<=memWnd.x+memWnd.w) && (mouse_y>=memWnd.y)&&(mouse_y<=memWnd.y+memWnd.h))&&memWnd.visible ) {
                //click inside mem window structure
                if (!memT) {
                    memT=1;
                    memTx=mouse_x;
                    memTy=mouse_y;
                    if (memWnd.active==0) {
                        memWnd.active=1;
                        gfxWnd.active=0;
                        regWnd.active=0;
                        dbgWnd.active=0;
                        REFRESH_WND;
                        REFRESH_SCREEN;
                    }
                } else {
                    memT=0;
                    if (memWnd.locked==0) {
                        if ((mouse_x!=memTx)||(mouse_y!=memTy)) {
                            memWnd.x+=(mouse_x-memTx)*2;
                            memWnd.y+=(mouse_y-memTy)*2;
                            REFRESH_SCREEN;
                        }
                    }
                }
            } else if ( ((mouse_x>=gfxWnd.x)&&(mouse_x<=gfxWnd.x+gfxWnd.w) && (mouse_y>=gfxWnd.y)&&(mouse_y<=gfxWnd.y+gfxWnd.h))&&gfxWnd.visible ) {
                //click inside gfx window structure
                if (!gfxT) {
                    gfxT=1;
                    gfxTx=mouse_x;
                    gfxTy=mouse_y;
                    if (gfxWnd.active==0) {
                        memWnd.active=0;
                        gfxWnd.active=1;
                        regWnd.active=0;
                        dbgWnd.active=0;
                        REFRESH_WND;
                        REFRESH_SCREEN;
                    }
                } else {
                    gfxT=0;
                    if (gfxWnd.locked==0) {
                        if ((mouse_x!=gfxTx)||(mouse_y!=gfxTy)) {
                            gfxWnd.x+=(mouse_x-gfxTx)*2;
                            gfxWnd.y+=(mouse_y-gfxTy)*2;
                            REFRESH_SCREEN;
                        }
                    }
                }
            } else if ( ((mouse_x>=regWnd.x)&&(mouse_x<=regWnd.x+regWnd.w) && (mouse_y>=regWnd.y)&&(mouse_y<=regWnd.y+regWnd.h))&&regWnd.visible ) {
                //click inside register window structure
                if (!regT) {
                    regT=1;
                    regTx=mouse_x;
                    regTy=mouse_y;
                    if (!regWnd.active) {
                        memWnd.active=0;
                        gfxWnd.active=0;
                        regWnd.active=1;
                        dbgWnd.active=0;
                        REFRESH_WND;
                        REFRESH_SCREEN;
                    }
                } else {
                    regT=0;

                    if (regWnd.locked==0) {
                        if ((mouse_x!=regTx)||(mouse_y!=regTy)) {
                            regWnd.x+=(mouse_x-regTx)*2;
                            regWnd.y+=(mouse_y-regTy)*2;
                            REFRESH_SCREEN;
                        }
                    }
                }
            } else if ( ((mouse_x>=dbgWnd.x)&&(mouse_x<=dbgWnd.x+dbgWnd.w) && (mouse_y>=dbgWnd.y)&&(mouse_y<=dbgWnd.y+dbgWnd.h))&&dbgWnd.visible ) {
                //click inside debug window structure
                if (!dbgT) {
                    dbgT=1;
                    dbgTx=mouse_x;
                    dbgTy=mouse_y;
                    if (!dbgWnd.active) {
                        memWnd.active=0;
                        gfxWnd.active=0;
                        regWnd.active=0;
                        dbgWnd.active=1;
                        REFRESH_WND;
                        REFRESH_SCREEN;
                    }
                } else {
                    dbgT=0;

                    if (dbgWnd.locked==0) {
                        if ((mouse_x!=dbgTx)||(mouse_y!=dbgTy)) {
                            dbgWnd.x+=(mouse_x-dbgTx)*2;
                            dbgWnd.y+=(mouse_y-dbgTy)*2;
                            REFRESH_SCREEN;
                        }
                    }
                }
            }
        } else {
            dbgT=0; //button is released
            regT=0;
            gfxT=0;
            memT=0;
        }

        if (key[KEY_ESC]) {
            return;
        } else if (key[KEY_F1]) {
            /* display help screen */
            clear_keybuf();

            show_mouse(NULL);

            rectfill(screen,0,0,SCREEN_W-1,SCREEN_H-1,4);

            rect(screen,5,5,SCREEN_W-6,SCREEN_H-6,60);
            floodfill(screen,10,10,40);

            textout(screen,font,"NGPCdebug by anarko <anarko@hushmail.com>",10,10,-1);

            textout(screen,font,"Global commands                                          ",10, 30,0x80FF);
            textout(screen,font,"ESC        Quit program                                  ",10, 40,-1);
            textout(screen,font,"ALT-T      Show/hide Tile browser                        ",10, 50,-1);
            textout(screen,font,"ALT-M      Show/hide Memory viewer                       ",10, 60,-1);
            textout(screen,font,"ALT-D      Show/hide Disassembly window                  ",10, 70,-1);
            textout(screen,font,"ALT-R      Show/hide Registers window                    ",10, 80,-1);
            textout(screen,font,"ALT-A      Show/hide all windows                         ",10, 90,-1);
            textout(screen,font,"ALT-C      Configuration                             (nd)",10,100,-1);


            textout(screen,font,"Disassembly window                                       ",10,130,0x80FF);
            textout(screen,font,"Up/Down    Scrolls one line                          (nd)",10,140,-1);
            textout(screen,font,"PGUP/PGDN  Scrolls one page                          (nd)",10,150,-1);
            textout(screen,font,"HOME/END   Jumps to beginning/end                    (nd)",10,160,-1);
            textout(screen,font,"S          Jumps to startup offset                       ",10,170,-1);
            textout(screen,font,"J          Jumps to prompted offset                  (nd)",10,180,-1);


            textout(screen,font,"Debugging commands                                       ",10,200,0x80FF);
            textout(screen,font,"TAB        Mark breakpoint                           (nd)",10,210,-1);
            textout(screen,font,"F8         Step trough code                              ",10,220,-1);
            textout(screen,font,"F9         Run until breakpoint                      (nd)",10,230,-1);
            textout(screen,font,"F12        Reset virtual machine                     (nd)",10,240,-1);


            textout(screen,font,"Tile and Memory browser windows                          ",10,260,0x80FF);
            textout(screen,font,"Arrows     Scrolls one line                              ",10,270,-1);
            textout(screen,font,"PGUP/PGDN  Scrolls one page                              ",10,280,-1);
            textout(screen,font,"HOME/END   Jumps to beginning/end                        ",10,290,-1);
            textout(screen,font,"+/-        Adjust tiles by one byte (Tile broswer only)  ",10,300,-1);
            textout(screen,font,"S          Jumps to startup offset                       ",10,310,-1);
            textout(screen,font,"J          Jumps to prompted offset                  (nd)",10,320,-1);


            textout(screen,font,"(nd) means NOT DONE.                                     ",10,350,-1);


            textout(screen,font,"Press a key to get rid of this text",10,460,-1);

            show_mouse(screen);

            readkey();
            clear_keybuf();

            REFRESH_SCREEN;
        } else if (key[KEY_F8]) {
            /* Execute one instruction */
            emu900h();
            opcnt++;

            /* weak attemt to make stepping look smoother */
            //if ( (dPC-30) > PC ) dPC=PC;
            dPC=PC;

            REFRESH_DISASM;
            REFRESH_REGS;
            REFRESH_MEM;
            REFRESH_TILES;

            draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
            draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
            draw_sprite(buffer,regWndB,regWnd.x,regWnd.y);
            draw_sprite(buffer,dbgWndB,dbgWnd.x,dbgWnd.y);

            REFRESH_SCREEN;

            clear_keybuf();
	    
	} else if (key[KEY_F9]) {
            /* executes until breakpoint */
	    
	    switch (bp_type) {
            case BPOPCNT:
                while (opcnt<bp_opcnt) {
                    emu900h();
                    opcnt++;
                } break;

            case BPHEX:
                while (PC!=bp_hex) {
                    emu900h();
                    opcnt++;
                } break;
            }
            bp_type=BPNONE;

            dPC=PC;

            REFRESH_DISASM;
            REFRESH_REGS;
            REFRESH_MEM;
            REFRESH_TILES;

            draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
            draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
            draw_sprite(buffer,regWndB,regWnd.x,regWnd.y);
            draw_sprite(buffer,dbgWndB,dbgWnd.x,dbgWnd.y);

            REFRESH_SCREEN;

            clear_keybuf();
	    
        } else if (key[KEY_DOWN]) {
            /* check if dbg is active */
            if (dbgWnd.active) {
                /* draw disassembly */
                dPCc=dPCc+dbgscrl[0]; dPC=dPCc;
                REFRESH_DISASM;

                /* updates screen */
                draw_sprite(buffer,dbgWndB,dbgWnd.x,dbgWnd.y);

                REFRESH_SCREEN;
            } else if (gfxWnd.active) {
                if (gfxP<(0x1000000-0x800)) {
                    gfxP+=0x80;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC<(0x1000000-0x140)) {
                    mPC+=0x10;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_UP]) {
            if (gfxWnd.active) {
                if (gfxP>=0x80) {
                    gfxP-=0x80;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC>=0x10) {
                    mPC-=0x10;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_RIGHT]) {
            if (gfxWnd.active) {
                if (gfxP<(0x1000000-0x800)) {
                    gfxP+=0x10;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC<(0x1000000-0x140)) {
                    mPC+=0x1;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_LEFT]) {
            if (gfxWnd.active) {
                if (gfxP>=0x10) {
                    gfxP-=0x10;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC>0x0) {
                    mPC-=0x1;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_PGDN]) {
            if (gfxWnd.active) {
                if (gfxP<(0x1000000-0x800)) {
                    gfxP+=0x800;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC<(0x1000000-0x140)) {
                    mPC+=0x140;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_PGUP]) {
            if (gfxWnd.active) {
                if (gfxP>=0x800) {
                    gfxP-=0x800;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                }
            } else if (memWnd.active) {
                if (mPC>=200) {
                    mPC-=0x140;
                    REFRESH_MEM;

                    /* updates screen */
                    draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                    REFRESH_SCREEN;
                }
            }
            clear_keybuf();
        } else if (key[KEY_HOME]) {
            if (gfxWnd.active) {
                gfxP=0x0;
                REFRESH_TILES;

                /* updates screen */
                draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                REFRESH_SCREEN;
            } else if (memWnd.active) {
                mPC=0x0;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
            }
            clear_keybuf();
        } else if (key[KEY_END]) {
            if (gfxWnd.active) {
                gfxP=0x1000000-0x800;
                REFRESH_TILES;

                /* updates screen */
                draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                REFRESH_SCREEN;
            } else if (memWnd.active) {
                mPC=0x1000000-0x140;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
            }
            clear_keybuf();

        } else if (key[KEY_PLUS_PAD]) {
            if (gfxWnd.active) {
                if (gfxP<(0x1000000-0x800)) {
                    gfxP++;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                } clear_keybuf();
            }
        } else if (key[KEY_MINUS_PAD]) {
            if (gfxWnd.active) {
                if (gfxP>=0x1) {
                    gfxP--;
                    REFRESH_TILES;

                    /* updates screen */
                    draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                    REFRESH_SCREEN;
                } clear_keybuf();
            }
        } else if (key[KEY_S]) {
            if (dbgWnd.active) {
                /* Jumps to start location */
                //dPCc=startPC;
                dPCc=0x200000;
                dPC=dPCc;
                REFRESH_DISASM;

                /* updates screen */
                draw_sprite(buffer,dbgWndB,dbgWnd.x,dbgWnd.y);
                REFRESH_SCREEN;
            } else if (gfxWnd.active) {
                /* Jumps to start location */
                gfxP=0x200000;
                REFRESH_TILES;

                /* updates screen */
                draw_sprite(buffer,gfxWndB,gfxWnd.x,gfxWnd.y);
                REFRESH_SCREEN;
            } else if (memWnd.active) {
                mPC=0x200000;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
            }
	    clear_keybuf();
        } else if (key[KEY_2]) {
            if (memWnd.active) {
		/* jumps to 0x002000 */
		
		mPC=0x002000;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
	    }	    
	    clear_keybuf();
	    
        } else if (key[KEY_4]) {
            if (memWnd.active) {
		/* jumps to 0x004000 */
		
		mPC=0x004000;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
	    }	    
	    clear_keybuf();
	    
        } else if (key[KEY_6]) {
            if (memWnd.active) {
		/* jumps to 0x006000 */
		
		mPC=0x006000;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
	    }	    
	    clear_keybuf();
	    
        } else if (key[KEY_8]) {
            if (memWnd.active) {
		/* jumps to 0x008000 */
		
		mPC=0x008000;
                REFRESH_MEM;

                /* updates screen */
                draw_sprite(buffer,memWndB,memWnd.x,memWnd.y);
                REFRESH_SCREEN;
	    }	    
	    clear_keybuf();
	    
        } else if (key[KEY_T] << 8) { //ALT-T
            gfxWnd.visible=!gfxWnd.visible;
            memWnd.active=0;
            gfxWnd.active=1;
            regWnd.active=0;
            dbgWnd.active=0;
            REFRESH_WND;
            REFRESH_SCREEN;
            clear_keybuf();
        } else if (key[KEY_D] << 8) { //ALT-D
            dbgWnd.visible=!dbgWnd.visible;
            memWnd.active=0;
            gfxWnd.active=0;
            regWnd.active=0;
            dbgWnd.active=1;
            REFRESH_WND;
            REFRESH_SCREEN;
            clear_keybuf();
        } else if (key[KEY_R] << 8) { //ALT-R
            regWnd.visible=!regWnd.visible;
            memWnd.active=0;
            gfxWnd.active=0;
            regWnd.active=1;
            dbgWnd.active=0;
            REFRESH_WND;
            REFRESH_SCREEN;
            clear_keybuf();
        } else if (key[KEY_M] << 8) { //ALT-M
            memWnd.visible=!memWnd.visible;
            memWnd.active=1;
            gfxWnd.active=0;
            regWnd.active=0;
            dbgWnd.active=0;
            REFRESH_WND;
            REFRESH_SCREEN;
            clear_keybuf();
        } else if (key[KEY_A] << 8) { //ALT-A
            if (gfxWnd.visible && dbgWnd.visible && regWnd.visible && memWnd.visible) {
                gfxWnd.visible=0;
                dbgWnd.visible=0;
                regWnd.visible=0;
                memWnd.visible=0;
            } else {
                gfxWnd.visible=1;
                dbgWnd.visible=1;
                regWnd.visible=1;
                memWnd.visible=1;
            }
            REFRESH_SCREEN;
            clear_keybuf();
        }

        vsync();

    } while (1);
}
