/* 900H.h */


/* STATUS REGISTER ENCODING */
typedef union {

        struct {
                unsigned lo : 8;   //flag register
                unsigned hi : 8;   //hi part
        } Byte;

        struct {
                unsigned fC   : 1; //carry
                unsigned fN   : 1; //negative
                unsigned fV   : 1; //parity/overflow
                unsigned fB1  : 1; //=0
                unsigned fH   : 1; //halfword
                unsigned fB2  : 1; //=0
                unsigned fZ   : 1; //zero
                unsigned fS   : 1; //sign

                unsigned rfp  : 2; //register file pointer bit 0 and 1
                unsigned rfp2 : 1; //=0
                unsigned max  : 1; //=1
                unsigned iff  : 3; //interrupt mask flip-flop, =7
                unsigned sysm : 1; //=1
        } Bit;

        uchar byte[2];   //for byte accesss
        uint  both;
} SReg;


SReg sysreg;

#define fC   sysreg.Bit.fC
#define fN   sysreg.Bit.fN
#define fV   sysreg.Bit.fV
#define fB1  sysreg.Bit.fB1
#define fH   sysreg.Bit.fH
#define fB2  sysreg.Bit.fB2
#define fZ   sysreg.Bit.fZ
#define fS   sysreg.Bit.fS

#define rb   sysreg.Bit.rfp
#define rb2  sysreg.Bit.rfp2
#define max  sysreg.Bit.max
#define iff  sysreg.Bit.iff
#define sysm sysreg.Bit.sysm

#define flagreg sysreg.byte[0]
#define SR   sysreg.both

uchar fSHADOW;  //shadow flagreg (F')


/* Sign flag: Is set to 1 when a operation result is negative
                   and 0 when positive.
   Zero flag: Is set to 1 when a operation result is zero,
                   if not it's set to 0. 
   Half carry flag: Is set to 1 when a carry or borrow from
                   bit 3 to bit 4 occurs as a result of the operation,
                   otherwise it's set to 0. If it was used with a 32-bit
                   instruction, an undefined value is set.
                   Example: If the result of a sub or div is above 0x40
                   then flag H is set. 
   Parity/overflow flag: Is set when a parity or overflow occurs.
                 Parity (P): 0 is set when the number of bits set to 1 is odd
                   and to 1 when it's even. If it was used with a 32-bit
                   instruction, an undefined value is set.
                 Overflow (V): 0 is set if no overflow, else 1 is set. 
   Negative: Is set to 0 after an addition instruction,
                 1 after a substraction instruction. Used when executing the
                 DAA (Decimal addition adjust accumulator) instruction.
   Carry flag: Is set to 1 when a carry or borrow occurs,
                  otherwise to 0. Example: If the result of a add is 0x80 or
                  above it's set, or if the result of a sub is below 0x80.  */


/* REGISTER ENCODING */
typedef union {

        struct {
                unsigned lo : 8;   //8 bit BYTE
                unsigned hi : 8;   //8 bit BYTE
                unsigned    : 16;  //not used
        } Byte; //for byte access

        struct {
                unsigned lo : 16;  //16 bit WORD
                unsigned hi : 16;  //not used, except with EXTZ
        } Word;  //for word access

        struct {
                unsigned b0 : 8;  //lowest
                unsigned b1 : 8;
                unsigned b2 : 8;  
                unsigned b3 : 8;  //highest
        } bytes;  //to split up data & push to stack etc

        uchar b[4];   //for byte access
        uint  w[2];   //for word access, not used :)
        ulong DWord;  //for lword access
} Reg;

/* Declares 8 gpr's, 4 of them with register banks */
Reg Reg_XWA[4];
Reg Reg_XBC[4];
Reg Reg_XDE[4];
Reg Reg_XHL[4];
Reg Reg_XIX;
Reg Reg_XIY;
Reg Reg_XIZ;
Reg Reg_XSP;

Reg to4x8b;          /* so i can access a dword as 4 bytes to push to stack */


/* Define the CPU registers */
#define XWA   Reg_XWA[rb].DWord
#define WA    Reg_XWA[rb].w[0]
#define W     Reg_XWA[rb].b[1]
#define A     Reg_XWA[rb].b[0]
#define XBC   Reg_XBC[rb].DWord
#define BC    Reg_XBC[rb].w[0]
#define B     Reg_XBC[rb].b[1]
#define C     Reg_XBC[rb].b[0]
#define XDE   Reg_XDE[rb].DWord
#define DE    Reg_XDE[rb].w[0]
#define D     Reg_XDE[rb].b[1]
#define E     Reg_XDE[rb].b[0]
#define XHL   Reg_XHL[rb].DWord
#define HL    Reg_XHL[rb].w[0]
#define H     Reg_XHL[rb].b[1]
#define L     Reg_XHL[rb].b[0]
#define XIX   Reg_XIX.DWord
#define IX    Reg_XIX.w[0]
#define XIY   Reg_XIY.DWord
#define IY    Reg_XIY.w[0]
#define XIZ   Reg_XIZ.DWord
#define IZ    Reg_XIZ.w[0]
#define XSP   Reg_XSP.DWord
#define SP    Reg_XSP.w[0]

#define TO4X8 to4x8b.DWord
#define _b0   to4x8b.bytes.b0
#define _b1   to4x8b.bytes.b1
#define _b2   to4x8b.bytes.b2
#define _b3   to4x8b.bytes.b3
#define _16lo to4x8b.Word.lo




ulong *xr32[0x40] = {
  0,0,0,0, /* 00-0F bank 0 */
  0,0,0,0, /* 10-1F bank 1 */
  0,0,0,0, /* 20-2F bank 2 */
  0,0,0,0, /* 30-3F bank 3 */

  0,0,0,0, /* 40-4F reserved */
  0,0,0,0, /* 50-5F reserved */
  0,0,0,0, /* 60-6F reserved */
  0,0,0,0, /* 70-7F reserved */

  0,0,0,0, /* 80-8F invalid */
  0,0,0,0, /* 90-9F invalid */
  0,0,0,0, /* A0-AF invalid */
  0,0,0,0, /* B0-BF invalid */
  0,0,0,0, /* C0-CF invalid */

  0,0,0,0, /* D0-DF prev bank */
  0,0,0,0, /* E0-EF current bank */
  0,0,0,0, /* F0-FF static gpr's */
};

uint *xr16[0x80] = {
  0,0,0,0,0,0,0,0, /* 00-0F bank 0 */
  0,0,0,0,0,0,0,0, /* 10-1F bank 1 */
  0,0,0,0,0,0,0,0, /* 20-2F bank 2 */
  0,0,0,0,0,0,0,0, /* 30-3F bank 3 */

  0,0,0,0,0,0,0,0, /* 40-4F reserved */
  0,0,0,0,0,0,0,0, /* 50-5F reserved */
  0,0,0,0,0,0,0,0, /* 60-6F reserved */
  0,0,0,0,0,0,0,0, /* 70-7F reserved */

  0,0,0,0,0,0,0,0, /* 80-8F invalid */
  0,0,0,0,0,0,0,0, /* 90-9F invalid */
  0,0,0,0,0,0,0,0, /* A0-AF invalid */
  0,0,0,0,0,0,0,0, /* B0-BF invalid */
  0,0,0,0,0,0,0,0, /* C0-CF invalid */

  0,0,0,0,0,0,0,0, /* D0-DF prev bank */
  0,0,0,0,0,0,0,0, /* E0-EF current bank */
  0,0,0,0,0,0,0,0, /* F0-FF static gpr's */
};

uchar *xr8[0x100] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 00-0F bank 0 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 10-1F bank 1 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 20-2F bank 2 */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 30-3F bank 3 */

  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 40-4F reserved */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 50-5F reserved */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 60-6F reserved */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 70-7F reserved */

  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 80-8F invalid */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* 90-9F invalid */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* A0-AF invalid */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* B0-BF invalid */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* C0-CF invalid */

  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* D0-DF prev bank */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* E0-EF current bank */
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* F0-FF static gpr's */
};





/* Program counter */
ulong startPC, PC, JmpPC;












/* INSTRUCTION DEFINITIONS */
/*
    r8,r16,r32  -  8,16,32 bit register
    n8,n16,n32  -  8,16,32 bit value (byte,word,dword)
 */

#define LD(dst,src)           dst=src
#define PUSH_SR               XSP-=2; rom[XSP]=sysreg.byte[1]; rom[XSP+1]=sysreg.byte[0]
#define POP_SR                sysreg.byte[1]=rom[XSP]; sysreg.byte[0]=rom[XSP+1]; XSP+=2
#define RET                   PC=(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP]; XSP+=4
#define JP_16                 PC=PC+3+( (short) (rom[PC+2]<<8)+rom[PC+1])
#define JP_24                 PC=(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]


#define CALL_24               JmpPC=(rom[PC+3]<<16)+(rom[PC+2]<<8)+rom[PC+1]; XSP-=4; TO4X8=PC+4; rom[XSP]=_b0; rom[XSP+1]=_b1; rom[XSP+2]=_b2; rom[XSP+3]=0x00; PC=JmpPC
#define CALR_16               JmpPC=PC+3+(short) ((rom[PC+2]<<8)+rom[PC+1]);  XSP-=4; TO4X8=PC+3; rom[XSP]=_b0; rom[XSP+1]=_b1; rom[XSP+2]=_b2; rom[XSP+3]=0x00; PC=JmpPC

#define LD_MEM_B8(dst,src)              rom[dst]=src
#define LD_MEM_B16(dst,src_hi,src_lo)   rom[dst]=src_lo; rom[dst+1]=src_hi
                


#define LD_R16_MEMr32d8(dst,src)   dst=(rom[src+1]<<8)+rom[src]
#define LD_MEMr32d8_R16(dst,src)   TO4X8=src; rom[dst]=_b0; rom[dst+1]=_b1

#define LD_R32_MEMr32d8(dst,src)   dst=(rom[src+3]<<24)+(rom[src+2]<<16)+(rom[src+1]<<8)+rom[src]
#define LD_MEMr32d8_R32(dst,src)   TO4X8=src; rom[dst]=_b0; rom[dst+1]=_b1; rom[dst+2]=_b2; rom[dst+3]=_b3

                            


#define PUSH_W(r16)    XSP-=2; _16lo=r16; rom[XSP]=_b0; rom[XSP+1]=_b1
#define POP_W(r16)     r16=+(rom[XSP+1]<<8)+rom[XSP]; XSP+=2

#define PUSH_L(r32)    XSP-=4; TO4X8=r32; \
		       rom[XSP]=_b0; rom[XSP+1]=_b1; \
                   rom[XSP+2]=_b2; rom[XSP+3]=_b3 \

#define POP_L(r32)     r32=(rom[XSP+3]<<24)+(rom[XSP+2]<<16)+(rom[XSP+1]<<8)+rom[XSP]; XSP+=4
            







ulong  *r32p[8] = { 0,0,0,0,0,0,0,0 };
uint   *r16p[8] = { 0,0,0,0,0,0,0,0 };
uchar   *r8p[8] = { 0,0,0,0,0,0,0,0 };


#define UPDATE_REGBANK \
    xr32[0x34]=&Reg_XWA[rb-1].DWord; xr32[0x35]=&Reg_XBC[rb-1].DWord; \
    xr32[0x36]=&Reg_XDE[rb-1].DWord; xr32[0x37]=&Reg_XHL[rb-1].DWord; \
    xr32[0x38]=&Reg_XWA[rb].DWord; xr32[0x39]=&Reg_XBC[rb].DWord; \
    xr32[0x3A]=&Reg_XDE[rb].DWord; xr32[0x3B]=&Reg_XHL[rb].DWord; \
    xr16[0x68]=&Reg_XWA[rb-1].w[0]; xr16[0x69]=&Reg_XWA[rb-1].w[1]; \
    xr16[0x6A]=&Reg_XBC[rb-1].w[0]; xr16[0x6B]=&Reg_XBC[rb-1].w[1]; \
    xr16[0x6C]=&Reg_XDE[rb-1].w[0]; xr16[0x6D]=&Reg_XDE[rb-1].w[1]; \
    xr16[0x6E]=&Reg_XHL[rb-1].w[0]; xr16[0x6F]=&Reg_XHL[rb-1].w[1]; \
    xr16[0x70]=&Reg_XWA[rb].w[0]; xr16[0x71]=&Reg_XWA[rb].w[1]; \
    xr16[0x72]=&Reg_XBC[rb].w[0]; xr16[0x73]=&Reg_XBC[rb].w[1]; \
    xr16[0x74]=&Reg_XDE[rb].w[0]; xr16[0x75]=&Reg_XDE[rb].w[1]; \
    xr16[0x76]=&Reg_XHL[rb].w[0]; xr16[0x77]=&Reg_XHL[rb].w[1]; \
    xr8[0xD0]=&Reg_XWA[rb-1].b[0]; \
    xr8[0xD1]=&Reg_XWA[rb-1].b[1]; \
    xr8[0xD2]=&Reg_XWA[rb-1].b[2]; \
    xr8[0xD3]=&Reg_XWA[rb-1].b[3]; \
    xr8[0xD4]=&Reg_XBC[rb-1].b[0]; \
    xr8[0xD5]=&Reg_XBC[rb-1].b[1]; \
    xr8[0xD6]=&Reg_XBC[rb-1].b[2]; \
    xr8[0xD7]=&Reg_XBC[rb-1].b[3]; \
    xr8[0xD8]=&Reg_XDE[rb-1].b[0]; \
    xr8[0xD9]=&Reg_XDE[rb-1].b[1]; \
    xr8[0xDA]=&Reg_XDE[rb-1].b[2]; \
    xr8[0xDB]=&Reg_XDE[rb-1].b[3]; \
    xr8[0xDC]=&Reg_XHL[rb-1].b[0]; \
    xr8[0xDD]=&Reg_XHL[rb-1].b[1]; \
    xr8[0xDE]=&Reg_XHL[rb-1].b[2]; \
    xr8[0xDF]=&Reg_XHL[rb-1].b[3]; \
    xr8[0xE0]=&Reg_XWA[rb].b[0]; \
    xr8[0xE1]=&Reg_XWA[rb].b[1]; \
    xr8[0xE2]=&Reg_XWA[rb].b[2]; \
    xr8[0xE3]=&Reg_XWA[rb].b[3]; \
    xr8[0xE4]=&Reg_XBC[rb].b[0]; \
    xr8[0xE5]=&Reg_XBC[rb].b[1]; \
    xr8[0xE6]=&Reg_XBC[rb].b[2]; \
    xr8[0xE7]=&Reg_XBC[rb].b[3]; \
    xr8[0xE8]=&Reg_XDE[rb].b[0]; \
    xr8[0xE9]=&Reg_XDE[rb].b[1]; \
    xr8[0xEA]=&Reg_XDE[rb].b[2]; \
    xr8[0xEB]=&Reg_XDE[rb].b[3]; \
    xr8[0xEC]=&Reg_XHL[rb].b[0]; \
    xr8[0xED]=&Reg_XHL[rb].b[1]; \
    xr8[0xEE]=&Reg_XHL[rb].b[2]; \
    xr8[0xEF]=&Reg_XHL[rb].b[3]; \
    r32p[0]=&XWA; r32p[1]=&XBC; \
    r32p[2]=&XDE; r32p[3]=&XHL; \
    r32p[4]=&XIX; r32p[5]=&XIY; \
    r32p[6]=&XIZ; r32p[7]=&XSP; \
    r16p[0]=&WA; r16p[1]=&BC; \
    r16p[2]=&DE; r16p[3]=&HL; \
    r16p[4]=&IX; r16p[5]=&IY; \
    r16p[6]=&IZ; r16p[7]=&SP; \
    r8p[0]=&W; r8p[1]=&A; \
    r8p[2]=&B; r8p[3]=&C; \
    r8p[4]=&D; r8p[5]=&E; \
    r8p[6]=&H; r8p[7]=&L; \




/* INSTRUCTION ENCODINGS */

typedef union {
        struct {
                unsigned lo   : 4;
                unsigned type : 2;
                unsigned hi   : 1;
                unsigned      : 1;  //=1
        } MemoryAdressing;

        struct {
                unsigned reg  : 3;
                unsigned type : 1;  //=1
                unsigned size : 2;
                unsigned      : 2;  //=11
        } RegisterAdressing;

        struct {
                unsigned id    : 2;
                unsigned reg32 : 6;
        } RegisterAdressing32;  //-1--0011 2:nd byte encoding

        uchar op;
} InstrEnc;

InstrEnc OpcodeClass;
InstrEnc OpcodeClass2;


#define madr      OpcodeClass.MemoryAdressing   /* (mem) encoding */
#define radr      OpcodeClass.RegisterAdressing /* reg encoding */
#define regsize   OpcodeClass.RegisterAdressing.size
#define regtype   OpcodeClass.RegisterAdressing.type
#define opcode    OpcodeClass.op
#define r32enc    OpcodeClass2.op
#define r32id     OpcodeClass2.RegisterAdressing32.id
#define r32reg    OpcodeClass2.RegisterAdressing32.reg32



/* pointer to real offset of (mem) instructions */
ulong *memadr;



div_t   divtmp;



uchar  fTmp8;
short  fTmp16;
ulong  fTmp32;


#define CARRY8(reg)        fC=(((reg)&0x100)==0x100)
#define SIGN8(reg)         fS=(((reg)&0x080)==0x080)
#define OVERFLOW8(reg)     fV=(((reg)&0x080)==0x080)

#define CARRY16(reg)       fC=(((reg)&0x10000)==0x10000)
#define SIGN16(reg)        fS=(((reg)&0x08000)==0x08000)
#define OVERFLOW16(reg)    fV=(((reg)&0x08000)==0x08000)

#define CARRY32(reg)       fC=(((reg)&0x100000000)==0x100000000)
#define SIGN32(reg)        fS=(((reg)&0x080000000)==0x080000000)
#define OVERFLOW32(reg)    fV=(((reg)&0x080000000)==0x080000000)

#define HCARRY(r)          fH=(((r)&0x10)==0x10)
#define ZERO(reg)          fZ=(!reg)




//#define ROL(c,b) ((c) << (b) | (c) >> (8-(b)))
//#define ROR(c,b) ((c) >> (b) | (c) << (8-(b)))
#define RBIT(c,b) ((char) (c >> (1+b)) << (1+b)) | ((char) (c << (8-b)) >> (8-b))
#define SBIT(c,b,b2) (((char) (c << (8-b))) >> (8-b)) | (((char) (c >> (1+b))) << (1+b)) | b2
//#define SWAP(c) ((char) c >> 4) | ((char) c << 4)







#define ADC_B(r1,r2) \
    HCARRY(r1+r2+fC); OVERFLOW8(r1+r2+fC); CARRY8(r1+r2+fC); r1=r1+r2+fC; SIGN8(r1); ZERO(r1); fN=0 \

#define ADD_B(r1,r2) \
    HCARRY(r1+r2); OVERFLOW8(r1+r2); CARRY8(r1+r2); r1=r1+r2; SIGN8(r1); ZERO(r1); fN=0 \

#define AND_B(r1,r2) \
    r1=(r1) & (r2); SIGN8(r1); ZERO(r1); fH=1; fN=0; fC=0 \
    //V unemulated

#define CP_B(r1,r2)   \
    fTmp8=r1-r2; SIGN8(fTmp8); ZERO(fTmp8); HCARRY(fTmp8); OVERFLOW8(fTmp8); fN=1; CARRY8(fTmp8); \

#define DEC_B(r1,adj) \
    SIGN8(r1+adj); ZERO(r1+adj); HCARRY(r1+adj); OVERFLOW8(r1+adj); fN=1; r1=r1+adj \

#define INC_B(r1,adj) \
    SIGN8(r1+adj); ZERO(r1+adj); HCARRY(r1+adj); OVERFLOW8(r1+adj); fN=0; r1=r1+adj \

#define OR_B(r1,r2) \
    r1=(r1)|(r2); SIGN8(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated

#define SBC_B(r1,r2) \
    HCARRY(r1-r2-fC); OVERFLOW8(r1-r2-fC); CARRY8(r1-r2-fC); r1=r1-r2-fC; SIGN8(r1); ZERO(r1); fN=1 \
    //V unemulated

#define SUB_B(r1,r2) \
    HCARRY(r1-r2); OVERFLOW8(r1-r2); CARRY8(r1-r2); r1-=r2; SIGN8(r1); ZERO(r1); fN=1 \
    //V unemulated

#define XOR_B(r1,r2) \
    r1=(r1)^(r2); SIGN8(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated




#define ADC_W(r1,r2) \
    HCARRY(r1+r2+fC); OVERFLOW16(r1+r2+fC); CARRY16(r1+r2+fC); r1=r1+r2+fC; SIGN16(r1); ZERO(r1); fN=0 \

#define ADD_W(r1,r2) \
    HCARRY(r1+r2); OVERFLOW16(r1+r2); CARRY16(r1+r2); r1=r1+r2; SIGN16(r1); ZERO(r1); fN=0 \

#define AND_W(r1,r2) \
    r1=(r1) & (r2); SIGN16(r1); ZERO(r1); fH=1; fN=0; fC=0 \
    //V unemulated

#define CP_W(r1,r2) \
    fTmp16=r1-r2; SIGN16(fTmp16); ZERO(fTmp16); HCARRY(fTmp16); OVERFLOW16(fTmp16); fN=1; CARRY16(fTmp16); \

#define DEC_W(r1,adj) \
    SIGN16(r1+adj); ZERO(r1+adj); HCARRY(r1+adj); OVERFLOW16(r1+adj); fN=1; r1=r1+adj \

#define INC_W(r1,adj) \
    SIGN16(r1+adj); ZERO(r1+adj); HCARRY(r1+adj); OVERFLOW16(r1+adj); fN=0; r1=r1+adj \

#define OR_W(r1,r2) \
    r1=(r1)|(r2); SIGN16(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated

#define SBC_W(r1,r2) \
    HCARRY(r1-r2-fC); OVERFLOW16(r1-r2-fC); CARRY16(r1-r2-fC); r1=r1-r2-fC; SIGN16(r1); ZERO(r1); fN=1 \
    //V unemulated

#define SUB_W(r1,r2) \
    HCARRY(r1-r2); OVERFLOW16(r1-r2); CARRY16(r1-r2); r1-=r2; SIGN16(r1); ZERO(r1); fN=1 \
    //V unemulated

#define XOR_W(r1,r2) \
    r1=(r1)^(r2); SIGN16(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated




#define ADC_L(r1,r2) \
    OVERFLOW32(r1+r2+fC); CARRY32(r1+r2+fC); r1=r1+r2+fC; SIGN32(r1); ZERO(r1); fN=0 \

#define ADD_L(r1,r2) \
    OVERFLOW32(r1+r2); CARRY32(r1+r2); r1=r1+r2; SIGN32(r1); ZERO(r1); fN=0 \

#define AND_L(r1,r2) \
    r1=(r1) & (r2); SIGN32(r1); ZERO(r1); fH=1; fN=0; fC=0 \
    //V unemulated

#define CP_L(r1,r2) \
    fTmp32=r1-r2; SIGN32(fTmp32); ZERO(fTmp32); OVERFLOW32(fTmp32); fN=1; CARRY32(fTmp32); \

#define DEC_L(r1,adj) \
    SIGN32(r1+adj); ZERO(r1+adj); OVERFLOW32(r1+adj); fN=1; r1=r1+adj \

#define INC_L(r1,adj) \
    SIGN32(r1+adj); ZERO(r1+adj); OVERFLOW32(r1+adj); fN=0; r1=r1+adj \

#define OR_L(r1,r2) \
    r1=(r1)|(r2); SIGN32(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated

#define SBC_L(r1,r2) \
    OVERFLOW32(r1-r2-fC); CARRY32(r1-r2-fC); r1=r1-r2-fC; SIGN32(r1); ZERO(r1); fN=1 \
    //V unemulated

#define SUB_L(r1,r2) \
    OVERFLOW32(r1-r2); CARRY32(r1-r2); r1-=r2; SIGN32(r1); ZERO(r1); fN=1 \
    //V unemulated
 
#define XOR_L(r1,r2) \
    r1=(r1)^(r2); SIGN32(r1); ZERO(r1); fH=0; fN=0; fC=0 \
    //V unemulated






#define LD_R16_MEM(dst,src)   dst=(rom[src+1]<<8)+rom[src]
#define LD_R32_MEM(dst,src)   dst=(rom[src+3]<<24)+(rom[src+2]<<16)+(rom[src+1]<<8)+rom[src]


#define LD_MEM_R32(dst,src)   TO4X8=src; rom[dst]=_b0; rom[dst+1]=_b1; rom[dst+2]=_b2; rom[dst+3]=_b3
#define LD_MEM_R16(dst,src)   TO4X8=src; rom[dst]=_b0; rom[dst+1]=_b1





#define BIT_MEM(mem,bit) \
    if (rom[mem]&bit) fZ=0; else fZ=1; \
    fH=1; fN=0; \



















#define WRITE_L(ofs,data) TO4X8=data; rom[ofs]=_b0; rom[ofs+1]=_b1; rom[ofs+2]=_b2; rom[ofs+3]=_b3
