/* d900h.c */

void dis900h(char *msg) {

    char    tmpadj=0;

    uint    OpTmp16=0,OpTmp16b=0,OpTmp16c=0;
    uchar   OpTmp8=0;
    ulong   OpTmp24=0,OpTmp24b=0;
    ulong   OpTmp32=0,OpTmp32b=0,OpTmp32c=0;



    uint         dTmp16=0,dTmp16b=0;
    ulong        dTmp24=0;
    signed int   dTmp16s=0;


    signed char OpTmp8s=0;


    opcode = rom[dPC];

    OpTmp16  = (rom[dPC+3]<<8)+rom[dPC+2];
    OpTmp16b = (rom[dPC+4]<<8)+rom[dPC+3];
    OpTmp16c = (rom[dPC+2]<<8)+rom[dPC+1];

    OpTmp24  = (rom[dPC+4]<<16)+(rom[dPC+3]<<8)+rom[dPC+2];
    OpTmp24b = (rom[dPC+3]<<16)+(rom[dPC+2]<<8)+rom[dPC+1];

    OpTmp32   = (rom[dPC+4]<<24)+(rom[dPC+3]<<16)+(rom[dPC+2]<<8)+rom[dPC+1];
    OpTmp32b  = (rom[dPC+5]<<24)+(rom[dPC+4]<<16)+(rom[dPC+3]<<8)+rom[dPC+2];
    OpTmp32c  = (rom[dPC+6]<<24)+(rom[dPC+5]<<16)+(rom[dPC+4]<<8)+rom[dPC+3];
    OpTmp8    = rom[dPC+1];

    OpTmp8s   = rom[dPC+1];
    dTmp16s  = (rom[dPC+2]<<8)+rom[dPC+1];

    dPCl=0; dPCh=1;

    sprintf(memadrt," ");


    if ((opcode<0x80) || (opcode>=0xF7)) {
    	switch (opcode) {
            case 0x00: sprintf(msg,"NOP"); dPCl=1; break;

            case 0x02: sprintf(msg,"PUSH   SR"); dPCl=1; break;
            case 0x03: sprintf(msg,"POP    SR"); dPCl=1; break;

    	    case 0x05: sprintf(msg,"HALT   ;*"); dPCl=1; break;
            case 0x06: if (rom[dPC+1]>=8) sprintf(msg,"DB     %02Xh,%02Xh",rom[dPC],rom[dPC+1]); else sprintf(msg,"EI     #%d",rom[dPC+1]); dPCl=2; break;
            case 0x07: sprintf(msg,"RETI   ;*"); dPCl=1; break;
            case 0x08: sprintf(msg,"LD     (0000%02X),%02Xh",OpTmp8,rom[dPC+2]); dPCl=3; break;
            case 0x09: sprintf(msg,"PUSH   %02Xh",rom[dPC+1]); dPCl=2; break;
            case 0x0A: sprintf(msg,"LD     (0000%02X),%04Xh",OpTmp8,OpTmp16); dPCl=4; break;
            case 0x0B: sprintf(msg,"PUSH   %04Xh",OpTmp16c); dPCl=3; break;
            case 0x0C: sprintf(msg,"INCF"); dPCl=1; break;
            case 0x0D: sprintf(msg,"DECF"); dPCl=1; break;
            case 0x0E: sprintf(msg,"RET"); dPCl=1; break;
            //0x0F = RETD 16bit
            case 0x10: sprintf(msg,"RCF"); dPCl=1; break;
            case 0x11: sprintf(msg,"SCF"); dPCl=1; break;
            case 0x12: sprintf(msg,"CCF"); dPCl=1; break;
            case 0x13: sprintf(msg,"ZCF"); dPCl=1; break;
            case 0x14: sprintf(msg,"PUSH   A"); dPCl=1; break;
            case 0x15: sprintf(msg,"POP    A"); dPCl=1; break;
            case 0x16: sprintf(msg,"EX     F,F'"); dPCl=1; break;
            case 0x17: sprintf(msg,"LDF    %d",OpTmp8); dPCl=2; break;
            case 0x18: sprintf(msg,"PUSH   F"); dPCl=1; break;
            case 0x19: sprintf(msg,"POP    F"); dPCl=1; break;
            case 0x1A: sprintf(msg,"JP     %06lX",dPC+3+(short) OpTmp16c); dPCl=3; break;
            case 0x1B: sprintf(msg,"JP     %06lX",OpTmp24b); dPCl=4; break;
            //0x1C = CALL 16bit
            case 0x1D: sprintf(msg,"CALL   %06lX",OpTmp24b); dPCl=4; break;
            case 0x1E: sprintf(msg,"CALR   %06lX",dPC+3+(short) OpTmp16c); dPCl=3; break;

            case 0x20: sprintf(msg,"LD     W,%02Xh",OpTmp8); dPCl=2; break;
            case 0x21: sprintf(msg,"LD     A,%02Xh",OpTmp8); dPCl=2; break;
            case 0x22: sprintf(msg,"LD     B,%02Xh",OpTmp8); dPCl=2; break;
            case 0x23: sprintf(msg,"LD     C,%02Xh",OpTmp8); dPCl=2; break;
            case 0x24: sprintf(msg,"LD     D,%02Xh",OpTmp8); dPCl=2; break;
            case 0x25: sprintf(msg,"LD     E,%02Xh",OpTmp8); dPCl=2; break;
            case 0x26: sprintf(msg,"LD     H,%02Xh",OpTmp8); dPCl=2; break;
            case 0x27: sprintf(msg,"LD     L,%02Xh",OpTmp8); dPCl=2; break;
            case 0x28: sprintf(msg,"PUSH   WA"); dPCl=1; break;
            case 0x29: sprintf(msg,"PUSH   BC"); dPCl=1; break;
            case 0x2A: sprintf(msg,"PUSH   DE"); dPCl=1; break;
            case 0x2B: sprintf(msg,"PUSH   HL"); dPCl=1; break;
            case 0x2C: sprintf(msg,"PUSH   IX"); dPCl=1; break;
            case 0x2D: sprintf(msg,"PUSH   IY"); dPCl=1; break;
            case 0x2E: sprintf(msg,"PUSH   IZ"); dPCl=1; break;
            case 0x2F: sprintf(msg,"PUSH   SP"); dPCl=1; break;
            case 0x30: sprintf(msg,"LD     WA,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x31: sprintf(msg,"LD     BC,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x32: sprintf(msg,"LD     DE,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x33: sprintf(msg,"LD     HL,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x34: sprintf(msg,"LD     IX,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x35: sprintf(msg,"LD     IY,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x36: sprintf(msg,"LD     IZ,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x37: sprintf(msg,"LD     SP,%04Xh",OpTmp16c); dPCl=3; break;
            case 0x38: sprintf(msg,"PUSH   XWA"); dPCl=1; break;
            case 0x39: sprintf(msg,"PUSH   XBC"); dPCl=1; break;
            case 0x3A: sprintf(msg,"PUSH   XDE"); dPCl=1; break;
            case 0x3B: sprintf(msg,"PUSH   XHL"); dPCl=1; break;
            case 0x3C: sprintf(msg,"PUSH   XIX"); dPCl=1; break;
            case 0x3D: sprintf(msg,"PUSH   XIY"); dPCl=1; break;
            case 0x3E: sprintf(msg,"PUSH   XIZ"); dPCl=1; break;
            case 0x3F: sprintf(msg,"PUSH   XSP"); dPCl=1; break;
            case 0x40: sprintf(msg,"LD     XWA,%08lXh",OpTmp32); dPCl=5; break;
            case 0x41: sprintf(msg,"LD     XBC,%08lXh",OpTmp32); dPCl=5; break;
            case 0x42: sprintf(msg,"LD     XDE,%08lXh",OpTmp32); dPCl=5; break;
            case 0x43: sprintf(msg,"LD     XHL,%08lXh",OpTmp32); dPCl=5; break;
            case 0x44: sprintf(msg,"LD     XIX,%08lXh",OpTmp32); dPCl=5; break;
            case 0x45: sprintf(msg,"LD     XIY,%08lXh",OpTmp32); dPCl=5; break;
            case 0x46: sprintf(msg,"LD     XIZ,%08lXh",OpTmp32); dPCl=5; break;
            case 0x47: sprintf(msg,"LD     XSP,%08lXh",OpTmp32); dPCl=5; break;
            case 0x48: sprintf(msg,"POP    WA"); dPCl=1; break;
            case 0x49: sprintf(msg,"POP    BC"); dPCl=1; break;
            case 0x4A: sprintf(msg,"POP    DE"); dPCl=1; break;
            case 0x4B: sprintf(msg,"POP    HL"); dPCl=1; break;
            case 0x4C: sprintf(msg,"POP    IX"); dPCl=1; break;
            case 0x4D: sprintf(msg,"POP    IY"); dPCl=1; break;
            case 0x4E: sprintf(msg,"POP    IZ"); dPCl=1; break;
            case 0x4F: sprintf(msg,"POP    SP"); dPCl=1; break;

            case 0x58: sprintf(msg,"POP    XWA"); dPCl=1; break;
            case 0x59: sprintf(msg,"POP    XBC"); dPCl=1; break;
            case 0x5A: sprintf(msg,"POP    XDE"); dPCl=1; break;
            case 0x5B: sprintf(msg,"POP    XHL"); dPCl=1; break;
            case 0x5C: sprintf(msg,"POP    XIX"); dPCl=1; break;
            case 0x5D: sprintf(msg,"POP    XIY"); dPCl=1; break;
            case 0x5E: sprintf(msg,"POP    XIZ"); dPCl=1; break;
            case 0x5F: sprintf(msg,"POP    XSP"); dPCl=1; break;
            case 0x60: sprintf(msg,"JR     f,%06lX",  dPC+2+OpTmp8s); dPCl=2; break;
            case 0x61: sprintf(msg,"JR     lt,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x62: sprintf(msg,"JR     le,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x63: sprintf(msg,"JR     ule,%06lX",dPC+2+OpTmp8s); dPCl=2; break;
            case 0x64: sprintf(msg,"JR     ov,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x65: sprintf(msg,"JR     mi,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x66: sprintf(msg,"JR     z,%06lX",  dPC+2+OpTmp8s); dPCl=2; break;
            case 0x67: sprintf(msg,"JR     c,%06lX",  dPC+2+OpTmp8s); dPCl=2; break;
            case 0x68: sprintf(msg,"JR     %06lX",    dPC+2+OpTmp8s); dPCl=2; break;
            case 0x69: sprintf(msg,"JR     ge,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6A: sprintf(msg,"JR     gt,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6B: sprintf(msg,"JR     ugt,%06lX",dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6C: sprintf(msg,"JR     nov,%06lX",dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6D: sprintf(msg,"JR     pl,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6E: sprintf(msg,"JR     nz,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x6F: sprintf(msg,"JR     nc,%06lX", dPC+2+OpTmp8s); dPCl=2; break;
            case 0x70: sprintf(msg,"JRL    f,%06lX",  dPC+3+dTmp16s); dPCl=3; break;
            case 0x71: sprintf(msg,"JRL    lt,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x72: sprintf(msg,"JRL    le,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x73: sprintf(msg,"JRL    ule,%06lX",dPC+3+dTmp16s); dPCl=3; break;
            case 0x74: sprintf(msg,"JRL    ov,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x75: sprintf(msg,"JRL    mi,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x76: sprintf(msg,"JRL    z,%06lX",  dPC+3+dTmp16s); dPCl=3; break;
            case 0x77: sprintf(msg,"JRL    c,%06lX",  dPC+3+dTmp16s); dPCl=3; break;
            case 0x78: sprintf(msg,"JRL    %06lX",    dPC+3+dTmp16s); dPCl=3; break;
            case 0x79: sprintf(msg,"JRL    ge,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x7A: sprintf(msg,"JRL    gt,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x7B: sprintf(msg,"JRL    ugt,%06lX",dPC+3+dTmp16s); dPCl=3; break;
            case 0x7C: sprintf(msg,"JRL    nov,%06lX",dPC+3+dTmp16s); dPCl=3; break;
            case 0x7D: sprintf(msg,"JRL    pl,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x7E: sprintf(msg,"JRL    nz,%06lX", dPC+3+dTmp16s); dPCl=3; break;
            case 0x7F: sprintf(msg,"JRL    nc,%06lX", dPC+3+dTmp16s); dPCl=3; break;

            //0xF7 = LDX (n),n
            case 0xF8: sprintf(msg,"SWI    0 ;*"); dPCl=1; break;
            case 0xF9: sprintf(msg,"SWI    1 ;*"); dPCl=1; break;
            case 0xFA: sprintf(msg,"SWI    2 ;*"); dPCl=1; break;
            case 0xFB: sprintf(msg,"SWI    3 ;*"); dPCl=1; break;
            case 0xFC: sprintf(msg,"SWI    4 ;*"); dPCl=1; break;
            case 0xFD: sprintf(msg,"SWI    5 ;*"); dPCl=1; break;
            case 0xFE: sprintf(msg,"SWI    6 ;*"); dPCl=1; break;
            case 0xFF: sprintf(msg,"SWI    7 ;*"); dPCl=1; break;

            default:   sprintf(msg,"disasm missing: %02Xh",opcode);
	}
    } /* if ((opcode<0x80) || (opcode>=0xF7)) */
    
    else if ( !((madr.hi==1) && (madr.lo>=0x7)) ) { /* if NOT register instructions */
	    
	/* Extracts (mem) info and then continues with processing the instruction */
	if (madr.hi==0) {
	    switch (madr.lo) {
            case 0x0: /* (XWA) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x1: /* (XBC) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x2: /* (XDE) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x3: /* (XHL) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x4: /* (XIX) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x5: /* (XIY) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x6: /* (XIZ) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x7: /* (XSP) */    sprintf(memadrd,"%s",memn[madr.lo]); sprintf(memadrtb,"(r32)"); dPC++; break;
            case 0x8: /* (XWA+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)"); dPC+=2; break;
            case 0x9: /* (XBC+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xA: /* (XDE+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xB: /* (XHL+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xC: /* (XIX+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xD: /* (XIY+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xE: /* (XIZ+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
            case 0xF: /* (XSP+d8) */ sprintf(memadrd,"%s+%02Xh",memn[madr.lo],rom[dPC+1]); sprintf(memadrtb,"(r32+d8)");  dPC+=2; break;
	    }		
	} else { /* madr.hi==1 */
        dTmp16 =(rom[dPC+2]<<8)+rom[dPC+1];
        dTmp16b=(rom[dPC+3]<<8)+rom[dPC+2];
        dTmp16s=(rom[dPC+3]<<8)+rom[dPC+2];
        dTmp24 =(rom[dPC+3]<<16)+(rom[dPC+2]<<8)+rom[dPC+1];
        r32enc = rom[dPC+1];      
	    switch (madr.lo) {
            case 0x0: /*  (#8) */ sprintf(memadrd,"0000%02X",rom[dPC+1]); sprintf(memadrtb,"(#8)");  dPC+=2; break;
            case 0x1: /* (#16) */ sprintf(memadrd,"00%04X",dTmp16);      sprintf(memadrtb,"(#16)"); dPC+=3; break;
            case 0x2: /* (#24) */ sprintf(memadrd,"%06lX",dTmp24);       sprintf(memadrtb,"(#24)"); dPC+=4; break;
            case 0x3: /* Multiple encodings */
                switch (r32id) {
                    case 0: /* (r32') */    sprintf(memadrd,"%s",xr32n[r32reg]); sprintf(memadrtb,"(r32')"); dPC+=2; break;
                    case 1: /* (r32+d16) */
                        /* %+04X is not allowed by gcc for some *braindead* reason!! */
                        if (dTmp16s>=0x8000)
                            sprintf(memadrd,"%s-%04Xh",xr32n[r32reg],0x10000-dTmp16b );
                        else
                            sprintf(memadrd,"%s+%04Xh",xr32n[r32reg],dTmp16b);

                        sprintf(memadrtb,"(r32+d16)");
                        dPC+=4; break;


                    case 3:
                        switch(r32reg) {
                            case 0: /* (r32+r8)  */ sprintf(memadrd,"%s+%s",xr32n[rom[dPC+2]/4],xr8n[rom[dPC+3]]); sprintf(memadrtb,"(r32+r8)");  dPC+=4; break;
                            case 1: /* (r32+r16) */ sprintf(memadrd,"%s+%s",xr32n[rom[dPC+2]/4],xr16n[rom[dPC+3]/2]); sprintf(memadrtb,"(r32+r16)"); dPC+=4; break;
                        }
                    } break;
		    
            case 0x4: /* (-r32) */
                if (r32id==0) tmpadj=1;
                if (r32id==1) tmpadj=2;
                if (r32id==2) tmpadj=4;
                if (r32id==3) { sprintf(msg,"invalid r32id (-r32)"); return; }
                sprintf(memadrtb,"(-r32)");
                sprintf(memadrd,"%s--%d",xr32n[r32reg],tmpadj); dPC+=2; break;
		    
            case 0x5: /* (r32+) */
                if (r32id==0) tmpadj=1;
                if (r32id==1) tmpadj=2;
                if (r32id==2) tmpadj=4;         
                if (r32id==3) { sprintf(msg,"invalid r32id (r32+)"); return; }
                sprintf(memadrtb,"(r32+)");
                sprintf(memadrd,"%s++%d",xr32n[r32reg],tmpadj); dPC+=2; break;
	    }	    
	}
	
    switch (madr.type) {
        case 0: /* src.B */
            sprintf(memadrt,"src.B %s",memadrtb);
		
	        OpTmp16 = (rom[dPC+2]<<8)+rom[dPC+1];
    		switch (rom[dPC]) {
                case 0x04: sprintf(msg,"PUSHB   (%s) ;*",memadrd); dPCl=1; break;
		    
        	    case 0x10:
            		switch (opcode) {
                        case 0x83: sprintf(msg,"LDIB   (XDE+),(XHL+)"); break;
                        case 0x85: sprintf(msg,"LDIB   (XIX+),(XIY+)"); break;
                        default:   sprintf(msg,"invalid src.B %s",memadrtb); 
            		} dPCl=1; break;

                case 0x11:
            		switch (opcode) {
                        case 0x83: sprintf(msg,"LDIRB  (XDE+),(XHL+)"); break;
                        case 0x85: sprintf(msg,"LDIRB  (XIX+),(XIY+)"); break;
                        default:   sprintf(msg,"invalid src.B %s",memadrtb);
                    } dPCl=1; break;

                    case 0x19: sprintf(msg,"LDB    (00%04X),(%s)",OpTmp16,memadrd); dPCl=3; break;

                    case 0x20: sprintf(msg,"LD     W,(%s)",memadrd); dPCl=1; break;
                    case 0x21: sprintf(msg,"LD     A,(%s)",memadrd); dPCl=1; break;
                    case 0x22: sprintf(msg,"LD     B,(%s)",memadrd); dPCl=1; break;
                    case 0x23: sprintf(msg,"LD     C,(%s)",memadrd); dPCl=1; break;
                    case 0x24: sprintf(msg,"LD     D,(%s)",memadrd); dPCl=1; break;
                    case 0x25: sprintf(msg,"LD     E,(%s)",memadrd); dPCl=1; break;
                    case 0x26: sprintf(msg,"LD     H,(%s)",memadrd); dPCl=1; break;
                    case 0x27: sprintf(msg,"LD     L,(%s)",memadrd); dPCl=1; break;

                    case 0x30: sprintf(msg,"EX     (%s),W ;*",memadrd); dPCl=1; break;
                    case 0x31: sprintf(msg,"EX     (%s),A ;*",memadrd); dPCl=1; break;
                    case 0x32: sprintf(msg,"EX     (%s),B ;*",memadrd); dPCl=1; break;
                    case 0x33: sprintf(msg,"EX     (%s),C ;*",memadrd); dPCl=1; break;
                    case 0x34: sprintf(msg,"EX     (%s),D ;*",memadrd); dPCl=1; break;
                    case 0x35: sprintf(msg,"EX     (%s),E ;*",memadrd); dPCl=1; break;
                    case 0x36: sprintf(msg,"EX     (%s),H ;*",memadrd); dPCl=1; break;
                    case 0x37: sprintf(msg,"EX     (%s),L ;*",memadrd); dPCl=1; break;
                    case 0x38: sprintf(msg,"ADD    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x39: sprintf(msg,"ADC    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3A: sprintf(msg,"SUB    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3B: sprintf(msg,"SBC    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3C: sprintf(msg,"AND    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3D: sprintf(msg,"XOR    (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3E: sprintf(msg,"OR     (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x3F: sprintf(msg,"CP     (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;
                    case 0x40: sprintf(msg,"MUL    WA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x41: sprintf(msg,"MUL    BC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x42: sprintf(msg,"MUL    DE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x43: sprintf(msg,"MUL    HL,(%s) ;*",memadrd); dPCl=1; break;

                    case 0x48: sprintf(msg,"MULS   WA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x49: sprintf(msg,"MULS   BC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4A: sprintf(msg,"MULS   DE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4B: sprintf(msg,"MULS   HL,(%s) ;*",memadrd); dPCl=1; break;

                    case 0x50: sprintf(msg,"DIV    WA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x51: sprintf(msg,"DIV    BC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x52: sprintf(msg,"DIV    DE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x53: sprintf(msg,"DIV    HL,(%s) ;*",memadrd); dPCl=1; break;

                    case 0x58: sprintf(msg,"DIVS   WA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x59: sprintf(msg,"DIVS   BC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5A: sprintf(msg,"DIVS   DE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5B: sprintf(msg,"DIVS   HL,(%s) ;*",memadrd); dPCl=1; break;

                    case 0x60: sprintf(msg,"INCB   8,(%s)",memadrd); dPCl=1; break;
                    case 0x61: sprintf(msg,"INCB   1,(%s)",memadrd); dPCl=1; break;
                    case 0x62: sprintf(msg,"INCB   2,(%s)",memadrd); dPCl=1; break;
                    case 0x63: sprintf(msg,"INCB   3,(%s)",memadrd); dPCl=1; break;
                    case 0x64: sprintf(msg,"INCB   4,(%s)",memadrd); dPCl=1; break;
                    case 0x65: sprintf(msg,"INCB   5,(%s)",memadrd); dPCl=1; break;
                    case 0x66: sprintf(msg,"INCB   6,(%s)",memadrd); dPCl=1; break;
                    case 0x67: sprintf(msg,"INCB   7,(%s)",memadrd); dPCl=1; break;
                    case 0x68: sprintf(msg,"DECB   8,(%s)",memadrd); dPCl=1; break;
                    case 0x69: sprintf(msg,"DECB   1,(%s)",memadrd); dPCl=1; break;
                    case 0x6A: sprintf(msg,"DECB   2,(%s)",memadrd); dPCl=1; break;
                    case 0x6B: sprintf(msg,"DECB   3,(%s)",memadrd); dPCl=1; break;
                    case 0x6C: sprintf(msg,"DECB   4,(%s)",memadrd); dPCl=1; break;
                    case 0x6D: sprintf(msg,"DECB   5,(%s)",memadrd); dPCl=1; break;
                    case 0x6E: sprintf(msg,"DECB   6,(%s)",memadrd); dPCl=1; break;
                    case 0x6F: sprintf(msg,"DECB   7,(%s)",memadrd); dPCl=1; break;

                    case 0x78: sprintf(msg,"RLC    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x79: sprintf(msg,"RRC    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7A: sprintf(msg,"RL     (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7B: sprintf(msg,"RR     (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7C: sprintf(msg,"SLA    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7D: sprintf(msg,"SRA    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7E: sprintf(msg,"SLL    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7F: sprintf(msg,"SRL    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x80: sprintf(msg,"ADD    W,(%s)",memadrd); dPCl=1; break;
                    case 0x81: sprintf(msg,"ADD    A,(%s)",memadrd); dPCl=1; break;
                    case 0x82: sprintf(msg,"ADD    B,(%s)",memadrd); dPCl=1; break;
                    case 0x83: sprintf(msg,"ADD    C,(%s)",memadrd); dPCl=1; break;
                    case 0x84: sprintf(msg,"ADD    D,(%s)",memadrd); dPCl=1; break;
                    case 0x85: sprintf(msg,"ADD    E,(%s)",memadrd); dPCl=1; break;
                    case 0x86: sprintf(msg,"ADD    H,(%s)",memadrd); dPCl=1; break;
                    case 0x87: sprintf(msg,"ADD    L,(%s)",memadrd); dPCl=1; break;
                    case 0x88: sprintf(msg,"ADD    (%s),W",memadrd); dPCl=1; break;
                    case 0x89: sprintf(msg,"ADD    (%s),A",memadrd); dPCl=1; break;
                    case 0x8A: sprintf(msg,"ADD    (%s),B",memadrd); dPCl=1; break;
                    case 0x8B: sprintf(msg,"ADD    (%s),C",memadrd); dPCl=1; break;
                    case 0x8C: sprintf(msg,"ADD    (%s),D",memadrd); dPCl=1; break;
                    case 0x8D: sprintf(msg,"ADD    (%s),E",memadrd); dPCl=1; break;
                    case 0x8E: sprintf(msg,"ADD    (%s),H",memadrd); dPCl=1; break;
                    case 0x8F: sprintf(msg,"ADD    (%s),L",memadrd); dPCl=1; break;
                    case 0x90: sprintf(msg,"ADC    W,(%s)",memadrd); dPCl=1; break;
                    case 0x91: sprintf(msg,"ADC    A,(%s)",memadrd); dPCl=1; break;
                    case 0x92: sprintf(msg,"ADC    B,(%s)",memadrd); dPCl=1; break;
                    case 0x93: sprintf(msg,"ADC    C,(%s)",memadrd); dPCl=1; break;
                    case 0x94: sprintf(msg,"ADC    D,(%s)",memadrd); dPCl=1; break;
                    case 0x95: sprintf(msg,"ADC    E,(%s)",memadrd); dPCl=1; break;
                    case 0x96: sprintf(msg,"ADC    H,(%s)",memadrd); dPCl=1; break;
                    case 0x97: sprintf(msg,"ADC    L,(%s)",memadrd); dPCl=1; break;
                    case 0x98: sprintf(msg,"ADC    (%s),W",memadrd); dPCl=1; break;
                    case 0x99: sprintf(msg,"ADC    (%s),A",memadrd); dPCl=1; break;
                    case 0x9A: sprintf(msg,"ADC    (%s),B",memadrd); dPCl=1; break;
                    case 0x9B: sprintf(msg,"ADC    (%s),C",memadrd); dPCl=1; break;
                    case 0x9C: sprintf(msg,"ADC    (%s),D",memadrd); dPCl=1; break;
                    case 0x9D: sprintf(msg,"ADC    (%s),E",memadrd); dPCl=1; break;
                    case 0x9E: sprintf(msg,"ADC    (%s),H",memadrd); dPCl=1; break;
                    case 0x9F: sprintf(msg,"ADC    (%s),L",memadrd); dPCl=1; break;
                    case 0xA0: sprintf(msg,"SUB    W,(%s)",memadrd); dPCl=1; break;
                    case 0xA1: sprintf(msg,"SUB    A,(%s)",memadrd); dPCl=1; break;
                    case 0xA2: sprintf(msg,"SUB    B,(%s)",memadrd); dPCl=1; break;
                    case 0xA3: sprintf(msg,"SUB    C,(%s)",memadrd); dPCl=1; break;
                    case 0xA4: sprintf(msg,"SUB    D,(%s)",memadrd); dPCl=1; break;
                    case 0xA5: sprintf(msg,"SUB    E,(%s)",memadrd); dPCl=1; break;
                    case 0xA6: sprintf(msg,"SUB    H,(%s)",memadrd); dPCl=1; break;
                    case 0xA7: sprintf(msg,"SUB    L,(%s)",memadrd); dPCl=1; break;
                    case 0xA8: sprintf(msg,"SUB    (%s),W",memadrd); dPCl=1; break;
                    case 0xA9: sprintf(msg,"SUB    (%s),A",memadrd); dPCl=1; break;
                    case 0xAA: sprintf(msg,"SUB    (%s),B",memadrd); dPCl=1; break;
                    case 0xAB: sprintf(msg,"SUB    (%s),C",memadrd); dPCl=1; break;
                    case 0xAC: sprintf(msg,"SUB    (%s),D",memadrd); dPCl=1; break;
                    case 0xAD: sprintf(msg,"SUB    (%s),E",memadrd); dPCl=1; break;
                    case 0xAE: sprintf(msg,"SUB    (%s),H",memadrd); dPCl=1; break;
                    case 0xAF: sprintf(msg,"SUB    (%s),L",memadrd); dPCl=1; break;
                    case 0xB0: sprintf(msg,"SBC    W,(%s)",memadrd); dPCl=1; break;
                    case 0xB1: sprintf(msg,"SBC    A,(%s)",memadrd); dPCl=1; break;
                    case 0xB2: sprintf(msg,"SBC    B,(%s)",memadrd); dPCl=1; break;
                    case 0xB3: sprintf(msg,"SBC    C,(%s)",memadrd); dPCl=1; break;
                    case 0xB4: sprintf(msg,"SBC    D,(%s)",memadrd); dPCl=1; break;
                    case 0xB5: sprintf(msg,"SBC    E,(%s)",memadrd); dPCl=1; break;
                    case 0xB6: sprintf(msg,"SBC    H,(%s)",memadrd); dPCl=1; break;
                    case 0xB7: sprintf(msg,"SBC    L,(%s)",memadrd); dPCl=1; break;
                    case 0xB8: sprintf(msg,"SBC    (%s),W",memadrd); dPCl=1; break;
                    case 0xB9: sprintf(msg,"SBC    (%s),A",memadrd); dPCl=1; break;
                    case 0xBA: sprintf(msg,"SBC    (%s),B",memadrd); dPCl=1; break;
                    case 0xBB: sprintf(msg,"SBC    (%s),C",memadrd); dPCl=1; break;
                    case 0xBC: sprintf(msg,"SBC    (%s),D",memadrd); dPCl=1; break;
                    case 0xBD: sprintf(msg,"SBC    (%s),E",memadrd); dPCl=1; break;
                    case 0xBE: sprintf(msg,"SBC    (%s),H",memadrd); dPCl=1; break;
                    case 0xBF: sprintf(msg,"SBC    (%s),L",memadrd); dPCl=1; break;
                    case 0xC0: sprintf(msg,"AND    W,(%s)",memadrd); dPCl=1; break;
                    case 0xC1: sprintf(msg,"AND    A,(%s)",memadrd); dPCl=1; break;
                    case 0xC2: sprintf(msg,"AND    B,(%s)",memadrd); dPCl=1; break;
                    case 0xC3: sprintf(msg,"AND    C,(%s)",memadrd); dPCl=1; break;
                    case 0xC4: sprintf(msg,"AND    D,(%s)",memadrd); dPCl=1; break;
                    case 0xC5: sprintf(msg,"AND    E,(%s)",memadrd); dPCl=1; break;
                    case 0xC6: sprintf(msg,"AND    H,(%s)",memadrd); dPCl=1; break;
                    case 0xC7: sprintf(msg,"AND    L,(%s)",memadrd); dPCl=1; break;
                    case 0xC8: sprintf(msg,"AND    (%s),W",memadrd); dPCl=1; break;
                    case 0xC9: sprintf(msg,"AND    (%s),A",memadrd); dPCl=1; break;
                    case 0xCA: sprintf(msg,"AND    (%s),B",memadrd); dPCl=1; break;
                    case 0xCB: sprintf(msg,"AND    (%s),C",memadrd); dPCl=1; break;
                    case 0xCC: sprintf(msg,"AND    (%s),D",memadrd); dPCl=1; break;
                    case 0xCD: sprintf(msg,"AND    (%s),E",memadrd); dPCl=1; break;
                    case 0xCE: sprintf(msg,"AND    (%s),H",memadrd); dPCl=1; break;
                    case 0xCF: sprintf(msg,"AND    (%s),L",memadrd); dPCl=1; break;
                    case 0xD0: sprintf(msg,"XOR    W,(%s)",memadrd); dPCl=1; break;
                    case 0xD1: sprintf(msg,"XOR    A,(%s)",memadrd); dPCl=1; break;
                    case 0xD2: sprintf(msg,"XOR    B,(%s)",memadrd); dPCl=1; break;
                    case 0xD3: sprintf(msg,"XOR    C,(%s)",memadrd); dPCl=1; break;
                    case 0xD4: sprintf(msg,"XOR    D,(%s)",memadrd); dPCl=1; break;
                    case 0xD5: sprintf(msg,"XOR    E,(%s)",memadrd); dPCl=1; break;
                    case 0xD6: sprintf(msg,"XOR    H,(%s)",memadrd); dPCl=1; break;
                    case 0xD7: sprintf(msg,"XOR    L,(%s)",memadrd); dPCl=1; break;
                    case 0xD8: sprintf(msg,"XOR    (%s),W",memadrd); dPCl=1; break;
                    case 0xD9: sprintf(msg,"XOR    (%s),A",memadrd); dPCl=1; break;
                    case 0xDA: sprintf(msg,"XOR    (%s),B",memadrd); dPCl=1; break;
                    case 0xDB: sprintf(msg,"XOR    (%s),C",memadrd); dPCl=1; break;
                    case 0xDC: sprintf(msg,"XOR    (%s),D",memadrd); dPCl=1; break;
                    case 0xDD: sprintf(msg,"XOR    (%s),E",memadrd); dPCl=1; break;
                    case 0xDE: sprintf(msg,"XOR    (%s),H",memadrd); dPCl=1; break;
                    case 0xDF: sprintf(msg,"XOR    (%s),L",memadrd); dPCl=1; break;
                    case 0xE0: sprintf(msg,"OR     W,(%s)",memadrd); dPCl=1; break;
                    case 0xE1: sprintf(msg,"OR     A,(%s)",memadrd); dPCl=1; break;
                    case 0xE2: sprintf(msg,"OR     B,(%s)",memadrd); dPCl=1; break;
                    case 0xE3: sprintf(msg,"OR     C,(%s)",memadrd); dPCl=1; break;
                    case 0xE4: sprintf(msg,"OR     D,(%s)",memadrd); dPCl=1; break;
                    case 0xE5: sprintf(msg,"OR     E,(%s)",memadrd); dPCl=1; break;
                    case 0xE6: sprintf(msg,"OR     H,(%s)",memadrd); dPCl=1; break;
                    case 0xE7: sprintf(msg,"OR     L,(%s)",memadrd); dPCl=1; break;
                    case 0xE8: sprintf(msg,"OR     (%s),W",memadrd); dPCl=1; break;
                    case 0xE9: sprintf(msg,"OR     (%s),A",memadrd); dPCl=1; break;
                    case 0xEA: sprintf(msg,"OR     (%s),B",memadrd); dPCl=1; break;
                    case 0xEB: sprintf(msg,"OR     (%s),C",memadrd); dPCl=1; break;
                    case 0xEC: sprintf(msg,"OR     (%s),D",memadrd); dPCl=1; break;
                    case 0xED: sprintf(msg,"OR     (%s),E",memadrd); dPCl=1; break;
                    case 0xEE: sprintf(msg,"OR     (%s),H",memadrd); dPCl=1; break;
                    case 0xEF: sprintf(msg,"OR     (%s),L",memadrd); dPCl=1; break;         
                    case 0xF0: sprintf(msg,"CP     W,(%s)",memadrd); dPCl=1; break;
                    case 0xF1: sprintf(msg,"CP     A,(%s)",memadrd); dPCl=1; break;
                    case 0xF2: sprintf(msg,"CP     B,(%s)",memadrd); dPCl=1; break;
                    case 0xF3: sprintf(msg,"CP     C,(%s)",memadrd); dPCl=1; break;
                    case 0xF4: sprintf(msg,"CP     D,(%s)",memadrd); dPCl=1; break;
                    case 0xF5: sprintf(msg,"CP     E,(%s)",memadrd); dPCl=1; break;
                    case 0xF6: sprintf(msg,"CP     H,(%s)",memadrd); dPCl=1; break;
                    case 0xF7: sprintf(msg,"CP     L,(%s)",memadrd); dPCl=1; break;
                    case 0xF8: sprintf(msg,"CP     (%s),W",memadrd); dPCl=1; break;
                    case 0xF9: sprintf(msg,"CP     (%s),A",memadrd); dPCl=1; break;
                    case 0xFA: sprintf(msg,"CP     (%s),B",memadrd); dPCl=1; break;
                    case 0xFB: sprintf(msg,"CP     (%s),C",memadrd); dPCl=1; break;
                    case 0xFC: sprintf(msg,"CP     (%s),D",memadrd); dPCl=1; break;
                    case 0xFD: sprintf(msg,"CP     (%s),E",memadrd); dPCl=1; break;
                    case 0xFE: sprintf(msg,"CP     (%s),H",memadrd); dPCl=1; break;
                    case 0xFF: sprintf(msg,"CP     (%s),L",memadrd); dPCl=1; break;

                    default:   sprintf(msg,"src.B %s: %02Xh",memadrtb,rom[dPC]); break;
        	} break;

            case 1: /* src.W */
		sprintf(memadrt,"src.W %s",memadrtb);

	        OpTmp16  = (rom[dPC+2]<<8)+rom[dPC+1];
		
                switch (rom[dPC]) {
                    case 0x04: sprintf(msg,"PUSHW  (%s) ;*",memadrd); dPCl=1; break;
	
            	    case 0x10:
                        switch (opcode) {
                            case 0x93: sprintf(msg,"LDIW   (XDE+),(XHL+) ;*"); break;
                            case 0x95: sprintf(msg,"LDIW   (XIX+),(XIY+) ;*"); break;
                    	    default:   sprintf(msg,"invalid src.W %s",memadrtb);
                        } dPCl=1; break;

                    case 0x11:
                        switch (opcode) {
                            case 0x93: sprintf(msg,"LDIRW  (XDE+),(XHL+)"); break;
                            case 0x95: sprintf(msg,"LDIRW  (XIX+),(XIY+)"); break;
                    	    default:   sprintf(msg,"invalid src.W %s",memadrtb);
                        } dPCl=1; break;

                    case 0x19: sprintf(msg,"LDW    (00%04X),(%s)",OpTmp16,memadrd); dPCl=3; break;

                    case 0x20: sprintf(msg,"LD     WA,(%s)",memadrd); dPCl=1; break;
                    case 0x21: sprintf(msg,"LD     BC,(%s)",memadrd); dPCl=1; break;
                    case 0x22: sprintf(msg,"LD     DE,(%s)",memadrd); dPCl=1; break;
                    case 0x23: sprintf(msg,"LD     HL,(%s)",memadrd); dPCl=1; break;
                    case 0x24: sprintf(msg,"LD     IX,(%s)",memadrd); dPCl=1; break;
                    case 0x25: sprintf(msg,"LD     IY,(%s)",memadrd); dPCl=1; break;
                    case 0x26: sprintf(msg,"LD     IZ,(%s)",memadrd); dPCl=1; break;
                    case 0x27: sprintf(msg,"LD     SP,(%s)",memadrd); dPCl=1; break;

                    case 0x30: sprintf(msg,"EX     (%s),WA ;*",memadrd); dPCl=1; break;
                    case 0x31: sprintf(msg,"EX     (%s),BC ;*",memadrd); dPCl=1; break;
                    case 0x32: sprintf(msg,"EX     (%s),DE ;*",memadrd); dPCl=1; break;
                    case 0x33: sprintf(msg,"EX     (%s),HL ;*",memadrd); dPCl=1; break;
                    case 0x34: sprintf(msg,"EX     (%s),IX ;*",memadrd); dPCl=1; break;
                    case 0x35: sprintf(msg,"EX     (%s),IY ;*",memadrd); dPCl=1; break;
                    case 0x36: sprintf(msg,"EX     (%s),IZ ;*",memadrd); dPCl=1; break;
                    case 0x37: sprintf(msg,"EX     (%s),SP ;*",memadrd); dPCl=1; break;
                    case 0x38: sprintf(msg,"ADD    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x39: sprintf(msg,"ADC    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3A: sprintf(msg,"SUB    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3B: sprintf(msg,"SBC    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3C: sprintf(msg,"AND    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3D: sprintf(msg,"XOR    (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3E: sprintf(msg,"OR     (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x3F: sprintf(msg,"CP     (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;
                    case 0x40: sprintf(msg,"MUL    XWA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x41: sprintf(msg,"MUL    XBC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x42: sprintf(msg,"MUL    XDE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x43: sprintf(msg,"MUL    XHL,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x44: sprintf(msg,"MUL    XIX,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x45: sprintf(msg,"MUL    XIY,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x46: sprintf(msg,"MUL    XIZ,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x47: sprintf(msg,"MUL    XSP,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x48: sprintf(msg,"MULS   XWA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x49: sprintf(msg,"MULS   XBC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4A: sprintf(msg,"MULS   XDE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4B: sprintf(msg,"MULS   XHL,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4C: sprintf(msg,"MULS   XIX,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4D: sprintf(msg,"MULS   XIY,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4E: sprintf(msg,"MULS   XIZ,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x4F: sprintf(msg,"MULS   XSP,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x50: sprintf(msg,"DIV    XWA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x51: sprintf(msg,"DIV    XBC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x52: sprintf(msg,"DIV    XDE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x53: sprintf(msg,"DIV    XHL,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x54: sprintf(msg,"DIV    XIX,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x55: sprintf(msg,"DIV    XIY,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x56: sprintf(msg,"DIV    XIZ,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x57: sprintf(msg,"DIV    XSP,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x58: sprintf(msg,"DIVS   XWA,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x59: sprintf(msg,"DIVS   XBC,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5A: sprintf(msg,"DIVS   XDE,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5B: sprintf(msg,"DIVS   XHL,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5C: sprintf(msg,"DIVS   XIX,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5D: sprintf(msg,"DIVS   XIY,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5E: sprintf(msg,"DIVS   XIZ,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x5F: sprintf(msg,"DIVS   XSP,(%s) ;*",memadrd); dPCl=1; break;
                    case 0x60: sprintf(msg,"INCW   8,(%s)",memadrd); dPCl=1; break;
                    case 0x61: sprintf(msg,"INCW   1,(%s)",memadrd); dPCl=1; break;
                    case 0x62: sprintf(msg,"INCW   2,(%s)",memadrd); dPCl=1; break;
                    case 0x63: sprintf(msg,"INCW   3,(%s)",memadrd); dPCl=1; break;
                    case 0x64: sprintf(msg,"INCW   4,(%s)",memadrd); dPCl=1; break;
                    case 0x65: sprintf(msg,"INCW   5,(%s)",memadrd); dPCl=1; break;
                    case 0x66: sprintf(msg,"INCW   6,(%s)",memadrd); dPCl=1; break;
                    case 0x67: sprintf(msg,"INCW   7,(%s)",memadrd); dPCl=1; break;
                    case 0x68: sprintf(msg,"DECW   8,(%s)",memadrd); dPCl=1; break;
                    case 0x69: sprintf(msg,"DECW   1,(%s)",memadrd); dPCl=1; break;
                    case 0x6A: sprintf(msg,"DECW   2,(%s)",memadrd); dPCl=1; break;
                    case 0x6B: sprintf(msg,"DECW   3,(%s)",memadrd); dPCl=1; break;
                    case 0x6C: sprintf(msg,"DECW   4,(%s)",memadrd); dPCl=1; break;
                    case 0x6D: sprintf(msg,"DECW   5,(%s)",memadrd); dPCl=1; break;
                    case 0x6E: sprintf(msg,"DECW   6,(%s)",memadrd); dPCl=1; break;
                    case 0x6F: sprintf(msg,"DECW   7,(%s)",memadrd); dPCl=1; break;
		    
                    case 0x78: sprintf(msg,"RLC    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x79: sprintf(msg,"RRC    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7A: sprintf(msg,"RL     (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7B: sprintf(msg,"RR     (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7C: sprintf(msg,"SLA    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7D: sprintf(msg,"SRA    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7E: sprintf(msg,"SLL    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x7F: sprintf(msg,"SRL    (%s) ;*",memadrd); dPCl=1; break;
                    case 0x80: sprintf(msg,"ADD    WA,(%s)",memadrd); dPCl=1; break;
                    case 0x81: sprintf(msg,"ADD    BC,(%s)",memadrd); dPCl=1; break;
                    case 0x82: sprintf(msg,"ADD    DE,(%s)",memadrd); dPCl=1; break;
                    case 0x83: sprintf(msg,"ADD    HL,(%s)",memadrd); dPCl=1; break;
                    case 0x84: sprintf(msg,"ADD    IX,(%s)",memadrd); dPCl=1; break;
                    case 0x85: sprintf(msg,"ADD    IY,(%s)",memadrd); dPCl=1; break;
                    case 0x86: sprintf(msg,"ADD    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0x87: sprintf(msg,"ADD    SP,(%s)",memadrd); dPCl=1; break;
                    case 0x88: sprintf(msg,"ADD    (%s),WA",memadrd); dPCl=1; break;
                    case 0x89: sprintf(msg,"ADD    (%s),BC",memadrd); dPCl=1; break;
                    case 0x8A: sprintf(msg,"ADD    (%s),DE",memadrd); dPCl=1; break;
                    case 0x8B: sprintf(msg,"ADD    (%s),HL",memadrd); dPCl=1; break;
                    case 0x8C: sprintf(msg,"ADD    (%s),IX",memadrd); dPCl=1; break;
                    case 0x8D: sprintf(msg,"ADD    (%s),IY",memadrd); dPCl=1; break;
                    case 0x8E: sprintf(msg,"ADD    (%s),IZ",memadrd); dPCl=1; break;
                    case 0x8F: sprintf(msg,"ADD    (%s),SP",memadrd); dPCl=1; break;
                    case 0x90: sprintf(msg,"ADC    WA,(%s)",memadrd); dPCl=1; break;
                    case 0x91: sprintf(msg,"ADC    BC,(%s)",memadrd); dPCl=1; break;
                    case 0x92: sprintf(msg,"ADC    DE,(%s)",memadrd); dPCl=1; break;
                    case 0x93: sprintf(msg,"ADC    HL,(%s)",memadrd); dPCl=1; break;
                    case 0x94: sprintf(msg,"ADC    IX,(%s)",memadrd); dPCl=1; break;
                    case 0x95: sprintf(msg,"ADC    IY,(%s)",memadrd); dPCl=1; break;
                    case 0x96: sprintf(msg,"ADC    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0x97: sprintf(msg,"ADC    SP,(%s)",memadrd); dPCl=1; break;
                    case 0x98: sprintf(msg,"ADC    (%s),WA",memadrd); dPCl=1; break;
                    case 0x99: sprintf(msg,"ADC    (%s),BC",memadrd); dPCl=1; break;
                    case 0x9A: sprintf(msg,"ADC    (%s),DE",memadrd); dPCl=1; break;
                    case 0x9B: sprintf(msg,"ADC    (%s),HL",memadrd); dPCl=1; break;
                    case 0x9C: sprintf(msg,"ADC    (%s),IX",memadrd); dPCl=1; break;
                    case 0x9D: sprintf(msg,"ADC    (%s),IY",memadrd); dPCl=1; break;
                    case 0x9E: sprintf(msg,"ADC    (%s),IZ",memadrd); dPCl=1; break;
                    case 0x9F: sprintf(msg,"ADC    (%s),SP",memadrd); dPCl=1; break;
                    case 0xA0: sprintf(msg,"SUB    WA,(%s)",memadrd); dPCl=1; break;
                    case 0xA1: sprintf(msg,"SUB    BC,(%s)",memadrd); dPCl=1; break;
                    case 0xA2: sprintf(msg,"SUB    DE,(%s)",memadrd); dPCl=1; break;
                    case 0xA3: sprintf(msg,"SUB    HL,(%s)",memadrd); dPCl=1; break;
                    case 0xA4: sprintf(msg,"SUB    IX,(%s)",memadrd); dPCl=1; break;
                    case 0xA5: sprintf(msg,"SUB    IY,(%s)",memadrd); dPCl=1; break;
                    case 0xA6: sprintf(msg,"SUB    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xA7: sprintf(msg,"SUB    SP,(%s)",memadrd); dPCl=1; break;
                    case 0xA8: sprintf(msg,"SUB    (%s),WA",memadrd); dPCl=1; break;
                    case 0xA9: sprintf(msg,"SUB    (%s),BC",memadrd); dPCl=1; break;
                    case 0xAA: sprintf(msg,"SUB    (%s),DE",memadrd); dPCl=1; break;
                    case 0xAB: sprintf(msg,"SUB    (%s),HL",memadrd); dPCl=1; break;
                    case 0xAC: sprintf(msg,"SUB    (%s),IX",memadrd); dPCl=1; break;
                    case 0xAD: sprintf(msg,"SUB    (%s),IY",memadrd); dPCl=1; break;
                    case 0xAE: sprintf(msg,"SUB    (%s),IZ",memadrd); dPCl=1; break;
                    case 0xAF: sprintf(msg,"SUB    (%s),SP",memadrd); dPCl=1; break;
                    case 0xB0: sprintf(msg,"SBC    WA,(%s)",memadrd); dPCl=1; break;
                    case 0xB1: sprintf(msg,"SBC    BC,(%s)",memadrd); dPCl=1; break;
                    case 0xB2: sprintf(msg,"SBC    DE,(%s)",memadrd); dPCl=1; break;
                    case 0xB3: sprintf(msg,"SBC    HL,(%s)",memadrd); dPCl=1; break;
                    case 0xB4: sprintf(msg,"SBC    IX,(%s)",memadrd); dPCl=1; break;
                    case 0xB5: sprintf(msg,"SBC    IY,(%s)",memadrd); dPCl=1; break;
                    case 0xB6: sprintf(msg,"SBC    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xB7: sprintf(msg,"SBC    SP,(%s)",memadrd); dPCl=1; break;
                    case 0xB8: sprintf(msg,"SBC    (%s),WA",memadrd); dPCl=1; break;
                    case 0xB9: sprintf(msg,"SBC    (%s),BC",memadrd); dPCl=1; break;
                    case 0xBA: sprintf(msg,"SBC    (%s),DE",memadrd); dPCl=1; break;
                    case 0xBB: sprintf(msg,"SBC    (%s),HL",memadrd); dPCl=1; break;
                    case 0xBC: sprintf(msg,"SBC    (%s),IX",memadrd); dPCl=1; break;
                    case 0xBD: sprintf(msg,"SBC    (%s),IY",memadrd); dPCl=1; break;
                    case 0xBE: sprintf(msg,"SBC    (%s),IZ",memadrd); dPCl=1; break;
                    case 0xBF: sprintf(msg,"SBC    (%s),SP",memadrd); dPCl=1; break;
                    case 0xC0: sprintf(msg,"AND    WA,(%s)",memadrd); dPCl=1; break;
                    case 0xC1: sprintf(msg,"AND    BC,(%s)",memadrd); dPCl=1; break;
                    case 0xC2: sprintf(msg,"AND    DE,(%s)",memadrd); dPCl=1; break;
                    case 0xC3: sprintf(msg,"AND    HL,(%s)",memadrd); dPCl=1; break;
                    case 0xC4: sprintf(msg,"AND    IX,(%s)",memadrd); dPCl=1; break;
                    case 0xC5: sprintf(msg,"AND    IY,(%s)",memadrd); dPCl=1; break;
                    case 0xC6: sprintf(msg,"AND    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xC7: sprintf(msg,"AND    SP,(%s)",memadrd); dPCl=1; break;
                    case 0xC8: sprintf(msg,"AND    (%s),WA",memadrd); dPCl=1; break;
                    case 0xC9: sprintf(msg,"AND    (%s),BC",memadrd); dPCl=1; break;
                    case 0xCA: sprintf(msg,"AND    (%s),DE",memadrd); dPCl=1; break;
                    case 0xCB: sprintf(msg,"AND    (%s),HL",memadrd); dPCl=1; break;
                    case 0xCC: sprintf(msg,"AND    (%s),IX",memadrd); dPCl=1; break;
                    case 0xCD: sprintf(msg,"AND    (%s),IY",memadrd); dPCl=1; break;
                    case 0xCE: sprintf(msg,"AND    (%s),IZ",memadrd); dPCl=1; break;
                    case 0xCF: sprintf(msg,"AND    (%s),SP",memadrd); dPCl=1; break;
                    case 0xD0: sprintf(msg,"XOR    WA,(%s)",memadrd); dPCl=1; break;
                    case 0xD1: sprintf(msg,"XOR    BC,(%s)",memadrd); dPCl=1; break;
                    case 0xD2: sprintf(msg,"XOR    DE,(%s)",memadrd); dPCl=1; break;
                    case 0xD3: sprintf(msg,"XOR    HL,(%s)",memadrd); dPCl=1; break;
                    case 0xD4: sprintf(msg,"XOR    IX,(%s)",memadrd); dPCl=1; break;
                    case 0xD5: sprintf(msg,"XOR    IY,(%s)",memadrd); dPCl=1; break;
                    case 0xD6: sprintf(msg,"XOR    IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xD7: sprintf(msg,"XOR    SP,(%s)",memadrd); dPCl=1; break;
                    case 0xD8: sprintf(msg,"XOR    (%s),WA",memadrd); dPCl=1; break;
                    case 0xD9: sprintf(msg,"XOR    (%s),BC",memadrd); dPCl=1; break;
                    case 0xDA: sprintf(msg,"XOR    (%s),DE",memadrd); dPCl=1; break;
                    case 0xDB: sprintf(msg,"XOR    (%s),HL",memadrd); dPCl=1; break;
                    case 0xDC: sprintf(msg,"XOR    (%s),IX",memadrd); dPCl=1; break;
                    case 0xDD: sprintf(msg,"XOR    (%s),IY",memadrd); dPCl=1; break;
                    case 0xDE: sprintf(msg,"XOR    (%s),IZ",memadrd); dPCl=1; break;
                    case 0xDF: sprintf(msg,"XOR    (%s),SP",memadrd); dPCl=1; break;
                    case 0xE0: sprintf(msg,"OR     WA,(%s)",memadrd); dPCl=1; break;
                    case 0xE1: sprintf(msg,"OR     BC,(%s)",memadrd); dPCl=1; break;
                    case 0xE2: sprintf(msg,"OR     DE,(%s)",memadrd); dPCl=1; break;
                    case 0xE3: sprintf(msg,"OR     HL,(%s)",memadrd); dPCl=1; break;
                    case 0xE4: sprintf(msg,"OR     IX,(%s)",memadrd); dPCl=1; break;
                    case 0xE5: sprintf(msg,"OR     IY,(%s)",memadrd); dPCl=1; break;
                    case 0xE6: sprintf(msg,"OR     IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xE7: sprintf(msg,"OR     SP,(%s)",memadrd); dPCl=1; break;
                    case 0xE8: sprintf(msg,"OR     (%s),WA",memadrd); dPCl=1; break;
                    case 0xE9: sprintf(msg,"OR     (%s),BC",memadrd); dPCl=1; break;
                    case 0xEA: sprintf(msg,"OR     (%s),DE",memadrd); dPCl=1; break;
                    case 0xEB: sprintf(msg,"OR     (%s),HL",memadrd); dPCl=1; break;
                    case 0xEC: sprintf(msg,"OR     (%s),IX",memadrd); dPCl=1; break;
                    case 0xED: sprintf(msg,"OR     (%s),IY",memadrd); dPCl=1; break;
                    case 0xEE: sprintf(msg,"OR     (%s),IZ",memadrd); dPCl=1; break;
                    case 0xEF: sprintf(msg,"OR     (%s),SP",memadrd); dPCl=1; break;
                    case 0xF0: sprintf(msg,"CP     WA,(%s)",memadrd); dPCl=1; break;
                    case 0xF1: sprintf(msg,"CP     BC,(%s)",memadrd); dPCl=1; break;
                    case 0xF2: sprintf(msg,"CP     DE,(%s)",memadrd); dPCl=1; break;
                    case 0xF3: sprintf(msg,"CP     HL,(%s)",memadrd); dPCl=1; break;
                    case 0xF4: sprintf(msg,"CP     IX,(%s)",memadrd); dPCl=1; break;
                    case 0xF5: sprintf(msg,"CP     IY,(%s)",memadrd); dPCl=1; break;
                    case 0xF6: sprintf(msg,"CP     IZ,(%s)",memadrd); dPCl=1; break;
                    case 0xF7: sprintf(msg,"CP     SP,(%s)",memadrd); dPCl=1; break;
                    case 0xF8: sprintf(msg,"CP     (%s),WA",memadrd); dPCl=1; break;
                    case 0xF9: sprintf(msg,"CP     (%s),BC",memadrd); dPCl=1; break;
                    case 0xFA: sprintf(msg,"CP     (%s),DE",memadrd); dPCl=1; break;
                    case 0xFB: sprintf(msg,"CP     (%s),HL",memadrd); dPCl=1; break;
                    case 0xFC: sprintf(msg,"CP     (%s),IX",memadrd); dPCl=1; break;
                    case 0xFD: sprintf(msg,"CP     (%s),IY",memadrd); dPCl=1; break;
                    case 0xFE: sprintf(msg,"CP     (%s),IZ",memadrd); dPCl=1; break;
                    case 0xFF: sprintf(msg,"CP     (%s),SP",memadrd); dPCl=1; break;

                    default:   sprintf(msg,"src.W %s: %02Xh",memadrtb,rom[dPC]); break;
	        } break;

            case 2: /* src.L */
		sprintf(memadrt,"src.L %s",memadrtb);
	    
	        switch (rom[dPC]) {
                    case 0x20: sprintf(msg,"LD     XWA,(%s)",memadrd); dPCl=1; break;
                    case 0x21: sprintf(msg,"LD     XBC,(%s)",memadrd); dPCl=1; break;
                    case 0x22: sprintf(msg,"LD     XDE,(%s)",memadrd); dPCl=1; break;
                    case 0x23: sprintf(msg,"LD     XHL,(%s)",memadrd); dPCl=1; break;
                    case 0x24: sprintf(msg,"LD     XIX,(%s)",memadrd); dPCl=1; break;
                    case 0x25: sprintf(msg,"LD     XIY,(%s)",memadrd); dPCl=1; break;
                    case 0x26: sprintf(msg,"LD     XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0x27: sprintf(msg,"LD     XSP,(%s)",memadrd); dPCl=1; break;

                    case 0x80: sprintf(msg,"ADD    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0x81: sprintf(msg,"ADD    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0x82: sprintf(msg,"ADD    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0x83: sprintf(msg,"ADD    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0x84: sprintf(msg,"ADD    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0x85: sprintf(msg,"ADD    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0x86: sprintf(msg,"ADD    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0x87: sprintf(msg,"ADD    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0x88: sprintf(msg,"ADD    (%s),XWA",memadrd); dPCl=1; break;
                    case 0x89: sprintf(msg,"ADD    (%s),XBC",memadrd); dPCl=1; break;
                    case 0x8A: sprintf(msg,"ADD    (%s),XDE",memadrd); dPCl=1; break;
                    case 0x8B: sprintf(msg,"ADD    (%s),XHL",memadrd); dPCl=1; break;
                    case 0x8C: sprintf(msg,"ADD    (%s),XIX",memadrd); dPCl=1; break;
                    case 0x8D: sprintf(msg,"ADD    (%s),XIY",memadrd); dPCl=1; break;
                    case 0x8E: sprintf(msg,"ADD    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0x8F: sprintf(msg,"ADD    (%s),XSP",memadrd); dPCl=1; break;
                    case 0x90: sprintf(msg,"ADC    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0x91: sprintf(msg,"ADC    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0x92: sprintf(msg,"ADC    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0x93: sprintf(msg,"ADC    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0x94: sprintf(msg,"ADC    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0x95: sprintf(msg,"ADC    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0x96: sprintf(msg,"ADC    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0x97: sprintf(msg,"ADC    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0x98: sprintf(msg,"ADC    (%s),XWA",memadrd); dPCl=1; break;
                    case 0x99: sprintf(msg,"ADC    (%s),XBC",memadrd); dPCl=1; break;
                    case 0x9A: sprintf(msg,"ADC    (%s),XDE",memadrd); dPCl=1; break;
                    case 0x9B: sprintf(msg,"ADC    (%s),XHL",memadrd); dPCl=1; break;
                    case 0x9C: sprintf(msg,"ADC    (%s),XIX",memadrd); dPCl=1; break;
                    case 0x9D: sprintf(msg,"ADC    (%s),XIY",memadrd); dPCl=1; break;
                    case 0x9E: sprintf(msg,"ADC    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0x9F: sprintf(msg,"ADC    (%s),XSP",memadrd); dPCl=1; break;
                    case 0xA0: sprintf(msg,"SUB    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xA1: sprintf(msg,"SUB    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xA2: sprintf(msg,"SUB    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xA3: sprintf(msg,"SUB    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xA4: sprintf(msg,"SUB    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xA5: sprintf(msg,"SUB    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xA6: sprintf(msg,"SUB    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xA7: sprintf(msg,"SUB    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xA8: sprintf(msg,"SUB    (%s),XWA",memadrd); dPCl=1; break;
                    case 0xA9: sprintf(msg,"SUB    (%s),XBC",memadrd); dPCl=1; break;
                    case 0xAA: sprintf(msg,"SUB    (%s),XDE",memadrd); dPCl=1; break;
                    case 0xAB: sprintf(msg,"SUB    (%s),XHL",memadrd); dPCl=1; break;
                    case 0xAC: sprintf(msg,"SUB    (%s),XIX",memadrd); dPCl=1; break;
                    case 0xAD: sprintf(msg,"SUB    (%s),XIY",memadrd); dPCl=1; break;
                    case 0xAE: sprintf(msg,"SUB    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xAF: sprintf(msg,"SUB    (%s),XSP",memadrd); dPCl=1; break;
                    case 0xB0: sprintf(msg,"SBC    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xB1: sprintf(msg,"SBC    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xB2: sprintf(msg,"SBC    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xB3: sprintf(msg,"SBC    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xB4: sprintf(msg,"SBC    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xB5: sprintf(msg,"SBC    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xB6: sprintf(msg,"SBC    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xB7: sprintf(msg,"SBC    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xB8: sprintf(msg,"SBC    (%s),XWA",memadrd); dPCl=1; break;
                    case 0xB9: sprintf(msg,"SBC    (%s),XBC",memadrd); dPCl=1; break;
                    case 0xBA: sprintf(msg,"SBC    (%s),XDE",memadrd); dPCl=1; break;
                    case 0xBB: sprintf(msg,"SBC    (%s),XHL",memadrd); dPCl=1; break;
                    case 0xBC: sprintf(msg,"SBC    (%s),XIX",memadrd); dPCl=1; break;
                    case 0xBD: sprintf(msg,"SBC    (%s),XIY",memadrd); dPCl=1; break;
                    case 0xBE: sprintf(msg,"SBC    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xBF: sprintf(msg,"SBC    (%s),XSP",memadrd); dPCl=1; break;
                    case 0xC0: sprintf(msg,"AND    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xC1: sprintf(msg,"AND    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xC2: sprintf(msg,"AND    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xC3: sprintf(msg,"AND    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xC4: sprintf(msg,"AND    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xC5: sprintf(msg,"AND    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xC6: sprintf(msg,"AND    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xC7: sprintf(msg,"AND    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xC8: sprintf(msg,"AND    (%s),XWA",memadrd); dPCl=1; break;
                    case 0xC9: sprintf(msg,"AND    (%s),XBC",memadrd); dPCl=1; break;
                    case 0xCA: sprintf(msg,"AND    (%s),XDE",memadrd); dPCl=1; break;
                    case 0xCB: sprintf(msg,"AND    (%s),XHL",memadrd); dPCl=1; break;
                    case 0xCC: sprintf(msg,"AND    (%s),XIX",memadrd); dPCl=1; break;
                    case 0xCD: sprintf(msg,"AND    (%s),XIY",memadrd); dPCl=1; break;
                    case 0xCE: sprintf(msg,"AND    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xCF: sprintf(msg,"AND    (%s),XSP",memadrd); dPCl=1; break;
                    case 0xD0: sprintf(msg,"XOR    XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xD1: sprintf(msg,"XOR    XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xD2: sprintf(msg,"XOR    XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xD3: sprintf(msg,"XOR    XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xD4: sprintf(msg,"XOR    XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xD5: sprintf(msg,"XOR    XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xD6: sprintf(msg,"XOR    XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xD7: sprintf(msg,"XOR    XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xD8: sprintf(msg,"XOR    (%s),XWA",memadrd); dPCl=1; break;
                    case 0xD9: sprintf(msg,"XOR    (%s),XBC",memadrd); dPCl=1; break;
                    case 0xDA: sprintf(msg,"XOR    (%s),XDE",memadrd); dPCl=1; break;
                    case 0xDB: sprintf(msg,"XOR    (%s),XHL",memadrd); dPCl=1; break;
                    case 0xDC: sprintf(msg,"XOR    (%s),XIX",memadrd); dPCl=1; break;
                    case 0xDD: sprintf(msg,"XOR    (%s),XIY",memadrd); dPCl=1; break;
                    case 0xDE: sprintf(msg,"XOR    (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xDF: sprintf(msg,"XOR    (%s),XSP",memadrd); dPCl=1; break;
                    case 0xE0: sprintf(msg,"OR     XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xE1: sprintf(msg,"OR     XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xE2: sprintf(msg,"OR     XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xE3: sprintf(msg,"OR     XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xE4: sprintf(msg,"OR     XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xE5: sprintf(msg,"OR     XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xE6: sprintf(msg,"OR     XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xE7: sprintf(msg,"OR     XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xE8: sprintf(msg,"OR     (%s),XWA",memadrd); dPCl=1; break;
                    case 0xE9: sprintf(msg,"OR     (%s),XBC",memadrd); dPCl=1; break;
                    case 0xEA: sprintf(msg,"OR     (%s),XDE",memadrd); dPCl=1; break;
                    case 0xEB: sprintf(msg,"OR     (%s),XHL",memadrd); dPCl=1; break;
                    case 0xEC: sprintf(msg,"OR     (%s),XIX",memadrd); dPCl=1; break;
                    case 0xED: sprintf(msg,"OR     (%s),XIY",memadrd); dPCl=1; break;
                    case 0xEE: sprintf(msg,"OR     (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xEF: sprintf(msg,"OR     (%s),XSP",memadrd); dPCl=1; break;
                    case 0xF0: sprintf(msg,"CP     XWA,(%s)",memadrd); dPCl=1; break;
                    case 0xF1: sprintf(msg,"CP     XBC,(%s)",memadrd); dPCl=1; break;
                    case 0xF2: sprintf(msg,"CP     XDE,(%s)",memadrd); dPCl=1; break;
                    case 0xF3: sprintf(msg,"CP     XHL,(%s)",memadrd); dPCl=1; break;
                    case 0xF4: sprintf(msg,"CP     XIX,(%s)",memadrd); dPCl=1; break;
                    case 0xF5: sprintf(msg,"CP     XIY,(%s)",memadrd); dPCl=1; break;
                    case 0xF6: sprintf(msg,"CP     XIZ,(%s)",memadrd); dPCl=1; break;
                    case 0xF7: sprintf(msg,"CP     XSP,(%s)",memadrd); dPCl=1; break;
                    case 0xF8: sprintf(msg,"CP     (%s),XWA",memadrd); dPCl=1; break;
                    case 0xF9: sprintf(msg,"CP     (%s),XBC",memadrd); dPCl=1; break;
                    case 0xFA: sprintf(msg,"CP     (%s),XDE",memadrd); dPCl=1; break;
                    case 0xFB: sprintf(msg,"CP     (%s),XHL",memadrd); dPCl=1; break;
                    case 0xFC: sprintf(msg,"CP     (%s),XIX",memadrd); dPCl=1; break;
                    case 0xFD: sprintf(msg,"CP     (%s),XIY",memadrd); dPCl=1; break;
                    case 0xFE: sprintf(msg,"CP     (%s),XIZ",memadrd); dPCl=1; break;
                    case 0xFF: sprintf(msg,"CP     (%s),XSP",memadrd); dPCl=1; break;

                    default:   sprintf(msg,"src.L %s: %02Xh",memadrtb,rom[dPC]); break;
                } break;

	    case 3: /* dst */
            sprintf(memadrt,"dst %s",memadrtb);
	    
            OpTmp16  = (rom[dPC+2]<<8)+rom[dPC+1];         
            switch (rom[dPC]) {
	            case 0x00: sprintf(msg,"LD     (%s),%02Xh",memadrd,rom[dPC+1]); dPCl=2; break;

    		    case 0x02: sprintf(msg,"LD     (%s),%04Xh",memadrd,OpTmp16); dPCl=3; break;

                case 0x04: sprintf(msg,"POPB   (%s) ;*",memadrd); dPCl=1; break;
		    
                case 0x06: sprintf(msg,"POPW   (%s) ;*",memadrd); dPCl=1; break;

                case 0x14: sprintf(msg,"LDB    (%s),(00%04X) ;*",memadrd,OpTmp16); dPCl=3; break;

	            case 0x16: sprintf(msg,"LDW    (%s),(00%04X) ;*",memadrd,OpTmp16); dPCl=3; break;

                case 0x20: sprintf(msg,"LDA    WA,%s ;*",memadrd); dPCl=1; break;
                case 0x21: sprintf(msg,"LDA    BC,%s ;*",memadrd); dPCl=1; break;
	            case 0x22: sprintf(msg,"LDA    DE,%s ;*",memadrd); dPCl=1; break;
                case 0x23: sprintf(msg,"LDA    HL,%s ;*",memadrd); dPCl=1; break;
	            case 0x24: sprintf(msg,"LDA    IX,%s ;*",memadrd); dPCl=1; break;
                case 0x25: sprintf(msg,"LDA    IY,%s ;*",memadrd); dPCl=1; break;
                case 0x26: sprintf(msg,"LDA    IZ,%s ;*",memadrd); dPCl=1; break;
                case 0x27: sprintf(msg,"LDA    SP,%s ;*",memadrd); dPCl=1; break;
                case 0x28: sprintf(msg,"ANDCF  A,(%s) ;*",memadrd); dPCl=1; break;
                case 0x29: sprintf(msg,"ORCF   A,(%s) ;*",memadrd); dPCl=1; break;
                case 0x2A: sprintf(msg,"XORCF  A,(%s) ;*",memadrd); dPCl=1; break;
                case 0x2B: sprintf(msg,"LDCF   A,(%s) ;*",memadrd); dPCl=1; break;
                case 0x2C: sprintf(msg,"STCF   A,(%s) ;*",memadrd); dPCl=1; break;
           
                case 0x30: sprintf(msg,"LDA    XWA,%s",memadrd); dPCl=1; break;
                case 0x31: sprintf(msg,"LDA    XBC,%s",memadrd); dPCl=1; break;
	            case 0x32: sprintf(msg,"LDA    XDE,%s",memadrd); dPCl=1; break;
                case 0x33: sprintf(msg,"LDA    XHL,%s",memadrd); dPCl=1; break;
	            case 0x34: sprintf(msg,"LDA    XIX,%s",memadrd); dPCl=1; break;
                case 0x35: sprintf(msg,"LDA    XIY,%s",memadrd); dPCl=1; break;
                case 0x36: sprintf(msg,"LDA    XIZ,%s",memadrd); dPCl=1; break;
                case 0x37: sprintf(msg,"LDA    XSP,%s",memadrd); dPCl=1; break;

                case 0x40: sprintf(msg,"LD     (%s),W",memadrd); dPCl=1; break;
                case 0x41: sprintf(msg,"LD     (%s),A",memadrd); dPCl=1; break;
                case 0x42: sprintf(msg,"LD     (%s),B",memadrd); dPCl=1; break;
                case 0x43: sprintf(msg,"LD     (%s),C",memadrd); dPCl=1; break;
                case 0x44: sprintf(msg,"LD     (%s),D",memadrd); dPCl=1; break;
                case 0x45: sprintf(msg,"LD     (%s),E",memadrd); dPCl=1; break;
                case 0x46: sprintf(msg,"LD     (%s),H",memadrd); dPCl=1; break;
                case 0x47: sprintf(msg,"LD     (%s),L",memadrd); dPCl=1; break;

                case 0x50: sprintf(msg,"LD     (%s),WA",memadrd); dPCl=1; break;
                case 0x51: sprintf(msg,"LD     (%s),BC",memadrd); dPCl=1; break;
                case 0x52: sprintf(msg,"LD     (%s),DE",memadrd); dPCl=1; break;
                case 0x53: sprintf(msg,"LD     (%s),HL",memadrd); dPCl=1; break;
                case 0x54: sprintf(msg,"LD     (%s),IX",memadrd); dPCl=1; break;
                case 0x55: sprintf(msg,"LD     (%s),IY",memadrd); dPCl=1; break;
                case 0x56: sprintf(msg,"LD     (%s),IZ",memadrd); dPCl=1; break;
                case 0x57: sprintf(msg,"LD     (%s),SP",memadrd); dPCl=1; break;

                case 0x60: sprintf(msg,"LD     (%s),XWA",memadrd); dPCl=1; break;
                case 0x61: sprintf(msg,"LD     (%s),XBC",memadrd); dPCl=1; break;
                case 0x62: sprintf(msg,"LD     (%s),XDE",memadrd); dPCl=1; break;
                case 0x63: sprintf(msg,"LD     (%s),XHL",memadrd); dPCl=1; break;
                case 0x64: sprintf(msg,"LD     (%s),XIX",memadrd); dPCl=1; break;
                case 0x65: sprintf(msg,"LD     (%s),XIY",memadrd); dPCl=1; break;
                case 0x66: sprintf(msg,"LD     (%s),XIZ",memadrd); dPCl=1; break;
                case 0x67: sprintf(msg,"LD     (%s),XSP",memadrd); dPCl=1; break;

                case 0x80: sprintf(msg,"ANDCF  0,(%s) ;*",memadrd); dPCl=1; break;
                case 0x81: sprintf(msg,"ANDCF  1,(%s) ;*",memadrd); dPCl=1; break;
                case 0x82: sprintf(msg,"ANDCF  2,(%s) ;*",memadrd); dPCl=1; break;
                case 0x83: sprintf(msg,"ANDCF  3,(%s) ;*",memadrd); dPCl=1; break;
                case 0x84: sprintf(msg,"ANDCF  4,(%s) ;*",memadrd); dPCl=1; break;
                case 0x85: sprintf(msg,"ANDCF  5,(%s) ;*",memadrd); dPCl=1; break;
                case 0x86: sprintf(msg,"ANDCF  6,(%s) ;*",memadrd); dPCl=1; break;
                case 0x87: sprintf(msg,"ANDCF  7,(%s) ;*",memadrd); dPCl=1; break;
                case 0x88: sprintf(msg,"ORCF   0,(%s) ;*",memadrd); dPCl=1; break;
                case 0x89: sprintf(msg,"ORCF   1,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8A: sprintf(msg,"ORCF   2,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8B: sprintf(msg,"ORCF   3,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8C: sprintf(msg,"ORCF   4,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8D: sprintf(msg,"ORCF   5,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8E: sprintf(msg,"ORCF   6,(%s) ;*",memadrd); dPCl=1; break;
                case 0x8F: sprintf(msg,"ORCF   7,(%s) ;*",memadrd); dPCl=1; break;
                case 0x90: sprintf(msg,"XORCF  0,(%s) ;*",memadrd); dPCl=1; break;
                case 0x91: sprintf(msg,"XORCF  1,(%s) ;*",memadrd); dPCl=1; break;
                case 0x92: sprintf(msg,"XORCF  2,(%s) ;*",memadrd); dPCl=1; break;
                case 0x93: sprintf(msg,"XORCF  3,(%s) ;*",memadrd); dPCl=1; break;
                case 0x94: sprintf(msg,"XORCF  4,(%s) ;*",memadrd); dPCl=1; break;
                case 0x95: sprintf(msg,"XORCF  5,(%s) ;*",memadrd); dPCl=1; break;
                case 0x96: sprintf(msg,"XORCF  6,(%s) ;*",memadrd); dPCl=1; break;
                case 0x97: sprintf(msg,"XORCF  7,(%s) ;*",memadrd); dPCl=1; break;
                case 0x98: sprintf(msg,"LDCF   0,(%s) ;*",memadrd); dPCl=1; break;
                case 0x99: sprintf(msg,"LDCF   1,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9A: sprintf(msg,"LDCF   2,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9B: sprintf(msg,"LDCF   3,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9C: sprintf(msg,"LDCF   4,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9D: sprintf(msg,"LDCF   5,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9E: sprintf(msg,"LDCF   6,(%s) ;*",memadrd); dPCl=1; break;
                case 0x9F: sprintf(msg,"LDCF   7,(%s) ;*",memadrd); dPCl=1; break;
                case 0xA0: sprintf(msg,"STCF   0,(%s)",memadrd); dPCl=1; break;
                case 0xA1: sprintf(msg,"STCF   1,(%s)",memadrd); dPCl=1; break;
                case 0xA2: sprintf(msg,"STCF   2,(%s)",memadrd); dPCl=1; break;
                case 0xA3: sprintf(msg,"STCF   3,(%s)",memadrd); dPCl=1; break;
                case 0xA4: sprintf(msg,"STCF   4,(%s)",memadrd); dPCl=1; break;
                case 0xA5: sprintf(msg,"STCF   5,(%s)",memadrd); dPCl=1; break;
                case 0xA6: sprintf(msg,"STCF   6,(%s)",memadrd); dPCl=1; break;
                case 0xA7: sprintf(msg,"STCF   7,(%s)",memadrd); dPCl=1; break;
                case 0xA8: sprintf(msg,"TSET   0,(%s) ;*",memadrd); dPCl=1; break;
                case 0xA9: sprintf(msg,"TSET   1,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAA: sprintf(msg,"TSET   2,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAB: sprintf(msg,"TSET   3,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAC: sprintf(msg,"TSET   4,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAD: sprintf(msg,"TSET   5,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAE: sprintf(msg,"TSET   6,(%s) ;*",memadrd); dPCl=1; break;
                case 0xAF: sprintf(msg,"TSET   7,(%s) ;*",memadrd); dPCl=1; break;
                case 0xB0: sprintf(msg,"RES    0,(%s)",memadrd); dPCl=1; break;
                case 0xB1: sprintf(msg,"RES    1,(%s)",memadrd); dPCl=1; break;
                case 0xB2: sprintf(msg,"RES    2,(%s)",memadrd); dPCl=1; break;
                case 0xB3: sprintf(msg,"RES    3,(%s)",memadrd); dPCl=1; break;
                case 0xB4: sprintf(msg,"RES    4,(%s)",memadrd); dPCl=1; break;
                case 0xB5: sprintf(msg,"RES    5,(%s)",memadrd); dPCl=1; break;
                case 0xB6: sprintf(msg,"RES    6,(%s)",memadrd); dPCl=1; break;
                case 0xB7: sprintf(msg,"RES    7,(%s)",memadrd); dPCl=1; break;
                case 0xB8: sprintf(msg,"SET    0,(%s)",memadrd); dPCl=1; break;
                case 0xB9: sprintf(msg,"SET    1,(%s)",memadrd); dPCl=1; break;
                case 0xBA: sprintf(msg,"SET    2,(%s)",memadrd); dPCl=1; break;
                case 0xBB: sprintf(msg,"SET    3,(%s)",memadrd); dPCl=1; break;
                case 0xBC: sprintf(msg,"SET    4,(%s)",memadrd); dPCl=1; break;
                case 0xBD: sprintf(msg,"SET    5,(%s)",memadrd); dPCl=1; break;
                case 0xBE: sprintf(msg,"SET    6,(%s)",memadrd); dPCl=1; break;
                case 0xBF: sprintf(msg,"SET    7,(%s)",memadrd); dPCl=1; break;
                case 0xC0: sprintf(msg,"CHG    0,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC1: sprintf(msg,"CHG    1,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC2: sprintf(msg,"CHG    2,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC3: sprintf(msg,"CHG    3,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC4: sprintf(msg,"CHG    4,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC5: sprintf(msg,"CHG    5,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC6: sprintf(msg,"CHG    6,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC7: sprintf(msg,"CHG    7,(%s) ;*",memadrd); dPCl=1; break;
                case 0xC8: sprintf(msg,"BIT    0,(%s)",memadrd); dPCl=1; break;
                case 0xC9: sprintf(msg,"BIT    1,(%s)",memadrd); dPCl=1; break;
                case 0xCA: sprintf(msg,"BIT    2,(%s)",memadrd); dPCl=1; break;
                case 0xCB: sprintf(msg,"BIT    3,(%s)",memadrd); dPCl=1; break;
                case 0xCC: sprintf(msg,"BIT    4,(%s)",memadrd); dPCl=1; break;
                case 0xCD: sprintf(msg,"BIT    5,(%s)",memadrd); dPCl=1; break;
                case 0xCE: sprintf(msg,"BIT    6,(%s)",memadrd); dPCl=1; break;
                case 0xCF: sprintf(msg,"BIT    7,(%s)",memadrd); dPCl=1; break;
                case 0xD0: sprintf(msg,"JP     f,%s ;*",memadrd); dPCl=1; break;
                case 0xD1: sprintf(msg,"JP     lt,%s ;*",memadrd); dPCl=1; break;
                case 0xD2: sprintf(msg,"JP     le,%s ;*",memadrd); dPCl=1; break;
                case 0xD3: sprintf(msg,"JP     ule,%s ;*",memadrd); dPCl=1; break;
                case 0xD4: sprintf(msg,"JP     ov,%s ;*",memadrd); dPCl=1; break;
                case 0xD5: sprintf(msg,"JP     mi,%s ;*",memadrd); dPCl=1; break;
                case 0xD6: sprintf(msg,"JP     z,%s",memadrd); dPCl=1; break;
                case 0xD7: sprintf(msg,"JP     c,%s",memadrd); dPCl=1; break;
                case 0xD8: sprintf(msg,"JP     %s",memadrd); dPCl=1; break;
                case 0xD9: sprintf(msg,"JP     ge,%s ;*",memadrd); dPCl=1; break;
                case 0xDA: sprintf(msg,"JP     gt,%s ;*",memadrd); dPCl=1; break;
                case 0xDB: sprintf(msg,"JP     ugt,%s ;*",memadrd); dPCl=1; break;
                case 0xDC: sprintf(msg,"JP     nov,%s ;*",memadrd); dPCl=1; break;
                case 0xDD: sprintf(msg,"JP     pl,%s ;*",memadrd); dPCl=1; break;
                case 0xDE: sprintf(msg,"JP     nz,%s",memadrd); dPCl=1; break;
                case 0xDF: sprintf(msg,"JP     nc,%s",memadrd); dPCl=1; break;
                case 0xE0: sprintf(msg,"CALL   f,%s ;*",memadrd); dPCl=1; break;
                case 0xE1: sprintf(msg,"CALL   lt,%s ;*",memadrd); dPCl=1; break;
                case 0xE2: sprintf(msg,"CALL   le,%s ;*",memadrd); dPCl=1; break;
                case 0xE3: sprintf(msg,"CALL   ule,%s ;*",memadrd); dPCl=1; break;
                case 0xE4: sprintf(msg,"CALL   ov,%s ;*",memadrd); dPCl=1; break;
                case 0xE5: sprintf(msg,"CALL   mi,%s ;*",memadrd); dPCl=1; break;
                case 0xE6: sprintf(msg,"CALL   z,%s",memadrd); dPCl=1; break;
                case 0xE7: sprintf(msg,"CALL   c,%s ;*",memadrd); dPCl=1; break;
                case 0xE8: sprintf(msg,"CALL   %s",memadrd); dPCl=1; break;
                case 0xE9: sprintf(msg,"CALL   ge,%s ;*",memadrd); dPCl=1; break;
                case 0xEA: sprintf(msg,"CALL   gt,%s ;*",memadrd); dPCl=1; break;
                case 0xEB: sprintf(msg,"CALL   ugt,%s ;*",memadrd); dPCl=1; break;
                case 0xEC: sprintf(msg,"CALL   nov,%s ;*",memadrd); dPCl=1; break;
                case 0xED: sprintf(msg,"CALL   pl,%s ;*",memadrd); dPCl=1; break;
                case 0xEE: sprintf(msg,"CALL   nz,%s",memadrd); dPCl=1; break;
                case 0xEF: sprintf(msg,"CALL   nc,%s",memadrd); dPCl=1; break;
                case 0xF0: if (opcode==0xB0) sprintf(msg,"RET    f ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF1: if (opcode==0xB0) sprintf(msg,"RET    lt ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF2: if (opcode==0xB0) sprintf(msg,"RET    le ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF3: if (opcode==0xB0) sprintf(msg,"RET    ule ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF4: if (opcode==0xB0) sprintf(msg,"RET    ov ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF5: if (opcode==0xB0) sprintf(msg,"RET    mi ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF6: if (opcode==0xB0) sprintf(msg,"RET    z"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF7: if (opcode==0xB0) sprintf(msg,"RET    c"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF8: if (opcode==0xB0) sprintf(msg,"RET    ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xF9: if (opcode==0xB0) sprintf(msg,"RET    ge ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFA: if (opcode==0xB0) sprintf(msg,"RET    gt ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFB: if (opcode==0xB0) sprintf(msg,"RET    ugt ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFC: if (opcode==0xB0) sprintf(msg,"RET    nov ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFD: if (opcode==0xB0) sprintf(msg,"RET    pl ;*"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFE: if (opcode==0xB0) sprintf(msg,"RET    nz"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;
                case 0xFF: if (opcode==0xB0) sprintf(msg,"RET    nc"); else sprintf(msg,"invalid dst (%s)",memadrd); dPCl=1; break;

                default:   sprintf(msg,"dst %s: %02Xh",memadrtb,rom[dPC]);
            } break;
        }
    } /* if ( !((madr.hi==1) && (madr.lo>=0x8)) ) */

    else if ((madr.type==0) && (madr.lo==0x7)) { /* reg.B r */
        OpTmp8s = rom[dPC+3];

        switch (rom[dPC+2]) {
            case 0x03: sprintf(msg,"LD     %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+2]); dPCl=3; break;

            case 0x04: sprintf(msg,"PUSH   %s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x05: sprintf(msg,"POP    %s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x06: sprintf(msg,"CPL    %s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x07: sprintf(msg,"NEG    %s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
	    
            case 0x1C: sprintf(msg,"DJNZ   %s,%06lX",xr8n[rom[dPC+1]],dPC+3+OpTmp8s); dPCl=3; break;

            case 0x30: sprintf(msg,"RES    %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;
            case 0x31: sprintf(msg,"SET    %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;
            case 0x32: sprintf(msg,"CHG    %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;
            case 0x33: sprintf(msg,"BIT    %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;
            case 0x34: sprintf(msg,"TSET   %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;

            case 0x60: sprintf(msg,"INC    8,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x61: sprintf(msg,"INC    1,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x62: sprintf(msg,"INC    2,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x63: sprintf(msg,"INC    3,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x64: sprintf(msg,"INC    4,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x65: sprintf(msg,"INC    5,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x66: sprintf(msg,"INC    6,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x67: sprintf(msg,"INC    7,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x68: sprintf(msg,"DEC    8,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x69: sprintf(msg,"DEC    1,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6A: sprintf(msg,"DEC    2,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6B: sprintf(msg,"DEC    3,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6C: sprintf(msg,"DEC    4,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6D: sprintf(msg,"DEC    5,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6E: sprintf(msg,"DEC    6,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x6F: sprintf(msg,"DEC    7,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;

            case 0x80: sprintf(msg,"ADD    W,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x81: sprintf(msg,"ADD    A,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x82: sprintf(msg,"ADD    B,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x83: sprintf(msg,"ADD    C,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x84: sprintf(msg,"ADD    D,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x85: sprintf(msg,"ADD    E,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x86: sprintf(msg,"ADD    H,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x87: sprintf(msg,"ADD    L,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x88: sprintf(msg,"LD     W,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x89: sprintf(msg,"LD     A,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8A: sprintf(msg,"LD     B,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8B: sprintf(msg,"LD     C,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8C: sprintf(msg,"LD     D,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8D: sprintf(msg,"LD     E,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8E: sprintf(msg,"LD     H,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x8F: sprintf(msg,"LD     L,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x90: sprintf(msg,"ADC    W,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x91: sprintf(msg,"ADC    A,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x92: sprintf(msg,"ADC    B,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x93: sprintf(msg,"ADC    C,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x94: sprintf(msg,"ADC    D,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x95: sprintf(msg,"ADC    E,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x96: sprintf(msg,"ADC    H,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x97: sprintf(msg,"ADC    L,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x98: sprintf(msg,"LD     %s,W",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x99: sprintf(msg,"LD     %s,A",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9A: sprintf(msg,"LD     %s,B",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9B: sprintf(msg,"LD     %s,C",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9C: sprintf(msg,"LD     %s,D",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9D: sprintf(msg,"LD     %s,E",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9E: sprintf(msg,"LD     %s,H",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0x9F: sprintf(msg,"LD     %s,L",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA0: sprintf(msg,"SUB    W,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA1: sprintf(msg,"SUB    A,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA2: sprintf(msg,"SUB    B,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA3: sprintf(msg,"SUB    C,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA4: sprintf(msg,"SUB    D,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA5: sprintf(msg,"SUB    E,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA6: sprintf(msg,"SUB    H,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA7: sprintf(msg,"SUB    L,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA8: sprintf(msg,"LD     %s,0",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xA9: sprintf(msg,"LD     %s,1",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAA: sprintf(msg,"LD     %s,2",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAB: sprintf(msg,"LD     %s,3",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAC: sprintf(msg,"LD     %s,4",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAD: sprintf(msg,"LD     %s,5",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAE: sprintf(msg,"LD     %s,6",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xAF: sprintf(msg,"LD     %s,7",xr8n[rom[dPC+1]]); dPCl=3; break;

            case 0xC0: sprintf(msg,"AND    W,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC1: sprintf(msg,"AND    A,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC2: sprintf(msg,"AND    B,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC3: sprintf(msg,"AND    C,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC4: sprintf(msg,"AND    D,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC5: sprintf(msg,"AND    E,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC6: sprintf(msg,"AND    H,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC7: sprintf(msg,"AND    L,%s ;*",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xC8: sprintf(msg,"ADD    %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xC9: sprintf(msg,"ADC    %s,%02Xh ;*",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCA: sprintf(msg,"SUB    %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCB: sprintf(msg,"SBC    %s,%02Xh ;*",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCC: sprintf(msg,"AND    %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCD: sprintf(msg,"XOR    %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCE: sprintf(msg,"OR     %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;
            case 0xCF: sprintf(msg,"CP     %s,%02Xh",xr8n[rom[dPC+1]],rom[dPC+3]); dPCl=4; break;

            case 0xD8: sprintf(msg,"CP     %s,0",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xD9: sprintf(msg,"CP     %s,1",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDA: sprintf(msg,"CP     %s,2",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDB: sprintf(msg,"CP     %s,3",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDC: sprintf(msg,"CP     %s,4",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDD: sprintf(msg,"CP     %s,5",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDE: sprintf(msg,"CP     %s,6",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xDF: sprintf(msg,"CP     %s,7",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE0: sprintf(msg,"OR     W,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE1: sprintf(msg,"OR     A,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE2: sprintf(msg,"OR     B,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE3: sprintf(msg,"OR     C,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE4: sprintf(msg,"OR     D,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE5: sprintf(msg,"OR     E,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE6: sprintf(msg,"OR     H,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xE7: sprintf(msg,"OR     L,%s",xr8n[rom[dPC+1]]); dPCl=3; break;

            case 0xEE: sprintf(msg,"SLL    %02Xh,%s ;*",rom[dPC+3],xr8n[rom[dPC+1]]); dPCl=4; break;

            case 0xF0: sprintf(msg,"CP     W,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF1: sprintf(msg,"CP     A,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF2: sprintf(msg,"CP     B,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF3: sprintf(msg,"CP     C,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF4: sprintf(msg,"CP     D,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF5: sprintf(msg,"CP     E,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF6: sprintf(msg,"CP     H,%s",xr8n[rom[dPC+1]]); dPCl=3; break;
            case 0xF7: sprintf(msg,"CP     L,%s",xr8n[rom[dPC+1]]); dPCl=3; break;

            default:   sprintf(msg,"reg.B r: %02Xh",rom[dPC+2]);
        }
    } /* reg.B r */

    else if ((madr.type==1) && (madr.lo==0x7)) { /* reg.W r */
        switch (rom[dPC+2]) {
            case 0x03: sprintf(msg,"LD     %s,%04Xh  ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0x04: sprintf(msg,"PUSH   %s  ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x05: sprintf(msg,"POP    %s  ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x06: sprintf(msg,"CPL    %s  ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x07: sprintf(msg,"NEG    %s  ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0x30: sprintf(msg,"RES    %d,%s ;*",rom[dPC+3], xr16n[rom[dPC+1]/2]); dPCl=4; break;
            case 0x31: sprintf(msg,"SET    %d,%s ;*",rom[dPC+3], xr16n[rom[dPC+1]/2]); dPCl=4; break;
            case 0x32: sprintf(msg,"CHG    %d,%s ;*",rom[dPC+3], xr16n[rom[dPC+1]/2]); dPCl=4; break;
            case 0x33: sprintf(msg,"BIT    %d,%s ;*",rom[dPC+3], xr16n[rom[dPC+1]/2]); dPCl=4; break;
            case 0x34: sprintf(msg,"TSET   %d,%s ;*",rom[dPC+3], xr16n[rom[dPC+1]/2]); dPCl=4; break;

            case 0x60: sprintf(msg,"INC    8,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x61: sprintf(msg,"INC    1,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x62: sprintf(msg,"INC    2,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x63: sprintf(msg,"INC    3,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x64: sprintf(msg,"INC    4,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x65: sprintf(msg,"INC    5,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x66: sprintf(msg,"INC    6,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x67: sprintf(msg,"INC    7,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x68: sprintf(msg,"DEC    8,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x69: sprintf(msg,"DEC    1,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6A: sprintf(msg,"DEC    2,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6B: sprintf(msg,"DEC    3,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6C: sprintf(msg,"DEC    4,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6D: sprintf(msg,"DEC    5,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6E: sprintf(msg,"DEC    6,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x6F: sprintf(msg,"DEC    7,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0x80: sprintf(msg,"ADD    WA,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x81: sprintf(msg,"ADD    BC,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x82: sprintf(msg,"ADD    DE,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x83: sprintf(msg,"ADD    HL,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x84: sprintf(msg,"ADD    IX,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x85: sprintf(msg,"ADD    IY,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x86: sprintf(msg,"ADD    IZ,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x87: sprintf(msg,"ADD    SP,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x88: sprintf(msg,"LD     WA,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x89: sprintf(msg,"LD     BC,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8A: sprintf(msg,"LD     DE,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8B: sprintf(msg,"LD     HL,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8C: sprintf(msg,"LD     IX,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8D: sprintf(msg,"LD     IY,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8E: sprintf(msg,"LD     IZ,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x8F: sprintf(msg,"LD     SP,%s",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0x98: sprintf(msg,"LD     %s,WA",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x99: sprintf(msg,"LD     %s,BC",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9A: sprintf(msg,"LD     %s,DE",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9B: sprintf(msg,"LD     %s,HL",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9C: sprintf(msg,"LD     %s,IX",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9D: sprintf(msg,"LD     %s,IY",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9E: sprintf(msg,"LD     %s,IZ",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0x9F: sprintf(msg,"LD     %s,SP",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0xA8: sprintf(msg,"LD     %s,0",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xA9: sprintf(msg,"LD     %s,1",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAA: sprintf(msg,"LD     %s,2",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAB: sprintf(msg,"LD     %s,3",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAC: sprintf(msg,"LD     %s,4",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAD: sprintf(msg,"LD     %s,5",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAE: sprintf(msg,"LD     %s,6",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xAF: sprintf(msg,"LD     %s,7",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0xC8: sprintf(msg,"ADD    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xC9: sprintf(msg,"ADC    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCA: sprintf(msg,"SUB    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCB: sprintf(msg,"SBC    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCC: sprintf(msg,"AND    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCD: sprintf(msg,"XOR    %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCE: sprintf(msg,"OR     %s,%04Xh ;*",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;
            case 0xCF: sprintf(msg,"CP     %s,%04Xh",xr16n[rom[dPC+1]/2],OpTmp16b); dPCl=5; break;

            case 0xD8: sprintf(msg,"CP     %s,0",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xD9: sprintf(msg,"CP     %s,1",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDA: sprintf(msg,"CP     %s,2",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDB: sprintf(msg,"CP     %s,3",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDC: sprintf(msg,"CP     %s,4",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDD: sprintf(msg,"CP     %s,5",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDE: sprintf(msg,"CP     %s,6",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xDF: sprintf(msg,"CP     %s,7",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            case 0xF0: sprintf(msg,"CP     WA,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF1: sprintf(msg,"CP     BC,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF2: sprintf(msg,"CP     DE,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF3: sprintf(msg,"CP     HL,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF4: sprintf(msg,"CP     IX,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF5: sprintf(msg,"CP     IY,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF6: sprintf(msg,"CP     IZ,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;
            case 0xF7: sprintf(msg,"CP     SP,%s ;*",xr16n[rom[dPC+1]/2]); dPCl=3; break;

            default:   sprintf(msg,"reg.W r: %02Xh",rom[dPC+2]);
        }
    } /* reg.W r */

    else if ((madr.type==2) && (madr.lo==0x7)) { /* reg.L r */
        switch (rom[dPC+2]) {
            case 0x03: sprintf(msg,"LD     %s,%08lXh",xr32n[rom[dPC+1]/4],OpTmp32c); dPCl=7; break;
            case 0x04: sprintf(msg,"PUSH   %s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x05: sprintf(msg,"POP    %s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;

            case 0x60: sprintf(msg,"INC    8,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x61: sprintf(msg,"INC    1,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x62: sprintf(msg,"INC    2,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x63: sprintf(msg,"INC    3,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x64: sprintf(msg,"INC    4,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x65: sprintf(msg,"INC    5,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x66: sprintf(msg,"INC    6,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x67: sprintf(msg,"INC    7,%s ;*",xr32n[rom[dPC+1]/4]); dPCl=3; break;

            case 0x98: sprintf(msg,"LD     %s,XWA",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x99: sprintf(msg,"LD     %s,XBC",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9A: sprintf(msg,"LD     %s,XDE",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9B: sprintf(msg,"LD     %s,XHL",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9C: sprintf(msg,"LD     %s,XIX",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9D: sprintf(msg,"LD     %s,XIY",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9E: sprintf(msg,"LD     %s,XIZ",xr32n[rom[dPC+1]/4]); dPCl=3; break;
            case 0x9F: sprintf(msg,"LD     %s,XSP",xr32n[rom[dPC+1]/4]); dPCl=3; break;

            case 0xC8: sprintf(msg,"ADD    %s,%08lXh ;*",xr32n[rom[dPC+1]/4],OpTmp32c); dPCl=7; break;

            default:   sprintf(msg,"reg.L r: %02Xh",rom[dPC+2]);
        }
    } /* reg.L r */

    else if (madr.type==0) { /* reg.B */
        OpTmp8s=rom[dPC+2];

        switch(rom[dPC+1]) {
            case 0x04: sprintf(msg,"PUSH   %s",rn8[radr.reg]); dPCl=2; break;
            case 0x05: sprintf(msg,"POP    %s",rn8[radr.reg]); dPCl=2; break;
            case 0x06: sprintf(msg,"CPL    %s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x07: sprintf(msg,"NEG    %s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x08: sprintf(msg,"MUL    %s,%02Xh",rn16[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0x09: sprintf(msg,"MULS   %s,%02Xh ;*",rn16[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0x0A: sprintf(msg,"DIV    %s,%02Xh ;*",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0x0B: sprintf(msg,"DIVS   %s,%02Xh ;*",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;

            case 0x10: sprintf(msg,"DAA    %s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x1C: sprintf(msg,"DJNZ   %s,%06lX",rn8[radr.reg],dPC+3+OpTmp8s); dPCl=3; break;

            case 0x20: sprintf(msg,"ANDCF  %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x21: sprintf(msg,"ORCF   %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x22: sprintf(msg,"XORCF  %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x23: sprintf(msg,"LDCF   %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x24: sprintf(msg,"STCF   %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;

            case 0x28: sprintf(msg,"ANDCF  A,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x29: sprintf(msg,"ORCF   A,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x2A: sprintf(msg,"XORCF  A,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x2B: sprintf(msg,"LDCF   A,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x2C: sprintf(msg,"STCF   A,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x30: sprintf(msg,"RES    %d,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x31: sprintf(msg,"SET    %d,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x32: sprintf(msg,"CHG    %d,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x33: sprintf(msg,"BIT    %d,%s",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0x34: sprintf(msg,"TSET   %d,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;

            case 0x40: sprintf(msg,"MUL    WA,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x41: sprintf(msg,"MUL    BC,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x42: sprintf(msg,"MUL    DE,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x43: sprintf(msg,"MUL    HL,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x48: sprintf(msg,"MULS   WA,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x49: sprintf(msg,"MULS   BC,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x4A: sprintf(msg,"MULS   DE,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x4B: sprintf(msg,"MULS   HL,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x50: sprintf(msg,"DIV    WA,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x51: sprintf(msg,"DIV    BC,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x52: sprintf(msg,"DIV    DE,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x53: sprintf(msg,"DIV    HL,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x58: sprintf(msg,"DIV    WA,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x59: sprintf(msg,"DIV    BC,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x5A: sprintf(msg,"DIV    DE,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x5B: sprintf(msg,"DIV    HL,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x60: sprintf(msg,"INC    8,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x61: sprintf(msg,"INC    1,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x62: sprintf(msg,"INC    2,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x63: sprintf(msg,"INC    3,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x64: sprintf(msg,"INC    4,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x65: sprintf(msg,"INC    5,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x66: sprintf(msg,"INC    6,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x67: sprintf(msg,"INC    7,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x68: sprintf(msg,"DEC    8,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x69: sprintf(msg,"DEC    1,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6A: sprintf(msg,"DEC    2,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6B: sprintf(msg,"DEC    3,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6C: sprintf(msg,"DEC    4,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6D: sprintf(msg,"DEC    5,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6E: sprintf(msg,"DEC    6,%s ;*",rn8[radr.reg]); dPCl=2; break;
            case 0x6F: sprintf(msg,"DEC    7,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x79: sprintf(msg,"SCC    GE,%s ;*",rn8[radr.reg]); dPCl=2; break;

            case 0x7E: sprintf(msg,"SCC    NZ,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x7F: sprintf(msg,"SCC    NC,%s",rn8[radr.reg]); dPCl=2; break;

            case 0x80: sprintf(msg,"ADD    W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x81: sprintf(msg,"ADD    A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x82: sprintf(msg,"ADD    B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x83: sprintf(msg,"ADD    C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x84: sprintf(msg,"ADD    D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x85: sprintf(msg,"ADD    E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x86: sprintf(msg,"ADD    H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x87: sprintf(msg,"ADD    L,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x88: sprintf(msg,"LD     W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x89: sprintf(msg,"LD     A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8A: sprintf(msg,"LD     B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8B: sprintf(msg,"LD     C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8C: sprintf(msg,"LD     D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8D: sprintf(msg,"LD     E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8E: sprintf(msg,"LD     H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0x8F: sprintf(msg,"LD     L,%s",rn8[radr.reg]); dPCl=2; break;

            case 0xA0: sprintf(msg,"SUB    W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA1: sprintf(msg,"SUB    A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA2: sprintf(msg,"SUB    B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA3: sprintf(msg,"SUB    C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA4: sprintf(msg,"SUB    D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA5: sprintf(msg,"SUB    E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA6: sprintf(msg,"SUB    H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xA7: sprintf(msg,"SUB    L,%s",rn8[radr.reg]); dPCl=2; break;

            case 0xC0: sprintf(msg,"AND    W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC1: sprintf(msg,"AND    A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC2: sprintf(msg,"AND    B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC3: sprintf(msg,"AND    C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC4: sprintf(msg,"AND    D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC5: sprintf(msg,"AND    E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC6: sprintf(msg,"AND    H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC7: sprintf(msg,"AND    L,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xC8: sprintf(msg,"ADD    %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xC9: sprintf(msg,"ADC    %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCA: sprintf(msg,"SUB    %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCB: sprintf(msg,"SBC    %s,%02Xh ;*",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCC: sprintf(msg,"AND    %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCD: sprintf(msg,"XOR    %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCE: sprintf(msg,"OR     %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xCF: sprintf(msg,"CP     %s,%02Xh",rn8[radr.reg],rom[dPC+2]); dPCl=3; break;
            case 0xD0: sprintf(msg,"XOR    W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD1: sprintf(msg,"XOR    A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD2: sprintf(msg,"XOR    B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD3: sprintf(msg,"XOR    C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD4: sprintf(msg,"XOR    D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD5: sprintf(msg,"XOR    E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD6: sprintf(msg,"XOR    H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD7: sprintf(msg,"XOR    L,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xD8: sprintf(msg,"CP     %s,0",rn8[radr.reg]); dPCl=2; break;
            case 0xD9: sprintf(msg,"CP     %s,1",rn8[radr.reg]); dPCl=2; break;
            case 0xDA: sprintf(msg,"CP     %s,2",rn8[radr.reg]); dPCl=2; break;
            case 0xDB: sprintf(msg,"CP     %s,3",rn8[radr.reg]); dPCl=2; break;
            case 0xDC: sprintf(msg,"CP     %s,4",rn8[radr.reg]); dPCl=2; break;
            case 0xDD: sprintf(msg,"CP     %s,5",rn8[radr.reg]); dPCl=2; break;
            case 0xDE: sprintf(msg,"CP     %s,6",rn8[radr.reg]); dPCl=2; break;
            case 0xDF: sprintf(msg,"CP     %s,7",rn8[radr.reg]); dPCl=2; break;
            case 0xE0: sprintf(msg,"OR     W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE1: sprintf(msg,"OR     A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE2: sprintf(msg,"OR     B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE3: sprintf(msg,"OR     C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE4: sprintf(msg,"OR     D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE5: sprintf(msg,"OR     E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE6: sprintf(msg,"OR     H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE7: sprintf(msg,"OR     L,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xE8: sprintf(msg,"RLC    %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xE9: sprintf(msg,"RRC    %02Xh,%s",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xEA: sprintf(msg,"RL     %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xEB: sprintf(msg,"RR     %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xEC: sprintf(msg,"SLA    %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xED: sprintf(msg,"SRA    %02Xh,%s ;*",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xEE: sprintf(msg,"SLL    %d,%s",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xEF: sprintf(msg,"SRL    %d,%s",rom[dPC+2],rn8[radr.reg]); dPCl=3; break;
            case 0xF0: sprintf(msg,"CP     W,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF1: sprintf(msg,"CP     A,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF2: sprintf(msg,"CP     B,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF3: sprintf(msg,"CP     C,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF4: sprintf(msg,"CP     D,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF5: sprintf(msg,"CP     E,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF6: sprintf(msg,"CP     H,%s",rn8[radr.reg]); dPCl=2; break;
            case 0xF7: sprintf(msg,"CP     L,%s",rn8[radr.reg]); dPCl=2; break;

            default:   sprintf(msg,"reg.B %s: %02Xh",rn8[radr.reg],rom[dPC+1]);
        }
    } /* reg.B */

    else if (madr.type==1) { /* reg.W */
        OpTmp8s=rom[dPC+2];

        switch (rom[dPC+1]) {
            case 0x06: sprintf(msg,"CPL    %s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x07: sprintf(msg,"NEG    %s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x08: sprintf(msg,"MUL    %s,%04Xh",rn32[radr.reg],OpTmp16); dPCl=4; break;
            case 0x09: sprintf(msg,"MULS   %s,%04Xh ;*",rn32[radr.reg],OpTmp16); dPCl=4; break;
            case 0x0A: sprintf(msg,"DIV    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0x0B: sprintf(msg,"DIVS   %s,%04Xh ;*",rn16[radr.reg],OpTmp16); dPCl=4; break;

            case 0x12: sprintf(msg,"EXTZ   %s",rn16[radr.reg]); dPCl=2; break;
            case 0x13: sprintf(msg,"EXTS   %s",rn16[radr.reg]); dPCl=2; break;

            case 0x1C: sprintf(msg,"DJNZ   %s,%06lX",rn16[radr.reg],dPC+3+OpTmp8s); dPCl=3; break;

            case 0x2E: sprintf(msg,"LDC    %s,%s ;*",cr16n[rom[dPC+2]/2],rn16[radr.reg]); dPCl=3; break;
            case 0x2F: sprintf(msg,"LDC    %s,%s ;*",rn16[radr.reg],cr16n[rom[dPC+2]/2]); dPCl=3; break;


            case 0x30: sprintf(msg,"RES    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0x31: sprintf(msg,"SET    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0x32: sprintf(msg,"CHG    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0x33: sprintf(msg,"BIT    %d,%s",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0x34: sprintf(msg,"TSET   %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;

            case 0x40: sprintf(msg,"MUL    XWA,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x41: sprintf(msg,"MUL    XBC,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x42: sprintf(msg,"MUL    XDE,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x43: sprintf(msg,"MUL    XHL,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x44: sprintf(msg,"MUL    XIX,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x45: sprintf(msg,"MUL    XIY,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x46: sprintf(msg,"MUL    XIZ,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x47: sprintf(msg,"MUL    XSP,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x48: sprintf(msg,"MULS   XWA,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x49: sprintf(msg,"MULS   XBC,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4A: sprintf(msg,"MULS   XDE,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4B: sprintf(msg,"MULS   XHL,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4C: sprintf(msg,"MULS   XIX,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4D: sprintf(msg,"MULS   XIY,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4E: sprintf(msg,"MULS   XIZ,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x4F: sprintf(msg,"MULS   XSP,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x50: sprintf(msg,"DIV    XWA,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x51: sprintf(msg,"DIV    XBC,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x52: sprintf(msg,"DIV    XDE,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x53: sprintf(msg,"DIV    XHL,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x54: sprintf(msg,"DIV    XIX,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x55: sprintf(msg,"DIV    XIY,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x56: sprintf(msg,"DIV    XIZ,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x57: sprintf(msg,"DIV    XSP,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x58: sprintf(msg,"DIVS   XWA,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x59: sprintf(msg,"DIVS   XBC,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5A: sprintf(msg,"DIVS   XDE,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5B: sprintf(msg,"DIVS   XHL,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5C: sprintf(msg,"DIVS   XIX,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5D: sprintf(msg,"DIVS   XIY,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5E: sprintf(msg,"DIVS   XIZ,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x5F: sprintf(msg,"DIVS   XSP,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0x60: sprintf(msg,"INC    8,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x61: sprintf(msg,"INC    1,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x62: sprintf(msg,"INC    2,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x63: sprintf(msg,"INC    3,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x64: sprintf(msg,"INC    4,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x65: sprintf(msg,"INC    5,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x66: sprintf(msg,"INC    6,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x67: sprintf(msg,"INC    7,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x68: sprintf(msg,"DEC    8,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x69: sprintf(msg,"DEC    1,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6A: sprintf(msg,"DEC    2,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6B: sprintf(msg,"DEC    3,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6C: sprintf(msg,"DEC    4,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6D: sprintf(msg,"DEC    5,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6E: sprintf(msg,"DEC    6,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x6F: sprintf(msg,"DEC    7,%s",rn16[radr.reg]); dPCl=2; break;

            case 0x80: sprintf(msg,"ADD    WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x81: sprintf(msg,"ADD    BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x82: sprintf(msg,"ADD    DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x83: sprintf(msg,"ADD    HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x84: sprintf(msg,"ADD    IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x85: sprintf(msg,"ADD    IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x86: sprintf(msg,"ADD    IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x87: sprintf(msg,"ADD    SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x88: sprintf(msg,"LD     WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x89: sprintf(msg,"LD     BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8A: sprintf(msg,"LD     DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8B: sprintf(msg,"LD     HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8C: sprintf(msg,"LD     IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8D: sprintf(msg,"LD     IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8E: sprintf(msg,"LD     IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0x8F: sprintf(msg,"LD     SP,%s",rn16[radr.reg]); dPCl=2; break;

            case 0xA0: sprintf(msg,"SUB    WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA1: sprintf(msg,"SUB    BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA2: sprintf(msg,"SUB    DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA3: sprintf(msg,"SUB    HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA4: sprintf(msg,"SUB    IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA5: sprintf(msg,"SUB    IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA6: sprintf(msg,"SUB    IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA7: sprintf(msg,"SUB    SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xA8: sprintf(msg,"LD     %s,0",rn16[radr.reg]); dPCl=2; break;
            case 0xA9: sprintf(msg,"LD     %s,1",rn16[radr.reg]); dPCl=2; break;
            case 0xAA: sprintf(msg,"LD     %s,2",rn16[radr.reg]); dPCl=2; break;
            case 0xAB: sprintf(msg,"LD     %s,3",rn16[radr.reg]); dPCl=2; break;
            case 0xAC: sprintf(msg,"LD     %s,4",rn16[radr.reg]); dPCl=2; break;
            case 0xAD: sprintf(msg,"LD     %s,5",rn16[radr.reg]); dPCl=2; break;
            case 0xAE: sprintf(msg,"LD     %s,6",rn16[radr.reg]); dPCl=2; break;
            case 0xAF: sprintf(msg,"LD     %s,7",rn16[radr.reg]); dPCl=2; break;       
            case 0xB0: sprintf(msg,"SBC    WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB1: sprintf(msg,"SBC    BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB2: sprintf(msg,"SBC    DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB3: sprintf(msg,"SBC    HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB4: sprintf(msg,"SBC    IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB5: sprintf(msg,"SBC    IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB6: sprintf(msg,"SBC    IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB7: sprintf(msg,"SBC    SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xB8: sprintf(msg,"EX     WA,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xB9: sprintf(msg,"EX     BC,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBA: sprintf(msg,"EX     DE,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBB: sprintf(msg,"EX     HL,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBC: sprintf(msg,"EX     IX,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBD: sprintf(msg,"EX     IY,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBE: sprintf(msg,"EX     IZ,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xBF: sprintf(msg,"EX     SP,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xC0: sprintf(msg,"AND    WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC1: sprintf(msg,"AND    BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC2: sprintf(msg,"AND    DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC3: sprintf(msg,"AND    HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC4: sprintf(msg,"AND    IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC5: sprintf(msg,"AND    IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC6: sprintf(msg,"AND    IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC7: sprintf(msg,"AND    SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xC8: sprintf(msg,"ADD    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xC9: sprintf(msg,"ADC    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCA: sprintf(msg,"SUB    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCB: sprintf(msg,"SBC    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCC: sprintf(msg,"AND    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCD: sprintf(msg,"XOR    %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCE: sprintf(msg,"OR     %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xCF: sprintf(msg,"CP     %s,%04Xh",rn16[radr.reg],OpTmp16); dPCl=4; break;
            case 0xD0: sprintf(msg,"XOR    WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD1: sprintf(msg,"XOR    BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD2: sprintf(msg,"XOR    DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD3: sprintf(msg,"XOR    HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD4: sprintf(msg,"XOR    IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD5: sprintf(msg,"XOR    IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD6: sprintf(msg,"XOR    IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD7: sprintf(msg,"XOR    SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xD8: sprintf(msg,"CP     %s,0",rn16[radr.reg]); dPCl=2; break;
            case 0xD9: sprintf(msg,"CP     %s,1",rn16[radr.reg]); dPCl=2; break;
            case 0xDA: sprintf(msg,"CP     %s,2",rn16[radr.reg]); dPCl=2; break;
            case 0xDB: sprintf(msg,"CP     %s,3",rn16[radr.reg]); dPCl=2; break;
            case 0xDC: sprintf(msg,"CP     %s,4",rn16[radr.reg]); dPCl=2; break;
            case 0xDD: sprintf(msg,"CP     %s,5",rn16[radr.reg]); dPCl=2; break;
            case 0xDE: sprintf(msg,"CP     %s,6",rn16[radr.reg]); dPCl=2; break;
            case 0xDF: sprintf(msg,"CP     %s,7",rn16[radr.reg]); dPCl=2; break;
            case 0xE0: sprintf(msg,"OR     WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE1: sprintf(msg,"OR     BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE2: sprintf(msg,"OR     DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE3: sprintf(msg,"OR     HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE4: sprintf(msg,"OR     IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE5: sprintf(msg,"OR     IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE6: sprintf(msg,"OR     IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE7: sprintf(msg,"OR     SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xE8: sprintf(msg,"RLC    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xE9: sprintf(msg,"RRC    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xEA: sprintf(msg,"RL     %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xEB: sprintf(msg,"RR     %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xEC: sprintf(msg,"SLA    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xED: sprintf(msg,"SRA    %d,%s ;*",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xEE: sprintf(msg,"SLL    %d,%s",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xEF: sprintf(msg,"SRL    %d,%s",rom[dPC+2],rn16[radr.reg]); dPCl=3; break;
            case 0xF0: sprintf(msg,"CP     WA,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF1: sprintf(msg,"CP     BC,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF2: sprintf(msg,"CP     DE,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF3: sprintf(msg,"CP     HL,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF4: sprintf(msg,"CP     IX,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF5: sprintf(msg,"CP     IY,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF6: sprintf(msg,"CP     IZ,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF7: sprintf(msg,"CP     SP,%s",rn16[radr.reg]); dPCl=2; break;
            case 0xF8: sprintf(msg,"RLC    A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xF9: sprintf(msg,"RRC    A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFA: sprintf(msg,"RL     A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFB: sprintf(msg,"RR     A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFC: sprintf(msg,"SLA    A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFD: sprintf(msg,"SRA    A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFE: sprintf(msg,"SLL    A,%s ;*",rn16[radr.reg]); dPCl=2; break;
            case 0xFF: sprintf(msg,"SRL    A,%s ;*",rn16[radr.reg]); dPCl=2; break;

            default:   sprintf(msg,"reg.W %s: %02Xh",rn16[radr.reg],rom[dPC+1]);
        }
    } /* reg.W */

    else if (madr.type==2) { /* reg.L */
        switch (rom[dPC+1]) {
            case 0x03: sprintf(msg,"LD     %s,%08lXh ;*",rn32[radr.reg],OpTmp32b); dPCl=6; break;
            case 0x04: sprintf(msg,"PUSH   %s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0x05: sprintf(msg,"POP    %s ;*",rn32[radr.reg]); dPCl=2; break;

            case 0x12: sprintf(msg,"EXTZ   %s",rn32[radr.reg]); dPCl=2; break;
            case 0x13: sprintf(msg,"EXTS   %s ;*",rn32[radr.reg]); dPCl=2; break;

            case 0x60: sprintf(msg,"INC    8,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x61: sprintf(msg,"INC    1,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x62: sprintf(msg,"INC    2,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x63: sprintf(msg,"INC    3,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x64: sprintf(msg,"INC    4,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x65: sprintf(msg,"INC    5,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x66: sprintf(msg,"INC    6,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x67: sprintf(msg,"INC    7,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x68: sprintf(msg,"DEC    0,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x69: sprintf(msg,"DEC    1,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6A: sprintf(msg,"DEC    2,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6B: sprintf(msg,"DEC    3,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6C: sprintf(msg,"DEC    4,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6D: sprintf(msg,"DEC    5,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6E: sprintf(msg,"DEC    6,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x6F: sprintf(msg,"DEC    7,%s",rn32[radr.reg]); dPCl=2; break;

            case 0x80: sprintf(msg,"ADD    XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x81: sprintf(msg,"ADD    XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x82: sprintf(msg,"ADD    XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x83: sprintf(msg,"ADD    XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x84: sprintf(msg,"ADD    XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x85: sprintf(msg,"ADD    XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x86: sprintf(msg,"ADD    XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x87: sprintf(msg,"ADD    XSP,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x88: sprintf(msg,"LD     XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x89: sprintf(msg,"LD     XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8A: sprintf(msg,"LD     XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8B: sprintf(msg,"LD     XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8C: sprintf(msg,"LD     XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8D: sprintf(msg,"LD     XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8E: sprintf(msg,"LD     XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0x8F: sprintf(msg,"LD     XSP,%s",rn32[radr.reg]); dPCl=2; break;

            case 0xA0: sprintf(msg,"SUB    XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA1: sprintf(msg,"SUB    XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA2: sprintf(msg,"SUB    XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA3: sprintf(msg,"SUB    XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA4: sprintf(msg,"SUB    XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA5: sprintf(msg,"SUB    XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA6: sprintf(msg,"SUB    XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA7: sprintf(msg,"SUB    XSP,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xA8: sprintf(msg,"LD     %s,0",rn32[radr.reg]); dPCl=2; break;
            case 0xA9: sprintf(msg,"LD     %s,1",rn32[radr.reg]); dPCl=2; break;
            case 0xAA: sprintf(msg,"LD     %s,2",rn32[radr.reg]); dPCl=2; break;
            case 0xAB: sprintf(msg,"LD     %s,3",rn32[radr.reg]); dPCl=2; break;
            case 0xAC: sprintf(msg,"LD     %s,4",rn32[radr.reg]); dPCl=2; break;
            case 0xAD: sprintf(msg,"LD     %s,5",rn32[radr.reg]); dPCl=2; break;
            case 0xAE: sprintf(msg,"LD     %s,6",rn32[radr.reg]); dPCl=2; break;
            case 0xAF: sprintf(msg,"LD     %s,7",rn32[radr.reg]); dPCl=2; break;

            case 0xC0: sprintf(msg,"AND    XWA,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC1: sprintf(msg,"AND    XBC,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC2: sprintf(msg,"AND    XDE,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC3: sprintf(msg,"AND    XHL,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC4: sprintf(msg,"AND    XIX,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC5: sprintf(msg,"AND    XIY,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC6: sprintf(msg,"AND    XIZ,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC7: sprintf(msg,"AND    XSP,%s ;*",rn32[radr.reg]); dPCl=2; break;
            case 0xC8: sprintf(msg,"ADD    %s,%08lXh",rn32[radr.reg],OpTmp32b); dPCl=6; break;

            case 0xCA: sprintf(msg,"SUB    %s,%08lXh",rn32[radr.reg],OpTmp32b); dPCl=6; break;

            case 0xCC: sprintf(msg,"AND    %s,%08lXh ;*",rn32[radr.reg],OpTmp32b); dPCl=6; break;
            case 0xCD: sprintf(msg,"XOR    %s,%08lXh ;*",rn32[radr.reg],OpTmp32b); dPCl=6; break;
            case 0xCE: sprintf(msg,"OR     %s,%08lXh ;*",rn32[radr.reg],OpTmp32b); dPCl=6; break;
            case 0xCF: sprintf(msg,"CP     %s,%08lXh",rn32[radr.reg],OpTmp32b); dPCl=6; break;
            case 0xD0: sprintf(msg,"XOR    XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD1: sprintf(msg,"XOR    XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD2: sprintf(msg,"XOR    XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD3: sprintf(msg,"XOR    XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD4: sprintf(msg,"XOR    XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD5: sprintf(msg,"XOR    XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD6: sprintf(msg,"XOR    XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xD7: sprintf(msg,"XOR    XSP,%s",rn32[radr.reg]); dPCl=2; break;

            case 0xE0: sprintf(msg,"OR     XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE1: sprintf(msg,"OR     XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE2: sprintf(msg,"OR     XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE3: sprintf(msg,"OR     XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE4: sprintf(msg,"OR     XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE5: sprintf(msg,"OR     XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE6: sprintf(msg,"OR     XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE7: sprintf(msg,"OR     XSP,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xE8: sprintf(msg,"RLC    %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xE9: sprintf(msg,"RRC    %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xEA: sprintf(msg,"RL     %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xEB: sprintf(msg,"RR     %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xEC: sprintf(msg,"SLA    %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xED: sprintf(msg,"SRA    %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xEE: sprintf(msg,"SLL    %d,%s ;*",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xEF: sprintf(msg,"SRL    %d,%s",rom[dPC+2],rn32[radr.reg]); dPCl=3; break;
            case 0xF0: sprintf(msg,"CP     XWA,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF1: sprintf(msg,"CP     XBC,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF2: sprintf(msg,"CP     XDE,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF3: sprintf(msg,"CP     XHL,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF4: sprintf(msg,"CP     XIX,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF5: sprintf(msg,"CP     XIY,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF6: sprintf(msg,"CP     XIZ,%s",rn32[radr.reg]); dPCl=2; break;
            case 0xF7: sprintf(msg,"CP     XSP,%s",rn32[radr.reg]); dPCl=2; break;

            default:   sprintf(msg,"reg.L %s: %02Xh",rn32[radr.reg],rom[dPC+1]);
        }
    } /* reg.L */

    else {
        sprintf(msg,"invalid instruction");
    }

} /* dis900h(char *msg) */
