DECLARE FUNCTION SUBchop$ (txt$)
DECLARE FUNCTION ADDchop$ (txt$)
DECLARE FUNCTION chkequ$ (txt$)
DECLARE FUNCTION frombin% (txt$)
DECLARE FUNCTION getsize2$ (txt$, frm%)
DECLARE FUNCTION getnum$ (txt$)
DECLARE SUB ErrorMsg (num%, param$)
DECLARE SUB Pass1 ()
DECLARE SUB Pass2 ()
DECLARE SUB stuff (dat$)
DECLARE FUNCTION getval& (txt$)
DECLARE FUNCTION tostring$ (txt$)
DECLARE FUNCTION val2str$ (txt$, size%)
DECLARE FUNCTION LDchop$ (txt$)
DECLARE FUNCTION getsize% (txt$)
DEFINT A-Z

DIM SHARED AsmFile$, OutFile$, Pass1File$

DIM SHARED code$, whole$
DIM SHARED curline   ' tells what line number current one is. for errors
DIM SHARED baseptr&   ' points to current point in assembly
DIM SHARED equ$(5000), equv$(5000), equc
DIM SHARED errcnt


AsmFile$ = "test3.asm"
OutFile$ = "test3.ngp"


Pass1File$ = "pass1xxx.tmp"


CLS

'make sure outfile dont exist:
OPEN OutFile$ FOR BINARY AS #1  'creates a empty file if not exist
CLOSE #1
KILL OutFile$                   'kills the file



OPEN OutFile$ FOR BINARY AS #9


PRINT "Pass 1 - "
Pass1   'Preliminary parsing of AsmFile$




PRINT "Pass 2 - "
Pass2   'Writing encoded instructions





KILL Pass1File$

CLOSE #9

IF errcnt THEN
    PRINT errcnt; "error(s) occured, no output written."
    KILL OutFile$
ELSE

    PRINT OutFile$; " written."
END IF

FUNCTION ADDchop$ (txt$)

    'txt$ contains 2 parts separated by a ,


    a = INSTR(txt$, ",")
    IF a = 0 THEN
        PRINT "ADDchop ERROR: "; txt$
        EXIT FUNCTION
    END IF


    d1$ = MID$(txt$, 1, a - 1)
    d2$ = MID$(txt$, a + 1)

    size = getsize(d1$)     '1=b,2=w,4=l
    size2$ = getsize2(d1$, 2)

    num$ = getnum$(d1$)   '0-7 for var num

    par1& = getval(d2$)           'makes parameter to data
    par2$ = val2str$(d2$, size)


    'ADD r,#
    '
    '11zz1RRR
    '11001000 (C8)

    'finish up
    fin$ = "11" + size2$ + "1" + num$
    
    ADDchop$ = CHR$(frombin(fin$)) + CHR$(&HC8) + par2$


END FUNCTION

FUNCTION chkequ$ (txt$)

    'checks txt$ for EQU's and replaces all occurences


    xxx = 0
    FOR a = 0 TO equc - 1
        b = INSTR(txt$, equ$(a))

        IF b THEN
            'found a EQU :-)
            c$ = MID$(txt$, 1, b - 1)
            d$ = MID$(txt$, b + LEN(equ$(a)))

            done$ = c$ + equv$(a) + d$
            xxx = 1
        END IF

    NEXT a

    IF xxx = 0 THEN
        done$ = txt$
    END IF


    chkequ$ = done$


END FUNCTION

SUB ErrorMsg (num, param$)

    PRINT "err("; LTRIM$(STR$(curline)); ") c"; LTRIM$(STR$(num)); ": ";

    SELECT CASE num:
        CASE 1000: PRINT "Unknown instruction '"; param$; "'"
        
    END SELECT


    errcnt = errcnt + 1

END SUB

FUNCTION frombin (txt$)

   dum = 1: svar = 0
   FOR cca = LEN(txt$) TO 1 STEP -1
       tmp$ = MID$(txt$, cca, 1)
       IF tmp$ = "1" THEN svar = svar + dum
       dum = dum * 2
   NEXT
   frombin = svar

END FUNCTION

FUNCTION getnum$ (txt$)

    sel$ = LTRIM$(RTRIM$(txt$))

    SELECT CASE sel$
        CASE "W": jao$ = "000"
        CASE "A": jao$ = "001"
        CASE "B": jao$ = "010"
        CASE "C": jao$ = "011"
        CASE "D": jao$ = "100"
        CASE "E": jao$ = "101"
        CASE "H": jao$ = "110"
        CASE "L": jao$ = "111"

        CASE "WA": jao$ = "000"
        CASE "BC": jao$ = "001"
        CASE "DE": jao$ = "010"
        CASE "HL": jao$ = "011"
        CASE "IX": jao$ = "100"
        CASE "IY": jao$ = "101"
        CASE "IZ": jao$ = "110"
        CASE "SP": jao$ = "111"

        CASE "XWA": jao$ = "000"
        CASE "XBC": jao$ = "001"
        CASE "XDE": jao$ = "010"
        CASE "XHL": jao$ = "011"
        CASE "XIX": jao$ = "100"
        CASE "XIY": jao$ = "101"
        CASE "XIZ": jao$ = "110"
        CASE "XSP": jao$ = "111"

        CASE ELSE: PRINT "GETNUM ERROR - "; whole$

    END SELECT

    getnum$ = jao$

END FUNCTION

FUNCTION getsize (txt$)

    'returns 0 for byte variable, 1 for word, 2 for lword.


    sel$ = LTRIM$(RTRIM$(txt$))
    SELECT CASE sel$
        CASE "W", "A", "B", "C", "D", "E", "H", "L": jao = 1
        CASE "WA", "BC", "DE", "HL", "IX", "IY", "IZ", "SP": jao = 2
        CASE "XWA", "XBC", "XDE", "XHL", "XIX", "XIY", "XIZ", "XSP": jao = 4
        CASE ELSE:
            PRINT "GETSIZE ERROR - "; whole$
    END SELECT

    getsize = jao


END FUNCTION

FUNCTION getsize2$ (txt$, frm)

    'frm = 1 means "0", "1"
    '    = 2 means "00","01","10"
    '    = 3 means "010","011","100"


    sel$ = LTRIM$(RTRIM$(txt$))
    SELECT CASE sel$
        CASE "W", "A", "B", "C", "D", "E", "H", "L":
            IF frm = 1 THEN jao$ = "0"
            IF frm = 2 THEN jao$ = "00"
            IF frm = 3 THEN jao$ = "010"

        CASE "WA", "BC", "DE", "HL", "IX", "IY", "IZ", "SP":
            IF frm = 1 THEN jao$ = "1"
            IF frm = 2 THEN jao$ = "01"
            IF frm = 3 THEN jao$ = "011"
            

        CASE "XWA", "XBC", "XDE", "XHL", "XIX", "XIY", "XIZ", "XSP":
            IF frm = 1 THEN PRINT "GETSIZE2 ERR - BAJS "; txt$
            IF frm = 2 THEN jao$ = "10"
            IF frm = 3 THEN jao$ = "100"


        CASE ELSE:
            PRINT "GETSIZE2 ERROR - "; whole$

    END SELECT

    getsize2$ = jao$


END FUNCTION

FUNCTION getval& (txt$)

    'converting something to a value :)
    

    txt$ = LTRIM$(RTRIM$(txt$))
    
    IF UCASE$(RIGHT$(txt$, 1)) = "H" THEN
        gtmp$ = MID$(txt$, 1, LEN(txt$) - 1)

        final& = VAL("&H00" + gtmp$)

    ELSE
        xtmp1 = VAL(txt$)
        xtmp2$ = LTRIM$(RTRIM$(STR$(xtmp1)))
        IF txt$ <> xtmp2$ THEN
            PRINT "GETVAL ERROR: "; txt$
        ELSE
            'this is a decimal number
            final& = xtmp1
        END IF
    END IF


    getval& = final&


END FUNCTION

FUNCTION LDchop$ (txt$)
    'txt$ contains 2 parts separated by a ,


    a = INSTR(txt$, ",")
    IF a = 0 THEN
        PRINT "LDchop ERROR: "; txt$
        EXIT FUNCTION
    END IF


    d1$ = MID$(txt$, 1, a - 1)
    d2$ = MID$(txt$, a + 1)
    
    size = getsize(d1$)     '1=b,2=w,4=l
    size2$ = getsize2(d1$, 3)

    num$ = getnum$(d1$)   '0-7 for var num

    par2$ = val2str$(d2$, size)
    

    'PRINT size, num, d1$, d2$, par2$


    'LD R,#'
    '
    '0zzz0RRR
    '

    'finish up
    fin$ = "0" + size2$ + "0" + num$
    LDchop$ = CHR$(frombin(fin$)) + par2$
    

END FUNCTION

SUB Pass1


    'Pass 1:
    '  - Removes comments ;
    '  - Removes empty lines
    '  - Picks out EQU's and stores them somewhere else
    '  - Rewrites infile to a temporarley file
    '    with parsed text and line numbers added.
    

    OPEN Pass1File$ FOR OUTPUT AS #1

        lcnt = 0
        OPEN AsmFile$ FOR INPUT AS #2
            DO WHILE NOT EOF(2)
                lcnt = lcnt + 1
                LINE INPUT #2, tmp$

                'removes ;
                a = INSTR(tmp$, ";")
                IF a THEN tmp$ = MID$(tmp$, 1, a - 1)

                'ignores empty lines
                tmp$ = RTRIM$(LTRIM$(tmp$))
                IF tmp$ <> "" THEN

                    'picks out EQU's
                    a = INSTR(tmp$, " ")
                    k2$ = ""
                    IF a THEN
                        k1$ = RTRIM$(LTRIM$(MID$(tmp$, 1, a - 1)))
                        k2b$ = RTRIM$(LTRIM$(MID$(tmp$, a + 1)))
                        a = INSTR(k2b$, " ")
                        IF a THEN k2$ = MID$(k2b$, 1, a - 1)

                        IF UCASE$(k2$) = "EQU" THEN
                            'stores EQU line into array
                            equ$(equc) = k1$
                            equv$(equc) = LTRIM$(RTRIM$(MID$(k2b$, a + 1)))
                            equc = equc + 1
                        END IF
                    END IF
                    

                    IF UCASE$(k2$) <> "EQU" THEN
                        'writes parsed stuff to temp file
                        tmp$ = LTRIM$(STR$(lcnt)) + " " + tmp$

                        'checks current line for existing EQU
                        tmp$ = chkequ$(tmp$)
                    
                        PRINT #1, tmp$
                    END IF
                    
                END IF
            LOOP
        CLOSE #2

    CLOSE #1


END SUB

SUB Pass2


    ' Pass 2 - Encodes instructions to outfile


    OPEN Pass1File$ FOR INPUT AS #1

        DO WHILE NOT EOF(1)

            LINE INPUT #1, tmp$

            whole$ = tmp$
            a = INSTR(tmp$, " ")
            curline = VAL(MID$(tmp$, 1, a))
            code$ = MID$(tmp$, a + 1)

            a = INSTR(code$, " ")
            IF a THEN
                comm$ = LTRIM$(RTRIM$(MID$(code$, 1, a)))
                pars$ = LTRIM$(MID$(code$, a))
            ELSE
                comm$ = code$
            END IF

            SELECT CASE UCASE$(comm$)
                CASE ".BASE":   'set BASE :)
                    baseptr& = getval(pars$)

                CASE "DB":      'BYTE DATA
                    done$ = tostring(pars$)
                    stuff done$

                CASE "DW":      'WORD DATA
                    done$ = val2str$(pars$, 2)
                    stuff done$

                CASE "DL":      'LONG DATA
                    done$ = val2str$(pars$, 4)
                    stuff done$

                CASE "LD":      'LD instr
                    done$ = LDchop$(UCASE$(pars$))
                    stuff done$

                CASE "ADD":     'ADD instr
                    done$ = ADDchop$(UCASE$(pars$))
                    stuff done$

                CASE "SUB":     'SUB instr
                    done$ = SUBchop$(UCASE$(pars$))
                    stuff done$


                CASE "LDF":     'LD rpf
                    temp = getval(pars$)
                    done$ = CHR$(&H17) + CHR$(temp)
                    stuff done$

                CASE "INCF":    'rpf++
                    done$ = CHR$(&HC)
                    stuff done$

                CASE "DECF":    'rpf--
                    done$ = CHR$(&HD)
                    stuff done$

                CASE "NOP":
                    done$ = CHR$(&H0)
                    stuff done$

                CASE "RET":
                    done$ = CHR$(&HE)
                    stuff done$

                CASE "RCF":
                    done$ = CHR$(&H10)
                    stuff done$

                CASE "SCF":
                    done$ = CHR$(&H11)
                    stuff done$

                CASE "CCF":
                    done$ = CHR$(&H12)
                    stuff done$

                CASE "ZCF":
                    done$ = CHR$(&H13)
                    stuff done$


                CASE ELSE: ErrorMsg 1000, comm$


            END SELECT

        LOOP

    CLOSE #1


END SUB

SUB stuff (dat$)

    'stuffs dat$ to binary output file


    PUT #9, (baseptr& + 1) - &H200000, dat$
    baseptr& = baseptr& + LEN(dat$)


END SUB

FUNCTION SUBchop$ (txt$)

    'txt$ contains 2 parts separated by a ,


    a = INSTR(txt$, ",")
    IF a = 0 THEN
        PRINT "ADDchop ERROR: "; txt$
        EXIT FUNCTION
    END IF


    d1$ = MID$(txt$, 1, a - 1)
    d2$ = MID$(txt$, a + 1)

    size = getsize(d1$)     '1=b,2=w,4=l
    size2$ = getsize2(d1$, 2)

    num$ = getnum$(d1$)   '0-7 for var num

    par2$ = val2str$(d2$, size)


    'ADD r,#
    '
    '11zz1RRR
    '11001010 (CA)

    'finish up
    fin$ = "11" + size2$ + "1" + num$

    SUBchop$ = CHR$(frombin(fin$)) + CHR$(&HCA) + par2$


END FUNCTION

FUNCTION tostring$ (txt$)


    'prepares txt$ wich is parameters for DB stuff :)
    ' txt$ could contain byte numbers in decimal or hex,
    ' or text stuff inside ""'s.
    ' A final string used for binary output is returned.

    
    IF LEFT$(txt$, 1) = CHR$(34) THEN ' 34 is "
        ttmp$ = MID$(txt$, 2)
        a = INSTR(ttmp$, CHR$(34))
        ttmp$ = MID$(ttmp$, 1, a - 1)

        ret$ = ttmp$
    
    ELSE
        'data, sigh
        a = INSTR(txt$, ",")
        IF a THEN
            PRINT "TOSTRING ERROR: "; txt$
        ELSE
            IF UCASE$(RIGHT$(txt$, 1)) = "H" THEN
                ret$ = CHR$(VAL("&H" + txt$))
            ELSE
                PRINT "TOSTRING ERROR: "; txt$
            END IF
        END IF
    END IF


    tostring$ = ret$


END FUNCTION

FUNCTION val2str$ (txt$, size)

    'takes a number and converts it to bytes. not at all like STR$()
    ' wich converts a number to characters that represents this number
    '
    ' - value can be max 32 bits (4 bytes) big
    ' - 'size' tells length of returned data, 1, 2 or 4


    txt$ = LTRIM$(RTRIM$(txt$))

    IF UCASE$(RIGHT$(txt$, 1)) = "H" THEN
        gtmp$ = MID$(txt$, 1, LEN(txt$) - 1)

        vtmp$ = RIGHT$(STRING$(8, "0") + gtmp$, 8)
    ELSE
        PRINT "val2str ERROR: "; txt$
    END IF
    
    d1 = VAL("&H" + MID$(vtmp$, 1, 2))
    d2 = VAL("&H" + MID$(vtmp$, 3, 2))
    d3 = VAL("&H" + MID$(vtmp$, 5, 2))
    d4 = VAL("&H" + MID$(vtmp$, 7, 2))

    SELECT CASE size:
        CASE 4: done$ = CHR$(d4) + CHR$(d3) + CHR$(d2) + CHR$(d1)
        CASE 2: done$ = CHR$(d4) + CHR$(d3)
        CASE 1: done$ = CHR$(d4)
    END SELECT


    val2str$ = done$


END FUNCTION

