// 24RGB16
// Converts an interleaved 24 bit RAW file to a 16 bit n64-like RAW file
// by Poison/Tequila (a.k.a. Ruggero Rossi) 1999
// < mlros@tin.it >

// usage:  24RGB16 file24.raw file16.raw
// where "file24.raw" is a raw picture file in 24bit mode in the R/G/B order
// and "file16.raw" is the file to be created, with the picture converted
//                  in N64 16 bit graphic mode.

// I wrote this little proggy because "24to16" converts well, but it wants a
// different order of bytes for the 24bit file: I needed a converter from
// RGB to 16 not from BGR or BRG...since RGB is the way Photoshop and
// Paint Shop Pro save on default the raw file (and it is quite a "standard").
// Moreover, I found only the executable for DOS of "24to16" so if someone
// is using a different o.s. (or even a different kind of computer), he 
// cannot convert from 24 to 16, so I released the C source code that is
// full ANSI compatible and you can recompile it on whatever platform you
// want. It is easy to make some little modify to the program to convert from
// BGR BRG GBR or the byte order you prefer.
// This source and this program are FREE: you can use, modify and recompile it
// as you like, as long as you do not charge money for it.
// You should too let my name in the credits...
// You use this program at your own risk: I am not responsible for possible
// damages.

// To recompile this on your platform:
// 1) Check the typedefs: they have to match with your compiler types'
//    dimensions. Make sure that:
//    u8  ->  8 bit unsigned
//    s8  ->  8 bit signed
//    u16 -> 16 bit unsigned
//    s16 -> 16 bit signed
// 2) If your machine is big endian (like a mc 680x0), cut off the
//    "BYTE SWAP" part. If you computer is little endian (like Pentium family
//    processor), don't touch the "BYTE SWAP" part: you need it.
// I compiled this program with Watcom C/C++ 10.6 on MS-DOS with my Pentium,
// and it works ok. I think that if you take care of the rules above, you
// could compile and run it on every platform.

// little explanation about n64 16bit mode:
// bit 0: alpha channel
// bit [5:1]: blue
// bit [6:10]: green
// bit [15:11]: red
// note that the 16bit pixel must be in big endian format:
// the high byte is in the lower address and the low byte is in the higher
// address.

#include <stdio.h>

// chek this for the porting:
// this is for Watcom C/C++ 10.x compiler
// you have to match the datatypes in order to have the right
// dimension for every type
#ifndef _CONV_TYPES_
 #define _CONV_TYPES_
 typedef unsigned char u8;
 typedef unsigned short u16;
 typedef signed char  s8;
 typedef signed short s16;
#endif

void main(int argc,char **argv)
{
 FILE *fipo;
 long pic_length,n;
 u8 *point1,*pu8;
 u8 component;
 u8 *swap;
 u16 colour,temp;
 u16 *image,*pu16;

 printf("\n 24RGB16 by Poison/Tequila 1999\n");

 if (argc !=3)
 {
  printf(" Converts from 24 RGB to n64-like 16bit\n");
  printf("\n Usage %s source24.raw destination16.raw\n",argv[0]);
  return;
 }

 fipo=fopen(argv[1],"rb");    // open the source 24bit RGB file

 if (fipo==NULL) 
 {
  printf("\n Error ! File %s not found !\n",argv[1]);
  return ;
 }

 n=fseek(fipo,0,SEEK_END);  // go to end of file
 if (n<0)
 {
  printf("\n Read Error ! File not positioned\n");
  fclose(fipo);
  return ;
 }

 pic_length=ftell(fipo); // length of file
 if (pic_length<0)
 {
  printf("\n Read Error ! I can't fetch the file lenght\n");
  fclose(fipo);
  return ;
 }

 // go to start of file
 n=fseek(fipo,0,SEEK_SET); 
 if (n<0)
 {
  printf("\n Read Error ! File not positioned\n");
  fclose(fipo);
  return ;
 }

//  memory alloc for the 24 bit pic
 point1=(u8 *)malloc(pic_length);
 if(point1==NULL)
 {
  printf("\n Out of memory Error\n");
  return ;
 }

// memory alloc for the 16bit pic
 image=(u16 *)malloc((pic_length/3)*2);
 if(image==NULL)
 {
  printf("\n Out of memory Error\n");
  return ;
 }

// load the pic
 n=fread(point1,pic_length,1,fipo);
 if (n!=1)
 {
  printf("\n Read Error on file %s !\n",argv[1]);
  fclose(fipo);
  return ;
 }


// start converting the pic
 pic_length/=3;  // number of pixels
 pu8=point1;   // point to start of the pics
 pu16=image;

 for(n=0;n<pic_length;n++)
 {
  colour=0; // clear colour

  component=pu8[0]; // read red
  component>>=3; // convert from 8 to 5 bit

  temp=0;
  temp=component;
  temp<<=11;  // put in the right position

  colour|=temp; // add the red component in the 16bit pixel

  component=pu8[1]; // read green
  component>>=3; // convert from 8 to 5 bit

  temp=0;
  temp=component;
  temp<<=6;  // put in the right position
    

  colour|=temp; // add the green component in the 16bit pixel

  component=pu8[2]; // read blue
  component>>=3; // convert from 8 to 5 bit

  temp=0;
  temp=component;
  temp<<=1; // put in the right position

  colour|=temp; // add the blue component in the 16bit pixel

// set alpha bit
 if(colour!=0)
 {
  colour|=1;
 }

  *pu16=colour; // write colour


// BYTES SWAP part
// ----------------------8<---cut-here-if-big-endian---8<-----------------
  swap=(u8*)pu16;

  component=*swap;
  *swap=swap[1];
  swap[1]=component;
// ----------------------8<---cut-here-if-big-endian---8<-----------------


  pu8+=3; // go to next pixel
  pu16++;
 }


// free the 24bit pic
 free(point1);
 fclose(fipo);

// write 16 bit file
 fipo=fopen(argv[2],"wb"); 

 if (fipo==NULL)  
 {
  printf("\n Error ! File %s gives me some problem !\n",argv[2]);
  return ;
 }

// write the data
 n=fwrite(image,pic_length*2,1,fipo);
 if (n!=1)
 {
  printf("\n Write Error on file %s\n",argv[2]);
  fclose(fipo);
  return ;
 }

 fclose(fipo);

 printf("\n Well converted!\n");

}

