; GameGear Sample Program by Charles Doty (cdoty@host.yab.com)
; This program puts up a simple text screen on a Sega GameGear
; Look for more advanced versions to appear on
; http://www.yab.com/~cdoty/console.html
; Most of this code is based on looking into two Asgard trainers/intros,
; Portar.txt (MSX documents of tms9918a), and programming experience
; on the Sega Genesis. As I don't yet have the GameGear docs.

.org  $0000
    di              ;Disable Interrupts
    im   1          ;Interrupt Mode 1
    ld   hl,$fffc   ;Select Bank 2 by putting bank number at $ffff
    xor  a
    ld   (hl),a
    inc  l
    ld   (hl),a
    inc  l
    inc  l
    ld   (hl),$02   ;Bank Number
    ld   sp,$c0f6
    call $8000

.org $8000
    di              ;Main Program
    im   1
waitforline:
    in   a,($7e)    ;7eh is the current displayed scanline.
    cp   $b0        ;Waits for line b0h. Assumed to be end of screen.
    jr   nz,waitforline

    in   a,($bf)    ;Reads VDP status.

    ld   hl,VDPRegsTable ;Sets hl to point to VDP register values.
    ld   b,$0b      ;Sets first 11 VDP registers. Starting at 0.
    ld   c,$80      ;High byte is register number + 80h
VDPRegsLoop:
    ld   a,(hl)
    inc  hl
    out  ($bf),a    ;bfh selects VDP(80h) register, CRAM(c0h) or VRAM(40h). 
    ld   a,c        ;Transfer data first then register number
    inc  c
    out  ($bf),a    ;Selects VDP register.
    dec  b
    jr   nz,VDPRegsLoop
    sub  a
    out  ($bf),a    ;Sets up Access to CRAM. Sets up colors 0 and 1.
    ld   a,$c0
    out  ($bf),a
    sub  a          
    out  ($be),a
    out  ($be),a
    ld   a,$00      ;Color 0 black.
    out  ($be),a
    ld   a,$0e      ;Color 1 Blue
    out  ($be),a
    ld   a,$00      ;Setup VRAM for write to $0000
    out  ($bf),a
    ld   a,$40      ;Transfer LB then HB
    out  ($bf),a
    ld   bc,$4000   ;Transfer 4000h 0's to VRAM.
ClearVRAMLoop:
    sub  a
    out  ($be),a
    dec  bc
    ld   a,b
    or   c
    jr   nz,ClearVRAMLoop

    ld   a,$20        ;Setup VRAM for write to $0020
    out  ($bf),a      ;Skips first 32 bytes to create blank character
    ld   a,$40
    out  ($bf),a

    ld   hl,CharData  ;Transfer Characters to VRAM
    ld   bc,CharCount
CharLoop:
    ld   a,(hl)
    out  ($be),a
    sub  a
    out  ($be),a
    out  ($be),a
    out  ($be),a
    inc  hl
    dec  bc
    ld   a,b
    or   c
    jr   nz,CharLoop

    ld   a,$00      ;Setup VRAM for write to $3800
    out  ($bf),a
    ld   a,$78
    out  ($bf),a

    ld   hl,ScreenData  ;Transfer Tile numbers to VRAM.
    ld   bc,ScreenCount
ScreenLoop:
    ld   a,(hl)
    inc  hl
    sub  $20
    out  ($be),a
    sub  a
    out  ($be),a
    dec  bc
    ld   a,b
    or   c
    jr   nz,ScreenLoop

    ld   a,$c0  ;Turn on the Screen
    out  ($bf),a
    ld   a,$81
    out  ($bf),a

WaitforEndofScreen:
    in   a,($7e)
    cp   $c0
    jr   nz,WaitforEndofScreen

EndlessLoop:
    jp   EndlessLoop

VDPRegsTable:
    .byte    $06,$80,$ff,$ff,$ff,$ff,$ff,$00,$00,$00,$00

ScreenData:
 .byte  "                    "
 .byte  "            "
 .byte  "                    "
 .byte  "            "
 .byte  "                    "
 .byte  "            "
 .byte  "                    "
 .byte  "            "
 .byte  "      "
 .byte  "  This is a Simple  "
 .byte  "      "
 .byte  "      "
 .byte  "  Text Demo for GG. "
 .byte  "      "
 .byte  "      "
 .byte  "                    "
 .byte  "      "
 .byte  "      "
 .byte  "     Written by     "
 .byte  "      "
 .byte  "      "
 .byte  "    Charles Doty    "
 .byte  "      "
 .byte  "      "
 .byte  "(cdoty@host.yab.com)"
 .byte  "      "
 .byte  "                    "
 .byte  "            "
 .byte  "      "
 .byte  "For more console    "
 .byte  "      "
 .byte  "      "
 .byte  "programming info    "
 .byte  "      "
 .byte  "      "
 .byte  "Visit:              "
 .byte  "      "
 .byte  "                    "
 .byte  "            "
 .byte  "      "
 .byte  "http://www.yab.com/ "
 .byte  "      "
 .byte  "      "
 .byte  "<cdoty/console.html "
 .byte  "      "
 .byte  "                    "
 .byte  "            "
 .byte  "      "
 .byte  "Look for further    "
 .byte  "      "
 .byte  "      "
 .byte  "updates to this demo"
 .byte  "      "
 .byte  "      "
 .byte  "soon.               "
 .byte  "      "
ScreenEnd:
ScreenCount = ScreenEnd-ScreenData

CharData: 
.include font
CharEnd:
CharCount = CharEnd-CharData
.org $10000
.end
