OpenFile Macro                    ; Macro define for OpenFile
  Mov    Ax,3D02h                 ; Open file for read/write
  Int    21h                      ; Open the file
  Jnc    Short Open               ; Error?, nope file is opened
  Mov    Dx,OffSet FnErr          ; Load offset of error message into Dx
  Jmp    KillCode                 ; Print the message and quit
 Open:                            ; Open Ok label
  XChg   Ax,Bx                    ; Swap the filehandle in ax with bx
EndM OpenFile                     ; The end of Openfile

EraseCode Macro Size              ; Erases the code from 100h to 100h+size
  Mov    Al,0FFh                  ; What to overwrite it with
  Mov    Cx,Size                  ; The number of bytes to erase
  Mov    Di,100h                  ; Place to start from
  Rep    StoSb                    ; Erase the code!
EndM EraseCode                    ; End the code eraser macro

WriteJmp Macro                    ; The write jump macro
  Xor    Ax,Ax                    ; Zero Ax register
  Xor    Cx,Cx                    ; Zero Cx register
  Cwd                             ; Zero Dx register
  Call   Seek                     ; Seek in the file
  In     Ax,40h                   ; Get a random number in Ax
  And    Ax,6                     ; Make sure its 2 or below
  XChg   Ax,Dx                    ; Swap ax with dx
  Mov    Ax,FSize                 ; Put the value of the filesize into ax
  Add    Ax,109h
  Cmp    Dx,3                     ; Are we below 1?
  Jb     Short Pick1              ; Yes, pick type #2
  Mov    Word Ptr Ds:[JmpB2+1],Ax ; Store the offset of the loader
  Call   RegRandom                ; Get a random number <= 3 into Ax
  Add    Word Ptr Ds:[JmpB2],Ax   ; Change the register in the jump
  Add    Word Ptr Ds:[JmpE2-1],Ax ;  and in the move instruction
  Mov    Dx,OffSet JmpB2          ; The offset of the jump to write
  Jmp    Short NoPck              ; Jump over jump type #2
 Pick1:                           ; Picks jump #1
  Mov    Word Ptr Ds:[JmpB1+1],Ax ; Store the jump offset of the loader
  Call   RegRandom                ; Get a random number <= 3 into Ax
  Add    Word Ptr Ds:[JmpB1],Ax   ; Change the register in the jump
  Add    Word Ptr Ds:[JmpE1-2],Ax ;  and in the move instruction
  Mov    Dx,OffSet JmpB1          ; The loader to write
 NoPck:                           ; Done with the stuffz :}
  Mov    Cl,5                     ; Cx should still be zero so we can use Cl
  Call   Write                    ; Write the data
EndM WriteJmp                     ; End the write jmp macro

WriteBuf Macro                    ; Writes the encrypted file to disk
  Mov    Dx,OffSet Buf            ; The encrypted buffer
  Mov    Cx,FSize                 ; The number of bytes to write
  Call   Write                    ; Write the data
EndM WriteBuf                     ; End the write buffer macro

ReadBuf Macro                     ; Reads the file2crypt from the disk
  Mov    Ah,3Fh                   ; DOS function to read from file
  Mov    Dx,OffSet Buf            ; Load offset of the input buffer
  Mov    Cx,0FFFFh                ; Number of bytes to try and read
  Int    21h                      ; Read the data
  Mov    FSize,Ax                 ; Store the file size to FSize
EndM ReadBuf                      ; End the read buffer macro

CalcSize Macro                    ; Calculate size macro
; Mov    Ax,FSize                 ; Get fsize into ax
  Xor    Dx,Dx                    ; Zero Dx register
  Mov    Cx,2                     ; We want to divide number in Ax by 2 (Cx)
  Div    Cx                       ; Divide Ax by Cx
  Add    Ax,Dx                    ; Add the remainder to the qoutient
  Mov    TmpLen,Ax                ; Store the length into TmpLen
EndM CalcSize                     ; End the size calculating macro

WriteLoader Macro                 ; Write the loader to disk
  Mov    Ax,2                     ; The type of file seek we want
  Xor    Cx,Cx                    ; Zero Cx register
  Cwd                             ; Make Dx = 0
  Call   Seek                     ; Seek to end of file
  Mov    Cx,(Finish-Begin)        ; The size of the loader w/o mutations
  Mov    Dx,OffSet Loader         ; Offset of the loader
  Call   Write                    ; Write the data
EndM WriteLoader                  ; Write the loader macro

MakeRand Macro                    ; Initialize the random number generator
  Mov    Di,OffSet Bufr           ; Destination buffer
  Mov    Si,OffSet Buf            ; The first 3 bytes of the file
  Mov    Cx,3                     ; Number of bytes to copy
  Rep    MovSb                    ; Move 3 bytes into [Di]
EndM MakeRand                     ; End random-num-initializer :)

EncryptBuf Macro                  ; Encryptbuffer macro
IFNDEF NOCRYPT                    ; Are we using encryption?
  Call   Random                   ; Get a random number into Ax, Cx & Dx
  Mov    ChgKey,Ax                ; Store the Add/Sub key to loader
  Push   Ax                       ; Save Ax to the stack
  Call   Random                   ; Get a random numbers into Ax, Cx, & Dx
  Xor    Ax,Cx                    ; Xor ax by random cx
  Add    Ax,Dx                    ; Add random dx to Ax
  Mov    ChgKey2,Ax               ; Store the key to the loader
  Mov    ChgKey3,Ax               ; Store the key to the loop below
ENDIF                             ; End the if statement
  Mov    Cx,TmpLen                ; Number or words to encrypt
  Mov    Di,OffSet Buf            ; Put the ofs of buf into Di
  Mov    Si,Di                    ; Put the ofs of the buf into Si too
  Jmp    Short $+2                ; Reset PIQ
  Pop    Dx                       ; Restore Ax into Dx
  Add    Dx,8                     ; Add 8 to Dx
 Lp:                              ; Encrypt loop label
  LodSw                           ; Load a word from Si
IFNDEF NOCRYPT                    ; Are we using encryption?
  Push   Cx                       ; Save Cx to the stack
  Xor    Ax,Key_
  Not    Ax                       ; Not AX
  Xor    Cx,Dx                    ; Xor Cx,Dx
   Db    35h                      ; OpCode for Xor Ax,0000h
 ChgKey3 Dw 0                     ; The add/sub key
  Xor    Ax,Dx                    ; Add Ax,Cx
  Sub    Ax,Cx                    ; Xor Ax,Dx
  Neg    Ax                       ; Make AX negative
  Pop    Cx                       ; Restore Cx from stack
ENDIF                             ; End the if statement
  StoSw                           ; Store the word into Di
  Loop   Lp                       ; Repeat for entire buffer
EndM EncryptBuf                   ; End encrypt buffer macro

GetParam Macro                    ; Get the command line macro
  Mov    Cl,Ds:[80h]              ; Grab the command line length in CL
  Or     Cl,Cl                    ; Check to see if it's 0
  Jz     Short NoCmd              ; No, get the commandline
 ScnCmd:                          ; Scan the command
  Mov    Si,81h                   ; Load command offset into SI
 ScanLp:                          ; Scanning loop
  LodSb                           ; Load a byte from SI into AL
  Cmp    Al,20h                   ; Remove the leading spaces, Is it a space?
  Jne    Short Found              ; No, stop loop and save param ofs
  Loop   ScanLp                   ; Yes, loop ScanLp until its not a space.
 NoCmd:                           ; No command was found
  Mov    Dx,OffSet Usage          ; Display the usage message
  Jmp    KillCode                 ; Call print to show the message
 Found:                           ; Found the beginning of the message
  Dec    Si                       ; Subtract 1 from the offset of commandline
  Push   Si                       ; Save Si to the stack
 ScnEnd:                          ; Done scanning
  LodSb                           ; Load a byte from SI
  Cmp    Al,0Dh                   ; Search for CR
  Jne    Short ScnEnd             ; CR not found so keep scanning
  Mov    Byte Ptr Ds:[Si-1],0     ; Replace CR with nul char (ASCIIZ)
  Pop    Dx                       ; Restore Si into Dx
EndM GetParam                     ; End get commandline macro

CheckExe Macro                    ; Check for EXE files
  Mov    Ax,Word Ptr [Buf]        ; Get the first two bytes of the bytes
  Cmp    Ax,'MZ'                  ; See if its a MZ, exesig
  Je     Short IsExe              ; Yes, we don't want exe files
  Cmp    Ax,'ZM'                  ; See if its a ZM, reverse exesig
  Jne    Short NoExe              ; Nope goto Not an exe
 IsExe:                           ; Is an EXE label
  Call   CloseFile                ; Close the file
  Mov    Dx,OffSet ExeMsg         ; The message to print
  Jmp    KillCode                 ; Print & quit :)
 NoExe:                           ; No EXE label
EndM CheckExe                     ; End the check exe macro

MakeExtra Macro                   ; This creates a random amount of mutations
  Mov    Cx,MutLen                ; Maximum mutation length
  Xor    Ax,Ax                    ; Zero Ax register
  In     Al,40h                   ; Grab a random number
  Sub    Cx,Ax                    ; Subtract the random # from max-mut len 
 TestIt:                          ; Test it label
  Cmp    Cx,MinLen                ; Are we lower then allowed?
  Jb     Short ChgIt              ; Yes, goto ChgIt
  Cmp    Cx,MutLen                ; Are we the maxium len allowed?
  Jb     Short Ok                 ; Its below or equal then its ok.
 ChgIt:                           ; Change it label
  Xor    Ax,Ax                    ; Zero ax register
  In     Ax,40h                   ; Grab another random number
  Add    Cx,Ax                    ; Add the random number to the current mut_len
  Jmp    Short TestIt             ; See if its ok now
 Ok:                              ; We've got the OK :)
  Push   Cx Cx                    ; Save Cx to stack twice
  Add    Cx,(Finish-Begin)        ; Add the loader size to it.
  Mov    LdrLen,Cx                ; Save the real loader size length
  Pop    Cx                       ; Restore 1 cx from stack
  Lea    Di,Buf                   ; Put offset of the buf into Di
  Push   Di                       ; Save Di for later use
 LpM:                             ; Junk-make loop
  In     Al,40h                   ; Get random number in Al
  Add    Al,Cl                    ; Add counter to Al
  Push   Ax                       ; Save ax to the stack
  In     Ax,40h                   ; Get a random number into Ax
  XChg   Ax,Dx                    ; Swap Dx and Ax again
  Pop    Ax                       ; Restore Ax from stack
  Add    Al,Dl                    ; Add Dl to Al
  StoSb                           ; Store the byte
  Loop   LpM                      ; Repeat for the entire thing
  Pop    Dx Cx                    ; Restore the 2nd cx from the stack and Dx = buf
  Call   Write                    ; Write the data to disk
EndM MakeExtra                    ; End Make Extra macro

IFDEF TESTMD                      ; Are we in testMode?
Testr Macro Chr                   ; This prints out a character and waits
  Push   Ax                       ; Save the Ax register
  Mov    Al,Chr                   ; Get the character to print into Al
  Int    29h                      ; Print the char
  Xor    Ax,Ax                    ; Zero ax register
  Int    16h                      ; Wait for character
  Pop    Ax                       ; Restore the AX register
EndM Testr                        ; End Testr macro
ENDIF                             ; End if statement
