/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

import perfectpix.BaseLib;
import perfectpix.ImageConverter;
import perfectpix.PerfectPix;
import perfectpix.VFile;

public class cfg
extends BaseLib {
    static final int TYPE_LINEAL = 0;
    static final int TYPE_STANDAR_SCREEN = 1;
    static final int TYPE_OVERSCAN = 2;
    static final int TYPE_LINEAL_V = 3;
    static final int TYPE_SPLITTED_OVERSCAN = 4;
    static final int TYPE_CUSTOM_SCANLINE_ORDER = 5;
    static final int TYPE_PPH = 6;
    static final int MODE_0 = 0;
    static final int MODE_1 = 1;
    static final int MODE_2 = 2;
    static final int MODE_R = 3;
    static final int MODE_B0 = 4;
    static final int MODE_B1 = 5;
    int mode;
    int type;
    int lineal_v_w = 1;
    String fileExt;
    String[] fileNames;
    int[] nBytesW;
    String output = "all";
    int param1;
    int transform = 0;
    int[] scanlines_per_char_order = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    int[] bytes_order;
    int[] width;
    int[] height;
    byte[][] palette;
    int[][] oCPCPaletteNumbers;
    int[][] oCPCPalette;
    int[][] oACTPalette;

    public cfg(int _mode, int _type, String _fileExt) {
        this.mode = _mode;
        this.type = _type;
        this.fileExt = _fileExt;
    }

    public void setFileNames(String[] _fileNames) {
        this.fileNames = new String[_fileNames.length];
        for (int i = 0; i < _fileNames.length; ++i) {
            this.fileNames[i] = PerfectPix.getFileNameWithoutExtension(_fileNames[i]);
        }
        int _nFiles = _fileNames.length;
        this.nBytesW = new int[_nFiles];
        this.palette = new byte[_nFiles][ImageConverter.nColorsMax[this.mode]];
        this.width = new int[_nFiles];
        this.height = new int[_nFiles];
    }

    public void setPalettes(String[] _fileNames) throws Exception {
        int _nFiles = _fileNames.length;
        this.oCPCPalette = new int[_nFiles][];
        this.oCPCPaletteNumbers = new int[_nFiles][];
        this.oACTPalette = new int[_nFiles][PerfectPix.N_PALETTE_COLORS];
        String _srcFile_ext = PerfectPix.getFileExtension(_fileNames[0]);
        if (_srcFile_ext == null) {
            _srcFile_ext = "act";
        }
        int _oPos = 0;
        int _colorSize = 3;
        if (_srcFile_ext.equals("pal")) {
            _oPos = 24;
            _colorSize = 4;
        }
        for (int i = 0; i < _nFiles; ++i) {
            VFile src = new VFile(PerfectPix.getFileNameWithoutExtension(_fileNames[i]) + "." + _srcFile_ext, 1);
            byte[] _data = src.getRawBytes();
            int _nCols = 4;
            if (this.mode == 4) {
                _nCols = 16;
            }
            this.oCPCPalette[i] = new int[_nCols];
            this.oCPCPaletteNumbers[i] = new int[_nCols];
            int _pos = 0;
            int c = 0;
            while (c < _nCols) {
                int _off = _oPos + _pos * _colorSize;
                int n = cfg.getRGBInt(_data[_off++], _data[_off++], _data[_off]);
                this.oCPCPalette[i][c] = n;
                int _rgb = n;
                this.oCPCPaletteNumbers[i][c] = ImageConverter.getCPCPaletteNumber(_rgb);
                ++c;
                _pos += _nCols + 1;
            }
            _pos = _oPos;
            int _j = 0;
            while (_j < PerfectPix.N_PALETTE_COLORS) {
                this.oACTPalette[i][_j] = cfg.getRGBInt(_data[_pos], _data[_pos + 1], _data[_pos + 2]);
                ++_j;
                _pos += _colorSize;
            }
            src.close();
        }
    }

    public int getIndexedColor(int _id, int _rgb) {
        _rgb &= 0xFFFFFF;
        int[] _oACTPalette = this.oACTPalette[_id];
        for (int i = 0; i < PerfectPix.N_PALETTE_COLORS; ++i) {
            if (_oACTPalette[i] != _rgb) continue;
            return i;
        }
        return -1;
    }

    public void savePPH(String _dskPath, boolean _multiple) throws Exception {
        _dskPath = PerfectPix.getFileNameWithoutExtension(_dskPath);
        VFile des = new VFile(_dskPath + ".pph", 2);
        byte[] _pph = this.getPPH();
        des.saveData(_pph, 0, _pph.length);
        des.close();
        if (_multiple) {
            int _nFiles = this.fileNames.length;
            int _nTotalEveData = 0;
            int _nTotalOddData = 0;
            byte[][] _srcDataEve = new byte[_nFiles][];
            byte[][] _srcDataOdd = new byte[_nFiles][];
            for (int i = 0; i < _nFiles; ++i) {
                VFile src = new VFile(this.fileNames[i] + ".eve", 1);
                _srcDataEve[i] = src.getRawBytes();
                _nTotalEveData += _srcDataEve[i].length;
                src = new VFile(this.fileNames[i] + ".odd", 1);
                _srcDataOdd[i] = src.getRawBytes();
                _nTotalOddData += _srcDataOdd[i].length;
            }
            byte[] _totalEveData = new byte[_nTotalEveData];
            byte[] _totalOddData = new byte[_nTotalOddData];
            int _totalEveDataPos = 0;
            int _totalOddDataPos = 0;
            for (int i = 0; i < _nFiles; ++i) {
                System.arraycopy(_srcDataEve[i], 0, _totalEveData, _totalEveDataPos, _srcDataEve[i].length);
                _totalEveDataPos += _srcDataEve[i].length;
                System.arraycopy(_srcDataOdd[i], 0, _totalOddData, _totalOddDataPos, _srcDataOdd[i].length);
                _totalOddDataPos += _srcDataOdd[i].length;
            }
            des = new VFile(_dskPath + ".eve", 2);
            des.saveData(_totalEveData, 0, _totalEveData.length);
            des.close();
            des = new VFile(_dskPath + ".odd", 2);
            des.saveData(_totalOddData, 0, _totalOddData.length);
            des.close();
        } else if (des.inDsk) {
            VFile src = new VFile(this.fileNames[0] + ".eve", 1);
            des = new VFile(_dskPath + ".eve", 2);
            des.copy(src);
            des.close();
            src = new VFile(this.fileNames[0] + ".odd", 1);
            des = new VFile(_dskPath + ".odd", 2);
            des.copy(src);
            des.close();
        }
    }

    public byte[] getPPH() {
        int _nPals = this.palette.length;
        int _height = 0;
        for (int _i = 0; _i < _nPals; ++_i) {
            _height += this.height[_i];
        }
        int _nColorsPerPal = this.palette[0].length;
        int _pph_len = _nPals == 1 ? 6 + _nColorsPerPal : _nPals * 5 + 5;
        byte[] _pph = new byte[_pph_len];
        int _off = 0;
        _pph[_off++] = (byte)this.mode;
        _pph[_off++] = (byte)(this.width[0] % 256);
        _pph[_off++] = (byte)(this.width[0] / 256);
        _pph[_off++] = (byte)(_height % 256);
        _pph[_off++] = (byte)(_height / 256);
        _pph[_off++] = (byte)_nPals;
        if (_nPals == 1) {
            System.arraycopy(this.palette[0], 0, _pph, _off, _nColorsPerPal);
        } else {
            System.arraycopy(this.palette[0], 0, _pph, _off, _nColorsPerPal);
            _off += _nColorsPerPal;
            int _pal_h = this.height[0];
            _pph[_off++] = (byte)(_pal_h % 256);
            _pph[_off++] = (byte)(_pal_h / 256);
            for (int _i = 1; _i < _nPals; ++_i) {
                System.arraycopy(this.palette[_i], 1, _pph, _off, _nColorsPerPal - 1);
                _off += _nColorsPerPal - 1;
                if (_i >= _nPals - 1) continue;
                _pal_h = this.height[_i];
                _pph[_off++] = (byte)(_pal_h % 256);
                _pph[_off++] = (byte)(_pal_h / 256);
            }
        }
        return _pph;
    }
}

