/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

public class LAB {
    public double L;
    public double a;
    public double b;
    public int c = -1;
    public double[] w;
    public double s = -1.0;

    public LAB(double L, double a, double b) {
        this.L = L;
        this.a = a;
        this.b = b;
    }

    private LAB(double L, double a, double b, int c) {
        this.L = L;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public String toString() {
        return (int)this.L + "," + (int)this.a + "," + (int)this.b;
    }

    public boolean equals(Object o) {
        if (o instanceof LAB) {
            LAB y = (LAB)o;
            return this.L == y.L && this.a == y.a && this.b == y.b;
        }
        return false;
    }

    public int hashCode() {
        int x = (int)this.L;
        int y = (int)(this.a + 110.0);
        int z = (int)(this.b + 110.0);
        return x << 16 | y << 8 | z;
    }

    public LAB copy() {
        LAB x = new LAB(this.L, this.a, this.b, this.c);
        if (this.w != null) {
            x.w = (double[])this.w.clone();
        }
        return x;
    }

    public double distance(LAB y) {
        double dL = this.L - y.L;
        double da = this.a - y.a;
        double db = this.b - y.b;
        return Math.sqrt(dL * dL + da * da + db * db);
    }

    public int rgb() {
        double y = (this.L + 16.0) / 116.0;
        double x = y + this.a / 500.0;
        double z = y - this.b / 200.0;
        double X = 0.95047;
        double Y = 1.0;
        double Z = 1.08883;
        x = X * (x > 0.206893034 ? x * x * x : (x - 0.13793103448275862) / 7.787037);
        y = Y * (y > 0.206893034 ? y * y * y : (y - 0.13793103448275862) / 7.787037);
        z = Z * (z > 0.206893034 ? z * z * z : (z - 0.13793103448275862) / 7.787037);
        double r = 3.2404542 * x - 1.5371385 * y - 0.4985314 * z;
        double g = -0.969266 * x + 1.8760108 * y + 0.041556 * z;
        double b = 0.0556434 * x - 0.2040259 * y + 1.0572252 * z;
        r = r <= 0.00304 ? 12.92 * r : 1.055 * Math.pow(r, 0.4166666666666667) - 0.055;
        g = g <= 0.00304 ? 12.92 * g : 1.055 * Math.pow(g, 0.4166666666666667) - 0.055;
        b = b <= 0.00304 ? 12.92 * b : 1.055 * Math.pow(b, 0.4166666666666667) - 0.055;
        int ir = (int)Math.round(255.0 * r);
        ir = Math.max(0, Math.min(ir, 255));
        int ig = (int)Math.round(255.0 * g);
        ig = Math.max(0, Math.min(ig, 255));
        int ib = (int)Math.round(255.0 * b);
        ib = Math.max(0, Math.min(ib, 255));
        return 0xFF0000 & ir << 16 | 0xFF00 & ig << 8 | 0xFF & ib;
    }

    public String hex() {
        int rgb = this.rgb();
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb;
        String sr = Integer.toHexString(r);
        String sg = Integer.toHexString(g);
        String sb = Integer.toHexString(b);
        if (sr.length() < 2) {
            sr = "0" + sr;
        }
        if (sg.length() < 2) {
            sg = "0" + sg;
        }
        if (sb.length() < 2) {
            sb = "0" + sb;
        }
        return "#" + sr + sg + sb;
    }

    public static LAB fromRGB(int ri, int gi, int bi, double binSize) {
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double X = 0.95047;
        double Y = 1.0;
        double Z = 1.08883;
        r = r <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.04045 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.04045 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        double x = (0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / X;
        double y = (0.2126729 * r + 0.7151522 * g + 0.072175 * b) / Y;
        double z = (0.0193339 * r + 0.119192 * g + 0.9503041 * b) / Z;
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787037 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787037 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787037 * z + 0.13793103448275862;
        double L = 116.0 * y - 16.0;
        double A = 500.0 * (x - y);
        double B = 200.0 * (y - z);
        if (binSize > 0.0) {
            L = binSize * Math.floor(L / binSize);
            A = binSize * Math.floor(A / binSize);
            B = binSize * Math.floor(B / binSize);
        }
        return new LAB(L, A, B);
    }

    public static LAB fromRGBr(int ri, int gi, int bi, double binSize) {
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double X = 0.95047;
        double Y = 1.0;
        double Z = 1.08883;
        r = r <= 0.04045 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.04045 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.04045 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        double x = (0.4124564 * r + 0.3575761 * g + 0.1804375 * b) / X;
        double y = (0.2126729 * r + 0.7151522 * g + 0.072175 * b) / Y;
        double z = (0.0193339 * r + 0.119192 * g + 0.9503041 * b) / Z;
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787037 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787037 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787037 * z + 0.13793103448275862;
        double L = 116.0 * y - 16.0;
        double A = 500.0 * (x - y);
        double B = 200.0 * (y - z);
        if (binSize > 0.0) {
            L = binSize * (double)Math.round(L / binSize);
            A = binSize * (double)Math.round(A / binSize);
            B = binSize * (double)Math.round(B / binSize);
        }
        return new LAB(L, A, B);
    }

    public static boolean isInRGBGamut(double L, double A, double B) {
        double y = (L + 16.0) / 116.0;
        double x = y + A / 500.0;
        double z = y - B / 200.0;
        double X = 0.95047;
        double Y = 1.0;
        double Z = 1.08883;
        x = X * (x > 0.206893034 ? x * x * x : (x - 0.13793103448275862) / 7.787037);
        y = Y * (y > 0.206893034 ? y * y * y : (y - 0.13793103448275862) / 7.787037);
        z = Z * (z > 0.206893034 ? z * z * z : (z - 0.13793103448275862) / 7.787037);
        double r = 3.2404542 * x - 1.5371385 * y - 0.4985314 * z;
        double g = -0.969266 * x + 1.8760108 * y + 0.041556 * z;
        double b = 0.0556434 * x - 0.2040259 * y + 1.0572252 * z;
        r = r <= 0.00304 ? 12.92 * r : 1.055 * Math.pow(r, 0.4166666666666667) - 0.055;
        g = g <= 0.00304 ? 12.92 * g : 1.055 * Math.pow(g, 0.4166666666666667) - 0.055;
        b = b <= 0.00304 ? 12.92 * b : 1.055 * Math.pow(b, 0.4166666666666667) - 0.055;
        return !(r < 0.0 || r > 1.0 || g < 0.0 || g > 1.0 || b < 0.0 || b > 1.0);
    }

    public static double ciede2000(LAB x, LAB y) {
        double hp2;
        double kl = 1.0;
        double kc = 1.0;
        double kh = 1.0;
        double pi = Math.PI;
        double L1 = x.L;
        double a1 = x.a;
        double b1 = x.b;
        double Cab1 = Math.sqrt(a1 * a1 + b1 * b1);
        double L2 = y.L;
        double a2 = y.a;
        double b2 = y.b;
        double Cab2 = Math.sqrt(a2 * a2 + b2 * b2);
        double Cab = 0.5 * (Cab1 + Cab2);
        double G = 0.5 * (1.0 - Math.sqrt(Math.pow(Cab, 7.0) / (Math.pow(Cab, 7.0) + Math.pow(25.0, 7.0))));
        double ap1 = (1.0 + G) * a1;
        double ap2 = (1.0 + G) * a2;
        double Cp1 = Math.sqrt(ap1 * ap1 + b1 * b1);
        double Cp2 = Math.sqrt(ap2 * ap2 + b2 * b2);
        double Cpp = Cp1 * Cp2;
        double hp1 = Math.atan2(b1, ap1);
        if (hp1 < 0.0) {
            hp1 += 2.0 * pi;
        }
        if ((hp2 = Math.atan2(b2, ap2)) < 0.0) {
            hp2 += 2.0 * pi;
        }
        double dL = L2 - L1;
        double dC = Cp2 - Cp1;
        double dhp = hp2 - hp1;
        if (dhp > pi) {
            dhp -= 2.0 * pi;
        }
        if (dhp < -pi) {
            dhp += 2.0 * pi;
        }
        if (Cpp == 0.0) {
            dhp = 0.0;
        }
        double dH = 2.0 * Math.sqrt(Cpp) * Math.sin(dhp / 2.0);
        double Lp = 0.5 * (L1 + L2);
        double Cp = 0.5 * (Cp1 + Cp2);
        double hp = 0.5 * (hp1 + hp2);
        if (Math.abs(hp1 - hp2) > pi) {
            hp -= pi;
        }
        if (hp < 0.0) {
            hp += 2.0 * pi;
        }
        if (Cpp == 0.0) {
            hp = hp1 + hp2;
        }
        double Lpm502 = (Lp - 50.0) * (Lp - 50.0);
        double Sl = 1.0 + 0.015 * Lpm502 / Math.sqrt(20.0 + Lpm502);
        double Sc = 1.0 + 0.045 * Cp;
        double T = 1.0 - 0.17 * Math.cos(hp - pi / 6.0) + 0.24 * Math.cos(2.0 * hp) + 0.32 * Math.cos(3.0 * hp + pi / 30.0) - 0.2 * Math.cos(4.0 * hp - 63.0 * pi / 180.0);
        double Sh = 1.0 + 0.015 * Cp * T;
        double ex = (180.0 / pi * hp - 275.0) / 25.0;
        double delthetarad = 30.0 * pi / 180.0 * Math.exp(-1.0 * (ex * ex));
        double Rc = 2.0 * Math.sqrt(Math.pow(Cp, 7.0) / (Math.pow(Cp, 7.0) + Math.pow(25.0, 7.0)));
        double RT = -1.0 * Math.sin(2.0 * delthetarad) * Rc;
        return (dL /= kl * Sl) * dL + (dC /= kc * Sc) * dC + (dH /= kh * Sh) * dH + RT * dC * dH;
    }
}

