/*
 * POSIX Compatibility Library for AmigaOS
 *
 * Written by Frank Wille <frank@phoenix.owl.de> in 2003
 *
 * $Id: ioccom.h,v 1.1 2005/04/11 21:46:13 phx Exp $
 */

#ifndef _SYS_IOCCOM_H_
#define _SYS_IOCCOM_H_

/*
 * Ioctl's have the command encoded in the lower word, and the size of
 * any in or out parameters in the upper word.  The high 3 bits of the
 * upper word are used to encode the in/out status of the parameter.
 */
#define IOCPARM_MASK    0x1fff          /* parameter length, at most 13 bits */
#define IOCPARM_LEN(x)  (((x) >> 16) & IOCPARM_MASK)
#define IOCBASECMD(x)   ((x) & ~(IOCPARM_MASK << 16))
#define IOCGROUP(x)     (((x) >> 8) & 0xff)

#define IOCPARM_MAX     4096    /* max size of ioctl args, mult. of NBPG */
                                /* no parameters */
#define IOC_VOID        (unsigned long)0x20000000
                                /* copy parameters out */
#define IOC_OUT         (unsigned long)0x40000000
                                /* copy parameters in */
#define IOC_IN          (unsigned long)0x80000000
                                /* copy paramters in and out */
#define IOC_INOUT       (IOC_IN|IOC_OUT)
                                /* mask for IN/OUT/VOID */
#define IOC_DIRMASK     (unsigned long)0xe0000000

#define _IOC(inout,group,num,len) \
        (inout | ((len & IOCPARM_MASK) << 16) | ((group) << 8) | (num))
#define _IO(g,n)        _IOC(IOC_VOID,  (g), (n), 0)
#define _IOR(g,n,t)     _IOC(IOC_OUT,   (g), (n), sizeof(t))
#define _IOW(g,n,t)     _IOC(IOC_IN,    (g), (n), sizeof(t))
/* this should be _IORW, but stdio got there first */
#define _IOWR(g,n,t)    _IOC(IOC_INOUT, (g), (n), sizeof(t))

#endif  /* _SYS_IOCCOM_H_ */
