
/* Includes */

#include <exec/types.h>
#include <intuition/intuition.h>
#include <dos/dos.h>
#include <string.h>
#include <stdlib.h>
#include <libraries/asl.h>

#include "VIC20.h"	/* User header file */
#include "VIC20_rev.h"	/* Bumprev header file */
#include "VIC20_asm.h"
#include <stdio.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/utility_protos.h>
#include <clib/asl_protos.h>
#include <clib/dos_protos.h>

/* Pragma includes for register parameters */
 
#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>
#include <pragmas/utility_pragmas.h>
#include <pragmas/asl_pragmas.h>
#include <pragmas/dos_pragmas.h>

/* Global variables */
BOOL ReadPrefsFile(UBYTE *,struct TMData *);
extern BPTR oldDir; 
extern UBYTE *dirName;
extern UBYTE *fileName;
char vers[] = VERSTAG;	/* Bumprev version string */
struct Library *IntuitionBase;	/* intuition.library pointer */
struct Library *GadToolsBase;	/* gadtools.library pointer */
struct Library *UtilityBase;	/* utility.library pointer */
struct Library *AslBase;	/* asl.library pointer */
struct IntuiText BodyText = {0,1,JAM2,20,8,NULL,(UBYTE *)TEXT_NORELEASE2,NULL};
struct IntuiText NegText  = {0,1,JAM2, 6,4,NULL,(UBYTE *)TEXT_OK,NULL};

/* Entry functions */
 
#ifdef _DCC	/* for DICE compatibility */
VOID wbmain(VOID *wbmsg)
  {
  main(0, wbmsg);
  }
#endif

VOID main(int argc, char **argv)
  {
  struct TMData *TMData;	/* data structure pointer */
  ULONG error;
  BPTR lock;

  if(!(IntuitionBase = OpenLibrary((UBYTE *)"intuition.library", 37L)))	/* Open intuition.library V37 */
    {
    if(IntuitionBase = OpenLibrary((UBYTE *)"intuition.library", 0L))
      {
      AutoRequest(NULL, &BodyText, NULL, &NegText, 0, 0, 320, 80);
      CloseLibrary(IntuitionBase);
      }
    cleanexit(NULL, RETURN_FAIL);
    }

  if(!(GadToolsBase = OpenLibrary((UBYTE *)"gadtools.library", 37L)))	/* Open gadtools.library V37 */
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOLIBRARY, (UBYTE *)TEXT_ABORT, NULL, "gadtools.library V37");
    cleanexit(NULL, RETURN_FAIL);
    }

  if(!(UtilityBase = OpenLibrary((UBYTE *)"utility.library", 37L)))	/* Open utility.library V37 */
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOLIBRARY, (UBYTE *)TEXT_ABORT, NULL, "utility.library V37");
    cleanexit(NULL, RETURN_FAIL);
    }

  if(!(AslBase = OpenLibrary((UBYTE *)"asl.library", 37L)))	/* Open asl.library V37 */
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOLIBRARY, (UBYTE *)TEXT_ABORT, NULL, "asl.library V37");
    cleanexit(NULL, RETURN_FAIL);
    }

  if(!(TMData = TM_Open(&error)))	/* Open Toolmaker data */
    {
    switch(error)
      {
      case TMERR_MEMORY:
        TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOMEMORY, (UBYTE *)TEXT_ABORT, NULL, NULL);
        break;
      case TMERR_MSGPORT:
        TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOMSGPORT, (UBYTE *)TEXT_ABORT, NULL, NULL);
        break;
      }
    cleanexit(NULL, RETURN_FAIL);
    }

  if(!(TMData->FileRequester = AllocAslRequestTags(ASL_FileRequest, TAG_DONE)))
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOFILEREQ, (UBYTE *)TEXT_ABORT, NULL, NULL);
    cleanexit(TMData, RETURN_FAIL);
    }

  if(!(OpenScreen_Workbench(TMData)))	/* Open default public screen */
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOSCREEN, (UBYTE *)TEXT_ABORT, NULL, NULL);
    cleanexit(TMData, RETURN_FAIL);
    }

  if(!(OpenWindow_VIC20(TMData)))	/* Open the window */
    {
    TM_Request(NULL, (UBYTE *)TEXT_ERROR, (UBYTE *)TEXT_NOWINDOW, (UBYTE *)TEXT_ABORT, NULL, NULL);
    cleanexit(TMData, RETURN_FAIL);
    }
  ReadPrefsFile("VIC20.prefs", TMData);
  OpenVIC();
  TM_EventLoop(TMData);	/* Process events */
  CloseVIC();
  cleanexit(TMData, RETURN_OK);
  }

/* cleanexit function */
 
VOID cleanexit(struct TMData *TMData, int returnvalue)
  {
  if(TMData)
    {
    CloseWindow_VIC20(TMData);
    CloseScreen_Workbench(TMData);
    if(TMData->FileRequester) FreeAslRequest(TMData->FileRequester);
    TM_Close(TMData);
    }

  if(AslBase)       CloseLibrary(AslBase);	/* Close asl.library */
  if(UtilityBase)   CloseLibrary(UtilityBase);	/* Close utility.library */
  if(GadToolsBase)  CloseLibrary(GadToolsBase);	/* Close gadtools.library */
  if(IntuitionBase) CloseLibrary(IntuitionBase);	/* Close intuition.library */

  exit(returnvalue);
  }

/* ASL file requester function */
 
UBYTE *getfilename(struct TMData *TMData, UBYTE *title, UBYTE *buffer, ULONG bufsize, struct Window *window, BOOL saveflag)
  {
  ULONG funcflags;

  if(saveflag)
    funcflags = FILF_SAVE;
  else
    funcflags = 0;

  if(buffer && TMData)
    {
    if(AslRequestTags((APTR) TMData->FileRequester,
                      ASL_Hail, title,
                      ASL_Window, window,
                      ASL_FuncFlags, funcflags,
		      ASL_ExtFlags1, 0L,
                      TAG_DONE))
      {
      strcpy(buffer, TMData->FileRequester->rf_Dir);
      if(AddPart(buffer, TMData->FileRequester->rf_File, bufsize))
        {
        return(buffer);
        }
      }
    }

  return(NULL);
  }

/* Window event functions */
 
BOOL Window_VIC20_CLOSEWINDOW(struct TMData *TMData, struct IntuiMessage *imsg)
  {
  LONG num;
  DisableWindow_VIC20(TMData);
  num=TM_Request(window_VIC20, "Quit",
	     "Are you sure that" "\n"
	     "you want to quit?" "\n"
	     ,
	     "OK|CANCEL", NULL, NULL);
  EnableWindow_VIC20(TMData);
  if (num==1) return(TRUE);
  else return(FALSE);
  }

BOOL Window_VIC20_MENUPICK(struct TMData *TMData, struct IntuiMessage *imsg)
  {
  UWORD menucode;
  struct MenuItem *menuitem;
  TMOBJECTDATA *tmobjectdata;
  BOOL (*eventfunc)(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);

  menucode = imsg->Code;
  while(menucode != MENUNULL)
    {
    menuitem = ItemAddress(WindowInfo_VIC20.Menu, menucode);
    tmobjectdata = (TMOBJECTDATA *)(GTMENUITEM_USERDATA(menuitem));
    eventfunc = tmobjectdata->EventFunc;

    if(eventfunc)
      {
      if((*eventfunc)(TMData, imsg, tmobjectdata)) return(TRUE);
      }

    menucode = menuitem->NextSelect;
    }
  return(FALSE);
  }

BOOL Window_VIC20_GADGETUP(struct TMData *TMData, struct IntuiMessage *imsg)
  {
  struct Gadget *gadget;
  TMOBJECTDATA *tmobjectdata;
  BOOL (*eventfunc)(struct TMData *, struct IntuiMessage *, TMOBJECTDATA *);

  gadget = (struct Gadget *)imsg->IAddress;
  tmobjectdata = (TMOBJECTDATA *)(gadget->UserData);
  eventfunc = tmobjectdata->EventFunc;

  if(eventfunc)
    {
    return((*eventfunc)(TMData, imsg, tmobjectdata));
    }
  return(FALSE);
  }

