<?xml version="1.0"?><doc>
<members>
<member name="T:Jacobi.Vst.Interop.Host.VstPluginContext" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="8">
<summary>
The VstPluginContext class represents a VST Plugin for the host.
</summary>
<remarks>
The VstPluginContext can only be created using the static 
<see cref="M:Jacobi.Vst.Interop.Host.VstPluginContext.Create(System.String,Jacobi.Vst.Core.Host.IVstHostCommandStub)"/> 
factory method. The method accepts the path to the plugin and an
implementation of the <see cref="T:Jacobi.Vst.Core.Host.IVstHostCommandStub"/>
interface.
Note that <c>Open</c> is not called on the Plugin by the context but it does call 
Close on the plugin when the context is disposed.
</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Create(System.String,Jacobi.Vst.Core.Host.IVstHostCommandStub)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="27">
<summary>
Creates a context using the specified <paramref name="pluginPath"/> and <paramref name="hostCmdStub"/>.
</summary>
<param name="pluginPath">The full path to a plugin .dll. Must not be null or empty.</param>
<param name="hostCmdStub">A reference to a host supplied implementation of the host command stub. Must not be null.</param>
<remarks>Note that when the <paramref name="hostCmdStub"/> implements <see cref="T:System.IDisposable"/> 
it is also disposed when this instance of the plugin context is disposed.</remarks>
<exception cref="T:System.IO.FileNotFoundException">Thrown when the file specified in 
<paramref name="pluginPath"/> does not exist.</exception>
<exception cref="T:System.ArgumentException">Thrown when the library cannot be opened.</exception>
<exception cref="T:System.EntryPointNotFoundException">Thrown when the library does not expose a 
<c>VSTPluginMain</c> exported function.</exception>
<exception cref="T:System.OperationCanceledException">Thrown when the library does not return 
an ::EAffect pointer from its exported main function.</exception>
<exception cref="T:System.NotSupportedException">Thrown when the library does not specify the correct magic number
in the ::EAffect structure or when it does not support VST version 2.4.</exception>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Set``1(System.String,``0)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="46">
<summary>
Sets a new <paramref name="value"/> for the <paramref name="keyName"/> property.
</summary>
<typeparam name="T">Inferred, no need to specify explicitly.</typeparam>
<param name="keyName">The name of the key used to identify the property.</param>
<param name="value">The value of the property.</param>
<remarks>When an existing value is overwritten the <see cref="E:Jacobi.Vst.Interop.Host.VstPluginContext.PropertyChanged"/> event fires.
When the <paramref name="value"/> implements <see cref="T:System.IDisposable"/> it is called
when this instance of the plugin context is disposed.
</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Find``1(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="58">
<summary>
Retrieves the value for the <paramref name="keyName"/> property.
</summary>
<typeparam name="T">The data type of the property.</typeparam>
<param name="keyName">The name of the key used to identify the property.</param>
<returns>Returns the value of the property identified by <paramref name="keyName"/>
or default(T) when it was not found.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Remove(System.String)" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="67">
<summary>
Removes the <paramref name="keyName"/> property from the plugin context.
</summary>
<param name="keyName">The name of the key used to identify the property.</param>
<remarks><see cref="!:System::IDisposable::Dispose"/> is <b>NOT</b> called on the property.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Delete(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="74">
<summary>
Deletes the <paramref name="keyName"/> property and removes it from the plugin context.
</summary>
<param name="keyName">The name of the key used to identify the property.</param>
<remarks><see cref="!:System::IDisposable::Dispose"/> <i>is</i> called on the property (when implemented).</remarks>
</member>
<member name="P:Jacobi.Vst.Interop.Host.VstPluginContext.HostCommandStub" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="81">
<summary>
Gets the reference to the host command stub passed into the ctor.
</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Host.VstPluginContext.PluginCommandStub" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="87">
<summary>
Gets the reference to the plugin command stub.
</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Host.VstPluginContext.PluginInfo" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="96">
<summary>
Gets the reference to the plugin info.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.AcceptPluginInfoData(System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="112">
<summary>
Copies the unmanaged property values to the <see cref="P:Jacobi.Vst.Interop.Host.VstPluginContext.PluginInfo"/> properties.
</summary>
<param name="raiseEvents">When true the <see cref="E:Jacobi.Vst.Interop.Host.VstPluginContext.PropertyChanged"/> event 
is raised for each property that has changed.</param>
</member>
<member name="E:Jacobi.Vst.Interop.Host.VstPluginContext.PropertyChanged" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="120">
<summary>
Raised when a property is changed on the plugin context.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.#ctor(Jacobi.Vst.Core.Host.IVstHostCommandStub)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="126">
<summary>Constructor for derived classes.</summary>
<param name="hostCmdStub">Reference is stored at the <see cref="P:Jacobi.Vst.Interop.Host.VstPluginContext.HostCommandStub"/> property 
and its <see cref="P:Jacobi.Vst.Core.Host.IVstHostCommandStub.PluginContext"/> property is set. 
Must not be null.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.RaisePropertyChanged(System.String)" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="132">
<summary>Raises the <see cref="E:Jacobi.Vst.Interop.Host.VstPluginContext.PropertyChanged"/> event for the <paramref name="propName"/> property.</summary>
<param name="propName">The name of the property that has changed. Must not be null or empty.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Initialize(System.String)" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="137">
<summary>Implemented by derived classes to initialize the instance.</summary>
<param name="pluginPath">An absolute path the the plugin dll. Must not be null or empty.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginContext.Uninitialize" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincontext.h" line="140">
<summary>Implemented by derived classes to clean up resources.</summary>
</member>
<member name="T:Jacobi.Vst.Interop.Host.VstManagedPluginContext" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstmanagedplugincontext.h" line="10">
<summary>
Implements a PluginContext for a Managed Plugin, bypassing the double interop that would occur.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstManagedPluginContext.AcceptPluginInfoData(System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstmanagedplugincontext.h" line="16">
<summary>
Not implemented.
</summary>
<param name="raiseEvents">Not used.</param>
<remarks>The managed plugin context sets new <see cref="T:Jacobi.Vst.Core.Plugin.VstPluginInfo"/> using the
setter of the <see cref="P:Jacobi.Vst.Interop.Host.VstPluginContext.PluginInfo"/> property.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstManagedPluginContext.CreateInternal(System.String,Jacobi.Vst.Core.Host.IVstHostCommandStub)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstmanagedplugincontext.h" line="25">
<summary>
Constructs a new uninitialized instance using the <paramref name="hostCmdStub"/>.
</summary>
<param name="pluginPath">An absolute path the the plugin dll. Must not be null or empty.</param>
<param name="hostCmdStub">An implementation of the host command stub. Must not be null.</param>
<remarks>Returns null when not successful.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstManagedPluginContext.#ctor(Jacobi.Vst.Core.Host.IVstHostCommandStub)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstmanagedplugincontext.h" line="34">
<summary>
Constructs a new uninitialized instance using the <paramref name="hostCmdStub"/>.
</summary>
<param name="hostCmdStub">An implementation of the host command stub. Must not be null.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstManagedPluginContext.Initialize(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstmanagedplugincontext.h" line="40">
<summary>
Initializes the PluginContext instance with the plugin pointed to by the <paramref name="pluginPath"/>.
</summary>
<param name="pluginPath">An absolute path the the plugin dll (that contains the exported 
'VSTPluginMain' function). Must not be null or empty.</param>
</member>
<member name="T:Jacobi.Vst.Interop.Plugin.Configuration" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="8">
<summary>
The Configuration class manages the plugin specific config file.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Plugin.Configuration.#ctor(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="14">
<summary>
Constructs a new instance based on the file path of the plugin assembly (renamed Interop).
</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Plugin.Configuration.IsValid" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="19">
<summary>

</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Plugin.Configuration.PluginConfig" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="25">
<summary>
The loaded configuration object. Can be null.
</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Plugin.Configuration.ProbePaths" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="31">
<summary>
The probe path config setting. Can be null.
</summary>
</member>
<member name="P:Jacobi.Vst.Interop.Plugin.Configuration.ManagedAssemblyName" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="37">
<summary>
The managed assembly name override. Can be null.
</summary>
</member>
<member name="F:Jacobi.Vst.Interop.Plugin.Configuration.VstNetProbePaths" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="43">
<summary>
The appSettgins config setting 'vstnetProbePaths'.
</summary>
</member>
<member name="F:Jacobi.Vst.Interop.Plugin.Configuration.VstNetManagedAssemblyName" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\plugin\configuration.h" line="48">
<summary>
The appSettgins config setting 'vstnetManagedAssemblyName'.
</summary>
</member>
<member name="T:Jacobi.Vst.Interop.Bootstrapper" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\bootstrapper.h" line="9">
<summary>
The Bootstrapper class temporarily subscribes to the AssemlbyResolve event of the current AppDomain.
</summary>
<remarks>
It is only used to load the Jacobi.Vst.Core assembly.
</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Bootstrapper.#ctor(System.String,Jacobi.Vst.Interop.Plugin.Configuration)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\bootstrapper.h" line="18">
<summary>
Constructs a new instance initialized with the specified <paramref name="basePath"/>
as well as the paths loaded from the "vstnetProbePaths" config appSettings.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Bootstrapper.Dispose" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\bootstrapper.h" line="23">
<summary>
Destructor.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Bootstrapper.Finalize" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\bootstrapper.h" line="27">
<summary>
Unregisters the bootstrapper from the AssemlbyResolve event.
</summary>
</member>
</members>
</doc>