﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TinyFM8.UserControls
{
    public partial class panelOpOsc : UserControl
    {
        public PatchData pd;
        public EventHandler UIChanged;
        public int OpIndex;
        public CheckBox[] Waveforms = new CheckBox[8];

        private bool InternalValueChange = false;


        private void CreateWaveformImage(int WaveformIndex, CheckBox chk)
        {
            float[] waveform = new float[0x10000];
            SoundRenderInterface.GetWaveform(WaveformIndex, waveform);

            var height = chkWaveform1.ClientRectangle.Height * 8 / 10;
            var width  = chkWaveform1.ClientRectangle.Width  * 8 / 10;
            var bmp = new Bitmap(width, height);
            var g = Graphics.FromImage(bmp);
            g.Clear(Color.FromArgb(0));

            var pnt = (float)((1.0 - waveform[0]) / 2.1 * height);
            for (int x = 1; x < width; x++)
            {
                var newPnt = (float)((1.0 - waveform[(2 * x * 0x10000 / width) % 0x10000]) / 2.1 * height);
                g.DrawLine(Pens.Black, x-1, pnt, x, newPnt);
                pnt = newPnt;
            }
            
            g.Dispose();

            chk.Image = bmp;
        }

        public void LoadFromData()
        {
            if (pd == null)
                return;

            var wf = pd.OP_Waveform[OpIndex];

            // Block self change reporting
            InternalValueChange = true;

            // Update checkboxs
            for (int i = 0; i < Waveforms.Length; i++)
                Waveforms[i].Checked = (wf == i);

            chkKeySync.Checked = pd.OP_KeySync[OpIndex] != 0;
            knobVelocity.Value = pd.OP_Velocity[OpIndex];
            updwnOffset.Value  = (decimal)pd.OP_Offset[OpIndex];
            updwnRadio.Value   = (decimal)pd.OP_Ratio[OpIndex];

            InternalValueChange = false;
        }

        public void SaveToData()
        {
            if (pd == null)
                return;

            // Search for waveform
            for (int i = 0; i < Waveforms.Length; i++)
                if (Waveforms[i].Checked)
                    pd.OP_Waveform[OpIndex] = (byte)i;

            pd.OP_KeySync[OpIndex]  = (byte)(chkKeySync.Checked ? 1 : 0);
            pd.OP_Velocity[OpIndex] = (sbyte)knobVelocity.Value;
            pd.OP_Offset[OpIndex]   = (float)updwnOffset.Value;
            pd.OP_Ratio[OpIndex]    = (float)updwnRadio.Value;
        }

        public panelOpOsc()
        {
            InitializeComponent();

            Waveforms[0] = chkWaveform1;
            Waveforms[1] = chkWaveform2;
            Waveforms[2] = chkWaveform3;
            Waveforms[3] = chkWaveform4;
            Waveforms[4] = chkWaveform5;
            Waveforms[5] = chkWaveform6;
            Waveforms[6] = chkWaveform7;
            Waveforms[7] = chkWaveform8;

            // Create button images
            var desgintime = (System.Diagnostics.Process.GetCurrentProcess().ProcessName == "devenv");
            if (!desgintime)
                for (int i = 0; i < Waveforms.Length; i++)
                    CreateWaveformImage(i, Waveforms[i]);
        }

        private void chkWaveform1_CheckedChanged(object sender, EventArgs e)
        {
            // Block re-entry caused by self changing checkbox states
            if (InternalValueChange)
                return;
            if (pd == null)
                return;

            // Turn on and off
            InternalValueChange = true;
            foreach (var chk in Waveforms)
                chk.Checked = (chk != sender) ? false : true;
            InternalValueChange = false;

            // Report value changes
            ValueChanged(null, null);
        }

        private void ValueChanged(object sender, EventArgs e)
        {
            // Block re-entry caused by self changing 
            if (InternalValueChange)
                return;
            if (pd == null)
                return;

            // Save data
            if (UIChanged != null)
                UIChanged(this, null);
        }
    }
}
