﻿using System;
using System.Collections.Generic;
using System.Text;
using Jacobi.Vst.Framework;
using System.IO;
using Jacobi.Vst.Core;
using Jacobi.Vst.Framework.Plugin;
using Jacobi.Vst.Framework.Plugin.IO;

namespace TinyFM8
{
    public class PluginPersistence : VstPluginPersistenceBase
    {
        private Plugin _plugin;
        public string KSDFile = "";

        /// <summary>
        /// Constructs a new instance.
        /// </summary>
        /// <param name="plugin">Must not be null.</param>
        public PluginPersistence(Plugin plugin)
        {
            _plugin = plugin;
        }

        protected override VstProgramReaderBase CreateProgramReader(Stream input)
        {
            return new ProgramReader(_plugin, input, Encoding);
        }

        public override void WritePrograms(Stream stream, VstProgramCollection programs)
        {
            base.WritePrograms(stream, programs);

            //var bw = new BinaryWriter(stream);
            //bw.Write(data);
        }

        public override void ReadPrograms(Stream stream, VstProgramCollection programs)
        {
            base.ReadPrograms(stream, programs);

            try
            {
                // Load into data array
                var br = new BinaryReader(stream);
                int basePos = (int)stream.Position;

                //byte[] data = new byte[stream.Length - stream.Position];
                //br.Read(data, 0, data.Length);
            }
            catch (Exception)
            {
            }
        }

        private class ProgramReader : VstProgramReaderBase
        {
            private Plugin _plugin;
            private Stream _stream;

            public ProgramReader(Plugin plugin, Stream input, Encoding encoding)
                : base(input, encoding)
            {
                _plugin = plugin;
                _stream = input;
            }

            protected override VstProgram CreateProgram()
            {
                var program = new VstProgram();
                _plugin.BuildParameterCollection(program.Parameters);


                try
                {
                    // Load things
                    //var br = new BinaryReader(_stream);
                    //program.Name = br.ReadString();
                }
                catch (Exception)
                {
                }

                return program;
            }
        }
    }
}
