﻿using System;
using Jacobi.Vst.Core;
using Jacobi.Vst.Framework;
using Jacobi.Vst.Framework.Common;
using System.Runtime.InteropServices;
using System.IO;
using System.Windows.Forms;
using Jacobi.Vst.Interop.Host;
using System.Reflection;

namespace TinyFM8
{
    /// <summary>
    /// Implements the custom UI editor for the plugin.
    /// </summary>
    public class PluginEditor : IVstPluginEditor
    {
        [DllImport("user32.dll")]
        public static extern IntPtr SetParent(IntPtr child, IntPtr newParent);

        private Plugin _plugin;
        private WinFormsControlWrapper<MainUserInterface> _uiWrapper = new WinFormsControlWrapper<MainUserInterface>();

        /// <summary>
        /// Constructs a new instance.
        /// </summary>
        /// <param name="plugin">Must not be null.</param>
        public PluginEditor(Plugin plugin)
        {
            _plugin = plugin;

            plugin.UserInterface = new MainUserInterface();
            plugin.UserInterface._plugin = plugin;
        }

        #region IVstPluginEditor Members

        public System.Drawing.Rectangle Bounds
        {
            get { return _plugin.UserInterface.Bounds; }
        }

        public void Close()
        {
            // Hide user interface
            _plugin.UserInterface.Hide();
        }

        public bool KeyDown(byte ascii, VstVirtualKey virtualKey, VstModifierKeys modifers)
        {
            return false;
        }

        public bool KeyUp(byte ascii, VstVirtualKey virtualKey, VstModifierKeys modifers)
        {
            return false;
        }

        public VstKnobMode KnobMode { get; set; }

        public void Open(IntPtr hWnd)
        {
            SetParent(_plugin.UserInterface.Handle, hWnd);
            _plugin.UserInterface.Show();
        }

        public void ProcessIdle()
        {
        }

        #endregion
    }
}
