#include "FM8_Utils.h"

#pragma pack(push, 1)

struct FM8_VariableStateFilter
{
    // Setup parameters
    float Damp;
    float Freq;

    // PrevSample
    float PrevSample;

    // Outputs
    float Low;
    float High;
    float Band;
    float Notch;

    void Setup(float CutOffFreq, float SampleRate, float Resonance);
    void ExecuteFilter(float input);
};

struct FM8_Synth
{
    float Gain;

    // loaded ints
    Int8 TrackIndex;
    Int8 Polyphony_Voices;
    Int8 Unison_Voices;
    Int8 Unison_Detune;
    Int8 Unison_Pan;

    Int8 OPX_NoiseCutOff;
    Int8 OPX_NoiseReso;
    Int8 OPX_NoiseAmp;
    Int8 OPX_SatLimit;
    Int8 OPX_SatGain;

    Int8 OPZ_CutOff;
    Int8 OPZ_Spread;
    Int8 OPZ_Reso1;
    Int8 OPZ_Reso2;
    Int8 OPZ_Mode1;
    Int8 OPZ_Mode2;
    Int8 OPZ_Routing;
    Int8 OPZ_Mix;

    Int8 Pitch_Envelope;
    Int8 Pitch_Transp;    // (float)Convert to float

    Int8 FM_Matrix[8][8];
    Int8 OP_Waveform[9];
    Int8 OP_Velocity[9];
    Int8 OP_KeySync[9];
    Int8 OP_OutVol[9];
    Int8 OP_OutPan[9];
    Int8 OP_KeyScale[9];
    Int8 OP_KeyScale_Length[9];
    Int8 OP_Env_Length[9];
    Int8 OP_Env_SustainLoopStart[9];
    Int8 OP_Env_SustainLoopEnd[9];

    // loaded floats
    float OP_Ratio[9];  // Loaded as float
    float OP_Offset[9]; // Loaded as float

    Int8  OP_KeySc_Note [9/*8*/][128]; Int8 space1[3456];
    Int8  OP_KeySc_Level[9/*8*/][128]; Int8 space2[3456];
    float OP_KeySc_Slope[9/*8*/][128];

    float OP_Env_Level[9][128]; 
    float OP_Env_Slope[9][128]; 
    float OP_Env_RelTime[9][128]; 

    // Pre-Computed fields
    float pcPitch_Transp;
    float pcOpX_NoiseAmp;
    float pcFM_Matrix[8][8];
    float pcOP_OutVol[18];
    float pcOP_Env_AbsTime[9][128]; // Needs to be computed manual

    // Cashing
    float csTimeScale[9];
    float csEnvRelease[9];
    float csKeyScaleAmp[9];
    float csVelocityAmp[9];
    
    // Current note info
    int   ActiveOperators;
    int   Note_Index;
    int   SampleCounter;
    float Note_Velocity;
    float TimeFromPress;
    float TimeRelease;

    // Envelope time relatex
    bool  EnvelopeActive[9];
    float EnvelopeIncrement[10];
    float EnvelopeCurrent[10];

    // DSP related
    float FMMatrixValue[8];
    float OscPos[6];

    // General helpers
    FM8_VariableStateFilter OpX_VSF;
    FM8_VariableStateFilter OpZ_S1_VSF;
    FM8_VariableStateFilter OpZ_S2_VSF;

    void  SetupInstrument();
    float GetScaleValue(int OpIndex, float NoteIndex);
    float GetEnvValue(int OpIndex, float Time_PressToNow, float Time_PressToRelease, bool& bActive);
    void  RenderToBuffer(float* buffer, int bufferLengthInSamples);
	void  RenderEnvelope(int OpIndex, float FromT, float ToT, int Samples, float* pBuffer);

    void PlayNote(int NoteIndex, int VoiceIndex);
    void SetVelocity(float Velocity);
    void ReleaseNote();
    
};

#pragma pack(pop)

void   FM8_GenerateWaveTable();
int    FM8_LoadInstruments(UInt8* pBlock, FM8_Synth*& pInstruments);
float* FM8_Waveform(int WaveformIndex);

