#include <math.h>
#include "FM8_AppAbstractionLayer.h"
#include "FM8_Utils.h"
#include "FM8_Compressor.h"


#ifdef ENABLE_SAMPLE_LOGGING
HANDLE out_in;
HANDLE out_indb;
HANDLE out_coef;
HANDLE out_envdb;
HANDLE out_gaindb;
HANDLE out_gain;
HANDLE out_out;
#endif

// DC offset (to prevent denormal)
// USE:
// 1. init envelope state to DC_OFFSET before processing
// 2. add to input before envelope runtime function
static const double DC_OFFSET = 1.0E-25;


void FM8_Compressor::Setup()
{
	LOG_CREATE(out_in,     "C:\\temp\\Data\\in.raw");
	LOG_CREATE(out_indb,   "C:\\temp\\Data\\indb.raw");
	LOG_CREATE(out_coef,   "C:\\temp\\Data\\coef.raw");
	LOG_CREATE(out_envdb,  "C:\\temp\\Data\\envdb.raw");
	LOG_CREATE(out_gaindb, "C:\\temp\\Data\\gaindb.raw"); 
	LOG_CREATE(out_gain,   "C:\\temp\\Data\\gain.raw");
	LOG_CREATE(out_out,    "C:\\temp\\Data\\out.raw");

    m_ratio              = 1 / (1 + 15.0f * LV_Ratio / 100) - 1; // m_ratio=0=no_change, m_ration=-1=limiter
    m_thresholdB         = LV_Threshold;
    m_makeup_gain        = dB2lin(LV_MakeupGain + (LV_Threshold + 20) * m_ratio);
    m_env_rms_state      = 0;
    m_env_overB_state    = 0;
    m_env_overB_coef_att = FM8_expf(-1000.0f / (SAMPLE_RATE * (0.001f +  10.0f/*ms*/ * LV_AttackTime / 100)));
    m_env_overB_coef_rel = FM8_expf(-1000.0f / (SAMPLE_RATE * (0.001f + 100.0f/*ms*/ * LV_ReleaseTime / 100)));
    //m_env_rms_coef     = FM8_expf(-1000.0f / ( 5 * SAMPLE_RATE ) );
}

void FM8_Compressor::Process(float& in1, float& in2)
{
    /*
    // sum square of input
    float inSq1 = in1 * in1;	
    float inSq2 = in2 * in2;
    float sum = inSq1 + inSq2;

    // Compute rms envelope
    m_env_rms_state = sum + m_env_rms_coef * ( m_env_rms_state - sum );

    // convert key to dB
    float rmsdB = lin2dB( m_env_rms_state + DC_OFFSET);	// convert linear -> dB

    // 
    rmsdB *= 0.5; // same as sqrtf() before lin2dB
    */
    
    // rectify input
    float rect1 = fabs(in1);
    float rect2 = fabs(in2);
    
    // link channels with greater of two channels
    float link = (rect1 > rect2) ? rect1 : rect2;	
	LOG_SAMPLE(out_in, in1);

    // convert linear -> dB
    float rmsdB = lin2dB(link + DC_OFFSET);	
	LOG_SAMPLE(out_indb, rmsdB);

    // find delta over threshold
    float overdB = rmsdB - m_thresholdB;	
    if ( overdB < 0.0 ) overdB = 0.0;

    // find if we're in attack or release mode
    float coef = m_env_overB_coef_att;
    if (overdB < m_env_overB_state)
        coef = m_env_overB_coef_rel;
	LOG_SAMPLE(out_coef, coef);

	// perform the IIR filtering
    m_env_overB_state = overdB + coef * ( m_env_overB_state - overdB );
	LOG_SAMPLE(out_envdb, m_env_overB_state);

    // transfer function using ratio - computes gain reduction in dB
    float gr = m_env_overB_state * m_ratio;	
	LOG_SAMPLE(out_gaindb, gr);

	// coonvert gain from db-to-linear
	LOG_SAMPLE(out_gain, dB2lin( gr ));
    gr = m_makeup_gain * dB2lin( gr );	

    // output gain - apply gain reduction to input
    in1 *= gr;	
    in2 *= gr;
	LOG_SAMPLE(out_out, in1);
}

void FM8_Compressor::Render(float* pBuffer, int nBufferSize)
{
	for (int i=0; i<nBufferSize; i++)
		Process(pBuffer[i * 2 + 0], pBuffer[i * 2 + 1]);
}

int FM8_CreateCompressors(void* pBlock, FM8_Compressor** pCompressors)
{
	int nCount = LoadInterlacedStruct((UInt8*&)pBlock, (UInt8*&)pCompressors[0], sizeof(FM8_Compressor), 5);

	// Run Setup
	for (int i = 0; i < nCount; i++)
	{
		pCompressors[i] = &pCompressors[0][i];
		pCompressors[i]->Setup();
	}

	return nCount;
}
