#pragma once

// This header file provides an abstraction layer for the OS services.
// Currently it is based on modified version of IQ 64kb framework. 
// Changing #define statements is the only thing you need do inorder for TinyFM8 
// to use your own framework resources.

// Those includes should be deleted if you choose to custom framework.
#include "msys\msys_math.h"
#include "msys\msys_random.h"
#include "msys\msys_sound.h"
#include "msys\msys_memory.h"

// Memory related methods
#define FM8_memset msys_memset
#define FM8_memcpy msys_memcpy
#define FM8_mallocAlloc msys_mallocAlloc
#define FM8_mallocFree  msys_mallocFree

// Math related methods
#define FM8_powf   msys_powf
#define FM8_expf   msys_expf
#define FM8_log2f  msys_log2f
#define FM8_sinf   msys_sinf

// Random related methods
#define FM8_irand  msys_rand
#define FM8_frand  msys_frand
#define FM8_sfrand msys_sfrand

// Sound Outputing
#define SAMPLE_RATE 44100
#define FM8_soundInit            msys_soundInit
#define FM8_soundStart           msys_soundStart
#define FM8_soundEnd             msys_soundEnd
#define FM8_soundGetPosInSamples msys_soundGetPosInSamples
