#pragma once

#define WIN32_LEAN_AND_MEAN             // Exclude rarely-used stuff from Windows headers
#include <windows.h>

extern "C"
{
    struct FM8_Synth;
    struct FM8_Compressor;
    struct FM8_Reverb;

    __declspec(dllexport) void __stdcall  BuildWaveforms();
    __declspec(dllexport) int __stdcall  CreateInstruments(void* pBlock, FM8_Synth** pInstruments);
    __declspec(dllexport) int __stdcall  CreateCompressors(void* pBlock, FM8_Compressor** pCompressors);
    __declspec(dllexport) int __stdcall CreateReverbs(void* pBlock, FM8_Reverb** pReverb);
    __declspec(dllexport) FM8_Synth*  __stdcall DuplicateInstrument(FM8_Synth* Handle);
    __declspec(dllexport) void __stdcall PlayNote(FM8_Synth* Handle, int NoteIndex, int VoiceIndex);
    __declspec(dllexport) void __stdcall SetVelocity(FM8_Synth* Handle, float Velocity);
    __declspec(dllexport) void __stdcall OffNote(FM8_Synth* Handle);
    __declspec(dllexport) void __stdcall CompressorRender(FM8_Compressor* Handle, float* pBuffer, int nBufferSize);
    __declspec(dllexport) void __stdcall ReverbRender(FM8_Reverb* pLeft, FM8_Reverb* pRight, float* pBuffer, int nBufferSize);
    __declspec(dllexport) void __stdcall SynthRender(FM8_Synth* Handle, float* pBuffer, int nBufferSize);
    __declspec(dllexport) int __stdcall GetVoices(FM8_Synth* Handle);
    __declspec(dllexport) int __stdcall GetNote(FM8_Synth* Handle);
    __declspec(dllexport) int __stdcall GetTrackIndex(FM8_Synth* Handle);
	__declspec(dllexport) void  __stdcall GetWaveform(int nWaveformIndex, float* pBuffer);
}
