﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jacobi.Vst.Framework;

public class VstParameterInfoEx : VstParameterInfo
{
    public string Formatting;

    public float MinRange = 0;
    public float MaxRange = 1;

    public int TrackMin = 0;
    public int TrackMax = 128;

    public VstParameterInfoEx(string Name, string Label, string Formatting, string Postfix, float DefaultValue, float MinValue, float MaxValue, int TrackMin, int TrackMax, int nSteps, out VstParameterManager paramManager)
    {
        // Make parameter editable
        CanBeAutomated = true;

        // Setup names
        this.Formatting = Formatting;
        this.Name = Name;
        this.Label = Label;
        this.ShortLabel = Postfix;

        // Setup ranges
        this.MaxRange = MaxValue;
        this.MinRange = MinValue;
        this.TrackMax = TrackMax;
        this.TrackMin = TrackMin;

        // Setup steps
        LargeStepFloat = SmallStepFloat = StepFloat = 1f / nSteps;

        // Setup Default value
        this.DefaultValue = (DefaultValue - MinRange) / (MaxValue - MinValue);

        // Create Parameter manage
        paramManager = new VstParameterManager(this);
    }
}

public class VstParameterEx : VstParameter
{
    public VstParameterEx(VstParameterInfoEx parameterInfo)
        : base(parameterInfo)
    {
    }

    public int TrackValue
    {
        get
        {
            var TrackMin = (base.Info as VstParameterInfoEx).TrackMin;
            var TrackMax = (base.Info as VstParameterInfoEx).TrackMax;

            return (int)Math.Round(base.Value * (TrackMax - TrackMin) + TrackMin);
        }
    }

    public float ScaledValue
    {
        get
        {
            var MinRange = (base.Info as VstParameterInfoEx).MinRange;
            var MaxRange = (base.Info as VstParameterInfoEx).MaxRange;

            return base.Value * (MaxRange - MinRange) + MinRange;
        }

        set
        {
            var MinRange = (base.Info as VstParameterInfoEx).MinRange;
            var MaxRange = (base.Info as VstParameterInfoEx).MaxRange;

            base.Value = (value - MinRange) / (MaxRange - MinRange);
        }
    }

    public override string DisplayValue
    {
        get
        {
            return string.Format((base.Info as VstParameterInfoEx).Formatting, ScaledValue);
        }

        protected set
        {
            if (string.IsNullOrEmpty(value))
                return;

            ScaledValue = float.Parse(value);
        }
    }
}
