﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Jacobi.Vst.Framework;

public class ReverbData
{
    public VstParameterInfoCollection ParameterInfos = new VstParameterInfoCollection();
    public List<VstParameterEx> Parameters = new List<VstParameterEx>();

    public VstParameterManager prmInputDiffuse1Mgr;
    public VstParameterManager prmInputDiffuse2Mgr;
    public VstParameterManager prmBandLimiterMgr;
    public VstParameterManager prmTimeMgr;
    public VstParameterManager prmDampingMgr;
    public VstParameterManager prmOutGainMgr;

    public VstParameterEx prmInputDiffuse1;
    public VstParameterEx prmInputDiffuse2;
    public VstParameterEx prmBandLimiter;
    public VstParameterEx prmTime;
    public VstParameterEx prmDamping;
    public VstParameterEx prmOutGain;

    private void CreateParam(string Name, string Label, string Formatter, string PostFix, float DefaultValue, float MinValue, float MaxValue, int TrackMin, int TrackMax, int nSteps, out VstParameterManager paramManager, out VstParameterEx param)
    {
        var prmInfo = new VstParameterInfoEx(Name, Label, Formatter, PostFix, DefaultValue, MinValue, MaxValue, TrackMin, TrackMax, nSteps, out paramManager);
        param = new VstParameterEx(prmInfo);
        Parameters.Add(param);
        ParameterInfos.Add(prmInfo);
    }

    public ReverbData()
    {
        CreateParam("Difuse1",     "Difuse1",     "{0:0}",  "%",  75,   0,  100,    0, 100, 100, out prmInputDiffuse1Mgr, out prmInputDiffuse1);
        CreateParam("Difuse2",     "Difuse2",     "{0:0}",  "%",  65,   0,  100,    0, 100, 100, out prmInputDiffuse2Mgr, out prmInputDiffuse2);
        CreateParam("BandLmt",     "BandLmt",     "{0:0}",  "%",  50,   0,  100,    0, 100, 100, out prmBandLimiterMgr,   out prmBandLimiter);
        CreateParam("Time",           "Time", "{0:0.000}", "ms", 600,  0f, 1000,    0, 100, 100, out prmTimeMgr,          out prmTime);
        CreateParam("Damping",     "Damping",     "{0:0}",  "%",  50,   0,  100,    0, 100, 100, out prmDampingMgr,       out prmDamping);
        CreateParam("OutGain",     "OutGain",  "{0:0.00}", "dB",   0, -50,   50,  -50,  50, 100, out prmOutGainMgr,       out prmOutGain);
    }
}
