﻿using System;
using System.Collections.Generic;
using System.Text;
using Jacobi.Vst.Framework;
using System.IO;
using Jacobi.Vst.Core;
using Jacobi.Vst.Framework.Plugin;
using Jacobi.Vst.Framework.Plugin.IO;

namespace ReverbFX
{
    public class PluginPersistence : VstPluginPersistenceBase
    {
        private Plugin _plugin;
        public string KSDFile = "";
        private ProgramReader reader;

        /// <summary>
        /// Constructs a new instance.
        /// </summary>
        /// <param name="plugin">Must not be null.</param>
        public PluginPersistence(Plugin plugin)
        {
            _plugin = plugin;
        }

        protected override VstProgramReaderBase CreateProgramReader(Stream input)
        {
            return null;
        }

        public override void WritePrograms(Stream stream, VstProgramCollection programs)
        {
            base.WritePrograms(stream, programs);
            if (_plugin.control == null)
                return;

            var bw = new BinaryWriter(stream);
            bw.Write(10);
        }

        public override void ReadPrograms(Stream stream, VstProgramCollection programs)
        {
            reader = new ProgramReader(_plugin, stream, Encoding);
            reader.ReadPrograms(programs);
            var prms = programs[0].Parameters;
            var prm = prms[0];
            prm.ToString();

            try
            {
                // Load into data array
                var br = new BinaryReader(stream);
                int basePos = (int)stream.Position;

                byte[] data = new byte[stream.Length - stream.Position];
                br.Read(data, 0, data.Length);

                // set arrau to host
                _plugin.UpdateDisplay();
            }
            catch (Exception)
            {
            }
        }

        private class ProgramReader : VstProgramReaderBase
        {
            private Plugin _plugin;

            public ProgramReader(Plugin plugin, Stream input, Encoding encoding)
                : base(input, encoding)
            {
                _plugin = plugin;
            }

            public void ReadPrograms(VstProgramCollection programs)
            {
                int count = ReadProgramHeader(programs);

                for (int i = 0; i < count; i++)
                {
                    VstProgram program = ReadProgram(i);

                    if (i == 0)
                        programs.Add(program);
                }
                programs[0].Name = "Parameters";
            }

            protected VstProgram ReadProgram(int index)
            {
                VstProgram program = CreateProgram(index == 0);

                program.Name = Reader.ReadString();

                ReadParameters(program.Parameters);

                return program;
            }

            protected override VstProgram CreateProgram()
            {
                return null;
            }

            protected VstProgram CreateProgram(bool bLink)
            {
                VstProgram program = new VstProgram(_plugin.ParameterFactory.Categories);

                _plugin.ParameterFactory.CreateParameters(program.Parameters, bLink ? _plugin.Param.Parameters : null);

                return program;
            }
        }
    }
}
