using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Reflection;
using System.Collections.Generic;
using KSDManager;
using ComponentAce.Compression.Libs.zlib;
using LZF.NET;

namespace CompressFile
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
    {
		private System.Windows.Forms.Button button2;
        private System.Windows.Forms.OpenFileDialog openFileDialog1;
        private TextBox txtFileName;
        private Button btnBrowse;
        private TextBox textBox1;
        private Panel panel1;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
        private TrackBar trackBar1;
        private Label label1;
        private Panel panel2;

        private KSDData m_KSD;
        //private FMInstrument m_FMInst;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.button2 = new System.Windows.Forms.Button();
            this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
            this.txtFileName = new System.Windows.Forms.TextBox();
            this.btnBrowse = new System.Windows.Forms.Button();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.panel1 = new System.Windows.Forms.Panel();
            this.trackBar1 = new System.Windows.Forms.TrackBar();
            this.label1 = new System.Windows.Forms.Label();
            this.panel2 = new System.Windows.Forms.Panel();
            ((System.ComponentModel.ISupportInitialize)(this.trackBar1)).BeginInit();
            this.SuspendLayout();
            // 
            // button2
            // 
            this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.button2.Location = new System.Drawing.Point(12, 57);
            this.button2.Name = "button2";
            this.button2.Size = new System.Drawing.Size(891, 32);
            this.button2.TabIndex = 1;
            this.button2.Text = "Decode";
            this.button2.Click += new System.EventHandler(this.button2_Click);
            // 
            // openFileDialog1
            // 
            this.openFileDialog1.Filter = "FM8 Files (*.ksd)|*.ksd|All files (*.*)|*.*";
            // 
            // txtFileName
            // 
            this.txtFileName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtFileName.Location = new System.Drawing.Point(12, 31);
            this.txtFileName.Name = "txtFileName";
            this.txtFileName.Size = new System.Drawing.Size(865, 20);
            this.txtFileName.TabIndex = 2;
            this.txtFileName.Text = "C:\\Program Files\\Common Files\\Native Instruments\\FM8\\Sounds\\FM8 Factory\\Instrumen" +
                "ts\\Plucked Synth.nfm8";
            // 
            // btnBrowse
            // 
            this.btnBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnBrowse.Location = new System.Drawing.Point(879, 31);
            this.btnBrowse.Name = "btnBrowse";
            this.btnBrowse.Size = new System.Drawing.Size(24, 20);
            this.btnBrowse.TabIndex = 3;
            this.btnBrowse.Text = "...";
            this.btnBrowse.UseVisualStyleBackColor = true;
            this.btnBrowse.Click += new System.EventHandler(this.btnBrowse_Click);
            // 
            // textBox1
            // 
            this.textBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.textBox1.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(177)));
            this.textBox1.Location = new System.Drawing.Point(12, 98);
            this.textBox1.Multiline = true;
            this.textBox1.Name = "textBox1";
            this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.textBox1.Size = new System.Drawing.Size(890, 295);
            this.textBox1.TabIndex = 4;
            // 
            // panel1
            // 
            this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.panel1.BackColor = System.Drawing.Color.White;
            this.panel1.Location = new System.Drawing.Point(12, 459);
            this.panel1.Name = "panel1";
            this.panel1.Size = new System.Drawing.Size(440, 100);
            this.panel1.TabIndex = 5;
            this.panel1.Paint += new System.Windows.Forms.PaintEventHandler(this.panel1_Paint);
            // 
            // trackBar1
            // 
            this.trackBar1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.trackBar1.Location = new System.Drawing.Point(12, 408);
            this.trackBar1.Maximum = 100;
            this.trackBar1.Name = "trackBar1";
            this.trackBar1.Size = new System.Drawing.Size(891, 45);
            this.trackBar1.TabIndex = 6;
            this.trackBar1.Scroll += new System.EventHandler(this.trackBar1_Scroll);
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(12, 396);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(35, 13);
            this.label1.TabIndex = 7;
            this.label1.Text = "label1";
            // 
            // panel2
            // 
            this.panel2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.panel2.BackColor = System.Drawing.Color.White;
            this.panel2.Location = new System.Drawing.Point(462, 459);
            this.panel2.Name = "panel2";
            this.panel2.Size = new System.Drawing.Size(440, 100);
            this.panel2.TabIndex = 8;
            this.panel2.Paint += new System.Windows.Forms.PaintEventHandler(this.panel2_Paint);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(915, 571);
            this.Controls.Add(this.panel2);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.trackBar1);
            this.Controls.Add(this.panel1);
            this.Controls.Add(this.textBox1);
            this.Controls.Add(this.btnBrowse);
            this.Controls.Add(this.txtFileName);
            this.Controls.Add(this.button2);
            this.Name = "Form1";
            this.Text = "CompressFile demo (c) ComponentAce 2006";
            this.Load += new System.EventHandler(this.Form1_Load);
            ((System.ComponentModel.ISupportInitialize)(this.trackBar1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        public string PrintArray(Array value)
        {
            return PrintArray(value, "");
        }

        public string PrintArray(Array value, string Format)
        {
            if (value == null)
                return "";

            if (String.IsNullOrEmpty(Format))
                Format = "{0} ";

            var sb = new StringBuilder();
            foreach (var item in value)
                sb.Append(String.Format(Format, item));

            return sb.ToString();
        }

        public string ByteArrayToHex(Byte[] value)
        {
            var sb = new StringBuilder();
            for (int i = 0; i < value.Length; i++)
            {
                if ((i % 16 == 0) && (i > 0)) sb.AppendLine("");
                if (i % 16 == 0) sb.Append(i.ToString("X4") + ":  ");
                sb.Append(value[i].ToString("X2") + " ");
            }
            return sb.ToString();
        }

        public void PrintValue(StringBuilder sb, object Container, string FieldName)
        {
            string ValueStr = Container.GetType().GetField(FieldName).GetValue(Container).ToString();
            sb.AppendLine(FieldName + ": " + ValueStr);
        }

        private string PrintKSDData(KSDData data)
        {
            var sb = new StringBuilder();
            PrintValue(sb, data.Block1, "LFO1_ToggleOn");
            sb.AppendLine("LFO1_Waveform:" + data.Block1.LFO1_Waveform.ToString("x8"));
            PrintValue(sb, data.Block1, "LFO1_Rate");
            PrintValue(sb, data.Block1, "LFO1_Delay");
            PrintValue(sb, data.Block1, "LFO1_KeyScale");
            PrintValue(sb, data.Block1, "LFO1_VelScale");
            PrintValue(sb, data.Block1, "LFO1_ToggleSync");
            PrintValue(sb, data.Block1, "LFO1_ToggleKeySync");
            PrintValue(sb, data.Block1, "LFO1_ToggleInvert");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "LFO2_ToggleOn");
            sb.AppendLine("LFO2_Waveform:" + data.Block1.LFO1_Waveform.ToString("x8"));
            PrintValue(sb, data.Block1, "LFO2_Rate");
            PrintValue(sb, data.Block1, "LFO2_Delay");
            PrintValue(sb, data.Block1, "LFO2_KeyScale");
            PrintValue(sb, data.Block1, "LFO2_VelScale");
            PrintValue(sb, data.Block1, "LFO2_ToggleSync");
            PrintValue(sb, data.Block1, "LFO2_ToggleKeySync");
            PrintValue(sb, data.Block1, "LFO2_ToggleInvert");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Master_Polyphony_Voices");
            PrintValue(sb, data.Block1, "Master_Polyphony_Mono");
            //PrintValue(sb, data.Block1, "Master_Unison_Pan");
            //PrintValue(sb, data.Block1, "Master_Unison_Pan");

            PrintValue(sb, data.Block1, "Master_Unison_Voices");
            PrintValue(sb, data.Block1, "Master_Unison_Detune");
            PrintValue(sb, data.Block1, "Master_Unison_Pan");
            PrintValue(sb, data.Block1, "Master_Unison_Dynamic");
            PrintValue(sb, data.Block1, "Master_Pitch_Tune");
            PrintValue(sb, data.Block1, "Master_Quality_Analog");
            PrintValue(sb, data.Block1, "Master_Quality_Digital");
            PrintValue(sb, data.Block1, "Effects_Amount");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Overdrive_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Overdrive_Drive");
            PrintValue(sb, data.Block1, "Eff_Overdrive_Tone");
            PrintValue(sb, data.Block1, "Eff_Overdrive_Bass");
            PrintValue(sb, data.Block1, "Eff_Overdrive_Volume");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_TubeAmp_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_TubeAmp_Volume");
            PrintValue(sb, data.Block1, "Eff_TubeAmp_Drive");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Cabinet_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Cabinet_Type");
            PrintValue(sb, data.Block1, "Eff_Cabinet_Size");
            PrintValue(sb, data.Block1, "Eff_Cabinet_Air");
            PrintValue(sb, data.Block1, "Eff_Cabinet_Bass");
            PrintValue(sb, data.Block1, "Eff_Cabinet_Treble");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_EQ1");
            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_EQ2");
            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_EQ3");
            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_EQ4");
            PrintValue(sb, data.Block1, "Eff_ShelvingEQ_Volume");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_PeakEQ_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_EQ1");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_EQ2");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_Q1");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_EQ3");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_EQ4");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_Q2");
            PrintValue(sb, data.Block1, "Eff_PeakEQ_Volume");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_TalkWah_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_TalkWah_Mouth");
            PrintValue(sb, data.Block1, "Eff_TalkWah_ModWheel");
            PrintValue(sb, data.Block1, "Eff_TalkWah_Size");
            PrintValue(sb, data.Block1, "Eff_TalkWah_Bright");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Phaser_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Phaser_Rate");
            PrintValue(sb, data.Block1, "Eff_Phaser_Inv");
            PrintValue(sb, data.Block1, "Eff_Phaser_Sync");
            PrintValue(sb, data.Block1, "Eff_Phaser_Notches");
            PrintValue(sb, data.Block1, "Eff_Phaser_Color");
            PrintValue(sb, data.Block1, "Eff_Phaser_SweepMin");
            PrintValue(sb, data.Block1, "Eff_Phaser_SweepMax");
            PrintValue(sb, data.Block1, "Eff_Phaser_Rotate");
            PrintValue(sb, data.Block1, "Eff_Phaser_DryWet");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Flanger_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Flanger_Rate");
            PrintValue(sb, data.Block1, "Eff_Flanger_Color");
            PrintValue(sb, data.Block1, "Eff_Flanger_Rotate");
            PrintValue(sb, data.Block1, "Eff_Flanger_Depth");
            PrintValue(sb, data.Block1, "Eff_Flanger_Sync");
            PrintValue(sb, data.Block1, "Eff_Flanger_DryWet");
            PrintValue(sb, data.Block1, "Eff_Flanger_Inv");
            PrintValue(sb, data.Block1, "Eff_Flanger_Static");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Tremolo_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Rate");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Sync");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Intensity");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Stereo");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Width");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Attach");
            PrintValue(sb, data.Block1, "Eff_Tremolo_Decay");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Reverb_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Reverb_Time");
            PrintValue(sb, data.Block1, "Eff_Reverb_Bright");
            PrintValue(sb, data.Block1, "Eff_Reverb_Treble");
            PrintValue(sb, data.Block1, "Eff_Reverb_DryWet");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_PsycheDelay_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Time");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Tap");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Sync");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Feedback");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Reverse");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Stereo");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Detune");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_Pitch");
            PrintValue(sb, data.Block1, "Eff_PsycheDelay_DryWet");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Eff_Chorus_ToggleOn");
            PrintValue(sb, data.Block1, "Eff_Chorus_Time");
            PrintValue(sb, data.Block1, "Eff_Chorus_Invert");
            PrintValue(sb, data.Block1, "Eff_Chorus_Sync");
            PrintValue(sb, data.Block1, "Eff_Chorus_SyncDelay");
            PrintValue(sb, data.Block1, "Eff_Chorus_Diffuse");
            PrintValue(sb, data.Block1, "Eff_Chorus_LoCut");
            PrintValue(sb, data.Block1, "Eff_Chorus_HiCut");
            PrintValue(sb, data.Block1, "Eff_Chorus_Feedback");
            PrintValue(sb, data.Block1, "Eff_Chorus_ModRate");
            PrintValue(sb, data.Block1, "Eff_Chorus_ModDepth");
            PrintValue(sb, data.Block1, "Eff_Chorus_DryWet");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "OPX_NoiseAmp");
            PrintValue(sb, data.Block1, "OPX_NoiseReso");
            PrintValue(sb, data.Block1, "OPX_NoiseCutOff");
            PrintValue(sb, data.Block1, "OPX_SatGain");
            PrintValue(sb, data.Block1, "OPX_SatLimit");
            PrintValue(sb, data.Block1, "OPX_SatAsym");
            sb.AppendLine("");


            PrintValue(sb, data.Block1, "OPZ_Spread");
            PrintValue(sb, data.Block1, "OPZ_CutOff");
            PrintValue(sb, data.Block1, "OPZ_Mode1");
            PrintValue(sb, data.Block1, "OPZ_Mode2");
            PrintValue(sb, data.Block1, "OPZ_Reso1");
            PrintValue(sb, data.Block1, "OPZ_Reso2");
            PrintValue(sb, data.Block1, "OPZ_EnvAmt");
            PrintValue(sb, data.Block1, "OPZ_Routing");
            PrintValue(sb, data.Block1, "OPZ_Mix");
            sb.AppendLine("");

            PrintValue(sb, data.Block1, "Pitch_Velocity");
            PrintValue(sb, data.Block1, "Pitch_Envelope");
            PrintValue(sb, data.Block1, "Pitch_Time");
            PrintValue(sb, data.Block1, "Pitch_ToggleAuto");
            PrintValue(sb, data.Block1, "Pitch_ToggleOn");
            PrintValue(sb, data.Block1, "Pitch_Transp");
            PrintValue(sb, data.Block1, "Pitch_PBMode");
            sb.AppendLine("");

            sb.AppendLine("OP_Ratio:                " + PrintArray(data.Block1.OP_Ratio, "{0:0.0000} "));
            sb.AppendLine("OP_Offset:               " + PrintArray(data.Block1.OP_Offset, " {0:00.00} "));
            sb.AppendLine("OP_Velocity:             " + PrintArray(data.Block1.OP_Velocity, "   {0:000} "));
            sb.AppendLine("OP_Waveform:             " + PrintArray(data.Block1.OP_Waveform, "    {0:00} "));
            sb.AppendLine("OP_KeyScaling:           " + PrintArray(data.Block1.OP_KeyScaling, "   {0:000} "));
            sb.AppendLine("OP_VelScaling:           " + PrintArray(data.Block1.OP_VelScaling, "   {0:000} "));
            sb.AppendLine("OP_Active:               " + PrintArray(data.Block1.OP_Active, "     {0:0} "));
            sb.AppendLine("OP_Release:              " + PrintArray(data.Block1.OP_Release, "     {0:0} "));
            sb.AppendLine("OP_Sustain:              " + PrintArray(data.Block1.OP_Sustain, "     {0:0} "));
            sb.AppendLine("OP_PitchEnv:             " + PrintArray(data.Block1.OP_PitchEnv, "     {0:0} "));
            sb.AppendLine("OP_Invert:               " + PrintArray(data.Block1.OP_Invert, "     {0:0} "));
            sb.AppendLine("OP_TempoSync:            " + PrintArray(data.Block1.OP_TempoSync, "     {0:0} "));
            sb.AppendLine("OP_Env_SustainLoopStart: " + PrintArray(data.Block1.OP_Env_SustainLoopStart,  "     {0:0} "));
            sb.AppendLine("OP_Env_SustainLoopEnd:   " + PrintArray(data.Block1.OP_Env_SustainLoopEnd,    "     {0:0} "));

            // Print Matrix
            sb.AppendLine("OP_Matrix:    ");
            for (int i = 0; i < data.FM_Matrix.GetLength(0); i++)
            {
                sb.Append("             ");
                for (int j = 0; j < data.FM_Matrix.GetLength(1); j++)
                    sb.Append(data.FM_Matrix[i, j].ToString("000") + " ");
                sb.AppendLine("");
            }
            sb.AppendLine("OP_IN:       " + PrintArray(data.OP_IN, "{0:000} "));
            sb.AppendLine("OP_OutVol:   " + PrintArray(data.OP_OutVol, "{0:000} "));
            sb.AppendLine("OP_OutPan:   " + PrintArray(data.OP_OutPan, "{0:000} "));
            sb.AppendLine("");

            // Print Envelop data
            for (int i = 0; i < data.OP_Env_Level.Length; i++)
            {
                sb.AppendLine("OP " + (i + 1).ToString() + " Envelope:");
                sb.AppendLine("   Level:  " + PrintArray(data.OP_Env_Level[i],   "{0:0.00000} "));
                sb.AppendLine("   R-Time: " + PrintArray(data.OP_Env_RelTime[i], "{0:0.00000} "));
                sb.AppendLine("   Slope:  " + PrintArray(data.OP_Env_Slope[i],   "{0:0.00000} "));
            }
            sb.AppendLine("");

            for (int i = 0; i < data.OP_KeySc_Level.Length; i++)
            {
                sb.AppendLine("OP " + (i + 1).ToString() + " KeySc:");
                sb.AppendLine("   Note:  " + PrintArray(data.OP_KeySc_Note[i], "{0:0.00000} "));
                sb.AppendLine("   Level: " + PrintArray(data.OP_KeySc_Level[i], "{0:0.00000} "));
                sb.AppendLine("   Slope: " + PrintArray(data.OP_KeySc_Slope[i], "{0:0.00000} "));
            }
            sb.AppendLine("");

            sb.AppendLine("Mod_PB_Up            " + PrintArray(data.Block1.Mod_PB_Up           , "{0:000} "));
            sb.AppendLine("Mod_PB_Dn            " + PrintArray(data.Block1.Mod_PB_Dn           , "{0:000} "));
            sb.AppendLine("Mod_Modulation       " + PrintArray(data.Block1.Mod_Modulation      , "{0:000} "));
            sb.AppendLine("Mod_AfterTouch       " + PrintArray(data.Block1.Mod_AfterTouch      , "{0:000} "));
            sb.AppendLine("Mod_Breath           " + PrintArray(data.Block1.Mod_Breath          , "{0:000} "));
            sb.AppendLine("Mod_Ctrl1            " + PrintArray(data.Block1.Mod_Ctrl1           , "{0:000} "));
            sb.AppendLine("Mod_Ctrl2            " + PrintArray(data.Block1.Mod_Ctrl2           , "{0:000} "));
            sb.AppendLine("Mod_In_Envelope      " + PrintArray(data.Block1.Mod_In_Envelope     , "{0:000} "));
            sb.AppendLine("Mod_LFO1             " + PrintArray(data.Block1.Mod_LFO1            , "{0:000} "));
            sb.AppendLine("Mod_LFO1_Modulation  " + PrintArray(data.Block1.Mod_LFO1_Modulation , "{0:000} "));
            sb.AppendLine("Mod_LFO1_AfterTouch  " + PrintArray(data.Block1.Mod_LFO1_AfterTouch , "{0:000} "));
            sb.AppendLine("Mod_LFO1_Breath      " + PrintArray(data.Block1.Mod_LFO1_Breath     , "{0:000} "));
            sb.AppendLine("Mod_LFO1_Ctrl1       " + PrintArray(data.Block1.Mod_LFO1_Ctrl1      , "{0:000} "));
            sb.AppendLine("Mod_LFO1_Ctrl2       " + PrintArray(data.Block1.Mod_LFO1_Ctrl2      , "{0:000} "));
            sb.AppendLine("Mod_LFO2             " + PrintArray(data.Block1.Mod_LFO2            , "{0:000} "));
            sb.AppendLine("Mod_LFO2_Modulation  " + PrintArray(data.Block1.Mod_LFO2_Modulation , "{0:000} "));
            sb.AppendLine("Mod_LFO2_AfterTouch  " + PrintArray(data.Block1.Mod_LFO2_AfterTouch , "{0:000} "));
            sb.AppendLine("Mod_LFO2_Breath      " + PrintArray(data.Block1.Mod_LFO2_Breath     , "{0:000} "));
            sb.AppendLine("Mod_LFO2_Ctrl1       " + PrintArray(data.Block1.Mod_LFO2_Ctrl1      , "{0:000} "));
            sb.AppendLine("Mod_LFO2_Ctrl2       " + PrintArray(data.Block1.Mod_LFO2_Ctrl2      , "{0:000} "));
            sb.AppendLine("");

            // Print unknowns
            foreach (var item in data.UnknownParts)
            {
                sb.AppendLine(item.Description + ":");
                sb.AppendLine(ByteArrayToHex(item.Block));
                sb.AppendLine("");
            }

            return sb.ToString();
        }

        private void SaveStream(string Filename, Stream input)
        {
            var fs = new FileStream(Filename, FileMode.Create, FileAccess.Write);
            input.Position = 0;
            KSDData.CopyStream(input, fs);
            fs.Close();
        }

        private void button2_Click(object sender, System.EventArgs e)
        {
            var files1 = Directory.GetFiles(@"C:\Program Files\Common Files\Native Instruments\FM8\Sounds\FM7 Legacy", "*.nfm8");
            var files2 = Directory.GetFiles(@"C:\Program Files\Common Files\Native Instruments\FM8\Sounds\FM8 Factory\Instruments\", "*.nfm8");
            foreach (var file in files1)
                KSDData.LoadFM8(file);
            foreach (var file in files2)
                KSDData.LoadFM8(file);

            //KSDData.LoadFM8(@"C:\temp.bin");
            //KSDData.LoadFM8(@"c:\2 Trompets-1.nfm8");
            

            return;

            // Delete old version
            txtFileName.Text = @"C:\5 Violina's-3.nfm8";
            
            m_KSD = KSDData.LoadFM8(txtFileName.Text);
            //m_FMInst = m_KSD.ConvertToFMInstrument();
            
            foreach (var chunk in m_KSD.Chunks)
                SaveStream(txtFileName.Text + chunk.Key, chunk.Value);

            //var list = new List<KSDData>();
            //list.Add(m_KSD);
            //KSDData.SerilaizeInstruments(list, null);

            // Store to file
            

            string Log = PrintKSDData(m_KSD);
            textBox1.Text = Log;

            // Rename old file
            try
            {
                File.Delete(txtFileName.Text + "_Prev");
            } 
            catch(Exception) {}

            try
            {
                File.Move(txtFileName.Text + "_Out", txtFileName.Text + "_Prev");
            } 
            catch(Exception) {}

            // Write to file
            var OutFile = new StreamWriter(txtFileName.Text + "_Out");
            OutFile.Write(Log);
            OutFile.Close();

            panel1.Refresh();
            panel2.Refresh();
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
                txtFileName.Text = openFileDialog1.FileName;
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            if (m_KSD == null)
                return ;

            // Test 1 - Before Loop
            // m_KSD.GetEnvValue(0, 0.05f, 0f, 15f);

            // Test 2 - Inside Loop
            // m_KSD.GetEnvValue(0, 0.2f, 0f, 15f);

            // Test 3 - Inside Loop (Overlapped)
            // m_KSD.GetEnvValue(0, 0.9f, 0f, 15f);

            // Test 4 - Release (Inside Loop)
            // m_KSD.GetEnvValue(0, 1.2f, 1.00f, 15f);

            /*Image bm = Bitmap.FromFile(@"c:\cv.bmp");
            e.Graphics.DrawImage(bm, e.ClipRectangle, new Rectangle(0, 0, (int)bm.Width, (int)bm.Height), GraphicsUnit.Pixel);
            bm.Dispose();*/
            /*bool bPostEnv;
            int nChannel = 0;
            float TotalLength = m_KSD.OP_Env_AbsTime[nChannel][m_KSD.OP_Env_AbsTime[nChannel].Length - 1]*1.2f;
            

            for (int x = 0; x < e.ClipRectangle.Width; x++)
            {
                float t = x / (float)e.ClipRectangle.Width * TotalLength;
                if (t > m_KSD.OP_Env_AbsTime[nChannel][m_KSD.OP_Env_AbsTime[nChannel].Length - 1])
                    0.ToString();

                float ReleaseTime = m_KSD.OP_Env_AbsTime[nChannel][m_KSD.Block1.OP_Env_SustainLoopEnd[nChannel] + 1] * 1f;
                if (ReleaseTime > t)
                    ReleaseTime = -1f;

                float y = (1f - m_FMInst.GetEnvValue(nChannel, t, ReleaseTime, trackBar1.Value / 1f, out bPostEnv)) * e.ClipRectangle.Height;
                if (nChannel == 8)
                    y = (1 - m_FMInst.GetEnvValue(nChannel, t, ReleaseTime, trackBar1.Value / 1f, out bPostEnv)) * 0.5f * e.ClipRectangle.Height;

                if (!bPostEnv)
                    e.Graphics.DrawRectangle(Pens.Black, x, y, 1, 1);
                else
                    e.Graphics.DrawRectangle(Pens.Red, x, y, 1, 1);
                
                /*y = (1f - m_KSD.GetEnvValue(0, true, t, trackBar1.Value / 1f)) * e.ClipRectangle.Height;
                e.Graphics.DrawRectangle(Pens.Green, x, y, 1, 1);*/
          //  }
        }

        private void panel2_Paint(object sender, PaintEventArgs e)
        {
           /* if (m_KSD == null)
                return;

            for (int x = 0; x < e.ClipRectangle.Width; x++)
            {
                float noteIndex = x / (float)e.ClipRectangle.Width * 127f;
                if (noteIndex > 70)
                    0.ToString();

                float y = (-m_FMInst.GetScaleValue(0, noteIndex) / 80f) * e.ClipRectangle.Height;
                e.Graphics.DrawRectangle(Pens.Black, x, y, 1, 1);
            }*/
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            label1.Text = (trackBar1.Value / 1f).ToString();
        }

	}
}
