/******************************************************************************/
/*                                                                            */
/*            ---=== The Utlimate Chip Konstruktor v1.0 ===---                */
/*          A tiny sound editor to easily create chip samples                 */
/*   Copyright (C) 1997  Olivier DOMINIQUE a.k.a. Wahat Herman/BSB            */
/*                                                                            */
/*   This program is free software; you can redistribute it and/or modify     */
/*   it under the terms of the GNU General Public License as published by     */
/*   the Free Software Foundation; either version 2 of the License, or        */
/*   (at your option) any later version.                                      */
/*                                                                            */
/*   This program is distributed in the hope that it will be useful,          */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*   GNU General Public License for more details.                             */
/*                                                                            */
/*   You should have received a copy of the GNU General Public License        */
/*   along with this program; if not, write to the Free Software              */
/*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                            */
/*                                                                            */
/*   A copy of the GNU General Public License is available with this package  */
/*   in the .../chip/ directory (in the file COPYING). Please READ IT to know */
/*   YOUR rights.                                                             */
/*                                                                            */
/******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <ctype.h>
#include <math.h>

typedef struct FFT_VALUE
	{
	unsigned int frequency;
	char value;
	char wave_type;
	} fft_value;


int initsize(FILE *file)
{
char buf[10];
char head[]="header";
int c,i;
int j=-1;
while((c=fgetc(file))!=EOF)
	{
	if (c=='#')
		{
		fgets(buf,7,file);
#ifdef DEBUG
		printf("%s\n",buf);
#endif
		for (i=0;buf[i];i++)    
			buf[i]=tolower(buf[i]);
		if (strcmp(buf,head)==0) 
			{
			printf("header found\n");
			fscanf(file,"%d",&j);
			break;
			}
		}       
	}
return j;
}


int preparedata(FILE *file)
{
char buf[10];
char data[]="data";
int c,i;
int j=-1;

while((c=fgetc(file))!=EOF)
	{
	if (c=='#')
		{
		fgets(buf,5,file);
#ifdef DEBUG
		printf("%s\n",buf);
#endif
		for (i=0;buf[i];i++)    
			buf[i]=tolower(buf[i]);

		if (strcmp(buf,data)==0) 
			{
			printf("data section found\n");
			j=0;
			break;
			}
		}       
	}
return j;
}


int initdata(FILE *file, fft_value *value_tab, int tab_size)
{
unsigned int i,j;
char v;
char c;
for (i=0;i<tab_size;i++)
	{
	while (!isdigit(c=getc(file))){}
	fseek(file,-1,SEEK_CUR);
	fscanf(file,"%u",&j);
#ifdef DEBUG
	printf("%u\t",j);
#endif
	value_tab[i].frequency=j;
	while (!(isdigit(c=getc(file))||c=='-')){}
	fseek(file,-1,SEEK_CUR);
	fscanf(file,"%d",&v);
#ifdef DEBUG
	printf("%d\t",v);        
#endif
	value_tab[i].value=v;
	while (!isalpha(c=getc(file))){}
	c=tolower(c);
#ifdef DEBUG
	printf("%c\n",c);
#endif
	value_tab[i].wave_type=c;
	}
return 0;
}

int displaydata(fft_value *value_tab, int tab_size)
{
int i;
for (i=0;i<tab_size;i++)
	printf("%d\t%d\t%c\n",value_tab[i].frequency,value_tab[i].value,value_tab[i].wave_type);
return 0;
}



void init_signal(char *signal,int signal_size,char signal_type,unsigned int frequency,int sampling_rate)
{
int i=0;
switch(signal_type)
	{
	case 's':	for (i=0;i<signal_size;i++) 
					signal[i]=sin(frequency*2*PI*i/sampling_rate)*127;
				break;

	case 't':	for (i=0;i<signal_size;i++) 
					signal[i]=asin(sin(frequency*2*PI*i/sampling_rate))*127/PI;
				break;

	case 'k':	for (i=0;i<signal_size/2;i++) 
					signal[i]=127;
				
				for (i=signal_size/2;i<signal_size;i++)
					signal[i]=-128;
				break;
	case 'c':	for (i=0;i<signal_size;i++) 
					signal[i]=cos(frequency*2*PI*i/sampling_rate)*127;
				break;

	default	:	printf("Error: unknown signal type");
	}
}




int main(int argc, char **argv)
{
FILE *coeff;
fft_value *freq_datas;
int nb_coeff=0;

FILE *chip;
fft_value mainfreq;
int i,j,sampnum;
int samprate=44100;
long *sample;
char *signal_tab; 
long maxsample;
char output[12];


printf(" The Ultimate Chip Konstruktor v1.0, Copyright (C) 1997 Olivier DOMINIQUE\n");
printf(" \nThe Utlimate Chip Konstruktor comes with ABSOLUTELY NO WARRANTY.\n");
printf(" This is free software, and you are welcome to redistribute it\n");
printf(" under certain conditions.\n");
printf(" See the GNU General Public License for more details\n");
printf(" A copy of the GNU General Public License is available in the .../chip/ directory\n");
printf(" in the file COPYING\n\n");
if (argc<2) 
	{
	fprintf(stderr,"Syntax: chip data.fft [chip.snd]\nSee readme.txt for more info\n");
	return -1;
	}
if (argc>3) 
	{
	fprintf(stderr,"Syntaxe: chip data.fft [chip.snd]\nSee readme.txt for more info\n");
	return -1;
	}
if (argc==2)
	{
	printf("Output file will be chip.snd\n");
	strcpy(output,"chip.snd");
	if ((coeff=fopen(argv[1],"rb"))==NULL)
		{
		fprintf(stderr,"file %s not found\n",argv[1]);
		return -1;
		}
	if ((chip=fopen(output,"wb"))==NULL)
		{
		fprintf(stderr,"error while opening %s (Disk full?)\n",argv[2]);
		return -1;
		}
#ifdef DEBUG
	fprintf(stderr,"files correctly opened\n");
#endif
	}
	
if (argc==3)
	{
	strcpy(output,argv[2]);
	if ((coeff=fopen(argv[1],"rb"))==NULL)
		{
		fprintf(stderr,"file %s not found\n",argv[1]);
		return -1;
		}
	if ((chip=fopen(output,"wb"))==NULL)
		{
		fprintf(stderr,"error while opening %s (Disk full?)\n",argv[2]);
		return -1;
		}
	
#ifdef DEBUG
	fprintf(stderr,"files correctly opened\n");
#endif
	}

/*lecture du header*/
if ((nb_coeff=initsize(coeff))== -1)
			{
			fprintf(stderr,"Error: file corrupted, no header found\n");
			return -1;
			}
printf("%d coefficient(s)\n",nb_coeff);

/*reservation*/
freq_datas = (fft_value *) malloc(nb_coeff*sizeof(fft_value)); 
	if(freq_datas==NULL) 
		{
		fprintf(stderr,"error: memory allocation failed\n");
		return -1;
		}
#ifdef DEBUG
	else 
		fprintf(stderr,"allocation mmoire russie\n");
#endif

/*recherche de la section data*/
if (preparedata(coeff)== -1)
			{
			fprintf(stderr,"Error: file corrupted, no data section found\n");
			return -1;
			}

/*lecture de la section data*/
initdata(coeff,freq_datas,nb_coeff);
#ifdef DEBUG
displaydata(freq_datas,nb_coeff);
#endif

/*gnration du chip sample*/

/*dtermination de la frquence principale*/
mainfreq.frequency=20;
mainfreq.value=0;
mainfreq.wave_type='s'; 
for (i=nb_coeff-1;i>-1;i--) 
	{ 
	if (freq_datas[i].value>=mainfreq.value) 
		{ 
		mainfreq.frequency=freq_datas[i].frequency;
		mainfreq.value=freq_datas[i].value;
		mainfreq.wave_type=freq_datas[i].wave_type;
		}
	}
printf("main frequency is : %d Hz\n",mainfreq.frequency);

sampnum=samprate/mainfreq.frequency;
printf("file size will be : %d byte(s)\n",sampnum);

sample=(long *)malloc(sampnum*sizeof(long));
signal_tab=(char *)malloc(sampnum*sizeof(char));

/*raz du buffer de stockage du sample*/
for (i=0;i<sampnum;i++) 
	sample[i]=0;

/*initialisation du sample */
for (i=0;i<nb_coeff;i++)
	{ 
	init_signal(signal_tab,sampnum,freq_datas[i].wave_type,freq_datas[i].frequency,samprate);
	for (j=0;j<sampnum;j++) 
		sample[j]=freq_datas[i].value*signal_tab[j]+sample[j];
	}

printf("calculation done.\n");

/*rduction en 8 bits*/
maxsample=0;
for (i=0;i<sampnum;i++) 
	if (maxsample < abs(sample[i])) 
		maxsample=abs(sample[i]);

#ifdef DEBUG
printf("max value : %d\n",maxsample);
#endif

for (i=0;i<sampnum;i++) 
	sample[i]=((sample[i]*127)/maxsample)+127;

/*sauvegarde du sample*/

for (i=0;i<sampnum;i++) 
	fputc(sample[i],chip);
fclose(chip);

/*fermeture des fichiers, et liberation de la mmoire*/
fclose (coeff);
free(freq_datas);
free(sample);
free(signal_tab);
#ifdef DEBUG
fprintf(stderr,"file correctly closed\n");
#endif
printf("\nEverything went OK, thank you for using a blue product.\n");
return 0;
}
