;----------------------------------------------------------------------------
; Music Box Musicplayer RGBDS Example V1.01.00
;
; Library Version
;
; By Ray 'Credo' Nemes of Black Box Development <credo@scs-trc.net>
;
; From 05/09/1998 to 24/08/1999
;
; note: this is a really-really minimal player, don't care about the headers
; and the others
;-----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; Header
;----------------------------------------------------------------------------

                SECTION "Header1",HOME[0]

                jp      main            ; typical header file, don't care
                ds      5               ; about these sections in this
                jp      main            ; example
                ds      5
                jp      main
                ds      5
                jp      main
                ds      5
                jp      main
                ds      5
                jp      main
                ds      5
                jp      main
                ds      5
                jp      main
                ds      5
                jp      irq_VBlank
                ds      5
                jp      irq_LCDC
                ds      5
                jp      irq_Timer
                ds      5
                jp      irq_Serial
                ds      5
                jp      irq_HiLo
                ds      5

                SECTION "Header2",HOME[$100]

                nop
                jp main

                db $ce,$ed,$66,$66,$cc,$0d,$00,$0b
                db $03,$73,$00,$83,$00,$0c,$00,$0d
                db $00,$08,$11,$1f,$88,$89,$00,$0e
                db $dc,$cc,$6e,$e6,$dd,$dd,$d9,$99
                db $bb,$bb,$67,$63,$6e,$0e,$ec,$cc
                db $dd,$dc,$99,$9f,$bb,$b9,$33,$3e

                db "EXAMPLEROM!"

                db $42,$42,$4f,$58,$80,$b1,$b0,$00
                db $19,$00,$00,$01,$33,$00,$00,$00
                db $00

;----------------------------------------------------------------------------
; Main code
;----------------------------------------------------------------------------

                SECTION "MainCode",HOME[$150]

                include "player.inc"    ; the music player header file

music:          incbin "xayne.sav"      ; the music as binary data
                                        ; this is a simple 8K file directly
                                        ; from the editor card's SRAM or
                                        ; saved by an emulator as musicbox.sav

main:

                di                      ; disable interrupts

                ld      hl,$cfff        ; initialize stack
                ld      sp,hl

                ei                      ; enable interrupts

                ld      hl,music        ; load music address to hl
                xor     a               ; load beginning pattern pos to a (0)
                ld      b,a             ; load restart pattern pos to b (0)
                call    MBInit          ; initialize the music

mainloop:

waitforpos1:    ld      a,[$ff44]       ; wait for a raster position, in this
                cp      $00             ; case to the 000th position, but
                jr      nz,waitforpos1  ; can be changed

                call    MBPlay          ; update the music in every frame at
                                        ; the same raster position

;----------------------------------------------------------------------------
; uncomment the following section for quattro player
;----------------------------------------------------------------------------
;
;waitforpos2:    ld      a,[$ff44]       ; wait for a raster position, in this
;                cp      $27             ; case to the 039th position, but
;                jr      nz,waitforpos2  ; can be changed
;
;                call    MBPlay          ; update the music in every frame at
;                                        ; the same raster position
;
;----------------------------------------------------------------------------
; uncomment the following section for double and quattro player
;----------------------------------------------------------------------------
;
;waitforpos3:    ld      a,[$ff44]       ; wait for a raster position, in this
;                cp      $4d             ; case to the 077th position, but
;                jr      nz,waitforpos3  ; can be changed
;
;                call    MBPlay          ; update the music in every frame at
;                                        ; the same raster position
;
;----------------------------------------------------------------------------
; uncomment the following section for quattro player
;----------------------------------------------------------------------------
;
;waitforpos4:    ld      a,[$ff44]       ; wait for a raster position, in this
;                cp      $73             ; case to the 115th position, but
;                jr      nz,waitforpos4  ; can be changed
;
;                call    MBPlay          ; update the music in every frame at
;                                        ; the same raster position
;
;----------------------------------------------------------------------------

                jr      mainloop        ; jump back to the main loop

irq_VBlank:     reti                    ; empty interrupt routines, don't
irq_LCDC:       reti                    ; care about these in this example
irq_Timer:      reti
irq_Serial:     reti
irq_HiLo:       reti

;----------------------------------------------------------------------------
