// ------------------------------------------------------
// OGLStartup.h
// CopyRight (C) 2004 Franck "hitchhikr" Charlet / TRSI.

#ifndef _STARTUP_H_
#define _STARTUP_H_

// ------------------------------------------------------
// Includes
#include <Windows.h>
#include <gl/gl.h>
#include <gl/glext.h>
#include <gl/glu.h>
#include <gl/wglext.h>
#include <commctrl.h>
#include "resource.h"

// ------------------------------------------------------
// Constants
#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define SCREEN_BPP 16

#define WM_MOUSEWHEEL 0x020A
#define WHEEL_DELTA 120

// ------------------------------------------------------
// structures
typedef struct {
	HINSTANCE hInstance;
	const char *className;
} Application;

typedef struct {
	Application *application;
	char *title;
	int width;
	int height;
	int bitsPerPixel;
	BOOL isFullScreen;
} GL_WindowInit;

typedef struct {
	HWND hWnd;
	HDC hDC;
	HGLRC hRC;
	GL_WindowInit init;
	BOOL isVisible;
	LONGLONG lastTickCount;
	LONGLONG firstTickCount;
} GL_Window;

// ------------------------------------------------------
// Global variables
extern int g_FullScreen;
extern GL_Window *g_window;
extern BOOL g_keys[256];
extern POINT Mouse_Coords;
extern int Mouse_Wheel;
extern int Mouse_Button;
extern int In_Requester;

// ------------------------------------------------------
// Public functions
void Terminate_Application(GL_Window* window);
BOOL Initialize(void);
void Deinitialize(void);
void Update(float milliseconds, float TotalTime);
BOOL Render_On_Screen(GL_Window *window);
void Draw(void);
void Reshape_GL(int width, int height);
BOOL Check_GL_Extension(char *name);

#endif
