// ------------------------------------------------------
// OGLMain.cpp
// CopyRight (C) 2004 Franck "hitchhikr" Charlet / TRSI.

// TODO:
//
//  Wave renderer.
//  Preferences:
//     Colors modifications (13 colors).
//     Start type: - Full Screen.
//                 - Windowed.
//                 - Ask.
//     Ok|Cancel

// ------------------------------------------------------
// Includes
#include "OGLStartup.h"
#include "Synth.h"
#include <stdio.h>

// ------------------------------------------------------
// Constants
#define MAX_LINES 49
#define MAX_COLUMNS 112

#define GADGET_DISABLED 0
#define GADGET_ENABLED 1
#define GADGET_AREA 2
#define GADGET_NUMBER 4

#define ID_INSTR_NBR 1
#define ID_INSTR_PLAY 2
#define ID_INSTR_NOTE 3
#define ID_INSTR_STOP 4
#define ID_INSTR_PREV 5
#define ID_INSTR_NEXT 6

#define ID_INSTR_NEW 7
#define ID_INSTR_DELETE_INSTR 8
#define ID_INSTR_LOAD 9
#define ID_INSTR_SAVE 10
#define ID_INSTR_ADD_WAVE 11
#define ID_INSTR_DELETE_WAVE 12

#define ID_INSTR_SELECTION 13

#define ID_SEQ_NBR 14
#define ID_SEQ_OCTAVE 15
#define ID_SEQ_PREV 16
#define ID_SEQ_NEXT 17
#define ID_SEQ_NEW 18
#define ID_SEQ_DELETE 19
#define ID_SEQ_TEMPO 20
#define ID_SEQ_FX_TEMPO 21
#define ID_SEQ_PLAY 22

#define ID_SEQ_SELECTION 23

#define ID_SONG_NEW 24
#define ID_SONG_CLEAN 25
#define ID_SONG_LOAD 26
#define ID_SONG_SAVE 27
#define ID_SONG_ADD 28
#define ID_SONG_INSERT 29
#define ID_SONG_DELETE 30
#define ID_SONG_PLAY 31
#define ID_SONG_PLAYFP 32
#define ID_SONG_STOP 33
#define ID_SONG_RESTART 34

#define ID_SONG_SELECTION 35
#define ID_SONG_NBR 36

#define ID_SONG_VOICE1 37
#define ID_SONG_VOICE2 38
#define ID_SONG_VOICE3 39
#define ID_SONG_VOICE4 40
#define ID_SONG_VOICE5 41
#define ID_SONG_VOICE6 42
#define ID_SONG_VOICE7 43
#define ID_SONG_VOICE8 44

#define ID_MISC_QUIT 45

#define ID_MISC_WAVE 46
#define ID_MISC_PREFS 47

#define INPUT_NBR_INSTRUMENT 0
#define INPUT_NBR_SEQUENCE 1
#define INPUT_TEMPO 2
#define INPUT_FX_TEMPO 3
#define INPUT_INSTR_NOTE 4
#define INPUT_NBR_OCTAVE 5
#define INPUT_NBR_RESTART 6

// ------------------------------------------------------
// Structures
typedef struct _GADGET {
	int ID;
	int Flags;
	char *Text;
	POINT Position;
	RECT Screen_Coords;
} GADGET, *LPGADGET;

enum {
	Edit_Instrument,
	Edit_Sequence,
	Edit_Song
} EDIT_TYPE;

// ------------------------------------------------------
// Variables
GLuint Font_Base;
HFONT Text_Font;
int Flash_Logo = FALSE;
float Flash_Color = 0.0f;
GLuint txLogo_Id;
int Font_Width;
int Font_Height;
BYTE Requester_Flag;
DWORD ThreadId;
HANDLE hThread;
HANDLE hReplayThread;
BYTE *Logo;
BYTE PixDats[] = { 0, 0, 0 };
CList Gadgets;				// GADGET
int Clicked_Gadget;
float Temp_Error;
int Was_Error;
LPGADGET Current_Gadget_Clicked;
int Wheel_Step;
int Loading;
int In_Value_Input;
int Input_Type;
int Pos_Instrument_Dat;
int Pos_Instrument_Scroll;
int Pos_In_Sequence;
int Old_Pos_In_Sequence;
int Pos_In_Instrument;
int Pos_In_Song;
int Pos_Song_Dat;
int Pos_Song_Scroll;
int Mouse_Gap;
int Pos_Caret_X;

int Instr_Sel_Flag;
int Seq_Sel_Flag;
int Pos_Sel_Flag;

int Tab_Pos_Caret_Instr[] =  { 1, 3, 6, 11, 13, 18, 20, 25, 27, 32, 34 };
int Tab_Size_Caret_Instr[] = { 1, 2, 4,  2,  4,  2,  4,  2,  4,  2,  4 };
int Mouse_Pos_Caret_Instr[] = { 0, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10};

int Tab_Pos_Caret_Seq[] =  { 43, 46, 50, 52, 55, 57, 58, 60, 62, 64, 65};
int Tab_Size_Caret_Seq[] = {  3,  4,  2,  2,  2,  1,  2,  2,  2,  1,  2};
int Mouse_Pos_Caret_Seq[] = { 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 7, 7, 8, 9, 9};
int Mouse_Pos_Caret_Seq_Delay[] = { 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10};

int Tab_Pos_Caret_Seq_Filter[] =  { 43, 46, 50, 52, 55, 57, 58, 60, 64, 65};
int Tab_Size_Caret_Seq_Filter[] = {  3,  4,  2,  2,  2,  1,  2,  4,  1,  2};

int Mouse_Pos_Caret_Song[] = {  0,  0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,
                                3,  3,  3,  3,  3,  4,  4,  4,  4,  5,  5,  5,
							    6,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,
							    9,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11,
							   12, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14,
							   15, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17,
							   18, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20,
							   21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23
						    };

int Tab_Pos_Caret_Song[] =  {  7, 12, 16,  
							  19, 24, 28,
							  31, 36, 40,
							  43, 48, 52,
							  55, 60, 64,
							  67, 72, 76,
							  79, 84, 88,
							  91, 96, 100
							};
int Tab_Size_Caret_Song[] = {  4,  3,  2,
							   4,  3,  2,
							   4,  3,  2,
							   4,  3,  2,
							   4,  3,  2,
							   4,  3,  2,
							   4,  3,  2,
							   4,  3,  2
							};

char Keys_Operators[] = {	'+', INS_OP_ADD,
							'-', INS_OP_SUB,
							'*', INS_OP_MUL,
							'/', INS_OP_DIV,
							VK_ADD, INS_OP_ADD,
							VK_SUBTRACT, INS_OP_SUB,
							VK_MULTIPLY, INS_OP_MUL,
							VK_DIVIDE, INS_OP_DIV
						};

char Keys_Octal[] = {	'0', 0,
					    '1', 1,
					    '2', 2,
					    '3', 3,
					    '4', 4,
					    '5', 5,
					    '6', 6,
					    '7', 7,
					    '8', 8,
						VK_NUMPAD0, 0,
						VK_NUMPAD1, 1,
						VK_NUMPAD2, 2,
						VK_NUMPAD3, 3,
						VK_NUMPAD4, 4,
						VK_NUMPAD5, 5,
						VK_NUMPAD6, 6,
						VK_NUMPAD7, 7,
						VK_NUMPAD8, 8
					};

char Keys_Hex[] = {	'0', 0,
					'1', 1,
					'2', 2,
					'3', 3,
					'4', 4,
					'5', 5,
					'6', 6,
					'7', 7,
					'8', 8,
					'9', 9,
					'A', 0xA,
					'B', 0xB,
					'C', 0xC,
					'D', 0xD,
					'E', 0xE,
					'F', 0xF,
					VK_NUMPAD0, 0,
					VK_NUMPAD1, 1,
					VK_NUMPAD2, 2,
					VK_NUMPAD3, 3,
					VK_NUMPAD4, 4,
					VK_NUMPAD5, 5,
					VK_NUMPAD6, 6,
					VK_NUMPAD7, 7,
					VK_NUMPAD8, 8,
					VK_NUMPAD9, 9
				  };

char *szNotesDieses = "--C-C#D-D#E-F-F#G-G#A-A#B-";
char *szNotesBemols = "--C-DbD-EbE-F-GbG-AbA-BbB-";
char szCharsNotesUp[] = { 'A', '2', 'Z', '3', 'E', 'R', '5', 'T', '6', 'Y', '7', 'U' };
char szCharsNotesDown[] = { 'W', 'S', 'X', 'D', 'C', 'V', 'G', 'B', 'H', 'N', 'J', '' };

char Tab_Hex[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

int Caret_X = 1;
int Caret_Y = 4;
int Caret_X_Size = 2;
int Edit_Mode = Edit_Sequence;
int Caret_Flash;
float Caret_Time;
char String_Save[256];
char String_Load[256];
OPENFILENAME MyOpenFName;
OPENFILENAME MySaveFName;

char *Wave = "Wave";
char *Prefs = "Prefs";

char *Next = "Next";
char *Prev = "Prev";
char *New = "New";
char *Load = "Load";
char *Save = "Save";
char *Add = "Add";
char *Voice_On =  " On ";
char *Voice_Off = "Mute";

char *New_Song =    " New  ";
char *Clean_Song =  " Wipe ";
char *Load_Song =   " Load ";
char *Save_Song =   " Save ";
char *Add_Song =    " Add. ";
char *Insert_Song = "Insert";
char *Delete =      "Delete";
char *Play =        " Play ";
char *PlayP =       "Pl.Pos";
char *Stop =        " Stop ";
char *Quit =        " Quit ";
char *Play_Instr = "Play";
char *Stop_Instr = "Stop";
char *Credits1 = "TRSI Sound Monitor v1.2";
char *Credits2 = "Written by hitchhikr/TRSI";
char *Status_Ok = "No problems so far.";
char *Err_Max_Instruments = "Maximum number of instruments reached !";
char *Err_No_Instrument = "No instrument selected or created !";
char *Err_Max_Positions = "Maximum number of positions reached !";
char *Err_Save = "Can't save file !";
char *Err_Load = "Can't load file !";
char *Err_Format = "Invalid format !";
char *Err_Del_Instrument = "Delete the instrument instead !";
char *Ok_Save = "File saved.";
char *Ok_Load = "File loaded.";
char *Ok_Copied = "Datas copied.";
char *Ok_Seq_Changed = "Sequence(s) modified by operation.";
char *Ok_Pos_Changed = "Position(s) modified by operation.";
char *Ok_Song_Changed = "0000 instrument(s) / 0000 sequence(s) removed.";
char *Err_Song_Changed = "Nothing to clean !";
char *Status_Message = Status_Ok;

// Operation and Wave number
//		1x = add
//		2x = substract
//		3x = multiply
//		4x = divide
//		----
//		x1 = sin
//		x2 = square
//		x3 = saw
//		x4 = random
// Repeat ADSR (4)
//		Start volume (0-100% (0x64)) (end volume for DSR)
//		Start period (hz frequency) (end frequency for DSR)
//		Duration (milliseconds) (0 = don't use) (0 - 65535)
int Base_Octave = 5;
int Old_Base_Octave;
int Old_Current_Instr_N;
int Current_Instr_N;
int Old_Current_Instr_Note;
char *Instr_Note = "C-5";
char *Current_Instr_Nbr = "0000";
char *Total_Instr_Nbr = "0000";
char *Current_Octave = "5";
char *Line_Instrument_Labels = "O Wf PSh. Vo Att Vo Dec Vo Sus Vo Rel";
char *Line_Instrument =        "+ 00 0000 000000 000000 000000 000000";

// Song position (0 - 0xffff)
// Sequence number (0 - 0xffff)
// Transpose (0xx = up 1xx = down) (xyy = semitone number (from 120 notes table));
// Default volume for pattern (1 - 0x65) (overridden if specified inside sequence).
char *Line_Song_Labels = "Pos.  Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo Seq. Trp Vo";
char *Line_Song =        "0000  0000 +00 00 0000 +00 00 0000 +00 00 0000 +00 00 0000 +00 00 0000 +00 00 0000 +00 00 0000 +00 00";

// Sequences:
// Line number (0x00 - 0x0f);
// Note (A - G) / Octave (0 - 9)
// Instrument number (0 - 0xFFFF)
// Volume level (1 to 0x65 value displayed -1)
// Panning (1 - 0x65) (0x32 = middle)
// FX number (0 - 0xff)
// FX datas
int Current_Seq_N;
int Old_Current_Seq_N;
int Old_Tempo;
int Tmp_Tempo;
int Old_Fx_Tempo;
int Tmp_Fx_Tempo;
char *Current_Seq_Nbr = "0000";
char *Total_Seq_Nbr = "0000";
char *Current_Tempo = "0000";
char *Current_Fx_Tempo = "0000";
char *Line_Seq_Labels = "Nb Nt.Ins.VoPa Dsp      Fx";
char *Line_Seq =        "00 ---00000000 000000000000";

int Tmp_Song_Restart;
char *Total_Song_Nbr = "0000";
char *strSong_Restart = " 0000 ";

SEQUENCE_DAT ClipBoard_Sequence_Dats;

// ------------------------------------------------------
// Functions
DWORD WINAPI Synth_Thread(LPVOID lpParameter);
HFONT Get_Font(char *Font_Name, int Font_Size);
void Set2D(int Width, int Height);
void Display_Error(char *Text, int Pos_X, int Pos_Y);
void Display_Text(char *Text, int Pos_X, int Pos_Y, float Red, float Green, float Blue);
void Display_Line(int Pos_X1, int Pos_Y1, int Pos_X2, int Pos_Y2, float Red, float Green, float Blue);
void Display_Box(int Pos_X, int Pos_Y, int Width, int Height);
int Get_Text_Width(char *Txt, int TxtLen);
int Get_Text_Height(char *Txt, int TxtLen);
DWORD WINAPI Replay_Thread(LPVOID lpParameter);
void Display_Caret(int Pos_X, int Pos_Y, int X_Size);
void Display_Gadget(LPGADGET Gadget, int Display_Text);
LPGADGET Get_Gadget_From_ID(int ID);
BYTE *Load_Picture(int ResourceID, int Width, int Height, int MaxWidth, int MaxHeight, int Bpp);
HGLOBAL Load_File_From_Resource(int ResourceID);
void Create_Gadget(int ID, int Flags, char *Text, int PosX, int PosY, int Size_X, int Size_Y);
void Free_List(CList *ListToFree);
LPGADGET Display_Gadgets(void);
void HighLight_Gadget(LPGADGET Gadget, int Button_HighLight);
void Draw_Spectrum_Bar(int Pos_X, int Height1, int Height2);
void Create_Instrument(void);
void Create_WaveForm(void);
void Free_Instruments(void);
void Free_Sequences(void);
void Bring_Caret(void);
void Remove_Caret(void);
void Print_Hex1(char *Dest_Text, int Number);
void Print_Hex2(char *Dest_Text, int Number);
void Print_Hex3(char *Dest_Text, int Number);
void Print_Hex4(char *Dest_Text, int Number);
void Get_Hex4_Split(BYTE *Hi_Byte, BYTE *Lo_Byte, int Position);
void Get_Hex1(BYTE *Number, int Position);
void Get_Hex2(BYTE *Number, int Position);
void Get_Hex3(WORD *Number, int Position);
void Get_Hex4(WORD *Number, int Position);
void Get_Hex6(DWORD *Number, int Position);
void Set_Error_Message(char *Message);
void Set_Ok_Message(char *Message);
void Load_Instrument_Cmd(void);
DWORD WINAPI Load_Instrument(LPVOID lpParameter);
void Save_Instrument_Cmd(void);
DWORD WINAPI Save_Instrument(LPVOID lpParameter);
char *Choose_Open_File(HWND hWnd, char *OFilters, char *InitDir);
char *Choose_Save_File(HWND hWnd, char *OFilters, char *InitDir);
HANDLE Create_Empty_File(char *FileName, long Security);
long Close_File(HANDLE hFile);
int Save_BYTE(HANDLE FileHandle, BYTE Value);
int Save_WORD(HANDLE FileHandle, WORD Value);
int Save_DWORD(HANDLE FileHandle, DWORD Value);
int Save_MEM(HANDLE FileHandle, BYTE *Memory, int Size);
HANDLE Open_File(char *FileName);
DWORD Read_DWORD(HANDLE FileHandle, LPDWORD ReadBytes);
WORD Read_WORD(HANDLE FileHandle, LPDWORD ReadBytes);
BYTE Read_BYTE(HANDLE FileHandle, LPDWORD ReadBytes);
void Confine_Instrument_Caret(void);
void Delete_Instrument(int Instrument_Number);
void Delete_Sequence(int Sequence_Number);
void Display_Total_Nbr_Instruments(void);
void Display_Total_Nbr_Positions(void);
void Display_Total_Nbr_Sequences(void);
void Set_Note(char *Note_String, int Note_Dat);
void Create_Sequence(void);
LPSEQUENCE_DAT Get_Latest_Sequence(void);
void Draw_Square(int Pos_X, int Pos_Y, int Width, int Height, float Red, float Green, float Blue);
void Calc_Deltas(LPINSTRUMENT_DAT Instrument_Dats);
void Display_Oscillators(void);
void Create_Position(int Insert_Point);
void Free_Positions(void);
void Delete_Position(int Position_Nbr);
void Confine_Song_Caret(void);
void Display_Octave(void);
void Save_Module_Cmd(void);
DWORD WINAPI Save_Module(LPVOID lpParameter);
void Load_Module_Cmd(void);
DWORD WINAPI Load_Module(LPVOID lpParameter);
void Erase_All_Cmd(void);
DWORD WINAPI Erase_All_Thread(LPVOID lpParameter);
void Erase_All(void);
void Replace_Sequences(int Instr_Nbr, int Instr_Nbr_Replace);
void Replace_Positions(int Seq_Nbr, int Seq_Nbr_Replace);
void Goto_Prev_Seq(void);
void Goto_Next_Seq(void);
void Goto_Prev_Instr(void);
void Goto_Next_Instr(void);
void Play_Current_Instrument(void);
void Play_Current_Sequence(void);
void Play_Current_Song(int Position);
void Clean_Song_Cmd(void);
DWORD WINAPI Clean_Song_Thread(LPVOID lpParameter);
void CleanUp_Song(void);
void Delete_Current_Sequence(void);
void Delete_Current_WaveForm(void);
void Next_Waveform(void);
void Prev_Waveform(void);
void Next_Position(void);
void Prev_Position(void);
void Switch_Track(int Id);
void Kill_Thread(void);
void Set_Caret_Y(void);
void Point_Mouse_Sequences(LPGADGET Gadget);
void Point_Mouse_Positions(LPGADGET Gadget);
void Point_Mouse_Instruments(LPGADGET Gadget);
void __stdcall Synchro(int Datas);
int Get_Sequence_From_DblClick(LPGADGET Gadget);
int Get_Instrument_From_DblClick(LPGADGET Gadget);
GLuint Create_NV_Texture(int Width, int Height, BYTE *Dest);
void Draw_Pixels(float X, float Y, float Width, float Height, GLuint TexID, BYTE *TexDatas);

// ------------------------------------------------------
// Name: Initialize()
// Desc: Perform the various initializations
BOOL Initialize(void) {
	// Turn vblank synchro on if possible
	if(Check_GL_Extension("WGL_EXT_swap_control")) {
		PFNWGLSWAPINTERVALEXTPROC pwglSwapIntervalEXT = (PFNWGLSWAPINTERVALEXTPROC) wglGetProcAddress("wglSwapIntervalEXT");
		if(pwglSwapIntervalEXT) pwglSwapIntervalEXT(1);
	}

	glShadeModel(GL_FLAT);
	glClearDepth(1.0f);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	Set2D(g_window->init.width, g_window->init.height);

	Font_Base = glGenLists(256);
	Text_Font = Get_Font("Lucida Console", 9);
	SelectObject(g_window->hDC, Text_Font);
	wglUseFontBitmaps(g_window->hDC, 0, 255, Font_Base);
	Font_Height = Get_Text_Height("|", 1);
	Font_Width = Get_Text_Width("W", 1);

	if(g_FullScreen) Mouse_Gap = 4;

	Logo = Load_Picture(IDR_LOGO, 300, 80, 300, 80, 3);

	txLogo_Id = Create_NV_Texture(300, 80, Logo);

	Create_Gadget(ID_INSTR_NBR, GADGET_ENABLED | GADGET_NUMBER , Current_Instr_Nbr, 1, 1, 0, 0);
	Create_Gadget(ID_INSTR_NBR, GADGET_DISABLED | GADGET_NUMBER, Total_Instr_Nbr, 6, 1, 0, 0);
	Create_Gadget(ID_INSTR_PLAY, GADGET_ENABLED, Play_Instr, 19, 1, 0, 0);
	Create_Gadget(ID_INSTR_NOTE, GADGET_ENABLED, Instr_Note, 24, 1, 0, 0);
	Create_Gadget(ID_INSTR_PREV, GADGET_ENABLED, Prev, 29, 1, 0, 0);
	Create_Gadget(ID_INSTR_NEXT, GADGET_ENABLED, Next, 29 + 5, 1, 0, 0);

	Create_Gadget(ID_INSTR_NEW, GADGET_ENABLED, New, 5, 21, 0, 0);
	Create_Gadget(ID_INSTR_DELETE_INSTR, GADGET_ENABLED, Delete, 9, 21, 0, 0);
	Create_Gadget(ID_INSTR_LOAD, GADGET_ENABLED, Load, 13 + 4, 21, 0, 0);
	Create_Gadget(ID_INSTR_SAVE, GADGET_ENABLED, Save, 13 + 4 + 5, 21, 0, 0);
	Create_Gadget(ID_INSTR_ADD_WAVE, GADGET_ENABLED, Add, 14 + 4 + 5 + 5, 21, 0, 0);
	Create_Gadget(ID_INSTR_DELETE_WAVE, GADGET_ENABLED, Delete, 14 + 4 + 5 + 5 + 4, 21, 0, 0);

	Create_Gadget(ID_INSTR_SELECTION, GADGET_AREA, "", 1, 3, 37, 18);

	Create_Gadget(ID_SEQ_NBR, GADGET_ENABLED | GADGET_NUMBER, Current_Seq_Nbr, 40, 1, 0, 0);
	Create_Gadget(ID_SEQ_NBR, GADGET_DISABLED | GADGET_NUMBER, Total_Seq_Nbr, 45, 1, 0, 0);
	Create_Gadget(ID_SEQ_OCTAVE, GADGET_ENABLED, Current_Octave, 51, 1, 0, 0);
	Create_Gadget(ID_SEQ_PREV, GADGET_ENABLED, Prev, 58, 1, 0, 0);
	Create_Gadget(ID_SEQ_NEXT, GADGET_ENABLED, Next, 58 + 5, 1, 0, 0);
	Create_Gadget(ID_SEQ_NEW, GADGET_ENABLED, New, 47 + 5 + 5, 21, 0, 0);
	Create_Gadget(ID_SEQ_DELETE, GADGET_ENABLED, Delete, 47 + 4 + 5 + 5, 21, 0, 0);
	Create_Gadget(ID_SEQ_TEMPO, GADGET_ENABLED | GADGET_NUMBER, Current_Tempo, 40, 21, 0, 0);
	Create_Gadget(ID_SEQ_FX_TEMPO, GADGET_ENABLED | GADGET_NUMBER, Current_Fx_Tempo, 45, 21, 0, 0);
	Create_Gadget(ID_SEQ_PLAY, GADGET_ENABLED, Play_Instr, 51, 21, 0, 0);

	Create_Gadget(ID_SEQ_SELECTION, GADGET_AREA, "", 40, 3, 27, 18);

	Create_Gadget(ID_SONG_NEW, GADGET_ENABLED, New_Song, 106, 23, 0, 0);
	Create_Gadget(ID_SONG_CLEAN, GADGET_ENABLED, Clean_Song, 106, 25, 0, 0);
	Create_Gadget(ID_SONG_LOAD, GADGET_ENABLED, Load_Song, 106, 27, 0, 0);
	Create_Gadget(ID_SONG_SAVE, GADGET_ENABLED, Save_Song, 106, 29, 0, 0);
	Create_Gadget(ID_SONG_ADD, GADGET_ENABLED, Add_Song, 106, 31, 0, 0);
	Create_Gadget(ID_SONG_INSERT, GADGET_ENABLED, Insert_Song, 106, 33, 0, 0);
	Create_Gadget(ID_SONG_DELETE, GADGET_ENABLED, Delete, 106, 35, 0, 0);
	Create_Gadget(ID_SONG_PLAY, GADGET_ENABLED, Play, 106, 37, 0, 0);
	Create_Gadget(ID_SONG_PLAYFP, GADGET_ENABLED, PlayP, 106, 39, 0, 0);
	Create_Gadget(ID_SONG_STOP, GADGET_ENABLED, Stop, 106, 41, 0, 0);
	Create_Gadget(ID_SONG_RESTART, GADGET_ENABLED | GADGET_NUMBER, strSong_Restart, 106, 43, 0, 0);

	Create_Gadget(ID_SONG_SELECTION, GADGET_AREA, "", 1, 23, 103, 25);
	Create_Gadget(ID_SONG_NBR, GADGET_DISABLED | GADGET_NUMBER, Total_Song_Nbr, 1, 48, 0, 0);

	Create_Gadget(ID_MISC_QUIT, GADGET_ENABLED, Quit, 106, 46, 0, 0);

	Create_Gadget(ID_SONG_VOICE1, GADGET_ENABLED, Voice_On, 10, 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE2, GADGET_ENABLED, Voice_On, 10 + (12 * 1), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE3, GADGET_ENABLED, Voice_On, 10 + (12 * 2), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE4, GADGET_ENABLED, Voice_On, 10 + (12 * 3), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE5, GADGET_ENABLED, Voice_On, 10 + (12 * 4), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE6, GADGET_ENABLED, Voice_On, 10 + (12 * 5), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE7, GADGET_ENABLED, Voice_On, 10 + (12 * 6), 48, 0, 0);
	Create_Gadget(ID_SONG_VOICE8, GADGET_ENABLED, Voice_On, 10 + (12 * 7), 48, 0, 0);

	Create_Gadget(ID_MISC_WAVE, GADGET_ENABLED, Wave, 102, 1, 0, 0);
	Create_Gadget(ID_MISC_PREFS, GADGET_ENABLED, Prefs, 107, 1, 0, 0);
	
	Positions[0] = new CList;
	Positions[1] = new CList;
	Positions[2] = new CList;
	Positions[3] = new CList;
	Positions[4] = new CList;
	Positions[5] = new CList;
	Positions[6] = new CList;
	Positions[7] = new CList;

	Erase_All();

	Synth_Init(g_window->hWnd, &Synchro);

	hReplayThread = CreateThread(NULL, 0, &Synth_Thread, 0, 0, &ThreadId);

	Display_Tempo(Tempo);
	Display_Fx_Tempo(Fx_Tempo);

	return(TRUE);
}

// ------------------------------------------------------
// Name: Synth_Thread()
// Desc: Audio rendering
DWORD WINAPI Synth_Thread(LPVOID lpParameter) {
	for(;;) {
		Synth_Play();
		Sleep(1);
	}
	return(FALSE);
}

// ------------------------------------------------------
// Name: Deinitialize()
// Desc: Free allocated resources
void Deinitialize(void) {
	if(hReplayThread) {
		TerminateThread(hReplayThread, 0);
		CloseHandle(hReplayThread);
	}
	if(txLogo_Id) glDeleteTextures(1, &txLogo_Id);
	if(Logo) free(Logo);
	Free_List(&Gadgets);
	Free_Instruments();
	Free_Sequences();
	Free_Positions();
	Synth_Stop();
}

// ------------------------------------------------------
// Name: Update()
// Desc: Update the scene
void Update(float milliseconds, float TotalTime) {

	Sleep(1);

	if(Flash_Logo) {
		if(Flash_Color > 0.0f) Flash_Color -= 1.3f * milliseconds;
		else {
			Flash_Logo = FALSE;
			Flash_Color = 0.0f;
		}
	}

	if(Temp_Error > 0.0f) Temp_Error -= milliseconds;
	else {
		Was_Error = FALSE;
		Temp_Error = 0.0f;
	}

	Caret_Time += milliseconds;
	if(Caret_Time >= 0.4f) {
		Caret_Flash ^= TRUE;
		Caret_Time = 0.0f;
	}
}

// ------------------------------------------------------
// Name: Draw()
// Desc: Draw the scene
void Draw(void) {
	int i = 0;
	int j = 0;
	int Max_Instr_Entries_Display;
	LPGADGET Current_Gadget;
	int Remove_HighLight;
	LPINSTRUMENT_DAT Current_Instrument_Dats;
	BYTE Carac;
	int Max_Value;
	int Old_WaveForm;
	LPSONG_DAT Song_Dat;
	LPSONG_DAT Song_Dat_2;
	int Max_Display_Positions;
	int Last_Instrument_Number;
	int In_Delay_Line;
	int Combined_Value;
	int Sequence_ToGo;
	int Pos_Caret_X_Temp;

	glClear(GL_COLOR_BUFFER_BIT);

	Display_Oscillators();

	// About
	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glDisable(GL_BLEND);
	if(Logo) {
		Draw_Pixels(484.0f, 558.0f, 300, 80, txLogo_Id, Logo);

		if(Flash_Logo) {
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
			glColor4f(Flash_Color, Flash_Color / 2,Flash_Color / 3, 1.0f);
			glPushMatrix();
				glTranslatef(69.1f * Font_Width, 576.0f - (7.0f * Font_Height) - Font_Height - 2.0f, -1.0f);
				glBegin(GL_QUADS);
					glVertex3f((43.0f * Font_Width) - 1.0f, (7.0f * Font_Height) - 4.0f, 0.0f);
					glVertex3f(0.0f, (7.0f * Font_Height) - 4.0f, 0.0f);
					glVertex3f(0.0f, 0.0f, 0.0f);
					glVertex3f((43.0f * Font_Width) - 1.0f, 0.0f, 0.0f);
				glEnd();
			glPopMatrix();
			glDisable(GL_BLEND);
		}

	}

	Display_Box(69, 3, 43, 10);
	Display_Text(Credits1, 89, 10, 0.5f, 0.5f, 0.5f);
	Display_Text(Credits2, 87, 11, 0.5f, 0.5f, 0.5f);

	// Equalizer
	Display_Box(69, 13, 43, 8);
	Display_Box(69, 13, 21, 8);

	// Status
	if(Temp_Error == 0.0f) Status_Message = Status_Ok;
	Display_Error(Status_Message, 69, 21);

	// Instruments editor
	Display_Box(1, 3, 37, 18);
	Display_Text(Line_Instrument_Labels, 1, 3, 0.5f, 0.5f, 0.5f);
	if(Loading == FALSE) {
		if(Current_Instrument) {
			Max_Instr_Entries_Display = Current_Instrument->Datas->Get_Number_Of_Entries();
			if(Max_Instr_Entries_Display > 16) Max_Instr_Entries_Display = 16;
			if(Max_Instr_Entries_Display > (Current_Instrument->Datas->Get_Number_Of_Entries() - Pos_Instrument_Scroll)) {
				// Don't display "unecessary datas"
				Max_Instr_Entries_Display = (Current_Instrument->Datas->Get_Number_Of_Entries() - Pos_Instrument_Scroll);
			}
			// Sequence editor
			for(i = 0; i < Max_Instr_Entries_Display; i += 2) {
				Draw_Square(1, i + 4, 37, 1, 0.0f, 0.1f, 0.1f);
			}
			for(i = 0; i < Max_Instr_Entries_Display; i++) {
				Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(i + Pos_Instrument_Scroll);
				switch(Current_Instrument_Dats->Operator) {
					case INS_OP_ADD:
						Line_Instrument[0] = '+';
						break;
					case INS_OP_SUB:
						Line_Instrument[0] = '-';
						break;
					case INS_OP_MUL:
						Line_Instrument[0] = '*';
						break;
					case INS_OP_DIV:
						Line_Instrument[0] = '/';
						break;
				}
				Print_Hex2(&Line_Instrument[2], Current_Instrument_Dats->Waveform);
				if(Current_Instrument_Dats->Waveform != INS_WF_CUST) {
					Print_Hex4(&Line_Instrument[5], Current_Instrument_Dats->PhaseShift);
				} else {
					Line_Instrument[5] =  ' ';
					if((signed short) Current_Instrument_Dats->PhaseShift < 0) Line_Instrument[6] =  '-';
					else Line_Instrument[6] =  '+';
					Print_Hex2(&Line_Instrument[7], Current_Instrument_Dats->PhaseShift);
				}
				Print_Hex2(&Line_Instrument[10], Current_Instrument_Dats->Attack_Vol);
				Print_Hex4(&Line_Instrument[12], Current_Instrument_Dats->Attack);
				Print_Hex2(&Line_Instrument[17], Current_Instrument_Dats->Decay_Vol);
				Print_Hex4(&Line_Instrument[19], Current_Instrument_Dats->Decay);
				Print_Hex2(&Line_Instrument[24], Current_Instrument_Dats->Sustain_Vol);
				Print_Hex4(&Line_Instrument[26], Current_Instrument_Dats->Sustain);
				Print_Hex2(&Line_Instrument[31], Current_Instrument_Dats->Release_Vol);
				Print_Hex4(&Line_Instrument[33], Current_Instrument_Dats->Release);
				if(i & 1) Display_Text(Line_Instrument, 1, i + 4, 0.4f, 0.5f, 0.5f);
				else Display_Text(Line_Instrument, 1, i + 4, 0.5f, 0.6f, 0.6f);
			}
		}
	}

	// Sequence editor
	for(i = 0; i < 16; i += 2) {
		Draw_Square(40, i + 4, 27, 1, 0.0f, 0.1f, 0.1f);
	}

	if(Play_Type == Play_Sequence) {
		Draw_Square(40, Cur_Seq_Play_Pos + 4, 27, 1, 0.3f, 0.1f, 0.1f);
	}
	
	Display_Box(40, 3, 27, 18);
	Display_Box(40, 3, 2, 18);
	Display_Text(Line_Seq_Labels, 40, 3, 0.5f, 0.5f, 0.5f);
	for(i = 0; i < 16; i += 2) {
		Print_Hex2(Line_Seq, i);
		Set_Note(&Line_Seq[3], Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i]);
		Print_Hex4(&Line_Seq[6], Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i]);
		if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i]) {
			Print_Hex2(&Line_Seq[10], Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] - 1);
		} else {
			Line_Seq[10] = '-';
			Line_Seq[11] = '-';
		}
		if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i]) {
			Print_Hex2(&Line_Seq[12], Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] - 1);
		} else {
			Line_Seq[12] = '-';
			Line_Seq[13] = '-';
		}
		Print_Hex2(&Line_Seq[15], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i]);
		Print_Hex1(&Line_Seq[17], Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i]);
		Print_Hex2(&Line_Seq[18], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i]);
		Print_Hex2(&Line_Seq[20], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i]);
		Print_Hex2(&Line_Seq[22], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i]);
		Print_Hex1(&Line_Seq[24], Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i]);
		Print_Hex2(&Line_Seq[25], Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i]);
		if((Play_Type == Play_Sequence) && i == Cur_Seq_Play_Pos) {
			Display_Text(Line_Seq, 40, i + 4, 0.8f, 0.5f, 0.5f);
		} else {
			Display_Text(Line_Seq, 40, i + 4, 0.5f, 0.6f, 0.6f);
		}

		Print_Hex2(Line_Seq, i + 1);
		Set_Note(&Line_Seq[3], Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i + 1]);
		Print_Hex4(&Line_Seq[6], Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i + 1]);
		if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i + 1]) {
			Print_Hex2(&Line_Seq[10], Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i + 1] - 1);
		} else {
			Line_Seq[10] = '-';
			Line_Seq[11] = '-';
		}
		if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i + 1]) {
			Print_Hex2(&Line_Seq[12], Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i + 1] - 1);
		} else {
			Line_Seq[12] = '-';
			Line_Seq[13] = '-';
		}
		Print_Hex2(&Line_Seq[15], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i + 1]);
		Print_Hex1(&Line_Seq[17], Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i + 1]);
		Print_Hex2(&Line_Seq[18], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i + 1]);
		Print_Hex2(&Line_Seq[20], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i + 1]);
		Print_Hex2(&Line_Seq[22], Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i + 1]);
		Print_Hex1(&Line_Seq[24], Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i + 1]);
		Print_Hex2(&Line_Seq[25], Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i + 1]);
		if((Play_Type == Play_Sequence) && (i + 1) == Cur_Seq_Play_Pos) {
			Display_Text(Line_Seq, 40, i + 4 + 1, 0.8f, 0.5f, 0.5f);
		} else {
			Display_Text(Line_Seq, 40, i + 4 + 1, 0.4f, 0.5f, 0.5f);
		}
	}

	// Song positions editor	
	Max_Display_Positions = Positions[0]->Get_Number_Of_Entries();
	if(Max_Display_Positions > 23) Max_Display_Positions = 23;
	if(Max_Display_Positions > (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll)) {
		// Don't display "unecessary datas"
		Max_Display_Positions = (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll);
	}
	for(i = 0; i < Max_Display_Positions; i += 2) {
		Draw_Square(1, i + 24, 103, 1, 0.0f, 0.1f, 0.1f);
	}

	if(Play_Type == Play_Song) {
		if((Song_Position - Pos_Song_Scroll) >= 0) {
			if((Song_Position - Pos_Song_Scroll) < 23) {
				Draw_Square(1, ((Song_Position + 1) - Pos_Song_Scroll) + 23, 103, 1, 0.3f, 0.1f, 0.1f);
			}
		}
	}

	Display_Box(1, 23, 103, 25);
	Display_Box(1, 23, 4, 25);
	Display_Box(1, 23, 17, 25);
	Display_Box(1, 23, 17 + (12 * 1), 25);
	Display_Box(1, 23, 17 + (12 * 2), 25);
	Display_Box(1, 23, 17 + (12 * 3), 25);
	Display_Box(1, 23, 17 + (12 * 4), 25);
	Display_Box(1, 23, 17 + (12 * 5), 25);
	Display_Box(1, 23, 17 + (12 * 6), 25);
	Display_Text(Line_Song_Labels, 1, 23, 0.5f, 0.5f, 0.5f);

	if(Loading == FALSE) {
		for(i = 0; i < Max_Display_Positions; i++) {
			Print_Hex4(&Line_Song[0], i + Pos_Song_Scroll + 1);
			for(j = 0; j < 8; j++) {
				if(Loading == TRUE) break;
				Song_Dat = (LPSONG_DAT) Positions[j]->Get_Entry_By_Ordinal_Long(i + Pos_Song_Scroll);
				if(Song_Dat) {
					Print_Hex4(&Line_Song[6 + (j * 12)], Song_Dat->Seq_Nbr);
					if((signed char) Song_Dat->Transpose < 0) Line_Song[11 + (j * 12)] = '-';
					else Line_Song[11 + (j * 12)] = '+';
					Print_Hex2(&Line_Song[12 + (j * 12)], Song_Dat->Transpose & 0x7f);
					if(Song_Dat->Volume) {
						Print_Hex2(&Line_Song[15 + (j * 12)], Song_Dat->Volume - 1);
					} else {
						Line_Song[15 + (j * 12)] = '-';
						Line_Song[16 + (j * 12)] = '-';
					}
				}
				if(Loading == TRUE) break;
			}
			if((Play_Type == Play_Song) && (i + Pos_Song_Scroll) == Song_Position) {
				Display_Text(Line_Song, 1, i + 24, 0.8f, 0.5f, 0.5f);
			} else {
				if(i & 1) Display_Text(Line_Song, 1, i + 24, 0.4f, 0.5f, 0.5f);
				else Display_Text(Line_Song, 1, i + 24, 0.5f, 0.6f, 0.6f);
			}
		}
	}

	// Display the gadgets
	Current_Gadget = Display_Gadgets();
	if(Current_Gadget) {
		if(!In_Requester) {
			Remove_HighLight = FALSE;
			if(Current_Gadget_Clicked) {
				if(Mouse_Button == 1 || Mouse_Button == 3) {
					if(Current_Gadget != Current_Gadget_Clicked) {
						Current_Gadget = Current_Gadget_Clicked;
						Remove_HighLight = TRUE;
					}
				}
			}
			if(Current_Gadget->Flags & GADGET_ENABLED) {
				if(Remove_HighLight) {
					Remove_HighLight = FALSE;
				} else {
					if(Mouse_Button == 1 || Mouse_Button == 3) Remove_HighLight = TRUE;
					else Remove_HighLight = FALSE;
				}
				HighLight_Gadget(Current_Gadget, Remove_HighLight);
		
				switch(Mouse_Button) {
					case 1:
					case 3:
						Current_Gadget_Clicked = Current_Gadget;
						if(!Clicked_Gadget) Clicked_Gadget = Current_Gadget->ID;
						break;
					case 2:
						Mouse_Button = 0;
						Current_Gadget_Clicked = NULL;
						if(Clicked_Gadget == Current_Gadget->ID) {
							switch(Current_Gadget->ID) {
								case ID_INSTR_NBR:
									if(Instruments.Get_Number_Of_Entries() > 1) {
										In_Requester = TRUE;
										In_Value_Input = TRUE;
										Input_Type = INPUT_NBR_INSTRUMENT;
										Old_Current_Instr_N = Current_Instr_N;
										Current_Instr_N = 0;
										sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N);
									}
									break;
								case ID_INSTR_NOTE:
									In_Requester = TRUE;
									In_Value_Input = TRUE;
									Input_Type = INPUT_INSTR_NOTE;
									Old_Current_Instr_Note = Current_Instr_Note;
									Set_Note(Instr_Note, Current_Instr_Note);
									break;
								case ID_INSTR_PLAY:
									Play_Current_Instrument();
									break;
								case ID_INSTR_PREV:
									Goto_Prev_Instr();
									break;
								case ID_INSTR_NEXT:
									Goto_Next_Instr();
									break;
								case ID_INSTR_NEW:
									Create_Instrument();
									Create_WaveForm();
									break;
								case ID_INSTR_DELETE_INSTR:
									Play_Type = No_Play;
									if(Instruments.Get_Number_Of_Entries()) {
										Delete_Instrument(Current_Instr_N);
										Display_Total_Nbr_Instruments();
										Replace_Sequences(Current_Instr_N + 1, 0);
									}
									if(Instruments.Get_Number_Of_Entries() == 0) {
										Current_Instr_N = 0;
										sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N);
										Current_Instrument = NULL;
										if(Edit_Mode == Edit_Instrument) {
											g_keys[VK_TAB] = TRUE;
										}
									} else {
										if(Current_Instr_N > (Instruments.Get_Number_Of_Entries() - 1)) Current_Instr_N--;
										Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
										sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
										Confine_Instrument_Caret();
									}
									break;
								case ID_INSTR_LOAD:
									Load_Instrument_Cmd();
									break;
								case ID_INSTR_SAVE:
									if(Current_Instrument) Save_Instrument_Cmd();
									break;
								case ID_INSTR_ADD_WAVE:
									Create_WaveForm();
									break;
								case ID_INSTR_DELETE_WAVE:
									Delete_Current_WaveForm();
									break;
								// ---------------------------------------------
								case ID_SEQ_NBR:
									if(Sequences.Get_Number_Of_Entries() > 1) {
										In_Requester = TRUE;
										In_Value_Input = TRUE;
										Input_Type = INPUT_NBR_SEQUENCE;
										Old_Current_Seq_N = Current_Seq_N;
										Current_Seq_N = 0;
										sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N);
									}
									break;
								case ID_SEQ_OCTAVE:
									In_Requester = TRUE;
									In_Value_Input = TRUE;
									Input_Type = INPUT_NBR_OCTAVE;
									Old_Base_Octave = Base_Octave;
									Base_Octave = 0;
									Display_Octave();
									break;
								case ID_SEQ_PREV:
									Goto_Prev_Seq();
									break;
								case ID_SEQ_NEXT:
									Goto_Next_Seq();
									break;
								case ID_SEQ_NEW:
									Create_Sequence();
									break;
								case ID_SEQ_DELETE:
									Delete_Current_Sequence();
									break;
								case ID_SEQ_TEMPO:
									In_Requester = TRUE;
									In_Value_Input = TRUE;
									Old_Tempo = Tempo;
									Tmp_Tempo = 0;
									Input_Type = INPUT_TEMPO;
									Display_Tempo(Tmp_Tempo);
									break;
								case ID_SEQ_FX_TEMPO:
									In_Requester = TRUE;
									In_Value_Input = TRUE;
									Old_Fx_Tempo = Fx_Tempo;
									Tmp_Fx_Tempo = 0;
									Input_Type = INPUT_FX_TEMPO;
									Display_Fx_Tempo(Tmp_Fx_Tempo);
									break;
								case ID_SEQ_PLAY:
									Play_Current_Sequence();
									break;
								// ---------------------------------------------
								case ID_SONG_NEW:
									Erase_All_Cmd();
									break;
								case ID_SONG_CLEAN:
									Clean_Song_Cmd();
									break;
								case ID_SONG_LOAD:
									Load_Module_Cmd();
									break;
								case ID_SONG_SAVE:
									Save_Module_Cmd();
									break;
								case ID_SONG_ADD:
									Create_Position(-1);
									Display_Total_Nbr_Positions();
									break;
								case ID_SONG_INSERT:
									Create_Position(Pos_Song_Dat);
									Display_Total_Nbr_Positions();
									break;
								case ID_SONG_DELETE:
									if(Positions[0]->Get_Number_Of_Entries() > 0) Delete_Position(Pos_Song_Dat);
									Display_Total_Nbr_Positions();
									break;
								case ID_SONG_PLAY:
									Play_Current_Song(0);
									break;
								case ID_SONG_PLAYFP:
									Play_Current_Song(Pos_Song_Dat);
									break;
								case ID_SONG_STOP:
									Play_Type = No_Play;
									break;
								case ID_SONG_RESTART:
									In_Requester = TRUE;
									In_Value_Input = TRUE;
									Input_Type = INPUT_NBR_RESTART;
									Tmp_Song_Restart = 0;
									sprintf(strSong_Restart, " %04X ", Tmp_Song_Restart);
									break;
								case ID_SONG_VOICE1:
								case ID_SONG_VOICE2:
								case ID_SONG_VOICE3:
								case ID_SONG_VOICE4:
								case ID_SONG_VOICE5:
								case ID_SONG_VOICE6:
								case ID_SONG_VOICE7:
								case ID_SONG_VOICE8:
									Switch_Track(Current_Gadget->ID);
									break;

								case ID_MISC_QUIT:
									Terminate_Application(g_window);
									return;

								case ID_MISC_WAVE:
									return;

								case ID_MISC_PREFS:
									return;
							}
						}
						Clicked_Gadget = 0;
				}
			} else if(Current_Gadget->Flags & GADGET_AREA) {
				switch(Mouse_Button) {
					case 1:
						switch(Current_Gadget->ID) {
							case ID_INSTR_SELECTION:
								Point_Mouse_Instruments(Current_Gadget);
								break;
							case ID_SEQ_SELECTION:
								Point_Mouse_Sequences(Current_Gadget);
								break;
							case ID_SONG_SELECTION:
								Point_Mouse_Positions(Current_Gadget);
								break;
						}
						Current_Gadget_Clicked = Current_Gadget;
						if(!Clicked_Gadget) Clicked_Gadget = Current_Gadget->ID;
						break;
					case 2:
						Mouse_Button = 0;
						Current_Gadget_Clicked = NULL;
						Clicked_Gadget = 0;
						break;
					case 3:
						switch(Current_Gadget->ID) {
							case ID_SEQ_SELECTION:
								Sequence_ToGo = Get_Instrument_From_DblClick(Current_Gadget);
								if(Sequence_ToGo != -1) {
									if(Sequence_ToGo == 0) {
										// Climp to eventually find the corresponding instrument
										for(i = Pos_In_Sequence; i >= 0; i--) {
											if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] != 0) {
												Sequence_ToGo = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] - 1;
												if(Sequence_ToGo < Instruments.Get_Number_Of_Entries()) {
													Current_Instr_N = Sequence_ToGo;
													Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
													sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
													break;
												}
											}
										}
									} else {
										Sequence_ToGo--;
										if(Sequence_ToGo < Instruments.Get_Number_Of_Entries()) {
											Current_Instr_N = Sequence_ToGo;
											Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
											sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
										}
									}
								}
								break;
							case ID_SONG_SELECTION:
								Sequence_ToGo = Get_Sequence_From_DblClick(Current_Gadget);
								if(Sequence_ToGo) {
									// Go to selected sequence
									Sequence_ToGo--;
									if(Sequence_ToGo < Sequences.Get_Number_Of_Entries()) {
										Current_Seq_N = Sequence_ToGo;
										Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
										sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
									}
								}
								break;
						}
				}
				if(Mouse_Wheel) {
					Wheel_Step = abs(Mouse_Wheel);
					if((Wheel_Step % 120) == 0) {
						switch(Current_Gadget->ID) {
							case ID_INSTR_SELECTION:
								if(Mouse_Wheel > 0) Prev_Waveform();
								else Next_Waveform();
								Bring_Caret();
								break;
							case ID_SONG_SELECTION:
								if(Mouse_Wheel > 0) Prev_Position();
								else Next_Position();
								Bring_Caret();
								break;
						}
					}
					Mouse_Wheel = 0;
				}
			}
		}
	} else {
		if(!In_Requester) {
			if(Mouse_Button == 1 || Mouse_Button == 3 && Current_Gadget_Clicked) {
				if(Current_Gadget_Clicked) {
					if(!(Current_Gadget_Clicked->Flags & GADGET_AREA)) {
						HighLight_Gadget(Current_Gadget_Clicked, FALSE);
					} else {
						switch(Current_Gadget_Clicked->ID) {
							case ID_INSTR_SELECTION:
								Point_Mouse_Instruments(Current_Gadget_Clicked);
								break;
							case ID_SEQ_SELECTION:
								Point_Mouse_Sequences(Current_Gadget_Clicked);
								break;
							case ID_SONG_SELECTION:
								Point_Mouse_Positions(Current_Gadget_Clicked);
								break;
						}
					}
				}
			} else Current_Gadget_Clicked = NULL;
		}
	}
	if(Mouse_Button == 2) {
		Mouse_Button = 0;
		Current_Gadget_Clicked = NULL;
		Clicked_Gadget = 0;
	}

	// Handle the keyboard
	if(!In_Requester) {
		if(g_keys[VK_LEFT]) {
			g_keys[VK_LEFT] = FALSE;
			if(g_keys[VK_CONTROL]) Goto_Prev_Seq();
			else if(Pos_Caret_X) Pos_Caret_X--;
			Bring_Caret();
		}
		if(g_keys[VK_RIGHT]) {
			g_keys[VK_RIGHT] = FALSE;
			if(g_keys[VK_CONTROL]) {
				Goto_Next_Seq();
			} else {
				switch(Edit_Mode) {
					case Edit_Instrument:
						if(Pos_Caret_X != (sizeof(Tab_Pos_Caret_Instr) / 4) - 1) Pos_Caret_X++;
						break;
					case Edit_Sequence:
						if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
							if(Pos_Caret_X != (sizeof(Tab_Pos_Caret_Seq_Filter) / 4) - 1) Pos_Caret_X++;
						} else {
							if(Pos_Caret_X != (sizeof(Tab_Pos_Caret_Seq) / 4) - 1) Pos_Caret_X++;
						}
						break;
					case Edit_Song:
						if(Pos_Caret_X != (sizeof(Tab_Pos_Caret_Song) / 4) - 1) Pos_Caret_X++;
						break;
				}
			}
			Bring_Caret();
		}
		if(g_keys[VK_TAB]) {
			g_keys[VK_TAB] = FALSE;
			switch(Edit_Mode) {
				case Edit_Instrument:
					if(g_keys[VK_SHIFT]) {
						if(Positions[0]->Get_Number_Of_Entries()) Edit_Mode = Edit_Song;
						else Edit_Mode = Edit_Sequence;
					}
					else Edit_Mode = Edit_Sequence;
					break;
				case Edit_Sequence:
					if(g_keys[VK_SHIFT]) {
						if(Current_Instrument) {
							if(Current_Instrument->Datas->Get_Number_Of_Entries()) Edit_Mode = Edit_Instrument;
							else {
								if(Positions[0]->Get_Number_Of_Entries()) Edit_Mode = Edit_Song;
								else Edit_Mode = Edit_Sequence;
							}
						} else {
							if(Positions[0]->Get_Number_Of_Entries()) Edit_Mode = Edit_Song;
							else Edit_Mode = Edit_Sequence;
						}
					} else {
						if(Positions[0]->Get_Number_Of_Entries()) Edit_Mode = Edit_Song;
						else {
							if(Current_Instrument) {
								if(Current_Instrument->Datas->Get_Number_Of_Entries()) {
									Edit_Mode = Edit_Instrument;
									break;
								}
							}
							Edit_Mode = Edit_Sequence;
						}
					}
					break;
				case Edit_Song:
					if(g_keys[VK_SHIFT]) Edit_Mode = Edit_Sequence;
					else {
						if(Current_Instrument) {
							if(Current_Instrument->Datas->Get_Number_Of_Entries()) Edit_Mode = Edit_Instrument;
							else Edit_Mode = Edit_Sequence;
						} else Edit_Mode = Edit_Sequence;
					}
					break;
			}
			Set_Caret_Y();
			Pos_Caret_X = 0;
			Bring_Caret();
		}
		if(g_keys[VK_NEXT]) {
			g_keys[VK_NEXT] = FALSE;
			if(g_keys[VK_CONTROL]) {
				Goto_Next_Instr();
			} else {
				switch(Edit_Mode) {
					case Edit_Instrument:
						for(i = 0; i < 15; i++) {
							if(Pos_Instrument_Dat < (Current_Instrument->Datas->Get_Number_Of_Entries() - 1)) {
								Pos_Instrument_Dat++;
								if(Pos_In_Instrument < 15) Pos_In_Instrument++;
								else Pos_Instrument_Scroll++;
							}
						}
						break;
					case Edit_Sequence:
						Old_Pos_In_Sequence = Pos_In_Sequence;
						if(Pos_In_Sequence >= 8) Pos_In_Sequence = 15;
						else Pos_In_Sequence = 8;
						break;
					case Edit_Song:
						for(i = 0; i < 22; i++) {
							if(Pos_Song_Dat < (Positions[0]->Get_Number_Of_Entries() - 1)) {
								Pos_Song_Dat++;
								if(Pos_In_Song < 22) Pos_In_Song++;
								else Pos_Song_Scroll++;
							}
						}
						break;
				}
				Bring_Caret();
			}
		}
		if(g_keys[VK_PRIOR]) {
			g_keys[VK_PRIOR] = FALSE;
			if(g_keys[VK_CONTROL]) {
				Goto_Prev_Instr();
			} else {
				switch(Edit_Mode) {
					case Edit_Instrument:
						for(i = 0; i < 15; i++) {
							if(Pos_Instrument_Dat) {
								Pos_Instrument_Dat--;
								if(Pos_In_Instrument) Pos_In_Instrument--;
								else Pos_Instrument_Scroll--;
							}
						}
						break;
					case Edit_Sequence:
						Old_Pos_In_Sequence = Pos_In_Sequence;
						if(Pos_In_Sequence <= 8) Pos_In_Sequence = 0;
						else Pos_In_Sequence = 8;
						break;
					case Edit_Song:
						for(i = 0; i < 22; i++) {
							if(Pos_Song_Dat) {
								Pos_Song_Dat--;
								if(Pos_In_Song) Pos_In_Song--;
								else Pos_Song_Scroll--;
							}
						}
						break;
				}
				Bring_Caret();
			}
		}
		if(g_keys[VK_HOME]) {
			g_keys[VK_HOME] = FALSE;
			switch(Edit_Mode) {
				case Edit_Instrument:
					Pos_Caret_X = 0;
					break;
				case Edit_Sequence:
					Old_Pos_In_Sequence = Pos_In_Sequence;
					if(g_keys[VK_CONTROL]) Pos_In_Sequence = 0;
					else Pos_Caret_X = 0;
					break;
				case Edit_Song:
					Pos_Caret_X = 0;
					break;
			}
			Bring_Caret();
		}
		if(g_keys[VK_END]) {
			g_keys[VK_END] = FALSE;
			switch(Edit_Mode) {
				case Edit_Instrument:
					Pos_Caret_X = 10;
					break;
				case Edit_Sequence:
					if(g_keys[VK_CONTROL]) {
						Old_Pos_In_Sequence = Pos_In_Sequence;
						Pos_In_Sequence = 15;
					} else {
						if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
							Pos_Caret_X = 9;
						} else {
							Pos_Caret_X = 10;
						}
					}
					break;
				case Edit_Song:
					Pos_Caret_X = 23;
					break;
			}
			Bring_Caret();
		}

		if(g_keys[VK_DOWN]) {
			g_keys[VK_DOWN] = FALSE;
			switch(Edit_Mode) {
				case Edit_Instrument:
					if(g_keys[VK_SHIFT]) {
						for(i = 0; i < 10; i++) {
							Next_Waveform();
						}
					} else {
						Next_Waveform();
					}
					break;
				case Edit_Sequence:
					Old_Pos_In_Sequence = Pos_In_Sequence;
					if(Pos_In_Sequence < 15) Pos_In_Sequence++;
					break;
				case Edit_Song:
					if(g_keys[VK_SHIFT]) {
						for(i = 0; i < 10; i++) {
							Next_Position();
						}
					} else {
						Next_Position();
					}
					break;
			}
			Bring_Caret();
		}
		if(g_keys[VK_UP]) {
			g_keys[VK_UP] = FALSE;
			switch(Edit_Mode) {
				case Edit_Instrument:
					if(g_keys[VK_SHIFT]) {
						for(i = 0; i < 10; i++) {
							Prev_Waveform();
						}
					} else {
						Prev_Waveform();
					}
					break;
				case Edit_Sequence:
					Old_Pos_In_Sequence = Pos_In_Sequence;
					if(Pos_In_Sequence) Pos_In_Sequence--;
					break;
				case Edit_Song:
					if(g_keys[VK_SHIFT]) {
						for(i = 0; i < 10; i++) {
							Prev_Position();
						}
					} else {
						Prev_Position();
					}
					break;
			}
			Bring_Caret();
		}
		// Stop any playback
		if(g_keys[VK_ESCAPE]) {
			g_keys[VK_ESCAPE] = FALSE;
			Play_Type = No_Play;
		}

		if((g_keys['I'] && g_keys[VK_CONTROL])) {
			g_keys['I'] = FALSE;
			Create_Instrument();
			Create_WaveForm();
		}

		if((g_keys['O'] && g_keys[VK_CONTROL])) {
			g_keys['O'] = FALSE;
			Load_Module_Cmd();
		}

		if((g_keys['S'] && g_keys[VK_CONTROL])) {
			g_keys['S'] = FALSE;
			Save_Module_Cmd();
		}

		// Display the caret
		switch(Edit_Mode) {
			case Edit_Instrument:
				if(Current_Instrument) {
					if(Current_Instrument->Datas->Get_Number_Of_Entries()) {
						Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(Pos_Instrument_Dat);

						if((g_keys['N'] && g_keys[VK_CONTROL])) {
							g_keys['N'] = FALSE;
							Create_WaveForm();
						} else if((g_keys['D'] && g_keys[VK_CONTROL])) {
							g_keys['D'] = FALSE;
							Delete_Current_WaveForm();
						} else {
							// Handle hexa chars
							if(Pos_Caret_X == 0) {
								for(i = 0; i < (sizeof(Keys_Operators) / 2); i++) {
									Carac = Keys_Operators[i * 2];
									if(g_keys[Carac]) {
										g_keys[Carac] = FALSE;
										Current_Instrument_Dats->Operator = Keys_Operators[(i * 2) + 1];
									}
								}
							} else {
								if(Pos_Caret_X == 2 && Current_Instrument_Dats->Waveform == INS_WF_CUST) {
									if(g_keys[VK_SUBTRACT]) {
										g_keys[VK_SUBTRACT] = FALSE;
										Current_Instrument_Dats->PhaseShift |= 0xff00;
									}
									if(g_keys[VK_ADD]) {
										g_keys[VK_ADD] = FALSE;
										Current_Instrument_Dats->PhaseShift &= 0xff;
									}
								}
								for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
									Carac = Keys_Hex[i * 2];
									if(g_keys[Carac]) {
										g_keys[Carac] = FALSE;
										switch(Pos_Caret_X) {
											case 1:
												Old_WaveForm = Current_Instrument_Dats->Waveform;
												Get_Hex1(&Current_Instrument_Dats->Waveform, i);
												Max_Value = Current_Instrument_Dats->Waveform;
												if(Max_Value < INS_WF_SIN) Current_Instrument_Dats->Waveform = INS_WF_SIN;
												if(Max_Value > INS_WF_CUST) Current_Instrument_Dats->Waveform = INS_WF_CUST;
												if(Old_WaveForm == INS_WF_CUST && Current_Instrument_Dats->Waveform != INS_WF_CUST) {
													Current_Instrument_Dats->PhaseShift = 0;
												} else {
													if(Old_WaveForm != INS_WF_CUST && Current_Instrument_Dats->Waveform == INS_WF_CUST) {
														Current_Instrument_Dats->PhaseShift = 0;
													}
												}
												break;
											case 2:
												if(Current_Instrument_Dats->Waveform == INS_WF_CUST) {
													Get_Hex2((BYTE *) &(Current_Instrument_Dats->PhaseShift), i);
													if((Current_Instrument_Dats->PhaseShift & 0xff) > 127) {
														Current_Instrument_Dats->PhaseShift = (Current_Instrument_Dats->PhaseShift & 0xff00) | 127;
													}
												} else {
													Get_Hex4(&Current_Instrument_Dats->PhaseShift, i);
													Max_Value = Current_Instrument_Dats->PhaseShift;
												}
												break;
											case 3:
												Get_Hex2(&Current_Instrument_Dats->Attack_Vol, i);
												Max_Value = Current_Instrument_Dats->Attack_Vol;
												if(Max_Value > 100) Current_Instrument_Dats->Attack_Vol = 100;
												Calc_Deltas(Current_Instrument_Dats);
												break;
											case 4:
												Get_Hex4(&Current_Instrument_Dats->Attack, i);
												break;
											case 5:
												Get_Hex2(&Current_Instrument_Dats->Decay_Vol, i);
												Max_Value = Current_Instrument_Dats->Decay_Vol;
												if(Max_Value > 100) Current_Instrument_Dats->Decay_Vol = 100;
												Calc_Deltas(Current_Instrument_Dats);
												break;
											case 6:
												Get_Hex4(&Current_Instrument_Dats->Decay, i);
												break;
											case 7:
												Get_Hex2(&Current_Instrument_Dats->Sustain_Vol, i);
												Max_Value = Current_Instrument_Dats->Sustain_Vol;
												if(Max_Value > 100) Current_Instrument_Dats->Sustain_Vol = 100;
												Calc_Deltas(Current_Instrument_Dats);
												break;
											case 8:
												Get_Hex4(&Current_Instrument_Dats->Sustain, i);
												break;
											case 9:
												Get_Hex2(&Current_Instrument_Dats->Release_Vol, i);
												Max_Value = Current_Instrument_Dats->Release_Vol;
												if(Max_Value > 100) Current_Instrument_Dats->Release_Vol = 100;
												Calc_Deltas(Current_Instrument_Dats);
												break;
											case 10:
												Get_Hex4(&Current_Instrument_Dats->Release, i);
												break;
										}
										Remove_Caret();
										break;
									}
								}
							}
							if(g_keys[VK_BACK]) {
								g_keys[VK_BACK] = FALSE;
								switch(Pos_Caret_X) {
									case 0:
										Current_Instrument_Dats->Operator = INS_OP_ADD;
										break;
									case 1:
										Current_Instrument_Dats->Waveform = INS_WF_SIN;
										break;
									case 2:
										Current_Instrument_Dats->PhaseShift >>= 4;
										break;
									case 3:
										Current_Instrument_Dats->Attack_Vol >>= 4;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 4:
										Current_Instrument_Dats->Attack >>= 4;
										break;
									case 5:
										Current_Instrument_Dats->Decay_Vol >>= 4;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 6:
										Current_Instrument_Dats->Decay >>= 4;
										break;
									case 7:
										Current_Instrument_Dats->Sustain_Vol >>= 4;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 8:
										Current_Instrument_Dats->Sustain >>= 4;
										break;
									case 9:
										Current_Instrument_Dats->Release_Vol >>= 4;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 10:
										Current_Instrument_Dats->Release >>= 4;
										break;
								}
								Remove_Caret();
							}
							if(g_keys[VK_DELETE]) {
								g_keys[VK_DELETE] = FALSE;
								switch(Pos_Caret_X) {
									case 0:
										Current_Instrument_Dats->Operator = INS_OP_ADD;
										break;
									case 1:
										Current_Instrument_Dats->Waveform = INS_WF_SIN;
										break;
									case 2:
										Current_Instrument_Dats->PhaseShift = 0;
										break;
									case 3:
										Current_Instrument_Dats->Attack_Vol = 0;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 4:
										Current_Instrument_Dats->Attack = 0;
										break;
									case 5:
										Current_Instrument_Dats->Decay_Vol = 0;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 6:
										Current_Instrument_Dats->Decay = 0;
										break;
									case 7:
										Current_Instrument_Dats->Sustain_Vol = 0;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 8:
										Current_Instrument_Dats->Sustain = 0;
										break;
									case 9:
										Current_Instrument_Dats->Release_Vol = 0;
										Calc_Deltas(Current_Instrument_Dats);
										break;
									case 10:
										Current_Instrument_Dats->Release = 0;
										break;
								}
								Remove_Caret();
							}
						}
						Display_Caret(Tab_Pos_Caret_Instr[Pos_Caret_X], Caret_Y + Pos_In_Instrument, Tab_Size_Caret_Instr[Pos_Caret_X]);
					}
				}
				break;
			case Edit_Sequence:
				if((g_keys['X'] && g_keys[VK_CONTROL])) {
					g_keys['X'] = FALSE;
					// Cut
					for(i = 0; i < 16; i++) {
						ClipBoard_Sequence_Dats.Note[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i];
						ClipBoard_Sequence_Dats.Instrument[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i];
						ClipBoard_Sequence_Dats.Volume[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i];
						ClipBoard_Sequence_Dats.Panning[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i];
						ClipBoard_Sequence_Dats.DspMask[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i];
						ClipBoard_Sequence_Dats.Dsp[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i];
						ClipBoard_Sequence_Dats.DspDatas1[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i];
						ClipBoard_Sequence_Dats.DspDatas2[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i];
						ClipBoard_Sequence_Dats.DspDatas3[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i];
						ClipBoard_Sequence_Dats.Fx[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i];
						ClipBoard_Sequence_Dats.FxDatas[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i];
					}
					Set_Ok_Message(Ok_Copied);
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = 0;
					Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = 0;
				} else if((g_keys['C'] && g_keys[VK_CONTROL])) {
					g_keys['C'] = FALSE;
					// Copy
					for(i = 0; i < 16; i++) {
						ClipBoard_Sequence_Dats.Note[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i];
						ClipBoard_Sequence_Dats.Instrument[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i];
						ClipBoard_Sequence_Dats.Volume[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i];
						ClipBoard_Sequence_Dats.Panning[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i];
						ClipBoard_Sequence_Dats.DspMask[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i];
						ClipBoard_Sequence_Dats.Dsp[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i];
						ClipBoard_Sequence_Dats.DspDatas1[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i];
						ClipBoard_Sequence_Dats.DspDatas2[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i];
						ClipBoard_Sequence_Dats.DspDatas3[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i];
						ClipBoard_Sequence_Dats.Fx[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i];
						ClipBoard_Sequence_Dats.FxDatas[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i];
					}
					Set_Ok_Message(Ok_Copied);
				} else if((g_keys['V'] && g_keys[VK_CONTROL])) {
					g_keys['V'] = FALSE;
					// Paste
					for(i = 0; i < 16; i++) {
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = ClipBoard_Sequence_Dats.Note[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = ClipBoard_Sequence_Dats.Instrument[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = ClipBoard_Sequence_Dats.Volume[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = ClipBoard_Sequence_Dats.Panning[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = ClipBoard_Sequence_Dats.DspMask[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = ClipBoard_Sequence_Dats.Dsp[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = ClipBoard_Sequence_Dats.DspDatas1[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = ClipBoard_Sequence_Dats.DspDatas2[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = ClipBoard_Sequence_Dats.DspDatas3[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = ClipBoard_Sequence_Dats.Fx[i];
						Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = ClipBoard_Sequence_Dats.FxDatas[i];
					}
				} else if((g_keys['N'] && g_keys[VK_CONTROL])) {
					g_keys['N'] = FALSE;
					Create_Sequence();
				} else if((g_keys['D'] && g_keys[VK_CONTROL])) {
					g_keys['D'] = FALSE;
					Delete_Current_Sequence();
				} else if((g_keys['K'] && g_keys[VK_CONTROL] && g_keys[VK_SHIFT])) {
					g_keys['K'] = FALSE;
					for(i = Pos_In_Sequence; i < 16; i++) {
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = 0;
						Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = 0;
					}
				} else if((g_keys['L'] && g_keys[VK_CONTROL])) {
					g_keys['L'] = FALSE;
					In_Delay_Line = FALSE;
					if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_DELAY || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_REVERB || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_FORMANT) In_Delay_Line = TRUE;
					switch(Pos_Caret_X) {
						case 0:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = 0;
						case 1:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = 0;
						case 2:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence] = 0;
						case 3:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence] = 0;
						case 4:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[Pos_In_Sequence] = 0;
						case 5:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] = 0;
						case 6:
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] = 0;
					}
					if(In_Delay_Line) {
						switch(Pos_Caret_X) {
							case 0:
							case 1:
							case 2:
							case 3:
							case 4:
							case 5:
							case 6:
							case 7:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
							case 8:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
							case 9:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = 0;
							case 10:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] = 0;
						}
					} else {
						switch(Pos_Caret_X) {
							case 0:
							case 1:
							case 2:
							case 3:
							case 4:
							case 5:
							case 6:
							case 7:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
							case 8:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = 0;
							case 9:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] = 0;
						}
					}
				} else if((g_keys['K'] && g_keys[VK_CONTROL])) {
					g_keys['K'] = FALSE;
					In_Delay_Line = FALSE;
					if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_DELAY || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_REVERB || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] == SEQ_DSP_FORMANT) In_Delay_Line = TRUE;
					switch(Pos_Caret_X) {
						case 0:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
							}
							break;
						case 1:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = 0;
							}
							break;
						case 2:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = 0;
							}
							break;
						case 3:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = 0;
							}
							break;
						case 4:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = 0;
							}
							break;
						case 5:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = 0;
							}
							break;
						case 6:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = 0;
							}
							break;
						case 7:
							for(i = Pos_In_Sequence; i < 16; i++) {
								if(In_Delay_Line) {
									if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_FORMANT) {
										Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
									}
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
								} else {
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
								}
							}
							break;
						case 8:
							for(i = Pos_In_Sequence; i < 16; i++) {
								if(In_Delay_Line) {
									if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] != SEQ_DSP_FORMANT) {
										Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
									}
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
								} else {
									Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = 0;
								}
							}
							break;
						case 9:
							for(i = Pos_In_Sequence; i < 16; i++) {
								if(In_Delay_Line) Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = 0;
								else Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = 0;
							}
							break;
						case 10:
							for(i = Pos_In_Sequence; i < 16; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = 0;
							}
							break;
					}
				} else {
					if(Pos_Caret_X == 0) {
						// Handle hexa chars
						for(i = 0; i < sizeof(szCharsNotesUp); i++) {
							Carac = szCharsNotesUp[i];
							if(g_keys[Carac]) {
								g_keys[Carac] = FALSE;
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = (i + ((Base_Octave + 1) * 12)) + 1;
								if(g_keys[VK_SHIFT] == FALSE) if(Current_Instrument) Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = Current_Instr_N + 1;
								if(Pos_In_Sequence < 15) Pos_In_Sequence++;
								Remove_Caret();
							}
							Carac = szCharsNotesDown[i];
							if(g_keys[Carac]) {
								g_keys[Carac] = FALSE;
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = (i + (Base_Octave * 12)) + 1;
								if(g_keys[VK_SHIFT] == FALSE) if(Current_Instrument) Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = Current_Instr_N + 1;
								if(Pos_In_Sequence < 15) Pos_In_Sequence++;
								Remove_Caret();
							}
						}
					} else {
						for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
							Carac = Keys_Hex[i * 2];
							if(g_keys[Carac]) {
								g_keys[Carac] = FALSE;
								switch(Pos_Caret_X) {
									case 1:
										Get_Hex4(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence], i);
										break;
									case 2:
										if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence]) Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence]--;
										Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence], i);
										Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence]++;
										Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence];
										if(Max_Value > 101) Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence] = 101;
										break;
									case 3:
										if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence]) Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence]--;
										Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence], i);
										Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence]++;
										Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence];
										if(Max_Value > 101) Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence] = 101;
										break;
									case 4:
										Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[Pos_In_Sequence], i);
										break;
									case 5:
										Get_Hex1(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence], i);
										Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence];
										if(Max_Value > SEQ_DSP_REVERB) Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] = SEQ_DSP_REVERB;
										if(Max_Value == SEQ_DSP_DELAY || Max_Value == SEQ_DSP_REVERB) {
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] = 0;
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
										}
										break;
								}
								if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB) {
									if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
										switch(Pos_Caret_X) {
											case 6:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence], i);
												break;
											case 7:
												Get_Hex4_Split(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence], &Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence], i);
												break;
											case 8:
												Get_Hex1(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence], i);
												Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence];
												if(Max_Value > SEQ_FX_SYNCHRO) Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = SEQ_FX_SYNCHRO;
												break;
											case 9:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence], i);
												break;
										}
									} else {
										switch(Pos_Caret_X) {
											case 6:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence], i);
												break;
											case 7:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence], i);
												break;
											case 8:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence], i);
												break;
											case 9:
												Get_Hex1(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence], i);
												Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence];
												if(Max_Value > SEQ_FX_SYNCHRO) Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = SEQ_FX_SYNCHRO;
												break;
											case 10:
												Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence], i);
												break;
										}
									}
								} else {
									switch(Pos_Caret_X) {
										case 6:
											Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence], i);
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] = 100;
											break;
										case 7:
											Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence], i);
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 100;
											break;
										case 8:
											Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence], i);
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence];
											if(Max_Value > 100) Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 100;
											break;
										case 9:
											Get_Hex1(&Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence], i);
											Max_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence];
											if(Max_Value > SEQ_FX_SYNCHRO) Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = SEQ_FX_SYNCHRO;
											break;
										case 10:
											Get_Hex2(&Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence], i);
											break;
									}
								}
								Remove_Caret();
								break;
							}
						}
					}
					if(g_keys[VK_DECIMAL]) {
						g_keys[VK_DECIMAL] = FALSE;
						goto Delete_Seq_Datas;
					}
					// Increment sequence note/octave
					if(g_keys[VK_F3]) {
						g_keys[VK_F3] = FALSE;
						if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE3);
						else {
							Last_Instrument_Number = 0;
							for(i = 0; i < 16; i++) {
								if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i]) {
									Last_Instrument_Number = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i];
								}
								if(Last_Instrument_Number == (Current_Instr_N + 1)) {
									if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i]) {
										if(g_keys[VK_SHIFT]) {
											Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] += 12;
											if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] > 120) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] -= 120;
										} else {
											Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i]++;
											if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] > 120) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
										}
									}
								}
							}
						}
					}
					// Decrement sequence note/octave
					if(g_keys[VK_F4]) {
						g_keys[VK_F4] = FALSE;
						if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE4);
						else {
							Last_Instrument_Number = 0;
							for(i = 0; i < 16; i++) {
								if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i]) {
									Last_Instrument_Number = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i];
								}
								if(Last_Instrument_Number == (Current_Instr_N + 1)) {
									if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i]) {
										if(g_keys[VK_SHIFT]) {
											Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] -= 12;
											if((char) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] <= 0) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] += 120;
										} else {
											Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i]--;
											if((char) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] < 0) Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
										}
									}
								}
							}
						}
					}

					if(g_keys[VK_INSERT]) {
						g_keys[VK_INSERT] = FALSE;
						if(g_keys[VK_SHIFT]) {
							// Move datas down
							for(i = 14; i >= Pos_In_Sequence; i--) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i + 1] = Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i];
							}
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] = 0;
							Remove_Caret();
						}
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						switch(Pos_Caret_X) {
							case 0:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = 0;
								break;
							case 1:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] >>= 4;
								break;
							case 2:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence] >>= 4;
								break;
							case 3:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence] >>= 4;
								break;
							case 4:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[Pos_In_Sequence] >>= 4;
								break;
							case 5:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] >>= 4;
								break;
							case 6:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] >>= 4;
								break;
						}
						if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
							switch(Pos_Caret_X) {
								case 7:
									Combined_Value = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] << 8;
									Combined_Value |= Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence];
									Combined_Value >>= 4;
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = Combined_Value >> 8;
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = Combined_Value & 0xff;
									break;
								case 8:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] >>= 4;
									break;
								case 9:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] >>= 4;
									break;
							}
						} else {
							switch(Pos_Caret_X) {
								case 7:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] >>= 4;
									break;
								case 8:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] >>= 4;
									break;
								case 9:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] >>= 4;
									break;
								case 10:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] >>= 4;
									break;
							}
						}
						Remove_Caret();
					}

					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						if(g_keys[VK_SHIFT]) {
							// Move datas up
							for(i = Pos_In_Sequence; i <= 14; i++) {
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i + 1];
								Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i + 1];
							}
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[i] = 0;
							Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[i] = 0;
							Remove_Caret();
							goto Seq_Datas_Deleted;
						}
Delete_Seq_Datas:		switch(Pos_Caret_X) {
							case 0:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Note[Pos_In_Sequence] = 0;
								if(!g_keys[VK_CONTROL]) Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = 0;
								break;
							case 1:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence] = 0;
								break;
							case 2:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Volume[Pos_In_Sequence] = 0;
								break;
							case 3:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Panning[Pos_In_Sequence] = 0;
								break;
							case 4:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspMask[Pos_In_Sequence] = 0;
								break;
							case 5:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] = 0;
								break;
							case 6:
								Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas1[Pos_In_Sequence] = 0;
								break;
						}
						if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
							switch(Pos_Caret_X) {
								case 7:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
									break;
								case 8:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = 0;
									break;
								case 9:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] = 0;
									break;
							}
						} else {
							switch(Pos_Caret_X) {
								case 7:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas2[Pos_In_Sequence] = 0;
									break;
								case 8:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->DspDatas3[Pos_In_Sequence] = 0;
									break;
								case 9:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->Fx[Pos_In_Sequence] = 0;
									break;
								case 10:
									Dummy_Sequence_Dats.Seq_Cur_Sequence->FxDatas[Pos_In_Sequence] = 0;
									break;
							}
						}
						Remove_Caret();
					}
				}
Seq_Datas_Deleted:
				if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
					if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] == SEQ_DSP_DELAY || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] == SEQ_DSP_REVERB || Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] == SEQ_DSP_FORMANT) {
						if(Pos_Caret_X == 8) Pos_Caret_X = 7;
						if(Pos_Caret_X == 9) Pos_Caret_X = 8;
						if(Pos_Caret_X == 10) Pos_Caret_X = 9;
					}
					Old_Pos_In_Sequence = Pos_In_Sequence;
					if(Pos_Caret_X > ((sizeof(Tab_Size_Caret_Seq_Filter) / 4) - 1)) Pos_Caret_X = (sizeof(Tab_Size_Caret_Seq_Filter) / 4) - 1;
					Display_Caret(Tab_Pos_Caret_Seq_Filter[Pos_Caret_X], Caret_Y + Pos_In_Sequence, Tab_Size_Caret_Seq_Filter[Pos_Caret_X]);
				} else {
					if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Old_Pos_In_Sequence] != SEQ_DSP_FORMANT) {
						if(Pos_Caret_X == 9) Pos_Caret_X = 10;
						if(Pos_Caret_X == 8) Pos_Caret_X = 9;
					}
					Old_Pos_In_Sequence = Pos_In_Sequence;
					if(Pos_Caret_X > ((sizeof(Tab_Size_Caret_Seq) / 4) - 1)) Pos_Caret_X = (sizeof(Tab_Size_Caret_Seq) / 4) - 1;
					Display_Caret(Tab_Pos_Caret_Seq[Pos_Caret_X], Caret_Y + Pos_In_Sequence, Tab_Size_Caret_Seq[Pos_Caret_X]);
				}
				break;
			case Edit_Song:
				if(Positions[0]->Get_Number_Of_Entries() > 0) {
					switch(Pos_Caret_X) {
						case 0:
						case 3:
						case 6:
						case 9:
						case 12:
						case 15:
						case 18:
						case 21:
							for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
								Carac = Keys_Hex[i * 2];
								if(g_keys[Carac]) {
									g_keys[Carac] = FALSE;
									Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
									Get_Hex4(&Song_Dat->Seq_Nbr, i);
									if(Song_Dat->Seq_Nbr == 0) Song_Dat->Seq_Nbr = 1;
									Remove_Caret();
								}
							}
							break;
						case 1:
						case 4:
						case 7:
						case 10:
						case 13:
						case 16:
						case 19:
						case 22:
							if(g_keys[VK_SUBTRACT]) {
								g_keys[VK_SUBTRACT] = FALSE;
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Transpose |= 0x80;
							}
							if(g_keys[VK_ADD]) {
								g_keys[VK_ADD] = FALSE;
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Transpose &= 0x7f;
							}

							for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
								Carac = Keys_Hex[i * 2];
								if(g_keys[Carac]) {
									g_keys[Carac] = FALSE;
									Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
									Get_Hex2(&Song_Dat->Transpose, i);
									Remove_Caret();
								}
							}
							break;
						case 2:
						case 5:
						case 8:
						case 11:
						case 14:
						case 17:
						case 20:
						case 23:
							for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
								Carac = Keys_Hex[i * 2];
								if(g_keys[Carac]) {
									g_keys[Carac] = FALSE;
									Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
									if(Song_Dat->Volume) Song_Dat->Volume--;
									Get_Hex2(&Song_Dat->Volume, i);
									Song_Dat->Volume++;
									Max_Value = Song_Dat->Volume;
									if(Max_Value > 101) Song_Dat->Volume = 101;
									Remove_Caret();
								}
							}
							break;
					} 
					if((g_keys['K'] && g_keys[VK_CONTROL] && g_keys[VK_SHIFT])) {
						g_keys['K'] = FALSE;
						for(i = Pos_Song_Dat ; i < Positions[(Pos_Caret_X / 3)]->Get_Number_Of_Entries(); i++) {
							Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i);
							Song_Dat->Seq_Nbr = 0;
							Song_Dat->Transpose = 0;
							Song_Dat->Volume = 0;
						}
					} else if((g_keys['K'] && g_keys[VK_CONTROL])) {
						g_keys['K'] = FALSE;
						for(i = Pos_Song_Dat ; i < Positions[(Pos_Caret_X / 3)]->Get_Number_Of_Entries(); i++) {
							Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i);
							switch(Pos_Caret_X % 3) {
								case 0:
									Song_Dat->Seq_Nbr = 0;
									break;
								case 1:
									Song_Dat->Transpose = 0;
									break;
								case 2:
									Song_Dat->Volume = 0;
									break;
							}
						}
					} else if((g_keys['L'] && g_keys[VK_CONTROL])) {
						g_keys['L'] = FALSE;
						Pos_Caret_X_Temp = Pos_Caret_X;
						for(i = (Pos_Caret_X / 3); i < 8; i++) {
							Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
							switch(Pos_Caret_X_Temp % 3) {
								case 0:
									Song_Dat->Seq_Nbr = 0;
								case 1:
									Song_Dat->Transpose = 0;
								case 2:
									Song_Dat->Volume = 0;
									break;
							}
							Pos_Caret_X_Temp = 0;
						}
					} else if(g_keys[VK_INSERT] && g_keys[VK_SHIFT]) {
						g_keys[VK_INSERT] = FALSE;
						// Move datas down
						for(i = Positions[(Pos_Caret_X / 3)]->Get_Number_Of_Entries() - 2; i >= Pos_Song_Dat; i--) {
							Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i);
							Song_Dat_2 = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i + 1);
							Song_Dat_2->Seq_Nbr = Song_Dat->Seq_Nbr;
							Song_Dat_2->Transpose = Song_Dat->Transpose;
							Song_Dat_2->Volume = Song_Dat->Volume;
						}
						Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
						Song_Dat->Seq_Nbr = 0;
						Song_Dat->Transpose = 0;
						Song_Dat->Volume = 0;
						Remove_Caret();
					} else if(g_keys[VK_DELETE] && g_keys[VK_SHIFT]) {
						g_keys[VK_DELETE] = FALSE;
						// Move datas up
						for(i = Pos_Song_Dat; i <= Positions[(Pos_Caret_X / 3)]->Get_Number_Of_Entries() - 2; i++) {
							Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i);
							Song_Dat_2 = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i + 1);
							Song_Dat->Seq_Nbr = Song_Dat_2->Seq_Nbr;
							Song_Dat->Transpose = Song_Dat_2->Transpose;
							Song_Dat->Volume = Song_Dat_2->Volume;
						}
						Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(i);
						Song_Dat->Seq_Nbr = 0;
						Song_Dat->Transpose = 0;
						Song_Dat->Volume = 0;
						Remove_Caret();
					} else if(g_keys[VK_INSERT] && g_keys[VK_CONTROL]) {
						g_keys[VK_INSERT] = FALSE;
						Create_Position(Pos_Song_Dat);
					} else if(g_keys[VK_DELETE] && g_keys[VK_CONTROL]) {
						g_keys[VK_DELETE] = FALSE;
						if(Positions[0]->Get_Number_Of_Entries() > 0) Delete_Position(Pos_Song_Dat);
					} else if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						switch(Pos_Caret_X) {
							case 0:
							case 3:
							case 6:
							case 9:
							case 12:
							case 15:
							case 18:
							case 21:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Seq_Nbr >>= 4;
								break;
							case 1:
							case 4:
							case 7:
							case 10:
							case 13:
							case 16:
							case 19:
							case 22:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Transpose >>= 4;
								break;
							case 2:
							case 5:
							case 8:
							case 11:
							case 14:
							case 17:
							case 20:
							case 23:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Volume >>= 4;
								break;
						}
					} else if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						switch(Pos_Caret_X) {
							case 0:
							case 3:
							case 6:
							case 9:
							case 12:
							case 15:
							case 18:
							case 21:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Seq_Nbr = 0;
								break;
							case 1:
							case 4:
							case 7:
							case 10:
							case 13:
							case 16:
							case 19:
							case 22:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Transpose = 0;
								break;
							case 2:
							case 5:
							case 8:
							case 11:
							case 14:
							case 17:
							case 20:
							case 23:
								Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
								Song_Dat->Volume = 0;
								break;
						}
					}
				}
				Display_Caret(Tab_Pos_Caret_Song[Pos_Caret_X], Caret_Y + Pos_In_Song, Tab_Size_Caret_Song[Pos_Caret_X]);
				break;
		}
	}

	if(In_Requester) {
		if(In_Value_Input) {
			switch(Input_Type) {
				case INPUT_NBR_INSTRUMENT:
					// Handle hexa chars
					for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
						Carac = Keys_Hex[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex4((WORD *) &Current_Instr_N, i);
							sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N);
							Remove_Caret();
						}
					}
					Display_Caret(1, 1, 4);
					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						Current_Instr_N--;
						if(Current_Instr_N < 0) Current_Instr_N = 0;
						if(Current_Instr_N > (Instruments.Get_Number_Of_Entries() - 1)) {
							Current_Instr_N = Instruments.Get_Number_Of_Entries() - 1;
						}
						sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
						Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
						Confine_Instrument_Caret();
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Current_Instr_N >>= 4;
						sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N);
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Current_Instr_N = 0;
						sprintf(Current_Instr_Nbr, "%04X", 0);
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Current_Instr_N = Old_Current_Instr_N;
						sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;
				case INPUT_NBR_SEQUENCE:
					// Handle hexa chars
					for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
						Carac = Keys_Hex[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex4((WORD *) &Current_Seq_N, i);
							sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N);
							Remove_Caret();
						}
					}
					Display_Caret(40, 1, 4);
					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						Current_Seq_N--;
						if(Current_Seq_N < 0) Current_Seq_N = 0;
						if(Current_Seq_N > (Sequences.Get_Number_Of_Entries() - 1)) {
							Current_Seq_N = Sequences.Get_Number_Of_Entries() - 1;
						}
						sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
						Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Current_Seq_N >>= 4;
						sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N);
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Current_Seq_N = 0;
						sprintf(Current_Seq_Nbr, "%04X", 0);
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Current_Seq_N = Old_Current_Seq_N;
						sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;
				case INPUT_TEMPO:
					// Handle hexa chars
					for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
						Carac = Keys_Hex[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex4((WORD *) &Tmp_Tempo, i);
							Display_Tempo(Tmp_Tempo);
							Remove_Caret();
						}
					}
					Display_Caret(40, 21, 4);
					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						if(Tmp_Tempo <= 0) Tmp_Tempo = 1;
						Tempo = Tmp_Tempo;
						Display_Tempo(Tempo);
						Tempo_Ticks = Get_Mix_Buffer_Len(Tempo);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Tmp_Tempo >>= 4;
						Display_Tempo(Tmp_Tempo);
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Tmp_Tempo = 0;
						Display_Tempo(Tmp_Tempo);
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Tmp_Tempo = Old_Tempo;
						Display_Tempo(Tmp_Tempo);
						Tempo_Ticks = Get_Mix_Buffer_Len(Tmp_Tempo);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;

				case INPUT_FX_TEMPO:
					// Handle hexa chars
					for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
						Carac = Keys_Hex[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex4((WORD *) &Tmp_Fx_Tempo, i);
							Display_Fx_Tempo(Tmp_Fx_Tempo);
							Remove_Caret();
						}
					}
					Display_Caret(45, 21, 4);
					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						if(Tmp_Fx_Tempo <= 0) Tmp_Fx_Tempo = 1;
						Fx_Tempo = Tmp_Fx_Tempo;
						Display_Fx_Tempo(Fx_Tempo);
						Fx_Tempo_Ticks = Get_Mix_Buffer_Len(Fx_Tempo);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Tmp_Fx_Tempo >>= 4;
						Display_Fx_Tempo(Tmp_Fx_Tempo);
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Tmp_Fx_Tempo = 0;
						Display_Fx_Tempo(Tmp_Fx_Tempo);
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Tmp_Fx_Tempo = Old_Fx_Tempo;
						Display_Fx_Tempo(Tmp_Fx_Tempo);
						Fx_Tempo_Ticks = Get_Mix_Buffer_Len(Tmp_Fx_Tempo);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;

				case INPUT_INSTR_NOTE:
					// Handle hexa chars
					for(i = 0; i < sizeof(szCharsNotesUp); i++) {
						Carac = szCharsNotesUp[i];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Current_Instr_Note = (i + ((Base_Octave + 1) * 12)) + 1;
							Set_Note(Instr_Note, Current_Instr_Note);
							In_Requester = FALSE;
							In_Value_Input = FALSE;
							Remove_Caret();
							break;
						}
						Carac = szCharsNotesDown[i];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Current_Instr_Note = (i + (Base_Octave * 12)) + 1;
							Set_Note(Instr_Note, Current_Instr_Note);
							In_Requester = FALSE;
							In_Value_Input = FALSE;
							Remove_Caret();
							break;
						}
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Current_Instr_Note = Old_Current_Instr_Note;
						Set_Note(Instr_Note, Current_Instr_Note);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					Display_Caret(24, 1, 3);
					break;

				case INPUT_NBR_OCTAVE:
					// Handle octal chars
					for(i = 0; i < (sizeof(Keys_Octal) / 2); i++) {
						Carac = Keys_Octal[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex1((BYTE *) &Base_Octave, Keys_Octal[(i * 2) + 1]);
							Display_Octave();
							Remove_Caret();
						}
					}
					Display_Caret(51, 1, 1);

					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						if(Base_Octave < 0) Base_Octave = 0;
						if(Base_Octave > 8) Base_Octave = 8;
						Display_Octave();
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Base_Octave >>= 4;
						Display_Octave();
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Base_Octave = 0;
						Display_Octave();
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						Base_Octave = Old_Base_Octave;
						Display_Octave();
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;

				case INPUT_NBR_RESTART:
					// Handle hexa chars
					for(i = 0; i < (sizeof(Keys_Hex) / 2); i++) {
						Carac = Keys_Hex[i * 2];
						if(g_keys[Carac]) {
							g_keys[Carac] = FALSE;
							Get_Hex4((WORD *) &Tmp_Song_Restart, i);
							sprintf(strSong_Restart, " %04X ", Tmp_Song_Restart);
							Remove_Caret();
						}
					}
					Display_Caret(107, 43, 4);

					if(g_keys[VK_RETURN]) {
						g_keys[VK_RETURN] = FALSE;
						if(!Tmp_Song_Restart) Tmp_Song_Restart = 1;
						Song_Restart = Tmp_Song_Restart;
						sprintf(strSong_Restart, " %04X ", Song_Restart);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					if(g_keys[VK_BACK]) {
						g_keys[VK_BACK] = FALSE;
						Tmp_Song_Restart >>= 4;
						sprintf(strSong_Restart, " %04X ", Tmp_Song_Restart);
					}
					if(g_keys[VK_DELETE]) {
						g_keys[VK_DELETE] = FALSE;
						Tmp_Song_Restart = 0;
						sprintf(strSong_Restart, " %04X ", Tmp_Song_Restart);
					}
					if(g_keys[VK_ESCAPE]) {
						g_keys[VK_ESCAPE] = FALSE;
						sprintf(strSong_Restart, " %04X ", Song_Restart);
						In_Requester = FALSE;
						In_Value_Input = FALSE;
					}
					break;
			}
		}
	}

	// (Following shortcuts are always available)

	// Increase base octave
	if(g_keys[VK_F1]) {
		g_keys[VK_F1] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE1);
		else {
			Base_Octave++;
			if(Base_Octave > 8) Base_Octave = 0;
			Display_Octave();
		}
	}

	// Decrease base octave
	if(g_keys[VK_F2]) {
		g_keys[VK_F2] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE2);
		else {
			Base_Octave--;
			if(Base_Octave < 0) Base_Octave = 8;
			Display_Octave();
		}
	}

	if(g_keys[VK_F3]) {
		g_keys[VK_F3] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE3);
	}

	if(g_keys[VK_F4]) {
		g_keys[VK_F4] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE4);
	}

	if(g_keys[VK_F5]) {
		g_keys[VK_F5] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE5);
		else Play_Current_Instrument();
	}

	if(g_keys[VK_F6]) {
		g_keys[VK_F6] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE6);
		else Play_Current_Sequence();
	}

	if(g_keys[VK_F7]) {
		g_keys[VK_F7] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE7);
		else Play_Current_Song(0);
	}

	if(g_keys[VK_F8]) {
		g_keys[VK_F8] = FALSE;
		if(g_keys[VK_CONTROL]) Switch_Track(ID_SONG_VOICE8);
		else Play_Current_Song(Pos_Song_Dat);
	}
}

// ------------------------------------------------------
// Name: Get_Font()
// Desc: Obtain a new font from windows
HFONT Get_Font(char *Font_Name, int Font_Size) {
    LOGFONT CMFont;
	HFONT hFont;

    HDC hDC = GetDC(g_window->hWnd);
    CMFont.lfHeight = -(long)((Font_Size * GetDeviceCaps(hDC, LOGPIXELSY)) / 72);
    CMFont.lfWidth = 0;
    CMFont.lfEscapement = 0;
    CMFont.lfOrientation = 0;
    CMFont.lfUnderline = 0;
    CMFont.lfStrikeOut = 0;
    CMFont.lfCharSet = DEFAULT_CHARSET;
    CMFont.lfOutPrecision = OUT_OUTLINE_PRECIS;
    CMFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
    CMFont.lfQuality = NONANTIALIASED_QUALITY;
	CMFont.lfPitchAndFamily = FF_DONTCARE | DEFAULT_PITCH;
    int FontNameLen = strlen(Font_Name);
	for(int i = 0 ; i <= LF_FACESIZE - 1; i++) {
        if(i == FontNameLen) break;
		CMFont.lfFaceName[i] = Font_Name[i];
    }
    CMFont.lfFaceName[i] = 0;
	CMFont.lfWeight = FW_NORMAL;
    CMFont.lfItalic = 0;
    hFont = CreateFontIndirect(&CMFont);
	ReleaseDC(g_window->hWnd, hDC);
	return(hFont);
}

// ------------------------------------------------------
// Name: Set2D
// Desc: Set the projection for 2d rendering
void Set2D(int Width, int Height) {
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0, Width, 0, Height);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

// ------------------------------------------------------
// Name: Get_Text_Width()
// Desc: Return the width in pixels of a given text with a given font
int Get_Text_Width(char *Txt, int TxtLen) {
	SIZE FontSize;

	GetTextExtentPoint32(g_window->hDC, Txt, TxtLen, &FontSize);
	return(FontSize.cx);
}

// ------------------------------------------------------
// Name: Get_Text_Height()
// Desc: Return the height in pixels of a given text with a given font
int Get_Text_Height(char *Txt, int TxtLen) {
    SIZE FontSize;

    GetTextExtentPoint32(g_window->hDC, Txt, TxtLen, &FontSize);
    return(FontSize.cy);
}

// ------------------------------------------------------
// Name: Display_Error()
// Desc: Display an error text on the screen
void Display_Error(char *Text, int Pos_X, int Pos_Y) {
	if(Text == Status_Ok) {
		Display_Text(Text, Pos_X, Pos_Y, 0.5f, 0.5f, 0.5f);
	} else {
		if(Was_Error) Display_Text(Text, Pos_X, Pos_Y, 0.8f, 0.3f, 0.3f);
		else Display_Text(Text, Pos_X, Pos_Y, 0.0f, 0.8f, 0.3f);
	}
}

// ------------------------------------------------------
// Name: Display_Text()
// Desc: Display a text on the screen
void Display_Text(char *Text, int Pos_X, int Pos_Y, float Red, float Green, float Blue) {
	glPushMatrix();
		glListBase(Font_Base);
		glColor4f(Red, Green, Blue, 1.0f);
		glRasterPos2f((float) ((Pos_X * Font_Width) + 1), (g_window->init.height - ((float) (Pos_Y * Font_Height))) - (Font_Height + 2));
		glCallLists(strlen(Text), GL_BYTE, Text);
	glPopMatrix();
}

// ------------------------------------------------------
// Name: Display_Line()
// Desc: Draw a line on the screen
void Display_Line(int Pos_X1, int Pos_Y1, int Pos_X2, int Pos_Y2, float Red, float Green, float Blue) {
	glColor4f(Red, Green, Blue, 1.0f);
	glPushMatrix();
		glTranslatef(0.0f, 0.0f, -1.0f);
		glBegin(GL_LINES);
			glVertex3f((float) Pos_X1, (float) (g_window->init.height - Pos_Y1) - 1, 1.0f);
			glVertex3f((float) Pos_X2, (float) (g_window->init.height - Pos_Y2) - 1, 1.0f);
		glEnd();
	glPopMatrix();
}

// ------------------------------------------------------
// Name: Display_Box()
// Desc: Draw a box on the screen
void Display_Box(int Pos_X, int Pos_Y, int Width, int Height) {
	int Real_PosX1;
	int Real_PosY1;
	int Real_PosX2;
	int Real_PosY2;

	Real_PosX1 = (Pos_X * Font_Width) - (Font_Width / 2);
	Real_PosX2 = ((Pos_X + Width) * Font_Width) + (Font_Width / 2) + 1;
	Real_PosY1 = (Pos_Y * Font_Height) + (Font_Height / 2) - 5;
	Real_PosY2 = ((Pos_Y + Height) * Font_Height) - (Font_Height / 2) + 1;

	Display_Line(Real_PosX1, Real_PosY1, Real_PosX2, Real_PosY1, 0.3f, 0.3f, 0.3f);
	Display_Line(Real_PosX1, Real_PosY1, Real_PosX1, Real_PosY2, 0.3f, 0.3f, 0.3f);
	Display_Line(Real_PosX2, Real_PosY1, Real_PosX2, Real_PosY2, 0.3f, 0.3f, 0.3f);
	Display_Line(Real_PosX1, Real_PosY2, Real_PosX2 + 1, Real_PosY2, 0.3f, 0.3f, 0.3f);
}

// ------------------------------------------------------
// Name: Display_Caret()
// Desc: Draw the caret on the screen at given location
void Display_Caret(int Pos_X, int Pos_Y, int X_Size) {
	int Real_PosX1;
	int Real_PosY1;
	int Real_PosX2;
	int Real_PosY2;

	if(Caret_Flash) {
		Real_PosX1 = (Pos_X * Font_Width);
		Real_PosX2 = (Pos_X * Font_Width) + (Font_Width * X_Size);
		Real_PosY1 = (Pos_Y * Font_Height) + 4;
		Real_PosY2 = Real_PosY1 + Font_Height;

		Display_Line(Real_PosX1, Real_PosY1, Real_PosX2, Real_PosY1, 0.4f, 0.8f, 0.6f);
		Display_Line(Real_PosX1, Real_PosY1, Real_PosX1, Real_PosY2, 0.4f, 0.8f, 0.6f);
		Display_Line(Real_PosX2, Real_PosY1, Real_PosX2, Real_PosY2, 0.4f, 0.8f, 0.6f);
		Display_Line(Real_PosX1, Real_PosY2, Real_PosX2 + 1, Real_PosY2, 0.4f, 0.8f, 0.6f);
	}
}

// ------------------------------------------------------
// Name: Load_Picture()
// Desc: Load part of the logo from the resources
//		 And convert the green color into alpha channel
BYTE *Load_Picture(int ResourceID, int Width, int Height, int MaxWidth, int MaxHeight, int Bpp) {
	BYTE *Dest_Pic;

	HGLOBAL TextureRes = Load_File_From_Resource(ResourceID);
	if(TextureRes == NULL) return(NULL);

	Dest_Pic = (BYTE *) malloc(MaxWidth * MaxHeight * 4);
	if(!Dest_Pic) return(NULL);
	int Src_Width = (Width * Bpp);
	int Dest_Width = (MaxWidth * 4);
	BYTE *End_Pic = Dest_Pic + (MaxHeight * Dest_Width) - Dest_Width;

	_asm {
		mov edi,Dest_Pic
		mov eax,0xff000000
		mov ecx,MaxWidth
		imul ecx,MaxHeight
		rep stosd

		mov esi,TextureRes
		mov edi,End_Pic
		xor ebx,ebx
Copy_Col:
		mov ecx,MaxWidth
		xor eax,eax
		push edi

Copy_Line:
		xor eax,eax
		lodsb			// 000000rr
		mov dl,al		// rr
		ror eax,8		// rr000000
		lodsb			// rr0000gg
		ror eax,8		// ggrr0000
		lodsb			// ggrr00bb
		mov dh,al		// bb
		ror eax,8		// bbggrr00
		mov ah,dh		// bbggbb00
		bswap eax		// 00bbggbb
		mov al,dl		// 00bbggrr
		and eax,0x00ffffff
		cmp eax,0x0000ff00
		jne Remove_Green
		mov eax,0xff000000
Remove_Green:
		stosd	
		loop Copy_Line
		pop edi
		sub edi,Dest_Width
		inc ebx
		cmp Height,ebx
		jnz Copy_Col
	}
	return(Dest_Pic);
}

// ------------------------------------------------------
// Name: Load_File_From_Resource()
// Desc: Load a file from the resources
HGLOBAL Load_File_From_Resource(int ResourceID) {
	HRSRC hResource = FindResource(0, MAKEINTRESOURCE(ResourceID), "RC_DATA");
	if(hResource == NULL) return(NULL);
	HGLOBAL TextureRes = LoadResource(0, hResource);
	if(TextureRes == NULL) return(NULL);
	TextureRes = LockResource(TextureRes);
	if(TextureRes == NULL) return(NULL);
	return(TextureRes);
}

// ------------------------------------------------------
// Name: Create_Gadget()
// Desc: Register a gadget
void Create_Gadget(int ID, int Flags, char *Text, int PosX, int PosY, int Size_X, int Size_Y) {
	int Real_PosX1;
	int Real_PosY1;
	int Real_PosX2;
	int Real_PosY2;

	int Txt_Len = strlen(Text);;
	LPGADGET New_Gadget = (LPGADGET) malloc(sizeof(GADGET));

	New_Gadget->Text = Text;
	New_Gadget->Flags = Flags;
	New_Gadget->ID = ID;

	New_Gadget->Position.x = PosX;
	New_Gadget->Position.y = PosY;

	if(Flags & GADGET_AREA) {
		Real_PosX1 = (PosX * Font_Width) - (Font_Width / 2);
		Real_PosX2 = ((PosX + Size_X) * Font_Width) + (Font_Width / 2) + 1;
		Real_PosY1 = (PosY * Font_Height) + (Font_Height / 2) - 5;
		Real_PosY2 = ((PosY + Size_Y) * Font_Height) - (Font_Height / 2) + 1;
	} else {
		Real_PosX1 = (PosX * Font_Width) - (Font_Width / 2);
		Real_PosX2 = ((PosX + Txt_Len) * Font_Width) + (Font_Width / 2) + 1;
		Real_PosY1 = (PosY * Font_Height) + (Font_Height / 2) - 5;
		Real_PosY2 = ((PosY + 2) * Font_Height) - (Font_Height / 2) + 1;
	}
	New_Gadget->Screen_Coords.left = Real_PosX1;
	New_Gadget->Screen_Coords.top = Real_PosY1;
	New_Gadget->Screen_Coords.right = Real_PosX2;
	New_Gadget->Screen_Coords.bottom = Real_PosY2;
	Gadgets.Add_Entry((long) New_Gadget);
}

// ------------------------------------------------------
// Name: Free_List()
// Desc: Remove all elements from a list
void Free_List(CList *ListToFree) {
	while(ListToFree->Get_Number_Of_Entries()) {
		ListToFree->Delete_Entry_By_Ordinal(0, true);
	}
}

// ------------------------------------------------------
// Name: Display_Gadget()
// Desc: Display a gadget on the screen
void Display_Gadget(LPGADGET Gadget, int Disp_Text) {
	char *Text = Gadget->Text;
	int Txt_Len = strlen(Text);
	int Pos_X = Gadget->Position.x;
	float Red;
	float Green;
	float Blue;

	Display_Box(Pos_X, Gadget->Position.y, Txt_Len, 2);
	if(Disp_Text) {
		if(Gadget->Flags & GADGET_ENABLED) {
			if(Gadget->Flags & GADGET_NUMBER) {
				Red = 0.4f;
				Green = 0.6f;
				Blue = 0.8f;
			} else {
				Red = 0.8f;
				Green = 0.6f;
				Blue = 0.4f;
			}
		} else {
			if(Gadget->Flags & GADGET_NUMBER) {
				Red = 0.3f;
				Green = 0.5f;
				Blue = 0.7f;
			} else {
				Red = 0.3f;
				Green = 0.5f;
				Blue = 0.7f;
			}
		}
		Display_Text(Text, Pos_X, Gadget->Position.y, Red, Green, Blue);
	}
}

// ------------------------------------------------------
// Name: Display_Gadgets()
// Desc: Display all gadgets on screen
LPGADGET Display_Gadgets(void) {
	LPGADGET Gadget;
	LPGADGET Gadget_Mouse = NULL;
	int i;
	int Real_Y = Mouse_Coords.y;

	if(!g_FullScreen) Real_Y = Mouse_Coords.y + 5;
	if(Mouse_Coords.x > 0 && Mouse_Coords.y > 0) {
		for(i = 0; i < Gadgets.Get_Number_Of_Entries(); i++) {
			Gadget = (LPGADGET) Gadgets.Get_Entry_By_Ordinal_Long(i); 
			if((Mouse_Coords.x >= Gadget->Screen_Coords.left) && (Mouse_Coords.x <= Gadget->Screen_Coords.right)) {
				if((Real_Y >= Gadget->Screen_Coords.top) && (Real_Y <= Gadget->Screen_Coords.bottom)) {
					Gadget_Mouse = Gadget;
					break;
				}
			}
		}
	}
	for(i = 0; i < Gadgets.Get_Number_Of_Entries(); i++) {
		Gadget = (LPGADGET) Gadgets.Get_Entry_By_Ordinal_Long(i);
		if(!(Gadget->Flags & GADGET_AREA)) {
			Display_Gadget(Gadget, TRUE);
		}
	}
	return(Gadget_Mouse);
}

// ------------------------------------------------------
// Name: Get_Gadget_From_ID()
// Desc: Get gadget's datas from it's ID
LPGADGET Get_Gadget_From_ID(int ID) {
	LPGADGET Gadget;

	for(int i = 0; i < Gadgets.Get_Number_Of_Entries(); i++) {
		Gadget = (LPGADGET) Gadgets.Get_Entry_By_Ordinal_Long(i);
		if(Gadget->ID == ID) return(Gadget);
	}
	return(NULL);
}

// ------------------------------------------------------
// Name: HighLight_Gadget()
// Desc: Highlight a gadget
void HighLight_Gadget(LPGADGET Gadget, int Button_HighLight) {
	glShadeModel(GL_SMOOTH);
	glPushMatrix();
		glTranslatef(0.0f, 0.0f, -1.0f);
		glEnable(GL_BLEND);
		if(Button_HighLight) glBlendFunc(GL_ONE, GL_DST_ALPHA);
		else glBlendFunc(GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR);
		glBegin(GL_QUADS);
			glColor4f(0.2f, 0.2f, 0.2f, 1.0f);
			glVertex3f((float) Gadget->Screen_Coords.left + 1, (float) (g_window->init.height - Gadget->Screen_Coords.top - 1), 1.0f);
			glColor4f(0.2f, 0.2f, 0.2f, 1.0f);
			glVertex3f((float) Gadget->Screen_Coords.right, (float) (g_window->init.height - Gadget->Screen_Coords.top - 1), 1.0f);
			glColor4f(0.4f, 0.4f, 0.4f, 1.0f);
			glVertex3f((float) Gadget->Screen_Coords.right, (float) (g_window->init.height - Gadget->Screen_Coords.bottom), 1.0f);
			glColor4f(0.4f, 0.4f, 0.4f, 1.0f);
			glVertex3f((float) Gadget->Screen_Coords.left + 1, (float) (g_window->init.height - Gadget->Screen_Coords.bottom), 1.0f);
		glEnd();
		glDisable(GL_BLEND);
	glPopMatrix();
	glShadeModel(GL_FLAT);
}

// ------------------------------------------------------
// Name: Draw_Spectrum_Bar()
// Desc: Draw a vertical bar in the spectrum array
void Draw_Spectrum_Bar(int Pos_X, int Height1, int Height2) {
	int Bars_Top1 = 264 - Height1;
	int Bars_Top2 = 264 - Height2;

	if(Height1 && Height2) {
		if(Height1 == Height2) Display_Line(Pos_X, (1 + Bars_Top1), Pos_X + 1, (1 + Bars_Top2), 0.4f, 0.8f, 0.4f);
		else Display_Line(Pos_X, (1 + Bars_Top1), Pos_X, (1 + Bars_Top2), 0.4f, 0.8f, 0.4f);
	}
}

// ------------------------------------------------------
// Name: Draw_Square()
// Desc: Draw a square on the screen
void Draw_Square(int Pos_X, int Pos_Y, int Width, int Height, float Red, float Green, float Blue) {
	if(Width && Height) {
		Pos_X *= Font_Width;
		Pos_X -= 2;
		Pos_Y *= Font_Height;
		Pos_Y += (Font_Height - 8);
		Width *= Font_Width;
		Width += (Font_Width / 2) + 2 + 1;
		Height *= Font_Height;
		glPushMatrix();
			glTranslatef(0.0f, 0.0f, -1.0f);
			glBegin(GL_QUADS);
				glColor4f(Red, Green, Blue, 1.0f);
				glVertex3f((float) Pos_X, (float) (g_window->init.height - (Height + Pos_Y)), 1.0f);
				glVertex3f((float) Pos_X + Width, (float) (g_window->init.height - (Height + Pos_Y)), 1.0f);
				glVertex3f((float) (Pos_X + Width), (float) (g_window->init.height - Pos_Y), 1.0f);
				glVertex3f((float) Pos_X, (float) (g_window->init.height - Pos_Y), 1.0f);
			glEnd();
		glPopMatrix();
	}
}

// ------------------------------------------------------
// Name: Create_Instrument()
// Desc: Create a new empty instrument
void Create_Instrument(void) {
	LPINSTRUMENT New_Instrument;

	if(Instruments.Get_Number_Of_Entries() == 0xffff) {
		Set_Error_Message(Err_Max_Instruments);
		return;
	}

	New_Instrument = (LPINSTRUMENT) malloc(sizeof(INSTRUMENT));
	New_Instrument->Datas = new CList;
	New_Instrument->FileName = NULL;
	Instruments.Add_Entry((long) New_Instrument);

	// Make it the current instrument
	Current_Instrument = New_Instrument;
	Current_Instr_N = Instruments.Get_Number_Of_Entries() - 1;
	Display_Total_Nbr_Instruments();
	sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);

	// Reset position
	Pos_Instrument_Dat = 0;
	Pos_Instrument_Scroll = 0;
	Pos_In_Instrument = 0;
	Pos_Caret_X = 0;
	Bring_Caret();
}

// ------------------------------------------------------
// Name: Create_WaveForm()
// Desc: Create a new empty waveform
void Create_WaveForm(void) {
	LPINSTRUMENT_DAT New_Instrument_Dat;

	if(Current_Instrument) {
		New_Instrument_Dat = (LPINSTRUMENT_DAT) malloc(sizeof(INSTRUMENT_DAT));
		memset(New_Instrument_Dat, 0, sizeof(INSTRUMENT_DAT));
		New_Instrument_Dat->Operator = INS_OP_ADD;
		New_Instrument_Dat->Waveform = INS_WF_SIN;
		Current_Instrument->Datas->Add_Entry((long) New_Instrument_Dat);
		if(Edit_Mode != Edit_Instrument) {
			Caret_Y = 4;
		}
		Edit_Mode = Edit_Instrument;

	} else {
		Set_Error_Message(Err_No_Instrument);
		return;
	}
}

// ------------------------------------------------------
// Name: Free_Instruments()
// Desc: Remove all instruments
void Free_Instruments(void) {
	while(Instruments.Get_Number_Of_Entries()) {
		Delete_Instrument(0);
	}
}

// ------------------------------------------------------
// Name: Delete_Instrument()
// Desc: Remove an instrument
void Delete_Instrument(int Instrument_Number) {
	LPINSTRUMENT Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Instrument_Number);
	if(Instrument->FileName) free(Instrument->FileName);
	Free_List(Instrument->Datas);
	Instruments.Delete_Entry_By_Ordinal(Instrument_Number, true);
}

// ------------------------------------------------------
// Name: Bring_Caret()
// Desc: Force the caret to be displayed
void Bring_Caret(void) {
	Caret_Flash = TRUE;
	Caret_Time = 0.0f;
}

// ------------------------------------------------------
// Name: Remove_Caret()
// Desc: Force the caret to be hidden
void Remove_Caret(void) {
	Caret_Flash = FALSE;
	Caret_Time = 0.1f;
}

// ------------------------------------------------------
// Name: Print_Hex1()
// Desc: Store a hexadecimal number with 1 digit
void Print_Hex1(char *Dest_Text, int Number) {
	Dest_Text[0] = Tab_Hex[(Number & 0xf)];
}

// ------------------------------------------------------
// Name: Print_Hex2()
// Desc: Store a hexadecimal number with 2 digits
void Print_Hex2(char *Dest_Text, int Number) {
	Dest_Text[0] = Tab_Hex[(Number >> 4) & 0xf];
	Dest_Text[1] = Tab_Hex[(Number & 0xf)];
}

// ------------------------------------------------------
// Name: Print_Hex3()
// Desc: Store a hexadecimal number with 3 digits
void Print_Hex3(char *Dest_Text, int Number) {
	Dest_Text[0] = Tab_Hex[(Number >> 8) & 0xf];
	Dest_Text[1] = Tab_Hex[(Number >> 4) & 0xf];
	Dest_Text[2] = Tab_Hex[(Number & 0xf)];
}

// ------------------------------------------------------
// Name: Print_Hex4()
// Desc: Store a hexadecimal number with 4 digits
void Print_Hex4(char *Dest_Text, int Number) {
	Dest_Text[0] = Tab_Hex[(Number >> 12) & 0xf];
	Dest_Text[1] = Tab_Hex[(Number >> 8) & 0xf];
	Dest_Text[2] = Tab_Hex[(Number >> 4) & 0xf];
	Dest_Text[3] = Tab_Hex[(Number & 0xf)];
}

// ------------------------------------------------------
// Name: Get_Hex1()
// Desc: Retrieve a hexadecimal number with 1 digit
void Get_Hex1(BYTE *Number, int Position) {
	*Number = Keys_Hex[(Position * 2) + 1];
}

// ------------------------------------------------------
// Name: Get_Hex2()
// Desc: Retrieve a hexadecimal number with 2 digits
void Get_Hex2(BYTE *Number, int Position) {
	*Number = (*Number << 4) & 0xff;
	*Number |= Keys_Hex[(Position * 2) + 1];
}

// ------------------------------------------------------
// Name: Get_Hex3()
// Desc: Retrieve a hexadecimal number with 3 digits
void Get_Hex3(WORD *Number, int Position) {
	*Number = (*Number << 4) & 0xfff;
	*Number |= Keys_Hex[(Position * 2) + 1];
}

// ------------------------------------------------------
// Name: Get_Hex4()
// Desc: Retrieve a hexadecimal number with 4 digits
void Get_Hex4(WORD *Number, int Position) {
	*Number = (*Number << 4) & 0xffff;
	*Number |= Keys_Hex[(Position * 2) + 1];
}

// ------------------------------------------------------
// Name: Get_Hex4_Split()
// Desc: Retrieve a hexadecimal number with 4 digits splitted on 2 bytes
void Get_Hex4_Split(BYTE *Hi_Byte, BYTE *Lo_Byte, int Position) {
	int Number = *Hi_Byte << 8;
	Number |= *Lo_Byte;
	Number = (Number << 4) & 0xffff;
	Number |= Keys_Hex[(Position * 2) + 1];
	*Lo_Byte = (BYTE) (Number & 0xff);
	*Hi_Byte = (BYTE) ((Number & 0xff00) >> 8);
}

// ------------------------------------------------------
// Name: Get_Hex6()
// Desc: Retrieve a hexadecimal number with 6 digits
void Get_Hex6(DWORD *Number, int Position) {
	*Number = (*Number << 4) & 0xffffff;
	*Number |= Keys_Hex[(Position * 2) + 1];
}

// ------------------------------------------------------
// Name: Set_Error_Message()
// Desc: Write an error message for a couple of seconds
void Set_Error_Message(char *Message) {
	Status_Message = Message;
	Temp_Error = 3.8f;
	Was_Error = TRUE;
	return;
}

// ------------------------------------------------------
// Name: Set_Ok_Message()
// Desc: Write an message for a succeding command for a couple of seconds
void Set_Ok_Message(char *Message) {
	Status_Message = Message;
	Temp_Error = 3.8f;
	Was_Error = FALSE;
	return;
}

// ------------------------------------------------------
// Name: Load_Instrument_Cmd()
// Desc: Load an instrument
void Load_Instrument_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Load_Instrument, 0, 0, &ThreadId);
}

DWORD WINAPI Load_Instrument(LPVOID lpParameter) {
	char *File_To_Open;
	HANDLE Instrument_File;
	DWORD Instrument_ID;
	DWORD ReadBytes;

	BYTE Operator;
	BYTE Waveform;
	WORD PhaseShift;
	BYTE Attack_Vol;
	WORD Attack;
	BYTE Decay_Vol;
	WORD Decay;
	BYTE Sustain_Vol;
	WORD Sustain;
	BYTE Release_Vol;
	WORD Release;
	int Nbr_Read_Line;
	LPINSTRUMENT_DAT Current_Instrument_Dats;

	File_To_Open = Choose_Open_File(g_window->hWnd, "TRSI Sound Monitor Instrument files (*.TSI)|*.TSI", "");
	if(File_To_Open) {
		Loading = TRUE;
		Instrument_File = Open_File(File_To_Open);
		if(Instrument_File != INVALID_HANDLE_VALUE) {
			Instrument_ID = Read_DWORD(Instrument_File, &ReadBytes);
			if(ReadBytes == 0) {
				Close_File(Instrument_File);
				Set_Error_Message(Err_Load);
				In_Requester = FALSE;
				Loading = FALSE;
				Kill_Thread();
				return(TRUE);
			}
			if(Instrument_ID != 0x01495354) {
				Close_File(Instrument_File);
				Set_Error_Message(Err_Format);
				In_Requester = FALSE;
				Loading = FALSE;
				Kill_Thread();
				return(TRUE);
			}

			// Check if there's at least one line in the file
			Nbr_Read_Line = 0;
			Operator = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Waveform = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			PhaseShift = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Attack_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Attack = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Decay_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Decay = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Sustain_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Sustain = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Release_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Release = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			if(!Nbr_Read_Line) {
				Close_File(Instrument_File);
				Set_Error_Message(Err_Format);
				In_Requester = FALSE;
				Kill_Thread();
				return(TRUE);
			}
			Create_Instrument();
			Create_WaveForm();

			// Store first data line

			for(;;) {
				Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(Current_Instrument->Datas->Get_Number_Of_Entries() - 1);
				Current_Instrument_Dats->Operator = Operator;
				Current_Instrument_Dats->Waveform = Waveform; 
				Current_Instrument_Dats->PhaseShift = PhaseShift;
				Current_Instrument_Dats->Attack_Vol = Attack_Vol;
				Current_Instrument_Dats->Attack = Attack;
				Current_Instrument_Dats->Decay_Vol = Decay_Vol;
				Current_Instrument_Dats->Decay = Decay;
				Current_Instrument_Dats->Sustain_Vol = Sustain_Vol;
				Current_Instrument_Dats->Sustain = Sustain;
				Current_Instrument_Dats->Release_Vol = Release_Vol;
				Current_Instrument_Dats->Release = Release;
				Calc_Deltas(Current_Instrument_Dats);
				Nbr_Read_Line = 0;
				Operator = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Waveform = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				PhaseShift = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Attack_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Attack = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Decay_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Decay = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Sustain_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Sustain = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Release_Vol = Read_BYTE(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				Release = Read_WORD(Instrument_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
				if(!Nbr_Read_Line) break;
				Create_WaveForm();
			}
			Close_File(Instrument_File);
			Set_Ok_Message(Ok_Load);
			Current_Instrument->FileName = strdup(File_To_Open);
			if(Play_Type == Play_Instrument) Play_Type = No_Play;
		} else {
			Set_Error_Message(Err_Load);
		}
	}
	In_Requester = FALSE;
	Kill_Thread();
	Loading = FALSE;
	return(TRUE);
}

// ------------------------------------------------------
// Name: Save_Instrument_Cmd()
// Desc: Save an instrument
void Save_Instrument_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Save_Instrument, 0, 0, &ThreadId);
}

DWORD WINAPI Save_Instrument(LPVOID lpParameter) {
	char *File_To_Save;
	HANDLE Instrument_File;
	LPINSTRUMENT_DAT Current_Instrument_Dats;
	int i;
	int Line;

	File_To_Save = Choose_Save_File(g_window->hWnd, "TRSI Sound Monitor Instrument files (*.TSI)|*.TSI", "");
	if(File_To_Save) {
		Loading = TRUE;
		Instrument_File = Create_Empty_File(File_To_Save, FALSE);
		if(Instrument_File != INVALID_HANDLE_VALUE) {
			Save_DWORD(Instrument_File, 0x01495354);
			for(i = 0; i < Current_Instrument->Datas->Get_Number_Of_Entries(); i++) {
				Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(i);
				Line = Current_Instrument_Dats->Operator + Current_Instrument_Dats->Waveform + Current_Instrument_Dats->PhaseShift +
						Current_Instrument_Dats->Attack_Vol + Current_Instrument_Dats->Attack + 
						Current_Instrument_Dats->Decay_Vol + Current_Instrument_Dats->Decay + 
						Current_Instrument_Dats->Sustain_Vol + Current_Instrument_Dats->Sustain + 
						Current_Instrument_Dats->Release_Vol + Current_Instrument_Dats->Release;
				if(Line) {
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Operator);
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Waveform);
					Save_WORD(Instrument_File, Current_Instrument_Dats->PhaseShift);
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Attack_Vol);
					Save_WORD(Instrument_File, Current_Instrument_Dats->Attack);
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Decay_Vol);
					Save_WORD(Instrument_File, Current_Instrument_Dats->Decay);
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Sustain_Vol);
					Save_WORD(Instrument_File, Current_Instrument_Dats->Sustain);
					Save_BYTE(Instrument_File, Current_Instrument_Dats->Release_Vol);
					Save_WORD(Instrument_File, Current_Instrument_Dats->Release);
				}
			}
			Close_File(Instrument_File);
			Set_Ok_Message(Ok_Save);
			Current_Instrument->FileName = strdup(File_To_Save);
		} else {
			Set_Error_Message(Err_Save);
		}
	}
	In_Requester = FALSE;
	Loading = FALSE;
	Kill_Thread();
	return(TRUE);
}

// ------------------------------------------------------
// Name: Choose_Open_File()
// Desc: Display a file selector for file loading
char *Choose_Open_File(HWND hWnd, char *OFilters, char *InitDir) {
    int i = 0;

	memset(&MyOpenFName, 0, sizeof(MyOpenFName));
    MyOpenFName.lStructSize = sizeof(MyOpenFName);
    MyOpenFName.hwndOwner = hWnd;
    MyOpenFName.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_LONGNAMES;
    MyOpenFName.lpstrDefExt = "";
    MyOpenFName.lpstrInitialDir = InitDir;
    MyOpenFName.lpstrFile = String_Load;
	MyOpenFName.lpstrFile[0] = 0;
	MyOpenFName.nMaxFile = 255;
	int LenOpenFile = strlen(OFilters);
    for(i = 1; i <= LenOpenFile; i++) {
		if(OFilters[i - 1] == '|') OFilters[i - 1] = 0;
    }
    MyOpenFName.lpstrFilter = OFilters;
    MyOpenFName.nFilterIndex = 1;
    MyOpenFName.lpstrTitle = "Select a file to open";
    MyOpenFName.hInstance = GetModuleHandle(NULL);
    if(GetOpenFileName(&MyOpenFName) != 0) {
		SetForegroundWindow(hWnd);
		return(MyOpenFName.lpstrFile);
    }
	SetForegroundWindow(hWnd);
	return(NULL);
}

// ------------------------------------------------------
// Name: Choose_Save_File()
// Desc: Display a file selector for file saving
char *Choose_Save_File(HWND hWnd, char *OFilters, char *InitDir) {
    int i = 0;

	memset(&MySaveFName, 0, sizeof(MySaveFName));
    MySaveFName.lStructSize = sizeof(MySaveFName);
    MySaveFName.hwndOwner = hWnd;
    MySaveFName.Flags = OFN_EXPLORER | OFN_HIDEREADONLY | OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_LONGNAMES | OFN_OVERWRITEPROMPT;
    MySaveFName.lpstrDefExt = "";
    MySaveFName.lpstrInitialDir = InitDir;
    MySaveFName.lpstrFile = String_Save;
	MySaveFName.lpstrFile[0] = 0;
	MySaveFName.nMaxFile = 255;
	int LenOpenFile = strlen(OFilters);
    for(i = 1; i <= LenOpenFile; i++) {
		if(OFilters[i - 1] == '|') OFilters[i - 1] = 0;
    }
    MySaveFName.lpstrFilter = OFilters;
    MySaveFName.nFilterIndex = 1;
    MySaveFName.lpstrTitle = "Select a file to save";
    MySaveFName.hInstance = GetModuleHandle(NULL);
    if(GetSaveFileName(&MySaveFName) != 0) {
		SetForegroundWindow(hWnd);
        return(MySaveFName.lpstrFile);
    }
	SetForegroundWindow(hWnd);
	return(NULL);
}

// ------------------------------------------------------
// Name: Create_Empty_File()
// Desc: Create a new empty file
HANDLE Create_Empty_File(char *FileName, long Security) {
    HANDLE ReturnValue = 0;
    SECURITY_ATTRIBUTES SecAt;

	memset(&SecAt, 0, sizeof(SecAt));
    DeleteFile(FileName);
    if(Security) {
        SecAt.nLength = sizeof(SecAt);
        SecAt.lpSecurityDescriptor = 0;
        SecAt.bInheritHandle = 1;
        ReturnValue = CreateFile(FileName, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, &SecAt, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    } else {
        ReturnValue = CreateFile(FileName, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
    }
    return(ReturnValue);
}

// ------------------------------------------------------
// Name: Close_File()
// Desc: Close an opened file
long Close_File(HANDLE hFile) {
    long ReturnValue = 0;

    if(hFile != 0) ReturnValue = CloseHandle(hFile);
    return(ReturnValue);
}

// ------------------------------------------------------
// Name: Save_BYTE()
// Desc: Save a byte into a file
int Save_BYTE(HANDLE FileHandle, BYTE Value) {
	DWORD Written;
	
	WriteFile(FileHandle, &Value, 1, &Written, NULL);
	return(Written);
}

// ------------------------------------------------------
// Name: Save_WORD()
// Desc: Save a word into a file
int Save_WORD(HANDLE FileHandle, WORD Value) {
	DWORD Written;
	
	WriteFile(FileHandle, &Value, 2, &Written, NULL);
	return(Written);
}

// ------------------------------------------------------
// Name: Save_DWORD()
// Desc: Save a dword into a file
int Save_DWORD(HANDLE FileHandle, DWORD Value) {
	DWORD Written;
	
	WriteFile(FileHandle, &Value, 4, &Written, NULL);
	return(Written);
}

// ------------------------------------------------------
// Name: Save_MEM()
// Desc: Save a memory block into a file
int Save_MEM(HANDLE FileHandle, BYTE *Memory, int Size) {
	DWORD Written;
	
	if(Size) WriteFile(FileHandle, &Memory, Size, &Written, NULL);
	return(Written);
}


// ------------------------------------------------------
// Name: Open_File()
// Desc: Open a file for reading
HANDLE Open_File(char *FileName) {
    return(CreateFile(FileName, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0));
}

// ------------------------------------------------------
// Name: Read_DWORD()
// Desc: Read a dword from a file
DWORD Read_DWORD(HANDLE FileHandle, LPDWORD ReadBytes) {
	DWORD Value;

	ReadFile(FileHandle, &Value, 4, ReadBytes, NULL);
	return(Value);
}

// ------------------------------------------------------
// Name: Read_WORD()
// Desc: Read a word from a file
WORD Read_WORD(HANDLE FileHandle, LPDWORD ReadBytes) {
	WORD Value;

	ReadFile(FileHandle, &Value, 2, ReadBytes, NULL);
	return(Value);
}

// ------------------------------------------------------
// Name: Read_BYTE()
// Desc: Read a byte from a file
BYTE Read_BYTE(HANDLE FileHandle, LPDWORD ReadBytes) {
	BYTE Value;

	ReadFile(FileHandle, &Value, 1, ReadBytes, NULL);
	return(Value);
}

// ------------------------------------------------------
// Name: Confine_Instrument_Caret()
// Desc: Ensure that the caret is visible in the instruments block
void Confine_Instrument_Caret(void) {
	if(Pos_Instrument_Dat > (Current_Instrument->Datas->Get_Number_Of_Entries() - 1)) {
		Pos_Instrument_Dat = 0;
		Pos_In_Instrument = 0;
		Pos_Instrument_Scroll = 0;
	}
}

// ------------------------------------------------------
// Name: Display_Total_Nbr_Instruments()
// Desc: Display the current number of instruments
void Display_Total_Nbr_Instruments(void) {
	sprintf(Total_Instr_Nbr, "%04X", Instruments.Get_Number_Of_Entries());
}

// ------------------------------------------------------
// Name: Display_Total_Nbr_Positions()
// Desc: Display the current number of positions
void Display_Total_Nbr_Positions(void) {
	sprintf(Total_Song_Nbr, "%04X", Positions[0]->Get_Number_Of_Entries());
}

// ------------------------------------------------------
// Name: Display_Tempo()
// Desc: Display the selected tempo
void __stdcall Display_Tempo(int Tempo_Display) {
	sprintf(Current_Tempo, "%04X", Tempo_Display);
}

// ------------------------------------------------------
// Name: Display_Fx_Tempo()
// Desc: Display the selected tempo
void __stdcall Display_Fx_Tempo(int Tempo_Display) {
	sprintf(Current_Fx_Tempo, "%04X", Tempo_Display);
}

// ------------------------------------------------------
// Name: Set_Note()
// Desc: Write a note/octave in a string
void Set_Note(char *Note_String, int Note_Dat) {
	// Note
	if(Note_Dat) {
		Note_String[0] = szNotesDieses[(((Note_Dat - 1) % 12) * 2) + 2];
		Note_String[1] = szNotesDieses[(((Note_Dat - 1) % 12) * 2) + 2 + 1];
		// Octave
		Note_String[2] = ((Note_Dat - 1) / 12) + 0x30;
	} else {
		Note_String[0] = '-';
		Note_String[1] = '-';
		Note_String[2] = '-';
	}
}

// ------------------------------------------------------
// Name: Create_Sequence()
// Desc: Create a new empty sequence
void Create_Sequence(void) {
	LPSEQUENCE_DAT New_Sequence;

	New_Sequence = (LPSEQUENCE_DAT) malloc(sizeof(SEQUENCE_DAT));
	memset(New_Sequence, 0, sizeof(SEQUENCE_DAT));
	Sequences.Add_Entry((long) New_Sequence);
	Dummy_Sequence_Dats.Seq_Cur_Sequence = New_Sequence;
	if(Edit_Mode != Edit_Sequence) Caret_Y = 4;
	Edit_Mode = Edit_Sequence;
	Current_Seq_N = Sequences.Get_Number_Of_Entries() - 1;
	Display_Total_Nbr_Sequences();
	sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
}

// ------------------------------------------------------
// Name: Free_Sequences()
// Desc: Remove all sequences
void Free_Sequences(void) {

	while(Sequences.Get_Number_Of_Entries()) {
		Delete_Sequence(0);
	}
}

// ------------------------------------------------------
// Name: Delete_Sequence()
// Desc: Remove an instrument
void Delete_Sequence(int Sequence_Number) {
	Sequences.Delete_Entry_By_Ordinal(Sequence_Number, true);
}

// ------------------------------------------------------
// Name: Get_Latest_Sequence()
// Desc: Retrieve the latest created sequence
LPSEQUENCE_DAT Get_Latest_Sequence(void) {
	return((LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Sequences.Get_Number_Of_Entries() - 1));
}

// ------------------------------------------------------
// Name: Display_Total_Nbr_Sequences()
// Desc: Display the current number of sequences
void Display_Total_Nbr_Sequences(void) {
	sprintf(Total_Seq_Nbr, "%04X", Sequences.Get_Number_Of_Entries());
}

// ------------------------------------------------------
// Name: Calc_Deltas()
// Desc: Calc and store the volumes deltas
void Calc_Deltas(LPINSTRUMENT_DAT Instrument_Dats) {
	// Attack always begin at 0 so attack's delta = absolute value
	Instrument_Dats->Attack_Vol_Delta = Instrument_Dats->Attack_Vol;
	Instrument_Dats->Decay_Vol_Delta = (Instrument_Dats->Decay_Vol - Instrument_Dats->Attack_Vol);
	Instrument_Dats->Sustain_Vol_Delta = (Instrument_Dats->Sustain_Vol - Instrument_Dats->Decay_Vol);
	Instrument_Dats->Release_Vol_Delta = (Instrument_Dats->Release_Vol - Instrument_Dats->Sustain_Vol);
}

// ------------------------------------------------------
// Name: Display_Oscillators()
// Desc: Display two oscillators according to the audio datas
void Display_Oscillators(void) {
	int k = 0;
	int i;
	WORD OsciValue;
	WORD Old_OsciValue = 0;

	// Display left oscilloscope
	WORD *Aud_Dats = Spectrum_Buffer;
	for(i = 0; i < 152; i++) {
		OsciValue = *(Aud_Dats + (k * 4));
		OsciValue -= 32768;
		OsciValue >>= 9;
		if(OsciValue > 106) OsciValue = 106;
		if(OsciValue < 20) OsciValue = 20;
		Draw_Spectrum_Bar(481 + i, OsciValue, Old_OsciValue);
		Old_OsciValue = OsciValue;
		k += 2;
	}

	// Display right oscilloscope
	Old_OsciValue = 0;
	Aud_Dats = Spectrum_Buffer + 1;
	k = 0;
	for(i = 0; i < 152; i++) {
		OsciValue = *(Aud_Dats + (k * 4));
		OsciValue -= 32768;
		OsciValue >>= 9;
		if(OsciValue > 106) OsciValue = 106;
		if(OsciValue < 20) OsciValue = 20;
		Draw_Spectrum_Bar(635 + i, OsciValue, Old_OsciValue);
		Old_OsciValue = OsciValue;
		k += 2;
	}
}

// ------------------------------------------------------
// Name: Create_Position()
// Desc: Create a new empty position
void Create_Position(int Insert_Point) {
	LPSONG_DAT New_Position1;
	LPSONG_DAT New_Position2;
	LPSONG_DAT New_Position3;
	LPSONG_DAT New_Position4;
	LPSONG_DAT New_Position5;
	LPSONG_DAT New_Position6;
	LPSONG_DAT New_Position7;
	LPSONG_DAT New_Position8;
	CList_Entry *Entry;

	if(Positions[0]->Get_Number_Of_Entries() == 0xffff) {
		Set_Error_Message(Err_Max_Positions);
		return;
	}

	New_Position1 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position2 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position3 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position4 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position5 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position6 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position7 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	New_Position8 = (LPSONG_DAT) malloc(sizeof(SONG_DAT));
	memset(New_Position1, 0, sizeof(SONG_DAT));
	memset(New_Position2, 0, sizeof(SONG_DAT));
	memset(New_Position3, 0, sizeof(SONG_DAT));
	memset(New_Position4, 0, sizeof(SONG_DAT));
	memset(New_Position5, 0, sizeof(SONG_DAT));
	memset(New_Position6, 0, sizeof(SONG_DAT));
	memset(New_Position7, 0, sizeof(SONG_DAT));
	memset(New_Position8, 0, sizeof(SONG_DAT));
	if(Insert_Point == -1) {
		Positions[0]->Add_Entry((long) New_Position1);
		Positions[1]->Add_Entry((long) New_Position2);
		Positions[2]->Add_Entry((long) New_Position3);
		Positions[3]->Add_Entry((long) New_Position4);
		Positions[4]->Add_Entry((long) New_Position5);
		Positions[5]->Add_Entry((long) New_Position6);
		Positions[6]->Add_Entry((long) New_Position7);
		Positions[7]->Add_Entry((long) New_Position8);
	} else {
		Entry = Positions[0]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[0]->Insert_Entry_Before(Entry, (long) New_Position1);
		Entry = Positions[1]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[1]->Insert_Entry_Before(Entry, (long) New_Position2);
		Entry = Positions[2]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[2]->Insert_Entry_Before(Entry, (long) New_Position3);
		Entry = Positions[3]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[3]->Insert_Entry_Before(Entry, (long) New_Position4);
		Entry = Positions[4]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[4]->Insert_Entry_Before(Entry, (long) New_Position5);
		Entry = Positions[5]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[5]->Insert_Entry_Before(Entry, (long) New_Position6);
		Entry = Positions[6]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[6]->Insert_Entry_Before(Entry, (long) New_Position7);
		Entry = Positions[7]->Get_Entry_By_Ordinal(Pos_Song_Dat);
		Positions[7]->Insert_Entry_Before(Entry, (long) New_Position8);
	}
	
	// Reset position
	if(Edit_Mode != Edit_Song) {
		Pos_Song_Dat = 0;
		Pos_Song_Scroll = 0;
		Pos_In_Song = 0;
		Pos_Caret_X = 0;
		Caret_Y = 24;
	}
	Edit_Mode = Edit_Song;
	Bring_Caret();
}

// ------------------------------------------------------
// Name: Free_Positions()
// Desc: Remove all positions
void Free_Positions(void) {
	while(Positions[0]->Get_Number_Of_Entries()) {
		Delete_Position(0);
	}
}

// ------------------------------------------------------
// Name: Delete_Position()
// Desc: Delete a song position
void Delete_Position(int Position_Nbr) {
	Positions[0]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[1]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[2]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[3]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[4]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[5]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[6]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Positions[7]->Delete_Entry_By_Ordinal(Position_Nbr, true);
	Confine_Song_Caret();
	if(Positions[0]->Get_Number_Of_Entries() == 0) {
		g_keys[VK_TAB] = TRUE;
	}
}

// ------------------------------------------------------
// Name: Confine_Song_Caret()
// Desc: Ensure that the caret is visible in the song block
void Confine_Song_Caret(void) {
	if(Pos_Song_Dat > (Positions[0]->Get_Number_Of_Entries() - 1)) {
		Pos_Song_Dat = 0;
		Pos_In_Song = 0;
		Pos_Song_Scroll = 0;
	}
}

// ------------------------------------------------------
// Name: Display_Octave()
// Desc: Display the currently selected base octave
void Display_Octave(void) {
	sprintf(Current_Octave, "%01X", Base_Octave);
}

// ------------------------------------------------------
// Name: Save_Module_Cmd()
// Desc: Save a song
void Save_Module_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Save_Module, 0, 0, &ThreadId);
}

DWORD WINAPI Save_Module(LPVOID lpParameter) {
	char *File_To_Save;
	HANDLE Module_File;
	LPINSTRUMENT Instrument;
	LPINSTRUMENT_DAT InstrumentDat;
	LPSEQUENCE_DAT Sequence;
	LPSONG_DAT Song_Dat;
	int i;
	int j;
	int Nbr_Instruments;
	int Instruments_Size;
	int Sequences_Size;
	int Positions_Size;

	File_To_Save = Choose_Save_File(g_window->hWnd, "TRSI Sound Monitor Module files (*.TSM)|*.TSM", "");
	if(File_To_Save) {
		Loading = TRUE;
		Module_File = Create_Empty_File(File_To_Save, FALSE);
		if(Module_File != INVALID_HANDLE_VALUE) {
			// Write header
			Save_DWORD(Module_File, 0x024D5354);
			// Write default tempo
			Save_WORD(Module_File, Tempo);
			// Write default fx-tempo
			Save_WORD(Module_File, Fx_Tempo);
			// Write restart position
			Save_WORD(Module_File, Song_Restart);
			
			// Get the size of the instruments
			Nbr_Instruments = Instruments.Get_Number_Of_Entries();
			Instruments_Size = 0;
			for(i = 0; i < Nbr_Instruments; i++) {
				Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(i);
				// (-4 to remove the 4 deltas)
				// (and +1 to add the byte for the number of combinators / instruments)
				Instruments_Size += ((Instrument->Datas->Get_Number_Of_Entries() * ((sizeof(INSTRUMENT_DAT) - 4))) + 1);
			}
			// Offset to sequences
			Save_DWORD(Module_File, Instruments_Size + 22);
			Sequences_Size = Sequences.Get_Number_Of_Entries() * sizeof(SEQUENCE_DAT);
			// Offset to positions
			Save_DWORD(Module_File, Instruments_Size + 22 + Sequences_Size + 4);
			Positions_Size = (Positions[0]->Get_Number_Of_Entries() * sizeof(SONG_DAT) * 8);

			// Number of instruments
			Save_DWORD(Module_File, Nbr_Instruments);
			for(i = 0; i < Instruments.Get_Number_Of_Entries(); i++) {
				Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(i);
				// Save the number of combinators
				Save_BYTE(Module_File, (BYTE) Instrument->Datas->Get_Number_Of_Entries());
				for(j = 0; j < Instrument->Datas->Get_Number_Of_Entries(); j++) {
					InstrumentDat = (LPINSTRUMENT_DAT) Instrument->Datas->Get_Entry_By_Ordinal_Long(j);
					Save_BYTE(Module_File, InstrumentDat->Operator);
					Save_BYTE(Module_File, InstrumentDat->Waveform);
					Save_WORD(Module_File, InstrumentDat->PhaseShift);
					Save_BYTE(Module_File, InstrumentDat->Attack_Vol);
					Save_WORD(Module_File, InstrumentDat->Attack);
					Save_BYTE(Module_File, InstrumentDat->Decay_Vol);
					Save_WORD(Module_File, InstrumentDat->Decay);
					Save_BYTE(Module_File, InstrumentDat->Sustain_Vol);
					Save_WORD(Module_File, InstrumentDat->Sustain);
					Save_BYTE(Module_File, InstrumentDat->Release_Vol);
					Save_WORD(Module_File, InstrumentDat->Release);
				}
			}

			// Number of sequences
			Save_DWORD(Module_File, Sequences.Get_Number_Of_Entries());
			for(i = 0; i < Sequences.Get_Number_Of_Entries(); i++) {
				Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(i);
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->Note[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_WORD(Module_File, Sequence->Instrument[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->Volume[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->Panning[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->DspMask[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->Dsp[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->DspDatas1[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->DspDatas2[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->DspDatas3[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->Fx[j]);
				}
				for(j = 0; j < 16; j++) {
					Save_BYTE(Module_File, Sequence->FxDatas[j]);
				}
			}

			// Number of positions
			Save_DWORD(Module_File, Positions[0]->Get_Number_Of_Entries());
			for(i = 0; i < 8; i++) {
				for(j = 0; j < Positions[0]->Get_Number_Of_Entries(); j++) {
					Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
					Save_WORD(Module_File, Song_Dat->Seq_Nbr);
				}
				for(j = 0; j < Positions[0]->Get_Number_Of_Entries(); j++) {
					Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
					Save_BYTE(Module_File, Song_Dat->Transpose);
				}
				for(j = 0; j < Positions[0]->Get_Number_Of_Entries(); j++) {
					Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
					Save_BYTE(Module_File, Song_Dat->Volume);
				}
			}
			Close_File(Module_File);
			Set_Ok_Message(Ok_Save);
		} else {
			Set_Error_Message(Err_Save);
		}
	}
	In_Requester = FALSE;
	Loading = FALSE;
	Kill_Thread();
	return(TRUE);
}

// ------------------------------------------------------
// Name: Load_Module_Cmd()
// Desc: Load a module
void Load_Module_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Load_Module, 0, 0, &ThreadId);
}

DWORD WINAPI Load_Module(LPVOID lpParameter) {
	char *File_To_Open;
	HANDLE Module_File;
	DWORD Module_ID = 0;
	DWORD ReadBytes;

	BYTE Operator;
	BYTE Waveform;
	WORD PhaseShift;
	BYTE Attack_Vol;
	WORD Attack;
	BYTE Decay_Vol;
	WORD Decay;
	BYTE Sustain_Vol;
	WORD Sustain;
	BYTE Release_Vol;
	WORD Release;
	int Nbr_Read_Line;
	LPINSTRUMENT_DAT Current_Instrument_Dats;
	LPSEQUENCE_DAT New_Sequence;
	LPSONG_DAT New_Song_Dat;

	int Sequences_Offset;
	int Positions_Offset;
	int Nbr_Instrs;
	int Nbr_Combinators;
	int Nbr_Sequences;
	int Nbr_Positions;
	int i;
	int j;
	int Module_Version;

	File_To_Open = Choose_Open_File(g_window->hWnd, "TRSI Sound Monitor Module files (*.TSM)|*.TSM", "");
	if(File_To_Open) {
		Loading = TRUE;
		Module_File = Open_File(File_To_Open);
		if(Module_File != INVALID_HANDLE_VALUE) {
			Module_ID = Read_DWORD(Module_File, &ReadBytes);
			if(ReadBytes == 0) {
				Close_File(Module_File);
				Set_Error_Message(Err_Load);
				In_Requester = FALSE;
				Loading = FALSE;
				Kill_Thread();
				return(TRUE);
			}
			Module_Version = Module_ID >> 24;
			Module_ID &= 0xffffff;

			// Version 1 or 2
			if(Module_ID != 0x004D5354) {
				Close_File(Module_File);
				Set_Error_Message(Err_Format);
				In_Requester = FALSE;
				Loading = FALSE;
				Kill_Thread();
				return(TRUE);
			}

			Erase_All();

			// Read the default tempi
			Tempo = Read_WORD(Module_File, &ReadBytes);
			Fx_Tempo = Read_WORD(Module_File, &ReadBytes);

			Song_Restart = 1;				// Was always 1 in older versions
			if(Module_Version == 2) {
				Song_Restart = Read_WORD(Module_File, &ReadBytes);
			}
			sprintf(strSong_Restart, " %04X ", Song_Restart);

			// Will only be used in replay routine
			Sequences_Offset = Read_DWORD(Module_File, &ReadBytes);
			Positions_Offset = Read_DWORD(Module_File, &ReadBytes);

			Nbr_Instrs = Read_DWORD(Module_File, &ReadBytes);
			Nbr_Combinators = Read_BYTE(Module_File, &ReadBytes) - 1;

			// Check if there's at least one line in the file
			Nbr_Read_Line = 0;
			Operator = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Waveform = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			PhaseShift = Read_WORD(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Attack_Vol = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Attack = Read_WORD(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Decay_Vol = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Decay = Read_WORD(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Sustain_Vol = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Sustain = Read_WORD(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Release_Vol = Read_BYTE(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			Release = Read_WORD(Module_File, &ReadBytes); Nbr_Read_Line += ReadBytes;
			if(!Nbr_Read_Line) {
				Close_File(Module_File);
				Set_Error_Message(Err_Format);
				In_Requester = FALSE;
				Kill_Thread();
				return(TRUE);
			}
			Create_Instrument();
			Create_WaveForm();
			Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(Current_Instrument->Datas->Get_Number_Of_Entries() - 1);
			Current_Instrument_Dats->Operator = Operator;
			Current_Instrument_Dats->Waveform = Waveform;
			Current_Instrument_Dats->PhaseShift = PhaseShift;
			Current_Instrument_Dats->Attack_Vol = Attack_Vol;
			Current_Instrument_Dats->Attack = Attack;
			Current_Instrument_Dats->Decay_Vol = Decay_Vol;
			Current_Instrument_Dats->Decay = Decay;
			Current_Instrument_Dats->Sustain_Vol = Sustain_Vol;
			Current_Instrument_Dats->Sustain = Sustain;
			Current_Instrument_Dats->Release_Vol = Release_Vol;
			Current_Instrument_Dats->Release = Release;
			Calc_Deltas(Current_Instrument_Dats);
			
			// Store first data line
			for(i = 0; i < Nbr_Instrs; i++) {
				for(j = 0; j < Nbr_Combinators; j++) {
					Operator = Read_BYTE(Module_File, &ReadBytes);
					Waveform = Read_BYTE(Module_File, &ReadBytes);
					PhaseShift = Read_WORD(Module_File, &ReadBytes);
					Attack_Vol = Read_BYTE(Module_File, &ReadBytes);
					Attack = Read_WORD(Module_File, &ReadBytes);
					Decay_Vol = Read_BYTE(Module_File, &ReadBytes);
					Decay = Read_WORD(Module_File, &ReadBytes);
					Sustain_Vol = Read_BYTE(Module_File, &ReadBytes);
					Sustain = Read_WORD(Module_File, &ReadBytes);
					Release_Vol = Read_BYTE(Module_File, &ReadBytes);
					Release = Read_WORD(Module_File, &ReadBytes);
					Create_WaveForm();
					Current_Instrument_Dats = (LPINSTRUMENT_DAT) Current_Instrument->Datas->Get_Entry_By_Ordinal_Long(Current_Instrument->Datas->Get_Number_Of_Entries() - 1);
					Current_Instrument_Dats->Operator = Operator;
					Current_Instrument_Dats->Waveform = Waveform;
					Current_Instrument_Dats->PhaseShift = PhaseShift;
					Current_Instrument_Dats->Attack_Vol = Attack_Vol;
					Current_Instrument_Dats->Attack = Attack;
					Current_Instrument_Dats->Decay_Vol = Decay_Vol;
					Current_Instrument_Dats->Decay = Decay;
					Current_Instrument_Dats->Sustain_Vol = Sustain_Vol;
					Current_Instrument_Dats->Sustain = Sustain;
					Current_Instrument_Dats->Release_Vol = Release_Vol;
					Current_Instrument_Dats->Release = Release;
					Calc_Deltas(Current_Instrument_Dats);
				}
				if(i < (Nbr_Instrs - 1)) {
					Create_Instrument();
					Nbr_Combinators = Read_BYTE(Module_File, &ReadBytes);
				}
			}

			Nbr_Sequences = Read_DWORD(Module_File, &ReadBytes);
			// (A sequence have already been created in Erase_All()
			New_Sequence = Get_Latest_Sequence();
			for(j = 0; j < 16; j++) New_Sequence->Note[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->Instrument[j] = Read_WORD(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->Volume[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->Panning[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->DspMask[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->Dsp[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->DspDatas1[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->DspDatas2[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->DspDatas3[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->Fx[j] = Read_BYTE(Module_File, &ReadBytes);
			for(j = 0; j < 16; j++) New_Sequence->FxDatas[j] = Read_BYTE(Module_File, &ReadBytes);
			for(i = 0; i < (Nbr_Sequences - 1); i++) {
				Create_Sequence();
				New_Sequence = Get_Latest_Sequence();
				for(j = 0; j < 16; j++) New_Sequence->Note[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->Instrument[j] = Read_WORD(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->Volume[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->Panning[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->DspMask[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->Dsp[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->DspDatas1[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->DspDatas2[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->DspDatas3[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->Fx[j] = Read_BYTE(Module_File, &ReadBytes);
				for(j = 0; j < 16; j++) New_Sequence->FxDatas[j] = Read_BYTE(Module_File, &ReadBytes);
			}

			Nbr_Positions = Read_DWORD(Module_File, &ReadBytes);
			if(Nbr_Positions) {
				for(i = 0; i < Nbr_Positions; i++) {
					Create_Position(-1);
				}
				for(i = 0; i < 8; i++) {
					for(j = 0; j < Positions[i]->Get_Number_Of_Entries(); j++) {
						New_Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
						New_Song_Dat->Seq_Nbr = Read_WORD(Module_File, &ReadBytes);
						Positions[i]->Set_Entry_By_Ordinal(j, (long) New_Song_Dat);
					}
					for(j = 0; j < Positions[i]->Get_Number_Of_Entries(); j++) {
						New_Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
						New_Song_Dat->Transpose = Read_BYTE(Module_File, &ReadBytes);
						Positions[i]->Set_Entry_By_Ordinal(j, (long) New_Song_Dat);
					}
					for(j = 0; j < Positions[i]->Get_Number_Of_Entries(); j++) {
						New_Song_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
						New_Song_Dat->Volume = Read_BYTE(Module_File, &ReadBytes);
						Positions[i]->Set_Entry_By_Ordinal(j, (long) New_Song_Dat);
					}
				}
			}
			Close_File(Module_File);
			Set_Ok_Message(Ok_Load);
			Play_Type = No_Play;
		} else {
			Set_Error_Message(Err_Load);
		}
		Display_Tempo(Tempo);
		Display_Fx_Tempo(Fx_Tempo);
		Tempo_Ticks = Get_Mix_Buffer_Len(Tempo);
		Fx_Tempo_Ticks = Get_Mix_Buffer_Len(Fx_Tempo);
		
		Current_Seq_N = 0;
		Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
		sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);

		Current_Instr_N = 0;
		Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
		sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);

		Display_Total_Nbr_Positions();
	}
	
	Loading = FALSE;
	In_Requester = FALSE;
	Kill_Thread();
	return(TRUE);
}

// ------------------------------------------------------
// Name: Erase_All_Cmd()
// Desc: Erase all song datas
void Erase_All_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Erase_All_Thread, 0, 0, &ThreadId);
}

DWORD WINAPI Erase_All_Thread(LPVOID lpParameter) {
	switch(MessageBox(g_window->hWnd, "Do you really want to erase all datas ?", "TRSI Sound Monitor", MB_YESNO | MB_ICONQUESTION)) {
		case IDYES:
			Erase_All();
	}
	In_Requester = FALSE;
	Kill_Thread();
	return(FALSE);
}

void Erase_All(void) {
	Loading = TRUE;

	Play_Type = No_Play;
	Free_Positions();
	Free_Sequences();
	Free_Instruments();
	Create_Sequence();
	Current_Instrument = NULL;
	Pos_Song_Dat = 0;
	Pos_Song_Scroll = 0;
	Pos_In_Song = 0;
	Pos_Caret_X = 0;
	Edit_Mode = Edit_Sequence;
	Caret_Y = 4;
	Old_Pos_In_Sequence = 0;
	Pos_In_Sequence = 0;
	Tempo = 21;
	Fx_Tempo = 125;
	Display_Tempo(Tempo);
	Display_Fx_Tempo(Fx_Tempo);
	Song_Restart = 1;
	sprintf(strSong_Restart, " %04X ", Song_Restart);
	OnOff_Status[0] = TRUE;
	OnOff_Status[1] = TRUE;
	OnOff_Status[2] = TRUE;
	OnOff_Status[3] = TRUE;
	OnOff_Status[4] = TRUE;
	OnOff_Status[5] = TRUE;
	OnOff_Status[6] = TRUE;
	OnOff_Status[7] = TRUE;

	Get_Gadget_From_ID(ID_SONG_VOICE1)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE2)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE3)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE4)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE5)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE6)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE7)->Text = Voice_On;
	Get_Gadget_From_ID(ID_SONG_VOICE8)->Text = Voice_On;

	Loading = FALSE;
}

// ------------------------------------------------------
// Name: Replace_Sequences()
// Desc: Modify the sequences so that all referenced instruments with a number
//       greater than the first argument will be decreased by one and all reference
//		 to the given number will be zeroed.
void Replace_Sequences(int Instr_Nbr, int Instr_Nbr_Replace) {
	LPSEQUENCE_DAT Seq;
	int Mark_Changed = FALSE;

	for(int i = 0; i < Sequences.Get_Number_Of_Entries(); i++) {
		Seq = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(i);
		for(int j = 0; j < 16; j++) {
			if(Seq->Instrument[j] > Instr_Nbr) {
				if(Seq->Instrument[j]) {
					Seq->Instrument[j]--;
					Mark_Changed = TRUE;
				}
			} else {
				if(Seq->Instrument[j] == Instr_Nbr) {
					Seq->Instrument[j] = Instr_Nbr_Replace;
					Mark_Changed = TRUE;
				}
			}
		}
	}
	if(Mark_Changed) Set_Ok_Message(Ok_Seq_Changed);
}

// ------------------------------------------------------
// Name: Replace_Positions()
// Desc: Modify the positions so that all referenced sequences with a number
//       greater than the first argument will be decreased by one and all reference
//		 to the given number will be replaced by the second argument.
void Replace_Positions(int Seq_Nbr, int Seq_Nbr_Replace) {
	LPSONG_DAT S_Dat;
	int Mark_Changed = FALSE;

	for(int i = 0; i < 8; i++) {
		for(int j = 0; j < Positions[i]->Get_Number_Of_Entries(); j++) {
			S_Dat = (LPSONG_DAT) Positions[i]->Get_Entry_By_Ordinal_Long(j);
			if(S_Dat->Seq_Nbr > Seq_Nbr) {
				if(S_Dat->Seq_Nbr) {
					S_Dat->Seq_Nbr--;
					Mark_Changed = TRUE;
				}
			} else {
				if(S_Dat->Seq_Nbr == Seq_Nbr) {
					S_Dat->Seq_Nbr = Seq_Nbr_Replace;
					Mark_Changed = TRUE;
				}
			}
		}
	}
	if(Mark_Changed) Set_Ok_Message(Ok_Pos_Changed);
}

// ------------------------------------------------------
// Name: Goto_Prev_Seq()
// Desc: Jump to the previous sequence
void Goto_Prev_Seq(void) {		
	if(Sequences.Get_Number_Of_Entries()) {
		if(Current_Seq_N) {
			Current_Seq_N--;
			Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
			sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
		}
	}
}

// ------------------------------------------------------
// Name: Goto_Next_Seq()
// Desc: Jump to the next sequence
void Goto_Next_Seq(void) {
	if(Current_Seq_N < (Sequences.Get_Number_Of_Entries() - 1)) {
		Current_Seq_N++;
		Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
		sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
	}
}

// ------------------------------------------------------
// Name: Goto_Prev_Instr()
// Desc: Jump to the previous instrument
void Goto_Prev_Instr(void) {
	if(Instruments.Get_Number_Of_Entries()) {
		if(Current_Instr_N) {
			Current_Instr_N--;
			Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
			sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
			Confine_Instrument_Caret();
		}
	}
}

// ------------------------------------------------------
// Name: Goto_Next_Instr()
// Desc: Jump to the next instrument
void Goto_Next_Instr(void) {
	if(Current_Instr_N < (Instruments.Get_Number_Of_Entries() - 1)) {
		Current_Instr_N++;
		Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
		sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
		Confine_Instrument_Caret();
	}
}

// ------------------------------------------------------
// Name: Play_Current_Instrument()
// Desc: Play the current instrument
void Play_Current_Instrument(void) {
	if(Current_Instrument) {
		Clear_Buffers();
		Instr_Datas_Copied = 0;
		Play_Type = Play_Instrument;
	}
}

// ------------------------------------------------------
// Name: Play_Current_Sequence()
// Desc: Play the current sequence
void Play_Current_Sequence(void) {
	// Don't play the sequence if there's no instrument
	if(Instruments.Get_Number_Of_Entries()) {
		Clear_Buffers();
		Instr_Datas_Copied = 0;
		Play_Type = Play_Sequence;
	}
}

// ------------------------------------------------------
// Name: Play_Current_Song
// Desc: Play the current song
void Play_Current_Song(int Position) {
	if(Positions[0]->Get_Number_Of_Entries() > 0) {
		Clear_Buffers();
		Instr_Datas_Copied = 0;
		Song_Position = Position - 1;
		Play_Type = Play_Song;
	}
}

// ------------------------------------------------------
// Name: Clean_Song_Cmd()
// Desc: Remove all unused intruments/sequences
void Clean_Song_Cmd(void) {
	In_Requester = TRUE;
	hThread = CreateThread(NULL, 0, &Clean_Song_Thread, 0, 0, &ThreadId);
}

DWORD WINAPI Clean_Song_Thread(LPVOID lpParameter) {
	switch(MessageBox(g_window->hWnd, "This will remove all unused/identical instruments and sequences.", "TRSI Sound Monitor", MB_YESNO | MB_ICONQUESTION)) {
		case IDYES:
			CleanUp_Song();
	}
	In_Requester = FALSE;
	Kill_Thread();
	Loading = FALSE;
	return(FALSE);
}

void CleanUp_Song(void) {
	LPSEQUENCE_DAT Seq;
	LPSEQUENCE_DAT Seq_Search;
	LPSONG_DAT S_Dat;
	LPINSTRUMENT_DAT Instr_Dat;
	LPINSTRUMENT Instru;
	LPINSTRUMENT_DAT Instr_Dat_Search;
	LPINSTRUMENT Instr_Search;
	int Mark_Changed = FALSE;
	int i = 0;
	int j;
	int k;
	int l;
	int Nbr_Found;
	int Instr_Modified = 0;
	int Seq_Modified = 0;
	int Any_Modified = FALSE;

	Loading = TRUE;

	Play_Type = No_Play;

Start_Again:
	// Search for identical sequencesinstruments
	i = 0;
	while(i < Instruments.Get_Number_Of_Entries()) {
		Nbr_Found = 0;
		Instru = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(i);
		for(j = 0; j < Instru->Datas->Get_Number_Of_Entries(); j++) {
			Instr_Dat = (LPINSTRUMENT_DAT) Instru->Datas->Get_Entry_By_Ordinal_Long(j);
			for(k = 0; k < Instruments.Get_Number_Of_Entries(); k++) {
				if(k != i) {
					Nbr_Found = 0;
					Instr_Search = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(k);
					if(Instr_Search->Datas->Get_Number_Of_Entries() == Instru->Datas->Get_Number_Of_Entries()) {
						for(l = 0; l < Instr_Search->Datas->Get_Number_Of_Entries(); l++) {
							Instr_Dat_Search = (LPINSTRUMENT_DAT) Instr_Search->Datas->Get_Entry_By_Ordinal_Long(l);
							if(Instr_Dat_Search->Operator != Instr_Dat->Operator ||
								Instr_Dat_Search->Waveform != Instr_Dat->Waveform ||
								Instr_Dat_Search->PhaseShift != Instr_Dat->PhaseShift ||
								Instr_Dat_Search->Attack != Instr_Dat->Attack ||
								Instr_Dat_Search->Attack_Vol != Instr_Dat->Attack_Vol ||
								Instr_Dat_Search->Decay != Instr_Dat->Decay ||
								Instr_Dat_Search->Decay_Vol != Instr_Dat->Decay_Vol ||
								Instr_Dat_Search->Sustain != Instr_Dat->Sustain ||
								Instr_Dat_Search->Sustain_Vol != Instr_Dat->Sustain_Vol ||
								Instr_Dat_Search->Release != Instr_Dat->Release ||
								Instr_Dat_Search->Release_Vol != Instr_Dat->Release_Vol) {
								Nbr_Found = 1;
								break;
							}
						}
						if(!Nbr_Found) {
							// Was identical
							Nbr_Found = 2;
							break;
						}
					}
				}
			}
			if(Nbr_Found == 2) {
				Nbr_Found = 3;
				break;
			}
		}
		if(Nbr_Found == 3) {
			Delete_Instrument(k);
			Replace_Sequences(k + 1, i + 1);
			Instr_Modified++;
			// Restart
			goto Start_Again;
		}
		i++;
	}

	// Search for all instruments in all sequences
	i = 0;
	while(i < Instruments.Get_Number_Of_Entries()) {
		Nbr_Found = 0;
		for(j = 0; j < Sequences.Get_Number_Of_Entries(); j++) {
			Seq = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(j);
			for(k = 0; k < 16; k++) {
				if(Seq->Instrument[k] == (i + 1)) Nbr_Found++;
			}
		}
		if(!Nbr_Found) {
			Delete_Instrument(i);
			Replace_Sequences(i + 1, 0);
			Instr_Modified++;
			// Restart
			goto Start_Again;
		}
		i++;
	}
	if(Instr_Modified) {
		Any_Modified = TRUE;
		Display_Total_Nbr_Instruments();
		if(Instruments.Get_Number_Of_Entries() == 0) {
			Current_Instr_N = 0;
			sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N);
			Current_Instrument = NULL;
			if(Edit_Mode == Edit_Instrument) {
				g_keys[VK_TAB] = TRUE;
			}
		} else {
			Current_Instr_N = 0;
			Current_Instrument = (LPINSTRUMENT) Instruments.Get_Entry_By_Ordinal_Long(Current_Instr_N);
			sprintf(Current_Instr_Nbr, "%04X", Current_Instr_N + 1);
			Confine_Instrument_Caret();
		}
	}

	// Search for identical sequences
	i = 0;
	while(i < Sequences.Get_Number_Of_Entries()) {
		Nbr_Found = 0;
		Seq = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(i);
		for(j = 0; j < Sequences.Get_Number_Of_Entries(); j++) {
			if(i != j) {
				Nbr_Found = 0;
				Seq_Search = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(j);
				for(k = 0; k < 16; k++) {
					if(Seq->Note[k] != Seq_Search->Note[k] || Seq->Instrument[k] != Seq_Search->Instrument[k] ||
						Seq->Volume[k] != Seq_Search->Volume[k] || Seq->Panning[k] != Seq_Search->Panning[k] ||
						Seq->DspMask[k] != Seq_Search->DspMask[k] || Seq->Dsp[k] != Seq_Search->Dsp[k] ||
						Seq->DspDatas1[k] != Seq_Search->DspDatas1[k] || Seq->DspDatas2[k] != Seq_Search->DspDatas2[k] ||
						Seq->DspDatas3[k] != Seq_Search->DspDatas3[k] || Seq->Fx[k] != Seq_Search->Fx[k] ||
						Seq->FxDatas[k] != Seq_Search->FxDatas[k]) {
						Nbr_Found = 1;
						break;
					}
				}
				if(!Nbr_Found) {
					// Was identical
					Nbr_Found = 2;
					break;
				}
			}
		}
		if(Nbr_Found == 2) {
			Delete_Sequence(j);
			Replace_Positions(j + 1, i + 1);
			Seq_Modified++;
			// Restart
			goto Start_Again;
		}
		i++;
	}

	// Search for all sequences in all positions
	i = 0;
	while(i < Sequences.Get_Number_Of_Entries()) {
		Nbr_Found = 0;
		for(j = 0; j < 8; j++) {
			for(k = 0; k < Positions[j]->Get_Number_Of_Entries(); k++) {
				S_Dat = (LPSONG_DAT) Positions[j]->Get_Entry_By_Ordinal_Long(k);
				if(S_Dat->Seq_Nbr == (i + 1)) {
					Nbr_Found++;
				}
			}
		}
		if(!Nbr_Found) {
			Delete_Sequence(i);
			Replace_Positions(i + 1, 0);
			Seq_Modified++;
			// Restart
			goto Start_Again;
		}
		i++;
	}
	if(Seq_Modified) {
		Any_Modified = TRUE;
		Display_Total_Nbr_Sequences();
		if(Sequences.Get_Number_Of_Entries() == 0) {
			Create_Sequence();
		} else {
			Current_Seq_N = 0;
			Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
			sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
		}
	}
	if(Any_Modified) {
		sprintf(Ok_Song_Changed, "%04X instrument(s)/%04X sequence(s) removed.", Instr_Modified, Seq_Modified);
		Set_Ok_Message(Ok_Song_Changed);
	} else {
		Set_Error_Message(Err_Song_Changed);
	}
}

// ------------------------------------------------------
// Name: Delete_Current_Sequence()
// Desc: Delete the currently viewed sequence
void Delete_Current_Sequence(void) {
	if(Sequences.Get_Number_Of_Entries()) {
		Delete_Sequence(Current_Seq_N);
		Display_Total_Nbr_Sequences();
		Replace_Positions(Current_Seq_N + 1, 0);
	}
	if(Sequences.Get_Number_Of_Entries() == 0) {
		Create_Sequence();
	} else {
		if(Current_Seq_N > (Sequences.Get_Number_Of_Entries() - 1)) Current_Seq_N--;
		Dummy_Sequence_Dats.Seq_Cur_Sequence = (LPSEQUENCE_DAT) Sequences.Get_Entry_By_Ordinal_Long(Current_Seq_N);
		sprintf(Current_Seq_Nbr, "%04X", Current_Seq_N + 1);
	}
}

// ------------------------------------------------------
// Name: Delete_Current_WaveForm()
// Desc: Delete the currently selected waveform
void Delete_Current_WaveForm(void) {
	if(Current_Instrument) {
		if(Current_Instrument->Datas->Get_Number_Of_Entries() == 1) {
			// Delete the complete instrument
			Set_Error_Message(Err_Del_Instrument);
			return;
		}
		if(Pos_Instrument_Dat < (Current_Instrument->Datas->Get_Number_Of_Entries())) {
			Current_Instrument->Datas->Delete_Entry_By_Ordinal(Pos_Instrument_Dat, true);
			Confine_Instrument_Caret();
		}
	}
}

// ------------------------------------------------------
// Name: Next_Waveform()
// Desc: Go to next waveform entry
void Next_Waveform(void) {
	if(Pos_Instrument_Dat < (Current_Instrument->Datas->Get_Number_Of_Entries() - 1)) {
		Pos_Instrument_Dat++;
		if(Pos_In_Instrument < 15) Pos_In_Instrument++;
		else Pos_Instrument_Scroll++;
	}
}

// ------------------------------------------------------
// Name: Prev_Waveform()
// Desc: Go to previous waveform entry
void Prev_Waveform(void) {
	if(Pos_Instrument_Dat) {
		Pos_Instrument_Dat--;
		if(Pos_In_Instrument) Pos_In_Instrument--;
		else Pos_Instrument_Scroll--;
	}
}

// ------------------------------------------------------
// Name: Next_Position()
// Desc: Go to next position in song
void Next_Position(void) {
	if(Pos_Song_Dat < (Positions[0]->Get_Number_Of_Entries() - 1)) {
		Pos_Song_Dat++;
		if(Pos_In_Song < 22) Pos_In_Song++;
		else Pos_Song_Scroll++;
	}
}

// ------------------------------------------------------
// Name: Prev_Position()
// Desc: Go to previous position in song
void Prev_Position(void) {
	if(Pos_Song_Dat) {
		Pos_Song_Dat--;
		if(Pos_In_Song) Pos_In_Song--;
		else Pos_Song_Scroll--;
	}
}

// ------------------------------------------------------
// Name: Switch_Track()
// Desc: Turn a track on/off
void Switch_Track(int Id) {
	LPGADGET Track_Gadget = Get_Gadget_From_ID(Id);
	OnOff_Status[Id - ID_SONG_VOICE1] ^= TRUE;
	if(OnOff_Status[Id - ID_SONG_VOICE1]) Track_Gadget->Text = Voice_On;
	else Track_Gadget->Text = Voice_Off;
}

// ------------------------------------------------------
// Name: Kill_Thread()
// Desc: Remove a requester thread
void Kill_Thread(void) {
	if(hThread) {
		TerminateThread(hThread, 0);
		CloseHandle(hThread);
	}
}

// ------------------------------------------------------
// Name: Set_Caret_Y()
// Desc: Remove a requester thread
void Set_Caret_Y(void) {
	switch(Edit_Mode) {
		case Edit_Instrument:
			Caret_Y = 4;
			break;
		case Edit_Sequence:
			Caret_Y = 4;
			break;
		case Edit_Song:
			Caret_Y = 24;
			break;
	}
}

// ------------------------------------------------------
// Name: Point_Mouse_Sequences()
// Desc: Set the caret position in the sequences editor according to the mouse
void Point_Mouse_Sequences(LPGADGET Gadget) {
	int Selection_X;
	int Selection_Y;

	Edit_Mode = Edit_Sequence;
	Selection_X = ((Mouse_Coords.x - Gadget->Screen_Coords.left - (Font_Width / 2)) / Font_Width) - 3;
	Selection_Y = ((Mouse_Coords.y - Gadget->Screen_Coords.top - Mouse_Gap) / Font_Height) - 1;
	if(Selection_X < 0) Selection_X = 0;
	if(Selection_Y < 0) Selection_Y = 0;
	if(Selection_X > 23) Selection_X = 23;
	if(Selection_Y > 15) Selection_Y = 15;
	Pos_In_Sequence = Selection_Y;
	if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
		Pos_Caret_X = Mouse_Pos_Caret_Seq[Selection_X];
	} else {
		Pos_Caret_X = Mouse_Pos_Caret_Seq_Delay[Selection_X];
	}
	Set_Caret_Y();
	Bring_Caret();
}

// ------------------------------------------------------
// Name: Point_Mouse_Positions()
// Desc: Set the caret position in the positions editor according to the mouse
void Point_Mouse_Positions(LPGADGET Gadget) {
	int Selection_X;
	int Selection_Y;
	int Max_Display_Positions;

	if(Positions[0]->Get_Number_Of_Entries()) {
		Edit_Mode = Edit_Song;
		Selection_X = ((Mouse_Coords.x - Gadget->Screen_Coords.left) / Font_Width) - 6;
		Selection_Y = ((Mouse_Coords.y - Gadget->Screen_Coords.top - Mouse_Gap) / Font_Height);
		if(Selection_X < 0) Selection_X = 0;
		if(Selection_Y < 0) Selection_Y = 0;
		if(Selection_X > 93) Selection_X = 93;
		Max_Display_Positions = Positions[0]->Get_Number_Of_Entries();
		if(Max_Display_Positions > 23) Max_Display_Positions = 23;
		if(Max_Display_Positions > (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll)) {
			// Don't display "unecessary datas"
			Max_Display_Positions = (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll);
		}
		if(Selection_Y == 0) {
			Prev_Position();
			Selection_Y++;
		}
		if(Selection_Y > 23) Next_Position();
		Selection_Y--;
		if(Selection_Y > (Max_Display_Positions - 1)) Selection_Y = Max_Display_Positions - 1;
		Pos_In_Song = Selection_Y;
		Pos_Song_Dat = Selection_Y + Pos_Song_Scroll;
		Pos_Caret_X = Mouse_Pos_Caret_Song[Selection_X];
		Set_Caret_Y();
		Bring_Caret();
	}
}

// ------------------------------------------------------
// Name: Point_Mouse_Instruments()
// Desc: Set the caret position in the instruments editor according to the mouse
void Point_Mouse_Instruments(LPGADGET Gadget) {
	int Selection_X;
	int Selection_Y;
	int Max_Instr_Entries_Display;

	if(Current_Instrument) {
		Edit_Mode = Edit_Instrument;
		Selection_X = ((Mouse_Coords.x - (Gadget->Screen_Coords.left - (Font_Width / 2))) / Font_Width) - 1;
		Selection_Y = ((Mouse_Coords.y - Gadget->Screen_Coords.top - Mouse_Gap) / Font_Height);
		if(Selection_X < 0) Selection_X = 0;
		if(Selection_Y < 0) Selection_Y = 0;
		if(Selection_X > 36) Selection_X = 36;
		Max_Instr_Entries_Display = Current_Instrument->Datas->Get_Number_Of_Entries();
		if(Max_Instr_Entries_Display > 16) Max_Instr_Entries_Display = 16;
		if(Max_Instr_Entries_Display > (Current_Instrument->Datas->Get_Number_Of_Entries() - Pos_Instrument_Scroll)) {
			Max_Instr_Entries_Display = (Current_Instrument->Datas->Get_Number_Of_Entries() - Pos_Instrument_Scroll);
		}
		if(Selection_Y == 0) {
			Prev_Waveform();
			Selection_Y++;
		}
		if(Selection_Y > 16) Next_Waveform();
		Selection_Y--;
		if(Selection_Y > (Max_Instr_Entries_Display - 1)) Selection_Y = Max_Instr_Entries_Display - 1;
		Pos_In_Instrument = Selection_Y;
		Pos_Instrument_Dat = Selection_Y + Pos_Instrument_Scroll;
		Pos_Caret_X = Mouse_Pos_Caret_Instr[Selection_X];
		Set_Caret_Y();
		Bring_Caret();
	}
}

// ------------------------------------------------------
// Name: Synchro()
// Desc: Synth callback
void __stdcall Synchro(int Datas) {
	Flash_Logo = TRUE;
	Flash_Color = 1.0f;
}

// ------------------------------------------------------
// Name: Get_Sequence_From_DblClick()
// Desc: Return the number of the double clicked sequence number in positions editor or 0
int Get_Sequence_From_DblClick(LPGADGET Gadget) {
	int Selection_X;
	int Selection_Y;
	int Max_Display_Positions;
	LPSONG_DAT Song_Dat;

	if(Positions[0]->Get_Number_Of_Entries()) {
		Edit_Mode = Edit_Song;
		Selection_X = ((Mouse_Coords.x - Gadget->Screen_Coords.left) / Font_Width) - 6;
		Selection_Y = ((Mouse_Coords.y - Gadget->Screen_Coords.top - Mouse_Gap) / Font_Height);
		if(Selection_X < 0) Selection_X = 0;
		if(Selection_Y < 0) Selection_Y = 0;
		if(Selection_X > 93) Selection_X = 93;
		Max_Display_Positions = Positions[0]->Get_Number_Of_Entries();
		if(Max_Display_Positions > 23) Max_Display_Positions = 23;
		if(Max_Display_Positions > (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll)) {
			// Don't display "unecessary datas"
			Max_Display_Positions = (Positions[0]->Get_Number_Of_Entries() - Pos_Song_Scroll);
		}
		if(Selection_Y == 0) {
			Prev_Position();
			Selection_Y++;
		}
		if(Selection_Y > 23) Next_Position();
		Selection_Y--;
		if(Selection_Y > (Max_Display_Positions - 1)) Selection_Y = Max_Display_Positions - 1;
		Pos_In_Song = Selection_Y;
		Pos_Song_Dat = Selection_Y + Pos_Song_Scroll;
		Pos_Caret_X = Mouse_Pos_Caret_Song[Selection_X];
		Set_Caret_Y();
		Bring_Caret();
		if((Pos_Caret_X % 3) != 0) return(0);
		Song_Dat = (LPSONG_DAT) Positions[(Pos_Caret_X / 3)]->Get_Entry_By_Ordinal_Long(Pos_Song_Dat);
		return(Song_Dat->Seq_Nbr);
	}
	return(0);
}

// ------------------------------------------------------
// Name: Get_Instrument_From_DblClick()
// Desc: Return the number of the double clicked instrument number in sequences editor or 0
int Get_Instrument_From_DblClick(LPGADGET Gadget) {
	int Selection_X;
	int Selection_Y;

	Edit_Mode = Edit_Sequence;
	Selection_X = ((Mouse_Coords.x - Gadget->Screen_Coords.left - (Font_Width / 2)) / Font_Width) - 3;
	Selection_Y = ((Mouse_Coords.y - Gadget->Screen_Coords.top - Mouse_Gap) / Font_Height) - 1;
	if(Selection_X < 0) Selection_X = 0;
	if(Selection_Y < 0) Selection_Y = 0;
	if(Selection_X > 23) Selection_X = 23;
	if(Selection_Y > 15) Selection_Y = 15;
	Pos_In_Sequence = Selection_Y;
	if(Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_DELAY && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_REVERB && Dummy_Sequence_Dats.Seq_Cur_Sequence->Dsp[Pos_In_Sequence] != SEQ_DSP_FORMANT) {
		Pos_Caret_X = Mouse_Pos_Caret_Seq[Selection_X];
	} else {
		Pos_Caret_X = Mouse_Pos_Caret_Seq_Delay[Selection_X];
	}
	Set_Caret_Y();
	Bring_Caret();
	if(Pos_Caret_X != 1) return(-1);
	return(Dummy_Sequence_Dats.Seq_Cur_Sequence->Instrument[Pos_In_Sequence]);
}

// ------------------------------------------------------
// Name: Create_NV_Texture()
// Desc: Create a non-rectangular texture
GLuint Create_NV_Texture(int Width, int Height, BYTE *Dest) {
	GLuint tx_Id;
	
	glGenTextures(1, &tx_Id);
	if(tx_Id) {
		glBindTexture(GL_TEXTURE_RECTANGLE_NV, tx_Id);
		glEnable(GL_TEXTURE_RECTANGLE_NV);
		glTexParameteri(GL_TEXTURE_RECTANGLE_NV, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_RECTANGLE_NV, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexImage2D(GL_TEXTURE_RECTANGLE_NV, 0, GL_RGBA, Width, Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, Dest);
	}
	return(tx_Id);
}

// ------------------------------------------------------
// Name: Draw_Pixels()
// Desc: Replacement function for glDrawPixels
//       (only work in ortho mode)
void Draw_Pixels(float X, float Y, float Width, float Height, GLuint TexID, BYTE *TexDatas) {
	glPushMatrix();
		glTranslatef(X, Y, 0.0f);
		glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
		glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		glBindTexture(GL_TEXTURE_RECTANGLE_NV, TexID);
		glTexSubImage2D(GL_TEXTURE_RECTANGLE_NV, 0, 0, 0, (int) Width, (int) Height, GL_RGBA, GL_UNSIGNED_BYTE, TexDatas);
		glEnable(GL_TEXTURE_RECTANGLE_NV);
		glBegin(GL_QUADS);
			glNormal3f(0.0f, 0.0f, 1.0f);
			glTexCoord2f(0.0f, Height); glVertex3f(0.0f, 0.0f, 0.0f);
			glTexCoord2f(Width, Height); glVertex3f(Width, 0.0f, 0.0f);
			glTexCoord2f(Width, 0.0f); glVertex3f(Width , Height, 0.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(0.0f, Height, 0.0f);
 		glEnd();
		glDisable(GL_TEXTURE_RECTANGLE_NV);
	glPopMatrix();
}
