; ------------------------------------------------------
; TSM v0.12 Replay routine
; Written by Franck 'hitchhikr' Charlet/TRSI
; ------------------------------------------------------

; --------------- Constants
TSM_INS_WF_CUST			equ	5
TSM_DSP_DELAY			equ	4

TSM_MAX_NOTES			equ	120	

; --------------- Structures

TSM_INSTRUMENT_DAT_SIZE		equ	20
STRUC TSM_INSTRUMENT_DAT
.Operator			RESB	1
.Waveform			RESB	1
.PhaseShift			RESW	1
.Attack_Volume			RESB	1
.Attack				RESW	1
.Decay_Volume			RESB	1
.Decay				RESW	1
.Sustain_Volume			RESB	1
.Sustain			RESW	1
.Release_Volume			RESB	1
.Release			RESW	1
.Attack_Volume_Delta		RESB	1
.Decay_Volume_Delta		RESB	1
.Sustain_Volume_Delta		RESB	1
.Release_Volume_Delta		RESB	1
ENDSTRUC

TSM_SEQUENCE_DAT_SIZE		equ	192
STRUC TSM_SEQUENCE_DAT
.Note				RESB 	16
.Instrument			RESW	16
.Volume				RESB	16
.Panning			RESB	16
.DspMask			RESB	16
.Dsp				RESB	16
.DspDatas1			RESB	16
.DspDatas2			RESB	16
.DspDatas3			RESB	16
.Fx				RESB	16
.FxDatas			RESB	16
ENDSTRUC

TSM_SONG_DAT_SIZE		equ	4
STRUC TSM_SONG_DAT
.Sequence			RESW	1
.Transpose			RESB	1
.Volume				RESB	1
ENDSTRUC

TSM_INSTRUMENT_VARS_SIZE	equ	8*4
STRUC TSM_INSTRUMENT_VARS
.Volume				RESD	1
.Ticks				RESD	1
.RndVal1			RESD	1
.RndVal2			RESD	1
.wrpos				RESD	1
.FPos				RESD	1
.Frac_Lo_Pos			RESD	1
.Oscillator			RESD	1
ENDSTRUC

TSM_SEQUENCE_SIZE		equ	0x2608
STRUC TSM_SEQUENCE
.Current_Sequence		RESD	1
.Current_Instrument		RESD	1
.Current_Instrument_Dat		RESD	1
.Instrument_NbrComb		RESD	1
.Freq_Lo_Speed			RESD	1
.Freq_Hi_Speed			RESD	1
.Pan				RESD	1
.Volume				RESD	1
.Position_Volume		RESD	1
.Position_Transpose		RESD	1
.Global_Volume			RESD	1
.Formant_Param1			RESD	1
.Formant_Param2			RESD	1
.Formant_Param3			RESD	1
.Disto_Param			RESD	1
.Disto_Abs_Input		RESD	1
.Hi_Pass_Param1			RESD	1
.Hi_Pass_Param2			RESD	1
.Hi_Pass_In1			RESD	1
.Hi_Pass_Out1			RESD	1
.Hi_Pass_In2			RESD	1
.Hi_Pass_Out2			RESD	1
.Lo_Pass_Param1			RESD	1
.Lo_Pass_Param2			RESD	1
.Lo_Pass_In1			RESD	1
.Lo_Pass_Out1			RESD	1
.Lo_Pass_In2			RESD	1
.Lo_Pass_Out2			RESD	1
.VCF_Pass_Param1		RESD	1
.VCF_Pass_Param2		RESD	1
.VCF_Pass_Out1			RESD	1
.VCF_Pass_Out2			RESD	1
.VCF_Pass_Out3			RESD	1
.VCF_Pass_Out4			RESD	1
.VCF_Pass_In1			RESD	1
.VCF_Pass_In2			RESD	1
.VCF_Pass_In3			RESD	1
.VCF_Pass_In4			RESD	1
.Delay_Cursor			RESD	1
.Delay_Value			RESD	1
.Delay_Left_FeedBack_Value	RESD	1
.Delay_Right_FeedBack_Value	RESD	1
.Delay_Left_Buffer		RESD	1
.Delay_Right_Buffer		RESD	1
.Arpeggio			RESD	1
.Vol_Side			RESD	1
.Pitch_Bend_Freq		RESD	1
.Current_Freq			RESD	1
.Pitch_Bend			RESD	1
.Vibrato			RESD	1
.Vibrato_Freq			RESD	1
.Vibrato_Tick			RESD	1
.Tone_Portamento_Speed		RESD	1
.Tone_Portamento_Note		RESD	1
.Sound_Datas			RESD	1
.Old_Vol_Side_Down		RESD	1
.Old_Vol_Side_Up		RESD	1
.Old_Pitch_Bend_Down		RESD	1
.Old_Pitch_Bend_Up		RESD	1
.Old_Vibrato			RESD	1
.Old_Arpeggio			RESD	1
.Old_Tone_Portamento_Speed	RESD	1
.Old_Tone_Portamento_Note	RESD	1
.Cur_Note			RESD	1
.Cur_Freq			RESD	1
.Cur_Instrument_Vars		RESB	TSM_INSTRUMENT_VARS_SIZE * 256
.Formant_Tmp_Mem		RESQ	10
.Source_Formant			RESQ	11
.Dest_Formant			RESQ	11
ENDSTRUC

; --------------- Datas section
TSM_Mixing_Buffer_Stereo:	dd	0
TSM_DSound_Context:		dd	0
TSM_Sound_Buffer_Desc:		times 	DSBUFFERDESC_SIZE db 0
TSM_Sound_Buffer:		dd	0
TSM_Wave_Format:		times 	WAVEFORMATEX_SIZE db 0
TSM_Buffer_Pos:			dd	0
TSM_Old_Buffer_Pos:		dd	0
TSM_Audio_Ptr1:			dd	0
TSM_Audio_Bytes1:		dd	0
TSM_Audio_Ptr2:			dd	0
TSM_Audio_Bytes2:		dd	0
TSM_Song_Position:		dd	0
TSM_Song_Restart:		dd	0
TSM_Cur_Ticks:			dd	0
TSM_Fx_Ticks:			dd	0
TSM_Speed_Tick:			dd	0
TSM_Speed_Counter:		dd	0
TSM_Tempo:			dd	0
TSM_Fx_Tempo:			dd	0
TSM_Tempo_Ticks:		dd	0
TSM_Fx_Tempo_Ticks:		dd	0
TSM_Can_Play:			dd	0
TSM_BufferSize:			dd	0
TSM_Instr_Dat_Number:		dd	0
TSM_Instr_Dat_Vars:		dd	0
TSM_Sequences_Dats:		dd	0
TSM_Cur_Play_Pos:		dd	0
TSM_Final_Signal:		dd	0.0
TSM_Module_Instruments:		dd	0
TSM_Module_Positions:		dd	0
TSM_Module_Sequences:		dd	0
TSM_Nbr_Instruments:		dd	0
TSM_Nbr_Positions:		dd	0
TSM_Length_Track:		dd	0
TSM_Nbr_Sequences:		dd	0
TSM_hWnd:			dd	0
TSM_Max_Buffer:			dd	44100
TSM_Global_Volume:		dd	0.0
TSM_Flt32767:			dd	32767.0
TSM_Flt32768:			dd	32768.0
TSM_Fltm1:			dd	-1.0
TSM_Flt025:			dd	0.25
TSM_Flt05:			dd	0.5
TSM_Fltm05:			dd	-0.5
TSM_Flt005:			dd	0.05
TSM_Flt1:			dd	1.0
TSM_Fltm005:			dd	-0.05
TSM_Flt100:			dd	100.0
TSM_Flt001:			dd	0.01
TSM_Flt00001:			dd	0.0001
TSM_Flt01:			dd	0.1
TSM_FltPI2:			dd	6.2831853071
TSM_FltPI:			dd	3.1415926535
TSM_Flt0000023:			dd	0.000023
TSM_Fltm2:			dd	-2.0
TSM_Flt116:			dd	1.16
TSM_Flt015:			dd	0.15
TSM_Flt035:			dd	0.35
TSM_Flt03:			dd	0.3
TSM_Random_Seed:		dd 	012341234h
TSM_Formant_Coefficients:	dq	3.11044e-06
				dq	8.943665402
				dq	-36.83889529
				dq	92.01697887
				dq	-154.337906
				dq	181.6233289
				dq	-151.8651235
				dq	89.09614114
				dq	-35.10298511
				dq	8.388101016
				dq	-0.923313471
				dq	4.36215e-06
				dq	8.90438318
				dq	-36.55179099
				dq	91.05750846
				dq	-152.422234
				dq	179.1170248
				dq	-149.6496211
				dq	87.78352223
				dq	-34.60687431
				dq	8.282228154
				dq	-0.914150747
				dq	3.33819e-06
				dq	8.893102966
				dq	-36.49532826
				dq	90.96543286
				dq	-152.4545478
				dq	179.4835618
				dq	-150.315433
				dq	88.43409371
				dq	-34.98612086
				dq	8.407803364
				dq	-0.932568035
				dq	1.13572e-06
				dq	8.994734087
				dq	-37.2084849
				dq	93.22900521
				dq	-156.6929844
				dq	184.596544
				dq	-154.3755513
				dq	90.49663749
				dq	-35.58964535
				dq	8.478996281
				dq	-0.929252233
				dq	4.09431e-07
				dq	8.997322763
				dq	-37.20218544
				dq	93.11385476
				dq	-156.2530937
				dq	183.7080141
				dq	-153.2631681
				dq	89.59539726
				dq	-35.12454591
				dq	8.338655623
				dq	-0.910251753
TSM_Freqs_Table:		dd	000000417h,00000455h,000000497h,0000004DDh,000000527h,000000575h,0000005C8h,000000620h,00000067Dh,0000006E0h,000000749h,0000007B8h
				dd	00000082Dh,000008A9h,00000092Dh,0000009B9h,000000A4Dh,000000AEAh,000000B90h,000000C40h,000000CFAh,000000DC0h,000000E91h,000000F6Fh
				dd	00000105Ah,00001153h,00000125Bh,000001372h,00000149Ah,0000015D4h,000001720h,000001880h,0000019F5h,000001B80h,000001D23h,000001EDEh
				dd	0000020B4h,000022A6h,0000024B5h,0000026E4h,000002934h,000002BA7h,000002E40h,000003100h,0000033EAh,000003700h,000003A45h,000003DBCh
				dd	000004168h,0000454Ch,00000496Bh,000004DC8h,000005268h,00000574Fh,000005C80h,000006200h,0000067D3h,000006E00h,00000748Ah,000007B79h
				dd	0000082D0h,00008A97h,0000092D5h,000009B90h,00000A4D0h,00000AE9Dh,00000B8FFh,00000C3FFh,00000CFA7h,00000DC00h,00000E915h,00000F6F1h
				dd	0000105A0h,0001152Fh,0000125AAh,000013721h,0000149A1h,000015D3Ah,0000171FFh,0000187FFh,000019F4Eh,00001B800h,00001D22Ah,00001EDE2h
				dd	000020B40h,00022A5Dh,000024B54h,000026E41h,000029341h,00002BA75h,00002E3FDh,000030FFEh,000033E9Ch,000037000h,00003A454h,00003DBC4h
				dd	000041681h,000454BBh,0000496A9h,00004DC82h,000052683h,0000574EAh,00005C7FAh,000061FFBh,000067D38h,00006E000h,0000748A8h,00007B789h
				dd	000082D01h,0008A976h,000092D52h,00009B904h,0000A4D05h,0000AE9D4h,0000B8FF5h,0000C3FF6h,0000CFA70h,0000DC000h,0000E914Fh,0000F6F11h

; ------------------------------------------------------
; Name: TSM_Init()
; Desc: Init the synthetizer
;       esi = module file
;       eax = hWnd
TSM_Init:			mov	[TSM_hWnd-_IAT+Var_Base],eax
				mov	ebx,esi
				lodsd
				cmp	eax,0024d5354h
				jne	TSM_Err_Init
				xor	eax,eax
				lodsw
				mov	[TSM_Tempo-_IAT+Var_Base],eax
				lodsw
				mov	[TSM_Fx_Tempo-_IAT+Var_Base],eax
				lodsw
				mov	[TSM_Song_Restart-_IAT+Var_Base],eax
				lodsd
				add	eax,ebx
				mov	[TSM_Module_Sequences-_IAT+Var_Base],eax
				lodsd
				add	eax,ebx
				mov	[TSM_Module_Instruments-_IAT+Var_Base],esi
				mov	esi,eax
				lodsd
				mov	[TSM_Nbr_Positions-_IAT+Var_Base],eax
				imul	ebx,eax,TSM_SONG_DAT_SIZE
				mov	[TSM_Length_Track-_IAT+Var_Base],ebx
				imul	eax,TSM_SONG_DAT_SIZE
				shl	eax,3

				push	eax
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]
		
				test	eax,eax
				jz	TSM_Err_Init
				mov	edi,eax
				mov	[TSM_Module_Positions-_IAT+Var_Base],edi
				mov	ebx,8
TSM_Convert_Positions:		push	edi
				push	edi
				mov	ecx,[TSM_Nbr_Positions-_IAT+Var_Base]
				test	ecx,ecx
				jz	TSM_Err_Init
TSM_Copy_Song_Datas_w:		movsw
				add	edi,TSM_SONG_DAT_SIZE - 2
				loop	TSM_Copy_Song_Datas_w
				pop	edi
				add	edi,2
				call	TSM_Copy_Module_Datas
				inc	edi
				call	TSM_Copy_Module_Datas
				pop	edi
				add	edi,[TSM_Length_Track-_IAT+Var_Base]
				dec	ebx
				jnz	TSM_Convert_Positions
				; Allocate room for intruments pointers
				mov	esi,[TSM_Module_Instruments-_IAT+Var_Base]
				lodsd
				mov	[TSM_Nbr_Instruments-_IAT+Var_Base],eax
				push	eax
				shl	eax,3

				push	eax
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				test	eax,eax
				jz	TSM_Err_Init
				mov	[TSM_Module_Instruments-_IAT+Var_Base],eax
				mov	ebx,eax
				pop	ecx
TSM_Create_Intruments:		push	ecx
				; Allocate slots
				movzx	eax,byte [esi]
				imul	eax,TSM_INSTRUMENT_DAT_SIZE

				push	eax
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				mov	edi,eax
				test	eax,eax
				jz	TSM_Err_Init
				movzx	ecx,byte [esi]
				mov	[ebx],eax			; Address
				add	ebx,4
				mov	[ebx],ecx			; Number of combinators
				add	ebx,4
				inc	esi
TSM_Create_Instruments_Datas:	push	ecx
				push	edi
				mov	ecx,16				; Copy datas
				rep	movsb
				pop	edi
				; Calc the deltas
				mov	al,[edi + TSM_INSTRUMENT_DAT.Attack_Volume]
				mov	[edi + TSM_INSTRUMENT_DAT.Attack_Volume_Delta],al
				mov	al,[edi + TSM_INSTRUMENT_DAT.Decay_Volume]
				sub	al,[edi + TSM_INSTRUMENT_DAT.Attack_Volume]
				mov	[edi + TSM_INSTRUMENT_DAT.Decay_Volume_Delta],al
				mov	al,[edi + TSM_INSTRUMENT_DAT.Sustain_Volume]
				sub	al,[edi + TSM_INSTRUMENT_DAT.Decay_Volume]
				mov	[edi + TSM_INSTRUMENT_DAT.Sustain_Volume_Delta],al
				mov	al,[edi + TSM_INSTRUMENT_DAT.Release_Volume]
				sub	al,[edi + TSM_INSTRUMENT_DAT.Sustain_Volume]
				mov	[edi + TSM_INSTRUMENT_DAT.Release_Volume_Delta],al
				add	edi,TSM_INSTRUMENT_DAT_SIZE
				pop	ecx
				loop	TSM_Create_Instruments_Datas
				pop	ecx
				loop	TSM_Create_Intruments
				
				; Set the sequences pointer
				mov	esi,[TSM_Module_Sequences-_IAT+Var_Base]
				lodsd
				mov	[TSM_Nbr_Sequences-_IAT+Var_Base],eax
				mov	[TSM_Module_Sequences-_IAT+Var_Base],esi

				push	0
				lea	eax,[TSM_DSound_Context-_IAT+Var_Base]
				push	eax
				push	0
				call	[(_IAT_DSound-_IAT+Var_Base) + (4*DirectSoundCreate)]

				test	eax,eax
				jnz	TSM_Err_Init

				push	DSSCL_EXCLUSIVE
				push	dword [TSM_hWnd-_IAT+Var_Base]
				mov	eax,[TSM_DSound_Context-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSound8.SetCooperativeLevel]

				test	eax,eax
				jnz	TSM_Err_Init
				mov	dword [TSM_Sound_Buffer_Desc-_IAT+Var_Base + DSBUFFERDESC.dwSize], DSBUFFERDESC_SIZE
				mov	dword [TSM_Sound_Buffer_Desc-_IAT+Var_Base + DSBUFFERDESC.dwFlags], DSBCAPS_STICKYFOCUS
				; 44100 hz
				mov	eax,[TSM_Max_Buffer-_IAT+Var_Base]
				mov	[TSM_Sound_Buffer_Desc-_IAT+Var_Base + DSBUFFERDESC.dwBufferBytes],eax
				mov	word [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.wFormatTag], WAVE_FORMAT_PCM
				; Stereo
				mov	word [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.nChannels], 2
				mov	dword [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.nSamplesPerSec], 44100
				mov	dword [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.nAvgBytesPerSec], (44100 * ((16 * 2) >> 3))
				mov	word [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.nBlockAlign], ((16 * 2) >> 3)
				; 16 bits
				mov	word [TSM_Wave_Format-_IAT+Var_Base + WAVEFORMATEX.wBitsPerSample], 16
				mov	dword [TSM_Sound_Buffer_Desc-_IAT+Var_Base + DSBUFFERDESC.lpwfxFormat], TSM_Wave_Format-_IAT+Var_Base

				push	0
				push	TSM_Sound_Buffer-_IAT+Var_Base
				push	TSM_Sound_Buffer_Desc-_IAT+Var_Base
				mov	eax,[TSM_DSound_Context-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSound8.CreateSoundBuffer]

				push	DSBPLAY_LOOPING
				push	0
				push	0
				mov	eax,[TSM_Sound_Buffer-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSoundBuffer.Play]

				test	eax,eax
				jnz	TSM_Err_Init

				push	((44100 * 2) + 4) * 4
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				test	eax,eax
				jz	TSM_Err_Init
				mov	[TSM_Mixing_Buffer_Stereo-_IAT+Var_Base],eax

				push	TSM_SEQUENCE_SIZE * 8
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				test	eax,eax
				jz	TSM_Err_Init
				mov	[TSM_Sequences_Dats-_IAT+Var_Base],eax
				mov	dword [TSM_Global_Volume-_IAT+Var_Base],03f800000h
				mov	dword [TSM_Speed_Counter-_IAT+Var_Base],3
				mov	dword [TSM_Cur_Play_Pos-_IAT+Var_Base],15
				mov	edi,[TSM_Sequences_Dats-_IAT+Var_Base]
				mov	ebx,8
TSM_Alloc_Delay_Buffers:	
				push	(44100 * 4)
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				test	eax,eax
				jz	TSM_Err_Init
				mov	[edi + TSM_SEQUENCE.Delay_Left_Buffer],eax

				push	(44100 * 4)
				push	GMEM_FIXED | GMEM_ZEROINIT
				call	[(_IAT_Kernel32-_IAT+Var_Base) + (4*GlobalAlloc)]

				test	eax,eax
				jz	TSM_Err_Init
				mov	[edi + TSM_SEQUENCE.Delay_Right_Buffer],eax
				; Set default position volume to 1.0
				mov	dword [edi + TSM_SEQUENCE.Position_Volume],03f800000h
				add	edi,TSM_SEQUENCE_SIZE
				dec	ebx
				jnz	TSM_Alloc_Delay_Buffers
				mov	ecx,[TSM_Tempo-_IAT+Var_Base]
				call	TSM_Get_Mix_Buffer_Len
				mov	[TSM_Tempo_Ticks-_IAT+Var_Base],eax
				mov	ecx,[TSM_Fx_Tempo-_IAT+Var_Base]
				call	TSM_Get_Mix_Buffer_Len
				mov	[TSM_Fx_Tempo_Ticks-_IAT+Var_Base],eax
				inc	dword [TSM_Can_Play-_IAT+Var_Base]
TSM_Err_Init:			mov	eax,[TSM_Can_Play-_IAT+Var_Base]
				ret

TSM_Copy_Module_Datas:		push	edi
				mov	ecx,[TSM_Nbr_Positions-_IAT+Var_Base]
TSM_Copy_Module_Datas_b:	movsb
				add	edi,TSM_SONG_DAT_SIZE - 1
				loop	TSM_Copy_Module_Datas_b
				pop	edi
				ret

; ------------------------------------------------------
; Name: TSM_Stop()
; Desc: Stop the synthetizer
;TSM_Stop			PROC
;				dec	dword [TSM_Can_Play]
;				mov	eax,[TSM_Sound_Buffer]
;				test	eax,eax
;				jz	TSM_Release_SoundBuffer
;				DSBINVOKE Stop,[TSM_Sound_Buffer]
;				DSBINVOKE Release,[TSM_Sound_Buffer]
;TSM_Release_SoundBuffer:	mov	eax,[TSM_DSound_Context]
;				test	eax,eax
;				jz	TSM_Release_DSContext
;				DSINVOKE Release, [TSM_DSound_Context]
;TSM_Release_DSContext:		mov	eax,[TSM_Mixing_Buffer_Stereo]
;				test	eax,eax
;				jz	TSM_Free_Mixing_Buffer_Stereo
;				invoke	GlobalFree,eax
;TSM_Free_Mixing_Buffer_Stereo:	mov	edi,[TSM_Sequences_Dats]
;				test	edi,edi
;				jz	TSM_No_Sequences_Dats
;				mov	ebx,8
;TSM_Free_Delay_Buffers:		mov	eax,[edi + TSM_SEQUENCE.Delay_Left_Buffer]
;				test	eax,eax
;				jz	TSM_Free_Delay_Left_Buffer
;				invoke	GlobalFree,eax
;TSM_Free_Delay_Left_Buffer:	mov	eax,[edi + TSM_SEQUENCE.Delay_Right_Buffer]
;				test	eax,eax
;				jz	TSM_Free_Delay_Right_Buffer
;				invoke	GlobalFree,eax
;TSM_Free_Delay_Right_Buffer:	add	edi,TSM_SEQUENCE_SIZE
;				dec	ebx
;				jnz	TSM_Free_Delay_Buffers
;TSM_No_Sequences_Dats:		mov	eax,[TSM_Sequences_Dats]
;				test	eax,eax
;				jz	TSM_Free_Sequences_Dats
;				invoke	GlobalFree,eax
;TSM_Free_Sequences_Dats:	mov	eax,[TSM_Module_Positions]
;				test	eax,eax
;				jz	TSM_Free_Module_Positions
;				invoke	GlobalFree,eax
;TSM_Free_Module_Positions:	ret
;TSM_Stop			ENDP

; ------------------------------------------------------
; Name: TSM_Play()
; Desc: Replay routine
TSM_Play:			cmp	dword [TSM_Can_Play-_IAT+Var_Base],0
				jne	TSM_Proceed_Play
				ret
TSM_Proceed_Play:
				push	0
				push	TSM_Buffer_Pos-_IAT+Var_Base
				mov	eax,[TSM_Sound_Buffer-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSoundBuffer.GetCurrentPosition]

				mov	eax,[TSM_Buffer_Pos-_IAT+Var_Base]
				sub	eax,[TSM_Old_Buffer_Pos-_IAT+Var_Base]
				jns	TSM_Reset_Buffer_Pos
				add	eax,[TSM_Max_Buffer-_IAT+Var_Base]
TSM_Reset_Buffer_Pos:	
				push	0
				push	TSM_Audio_Bytes2-_IAT+Var_Base
				push	TSM_Audio_Ptr2-_IAT+Var_Base
				push	TSM_Audio_Bytes1-_IAT+Var_Base
				push	TSM_Audio_Ptr1-_IAT+Var_Base
				push	eax
				push	dword [TSM_Old_Buffer_Pos-_IAT+Var_Base]
				mov	eax,[TSM_Sound_Buffer-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSoundBuffer.Lock]

				mov	eax,[TSM_Buffer_Pos-_IAT+Var_Base]
				mov	[TSM_Old_Buffer_Pos-_IAT+Var_Base],eax
				mov	edx,[TSM_Audio_Bytes1-_IAT+Var_Base]
				mov	eax,[TSM_Audio_Ptr1-_IAT+Var_Base]
				call	TSM_Process_Sound_Dat
				mov	edx,[TSM_Audio_Bytes2-_IAT+Var_Base]
				mov	eax,[TSM_Audio_Ptr2-_IAT+Var_Base]
				call	TSM_Process_Sound_Dat

				push	dword [TSM_Audio_Bytes2-_IAT+Var_Base]
				push	dword [TSM_Audio_Ptr2-_IAT+Var_Base]
				push	dword [TSM_Audio_Bytes1-_IAT+Var_Base]
				push	dword [TSM_Audio_Ptr1-_IAT+Var_Base]
				mov	eax,[TSM_Sound_Buffer-_IAT+Var_Base]
				push	eax
				mov	ebx,[eax]
				call	[ebx + IDirectSoundBuffer.Unlock]
				ret

; ------------------------------------------------------
; Name: TSM_Process_Sound_Dat()
; Desc: Inner part of the replay
TSM_Process_Sound_Dat:		push	ebp
				push	eax
				mov	[TSM_BufferSize-_IAT+Var_Base],edx
				shr	edx,2
				mov	edi,[TSM_Mixing_Buffer_Stereo-_IAT+Var_Base]
TSM_Mix_Loop:			test	edx,edx
				jz	TSM_End_Mix_Loop
				push	edx
				mov	ebp,[TSM_Sequences_Dats-_IAT+Var_Base]
				mov	dword [TSM_Speed_Tick-_IAT+Var_Base],0
				dec	dword [TSM_Fx_Ticks-_IAT+Var_Base]
				jns	TSM_Speed_Limit
				push	dword [TSM_Fx_Tempo_Ticks-_IAT+Var_Base]
				pop	dword [TSM_Fx_Ticks-_IAT+Var_Base]
				inc	dword [TSM_Speed_Tick-_IAT+Var_Base]
				inc	dword [TSM_Speed_Counter-_IAT+Var_Base]
				cmp	dword [TSM_Speed_Counter-_IAT+Var_Base],3
				jl	TSM_Speed_Limit
				mov	dword [TSM_Speed_Counter-_IAT+Var_Base],0
TSM_Speed_Limit:		dec	dword [TSM_Cur_Ticks-_IAT+Var_Base]
				jns	TSM_Update_Channels
				push	dword [TSM_Tempo_Ticks-_IAT+Var_Base]
				pop	dword [TSM_Cur_Ticks-_IAT+Var_Base]
				; Goto next position
				inc	dword [TSM_Cur_Play_Pos-_IAT+Var_Base]
				cmp	dword [TSM_Cur_Play_Pos-_IAT+Var_Base],16
				jne	TSM_Reset_Sequence_Pos
				mov	dword [TSM_Cur_Play_Pos-_IAT+Var_Base],0
				; Fill the sequences datas
				lea	ebx,[ebp]
				xor	esi,esi
				mov	ecx,8
TSM_Set_Sequences:		push	ecx
				mov	eax,[TSM_Module_Positions-_IAT+Var_Base]
				mov	edx,[TSM_Length_Track-_IAT+Var_Base]
				imul	edx,esi
				add	eax,edx			; Start address of the track
				imul	edx,[TSM_Song_Position-_IAT+Var_Base],TSM_SONG_DAT_SIZE
				add	eax,edx
				movzx	edx,byte [eax + TSM_SONG_DAT.Volume]
				push	edx			; Push volume
				movzx	edx,byte [eax + TSM_SONG_DAT.Transpose]
				mov	cl,dl
				and	dl,07fh
				and	cl,080h
				jz	TSM_Negative_Transpose
				neg	edx
TSM_Negative_Transpose:		push	edx			; Push transpose
				movzx	eax,word [eax + TSM_SONG_DAT.Sequence]
				test	eax,eax
				jz	TSM_No_Sequence
				dec	eax
				cmp	[TSM_Nbr_Sequences-_IAT+Var_Base],eax
				ja	TSM_Wrong_Sequence
				xor	eax,eax
				jmp	TSM_No_Sequence
TSM_Wrong_Sequence:		imul	eax,TSM_SEQUENCE_DAT_SIZE
				add	eax,[TSM_Module_Sequences-_IAT+Var_Base]
TSM_No_Sequence:		mov	[ebx + TSM_SEQUENCE.Current_Sequence],eax
				; Set transpose for this sequence
				pop	dword [ebx + TSM_SEQUENCE.Position_Transpose]
				; Set global volume for this sequence
				pop	eax
				test	eax,eax
				jz	TSM_No_New_Global_Volume
				dec	eax
				push	eax
				fild	dword [esp]
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				pop	eax
				fstp	dword [ebx + TSM_SEQUENCE.Position_Volume]
TSM_No_New_Global_Volume:	add	ebx,TSM_SEQUENCE_SIZE
				inc	esi
				pop	ecx
				dec	ecx
				jnz	TSM_Set_Sequences
				mov	eax,[TSM_Nbr_Positions-_IAT+Var_Base]	
				inc	dword [TSM_Song_Position-_IAT+Var_Base]
				cmp	[TSM_Song_Position-_IAT+Var_Base],eax
				jl	TSM_Reset_Song_Position
				xor	ebx,ebx
				test	eax,eax
				jz	TSM_Max_Restart
				mov	ebx,[TSM_Song_Restart-_IAT+Var_Base]
				dec	ebx
				dec	eax
				cmp	ebx,eax
				jb	TSM_Max_Restart
				mov	ebx,eax
TSM_Max_Restart:		mov	[TSM_Song_Position-_IAT+Var_Base],ebx
TSM_Reset_Song_Position:	; Set the default pans of the sequences
				lea	eax,[ebp]
				mov	ecx,8
TSM_Reset_Pan:			; (Default pan)
				fld	dword [TSM_Flt05-_IAT+Var_Base]
				fstp	dword [eax + TSM_SEQUENCE.Pan]
				add	eax,TSM_SEQUENCE_SIZE
				loop	TSM_Reset_Pan
TSM_Reset_Sequence_Pos:		mov	ecx,8
TSM_Set_Song_Datas:		push	ecx
				push	edi
				mov	dword [ebp + TSM_SEQUENCE.Vol_Side],0
				mov	dword [ebp + TSM_SEQUENCE.Arpeggio],0
				mov	dword [ebp + TSM_SEQUENCE.Pitch_Bend],0
				mov	dword [ebp + TSM_SEQUENCE.Vibrato],0
				mov	dword [ebp + TSM_SEQUENCE.Vibrato_Freq],0
				mov	dword [ebp + TSM_SEQUENCE.Tone_Portamento_Speed],0
				mov	dword [ebp + TSM_SEQUENCE.Tone_Portamento_Note],0
				; Set the effects
				mov	edi,[ebp + TSM_SEQUENCE.Current_Sequence]
				test	edi,edi
				jz	TSM_No_New_Panning
				mov	esi,[TSM_Cur_Play_Pos-_IAT+Var_Base]
				movzx	ebx,byte [edi + esi + TSM_SEQUENCE_DAT.Fx]
				movzx	eax,byte [edi + esi + TSM_SEQUENCE_DAT.FxDatas]
				; Arpeggio
				dec	ebx
				js	TSM_Fx_NoFx
				jnz	TSM_Fx_Arpeggio
				test	eax,eax
				jnz	TSM_Fx_Old_Arpeggio
				mov	eax,[ebp + TSM_SEQUENCE.Old_Arpeggio]
TSM_Fx_Old_Arpeggio:		mov	[ebp + TSM_SEQUENCE.Arpeggio],eax
				mov	[ebp + TSM_SEQUENCE.Old_Arpeggio],eax
TSM_Fx_Arpeggio:		; Pitch bend up
				dec	ebx
				jnz	TSM_Fx_Pitch_Bend_Up
				test	eax,eax
				jnz	TSM_Fx_Old_Pitch_Bend_Up
				mov	eax,[ebp + TSM_SEQUENCE.Old_Pitch_Bend_Up]
TSM_Fx_Old_Pitch_Bend_Up:	mov	dword [ebp + TSM_SEQUENCE.Pitch_Bend],eax
				mov	[ebp + TSM_SEQUENCE.Old_Pitch_Bend_Up],eax
TSM_Fx_Pitch_Bend_Up:		; Pitch bend down
				dec	ebx
				jnz	TSM_Fx_Pitch_Bend_Down
				neg	eax
				test	eax,eax
				jnz	TSM_Fx_Old_Pitch_Bend_Down
				mov	eax,[ebp + TSM_SEQUENCE.Old_Pitch_Bend_Down]
TSM_Fx_Old_Pitch_Bend_Down:	mov	[ebp + TSM_SEQUENCE.Pitch_Bend],eax
				mov	[ebp + TSM_SEQUENCE.Old_Pitch_Bend_Down],eax
TSM_Fx_Pitch_Bend_Down:		; Vibrato
				dec	ebx
				jnz	TSM_Fx_Vibrato
				test	eax,eax
				jnz	TSM_Fx_Old_Vibrato
				mov	eax,[ebp + TSM_SEQUENCE.Old_Vibrato]
TSM_Fx_Old_Vibrato:		mov	[ebp + TSM_SEQUENCE.Vibrato],eax
				mov	[ebp + TSM_SEQUENCE.Old_Vibrato],eax
TSM_Fx_Vibrato:			; Volume slide up
				dec	ebx
				jnz	TSM_Fx_Vol_Slide_Up
				test	eax,eax
				jnz	TSM_Fx_Old_Vol_Slide_Up
				mov	eax,[ebp + TSM_SEQUENCE.Old_Vol_Side_Up]
TSM_Fx_Old_Vol_Slide_Up:	push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Vol_Side]
				mov	[ebp + TSM_SEQUENCE.Old_Vol_Side_Up],eax
TSM_Fx_Vol_Slide_Up:		; Volume slide down
				dec	ebx
				jnz	TSM_Fx_Vol_Slide_Down
				test	eax,eax
				jnz	TSM_Fx_Old_Vol_Slide_Down
				mov	eax,[ebp + TSM_SEQUENCE.Old_Vol_Side_Down]
TSM_Fx_Old_Vol_Slide_Down:	push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fchs
				fstp	dword [ebp + TSM_SEQUENCE.Vol_Side]
				mov	[ebp + TSM_SEQUENCE.Old_Vol_Side_Down],eax
TSM_Fx_Vol_Slide_Down:		; Modify tempo
				dec	ebx
				jnz	TSM_Fx_Set_Tempo
				mov	[TSM_Tempo-_IAT+Var_Base],eax
				mov	ecx,eax
				call	TSM_Get_Mix_Buffer_Len
				mov	[TSM_Tempo_Ticks-_IAT+Var_Base],eax
TSM_Fx_Set_Tempo:		; Modify misc. FX tempo
				dec	ebx
				jnz	TSM_Fx_Set_Misc_Tempo
				mov	[TSM_Fx_Tempo-_IAT+Var_Base],eax
				mov	ecx,eax
				call	TSM_Get_Mix_Buffer_Len
				mov	[TSM_Fx_Tempo_Ticks-_IAT+Var_Base],eax
TSM_Fx_Set_Misc_Tempo:		; Modify global volume
				dec	ebx
				jnz	TSM_Fx_Set_Global_Volume
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				call	TSM_Clamp_Value
				fstp	dword [TSM_Global_Volume-_IAT+Var_Base]
TSM_Fx_Set_Global_Volume:	; Tone portamento
				dec	ebx
				jnz	TSM_Fx_NoFx
				movzx	edx,byte [edi + esi + TSM_SEQUENCE_DAT.Note]
				test	eax,eax
				jnz	TSM_Fx_Old_Tone_Portamento_Spd
				mov	eax,[ebp + TSM_SEQUENCE.Old_Tone_Portamento_Speed]
TSM_Fx_Old_Tone_Portamento_Spd:	dec	edx
				jns	TSM_Fx_Old_Tone_Portamento_Nt
				mov	edx,[ebp + TSM_SEQUENCE.Old_Tone_Portamento_Note]
TSM_Fx_Old_Tone_Portamento_Nt:	mov	[ebp + TSM_SEQUENCE.Tone_Portamento_Speed],eax
				mov	[ebp + TSM_SEQUENCE.Old_Tone_Portamento_Speed],eax
				mov	[ebp + TSM_SEQUENCE.Tone_Portamento_Note],edx
				mov	[ebp + TSM_SEQUENCE.Old_Tone_Portamento_Note],edx
TSM_Fx_NoFx:			; Set the instrument
				movzx	eax,word [edi + TSM_SEQUENCE_DAT.Instrument + esi * 2]
				dec	eax
				js	TSM_No_New_Instrument
				cmp	[TSM_Nbr_Instruments-_IAT+Var_Base],eax
				jg	TSM_Return_Instrument
				xor	eax,eax
				jmp	TSM_Wrong_Instrument
TSM_Return_Instrument:		shl	eax,3
				add	eax,[TSM_Module_Instruments-_IAT+Var_Base]
TSM_Wrong_Instrument:		mov	[ebp + TSM_SEQUENCE.Current_Instrument],eax
				xor	ecx,ecx
				mov	eax,[ebp + TSM_SEQUENCE.Current_Instrument]
				call	TSM_Get_Instrument_Dat
				mov	[ebp + TSM_SEQUENCE.Current_Instrument_Dat],eax
				test	eax,eax
				jz	TSM_No_New_Instrument
				mov	eax,[ebp + TSM_SEQUENCE.Current_Instrument]
				test	eax,eax
				jz	TSM_Return_Comb
				mov	eax,[eax + 4]
TSM_Return_Comb:		mov	[ebp + TSM_SEQUENCE.Instrument_NbrComb],eax
				fld1
				fstp	dword [ebp + TSM_SEQUENCE.Volume]
TSM_No_New_Instrument:		; Set the note
				mov	esi,[TSM_Cur_Play_Pos-_IAT+Var_Base]
				cmp	dword [ebp + TSM_SEQUENCE.Tone_Portamento_Speed],0
				jne	TSM_No_New_Note
				movzx	ebx,byte [edi + esi + TSM_SEQUENCE_DAT.Note]
				dec	ebx
				js	TSM_No_New_Note
				add	ebx,[ebp + TSM_SEQUENCE.Position_Transpose]
				mov	[ebp + TSM_SEQUENCE.Cur_Note],ebx
				mov	[ebp + TSM_SEQUENCE.Cur_Freq],ebx
				mov	dword [ebp + TSM_SEQUENCE.Pitch_Bend_Freq],0
				mov	eax,[ebp + TSM_SEQUENCE.Current_Instrument]
				test	eax,eax
				jz	TSM_No_New_Note
				mov	ecx,[ebp + TSM_SEQUENCE.Instrument_NbrComb]
				lea	eax,[ebp + TSM_SEQUENCE.Cur_Instrument_Vars]
TSM_Clear_Instrument_Dats:	xor	edx,edx
				mov	[eax + TSM_INSTRUMENT_VARS.Volume],edx
				mov	[eax + TSM_INSTRUMENT_VARS.Ticks],edx
				mov	[eax + TSM_INSTRUMENT_VARS.RndVal1],edx
				mov	[eax + TSM_INSTRUMENT_VARS.RndVal2],edx
				mov	[eax + TSM_INSTRUMENT_VARS.wrpos],edx
				mov	[eax + TSM_INSTRUMENT_VARS.FPos],edx
				mov	[eax + TSM_INSTRUMENT_VARS.Oscillator],edx
				mov	[eax + TSM_INSTRUMENT_VARS.Frac_Lo_Pos],edx
				add	eax,TSM_INSTRUMENT_VARS_SIZE
				loop	TSM_Clear_Instrument_Dats
TSM_No_New_Note:		; Set the volume
				movzx	ebx,byte [edi + esi + TSM_SEQUENCE_DAT.Volume]
				dec	ebx
				js	TSM_No_New_Volume
				push	ebx
				fild	dword [esp]
				pop	ebx
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Volume]
TSM_No_New_Volume:		; Set the panning
				movzx	ebx,byte [edi + esi + TSM_SEQUENCE_DAT.Panning]
				dec	ebx
				js	TSM_No_New_Panning
				push	ebx
				fild	dword [esp]
				pop	ebx
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Pan]
TSM_No_New_Panning:		pop	edi
				pop	ecx
				add	ebp,TSM_SEQUENCE_SIZE
				dec	ecx
				jnz	TSM_Set_Song_Datas
TSM_Update_Channels:		; -------------------------------------------------
				; Process in-between effects
				mov	ebp,[TSM_Sequences_Dats-_IAT+Var_Base]
				mov	ecx,8
TSM_Set_Song_Fx:		push	ecx
				cmp	dword [ebp + TSM_SEQUENCE.Pitch_Bend],0
				je	TSM_No_PitchBend
				cmp	dword [TSM_Speed_Tick-_IAT+Var_Base],0
				je	TSM_No_PitchBend
				mov	eax,[ebp + TSM_SEQUENCE.Pitch_Bend_Freq]
				add	eax,[ebp + TSM_SEQUENCE.Pitch_Bend]
				mov	[ebp + TSM_SEQUENCE.Pitch_Bend_Freq],eax
TSM_No_PitchBend:		cmp	dword [ebp + TSM_SEQUENCE.Vibrato],0
				je	TSM_No_Vibrato
				cmp	dword [TSM_Speed_Tick-_IAT+Var_Base],0
				je	TSM_No_Vibrato
				mov	eax,[ebp + TSM_SEQUENCE.Vibrato]
				mov	ebx,eax
				shr	ebx,4
				and	eax,0fh
				push	eax
				fild	dword [esp]
				fadd	st0,st0
				fadd	st0,st0
				fadd	st0,st0
				fadd	st0,st0
				pop	eax
				push	dword [ebp + TSM_SEQUENCE.Vibrato_Tick]
				fild	dword [esp]
				fmul	dword [TSM_Flt005-_IAT+Var_Base]
				fsin
				fmulp	st1,st0
				fistp	dword [esp]
				pop	eax
				mov	[ebp + TSM_SEQUENCE.Vibrato_Freq],eax
				add	[ebp + TSM_SEQUENCE.Vibrato_Tick],ebx
TSM_No_Vibrato:			cmp	dword [ebp + TSM_SEQUENCE.Arpeggio],0
				je	TSM_No_Arpeggio
				mov	eax,[TSM_Speed_Counter-_IAT+Var_Base]
				xor	edx,edx
				mov	ebx,3
				div	ebx
				dec	edx
				jz	TSM_Do_Arpeggio1
				dec	edx
				jz	TSM_Do_Arpeggio2
				xor	edx,edx
				jmp	TSM_Do_Arpeggio
TSM_Do_Arpeggio1:		mov	edx,[ebp + TSM_SEQUENCE.Arpeggio]
				shr	edx,4
				jmp	TSM_Do_Arpeggio
TSM_Do_Arpeggio2:		mov	edx,[ebp + TSM_SEQUENCE.Arpeggio]
				and	edx,0fh
TSM_Do_Arpeggio:		add	edx,[ebp + TSM_SEQUENCE.Cur_Note]
				mov	[ebp + TSM_SEQUENCE.Cur_Freq],edx
TSM_No_Arpeggio:		cmp	dword [ebp + TSM_SEQUENCE.Tone_Portamento_Speed],0
				je	TSM_No_TonePortamento
				cmp	dword [TSM_Speed_Tick-_IAT+Var_Base],0
				je	TSM_No_TonePortamento
				mov	ebx,[ebp + TSM_SEQUENCE.Pitch_Bend_Freq]
				mov	ecx,[ebp + TSM_SEQUENCE.Tone_Portamento_Speed]
				mov	edx,[ebp + TSM_SEQUENCE.Tone_Portamento_Note]
				mov	eax,[TSM_Freqs_Table-_IAT+Var_Base + edx * 4]
				cmp	eax,[ebp + TSM_SEQUENCE.Current_Freq]
				je	TSM_Portamento_Stop
				ja	TSM_Portamento_Up
				sub	ebx,ecx
				cmp	eax,ebx
				ja	TSM_Portamento_Stop
				jmp	TSM_Set_Portamento_Freq
TSM_Portamento_Up:		add	ebx,ecx
				cmp	eax,ebx
				jb	TSM_Portamento_Stop
				jmp	TSM_Set_Portamento_Freq
TSM_Portamento_Stop:		mov	[ebp + TSM_SEQUENCE.Cur_Freq],edx
				xor	ebx,ebx
TSM_Set_Portamento_Freq:	mov	[ebp + TSM_SEQUENCE.Pitch_Bend_Freq],ebx
TSM_No_TonePortamento:		pop	ecx
				add	ebp,TSM_SEQUENCE_SIZE
				dec	ecx
				jnz	TSM_Set_Song_Fx
				; -------------------------
				; Handle waves combinations
				mov	ebp,[TSM_Sequences_Dats-_IAT+Var_Base]
				mov	ecx,8
TSM_Set_Song_Instruments:	push	ecx
				push	edi
				lea	eax,[ebp + TSM_SEQUENCE.Cur_Instrument_Vars]
				mov	[TSM_Instr_Dat_Vars-_IAT+Var_Base],eax
				mov	dword [ebp + TSM_SEQUENCE.Sound_Datas],0
				mov	dword [TSM_Instr_Dat_Number-_IAT+Var_Base],0
				mov	ebx,[ebp + TSM_SEQUENCE.Current_Instrument_Dat]
				; Load number of combinators
				mov	ecx,[ebp + TSM_SEQUENCE.Instrument_NbrComb]
TSM_Load_Instrument:		test	ebx,ebx
				jz	TSM_No_Instrument
				push	ecx
				mov	edi,[TSM_Instr_Dat_Vars-_IAT+Var_Base]
				mov	ecx,[ebp + TSM_SEQUENCE.Cur_Freq]
				mov	dword [ebp + TSM_SEQUENCE.Freq_Hi_Speed],0
				mov	dword [ebp + TSM_SEQUENCE.Freq_Lo_Speed],0
				test	ecx,ecx
				js	TSM_No_Freq
				cmp	ecx,TSM_MAX_NOTES
				jge	TSM_No_Freq
				mov	eax,[TSM_Freqs_Table-_IAT+Var_Base + ecx * 4]
				add	eax,[ebp + TSM_SEQUENCE.Vibrato_Freq]
				add	eax,[ebp + TSM_SEQUENCE.Pitch_Bend_Freq]
				movzx	edx,byte [ebx + TSM_INSTRUMENT_DAT.Waveform]
				cmp	dl,TSM_INS_WF_CUST
				je	TSM_Custom_Value
				movsx	edx,word [ebx + TSM_INSTRUMENT_DAT.PhaseShift]
				add	eax,edx
TSM_Custom_Value:		cmp	eax,0417h
				jg	TSM_Min_Frequency
				mov	eax,0417h
TSM_Min_Frequency:		cmp	eax,0F6F11h
				jl	TSM_Max_Frequency
				mov	eax,0F6F11h
TSM_Max_Frequency:		mov	[ebp + TSM_SEQUENCE.Current_Freq],eax
				xor	edx,edx
				div	dword [TSM_Max_Buffer-_IAT+Var_Base]
				mov	[ebp + TSM_SEQUENCE.Freq_Hi_Speed],eax
				xor	eax,eax
				div	dword [TSM_Max_Buffer-_IAT+Var_Base]
				mov	[ebp + TSM_SEQUENCE.Freq_Lo_Speed],eax
TSM_No_Freq:			mov	edx,[edi + TSM_INSTRUMENT_VARS.Frac_Lo_Pos]
				mov	esi,[edi + TSM_INSTRUMENT_VARS.Oscillator]
				add	edx,[ebp + TSM_SEQUENCE.Freq_Lo_Speed]
				adc	esi,[ebp + TSM_SEQUENCE.Freq_Hi_Speed]
				mov	[edi + TSM_INSTRUMENT_VARS.Frac_Lo_Pos],edx
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				mov	[edi + TSM_INSTRUMENT_VARS.Oscillator],esi
				fild	dword [edi + TSM_INSTRUMENT_VARS.Oscillator]
				fmul	dword [TSM_Flt01-_IAT+Var_Base]
				movzx	edx,byte [ebx + TSM_INSTRUMENT_DAT.Waveform]
				dec	dl
				jnz	TSM_Set_Ins_Sin
				fsin
TSM_Set_Ins_Sin:		dec	dl
				jnz	TSM_Set_Ins_Sqr
				fsin
				fld	st0
				push	eax
				fistp	dword [esp]
				fild	dword [esp]
				fxch	st1
				cmp	dword [esp],0
				jne	TSM_Sqr_Zero
				ftst
				fstsw	ax
				sahf
				fstp	st0
				fstp	st0
				fld1
				ja	TSM_Sqr_Neg
				fchs
TSM_Sqr_Neg:			fld	st0
TSM_Sqr_Zero:			fstp	st0
				pop	eax
TSM_Set_Ins_Sqr:		dec	dl
				jnz	TSM_Set_Ins_Saw
				fld	dword [TSM_FltPI2-_IAT+Var_Base]
				fxch	st1
TSM_FModf_Saw:			fprem
				fstsw	ax
				sahf
				jp	TSM_FModf_Saw
				fstp	st1
				fdiv	dword [TSM_FltPI-_IAT+Var_Base]
				fsub	dword [TSM_Flt1-_IAT+Var_Base]
TSM_Set_Ins_Saw:		dec	dl
				jnz	TSM_Set_Ins_Rnd
				fstp	dword [edi + TSM_INSTRUMENT_VARS.FPos]
				cmp	dword [edi + TSM_INSTRUMENT_VARS.wrpos],0
				jne	TSM_Reset_Noise
				call	TSM_Wave_WhiteNoise
				fstp	dword [edi + TSM_INSTRUMENT_VARS.RndVal1]
				call	TSM_Wave_WhiteNoise
				fstp	dword [edi + TSM_INSTRUMENT_VARS.RndVal2]
				mov	eax,[edi + TSM_INSTRUMENT_VARS.FPos]
				mov	[edi + TSM_INSTRUMENT_VARS.wrpos],eax
TSM_Reset_Noise:		fld	dword [edi + TSM_INSTRUMENT_VARS.wrpos]
				fadd	dword [TSM_FltPI2-_IAT+Var_Base]
				fcom	dword [edi + TSM_INSTRUMENT_VARS.FPos]
				fnstsw	ax
				sahf
				jae	TSM_Done_Rnd
				fstp	dword [edi + TSM_INSTRUMENT_VARS.wrpos]
				mov	eax,[edi + TSM_INSTRUMENT_VARS.RndVal2]
				mov	[edi + TSM_INSTRUMENT_VARS.RndVal1],eax
				call	TSM_Wave_WhiteNoise
				fstp	dword [edi + TSM_INSTRUMENT_VARS.RndVal2]
				jmp	TSM_Reset_Noise
TSM_Done_Rnd:			fstp	st0
				fld	dword [edi + TSM_INSTRUMENT_VARS.FPos]
				fsub	dword [edi + TSM_INSTRUMENT_VARS.wrpos]
				fmul	dword [edi + TSM_INSTRUMENT_VARS.RndVal2]
				fld	dword [TSM_FltPI2-_IAT+Var_Base]
				fadd	dword [edi + TSM_INSTRUMENT_VARS.wrpos]
				fsub	dword [edi + TSM_INSTRUMENT_VARS.FPos]
				fmul	dword [edi + TSM_INSTRUMENT_VARS.RndVal1]
				faddp	st1,st0
				fmul	dword [TSM_Flt05-_IAT+Var_Base]
TSM_Set_Ins_Rnd:		dec	dl
				jnz	TSM_Set_Ins_Cust
				fstp	st0
				movzx	eax,byte [ebx + TSM_INSTRUMENT_DAT.PhaseShift]
				push	eax
				fild	dword [esp]
				pop	eax
				cmp	word [ebx + TSM_INSTRUMENT_DAT.PhaseShift],0
				jg	TSM_Negative_Shift
				fchs
TSM_Negative_Shift:		fmul	dword [TSM_Flt001-_IAT+Var_Base]
TSM_Set_Ins_Cust:		dec	dl
				jnz	TSM_Set_Ins_Tri
				fld	dword [TSM_FltPI2-_IAT+Var_Base]
				fxch	st1
TSM_FModf_Tri:			fprem
				fstsw	ax
				sahf
				jp	TSM_FModf_Tri
				fstp	st1
				fcom	dword [TSM_FltPI-_IAT+Var_Base]
				fnstsw	ax
				sahf
				fld1
				ja	TSM_Tri_Desc
				fchs
TSM_Tri_Desc:			fxch	st1
				fcom	dword [TSM_FltPI2-_IAT+Var_Base]
				fnstsw	ax
				sahf
				jb	TSM_Tri_Ramp
				fsub	dword [TSM_FltPI2-_IAT+Var_Base]
				fld	dword [TSM_FltPI2-_IAT+Var_Base]
				fsubrp	st1,st0
TSM_Tri_Ramp:			fdiv	dword [TSM_FltPI2-_IAT+Var_Base]
				fmulp	st1,st0
				fadd	dword [TSM_Flt025-_IAT+Var_Base]
				fcom	dword [TSM_Flt05-_IAT+Var_Base]
				fnstsw	ax
				sahf
				jb	TSM_Tri_Invert
				fsub	dword [TSM_Flt1-_IAT+Var_Base]
TSM_Tri_Invert:			fadd	st0,st0
				fadd	st0,st0
TSM_Set_Ins_Tri:		push	ebp
				mov	ebp,[TSM_Instr_Dat_Vars-_IAT+Var_Base]
				; Handle ADSR
				push	edi
				movzx	edi,byte [ebx + TSM_INSTRUMENT_DAT.Attack_Volume]
				movzx	ecx,word [ebx + TSM_INSTRUMENT_DAT.Attack]
				xor	edx,edx
				movsx	eax,byte [ebx + TSM_INSTRUMENT_DAT.Attack_Volume_Delta]
				mov	esi,ecx
				test	ecx,ecx
				jz	TSM_Load_Decay
				add	edx,ecx
				cmp	[ebp + TSM_INSTRUMENT_VARS.Ticks],edx
				jb	TSM_Load_Decay
				movzx	edi,byte [ebx + TSM_INSTRUMENT_DAT.Decay_Volume]
				movzx	esi,word [ebx + TSM_INSTRUMENT_DAT.Decay]
				movsx	eax,byte [ebx + TSM_INSTRUMENT_DAT.Decay_Volume_Delta]
TSM_Load_Decay:			movzx	ecx,word [ebx + TSM_INSTRUMENT_DAT.Decay]
				test	ecx,ecx
				jz	TSM_Load_Sustain
				add	edx,ecx
				cmp	[ebp + TSM_INSTRUMENT_VARS.Ticks],edx
				jb	TSM_Load_Sustain
				movzx	edi,byte [ebx + TSM_INSTRUMENT_DAT.Sustain_Volume]
				movzx	esi,word [ebx + TSM_INSTRUMENT_DAT.Sustain]
				movsx	eax,byte [ebx + TSM_INSTRUMENT_DAT.Sustain_Volume_Delta]
TSM_Load_Sustain:		movzx	ecx,word [ebx + TSM_INSTRUMENT_DAT.Sustain]
				test	ecx,ecx
				jz	TSM_Load_Release
				add	edx,ecx
				cmp	dword [ebp + TSM_INSTRUMENT_VARS.Ticks],edx
				jb	TSM_Load_Release
				movzx	edi,byte [ebx + TSM_INSTRUMENT_DAT.Release_Volume]
				movzx	esi,word [ebx + TSM_INSTRUMENT_DAT.Release]
				movsx	eax,byte [ebx + TSM_INSTRUMENT_DAT.Release_Volume_Delta]
TSM_Load_Release:		test	esi,esi
				jz	TSM_Done_Ramping
				test	eax,eax
				jz	TSM_Done_Ramping
				push	eax
				jg	TSM_Vol_Ramp_Up
				; Ramping down
				push	edi				; Dest volume
				fild	dword [esp]
				pop	edi
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fcomp	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
				fnstsw	ax
				sahf
				jb	TSM_Volume_Max
				jmp	TSM_Volume_Equal
				; Ramping up
TSM_Vol_Ramp_Up:		push	edi
				fild	dword [esp]
				pop	edi
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fcomp	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
				fnstsw	ax
				sahf
				jz	TSM_Volume_Equal
				ja	TSM_Volume_Max
TSM_Volume_Equal:		; Set the Dest volume
				mov	[esp],edi
				fild	dword [esp]
				pop	edi
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
				jmp	TSM_Done_Ramping
TSM_Volume_Max:			fild	dword [esp]			; Delta volume
				pop	eax
				push	esi
				fild	dword [esp]			; Ramping time
				pop	esi
				fdivp	st1,st0
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fadd	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
				call	TSM_Clamp_Value
				fstp	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
TSM_Done_Ramping:		; Set the volume of the sample according to the ADSR
				fmul	dword [ebp + TSM_INSTRUMENT_VARS.Volume]
				pop	edi
				; Handle operators
				mov	dl,[ebx + TSM_INSTRUMENT_DAT.Operator]
				dec	dl
				jnz	TSM_Set_Ins_Op_Add
				faddp	st1,st0
TSM_Set_Ins_Op_Add:		dec	dl
				jnz	TSM_Set_Ins_Op_Sub
				fsubp	st1,st0
TSM_Set_Ins_Op_Sub:		dec	dl
				jnz	TSM_Set_Ins_Op_Mul
				fmulp	st1,st0
TSM_Set_Ins_Op_Mul:		dec	dl
				jnz	TSM_Set_Ins_Op_Div
				fdivp	st1,st0
TSM_Set_Ins_Op_Div:		inc	dword [ebp + TSM_INSTRUMENT_VARS.Ticks]
				pop	ebp
				; Store oscillator value now
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				; Next instrument's datas
				inc	dword [TSM_Instr_Dat_Number-_IAT+Var_Base]
				mov	ecx,[TSM_Instr_Dat_Number-_IAT+Var_Base]
				; Next datas of the instrument of the sequence
				mov	eax,[ebp + TSM_SEQUENCE.Current_Instrument]
				call	TSM_Get_Instrument_Dat
				mov	ebx,eax
				add	dword [TSM_Instr_Dat_Vars-_IAT+Var_Base],TSM_INSTRUMENT_VARS_SIZE
				pop	ecx
				dec	ecx
				jnz	TSM_Load_Instrument
TSM_No_Instrument:		pop	edi
				; Set channel volume
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fld	dword [ebp + TSM_SEQUENCE.Volume]
				cmp	dword [TSM_Speed_Tick-_IAT+Var_Base],0
				je	TSM_No_Vol_Slide
				fadd	dword [ebp + TSM_SEQUENCE.Vol_Side]
				call	TSM_Clamp_Value
				fst	dword [ebp + TSM_SEQUENCE.Volume]
TSM_No_Vol_Slide:		fmulp	st1,st0
				; Set song position volume
				fmul	dword [ebp + TSM_SEQUENCE.Position_Volume]
				fmul	dword [TSM_Global_Volume-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				; Reset DSP effects parameters
				mov	edx,[ebp + TSM_SEQUENCE.Current_Sequence]
				test	edx,edx
				jz	TSM_No_DSP_Params
				mov	esi,[TSM_Cur_Play_Pos-_IAT+Var_Base]
				mov	bl,[edx + esi + TSM_SEQUENCE_DAT.DspMask]
				test	bl,1
				jz	TSM_Switch_Lo_Pass_Off
				mov	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param1],0
				mov	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param2],0
TSM_Switch_Lo_Pass_Off:		test	bl,2
				jz	TSM_Switch_Hi_Pass_Off
				mov	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param1],0
				mov	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param2],0
TSM_Switch_Hi_Pass_Off:		test	bl,4
				jz	TSM_Switch_VCF_Pass_Off
				mov	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param1],0
				mov	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param2],0
TSM_Switch_VCF_Pass_Off:	test	bl,8
				jz	TSM_Switch_Delay_Off
				push	0
				push	0
				push	0
				push	ebp
				call	TSM_Set_Delay
				mov	dword [ebp + TSM_SEQUENCE.Delay_Cursor],0
TSM_Switch_Delay_Off:		test	bl,16
				jz	TSM_Switch_Disto_Off
				mov	dword [ebp + TSM_SEQUENCE.Disto_Param],0
TSM_Switch_Disto_Off:		test	bl,32
				jz	TSM_Switch_Formant_Off
				mov	dword [ebp + TSM_SEQUENCE.Formant_Param1],0
				mov	dword [ebp + TSM_SEQUENCE.Formant_Param2],0
				mov	dword [ebp + TSM_SEQUENCE.Formant_Param3],0
TSM_Switch_Formant_Off:		; Process DSP effects
				mov	bl,byte [edx + esi + TSM_SEQUENCE_DAT.Dsp]
				dec	bl
				js	TSM_No_DSP_Params
				jnz	TSM_No_Lo_Pass_Filter
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				mov	ah,[edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				push	eax
				fild	dword [esp]
				pop	eax
				fstp	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param2]
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas1]
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt01-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param1]
TSM_No_Lo_Pass_Filter:		dec	bl
				jnz	TSM_No_Hi_Pass_Filter
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				mov	ah,[edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				push	eax
				fild	dword [esp]
				pop	eax
				fstp	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param2]
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas1]
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt01-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param1]
TSM_No_Hi_Pass_Filter:		dec	bl
				jnz	TSM_No_VCF_Pass_Filter
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				mov	ah,[edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt00001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param2]
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas1]
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param1]
TSM_No_VCF_Pass_Filter:		dec	bl
				dec	bl
				jnz	TSM_No_Disto_Filter
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				mov	ah,[edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				push	eax
				fild	dword [esp]
				pop	eax
				fmul	dword [TSM_Flt01-_IAT+Var_Base]
				fstp	dword [ebp + TSM_SEQUENCE.Disto_Param]
TSM_No_Disto_Filter:		dec	bl
				jnz	TSM_No_DSP_Params
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas1]
				cmp	eax,5
				jb	TSM_Max_Formant_Filter
				mov	eax,5
TSM_Max_Formant_Filter:		mov	[ebp + TSM_SEQUENCE.Formant_Param1],eax
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				cmp	eax,5
				jb	TSM_Max_Formant_Filter_Dest
				mov	eax,5
TSM_Max_Formant_Filter_Dest:	mov	[ebp + TSM_SEQUENCE.Formant_Param2],eax
				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				mov	[ebp + TSM_SEQUENCE.Formant_Param3],eax
TSM_No_DSP_Params:		cmp	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param1],0
				je	TSM_No_Process_Lo_Pass
				cmp	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param2],0
				je	TSM_No_Process_Lo_Pass
				fldpi
				fmul	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param2]
				fmul	dword [TSM_Flt0000023-_IAT+Var_Base]
				fptan
				fstp	st0
				mov	edx,[ebp + TSM_SEQUENCE.Lo_Pass_In1]
				mov	ecx,[ebp + TSM_SEQUENCE.Lo_Pass_Out1]
				fld1
				fld	st0
				fdivrp	st2,st0
				fld	dword [ebp + TSM_SEQUENCE.Lo_Pass_Param1]
				fmul	st0,st2
				fxch	st2
				fmul	st0,st0
				fld	st1
				fadd	st0,st3
				fadd	st0,st1
				fdivr	st0,st2
				fld	st0
				fadd	st0,st0
				fld	st3
				fsub	st0,st3
				fadd	st0,st0
				fmul	st0,st2
				fxch	st4
				fsubrp	st5,st0
				fxch	st2
				faddp	st4,st0
				fmul	st3,st0
				fld	st0
				fmul	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fxch	st2
				fmul	dword [ebp + TSM_SEQUENCE.Lo_Pass_In1]
				faddp	st2,st0
				fmul	dword [ebp + TSM_SEQUENCE.Lo_Pass_In2]
				faddp	st1,st0
				fld	dword [ebp + TSM_SEQUENCE.Lo_Pass_Out1]
				fchs
				fmulp	st2,st0
				faddp	st1,st0
				fld	dword [ebp + TSM_SEQUENCE.Lo_Pass_Out2]
				fchs
				fmulp	st2,st0
				faddp	st1,st0
				mov	[ebp + TSM_SEQUENCE.Lo_Pass_In2],edx
				fld	st0
				mov	[ebp + TSM_SEQUENCE.Lo_Pass_Out2],ecx
				push	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				pop	dword [ebp + TSM_SEQUENCE.Lo_Pass_In1]
				fxch	st1
				fstp	dword [ebp + TSM_SEQUENCE.Lo_Pass_Out1]
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
TSM_No_Process_Lo_Pass:		cmp	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param1],0
				je	TSM_No_Process_Hi_Pass
				cmp	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param2],0
				je	TSM_No_Process_Hi_Pass
				fldpi
				fmul	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param2]
				fmul	dword [TSM_Flt0000023-_IAT+Var_Base]
				fptan
				fstp	st0
				fld	st0
				fmul	st0,st0
				fld1
				fld	st0
				fadd	st0,st2
				fld	dword [ebp + TSM_SEQUENCE.Hi_Pass_Param1]
				fmulp	st4,st0
				fld	st0
				fadd	st0,st4
				fdivp	st2,st0
				fxch	st2
				fadd	dword [TSM_Fltm1-_IAT+Var_Base]
				fld	dword [TSM_Fltm2-_IAT+Var_Base]
				fmul	st0,st2
				fxch	st1
				fadd	st0,st0
				fmul	st0,st2
				fxch	st4
				fsubp	st3,st0
				fxch	st1
				fmul	st2,st0
				mov	edx,[ebp + TSM_SEQUENCE.Hi_Pass_In1]
				mov	ecx,[ebp + TSM_SEQUENCE.Hi_Pass_Out1]
				fld	st0
				fmul	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fxch	st2
				fmul	dword [ebp + TSM_SEQUENCE.Hi_Pass_In1]
				faddp	st2,st0
				fmul	dword [ebp + TSM_SEQUENCE.Hi_Pass_In2]
				faddp	st1,st0
				fld	dword [ebp + TSM_SEQUENCE.Hi_Pass_Out1]
				fchs
				fmulp	st3,st0
				faddp	st2,st0
				fld	dword [ebp + TSM_SEQUENCE.Hi_Pass_Out2]
				fchs
				fmulp	st1,st0
				faddp	st1,st0
				mov	[ebp + TSM_SEQUENCE.Hi_Pass_In2],edx
				fld	st0
				mov	[ebp + TSM_SEQUENCE.Hi_Pass_Out2],ecx
				push	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				pop	dword [ebp + TSM_SEQUENCE.Hi_Pass_In1]
				fxch	st1
				fstp	dword [ebp + TSM_SEQUENCE.Hi_Pass_Out1]
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
TSM_No_Process_Hi_Pass:		cmp	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param1],0
				je	TSM_No_Process_VCF_Pass
				cmp	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param2],0
				je	TSM_No_Process_VCF_Pass
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param2]
				fmul	dword [TSM_Flt116-_IAT+Var_Base]
				fld1
				fld	st1
				fmul	st0,st0
				fld	dword [TSM_Flt015-_IAT+Var_Base]
				fmul	st0,st3
				fmul	st0,st3
				fsubr	st0,st2
				fmul	dword [ebp + TSM_SEQUENCE.VCF_Pass_Param1]
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out4]
				fld	st0
				fchs
				fmulp	st2,st0
				fxch	st1
				fadd	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fxch	st3
				fsubrp	st4,st0
				fld	dword [TSM_Flt035-_IAT+Var_Base]
				fmul	st0,st2
				fmulp	st2,st0
				fxch	st1
				fmulp	st2,st0
				fld	st2
				fld	dword [TSM_Flt03-_IAT+Var_Base]
				fld	st0
				fld	st5
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_In1]
				fmulp	st2,st0
				fxch	st1
				fadd	st0,st5
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out1]
				fmulp	st4,st0
				faddp	st3,st0
				fxch	st2 
				fst	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out1]
				fld	st1
				fxch	st5
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_In1]
				fld	st5
				fxch	st4
				fmulp	st6,st0
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_In2]
				fmulp	st5,st0
				fadd	st4,st0
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out2]
				fmulp	st3,st0
				fxch	st2
				faddp	st4,st0
				fxch	st3
				fst	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out2]
				fld	st3
				fxch	st2
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_In2]
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_In3]
				fmulp	st2,st0
				fadd	st1,st0
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out3]
				fmulp	st3,st0
				fxch	st2
				faddp	st1,st0
				fst	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out3]
				fxch	st1
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_In3]
				fld	dword [ebp + TSM_SEQUENCE.VCF_Pass_In4]
				fmulp	st2,st0
				fadd	st1,st0
				fxch	st2
				faddp	st1,st0
				fst	dword [ebp + TSM_SEQUENCE.VCF_Pass_Out4]
				fxch	st1
				fstp	dword [ebp + TSM_SEQUENCE.VCF_Pass_In4]
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
TSM_No_Process_VCF_Pass:	cmp	dword [ebp + TSM_SEQUENCE.Disto_Param],0
				je	TSM_No_Process_Disto
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fabs
				fst	qword [ebp + TSM_SEQUENCE.Disto_Abs_Input]
				fld1
				fld	dword [ebp + TSM_SEQUENCE.Disto_Param]
				fld	st0
				fadd	qword [ebp + TSM_SEQUENCE.Disto_Abs_Input]
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fmul	st1,st0
				fmul	st0,st0
				fadd	st0,st3
				fld	dword [TSM_Fltm1-_IAT+Var_Base]
				faddp	st3,st0
				fxch	st4
				fmulp	st2,st0
				fxch	st1
				faddp	st3,st0
				fxch	st1
				fdivrp	st2,st0
				fmulp	st1,st0
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
TSM_No_Process_Disto:		mov	eax,[ebp + TSM_SEQUENCE.Formant_Param1]
				test	eax,eax
				jz	TSM_No_Process_Filters
				dec	eax
				imul	eax,eax,(11 * 8)
				mov	ecx,[ebp + TSM_SEQUENCE.Formant_Param2]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 5)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 6)]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base]
				fmul	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 1)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 2)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 1)]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 3)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 2)]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 4)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 3)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 7)]
				fxch	st6
				fst	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 7)]
				fxch	st7
				fst	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 6)]
				fxch	st4
				faddp	st5,st0
				fxch	st2
				faddp	st4,st0
				faddp	st3,st0
				faddp	st2,st0
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 5)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 4)]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 6)]
				fmulp	st2,st0
				faddp	st1,st0
				faddp	st1,st0
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 7)]
				fmulp	st3,st0
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 8)]
				fmul	st0,st2
				faddp	st3,st0
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 9)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 8)]
				fld	qword [eax + TSM_Formant_Coefficients-_IAT+Var_Base + (8 * 10)]
				fmul	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 9)]
				fxch	st1
				fmul	st2,st0
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 9)]
				fxch	st3
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 8)]
				faddp	st2,st0
				fxch	st1
				faddp	st2,st0
				faddp	st1,st0
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 4)]
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 5)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 3)]
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 4)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 2)]
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 3)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 1)]
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 2)]
				fld	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem]
				fstp	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem + (8 * 1)]
				fst	qword [ebp + TSM_SEQUENCE.Formant_Tmp_Mem]
				fstp	dword [ebp + TSM_SEQUENCE.Sound_Datas]
TSM_No_Process_Filters:		pop	ecx
				add	ebp,TSM_SEQUENCE_SIZE
				dec	ecx
				jnz	TSM_Set_Song_Instruments
				; ----------------------------------
				; Split stereo signal now
				xor	edx,edx
				mov	ebp,[TSM_Sequences_Dats-_IAT+Var_Base]
				mov	ecx,8
TSM_Process_Effects:		push	edx
				push	ecx
				fld1
				fsub	dword [ebp + TSM_SEQUENCE.Pan]
				fsqrt
				fmul	dword [ebp+TSM_SEQUENCE.Sound_Datas]
				; Store left signal
				test	edx,edx
				jz	TSM_Set_Left_Channel
				fadd	dword [edi]
TSM_Set_Left_Channel:		fstp	dword [edi]
				fld	dword [ebp + TSM_SEQUENCE.Pan]
				fsqrt
				fmul	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				; Store right signal
				test	edx,edx
				jz	TSM_Set_Right_Channel
				fadd	dword [edi + 4]
TSM_Set_Right_Channel:		fstp	dword [edi + 4]
				; ----------------------------------
				; Process delay if necessary
				mov	edx,[ebp + TSM_SEQUENCE.Current_Sequence]
				test	edx,edx
				jz	TSM_No_Delay_Dsp
				mov	esi,[TSM_Cur_Play_Pos-_IAT+Var_Base]
				mov	bl,byte [edx + esi + TSM_SEQUENCE_DAT.Dsp]
				cmp	bl,TSM_DSP_DELAY
				jne	TSM_No_Delay_Dsp

				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas3]
				push	eax
				fild	dword [esp]
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [esp]

				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas2]
				push	eax
				fild	dword [esp]
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [esp]

				movzx	eax,byte [edx + esi + TSM_SEQUENCE_DAT.DspDatas1]
				push	eax
				fild	dword [esp]
				fmul	dword [TSM_Flt001-_IAT+Var_Base]
				fstp	dword [esp]

				push	ebp
				call	TSM_Set_Delay
TSM_No_Delay_Dsp:		mov	eax,[ebp + TSM_SEQUENCE.Delay_Value]
				test	eax,eax
				jz	TSM_No_Delay
				mov	eax,[ebp + TSM_SEQUENCE.Delay_Cursor]
				mov	ebx,[ebp + TSM_SEQUENCE.Delay_Left_Buffer]
				mov	ecx,edi
				fld	dword [ebx + eax * 4]
				fadd	dword [ecx]
				fstp	dword [ecx]
				add	ecx,4
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fadd	dword [ebx + eax * 4]
				fmul	dword [ebp + TSM_SEQUENCE.Delay_Left_FeedBack_Value]
				fstp	dword [ebx + eax * 4]
				mov	eax,[ebp + TSM_SEQUENCE.Delay_Cursor]
				mov	ebx,[ebp + TSM_SEQUENCE.Delay_Right_Buffer]
				fld	dword [ebx + eax * 4]
				fadd	dword [ecx]
				fstp	dword [ecx]
				fld	dword [ebp + TSM_SEQUENCE.Sound_Datas]
				fadd	dword [ebx + eax * 4]
				fmul	dword [ebp + TSM_SEQUENCE.Delay_Right_FeedBack_Value]
				fstp	dword [ebx + eax * 4]
				inc	dword [ebp + TSM_SEQUENCE.Delay_Cursor]
				mov	eax,[ebp + TSM_SEQUENCE.Delay_Value]
				cmp	[ebp + TSM_SEQUENCE.Delay_Cursor],eax
				jl	TSM_No_Delay
				mov	dword [ebp + TSM_SEQUENCE.Delay_Cursor],0
TSM_No_Delay:			pop	ecx
				pop	edx
				mov	edx,1
				add	ebp,TSM_SEQUENCE_SIZE
				dec	ecx
				jnz	TSM_Process_Effects
				add	edi,8
				pop	edx
				dec	edx
				jmp	TSM_Mix_Loop
TSM_End_Mix_Loop:		pop	edi
				; ----------------------------------
				; Final mixing and conversion into 16 bits output
				mov	edx,[TSM_BufferSize-_IAT+Var_Base]
				shr	edx,1
				mov	esi,[TSM_Mixing_Buffer_Stereo-_IAT+Var_Base]
TSM_Final_Mix_Loop:		test	edx,edx
				jz	TSM_End_Final_Mix_Loop
				lodsd
				mov	[TSM_Final_Signal-_IAT+Var_Base],eax
				; Clip sample
				fld	dword [TSM_Final_Signal-_IAT+Var_Base]
				fld1
				fcom	st1
				fnstsw	ax
				sahf
				jae	TSM_Min_Value
				fst	dword [TSM_Final_Signal-_IAT+Var_Base]
TSM_Min_Value:			fstp	st0
				fstp	st0
				fld	dword [TSM_Final_Signal-_IAT+Var_Base]
				fld	dword [TSM_Fltm1-_IAT+Var_Base]
				fcom	st1
				fnstsw	ax
				sahf
				jbe	TSM_Max_Value
				fst	dword [TSM_Final_Signal-_IAT+Var_Base]
TSM_Max_Value:			fstp	st0
				fstp	st0
				fld	dword [TSM_Final_Signal-_IAT+Var_Base]
				fmul	dword [TSM_Flt32767-_IAT+Var_Base]		; Sign the sample
				fistp	dword [TSM_Final_Signal-_IAT+Var_Base]
				fstp	st0
				mov	eax,[TSM_Final_Signal-_IAT+Var_Base]
				stosw
				dec	edx
				jmp	TSM_Final_Mix_Loop
TSM_End_Final_Mix_Loop:		pop	ebp
				ret

; ------------------------------------------------------
; Name: TSM_Get_Instrument_Dat()
; Desc: Retrieve the address of an instrument
;       eax = TSM_Cur_Instrument
;       ecx = TSM_Instr_Number
TSM_Get_Instrument_Dat:		test	eax,eax
				jz	TSM_Return_Dat
				push	ebx
				mov	ebx,[eax + 4]
				cmp	ecx,ebx
				jl	TSM_Max_Comb
				pop	ebx
				xor	eax,eax
				ret
TSM_Max_Comb:			imul	ebx,ecx,TSM_INSTRUMENT_DAT_SIZE
				mov	eax,[eax]
				add	eax,ebx			; Offset to instrument's datas
				pop	ebx
TSM_Return_Dat:			ret

; ------------------------------------------------------
; Name: TSM_Wave_WhiteNoise()
; Desc: Produce a whitenoise
TSM_Wave_WhiteNoise:		mov	eax,[TSM_Random_Seed-_IAT+Var_Base]
				inc	eax
				imul	eax,01df5d45h
				mov	[TSM_Random_Seed-_IAT+Var_Base],eax
				and	eax,0ffffh
				sub	eax,08000h
				push	eax
				fild	dword [esp]
				pop	eax
				fdiv	dword [TSM_Flt32768-_IAT+Var_Base]
				ret

; ------------------------------------------------------
; Name: TSM_Get_Mix_Buffer_Len()
; Desc: Convert a given BPM into ticks
;       ecx = TSM_BPM
TSM_Get_Mix_Buffer_Len:		push	ebx
				push	edx
				mov	eax,44100
				mov	ebx,10
				imul	eax,ebx
				xor	edx,edx
				test	ecx,ecx
				jz	TSM_ZeroBPM
				idiv	ecx
TSM_ZeroBPM:			shr	eax,2
				pop	edx
				pop	ebx
				ret

; ------------------------------------------------------
; Name: TSM_Set_Delay()
; Desc: Set the delay effect values
TSM_SET_DELAY_SEQUENCE		equ	8
TSM_SET_DELAY_DISTANCE		equ	0xc
TSM_SET_DELAY_FEEDBACK		equ	0x10
TSM_SET_DELAY_PAN		equ	0x14
TSM_Set_Delay:			push	ebp
				mov	ebp,esp
				mov	eax,[ebp + TSM_SET_DELAY_SEQUENCE]
				fld	dword [ebp + TSM_SET_DELAY_DISTANCE]
				fimul	dword [TSM_Max_Buffer-_IAT+Var_Base]
				fistp	dword [eax + TSM_SEQUENCE.Delay_Value]
				fld1
				fsub	dword [ebp + TSM_SET_DELAY_PAN]
				fsqrt
				fmul	dword [ebp + TSM_SET_DELAY_FEEDBACK]
				fstp	dword [eax + TSM_SEQUENCE.Delay_Left_FeedBack_Value]
				fld	dword [ebp + TSM_SET_DELAY_PAN]
				fsqrt
				fmul	dword [ebp + TSM_SET_DELAY_FEEDBACK]
				fstp	dword [eax + TSM_SEQUENCE.Delay_Right_FeedBack_Value]
				leave
				ret	0x10

; ------------------------------------------------------
; Name: TSM_Clamp_Value()
; Desc: Clamp the a value between [0..1] 
TSM_Clamp_Value:		fcom	dword [TSM_Flt1-_IAT+Var_Base]
				fnstsw	ax
				sahf
				jb	TSM_Clamp_Volume_Max
				fstp	st0
				fld1
TSM_Clamp_Volume_Max:		ftst
				fnstsw	ax
				sahf
				ja	TSM_Clamp_Volume_Min
				fsub	st0,st0
TSM_Clamp_Volume_Min:		ret

end