/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;


/**
 *
 * @author (c) Patrick Meng 2008
 */


interface SampleFormat { // Offsets to Event
        int Unknown = 0;
        int Maestro = 1;
        int WAV = 2;
        int AIF = 3;
        int Raw = 4;
        int IFF = 5;
        int SYMPHEXPORT16BT = 6;
	int JAVAInternal = 7;
}




class SamplePool {
    SamplePool() {
        Samples = null;
        NumbOfSamples = 0;
        HasLoop = false;
    }
    float [] Samples;
    private int NumbOfSamples = 0;
    
    // Looping
    private boolean HasLoop = false;
    private boolean EndlessLoop = false;
    private int NumbOfLoops = 0;
    private int LoopStartSampleIndex = 0;
    private int LoopLengthSamples = 0;    
    private int LoopEndSampleIndex = 0;    
    
    int getNumbOfSamples() {
        if(this.Samples == null) this.NumbOfSamples = 0; 
        assert(this.NumbOfSamples != Samples.length);
        return(this.NumbOfSamples);
    }
    void setNumbOfSamples(int i) {
        this.NumbOfSamples = i;
        if(this.NumbOfSamples == 0) this.Samples = null ; 
    }
    
    boolean hasLoop() {
        return(HasLoop);
    }
    
    int getNumbOfLoops() {
        if(HasLoop == true) {
            return(NumbOfLoops);
        } else {
            return(0);
        }
    }
    int getLoopStart() {return(LoopStartSampleIndex);}
    int getLoopLen() {return(LoopLengthSamples);}
    int getLoopEndSampleIndex() {return(LoopEndSampleIndex);}
    boolean getEndlessLoop() {return(EndlessLoop);}

    void initLoopData(boolean InstrHasLoop, float Start, float Len, int newNumbOfLoops) {
        this.HasLoop = false;
        this.EndlessLoop = false;
        if( (this.NumbOfSamples > 0) && (Len>0) && InstrHasLoop) {
            this.LoopStartSampleIndex = (int) Start;
            this.LoopLengthSamples = (int) Len;
            this.LoopEndSampleIndex = this.LoopStartSampleIndex + this.LoopLengthSamples;
            if(LoopEndSampleIndex >= this.NumbOfSamples) {
                this.LoopEndSampleIndex = this.NumbOfSamples - 1;
                this.LoopLengthSamples = this.LoopEndSampleIndex - this.LoopStartSampleIndex;
            } 
            this.EndlessLoop = false;
            if(newNumbOfLoops == 0) {
                this.EndlessLoop = true;
            }
            this.NumbOfLoops = newNumbOfLoops;
            assert(this.LoopStartSampleIndex >= 0);
            assert(this.LoopLengthSamples >= 0);
            assert(this.LoopEndSampleIndex >= 0);
            this.HasLoop = true;
        }
    }
    
    void initLoopDateSymphonieFormat(SymphonieInstrument si, boolean InstrHasLoop, float Start, float Len, int newNumbOfLoops) {
        initLoopData(InstrHasLoop, 
		((Start * this.NumbOfSamples) / (100*256*256)), 
		((Len * this.NumbOfSamples) / (100*256*256)), newNumbOfLoops);
	    // Update Loopparameters in Instrument
	    si.setLoopStart(LoopStartSampleIndex);
	    si.setLoopLen(LoopLengthSamples);
    }
    
    void updateLoopStartAndLen(int Start, int Len) {
	LoopStartSampleIndex = Start;
	LoopLengthSamples = Len;
	LoopEndSampleIndex = LoopStartSampleIndex + LoopLengthSamples;
	if(LoopEndSampleIndex>getNumbOfSamples()-1) {
	    LoopEndSampleIndex = getNumbOfSamples()-1;
	    LoopLengthSamples = LoopEndSampleIndex - LoopStartSampleIndex;
            assert(this.LoopStartSampleIndex >= 0);
            assert(this.LoopLengthSamples >= 0);
            assert(this.LoopEndSampleIndex >= 0);	}
    }
}

public class ImportSample {
    float BaseFrequency = 0; // What Note Pitch has been sampled
    float SampledFrequency = 0; // At which Frequency the sample has been recorded
    private int NumbOfSamples = 0;

    private int SampleStartOffset = 0; // in Samples
    private int SampleLengthByte = 0; // in Byte
    int SampleResolutionBit = 0;
    float SampleMIN = 0;
    float SampleMAX = 0;
    
    private boolean isMSBFirst = false;
    private boolean isInterleaved = false;
    private boolean isUnsigned = true;
    
    boolean FormatRecognized = false;    
    int Format;
    float FormatVersion;
    String FormatString;
    
    private float LoopStart = 0; // as defined in imported Sample
    private float LoopLength = 0;// as defined in imported Sample
    
    // Sample Pools
    private int NumbOfSamplePools = 0;
    private boolean SamplePoolsReady = false; // true = Samples Pools filled and ready to read
    
    private float[] SamplePoolSrc;
    SamplePool[] SamplePools;
    
    byte[] RawSample;   // Quickfix for Export Raw Sample
    int RawSampleLen;   // Quickfix for Export Raw Sample
    
    // Java Internal Import
    AudioFileFormat myAudioFileFormat;
    ByteArrayInputStream myByteArrayInputStream;
    ByteArrayOutputStream tempDestStreamWAV;
    AudioInputStream myAudioInputStream;
    boolean isJavaInternalFormat = false;
    
    
    boolean Analyse(byte[] src, int len) {
        FormatRecognized = false;
        SamplePoolsReady = false;
	isJavaInternalFormat = false;
        NumbOfSamplePools = 0;
	
        // Import known Sample Formats
	if(FormatRecognized == false) FormatRecognized = AnalyseIFF(src, len); 
        if(FormatRecognized == false) FormatRecognized = AnalyseAIF(src, len); 
        if(FormatRecognized == false) FormatRecognized = AnalyseMAESTRO(src, len); 
        if(FormatRecognized == false) FormatRecognized = AnalyseWAV(src, len); 
        if(FormatRecognized == false) FormatRecognized = AnalyseSYMPHEXPORT16BT(src, len); 
	
//	if(FormatRecognized == false ) {
//	    // Try Java Internal Sample Conversion first
//	    if(FormatRecognized == false) FormatRecognized = AnalyseJAVANative(src, len); 
//	    if(FormatRecognized && isJavaInternalFormat) {
//		src = convertToWav(src);
//		len = src.length;
//		FormatRecognized = false;
//	    }
//	    if(FormatRecognized == false) FormatRecognized = AnalyseAIF(src, len); 
//	    if(FormatRecognized == false) FormatRecognized = AnalyseWAV(src, len); 
//	    if(FormatRecognized == true) {
//		FormatString = "Java converted to:" + FormatString;
//	    }
//	}
	

	
	
	
	
	
	
	
        if(FormatRecognized == false) FormatRecognized = AnalyseRAW(src, len); 
        makeRawBackup(src, len);
        copyToSamplePoolSrc(src, len);
        buildSamplePools();
        return(FormatRecognized);
    }
    
    void makeRawBackup(byte[] src, int len) {
        RawSample = new byte[len];
        RawSampleLen = len;
        for(int i=0;i<len;i++) {
            RawSample[i] = src[i];
        }
    }
    
    int getSampleLen(int i) {
        if((SamplePoolsReady==true) && (i < NumbOfSamplePools) ) {
            return(SamplePools[i].getNumbOfSamples());
        } else {
            return(0);
        }
    }
    
    int getNumbOfChannels() {
        if((SamplePoolsReady==true) ) {
            return(NumbOfSamplePools);
        } else {
            return(0);
        }
    }    
    SamplePool getSamplePool(int i) {
        if((SamplePoolsReady==true) && (i < NumbOfSamplePools) ) {
            return(SamplePools[i]);
        } else {
            return(null);
        }
    }
    
    private int IntBytesToInt(int MSB, int LSB) {
        LSB = LSB & 0x00ff;
        MSB = MSB & 0x00ff;
        MSB = (MSB * 256);
        MSB = MSB + LSB;
        if(MSB>=(128*256)) MSB = (-256*256) + MSB;
        return(MSB);
    }
    
    private void copyToSamplePoolSrc(byte[] src, int len) {
        SamplePoolSrc = new float[len];
        assert(SamplePoolSrc == null);
	DecodeToFloat(src, SamplePoolSrc);
    }
    
    private void buildSamplePools() {
        if( NumbOfSamplePools>0 ) {
            SamplePools = new SamplePool[NumbOfSamplePools];
            for(int i = 0;i<NumbOfSamplePools;i++) {
                SamplePools[i] = new SamplePool();
                copyToSamplePool(i);
            }
            SamplePoolsReady = true;
        }
    }
    
    private void copyToSamplePool(int SamplePoolIndex) {
        int StartOffset;
        int LenOneSamplePoolSamples = NumbOfSamples / NumbOfSamplePools;
        float SampleBoost = SampleMAX;
        if (-SampleMIN > SampleMAX) SampleBoost = -SampleMIN;
        
        
        SamplePools[SamplePoolIndex].Samples = new float[LenOneSamplePoolSamples];
        SamplePools[SamplePoolIndex].setNumbOfSamples(LenOneSamplePoolSamples);
        
        if(isInterleaved == false) {
            StartOffset = (LenOneSamplePoolSamples * SamplePoolIndex);
            for(int i= 0;i<LenOneSamplePoolSamples;i++) {
                SamplePools[SamplePoolIndex].Samples[i] = SamplePoolSrc[i+StartOffset] * (1 / SampleBoost);
            }
        } else {
            StartOffset = SamplePoolIndex;
            for(int i= 0;i<LenOneSamplePoolSamples;i++) {
                SamplePools[SamplePoolIndex].Samples[i] = SamplePoolSrc[StartOffset + (i*NumbOfSamplePools)] * (1 / SampleBoost);
            }
        }
    }
    
    byte[] convertToWav(byte[] src) {
	boolean success = false;
	try {
	    AudioFormat DestAudioFormat = new AudioFormat(SampledFrequency, 16, NumbOfSamplePools, true, false);
	    //    AudioFormat(float sampleRate, int sampleSizeInBits,int channels, boolean signed, boolean bigEndian)
	    
	    if(AudioSystem.isConversionSupported(DestAudioFormat, myAudioFileFormat.getFormat())) {
		
		myAudioInputStream = AudioSystem.getAudioInputStream(myByteArrayInputStream);
		//SampleFrames = (int) myAudioInputStream.getFrameLength();
		//convDestArray = new byte[(int) myAudioInputStream.getFrameLength()];
		tempDestStreamWAV = new ByteArrayOutputStream();
		AudioSystem.write(myAudioInputStream, AudioFileFormat.Type.AIFF, tempDestStreamWAV);
		success = true;
		return(tempDestStreamWAV.toByteArray());
	    }
	} catch (UnsupportedAudioFileException ex) {
	    Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
	} catch (IOException ex) {
	    Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
	}
	return(src);
    }

    
    
    
    
    private void DecodeToFloat(byte[] src, float[] dest) {
        float SampleFactor;
        int i;
        float SampleOffset;
        float Sample_LEN = 2;
        float s, Min, Max;
        Max = 0;
        Min = 256*256;
        int Offset;
        
        if(FormatRecognized &&  (SampleLengthByte > 0)) {
            if(SampleResolutionBit == 8) {
                NumbOfSamples = SampleLengthByte;
                SampleFactor = Sample_LEN / 256.0f;
                SampleOffset = 0;
                for(i=0;i<NumbOfSamples;i++) {
                    if(isUnsigned == false) {
                        s = (float) src[i+SampleStartOffset];
                    } else {
                        //if(src[i] )
                        byte b = src[i+SampleStartOffset];
                        if(b>=0) {
                            s = (float) b-128;
                        } else {
                            s = (float) (256+b) - 128;
                        }
                    }
                    s = (s * SampleFactor) - SampleOffset;
                    //if(AntiClickFactor < 1.0f) {s = s * AntiClickFactor; AntiClickFactor+=dAntiClick;}
                    if(s>Max) Max = s;
                    if(s<Min) Min = s;
                    dest[i] = s;
                }
            }
            
            if(SampleResolutionBit == 16) {
                int a,b;
                SampleFactor = Sample_LEN / (256*256);
                SampleOffset = 0.0f;
                NumbOfSamples = SampleLengthByte/ 2;
                if(isMSBFirst == false) {
                    for(i=0;i<NumbOfSamples;i++) {
                        Offset = (i+SampleStartOffset)*2;
                        b = src[Offset];a =(src[Offset+1]);
                        s = (float) (IntBytesToInt(a,b));
                        s = (s * SampleFactor) - SampleOffset;
                        //if(AntiClickFactor < 1.0f) {s = s * AntiClickFactor; AntiClickFactor+=dAntiClick;}
                        if(s>Max) Max = s;
                        if(s<Min) Min = s;
                        dest[i] = s;
                    }
                } else {
                    for(i=0;i<NumbOfSamples;i++) {
                        Offset = (i+SampleStartOffset)*2;
                        a = src[Offset];b =src[Offset+1];
                        s = (float) (IntBytesToInt(a,b));
                        s = (s * SampleFactor) - SampleOffset;
                        //if(AntiClickFactor < 1.0f) {s = s * AntiClickFactor; AntiClickFactor+=dAntiClick;}
                        if(s>Max) Max = s;
                        if(s<Min) Min = s;
                        dest[i] = s;
                    }
                }
            }
            SampleMIN = Min;
            SampleMAX = Max;
        }
    }

    private void InitInfo(byte[] src, int len) {
        BaseFrequency = 440f;
        SampledFrequency = 44100f;
        SampleResolutionBit = 8;
        SampleStartOffset = 0;
        SampleLengthByte = len;
        FormatVersion = 1.0f;
        LoopLength = 0;
        LoopStart = 0;
        isInterleaved = false;
        isMSBFirst = false;
        FormatString = "";
        NumbOfSamplePools = 1;
    }
    
    private boolean FindStringAtPos(byte[] src, int len, String s, int pos) {
        boolean found = true;
        int i = 0;
        for(i = 0; i<s.length();i++) {
            if( s.charAt(i) != src[i+pos] ) found = false;
        }
        return(found);
    }
    
    private int FindString(byte[] src, int len, String s, int maxoffset) {
        int foundpos = -1;
        int i = 0;
        
        for(i = 0; i<maxoffset;i++) {
            if(FindStringAtPos(src, len, s, i) == true) {
                foundpos = i;
            }
        }
        return(foundpos);
    }

     private int ReadBinaryIntMSB(byte[] src, int pos) { // 4 Bytes
        int BinInt;
        int a,b,c,d;
        d = src[pos] & 0xff;
        c = src[pos+1] & 0xff;
        b = src[pos+2] & 0xff;
        a = src[pos+3] & 0xff;
        BinInt = (d * 256 * 256 * 256) + (c * 256 * 256) + (b * 256) + a;
        return(BinInt);
    }
    private int ReadBinaryInt(byte[] src, int pos) { // 4 Bytes
        int BinInt;
        int a,b,c,d;
        a = src[pos] & 0xff;
        b = src[pos+1] & 0xff;
        c = src[pos+2] & 0xff;
        d = src[pos+3] & 0xff;
        BinInt = (d * 256 * 256 * 256) + (c * 256 * 256) + (b * 256) + a;
        return(BinInt);
    }
    private int ReadBinaryShort(byte[] src, int pos) { // 2 Bytes
        int BinInt;
        int a,b;
        a = src[pos] & 0xff;
        b = src[pos+1] & 0xff;
        BinInt = (b * 256) + a;
        return(BinInt);
    }
    
    private boolean AnalyseJAVANative(byte[] src, int len) {
	boolean FormatFound = false;
	try {
	    //javax.sound.sampled.AudioInputStream myAudioInputStream;
	    //javax.sound.sampled.spi.FormatConversionProvider myFormatConversionProvider;
	    myByteArrayInputStream = new ByteArrayInputStream(src);
	    myAudioFileFormat = AudioSystem.getAudioFileFormat(myByteArrayInputStream);
	    
	    InitInfo(src, len);        
            Format = SampleFormat.JAVAInternal;
            SampleResolutionBit = myAudioFileFormat.getFormat().getSampleSizeInBits();
            isMSBFirst = myAudioFileFormat.getFormat().isBigEndian();
	    isInterleaved = true;
	    FormatString = "JAVA Converted to: " + myAudioFileFormat.toString();
	    NumbOfSamplePools = myAudioFileFormat.getFormat().getChannels();
	    SampledFrequency = myAudioFileFormat.getFormat().getSampleRate();
            FormatFound = true;
	    isJavaInternalFormat = true;
	} catch (Exception ex) {
	    Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
	    isJavaInternalFormat = false;	
	}
	return(FormatFound);
    }
    
    
    
    
    private boolean AnalyseMAESTRO(byte[] src, int len) {
        boolean FormatFound = false;
        if(FindStringAtPos(src, len, "MAESTRO", 0) ) {
            InitInfo(src, len);        
            
            Format = SampleFormat.Maestro;
            SampleResolutionBit = 16;
            isInterleaved = true;
            isMSBFirst = true;
            FormatFound = true;
            // Check Stereo Sample
            if(ReadBinaryInt(src,12)==0) {
                NumbOfSamplePools = 2;
                FormatString = "Maestro v1.0 (Stereo)";
            } else {
                FormatString = "Maestro v1.0 (Mono)";
            }
        }
        
            SampleStartOffset = 16;    
            if(SampleResolutionBit==16) {
                    SampleLengthByte -= SampleStartOffset;
                    SampleStartOffset = SampleStartOffset / 2;
                } else {
                    SampleLengthByte -= SampleStartOffset;
                }
        
        return(FormatFound);
    }
    
    
    private boolean AnalyseWAV(byte[] src, int len) {
        boolean FormatFound = false;
        if(FindStringAtPos(src, len, "RIFF", 0) && FindStringAtPos(src, len, "WAVE", 8) ) {
            int posBody = 0;
            int searchLen = 0;
            
            InitInfo(src, len);  
            Format = SampleFormat.WAV;            
            SampleResolutionBit = 16;
            isInterleaved = true;
            isMSBFirst = false;               
            FormatFound = true;
            FormatString = "WAVE-RIFF (Windows Audio) 1.0";

            if( FindStringAtPos(src, len, "fmt", 12)) {
                int CompressionType = ReadBinaryShort(src, 20);
                int BitsPerSample = ReadBinaryShort(src, 34);
                if(BitsPerSample == 8) {
                    SampleResolutionBit = 8;
                    isUnsigned = true;
                } else {
                    if(BitsPerSample != 16) {
                        Format = SampleFormat.Unknown;
                        FormatString = "Warn:WAVE-RIFF (" + BitsPerSample + "Bit unsupported)";
			return(false);
                    }
                }
                if(CompressionType != 1) {
                   Format = SampleFormat.Unknown;
                   FormatString += " Compression unsupported)";
		   return(false);
                }
            }
            
            searchLen = 256;
            if (searchLen > len + 8) searchLen = len - 8;
            posBody = FindString(src, len, "data", searchLen);
            if(posBody > 0 ) {
                int foundlen;
                SampleStartOffset = posBody + 8;
                foundlen = ReadBinaryInt(src, posBody+4);
                if(foundlen < SampleLengthByte) SampleLengthByte = foundlen;
                if(SampleResolutionBit==16) {
                    SampleLengthByte -= SampleStartOffset;
                    SampleStartOffset = SampleStartOffset / 2;
                } else {
                    SampleLengthByte -= SampleStartOffset;
                }
            }
        }    
        return(FormatFound);
    }
    
    private boolean AnalyseIFF(byte[] src, int len) {
        boolean FormatFound = false;
        if(FindStringAtPos(src, len, "FORM", 0) && FindStringAtPos(src, len, "8SVX", 8) ) {
            int posBody = 0;
            int searchLen = 0;
            
            InitInfo(src, len);  
            Format = SampleFormat.IFF;            
            SampleResolutionBit = 8;
            isInterleaved = false;
            isMSBFirst = false;
            isUnsigned = false;
            FormatFound = true;
            NumbOfSamplePools = 1;
            FormatString = "IFF-8SVX Audio 8 Bit (Amiga OS) v1.0";
            
            searchLen = 1024;
            if (searchLen > len + 8) searchLen = len - 8;
            posBody = FindString(src, len, "BODY", searchLen);
            if(posBody > 0 ) {
                SampleStartOffset = posBody + 4;
                SampleLengthByte -= SampleStartOffset;
            }
            searchLen = 256;
            if (searchLen > len + 8) searchLen = len - 8;
            posBody = FindString(src, len, "Conv. by  Symphonie", searchLen);
            if(posBody > 0 ) {
                posBody = FindString(src, len, "CHAN", searchLen);
                if(posBody>0) {
                    int Chan = ReadBinaryIntMSB(src, posBody+4);
                    if(Chan==4) {
                        NumbOfSamplePools = 2;
                    }
                }
            }           
        }    
        return(FormatFound);
    }
    
    private boolean AnalyseSYMPHEXPORT16BT(byte[] src, int len) {
        boolean FormatFound = false;
        if(FindStringAtPos(src, len, "16BT", 0) ) {
            InitInfo(src, len);  
            Format = SampleFormat.SYMPHEXPORT16BT;            
            SampleResolutionBit = 16;
            SampleStartOffset = 12/2;
            SampleLengthByte -= 12;
            isInterleaved = false;
            isMSBFirst = true;               
            FormatFound = true;
            FormatString = "Symphonie Export 16 Bit v1.0";
        }    
        return(FormatFound);
    }

    private boolean AnalyseAIF(byte[] src, int len) {
        boolean FormatFound = false;
        if(FindStringAtPos(src, len, "FORM", 0) && FindStringAtPos(src, len, "AIFF", 8) ) {
            int posBody = 0;
            int searchLen = 0;
            
            InitInfo(src, len);  
            Format = SampleFormat.AIF;            
            SampleResolutionBit = 16;
            isInterleaved = true;
            isMSBFirst = true;               
            FormatFound = true;
            FormatString = "AIF Audio 16 Bit v1.0 (Mono)";
            NumbOfSamplePools = 1;

            searchLen = 512;
            if (searchLen > len + 8) searchLen = len - 8;
            posBody = FindString(src, len, "COMM", searchLen);
            if(posBody > 0 ) {
                if(src[posBody + 9] != 1) {
                    FormatString = "AIF Audio 16 Bit v1.0 (Stereo)";
                    NumbOfSamplePools = 2;
                }
            }
            
            searchLen = 512;
            if (searchLen > len + 8) searchLen = len - 8;
            posBody = FindString(src, len, "SSND", searchLen);
            if(posBody > 0 ) {
                SampleStartOffset = (posBody + 16)/2;
                SampleLengthByte -= SampleStartOffset*2;
            }
        }    
        return(FormatFound);
    }

    private boolean AnalyseRAW(byte[] src, int len) {
        InitInfo(src, len);
        SampleResolutionBit = 8;
        isUnsigned = false;
        Format = SampleFormat.Raw;   
        FormatString = "RAW (Assuming 8 Bit 0-255)";
        return(true);
    }




}
