/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import symreader.SampleFilter;
import symreader.SymphonieInstrument;
import symreader.VoiceLFO;
import symreader.VoiceSmoother;

class Voice {
    boolean inUse = false;
    boolean Mute = false;
    double MixFrequency;
    float MixVolume = 1.0f;
    float ChannelVolume = 0.0f;
    private double PlayFrequency = 440.0;
    float SourceFrequency = 44100.0f;
    double SamplePtr = 0.0;
    private int NumbOfLoopsRemaining = 0;
    float LastSample = 0.0f;
    boolean isPausing = false;
    SymphonieInstrument si;
    int LastInstrumentIDPlayed = -1;
    VoiceLFO LFOChannelVol;
    VoiceLFO LFOPitch;
    VoiceLFO LFOSample;
    SampleFilter Filter;
    boolean FilterActiva = false;
    VoiceSmoother Smoother;
    private boolean PanningActive = false;
    private float PanningX = 0.0f;
    private float PanningY = 0.0f;
    private float PanningZ = 0.0f;
    float SampleR = 0.0f;

    Voice(int myMixFrequency) {
        this.MixFrequency = myMixFrequency;
        this.LFOChannelVol = new VoiceLFO(0.0, 100.0);
        this.LFOPitch = new VoiceLFO(0.0, 10000.0);
        this.LFOSample = new VoiceLFO(0.0, 255.0);
        this.Smoother = new VoiceSmoother();
        this.Filter = new SampleFilter();
        this.Filter.init(0, 0.0, 0.0, (float)this.MixFrequency);
        this.setMute(false);
        this.LastInstrumentIDPlayed = -1;
    }

    void setPanningX(float PositionLR) {
        this.PanningX = PositionLR;
    }

    void setPanningX(SymphonieInstrument si) {
        if (si != null) {
            this.PanningActive = si.PanningActive;
            this.PanningX = si.PanningX;
        } else {
            this.PanningActive = false;
        }
    }

    void activatePanning(boolean b) {
        this.PanningActive = b;
    }

    boolean checkPanningActive() {
        return this.PanningActive;
    }

    float getPanningX() {
        if (this.PanningActive) {
            return this.PanningX;
        }
        return 0.0f;
    }

    void setMixFrequency(double myMixFrequency) {
        this.MixFrequency = myMixFrequency;
    }

    int getLastInstrIdPlayed() {
        return this.LastInstrumentIDPlayed;
    }

    void processAllLFOs() {
        if (this.LFOChannelVol.isRunning()) {
            this.ChannelVolume = (float)this.LFOChannelVol.applyToValue(this.ChannelVolume);
        }
        if (this.LFOPitch.isRunning()) {
            this.PlayFrequency = this.LFOPitch.applyToValue(this.PlayFrequency);
        }
    }

    void setMute(boolean b) {
        this.Mute = b;
    }

    boolean getMute() {
        return this.Mute;
    }

    void toogleMute() {
        this.Mute = !this.Mute;
    }

    void pausePlaying() {
        this.isPausing = true;
    }

    void continuePlaying() {
        this.isPausing = false;
    }

    void setNumbOfLoopsRemaining(int NumbOfLoops) {
        this.NumbOfLoopsRemaining = NumbOfLoops;
    }

    int getNumbOfLoopsRemaining() {
        return this.NumbOfLoopsRemaining;
    }

    void decNumbOfLoopsRemaining() {
        if (this.NumbOfLoopsRemaining > 0) {
            --this.NumbOfLoopsRemaining;
        }
    }

    int getSampleEndPtr() {
        return this.si.sp.getNumbOfSamples() - 1;
    }

    void setFreq(float f, boolean StopLFO) {
        this.PlayFrequency = f;
        if (StopLFO || f == 0.0f) {
            this.LFOPitch.stop();
        }
    }

    void setFreq(double f, boolean StopLFO) {
        this.PlayFrequency = f;
        if (StopLFO || f == 0.0) {
            this.LFOPitch.stop();
        }
    }

    double getFreq() {
        return this.PlayFrequency;
    }
}

