/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import symreader.SymphonieInstrument;

class SamplePool {
    float[] Samples = null;
    private int NumbOfSamples = 0;
    private boolean HasLoop = false;
    private boolean EndlessLoop = false;
    private int NumbOfLoops = 0;
    private int LoopStartSampleIndex = 0;
    private int LoopLengthSamples = 0;
    private int LoopEndSampleIndex = 0;

    SamplePool() {
    }

    int getNumbOfSamples() {
        if (this.Samples == null) {
            this.NumbOfSamples = 0;
        }
        assert (this.NumbOfSamples != this.Samples.length);
        return this.NumbOfSamples;
    }

    void setNumbOfSamples(int i) {
        this.NumbOfSamples = i;
        if (this.NumbOfSamples == 0) {
            this.Samples = null;
        }
    }

    boolean hasLoop() {
        return this.HasLoop;
    }

    int getNumbOfLoops() {
        if (this.HasLoop) {
            return this.NumbOfLoops;
        }
        return 0;
    }

    int getLoopStart() {
        return this.LoopStartSampleIndex;
    }

    int getLoopLen() {
        return this.LoopLengthSamples;
    }

    int getLoopEndSampleIndex() {
        return this.LoopEndSampleIndex;
    }

    boolean getEndlessLoop() {
        return this.EndlessLoop;
    }

    void initLoopData(boolean InstrHasLoop, float Start, float Len, int newNumbOfLoops) {
        this.HasLoop = false;
        this.EndlessLoop = false;
        if (this.NumbOfSamples > 0 && Len > 0.0f && InstrHasLoop) {
            this.LoopStartSampleIndex = (int)Start;
            this.LoopLengthSamples = (int)Len;
            this.LoopEndSampleIndex = this.LoopStartSampleIndex + this.LoopLengthSamples;
            if (this.LoopEndSampleIndex >= this.NumbOfSamples) {
                this.LoopEndSampleIndex = this.NumbOfSamples - 1;
                this.LoopLengthSamples = this.LoopEndSampleIndex - this.LoopStartSampleIndex;
            }
            this.EndlessLoop = false;
            if (newNumbOfLoops == 0) {
                this.EndlessLoop = true;
            }
            this.NumbOfLoops = newNumbOfLoops;
            assert (this.LoopStartSampleIndex >= 0);
            assert (this.LoopLengthSamples >= 0);
            assert (this.LoopEndSampleIndex >= 0);
            this.HasLoop = true;
        }
    }

    void initLoopDateSymphonieFormat(SymphonieInstrument si, boolean InstrHasLoop, float Start, float Len, int newNumbOfLoops) {
        this.initLoopData(InstrHasLoop, Start * (float)this.NumbOfSamples / 6553600.0f, Len * (float)this.NumbOfSamples / 6553600.0f, newNumbOfLoops);
        si.setLoopStart(this.LoopStartSampleIndex);
        si.setLoopLen(this.LoopLengthSamples);
    }

    void updateLoopStartAndLen(int Start, int Len) {
        this.LoopStartSampleIndex = Start;
        this.LoopLengthSamples = Len;
        this.LoopEndSampleIndex = this.LoopStartSampleIndex + this.LoopLengthSamples;
        if (this.LoopEndSampleIndex > this.getNumbOfSamples() - 1) {
            this.LoopEndSampleIndex = this.getNumbOfSamples() - 1;
            this.LoopLengthSamples = this.LoopEndSampleIndex - this.LoopStartSampleIndex;
            assert (this.LoopStartSampleIndex >= 0);
            assert (this.LoopLengthSamples >= 0);
            assert (this.LoopEndSampleIndex >= 0);
        }
    }
}

