/*
 * Decompiled with CFR 0.152.
 */
package symreader;

public class InterpolateSample {
    private int Type = 2;
    double bias = 0.0;
    double tension = 0.0;
    float y0;
    float y1;
    float y2;
    float y3;
    float mu;
    int ptr;
    float Sample;
    double a0;
    double a1;
    double a2;
    double a3;
    double m0;
    double m1;
    double mu2;
    double mu3;

    InterpolateSample() {
    }

    void setInterpolateType(int newType) {
        this.Type = newType;
        if (this.Type > 4) {
            this.Type = 4;
        }
    }

    float getSample(float[] Samples, float SamplePtr) {
        this.ptr = (int)SamplePtr;
        this.mu = SamplePtr - (float)this.ptr;
        switch (this.Type) {
            case 0: {
                return Samples[this.ptr];
            }
            case 1: {
                if (this.ptr + 1 <= Samples.length - 1) {
                    this.Sample = Samples[this.ptr + 1] * this.mu;
                    this.Sample += Samples[this.ptr] * (1.0f - this.mu);
                    return this.Sample;
                }
                return Samples[this.ptr];
            }
            case 2: {
                this.y1 = Samples[this.ptr];
                this.y2 = this.ptr < Samples.length - 1 ? Samples[this.ptr + 1] : Samples[this.ptr];
                this.y3 = this.ptr < Samples.length - 2 ? Samples[this.ptr + 2] : Samples[this.ptr];
                this.y0 = this.ptr > 0 ? Samples[this.ptr - 1] : Samples[0];
                return this.CubicInterpolate(this.y0, this.y1, this.y2, this.y3, this.mu);
            }
            case 3: {
                if (this.ptr + 1 <= Samples.length - 1) {
                    return this.CosineInterpolate(Samples[this.ptr], Samples[this.ptr + 1], this.mu);
                }
                return Samples[this.ptr];
            }
            case 4: {
                this.y1 = Samples[this.ptr];
                this.y2 = this.ptr < Samples.length - 1 ? Samples[this.ptr + 1] : Samples[this.ptr];
                this.y3 = this.ptr < Samples.length - 2 ? Samples[this.ptr + 2] : Samples[this.ptr];
                this.y0 = this.ptr > 0 ? Samples[this.ptr - 1] : Samples[0];
                return this.HermiteInterpolate(this.y0, this.y1, this.y2, this.y3, this.mu);
            }
        }
        return Samples[this.ptr];
    }

    private float CubicInterpolate(double y0, double y1, double y2, double y3, double mu) {
        this.mu2 = mu * mu;
        this.a0 = y3 - y2 - y0 + y1;
        this.a1 = y0 - y1 - this.a0;
        this.a2 = y2 - y0;
        this.a3 = y1;
        return (float)(this.a0 * mu * this.mu2 + this.a1 * this.mu2 + this.a2 * mu + this.a3);
    }

    float CosineInterpolate(double y1, double y2, double mu) {
        this.mu2 = (1.0 - Math.cos(mu * Math.PI)) / 2.0;
        return (float)(y1 * (1.0 - this.mu2) + y2 * this.mu2);
    }

    float HermiteInterpolate(double y0, double y1, double y2, double y3, double mu) {
        this.mu2 = mu * mu;
        this.mu3 = this.mu2 * mu;
        this.m0 = (y1 - y0) * (1.0 + this.bias) * (1.0 - this.tension) / 2.0;
        this.m0 += (y2 - y1) * (1.0 - this.bias) * (1.0 - this.tension) / 2.0;
        this.m1 = (y2 - y1) * (1.0 + this.bias) * (1.0 - this.tension) / 2.0;
        this.m1 += (y3 - y2) * (1.0 - this.bias) * (1.0 - this.tension) / 2.0;
        this.a0 = 2.0 * this.mu3 - 3.0 * this.mu2 + 1.0;
        this.a1 = this.mu3 - 2.0 * this.mu2 + mu;
        this.a2 = this.mu3 - this.mu2;
        this.a3 = -2.0 * this.mu3 + 3.0 * this.mu2;
        return (float)(this.a0 * y1 + this.a1 * this.m0 + this.a2 * this.m1 + this.a3 * y2);
    }
}

