//
// global.h
//

//#include "stdafx.h"

#ifndef RMT_GLOBAL_
#define RMT_GLOBAL_


char CharH4(unsigned char b) { BYTE i=b>>4; return ((BYTE)i+((i<10)? 48:55)); };
char CharL4(unsigned char b) { BYTE i=b&0x0f; return ((BYTE)i + ((i<10)? 48:55)); };

CDC* g_mem_dc;
CDC* g_gfx_dc;

//
int g_tracks4_8;
BOOL volatile g_screenupdate=0;
BOOL volatile g_invalidatebytimer=0;
int volatile g_screena;
int volatile g_screenwait;
BOOL volatile g_rmtroutine;
BOOL volatile g_timerroutineprocessed;

int volatile g_prove;		//testovaci hra bez editace (0=vyp,1=mono,2=stereo)
int volatile g_respectvolume;	//nemeni hlasitost pokud uz tam je

int g_activepart;			//0 info, 1 edittracks, 2 editinstruments, 3 song
int g_active_ti;			//1 tracks, 2 instrs

BOOL g_viewblocktoolbar=0;	//1 ano, 0 ne
BOOL g_viewanalyzer=1;		//1 ano, 0 ne
BOOL g_viewinstractivehelp=1;	//1 ano, 0 ne

CTrackClipboard g_trackcl;

CString g_prgpath;			//cesta do adresare odkud byl program spusten (vcetne lomitka na konci)

void TextXY(char *txt,int x,int y,int c=0)
{
	char a;
	c=c<<4;
	for(int i=0; a=(txt[i]); i++,x+=8)
		if (a!=32) g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,(a & 0x7f)<<3,c,SRCCOPY);
}

void TextXYSelN(char *txt,int n,int x,int y,int c=0)
{
	//znak indexu n bude mit "select" barvu, ostatni c
	char a;
	c=c<<4;
	for(int i=0; a=(txt[i]); i++,x+=8)
		g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,(a & 0x7f)<<3,(i==n)? 3*16:c,SRCCOPY);
	if (i==n) //prvni znak za koncem retezce
		g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,32<<3,3*16,SRCCOPY);
}

void TextXYCol(char *txt,int x,int y,char *col)
{
	char a;
	for(int i=0; a=(txt[i]); i++,x+=8)
		g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,(a & 0x7f)<<3,col[i]<<4,SRCCOPY);
}

void TextDownXY(char *txt,int x,int y,int c=0)
{
	char a;
	c=c<<4;
	for(int i=0; a=(txt[i]); i++,y+=16)
		g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,(a & 0x7f)<<3,c,SRCCOPY);
}

void NumberMiniXY(BYTE num,int x,int y,int c=0)
{
	c=112+(c<<3);
	g_mem_dc->BitBlt(x,y,8,8,g_gfx_dc,(num & 0xf0)>>1,c,SRCCOPY);
	g_mem_dc->BitBlt(x+8,y,8,8,g_gfx_dc,(num & 0x0f)<<3,c,SRCCOPY);
}

void TextMiniXY(char *txt,int x,int y,int c=0)
{
	char a;
	c=112+(c<<3);
	for(int i=0; a=(txt[i]); i++,x+=8)
		if (a!=32) g_mem_dc->BitBlt(x,y,8,8,g_gfx_dc,(a & 0x7f)<<3,c,SRCCOPY);
}

void IconMiniXY(int icon,int x,int y)
{
	static c=128-6;
	if (icon>=1 && icon<=4) g_mem_dc->BitBlt(x,y,32,6,g_gfx_dc,(icon-1) * 32,c,SRCCOPY);
}

int EditText(int vk,int shift,int control, char* txt,int& cur, int max)
{
	//vraci 1, pokud byl stisknut TAB nebo ENTER
	max--;
	if (vk==8) //VK_BACKSPACE
	{
		if (cur>0)
		{
			cur--;
			for(int j=cur; j<=max-1; j++) txt[j]=txt[j+1];
			txt[max]=' ';
			//if (cur==max) txt[cur]=' ';
			//txt[cur]=' ';
		}
	}
	else
	if (vk==VK_TAB || vk==13)		//VK_ENTER
	{
		return 1;
	}
	else
	if (vk==VK_INSERT)
	{
		for(int j=max-1; j>=cur; j--) txt[j+1]=txt[j];
		txt[cur]=' ';
	}
	else
	if (vk==VK_DELETE)
	{
		for(int j=cur; j<=max-1; j++) txt[j]=txt[j+1];
		txt[max]=' ';
	}
	else
	{
		if (shift) return 0;
		char a=0;
		if (vk>=65 && vk<=90) {	a = (control)? vk : vk+32; }		//pismena - velka pres Control
		else
		if (vk>=48 && vk<=57) { a = (control)? *(")!@#$%^&*("+vk-48): vk; }			//cislice - pres Control znaky pod nimi
		else
		if (vk==' ')			a = ' ';	//mezera
		else
		if (vk==189)	a= (control)? '_':'-';
		else
		if (vk==187)	a= (control)? '+':'=';
		else
		if (vk==219)	a='[';
		else
		if (vk==221)	a=']';
		else
		if (vk==186)	a= (control)? ':':';';
		else
		if (vk==222)	a= (control)? '"':'\'';
		else
		if (vk==188)	a= (control)? '<':',';
		else
		if (vk==190)	a= (control)? '>':'.';
		else
		if (vk==191)	a= (control)? '?':'/';
		else
		if (vk==220)	a= (control)? '|':'\\';
		else
		if (vk==VK_RIGHT)
		{
			if (cur<max) cur++;
		}
		else
		if (vk==VK_LEFT)
		{
			if (cur>0) cur--;
		}
		else
		if (vk==VK_HOME) cur=0;
		else
		if (vk==VK_END)
		{
			for(int j=max; j>=0 && (txt[j]==' '); j--);
			cur=(j<max)? j+1:max;
		}


		if (a>0)
		{
			for(int j=max-1; j>=cur; j--) txt[j+1]=txt[j];
			txt[cur]=a;
			if (cur<max) cur++;
		}
	}
	return 0;
}

/*
void ClearXY(int x,int y,int n)
{
	x<<=3; y<<=4;
	g_mem_dc->FillSolidRect(x,y,x+(n<<8),y+15,RGB(96,96,96));
}
*/

void WaitForTimerRoutineProcessed()
{
	g_timerroutineprocessed=0;
	while(!g_timerroutineprocessed) Sleep(1);		//ceka
}

extern unsigned char g_atarimem[65536];
extern void Memory_Init();
extern int GO(int goaddr,unsigned char A,unsigned char  X,unsigned char Y);
extern int LoadBinaryBlock(ifstream& in,unsigned char* memory,WORD& fromadr, WORD& toadr);
extern int LoadBinaryFile(char *fname, unsigned char *memory,WORD& minadr,WORD& maxadr);
extern int SaveBinaryBlock(ofstream& out,unsigned char* memory,WORD fromadr,WORD toadr,BOOL ffffhead);


int Atari_LoadRMTRoutines()
{
	//nacte rmt rutinu $3400, setnoteinstrvol $3d00, setvol $3e00
	WORD min,max;
	int r = LoadBinaryFile((char*)(LPCSTR)(g_prgpath+"rmt_ata.sys"),g_atarimem,min,max);
	return r;
}

int Atari_InitRMTRoutine()
{
	int r = GO(0x3400,0,0x00,0x3f);			//adr,A,X,Y
	return r;
}

void Atari_PlayRMT()
{
	//GO(0x3403,0,0,0);					//SetPokey + jeden prubeh RMT rutinou
	GO(0x3406,0,0,0);					//(bez SetPokey) jeden prubeh RMT rutinou, ale az od rmt_p3 (zpracovani obalek)
	GO(0x340c,0,0,0);					//SetPokey
	//prepis z g_atarimem do POKEYe
}

void Atari_Silence()
{
	GO(0x3409,0,0,0);
	//Silence rutina
}

void Atari_SetTrack_NoteInstrVolume(int t,int n,int i,int v)
{
	GO(0x3d00,n,t,i);		//adr, nota, track, instrument
	GO(0x3e00,v,t,0);		//adr, volume, track
}

void Atari_SetTrack_Volume(int t,int v)
{
	GO(0x3e00,v,t,0);		//adr, volume, track
}

void StrToAtariVideo(char* txt,int count)
{
	char a;
	for(int i=0; i<count; i++)
	{
		a=txt[i] & 0x7f;
		if (a<32) a=0;
		else
		if (a<96) a-=32;
		txt[i]=a;
	}
}

//----

const char keynotes[256]=
{
//0
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, 27, -1,
//50
	13, 15, -1, 18, 20, 22, -1, 25, -1, -1,
	-1, -1, -1, -1, -1, -1,  7,  4,  3, 16,
	-1,  6,  8, 24, 10, -1, 13, 11,  9, 26,
	28, 12, 17,  1, 19, 23,  5, 14,  2, 21,
	 0, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//100
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//150
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, 15, 30, 12, -1,
	14, 16, -1, -1, -1, -1, -1, -1, -1, -1,
//200
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, 29,
	-1, 31, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//250
	-1, -1, -1, -1, -1, -1
};

const char keynumbs[256]=
{
//0
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
//64
	-1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//128
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//192
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

const char keynumblock09[256]=
{
//0
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//64
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//128
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
//192
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};


char NoteKey(int vk)	{ return keynotes[vk]; };
char NumbKey(int vk)	{ return keynumbs[vk]; };
char Numblock09Key(int vk)	{ return keynumblock09[vk]; };

#endif