// RmtView.h : interface of the CRmtView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_RMTVIEW_H__1709C74D_06D0_11D7_BEB0_00600854AFCA__INCLUDED_)
#define AFX_RMTVIEW_H__1709C74D_06D0_11D7_BEB0_00600854AFCA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "r_music.h"


extern CDC* g_mem_dc;
extern CDC* g_gfx_dc;

extern int g_tracks4_8;

extern BOOL volatile g_screenupdate;
extern BOOL volatile g_invalidatebytimer;
extern int volatile g_screena;
extern int volatile g_screenwait;

extern int g_activepart;
extern int g_active_ti;	

extern BOOL volatile g_prove;
extern BOOL volatile g_respectvolume;

extern BOOL g_viewblocktoolbar;
extern BOOL g_viewanalyzer;
extern BOOL g_viewinstractivehelp;

extern void TextXY(char *txt,int x,int y,int c=0);

extern void Memory_Clear();
extern int Atari_LoadRMTRoutines();
extern int Atari_InitRMTRoutine();

extern char CharH4(unsigned char b);
extern char CharL4(unsigned char b);

extern char NoteKey(int vk);
extern char Numblock09Key(int vk);

extern unsigned char g_atarimem[65536];

extern CString g_prgpath;

extern CTrackClipboard g_trackcl;


class CRmtView : public CView
{
protected: // create from serialization only
	CRmtView();
	DECLARE_DYNCREATE(CRmtView)

// Attributes
public:
	CRmtDoc* GetDocument();

	BOOL DrawAll();
	void DrawAnalyzer();

	//my
	CBitmap m_mem_bitmap;
	CDC		m_mem_dc;
	CBitmap m_gfx_bitmap;
	CDC		m_gfx_dc;
	CPen*	m_pen1;
	CPen*	m_penorig;

	CSong	m_song;

	int m_shiftkey;
	int m_controlkey;

	UINT m_timeranalyzer;

// Operations
public:


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRmtView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CRmtView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CRmtView)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileNew();
	afx_msg void OnFileExportAs();
	afx_msg void OnInstrLoad();
	afx_msg void OnInstrSave();
	afx_msg void OnInstrCopy();
	afx_msg void OnInstrPaste();
	afx_msg void OnInstrCut();
	afx_msg void OnInstrDelete();
	afx_msg void OnTrackDelete();
	afx_msg void OnTrackCopy();
	afx_msg void OnTrackPaste();
	afx_msg void OnTrackCut();
	afx_msg void OnSongCopyline();
	afx_msg void OnSongPasteline();
	afx_msg void OnSongClearline();
	afx_msg void OnPlay1();
	afx_msg void OnPlay2();
	afx_msg void OnPlay3();
	afx_msg void OnPlaystop();
	afx_msg void OnPlayfollow();
	afx_msg void OnEmInfo();
	afx_msg void OnEmInstruments();
	afx_msg void OnEmSong();
	afx_msg void OnEmTracks();
	afx_msg void OnUpdateEmTracks(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEmInstruments(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEmInfo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEmSong(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePlayfollow(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePlay1(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePlay2(CCmdUI* pCmdUI);
	afx_msg void OnUpdatePlay3(CCmdUI* pCmdUI);
	afx_msg void OnProvemode();
	afx_msg void OnUpdateProvemode(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnViewVolumeanalyzer();
	afx_msg void OnUpdateViewVolumeanalyzer(CCmdUI* pCmdUI);
	afx_msg void OnViewInstrumentactivehelp();
	afx_msg void OnUpdateViewInstrumentactivehelp(CCmdUI* pCmdUI);
	afx_msg void OnViewBlocktoolbar();
	afx_msg void OnUpdateViewBlocktoolbar(CCmdUI* pCmdUI);
	afx_msg void OnBlockNoteup();
	afx_msg void OnUpdateBlockNoteup(CCmdUI* pCmdUI);
	afx_msg void OnBlockVolumedown();
	afx_msg void OnUpdateBlockVolumedown(CCmdUI* pCmdUI);
	afx_msg void OnBlockVolumeup();
	afx_msg void OnUpdateBlockVolumeup(CCmdUI* pCmdUI);
	afx_msg void OnBlockNotedown();
	afx_msg void OnUpdateBlockNotedown(CCmdUI* pCmdUI);
	afx_msg void OnBlockInstrleft();
	afx_msg void OnUpdateBlockInstrleft(CCmdUI* pCmdUI);
	afx_msg void OnBlockInstrright();
	afx_msg void OnUpdateBlockInstrright(CCmdUI* pCmdUI);
	afx_msg void OnBlockInstrall();
	afx_msg void OnUpdateBlockInstrall(CCmdUI* pCmdUI);
	afx_msg void OnBlockBackup();
	afx_msg void OnUpdateBlockBackup(CCmdUI* pCmdUI);
	afx_msg void OnBlockPlay();
	afx_msg void OnUpdateBlockPlay(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in RmtView.cpp
inline CRmtDoc* CRmtView::GetDocument()
   { return (CRmtDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_RMTVIEW_H__1709C74D_06D0_11D7_BEB0_00600854AFCA__INCLUDED_)
