***************************************************************************
*									  *
*		  P R O T R A C K E R	 4    S O U R C E		  *
*									  *
*               (c) 1994-1998 by Thomas "Dreamer" Beyer / Germany	  *
*									  *
*	Using this source code is allowed as long as the names of *all*   *
* 	developers are visible in the about requester  of the executable. *
***************************************************************************
*									  *
*                         Special note: 	                          *
*                         -------------					  *
*									  *
* This sourcecode is based on the V1.1 sources from Lars 'Zap' Hamre      *
* and resourced V3.15 code from Cryptoburners. Resourcing was needed      *
* due the fact cryptoburners don't answered any requests and     	  *
* the developing was stopped in early 1994.                               *
* The only 'official' rumour was that the 3.15 sources seems to be lost   *
* forever.                                                                *
*                                                                         *
***************************************************************************
* Language:               MC680X0 Ass, DevPac V3.14/AsmOne compatible	  *
* Machine:                Amiga PC					  *
* Development basics:     Amiga 4000/MC68030-50MHz/64MB RAM		  *
* Begin of code rev:  	  March 1989					  *
* Last revision date:     May 1998					  *
***************************************************************************
*      			PT used screens (bit)				  *
*	=> 1: mainscreen                   => 2: helpscreen		  *
*	=> 3: dirscreeen                   => 4: *** EMPTY *** 		  *
*	=> 5: setupscreen                  => 6: PLST			  *
*	=> 7: *** EMPTY *** (removed PED)  => 8: Info			  *
*	=> 9: Posed							  *
***************************************************************************

*  ---===*** compiling specific definitions ***===---
*********************************************************
packedpics = 0			; 1=uncrunched IFF GUI's, 0=FIMP crunched GUI's
highercpu  = 0			; 0=68000, 1=68020

* for Devpac Amiga Version 2 the following symbols were changed
* to avoid crashes with the new include files:


Revision:	macro
		dc.b	'4.02'
		endm

RevDate:	macro
		dc.b	'24.09.97'
		endm

VDate1:		equ	'05.0'
VDate2:		equ	'9.97'



*             ---===*** Macros ***===---
*********************************************************
	IFEQ	highercpu
		;opt	P=68000			; L-,O+      P=68030,I-      c+,d+
		;MC68000

CALL:		macro
		JSR	\1
		endm
GOTO:		macro
		JMP	\1
		endm

	ELSE
*-------------------------------------------------------*
		;opt	P=68020			;,I-,O-,o-
		;MC68020

CALL:		macro
		BSR.L	\1
		endm
GOTO:		macro
		BRA.L	\1
		endm
	ENDC

*-------------------------------------------------------*
chn8test:	macro
		btst	#5,Packetfield
		endm
checklmb:	macro
		BTST	#6,$00BFE001
		endm
checkrmb:	macro
		BTST	#2,POTINP
		endm
CALLSYS:	macro
		IFGT NARG-1
		   FAIL	!!!	CALLSYS MACRO - too much parameters !!!
		ENDC
		JSR	_LVO\1(A6)
		endm

Push:		macro
		ifc	"\1","All"
		movem.l	d0-a6,-(sp)
		else
		movem.l	\1,-(sp)
		endc
		endm
Pull:		macro
		ifc	"\1","All"
		movem.l	(sp)+,d0-a6
		else
		movem.l	(sp)+,\1
		endc
		endm

*********************************************************

LIB_OPEN2:	EQU	$FFFFFFFA
LIB_CLOSE2:	EQU	$FFFFFFF4

ds_Days:	EQU	$00
ds_Minute:	EQU	$04
ds_Tick:	EQU	$08

*********************************************************
MaxPattPos:	EQU	63
MaxSamLen:	EQU 	$0001FFFC		; 3.15=65534(FFFE),4.0=131068 samplelength
MaxInsNum:	EQU 	31			; max 32 samples

sd_sampleinfo:	EQU 	20			;first sample starts here
sd_numofpatt:	EQU 	MaxInsNum*30+20 	;number of patterns are stored here
sd_ntflag:	EQU 	MaxInsNum*30+20+1
sd_pattpos:	EQU 	MaxInsNum*30+20+2	;pattern positions table is here
sd_mahokakt:	EQU 	MaxInsNum*30+20+130	;"M.K." :)
sd_patterndata: EQU 	MaxInsNum*30+20+134	;first patterm starts at this position

n_note: 		EQU	0  ; W		    period
n_cmd:			EQU	2  ; W		    instr/cmd
n_cmdlo:		EQU	3  ; low B of cmd   CMD=parameter
n_start:		EQU	4  ; L		    address of sample
n_length:		EQU	8  ; W		    length of sample
n_loopstart:		EQU	10 ; L		    address of repeat
n_replen:		EQU	14 ; W
n_period:		EQU	16 ; W $10	    period to play
n_finetune:		EQU	18 ; B $12
n_volume:		EQU	19 ; B $13	    volume to set
n_dmabit:		EQU	20 ; W $14	    dmabit for channel
n_toneportdirec:	EQU	22 ; B $16
n_toneportspeed:	EQU	23 ; B $17
n_wantedperiod: 	EQU	24 ; W $18
n_vibratocmd:		EQU	26 ; B $1A
n_vibratopos:		EQU	27 ; B $1C
n_tremolocmd:		EQU	28 ; B
n_tremolopos:		EQU	29 ; B
n_wavecontrol:		EQU	30 ; B
n_glissfunk:		EQU	31 ; B
n_sampleoffset: 	EQU	32 ; B
n_pattpos:		EQU	33 ; B
n_loopcount:		EQU	34 ; B
n_funkoffset:		EQU	35 ; B
n_wavestart:		EQU	36 ; L
n_reallength:		EQU	40 ; W
n_trigger:		EQU	42 ; B	2A
n_SIZEOF		EQU	42
n_samplenum:		EQU	43 ; B	2B

*-------------------------------------------------------*
ScreenWidth:	EQU	40*2
ScreenHeight:	EQU	256
;PattBlkSize:	EQU	(ScreenWidth*694)

*********************************************************
*   pre-defined bitmap positions                        *
*********************************************************
ScopeBoxPos:	EQU	16
DirScreenPos:	EQU	16+24
OptionsPos:	EQU	16+24+3520	; Opt1-7
RequesterPos:	EQU	16+24+3520+464
RequesterPos1:	EQU	RequesterPos+1

UnderPartPos:	EQU	11040		; sampler, notescroller mainscreen (bottom)
VolBoxPos:	EQU	12409		; volumebox in sampler
Main2Plane:	EQU	20480

*********************************************************
*         Protracker customchip addresses               *
*********************************************************
BLTDDAT:		EQU	$DFF000
DMACONR:		EQU	$DFF002
VPOSR:			EQU	$DFF004 	; IN WAITFORVBLANK
VHPOSR: 		EQU	$DFF006
POTINP: 		EQU	$DFF016
INTENAR:		EQU	$DFF01C
INTREQR: 		EQU	$DFF01E
BLTCON0:		EQU	$DFF040
BLTCON1:		EQU	$DFF042
BLTAFWM:		EQU	$DFF044
BLTCPT: 		EQU	$DFF048
BLTAPT: 		EQU	$DFF050
BLTDPT: 		EQU	$DFF054
BLTSIZE:		EQU	$DFF058
BLTCMOD:		EQU	$DFF060
BLTBMOD:		EQU	$DFF062
BLTAMOD:		EQU	$DFF064
BLTDMOD:		EQU	$DFF066
BLTBDAT:		EQU	$DFF072
BLTADAT:		EQU	$DFF074
COP1LC: 		EQU	$DFF080
COPJMP1:		EQU	$DFF088
DMACON: 		EQU	$DFF096
INTENA: 		EQU	$DFF09A
INTREQ: 		EQU	$DFF09C
BPLCON0:		EQU	$DFF100
COLOR:			EQU	$DFF180
BEAMCON0:		EQU	$DFF1DC
*-------------------------------------------------------*
PALSYNC:		EQU	$0020
NTSCSYNC:		EQU	$0000
DBLPALSYNC:		EQU	$1B88

FMODE:			EQU	$1FC
LISAID:			EQU	$07C
Normal_Denise:		EQU	$0
ECS_Denise_1:		EQU	$FC
ECS_Denise_2:		EQU	$EC
AA_Lisa:		EQU	$F8
*-------------------------------------------------------*
AUD0:			EQU	$DFF0A0
AUD1:			EQU	$DFF0B0
AUD2:			EQU	$DFF0C0
AUD3:			EQU	$DFF0D0

AUD0VOL:		EQU	$DFF0A8
AUD1VOL:		EQU	$DFF0B8
AUD2VOL:		EQU	$DFF0C8
AUD3VOL:		EQU	$DFF0D8

AUD1DAT:		EQU	$DFF0BA

	SECTION Protracker,CODE
*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
	INCDIR  'Include:'

	INCLUDE 'Exec/io.i'			; for AHI
	INCLUDE	'exec/memory.i'

	INCLUDE 'LVO/exec_lib.i'
	INCLUDE 'LVO/intuition_lib.i'
	INCLUDE 'LVO/dos_lib.i'

	INCLUDE	'intuition/screens.i'
	INCLUDE	'graphics/modeid.i'

	INCLUDE 'Own/graphics_base.i'
	INCLUDE 'Own/graphics_lib.i'
	INCLUDE 'Utility/tagitem.i'		; screen struct

	INCLUDE 'Libraries/ppbase.i'
	INCLUDE 'Libraries/powerpacker_lib.i'

	INCLUDE 'XPK/xpk.i'
	INCLUDE	'LVO/xpkmaster_lib.i'
	INCLUDE 'Libraries/reqtools_lib.i'

*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
	

Start:
	MOVEM.L D0/A0,-(SP)
	CLR.L	version.msg
	SUB.L	A1,A1
	MOVE.L	4.w,A6
	CALLSYS	FindTask
	MOVE.L	D0,A4
	TST.L	$AC(A4)
	BEQ.S	rb_FromCLI
	MOVEM.L (SP)+,D0/A0
	BRA.S	rb_FromWB

rb_FromCLI:
	LEA	$5C(A4),A0
	MOVE.L	4.w,A6
	CALLSYS	WaitPort
	LEA	$5C(A4),A0
	CALLSYS	GetMsg
	MOVE.L	D0,version.msg
	NOP
	MOVEM.L (SP)+,D0/A0

rb_FromWB:
	BSR.S	pt_wbmain
	MOVE.L	D0,-(SP)
	TST.L	version.msg
	BEQ.S	StartRet
	MOVE.L	4.w,A6
	CALLSYS	Forbid
	MOVE.L	version.msg(PC),A1
	CALLSYS	ReplyMsg
StartRet:
	MOVE.L	(SP)+,D0
	RTS

*********************************************************
*            internal versions string                   *
*********************************************************
version.msg:
	dc.l	0
	dc.b	'$VER: Protracker V'
	Revision
	dc.b	' ('
	RevDate
	dc.b	') '

	IFEQ	highercpu
	dc.b	'for MC68000 '
	ELSE
	dc.b	'for MC68020 '
	ENDC
	dc.b	'by Thomas Beyer [dreamer@silent-dreams.de]',0
	EVEN

*********************************************************
*         PT WB/CLI startcode                           *
*********************************************************
pt_wbmain:
	MOVE.L	SP,ProgStackSave		; save stackpointer
	MOVE.L	4.w,A6
	LEA	PTProcess.MSG(PC),A1
	CALLSYS	FindTask
	MOVE.L	D0,TaskErrorBit

	; get address from the task
	SUB.L	A1,A1
	CALLSYS	FindTask
	MOVE.L	D0,PTProcess
	MOVE.L	D0,A0				; pointer to task struct
	LEA	mt_currentdir(PC),A1		; set actual directory
	MOVE.L	10(A0),(A1)
	LEA	PTProcess.MSG(PC),A1
	MOVE.L	A1,10(A0)

	BSR.W	OpenLibs
	BSR.W	TaskInitTest			; PT is already running ?
	BNE.W	intrgga				; then close pt

	BSR.W	TestHardware			; CPU, Chipset

	IFEQ	highercpu
	ELSE
	cmp.b	#1,CPUFlag			; min 68020
	bgt.s	.l0
	bra	cpuwarning			; no, exit
	ENDC

.l0:	BSR.W	intrgmo				; audio.device not free?
	BNE.W	intrgga				; then close pt
	BSR.W	OpenLotsOfThings		; pt_init
	BSR.W	intmagfield			; set CIA IRQ's
	BNE.W	errorexit1
	BSR.W	intwarm 			; set audio-irq 1-4 for PT
	CALL	intdrweb
	BSR.W	intrema				; check kickstart
	BSR.W	InitInputHandler
	BSR.W	SetEasyReq
	BSR.W	CreatePTScreen			; depack main screen
	BSR.W	OpenPTScreen			; get screen
	BSR.W	SetVBInt
	CALL	SetPatternPos
	BSR.W	SetNormalPtrCol
	BSR.W	StorePtrCol
	CALL	BlitManyThings
	BSR.W	loadkeymap
	BSR.W	valgask
	BSR.W	valmaga
	BSR.W	DoShowFreeMem
	CALL	bltvalg
	BSR.W	SetTempo
	BSR.W	SetCopList
	MOVE.W	#1,notogfl
	BSR.W	DisplayMainScreen
	LEA	VersionText(PC),A0
	CALL	ShowStatusText			; VersionsText
	CALL	ViewFont2			; ViewFont
	move.w	#1,newalloc
	CALL	showmode			; draw 4/8chn notefield
	CALL	tpnskp2				; View DrumPad

	;move.l	IntuitionBase,a6
	;CALLSYS	RethinkDisplay

MainLoop:

	BSR.W	DoKeyBuffer
	BSR	CheckLAmiga3
	BSR.W	CheckCtrlKeys
	BSR.W	CheckAltKeys
	CALL	CheckKeyboard
	CALL	CheckF1_F2
	BSR.W	CheckF3_F5
	BSR.W	CheckF6_F10
	BSR.W	CheckPlayKeys
	BSR.W	CheckHelp
	CALL	ResetKeyTimer
	BSR.W	CheckLAmigaKeys
	CALL	ArrowKeys2
	BSR.W	CheckIf100
	BSR.W	ShowTimer
	BSR.W	ShowFreeMem
	CALL	CheckBlockPos
	CALL	CheckSampleLength
	BSR.W	CheckRedraw

	checkrmb
	BNE.B	.l1
	CALL	DoRightButton			; check RMB mouseclick

.l1:	BTST	#6,$BFE001
	BNE.B	MainLoop			; loop if not pressed
	TST.W	CurrScreen
	BNE.B	.l2
	MOVE.W	#1,notogfl
	BSR.W	DisplayMainScreen
	CALL	ShowAllRight
	BSR.W	WaitForButtonUp
.l2:
	CALL	ArrowKeys
	GOTO	CheckGadgets

*********************************************************
notogfl:	dc.w	0
mt_currentdir:	dc.l	0,0		; pt path if cli-start
PTProcess.MSG:	dc.b	'Protracker',0	; processname if wbstart
		EVEN

VersionText:	dc.b	'PROTRACKER V'
		Revision
		dc.b	' ('
		RevDate
		dc.b	')',0
		EVEN

*********************************************************
CheckRedraw:
	TST.B	UpdateTempo
	BEQ.S	.l1
	CLR.B	UpdateTempo
	BSR	SetTempo

.l1:	CMP.L	#'patp',RunMode
	BEQ.S	.l2
	RTS

.l2:	CALL	ShowPosition
	tst.b	PattRfsh
	bne.s	.l3
	rts

;--- refresh posed and infoscreen positions ---
.l3:	cmp.w	#1,CurrScreen
	beq.s	.l4
	move.w	Saveplaypos,D0
	cmp.w	playpos+2,D0			; new pattern?
	beq.s	.l4
	CALL	PosEDstart			; and info screen
	CALL	InfoViewPos
	move.w	playpos+2,Saveplaypos

;--- mainscreen ---
.l4:
	MOVE.L	PattRfshNum,PatternNumber
	GOTO	RedrawPattern

*********************************************************
*              external keymap loader                   *
*********************************************************

keyfilelength:	EQU	128

loadkeymap:
	MOVE.L	#keyfilelength,D0
	MOVE.L	#MEMF_CHIP|MEMF_PUBLIC|MEMF_CLEAR,D1
	MOVE.L	4.w,A6
	CALLSYS	AllocMem
	beq.s	freekey
	MOVE.L	D0,keymapmem

	LEA	PTPath,A0
	CALL	CopyPath
	LEA	keymapname(PC),A0
	MOVEQ	#9,D0
.loop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loop
	MOVE.L	#FileName,D1
	MOVE.L	#$000003ED,D2
	MOVE.L 	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,D7
	BEQ.B	FreeKeyMem
	MOVE.L	keymapmem(PC),D2		; memory buffer
	BEQ.B	FreeKeyMem

	MOVE.L	D7,D1				; file
	MOVE.L	#keyfilelength,D3
	MOVE.L 	DOSBase,A6
	CALLSYS	Read
	MOVE.L	D7,D1
	MOVE.L	DOSBase,A6
	CALLSYS	Close
	RTS

FreeKeyMem:
	tst.l	keymapmem
	beq.s	freekey
	move.l	4.w,a6
	MOVE.L	keymapmem,a1
	move.l  #keyfilelength,D0
	CALLSYS	FreeMem

freekey:
	clr.l	keymapmem
	rts

keymapmem:	dc.l	0
keymapname:	dc.b	'pt.keymap',0
		EVEN

*********************************************************
* shows !(100Patt) or b(64Patt) mode in status line     *
*********************************************************
CheckIf100:
	move.l	MaxPattLength,d0
	cmp.l	#63,d0
	bhi.s	.l1
	move.b	#'`',d0
	bra.s	.l2
.l1:	move.B	#'!',D0
.l2:	move.b	d0,pattmodeind
	lea	pattmodeind,a0
	MOVEQ	#1,D0
	move.w	#$2803+1,d1
	GOTO	ShowText3

*********************************************************
*      requester warning if module is changed           *
*********************************************************
modischanged:
	lea	ChangedMod.TXT,a0
	bsr.w	AreYouSure
	beq.s	.l1
	moveq	#1,d0
	rts

.l1:	moveq	#2,d0
	rts

*********************************************************
*            exit and quit program                      *
*********************************************************
ExitCleanup:
	cmp.l	#'CHG!',changeflag
	bne.s	.l1
	bsr.b	modischanged
	cmp	#2,d0
	beq.s	.exit
	rts

.l1:	LEA	QuitProgram.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	.exit
	RTS

.exit:	CALL	StopIt
	CALL	TurnOffVoices
	BCLR	#1,$00BFE001
	BSET	#1,Packetfield
	MOVE.B	LEDStatus,D0
	AND.B	#2,D0
	OR.B	D0,$BFE001
	BSR.W	EscPressed
	BSR.W	EscPressed
	bsr.w	FreeKeyMem			; cleanup ext keymapbuffer
	CALL	FreePLST			; cleanup PLST mem
	BSR.W	PrepareResetVBI
	BSR.W	qint_er

	;chn8test				; AHI on ?
	;beq.s	close8dev			; yes, skip
	BSR.W	resetirqveks			; remove pt aud0-aud3 irq ports
close8dev:
	BSR.W	RemovePTPort
	BSR.W	ResetCopList
	BSR.W	ReSetEasyReq
	MOVE.L	0,A0				;useless
	BSR.W	ClosePTScreen

errorexit1:
	;chn8test				; AHI on ?
	;bne.s	close4dev			; no, skip
	;CALL	close_ahi
;close4dev:
	BSR.W	CloseAudioDev
	CALL	ClearCopyBufPtr
	BSR.W	di_clearbyexit
	BSR.W	FreeDirMemory
	CALL	FreeMemSample			; freemem

*********************************************************
* also jumped if another pt task is found at start      *
*********************************************************
intrgga:
	MOVE.L	PTProcess(PC),A0		; wb or cli task ?
	CMP.L	#0,A0
	BEQ.B	.l1
	MOVE.L	mt_currentdir(PC),10(A0)

.l1:	MOVE.L	4.w,A6
	MOVE.L	GfxBase,A1
	beq.s	.l2
	CALLSYS	CloseLibrary
	CLR.L	GfxBase

.l2:	MOVE.L	IntuiBase,A1
	beq.s	.l3
	CALLSYS	CloseLibrary
	CLR.L	IntuiBase

.l3:	MOVE.L	DOSBase,A1
	beq.s	.l4
	CALLSYS	CloseLibrary
	CLR.L	DOSBase

.l4:	move.l	ReqBase,A1
	beq.S	.l5
	CALLSYS	CloseLibrary
	CLR.L	ReqBase

.l5:	MOVE.L	xpkbase,A1
	BEQ.S	.l6
	CALLSYS	CloseLibrary
	CLR.L	xpkbase

.l6:	MOVE.L	PPackBase,A1
	BEQ.S	.l7
	CALLSYS	CloseLibrary
	CLR.L	PPackBase

.l7:	move.l	4.w,A6
	move.l	mt_songdataptr,D1
	beq.s	.l8
	move.l	d1,a1
	move.l	PatternMemAllocSize,D0
	CALLSYS	FreeMem

.l8:	MOVE.L	ProgStackSave,SP
	MOVEQ	#0,D0
	RTS

*********************************************************
*            library open subroutine                    *
*********************************************************
OpenLibs:
	MOVE.L	4.w,A6				; get Exec
	LEA	DOSname(PC),A1
	MOVEQ	#33,D0				; V34
	CALLSYS	OpenLibrary
	MOVE.L	D0,DOSBase
	BEQ.S	.liberror

	LEA	GraphicsName(PC),A1
	MOVEQ	#33,D0
	CALLSYS	OpenLibrary
	MOVE.L	D0,GfxBase
	BEQ.S	.liberror

	LEA	IntuitionName(PC),A1
	MOVEQ	#33,D0
	CALLSYS	OpenLibrary
	MOVE.L	D0,IntuiBase
	BEQ.S	.liberror

	lea	reqtoolsname(PC),A1
	moveq	#38,D0
	CALLSYS	OpenLibrary
	move.l	D0,ReqBase

	lea	xpkname(PC),A1
	moveq	#3,D0				; V3
	CALLSYS	OpenLibrary
	move.l	D0,xpkbase
	beq.s	openpplib			; if no xpk, open pp.lib
	moveq	#0,d0
	rts

.liberror:	MOVEQ	#-1,D0
		RTS

;--- powerpacker.library ---

openpplib:
	move.l	4.w,a6
	LEA	ppname(PC),A1
	MOVEQ	#$23,D0
	CALLSYS	OpenLibrary
	MOVE.L	D0,PPackBase
	moveq	#0,d0
	rts

*********************************************************
*            Protracker main init                       *
*********************************************************
OpenLotsOfThings:
	MOVE.B	$BFE001,LEDStatus
	BSET	#1,$00BFE001
	BCLR	#1,Packetfield			; Filter off
	BCLR	#2,Packetfield			; file type mod
	BCLR	#4,Packetfield			; no variable Patterns
	BCLR	#6,Packetfield			; 8 Bit samples
	BCLR	#7,Packetfield			; no packed patterns
	move.w	#4,numchans			; 4 channel init
	move.w	#125,BPMTempo
	move.w	#6,DefaultSpeed

	CALL	TurnOffVoices
	CLR.L	CopListPtr
	MOVE.L	#PattBlkSize,D0
	MOVE.L	D0,TextBplPtr

	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1

	MOVE.L	4.w,A6
	CALLSYS	AllocMem			; allocate patternmem
	MOVE.L	D0,mt_songdataptr
	BEQ.W	errorexit1

	MOVE.L	D0,mt_songdataptr
	move.l	d0,a0
	LEA	20(a0),a0			; samplenamestart act sample
	moveq	#30,d0
.l1:
	move.w	#1,28(a0)			; set
	lea	30(a0),a0
	dbra	d0,.l1

	move.l	mt_songdataptr,a0
	move.w	#383,sd_numofpatt(a0)
	move.l	'M.K.',sd_mahokakt(a0)

	MOVEQ	#6,D0				; actual speed to 6
	MOVE.L	D0,mt_speed
	MOVE	#1,PEDPos
	MOVE.L	#ModulesPath2,DirPath
	move.l	#CopperList,CopListPtr
	MOVE.L	#CopListBitPlanes,CopListBplPtr
	MOVE.L	#CopListColors,CopListColorPtr
	MOVE.L	#CopListBpl4,CopListBpl4Ptr
	MOVE.L	#KbdTransTable2,KeyTransTabPtr
	MOVE.L	#NoteNames1,NoteNamesPtr
	MOVE.L	#VUMeterColors,TheRightColors

	CALL	GetStandardConfig
	CALL	DoLoadConfig			; Load Config
	CALL	SetScrPatternPos

	BTST	#0,VUSpriteMode
	BEQ.S	.l0
	BSR	SetDefSpritePtrs_L		; init vumetersprites (fine) pos
	BRA.S	.lt1

.l0:	BSR	SetDefSpritePtrs_B		; init vumetersprites (bold) pos
.lt1:	CALL	mt_initbars			; enforcer hit removed
	MOVE.W	#$FFE0,D0
	MOVE.W	#$0019,D1
	MOVE.W	#$0053,D2
	CALL	UpdscrollSprite1
	;CALL	GetStandardConfig
	;CALL	DoLoadConfig			; Load Config
	CALL	DoLoadPLST			; Load PLST
	CALL	UpdCurAndPatt
	CALL	UpdIfCfgOpen
	CALL	RedrawPattern
	CALL	ShowPosition
	CALL	ShowSongLength
	MOVE.W	#1,InsNum
	MOVE.W	#1,CurrScreen			; fix
	CALL	ShowSampleInfo

*********************************************************
*        vucolors set, called also by setups            *
*********************************************************
mt_setupvucols:
	TST.W	SamScrEnable
	BEQ.S	mt_setupvuc
	RTS

mt_setupvuc:
	LEA	CopListMark2,A0
	MOVE.W	#$00C3,D5		;195
	ADD.W	ScreenPosY,D5
	SUB.W	ScrPosYValue,D5
	LSL.W	#8,D5
	OR.B	#7,D5
	LEA	VUMeterColors,A5
	MOVEQ	#48-1,D7
.lob:
	MOVE.W	D5,(A0)+
	MOVE.W	#$FFFE,(A0)+
	LEA	VUMeterColRegs(PC),A1
	MOVEQ	#1,D6
.loo:
	MOVE.W	(A5),D4
	MOVE.W	(A1)+,(A0)+
	MOVE.W	#3,FadeX
	MOVE.W	D4,D0
	CALL	FadeCol
	MOVE.W	D0,(A0)+
	MOVE.W	(A1)+,(A0)+
	MOVE.W	D4,(A0)+
	MOVE.W	(A1)+,(A0)+
	MOVE.W	#$FFFD,FadeX
	MOVE.W	D4,D0
	CALL	FadeCol
	MOVE.W	D0,(A0)+
	DBRA	D6,.loo
	ADDQ.W	#2,A5
	ADD.W	#256,D5			;screenheight
	DBRA	D7,.lob
	CALL	SetScreenColors
	RTS

*********************************************************
* intuirequester if another PT task is already running  *
*********************************************************
TaskInitTest:
	TST.L	TaskErrorBit
	BNE.S	mt_taskrequest
	MOVEQ	#0,D0
	RTS

mt_taskrequest:
	move.l	ReqBase,d0			; reqtools available ?
	beq.s	useintuireq			; no

	move.l	d0,a6
	lea	RText1(pc),a1
	lea	RUnderstood(pc),a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a0,a0
	CALLSYS	rtEZRequestA
	moveq	#-1,d0
	rts

useintuireq:
	LEA	mt_tskreqdatas(PC),A1
	BSR.W	OpenErrorRequester
	MOVEQ	#-1,D0
	RTS

TaskErrorBit:	dc.l	0

*********************************************************
*         open and init audio.device     		*
*********************************************************
intrgmo:
	LEA	audiodevtags,A1
	MOVE.L	PTProcess(PC),D0
	MOVE.L	D0,16(A1)
	LEA	audiodevtags,A1
	MOVE.L	4.w,a6
	CALLSYS	AddPort
	LEA	AudioDevbuf,A1
	MOVE.B	#$7F,9(A1)
	MOVE.L	#audiodevtags,14(A1)
	MOVE.L	#AuDevCoBit,$22(A1)
	MOVE.L	#1,$0026(A1)
	MOVE.L	#AuDevLtBit,$18(A1)             ; ioRequest
	MOVEQ	#0,D0				; unit
	MOVEQ	#0,D1				; flags
	LEA	AudioDevName(PC),A0		; devicename
	CALLSYS	OpenDevice
	TST.L	D0
	BNE.S	NAllocP
	LEA	AudioDevbuf,A1
	MOVE.B	$001F(A1),D0
	BNE.S	NAllocP
	MOVE.L	$0014(A1),AuDevOpBit
	TST.L	AuDevOpBit
	BEQ.S	NAllocP
	MOVE.W	$0020(A1),AuDevStBit
	MOVEQ	#0,D0
	RTS

CloseAudioDev:
	LEA	AudioDevbuf,A1
	MOVE.L	AuDevOpBit(PC),$0014(A1)
	MOVE.L	#AuDevCoBit,$0018(A1)
	MOVE.W	AuDevStBit(PC),$0020(A1)
	MOVE.L	4.w,a6
	CALLSYS	CloseDevice
	LEA	AudioDevbuf,A1
	MOVE.B	$001F(A1),D0
	TST.B	D0
	BNE.S	NAllocP
Remove_Port:
	LEA	audiodevtags,A1
	MOVE.L	4.w,a6
	CALLSYS	RemPort
	MOVEQ	#-1,D0
	RTS

*********************************************************
*        inutirequester no audio.device 		*
*********************************************************
NAllocP:
	CMP.L	#$FFFFFFF5,D0
	BNE.S	AudioErrorReq

*** audio allocating error requester ***

	move.l	ReqBase,d0			; reqtools available?
	beq.s	useintuireq2			; no
	move.l	d0,a6
	lea	RText3(pc),a1
	lea	RUnderstood(pc),a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a0,a0
	CALLSYS	rtEZRequestA
	BRA.S	Remove_Port

useintuireq2:
	LEA	NoAllocPRC(PC),A1		; no allocate audio.dev req
	BRA.S	ErrorReqPort

*** general audio error requester ***

AudioErrorReq:
	move.l	ReqBase,d0			; reqtools available?
	beq.s	useintuireq3			; no
	move.l	d0,a6
	lea	RText5(pc),a1
	lea	RUnderstood(pc),a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a0,a0
	CALLSYS	rtEZRequestA
	BRA.S	Remove_Port

useintuireq3:
	LEA	AudioDevReq(PC),A1		; general audio.dev error req

ErrorReqPort:
	BSR.S	OpenErrorRequester
	BRA.B	Remove_Port

*********************************************************
* 		old intuition requester			*
* => A1 = Bodytext					*
*********************************************************
OpenErrorRequester:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	IntuiBase,A6
	MOVE.L	$0034(A6),A0			; window addr
	MOVEM.L A0/A1,-(SP)
	MOVE.L	$0038(A6),A0
	MOVEQ	#0,D0
	MOVE.L	$0028(A0),A1
	MOVE.W	4(A1),D0
	ADDQ.W	#1,D0
	ADD.B	$0023(A0),D0
	MOVE.L	D0,AudAllocErrPos
	MOVE.L	D0,TaskReqAdr
	MOVE.L	D0,CiAReqAdr
	MOVEM.L (SP)+,A0/A1
	SUB.L	A2,A2
	LEA	RequesterDatas(PC),A3			; negtext
	MOVEQ	#0,D0					; posflags
	MOVEQ	#0,D1					; negflags
	MOVEQ	#0,D2					; width
	MOVEQ	#0,D3					; height

	;A0=window A1=BodyText A2=PosText A3=NegText
	;D0=PosFlags D1=NegFlags D2=Width D3=Height

	CALLSYS	AutoRequest
	MOVEM.L (SP)+,D1-D7/A0-A6
	RTS

*********************************************************
*	Intuition easyreq texts for requesters		*
*	(used if reqtools.library is not available	*
*********************************************************

NoAllocPRC:	dc.l	0,0,0
		dc.l	NoAllocate.MSG	;text
		dc.l	AudAllocErrRq
*---
AudAllocErrRq:	dc.l	0
AudAllocErrPos:	dc.l	0,0
		dc.l	AudioChannels.MSG,0,0
		EVEN
*---
NoAllocate.MSG:		dc.b	'Couldn''t allocate',0
AudioChannels.MSG:	dc.b	'the audiochannels!',0,0

*---
AudioDevReq:		dc.l	0,0,0
			dc.l	GenAudioError.MSG,0,0
GenAudioError.MSG:	dc.b	'General audio.device error!',0,0

*---
RequesterDatas:
		dc.w	0		;autofrontpen
		dc.w	0		;autobackpen
		dc.w	0		;autodrawmode
		dc.w	0		;autoleftedge
		dc.w	0		;autotopedge
		dc.w	0		;autoittextfont

		dc.l	Resume.MSG,0	;autonexttext

Resume.MSG:	dc.b	'Resume',0
		EVEN
		dc.b	'Protracker request!',0
*---
mt_tskreqdatas:	dc.l	0,0,0
		dc.l	TaskErrorTxt
		dc.l	TaskErrorPo

TaskErrorPo:	dc.l	0
TaskReqAdr:	dc.l	0,0
		dc.l	TaskTxt,0,0
TaskErrorTxt:	dc.b	'        TASK INTERFERANCE!',0
		EVEN
*---
TaskTxt:	dc.b	'ProTracker '
		Revision
		dc.b	' is already running.',0

CIAErrorPo:	dc.l	0,0,0
		dc.l	UnableCIA.TXT
		dc.l	CIAErrorCal
CIAErrorCal:	dc.l	0
CiAReqAdr:	dc.l	0,0
		dc.l	TermTask.TXT,0,0

*---
UnableCIA.TXT:	dc.b	'     Unable to get CIA timer',0,0
TermTask.TXT:	dc.b	'Terminate other tasks and try again.',0,0
		EVEN

*********************************************************
* 	Reqtools requester texts ...			*
*********************************************************
RText1:	dc.b	"ProTracker V"
	Revision
	dc.b	" ("
	RevDate
	dc.b	") Request",10
	dc.b	"~~~~~~~~~~~~~~~~~~~~~~~~~",10
	dc.b	"Another Protracker task is already",10
	dc.b	"running. You can't start it twice.",0
	EVEN
*---
RText3:	dc.b	"ProTracker V"
	Revision
	dc.b	" ("
	RevDate
	dc.b	") Request",10
	dc.b	"~~~~~~~~~~~~~~~~~~~~~~~~~",10
	dc.b	"Couldn't allocate the audio channels.",10
	dc.b	"The audio.device seems to be busy ...",0
	EVEN
*---
RText5:	dc.b	"ProTracker V"
	Revision
	dc.b	" ("
	RevDate
	dc.b	") Request",10
	dc.b	"~~~~~~~~~~~~~~~~~~~~~~~~~",10
	dc.b	"General audio.device error occured",10
	dc.b	"while starting the Protracker task.",0
	EVEN
*---
RText7:	dc.b	"ProTracker V"
	Revision
	dc.b	" ("
	RevDate
	dc.b	") Request",10
	dc.b	"~~~~~~~~~~~~~~~~~~~~~~~~~",10
	dc.b	"Unable to get an free CIA timer. Please",10
	dc.b	"quit other tasks and try it later again.",0
	EVEN
*---
RUnderstood:
	dc.b	"Understood",0
	EVEN

*********************************************************
AuDevOpBit:	dc.l	0	;(14)
AuDevStBit:	dc.w	0       ;(20)
AuDevLtBit:	dc.l	0	;(18)
AuDevCoBit:	dc.w	$0FB4	;(22)

VUMeterColRegs: 	dc.l	$01B201B4,$01B601BA,$01BC01BE
CopListColorPtr:	dc.l	0
CopListPtr:		dc.l	0	; $26(gfxbase) oldcop1
			dc.l	0	; $32(gfxbase) oldcop2

CopListBplPtr:		dc.l	0
system_view:		ds.l	1	; $22(gfxbase)
old_dmacon:		ds.w	1
old_intena:		ds.w	1
old_intreq:		ds.w	1

*********************************************************
DOSname:	dc.b	'dos.library',0
		EVEN
IntuitionName:	dc.b	'intuition.library',0
		EVEN
GraphicsName:	dc.b	'graphics.library',0
		EVEN
reqtoolsname:	dc.b	'reqtools.library',0
		EVEN
xpkname:	XPKNAME
		EVEN
ppname: 	PPNAME
		EVEN
AudioDevName:	dc.b	'audio.device',0
		EVEN

*********************************************************
SetSamSpritePtrs:
	MOVE.L	#LoopSpriteData1,Ch1SpritePtr
	MOVE.L	#LoopSpriteData2,Ch2SpritePtr
	MOVE.L	#PlayPosSpriteData,Ch3SpritePtr
	MOVE.L	#Cursor4chn,Ch4SpritePtr
	chn8test
	bne.s	.s1
	MOVE.L	#Cursor8chn,Ch4SpritePtr
.s1:	BRA.S	sdsp2


SetDefSpritePtrs_L:				; fine vumetersprite (opt)
	MOVE.L	#VUSpriteData1L,Ch1SpritePtr
	MOVE.L	#VUSpriteData2L,Ch2SpritePtr
	MOVE.L	#VUSpriteData3L,Ch3SpritePtr
	MOVE.L	#VUSpriteData4L,Ch4SpritePtr
	;MOVE.L	#VUSpriteData5L,Ch5SpritePtr
	;MOVE.L	#VUSpriteData6L,Ch6SpritePtr
	;MOVE.L	#VUSpriteData7L,Ch7SpritePtr
	;MOVE.L	#VUSpriteData8L,Ch8SpritePtr
	BRA.S	sdsp2

SetDefSpritePtrs_B:				; bold vumetersprite (def)
	MOVE.L	#VUSpriteData1B,Ch1SpritePtr
	MOVE.L	#VUSpriteData2B,Ch2SpritePtr
	MOVE.L	#VUSpriteData3B,Ch3SpritePtr
	MOVE.L	#VUSpriteData4B,Ch4SpritePtr
	;MOVE.L	#VUSpriteData5B,Ch5SpritePtr
	;MOVE.L	#VUSpriteData6B,Ch6SpritePtr
	;MOVE.L	#VUSpriteData7B,Ch7SpritePtr
	;MOVE.L	#VUSpriteData8B,Ch8SpritePtr
sdsp2:
	MOVE.L	#EmptySprite,CursorPosPtr
	MOVE.L	#PointerSpriteData,PointerSpritePtr
	MOVE.L	#LineCurSpriteData,LineCurPosPtr
	MOVE.L	#ScrollerSprite1,NoSpritePtr2
	MOVE.L	PointerSpritePtr,SpritePtrsPtr

	LEA	SpritePtrsPtr,A0
	LEA	copsprit,A1			;Set Pointers  to copperlist-spritedata
	MOVEQ	#16-1,D2			;2*8 words for the 8 sprites

.lop:	MOVE.W	(A0)+,2(A1)			;all 8 sprites

	ADDQ.L	#4,A1
	DBRA	D2,.lop
	RTS

PointerSpritePtr:	dc.l	0		; pointer to own Mousesprite

*********************************************************
* Change some intuition vectors, called by start of prog*
* and by screenswitching				*
*********************************************************
SetEasyReq:
	MOVE.L	4.w,a6
	CALLSYS	Forbid
	MOVE.L	IntuiBase,A1			; get intuition pointer for patching
	lea.l	SNewEasyReq(PC),A0
	move.l	a0,d0				; newfunction
	lea.l	(_LVOAutoRequest).w,A0		; oldfunction
	CALLSYS	SetFunction
	MOVE.L	D0,AutoReqSave			; save old AutoRequest-pointer

	CMP.W	#36,CheckKickSeteg		; min Kick V2.0
	BMI.S	AutReq_rt

	MOVE.L	IntuiBase,A1
	lea.l	NewEasyRequestArgs(PC),A0
	move.l	a0,d0				; newfunction
	lea.l	(_LVOEasyRequestArgs).w,A0	; oldfunction
	CALLSYS	SetFunction
	MOVE.L	D0,EasyReqArgSave

	MOVE.L	IntuiBase,A1
	LEA.L	NewFreeRequest(PC),A0
	move.l	a0,d0				; newfunction
	LEA.L	(_LVOFreeSysRequest).w,A0	; oldfunction
	CALLSYS	SetFunction
	MOVE.L	D0,FreeSysReqSave

	MOVE.L	IntuiBase,A1
	LEA.L	NewBuildSysReq(PC),A0
	move.l	a0,d0				; new
	LEA.L	(_LVOBuildSysRequest).w,A0	; old
	CALLSYS	SetFunction
	MOVE.L	D0,BuildReqSave

	MOVE.L	IntuiBase,A1
	LEA.L	NewEndRefresh,A0
	move.l	A0,D0				; new
	LEA.L	(_LVOEndRefresh).w,A0		; old
	CALLSYS	SetFunction
	MOVE.L	D0,EndRefreshSave
AutReq_rt:
	CALLSYS	Permit
	RTS

*********************************************************
ReSetEasyReq:
	MOVE.L	4.w,a6
	CALLSYS	Forbid
	MOVE.L	IntuiBase,A1
	MOVE.L	AutoReqSave(PC),D0
	LEA.L	(_LVOAutoRequest).w,A0		;restore OS autorequest
	CALLSYS	SetFunction

	CMP.W	#36,CheckKickSeteg		; min Kick V2.0
	BMI.S	NoHiKick

	MOVE.L	IntuiBase,A1
	MOVE.L	EasyReqArgSave(PC),D0
	LEA.L	(_LVOEasyRequestArgs).w,A0
	CALLSYS	SetFunction

	MOVE.L	IntuiBase,A1
	MOVE.L	FreeSysReqSave(PC),D0
	LEA.L	(_LVOFreeSysRequest).w,A0
	CALLSYS	SetFunction

	MOVE.L	IntuiBase,A1
	MOVE.L	BuildReqSave(PC),D0
	LEA.L	(_LVOBuildSysRequest).w,A0
	CALLSYS	SetFunction

	MOVE.L	IntuiBase,A1
	MOVE.L	EndRefreshSave(PC),D0
	LEA.L	(_LVOEndRefresh).w,A0
	CALLSYS	SetFunction
NoHiKick:
	CALLSYS	Permit
	RTS

*********************************************************
* PT-routines for Intui-requests			*
*********************************************************
SNewEasyReq:
	TST.W	MountFlag
	BEQ.S	.l0
	MOVEQ	#0,D0
	RTS

.l0:	TST.B	AutoReqRunning
	BNE.S	xyzzy

	ADDQ.B	#1,AutoReqRunning

	MOVE.L	A0,-(SP)
	BSR.W	ResetCopList
	MOVE.L	(SP)+,A0

	PEA	saveA0(PC)
	MOVE.L	AutoReqSave(PC),-(SP)
	RTS

xyzzy:	ADDQ.B	#1,AutoReqRunning
	PEA	saveA0(PC)
	MOVE.L	AutoReqSave(PC),-(SP)
	RTS

*********************************************************
* patched EasyRequestArgs if kick min V2.0 autoreq	*
*********************************************************
NewEasyRequestArgs:
	TST.W	MountFlag
	BEQ.S	.l1
	MOVEQ	#0,D0
	RTS

.l1:	TST.B	AutoReqRunning
	BNE.S	.l2
	ADDQ.B	#1,AutoReqRunning
	MOVE.L	A0,-(SP)
	BSR	ResetCopList

	MOVE.L	(SP)+,A0
	PEA	saveA0(PC)
	MOVE.L	EasyReqArgSave(PC),-(SP)
	RTS

.l2:	ADDQ.B	#1,AutoReqRunning
	PEA	saveA0(PC)
	MOVE.L	EasyReqArgSave(PC),-(SP)
	RTS

*********************************************************
* Patched BuildSysRequest				*
*********************************************************
NewBuildSysReq:
	TST.W	MountFlag
	BEQ.S	.l1
	MOVEQ	#0,D0
	RTS

.l1:	TST.B	AutoReqRunning
	BNE.S	.l2
	ADDQ.B	#1,AutoReqRunning
	MOVE.L	A0,-(SP)
	BSR	ResetCopList
	MOVE.L	(SP)+,A0
	MOVE.L	BuildReqSave(PC),-(SP)
	RTS

.l2:	ADDQ.B	#1,AutoReqRunning
	MOVE.L	BuildReqSave(PC),-(SP)
	RTS

*********************************************************
* Patched FreeSysRequest				*
*********************************************************
NewFreeRequest:
	PEA	saveA0(PC)
	MOVE.L	FreeSysReqSave(PC),-(SP)
	RTS

NewEndRefresh:
	PEA	saveA0(PC)
	MOVE.L	EndRefreshSave(PC),-(SP)
	RTS

saveA0:	SUBQ.B	#1,AutoReqRunning
	BEQ.S	SetCop_S
	RTS

SetCop_S:
	BRA	SetCopList


	cnop 0,2

AutoReqSave:	dc.l	0			; old autorequest pointer
EasyReqArgSave:	dc.l	0			; old easyreqargs pointer
BuildReqSave:	dc.l	0			; old buildsysrequest pointer
FreeSysReqSave:	dc.l	0
EndRefreshSave:	dc.l	0

*********************************************************
intrema:
	MOVE.W	#33,CheckKickSeteg		; Kick v1.2
	MOVEQ	#34,D0				; intui v34?
	BSR.S	CheckIntui
	BEQ.S	intrema_rt
	MOVE.W	#34,CheckKickSeteg		; Kick V1.3

	MOVEQ	#36,D0				; intui V36?
	BSR.S	CheckIntui
	BEQ.S	intrema_rt
	MOVE.W	#36,CheckKickSeteg		; Kick V2.0

	moveq	#39,d0
	bsr.s	CheckIntui
	beq.s	intrema_rt
	move.w	#39,CheckKickSeteg

	moveq	#40,d0
	bsr.s	CheckIntui
	beq.s	intrema_rt
	move.w	#40,CheckKickSeteg

intrema_rt:
	RTS

CheckKickSeteg:	dc.w	0

*********************************************************
CheckIntui:
	MOVE.L	4.w,a6
	LEA	IntuitionName,A1
	CALLSYS	OpenLibrary
	TST.L	D0
	BEQ.S	CheckIntui_no
	MOVE.L	D0,A1
	CALLSYS	CloseLibrary
	MOVEQ	#-1,D0
	RTS

CheckIntui_no:
	MOVEQ	#0,D0
	RTS

*********************************************************
*	Test cpu and chipset of amiga			*
*********************************************************
TestHardware:
	move.l	4.w,a6
	move.w	296(a6),d0

	btst	#0,d0		;68010?
	beq.s	.l0		;no
	move.b	#1,CPUFlag

.l0:	btst	#1,d0		;68020?
	beq.s	.l1		;no
	move.b	#2,CPUFlag

.l1:	btst	#2,d0		;68030?
	beq.s	.l2		;no
	move.b	#3,CPUFlag

.l2:	btst	#4,d0		;68881?
	beq.s	.l3		;no
	move.b	#1,FPUFlag

.l3:	btst	#5,d0		;68882?
	beq.s	.l4		;no
	move.b	#2,FPUFlag

.l4:	btst	#3,d0		;68040?
	beq.s	.l5		;no
	move.b	#4,CPUFlag

.l5:	btst	#7,d0		;68060?
	beq.s	.l6		;no
	move.b	#5,CPUFlag

.l6:	btst	#6,d0		;68551?
	beq.s	CheckAGA	;no
	move.b	#1,MMUFlag

CheckAGA:
	move.w	BLTDDAT+LISAID,d0		; get LISA ID Flags
	beq.s	Is_Denise
	cmp.w	#ECS_Denise_1,d0
	beq.s	Is_Denise_1
	cmp.w	#ECS_Denise_2,d0
	beq.s	Is_Denise_1
	cmp.w	#AA_Lisa,d0			; Has this Amiga GOT AGA?
	beq.s	Is_AA_Lisa
Not_AGA:
	st.b	d0				; NoAGA=$FF (.B)
	rts

Is_AA_Lisa:
	moveq	#0,d0				; AGA=0
	move.b	#3,LisaFlag
	;move.w	d0,BLTDDAT+FMODE		; reset sprite & bitplane fetch
	;move.w	d0,BLTDDAT+BPLCON3		; reset bplcon3 modulo
	rts
Is_Denise:
	moveq	#1,d0
	move.b	#0,LisaFlag
	rts

Is_Denise_1:
	moveq	#2,d0
	move.b	#1,LisaFlag
	rts
Is_Denise_2:
	moveq	#3,d0
	move.b	#2,LisaFlag
	rts

CPUFlag:	dc.b	0	;1=010,2=020,3=030,4=040,5=060
FPUFlag:	dc.b	0	;1=881,2=882
MMUFlag:	dc.b	0	;1=551
LisaFlag:	dc.b	0	;0=OCS,1=ECS,2=ECS,3=AGA
		EVEN

*********************************************************
* 	You need min. a 68020 CPU, exit			*
*********************************************************
	IFEQ	highercpu
	ELSE

cpuwarning:
	move.l	ReqBase,d0			; reqtools available ?
	beq.s	silentbye			; no
	move.l	d0,a6
	lea	cputxt(pc),a1
	lea	exitgad(pc),a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a0,a0
	CALLSYS	rtEZRequestA
silentbye:
	bra	intrgga				;pt shutdown

cputxt:
	dc.b	"This version of Protracker needs min. an MC68020.",10
	dc.b	"Your computer is using an CPU MC68000 or MC68010.",10
	dc.b	"Please try again with an recent executable ...",0

exitgad:
	dc.b	"Exit",0
	EVEN

	ENDC

*********************************************************
*	Create the pt screen main upper part		*
*********************************************************
CreatePTScreen:
	LEA	PTPic,A0
	CALL	C_DecompactIFF
	bne.s   .l1
	RTS

.l1:	LEA	PTBitMap,a0
	moveq   #0,d3
	MOVEQ   #1,D2

.lop:	MOVE.L  #2759,D0			; $0AC7,D0
.loo:	MOVE.L  (A1)+,(A0)+
	DBRA    D0,.loo

	LEA     PTBitMap+Main2Plane,A0
	DBRA    D2,.lop

	MOVEQ   #0,D0
	GOTO	C_FreeDecompMem

*********************************************************
* 	Open the intuition screen of PT 		*
*********************************************************
OpenPTScreen:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	IntuiBase,A6
	LEA	PTScreenTags(PC),A0		; intui struct to a0
	CALLSYS	OpenScreen
	MOVE.L	D0,PTScreenBase			; D0=screensddress
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*********************************************************
*	Close the intuition screen of PT		*
*********************************************************
ClosePTScreen:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	IntuiBase,A6
	MOVE.L	PTScreenBase,A0
	CMP.L	#0,A0
	BEQ.S	scrisclosed
	CALLSYS	CloseScreen
scrisclosed:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*********************************************************
AllocPTScreen:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.L	PTScreenBase
	BEQ.S	allcptscr2
allcptscr1:
	MOVE.L	DOSBase,A6
	MOVEQ	#10,D1
	CALLSYS	Delay
	MOVE.L	IntuiBase,A6
	MOVE.L	$003C(A6),D0				; clearpointer
	CMP.L	PTScreenBase(PC),D0
	BNE.S	allcptscr1

allcptscr2:
	;moveq	#1,d0
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*********************************************************
* 		PT intuition screen tags		*
*********************************************************
PTScreenTags:
	dc.w	0					; leftedge
	dc.w	0					; topedge
	dc.w	640					; width
	dc.w	12					; height
	dc.w	1					; depth
	dc.b	00					; detailpen
	dc.b	01					; blockpen
	dc.w	$8000					; screentype
	dc.w	NS_EXTENDED|CUSTOMSCREEN|SCREENHIRES
	dc.l	0					; font
	dc.l	ScreenName				; default title
	dc.l	0					; Gadgets
	dc.l	0					; Custombitmap
	dc.l	ScrTagItem				; ns_extended ptr
	dc.l	WinDefTitle				; standard windowtitle

*--- extended screen struct, in pre V39 systems ignored ---*

ScrTagItem:
	;dc.l	SA_SysFont
	;dc.l	0				; 0=nonprop, 1=prop font
	dc.l	SA_Type
	dc.l	CUSTOMSCREEN
	dc.l	SA_ShowTitle
	dc.l	0				; no screentitle for intuition
	dc.l	SA_DisplayID			; ti_Tag; type       org=SA_DisplayID
	dc.l	PAL_MONITOR_ID|HIRES_KEY	; ti_Data PAL Hires  org=00029000
	dc.l	SA_Draggable
	dc.l	1				; 0, FALSE
	dc.l	SA_Exclusive
	dc.l	1				; 1, TRUE
	;dc.l	SA_SharePens
	;dc.l	0
	dc.l	SA_LikeWorkbench
	dc.l	0
	;dc.l	SA_MinimizeISG
	;dc.l	1
	dc.l	TAG_END				; 0

PTScreenBase:	dc.l	0						; ptr to opened intuiscreen
ScreenName:	dc.b	'Protracker 4.00  1995-1997 by Thomas Beyer',0	; intui screentitle
		EVEN

WinDefTitle:	dc.b	'Protracker Window',0
		EVEN

*********************************************************
*		Copperlist set routine			*
*********************************************************
SetCopList:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	SUB.L	A1,A1
	CALLSYS	LoadView			;InView in A1
	CALLSYS	WaitTOF				;wait to next TOF
	CALLSYS	WaitTOF
	CALL	StoreCopPtrF
	MOVE.L	#CopperList,CopListPtr
	MOVE.L	#CopperList,COP1LC
	MOVE.W	#0,COPJMP1
	MOVEM.L (SP)+,D0-D7/A0-A6
	;BSR	multiscan			;fix jmptab before enabling!!!
	RTS

*********************************************************
*		Copperlist reset routine		*
*********************************************************
ResetCopList:
	MOVEM.L D0-D7/A0-A6,-(SP)

	MOVE.L	GfxBase,A6
	MOVE.L	IntuiBase,A1
	LEA	$22(A1),A1			;screen pointer
	CALLSYS	LoadView
	CALLSYS	WaitTOF
	CALLSYS	WaitTOF

	MOVE.L	GfxBase,A0
	LEA	CopListPtr(PC),A1
	MOVE.L	$26(A0),(A1)+			;get oldcop1, system_copper
	move.l	$32(A0),(A1)+			;get oldcop2

	MOVE.L	$26(A0),COP1LC
	MOVE.W	#0,COPJMP1
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*********************************************************
*	Added for different screenmodes			*
*********************************************************
multiscan:
	MOVEM.L D0-D7/A0-A6,-(SP)
	;MOVE.L	4.w,A6
	;CALLSYS	Forbid
	;CALLSYS	Disable

	move.l	GfxBase,a6
	;MOVE.L	$22(A6),system_view
	;MOVE.L	$26(A6),CopListPtr		;system_copper
	;SUB.L	A1,A1
	;CALLSYS	LoadView 		;(null)
	;CALLSYS	WaitTOF
	;CALLSYS	WaitTOF

	LEA	BLTDDAT,A6
	MOVE.W	2(A6),old_dmacon
	MOVE.W	$1C(A6),old_intena
	MOVE.W	$1E(A6),old_intreq
	MOVE.W	#$8000,D0
	OR.W	D0,old_dmacon
	OR.W	D0,old_intena
	OR.W	D0,old_intreq
	MOVE.W	#$0020,$96(A6)
	LEA	$140(A6),A0
	MOVEQ	#16-1,D0
.c:	CLR.L	(A0)+
	DBRA	D0,.c

	move.w	#$0FFF,copper_color_hi_256+10
	move.l	#PTBitMap,screen_showed
	move.b	#$F5,PTBitMap
	move.b	#$AF,PTBitMap+(640/3)-1
	move.b	#$F0,PTBitMap+(7960)
	move.b	#$0F,PTBitMap+(640/3)-1+(7960)


;SetSyncMode
;
;0=Pal - 8 sprites
;1=Ntsc - 8 sprites
;2=DblPal (30.00Khz 50Hz) - 4 sprites
;3=DblNtsc (30.00Khz 60Hz) - 4 sprites
;4=Multiscan (31.56Khz 60Hz) - 1 sprite
;5=DblPal (30.00Khz 50Hz) - 4 sprites - specific for 1942 monitors
;6=DblNtsc (30.00Khz 60Hz) - 4 sprites - specific for 1942 monitors
;7=Multiscan (31.56Khz 60Hz) - 1 sprite - specific for 1942 monitors

	move.l	#1,Y_mode		; origin: 0=bottom/left 1=top/left
	MOVE.L	#2,synch_mode		; 0-7, Screenmode

	BSR.S	SetSynchMode
	BSR	SetBplPt

	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*********************************************************
screen_showed:	DC.L	0		;^ to the screen being showed
Y_mode:		DC.L	0		;0=bottom_left  1=top_left
h_center:	DC.L	0		;30.00/31.56Khz horizontal centering
v_center:	DC.L	0		;30.00/31.56Khz vertical centering
synch_mode:	DC.L	0		;0=PAL  1=NTSC  2=DBLPAL etc..

*********************************************************
SetSynchMode:	movem.l	d0/d1/a0/a1/a2/a3,-(sp)
		bsr.w	WaitVBL
		lea	BLTDDAT,a0
		move.w	#$03A0,$096(a0)		;DMACON - disable bpl/cop/spr
		lea	copper_bpl_regs+2,a2
		lea	copper_spr_res+2,a3
		move.l	synch_mode,d0
		bmi.w	.exit
		cmp.l	#8,d0
		bge.w	.exit
;		jmp	([.jmptab,pc,d0.l*4])
.jmptab:
		dc.l	.pal
		dc.l	.ntsc
		dc.l	.dblpal
		dc.l	.dblntsc
		dc.l	.multiscan
		dc.l	.1942dblpal
		dc.l	.1942dblntsc
		dc.l	.1942multiscan
.pal:		bsr.w	.sprites_pal
		move.w	#$0211,8(a2)		;BPLCON0
		move.w	#$0038,$092(a0)		;DDFSTRT
		move.w	#$00A8,$094(a0)		;DDFSTOP
		move.w	#$000F,$1FC(a0)		;FMODE
		move.w	#$0020,$1DC(a0)		;BEAMCON0
		move.w	#$4481,$08E(a0)		;DIWSTRT
		move.w	#$0CC1,$090(a0)		;DIWSTOP
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$0063,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.ntsc:		bsr.w	.sprites_ntsc
		move.w	#$0211,8(a2)		;BPLCON0
		move.w	#$0038,$092(a0)		;DDFSTRT
		move.w	#$00A8,$094(a0)		;DDFSTOP
		move.w	#$000F,$1FC(a0)		;FMODE
		move.w	#$0000,$1DC(a0)		;BEAMCON0
		move.w	#$2C81,$08E(a0)		;DIWSTRT
		move.w	#$F4C1,$090(a0)		;DIWSTOP
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$0063,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.dblpal:	bsr.w	.v_centering_50
		bsr.w	.h_centering
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0028,$092(a0)		;DDFSTRT
		move.w	#$0068,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0025,$1C2(a0)		;HSSTOP
		move.w	#$0031,$1C6(a0)		;HBSTOP
		move.w	#$0077,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0003,$1E0(a0)		;VSSTRT
		move.w	#$0005,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$0258,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.dblntsc:	bsr.w	.v_centering_60
		bsr.w	.h_centering
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0028,$092(a0)		;DDFSTRT
		move.w	#$0068,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0025,$1C2(a0)		;HSSTOP
		move.w	#$0031,$1C6(a0)		;HBSTOP
		move.w	#$0077,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0003,$1E0(a0)		;VSSTRT
		move.w	#$0005,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$01F4,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.multiscan:	bsr.w	.m_centering_60
		bsr.w	.h_centering_m
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0018,$092(a0)		;DDFSTRT
		move.w	#$0058,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0017,$1C2(a0)		;HSSTOP
		move.w	#$0021,$1C6(a0)		;HBSTOP
		move.w	#$0071,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0003,$1E0(a0)		;VSSTRT
		move.w	#$0005,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$020E,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.1942dblpal:	bsr.w	.v_centering_50
		bsr.w	.h_centering
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0028,$092(a0)		;DDFSTRT
		move.w	#$0068,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0025,$1C2(a0)		;HSSTOP
		move.w	#$0031,$1C6(a0)		;HBSTOP
		move.w	#$0077,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0005,$1E0(a0)		;VSSTRT
		move.w	#$0003,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$0258,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.1942dblntsc:	bsr.w	.v_centering_60
		bsr.w	.h_centering
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0028,$092(a0)		;DDFSTRT
		move.w	#$0068,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0025,$1C2(a0)		;HSSTOP
		move.w	#$0031,$1C6(a0)		;HBSTOP
		move.w	#$0077,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0005,$1E0(a0)		;VSSTRT
		move.w	#$0003,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$01F4,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0	;test 1B8A!!
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4
		bra.w	.exit

.1942multiscan:	bsr.w	.m_centering_60
		bsr.w	.h_centering_m
		move.w	#$8211,8(a2)		;BPLCON0
		move.w	#$0018,$092(a0)		;DDFSTRT
		move.w	#$0058,$094(a0)		;DDFSTOP
		move.w	#$C00F,$1FC(a0)		;FMODE
		move.w	#$0009,$1C4(a0)		;HBSTRT
		move.w	#$0017,$1C2(a0)		;HSSTOP
		move.w	#$0021,$1C6(a0)		;HBSTOP
		move.w	#$0071,$1C0(a0)		;HTOTAL
		move.w	#$0000,$1CC(a0)		;VBSTRT
		move.w	#$0005,$1E0(a0)		;VSSTRT
		move.w	#$0003,$1CA(a0)		;VSSTOP
		move.w	#$001D,$1CE(a0)		;VBSTOP
		move.w	#$020E,$1C8(a0)		;VTOTAL
		move.w	#$0B88,$1DC(a0)		;BEAMCON0
		move.w	#$0000,$102(a0)		;BPLCON1
		move.w	#$027F,$104(a0)		;BPLCON2
		move.w	#$00A3,(a3)		;BPLCON3	;spr res
		move.w	#$0011,$10C(a0)		;BPLCON4

.exit:		bsr	SetModRegs
		move.l	#copper,$080(a0)
		move.w	#$8380,$096(a0)		;DMACON - enable mast/bpl/cop/(spr)
		move.w	#$0000,$088(a0)
		movem.l	(sp)+,d0/d1/a0/a1/a2/a3
		rts
;---
.h_centering:	move.l	h_center,d0
		neg.l	d0
		cmp.l	#8,d0
		blt.b	.h_lt8
		moveq	#8,d0			;depth 8
.h_lt8:		cmp.l	#-8,d0			;depth -8
		bgt.b	.h_gt8
		moveq	#-8,d0			;depth-8
.h_gt8:		add.l	#$001B,d0
		move.w	D0,$1DE(a0)		;HSSTRT
		rts
*---
.h_centering_m:	move.l	h_center,d0
		neg.l	d0
		cmp.l	#8,d0
		blt.b	.h_m_lt8
		moveq	#8,d0
.h_m_lt8:	cmp.l	#-8,d0
		bgt.b	.h_m_gt8
		moveq	#-8,d0
.h_m_gt8:	add.l	#$000D,d0
		move.w	D0,$1DE(a0)		;HSSTRT
		rts
*---
.sprites_pal:	rts

*---
.sprites_ntsc:	rts

*---
.v_centering_50:
		move.l	v_center,d0
		cmp.l	#23,d0
		blt.b	.v_50_lt23
		moveq	#23,d0
.v_50_lt23:	cmp.l	#-23,d0
		bgt.b	.v_50_gt23
		moveq	#-23,d0
.v_50_gt23:	sub.l	#10,d0
		lsl.l	#8,d0
		add.l	#$80*256,d0
		move.b	#$61,d0
		move.w	d0,$08E(a0)			;DIWSTRT
		add.l	#400*256,d0
		move.b	#$00,d0
		move.w	D0,$090(a0)			;DIWSTOP
		swap	d0
		lsl.l	#8,d0
		move.w	d0,$1E4(a0)			;DIWHIGH
		rts
*---
.v_centering_60:
		move.l	v_center,d0
		cmp.l	#23,d0
		blt.b	.v_60_lt23
		moveq	#23,d0
.v_60_lt23:	cmp.l	#-23,d0
		bgt.b	.v_60_gt23
		moveq	#-23,d0
.v_60_gt23:	sub.l	#10,d0
		lsl.l	#8,d0
		add.l	#$50*256,d0
		move.b	#$61,d0
		move.w	d0,$08E(a0)			;DIWSTRT
		add.l	#400*256,d0
		move.b	#$00,d0
		move.w	D0,$090(a0)			;DIWSTOP
		swap	d0
		lsl.l	#8,d0
		move.w	d0,$1E4(a0)			;DIWHIGH
		rts
*---
.m_centering_60:
		move.l	v_center,d0
		cmp.l	#23,d0
		blt.b	.m_60_lt23
		moveq	#23,d0
.m_60_lt23:	cmp.l	#-23,d0
		bgt.b	.m_60_gt23
		moveq	#-23,d0
.m_60_gt23:	sub.l	#10,d0
		lsl.l	#8,d0
		add.l	#$50*256,d0
		move.b	#$41,d0
		move.w	d0,$08E(a0)			;DIWSTRT
		add.l	#400*256,d0
		move.b	#$E1,d0
		move.w	D0,$090(a0)			;DIWSTOP
		swap	d0
		lsl.l	#8,d0
		move.w	d0,$1E4(a0)			;DIWHIGH
		rts

*--- used by SetYmode and SetSynch ---*

SetModRegs:	movem.l	d0/a0,-(sp)
		lea	copper_bpl_regs+2,a0
		move.l	synch_mode,d0
		cmp.l	#8,d0
		bge.w	.exit
;		jmp	([.jmptab,pc,d0.l*4])
.jmptab:	dc.l	.single
		dc.l	.single
		dc.l	.double
		dc.l	.double
		dc.l	.double
		dc.l	.double
		dc.l	.double
		dc.l	.double
.single:	tst.l	Y_mode
		bne.b	.singley1
		move.w	#-80,0(a0)		;BPL1MOD
		move.w	#-80,4(a0)		;BPL2MOD
		bra.b	.singleye
.singley1:	move.w	#0,0(a0)		;BPL1MOD
		move.w	#0,4(a0)		;BPL2MOD
.singleye:	bra.b	.exit

.double:	tst.l	Y_mode
		bne.b	.doubley1
		move.w	#-40,0(a0)		;BPL1MOD
		move.w	#-80,4(a0)		;BPL2MOD
		bra.b	.exit
.doubley1:	move.w	#-40,0(a0)		;BPL1MOD
		move.w	#0,4(a0)		;BPL2MOD
.exit:		movem.l	(sp)+,d0/a0
		rts
*---

WaitVBL:	move.l	d0,-(sp)
		move.b	$BFE801,D0
.wait:		cmp.b	$BFE801,D0
		beq.b	.wait
		move.l	(sp)+,d0
		rts

*********************************************************
SetBplPt:	MOVEM.L	D0/D1/A0,-(SP)
		move.l	screen_showed,d0
		tst.l	Y_mode
		bne.b	.y1
		add.l	#(640*255)/3,d0
.y1:		move.l	#(640*256)/3,d1
		lea	copper_bpl_pt,a0
		move.w	d0,$06(a0)
		swap	d0
		move.w	d0,$02(a0)
		swap	d0
		add.l	d1,d0
		move.w	d0,$0E(a0)
		swap	d0
		move.w	d0,$0A(a0)
		swap	d0
		add.l	d1,d0
		move.w	d0,$16(a0)
		swap	d0
		move.w	d0,$12(a0)
		swap	d0
		add.l	d1,d0
		move.w	d0,$1E(a0)
		swap	d0
		;move.w	d0,$1A(a0)
		;swap	d0
		;add.l	d1,d0
		;move.w	d0,$26(a0)
		;swap	d0
		;move.w	d0,$22(a0)
		;swap	d0
		;add.l	d1,d0
		;move.w	d0,$2E(a0)
		;swap	d0
		;move.w	d0,$2A(a0)
		;swap	d0
		;add.l	d1,d0
		;move.w	d0,$36(a0)
		;swap	d0
		;move.w	d0,$32(a0)
		;swap	d0
		;add.l	d1,d0
		;move.w	d0,$3E(a0)
		;swap	d0
		;move.w	d0,$3A(a0)
		MOVEM.L	(SP)+,D0/D1/A0
		rts

*********************************************************
SetVBInt:
	MOVEQ	#5,D0
	LEA	VBIntServer,A1
	MOVE.L	4.w,a6
	CALLSYS	AddIntServer
	MOVEQ	#4,D0
	LEA	VBIStore,A1
	MOVE.L	4.w,a6
	CALLSYS	AddIntServer
	MOVE.W	#$FFFF,VBIFlag
	RTS

PrepareResetVBI:
	TST.W	VBIFlag
	BNE.S	ResetVBInt
	RTS

ResetVBInt:
	CLR.W	VBIFlag
	MOVEQ	#5,D0
	LEA	VBIntServer,A1
	MOVE.L	4.w,a6
	CALLSYS	RemIntServer
	MOVEQ	#4,D0
	LEA	VBIStore,A1
	MOVE.L	4.w,a6
	CALLSYS	RemIntServer
	RTS

*********************************************************
*	GFX irq task for marks in dirscreen		*
*********************************************************
; white field in dir screen to select an file

VBIDirMouse:
	MOVEM.L D0-D3/A0,-(SP)
	MOVE.L DirMousetable(PC),A5
	TST.W	DirCopFlag
	BNE.S	DirCopNoReady
	MOVEM.W (MouseX),D0/D1
	LEA	DirGadData,A0
	MOVE.B	#$FF,MousKoordReg1

	MOVE.B	#$FF,di_chkwhitetflag
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	mt_moskoos
	CLR.W	DirCopFlag

	CLR.B	MousKoordReg1
	BSR.S	WhtSetFF
	CMP.W	#$26,D2
	BNE.S	WhtForb
	SUBQ.W	#3,D1				;fix, 4
	EXT.L	D1
	DIVU	#6,D1
	CMP.W	#$13,D1
	BEQ.S	WhtForb
	;CMP.W	$16(A5),D1			;double lines fix
	;BGE.S	WhtForb
	MOVE.W	scrtablecl,D2
	CMP.W	D1,D2				;mouse stand still
	BEQ.S	DirCopNoReady
	MOVE.W	D1,scrtablecl
	BSR.S	ClrWhiteLines
	BRA.S	DirCopNoReady

WhtForb:
	MOVE.W	#$FFFF,scrtablecl
DirCopNoReady:
	MOVEM.L (SP)+,D0-D3/A0
	RTS

DirCopFlag:	dc.w	$FFFF

WhtSetFF:
	MOVEM.W D0-D7,-(SP)
	CMP.W	#$FFFF,scrtablecl
	BEQ.S	WhtSetFFRt
	CMP.W	#$26,D2
	BNE.S	WhtSetFFMk
	SUBQ.W	#3,D1
	DIVU	#6,D1
	MOVE.W	scrtablecl,D2
	CMP.W	D1,D2				;mouse stand still
	BEQ.S	WhtSetFFRt
WhtSetFFMk:
	BSR.S	ClrWhiteLines
WhtSetFFRt:
	MOVEM.W (SP)+,D0-D7
	RTS

WhtSetCopl:
	cmp.w	#3,CurrScreen
	bne.b	getcopo
	rts
getcopo:
	CMP.W	#$FFFF,scrtablecl
	BEQ.S	WhtSetCopRt
	MOVEM.W D0-D7/A0,-(SP)
	BSR.S	ClrWhiteLines
	MOVEM.W (SP)+,D0-D7/A0
WhtSetCopRt:
	RTS

ClrWhiteLines:
	MOVE.W	scrtablecl,D1
	MULU	#6,D1
	ADDQ.W	#3,D1
	LEA	PTBitMap+DirScreenPos,A0
	MULU	#$50,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	#6,D2

ClrWht1:
	MOVE.W	#$24,D3
	MOVE.B	(A0),D0
	EOR.B	#$3F,D0
	MOVE.B	D0,(A0)+

.loo:	EOR.B	#$FF,(A0)+
	DBRA	D3,.loo				;rectangle white ready?
	LEA	$2A(A0),A0
	DBRA	D2,ClrWht1
	RTS

scrtablecl:
	dc.w	$FFFF

*********************************************************
*	Main vbint-irq from protracker 			*
*********************************************************
vbint:	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR	UpdatePointerPos		;refresh mouse
	BSR	VUmeters
	TST.L	CopListPtr
	BEQ.S	NoCopListSet
	MOVE.L	CopListPtr,COP1LC

NoCopListSet:
	CMP.W	#3,CurrScreen			;DIR Window?
	BNE.B	NoDirVBI			;NO
	BSR	VBIDirMouse

NoDirVBI:
	CALL	ArrowKeys
	BSR	UpdateTicks
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*---
CopIntVec:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.S	CopIntVec2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

CopIntVec2:
	BTST	#3,Packetfield			;SoftVec?
	BEQ	Scope
	LEA	ScopSoftIntVec,A1
	MOVE.L	4.w,a6
	CALLSYS	Cause
	RTS

CopIntScop:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	Scope
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

VBIntServer:
	dc.l	0,0
	dc.b	02,00		;type, priority
	dc.l	.vbintname
	dc.w	0,0
	dc.l	vbint

.vbintname:
	dc.b	'PT'
	Revision
	dc.b	' VBInt',0
	EVEN

*---
VBIFlag:
	dc.w	0

*---
VBIStore:
	dc.l	0,0
	dc.b	02,00		;type, priority
	dc.l	copintname
	dc.w	0,0
	dc.l	CopIntVec

copintname:
	dc.b	'PT'
	Revision
	dc.b	' CopInt',0,0

	dc.b	0,0,0,0,0,0
	dc.b	02,$E0		;type, priority
	dc.l	.softintname
	dc.b	0,0,0,0
	dc.l	copintrun

.softintname:
	dc.b	'PT'
	Revision
	dc.b	' Pattern SoftInt',0
	EVEN

*********************************************************
copintrun:
	MOVEM.L D0-D7/A0-A6,-(SP)
	CMP.L	#'patp',RunMode
	BNE.S	.ret

	TST.W	SamScrEnable
	BNE.S	.ret
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	ADD.L	playpos,A0
	MOVEQ	#0,D0
	MOVE.B	(A0),D0
	CMP.L	PatternNumber,D0
	BEQ.S	.ret
	MOVE.L	D0,PatternNumber
	CALL	RedrawPattern4			;redraw tracks

.ret:	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*---
VBISoftIntStore:
	dc.l	0,0
	dc.b	02,$20
	dc.l	softintname
	dc.w	0,0
	dc.l	mt_musicsoft

softintname:
	dc.b	'PT'
	Revision
	dc.b	' Music SoftInt',0
	EVEN
*---
ScopSoftIntVec:
	dc.l	0,0
	dc.b	02,$E0
	dc.l	scopeintname
	dc.w	0,0
	dc.l	CopIntScop		;scope int

scopeintname:
	dc.b	'PT'
	Revision
	dc.b	' Scope SoftInt',0
	EVEN
*---
Chan0int.msg:
	dc.l	0,0
	dc.b	02,00
	dc.l	aud0name
	dc.l	audchan1temp
	dc.l	sint_a

aud0name:
	dc.b	'PT'
	Revision
	dc.b	' Aud0Int',0
	EVEN

*---
Chan1int.msg:
	dc.l	0,0
	dc.b	02,00
	dc.l	aud1name
	dc.l	audchan2temp
	dc.l	sint_b

aud1name:
	dc.b	'PT'
	Revision
	dc.b	' Aud1Int',0
	EVEN
*---
Chan2int.msg:
	dc.l	0,0
	dc.b	02,00
	dc.l	aud2name
	dc.l	audchan3temp
	dc.l	sint_c

aud2name:
	dc.b	'PT'
	Revision
	dc.b	' Aud2Int',0
	EVEN
*---
Chan3int.msg:
	dc.l	0,0
	dc.b	02,00
	dc.l	aud3name
	dc.l	audchan4temp
	dc.l	sint_d

aud3name:
	dc.b	'PT'
	Revision
	dc.b	' Aud3Int',0
	EVEN

*********************************************************
*	Set interrupt vectors for pt			*
*********************************************************
intwarm:
	MOVE.W	#$780,INTENA
	MOVEQ	#7,D0
	MOVE.L	#Chan0int.msg,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVE.L	D0,irq0veks
	MOVEQ	#8,D0
	MOVE.L	#Chan1int.msg,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVE.L	D0,irq1veks
	MOVEQ	#9,D0
	MOVE.L	#Chan2int.msg,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVE.L	D0,irq2veks
	MOVEQ	#10,D0
	MOVE.L	#Chan3int.msg,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVE.L	D0,irq3veks
	RTS

*********************************************************
resetirqveks:
	MOVEQ	#7,D0
	MOVE.L	irq0veks,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVEQ	#8,D0
	MOVE.L	irq1veks,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVEQ	#9,D0
	MOVE.L	irq2veks,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	MOVEQ	#10,D0
	MOVE.L	irq3veks,A1
	MOVE.L	4.w,a6
	CALLSYS	SetIntVector
	RTS

sint_a:	LEA	$00A0(A0),A6
	BRA.S	SInt_bg

sint_b:	LEA	$00B0(A0),A6
	BRA.S	SInt_bg

sint_c:	LEA	$00C0(A0),A6
	BRA.S	SInt_bg

sint_d:	LEA	$00D0(A0),A6

SInt_bg:
	MOVE.L	A0,A5
	MOVE.W	#$4000,$9A(A5)
	TST.B	$0038(A1)
	BNE.W	sint_aq

	TST.B	$0036(A1)
	BEQ.W	qint_rz

	MOVE.W	$003A(A1),D0
	BNE.S	sint_mk

	BTST	#3,InfoOnOff
	BEQ.S	sint_jk

	MOVEQ	#$50,D1
	CALL	dmafog1
sint_jk:
	MOVE.L	$0040(A1),D1
	BEQ	qint_rz
	MOVE.L	D1,A0
	TST.L	(A0)
	BLE	qint_rz
	MOVE.W	6(A0),D1
	ADDQ.L	#8,$0040(A1)
	MOVE.W	D1,$004A(A1)
	MOVE.W	D1,$0048(A1)
	BSR.S	sint_gr

	MOVE.W	D1,8(A6)
	MOVE.W	$0010(A1),6(A6)
	MOVE.W	$0050(A1),$0096(A5)
	MOVE.W	$0052(A1),$009C(A5)
	BRA	sint_rz

sint_gr:
	MOVE.W	$004C(A1),D0
	BNE.S	sint_li
	MOVEQ	#0,D1
	BRA.S	sint_rt

sint_li:
	TST.W	D1
	BEQ.S	sint_rt
	MULU	D0,D1
	ADD.W	#$0020,D1
	LSR.W	#6,D1
	BNE.S	sint_rt
	MOVEQ	#1,D1
sint_rt:
	RTS

sint_mk:
	MOVE.W	$0052(A1),$009C(A5)
	MOVE.W	$004A(A1),D1
	MOVE.W	D1,$0048(A1)
	BSR.S	sint_gr
	MOVE.W	D1,8(A6)
	MOVE.L	$0040(A1),D1
	BEQ.S	sint_bi
	MOVE.L	D1,A0
sint_db:
	MOVE.L	(A0)+,D1
	BGT.S	sint_ro
	BEQ.S	sint_ru
	ADD.L	D1,A0
	BRA.S	sint_db

sint_ro:
	MOVE.L	D1,(A6)
	MOVE.W	(A0)+,4(A6)
	MOVE.W	(A0)+,$004A(A1)
	MOVE.L	A0,$0040(A1)
	BRA.W	sint_rz

sint_ru:
	MOVE.L	#PTBitMap+ScopeBoxPos,(A6)
	MOVE.W	#$0010,4(A6)
	MOVE.W	D1,$004A(A1)
	MOVE.L	D1,$0040(A1)
	BRA.W	sint_rz

sint_bi:
	MOVE.W	$0052(A1),$009A(A5)
	MOVE.W	$004E(A1),$0096(A5)
	SF	$0036(A1)
	CLR.W	$004A(A1)
	CLR.W	$0048(A1)
	MOVE.W	D1,8(A6)
	MOVE.W	#1,6(A6)
	BRA.S	sint_rz

sint_aq:
	TST.W	$003A(A1)
	BEQ.S	sint_sq
	CMP.W	#1,$003A(A1)
	BEQ.S	sint_dr
	BRA.S	qint_rz

sint_sq:
	BTST	#3,InfoOnOff
	BEQ.S	sint_sx
	MOVEQ	#$50,D1
	CALL	dmafog1
sint_sx:
	MOVEQ	#0,D0
	MOVE.B	$0013(A1),D0
	MULU	$0014(A1),D0
	ADD.W	#$0020,D0
	LSR.W	#6,D0
	MOVE.W	D0,8(A6)
	MOVE.W	$0050(A1),$0096(A5)
	MOVE.W	$0052(A1),$009C(A5)
	MOVE.W	$0010(A1),6(A6)
	BRA.S	sint_rz

sint_dr:
	MOVE.W	$0052(A1),$009C(A5)
	MOVE.W	$0052(A1),$009A(A5)
	CLR.B	$0038(A1)
	MOVE.L	10(A1),(A6)
	MOVE.W	14(A1),4(A6)
sint_rz:
	ADDQ.W	#1,$003A(A1)
	MOVE.W	#$C000,$009A(A5)
	RTS

qint_rz:
	MOVE.W	#$FFFF,D0
qint_rb:
	MOVE.W	D0,D1
	AND.W	#$0F00,D1
	;MOVE.W	D1,COLOR	      		; empty sample play=errorblitz
	DBRA	D0,qint_rb
	MOVE.W	$0052(A1),$009A(A5)
	CLR.B	$0038(A1)
	CLR.B	$0036(A1)
	BRA.S	sint_rz

intmagfield:
	BSET	#0,Packetfield
	BSR.S	SetCIAInt
	BNE.S	qint_rt
	MOVEQ	#0,D0
	RTS

qint_rt:
	MOVEQ	#-1,D0
	RTS

qint_er:

	MOVE.L	ciares,D0
	BNE.W	ResetCIAInt
	RTS

MusicIntServer: dc.l	0,0
		dc.b	$02,$10				;Type, priority
		dc.l	musintname
		dc.w	0,0
		dc.l	mt_music
musintname:	dc.b	'Protracker CIA MusicInt',0
		EVEN

*********************************************************
* 	Set & alloc CIA, called by PT start		*
*********************************************************
SetCIAInt:
	LEA	$BFD000,A5
	MOVE.B	#'b',CIAAname+3
	BSR.S	CheckForPAL
	BNE.S	TryTimerAB
	BSR.W	TryTimerA
	BEQ.S	NoTimerFree
	BSR.W	TryTimerB
	BEQ.S	NoTimerFree

TryTimerAB:
	MOVE.B	#'a',CIAAname+3
	LEA	$00BFE001,A5
	BSR.S	CheckForPAL
	BNE.S	TryTimABlo
	BSR.W	TryTimerA
	BEQ.S	NoTimerFree
	BSR	TryTimerB
	BEQ.S	NoTimerFree
TryTimABlo:
	CLR.L	ciares
	TST.L	CopListPtr
	BNE.S	TimerFree

	move.l	ReqBase,d0			;reqtools available?
	beq.s	useintuireq4			;no
	move.l	d0,a6
	lea	RText7(pc),a1
	lea	RUnderstood(pc),a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a0,a0
	CALLSYS	rtEZRequestA
	bra.s	TimerFree

useintuireq4:
	LEA	CIAErrorPo(PC),A1
	BSR.W	OpenErrorRequester

TimerFree:
	MOVEQ	#-1,D0
	RTS

NoTimerFree:
	MOVEQ	#0,D0
	RTS

*---
CheckForPAL:
	MOVEQ	#0,D0
	LEA	CIAAname(PC),A1
	MOVE.L	4.w,a6
	CALLSYS	OpenResource
	MOVE.L	D0,ciares
	BEQ.W	CIAError
	MOVE.L	D0,A6
	MOVE.L	GfxBase,A0
	MOVE.W	$00CE(A0),D0			; Displayflags
	BTST	#2,D0				; PAL?
	BEQ.S	NTSCValue
	MOVE.L	#1773447,D7			; PAL
	BRA.S	sciask

*---
NTSCValue:
	MOVE.L	#1789773,D7			; NTSC
sciask:
	MOVE.L	D7,timer
	DIVU	#$007D,D7			; /125, Default to normal 50 Hz Timer
	MOVEQ	#0,D0
	RTS

*---
TryTimerB:
	LEA	MusicIntServer(PC),A1
	MOVEQ	#1,D0				; Bit 1 = Timer B
	JSR	LIB_OPEN2(a6)
	MOVE.L	#1,TimerFlag
	TST.L	D0
	BNE.S	CIAError
	MOVE.L	A5,CIAAaddr
	BCLR	#0,$0F00(A5)
	MOVE.B	D7,$0600(A5)
	LSR.W	#8,D7
	MOVE.B	D7,$0700(A5)
	MOVEQ	#0,D0
	RTS

TryTimerA:
	LEA	MusicIntServer(PC),A1
	MOVEQ	#0,D0				; Bit 0 = Timer A
	JSR	LIB_OPEN2(A6)
	CLR.L	TimerFlag
	TST.L	D0
	BNE.S	CIAError
	MOVE.L	A5,CIAAaddr
	BCLR	#0,$0E00(A5)
	MOVE.B	D7,$0400(A5)
	LSR.W	#8,D7
	MOVE.B	D7,$0500(A5)
	MOVEQ	#0,D0
	RTS

CIAError:
	MOVEQ	#-1,D0
	RTS

*********************************************************
ResetCIAInt:
	CLR.L	ciares
	MOVE.L	D0,A6
	MOVE.L	CIAAaddr(PC),A5
	TST.L	TimerFlag
	BEQ.S	ResTimerA
	BCLR	#0,$0F00(A5)
	MOVEQ	#1,D0
	BRA.S	RemInt

ResTimerA:
	BCLR	#0,$0E00(A5)
	MOVEQ	#0,D0

RemInt: LEA	MusicIntServer(PC),A1
	MOVEQ	#0,D0
	JSR	LIB_CLOSE2(A6)
	RTS

CIAAname:	dc.b	'ciaa.resource',0
ciares:		dc.l	0
TimerFlag:	dc.l	0
timer:		dc.l	0

*********************************************************
*			Tempo gad			*
*********************************************************
TempoGadg:
	OR.B	#0,D0
	CMP.W	#$005E,D0
	BCC.S	TemDown
	CMP.W	#$0050,D0
	BCC.S	TemUp
	RTS

TemUp:	MOVE.W	BPMTempo,D0
	ADDQ.W	#1,D0

	checkrmb
	BNE.S	.l1
	ADDQ.W	#8,D0
	ADDQ.W	#1,D0

.l1:	CMP.W	#255,D0
	BLS.S	tmpok
	MOVE.W	#255,D0

tmpok:	MOVE.W	D0,BPMTempo
	MOVE.W	D0,RealTempo
	BSR.S	ShowTempo
	BSR.S	SetTempo
	GOTO	Wait_4000

*---
TemDown:
	MOVE.W	BPMTempo,D0
	SUBQ.W	#1,D0
	checkrmb
	BNE.S	.l1
	SUBQ.W	#8,D0
	SUBQ.W	#1,D0

.l1:	CMP.W	#32,D0
	BCC.S	tmpok
	MOVE.W	#32,D0
	BRA.S	tmpok

*********************************************************
ShowTempo:
	CMP.W	#5,CurrScreen			; setup
	BEQ.B	ShowTempo1			; yes
	;CMP.W	#2,CurrScreen
	;BEQ.S	ShowTempo1
	;CMP.W	#8,CurrScreen
	;BEQ.S	ShowTempo1			; timershow in setupscreen
	;CMP.W	#9,CurrScreen
	;BEQ.S	ShowTempo1
	RTS

ShowTempo1:
	MOVE.W	#$103,TextOffset		; tempotext pos
	MOVE.W	RealTempo(PC),WordNumber
	GOTO	Print3DecDigits_2

*********************************************************
SetTempo:
	MOVEQ	#$7D,D0
	MOVE.L	ciares,D1
	BEQ.S	setesk3
	BTST	#0,Packetfield
	BEQ.S	SetTempo2
	MOVE.W	RealTempo(PC),D0
SetTempo2:
	CMP.W	#$0020,D0
	BCC.S	SetTempo3
	MOVEQ	#$20,D0
SetTempo3:
	BTST	#0,Packetfield
	BEQ.S	setesk3
	MOVE.W	D0,RealTempo
setesk3:
	TST.W	SamScrEnable
	BNE.S	setesk2


	MOVE.W	D0,WordNumber
	MOVE.W	#$016C,fl3DecDigit1		; x=605
	MOVE.W	#$0080,fl3DecDigit2		; y=143
	CALL	Print3DecDigits 		; bpm
setesk2:
	MOVE.L	ciares,D0
	BNE.S	rtulk
bgff:	RTS

rtulk:
	MOVEQ	#$7D,D0
	BTST	#0,Packetfield
	BEQ.S	rtulv
	MOVE.W	RealTempo(PC),D0
rtulv:
	MOVE.L	timer(PC),D1
	DIVU	D0,D1
	MOVE.L	CIAAaddr(PC),A5
	MOVE.L	TimerFlag(PC),D0
	BEQ.S	rtul_rt
	AND.B	#$F7,$0F00(A5)
	OR.B	#$11,$0F00(A5)
	MOVE.B	D1,$0600(A5)
	LSR.W	#8,D1
	MOVE.B	D1,$0700(A5)
	RTS

rtul_rt:
	AND.B	#$F7,$0E00(A5)
	OR.B	#$11,$0E00(A5)
	MOVE.B	D1,$0400(A5)
	LSR.W	#8,D1
	MOVE.B	D1,$0500(A5)
	RTS

RealTempo:	dc.w	125
CIAAaddr:	dc.l	0

*********************************************************
*  		Protracker Input handler		*
*********************************************************
InitInputHandler:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	4.w,a6
	LEA	InpDefBuf,A1
	MOVE.L	A1,-(SP)
	MOVEQ	#-1,D0
	CALLSYS	AllocSignal
	MOVE.L	D0,D2
	SUB.L	A1,A1
	CALLSYS	FindTask
	MOVE.L	(SP)+,A1
	CLR.B	9(A1)
	MOVE.L	#inpevname,16(A1)		; IND_ADDHANDLER
	MOVE.B	#4,8(A1)
	MOVE.B	D2,15(A1)
	MOVE.L	D0,16(A1)
	CALLSYS	AddPort
	MOVEM.L (SP)+,D0-D7/A0-A6

	MOVE.L	4.w,a6
	LEA	InputDevice,A0
	MOVEQ	#0,D0
	LEA	inputdevtags,A1
	MOVEQ	#0,D1
	MOVE.L	#InpDefBuf,14(A1)	;Portname
	CALLSYS	OpenDevice
	TST.L	D0
	BNE.S	Resetmachine
	LEA	inputdevtags,A1
	MOVE.W	#9,$1C(A1)
	MOVE.L	#InpEvStuff,$28(A1)
	CALLSYS	DoIO
	RTS

*********************************************************
Resetmachine:
	JMP	$F80000

*********************************************************
*	Remove PT input handler				*
*********************************************************
RemovePTPort:
	MOVE.L	4.w,a6
	LEA	inputdevtags,A1
	MOVE.W	#10,$1C(A1)
	MOVE.L	#InpEvStuff,$28(A1)
	CALLSYS	DoIO
	LEA	inputdevtags,A1
	CALLSYS	CloseDevice
	LEA	InpDefBuf,A1
	CALLSYS	RemPort
	RTS

loop1:	dc.b	$F4,$BC
*---
InpEvStuff:
	dc.l	0,0
	dc.w	$0234			; type, priority
	dc.l	inpevname
	dc.w	0,0
	dc.l	InputHandler

inpevname:
	dc.b	'Protracker InputHandler',0

*********************************************************
* A0 - Input 	A1-Data Area				*
*********************************************************
InputHandler:
	MOVE.L	A2,-(SP)
	TST.B	AutoReqRunning
	BNE.S	inphend
	SUB.L	A2,A2				; min kick2.0
	MOVE.L	A0,A1
	MOVE.B	4(A1),D0			; ie_Class
	CMP.B	#1,D0				; Rawkey
	BEQ.S	InpRawkey
	CMP.B	#2,D0				; RawMouse
	BEQ.S	InpRawmouse
	MOVE.L	A1,A2

InpNext:
	MOVE.L	(A1),A1
	MOVE.L	A1,D0
	BNE.S	InputHandler

inphend:
	MOVE.L	A0,D0
	MOVE.L	(SP)+,A2
	RTS

*********************************************************
* 		rawkey event input			*
*********************************************************
InpRawkey:
	BSR	InpUnchain
	MOVE.W	6(A1),D0		;e_eRAWKEY+2
	;MOVE.W	8(A1),D1		;E_eTIMETICK
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR	ProcessRawkey
	MOVEM.L (SP)+,D0-D7/A0-A6
	BRA	InpNext

*********************************************************
*		rawmouse event input			*
*********************************************************
InpRawmouse:
	BSR.W	InpUnchain
	MOVE.W	MouseX3,D0
	MOVE.W	MouseY3,D1
	MOVE.W	10(A1),D2
	MOVE.W	12(A1),D3
	TST.W	MouseFreezeFlag
	BEQ.S	InpRMs2
	ADD.W	D2,MouseFlag
	ADD.W	D3,MouseFlag+2			;Vertical screen moving

InpRMs2:
	TST.W	MouseFreezeFlag
	BNE.S	InpRMs3
	ADD.W	D2,D0
	ADD.W	D3,D1
	ASR.W	#1,D3
	TST.W	D0
	BPL.S	InpRMret
	MOVEQ	#0,D0
InpRMret:
	TST.W	D1
	BPL.S	InpRMret1
	MOVE.W	D3,ResKeyTiByte
	MOVEQ	#0,D1
InpRMret1:
	CMP.W	#$27F,D0			;max xpos
	BMI.S	InpRMmax
	MOVE.W	#$27F,D0

InpRMmax:
	MOVE.W	#$1FF,D2			;511
	BTST	#0,VModeField			;NTSC?
	BEQ.S	InpRMmax1
	SUB.W	#$64,D2				;-100

InpRMmax1:
	CMP.W	D2,D1
	BMI.S	InpRMs3
	MOVE.W	D3,ResKeyTiByte
	MOVE.W	D2,D1

InpRMs3:
	MOVE.W	D1,MouseY3
	MOVE.W	ScrPosYValue,D2
	ADD.W	D2,D2
	ADD.W	D2,D1
	MOVE.W	D0,MouseX3
	MOVE.W 	D1,MouseY4
	LSR.W	#1,D1
	MOVE.W	D0,MouseX
	MOVE.W	D1,MouseY
	BRA	InpNext

InpUnchain:
	MOVE.L	A2,D0
	BNE.S	InpUnc2
	MOVE.L	(A1),A0
	RTS

InpUnc2:
	MOVE.L	(A1),(A2)
	RTS

*********************************************************
* 		rawkey input keyboard			*
*********************************************************
ProcessRawkey:
	CMP.B	mt_lastrawkey,D0
	BNE.S	recme
	TST.B	KeyRepeat			;keyrepeat test
	BNE.S	recme2
	RTS

recme2: BRA.S	rgdd

recme:	MOVE.B	D0,mt_lastrawkey
	;CMP.B	 #67+128,D0
	;BEQ.W	 EnterKeyOff
	CMP.B	#96,D0
	BEQ.W	ShiftOn
	CMP.B	#97,D0
	BEQ.W	ShiftOn2
	CMP.B	#100,D0
	BEQ.W	AltOn				; LALT
	CMP.B	#101,D0
	BEQ.W	AltOn2				; RALT
	CMP.B	#99,D0
	BEQ.W	CtrlOn
	CMP.B	#102,D0
	BEQ.W	LeftAmigaOn
	CMP.B	#99+128,D0
	BEQ.W	CtrlOff
	CMP.B	#100+128,D0
	BEQ.W	AltOff
	CMP.B	#96+128,D0
	BEQ.S	ShiftOff
	CMP.B	#101+128,D0
	BEQ.B	AltOff
	CMP.B	#97+128,D0
	BEQ.S	ShiftOff
	CMP.B	#102+128,D0
	BEQ.W	LeftAmigaOff
rgdd:	CMP.B	#98,D0
	BEQ.S	KeyRepOn
	CMP.B	#98+128,D0
	BEQ.S	KeyRepOff

kbintSetKey:
	TST.B	D0
	BNE.B	kbintDoSet
	MOVE.B	#127,D0

kbintDoSet:
	MOVE.W	mt_keybufpos(PC),D1
	CMP.W	#$14,D1
	BCS.B	kbintdoset2
	RTS

kbintdoset2:
	LEA	mt_keybuffer(PC),A3
	MOVE.B	D0,(A3,D1.W)
	ADDQ.W	#1,mt_keybufpos
	RTS

*---
KeyRepOn:	ST	KeyRepeat
		RTS

KeyRepOff:	SF	KeyRepeat
		RTS

ShiftOn:	MOVE.B	#1,ShiftKeyStatus
		RTS

ShiftOn2:	MOVE.B	#1,ShiftKeyStatus
		BRA.B	kbintSetKey

ShiftOff:	CLR.B	ShiftKeyStatus
		RTS

AltOn:		MOVE.W	#1,AltKeyStatus
		RTS

AltOn2:		MOVE.W	#1,AltKeyStatus
		BRA.B	kbintSetKey

AltOff:		CLR.W	AltKeyStatus
		RTS

CtrlOn:		MOVE.W	#1,CtrlKeyStatus
		RTS

CtrlOff:	CLR.W	CtrlKeyStatus
		RTS

LeftAmigaOn:	MOVE.W	#1,LeftAmigaStatus
		RTS

LeftAmigaOff:	CLR.W	LeftAmigaStatus
		RTS

*********************************************************
EnterKeyChange:
	MOVEM.L D0-A6,-(SP)
	BSR.S	ClearAllKeys
	LEA	enterchar,a0
	TST.W	EnterKeyStatus
	BEQ.S	EnterKeyOn
	MOVE.B	#' ',(a0)
	CLR.W	EnterKeyStatus
	BRA.S	showenter

EnterKeyOn:
	MOVE.W	#1,EnterKeyStatus
	MOVE.B	#'X',(A0)

showenter:
	MOVEQ	#1,D0
	MOVE.W	#$2834,D1
	CALL	ShowText3
	CALL	Wait_4000
	MOVEM.L (SP)+,D0-A6
	RTS

*********************************************************
ClearAllKeys:
	CLR.W	AltKeyStatus
	CLR.W	CtrlKeyStatus
	CLR.W	LeftAmigaStatus
	CLR.B	ShiftKeyStatus
	;CLR.W	EnterKeyStatus
	CLR.B	RawKeyCode
	RTS

*********************************************************
DoKeyBuffer:
	MOVE.W	mt_keybufpos(PC),D0
	BNE.S	DoKeyBuffer2
	RTS

DoKeyBuffer2:
	SUBQ.W	#1,D0
	LEA	mt_keybuffer(PC),A0
	MOVE.B	(A0,D0.W),D1
	MOVE.W	D0,mt_keybufpos
	MOVE.B	D1,RawKeyCode
	MOVE.B	D1,mt_savekey
	;move.w	KeyRepDelay,mt_keyrepcounter  	; 4.0
	btst	#7,D1
	AND.B	#$80,D1
	BEQ.B	dkbend
	CLR.B	RawKeyCode
	CLR.B	mt_lastrawkey
	CLR.w	mt_keyrepcounter

dkbend:	RTS

mt_keybufpos:		dc.w	0
mt_keybuffer:		dc.l	0,0,0,0
AltKeyStatus:		dc.w	0
CtrlKeyStatus:		dc.w	0
LeftAmigaStatus:	dc.w	0
EnterKeyStatus: 	dc.w	0
mt_lastrawkey:		dc.b	255,0
mt_savekey:		dc.b	0,0
KeyRepeat:		dc.b	0,0
mt_savekeyRepeat:	dc.w	0
mt_keyrepcounter:	dc.w	0
enterchar:		dc.w	'  ',0,0

*********************************************************
* 		refresh the own mouse sprite		*
*********************************************************
UpdatePointerPos:
	MOVE.W	MouseX,D0
	LSR.W	#1,D0
	ADDQ.W	#3,D0
	MOVE.W	MouseY3,D1
	LSR.W	#1,D1
	MOVEQ	#11,D2
	MOVE.L	PointerSpritePtr,A0
	ADD.W	ScrPosYValue,D1
	CALL	SetSpritePos
	RTS

UpdateTicks:
	CMP.L	#'patp',RunMode
	BEQ.S	UpdateTicks2
	RTS

UpdateTicks2:
	ADDQ.W	#1,PatternTicks
	MOVE.W	PatternTicks(PC),D0
	MOVE.L	4.w,A0
	CMP.B	$212(A0),D0
	BEQ.S	PatternTicks1
	RTS

PatternTicks1:
	CLR.W	PatternTicks
	ADDQ.L	#1,TimerTicks
	RTS

*********************************************************
*		timer functions in mainscreen		*
*********************************************************
ShowTimer:
	CMP.W	#1,CurrScreen		; main
	BEQ.B	ShowTimer1
	CMP.W	#9,CurrScreen
	BEQ.B	ShowTimer1
	RTS
ShowTimer1:
	MOVE.W	#0,WordNumber
	MOVE.W	#$0A96,TextOffset
	CALL	Print2DecDigits 	; playtime first digit
	MOVE.L	TimerTicks(PC),D0
	DIVU	#$003C,D0
	MOVE.W	D0,WordNumber
	SWAP	D0
	MOVE.W	D0,D7
	ADDQ.W	#1,TextOffset
	CALL	Print2DecDigits

	MOVE.W	D7,WordNumber
	ADDQ.W	#1,TextOffset
	CALL	Print2DecDigits

	MOVE.L	#tim_fla,D1
	MOVE.L	DOSBase,A6
	CALLSYS	Deallocate
	MOVE.L	tim_fla,D0
	MOVE.L	scrtable1,D1
	;CMP.W	#1,CurrScreen		; fix
	;BNE	st_ala			; fix
	;CMP.L	D1,D0
	;BEQ.S	st_ala
	BSR.W	PrintDate
st_ala:
	MOVE.L	tim_flb,D0
	MOVE.L	scrtable2,D1
	;CMP.L	D1,D0			; fix for other than screens #1
	;BEQ.S	st_alb
	BSR.S	st_altime
st_alb:
	MOVE.L	tim_flc,D0
	DIVU	#$0032,D0
	MOVE.L	D0,tim_flc
	MOVE.L	scrtable3,D1
	CMP.L	D1,D0
	BEQ.S	st_alc
	BSR.S	st_ald
st_alc:
	LEA	tim_fla,A0
	LEA	scrtable1,A1
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	RTS

st_altime:
	DIVU	#$003C,D0
	move.w	d0,fa_creattime_h
	MOVE.W	D0,WordNumber
	SWAP	D0
	MOVE.W	D0,-(SP)
	MOVE.W	#$0816,TextOffset
	CALL	Print2DecDigits 	;time
	MOVE.W	(SP)+,D0
	MOVE.W	D0,WordNumber
	ADDQ.W	#1,TextOffset
	move.w	d0,fa_creattime_m
	CALL	Print2DecDigits
	RTS

st_ald:	EXT.L	D0
	DIVU	#$003C,D0
	SWAP	D0
	MOVE.W	D0,WordNumber
	MOVE.W	#$081C,TextOffset
	move.w	d0,fa_creattime_s
	CALL	Print2DecDigits
	RTS

*********************************************************
*		date output in pt mainscreen		*
*********************************************************
PrintDate:
	CALL	CalcDate
	BEQ.W	ShowTimer1
	MOVE.W	TheDay,D0
	MOVE.W	D0,WordNumber
	move.w	d0,fa_creatdat_da
	MOVE.W	#$0596,TextOffset
	CALL	Print2DecDigits
	LEA	Months.MSG,A0
	MOVE.W	TheMonth,D0
	move.w	d0,fa_creatdat_mo
	SUBQ.W	#1,D0
	MULU	#5,D0
	ADD.W	D0,A0
	MOVE.W	#$0598,D1
	MOVE.W	#5,D0
	CALL	ShowText3
	MOVE.W	TheYear,D0
	MOVE.W	D0,WordNumber
	move.w	d0,fa_creatdat_ye
	MOVE.W	#$059D,TextOffset
	CALL	Print2DecDigits
	RTS

tim_fla:	dc.l	0
tim_flb:	dc.l	0
tim_flc:	dc.l	0
scrtable1:	dc.l	0
scrtable2:	dc.l	0
scrtable3:	dc.l	0
PatternTicks:	dc.w	0
TimerTicks:	dc.l	0
Months.MSG:	dc.b	'-JAN--FEB--MAR--APR--MAY--JUN--JUL--AUG--SEP'
		dc.b	'--OCT--NOV--DEC-MON-TUE-WED-THU-FRI-SAT-SUN-'

*********************************************************
*		Protracker Audio Scopes (1/2/4)		*
*********************************************************
Scope:	LEA	audchan1temp,A0
	LEA	ScopeInfo,A2
	LEA	ScopeSamInfo,A1
	LEA	BlankSample,A3

	move.w	numchans,D6
	subq.w	#1,D6

scoploop:
	MOVE.W	(A0),D0
	AND.W	#$FFF,D0
	OR.W	$10(A0),D0
	BEQ.S	scoaret
	MOVE.W	$10(A0),$10(A2)
	MOVE.B	$13(A0),$12(A2)
	TST.B	$2A(A0)				;sample empty?
	BEQ.S	scoa1
	SF	$2A(A0)
	BSR.W	MakeScope
	MOVEQ	#0,D0
	MOVE.B	$2B(A0),D0
	SUBQ.W	#1,D0
	LSL.W	#4,D0
	MOVE.L	(A1,D0.W),(A2)
	MOVE.L	4(A1,D0.W),4(A2)
	MOVE.L	8(A1,D0.W),8(A2)
	MOVE.L	12(A1,D0.W),12(A2)
	MOVE.L	(A2),D0
	CMP.L	A3,D0
	BEQ.S	scoar
	BRA.S	scoa2

;---
scoa1:
	MOVE.L	(A2),D0
	CMP.L	A3,D0
	BEQ.S	scoar
	MOVEQ	#0,D1
	MOVE.W	$10(A2),D1
	LSR.W	#1,D1
	BEQ.S	scoar
	MOVE.L	#$8A8D,D2
	DIVU	D1,D2
	EXT.L	D2
	ADD.L	D2,D0
scoa2:
	CMP.L	4(A2),D0
	BCS.S	scoad
	TST.L	8(A2)
	BNE.S	scoac
scoaret:
	MOVE.L	A3,D0
	BRA.S	scoad

scoac:	SUB.L	4(A2),D0
	ADD.L	8(A2),D0
	MOVE.L	12(A2),4(A2)
	CMP.L	4(A2),D0
	BCC.S	scoac
scoad:
	MOVE.L	D0,(A2)
scoar:
	ADD.L	#$14,A2
	LEA	$58(A0),A0
	DBRA	D6,scoploop
	MOVEQ	#-1,D4
	TST.W	SamScrEnable
	BEQ.S	NormalScopes
	MOVEQ	#0,D4

NormalScopes:
	MOVEQ	#0,D7
	MOVE.W	DMACONR,D6

*--- channel 1 ---*

	CLR.W	ScopeFlagA
	BTST	#0,ActiveChannels+1
	BEQ.S	scon1
	MOVE.L	#$209,D0			;ClearVol1, clear for analyzer
	MOVEQ	#0,D5
	MOVE.L	#$709,A1			;xpos
	LEA	BlankSampleAd,A2
	BTST	#0,D6
	BEQ.S	.l0
	LEA	ScopeInfo,A2
	MOVE.B	$12(A2),D5			;sample volume
.l0:	BSR.W	sconset

*--- channel 2 ---*

scon1:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan1Volume
	CLR.W	ScopeFlagA
	BTST	#1,ActiveChannels+1
	BEQ.S	scon2
	MOVEQ	#0,D5

	chn8test
	bne.s	.chn4
	move.l	#$709+3,A1
	MOVE.L	#$209+3-1,D0			;ClearVol2
	bra.s	.chn8

.chn4:	MOVE.L	#$709+6,A1
	MOVE.L	#$209+6,D0			;ClearVol2
.chn8:	LEA	BlankSampleAd,A2
	BTST	#1,D6
	BEQ.S	.l0
	LEA	ScopeInfo+20,A2
	MOVE.B	$12(A2),D5
.l0:	BSR.W	sconset

*--- channel 3 ---*

scon2:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan2Volume
	CLR.W	ScopeFlagA
	BTST	#2,ActiveChannels+1
	BEQ.S	scon3
	MOVEQ	#0,D5

	chn8test
	bne.s	.chn4
	move.l	#$709+3+3,A1
	MOVE.L	#$209+3+3-1,D0			;ClearVol3
	bra.s	.chn8

.chn4:	MOVE.L	#$709+6+6,A1
	MOVE.L	#$209+6+6,D0			;ClearVol3
.chn8:	LEA	BlankSampleAd,A2
	BTST	#2,D6
	BEQ.S	.l0
	LEA	ScopeInfo+40,A2
	MOVE.B	$12(A2),D5
.l0:	BSR	sconset

*--- channel 4 ---*

scon3:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan3Volume
	CLR.W	ScopeFlagA
	BTST	#3,ActiveChannels+1
	BEQ.S	scon3e
	MOVEQ	#0,D5

	chn8test
	bne.s	.chn4
	move.l	#$709+3+3+3,A1
	MOVE.L	#$209+3+3+3-1,D0		;ClearVol4
	bra.s	.chn8

.chn4:	MOVE.L	#$709+6+6+6,A1
	MOVE.L	#$209+6+6+6,D0			;ClearVol4
.chn8:	LEA	BlankSampleAd,A2
	BTST	#3,D6
	BEQ.S	.l0
	LEA	ScopeInfo+60,A2
	MOVE.B	$12(A2),D5
.l0:	BSR	sconset

*--- channel 4-end , only analyzer ---*

scon3e:	chn8test
	beq.s	scon4

	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan4Volume
	TST.L	D7
	BEQ.W	SetVUSprite			;set sprite
	RTS

*--- channel 5 ---*

scon4:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan4Volume
	CLR.W	ScopeFlagA
	BTST	#4,ActiveChannels+1
	BEQ.S	scon5
	MOVEQ	#0,D5

	move.l	#$709+3+3+3+3,A1
	MOVE.L	#$209+3+3+3+3-1,D0		;ClearVol5
	LEA	BlankSampleAd,A2
	BTST	#4,D6
	BEQ.S	.l0
	LEA	ScopeInfo+80,A2
	MOVE.B	$12(A2),D5
.l0:	BSR	sconset

*--- channel 6 ---*

scon5:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan5Volume
	CLR.W	ScopeFlagA
	BTST	#5,ActiveChannels+1
	BEQ.S	scon6
	MOVEQ	#0,D5
	move.l	#$709+3+3+3+3+3,A1
	MOVE.L	#$209+3+3+3+3+3-1,D0		;ClearVol6
	LEA	BlankSampleAd,A2
	BTST	#5,D6
	BEQ.S	.l0
	LEA	ScopeInfo+100,A2
	MOVE.B	$12(A2),D5
.l0:	BSR	sconset

*--- channel 7 ---*

scon6:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan6Volume
	CLR.W	ScopeFlagA
	BTST	#6,ActiveChannels+1
	BEQ.S	scon7
	MOVEQ	#0,D5
	move.l	#$709+3+3+3+3+3+3,A1
	MOVE.L	#$209+3+3+3+3+3+3-1,D0		;ClearVol7
	LEA	BlankSampleAd,A2
	BTST	#6,D6
	BEQ.S	.l0
	LEA	ScopeInfo+120,A2
	MOVE.B	$12(A2),D5
.l0:	BSR.S	sconset

*--- channel 8 ---*

scon7:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan7Volume
	CLR.W	ScopeFlagA
	BTST	#7,ActiveChannels+1
	BEQ.S	scon8e
	MOVEQ	#0,D5
	move.l	#$709+3+3+3+3+3+3+3,A1
	MOVE.L	#$209+3+3+3+3+3+3+3-1,D0	;ClearVol8
	LEA	BlankSampleAd,A2
	BTST	#7,D6
	BEQ.S	.l0
	LEA	ScopeInfo+140,A2
	MOVE.B	$12(A2),D5
.l0:	BSR.S	sconset

*--- channel 8-end , only analyzer ---*

scon8e:	MOVE.W	ScopeFlagA(PC),D0
	MOVE.W	D0,Chan8Volume
	CLR.W	ScopeFlagA
	TST.L	D7
	BEQ.W	SetVUSprite			;set sprite
	RTS

*********************************************************
* set vumeter, level tracking for vumeter AND scopes ...*
*							*
* => A1=xpos, A2=BlankSampleAd, D5=12(A2)		*
*********************************************************
sconset:
	TST.B	ScopeEnable			;allow scopes ?
	BEQ.W	ScopeOk_rt

	CMP.B	#2,VUShowMode			;none/fake/real
	BEQ.S	.doit
	CMP.W	#1,CurrScreen			;mainscreen ?
	BEQ.S	.doit
	CMP.W	#9,CurrScreen			; posed active ?
	BEQ.S	.doit
	BNE.W	ScopeOk_rt

.doit:	CMP.W	#1,CurrScreen
	BEQ.B	.l1
	CMP.W	#9,CurrScreen
	BEQ.B	.l1
	BNE.W	ClrSte1

.l1:	CMP.B	#4,ScopeNr			;2way
	BEQ.S	.2way
	CMP.B	#5,ScopeNr			;2waysolid
	beq.s	.2way
	bra.s	.begs

.2way:	chn8test
	bne.s	.chn4

	cmp.l	#$209+3-1,D0
	beq.s	ClrSte1
	cmp.l	#$209+3+3+3-1,d0
	beq.s	ClrSte1
	bra.s	.begs

.chn4:	CMP.L	#$209+6,d0			;voice 2 for stereoscope
	BEQ.S	ClrSte1
	CMP.L	#$209+6+6+6,d0			;voice 4 for stereoscope
	BEQ.S	ClrSte1

*---
.begs:	MOVE.L	TextBplPtr,A0
	ADD.L	D0,A0
	MOVEQ	#0,D0
	MOVEQ	#32,D1				;y-value

sconlp:	chn8test
	beq.s	.chn8

	MOVE.B	D0,(A0)+			;draw sample to vumeter
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+

.chn8:	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(a0)

	CMP.B	#4,ScopeNr			;clear
	BEQ.S	CLRNoSt
	cmp.b	#5,ScopeNr
	beq.s	CLRNoSt

	bra.s	CLRStereo

CLRNoSt:
	MOVE.B	D0,1(a0)
	MOVE.L	D0,2(a0)

CLRStereo:
	chn8test
	bne.s	.chn4
	LEA	75+3(A0),A0
	bra.s	.chn8

.chn4:	LEA	75(A0),A0			;stereo
.chn8:	DBRA	D1,sconlp


ClrSte1:
	MULS	TremoloByte,D5
	ADD.L	#32,D5
	LSR.L	#6,D5
	LSR.W	#1,D5
	CMP.W	#32,D5
	BLS.S	ClrSte2
	MOVEQ	#32,D5

ClrSte2:
	MOVE.L	(A2),A0
	ADD.L	TextBplPtr,A1
	MOVEM.L D6/D7,-(SP)
	MOVEQ	#0,D6
	MOVEQ	#0,D7
	CMP.W	#1,CurrScreen
	BEQ.B	.l1
	CMP.W	#9,CurrScreen
	BEQ.B	.l1
	BRA.B	NoScope

*********************************************************
.l1:	BSR.W	ViewScopes
	CMP.B	#0,ScopeNr
	BEQ.S	NoScope
	CMP.B	#1,ScopeNr
	BEQ.S	StdScope
	CMP.B	#2,ScopeNr
	BEQ.S	SolidScope
	CMP.B	#3,ScopeNr
	BEQ.S	LinesScope
	CMP.B	#4,ScopeNr
	BEQ.S	Scope2W
	cmp.b	#5,ScopeNr
	beq.s	Scope2WS
	BRA.S	NoScope

StdScope:
	BSR	StdScope3
	BRA.S	ScopeOk

SolidScope:
	BSR.W	SolidScope3
	BRA.S	ScopeOk

LinesScope
	BSR.W	LineScope
	BRA.S	ScopeOk

Scope2W:
	BSR.W	Scope2Way
	BRA.S	ScopeOk

Scope2WS:
	BSR.W	Scope2WaySolid
	BRA.S	ScopeOk

NoScope:
	BSR.W	ClrNoSco
ScopeOk:
	MOVE.W	D7,ScopeFlagA
	MOVEM.L (SP)+,D6/D7
ScopeOk_rt:
	TST.B	D4
	BEQ.S	.setsprite
	RTS

*********************************************************
* 		set sprite routine volume meters	*
*********************************************************
.setsprite:
	LEA	BlankSampleAd(PC),A0
	CMP.L	A0,A2
	BEQ.S	SetVUSprite			;set sprite
	MOVE.L	(A2),D1
	MOVE.L	SamDrawStart(PC),D0
	CMP.L	D0,D1
	BHI.S	.l2
	RTS

.l2:	CMP.L	SamDrawEnd(PC),D1
	BCS.S	.l1
	RTS

.l1:	SUB.L	D0,D1
	MULU	#314,D1
	MOVE.L	SamDisplay,D0
	BNE.S	.l0
	RTS

.l0:	DIVU	D0,D1
	ST	D4
	ST	D7
	MOVE.L	D1,D0

	chn8test
	bne.s	.chn4

	addq.w	#3,d0
	bra.s	.chn8

.chn4:	ADDQ.W	#6,D0
.chn8	MOVE.W	#139,D1

BlankSamSetNow:
	MOVEQ	#64,D2
	LEA	PlayPosSpriteData,A0
	GOTO	SetSpritePos			;set sprite

SetVUSprite:
	MOVEQ	#0,D0
	MOVE.W	#270,D1
	BRA.S	BlankSamSetNow

*********************************************************
StdScope3:
	chn8test
	bne.s	.chn4
	moveq	#2,d2
	bra.s	StdScop3lop

.chn4:	MOVEQ	#4,D2
StdScop3lop:
	MOVEQ	#7,D3

StdScop3lop2:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.W	D0,D6
	BPL.S	StdScop3skop
	NEG.W	D6
StdScop3skop:
	CMP.W	D6,D7
	BGE.S	StdScop3skip
	MOVE.W	D6,D7
StdScop3skip:
	NEG.W	D0
	MULS	D5,D0
	ASR.W	#8,D0
	MOVE.W	D0,D1
	ASL.W	#6,D0
	ASL.W	#4,D1
	ADD.W	D1,D0
	BSET	D3,0(A1,D0.W)
	DBRA	D3,StdScop3lop2
	ADDQ.L	#1,A1
	DBRA	D2,StdScop3lop		;4/8 loop
	RTS

*********************************************************
SolidScope3:
	chn8test
	bne.s	.chn4
	moveq	#2,d2
	bra.s	SolScoLop

.chn4:	MOVEQ	#4,D2

SolScoLop:
	MOVEQ	#7,D3
SolScoLop2:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.W	D0,D6
	BPL.S	SolScoSco
	NEG.W	D6
SolScoSco:
	CMP.W	D6,D7
	BGE.S	SolScoSkip
	MOVE.W	D6,D7
SolScoSkip:
	NEG.W	D0
	MULS	D5,D0
	ASR.W	#8,D0
	MOVE.W	D0,D1
	ASL.W	#6,D0
	ASL.W	#4,D1
	ADD.W	D1,D0
SolScoSkip2:
	BSET	D3,0(A1,D0.W)
	TST.W	D0
	BEQ.S	SolScoCont
	BMI.S	SolScoAdd
	SUB.W	#$50,D0
	BRA.S	SolScoSkip2

SolScoAdd:
	ADD.W	#$50,D0
	BRA.S	SolScoSkip2

SolScoCont:
	DBRA	D3,SolScoLop2
	ADDQ.L	#1,A1
	DBRA	D2,SolScoLop		;4/8 loop
	RTS

LinesOld:	dc.w	0
LinesOld2:	dc.w	0
LinesNew:	dc.w	0

*********************************************************
LineScope:
	chn8test
	bne.s	.chn4
	moveq	#2,d2
	bra.s	.chn8

.chn4:	MOVEQ	#4,D2
.chn8:	MOVE.W	#1,LinesNew

lnscp1:	MOVEQ	#7,D3
lnscp2:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.W	D0,D6
	BPL.S	lnscp3
	NEG.W	D6
lnscp3:
	CMP.W	D6,D7
	BGE.S	lnscp4
	MOVE.W	D6,D7
lnscp4:
	NEG.W	D0
	MULS	D5,D0
	ASR.W	#8,D0
	MOVE.W	D0,D1
	ASL.W	#6,D0
	ASL.W	#4,D1
	ADD.W	D1,D0
	TST.W	LinesNew
	BEQ.S	LinesNoNew
	MOVE.W	D0,LinesOld
	MOVE.W	#0,LinesNew
LinesNoNew:
	MOVE.W	LinesOld,LinesOld2
	MOVE.W	D0,LinesOld
lnscp5:
	BSET	D3,0(A1,D0.W)
	CMP.W	LinesOld2,D0
	BEQ.S	lnscp7
	BMI.S	lnscp6
	SUB.W	#$50,D0
	BRA.S	lnscp5

lnscp6:	ADD.W	#$50,D0
	BRA.S	lnscp5

lnscp7:
	DBRA	D3,lnscp2
	ADDQ.L	#1,A1
	DBRA	D2,lnscp1			;4/8 loop
	RTS

*********************************************************
Scope2Way:
	MOVE.L	a1,d2
	SUB.L	TextBplPtr,d2
	chn8test
	bne.s	.chn4

	CMP.L	#$709+3,d2		;70F
	BEQ.B	sc2w5
	CMP.L	#$709+3+3+3,d2		;71B
	BEQ.B	sc2w5
	bra.s	sc2w0


.chn4:	CMP.L	#$70F,d2		;70F
	BEQ.B	sc2w5
	CMP.L	#$71B,d2		;71B
	BEQ.B	sc2w5
sc2w0:
	MOVEQ   #10,D2
sc2w1:
	MOVEQ   #7,D3

sc2w2:
	MOVE.B  (A0)+,D0
	EXT.W   D0
	MOVE.W  D0,D6
	BPL.S   sc2w3
	NEG.W   D6
sc2w3:
	CMP.W   D6,D7
	BGE.S   sc2w4
	MOVE.W  D6,D7
sc2w4:
	NEG.W   D0
	MULS    D5,D0
	ASR.W   #8,D0
	MOVE.W  D0,D1
	ASL.W   #6,D0
	ASL.W   #4,D1
	ADD.W   D1,D0
	BSET    D3,0(A1,D0.W)
	DBRA    D3,sc2w2
	ADDQ.L  #1,A1
	DBRA    D2,sc2w1
	RTS
sc2w5:
	SUBQ.L	#6,a1
	BRA.B	sc2w0

*********************************************************
Scope2WaySolid:
	MOVE.L	a1,d2
	SUB.L	TextBplPtr,d2

	chn8test
	bne.s	.chn4

	cmp.l	#$709+3,d2
	beq.s	.l5
	cmp.l	#$709+3+3+3,d2
	beq.s	.l5
	bra.s	.l0

.chn4:	CMP.L	#$70F,d2
	BEQ.B	.l5
	CMP.L	#$71B,d2
	BEQ.B	.l5

.l0:	MOVEQ	#10,D2
.l1:	MOVEQ	#7,D3

.l2:	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.W	D0,D6
	BPL.S	.l3
	NEG.W	D6

.l3:	CMP.W	D6,D7
	BGE.S	.l4
	MOVE.W	D6,D7

.l4:	NEG.W	D0
	MULS	D5,D0
	ASR.W	#8,D0
	MOVE.W	D0,D1
	ASL.W	#6,D0
	ASL.W	#4,D1
	ADD.W	D1,D0

.r1:	BSET	D3,0(A1,D0.W)
	tst.w	d0
	beq.s	.r2
	bmi.s	.r3
	sub.w	#$50,d0
	bra.s	.r1

.r3:	add.w	#$50,d0
	bra.s	.r1

.r2:	DBRA	D3,.l2
	ADDQ.L	#1,A1
	DBRA	D2,.l1
	RTS

.l5:
	SUBQ.L	#6,a1
	BRA.B	.l0

*********************************************************
ClrNoSco:
	CMP.B	#2,VUShowMode
	BEQ.S	.doit
	RTS

.doit:	MOVEQ	#$27,D2				;40-1
.clop:	MOVE.B	(A0)+,D0
	EXT.W	D0
	BPL.S	.l1
	NEG.W	D0
.l1:	CMP.W	D0,D7
	BGE.S	.l2
	MOVE.W	D0,D7
.l2:	DBRA	D2,.clop
	RTS

*********************************************************
MakeScope:
	MOVEQ	#0,D1
	MOVE.B	$2B(A0),D1
	SUBQ.W	#1,D1
	LSL.W	#4,D1
	LEA	ScopeSamInfo,A4
	LEA	0(A4,D1.W),A4
	MOVE.L	4(A0),D0
	MOVE.L	D0,(A4)
	MOVEQ	#0,D1
	MOVE.W	8(A0),D1
	ADD.L	D1,D0
	ADD.L	D1,D0
	MOVE.L	D0,4(A4)
	MOVE.L	10(A0),D0
	MOVE.L	D0,8(A4)
	MOVEQ	#0,D1
	MOVE.W	14(A0),D1
	CMP.W	#1,D1
	BEQ.S	.skip
	ADD.L	D1,D0
	ADD.L	D1,D0
	MOVE.L	D0,12(A4)
	RTS

.skip:	CLR.L	8(A4)
	RTS

*********************************************************
ViewScopes:
	MOVEM.L D0/A0,-(SP)
	move.b	ScopeNr,d0
	cmp.b	ScopeAct,d0		;scope already valid?
	BEQ	ViewScope8

	CMP.B	#0,ScopeNr
	BNE.S	ViewScope1
	move.l	#ScopeGfxData1,a0

ViewScope1:
	CMP.B	#1,ScopeNr
	BNE.S	ViewScope2
	chn8test
	beq.s	.chn8
	move.l	#ScopeGfxData2,a0
	bra.s	ViewScope2
.chn8:	move.l	#ScopeGfxData6,a0

ViewScope2:
	CMP.B	#2,ScopeNr
	BNE.S	ViewScope3
	chn8test
	beq.s	.chn8
	move.l	#ScopeGfxData2,a0
	bra.s	ViewScope3
.chn8:	move.l	#ScopeGfxData6,a0

ViewScope3:
	CMP.B	#3,ScopeNr
	BNE.S	ViewScope5
	chn8test
	beq.s	.chn8
	move.l	#ScopeGfxData2,a0
	bra.s	ViewScope5
.chn8:	move.l	#ScopeGfxData6,a0

ViewScope5:
	chn8test
	bne.b	.l0			; no stereoscope in 8-channel mode
	cmp.b	#3,ScopeNr
	bne.b	.l0
	move.b	#0,ScopeNr
	bra	ViewScope8

.l0	CMP.B	#4,ScopeNr		; 2way
	BNE.S	ViewScope6
	move.l	#ScopeGfxData4,a0

ViewScope6:
	cmp.b	#5,ScopeNr
	bne.s	ViewScope7
	move.l	#ScopeGfxData4,a0	; 2waysolid

ViewScope7:
	move.b	ScopeNr,d0
	cmp.b	ScopeAct,d0		;scope already valid?
	BEQ.W	ViewScope8
	move.b	ScopeNr,ScopeAct

	cmp.l	#'IMP!',(A0)
	bne.s	.l1
	MOVEM.L D0-D7/A1-A6,-(SP)
	CALL	fimpdecrunch
	MOVEM.L (SP)+,D0-D7/A1-A6

.l1:	move.l	a0,a1
	lea	PTBitMap,a0
	add.l	#40,a0
	moveq	#1,d0
CopyScope1:
	moveq	#43,d1

CopyScope2:
	move.l	(a1)+,(a0)
	move.l	(a1)+,4(a0)
	move.l	(a1)+,8(a0)
	move.l	(a1)+,12(a0)
	move.l	(a1)+,16(a0)
	move.l	(a1)+,20(a0)
	move.b	(a1)+,24(a0)
	addq.l	#1,a1
	add.l	#80,a0
	dbra	d1,CopyScope2
	lea	PTBitMap,a0
	add.l	#20480+40,a0
	dbra	d0,CopyScope1

	tst.l	ffpointer
	beq.s	ViewScope8
	MOVEM.L D0-D7/A1-A6,-(SP)
	CALL	fimpclean
	MOVEM.L (SP)+,D0-D7/A1-A6

ViewScope8:
	MOVEM.L (SP)+,D0/A0
	RTS

*********************************************************
* 		calculate free memory pools		*
*********************************************************
DoShowFreeMem:
	MOVE.W	#1,UpdateFreeMem
ShowFreeMem:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	UpdateFreeMem
	BEQ.S	ShowFreeMem2
	CLR.W	UpdateFreeMem
	CLR.L	mt_memchgflag
	CLR.L	TuneRAMBit

*--- hexadecimal output ---*
ShowFreeMem2:
	BSR.B	CalcTuneRAM
	MOVEQ	#0,D1
	MOVE.L	4.w,a6
	CALLSYS	AvailMem
	CMP.L	mt_memchgflag(PC),D0
	BEQ.B	sfreemem_ret
	MOVE.L	D0,mt_memchgflag
	BTST	#7,Packetfield
	BNE.B	sfreemem_dec
	;MOVE.L	D0,D6
	;MOVE.W	#$2939,TextOffset
	;SWAP	D0
	;AND.W	#$00FF,D0
	;MOVE.W	D0,WordNumber
	;CALL	PrintHexByte		;public hex
	;MOVE.W	D6,WordNumber
	;CALL	PrintHexWord

	MOVEQ	#2,D1
	MOVE.L	4.w,a6
	CALLSYS	AvailMem
	MOVE.L	D0,D6
	;MOVE.W	#$26FD,TextOffset
	move.w	#$2836+11+8,TextOffset
	SWAP	D0
	AND.W	#$00FF,D0
	MOVE.W	D0,WordNumber
	CALL	PrintHexByte		;ShowHexChipRAM
	MOVE.W	D6,WordNumber
	CALL	PrintHexWord

	;MOVEQ	#4,D1
	;MOVE.L	4.w,a6
	;CALLSYS	AvailMem
	;MOVE.L	D0,D6
	;MOVE.W	#$292D,TextOffset
	;SWAP	D0
	;AND.W	#$00FF,D0
	;MOVE.W	D0,WordNumber
	;CALL	PrintHexByte		;fastram hex

	;MOVE.W	D6,WordNumber
	;CALL	PrintHexWord

sfreemem_ret:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

*--- decimal output ---*
sfreemem_dec:
	;MOVE.L	mt_memchgflag(PC),D0
	;MOVE.W	#$2939,TextOffset
	;CALL	Print6DecDigits 	;public RAM

	MOVEQ	#2,D1
	MOVE.L	4.w,a6
	CALLSYS	AvailMem
	;MOVE.W	#$26FD,TextOffset
	move.w	#$2836+11+8,TextOffset
	CALL	Print6DecDigits 	;DecChipRAM

	;MOVEQ	#4,D1
	;MOVE.L	4.w,a6
	;CALLSYS	AvailMem
	;MOVE.W	#$292D,TextOffset
	;CALL	Print6DecDigits 	;DecFastRAM


	BRA.S	sfreemem_ret

*********************************************************
CalcTuneRAM:
	MOVE.L	mt_songdataptr,A0
	LEA	42(A0),A0		; Samplelengthaddr 1. sample
	MOVE.W	TuneUp(PC),D7		; actual used samples in d7
	SUBQ.W	#1,D7
	MOVE.W	#MaxInsNum,TuneUp
	MOVEQ	#0,D0

.lob:	MOVEQ	#0,D1
	MOVE.W	(A0),D1			; get samplelength word (x2= real length)
	ASL.W	#1,D1			; x2
	ADD.L	D1,D0			; add to d0 (sum length)
	ADD.L	#30,A0 			; next sample
	DBRA	D7,.lob

	ADD.L	#sd_patterndata,D0	; + patternmem
	MOVE.L	mt_songdataptr,A0

	MOVEQ	#128-1,D7		; max patterns
	ADD.L	#sd_pattpos,A0
	MOVEQ	#0,D6

.lo:	MOVE.B	(A0)+,D5
	CMP.B	D5,D6
	BHI.S	.l2
	MOVE.B	D5,D6
.l2:	DBRA	D7,.lo

	ADDQ.W	#1,D6
	ASL.L	#8,D6
	ASL.L	#2,D6

	chn8test
	BNE.S	.chn4
	ASL.L	#1,D6

.chn4:	ADD.L	D6,D0
	CMP.L	TuneRAMBit(PC),D0
	BNE.S	ShowTuneRAM
	RTS

*********************************************************
ShowTuneRAM:
	MOVE.L	D0,TuneRAMBit
	BTST	#7,Packetfield
	BNE.S	.showdec

	MOVE.L	D0,D6
	;MOVE.W	#$2709,TextOffset
	move.w	#$2836+6+2,TextOffset

	SWAP	D0
	AND.W	#$00FF,D0
	MOVE.W	D0,WordNumber
	CALL	PrintHexByte
	MOVE.W	D6,WordNumber
	GOTO	PrintHexWord

.showdec:
	MOVE.L	TuneRAMBit(PC),D0
	;MOVE.W	#$2709,TextOffset
	move.w	#$2836+6+2,TextOffset
	GOTO	Print6DecDigits

UpdateFreeMem:	dc.w	0
mt_memchgflag:	dc.l	0
TuneRAMBit:	dc.l	0
TuneUp: 	dc.w	MaxInsNum

*********************************************************
* routines for switching channels 0-3/0-7 on/off 	*
*********************************************************
ToggleChannels:
	CMP.W	#$22,D0
	BCC.S	ToggleCh4
	CMP.W	#$17,D0
	BCC.S	ToggleCh3
	CMP.W	#12,D0
	BCC.S	ToggleCh2

ToggleCh1:	LEA	audchan1toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh2:	LEA	audchan2toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh3:	LEA	audchan3toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh4:	LEA	audchan4toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh5:	LEA	audchan5toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh6:	LEA	audchan6toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh7:	LEA	audchan7toggle(PC),A0
		BRA.S	ToggleCh_beg
ToggleCh8:	LEA	audchan8toggle(PC),A0

ToggleCh_beg:
	chn8test
	bne.s	.tog4
	MOVE.W	#8,NewChannels
	bra.s	.tog8
.tog4:
	MOVE.W	#4,NewChannels
.tog8:
	EOR.W	#1,(A0)			;mute
	BSR.W	WaitForButtonUp

TogglerView:
	CLR.W	D0
	chn8test
	bne.s	.chn4

	MOVE.W	audchan8toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan7toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan6toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan5toggle(PC),D0
	LSL.B	#1,D0
	BRA.S	.l1


.chn4:
	MOVE.W	audchan4toggle(PC),D0
	LSL.B	#1,D0
.l1:	OR.W	audchan4toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan3toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan2toggle(PC),D0
	LSL.B	#1,D0
	OR.W	audchan1toggle(PC),D0

	MOVE.W	D0,ActiveChannels		;=> %00001111
	CLR.B	RawKeyCode
	BSR.S	valmaga
	CALL	Wait_4000
	GOTO	ShowTracks

valmaga:
	cmp.w	#1,CurrScreen			; reincluded 401
	BEQ.B	.l1
	cmp.w	#9,CurrScreen			; reincluded 401
	BEQ.B	.l1
	RTS

.l1:	CMP.b	#4,ScopeNr
	beq	valmaga2
	CMP.b	#5,ScopeNr
	beq	valmaga2

	chn8test
	bne	.chn4

	MOVE.W	ActiveChannels(PC),D2		; => %00001111
	MOVE.L	#$209,D0
	LEA	audchan1temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2
	MOVE.L	#$209+3,D0
	LEA	audchan2temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2
	MOVE.L	#$209+3+3,D0
	LEA	audchan3temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2
	MOVE.L	#$209+3+3+3,D0
	LEA	audchan4temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2				; chn5
	MOVE.L	#$209+3+3+3+3,D0
	LEA	audchan5temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2				; chn6
	MOVE.L	#$209+3+3+3+3+3,D0
	LEA	audchan6temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2				; chn7
	MOVE.L	#$209+3+3+3+3+3+3,D0
	LEA	audchan7temp,A1
	BSR	cltremvol8

	LSR.W	#1,D2				; chn8
	MOVE.L	#$209+3+3+3+3+3+3+3,D0
	LEA	audchan8temp,A1
	BSR	cltremvol8
	bra.s	.chn8

.chn4:	MOVE.W	ActiveChannels(PC),D2		; => %00001111
	MOVE.L	#$209,D0
	LEA	audchan1temp,A1
	BSR.S	cltremvol

	LSR.W	#1,D2
	MOVE.L	#$209+6,D0
	LEA	audchan2temp,A1
	BSR.S	cltremvol

	LSR.W	#1,D2
	MOVE.L	#$209+6+6,D0
	LEA	audchan3temp,A1
	BSR.S	cltremvol

	LSR.W	#1,D2
	MOVE.L	#$209+6+6+6,D0
	LEA	audchan4temp,A1
	BSR.S	cltremvol


.chn8:	BSR.W	MkVolSet			; set/update volume
	RTS

cltremvol:					; clear voicedeactivated scope
	BTST	#0,D2				; valid scope (1-4)?
	BNE.S	.fini				; no, return
	CLR.W	20(A1)

	MOVE.L	TextBplPtr,A0
	ADD.L	D0,A0
	MOVE.B	#5*3+2,D0
	MOVEQ	#5*6+2,D1
.clop:
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	ROR	#2,D0				; Muster
	LEA	75(A0),A0
	DBRA	D1,.clop
.cret:	RTS

.fini:	MOVE.W	TremoloByte,20(A1)
	RTS

cltremvol8:					; clear voicedeactivated scope
	BTST	#0,D2				; valid scope (1-4)?
	BNE.S	.fini				; no, return
	CLR.W	20(A1)

	MOVE.L	TextBplPtr,A0
	ADD.L	D0,A0				; posoffset add
	MOVE.B	#17,D0				; fillpattern
	moveq	#32,d1
.clop:
	MOVE.B	D0,(A0)+
	MOVE.B	D0,(A0)+
	;MOVE.B	D0,(A0)+
	;MOVE.B	D0,(A0)+
	;MOVE.B	D0,(A0)+

	ROR	#2,D0				; rotate pattern
	LEA	75+3(A0),A0
	DBRA	D1,.clop
.cret:	RTS

.fini:	MOVE.W	TremoloByte,20(A1)
	RTS

*---if 2way scopes active ---*

valmaga2:
	MOVE.W	ActiveChannels(PC),D2		; => %00001111
	MOVE.L	#$209,D0
	LEA	audchan1temp,A1
	BSR.S	cltremvol2

	LSR.W	#1,D2
	MOVE.L	#$209,D0
	LEA	audchan2temp,A1
	BSR.S	cltremvol2

	LSR.W	#1,D2
	MOVE.L	#$209+6+6,D0
	LEA	audchan3temp,A1
	BSR.S	cltremvol2

	LSR.W	#1,D2
	MOVE.L	#$209+6+6,D0
	LEA	audchan4temp,A1
	BSR.S	cltremvol2

	BSR.W	MkVolSet			; set/update volume
	RTS

cltremvol2:					; clear voicedeactivated scope
	BTST	#0,D2				; activechannel
	BNE.S	.fini				; no, return
	CLR.W	20(A1)				; temp

	MOVE.L	TextBplPtr,A0
	ADD.L	D0,A0
	MOVE.B	#17,D0
	MOVEQ	#(10*6+2)/2,D1				; y-value, 32/5=6
.clop:
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+

	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+
	MOVE.b	D0,(A0)+

	ROR	#2,D0				; Muster
	LEA	75-5(A0),A0			; 15*5=75
	DBRA	D1,.clop
.cret:	RTS

.fini:	MOVE.W	TremoloByte,20(A1)
	RTS

*********************************************************
*	vumeter part1 (chan 0-3 /4-7 in Patterneditor	*
*********************************************************
valgask:
	btst	#0,VUSpriteMode
	beq.s	.DoFatMeters

	LEA	VUSpriteData1L,A2
	LEA	audchan1toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData2L,A2
	LEA	audchan2toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData3L,A2
	LEA	audchan3toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData4L,A2
	LEA	audchan4toggle(PC),A3
	BSR.W	vumet_sho

	chn8test
	bne.s	.vret1

	LEA	VUSpriteData5L,A2
	LEA	audchan5toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData6L,A2
	LEA	audchan6toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData7L,A2
	LEA	audchan7toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData8L,A2
	LEA	audchan8toggle(PC),A3
	BSR.W	vumet_sho
.vret1:	RTS

.DoFatMeters:
	LEA	VUSpriteData1B,A2
	LEA	audchan1toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData2B,A2
	LEA	audchan2toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData3B,A2
	LEA	audchan3toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData4B,A2
	LEA	audchan4toggle(PC),A3
	BSR.W	vumet_sho

	chn8test
	bne.s	.vret2

	LEA	VUSpriteData5B,A2
	LEA	audchan5toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData6B,A2
	LEA	audchan6toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData7B,A2
	LEA	audchan7toggle(PC),A3
	BSR.W	vumet_sho
	LEA	VUSpriteData8B,A2
	LEA	audchan8toggle(PC),A3
	BSR.W	vumet_sho
.vret2:	RTS

*********************************************************
* 		VU Meters part2, from vbint		*
*********************************************************
VUmeters:
	TST.B	VUShowMode
	BNE.S	.l0
	RTS

.l0:	BTST	#0,VUSpriteMode
	BEQ	.lbig

	LEA	audchan1temp,A1
	LEA	VUSpriteData1L,A2
	LEA	audchan1toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan2temp,A1
	LEA	VUSpriteData2L,A2
	LEA	audchan2toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan3temp,A1
	LEA	VUSpriteData3L,A2
	LEA	audchan3toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan4temp,A1
	LEA	VUSpriteData4L,A2
	LEA	audchan4toggle(PC),A3
	BSR	OneVUmeter

	chn8test
	beq.s	.l1
	rts

.l1:	LEA	audchan5temp,A1
	LEA	VUSpriteData5L,A2
	LEA	audchan5toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan6temp,A1
	LEA	VUSpriteData6L,A2
	LEA	audchan6toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan7temp,A1
	LEA	VUSpriteData7L,A2
	LEA	audchan7toggle(PC),A3
	BSR	OneVUmeter

	LEA	audchan8temp,A1
	LEA	VUSpriteData8L,A2
	LEA	audchan8toggle(PC),A3
	BRA	OneVUmeter

*--- as above, with big spriteset ---*

.lbig:	LEA	audchan1temp,A1
	LEA	VUSpriteData1B,A2
	LEA	audchan1toggle(PC),A3
	BSR	OneVUmeter
	LEA	audchan2temp,A1
	LEA	VUSpriteData2B,A2
	LEA	audchan2toggle(PC),A3
	BSR.S	OneVUmeter
	LEA	audchan3temp,A1
	LEA	VUSpriteData3B,A2
	LEA	audchan3toggle(PC),A3
	BSR.S	OneVUmeter
	LEA	audchan4temp,A1
	LEA	VUSpriteData4B,A2
	LEA	audchan4toggle(PC),A3
	BSR.S	OneVUmeter

	chn8test
	beq.s	.l2
	rts

.l2:	LEA	audchan5temp,A1
	LEA	VUSpriteData5B,A2
	LEA	audchan5toggle(PC),A3
	BSR.B	OneVUmeter
	LEA	audchan6temp,A1
	LEA	VUSpriteData6B,A2
	LEA	audchan6toggle(PC),A3
	BSR.S	OneVUmeter
	LEA	audchan7temp,A1
	LEA	VUSpriteData7B,A2
	LEA	audchan7toggle(PC),A3
	BSR.S	OneVUmeter
	LEA	audchan8temp,A1
	LEA	VUSpriteData8B,A2
	LEA	audchan8toggle(PC),A3

*---
OneVUmeter:
	MOVE.W	(A3),D0
	CMP.B	#2,VUShowMode
	BEQ.B	VUmeter_ret
	TST.L	RunMode
	BEQ.W	VUmeterDown
	TST.W	D0
	BEQ.W	VUmeterDown
	TST.L	mt_counter
	BNE.W	VUmeterDown
	TST.W	(A1)
	BEQ.W	VUmeterDown

	MOVEQ	#0,D0			; new note
	MOVE.B	n_volume(A1),D0 	; get volume
	CMP.W	#63,D0			; max?
	BLS.S	iccskip 		; no, skip
	MOVEQ	#63,D0	 		; yes, set to 63

iccskip:
	MULU	#48,D0
	MULU	TremoloByte,D0
	ADD.L	#32,D0
	LSR.L	#6,D0
	LSR.W	#6,D0
	BNE.S	iccsko
	MOVEQ	#1,D0
iccsko:
	MOVE.W	D0,n_start(A3)
	BRA.S	vumet_sho

*---
VUmeter_ret:
	MOVE.W	6(A3),D1
	MOVEQ	#0,D0
	MOVE.B	19(A1),D0
	MULU	D1,D0
	MULU	#48,D0
	LSR.L	#7,D0
	MULU	TremoloByte,D0
	ADD.L	#32,D0
	LSR.L	#6,D0
	LSR.W	#6,D0
	BNE.S	vumet_ret
	MOVEQ	#1,D0
vumet_ret:
	CMP.W	4(A3),D0
	BMI.B	vumet_skp
	MOVE.W	D0,4(A3)

*---
vumet_sho:
	MOVE.W	4(A3),D2
	MOVE.W	#198,D1
	SUB.W	D2,D1			; new height
	MOVE.W	2(A3),D0
	TST.B	VUShowMode
	BNE.S	vumet_set
	MOVEQ	#-$40,D0
vumet_set:
	MOVE.L	A2,A0
	GOTO	SetSpritePos		; set this as sprite
	RTS

vumet_skp:
	MOVE.W	4(A3),D1
	SUB.W	D0,D1
	LSR.W	#1,D1
	SUB.W	D1,4(A3)

VUmeterDown:
	SUBQ.W	#1,4(A3)
	CMP.W	#1,4(A3)
	BPL.S	vumetdown_sk
	MOVE.W	#1,4(A3)
vumetdown_sk:
	BRA.B	vumet_sho

*********************************************************
ScopeEnable:	dc.b	0,1
BlankSampleAd:	dc.l	BlankSample
SamDrawStart:	dc.l	0
SamDrawEnd:	dc.l	0
ScopeFlagA:	dc.w	0
*********************************************************
audchan1toggle: dc.w	1,$2E,1
Chan1Volume:	dc.w	0
Chan1Volume1:	dc.w	0
audchan2toggle: dc.w	1,$6A,1
Chan2Volume:	dc.w	0
Chan2Volume1:	dc.w	0
audchan3toggle: dc.w	1,$A6,1
Chan3Volume:	dc.w	0
Chan3Volume1:	dc.w	0
audchan4toggle: dc.w	1,$E2,1
Chan4Volume:	dc.w	0
Chan4Volume1:	dc.w	0

ActiveChannels:
	dc.w	$000F
	dc.b	$48,$E7,$F0,$80,$E1,$4A,$84,$FC,2,$80
	dc.b	$BA,$FC,$F0,$A0,$66,$16,$4A,$79
	dc.l	audchan1toggle

	dc.b	$67,14,$22,$79					; volumeslider
	dc.l	Chan1Volume1
	dc.b	$65,6,$33,$C2
	dc.l	Chan1Volume1
*---
	dc.b	$BA,$FC,$F0,$B0,$66,$16,$4A,$79
	dc.l	audchan2toggle

	dc.b	$67,14,$22,$79					; volumeslider
	dc.l	Chan2Volume1
	dc.b	$65,6,$33,$C2
	dc.l	Chan2Volume1
*---

	dc.b	$BA,$FC,$F0,$C0,$66,$16,$4A,$79
	dc.l	audchan3toggle

	dc.b	$67,14,$22,$79
	dc.l	Chan3Volume1
	dc.b	$65,6,$33,$C2
	dc.l	Chan3Volume1
*---
	dc.b	$BA,$FC,$F0,$D0,$66,$16,$4A,$79
	dc.l	audchan4toggle

	dc.b	$67,14,$22,$79
	dc.l	Chan4Volume1
	dc.b	$65,6,$33,$C2
	dc.l	Chan4Volume1

*---
;	dc.b	$BA,$FC,$F0,$E0,$66,$16,$4A,$79
;	dc.l	audchan5toggle

;	dc.b	$67,14,$22,$79
;	dc.l	Chan5Volume1
;	dc.b	$65,6,$33,$C2
;	dc.l	Chan5Volume1

;---
;	dc.b	$BA,$FC,$F0,$F0,$66,$16,$4A,$79
;	dc.l	audchan6toggle

;	dc.b	$67,14,$22,$79
;	dc.l	Chan6Volume1
;	dc.b	$65,6,$33,$C2
;	dc.l	Chan6Volume1

*---
;	dc.b	$BA,$FC,$F0,$F0,$66,$16,$4A,$79
;	dc.l	audchan7toggle

;	dc.b	$67,14,$22,$79
;	dc.l	Chan7Volume1
;	dc.b	$65,6,$33,$C2
;	dc.l	Chan7Volume1

*---
;	dc.b	$BA,$FC,$F0,$F0,$66,$16,$4A,$79
;	dc.l	audchan8toggle

;	dc.b	$67,14,$22,$79
;	dc.l	Chan8Volume1
;	dc.b	$65,6,$33,$C2
;	dc.l	Chan8Volume1

audchan5toggle: dc.w	1,$011E,1
Chan5Volume:	dc.w	0
Chan5Volume1:	dc.w	0
audchan6toggle: dc.w	1,$015A,1
Chan6Volume:	dc.w	0
Chan6Volume1:	dc.w	0
audchan7toggle: dc.w	1,$0196,1
Chan7Volume:	dc.w	0
Chan7Volume1:	dc.w	0
audchan8toggle: dc.w	1,$01D2,1
Chan8Volume:	dc.w	0
Chan8Volume1:	dc.w	0
		EVEN
;******************************
;* volume bar in mainscreen   *
;******************************

volup:	MOVEQ	#-1,D0			; mouseclicked
	checkrmb
	BNE.S	.l1
	MOVEQ	#-10,D0
.l1:	BRA.S	chgvolume

voldown:				; mouseclicked
	MOVEQ	#1,D0
	checkrmb
	BNE.S	chgvolume
	MOVEQ	#10,D0

chgvolume:
	ADD.W	D0,Volume
	BPL.S	.l1
	CLR.W	Volume

.l1:	CMP.W	#$22,Volume
	BMI.S	.l2
	MOVE.W	#$22,Volume

.l2:	BRA.W	BlitManyThings

;*******************************
;* volume slider in mainscreen *
;*******************************
CheckVolumeSlider:
	MOVE.W	MouseY,D0
	MOVE.W	Volume(PC),D2
	SUBQ.W	#2,D0
	CMP.W	D0,D2
	BGT.S	decrvolsld
	MOVE.W	D0,D1
	SUBQ.W	#6,D1
	CMP.W	D1,D2
	BLE.B	incrvolsld
	MOVE.W	D0,D4
	SUB.W	D2,D4
	MOVE.W	#2,VolumeBag5
	BSR.W	BlitManyThings

v_lop:	checklmb
	BNE.S	.vskip
	CALL	ResetKeyTimer
	MOVE.W	MouseY,D0
	SUBQ.W	#2,D0
	SUB.W	D4,D0
	BGT.S	.l1
	MOVEQ	#0,D0

.l1:	CMP.W	#$22,D0
	BLS.S	.l2
	MOVE.W	#$22,D0

.l2:	CMP.W	D0,D2
	BEQ.B	v_lop

	MOVE.W	D0,D2
	MOVE.W	D0,Volume
	BSR.S	BlitManyThings
	checklmb
	BEQ.S	v_lop

.vskip:	MOVE.W	#1,VolumeBag5
	BRA.S	BlitManyThings

;--- decrease base volume ---

decrvolsld:
	SUBQ.W	#1,Volume
	BPL.S	.l1
	CLR.W	Volume

.l1:	MOVE.L	DOSBase,A6		; has trashed loopsprite in sam!
	MOVEQ	#1,D1
	CALLSYS	Delay
	BRA.S	BlitManyThings

;--- increase base volume ---

incrvolsld:
	ADDQ.W	#1,Volume
	CMP.W	#$22,Volume
	BMI.S	.l1
	MOVE.W	#$22,Volume

.l1:	MOVE.L	DOSBase,A6
	MOVEQ	#1,D1
	CALLSYS	Delay

;******************************
; blit almost all gfx stuff   *
;* volume slider blit routine *
;******************************

BlitManyThings:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	Volume(PC),D0
	MOVE.W	D0,Volumebag1
	MOVE.W	D0,Volumebag2
	MOVE.W	D0,D1
	ADDQ.W	#6,D1
	MOVE.W	D1,volslreg1
	MOVE.W	#$22,D1
	SUB.W	D0,D1
	MOVE.W	D1,Volumebag4
	LEA	Volumebag3(PC),A0
	MOVE.W	#$0134,D0		; pos left
	MOVEQ	#2,D1			; Y-pos slider
	cmp.w	#1,CurrScreen
	bne.b	.skip
	CALL	BlitAllBasic		; Volume Slider
.skip:
	MOVE.W	#$22,D1
	SUB.W	Volume(PC),D1
	move.w	Volume(PC),D1

	MULU	#$40,D1
	DIVU	#$22,D1
	MOVE.W	#$40,D0
	SUB.W	D1,D0

	MOVE.W	D0,TremoloByte
	TST.W	audchan1toggle
	BEQ.S	.l2
	MOVE.W	D0,audchan11temp
.l2:	TST.W	audchan2toggle
	BEQ.S	.l3
	MOVE.W	D0,audchan21temp
.l3:	TST.W	audchan3toggle
	BEQ.S	.l4
	MOVE.W	D0,audchan31temp
.l4:	TST.W	audchan4toggle
	BEQ.S	.lk
	MOVE.W	D0,audchan41temp
.lk:	BSR.S	MkVolSet
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************
;* volume for all channels      *
;********************************

MkVolSet:
	LEA	Allchantempis,A1
	LEA	AUD0,A5
	MOVEQ	#4-1,D1
	;move	numchans,d1
	;subq	#1,d1

.loo:	MOVE.L	(A1)+,A0
	BSR.S	.ss1

	LEA	16(A5),A5
	DBRA	D1,.loo
	RTS

.ss1:	MOVEQ	#0,D0
	MOVE.B	19(A0),D0
	MULS	20(A0),D0
	ADD.L	#32,D0
	LSR.L	#6,D0
	TST.B	54(A0)
	BNE.S	.skip
	MOVE.W	D0,8(A5)
.skip:	RTS

Volume: 	dc.w	$22
Volumebag3:	dc.l	$00050002,0	;background volume slider
		dc.w	9
Volumebag1:	dc.w	0
VolumeBag5:	dc.w	1,0
Volumebag2:	dc.w	0,9,6,5,2,0
volslreg1:	dc.w	6,9
Volumebag4:	dc.b	0,$22
		dc.w	0

;******************************
; gadget x/y blit routine     *
;******************************

ConvMousTabl:
	MOVE.W	#$FFFF,DirCopFlag
	BSR.S	MousXTablKonv
	CLR.W	DirCopFlag
	RTS

MousXTablKonv:
	CLR.B	di_chkwhitetflag
mt_moskoos:
	MOVE.W	D7,-(SP)
mt_moskood:
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D7
	MOVE.W	(A0)+,D3
	MOVE.W	(A0)+,D4
	MOVE.W	(A0)+,D5
	MOVE.W	(A0)+,D6
	TST.W	D2
	BEQ.S	mt_moskort
	CMP.W	D0,D3
	BHI.S	mt_moskood
	CMP.W	D0,D5
	BCS.S	mt_moskood
	CMP.W	D1,D4
	BHI.S	mt_moskood
	CMP.W	D1,D6
	BCS.S	mt_moskood
	MOVE.W	D7,blt_ctrlreg
	TST.W	D7
	BEQ.S	mt_moskort
	TST.B	MousKoordReg1
	BNE.S	mt_moskort
	BSR.S	mt_moscal
mt_moskort:
	MOVE.W	(SP)+,D7
	RTS

di_chkwhitetflag:
	dc.b	 0,0

;****************************************
;* blit the borders of pressed gadget   *
;****************************************

mt_moscal:
	MOVEQ	#0,D7
	BSR.W	blt_mscr2
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.B	di_chkwhitetflag
	BNE.S	lbC0026D4
	MOVE.L	DOSBase,D0
	BEQ.S	lbC0026D4
	MOVE.L	D0,A6
	MOVEQ	#1,D1
	CALLSYS	Delay
lbC0026D4:
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEM.W D0/D1,-(SP)
lbC0026DC:
	CALL	ResetKeyTimer
	MOVEM.W (MouseX),D0/D1
	TST.W	D7
	BEQ.S	blt_mscrstrt0
	BSR.S	blt_mscr1
	BRA.S	blt_mscrstrt

blt_mscrstrt0:
	BSR.S	blt_mscr0

blt_mscrstrt:
	checklmb
	BEQ.S	lbC0026DC
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.B	di_chkwhitetflag
	BNE.S	blt_mscrmain
	MOVE.L	DOSBase,D0
	BEQ.S	blt_mscrmain
	MOVE.L	D0,A6
	MOVEQ	#1,D1
	CALLSYS	Delay

blt_mscrmain:
	MOVEM.L (SP)+,D0-D7/A0-A6
	checklmb
	BEQ.S	lbC0026DC
	MOVEM.W (SP)+,D0/D1
	MOVE.W	D7,D2
	BEQ.S	blt_rts
	BSR.S	blt_mscr3	;blitting 0-1 and 1-2
blt_rts:
	RTS

blt_mscr1:
	CMP.W	D0,D3
	BHI.S	blt_mscr2
	CMP.W	D0,D5
	BCS.S	blt_mscr2
	CMP.W	D1,D4
	BHI.S	blt_mscr2
	CMP.W	D1,D6
	BCS.S	blt_mscr2
	RTS

blt_mscr0:
	CMP.W	D0,D3
	BHI.S	blt_rts
	CMP.W	D0,D5
	BCS.S	blt_rts
	CMP.W	D1,D4
	BHI.S	blt_rts
	CMP.W	D1,D6
	BCS.S	blt_rts
blt_mscr2:
	EOR.W	D2,D7
blt_mscr3:
	MOVEM.W D0-D7,-(SP)
	CMP.W	#1,blt_ctrlreg
	BNE.S	blt_mscr4
	BSR.S	wt_mscr1		; blit to planes 2-3
blt_mscr4:
	CMP.W	#2,blt_ctrlreg
	BNE.S	blt_mscr5
	BSR.S	wt_mscr0		; blit to planes 0-1
blt_mscr5:
	MOVEM.W (SP)+,D0-D7
	RTS

wt_mscr0:
	MOVE.W	D3,D0
	MOVE.W	D4,D1
	MOVE.W	D5,D2
	ADDQ.W	#1,D2
	MOVE.W	D6,D3
	ADDQ.W	#1,D3
	GOTO	Blitcharge0		; blit to planes 0-1

wt_mscr1:
	MOVE.W	D3,D7
	MOVE.W	D3,D0
	MOVE.W	D4,D1
	MOVE.W	D1,D3
	ADDQ.W	#1,D3
	MOVE.W	D5,D2
	CALL	BlitCharge1		; blit to planes 2-3
	MOVE.W	D5,D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	MOVE.W	D4,D1
	ADDQ.W	#1,D1
	MOVE.W	D6,D3
	ADDQ.W	#1,D3
	CALL	BlitCharge1
	MOVE.W	D7,D0
	ADDQ.W	#1,D0
	MOVE.W	D5,D2
	MOVE.W	D6,D1
	MOVE.W	D6,D3
	ADDQ.W	#1,D3
	CALL	BlitCharge1
	MOVE.W	D7,D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	MOVE.W	D4,D1
	ADDQ.W	#1,D1
	MOVE.W	D6,D3
	GOTO	BlitCharge1

blt_ctrlreg:	dc.w	0
MousKoordReg1:	dc.b	0,0

;********************************
;* Basic blitting routine for PT*
;********************************

;in =>> A0=GFX, D0=XPos, D1=YPos

BlitAllBasic:
	MOVE.W	D0,bltXPos
	MOVE.W	D1,bltYPos

.blitloop:

	MOVE.W	(A0)+,D0
	BEQ.W	.skip

	CMP.W	#1,D0
	BNE.S	.draw2

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	MOVE.W	#1,svolreg3
	MOVE.W	#3,svolreg4
	BSR.W	SubBlitMC
	BRA.S	.blitloop

.draw2:	CMP.W	#2,D0
	BNE.S	.draw3

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	MOVE.W	#3,svolreg3
	MOVE.W	#1,svolreg4
	BSR.W	SubBlitMC
	BRA.S	.blitloop

.draw3:	CMP.W	#3,D0
	BNE.S	.draw4

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	MOVE.W	#1,svolreg3
	MOVE.W	#3,svolreg4
	BSR.W	SubBlitMD
	BRA.W	.blitloop

.draw4:	CMP.W	#4,D0
	BNE.S	.draw5

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	MOVE.W	#3,svolreg3
	MOVE.W	#1,svolreg4
	BSR.W	SubBlitMD
	BRA.W	.blitloop

.draw5:	CMP.W	#5,D0
	BNE.S	.draw6

	MOVE.W	(A0)+,D5
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	BSR.W	SubBlitMB
	BRA.W	.blitloop

.draw6:	CMP.W	#6,D0
	BNE.S	.draw7

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	LEA	Wr_Message,A2
	BSR.W	SubBlitMA
	BRA.W	.blitloop

.draw7:	CMP.W	#7,D0
	BNE.S	.draw8

	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	LEA	BlitText1,A2
	BSR.S	SubBlitMA
	BRA.W	.blitloop

.draw8:	CMP.W	#8,D0
	BNE.S	.drawA

	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	LEA	BlitText2,A2
	BSR.S	SubBlitMA
	BRA.W	.blitloop

.drawA:	CMP.W	#10,D0
	BNE.S	.draw9

	MOVE.W	(A0)+,D5
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	ADD.W	bltXPos(PC),D2
	ADD.W	bltYPos(PC),D3
	CALL	drwths4
	BRA.W	.blitloop

.draw9:	CMP.W	#9,D0
	BNE.S	.skip

	MOVE.W	(A0)+,D5
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	ADD.W	bltXPos(PC),D0
	ADD.W	bltYPos(PC),D1
	CALL	DrawThis
	BRA.W	.blitloop

.skip:	RTS

;---
SubBlitMA:
	MOVEM.L D0-D7,-(SP)
	MOVE.L	A0,A1
	MOVEQ	#-1,D3

.loop:	ADDQ.W	#1,D3
	TST.B	(A0)+
	BNE.S	.loop
	MOVE.L	A0,D4
	ADDQ.L	#1,D4
	AND.L	#$FFFFFFFE,D4
	MOVE.L	D4,A0
	MOVE.L	A0,-(SP)
	MOVE.L	A1,A0
	JSR	(A2)
	MOVE.L	(SP)+,A0
	MOVEM.L (SP)+,D0-D7
	RTS
;---
SubBlitMB:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	D2
	BLE.S	.skip
	TST.W	D3
	BLE.S	.skip
	ADD.W	D0,D2
	ADD.W	D1,D3
	CALL	BlitToMain		;blit
.skip:	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS
;---
SubBlitMC:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	D2
	BLE.W	.skip
	TST.W	D3
	BLE.W	.skip
	ADD.W	D0,D2
	ADD.W	D1,D3
	MOVE.W	D0,blt_reg1
	MOVE.W	D1,blt_reg2
	MOVE.W	D2,blt_reg3
	MOVE.W	D3,blt_reg4
	MOVEQ	#2,D5
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	MOVE.W	blt_reg3(PC),D2
	MOVE.W	blt_reg2(PC),D1
	SUBQ.W	#1,D2
	MOVE.W	D1,D3
	ADDQ.W	#1,D3
	MOVE.W	svolreg3(PC),D5
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	MOVE.W	blt_reg2(PC),D1
	ADDQ.W	#1,D1
	MOVE.W	blt_reg4(PC),D3
	SUBQ.W	#1,D3
	MOVE.W	svolreg3(PC),D5
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg3(PC),D0
	MOVE.W	D0,D2
	SUBQ.W	#1,D0
	MOVE.W	blt_reg2(PC),D1
	ADDQ.W	#1,D1
	MOVE.W	blt_reg4(PC),D3
	MOVE.W	svolreg4(PC),D5
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	ADDQ.W	#1,D0
	MOVE.W	blt_reg3(PC),D2
	MOVE.W	blt_reg4(PC),D1
	MOVE.W	D1,D3
	SUBQ.W	#1,D1
	MOVE.W	svolreg4(PC),D5
	CALL	BlitToMain		;blit

.skip:	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS
;---
SubBlitMD:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	D2
	BLE.W	.skip

	TST.W	D3
	BLE.W	.skip

	ADD.W	D0,D2
	ADD.W	D1,D3
	MOVE.W	D0,blt_reg1
	MOVE.W	D1,blt_reg2
	MOVE.W	D2,blt_reg3
	MOVE.W	D3,blt_reg4
	MOVEQ	#2,D5
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	MOVE.W	blt_reg3(PC),D2
	MOVE.W	blt_reg2(PC),D1
	SUBQ.W	#1,D2
	MOVE.W	D1,D3
	ADDQ.W	#1,D3
	MOVE.W	svolreg3(PC),D5
	CALL	BlitToMain		;blit
	ADDQ.W	#1,D1
	ADDQ.W	#1,D3
	SUBQ.W	#1,D2
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	MOVE.W	blt_reg2(PC),D1
	ADDQ.W	#1,D1
	MOVE.W	blt_reg4(PC),D3
	SUBQ.W	#1,D3
	MOVE.W	svolreg3(PC),D5
	CALL	BlitToMain		;blit
	ADDQ.W	#1,D0
	ADDQ.W	#1,D2
	SUBQ.W	#1,D3
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg3(PC),D0
	MOVE.W	D0,D2
	SUBQ.W	#1,D0
	MOVE.W	blt_reg2(PC),D1
	ADDQ.W	#1,D1
	MOVE.W	blt_reg4(PC),D3
	MOVE.W	svolreg4(PC),D5
	CALL	BlitToMain		;blit
	SUBQ.W	#1,D0
	SUBQ.W	#1,D2
	ADDQ.W	#1,D1
	CALL	BlitToMain		;blit
	MOVE.W	blt_reg1(PC),D0
	ADDQ.W	#1,D0
	MOVE.W	blt_reg3(PC),D2
	MOVE.W	blt_reg4(PC),D1
	MOVE.W	D1,D3
	SUBQ.W	#1,D1
	MOVE.W	svolreg4(PC),D5
	CALL	BlitToMain		:blit
	SUBQ.W	#1,D1
	SUBQ.W	#1,D3
	ADDQ.W	#1,D0
	CALL	BlitToMain		;blit

.skip:	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

bltXPos:	dc.w	0
bltYPos:	dc.w	0
svolreg3:	dc.w	1
svolreg4:	dc.w	2
blt_reg1:	dc.w	0
blt_reg2:	dc.w	0
blt_reg3:	dc.w	0
blt_reg4:	dc.w	0

;*************************************
;----------- Disk Operation ----------
;*************************************

DiskOp:
	cmp.w	#3,CurrScreen
	beq.w	ExitFromDir
	BSR.W	TopExit 			; exit other screens

ShowDirScreen:

	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	#$FFFF,scrtablecl
	BSR.W	WaitForButtonUp
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	#$FFFF,scrtablecl
	MOVE.W	#3,CurrScreen
	CALL	ClearAllKeys			; 3.58
	ST	NoSampleInfo
	BSR.W	Clear120Lines
	BSR.W	SwapDirScreen
	BNE.W	DisplayMainAll
	BSR.W	ShowDiskDrives
	BSR.W	ItsRealDisk
	BSR.W	SelPck
	BSR.W	RawIFFTog2
	BSR.W	showsaveformat
	BSR.W	TogIconsShow
	BSR.W	FNameInDir		; samplename
	BSR.W	FilePattern
	CLR.W	DirCopFlag
	MOVE.L	DirMousetable(PC),A5
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames

	BSR.W	rd_upddirlist		; dirpropscroller on
	BTST	#3,PackMode
	BEQ.S	SelectCachedPath
	MOVE.L	DirMousetable(PC),A5
	TST.W	8(A5)
	BNE.S	SelectCachedPath
SelectPath:
	MOVE.W	DirPathNum,D0
	;cmp.w	#1,d0
	;beq.w	rd_exe
	CMP.W	#2,D0
	BEQ.W	rd_modul		;mod
	;CMP.W	#3,D0
	;BEQ.W	SelectSong		;song
	;cmp.w	#4,d0
	;beq.w	SelectInstrument
	;CMP.W	#5,D0
	;BEQ.W	SelectSample		;sample
	;cmp.w	#6,d0
	;beq.w	rd_patt
	BRA.W	SelectModules

SelectCachedPath:
	MOVE.W	DirPathNum,D0
	CMP.W	#1,D0
	BEQ.W	dt_tog_exe
	CMP.W	#2,D0
	BEQ.W	SelectModules
	CMP.W	#3,D0
	BEQ.W	dt_tog_song
	CMP.W	#4,D0
	BEQ.W	dt_tog_track
	CMP.W	#5,D0
	BEQ.W	dt_tog_sample
	CMP.W	#6,D0			;4
	BEQ.W	dt_tog_patt
	RTS

SwapDirScreen:
	LEA	DirScreenData,a0
	CALL	UpperDecrunch
	RTS


CheckDirGadgets:
	MOVE.L	DirMousetable(PC),A5
	MOVEM.W (MouseX2),D0/D1
	LEA	DirGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	ChkDirGadgs
	RTS

ChkDirGadgs:
	CMP.W	#1,D2
	BEQ.W	ExitFromDir
	CMP.W	#2,D2
	BEQ.W	SelSamMod		;pack on/off
	CMP.W	#3,D2
	BEQ.W	RawIFFTog
	cmp.w	#$04,d2 		;save mode iff/raw module+song
	beq.w	modmodechg
	CMP.W	#5,D2
	BEQ.W	ToggleShowIcons
	CMP.W	#6,D2
	BEQ.W	ResetPathsQuest
	CMP.W	#7,D2
	BEQ.W	Format_Disk
	CMP.W	#8,D2
	BEQ.W	Relabel_Disk
	CMP.W	#9,D2
	BEQ.W	HitFilePattern
	CMP.W	#10,D2
	BEQ.W	MkDirMsg		;
	CMP.W	#11,D2
	BEQ.W	SelFileMsg
	CMP.W	#12,D2
	BEQ.W	DeleteFile
	CMP.W	#13,D2
	BEQ.W	HitPathInDir
	CMP.W	#14,D2
	BEQ.W	HitFileNameInDir	;filename in dirscreen input
	CMP.W	#15,D2			;togglescreen gadg
	BEQ.W	Screenswitch
	CMP.W	#$10,D2 		;read dir
	BEQ.W	ReadDir
	CMP.W	#$11,D2
	BEQ.W	di_parentdir
	CMP.W	#$12,D2
	BEQ.W	DirTypeToggle
	CMP.W	#$14,D2
	BEQ.W	dt_tog_exe
	cmp.w	#$15,d2
	beq.w	SaveTheExe
	CMP.W	#$16,D2
	BEQ.W	SelectModules
	CMP.W	#$17,D2
	BEQ.W	SaveModule
	CMP.W	#$18,D2
	BEQ.W	dt_tog_song
	CMP.W	#$19,D2
	BEQ.W	SaveTheSong
	CMP.W	#$1A,D2
	BEQ.W	dt_tog_track
	cmp.w	#$1B,D2
	beq.w	SaveTheTrack
	CMP.W	#$1C,D2
	BEQ.W	dt_tog_sample
	CMP.W	#$1D,D2
	BEQ.W	dosavesample
	CMP.W	#$1E,D2
	BEQ.W	dt_tog_patt

	cmp.w	#$1F,D2
	beq.w	SaveThePattern
	CMP.W	#$20,D2
	BEQ.W	FileNameOneUp
	CMP.W	#$21,D2
	BEQ.W	DirPropScroller
	CMP.W	#$22,D2
	BEQ.W	FileNameOneDown
	CMP.W	#$25,D2
	BEQ.W	ShowFreeDiskGadg	;FREE
	CMP.W	#$26,D2
	BEQ.W	HitDirloadEntry
	CMP.W	#$0064,D2
	BCC.W	di_DiskDrives
	RTS

ChkDirMouse:
	MOVEM.W (MouseX2),D0/D1
	LEA	DirCacheGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.doit
	RTS

.doit:	CMP.W	#1,D2
	BEQ.W	lbC00310E
	CMP.W	#10,D2
	BEQ.S	DTTogMod
	CMP.W	#11,D2
	BEQ.S	DTTogSong
	CMP.W	#12,D2
	BEQ.S	DTTogTrck
	CMP.W	#13,D2
	BEQ.S	DTTogSam
	CMP.W	#14,D2
	BEQ.S	DTTogPat
	CMP.W	#15,D2
	BEQ.S	DTTogExe
	RTS

DTTogMod:
	MOVEQ	#1,D0
	LEA	dt_tog_exe(PC),A0
	BRA.S	ClearPathDatas

DTTogSong:
	MOVEQ	#2,D0
	LEA	SelectModules(PC),A0
	BRA.S	ClearPathDatas

DTTogTrck:
	MOVEQ	#3,D0
	LEA	dt_tog_song(PC),A0
	BRA.S	ClearPathDatas

DTTogSam:
	MOVEQ	#4,D0
	LEA	dt_tog_track(PC),A0
	BRA.S	ClearPathDatas

DTTogPat:
	MOVEQ	#5,D0
	LEA	dt_tog_sample(PC),A0
	BRA.S	ClearPathDatas

DTTogExe:
	MOVEQ	#6,D0
	LEA	dt_tog_patt(PC),A0

;***********************************
;* saveformat toggle in dirscreen  *
;***********************************
modmodechg:
	addq.b	#1,modmode
	cmp.b	#2,modmode
	bmi.s	showsaveformat
	clr.b	modmode

showsaveformat:
	lea	modmodetxt(PC),a0
	moveq	#0,D0
	move.b	modmode,d0
	lsl.w	#2,d0
	lea	0(a0,d0.w),a0
	move.w	#$017E-200-109,d0	;x-pos txt
	move.w	#$11+11+8,d1	  	;y-pos txt
	moveq	#4,d3
	CALL	Write_Text
	RTS

modmodetxt:	dc.b	'OLD IFF '

;***********************************
;* clears actual module+filepath   *
;***********************************
ClearPathDatas:
	SUBQ.W	#1,D0
	CMP.W	#5,D0
	BLS.S	.doit			;=<5
	RTS

.doit:	MULU	#32,D0
	LEA	ModulesPath2,A1
	LEA	FilePatternData,A2
	LEA	0(A1,D0.L),A1
	LEA	0(A2,D0.L),A2

	MOVEQ	#31+50,D0		;4.0
.loo:	MOVE.B	(A2)+,(A1)+
	DBRA	D0,.loo

	JSR	(A0)
	BTST	#3,PackMode
	BNE.W	SelectPath
	RTS

;***********************************

SelFileMsg:
	MOVE.W	DirFBitt,DirFBitt2
	MOVE.W	#10,DirFBitt
	LEA	RenameFileTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

MkDirMsg:
	LEA	Makedirectory.MSG(PC),A0
	LEA	modules.MSG(PC),A1
	MOVEQ	#32,D0
	LEA	NotStandardSongData,A2
	CALL	mt_makereqindir
	BEQ.S	CreatDirMsg
	RTS

CreatDirMsg:
	LEA	Creatingdirec.MSG(PC),A0
	CALL	ShowStatusText
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	modules.MSG(PC),A0	;default 'modules'
	MOVEQ	#$17,D0 		;length 23

CreatDirDT:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,CreatDirDT
	MOVE.L	#FileName,D1
	MOVE.L	DOSBase,A6
	CALLSYS	CreateDir
	BSR.W	RestorePtrCol
	CALL	ShowAllRight
	BTST	#3,PackMode
	BNE.S	CreatDirEnd
	RTS

CreatDirEnd:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir

Makedirectory.MSG:	dc.b	10,10,'   MAKE DIRECTORY:',0
Creatingdirec.MSG:	dc.b	'CREATING DIRECTORY...',0
modules.MSG:		dc.b	'modules'
			dcb.b	27,0
			EVEN

*********************************
DeleteFile:
	MOVE.W	DirFBitt,DirFBitt2
	MOVE.W	#9,DirFBitt
	LEA	DeleteFileTXT,A0
	CALL	ShowStatusText
	BRA.W	SetDeletePtrCol


SelSamMod:
	BCHG	#1,PackMode

SelPck:
	LEA	off.MSG(PC),A0
	BTST	#1,PackMode
	BEQ.S	SelPck2
	LEA	on.MSG0(PC),A0

SelPck2:
	MOVEQ	#3,D0
	MOVE.W	#$0469,D1
	CALL	ShowText3
	BRA.W	WaitForButtonUp

RawIFFTog:
	EOR.B	#1,RAWIFFMode

RawIFFTog2:
	LEA	RAW.MSG(PC),A0
	TST.B	RAWIFFMode
	BEQ.S	RawIFFTog3
	LEA	IFF.MSG(PC),A0

RawIFFTog3:
	MOVEQ	#3,D0
	MOVE.W	#$07D9,D1
	CALL	ShowText3
	BRA.W	WaitForButtonUp

RAW.MSG:	dc.b	'RAW',0
IFF.MSG:	dc.b	'IFF',0

;*******************************
ExitFromDir:
	CLR.W	DProp_X
	MOVE.W	#$0053,DProp_Y
	MOVE.B	#$F8,EmptySprite+1
	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3
	CMP.W	#$FFFF,scrtablecl
	BEQ.S	DispMain
	MOVEM.L D0-D3/A0,-(SP)
	CALL	ClrWhiteLines
	MOVEM.L (SP)+,D0-D3/A0
	MOVE.W	#$FFFF,scrtablecl
	MOVE.W	#$FFFF,DirCopFlag

DispMain:
	BSR.W	WaitForButtonUp
	BSR.W	SwapDirScreen
	BSR.W	Clear120Lines

DisplayMainAll:
	move.w	#1,CurrScreen
	BSR.W	DisplayMainScreen
	CALL	ShowSongLength
	CALL	ShowSampleInfo
	CALL	ShowSongName
	CALL	PrintmultiM
	TST.W	LoadingInProgress
	BNE.S	RefrMainScr			; refreshmainscreen
	CALL	BlitManyThings 			; included
	BNE.S	RefrMainScr
	CALL	ShowAllRight

RefrMainScr:
	GOTO	ShowPosition


xxPLST: 	GOTO	PLST
xxInfoScreen:	GOTO	InfoScreen
xxPosED:	GOTO	PosED
xxDirScreen:	GOTO	DiskOp


;*********************************
;* shows all drives/assigns in   *
;* the directory screen          *
;*********************************

ShowDiskDrives:
	CALL	WaitForDiskDrive
	BSR.W	di_assrdl
	BEQ.S	di_intrd1
	RTS

di_intrd1:
	TST.W	di_Diskflag2
	BNE.S	di_intrd2
	RTS

di_intrd2:
	MOVE.B	ShowZeroFlag,D0
	MOVE.B	D0,di_intrdflag		;save showzeroflag
	MOVE.B	#$20,ShowZeroFlag
	MOVE.L	assignsmem(PC),D0
	BNE.S	di_intrd3

	MOVE.B	di_intrdflag(PC),D0	;restore showzeroflag
	MOVE.B	D0,ShowZeroFlag

	RTS

di_intrd3:
	MOVE.L	D0,A0
	MOVE.W	di_Diskflag(PC),D0
	MULU	#$0020,D0
	ADD.L	D0,A0
	MOVE.W	#$00CA,D0
	MOVE.W	#14,D1
	MOVEQ	#8,D3
	MOVE.W	di_Diskflag2(PC),D7
	SUB.W	di_Diskflag(PC),D7
	CMP.W	#$0010,D7
	BMI.S	di_intrd4
	MOVEQ	#$10,D7			;10 drives
di_intrd4:
	SUBQ.W	#1,D7
	BMI.S	di_intrd9
di_intrd5:
	TST.L	(A0)
	BNE.S	di_intrd6

	MOVE.B	di_intrdflag(PC),D0	;restore showzeroflag
	MOVE.B	D0,ShowZeroFlag

	RTS

di_intrd6:
	CALL	Wr_Message
	LEA	$0020(A0),A0
	CMP.W	#$00CA,D0
	BNE.S	di_intrd7
	MOVE.W	#$0106,D0
	DBRA	D7,di_intrd5
	BRA.S	di_intrd9

di_intrd7:
	MOVE.W	#$CA,D0
	ADD.W	#11,D1
	DBRA	D7,di_intrd5		;next drive
di_intrd9:
	MOVE.B	di_intrdflag(PC),D0	;restore showzeroflag
	MOVE.B	D0,ShowZeroFlag
	RTS

di_intrdflag:	dc.b	0,0

;*********************************
lbC00310E:
	BSR.W	WaitForButtonUp
	CMP.W	#$10,di_Diskflag2
	BPL.S	.skip
	RTS

.skip:
	MOVE.W	di_Diskflag(PC),D0
	ADD.W	#$10,D0
	CMP.W	di_Diskflag2(PC),D0
	BLT.S	.doit
	MOVEQ	#0,D0
.doit:
	MOVE.W	D0,di_Diskflag
	BSR.S	lbC00313A
	BRA.W	di_intrd1
lbC00313A:
	MOVEQ	#15,D7
	MOVE.W	#$CA,D0
	MOVE.W	#14,D1
	MOVEQ	#8,D3
lbC003146:
	LEA	ascii.MSG16(PC),A0
	CALL	Wr_Message
	CMP.W	#$CA,D0
	BNE.S	lbC003160
	MOVE.W	#$0106,D0
	DBRA	D7,lbC003146
	BRA.S	lbC00316C

lbC003160:
	MOVE.W	#$CA,D0
	ADD.W	#11,D1
	DBRA	D7,lbC003146
lbC00316C:
	RTS

ascii.MSG16:	dc.b	'                    ',0,0

;**********************************
;*        allocate and prepare    *
;*        diskdrives/assigns      *
;**********************************
di_DiskDrives:
	SUB.W	#$64,D2
	ADD.W	di_Diskflag(PC),D2
	CMP.W	di_Diskflag2(PC),D2
	BLT.S	ReadDiskDriveGads
	RTS

ReadDiskDriveGads:
	MULU	#32,D2
	MOVE.L	assignsmem(PC),A1
	LEA	0(A1,D2.L),A1
	MOVE.W	DirPathNum,D0			;1-6
	SUBQ.W	#1,D0
	MULU	#32+50,D0
	LEA	ModulesPath2,A0

	LEA	0(A0,D0.L),A0
	MOVEQ	#31+50,D1
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D1,.loo
	BSR.W	ShowDirPath
	BRA.W	di_readdir

di_assrdl:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	4.w,a6
	CALLSYS	Forbid
	MOVE.L	DOSBase,A1
	MOVE.L	$22(A1),A1
	MOVE.L	$18(A1),A1
	MOVE.L	A1,D0
	LSL.L	#2,D0
	MOVE.L	D0,A1
	MOVE.L	4(A1),D0
	LSL.L	#2,D0
	MOVE.L	D0,A1
	MOVE.L	A1,lbL003360
	BSR.W	di_agb1
	ADDQ.W	#6,D0
	MOVE.W	D0,di_Diskflag2
	MULU	#32+50,D0
	CMP.L	assign_memflag(PC),D0
	BEQ.S	di_ag1
	MOVE.L	D0,-(SP)
	BSR.W	di_assignsfreemem
	MOVE.L	(SP)+,D0
	CLR.W	di_Diskflag
	MOVE.L	D0,assign_memflag
	MOVE.L	#$00010000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem		;alloc mem for diskdrives
	MOVE.L	D0,assignsmem
	BEQ.S	di_agrt			;memerror
di_ag1:
	MOVE.L	assignsmem(PC),A0
	MOVE.L	assign_memflag(PC),D0
	SUBQ.L	#1,D0
	BMI.S	di_ag3
di_ag2:
	CLR.B	(A0)+
	SUBQ.L	#1,D0
	BPL.S	di_ag2
di_ag3:
	CLR.L	CachBytes
	CLR.L	lbL00335C
	BSR.B	di_agc1
	MOVE.L	#2,lbL00335C
	BSR.S	di_agc1
	MOVE.L	#1,lbL00335C
	BSR.S	di_agc1
	BSR.W	di_age1
	MOVE.L	4.w,a6
	CALLSYS	Permit
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D0
	RTS

di_agrt:
	MOVEM.L (SP)+,D0-D7/A0-A6
	CLR.W	di_Diskflag2
	CLR.W	di_Diskflag
	MOVE.L	4.w,a6
	CALLSYS	Permit
	CALL	OutOfMemErr
	MOVEQ	#0,D0
	RTS

di_agb1:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	lbL003360(PC),A1
	MOVEQ	#0,D0
di_agb2:
	MOVE.L	(A1),D1
	BEQ.S	di_agbrt
	LSL.L	#2,D1
	MOVE.L	D1,A1
	TST.L	8(A1)
	BEQ.S	di_agb2
	ADDQ.L	#1,D0
	BRA.S	di_agb2

di_agbrt:
	MOVEM.L (SP)+,D1-D7/A0-A6
	RTS

di_agc1:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	lbL003360(PC),A1
di_agc2:
	MOVE.L	(A1),D0
	BEQ.S	di_agcrt
	LSL.L	#2,D0
	MOVE.L	D0,A1
	TST.L	8(A1)
	BEQ.S	di_agc2
	MOVE.L	lbL00335C(PC),D0
	CMP.L	4(A1),D0
	BEQ.S	di_agd1
	BRA.S	di_agc2

di_agcrt:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

di_agd1:
	MOVE.L	$0028(A1),D0
	LSL.L	#2,D0
	MOVE.L	D0,A2
	MOVEQ	#0,D5
	MOVE.L	assignsmem(PC),A3
	MOVE.L	CachBytes(PC),D5
	LEA	0(A3,D5.L),A3
	MOVEQ	#$1E,D7			;4.0
	LEA	1(A2),A2
.loo:
	TST.B	(A2)
	BEQ.S	di_agd2
	MOVE.B	(A2)+,(A3)+
	DBRA	D7,.loo
di_agd2:
	MOVE.B	#$3A,(A3)
	ADD.L	#$00000020,CachBytes
	BRA.S	di_agc2

di_age1:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	FilePatternData,A2
	MOVE.L	assignsmem(PC),A3
	MOVE.L	CachBytes(PC),D5
	LEA	0(A3,D5.L),A3
	MOVE.W	#$00BF,D7
di_age2:
	MOVE.B	(A2)+,(A3)+
	DBRA	D7,di_age2
	ADD.L	#$000000C0,CachBytes
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

CachBytes:	dc.l	0
lbL00335C:	dc.l	0
lbL003360:	dc.l	0

;*******************************
;* clears dirstuff by exit pt  *
;*******************************
di_clearbyexit:
	BSR.S	di_assignsfreemem
	CLR.W	di_Diskflag2
	CLR.W	di_Diskflag
	CLR.L	assign_memflag
	RTS

di_assignsfreemem:
	MOVE.L	assignsmem(PC),D1
	BEQ.S	assignsisfree
	MOVE.L	D1,A1
	MOVE.L	assign_memflag(PC),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	assignsmem
assignsisfree:
	RTS

assignsmem:	dc.l	0
assign_memflag:	dc.l	0
di_Diskflag:	dc.w	0
di_Diskflag2:	dc.w	0

;*******************************

DirTypeToggle:
	MOVE.W	DirPathNum(PC),D0
	CMP.W	#6,D0
	BLT.S	DTToggl2
	MOVEQ	#0,D0
DTToggl2:
	LSL.W	#2,D0
	MOVE.L	DTTogglData(PC,D0.W),A0
	JSR	(A0)				;fix to redraw by toggling

;--- read dir new after toggle

	btst	#3,PackMode
	bne.s	readnew
	RTS
readnew:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir

;----
DTTogglData:
	dc.l	dt_tog_exe		;exe
	dc.l	SelectModules		;mod
	dc.l	dt_tog_song		;song
	dc.l	dt_tog_track		;track
	dc.l	dt_tog_sample		;sample
	dc.l	dt_tog_patt		;pattern

;******************************************
ResetPathsQuest:
	LEA	ResPathTXT(PC),A0
	BSR.W	AreYouSure
	BEQ.S	ResetPaths
	RTS

ResetPaths:
	move.l	DISKConfBuf,D0		;org(PC)
	BEQ.S	respatret

	add.l	#8+6,d0
	move.l	d0,a0
	lea	ModulesPath2,A1
	lea	FilePatternData,a2
	moveq	#5,d0

RespathsLp:
	moveq	#32-1+50,D1

Respatlop:
	move.b	(a0),(a1)+
	move.b	(a0)+,(a2)+
	dbra	D1,Respatlop
	lea	45+32-1(a0),a0
	dbra	d0,RespathsLp
	lea	MatchPatterns,A1
	move.w	#32*6-1,D0

Respaloops:
	move.b	(A0)+,(A1)+
	dbra	d0,Respaloops
	bsr.w	FilePattern

respatret:
	BRA.W	ShowDirPath



ResPathTXT:	dc.b	10,10,'   Are you sure you want',$A
		dc.b	'    to reset all paths?',0
		EVEN

;**********************************
dt_tog_exe:
	MOVE.W	#2,DirFBitt
	MOVEQ	#1,D0
	LEA	SelectExeTXT,A0
	LEA	DCache_Exe(PC),A1
	BRA.S	ShowDTStatus

SelectModules:
	MOVE.W	#3,DirFBitt
	MOVEQ	#2,D0
	LEA	SelectModuleTXT,A0
	LEA	DCache_Mod(PC),A1
	BRA.S	ShowDTStatus

dt_tog_song:
	MOVE.W	#1,DirFBitt
	MOVEQ	#3,D0
	LEA	SelectSongTXT,A0
	LEA	DCache_Song(PC),A1
	BRA.S	ShowDTStatus

dt_tog_track:
	MOVE.W	#4,DirFBitt
	MOVEQ	#4,D0
	LEA	SelectTrackTXT,A0
	LEA	DCache_Track(PC),A1
	BRA.S	ShowDTStatus

dt_tog_sample:
	MOVE.W	#5,DirFBitt
	MOVEQ	#5,D0
	LEA	SelectSampleTXT,A0
	LEA	DCache_Sampl(PC),A1
	BRA.S	ShowDTStatus


dt_tog_patt:
	MOVE.W	#6,DirFBitt
	MOVEQ	#6,D0
	LEA	SelectPatternTXT,A0
	LEA	DCache_Patt(PC),A1

ShowDTStatus:
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	ShowStatusText
	MOVEM.L (SP)+,D0-D7/A0-A6

	BTST	#2,InfoOnOff
	BNE.S	.l1
	LEA	DCache_Mod(PC),A1
.l1:
	MOVE.L	A1,DirMousetable
	BSR.W	updcheckmarks
	MOVE.W	D0,DirPathNum
	SUBQ.W	#1,D0
	MULU	#32+50,D0			;3.58
	LEA	ModulesPath2,A3
	LEA	0(A3,D0.L),A3
	MOVE.L	A3,DirPath
	LEA	CheckMarkFlg(PC),A0
	MOVE.B	#$60,CheckMarkFlg
	MOVE.W	DirPathNum(PC),D1
	MULU	#11,D1
	ADD.W	#24,D1
	MOVEQ	#$65,D0
	MOVEQ	#1,D3
	CALL	Wr_Message			; print checkmark in dirwin
	MOVE.W	DirPathNum(PC),D0
	SUBQ.W	#1,D0
	MULU	#10,D0
	LEA	ModTypeSwitchTXT(PC,D0.L),A0
	MOVE.W	#$00EA,D0
	MOVEQ	#$71,D1
	MOVEQ	#10,D3
	CALL	Wr_Message
	BSR.W	FNameInDir			; samplename
	BSR.W	FilePattern
	BSR.W	ShowDirPath
	BSR.W	SetNormalPtrCol
	BTST	#2,InfoOnOff
	BEQ.S	lbC003566
	MOVE.L	DirMousetable(PC),A5
	CMP.W	#$0013,$0016(A5)
	BPL.S	lbC003556
	BSR.W	xClearRightArea
lbC003556:
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	BSR.W	ItsRealDisk
lbC003566:
	BRA.W	WaitForButtonUp


ModTypeSwitchTXT:	dc.b	'Executable  Module     Song      Track    Sample    Pattern ',0
			EVEN

DirPathNum:		dc.w	2

;**************************************
;* update correct state of checkmarks *
;* in the directory screen            *
;**************************************

updcheckmarks:
	MOVEM.L D0-D3/A0,-(SP)
	LEA	CheckMarkFlg(PC),A0
	MOVE.B	#32,CheckMarkFlg
	MOVE.W	DirPathNum,D1
	MULU	#11,D1
	ADD.W	#24,D1
	MOVE.W	#101,D0
	MOVEQ	#1,D3
	CALL	Wr_Message
	MOVEM.L (SP)+,D0-D3/A0
	RTS

CheckMarkFlg:	dc.b	0,0

;*************************************
ReadDir:
	MOVE.W	DirPathNum,D0
	cmp.w	#1,d0
	beq.w	rd_exe
	CMP.W	#2,D0			;mod
	BEQ.W	rd_modul
	CMP.W	#3,D0			;song
	BEQ.S	SelectSong
	cmp.w	#4,d0
	beq.b	SelectTrack
	CMP.W	#5,D0			;sample
	BEQ.W	SelectSample
	cmp.w	#6,d0
	beq.w	rd_patt
	RTS

;**********************************
SelectSong:
	BSR.W	StorePtrCol
	BSR.W	WaitForButtonUp
	BSR.W	dt_tog_song
	BSR.W	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR.W	ClearDirTotal
	BSR.W	DirDisk
	BNE.W	RestorePtrCol
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	MOVE.W	#1,DirFBitt
	LEA	SelectSongTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

;--------------------------
SelectTrack:
	BSR.W	StorePtrCol
	BSR.W	WaitForButtonUp
	BSR.W	dt_tog_track
	BSR.W	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR.W	ClearDirTotal
	BSR.W	DirDisk
	BNE.W	RestorePtrCol
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	MOVE.W	#4,DirFBitt
	LEA	SelectTrackTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

;**********************************
SaveTheTrack:
	bsr.w	dt_tog_track
	LEA	SaveTrackTXT,A0
	BSR.W	AreYouSure
	BEQ.S	savetracknow
	RTS

savetracknow:
	CALL	calcloadtr
	bsr.w	CopyTrack
	CALL	savethetrack2
	MOVE.W	#4,DirFBitt
	CALL	ShowAllRight
	BTST	#3,PackMode
	BNE.W	di_rdrdmod
	RTS

savethetrack2:
	BSR.W	StorePtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	move.l	a1,-(sp)
	MOVE.L	mt_songdataptr,A0
	MOVEQ	#$13,D0
.loop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loop
	move.l	(sp),a1
	subq.l	#1,a1

dseloop7:
	addq.l	#1,a1
	cmp.b	#0,(a1)
	bne.s	dseloop7

	move.b	#'.',(a1)+
	move.b	#'T',(a1)+
	move.b	#'R',(a1)+
	move.b	#'K',(a1)+
	CLR.B	(A1)+
	MOVE.L	(SP)+,A1

	MOVE.L	#TrackBuffer,DiskDataPtr
	BSR.W	SetDiskPtrCol
	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,FileNamePtr
	MOVE.L	FileNamePtr,D1
	MOVE.L	#$3EE,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.B	SaveTrackNow
	BRA.W	ErrorRestoreCol

SaveTrackNow:
	LEA	SavingTrackText,A0
	CALL	ShowStatusText

	MOVE.L	FileHandle,D1
	MOVE.L	#TrackHeader,D2
	MOVEQ	#$10,D3
	CALLSYS	Write

	MOVE.L	FileHandle,D1
	MOVE.L	DiskDataPtr,D2
	MOVE.L	#256,D3
	CALLSYS	Write

	MOVE.L	FileHandle,D1
	CALLSYS	Close
	CLR.L	FileHandle
	MOVE.W	#4,DirFBitt
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	BTST	#3,PackMode
	BNE.W	ReRdDir2
	RTS

TrackHeader:
	dc.b	'FORM',0,0
	dc.b	$1,00			;length 256 Bytes
	dc.b	'PTCFTRCK',0,0
	EVEN
;**********************************
rd_exe:
	BSR.W	StorePtrCol
	BSR.W	WaitForButtonUp
	BSR.W	dt_tog_exe
	BSR.W	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR.W	ClearDirTotal
	BSR.W	DirDisk
	BNE.W	RestorePtrCol
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	MOVE.W	#2,DirFBitt
	LEA	SelectExeTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

SaveTheExe:
	chn8test
	BEQ.S	.chn8

	bsr.w	dt_tog_exe
	LEA	SaveExeTXT,A0
	BSR.W	AreYouSure
	BEQ.S	.doit
	RTS

.doit:	CALL	savetheexe2
	MOVE.W	#2,DirFBitt
	CALL	ShowAllRight
	BTST	#3,PackMode
	BNE.W	di_rdrdmod
	RTS

.chn8:	LEA	no8modtxt,a0
	bsr.w	AreYouSure
	RTS

;**********************************
rd_patt:
	BSR.W	StorePtrCol
	BSR.W	WaitForButtonUp
	BSR.W	dt_tog_patt
	BSR.W	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR.W	ClearDirTotal
	BSR.W	DirDisk
	BNE.W	RestorePtrCol
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	MOVE.W	#6,DirFBitt
	LEA	SelectPatternTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

SaveThePattern:
	bsr.w	dt_tog_patt
	LEA	SavePattTXT,A0
	BSR.W	AreYouSure
	BEQ.S	savepattnow
	RTS

savepattnow:
	CALL	calcloadtr
	BSR.W	CopyPattern
	BSR.W	StorePtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	move.l	a1,-(sp)
	MOVE.L	mt_songdataptr,A0
	MOVEQ	#$13,D0
dseloop4:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dseloop4
	move.l	(sp),a1
	subq.l	#1,a1
dseloop5:
	addq.l	#1,a1
	cmp.b	#0,(a1)
	bne.s	dseloop5

	move.b	#'.',(a1)+
	move.b	#'P',(a1)+
	move.b	#'A',(a1)+
	move.b	#'T',(a1)+
	move.b	#0,(a1)+
	move.l	(SP)+,a1

	MOVE.L	PatternBuffer,DiskDataPtr
	BSR.W	SetDiskPtrCol
	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,FileNamePtr
	MOVE.L	FileNamePtr,D1
	MOVE.L	#$3EE,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.S	SavePatternNow
	BRA.W	ErrorRestoreCol

;**********************************
SavePatternNow:
	LEA	SavingPatternText,A0
	CALL	ShowStatusText
	MOVE.L	FileHandle,D1
	move.l	#PROTPATT.MSG,D2	; 16 byte header
	MOVEQ	#$10,D3
	CALLSYS	Write
	MOVE.L	FileHandle,D1
	move.l	#PatternBuffer,d2
	MOVE.L	#1024,D3		; 1024 Bytes

	chn8test
	BNE.S	.chn4
	MOVE.L	#2048,D3
.chn4:
	CALLSYS	Write
	MOVE.L	FileHandle,D1
	CALLSYS	Close
	CLR.L	FileHandle
	MOVE.W	#6,DirFBitt
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	BTST	#3,PackMode
	BNE.S	ReRdDir2
	RTS

ReRdDir2:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir


PROTPATT.MSG:	dc.b	'FORM',0,0
		dc.b	$4,00			;length 1024 Bytes
		dc.b	'PTCFPATT',0,0
		EVEN

;**********************************
SaveTheSong:
	BSR.W	dt_tog_song
	LEA	SaveSongTXT,A0
	BSR.W	AreYouSure
	BEQ.S	di_savsong
	RTS

di_savsong:
	BSR.W	RestorePtrCol
	CALL	SaveSong
	MOVE.W	#1,DirFBitt
	BTST	#3,PackMode
	BNE.S	di_rdrdso
	RTS

di_rdrdso:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir

;**********************************

rd_modul:
	BSR	StorePtrCol
	BSR	WaitForButtonUp
	BSR	SelectModules
	BSR	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR	ClearDirTotal
	BSR	DirDisk
	BEQ.S	.doit
	BRA	RestorePtrCol

.doit:
	MOVE.W	$18(A5),D0
	BSR	RedrawFileNames
	BSR	rd_upddirlist
	MOVE.W	#3,DirFBitt
	LEA	SelectModuleTXT,A0
	CALL	ShowStatusText
	BRA	RestorePtrCol

;**********************************

SaveModule:
	BSR.W	SelectModules
	LEA	SaveModuleTXT,A0
	BSR.W	AreYouSure
	BEQ.S	SaveModule2
	RTS

SaveModule2:
	CALL	SaveModule3
	MOVE.W	#3,DirFBitt
	CALL	ShowAllRight
	BTST	#3,PackMode
	BNE.S	di_rdrdmod
	RTS

di_rdrdmod:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir

;**********************************

SelectSample:
	BSR.W	StorePtrCol
	BSR.W	WaitForButtonUp
	BSR.W	dt_tog_sample
	BSR.W	xClearRightArea
	MOVE.L	DirMousetable(PC),A5
	BSR.W	ClearDirTotal
	BSR.W	DirDisk
	BEQ.S	lbC003720
	BRA.W	RestorePtrCol

lbC003720:
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	BSR.W	rd_upddirlist
	MOVE.W	#5,DirFBitt
	LEA	SelectSampleTXT,A0
	CALL	ShowStatusText
	BRA.W	RestorePtrCol

dosavesample:
	cmp.w	#3,CurrScreen
	bne.s	opdrscr
	BSR.W	dt_tog_sample
	CLR.B	RawKeyCode
	MOVE.W	InsNum,D0
	BNE.S	ThisSamSave
	GOTO	NotSampleNull

opdrscr:
	bsr.w	ShowDirScreen
	bra.s	dosavesample
ThisSamSave:
	;LEA	 SaveSampleTXT,A0
	;BSR.W	 AreYouSure
	;BEQ.S	 ThisSamSave2
	;RTS

ThisSamSave2:
	BSR.W	StorePtrCol
	CALL	CreateSampleName
	MOVEQ	#0,D1
	MOVE.W	InsNum,D1
	LSL.L	#2,D1
	LEA	mt_songdataptr,A0
	MOVE.L	0(A0,D1.W),DiskDataPtr
	BSR.W	SetDiskPtrCol
	MOVE.L	DOSBase,A6
	MOVE.L	FileNamePtr,D1
	MOVE.L	#$000003EE,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.S	SaveSample
	;CALL	 CantOpenFile
	BRA.W	ErrorRestoreCol

;**********************************
SaveSample:
	LEA	SavingSampleText,A0
	CALL	ShowStatusText
	TST.B	RAWIFFMode
	BEQ.S	SavAsRaw
	MOVE.L	FileHandle,D1
	MOVE.L	#FORM.MSG,D2
	MOVEQ	#$68,D3
	CALLSYS	Write
SavAsRaw:
	MOVE.L	FileHandle,D1
	MOVE.L	DiskDataPtr,D2
	MOVE.L	DiskDataLength,D3
	CALLSYS	Write
	MOVE.L	FileHandle,D1
	CALLSYS	Close
	CLR.L	FileHandle
	MOVE.W	#5,DirFBitt
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	BTST	#3,PackMode
	BNE.S	ReRdDir
	RTS

ReRdDir:
	MOVE.B	#$FF,di_readdirnew
	BRA.W	ReadDir

;********************************
;* IFF Header for sample saving *
;********************************

FORM.MSG:	dc.b	'FORM'
IFFSa_Length:	dc.l	0
		dc.b	'8SVXVHDR'
		dc.b	0,0,0,$14

lbL003840:	dc.l	0
lbB003844:	dc.l	0

		dc.b	0,0,0,$20
		dc.b	$41,$56,1,0
		dc.b	0,1,0,0

name.msg:	dc.b	'NAME'
		dc.b	0,0,0,$18

IFFSa_Name:	dcb.b	24,0

anno.msg:	dc.b	'ANNO'
		dc.b	0,0,0,$10

		dc.b	'PROTRACKER 4.00',0
		dc.b	'BODY'

lbL003890:	dc.l	0
		EVEN
;**********************************
FNameInDir:
	BSR.W	memcachedir
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#$2355,TextOffset
	CMP.W	#1,CurrScreen
	BEQ.B	rrra
	CMP.W	#2,CurrScreen
	BEQ.B	rrra
	CMP.W	#9,CurrScreen
	BEQ.B	rrra
	bra.b	rrrb
rrra:	MOVE.W	#$190A,TextOffset
rrrb:	MOVE.W	#$14,TextLength
	CALL	ShowText
	RTS

;**********************************
HitFileNameInDir:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol

	move.l	mt_songdataptr,A6
	move.l	A6,TextEndPtr

	MOVE.L	A6,ShowTextPtr
	ADD.L	#$13,TextEndPtr		;13
	MOVE.W	#$14,TextLength		;14
	MOVE.W	#$2355,A4
	CALL	GetTextLine
	CLR.L	TextEndPtr
	BRA.W	RestorePtrCol
	;RTS

;**********************************
;* art of filename in dirscreen   *
;**********************************
memcachedir:
	MOVE.L	mt_songdataptr,A0
	MOVE.W	DirPathNum,D0

	CMP.W	#5,D0			;load/save sample?
	BNE.B	.ret

	MOVE.L	mt_songdataptr,A0
	LEA	-10(A0),A0
	MOVE.W	InsNum,D7
	BNE.B	.get
	MOVE.W	LastInsNum,D7

.get:	MULU	#30,D7			;start of samplename
	ADD.L	D7,A0
.ret:	RTS


;**********************************
FilePattern:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	DirPathNum(PC),D0
	SUBQ.W	#1,D0
	MULU	#$0020,D0		;NOT 20+50!
	LEA	MatchPatterns,A6
	LEA	0(A6,D0.L),A6
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,fpattstor
	MOVE.L	A6,A0
	MOVEQ	#$29,D0
	MOVEQ	#$5B,D1
	MOVEQ	#7,D3
	CALL	Write_Text
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;**********************************
HitFilePattern:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	MOVE.W	DirPathNum,D0
	CMP.W	#6,D0
	BLS.S	di_hitfist
	RTS

di_hitfist:
	SUBQ.W	#1,D0
	MULU	#$0020,D0		;NOT +50
	LEA	MatchPatterns,A6
	LEA	0(A6,D0.L),A6
	MOVE.L	A6,fpattstor
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,TextEndPtr
	ADD.L	#$0000001F,TextEndPtr
	MOVE.W	#7,TextLength
	MOVEQ	#$29,D0
	MOVEQ	#$5B,D1
	CALL	EnterTextNow
	BSR.W	RestorePtrCol
	MOVE.L	fpattstor,A1
	BSR.W	di_filtpattern
	MOVE.B	#$FF,di_readdirnew
	RTS

;**********************************
di_calcnameouts:

	MOVEM.L D0/D1/A0-A3,-(SP)
	EXG	A0,A1
	TST.B	(A1)
	BEQ.S	di_clcnot
di_clcsrt:
	MOVE.B	(A1)+,D0
	CMP.B	#$23,D0
	BNE.S	di_clcsca
	CMP.B	#'?',(A1)
	BNE.S	di_clcsca
	ADDQ.L	#1,A1
	BRA.S	di_clcadd

di_clcsca:
	MOVE.B	(A0)+,D1
	BNE.S	di_clccont
	TST.B	D0
	BEQ.S	di_clcnot
	BRA.S	di_clcerr

di_clccont:
	CMP.B	D0,D1
	BEQ.S	di_clcsrt
	BRA.S	di_clcerr

di_clcadd:
	MOVE.L	A0,A3
	MOVE.L	A1,A2
	ADDQ.L	#1,A0
di_clcscod:
	MOVE.B	(A2)+,D0
	CMP.B	#$23,D0
	BNE.S	di_clcscad
	CMP.B	#'?',(A2)
	BNE.S	di_clcscad
	ADDQ.L	#1,A2
	MOVE.L	A2,A1
	MOVE.L	A3,A0
	BRA.S	di_clcadd

di_clcscad:
	MOVE.B	(A3)+,D1
	BNE.S	di_clcloas
	TST.B	D0
	BEQ.S	di_clcnot
	CMP.B	#$23,(A2)
	BNE.S	di_clcerr
	CMP.B	#$3F,1(A2)
	BNE.S	di_clcerr
	TST.B	2(A2)
	BNE.S	di_clcerr
	BRA.S	di_clcnot

di_clcloas:
	TST.B	D0
	BEQ.S	di_clcnorw
	CMP.B	D0,D1
	BEQ.S	di_clcscod
di_clcnorw:
	BRA.S	di_clcadd

di_clcnot:
	MOVEM.L (SP)+,D0/D1/A0-A3
	MOVEQ	#0,D0
	RTS

di_clcerr:
	MOVEM.L (SP)+,D0/D1/A0-A3
	MOVEQ	#-1,D0
	RTS

INFO.MSG:	dc.b	'#?.INFO',0
di_readdirnew:	dc.b	0,0
fpattstor:	dc.l	0

;***************************************
;* filename in A1, filter patternmatch *
;***************************************

di_filtpattern:
	MOVEM.L D0/A1,-(SP)
di_matchlp:
	MOVE.B	(A1)+,D0
	TST.B	D0
	BEQ.S	di_matchnd
	CMP.B	#$61,D0
	BEQ.S	di_matchrt
	BMI.S	di_matchlp
	CMP.B	#$7A,D0
	BEQ.S	di_matchrt
	BPL.S	di_matchlp
di_matchrt:
	SUB.B	#$20,D0
	MOVE.B	D0,-1(A1)
	BRA.S	di_matchlp

di_matchnd:
	MOVEM.L (SP)+,D0/A1
	RTS

;**********************************
ToggleShowIcons:
	BSR.W	WaitForButtonUp
	BCHG	#0,InfoOnOff
	MOVE.B	#$FF,di_readdirnew

TogIconsShow:
	LEA	HideShow.MSG(PC),A0
	BTST	#0,InfoOnOff
	BEQ.S	di_togi
	ADD.L	#9,A0
di_togi:
	MOVEQ	#$11,D0
	MOVEQ	#$2F,D1
	MOVEQ	#9,D3
	GOTO	Wr_Message

HideShow.MSG:	dc.b	'Hide InfoShow Info',0,0

;**********************************
HitPathInDir:
	BSR	StorePtrCol
	BSR	SetWaitPtrCol
	MOVE.L	DirPath,A6
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,TextEndPtr
	ADD.L	#32-1+50,TextEndPtr
	MOVE.W	#20,TextLength
	MOVE.W	#$1FE5,A4
	CALL	GetTextLine
	BSR	RestorePtrCol
	BSR	WaitForButtonUp

	;MOVE.B	#$FF,di_readdirnew	; 3.62, readdir always if entered
	;BRA.W	ReadDir

	TST.W	 mt_getlineflag		; obselete
	BEQ.S	 lbC003B7C
	RTS

lbC003B7C:				; now obselete
	BTST	#3,PackMode
	BNE.S	lbC003B88
	RTS

lbC003B88:
	MOVE.B	#$FF,di_readdirnew
	BRA	ReadDir


;**********************************
CopyPath:
	LEA	FileName,A1
	TST.B	(A0)
	BNE.S	CopyPath2
	RTS

CopyPath2:
	MOVE.B	(A0)+,(A1)+
	BNE.B	CopyPath2
	CMP.B	#$3A,-2(A1)		; if ending with : its ok
	BEQ.S	PathCharBack
	CMP.B	#$2F,-2(A1)		; if ending with / its ok
	BEQ.S	PathCharBack
	MOVE.B	#$2F,-1(A1)		; add / to end of path
	RTS

PathCharBack:
	SUBQ.L	#1,A1
	RTS

;**********************************
ShowDirPath:
	CMP.W	#3,CurrScreen
	BEQ.B	.doit
	RTS

.doit:	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DirPath,A0
	MOVEQ	#$14,D0
	MOVE.W	#$1FE5,D1
	CALL	ShowText3
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*******************************
FileNameOneUp:
	TST.W	DirFBitt
	BNE.S	.l1
	RTS

.l1:	MOVE.L	DirMousetable(PC),A5
	MOVE.W	$0018(A5),D0
	BNE.S	.doit
	RTS

.doit:	SUBQ.W	#1,D0
	MOVE.W	D0,$0018(A5)
	BSR.S	rd_upddirlist
	checkrmb
	BNE.W	RedrawFileNames
	SUBQ.W	#3,D0
	BPL.W	RedrawFileNames
	MOVEQ	#0,D0
	BRA.W	RedrawFileNames

;*******************************
FileNameOneDown:
	TST.W	DirFBitt
	BNE.S	.l1
	RTS

.l1:	MOVE.L	DirMousetable(PC),A5
	MOVE.W	$0018(A5),D0
	ADDQ.W	#1,D0
	checkrmb
	BNE.S	.doit
	ADDQ.W	#3,D0

.doit:	MOVE.W	$0016(A5),D1
	SUB.W	#$0013,D1
	BPL.S	.l2
	RTS

.l2:	MOVE.W	D0,$0018(A5)
	BSR.S	rd_upddirlist
	CMP.W	D1,D0
	BLS.W	RedrawFileNames
	MOVE.W	D1,D0
	BRA.W	RedrawFileNames

;**********************************
;------- propscrollbar in dirwin --
;**********************************
rd_upddirlist:
	MOVEM.L D0-D3,-(SP)
	MOVEQ	#0,D3
	MOVE.W	#$0053,DProp_Y
	CLR.W	DProp_X
	MOVE.L	DirMousetable(PC),A5
	MOVEQ	#$53,D0
	MOVE.W	#0,D1
	CMP.W	#$0013,$0016(A5)
	BMI.S	dp_ret
	BEQ.S	dp_ret
	MOVE.W	#$0629,D0
	MOVE.W	$0016(A5),D1
	EXT.L	D0
	DIVU	D1,D0
	MOVE.W	D0,DProp_Y
	MOVE.W	$0018(A5),D1
	MOVE.W	$0016(A5),D2
	MOVE.W	#$0053,D3
	SUB.W	D0,D3
	MULU	D1,D3
	SUB.W	#$0013,D2
	DIVU	D2,D3
	MOVE.W	D3,DProp_X
dp_ret:
	MOVE.W	DProp_X(PC),D3
	ADD.W	DProp_Y(PC),D3
	CMP.W	#$0053,D3
	BMI.S	dp_ok
	MOVEQ	#$53,D3
dp_ok:
	SUB.W	DProp_Y(PC),D3
	MOVE.W	D3,DProp_X
	BSR.W	UnPressedDirScrollbar
	MOVEM.L (SP)+,D0-D3
	RTS

DProp_X:	dc.w	0
DProp_Y:	dc.w	0

;*******************************
DirPropScroller:
	MOVE.L	DirMousetable(PC),A5
	CMP.W	#$0013,$0016(A5)
	BHI.S	dpropsc2
	RTS

dpropsc2:
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	MouseY,D1
	MOVE.W	DProp_X,D0
	ADD.W	#$0018,D0
	SUB.W	D0,D1
	BMI.W	dpropsc_sub
	CMP.W	DProp_Y,D1
	BPL.W	dpropsc_add
	MOVE.W	D1,D2
	MOVE.W	#$0053,D4
	SUB.W	DProp_Y,D4
	BSR.W	dpropsc10
	MOVE.W	MouseY,D1
dpropsc3:
	CALL	ResetKeyTimer
	checklmb
	BNE.S	dpropsc6
	MOVE.W	D1,D3
	MOVE.W	MouseY,D1
	CMP.W	D1,D3
	BEQ.S	dpropsc3
	SUB.W	D2,D1
	SUB.W	#$0018,D1
	BPL.S	dpropsc4
	MOVEQ	#0,D1
dpropsc4:
	CMP.W	D4,D1
	BMI.S	dpropsc5
	MOVE.W	D4,D1
dpropsc5:
	MOVE.W	D1,DProp_X
	BSR.W	PressedDirScrollbar
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DirMousetable(PC),A5
	MOVE.W	$0016(A5),D0
	SUB.W	#$0013,D0
	MULU	DProp_X,D0
	MOVE.W	#$0053,D1
	SUB.W	DProp_Y,D1
	DIVU	D1,D0
	MOVE.W	D0,$0018(A5)
	BSR.W	RedrawFileNames
	MOVEM.L (SP)+,D0-D7/A0-A6
	checklmb
	BEQ.B	dpropsc3
dpropsc6:
	BSR.B	UnPressedDirScrollbar
	CLR.W	DirCopFlag
	RTS

dpropsc_sub:
	SUB.W	#$0013,$0018(A5)
	BPL.S	dpropsc8
	CLR.W	$0018(A5)
dpropsc8:
	BSR.W	rd_upddirlist
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	CLR.W	DirCopFlag
	RTS

dpropsc_add:
	ADD.W	#$0013,$0018(A5)
	MOVE.W	$0016(A5),D0
	SUB.W	#$0013,D0
	CMP.W	$0018(A5),D0
	BPL.S	dpropsc9
	MOVE.W	D0,$0018(A5)
dpropsc9:
	BSR.W	rd_upddirlist
	MOVE.W	$0018(A5),D0
	BSR.W	RedrawFileNames
	CLR.W	DirCopFlag
	RTS

PressedDirScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	DProp_X,D1
	ADD.W	#24,D1
	MOVE.W	#317,D0
	MOVE.W	DProp_Y,D2
	LEA	EmptySprite,A0
	CALL	SetSpritePos
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

UnPressedDirScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	DProp_X,D1
	ADD.W	#24,D1
	MOVE.W	#317,D0
	MOVE.W	DProp_Y,D2
	CALL	UpdscrollSprite1
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

dpropsc10:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	DProp_X,D1
	ADD.W	#24,D1
	MOVE.W	#317,D0
	MOVE.W	DProp_Y,D2
	CALL	UpdscrollSprite2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;**********************************
;* clicked filename routine       *
;**********************************

HitDirloadEntry:
	TST.W	scrtablecl
	BPL.S	HitDirloadEntry2
	RTS

HitDirloadEntry2:
	MOVE.W	scrtablecl,D1
	MOVE.W	#1,UpdateFreeMem
	TST.W	DirFBitt
	BNE.S	HitDirloadEntry3
	RTS

HitDirloadEntry3:
	AND.L	#$0000FFFF,D1
	MOVE.L	DirMousetable(PC),A5
	MOVE.W	$0018(A5),D0
	ADD.W	D1,D0
	CMP.W	$0016(A5),D0
	BCS.S	HitDirloadEntry4
	RTS

HitDirloadEntry4:
	MULU	#$0024,D0
	ADD.L	(A5),D0
	MOVE.L	D0,A0
	MOVE.W	DirFBitt,D6
	CMP.W	#9,D6
	BEQ.S	HitDirloadEntry5
	CMP.W	#10,D6
	BEQ.S	HitDirloadEntry5
	TST.L	$0020(A0)
	BMI.S	CreateFilePath
HitDirloadEntry5:
	LEA	DirInputName,A1
	MOVEQ	#$1D,D0
HitDirloadEntry6:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,HitDirloadEntry6
	CMP.W	#1,D6
	BNE.S	HitDirloadExe
	GOTO	LoadSong

;**********************************

HitDirloadExe
	CMP.W	#2,D6
	BNE.S	HitDirloadMod
	GOTO	LoadExecutable

;**********************************

HitDirloadMod:
	CMP.W	#3,D6
	BNE.S	HitDirloadTrack
	GOTO	LoadModule

;**********************************

HitDirloadTrack:
	CMP.W	#4,D6
	BNE.S	HitDirloadSampl
	GOTO	LoadTrack

;**********************************

HitDirloadSampl:
	CMP.W	#5,D6
	BNE.S	HitDirloadPatt
	GOTO	LoadSample

;**********************************

HitDirloadPatt:
	CMP.W	#6,D6
	BNE.S	DelFileGadg
	GOTO	LoadPattern

;**********************************

DelFileGadg:
	CMP.W	#9,D6
	BNE.S	RenFileGadg
	GOTO	DelFile

;**********************************
RenFileGadg:
	CMP.W	#10,D6
	BNE.S	RenFileGadgRet
	GOTO	RenameFile

RenFileGadgRet:
	RTS

;**********************************

CreateFilePath:
	MOVE.L	A0,-(SP)
	MOVE.L	DirPath,A0
	BSR.W	CopyPath
	MOVE.L	(SP)+,A0
	MOVEQ	#32-3+50,D0		;+20 longer
.loo:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo
	LEA	FileName,A0
	MOVE.L	DirPath,A1
	MOVEQ	#32-1+50,D0		;+20longer
.lob:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.lob

di_readdir:
	BSR.W	ShowDirPath
	MOVE.W	DirFBitt,D6
	CMP.W	#1,D6
	BEQ.W	SelectSong
	CMP.W	#2,d6
	BEQ.W	rd_exe
	CMP.W	#3,D6
	BEQ.W	rd_modul
	cmp.w	#4,d6
	beq.w	SelectTrack
	CMP.W	#5,D6
	BEQ.W	SelectSample
	cmp.w	#6,d6
	beq.w	rd_patt
	RTS


;**********************************

di_parentdir:
	BSR.W	WaitForButtonUp
	MOVE.L	DirPath,A0
	MOVE.L	A0,A1
di_parlp:
	TST.B	(A1)+
	BNE.S	di_parlp
	SUBQ.L	#1,A1
	CMP.L	A0,A1
	BHI.S	dir_parst
	RTS

dir_parst:
	SUBQ.L	#1,A1
	CMP.B	#'/',(A1)
	BNE.S	dir_parsub
	CLR.B	(A1)
dir_parsub:
	CMP.B	#':',(A1)
	BEQ.S	di_readdir
	CMP.B	#'/',(A1)
	BEQ.S	dir_parend
	CLR.B	(A1)
	CMP.L	A0,A1
	BLS.S	di_readdir
	SUBQ.L	#1,A1
	BRA.S	dir_parsub

dir_parend:
	CLR.B	(A1)
	BRA.B	di_readdir

DirMousetable:	dc.l	DCache_Exe	;DCache_Mod
DCache_Exe:	dcb.b	70,0		;30 all in 3.15
DCache_Mod:	dcb.b	70,0
DCache_Song:	dcb.b	70,0
DCache_Track:	dcb.b	70,0
DCache_Sampl:	dcb.b	70,0
DCache_Patt:	dcb.b	70,0
		EVEN

;**********************************
;* disk free avail space routine  *
;**********************************
ShowFreeDiskGadg:
	BSR.W	WaitForButtonUp
	BSR.S	LockAndGetInfo
	BSR.W	DirDiskUnlock
	GOTO	ShowAllRight

LockAndGetInfo:
	BSR.W	StorePtrCol
	BSR.W	SetDiskPtrCol
	MOVE.L	DirMousetable(PC),A5
	MOVE.L	DOSBase,A6
	MOVE.L	DirPath,D1
	MOVEQ	#-2,D2
	CALLSYS	Lock
	MOVE.L	D0,FileLock
	BEQ.W	DirDiskError		;3.15
	LEA	Readingdir.MSG,A0
	CALL	ShowStatusText
	MOVE.L	FileLock,D1		;lock in d1
	MOVE.L	#InfoData,D2		;parameterblock in d2
	CALLSYS	Info
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	InfoData,A0
	MOVE.L	12(A0),D0		;id_NumBlocks
	MOVE.L	$0010(A0),D1		;id_NumBlocksUsed
	MOVE.L	$0014(A0),D2		;id_BytesPerBlock+2
	SUB.L	D1,D0
	MOVE.W	D0,D3
	SWAP	D0
	MOVE.W	D0,D4
	MULU	D2,D3
	MULU	D2,D4
	SWAP	D4
	OR.L	D4,D3
	MOVE.L	D3,$001A(A5)
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	DirPath,A4
	CMP.L	#'Ram ',(A4)
	BEQ.S	ItsRAMDisk
	CMP.L	#'ram:',(A4)
	BEQ.S	ItsRAMDisk
	CMP.L	#'RAM:',(A4)
	BNE.S	ItsRealDisk
ItsRAMDisk:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVEQ	#4,D1
	MOVE.L	4.w,a6
	CALLSYS	AvailMem
	MOVE.L	D0,$001A(A5)
	MOVEQ	#2,D1
	CALLSYS	AvailMem
	ADD.L	D0,$001A(A5)
	MOVEM.L (SP)+,D0-D7/A0-A6
ItsRealDisk:
	MOVE.L	DirMousetable(PC),A5
	;MOVE.W #$00F7,D0
	;MOVE.W #$0066,D1
	;MOVE.L $001A(A5),D2
	;MOVE.W #9,D3
	;CALL	PrintHexWord2

	move.l	$001A(A5),D0
	move.w	#$1FE5+28,TextOffset
	CALL	Print6DecDigits
	MOVEQ	#0,D0
	RTS

AllocDirMem:
	MOVE.L	DirMousetable(PC),A5
	ADD.W	#$0032,8(A5)
	MOVE.W	8(A5),D0
	MULU	#$0024,D0
	MOVE.L	4(A5),D6
	MOVE.L	D0,4(A5)
	MOVE.L	#$00010000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,D7
	BEQ.W	baehsj
	MOVE.L	DirMousetable(PC),A5
	MOVE.L	(A5),D1
	MOVE.L	D7,(A5)
	TST.L	D1
	BNE.S	AllocDirMem1
	RTS

AllocDirMem1:
	TST.L	D6
	BNE.S	AllocDirMem2
	RTS

AllocDirMem2:
	MOVE.L	D1,A0
	MOVE.L	D7,A1
	MOVE.L	D6,D0
admloop:
	MOVE.B	(A0)+,(A1)+
	SUBQ.L	#1,D6
	BNE.S	admloop
	MOVE.L	D1,A1
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	RTS

;*********************************
;* free's directory structures   *
;*********************************

FreeDirMemory:
	LEA	DCache_Exe(PC),A5
	BSR.S	FreeDirMem1
	LEA	DCache_Mod(PC),A5
	BSR.S	FreeDirMem1
	LEA	DCache_Song(PC),A5
	BSR.S	FreeDirMem1
	LEA	DCache_Track(PC),A5
	BSR.S	FreeDirMem1
	LEA	DCache_Sampl(PC),A5
	BSR.S	FreeDirMem1
	LEA	DCache_Patt(PC),A5
	BSR.S	FreeDirMem1
	RTS

;--- from DirDisk ---
FreeDirMem:
	MOVE.L	DirMousetable(PC),A5

FreeDirMem1:
	MOVE.L	(A5),D1			;sam in a5
	BNE.S	.l1
	RTS
.l1:	MOVE.L	D1,A1			;samadr in d1
	MOVE.L	4(A5),D0
	CLR.L	(A5)
	CLR.W	4(A5)
	CLR.W	8(A5)
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	RTS

baehsj:
	CALL	OutOfMemErr
	MOVEQ	#-1,D0
	RTS
;**********************************
;* get directory from disk        *
;**********************************
DirDisk:
	CLR.B	di_readdirnew
	BSR	FreeDirMem
	BSR	AllocDirMem
	BSR	LockAndGetInfo
	BEQ.S	.doit
	RTS

.doit:
	MOVE.L	DirMousetable(PC),A5
	CLR.W	$18(A5)
	MOVE.L	FileLock,D1
	MOVE.L	#FileInfoBlock,D2
	CALLSYS	Examine
	TST.L	D0
	BEQ.S	DirDiskError

.l1:	MOVE.L	FileLock,D1
	MOVE.L	#FileInfoBlock,D2
	MOVE.L	DOSBase,A6
	CALLSYS	ExNext
	TST.L	D0
	BEQ.S	DirDiskUnlock
	checkrmb
	BEQ.S	AbortDir
	BSR.W	NewDirEntry
	BRA.S	.l1

AbortDir:
	CLR.L	10(A5)
	LEA	Diraborted.MSG(PC),A0
	CALL	ShowStatusText
	BSR.S	DirDiskUnlock
	CALL	WaitALittle
	CALL	ShowAllRight
	MOVEQ	#0,D0
	RTS

DirDiskUnlock:
	MOVE.L	FileLock,D1
	CALLSYS	UnLock
	BSR.W	RestorePtrCol
	MOVEQ	#0,D0
	RTS

Diraborted.MSG: 	dc.b	'DIR ARBORTED!',0,0

	EVEN
	
DirDiskError:
	TST.L	FileLock
	BEQ.S	.l1
	MOVE.L	FileLock,D1
	CALLSYS	UnLock

.l1:	BSR.W	RestorePtrCol
	LEA	Cantfinddir.MSG,A0
	CALL	ShowStatusText
	BSR.W	SetErrorPtrCol
	MOVEQ	#-1,D0
	RTS

ClearDirTotal:
	CLR.W	$16(A5)
	RTS

Cantfinddir.MSG:	dc.b	'CAN''T FIND DIR!',0

	EVEN
;*******************************
NewDirEntry:
	LEA	FIB_FileName,A0
	BTST	#2,PackMode
	BNE.S	.l1
	TST.L	FIB_EntryType
	BMI.S	.l1
	RTS

.l1:	TST.L	FIB_EntryType
	BPL.S	.l2
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVEQ	#0,D0
	MOVE.L	#FIB_FileName,A1
	BSR.W	di_filtpattern
	BTST	#0,InfoOnOff
	BNE.S	.l4
	LEA	INFO.MSG(PC),A0
	BSR.W	di_calcnameouts
	TST.L	D0
	BEQ.S	.l5

.l4:	MOVE.L	fpattstor(PC),A0
	BSR.W	di_calcnameouts
	TST.L	D0
	BEQ.S	.l6

.l5:	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

.l6:	MOVEM.L (SP)+,D0-D7/A0-A6

.l2:
	MOVE.W	$0016(A5),D0
	CMP.W	8(A5),D0
	BCS.S	.l3
	MOVE.L	A0,-(SP)
	BSR.W	AllocDirMem
	MOVE.L	(SP)+,A0
.l3:
	MOVE.W	$0016(A5),D6
	BEQ.B	LDirs
	SUBQ.W	#1,D6
	MOVE.L	(A5),A1
ndeloopname:
	MOVEQ	#0,D2
	MOVE.L	FIB_EntryType,D0
	MOVE.L	$0020(A1),D1
	TST.L	D0
	BPL.S	ndesfil 		;if directory
	TST.L	D1
	BMI.S	ndenext 		;was file, skip if directory
	BRA.S	ndelopc

ndesfil:
	TST.L	D1			;if file
	BPL.S	ndeinse
ndelopc:
	MOVE.B	0(A0,D2.W),D0		;get a character
	BEQ.S	ndeinse
	CMP.B	#$60,D0 		;lowercase?
	BCS.S	ndeskp1
	SUB.B	#$20,D0 		;switch to upper
ndeskp1:
	MOVE.B	0(A1,D2.W),D1
	BEQ.S	ndenext
	CMP.B	#$60,D1
	BCS.S	ndeskp2
	SUB.B	#$20,D1
ndeskp2:
	CMP.B	D0,D1
	BHI.S	ndeinse
	BNE.S	ndenext
	ADDQ.W	#1,D2
	BRA.S	ndelopc

ndenext:
	LEA	$0024(A1),A1		;next entry
	DBRA	D6,ndeloopname		;loop entries
	MOVE.L	(A5),A1
	MOVE.W	$0016(A5),D0
	MULU	#$0024,D0
	ADD.W	D0,A1
	BRA.S	LDirs2

ndeinse:
	MOVE.L	(A5),A2
	MOVE.W	$0016(A5),D0
	MULU	#$0024,D0
	ADD.W	D0,A2
	MOVE.L	A2,A3
	LEA	$0024(A3),A3
nde3loop:
	MOVE.W	-(A2),-(A3)
	CMP.L	A2,A1
	BNE.S	nde3loop
	BRA.S	LDirs2

LDirs:	MOVE.L	(A5),A1			; put new filename into list
LDirs2: LEA	FIB_FileName,A0
	MOVE.L	A1,A3
	MOVEQ	#$23,D0 		; clear old filename
nde4loop:
	CLR.B	(A3)+
	DBRA	D0,nde4loop
	MOVE.W	FIB_DateStamp+ds_Days+2,30(A1)
	MOVEQ	#-1,D0
	TST.L	FIB_EntryType
	BPL.S	LDirs3
	MOVE.L	FIB_FileSize,D0
LDirs3:
	MOVE.L	D0,$0020(A1)
	MOVEQ	#$1D,D0 		; copy new filename
LDirs4:
	MOVE.B	(A0)+,D1
	MOVE.B	D1,(A1)+
	TST.B	D1
	BEQ.S	LDirs5
	DBRA	D0,LDirs4
LDirs5:
	ADDQ.W	#1,$0016(A5)		; Files+1
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#0,D0
	BSR.S	LDirs7			;RedrawFileNames
	BSR.W	rd_upddirlist
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

RedrawFileNames:

	MOVE.W	D0,-(SP)
	BSR.W	ShowDirPath
	MOVE.W	(SP)+,D0
LDirs7:
	MOVE.W	D0,$0018(A5)
	TST.W	$0016(A5)
	BNE.S	ListDirEntries2
	RTS

ListDirEntries2:
	MOVE.w	#$169,A6
	MOVE.W	A6,TextOffset
	MOVE.L	(A5),D6
	MULU	#$0024,D0
	ADD.L	D0,D6
	AND.L	#$FFFFFFFE,D6

	MOVE.W	$0016(A5),D0
	sub.w	$0018(A5),d0		; filename pos

	CMP.W	#$0013,D0
	BCC.S	ShowFileNames
	SUBQ.W	#1,D0
	MOVE.W	D0,D7
	BRA.S	sfnloop

;******************************
ShowFileNames:
	MOVEQ	#$12,D7
sfnloop:
	MOVE.W	A6,TextOffset		; A6 =>FIB
	MOVE.L	D6,A0
	MOVEQ	#0,D0
	MOVE.W	30(A0),D0

	cmp.b	#1,showdateflag
	beq.s	skpdtshow

	BSR.W	CalcDate
	MOVE.W	TheDay(PC),WordNumber
	CALL	Print2DecDigits
	MOVE.W	TheMonth(PC),WordNumber
	CALL	Print2DecDigits
	MOVE.W	TheYear(PC),WordNumber
	CALL	Print2DecDigits
	ADDQ.W	#1,TextOffset
skpdtshow:
	MOVE.L	D6,ShowTextPtr
	MOVE.W	#24,TextLength

	cmp.b	#1,modshortmode		;no mod.* or ptm.* or *.mod ...?
	bne.w	.sfns


	move.l	d6,a0
	cmp.l	#'mod.',(a0)
	beq.s	.l1
	cmp.l	#'MOD.',(A0)
	beq.s	.l1
	cmp.l	#'ptm.',(A0)
	beq.s	.l1
	cmp.l	#'PTM.',(A0)
	beq.s	.l1
	cmp.l	#'pts.',(A0)
	beq.s	.l1
	cmp.l	#'PTS.',(A0)
	bne.s	.l2

.l1:	addq.l	#4,ShowTextPtr

;--- check the suffix

.l2:	moveq	#24,d3			; length
.loo:	cmp.l	#'.mod',(A0,d3)
	beq.s	.strip
	cmp.l	#'.MOD',(A0,d3)
	beq.s	.strip
	cmp.l	#'.ptm',(A0,d3)
	beq.s	.strip
	cmp.l	#'.PTM',(A0,d3)
	beq.s	.strip
	cmp.l	#'.pts',(A0,d3)
	beq.s	.strip
	cmp.l	#'.PTS',(A0,d3)
	beq.s	.strip
	dbra	d3,.loo

	bra.s	.sfns

.strip:	move.w	d3,TextLength
	move.w	d3,fnaml

.sfns:	btst	#1,CfgFlag
	beq.b	.l4
	bset	#1,CfgStore		; ever great chars
	bclr	#1,CfgFlag

.l4:	MOVEM.L D0-D7/A0-A6,-(SP)	; fix
	CALL	SpaceShowText		; filename
	MOVEM.L (SP)+,D0-D7/A0-A6

	cmp.w	#0,fnaml
	beq.s	.l5

	MOVE	#14,TextLength
	MOVE.L	#EmptyTextField,ShowTextPtr
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	move.w	#0,fnaml

.l5:	btst	#1,CfgStore
	beq.s	.l8	 		;store charset
	bset	#1,CfgFlag

.l8:	LEA	$0020(A6),A6
	MOVE.W	A6,TextOffset
	MOVE.L	D6,A0
	MOVE.L	$0020(A0),D1
	BMI.S	sfndir
	BTST	#7,Packetfield		;hex or dec?
	BNE.S	sfndec
	SWAP	D1
	AND.W	#15,D1
	CALL	mt_clarconv
	MOVE.L	D6,A0
	MOVE.W	$0022(A0),WordNumber
	CALL	PrintHexWord
sfnend:
	ADD.L	#$24,D6
	LEA	$01C0(A6),A6
	DBRA	D7,sfnloop
	RTS

sfndec:
	MOVE.L	D1,D0
	SUBQ.W	#1,TextOffset
	CALL	Print6DecDigits 	;print filelength in dirWin
	BRA.S	sfnend

sfndir:
	MOVE.L	#DIR.MSG,ShowTextPtr
	SUBQ.W	#1,TextOffset
	MOVE.W	#6,TextLength
	CALL	ShowText
	BRA.S	sfnend

CalcDate:
	DIVU	#$05B5,D0
	LSL.W	#2,D0
	MOVE.W	D0,TheYear
	CLR.W	D0
	SWAP	D0
	CMP.W	#$0315,D0
	BEQ.S	cadleap
	BCS.S	cadskp2
	SUBQ.W	#1,D0
cadskp2:
	DIVU	#$016D,D0
	MOVE.L	D0,D1
	SWAP	D1
	CMP.W	#4,D0
	BCS.S	cadskip
	SUBQ.W	#1,D0
cadskip:
	ADD.W	D0,TheYear
	LEA	MonthTable(PC),A1
	MOVEQ	#$18,D0
cadloop:
	SUBQ.W	#2,D0
	MOVE.W	0(A1,D0.W),D2
	CMP.W	D2,D1
	BCC.S	cadskp3
	TST.W	D0
	BNE.S	cadloop
cadskp3:
	LSR.W	#1,D0
	ADDQ.W	#1,D0
	MOVE.W	D0,TheMonth
	SUB.W	D2,D1
	ADDQ.W	#1,D1
	MOVE.W	D1,TheDay
cadend:
	MOVEQ	#0,D0
	MOVE.W	TheYear(PC),D0
	ADD.W	#$004E,D0
	DIVU	#$0064,D0
	SWAP	D0
	MOVE.W	D0,TheYear
	RTS

cadleap:
	ADDQ.W	#2,TheYear
	MOVE.W	#2,TheMonth
	MOVE.W	#$001D,TheDay
	BRA.B	cadend


TheYear:	dc.w	0
TheMonth:	dc.w	0
TheDay: 	dc.w	0
MonthTable:	dc.w 	0,31,59,90,120,151,181,212,243,273,304,334
DIR.MSG:	dc.b	' (DIR)',0,0
fnaml:		dc.w	0

;******************************
;* continue play button       *
;******************************

playcontinue:
	TST.L	RunMode
	BEQ.S	.l1
	RTS

.l1:	CLR.W	mt_counter
	TST.W	PattScrollBuf
	BNE.W	pattplay			; pattern
	BRA.S	play				; song

;******************************
;* Play start routine, RALT   *
;******************************

PlaySong:
	LEA	NormalPlayText(pc),A0
	CALL	ShowStatusText

	;chn8test
	;bne.s	.chn4
	;MOVEM.L D0-D7/A0-A6,-(SP)
	;CALL	AHI_Main		; opens/init ahi.device
	;MOVEM.L (SP)+,D0-D7/A0-A6

.chn4:	MOVEQ	#0,D0

playsong1:
	CLR.W	PattScrollBuf
	CALL	StopIt
	BSR.W	ClearAllKeys
	checkrmb
	BNE.S	rmb

play:	MOVE.W	PlayFromPos,D0
rmb:	MOVE.W	D0,ScrPattPos
	LSL.W	#4,D0

	chn8test
	bne.s	.chn4
	lsl.w	#1,d0

.chn4:	AND.L	#$0000FFFF,D0
	MOVE.L	D0,mt_patternpos
	BSR.W	WaitForButtonUp
	CLR.B	RawKeyCode
	CLR.B	mt_savekey
	BSR	SetPlayPtrCol
	CLR.W	PatternTicks
	CLR.L	TimerTicks
	MOVE.L	#'patp',RunMode
	CLR.W	DidQuantize
	MOVE.L	#-1,LongFFFF
	CALL	SetScrPatternPos

SetPlayPosition:
	MOVE.L	playpos,D0
	MOVE.L	mt_songdataptr,A0

	CMP.B	sd_numofpatt(A0),D0
	BCC.S	SongPosToZero
	MOVE.L	playpos,mt_songpos
	RTS

SongPosToZero:
	CLR.L	mt_songpos
	CLR.L	playpos
	RTS

;*********************************
;* play pattern routine, ramiga  *
;*********************************

playpattern:
	LEA	NormalPattText(pc),A0
	CALL	ShowStatusText
	MOVEQ	#0,D0

PattFrom:
	MOVE.W	#$FFFF,PattScrollBuf
	CALL	StopIt
	BSR	ClearAllKeys
	checkrmb
	BNE.S	pafr1

pattplay:
	MOVE.W	PlayFromPos,D0
pafr1:	MOVE.W	D0,ScrPattPos
	LSL.W	#4,D0

	chn8test			; 4.0
	bne.s	.chn4
	lsl.w	#1,d0

.chn4:	AND.L	#$0000FFF,D0
	MOVE.L	D0,mt_patternpos
	BSR.W	WaitForButtonUp
	CLR.B	RawKeyCode
	CLR.B	mt_savekey
	MOVE.L	#'patt',RunMode
	BSR.W	SetPlayPtrCol

ResetPosition:
	MOVE.L	PatternNumber,mt_songpos
	clr.b	RawKeyCode
	RTS

;*********************************
;*  --- Record Pattern/Song ---  *
;*********************************

RecordSong:
	LEA	NormalRecText(pc),A0
	CALL	ShowStatusText

	BTST	#0,CutToBufFlag			;record hold flag?
	BEQ.W	record
	CLR.B	RawKeyCode
	BSR.W	WaitForButtonUp

RecordFrom:
	CALL	ResetKeyTimer
	checklmb
	BEQ.W	record

	checkrmb
	BEQ.W	record

	BSR.W	DoKeyBuffer
	BSR	CheckLAmigaKeys		;reinserted 4.01
	TST.B	RawKeyCode
	BEQ.S	RecordFrom
	MOVE.B	RawKeyCode,D0
	MOVE.B	D0,mt_savekey
	MOVEQ	#0,D0
	TST.W	SamScrEnable
	BEQ.S	.doit
	RTS

.doit:	CALL	StopIt
	checkrmb
	BNE.S	.l1
	MOVE.W	PlayFromPos,D0

.l1:	MOVE.W	D0,ScrPattPos
	LSL.W	#4,D0

	chn8test			; 4.0
	bne.s	.chn4
	lsl.w	#1,d0
.chn4:
	AND.L	#$00000FFF,D0
	MOVE.L	D0,mt_patternpos
	BSR.W	WaitForButtonUp
	BSR.W	SetEditPtrCol
	MOVE.B	mt_savekey,D1		;reinserted 4.01
	Move.B	D1,RawKeyCode
	;CLR.B	RawKeyCode
	;CLR.B	mt_savekey
	BSR.W	SaveUndo
	MOVE.L	#'edit',EditMode
	MOVE.L	#'patt',RunMode
	CALL	CheckKeyboard
	TST.B	RecordMode
	BEQ.W	ResetPosition
	MOVE.L	#'patp',RunMode
	BRA.W	SetPlayPosition
;---
record:	MOVEQ	#0,D0

mt_recordon:
	TST.W	SamScrEnable
	BEQ.S	.doit
	RTS

.doit:	CALL	StopIt

	checkrmb
	BNE.S	.dook
	MOVE.W	PlayFromPos,D0

.dook:	MOVE.W	D0,ScrPattPos
	LSL.W	#4,D0

	chn8test			; 4.0
	bne.s	.chn4
	lsl.w	#1,d0

.chn4:	AND.L	#$00000FFF,D0
	MOVE.L	D0,mt_patternpos
	BSR.W	WaitForButtonUp
	BSR.W	SetEditPtrCol
	CLR.B	RawKeyCode
	CLR.B	mt_savekey
	BSR.W	SaveUndo
	MOVE.L	#'edit',EditMode
	MOVE.L	#'patt',RunMode
	TST.B	RecordMode
	BEQ.W	ResetPosition
	MOVE.L	#'patp',RunMode
	BRA.W	SetPlayPosition

;*********************************
;*  --- Show Main Screen ---     *
;*********************************

DisplayMainScreen:
	;CALL	ClearAllKeys		;3.58
	clr.b	RawKeyCode
	CLR.W	BlockMarkFlag
	MOVE.W	#1,CurrScreen
	SF	NoSampleInfo
	TST.W	LoadingInProgress
	BNE.B	.blit

	BSR.W	SetNormalPtrCol
	TST.W	RunMode
	BEQ.S	.stip
	BSR.W	SetPlayPtrCol

.stip:	TST.L	EditMode
	BEQ.S	.rik
	BSR.W	SetEditPtrCol		;blue mouse, edit on
.rik:	BSR.W	StorePtrCol

.blit:	BSR.W	BlitManyThings
	BSR.W	valmaga 		;scope
	CALL	DctMainScr1_7
	ST	ScopeEnable

showskips:
	move.w	#$2835,TextOffset	;3.61
	move.w	EditMoveAdd,D0
	CALL	PrintHexDigit
	RTS
;*******************************

xClearRightArea:
	BSR.W	WhtSetCopl
	MOVE.L	TextBplPtr,A1
	LEA	$0118(A1),A1
	MOVE.W	#$0473,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D3
mscrlop:
	MOVE.L	D1,(A1)+
	ADDQ.L	#4,D3
	CMP.L	#$00000028,D3
	BNE.S	mscrskip
	MOVEQ	#0,D3
	LEA	$0028(A1),A1
mscrskip:
	DBRA	D0,mscrlop
	CLR.W	DProp_X
	MOVE.W	#$0053,DProp_Y
	BRA.W	rd_upddirlist

Clear120Lines: 					; 4.0
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#1,D0
	MOVEQ	#1,D1
	MOVE.W	#639,D2
	MOVEQ	#119,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox			; clears area 1-639 x
	MOVEM.L (SP)+,D0-D7/A0-A6		; 1-119 y
	RTS

;************************************

WaitForButtonUp:
	btst	#6,$dff002	;old blitters saids to have a bug

	CALL	ResetKeyTimer
	checklmb
	BEQ.S	WaitForButtonUp
	checkrmb
	BEQ.S	WaitForButtonUp
	BSR.B	WaitAMoment
	checklmb
	BEQ.S	WaitForButtonUp
	checkrmb
	BEQ.S	WaitForButtonUp
	RTS

;************************************

WaitAMoment:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DOSBase,A6
	MOVEQ	#2,D1
	CALLSYS	Delay
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
;* requester yes/no structure       *
;************************************

AreYouSure:
	cmp.w	#9,CurrScreen
	bne.b	aysu
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	exitposed		;exit posed, sprite condlict with req
	MOVEM.L (SP)+,D0-D7/A0-A6
aysu:
	MOVE.L	A0,-(SP)
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	CALL	Wait_4000
	BSR.W	ClearRightAreaReq
	MOVE.L	(SP)+,A0
	LEA	SureBoxData,A1
	LEA	SureYesNoData,A2
	MOVE.L	#$00000460,D0
	BSR.W	SwapBoxMem
	CLR.B	RawKeyCode
surebuttoncheck:
	CALL	ResetKeyTimer
	BSR.W	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	CMP.B	#$15,D0
	BEQ.B	SureAnswerYes
	CMP.B	#$31,D0
	BEQ.S	SureAnswerYes		;included, german Y
	CMP.B	#$44,D0
	BEQ.S	SureAnswerYes
	CMP.B	#$36,D0
	BEQ.S	SureAnswerNo
	CMP.B	#$45,D0
	BEQ.S	SureAnswerNo
	checklmb
	BNE.S	surebuttoncheck

	MOVEM.W (MouseX),D0/D1
	LEA	MousXKoorTabl,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.S	surebuttoncheck
	CMP.W	#1,D2
	BEQ.S	SureAnswerYes
	CMP.W	#3,D2
	BEQ.S	SureAnswerNo
	CMP.W	#10,D2
	BNE.S	surebuttoncheck
	BSR.W	Screenswitch
	BRA.S	surebuttoncheck

SureAnswerNo:
	BSR.W	OpenRequester
	CALL	ShowAllRight
	BSR.W	ErrorRestoreCol
	CALL	Wait_4000		;org bsr 3.62
	BSR.W	WaitForButtonUp
	CLR.W	DirCopFlag
	CLR.B	RawKeyCode
	MOVEQ	#-1,D0
	RTS

SureAnswerYes:
	BSR.W	OpenRequester
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	CALL	Wait_4000		;org bsr 3.62
	BSR.W	WaitForButtonUp
	CLR.W	DirCopFlag
	CLR.B	RawKeyCode
	MOVEQ	#0,D0
	RTS

;************************************
;* format requester structure       *
;************************************

mt_formatreq:
	MOVE.L	A0,-(SP)
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	CALL	Wait_4000		;org bsr 3.62
	BSR.W	ClearRightAreaReq
	MOVE.L	(SP)+,A0
	LEA	SureBoxData,A1
	LEA	lbL01972C,A2
	MOVE.L	#$00000460,D0
	BSR.W	SwapBoxMem
mtformlop:
	CALL	ResetKeyTimer
	BSR.W	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	CMP.B	#$13,D0
	BEQ.S	mtformop2
	CMP.B	#$44,D0
	BEQ.S	mtformop2
	CMP.B	#$33,D0
	BEQ.S	mtformop
	CMP.B	#$45,D0
	BEQ.S	mtformop
	checklmb
	BNE.S	mtformlop
	MOVEM.W (MouseX),D0/D1
	LEA	MousXKoorTabl,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.S	mtformlop
	CMP.W	#1,D2
	BEQ.S	mtformop2
	CMP.W	#3,D2
	BEQ.S	mtformop
	BRA.S	mtformlop

mtformop:
	BSR.W	OpenRequester
	CALL	ShowAllRight
	BSR.W	ErrorRestoreCol
	CALL	Wait_4000
	BSR.W	WaitForButtonUp
	CLR.W	DirCopFlag
	MOVEQ	#-1,D0
	RTS

mtformop2:
	BSR.W	OpenRequester
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	CALL	Wait_4000
	BSR.W	WaitForButtonUp
	CLR.W	DirCopFlag
	MOVEQ	#0,D0
	RTS

;************************************
;* no memory requester structure    *
;************************************

NoMemoryRequester:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	A0,-(SP)
	BSR.W	WhtSetCopl
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	ClearRightAreaReq
	MOVE.L	(SP)+,A0
	LEA	NoMemGFXData,A1
	LEA	lbL0197A4,A2
	MOVE.L	#$00000460,D0
	BSR.W	SwapBoxMem
NoMemReqlop:
	BSR.W	ResetKeyTimer
	BSR.W	DoKeyBuffer
	cmp.w	#$44,RawKeyCode
	beq.s	NoMemReqRet
	cmp.w	#$45,RawKeyCode
	beq.s	NoMemReqRet
	checklmb
	BNE.S	NoMemReqlop
	MOVEM.W (MouseX),D0/D1
	LEA	CopyrightsGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.B	NoMemReqlop
	CMP.W	#2,D2
	BEQ.S	NoMemReqRet
	BRA.B	NoMemReqlop

NoMemReqRet:
	BSR.W	OpenRequester
	CLR.W	DirCopFlag
	MOVEM.L (SP)+,D1-D7/A0-A6
	RTS

;************************************

mt_makereqindir:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	A2,-(SP)
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.L	A1,lbL004FC8
	MOVE.L	D0,lbL004FCC
	BSR.W	ClearRightAreaReq
	MOVE.L	(SP)+,A1
	LEA	lbL01985C,A2
	MOVE.L	#$00000460,D0
	BSR.W	SwapBoxMem
	BSR.W	lbC004FA8
lbC004F00:
	BSR.W	ResetKeyTimer
	BSR.W	DoKeyBuffer
	BSR	CheckLAmigaKeys
	BTST	#6,$BFE001
	BNE.S	lbC004F00
	MOVEM.W (MouseX),D0/D1
	LEA	lbL0194C0,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.S	lbC004F00
	CMP.W	#1,D2
	BEQ.S	lbC004F4C
	CMP.W	#3,D2
	BEQ.S	lbC004F50
	CMP.W	#4,D2
	BEQ.S	lbC004F64
	CMP.W	#10,D2
	BNE.S	lbC004F00
	BSR.W	Screenswitch
	BRA.S	lbC004F00

lbC004F4C:
	MOVEQ	#0,D0
	BRA.S	lbC004F52

lbC004F50:
	MOVEQ	#-1,D0
lbC004F52:
	BSR.W	OpenRequester
	CLR.W	DirCopFlag
	MOVEM.L (SP)+,D1-D7/A0-A6
	TST.L	D0
	RTS

lbC004F64:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	MOVE.L	lbL004FC8(PC),A6
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,TextEndPtr
	MOVE.L	lbL004FCC(PC),D0
	ADD.L	D0,TextEndPtr
	CMP.W	#$0015,D0
	BMI.S	lbC004F8E
	MOVEQ	#$15,D0
lbC004F8E:
	MOVE.W	D0,TextLength
	MOVE.W	#$010D,D0
	MOVEQ	#$4F,D1
	CALL	EnterTextNow
	BSR.W	RestorePtrCol
	BSR.S	lbC004FA8
	BRA.W	lbC004F00

lbC004FA8:
	MOVE.L	lbL004FC8(PC),A0
	MOVE.L	lbL004FCC(PC),D3
	CMP.L	#$00000015,D3
	BMI.S	lbC004FBA
	MOVEQ	#$15,D3
lbC004FBA:
	MOVE.W	#$010D,D0
	MOVEQ	#$4F,D1
	GOTO	Write_Text

lbL004FC8:	dc.l	0
lbL004FCC:	dc.l	0

SwapBoxMem:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	A0,-(SP)
	MOVE.L	A1,-(SP)
	MOVE.L	D0,-(SP)
	CMP.L	#0,A2
	BEQ.S	swabom1
	MOVE.L	A2,A0
	MOVE.W	#$C0,D0
	MOVEQ	#$32,D1
	CALL	BlitAllBasic

	MOVE.W	#$C0,D0
	MOVEQ	#$32,D1
	MOVE.W	#$1C0,D2
	MOVEQ	#$72,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox
swabom1:
	LEA	PTBitMap+RequesterPos1,A0
	MOVE.L	(SP)+,D3
	MOVE.L	(SP)+,D0
	BEQ.S	swabom3
	MOVE.L	D0,A1
	ADD.L	D3,A0
	MOVEQ	#1,D1
swabom2:
	MOVEQ	#$1F,D0
.loo:
	MOVE.B	(A1)+,(A0)
	MOVE.B	(A1)+,1(A0)
	MOVE.B	(A1)+,2(A0)
	MOVE.B	(A1)+,3(A0)
	MOVE.B	(A1)+,4(A0)
	MOVE.B	(A1)+,5(A0)
	LEA	$50(A0),A0
	DBRA	D0,.loo

	LEA	$4600(A0),A0
	DBRA	D1,swabom2
	MOVE.L	TextBplPtr,A0		;swap text
	ADD.L	#$FB9,A0
	ADD.L	D3,A0
	MOVEQ	#$1F,D0
.lob:
	MOVE.B	(A1)+,(A0)
	MOVE.B	(A1)+,1(A0)
	MOVE.B	(A1)+,2(A0)
	MOVE.B	(A1)+,3(A0)
	MOVE.B	(A1)+,4(A0)
	MOVE.B	(A1)+,5(A0)
	LEA	$50(A0),A0
	DBRA	D0,.lob
swabom3:
	MOVE.L	(SP)+,D0
	BEQ.S	swabomrt
	MOVE.L	D0,A0
	MOVE.W	#$00F8,D0
	MOVEQ	#$37,D1
	CALL	PrintTextInReqs
swabomrt:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
ClearRightAreaReq:

	MOVEM.L D0-D7/A0-A6,-(SP)
	lea	DecrunchBig,A0
	LEA	PTBitMap+RequesterPos,A1
	MOVEQ	#1,D2
clrbom1:
	MOVEQ	#$3F,D1
clrbom2:
	MOVEQ	#$1F,D0
.loo:	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loo

	LEA	$0030(A1),A1
	DBRA	D1,clrbom2
	LEA	$3C00(A1),A1
	DBRA	D2,clrbom1
	MOVE.L	TextBplPtr,A1
	ADD.L	#$00000FB8,A1
	MOVEQ	#$3F,D1
clrbom3:
	MOVEQ	#$1F,D0
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loo

	LEA	$0030(A1),A1
	DBRA	D1,clrbom3
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
OpenRequester:
	MOVEM.L D0-D7/A0-A6,-(SP)
	lea	DecrunchBig,A0
	LEA	PTBitMap+RequesterPos,A1
	MOVEQ	#1,D2
.l0:	MOVEQ	#$3F,D1
.l3:	MOVEQ	#$1F,D0
.l1:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.l1

	LEA	$0030(A1),A1
	DBRA	D1,.l3

	LEA	$3C00(A1),A1
	DBRA	D2,.l0
	MOVE.L	TextBplPtr,A1
	ADD.L	#$00000FB8,A1
	MOVEQ	#$3F,D1

.l2:	MOVEQ	#$1F,D0
.loo:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo

	LEA	$0030(A1),A1
	DBRA	D1,.l2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************

GetCopyrGFX:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	DecrCopyPtr,A0
	LEA	PTBitMap,A1
	MOVEQ	#1,D1
.l1:	MOVE.W	#$25CF,D0
.loo:	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loo

	LEA	$2A30(A1),A1
	DBRA	D1,.l1
	MOVE.L	TextBplPtr,A1
	MOVE.W	#$25CF,D0
.lob:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.lob
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************

CopyrightEnd:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	DecrCopyPtr,A0
	LEA	PTBitMap,A1
	MOVEQ	#1,D1
.l1:	MOVE.W	#$25CF,D0
.loo:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo

	LEA	$2A30(A1),A1
	DBRA	D1,.l1

	MOVE.L	TextBplPtr,A1
	MOVE.W	#$25CF,D0
.lob:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.lob
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
;*----- set pointercolors ----------*
;************************************

SetDeletePtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0077,2(A6)
	MOVE.W	#$0044,6(A6)
	MOVE.W	#$00AA,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetNormalPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0E44,2(A6)
	MOVE.W	#0,6(A6)
	MOVE.W	#$0EEC,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetDiskPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0070,2(A6)
	MOVE.W	#$0040,6(A6)
	MOVE.W	#$00A0,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetPlayPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0770,2(A6)
	MOVE.W	#$0440,6(A6)
	MOVE.W	#$0AA0,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetEditPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0049,2(A6)
	MOVE.W	#6,6(A6)
	MOVE.W	#$005B,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetWaitPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0727,2(A6)
	MOVE.W	#$0404,6(A6)
	MOVE.W	#$0A5A,10(A6)
	MOVE.L	(SP)+,A6
	RTS

SetErrorPtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	#$0900,2(A6)
	MOVE.W	#$0700,6(A6)
	MOVE.W	#$0C00,10(A6)
	MOVE.L	(SP)+,A6
	MOVE.W	#1,UpdateFreeMem
	CALL	WaitALittle
	CALL	ShowAllRight			;print status 'ok'
	BSR.W	SetNormalPtrCol
	MOVEQ	#0,D0
	RTS

StorePtrCol:
	MOVE.L	A6,-(SP)
	MOVE.L	CopListColorPtr,A6
	MOVE.W	2(A6),PointerCol1Save
	MOVE.W	6(A6),PointerCol2Save
	MOVE.W	10(A6),PointerCol3Save
	MOVE.L	(SP)+,A6
	RTS

ErrorRestoreCol:
	BSR.B	SetErrorPtrCol

RestorePtrCol:
	MOVE.L	A6,-(SP)
	MOVE.W	#1,UpdateFreeMem
	MOVE.L	CopListColorPtr,A6
	MOVE.W	PointerCol1Save,2(A6)
	MOVE.W	PointerCol2Save,6(A6)
	MOVE.W	PointerCol3Save,10(A6)
	MOVE.L	(SP)+,A6
	RTS


;************************************
;* checks ralt, rcommand and space  *
;************************************

CheckPlayKeys:
;	move.w	$DFF00C,D0		; get joy0 register
;	btst	#1,d0
;	bne.b	PlaySong		; joy right
;	btst	#9,d0
;	bne.s	.stop	 		; joy left
;	btst	#7,$BFE001		; joystick fire
;	beq.s	PlaySong

	MOVE.B	RawKeyCode,D0
	CMP.B	#$65,D0 		; ralt
	BEQ	PlaySong
	CMP.B	#$67,D0 		; rcommand
	BEQ	playpattern
	CMP.B	#$40,D0 		; space
	BNE.W	cpkskip
	cmp.w	#8,CurrScreen
	bne.s	.l0
	GOTO	ToggleInfos
.l0:	TST.L	RunMode
	BEQ.S	.l1
	BRA.S	.stop

.l1:	BSR.S	.record
	TST.L	EditMode
	BEQ.S	Edit

;--- status messages ---

.stop:	LEA	stopped.MSG(PC),A0
	CALL	ShowStatusText
	GOTO	StopIt

.record:
	TST.W	SamScrEnable
	BNE.S	.skip
	LEA	recready.MSG(PC),A0
	CALL	ShowStatusText
.skip:	RTS

Edit:
	TST.W	SamScrEnable			;fix 401, remove drawing notes if samplescreen on
	BEQ.B	.edit
	RTS

.edit
	CALL	StopIt
	CLR.B	RawKeyCode
	CALL	SetEditPtrCol
	CALL	SetScrPatternPos
	MOVE.L	#'edit',EditMode
	GOTO	WaitForButtonUp

;******************************
cpkskip:
	CMP.B	#$61,D0
	BEQ	RecordSong
	CMP.B	#$45,D0
	BEQ.W	EscPressed
	CMP.B	#$42,D0
	BEQ.W	TabulateCursor
	CMP.B	#$30,D0
	BNE.S	.l0
	GOTO	TurnOffVoices
.l0:	CMP.B	#$3C,D0
	BNE.S	.l1
	GOTO	KillSample

.l1:	;move.b mt_lastrawkey,d0	; for cursorkeys in mainscreen
	;move.b d0,mt_keyrepcounter

	CMP.B	#13,D0			; Drumpadmode
	BEQ.W	TogglePNote
	CMP.B	#$43,D0
	BEQ.W	EnterKeyChange
	LEA	kpinstable(PC),A0
	MOVEQ	#0,D2

.kpinsoop:
	CMP.B	0(A0,D2.W),D0
	BEQ.S	.kpinsfound
	ADDQ.W	#1,D2
	CMP.W	#$0010,D2
	BCS.B	.kpinsoop
	RTS

.kpinsfound:	TST	EnterKeyStatus
		BEQ.S	.nohi
		ADD.W	#16,D2
.nohi:
		MOVE.W	D2,D1
		BEQ.S	insnull
		BRA.B	redrsa2

redrsa3:	MOVE.W	D1,InsNum

mt_redrsaUU:	CLR.B	RawKeyCode
		CLR.L	SavSamInf
		CMP.W	#3,CurrScreen
		BNE.B	.skip
		CALL	dt_tog_sample

.skip:		CALL	ShowSampleInfo
		GOTO	RedrawSample

insnull:
		TST.W	InsNum
		BEQ.S	.skip
		MOVE.W	InsNum,LastInsNum
		CLR.W	InsNum
		MOVEQ	#0,D1
		BRA.S	redrsa2

.skip:		GOTO	ShowSampleInfo

kpinstable:	dc.b	15,$5A,$5B,$5C,$5D,$3D,$3E,$3F,$4A,$2D,$2E,$2F
		dc.b	$5E,$1D,$1E,$1F

PTProcess:	dc.l	0			; maintask addr

;****************************
redrsa2:
	TST.B	pnoteflag
	BEQ.S	redrsa3
	CLR.B	RawKeyCode
	;TST.W	AltKeyStatus
	;BNE.S	setpnote
	MOVE.W	D1,InsNum
	CALL	ShowSampleInfo
	MOVE.W	InsNum,D0
	ADD.W	D0,D0
	MOVE.W	pnotetable(PC,D0.W),D0
	MOVEQ	#-1,D2
	BSR.W	playtheinstr
	BSR.W	ClearAllKeys		;3.59
	GOTO	RedrawSample

pnotetable:
	dc.w	$0018,$0018,$0018,$0018,$0018,$0018,$0018,$0018
	dc.w	$0018,$0018,$0018,$0018,$0018,$0018,$0018,$0018
	dc.w	$0018,$0018,$0018,$0018,$0018,$0018,$0018,$0018
	dc.w	$0018,$0018,$0018,$0018,$0018,$0018,$0018,$0018

setpnote:
	ADD.W	D1,D1
	LEA	pnotetable(PC,D1.W),A0
	MOVE.L	A0,SplitAddress
	MOVE.W	#4,SamNotetype
	LEA	selectnote.MSG(PC),A0
	GOTO	ShowStatusText

;drumpadmode
TogglePNote:
	;CLR.B	RawKeyCode
	BSR.W	ClearAllKeys
	MOVEQ	#0,D0
	MOVE.B	pnoteflag,D0
	ADDQ.B	#1,D0
	CMP.B	#3,D0
	BCS.S	tpnskp
	MOVEQ	#0,D0
tpnskp:
	MOVE.B	D0,pnoteflag
	;LEA	 pnotechar(PC,D0.W),A0
tpnskp2:
	MOVEQ	#2,D0
	cmp.b	#1,pnoteflag
	beq.s	pnote1
	cmp.b	#2,pnoteflag
	beq.s	pnote2

	move.w	#'NO',pnotechar
	bra.s	ppnote
pnote1: move.w	#'PL',pnotechar
	bra.s	ppnote
pnote2: move.w	#'ED',pnotechar

ppnote:
	lea	pnotechar,a0
	MOVE.W	#$2836,D1
	CALL	ShowText3
	GOTO	Wait_4000

pnotechar:	dc.w	$00
pnoteflag:	dc.b	0,0

;***********************************
;* check shortcuts with left amiga *
;***********************************
CheckLAmigaKeys:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	LeftAmigaStatus
	BEQ.S	.skip

	MOVE.B	RawKeyCode,D1
	cmp.b	#$37,D1 		; M
	bne.s	.skip
	clr.b	RawKeyCode
	CALL	Screenswitch		; toggle PT screen if LAMIGA M pressed
.skip:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***********************************
;*--- the shortcuts with LAmiga ---*
;***********************************

CheckLAmiga3:
	TST.W	LeftAmigaStatus
	bne.s	.doit
	rts

.doit:
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	move.b	RawKeyCode,D1
	MOVE.B	SampleAllFlag,sampallsave
	BSR.S	ctksub
	MOVE.B	sampallsave(PC),SampleAllFlag
	RTS

ctksub:
	MOVEQ	#0,D0
	CLR.B	SampleAllFlag
	CMP.B	#1,D1
	BNE.S	ctksub22
	GOTO	xnotup2

ctksub22:
	CMP.B	#$10,D1 		;Q
	BNE.S	.rov1
	GOTO	lbC00F5CA

.rov1:
	CMP.B	#$20,D1 		;A
	BNE.S	.rov2
	GOTO	xoctup2

.rov2:
	CMP.B	#$31,D1 		;Y
	BNE.S	.rov3
	GOTO	lbC00F5A6

.rov3:
	MOVE.W	#$012C,D0
	CMP.B	#2,D1
	BNE.S	.rov4
	GOTO	xnotup2

.rov4:
	CMP.B	#$11,D1 		;W
	BNE.S	.rov5
	GOTO	lbC00F5CA

.rov5:
	CMP.B	#$21,D1 		;S
	BNE.S	.rov6
	GOTO	xoctup2

.rov6:
	CMP.B	#$32,D1 		;X
	BNE.S	.rov7
	GOTO	lbC00F5A6

.rov7:
	MOVEQ	#0,D0
	MOVE.B	#1,SampleAllFlag
	CMP.B	#3,D1
	BNE.S	.rov8
	GOTO	xnotup2

.rov8:
	CMP.B	#$12,D1
	BNE.S	.rov9
	GOTO	lbC00F5CA

.rov9:
	CMP.B	#$22,D1 		;D
	BNE.S	.rov10
	GOTO	xoctup2

.rov10:
	CMP.B	#$33,D1 		;C
	BNE.S	.rov11
	GOTO	lbC00F5A6

.rov11:
	MOVE.W	#$012C,D0
	CMP.B	#4,D1
	BNE.S	.rov12
	GOTO	xnotup2

.rov12:
	CMP.B	#$13,D1 		;R
	BNE.S	.rov13
	GOTO	lbC00F5CA

.rov13:
	CMP.B	#$23,D1 		;F
	BNE.S	.rov14
	GOTO	xoctup2

.rov14:
	CMP.B	#$34,D1 		;V
	BNE.S	.rov15
	GOTO	lbC00F5A6

.rov15:
	RTS

;***********************************
;* check shortcuts with control    *
;***********************************
CheckCtrlKeys:
	TST.W	CtrlKeyStatus
	BNE.S	.doit
	RTS

.doit:
	TST.B	ShiftKeyStatus
	BNE.W	CtrlShiftKeys		;CTRL-Shift
	BSR.W	DoKeyBuffer
	MOVE.B	RawKeyCode,D0

	CMP.B	#$23,D0 		;F
	BEQ.W	ToggleFilter
	CMP.B	#$21,D0 		;S
	BNE.S	.skip
	GOTO	ToggleSplitMode

.skip:	CMP.B	#$37,D0 		;M
	BNE.S	.skip1
	GOTO	ToggleMultiMode

.skip1:	CMP.B	#$10,D0 		;Q
	BEQ.W	UnMuteAll
	CMP.B	#$20,D0 		;A
	BEQ.W	ToggleMute
	CMP.B	#$31,D0 		;Y
	BEQ.W	RestoreEffects
	CMP.B	#$13,D0 		;R
	BEQ.W	RestoreFKeyPos
	CMP.B	#$14,D0 		;T
	BEQ.W	SwapTrack
	CMP.B	#$35,D0 		;B
	BEQ.W	BeginBlock
	CMP.B	#$33,D0 		;C
	BEQ.W	CopyBlock
	CMP.B	#$32,D0 		;X
	BEQ.W	CutBlock
	CMP.B	#$22,D0 		;D
	BEQ.W	DeleteBlock
	CMP.B	#$19,D0 		;P
	BEQ.W	PasteBlock
	CMP.B	#$17,D0 		;I
	BEQ.W	InsertBlock
	CMP.B	#$26,D0 		;J
	BEQ.W	JoinPasteBlock
	CMP.B	#$36,D0 		;N
	BEQ.W	Re_MarkBlock
	CMP.B	#$15,D0 		;Z
	BEQ.W	BackwardsBlock
	CMP.B	#$11,D0 		;W
	BEQ.W	PolyphonizeBlock
	CMP.B	#$12,D0 		;E
	BEQ.W	ExpandTrack
	CMP.B	#$18,D0 		;O
	BEQ.W	ContractTrack
	CMP.B	#$25,D0 		;H
	BEQ.W	TransBlockUp
	CMP.B	#$28,D0 		;L
	BEQ.W	TransBlockDown
	CMP.B	#$27,D0 		;K
	BEQ.W	KillEndOfTrack
	CMP.B	#$16,D0 		;U
	BEQ.W	UndoLastChange
	CMP.B	#$44,D0 		;ENTER
	BEQ.W	InsCMDTrack
	CMP.B	#$41,D0 		;DEL
	BEQ.W	DelCMDTrack
	CMP.B	#$24,D0 		;G
	BEQ.W	BoostAll
	CMP.B	#$34,D0 		;V
	BEQ.W	FilterAll
	CMP.B	#1,D0
	BCC.S	movaddchk
	RTS

;***********************************
;* check ctrl 0-9 editskip option  *
;***********************************
movaddchk:	CMP.B	#10,D0
		BLS.S	.doit
		RTS

.doit:		BNE.S	.skip
		MOVEQ	#0,D0

.skip:		MOVE.W	D0,EditMoveAdd
		CLR.B	RawKeyCode
		ADD.B	#'0',D0
		LEA	editskip0.MSG(PC),A0
		MOVE.B	D0,11(A0)
		CALL	ShowStatusText
		CALL	WaitALittle
		CALL	ShowAllRight
		BRA.W	showskips

editskip0.MSG:	dc.b	'EDITSKIP = 0',0,0

;***********************************
;* check shortcuts with left alt   *
;***********************************
CheckAltKeys:
	TST.W	AltKeyStatus
	BNE.S	.doit
	RTS
.doit:
	CALL	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	CMP.B	#$31,D0 		;Y
	BEQ.W	ToggleCh1
	CMP.B	#$32,D0 		;X
	BEQ.W	ToggleCh2
	CMP.B	#$33,D0 		;C
	BEQ.W	ToggleCh3
	CMP.B	#$34,D0 		;V
	BEQ.W	ToggleCh4
	CMP.B	#$35,D0 		;B
	BNE.S	.skip11
	GOTO	Boost
.skip11:
	CMP.B	#$23,D0 		;F
	BNE.S	.skip10
	GOTO	Filter

.skip10:
	CMP.B	#$14,D0 		;T
	BNE.S	.skip9
	GOTO	xTuningTone

.skip9:
	CMP.B	#$21,D0 		;LALT S
	BNE.S	.skip8
	GOTO	SamplerScreen		;GOTO SAMPLER

.skip8:
	CMP.B	#$13,D0 		;R
	BNE.S	.skip6
	GOTO	Resample

.skip6:
	CMP.B	#$17,D0 		;I
	bne.s	.skip7
	GOTO	ToggleInsertMode

.skip7:
	CMP.B	#$2B,D0
	BNE.S	.skip5
	GOTO	InfoScreen		;# infoscreen

.skip5:
	CMP.B	#$22,D0 		;D
	BEQ.W	DiskOp
	CMP.B	#$2A,D0
	BEQ.W	gtoPLST
	CMP.B	#$29,D0
	BEQ.W	gtoPLST			;PED

	CMP.B	#$3A,D0 		;-
	bne.s	.skip
	GOTO	Setup
.skip:
	;CMP.W	#1,CurrScreen
	;BNE.S	.skip4
	CMP.B	#$39,D0
	BEQ.W	decrvolsld		;volup
	CMP.B	#$38,D0
	BEQ.W	incrvolsld		;voldown

.skip4:
	CMP.B	#$27,D0 		;K
	BNE.S	.skip3
	GOTO	KillInstrTrack

.skip3:
	CMP.B	#$20,D0 		;A
	BNE.S	.skip2
	GOTO	xSampler

.skip2:
	cmp.b	#$15,D0
	beq.w	SaveAllSamples

	cmp.b	#$1B,D0
	bne.s	.skip1
	GOTO	PosED
.skip1:
	CMP.B	#$10,D0 		;Q
	BEQ.W	ExitCleanup
	cmp.b	#$3D,D0
	BEQ.W	setpnote
	cmp.b	#$3E,D0
	BEQ.W	setpnote
	cmp.b	#$3F,D0
	BEQ.W	setpnote
	cmp.b	#$2D,D0
	BEQ.W	setpnote
	cmp.b	#$2E,D0
	BEQ.W	setpnote
	cmp.b	#$2F,D0
	BEQ.W	setpnote
	cmp.b	#$1D,D0
	BEQ.W	setpnote
	cmp.b	#$1E,D0
	BEQ.W	setpnote
	cmp.b	#$1F,D0
	BEQ.W	setpnote
	cmp.b	#$43,d0 	;ENTER
	beq.w	setpnote
	cmp.b	#$0F,D0 	;0
	beq.w	setpnote
	cmp.b	#$4A,D0 	;-
	BEQ.W	setpnote
	cmp.b	#$5E,d0 	;+
	beq.w	setpnote
	cmp.b	#$5A,d0 	;[
	beq.w	setpnote
	cmp.b	#$5B,d0 	;]
	beq.w	setpnote
	cmp.b	#$5C,d0 	;/
	beq.w	setpnote
	cmp.b	#$5D,d0 	;*
	beq.w	setpnote
	RTS
;***********************************
;* Save all samples (LALT Z)       *
;***********************************

SaveAllSamples:
	LEA	SaveAllSamplesText,A0
	BSR.W	AreYouSure
	BNE.W	SetErrorPtrCol
	MOVE.W	InsNum,SaveInstr
	MOVE.W	#1,InsNum
sasamloop:
	CALL	ShowSampleInfo
	BSR.W	dosavesample
	ADDQ.W	#1,InsNum
	CMP.W	#MaxInsNum+1,InsNum
	BCS.S	sasamloop
	MOVE.W	SaveInstr,InsNum
	GOTO	ShowSampleInfo

troffs4:	EQU	5		;track mark left xoffset
cmoffs4:	EQU     5		;5+2troffs4+4

;***********************************
;* mousepositionizing tracks       *
;***********************************

FindPosTrack1:
	MOVEM.W (MouseX2),D0/D1
	chn8test
	bne.s	.chan4
	moveq	#43,d2
	bra.s	.doit

.chan4:	MOVEQ	#54,D2
.doit:	MOVEQ	#0,D3			;pattcurpos zero
	BRA.W	findposit
;---

FindPosTrack2:
	MOVEM.W (MouseX2),D0/D1
	chn8test
	bne.s	.chan4
	move.w	#133-18,d2
	bra.s	.doit

.chan4:	MOVE.W	#199,D2
.doit:	MOVEQ	#6,D3
	BRA.S	findposit

;---

FindPosTrack3:
	MOVEM.W (MouseX2),D0/D1
	chn8test
	bne.s	.chn4
	move.w	#230-39-4,d2
	bra.s	.doit

.chn4:	MOVE.W	#343,D2
.doit:	MOVEQ	#12,D3
	BRA.S	findposit

;---

FindPosTrack4:
	MOVEM.W (MouseX2),D0/D1
	chn8test
	bne.s	.chn4
	move.w	#314-38-17,d2
	bra.s	.skip

.chn4:	MOVE.W	#487,D2
.skip:	MOVEQ	#18,D3
	BRA.S	findposit

;---
FindPosTrack5:
	MOVEM.W (MouseX2),D0/D1
	MOVE.W	#384-38-16,D2
	MOVEQ	#24,D3
	BRA.S	findposit
;---
FindPosTrack6:
	MOVE.W	#454-38-13,D2
	MOVEQ	#30,D3
	BRA.S	findposit

;---
FindPosTrack7:
	MOVE.W	#526-38-13,D2
	MOVEQ	#36,D3
	BRA.S	findposit

;---
FindPosTrack8:
	MOVE.W	#596-38-11,D2
	MOVEQ	#42,D3

;--- continue findpostracks---

findposit:
	SUB.W	D2,D0
	TST.B	lmb_or_rmb		;lmb or rmb?
	BEQ.S	.l0			;lmb
	BSR.W	.l1			;rmb
	BEQ.S	.l0
	RTS

.l0:
	chn8test			;4.0 prfen
	bne.s	.chan4
	mulu.w	#2,d0

.chan4:
	BSR.W	WaitForButtonUp		;again removed 4.01
	MOVEQ	#0,D4
	CMP.W	#8*6,D0
	BMI.S	.kl
	ADDQ.W	#1,D4
	CMP.W	#8*8,D0
	BMI.S	.kl
	ADDQ.W	#1,D4
	CMP.W	#8*10,D0
	BMI.S	.kl
	ADDQ.W	#1,D4
	CMP.W	#8*12,D0
	BMI.S	.kl
	ADDQ.W	#1,D4
	CMP.W	#8*14,D0
	BMI.S	.kl
	ADDQ.W	#1,D4
	CMP.W	#8*16,D0
	BMI.S	.kl
	ADDQ.W	#1,D4

.kl:	ADD.W	D3,D4
	MOVE.W	D4,PattCurPos
	TST.W	RunMode
	BNE.S	.ka
	SUB.W	#150,D1
	ASR.W	#3,D1
	SUBQ.W	#6,D1
	ADD.W	D1,ScrPattPos
	BPL.S	.kb
	CLR.W	ScrPattPos

.kb:	CMP.W	#MaxPattPos,ScrPattPos
	BMI.S	.kc
	MOVE.W	#MaxPattPos,ScrPattPos
.kc:	CALL	SetScrPatternPos

.ka:	BSR.W	UpdateCursorPos
	TST.L	RunMode
	BEQ.S	.dook
	RTS
.dook:
	TST.B	lmb_or_rmb
	BNE.S	.ko
	RTS

.ko:	CLR.W	mt_TrackPattGad
	lea	Useopt7.MSG,a0
	CALL	ShowStatusText
	GOTO	ShowBlockMode
	;GOTO	OptionCommands7			;4.0 toggle aut. to opt7
;---

.l1:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.L	RunMode				;play?
	BNE.W	BlitMarkEnd

	MOVE.W	D2,MarkXPosPtr
	MOVE.W	D3,lbW005ADA
	BSR.W	ReBlitTrack
	MOVE.L	#$FFFFFFFF,MarkReadyFlag

	MOVEM.W (MouseX),D0/D1
	SUB.W	MarkXPosPtr(PC),D0
	BMI.W	SMarkMo				;end, no blit

	CMP.W	#$00FE,D1
	BPL.W	PositionizeCursor
	SUB.W	#$0096,D1			;y-may
	BMI.W	PositionizeCursor

	EXT.L	D0
	DIVS	#12,D0
	ASR.W	#3,D1
	ADD.W	ScrPattPos,D1

	CMP.W	#6,D1
	BMI.W	PositionizeCursor		;minpos
	CMP.W	#$46,D1
	BPL.W	PositionizeCursor		;maxpos
	MOVE.W	D1,D2
	SWAP	D2
	chn8test
	bne.s	.chn4

	cmp.w	#4,d0
	BPL.S	mt_posbyg8
	MOVEQ	#0,D0
	BRA.S	mt_posbyh
.chn4:
	CMP.W	#5+2,D0
	BPL.S	mt_posbyg
	MOVEQ	#0,D0
	BRA.S	mt_posbyh

;MARK CMDS

mt_posbyg8:
	moveq	#4,d0
	bra.s	mt_posbyh

mt_posbyg:
	MOVEQ	#5+2,D0				;xleft cmds mark

;MARK TRACK

mt_posbyh:
	MOVE.W	D0,D2
	MOVE.L	D2,BlitChannel
	MOVE.W	lbW005ACE(PC),BltDelayBase
mt_posbyi:
	BSR.W	ResetKeyTimer
	checkrmb
	BNE.W	PositionizeCursor 		;trackmark RMB?

;*************************************
;* RMB, mark trackparts by dragging  *
;*  mouse			     *
;*************************************

	MOVE.W	lbW005ACE(PC),D7
	MOVEM.W (MouseX),D2/D3
	CMP.W	#$00FD,D3			;lower for scrolldown
	BMI.S	mt_posbyj
	ADDQ.W	#1,ScrPattPos
	CMP.W	#MaxPattPos,ScrPattPos
	BMI.S	maddloo
	MOVE.W	#MaxPattPos,ScrPattPos
maddloo:
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	SetScrPatternPos
	MOVE.L	DOSBase,A6
	MOVEQ	#0,D1
	MOVE.W	BltDelayBase(PC),D1
	CALLSYS	Delay
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.W	#$00FC,D3			;lowest for scrolldown
	MOVE.W	yposmark(PC),D7

mt_posbyj:
	SUB.W	#$0096,D3			;yposmax
	BPL.S	Mark_Horiz
	SUBQ.W	#1,ScrPattPos
	BPL.S	msubloo
	CLR.W	ScrPattPos

msubloo:
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	SetScrPatternPos
	MOVE.L	DOSBase,A6
	MOVEQ	#0,D1
	MOVE.W	BltDelayBase(PC),D1
	CALLSYS	Delay
	MOVEM.L (SP)+,D0-D7/A0-A6

	MOVEQ	#0,D3				;yposmin
	MOVE.W	yposmark(PC),D7

;ypos

Mark_Horiz:
	MOVE.W	D7,BltDelayBase 		;ypos
	SUB.W	MarkXPosPtr(PC),D2		;xpos mouse
	BPL.S	mt_posbyl
	MOVEQ	#0,D2

mt_posbyl:
	EXT.L	D2
	DIVS	#12,D2			;12
	CMP.W	#8+3,D2			;6
	BMI.S	mt_posbym
	MOVEQ	#8+3,D2			;xend 1 track
mt_posbym:
	ASR.W	#3,D3
	CMP.W	#13,D3                	;xstart tracks
	BMI.S	mt_posbyn
	MOVE.W	#13,D3			;visible rel to mouse y

mt_posbyn:
	ADD.W	ScrPattPos,D3 		;ystart 1 track
	CMP.W	#7,D3
	BPL.S	Mark_NextTrack
	MOVEQ	#7,D3

;valid select, calc now

Mark_NextTrack:
	CMP.W	#$0045,D3
	BMI.S	mt_posbyp
	MOVE.W	#$0045,D3		;ymax all
mt_posbyp:

	chn8test
	bne.s	.chan4
	cmp.w	#4,d2
	bpl.s	MarkCmds8
	moveq	#0,d2
	bra.s	MarkTracks

.chan4:
	CMP.W	#5+2,D2
	BPL.S	MarkCmds
	MOVEQ	#0,D2			;tracks+cmd area change
	BRA.S	MarkTracks		;note-area

;markarea cmds
MarkCmds8:
	moveq	#4,d2
	bra.s	MarkTracks

MarkCmds:
	MOVEQ	#5+2,D2			;x-min offset cmds mark

;d0=point to next
;d1=value of marked rows low d2=bright d3=value of markrows high

MarkTracks:
	MOVE.W	D3,D4
	SWAP	D4
	MOVE.W	D2,D4
	CMP.L	BlitChannel(PC),D4
	BEQ.W	mt_posbyi
	MOVE.L	D4,BlitChannel
	MOVE.W	MarkXPosPtr(PC),D4
	MOVEM.L D0-D7/A0-A6,-(SP)

	BSR.W	BlitMark
	MOVEM.L (SP)+,D0-D7/A0-A6
	BRA.W	mt_posbyi

mt_posbys:
	CLR.L	MarkReadyFlag
BlitMarkEnd:
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D4
	RTS

;***********************************
PositionizeCursor:
	TST.L	MarkReadyFlag
	BMI.S	mt_posbys
SMarkMo:
	MOVE.W	#3,mt_TrackPattGad	;set to block
	CALL	ShowBlockMode
	;CALL	OptionCommands7		;4.0 toggle aut. to opt7
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#-1,D4
	RTS

;***********************************
;* gets pointers to marked trackdata
;***********************************
GetMarkPointers:
	TST.L	MarkReadyFlag
	BEQ.S	.loo
	MOVE.W	lbW005AD4(PC),D0
	MOVE.W	lbW005AD8(PC),D1
	ADDQ.W	#1,D1
	SUB.W	D0,D1
	SUBQ.W	#6,D0
	MOVE.W	D1,EndBlockPos
	MOVE.W	D0,StartblockPos
	MOVE.W	lbW005ADA(PC),PattCurStore
	TST.W	lbW005AD2
	SNE	lbB00F49D
	TST.W	lbW005AD6
	SEQ	lbB00F49E
	MOVEQ	#0,D0
	RTS

.loo:	MOVEQ	#-1,D0
	RTS

EndXOps:
	MOVEM.W MarkReadyFlag(PC),D0-D3
	BRA.W	BlitMarkNow

;********************************
;* routine for drawing a track  *
;********************************

ReBlitTrack:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEM.W D0-D3,MarkReadyFlag
BlitMark:
	MOVEM.W D0-D4,-(SP)
	MOVEM.W BlitMarkPtrs(PC),D0-D3
	BSR.W	BlitMarkNow
	MOVEM.W (SP)+,D0-D4
	CMP.W	D0,D2
	BPL.S	bmloo
	EXG	D0,D2
bmloo:
	CMP.W	D1,D3
	BPL.S	bmlob
	EXG	D1,D3
bmlob:	MOVEM.W D0-D3,BlitMarkPtrsSto

	TST.W	D2
	BNE.S	bmloc			;+cmds?

	chn8test
	bne.s	.chn4
	moveq	#4,d2			;notes8 xposr
	bra.s	.chn8

.chn4:	MOVEQ	#5+2,D2			;notes4 xposr
.chn8:	BRA.S	bmlod

bmloc:	MOVEQ	#9+2,D2			;cmds4 xposr
	chn8test
	bne.s	bmlod
	move	#4+2,d2			;cmds8 xposr

bmlod:	MULS	#12,D0			;YPOS4
	MULS	#12,D2

	ASL.W	#3,D1
	ASL.W	#3,D3

	ADD.W	D4,D0
	ADD.W	D4,D2

	ADD.W	#$0092,D1		;trck+cmd
	ADD.W	#$0092,D3		;ymarkmax
	ADDQ.W	#8,D3			;fontheight, next pos
	MOVEM.W D0-D3,BlitMarkPtrs
	TST.W	D4
	BNE.S	ReBlitRet
	RTS

ReBlitRet:
	MOVEM.W D0-D3,MarkReadyFlag
	BSR.S	BlitMarkNow
	MOVEM.W BlitMarkPtrsSto(PC),D0-D3
	MOVEM.W D0-D3,lbW005AD2
	RTS

BlitMarkNow:
	TST.W	D0
	BNE.S	.doit
	RTS
.doit:	GOTO	BlitTrackMarks		;blit markers

MarkXPosPtr:	dc.w	0,0
BltDelayBase:	dc.w	0
BlitChannel:	dc.l	0
lbW005ACE:	dc.w	$0014
yposmark:	dc.w	2
lbW005AD2:	dc.w	0
lbW005AD4:	dc.w	0
lbW005AD6:	dc.w	0
lbW005AD8:	dc.w	0
lbW005ADA:	dc.w	0
MarkReadyFlag:	dc.l	0,0
BlitMarkPtrs:		dc.w	0,0,0,0
BlitMarkPtrsSto:	dc.w	0,0,0,0
lmb_or_rmb:		dc.b	0,0

;***********************************
;* tabulatorposittion in edit      *
;***********************************

TabulateCursor:
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BNE.S	TabCurRight
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	ADDQ.W	#1,D0
	cmp.w	numchans,d0
	bne.s	tacskip
	moveq	#0,d0
tacskip:
	MULU	#6,D0
	MOVE.W	D0,PattCurPos
	BRA.W	UpdateCursorPos

TabCurRight:
	MOVE.W	PattCurPos,D0
	ADDQ.W	#5,D0
	DIVU	#6,D0
	SUBQ.W	#1,D0
	BPL.S	tacskip

	move.w	numchans,d0
	subq	#1,d0
	BRA.S	tacskip

;***********************************
;*close all what is to close w. ESC*
;***********************************
EscPressed:
	CLR.B	RawKeyCode
	CLR.B	mt_savekey
	MOVE.W	CurrScreen,D0
	CMP.W	#2,D0
	BCS.S	BotExit
TopExit:
	MOVE.W	CurrScreen,D0
	CMP.W	#2,D0
	BEQ.W	ExitHelpScreen
	CMP.W	#3,D0
	BEQ.W	ExitFromDir
	CMP.W	#5,D0
	BEQ.W	ExitFromSetup
	CMP.W	#6,D0
	bne.b	.skip
	GOTO	ExitPLST
.skip:
	CMP.W	#8,D0
	BNE.B	.skip1
	GOTO	Info_Exit
.skip1:
	cmp.w	#9,d0
	bne.b	.skip2
	GOTO	exitposed
.skip2:	RTS

BotExit:
	TST.W	SamScrEnable
	beq.s	.skip
	GOTO	ExitFromSam
.skip:
	TST.W	BlockMarkFlag
	BNE.W	blkunma
	RTS

;***********************************
;*LCOMM N/M OR GADGET SCREENSWITCH *
;***********************************
Screenswitch:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR	PrepScreenSwitch
	BNE.S	PrepNotFinished
	CALL	AllocPTScreen
	BSR	ScrSwitch2
PrepNotFinished:
	MOVEM.L (SP)+,D0-D7/A0-A6	; after screenswitch, 4.0
	RTS

PrepScreenSwitch:
	TST.L	PTScreenBase
	BEQ.S	NoPTScreenFound
	TST.L	RunMode
	BNE.S	psswll
	CALL	StopIt
psswll:
	BSR	PrepareResetVBI
	BSR	RemovePTPort
	BSR	ReSetEasyReq
	BSR	ResetCopList
	MOVE.L	PTScreenBase(PC),A0
	MOVE.L	IntuiBase,A6
	CMP.L	$003C(A6),A0
	BNE.S	mt_scrswend
	CALLSYS	ScreenToBack
mt_scrswend:
	MOVEQ	#0,D0
	RTS

NoPTScreenFound:
	MOVEQ	#-1,D0
	RTS

ScrSwitch2:
	MOVE.L	IntuiBase,A6
	CALLSYS	ScreenToFront
	BSR	SetVBInt
	BSR	InitInputHandler
	BSR	SetEasyReq
	BRA	SetCopList

;***********************************
;*copyright requester in mainscreen*
;***********************************
remember:

	MOVE.W	#$FFFF,DirCopFlag
	SF	ScopeEnable
	BSR.W	GetCopyrGFX
	LEA	ReqGFXCopyRight,A0
	MOVEQ	#$40,D0
	MOVEQ	#11,D1
	CALL	BlitAllBasic			; symbol sprite

	MOVE.W	#$0040,D0
	MOVEQ	#11,D1
	MOVE.W	#$0240,D2
	MOVEQ	#$72,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox			; clears aboutreq area

	LEA	Copyright.TXT(PC),A0
	MOVE.W	#$0050,D0
	MOVEQ	#$10,D1
	CALL	PrintTextInReqs

	SUB.L	A0,A0
	LEA     CopyrightBoxGFX,A1
	SUB.L   A2,A2
	MOVE.L  #$FFFFF551,D0
	BSR.W   SwapBoxMem

.loop:	BSR.W	ResetKeyTimer
	BSR.W	DoKeyBuffer
	BSR.W	CheckLAmigaKeys
	move.b	RawKeyCode,d0
	cmp.b	#$40,d0
	beq.s	.end				;end
	cmp.b	#$44,d0
	beq.s	.end
	cmp.b	#$45,d0
	beq.s	.end
	checklmb
	BNE.S	.loop

	MOVEM.W (MouseX),D0/D1
	LEA	CopyrightsGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.B	.loop
.end:
	BSR.W	CopyrightEnd			; swap gfx mem
	ST	ScopeEnable
	CLR.W	DirCopFlag
	clr.b	RawKeyCode
	RTS

;*************************************

mt_relabdiskproc:
	MOVE.L	A0,A2
	MOVE.L	A1,A3
	LEA	MsgPortAddr,A5
	LEA	$14(A5),A4
	MOVE.L	A4,10(A5)
	LEA	(A5),A0
	MOVE.L	A0,(A4)
	MOVE.L	PTProcess(PC),A0
	LEA	$5C(A0),A0
	MOVE.L	A0,4(A4)
	MOVE.L	#9,8(A4)
	MOVE.L	A3,D1
	LSR.L	#2,D1
	MOVE.L	D1,$14(A4)
	MOVE.L	A2,A0
	MOVE.L	A0,D1
	MOVE.L	DOSBase,A6
	CALLSYS	DeviceProc
	MOVE.L	D0,A0
	LEA	MsgPortAddr,A1
	MOVE.L	4.w,a6
	CALLSYS	PutMsg
	MOVE.L	PTProcess(PC),A0
	LEA	$5C(A0),A0
	MOVE.L	A0,-(SP)
	CALLSYS	WaitPort
	MOVE.L	(SP)+,A0
	CALLSYS	GetMsg
	MOVE.L	D0,A1
	TST.L	D0
	BEQ.S	.skip
	CALLSYS	ReplyMsg
.skip:
	RTS

Copyright.TXT:
	dc.b	'        ProTracker V'
	Revision
	dc.b	' FINAL  (MC '

	IFEQ	highercpu
	dc.b	'68000'
	ELSE
	dc.b	'68020'
	ENDC

	dc.b	' Version / '
	RevDate
	dc.b	')',$A,$A
	dc.b	'        (C) 1990 Lars Hamre,''92-''93 CryptoBurners, ''94-''97 Tom Beyer',$A,$A
	dc.b	'        All forms of publishing through commercial channels and data',$A
	dc.b	'        medias (as CD, Disk, DAT-Tapes etc.) are striktly forbidden.',$A
	dc.b	'        The authors are not responsible for  any  loss  of  data if ',$A
	dc.b	'           Protracker should crash your system or causes errors.',$A,$A
	dc.b	'              And always remember: the future is unwritten ...',$A
	dc.b	'        Dedicated to Nando. May you find comfort in another world.',0
	EVEN

gtoPLST:	GOTO	PLST
;********************************
;* online help show/load        *
;********************************
CheckHelp:
	CMP.B	#$5F,RawKeyCode
	BEQ.S	.hky
	RTS

.hky:	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BNE.S	.shifsel
	TST.W	CtrlKeyStatus
	BNE.S	.hsel
	BRA.S	.hlpdo

.hsel:
	CLR.B	PLSTHelpFlag
	LEA	helpselected.MSG,A0
	BRA.S	.msg

.shifsel:
	MOVE.B	#1,PLSTHelpFlag
	LEA	plstselected.MSG,A0

.msg:	CALL	ShowStatusText
	BSR.W	WaitALittle
	GOTO	ShowAllRight

;---
.hlpdo:	CMP.B	#1,PLSTHelpFlag
	bne.s	Help
	GOTO	PLST

Help:	CMP.W	#2,CurrScreen
	BEQ.W	ExitHelpScreen
	BSR.W	TopExit
	BSR.W	WaitForButtonUp
	ST	ScopeEnable			;scopes off
	ST	NoSampleInfo			;sample infotexts off
	BSR.W	SwapHelpScreen			;make window for help if not open
	BEQ.W	exithlp

	BSR.W	clearhelp
	TST.L	HelpTextIndex+4
	BNE.B	.l1	 			;path+read
	BSR.W	GetHelpIndex
.l1:
	MOVE.L	#pthelpfilename,D1		;name
	MOVE.L	#$000003ED,D2			;AXSmode
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.W	ShowHelpPage

	LEA	pthelpfilename,A0		;store path in status1
	BSR.W	CopyPath			;!!!!
	LEA	pthelpfilename,A0
	MOVEQ	#7,D0

.l2:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.l2

	MOVE.L	#FileName,D1			;name
	MOVE.L	#$000003ED,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	nohelp

	BRA.W	ShowHelpPage
;---
ExitHelpScreen:
	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3
	CMP.W	#$FFFF,scrtablecl
	MOVE.L	FileHandle,D1
	BEQ.B	.l3
	MOVE.L	DOSBase,A6
	CALLSYS	Close

.l3:	BSR.W	WaitForButtonUp
	bsr.s	clearhelp
	BSR.B	SwapHelpScreen

exithlp:
	BSR.W	Clear120Lines
	BRA.W	DisplayMainAll

;---
SwapHelpScreen:
	lea	HelpScreenData,a0
	bsr.w	UpperDecrunch
	moveq	#-1,d0
	rts

clearhelp:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#2,D0
	MOVEQ	#12,D1
	MOVE.W	#638,D2
	MOVEQ	#118,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox			; clears helptext area 2-638 x
	MOVEM.L (SP)+,D0-D7/A0-A6		;                     12-118 y
	RTS

CheckHelpGadgs:
	MOVEM.W (MouseX2),D0/D1 		; Help screen, get close symbol
	LEA	HelpGadData,A0			; stolen from Info screen :-)
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.doit
	RTS
.doit:
	CMP.W	#01,D2
	BEQ.W	ExitHelpScreen
	cmp.w	#02,d2
	beq.w	Screenswitch
	cmp.w	#$03,d2
	beq.w	HelpLeft
	cmp.w	#$04,d2
	beq.w	HelpUp
	cmp.w	#$05,d2
	beq.w	HelpDown
	cmp.w	#$06,d2
	beq.w	HelpRight
	RTS
;---
ShowHelpPage:
	MOVE.W	#2,CurrScreen
	MOVE.W	HelpPage,D0
	AND.W	#$00FF,D0
	LSL.W	#2,D0
	LEA	HelpTextIndex,A0
	MOVE.L	FileHandle,D1			; FileHandle
	BNE.B	.l5
	RTS

.l5:	MOVE.L	(A0,D0.W),D2			;get actual txt adress
	ADD.L	#1024,D2			;skip indexdata, txtstrt
	MOVEQ	#-1,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Seek
	MOVE.L	FileHandle,D1			;FileHandle
	MOVE.L	#HelpTextData,D2		;buffer
	MOVE.L	#$00000290*2,D3			;4.0 *2 656*2 length
	CALLSYS	Read
	BSR.W	clearhelp
	LEA	HelpTextData+16,A6		;table
	MOVE.W	#$0F0*6,D6			;x-offset start
	MOVEQ	#16,D7				;lines to print

.tlop:	MOVEQ	#0,D0
	MOVE.L	A6,A1

.l8:	CMP.B	#10,(A1)+
	BEQ.B	.txtout
	TST.B	-1(A1)
	BEQ.B	.txtout
	ADDQ.W	#1,D0
	BRA.S	.l8

.txtout:
	MOVE.L	A6,ShowTextPtr
	MOVE.L 	A1,A6
	MOVE.W	D6,TextOffset			;D6 startvalue x txt
	MOVE.W	D0,TextLength
	BEQ.B	.l9
	CALL	ShowText
.l9:	ADD.W	#$01E0,D6			;new line
	DBRA	D7,.tlop

	BRA.W	Wait_4000

;---
HelpUp: 	LEA	HelpTextData+7,A0
		BRA.S	hlpmov
HelpDown:	LEA	HelpTextData+10,A0
		BRA.S	hlpmov
HelpLeft:	LEA	HelpTextData+4,A0
		BRA.S	hlpmov
HelpRight:	LEA	HelpTextData+13,A0

hlpmov:
	CLR.B	RawKeyCode
	MOVEQ	#0,D0
	CALL	HexToInteger2			;calculate
	TST.W	D0
	BNE.B	.lm
	RTS

.lm:	AND.W	#$00FF,D0
	MOVE.W	D0,HelpPage
	BSR.W	ShowHelpPage
	BSR.W	ClearAllKeys
	BSR.W	Wait_4000
	BRA.W	Wait_4000

;---
GetHelpIndex:
	MOVE.L	HelpTextFlag,D0			;base help
	CMP.L	HelpTextIndex,D0		;pt.help already opened?
	BNE.S	.gh
	RTS

.gh:	MOVE.L	#pthelpfilename,D1		;get full path
	MOVE.L	#$000003ED,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.S	.read
	LEA	pthelpfilename,A0
	BSR.W	CopyPath
	LEA	pthelpfilename,A0
	MOVEQ	#7,D0

.lA:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.lA

	MOVE.L	#FileName,D1			;full path+name
	MOVE.L	#$000003ED,D2			;accessmode
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.S	nohelp

.read:	MOVE.L	D0,D1
	MOVE.L	#HelpTextIndex,D2		;Buffer
	MOVE.L	#1024,D3			;length
	CALLSYS	Read
	MOVE.L	FileHandle,D1			;FileHandle
	CALLSYS	Close
	MOVE.L	HelpTextIndex,HelpTextFlag
	RTS

;---
nohelp:
	MOVE.W	#2,CurrScreen
	LEA	NoHelpFile.MSG(PC),A0
	MOVE.W	#$0EB7,D1
	MOVEQ	#$18,D0
	GOTO	ShowStatusText

;******************************
;* position set message       *
;******************************
chkalt:
	LEA	Positionnowse.MSG,A0
	CALL	ShowStatusText
	MOVEQ	#8,D2
.loo:
	BSR.W	Wait_4000
	DBRA	D2,.loo
	GOTO	ShowAllRight

;********************************
;* check position f-keys f6-f10 *
;********************************
CheckF6_F10:
	CMP.B	#$55,RawKeyCode 		;F6
	BNE.S	.CheckF7
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.doit
	MOVE.W	ScrPattPos,F6Pos
	bsr.s	chkalt				; Status Message
.doit:
	MOVE.W	F6Pos,D0
.lab1:
	TST.W	AltKeyStatus
	BNE.W	PattFrom
	TST.W	CtrlKeyStatus
	BNE.W	mt_recordon
	TST.W	LeftAmigaStatus
	BNE.W	playsong1

	TST.W	RunMode
	BEQ.S	.doit1
	RTS
.doit1:
	MOVE.W	D0,ScrPattPos
	BRA.W	SetScrPatternPos

.CheckF7:
	CMP.B	#$56,RawKeyCode
	BNE.S	.CheckF8
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.skip2
	MOVE.W	ScrPattPos,F7Pos
	BRA	chkalt

.skip2:
	MOVE.W	F7Pos,D0
	BRA.S	.lab1

.CheckF8:
	CMP.B	#$57,RawKeyCode
	BNE.S	.CheckF9
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.skip3
	MOVE.W	ScrPattPos,F8Pos
	BRA.W	chkalt

.skip3:
	MOVE.W	F8Pos,D0
	BRA.W	.lab1

.CheckF9:
	CMP.B	#$58,RawKeyCode
	BNE.S	.CheckF10
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.skip4
	MOVE.W	ScrPattPos,F9Pos
	BRA.W	chkalt

.skip4:
	MOVE.W	F9Pos,D0
	BRA.W	.lab1

.CheckF10:
	CMP.B	#$59,RawKeyCode
	BEQ.S	.skip5
	RTS

.skip5:
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.skip6
	MOVE.W	ScrPattPos,F10Pos
	BRA.W	chkalt

.skip6:
	MOVE.W	F10Pos,D0
	BRA.W	.lab1

;********************************
;* check f-keys f3-f5           *
;********************************
CheckF3_F5:
	MOVEQ	#0,D0
	MOVE.L	D0,A0
	TST.B	ShiftKeyStatus
	BNE.W	F3_F5cutcopy		;shift scanned
	TST.W	CtrlKeyStatus
	BNE.W	F3_F5cutcopy		;ctrl scanned
	TST.W	AltKeyStatus
	BNE.W	CutCopPas		;alt scanned

	CMP.B	#$44,RawKeyCode 	;ENTER
	BEQ.S	StepPlayForward
	CMP.B	#$41,RawKeyCode 	;BackSpace
	BEQ.S	StepPlaybackward
	TST.W	SamScrEnable
	BNE.S	.skip0
	RTS
.skip0:
	CMP.B	#$52,RawKeyCode
	BNE.S	.skip
	GOTO	SamCut
.skip:
	CMP.B	#$53,RawKeyCode
	BNE.S	.skip1
	GOTO	SamCopy
.skip1:
	CMP.B	#$54,RawKeyCode
	BNE.S	.skip2
	GOTO	SamPaste
.skip2:
	RTS

;*************************************
;* Step play with enter / <==        *
;*************************************
StepPlayForward:
	CMP.W	#3,CurrScreen
	BNE.S	.doit
	GOTO	HitDirloadEntry		;3.30, enter if dirscreen open = load

.doit:	MOVE.W	#1,StepPlayEnable
	CALL	DoStopIt
	MOVE.W	ScrPattPos,D0
	BSR.W	pafr1
.loop:
	BSR.W	Wait_4000
	tst.w	StepPlayEnable
	bne.s	.loop

	BSR.W	ClearAllKeys
	bra.w	SetScrPatternPos

StepPlaybackward:
	MOVE.W	#1,StepPlayEnable
	CALL	DoStopIt
	MOVE.W	ScrPattPos,D0
	BSR.W	pafr1

.loop:	bsr.w	Wait_4000
	tst.w	StepPlayEnable
	bne.s	.loop

	move.w	ScrPattPos,D0
	SUBQ.W	#2,D0
	AND.W	#MaxPattPos,D0
	MOVE.W	D0,ScrPattPos
	BSR.W	ClearAllKeys
	bra.w	SetScrPatternPos

StepPlayEnable: dc.w	0

;********************************
;* routines for f3-f5 cut/copy  *
;* jumped from CheckF3_F5       *
;********************************

F3_F5cutcopy:
	MOVEQ	#0,D0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	AND.L	#7,D0
	chn8test
	BEQ.B	.chn4
	AND.L	#3,D0
.chn4:
	LSL.L   #2,D0
	MOVE.L  D0,A0

CutCopPas:
	ADD.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D0
	LSL.L	#8,D0
	LSL.L	#2,D0
	chn8test
	BNE.S	.chn4
	LSL.L	#1,D0

.chn4:	ADD.L	D0,A0
	TST.W	AltKeyStatus
	BNE.S	CutCopPasPatt
	TST.W	CtrlKeyStatus
	BNE.B	CutCopPasCmds
	CMP.B	#$52,RawKeyCode 	;F3
	BEQ.W	CutTrack
	CMP.B	#$53,RawKeyCode 	;F4
	BEQ.W	CopyTrack
	CMP.B	#$54,RawKeyCode 	;F5
	BEQ.W	PasteTrack
	CMP.B	#$44,RawKeyCode 	;ENTER
	BEQ.W	InsNoteTrack
	CMP.B	#$41,RawKeyCode 	;<-
	BEQ.W	DelNoteTrack
	RTS

;********************************
CutCopPasPatt:
	CMP.B	#$52,RawKeyCode 	;F3
	BEQ.S	CutPattern
	CMP.B	#$53,RawKeyCode 	;F4
	BEQ.S	CopyPattern
	CMP.B	#$54,RawKeyCode 	;F5
	BEQ.W	PastePattern
	CMP.B	#$44,RawKeyCode 	;ENTER
	BEQ.W	InsNotePattern
	CMP.B	#$41,RawKeyCode 	;<-
	BEQ.W	DelNotePattern
	RTS

;********************************
CutCopPasCmds:
	CMP.B	#$52,RawKeyCode
	BEQ.W	CutCmds
	CMP.B	#$53,RawKeyCode
	BEQ.W	CopyCmds
	CMP.B	#$54,RawKeyCode
	BEQ.W	PasteCmds
	RTS

;********************************
CutPattern:
	BSR.W	SaveUndo
	LEA	PatternBuffer,A1
	MOVE.W	#$00FF,D0
	MOVEQ	#0,D1
	chn8test
	BNE.S	.chn4
	MOVE.W	#$1FF,D0

.chn4:	MOVE.L	(A0),(A1)+
	MOVE.L	D1,(A0)+
	DBRA	D0,.chn4

	CLR.B	RawKeyCode
	GOTO	RedrawPattern

;********************************
CopyPattern:
	LEA	PatternBuffer,A1
	MOVE.W	#$00FF,D0
	chn8test
	BNE.S	.chn4
	MOVE.W	#$1FF,D0

.chn4:	MOVE.L	(A0)+,(A1)+
	DBRA	D0,.chn4
	RTS

;********************************
PastePattern:
	BSR.W	SaveUndo
	LEA	PatternBuffer,A1
	MOVE.W	#$00FF,D0
	chn8test
	BNE.S	.chn4
	MOVE.W	#$1FF,D0

.chn4:	MOVE.L	(A1)+,(A0)+
	DBRA	D0,.chn4
	CLR.B	RawKeyCode
	GOTO	RedrawPattern

;********************************
CutTrack:
	BSR.W	SaveUndo
	LEA	TrackBuffer,A1
	MOVEQ	#MaxPattPos,D0
	MOVEQ	#0,D1

.loop:
	MOVE.L	(A0),(A1)+
	MOVE.L	D1,(A0)
	LEA	$0010(A0),A0
	chn8test
	BNE.S	.chn4
	LEA	$10(A0),A0

.chn4:	DBRA	D0,.loop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern

;********************************
CopyTrack:
	LEA	TrackBuffer,A1
	MOVEQ	#MaxPattPos,D0
.loop:
	MOVE.L	(A0),(A1)+
	LEA	$0010(A0),A0
	chn8test
	BNE.S	.chn4
	LEA	$0010(A0),A0

.chn4:	DBRA	D0,.loop
	RTS

;********************************
PasteTrack:
	BSR.W	SaveUndo
	LEA	TrackBuffer,A1
	MOVEQ	#MaxPattPos,D0

patrloop:
	MOVE.L	(A1)+,(A0)
	LEA	$0010(A0),A0
	chn8test
	BNE.S	.chn4
	LEA	$0010(A0),A0

.chn4:	DBRA	D0,patrloop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern

;********************************
InsNotePattern:
	BSR.W	SaveUndo
	MOVEQ	#0,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#6,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#12,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#18,D0
	CALL	GetPositionPtr
	BSR.S	inotr

	chn8test
	BNE.S	intskip

	MOVEQ	#24,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#30,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#36,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	MOVEQ	#42,D0
	CALL	GetPositionPtr
	BSR.S	inotr
	BRA.S	intskip

;********************************
InsNoteTrack:
	BSR.W	SaveUndo
	BSR.S	inotr
intskip:
	CLR.B	RawKeyCode
	ADD.W	D2,ScrPattPos

	AND.W	#MaxPattPos,ScrPattPos
	BSR.W	SetScrPatternPos
	GOTO	RedrawPattern

inotr:
	MOVE.W	ScrPattPos,D1
	LSL.W	#4,D1
	chn8test
	BNE.S	.chn4

	CMP.W	#2048-32,D1
	BEQ.S	inoskip
	MOVE.W	#2048-2*32,D0
	bra.s	intloop

.chn4:
	CMP.W	#1024-16,D1
	BEQ.S	inoskip
	MOVE.W	#1024-2*16,D0

intloop:
	MOVE.L	0(A0,D0.W),$10(A0,D0.W)
	SUB.W	#$0010,D0
	CMP.W	D1,D0
	BGE.S	intloop

inoskip:
	MOVEQ	#1,D2
	CLR.L	0(A0,D1.W)
	RTS

;********************************
InsCMDTrack:
	CLR.B	RawKeyCode
	BSR.W	SaveUndo
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.S	.doit
	BRA.S	intskip

.doit:
	MOVE.W	ScrPattPos,D1
	LSL.W	#4,D1
	chn8test
	BNE.S	.chn4

	CMP.W	#2048-32,D1
	BEQ.S	icmskip
	MOVE.W	#2048-32*2,D0
	BRA.S	icmloop
.chn4:
	CMP.W	#1024-16,D1
	BEQ.S	icmskip
	MOVE.W	#1024-16*2,D0
icmloop:
	MOVE.W	2(A0,D0.W),D2
	AND.W	#$0FFF,D2
	AND.W	#$F000,$12(A0,D0.W)
	OR.W	D2,$12(A0,D0.W)
	SUB.W	#$0010,D0
	CMP.W	D1,D0
	BGE.S	icmloop
icmskip:
	MOVEQ	#1,D2
	AND.W	#$F000,2(A0,D1.W)
	RTS

;********************************
DelNotePattern:
	BSR.W	SaveUndo
	MOVEQ	#0,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#6,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#12,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#18,D0
	CALL	GetPositionPtr
	BSR.S	dnt

	chn8test
	BNE.W	intskip

	MOVEQ	#24,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#30,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#36,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	MOVEQ	#42,D0
	CALL	GetPositionPtr
	BSR.S	dnt
	BRA.W	intskip

;********************************
DelNoteTrack:
	BSR.W	SaveUndo
	BSR.S	dnt
	BRA.W	intskip

dnt:	MOVE.W	ScrPattPos,D0
	BNE.S	.now
	RTS

.now:	SUBQ.W	#1,D0
	LSL.W	#4,D0

.loop:
	MOVE.L	$10(A0,D0.W),0(A0,D0.W)
	ADD.W	#$0010,D0

	chn8test
	BNE.S	.chn4

	ADD.W	#$10,D0
	CMP.W	#2048,D0
	BCS.S	.loop
	MOVE.W	#2048-32,D1
	MOVEQ	#-1,D2
	CLR.L	0(A0,D1.W)
	RTS
.chn4:
	CMP.W	#1024,D0
	BCS.S	.loop
	MOVE.W	#$03F0,D1
	MOVEQ	#-1,D2
	CLR.L	0(A0,D1.W)
	RTS

;********************************
DelCMDTrack:
	CLR.B	RawKeyCode
	BSR.W	SaveUndo
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.S	.doit
	BRA.W	intskip

.doit:	MOVE.W	ScrPattPos,D0
	BNE.S	.skip
	RTS

.skip:	SUBQ.W	#1,D0
	LSL.W	#4,D0

.loop:
	MOVE.W	$12(A0,D0.W),D2
	AND.W	#$0FFF,D2
	AND.W	#$F000,2(A0,D0.W)
	OR.W	D2,2(A0,D0.W)
	ADD.W	#$0010,D0

	chn8test
	BNE.S	.chn4

	ADD.W	#$10,D0
	CMP.W	#2048,D0
	BCS.S	.loop
	MOVE.W	#2048-32,D1
	MOVEQ	#-1,D2
	AND.W	#$F000,2(A0,D1.W)
	RTS
.chn4:
	CMP.W	#$0400,D0
	BCS.S	.loop
	MOVE.W	#$03F0,D1
	MOVEQ	#-1,D2
	AND.W	#$F000,2(A0,D1.W)
	RTS

;********************************
CutCmds:
	BSR.W	SaveUndo
	LEA	CmdsBuffer,A1
	MOVEQ	#0,D0
.loop:
	MOVE.L	0(A0,D0.W),(A1)+
	AND.L	#$FFFFF000,0(A0,D0.W)
	ADD.W	#$0010,D0

	chn8test
	BNE.S	.chn4
	ADD.W	#$10,D0
	CMP.W	#2048,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern

.chn4:	CMP.W	#$0400,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern
;********************************
CopyCmds:
	LEA	CmdsBuffer,A1
	CLR.W	D0

.loop:
	MOVE.L	0(A0,D0.W),(A1)+
	ADD.W	#$0010,D0

	chn8test
	BNE.S	.chn4
	ADD.W	#$10,D0
	CMP.W	#2048,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	RTS

.chn4:	CMP.W	#$0400,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	RTS

;********************************
PasteCmds:
	BSR.W	SaveUndo
	LEA	CmdsBuffer,A1
	MOVEQ	#0,D0
.loop:
	MOVE.L	0(A0,D0.W),D1
	AND.L	#$FFFFF000,D1
	MOVE.L	(A1)+,D2
	AND.L	#$00000FFF,D2
	OR.L	D2,D1
	MOVE.L	D1,0(A0,D0.W)
	ADD.W	#$0010,D0

	chn8test
	BNE.S	.chn4

	ADD.W	#$10,D0
	CMP.W	#2048,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern
.chn4:
	CMP.W	#1024,D0
	BNE.S	.loop
	CLR.B	RawKeyCode
	GOTO	RedrawPattern

;********************************
SwapTrack:
	CLR.B	RawKeyCode
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	LEA	SwapTrackText,A0

	chn8test
	BNE.S	.chn4
	LEA	SwapTrackText8,A0

.chn4:	CALL	ShowStatusText

.loop1:	BSR.W	GetHexKey
	TST.B	D1
	BEQ.W	swtabor

	chn8test
	BNE.S	.chn42

	CMP.B	#8,D1
	BHI.S	.loop1
	BRA.S	.chn8_3

.chn42:	CMP.B	#4,D1
	BHI.S	.loop1

.chn8_3:
	BSR.W	SaveUndo
	SUBQ.L	#1,D1
	LSL.L	#2,D1
	MOVE.L	D1,D0
	MOVE.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D1
	LSL.L	#8,D1
	LSL.L	#2,D1

	chn8test
	BNE.S	.chn8_1
	LSL.L	#1,D1

.chn8_1:
	ADD.L	D1,A0
	MOVE.L	A0,A1
	ADD.L	D0,A0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	AND.L	#15,D0
	LSL.L	#2,D0
	ADD.L	D0,A1
	MOVEQ	#63,D1

.loop:
	MOVE.L	(A0),D0
	MOVE.L	(A1),(A0)
	MOVE.L	D0,(A1)

	chn8test
	BNE.S	.chn41

	LEA	$0020(A0),A0
	LEA	$0020(A1),A1
	DBRA	D1,.loop
	CALL	RedrawPattern
	BRA.S	swtabor

.chn41:
	LEA	$0010(A0),A0
	LEA	$0010(A1),A1
	DBRA	D1,.chn41
	CALL	RedrawPattern
swtabor:
	CALL	ShowAllRight
	BRA.W	RestorePtrCol

;********************************

SwapTrackText:		dc.b	'SWAP TRACK (1/2/3/4)',0,0
SwapTrackText8: 	dc.b	'SWAP (1/2/3/4/5/6/7/8)',0,0
BlockMarkText:		dc.b	'MARK BLOCK 00-00',0,0
Youhaventmark.MSG:	dc.b	'MARK ANY BLOCK!',0
BufEmptyText:		dc.b	'THE BUFFER IS EMPTY!',0,0
CommandStoredText:	dc.b	'COMMAND STORED!',0
selectnote.MSG: 	dc.b	'SELECT NOTE',0
helpselected.MSG:	dc.b	'* HELP SELECTED *',0
plstselected.MSG:	dc.b	'* PLST SELECTED *',0
NoHelpFile.MSG:		dc.b	'CAN''T OPEN HELPFILE',0
pthelpfilename: 	dc.b	'S:PT.help',0
NormalPlayText: 	dc.b	'PLAY MODULE...',0,0
NormalPattText: 	dc.b	'PLAY PATTERN...',0
NormalRecText:		dc.b	'NORMAL RECORD...',0,0
stopped.MSG:		dc.b	'STOPPED...',0,0
recready.MSG:		dc.b	'RECORD READY...',0

HelpPage:		dc.w	1
PLSTHelpFlag:		dc.b	0,0
SaveInstr:		dc.w	0
BlockFromPos:		dc.w	0
BlockToPos:		dc.w	0
BlockMarkFlag:		dc.w	0
BlockBufferFlag:	dc.w	0
JoinPasteFlag:		dc.w	0
PolyPasteFlag:		dc.w	0
BuffFromPos:		dc.w	0
BuffToPos:		dc.w	0

F6Pos:		dc.w	0
F7Pos:		dc.w	16
F8Pos:		dc.w	32
F9Pos:		dc.w	48
F10Pos: 	dc.w	63

;********************************
BeginBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.S	bgbskip
blkunma:
	CLR.W	BlockMarkFlag
	GOTO	ShowAllRight

bgbskip:
	MOVE.W	#1,BlockMarkFlag
	MOVE.W	ScrPattPos,BlockFromPos
	MOVE.W	ScrPattPos,BlockToPos

;********************************
ShowBlockPos:
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	.doit
	EXG	D0,D1
.doit:
	LEA	BlockMarkText+12(PC),A0
	BSR.S	.InTo2DecAscii
	LEA	BlockMarkText+15(PC),A0
	MOVE.W	D1,D0
	BSR.S	.InTo2DecAscii
	LEA	BlockMarkText(PC),A0
	GOTO	ShowStatusText

.InTo2DecAscii:
	AND.L	#$000000FF,D0
	DIVU	#10,D0
	ADD.B	#$30,D0
	MOVE.B	D0,-1(A0)
	SWAP	D0
	ADD.B	#$30,D0
	MOVE.B	D0,(A0)
	RTS

;********************************
Re_MarkBlock:
	CLR.B	RawKeyCode
	MOVE.W	#1,BlockMarkFlag
	MOVE.W	BlockToPos,ScrPattPos
	BSR.W	SetScrPatternPos
	BRA.S	ShowBlockPos

;********************************
CheckBlockPos:
	TST.W	BlockMarkFlag
	BNE.S	.doit
	RTS

.doit:
	MOVE.W	ScrPattPos,D0
	CMP.W	BlockToPos,D0
	BNE.S	.doit1
	RTS

.doit1:
	MOVE.W	D0,BlockToPos
	BRA	ShowBlockPos

;********************************
CutBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError
	BSR.S	cobldo
	MOVE.W	#1,BlockMarkFlag
	BRA.W	ClearBlock

;********************************
CopyBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError

cobldo:
	CLR.W	BlockMarkFlag
	MOVE.W	#1,BlockBufferFlag
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	LEA	BlockBuffer,A1
	MOVEQ	#MaxPattPos,D0
cobllop:
	MOVE.L	(A0),(A1)
	LEA	$0010(A0),A0
	LEA	$0010(A1),A1
	DBRA	D0,cobllop
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	coblskp
	EXG	D0,D1
coblskp:
	MOVE.W	D0,BuffFromPos
	MOVE.W	D1,BuffToPos
	GOTO	ShowAllRight

;********************************
PasteBlock:
	CLR.B	RawKeyCode
	TST.W	BlockBufferFlag
	BEQ.W	BufferError
	BSR.W	SaveUndo
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	LEA	BlockBuffer,A1
	MOVE.W	BuffFromPos,D0
	MOVE.W	BuffToPos,D1
	MOVE.W	ScrPattPos,D2
	LSL.W	#4,D0
	LSL.W	#4,D1
	LSL.W	#4,D2
pabllop:
	MOVE.L	0(A1,D0.W),D3
	TST.W	JoinPasteFlag
	BEQ.S	pablskp
	MOVE.L	D3,D4
	AND.L	#$FFFFF000,D4
	BNE.S	pablskp
	MOVE.L	0(A0,D2.W),D4
	AND.L	#$FFFFF000,D4
	AND.L	#$00000FFF,D3
	OR.L	D4,D3
pablskp:
	MOVE.L	D3,0(A0,D2.W)
	CMP.W	D0,D1
	BEQ.S	pablend
	CMP.W	#1008,D0
	BEQ.S	pablend
	CMP.W	#1008,D2
	BEQ.S	pablend
	ADD.W	#16,D0
	ADD.W	#16,D2
	TST.W	PolyPasteFlag
	BEQ.S	pabllop
	MOVEM.L D0-D2/A1,-(SP)
	BSR.W	GotoNextMulti
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVEM.L (SP)+,D0-D2/A1
	BRA.S	pabllop

pablend:
	CLR.W	JoinPasteFlag
	CLR.W	PolyPasteFlag
	CALL	ShowAllRight
	CALL	RedrawPattern
	TST.B	ShiftKeyStatus
	BEQ.S	pablend2
	RTS

pablend2:
	MOVE.W	BuffToPos,D0
	SUB.W	BuffFromPos,D0
	ADDQ.W	#1,D0
	ADD.W	ScrPattPos,D0

	CMP.W	#63,D0
	BLS.S	pablset
	MOVEQ	#0,D0
pablset:
	MOVE.W	D0,ScrPattPos
	BRA.W	SetScrPatternPos

;********************************
PolyphonizeBlock:
	CLR.B	RawKeyCode
	MOVE.W	#1,PolyPasteFlag
JoinPasteBlock:
	CLR.B	RawKeyCode
	MOVE.W	#1,JoinPasteFlag
	BRA.W	PasteBlock

InsertBlock:
	CLR.B	RawKeyCode
	TST.W	BlockBufferFlag
	BEQ.W	BufferError

	CMP.W	#63,ScrPattPos
	BEQ.W	PasteBlock
	MOVE.W	BuffToPos,D0
	SUB.W	BuffFromPos,D0
inbllop:
	MOVE.L	D0,-(SP)
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.W	inotr
	MOVE.L	(SP)+,D0
	DBRA	D0,inbllop
	BRA.W	PasteBlock

;********************************
DeleteBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError
	BSR.W	SaveUndo
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	deblskp
	EXG	D0,D1
deblskp:
	CMP.W	#63,D1
	BEQ.S	ClearBlock
	CLR.W	BlockMarkFlag
	MOVE.W	D0,ScrPattPos
	ADDQ.W	#1,ScrPattPos
	SUB.W	D0,D1
	MOVE.W	D1,D0
debllop:
	MOVE.L	D0,-(SP)
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.W	dnt
	MOVE.L	(SP)+,D0
	DBRA	D0,debllop
	SUBQ.W	#1,ScrPattPos
	CALL	ShowAllRight
	GOTO	RedrawPattern

;********************************
ClearBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError
	BSR.W	SaveUndo
	CLR.W	BlockMarkFlag
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	clbllskp
	EXG	D0,D1
clbllskp:
	LSL.W	#4,D0
	LSL.W	#4,D1
	MOVEQ	#0,D2
clbllop:
	MOVE.L	D2,0(A0,D0.W)
	CMP.W	D0,D1
	BEQ.S	clblend
	ADD.W	#$0010,D0
	BRA.S	clbllop

clblend:
	CALL	ShowAllRight
	GOTO	RedrawPattern

;********************************
BackwardsBlock:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError
	BSR.W	SaveUndo
	CLR.W	BlockMarkFlag
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	bablskp
	EXG	D0,D1
bablskp:
	LSL.W	#4,D0
	LSL.W	#4,D1
babllop:
	MOVE.L	0(A0,D0.W),D2
	MOVE.L	0(A0,D1.W),0(A0,D0.W)
	MOVE.L	D2,0(A0,D1.W)
	CMP.W	D1,D0
	BCC.S	bablend
	ADD.W	#$0010,D0
	SUB.W	#$0010,D1
	CMP.W	D1,D0
	BCC.S	bablend
	BRA.S	babllop

bablend:
	CALL	ShowAllRight
	GOTO	RedrawPattern

;********************************
TransBlockUp:
	CLR.B	RawKeyCode
	SF	trblflag
	BRA.S	trbldo


;********************************
TransBlockDown:
	ST	trblflag
trbldo:
	CLR.B	RawKeyCode
	TST.W	BlockMarkFlag
	BEQ.W	BlockError
	BSR.W	SaveUndo
	MOVE.W	#2,NoteShift
	MOVE.W	BlockFromPos,D0
	MOVE.W	BlockToPos,D1
	CMP.W	D0,D1
	BCC.S	trblskp
	EXG	D0,D1
trblskp:
	MOVE.W	D0,D5
	LSL.W	#4,D5
	SUB.W	D0,D1
	MOVE.W	D1,D6
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	LEA	0(A0,D5.W),A3
	MOVEQ	#0,D3
	MOVE.B	SampleAllFlag,sampallsave
	ST	SampleAllFlag
	TST.B	trblflag
	BEQ.S	trblup
	CALL	sandlo2
	MOVE.B	sampallsave,SampleAllFlag
	GOTO	RedrawPattern
trblup:
	CALL	sanulo2
	MOVE.B	sampallsave,SampleAllFlag
	GOTO	RedrawPattern

trblflag:	dc.b	0,0
sampallsave:	dc.b	0,0

;********************************
BlockError:
	LEA	Youhaventmark.MSG,A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol

BufferError:
	LEA	BufEmptyText,A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol

;********************************
ExpandTrack:
	CLR.B	RawKeyCode
	BSR.W	SaveUndo
	MOVE.W	ScrPattPos,PosSave
	ADDQ.W	#1,ScrPattPos
	CMP.W	#$0040,ScrPattPos
	BCC.S	extrend
extrlop:
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.W	inotr
	ADDQ.W	#2,ScrPattPos
	CMP.W	#64,ScrPattPos
	BCS.S	extrlop
extrend:
	MOVE.W	PosSave,ScrPattPos
	GOTO	RedrawPattern

;********************************
ContractTrack:
	CLR.B	RawKeyCode
	BSR.W	SaveUndo
	MOVE.W	ScrPattPos,PosSave
	ADDQ.W	#1,ScrPattPos
	CMP.W	#64,ScrPattPos
	BCC.S	cotrend
cotrlop:
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	BSR.W	dnt
	ADDQ.W	#1,ScrPattPos
	CMP.W	#64,ScrPattPos
	BCS.S	cotrlop
cotrend:
	MOVE.W	PosSave,ScrPattPos
	GOTO	RedrawPattern

PosSave:	dc.w	0

;********************************
KillEndOfTrack:
	CLR.B	RawKeyCode
	BSR.B	SaveUndo
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.W	ScrPattPos,D0
	MOVE.W	D0,D1
	;MULU	 #$0010,D1
	LSL.L	#4,D1			;orgmulu
	LEA	0(A0,D1.W),A0
	TST.B	ShiftKeyStatus
	BNE.S	KillToStart
kteot:
	CLR.L	(A0)
	LEA	$0010(A0),A0
	ADDQ.W	#1,D0
	CMP.W	#$0040,D0
	BCS.S	kteot
	GOTO	RedrawPattern

KillToStart:
	CLR.L	(A0)
	LEA	-$0010(A0),A0
	TST.W	D0
	BNE.S	KillToStart2
	GOTO	RedrawPattern

KillToStart2:
	SUBQ.W	#1,D0
	BRA.S	KillToStart

;********************************
UndoLastChange:
	CLR.B	RawKeyCode
	MOVEQ	#0,D0
	CALL	GetPositionPtr
	LEA	UndoBuffer,A1
	MOVE.W	#255,D0
unlalop:
	MOVE.L	(A1),D1
	MOVE.L	(A0),(A1)+
	MOVE.L	D1,(A0)+
	DBRA	D0,unlalop
	GOTO	RedrawPattern

;********************************
SaveUndo:
	MOVEM.L D0/A0/A1,-(SP)
	MOVEQ	#0,D0
	CALL	GetPositionPtr
	LEA	UndoBuffer,A1
	MOVE.W	#255,D0
saunlop:
	MOVE.L	(A0)+,(A1)+
	DBRA	D0,saunlop
	MOVEM.L (SP)+,D0/A0/A1
	RTS

;********************************
BoostAll:
	CLR.B	RawKeyCode
	LEA	BoostAllText,A0
	BSR.W	AreYouSure
	BNE.W	SetErrorPtrCol
	MOVE.W	InsNum,SaveInstr
	MOVE.W	#1,InsNum
.l1:
	CALL	ShowSampleInfo
	CALL	Boost
	ADDQ.W	#1,InsNum
	CMP.W	#MaxInsNum+1,InsNum
	BCS.S	.l1

	MOVE.W	SaveInstr,InsNum
	GOTO	ShowSampleInfo

;********************************
FilterAll:
	;CLR.B	RawKeyCode
	LEA	FilterAllText,A0
	BSR.W	AreYouSure
	BNE.W	SetErrorPtrCol
	MOVE.W	InsNum,SaveInstr
	MOVE.W	#1,InsNum

.l1:	CALL	ShowSampleInfo
	CALL	Filter2
	ADDQ.W	#1,InsNum
	CMP.W	#MaxInsNum+1,InsNum
	BCS.S	.l1

	MOVE.W	SaveInstr,InsNum
	GOTO	ShowSampleInfo


;********************************
;* check octave fkeys f1-f2     *
;********************************
CheckF1_F2:
	CMP.B	#$50,RawKeyCode
	BEQ.S	SetOctaveLow
	CMP.B	#$51,RawKeyCode
	BEQ.S	SetOctaveHigh
	RTS

SetOctaveLow:
	MOVE.L	#KbdTransTable1,KeyTransTabPtr
	CLR.B	RawKeyCode
	RTS

SetOctaveHigh:
	MOVE.L	#KbdTransTable2,KeyTransTabPtr
	CLR.B	RawKeyCode
	RTS

;**************************************
;* gets a 2 digit hex value from      *
;* the protracker screens	      *
;* input:  scrnkoordinates = TextValue*
;* output: D0                         *
;**************************************

; 1 x called from ShowTuneTone value
GetHexByte3:
	MOVE.W	#$FFFF,GtHxBytFlag
	MOVE.W	D0,GtHxBytNib1
	MOVE.W	D1,GtHxBytNib2
	BRA.S	GetHexByte2

; called from prefs ...
GetHexByte:
	CLR.W	GtHxBytFlag

GetHexByte2:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	MOVEQ	#0,D0
	MOVE.W	TextOffset,D0
	DIVU	#$0050,D0
	ADDQ.W	#5,D0
	MOVE.W	D0,LineCurY
	SWAP	D0
	LSL.W	#3,D0
	ADDQ.W	#4,D0
	MOVE.W	D0,LineCurX
	TST.W	GtHxBytFlag
	BEQ.S	GtHxBytPos
	MOVE.W	GtHxBytNib1(PC),D0
	ADDQ.W	#4,D0
	MOVE.W	D0,LineCurX
	MOVE.W	GtHxBytNib2(PC),D0
	ADDQ.W	#5,D0
	MOVE.W	D0,LineCurY
GtHxBytPos:
	BSR.W	UpdateLineCurPos
	BSR.B	GetHexKey
	MOVE.L	D1,D0
	MOVE.B	D1,D6
	LSL.B	#4,D6
	TST.W	GtHxBytFlag
	BEQ.S	GtHxByt3
	BSR.S	GtHxByt7
	BRA.S	GtHxByt4

GtHxByt3:
	CALL	PrintHexDigit
GtHxByt4:
	ADDQ.W	#8,LineCurX
	BSR.W	UpdateLineCurPos
	BSR.S	GetHexKey
	MOVE.L	D1,D0
	OR.B	D1,D6
	TST.W	GtHxBytFlag
	BEQ.S	GtHxByt5
	BSR.S	GtHxByt7
	BRA.S	GtHxByt6

GtHxByt5:
	CALL	PrintHexDigit
GtHxByt6:
	MOVE.W	#$FFF0,LineCurX
	CLR.W	LineCurY
	BSR.W	UpdateLineCurPos
	BSR.W	RestorePtrCol
	MOVEQ	#0,D0
	MOVE.B	D6,D0
	RTS

GtHxByt7:
	MOVEM.W D0/D1/D3,-(SP)
	MOVE.W	D0,D3
	MOVE.W	LineCurX,D0
	SUBQ.W	#4,D0
	MOVE.W	GtHxBytNib2(PC),D1
	CALL	ShowHexByte
	MOVEM.W (SP)+,D0/D1/D3
	RTS

;********************************
GetHexKey:
	BSR.W	ResetKeyTimer
	CLR.B	RepeatKey
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	checkrmb
	BEQ.S	ghkreturn
	BSR.W	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	MOVE.B	D0,RepeatKey
	BEQ.S	GetHexKey
	CMP.B	#$44,D0 		; ENTER
	BEQ.S	ghkreturn
	CMP.B	#$45,D0 		; ESC
	BEQ.S	ghkreturn
	CMP.B	#$4F,D0 		; <---
	BEQ.S	ghkleft
	CMP.B	#$4E,D0 		; --->
	BEQ.S	ghkright
	BSR.S	CheckHexKey
	CMP.B	#$10,D1
	BEQ.S	GetHexKey
	CLR.B	RawKeyCode
ghkreturn:
	MOVEQ	#0,D0
	RTS

ghkleft:
	MOVEQ	#-1,D0
	RTS

ghkright:
	MOVEQ	#1,D0
	RTS

CheckHexKey:
	LEA	RawKeyHexTable,A0
	MOVEQ	#0,D1
chxloop:
	CMP.B	(A0)+,D0
	BNE.S	chxret
	RTS
chxret: ADDQ.B	#1,D1
	CMP.B	#$10,D1
	BNE.S	chxloop
	RTS

GtHxBytFlag:	dc.w	0
GtHxBytNib1:	dc.w	0
GtHxBytNib2:	dc.w	0

;********************************
;* Enter Edit Commands (effects)*
;********************************
EditCommand:
	TST.L	EditMode
	BNE.S	.Edit
	RTS

.Edit:
	move.l	#'CHG!',changeflag
	MOVEQ	#0,D0
	MOVE.B	RawKeyCode,D0
	BSR.S	CheckHexKey
	CMP.B	#$10,D1
	BNE.S	.Edit1
	RTS

;*** Track1 ***

.Edit1:
	CMP.W	#1,PattCurPos			; Note
	BNE.S	.Pos1
	CMP.W	#1,D1
	BLS.S	.Pos0
	RTS

.Pos0:						; Sample 1
	MOVE.L	#$00000FFF,D2
	CLR.W	CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos1:						; Sample 2
	CMP.W	#2,PattCurPos
	BNE.S	.Pos2
	MOVE.L	#$00000FFF,D2
	MOVE.W	#2,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos2:						; Trash forgotten by CRB (3.15)
	;CMP.W	 #3,PattCurPos
	;BNE.S	 .Pos3
	;BRA.W	 UpdateCom2

.Pos3:						; Command Track 1
	CMP.W	#3,PattCurPos
	BNE.S	.Pos4
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#2,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos4:						; Command Data 1
	CMP.W	#4,PattCurPos
	BNE.S	.Pos5
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#2,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos5:						; Command Data 2
	CMP.W	#5,PattCurPos
	BNE.S	.Pos6
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#2,CmdOffset
	BRA.W	UpdateCommand

;*** Track2 ***

.Pos6:						; Note
	CMP.W	#7,PattCurPos
	BNE.S	.Pos8
	CMP.W	#1,D1
	BLS.S	.Pos7
	RTS

.Pos7:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#4,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos8:						; Sample 2
	CMP.W	#8,PattCurPos
	BNE.S	.Pos9
	MOVE.L	#$00000FFF,D2
	MOVE.W	#6,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos9:						; Trash
	;CMP.W	 #10,PattCurPos
	;BNE.S	 .Pos10
	;BRA.W	 UpdateCom2

.Pos10:						; Track2 Command 1.digit
	CMP.W	#9,PattCurPos
	BNE.S	.Pos11
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#6,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos11:						; Command data 1
	CMP.W	#10,PattCurPos
	BNE.S	.Pos12
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#6,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos12:						; Command Data 2
	CMP.W	#11,PattCurPos
	BNE.S	.Pos13
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#6,CmdOffset
	BRA.W	UpdateCommand


;*** Track3 ***

.Pos13:						; Note
	CMP.W	#13,PattCurPos
	BNE.S	.Pos15
	CMP.W	#1,D1
	BLS.S	.Pos14
	RTS

.Pos14:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#8,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos15:						; Sample 2
	CMP.W	#14,PattCurPos
	BNE.S	.Pos16
	MOVE.L	#$00000FFF,D2
	MOVE.W	#10,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos16:						; Trash
	;CMP.W	 #17,PattCurPos
	;BNE.S	 .Pos17
	;BRA.W	 UpdateCom2

.Pos17:						; Command
	CMP.W	#15,PattCurPos
	BNE.S	.Pos18
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#10,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos18:						; Command data 1
	CMP.W	#16,PattCurPos
	BNE.S	.Pos19
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#10,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos19:						; Command data 2
	CMP.W	#17,PattCurPos
	BNE.S	.Pos20
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#10,CmdOffset
	BRA.W	UpdateCommand

;*** Track4 ***

.Pos20:						; Note
	CMP.W	#19,PattCurPos
	BNE.S	.Pos22
	CMP.W	#1,D1
	BLS.S	.Pos21
	RTS

.Pos21:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#12,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos22:						; Sample 2
	CMP.W	#20,PattCurPos
	BNE.S	.Pos23
	MOVE.L	#$00000FFF,D2
	MOVE.W	#14,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos23:						; Trash
	;CMP.W	 #24,PattCurPos
	;BNE.S	 .Pos24
	;BRA.W	 UpdateCom2

.Pos24:						; Command
	CMP.W	#21,PattCurPos
	BNE.S	.Pos25
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#14,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos25:						; Command Data 1
	CMP.W	#22,PattCurPos
	BNE.S	.Pos26
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#14,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos26:						; Command Data 2
	CMP.W	#23,PattCurPos
	BNE.S	.chan8mode
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#14,CmdOffset
	BRA.W	UpdateCommand


.chan8mode:

	chn8test
	BEQ.S	.Pos27				; 8 channel mode ?
	RTS

;*** Track5 ***

.Pos27:
	CMP.W	#25,PattCurPos			; Note
	BNE.S	.Pos29
	CMP.W	#1,D1
	BLS.S	.Pos28
	RTS

.Pos28:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#16,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos29:						; Sample 2
	CMP.W	#26,PattCurPos
	BNE.S	.Pos30
	MOVE.L	#$00000FFF,D2
	MOVE.W	#18,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos30:						; Trash
	;CMP.W	 #3,PattCurPos
	;BNE.S	 .Pos31
	;BRA.W	 UpdateCom2

.Pos31:						; Command
	CMP.W	#27,PattCurPos
	BNE.S	.Pos32
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#18,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos32:						; Command Data 1
	CMP.W	#28,PattCurPos
	BNE.S	.Pos33
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#18,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos33:						; Command Data 2
	CMP.W	#29,PattCurPos
	BNE.S	.Pos34
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#18,CmdOffset
	BRA.W	UpdateCommand

;*** Track6 ***

.Pos34:						; Note
	CMP.W	#31,PattCurPos
	BNE.S	.Pos36
	CMP.W	#1,D1
	BLS.S	.Pos35
	RTS

.Pos35:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#20,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos36:						; Sample 2
	CMP.W	#32,PattCurPos
	BNE.S	.Pos37
	MOVE.L	#$00000FFF,D2
	MOVE.W	#22,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos37:						; Trash
	;CMP.W	 #10,PattCurPos
	;BNE.S	 .Pos38
	;BRA.W	 UpdateCom2

.Pos38:						; Command
	CMP.W	#33,PattCurPos
	BNE.S	.Pos39
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#22,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos39:						; Command data 1
	CMP.W	#34,PattCurPos
	BNE.S	.Pos40
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#22,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos40:						; Command Data 2
	CMP.W	#35,PattCurPos
	BNE.S	.Pos41
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#22,CmdOffset
	BRA.W	UpdateCommand

;*** Track7 ***

.Pos41:						; Note
	CMP.W	#37,PattCurPos
	BNE.S	.Pos43
	CMP.W	#1,D1
	BLS.S	.Pos42
	RTS

.Pos42:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#24,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos43:						; Sample 2
	CMP.W	#38,PattCurPos
	BNE.S	.Pos44
	MOVE.L	#$00000FFF,D2
	MOVE.W	#26,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos44:						; Trash
	;CMP.W	 #17,PattCurPos
	;BNE.S	 .Pos45
	;BRA.W	 UpdateCom2

.Pos45:						; Command
	CMP.W	#39,PattCurPos
	BNE.S	.Pos46
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#26,CmdOffset
	LSL.W	#8,D1
	BRA.W	UpdateCommand

.Pos46:						; Command data 1
	CMP.W	#40,PattCurPos
	BNE.S	.Pos47
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#26,CmdOffset
	LSL.W	#4,D1
	BRA.W	UpdateCommand

.Pos47:						; Command data 2
	CMP.W	#41,PattCurPos
	BNE.S	.Pos48
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#26,CmdOffset
	BRA.W	UpdateCommand

;*** Track8 ***

.Pos48:						; Note
	CMP.W	#43,PattCurPos
	BNE.S	.Pos50
	CMP.W	#1,D1
	BLS.S	.Pos49
	RTS

.Pos49:						; Sample 1
	MOVE.L	#$00000FFF,D2
	MOVE.W	#28,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.B	UpdateCommand

.Pos50:						; Sample 2
	CMP.W	#44,PattCurPos
	BNE.S	.Pos51
	MOVE.L	#$00000FFF,D2
	MOVE.W	#30,CmdOffset
	LSL.W	#4,D1
	LSL.W	#8,D1
	BRA.S	UpdateCommand

.Pos51:						; Trash
	;CMP.W	 #24,PattCurPos
	;BNE.S	 .Pos52
	;BRA.W	 UpdateCom2

.Pos52:						; Command
	CMP.W	#45,PattCurPos
	BNE.S	.Pos53
	MOVE.L	#$0000F0FF,D2
	MOVE.W	#30,CmdOffset
	LSL.W	#8,D1
	BRA.S	UpdateCommand

.Pos53:						; Command Data 1
	CMP.W	#46,PattCurPos
	BNE.S	.Pos54
	MOVE.L	#$0000FF0F,D2
	MOVE.W	#30,CmdOffset
	LSL.W	#4,D1
	BRA.S	UpdateCommand

.Pos54:						; Command data 2
	CMP.W	#47,PattCurPos
	BNE.S	.PosEnd
	MOVE.L	#$0000FFF0,D2
	MOVE.W	#30,CmdOffset
	BRA.S	UpdateCommand

.PosEnd:
	RTS

;*********************************
;* is called in editmode=on from *
;* the editcommand subroutine    *
;*********************************

UpdateCommand:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	ReBlitTrack
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D0
	LSL.L	#8,D0
	LSL.L	#2,D0

	chn8test
	BNE.S	.chn4
	LSL.L	#1,D0
.chn4:
	ADD.L	D0,A0
	MOVEQ	#0,D0
	MOVE.W	ScrPattPos,D0
	LSL.W	#4,D0

	chn8test
	BNE.S	.chn4_1
	LSL.W	#1,D0				;???

.chn4_1:
	EXT.L	D0
	ADD.L	D0,A0
	MOVE.L	A0,A1
	MOVEQ	#0,D0
	MOVE.W	CmdOffset,D0
	ADD.L	D0,A0
	AND.L	#$FFFFFFFC,D0
	ADD.L	D0,A1
	AND.W	D2,(A0)
	ADD.W	D1,(A0)
	MOVEQ	#0,D0
	MOVE.W	ScrPattPos,D0
	MULU	#640,D0
	MOVE.W	PattCurPos,D1
	DIVU	#6,D1
	MULU	#9,D1				;4=18

	chn8test
	BEQ.S	.chn8
	MULU	#2,D1
.chn8:
	ADD.L	D1,D0
	ADD.W	#$3CA6+1,D0

	chn8test
	BNE.S	.chn4_3
	SUBQ.W	#1,D0

.chn4_3:
	MOVE.W	D0,TextOffset
	MOVE.L	A1,A0
	CALL	RedrawNotes

UpdateCom2:
	BSR.W	EditMoveDown
	CLR.B	RawKeyCode
	RTS

;********************************
;* Store/Insert Effect Commands *
;********************************
CheckStoreEffect:
	;TST.B	ShiftKeyStatus
	;BNE.W	CtrlShiftKeys
	MOVEQ	#0,D0
	MOVE.B	RawKeyCode,D0
	BNE.S	.doit
	RTS

.doit:
	CMP.B	#70,D0
	BEQ.W	CheckKeyboard2
	CMP.B	#10,D0
	BLS.S	.doit1
	RTS

.doit1:
	SUBQ.B	#1,D0
	ADD.B	D0,D0
	MOVE.L	D0,D7
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.W	ScrPattPos,D0
	LSL.W	#4,D0
	LEA	0(A0,D0.W),A0
	MOVE.W	2(A0),D0
	AND.W	#$0FFF,D0
	LEA	EffectMacros,A0
	MOVE.W	D0,0(A0,D7.W)
	LEA	CommandStoredText,A0
	CALL	ShowStatusText
	BSR.W	WaitALittle
	GOTO	ShowAllRight

;********************************
CheckInsertEffect:
	CLR.W	InsEFX
	MOVEQ	#0,D0
	MOVE.B	RawKeyCode,D0
	BNE.S	.doit
	RTS

.doit:
	CMP.B	#$46,D0
	BEQ.W	CheckKeyboard2
	CMP.B	#11,D0
	BEQ.W	DecreaseEffect
	CMP.B	#12,D0
	BEQ.S	IncreaseEffect
	CMP.B	#13,D0
	BEQ.S	CopyEffect
	CMP.B	#10,D0
	BLS.S	CheckInsertEffect3
	RTS

CheckInsertEffect3:
	SUBQ.B	#1,D0
	ADD.B	D0,D0
	LEA	EffectMacros,A0
	MOVE.W	0(A0,D0.W),InsEFX
DoInsEffect:
	MOVE.B	#$46,RawKeyCode
	BRA.W	CheckNoteKeys

;********************************
GetLastEffect:
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.W	ScrPattPos,D0
	SUBQ.W	#1,D0
	AND.W	#MaxPattPos,D0
	LSL.W	#4,D0
	LEA	0(A0,D0.W),A0
	MOVE.W	2(A0),D0
	AND.W	#$0FFF,D0
	RTS

;********************************
CopyEffect:
	BSR.S	GetLastEffect
	MOVE.W	D0,InsEFX
	BRA.S	DoInsEffect


;********************************
IncreaseEffect:
	BSR.S	GetLastEffect
	MOVE.W	D0,D1
	AND.W	#$0F00,D1
	CMP.W	#$0E00,D1
	BEQ.S	IncECom
	ADDQ.B	#1,D0
	MOVE.W	D0,InsEFX
	BRA.S	DoInsEffect

;********************************
IncECom:
	MOVE.W	D0,D1
	ADDQ.B	#1,D1
	AND.B	#15,D1
	AND.W	#$0FF0,D0
	OR.B	D1,D0
	MOVE.W	D0,InsEFX
	BRA.S	DoInsEffect

;********************************
DecreaseEffect:
	BSR.S	GetLastEffect
	MOVE.W	D0,D1
	AND.W	#$0F00,D1
	CMP.W	#$0E00,D1
	BEQ.S	DecECom
	SUBQ.B	#1,D0
	MOVE.W	D0,InsEFX
	BRA.W	DoInsEffect

;********************************
DecECom:
	MOVE.W	D0,D1
	SUBQ.B	#1,D1
	AND.B	#15,D1
	AND.W	#$0FF0,D0
	OR.B	D1,D0
	MOVE.W	D0,InsEFX
	BRA.W	DoInsEffect

InsEFX: dc.w	0

;***********************************
;*-- Check Keyboard for notekeys --*
;* base keyboard noterequests etc. *
;***********************************
CheckKeyboard:
	TST.B	RawKeyCode
	BEQ.S	kbdskip
	TST.W	LeftAmigaStatus
	BNE.S	kbdskip
	TST.W	CtrlKeyStatus
	BNE.S	kbdskip

	TST.B	ShiftKeyStatus
	BNE.W	CheckStoreEffect
	TST.W	AltKeyStatus
	BNE.W	CheckInsertEffect

CheckKeyboard2:
	MOVE.W	PattCurPos,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#6,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#12,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#18,D0
	BEQ.W	CheckNoteKeys

	chn8test
	BNE.S	.chn4

	CMP.W	#24,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#30,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#36,D0
	BEQ.W	CheckNoteKeys
	CMP.W	#42,D0
	BEQ.W	CheckNoteKeys

.chn4:	TST.L	EditMode
	BNE.W	EditCommand		; edit mode on, insert note, cmds ...
kbdskip:
	RTS

CtrlShiftKeys:
	MOVE.B	RawKeyCode,D0
	BEQ.B	.skip
	CMP.B	#7,D0
	BHI.B	.skip

	CMP.W	#1,CurrScreen
	BEQ.B	.dooptk
	CMP.W	#2,CurrScreen
	BEQ.B	.dooptk
	CMP.W	#9,CurrScreen
	BEQ.B	.dooptk

.skip:	RTS

.dooptk:
	BSR.W	ClearAllKeys
	CMP.B	#1,D0
	BNE.S	.skip0
	GOTO	EditOptions
.skip0:
	CMP.B	#2,D0
	bne.s	.skip1
	GOTO	SampleOptions

.skip1:
	CMP.B	#3,D0
	BNE.B	.skip2
	GOTO	ChordEditor

.skip2:
	CMP.B	#4,D0
	BNE.B	.skip3
	GOTO	FilterEditor

.skip3:
	CMP.B	#5,D0
	BNE.B	.skip4
	GOTO	Opt5RotChk

.skip4:
	CMP.B	#6,D0
	BNE.S	.skip5
	GOTO	Reserved2
.skip5:
	CMP.B	#7,D0
	BNE.S	.skip6
	GOTO	OptionCommands7
.skip6:
	RTS

;********************************
;* notekey tests keyboard       *
;********************************
CheckNoteKeys:
	LEA	RawKeyScaleTable,A0
	MOVE.B	RawKeyCode,D1
	MOVEQ	#38,D0				; 38 notes
.loo:
	CMP.B	0(A0,D0.W),D1
	BEQ.S	NoteKeyPressed
	DBRA	D0,.loo
	RTS

NoteKeyPressed:
	CLR.B	RawKeyCode
	MOVE.L	KeyTransTabPtr,A1
	MOVE.B	0(A1,D0.W),D0
	CMP.W	#36,D0
	BCC.S	nkpskip
	MOVE.L	SplitAddress,D1
	BEQ.S	nkpskip
	CLR.L	SplitAddress
	MOVE.L	D1,A0
	MOVE.B	D0,(A0)
	MOVE.W	SamNotetype,D1
	BEQ.W	ShowSplit
	CLR.W	SamNotetype
	AND.W	#$00FF,D0
	MOVE.W	D0,(A0)

	CMP.W	#1,D1
	BNE.S	n_norsa
	GOTO	ShowSamNote
n_norsa:
	CMP.W	#2,D1
	BNE.S	m_norsm
	GOTO	ShowResamNote
m_norsm:
	CMP.W	#3,D1
	BEQ.W	ShowS2TuneNote
	CMP.W	#4,d1
	BNE.S	m_norsv
	GOTO     ShowModSampleNote
m_norsv:
	GOTO	ShowAllRight

;********************************

nkpskip:
	MOVE.W	InsNum,PlayInsNum
	BTST	#4,CutToBufFlag
	BEQ.S	nkpskip2
	LEA	SplitInstrTable,A1
	MOVE.B	0(A1,D0.W),D1
	BEQ.S	nkpskip3
	MOVE.B	D1,PlayInsNum+1


nkpskip3:
	LEA	SplitTransTable,A1
	MOVE.B	0(A1,D0.W),D0
nkpskip2:
	MOVEQ	#0,D2

;--------- note in D0 -----------
playtheinstr:
	LEA	mt_periodtable,A1 	;note in d0 here
	MOVE.L	D0,D4
	LSL.W	#1,D0
	MOVEQ	#0,D3
	MOVE.W	0(A1,D0.W),D3
	MOVE.L	mt_songdataptr,A0	;fixes finetune
	LEA	14(A0),A0
	MOVE.W	InsNum,D1
	BNE.S	nkpskipit
	MOVE.W	LastInsNum,D1
nkpskipit:
	MULU	#30,D1
	ADD.L	D1,A0
	MOVEQ	#0,D1
	MOVE.B	(A0),D1 		;get finetune
	AND.B	#15,D1
	MULU	#$004A,D1		;37*2
	ADD.L	D1,A1
	MOVE.W	0(A1,D0.W),CurrentPlayNote
	TST.L	D2
	BEQ.S	nkpnrml
	CMP.B	#2,pnoteflag
	BNE.W	entpskip
nkpnrml:
	TST.L	EditMode
	BEQ.W	entpskip

	MOVEM.L D0-D7/A0-A6,-(SP)	;V3
	BSR.W	ReBlitTrack
	MOVEM.L (SP)+,D0-D7/A0-A6

AddNoteToPattern:
	move.l	#'CHG!',changeflag

	MOVE.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0	;Find first pattern
	MOVE.L	PatternNumber,D0
	LSL.L	#8,D0
	LSL.L	#2,D0

	chn8test
	BNE.S	.chn4
	LSL.L	#1,D0

.chn4:	ADD.L	D0,A0			;Find current pattern
	MOVEQ	#0,D0
	MOVE.W	ScrPattPos,D0
	BSR.W	QuantizeCheck
	LSL.W	#4,D0

	chn8test
	BNE.S	.chn41
	LSL.W	#1,D0

.chn41:	EXT.L	D0
	ADD.L	D0,A0			;find current pos
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	LSL.W	#2,D0
	EXT.L	D0
	ADD.L	D0,A0			;find current channel
	TST.W	AltKeyStatus
	BEQ.S	antpsks
	AND.L	#$FFFFF000,(A0)
	MOVE.W	InsEFX,D0
	OR.W	D0,2(A0)
	BRA.S	antp3

antpsks:
	TST.B	ShiftKeyStatus
	BEQ.S	antpskip2
	CLR.L	(A0)
antpskip2:
	MOVE.W	D3,(A0) 		;put note into pattern

	BEQ.S	antp2
	TST.B	AutoInsFlag
	BEQ.S	antp4
	MOVE.W	VolumeEfx,2(A0)
antp4:	MOVEQ	#0,D0
	MOVE.W	PlayInsNum,D0
	LSL.W	#4,D0
	AND.B	#15,2(A0)

	ADD.B	D0,2(A0)
	LSL.W	#4,D0
	AND.W	#$F000,D0
	OR.W	D0,(A0)
	BRA.S	antp3

antp2:	AND.W	#$0FFF,2(A0)

antp3:	MOVE.W	2(A0),CurrCmds
	MOVEQ	#0,D0
	MOVE.W	ScrPattPos,D0

	BSR.W	QuantizeCheck

	MULU	#640,D0
	MOVEQ	#0,D1
	MOVE.W	PattCurPos,D1

	DIVU	#6,D1
	MULU	#9,D1			;4=18

	chn8test
	BEQ.S	.chn8
	mulu	#2,D1

.chn8:	ADD.L	D1,D0
	ADD.W	#15526+1,D0

	chn8test
	BNE.S	.chn4
	SUBQ.W	#1,D0 			;1 scrpos left

.chn4:	MOVE.W	D0,TextOffset
	CALL	RedrawNotes
	BSR.W	EditMoveDown	;set propscroller
entpskip:
	TST.W	DidQuantize
	BNE.S	testmul
	TST.W	CurrentPlayNote
	BNE.W	PlayNote
testmul:
	TST.B	MultiFlag
	BNE.S	GotoNextMulti
	RTS

GotoNextMulti:				;ctrl-m yes => goto next trackpos
	MOVEQ	#0,D0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	LEA	MultiModeNext,A0
	MOVE.B	0(A0,D0.W),D0
	SUBQ.W	#1,D0
	AND.W	#3,D0
	MULU	#6,D0
	MOVE.W	D0,PattCurPos
	BRA.W	UpdateCursorPos

;********************************

QuantizeCheck:
	TST.L	RunMode
	BEQ.S	qcend
	MOVEQ	#0,D1
	MOVE.B	QuantizeValue,D1
	BEQ.S	qcend
	CMP.W	#1,D1
	BEQ.S	QuanOne
	MOVE.W	#1,DidQuantize
	MOVE.L	D1,D2
	LSR.W	#1,D2
	ADD.W	D0,D2
	AND.W	#MaxPattPos,D2
	DIVU	D1,D2
	MULU	D1,D2
	CMP.W	D0,D2
	BHI.S	qcskip
	CLR.W	DidQuantize
qcskip:
	MOVE.W	D2,D0
	RTS


;********************************

QuanOne:
	MOVE.L	mt_speed,D1
	LSR.L	#1,D1
	CMP.L	mt_counter,D1
	BLS.S	QuantToNextNote
qcend:
	CLR.W	DidQuantize
	RTS

QuantToNextNote:
	ADDQ.W	#1,D0
	AND.W	#MaxPattPos,D0
	MOVE.W	#1,DidQuantize
	RTS

;********************************
;* play note sound if keypress  *
;********************************

PlayNote:
	MOVE.W	PlayInsNum,D0
	BNE.S	.doit
	MOVE.W	InsNum,D0
	BEQ.S	DoPlayNote
.doit:
	;MOVEM.L D1,-(SP)

	MOVE.L  mt_mxbuf4base,D1	; the fix 4.01!

	;BTST    D0,D1
	;MOVEM.L (SP)+,D1
	;SNE	D1

	chn8test
	bne.s	.chn4
	moveq	#3*6,d7			;8-1*6 8 channels
	moveq	#3,d0
	LEA	audchan4temp,A4		;cludge
	LEA	AUD3,A5
	bra.s	.loop

.chn4:	MOVEQ	#3*6,D7
	MOVEQ	#3,D0			; 4 real audiochannels
	LEA	audchan4temp,A4
	LEA	AUD3,A5

.loop:	CMP.W	PattCurPos,D7
	BEQ.S	nplaynote
	SUBQ.W	#6,D7			; cursorpos
	LEA	-$0058(A4),A4		; audchan4temp/audchan8temp


	LEA	-$0010(A5),A5		;aud0-aud3, hardware !!!

	subq.w	#1,d0
	BGE.S	.loop
	RTS

;*********************************
;* 1x called from PlayNote       *
;* Plays note if key is pressed  *
;*********************************
nplaynote:
	TST.B	D1
	BEQ.S	DoPlayNote
	MOVE.W	InsNum,D1
	MOVE.W	#$4000,INTENA
	BSR.W	mt_nsetplaynote
	BRA.W	mt_zsetpnote

DoPlayNote:
	MOVE.W	#$4000,INTENA
	LEA	SampleInfo,A6
	MOVE.W	PlayInsNum,D0
	BEQ.S	dpnplay
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	mt_songdataptr,A0
	MOVE.L	0(A0,D0.W),si_pointer2
	LEA	SampleInfo2,A6
	MOVE.L	mt_songdataptr,A0
	LEA	-10(A0),A0
	MOVE.W	PlayInsNum,D0
	MOVE.B	D0,PlayInsNum2
	MULU	#$001E,D0
	ADD.L	D0,A0
	MOVE.L	22(A0),SampleInfo2
	MOVE.L	26(A0),si_long2
dpnplay:
	MOVE.B	PlayInsNum2,$002B(A4)
	MOVE.W	6(A6),D2
	MOVE.W	D2,14(A4)

	MOVE.W	4(A6),D0		; repeat
	MOVEQ	#0,D1
	MOVE.W	D0,D1
	BNE.S	dpn2
	MOVE.W	(A6),D0 		; length
	BRA.S	dpn3

dpn2:	ADD.W	D2,D0			; add replen
dpn3:	MOVE.W	D0,8(A4)
	BNE.S	dpn4
	MOVE.W	#1,8(A4)		; set volume

	LEA	PTBitMap+ScopeBoxPos,A0
	MOVE.L	A0,4(A4)
	MOVE.L	A0,10(A4)
	BRA.S	dpn5

dpn4:	ADD.L	D1,D1
	MOVE.L	8(A6),D0
	ADD.L	D0,D1
	MOVE.L	D1,10(A4)
	ADD.L	StartOfs,D0
	MOVE.L	D0,4(A4)
dpn5:	CLR.L	StartOfs
	MOVEQ	#0,D1
	MOVE.B	3(A6),D1
	MOVE.B	D1,$0013(A4)			; set volume
	MOVE.W	CurrentPlayNote,$0010(A4)	; set period
	ST	$0038(A4)
	CLR.W	$003A(A4)
	SF	$0036(A4)
	LEA	fogvalue,A0
	MOVE.L	4(A4),(A0)+
	MOVE.W	8(A4),(A0)+
	SUBQ.W	#6,A0
	BSR.S	dmascan
	ST	$002A(A4)
	BRA.W	testmul 			; redraw finnish

dmascan:
	LEA	BLTDDAT,A6			; Channel DMA
	MOVE.W	2(A6),D0
	MOVE.W	$0056(A4),D1
	BTST	D1,D0
	BNE.S	dmascan2
	MOVE.W	$0052(A4),$009A(A6)
	MOVE.W	$0052(A4),$009C(A6)
	MOVE.W	#1,6(A5)
	MOVE.L	(A0)+,0(A5)
	MOVE.W	(A0),4(A5)
	MOVE.W	#0,10(A5)
	BRA.S	dmascan4

dmascan2:
	MOVE.W	$0052(A4),$009A(A6)
	MOVE.W	$0052(A4),$009C(A6)
	MOVE.W	$004E(A4),$0096(A6)
	MOVE.W	#1,6(A5)
	BRA.W	.dmako			;useless

.dmako:
	MOVE.L	(A0)+,0(A5)
	MOVE.W	(A0),4(A5)
	MOVE.W	#0,8(A5)
dmascan4:
	MOVE.W	#$C000,$009A(A6)
	MOVE.W	$0054(A4),$009A(A6)
	RTS

PlayInsNum2:	dc.b	0,0
fogvalue:	dc.l	0
		dc.w	0

;********************************
dmafog1:	MOVE.L	D0,-(SP)

.loop:		MOVE.B	VHPOSR+1,D0

.loop2:		CMP.B	VHPOSR+1,D0
		BEQ.S	.loop2
		DBRA	D1,.loop

		MOVE.L	(SP)+,D0
		RTS

;********************************
;* called from  pt mainloop     *
;********************************
intdrweb:
	LEA	mt_mxbuf4chan,A1
	LEA	Allchantempis,A0
	MOVE.L	(A0)+,A2

	MOVE.W	#1,$004E(A2)
	MOVE.W	#$8001,$0050(A2)
	MOVE.W	#$0080,$0052(A2)
	MOVE.W	#$8080,$0054(A2)
	MOVE.L	(A1)+,$003C(A2)
	MOVE.W	#0,$0056(A2)
	MOVE.L	(A0)+,A2

	MOVE.W	#2,$004E(A2)
	MOVE.W	#$8002,$0050(A2)
	MOVE.W	#$0100,$0052(A2)
	MOVE.W	#$8100,$0054(A2)
	MOVE.L	(A1)+,$003C(A2)
	MOVE.W	#1,$0056(A2)
	MOVE.L	(A0)+,A2

	MOVE.W	#4,$004E(A2)
	MOVE.W	#$8004,$0050(A2)
	MOVE.W	#$0200,$0052(A2)
	MOVE.W	#$8200,$0054(A2)
	MOVE.L	(A1)+,$003C(A2)
	MOVE.W	#2,$0056(A2)
	MOVE.L	(A0)+,A2

	MOVE.W	#8,$004E(A2)
	MOVE.W	#$8008,$0050(A2)
	MOVE.W	#$0400,$0052(A2)
	MOVE.W	#$8400,$0054(A2)
	MOVE.L	(A1)+,$003C(A2)
	MOVE.W	#3,$0056(A2)
	RTS

;********************************
;* called by playing a voice    *
;********************************
mt_nsetplaynote:
	MOVEM.L D0/D1/D6/D7/A0-A3,-(SP)
	LEA	mt_mxbuf4chan,A3
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	0(A3,D0.W),A3
	MOVE.W	D1,D0
	BNE.S	mt_nsetpna
	BRA.S	mt_nsetpn2t

mt_nsetpna:
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	mt_songdataptr,A0
	MOVE.L	0(A0,D0.W),A1
	ADD.W	D0,D0
	LEA	MSamPointer,A0
	MOVE.L	0(A0,D0.W),A2
	MOVEQ	#0,D0
	MOVE.W	(A2)+,D7
	MOVE.W	(A2)+,D6
mt_nsetpn1:
	MOVE.L	A1,(A3)+
	MOVE.W	(A2)+,D1
	MOVE.W	D1,(A3)+
	MOVE.W	(A2)+,(A3)+
	ADD.W	D1,D1
	ADD.W	D1,A1
	ADDQ.W	#1,D0
	CMP.W	D6,D0
	BNE.S	mt_nsetpn2
	MOVE.L	A3,A0
mt_nsetpn2:
	CMP.W	D7,D0
	BLT.S	mt_nsetpn1
	TST.W	D6
	BEQ.S	mt_nsetpn2t
	MOVE.L	A3,A1
	ADDQ.W	#4,A1
	SUB.L	A1,A0
	MOVE.L	A0,(A3)+
mt_nsetpn2t:
	CLR.L	(A3)+
	MOVEM.L (SP)+,D0/D1/D6/D7/A0-A3
	RTS

;********************************
;* called by voice playing      *
;********************************
mt_zsetpnote:
	LEA	SampleInfo,A6
	MOVE.W	PlayInsNum,D0
	BEQ.S	.l0
	LEA	SampleInfo2,A6
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	mt_songdataptr,A0
	MOVE.L	0(A0,D0.W),si_pointer2
	MOVE.W	PlayInsNum,D0
	MOVE.B	D0,PlayInsNum2
	MOVE.L	mt_songdataptr,A0
	LEA	-10(A0),A0			; start act. sample
	MULU	#$001E,D0
	ADD.L	D0,A0
	MOVE.L	$0016(A0),SampleInfo2
	MOVE.L	$001A(A0),si_long2
.l0:
	MOVE.B	PlayInsNum2,$002B(A4)
	MOVEQ	#0,D1
	MOVE.W	6(A6),D2
	MOVE.W	D2,14(A4)
	MOVE.W	4(A6),D0
	MOVE.W	D0,D1
	BNE.S	.l2
	MOVE.W	(A6),D0
	BRA.S	.l3

.l2:
	ADD.W	D2,D0
.l3:
	MOVE.W	D0,8(A4)
	BNE.S	.la1
	MOVE.W	#1,8(A4)

.la1:	ADD.L	D1,D1
	MOVE.L	8(A6),D0
	ADD.L	D0,D1
	MOVE.L	D1,10(A4)
	MOVE.L	$003C(A4),A0
	MOVE.L	A0,$0044(A4)
	MOVE.L	D0,D1
	MOVE.L	StartOfs,D2
	ADD.L	D2,D1
	MOVE.L	D1,4(A4)
	CLR.L	StartOfs
	TST.W	PlayInsNum
	BNE.S	.audioplay
	TST.L	D2
	BEQ.S	.l4
.loop:
	MOVE.L	(A0),D0
	BEQ.S	.l5
	CMP.L	D0,D1
	BLT.S	.l5
	ADDQ.W	#8,A0
	BRA.B	.loop

.l5:
	SUBQ.W	#8,A0
	MOVEQ	#0,D0
	MOVE.L	(A0),D0
	SUB.L	D1,D0
	NEG.L	D0
	LSR.L	#1,D0
	SUB.W	D0,4(A0)
	MOVE.L	D1,(A0)
	MOVE.L	A0,$0044(A4)
.l4:
	MOVE.W	8(A4),D1
	MOVEQ	#0,D2
.loop2:
	TST.L	(A0)
	BEQ.S	.audioplay
	MOVE.W	4(A0),D0
	ADD.W	D0,D2
	CMP.W	D1,D2
	BCC.S	.skip
	ADDQ.W	#8,A0
	BRA.S	.loop2

.skip:
	SUB.W	D1,D2
	SUB.W	D2,D0
	MOVE.W	D0,4(A0)
	CLR.L	8(A0)

;--- audio output ---
.audioplay:
	MOVE.W	#$4000,INTENA
	MOVEQ	#0,D1
	MOVE.B	3(A6),D1
	MOVE.B	D1,$0013(A4)
	MULU	$0014(A4),D1
	ADD.W	#$0020,D1
	LSR.W	#6,D1
	MOVE.W	D1,$004C(A4)
	MOVE.W	CurrentPlayNote,$0010(A4)
	SF	$0038(A4)
	CLR.W	$003A(A4)
	ST	$0036(A4)
	MOVE.L	$0044(A4),A0
	MOVE.L	A0,$0040(A4)
	BSR.W	dmascan
	ST	$002A(A4)
	BRA.W	testmul


;********************************
;* Cursor key checkroutine      *
;********************************
ArrowKeys:
	TST.W	SamScrEnable
	beq.s	.doit
	RTS

.doit:	CMP.B	#4,EnterTextFlag
	BNE.B	.skip
	RTS
.skip:
	move.b	RawKeyCode,D0
	beq.s	arkeskip

	MOVE.B	RawKeyCode,D0
	BEQ.S	arkeskip
	TST.W	GetLineFlag
	BNE.S	arkeskip
	TST.B	ShiftKeyStatus
	BNE.S	arkeskip
	TST.W	AltKeyStatus
	BNE.S	arkeskip
	cmp.w	#9,CurrScreen
	beq.b	posedskip
	CMP.W	#2,CurrScreen		;help selected?
	BEQ.B	arkeskip		;
	;tst.w	SamScrEnable
	;bne.s	posedskip		;sampleskip
	CMP.B	#$4E,D0 		;--->
	BEQ.W	RightArrow
	CMP.B	#$4F,D0 		;<---
	BEQ.W	LeftArrow

arkeskip:

	;tst.w	SamScrEnable
	;bne.s	posedskip		;sampleskip
	CMP.B	#$4C,D0 		;Cursor high
	BEQ.S	UpArrow
	CMP.B	#$4D,D0 		;Cursor low
	BEQ.W	DownArrow
	CLR.W	ArrowPressed
	CLR.W	ArrowRepcounter
posedskip:

	RTS

ArrowPressed:		dc.w	0
ArrowRepcounter:	dc.w	0

UpArrow:
	TST.L	RunMode
	BNE.B	Return7
	CMP.W	#2,CurrScreen		;new, helpscreen
	BEQ.B	Return7
	CMP.W	#3,CurrScreen
	BEQ.B	Return7
	CMP.W	#6,CurrScreen
	BEQ.B	Return7
	cmp.w	#8,CurrScreen
	beq.b	Return7
	cmp.w	#9,CurrScreen
	beq.b	Return7
	TST.W	ArrowPressed
	BEQ.S	MoveOneUp
	ADDQ.W	#1,ArrowRepcounter
	TST.W	AltKeyStatus		;turboscroll
	BNE.S	AltArrowUp
	TST.B	ShiftKeyStatus		;fastcscroll
	BNE.S	ShiftArrowUp
	CMP.W	#6,ArrowRepcounter
	BPL.S	MoveOneUp

Return7:
	RTS

ShiftArrowUp:
	CMP.W	#3,ArrowRepcounter
	BPL.S	MoveOneUp
	RTS

AltArrowUp:
	CMP.W	#1,ArrowRepcounter
	BPL.S	MoveOneUp
	RTS

MoveOneUp:
	CLR.W	ArrowRepcounter
	MOVE.W	#$FFFF,ArrowPressed
	CMP.L	#'patt',RunMode
	BNE.S	trt9
	RTS

trt9:
	SUBQ.W	#1,ScrPattPos
	AND.W	#$003F,ScrPattPos
	BRA.W	SetScrPatternPos

DownArrow:
	TST.L	RunMode
	BNE.B	trt10
	CMP.W	#2,CurrScreen		;Help screen
	BEQ.B	trt10
	CMP.W	#3,CurrScreen		;DirScreen
	BEQ.B	trt10
	CMP.W	#6,CurrScreen
	BEQ.B	trt10
	cmp.w	#8,CurrScreen
	beq.b	trt10
	cmp.w	#9,CurrScreen
	beq.b	trt10
	TST.W	ArrowPressed
	BEQ.B	MoveOneDown
	ADDQ.W	#1,ArrowRepcounter

	TST.W	AltKeyStatus		;turboscroll
	BNE.B	AltDownArrow
	TST.B	ShiftKeyStatus		;fastscroll
	BNE.B	ShiftDownArrow
	CMP.W	#6,ArrowRepcounter
	BPL.B	MoveOneDown

trt10:
	RTS

ShiftDownArrow:
	CMP.W	#3,ArrowRepcounter
	BPL.S	MoveOneDown
	RTS

AltDownArrow:
	CMP.W	#1,ArrowRepcounter
	BPL.S	MoveOneDown
	RTS

MoveOneDown:
	CLR.W	ArrowRepcounter
	MOVE.W	#$FFFF,ArrowPressed
	TST.L	RunMode
	BEQ.S	trt13
	RTS

trt13:
	ADDQ.W	#1,ScrPattPos
	AND.W	#MaxPattPos,ScrPattPos
	BRA.W	SetScrPatternPos

EditMoveDown:
	TST.L	RunMode
	BEQ.S	trt14
	RTS

trt14:
	TST.B	EditMovRightFlag	;Edit move right prefs
	BNE.S	MoveOneRight

	MOVE.W	EditMoveAdd,D0
	ADD.W	D0,ScrPattPos
	AND.W	#MaxPattPos,ScrPattPos
	BRA.W	SetScrPatternPos

EditMoveAdd:	dc.w	1

RightArrow:
	TST.W	ArrowPressed
	BEQ.S	MoveOneRight
	ADDQ.W	#1,ArrowRepcounter
	CMP.W	#6,ArrowRepcounter
	BPL.S	MoveOneRight
	RTS

MoveOneRight:
	CLR.W	ArrowRepcounter
	MOVE.W	#$FFFF,ArrowPressed
	ADDQ.W	#1,PattCurPos

	chn8test
	BNE.S	.chn4

	CMP.W	#48,PattCurPos
	BMI.S	morskip
	CLR.W	PattCurPos
	BRA.S	UpdateCursorPos

.chn4:	CMP.W	#24,PattCurPos
	BMI.S	morskip
	CLR.W	PattCurPos
morskip:
	BRA.S	UpdateCursorPos


LeftArrow:
	TST.W	ArrowPressed
	BEQ.S	MoveOnLeft
	ADDQ.W	#1,ArrowRepcounter
	CMP.W	#6,ArrowRepcounter
	BPL.S	MoveOnLeft
	RTS

MoveOnLeft:
	CLR.W	ArrowRepcounter
	MOVE.W	#$FFFF,ArrowPressed
	SUBQ.W	#1,PattCurPos
	TST.W	PattCurPos
	BPL.S	UpdateCursorPos

	chn8test
	BNE.S	.chn4

	MOVE.W	#47,PattCurPos
	BRA.S	UpdateCursorPos

.chn4:	MOVE.W	#23,PattCurPos

UpdateCursorPos:
	TST.W	SamScrEnable
	BEQ.S	auins32
	RTS

auins32:
	MOVE.W	PattCurPos,D0
	LEA	CursPosTable,A0
	MOVE.B	0(A0,D0.W),D0
	MOVE.W	D0,D1			;4
	LSL.W	#2,D0			;16    ;4=2

	chn8test
	BNE.S	.chn4

	LSR.W	#1,D0
	ADDQ.W	#8,D0

.chn4:	;LSL.W	 #1,D1		;8
	;ADD.W	 D1,D0		;24
	;ADD.W	 #8,D0		;32

	MOVE.W	#197,D1		;YPos Hauptcursor
	MOVEQ	#9,D2		;YLen
	MOVE.L	CspritePtr,A0
	GOTO	SetSpritePos

;********************************
;* 2th cursorkeys checkroutine  *
;********************************
ArrowKeys2:
	MOVE.B	RawKeyCode,D0
	tst.w	SamScrEnable
	bne.b	.skip			;sampleskip
	tst.b	d0
	bne.s	.doit
.skip:	RTS

.doit:	CMP.B	#$4C,D0 		;^
	BEQ.S	UpArrow2
	CMP.B	#$4D,D0;		;low
	BEQ.S	DownArrow2
	CMP.B	#$4F,D0 		;<---
	BEQ.W	LeftArrow2
	CMP.B	#$4E,D0 		;--->
	BEQ.W	RightArrow2
	RTS

UpArrow2:
	CMP.W	#2,CurrScreen		;help active?
	BEQ.W	HelpUp

	CMP.W	#3,CurrScreen		;Dir
	BNE.B	twqk5

	BSR.W	FileNameOneUp
	GOTO	Wait_4000

twqk5:

	CMP.W	#6,CurrScreen
	BNE.B	.inf1up
	GOTO	PLSTOneUp

.inf1up:
	cmp.w	#8,CurrScreen
	bne.b	.plst1up
	GOTO	ToggleInfosUp

.plst1up:
	cmp.w	#9,CurrScreen
	beq.w	PositionDown
	RTS

DownArrow2:
	CMP.W	#2,CurrScreen
	BEQ.W	HelpDown
	CMP.W	#3,CurrScreen		;dir
	BNE.B	kalau1			;LeftArrow2
	BSR.W	FileNameOneDown
	BSR.W	Wait_4000
	RTS

kalau1:

	CMP.W	#6,CurrScreen
	BNE.B	.inf1dwn
	GOTO	PLSTOneDown

.inf1dwn:
	cmp.w	#8,CurrScreen
	bne.b	.plst1d
	GOTO	ToggleInfosDown
.plst1d:
	cmp.w	#9,CurrScreen
	beq.w	PositionUp
	RTS				;Cryptoburners forgot this, CB bug

LeftArrow2:
	TST.B	ShiftKeyStatus
	BNE.W	PositionDown
	TST.W	AltKeyStatus
	BNE.W	PatternOneDown
	TST.W	CtrlKeyStatus
	BNE.W	SampleNumDown
	CMP.W	#2,CurrScreen
	BEQ.W	HelpLeft
	cmp.w	#9,CurrScreen
	bne.b	larrret
	MOVE.W	#$FFFF,UpOrDown
	BRA.W	PatternGadg

larrret:
	RTS

RightArrow2:
	TST.B	ShiftKeyStatus
	BNE.W	PositionUp
	TST.W	AltKeyStatus
	BNE.W	PatternOneUp
	TST.W	CtrlKeyStatus
	BNE.W	SampleNumUp
	CMP.W	#2,CurrScreen
	BEQ.W	HelpRight
	cmp.w	#9,CurrScreen
	bne.b	rarrret
	CLR.W	UpOrDown
	BRA.W	PatternGadg
rarrret:
	RTS

UpdateLineCurPos:
	MOVE.W	LineCurX,D0
	LSR.W	#1,D0
	MOVE.W	LineCurY,D1
	SUBQ.W	#1,D0
	MOVEQ	#2,D2
	LEA	LineCurSpriteData,A0
	GOTO	SetSpritePos
	RTS


;********************************
;* Gadget coords conf. routine  *
;********************************
CheckGadgets:
	BSR.S	cgskip			;other gadgets than screen 1
	CLR.W	notogfl
mt_chkgdgts:
	BSR.W	ResetKeyTimer

	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	WaitTOF
	MOVEM.L (SP)+,D0-D7/A0-A6

	SUBQ.W	#1,mt_wtofgadreg
	BMI.S	cgnorm2
	checklmb
	BEQ.S	mt_chkgdgts
cgnorma:
	MOVE.W	#$0014,mt_wtofgadreg
	CLR.W	UpOrDown
	GOTO	MainLoop

;--------------------
cgnorm2:
	MOVE.W	#1,mt_wtofgadreg
	checklmb
	BEQ.S	CheckGadgets
	BRA.S	cgnorma

mt_wtofgadreg:	dc.w	$0014

cgskip:
	MOVE.W	MouseX,MouseX2
	MOVE.W	MouseY,MouseY2
	MOVEM.W (MouseX2),D0/D1
	MOVE.W	MouseY2,D1
	CMP.W	#$0079,D1
	BCC.W	WantedPattGadg

	CMP.W	#2,CurrScreen
	bne.b	.skip
	GOTO	CheckHelpGadgs
.skip:
	CMP.W	#3,CurrScreen		;Dir Screen
	BEQ.W	CheckDirGadgets
	CMP.W	#5,CurrScreen		;Setup
	BEQ.W	CheckSetupGadgs
	CMP.W	#6,CurrScreen
	BNE.S	.skip2
	GOTO	CheckPLSTGadgs
.skip2:
	CMP.W	#8,CurrScreen
	bne.b	.skip3
	GOTO	CheckInfoGadgs
.skip3:
	cmp.w	#9,CurrScreen
	bne.b	.skip4
	GOTO	CheckPosGadgs
.skip4:
	CMP.W	#1,CurrScreen
	BEQ.B	ChkMainScrGadgs
	RTS

;********************************
;* Gadgetcheck opt1-7           *
;********************************
ChkMainright:
	MOVEM.W (MouseX2),D0/D1
	LEA	MainGadData2,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.W	chkhalf
	RTS

;********************************
;* Gadgetcheck for mainscreen   *
;********************************

ChkMainScrGadgs:
	MOVEM.W (MouseX2),D0/D1
	LEA	MainGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.doit
	RTS

.doit:	cmp.w	#$48,d2
	beq.w	remember
	CMP.W	#1,D2
	bne.s	.l0
	GOTO	ExitCleanup

.l0:	CMP.W	#2,D2
	BEQ.W	Screenswitch
	CMP.W	#3,D2
	BEQ.W	EnterSongName
	CMP.W	#4,D2			; vol up
	BEQ.W	volup
	CMP.W	#5,D2			; vol down
	BEQ.W	voldown
	CMP.W	#6,D2
	BNE.S	.l1
	GOTO	CheckVolumeSlider

.l1:	CMP.W	#7,D2
	BEQ.W	PosInsert
	CMP.W	#8,D2
	BEQ.W	PosDelete
	CMP.W	#9,D2
	BEQ.W	EnterPosGadg
	CMP.W	#10,D2
	BEQ.W	EnterPattGadg		; patternlength
	CMP.W	#11,D2
	BEQ.W	EnterlenGadg		; songlength
	CMP.W	#12,D2
	bne.s	.skip3
	GOTO	PLST
.skip3:
	CMP.W	#13,D2
	BNE.S	.skip6			; Positionseditor
	GOTO	PosED
.skip6:
	CMP.W	#$14,D2
	BEQ.W	PlaySong		; play module
	CMP.W	#$15,D2
	BEQ.W	StopIt
	CMP.W	#$16,D2
	BEQ.W	playcontinue
	CMP.W	#$17,D2
	BEQ.W	playpattern
	CMP.W	#$18,D2
	BEQ.W	RecordSong
	CMP.W	#$19,D2
	BEQ.W	Edit
	CMP.W	#$1A,D2
	BEQ.W	ClearData
	CMP.W	#$1B,D2
	BEQ.W	Setup
	CMP.W	#$1C,D2
	BEQ.W	ShowDirScreen
	CMP.W	#$1D,D2 		; samplename
	BEQ.W	HitSampleName
	CMP.W	#$31,D2
	BNE.S	.skip
	GOTO	KillSample
.skip:
	CMP.W	#$32,D2
	BNE.S	.skip1
	GOTO	SamplerScreen
.skip1:
	MOVE.W	#1,UpdateFreeMem
	CMP.W	#$2D,D2
	BEQ.W	InpSampleLength
	CMP.W	#$2E,D2
	BEQ.W	RepeatGadg
	CMP.W	#$2F,D2
	BEQ.W	lbC00B906
	MOVE.W	#$FFFF,UpOrDown
	CMP.W	#15,D2
	BEQ.W	PositionUpDown
	CMP.W	#$11,D2 		; pattern decrease
	BEQ.W	PatternGadg
	CMP.W	#$13,D2
	BEQ.W	SongLengthGadg
	CMP.W	#$1F,D2
	BEQ.W	SampleNumGadg
	CMP.W	#$21,D2
	BEQ.W	VolumeGadg
	CMP.W	#$23,D2
	BEQ.W	FineTuneGadg
	CMP.W	#$25,D2
	BEQ.W	SampleLengthGadg
	CMP.W	#$27,D2
	BEQ.W	Repeathigh
	CMP.W	#$29,D2
	BEQ.W	ReplenHigh
	CLR.W	UpOrDown
	CMP.W	#14,D2
	BEQ.W	PositionUpDown
	CMP.W	#$10,D2
	BEQ.W	PatternGadg		; pattern increase
	CMP.W	#$12,D2
	BEQ.W	SongLengthGadg
	CMP.W	#$1E,D2
	BEQ.W	SampleNumGadg
	CMP.W	#$20,D2
	BEQ.W	VolumeGadg
	CMP.W	#$22,D2
	BEQ.W	FineTuneGadg
	CMP.W	#$24,D2
	BEQ.W	SampleLengthGadg
	CMP.W	#$26,D2
	BEQ.W	Repeathigh
	CMP.W	#$28,D2
	BEQ.W	ReplenHigh
	CMP.W	#1,CurrScreen
	BNE.B	chkhalf
	CMP.W	#$44,D2
	BEQ.W	gtorecover
	CMP.W	#$45,D2
	BNE.S	.skip5
	GOTO	InfoScreen
.skip5:
	cmp.w	#$4a,d2			; small button 4 channel
	beq.w	gto4chan
	cmp.w	#$4B,d2
	beq.w	gto8chan

	;CMP.W	#$4e,D2
	;BEQ.W	ToggleCh1
	;CMP.W	 #$4f,D2
	;BEQ.W	 ToggleCh2
	;CMP.W	 #$50,D2
	;BEQ.W	 ToggleCh3
	;CMP.W	 #$51,D2
	;BEQ.W	 ToggleCh4

	cmp.w	#$49,d2
	bne.s	.skip7
	GOTO	PosED			; small-button PosED call
.skip7:
	cmp.w	#$4c,d2
	beq.w	gtolevelmeters		; gtoPED2


	cmp.w	#$4D,d2			; toggle vumetersprite (big or little)
	beq	ToggleVUSprites

chkhalf:
	;CMP.W	 #$33,D2		; Rewritten since 3.61
	;BEQ.W	 ToggleCh1
	;CMP.W	 #$34,D2
	;BEQ.W	 ToggleCh2
	;CMP.W	 #$35,D2
	;BEQ.W	 ToggleCh3
	;CMP.W	 #$36,D2
	;BEQ.W	 ToggleCh4
	cmp.w	#8,OptScrFlag
	bne.s	.skip
	GOTO	CheckOpt8Gadg
.skip
	CMP.W	#$3C,D2
	BEQ.W	CheckOpt1_4Gadg
	CMP.W	#$3D,D2
	BEQ.W	EditOptions
	CMP.W	#$3E,D2
	BEQ.W	SampleOptions
	CMP.W	#$3F,D2
	BEQ.W	ChordEditor
	CMP.W	#$40,D2
	BEQ.W	FilterEditor
	CMP.W	#$41,D2
	BNE.S	.Reserved1
	GOTO	Opt5RotChk
.Reserved1:
	CMP.W	#$42,D2
	BEQ.W	Reserved2
	CMP.W	#$43,D2
	BEQ.W	OptionCommands7

	cmp.w	#$46,d2
	bne.s	.skip10
	GOTO	PrintSong
.skip10:
	cmp.w	#$47,d2 		; move screen
	beq.w	MoveScreen

	cmp.w	#$4F,d2
	bne.s	.skip4
	GOTO	Help
.skip4:
	cmp.w	#$4e,d2
	bne.s	.skip9
	GOTO	ExitCleanup
.skip9:
	cmp.w	#$56,d2
	beq.w	NextScope2		;click on vumeter
	RTS

ToggleVUSprites:
	BCHG	#0,VUSpriteMode
	BTST	#0,VUSpriteMode
	BEQ.S	.lbig
	GOTO	SetDefSpritePtrs_L		; change to vumetersprites (fine)
.lbig:	GOTO	SetDefSpritePtrs_B		; change to vumetersprites (bold)


;***********************************
gtorecover:
		LEA	recovertxt,A0
		BSR.W	AreYouSure
		beq.s	recovermm
		RTS
recovermm:	GOTO	recovermain

gtolevelmeters:
		ADDQ.B	#1,VUShowMode
		CMP.B	#3,VUShowMode
		BMI.S	VUModChg22
		CLR.B	VUShowMode
VUModChg22:	CALL	valgask
		RTS

;**********************************
;* Checks right mousebutton click *
;**********************************

DoRightButton:
	MOVE.W	MouseX,MouseX2
	MOVE.W	MouseY,MouseY2
	MOVE.W	MouseX2,D0
	MOVE.W	MouseY2,D1
	CMP.W	#$79,D1
	BCS.S	.l1

	TST.W	SamScrEnable
	BNE.S	.l1
	BSR.W	RMBPosTrGet		; Mainscreen, RMB

.l1:	CMP.W	#3,CurrScreen
	BEQ.W	ChkDirMouse
	RTS

;********************************
;* relabel disk in diskscreen   *
;********************************

Relabel_Disk:
	LEA	rl_DiskName(PC),A0
	MOVE.L	DirPath,A1
	MOVEQ	#$1F,D1
rldisk_loop1:
	MOVE.B	(A1)+,(A0)+
	DBRA	D1,rldisk_loop1
	LEA	rl_DiskName(PC),A0
	MOVEQ	#$1F,D1
rldisk_loop2:
	CMP.B	#$3A,(A0)
	BEQ.S	rldisk_ffa
	ADDQ.L	#1,A0
	DBRA	D1,rldisk_loop2
	BRA.S	mt_disknametolong

rldisk_ffa:
	CLR.B	(A0)+
	DBRA	D1,rldisk_ffa
	LEA	rl_DiskName(PC),A0
	TST.B	(A0)
	BEQ.S	mt_disknametolong
	MOVEQ	#30,D0			;max length diskname
rldisk_ffb:
	TST.B	(A0)+
	BEQ.S	rldisk_ffc
	DBRA	D0,rldisk_ffb
	BRA.S	mt_disknametolong

rldisk_ffc:
	MOVE.B	#$3A,-1(A0)
	LEA	Relabeldiskas.MSG(PC),A0
	LEA	ST00.MSG(PC),A1		;predefined name
	MOVEQ	#$20,D0
	LEA	ClearSongGFXdata,A2
	CALL	mt_makereqindir
	BEQ.S	rldisk_reqisok
	RTS

rldisk_reqisok:
	LEA	Relablingdisk.MSG(PC),A0
	CALL	ShowStatusText
	LEA	rl_ST00_defname(PC),A0
	LEA	1(A0),A1
	MOVEQ	#0,D0
rldisk_ffd:
	TST.B	(A1)+
	BEQ.S	rldisk_ffe
	ADDQ.W	#1,D0
	CMP.W	#$0020,D0		;max length
	BNE.B	rldisk_ffd
	CLR.B	(A1)
rldisk_ffe:
	MOVE.B	D0,(A0)
	LEA	rl_DiskName(PC),A0
	LEA	rl_ST00_defname(PC),A1
	BSR.W	mt_relabdiskproc
	CALL	ShowAllRight
	RTS

mt_disknametolong:
	LEA	DNameToLong.MSG(PC),A0
	CALL	ShowStatusText
	GOTO	SetErrorPtrCol

Relabeldiskas.MSG:	dc.b	10,10
			dc.b	'   Relabel disk as:',0
Relablingdisk.MSG:	dc.b	'RELABELING DISK...',0,0
DNameToLong.MSG:	dc.b	'NO DISKNAME TO RELABEL',0,0
disknamelong.msg:	dc.b	'DISKNAME TO LONG...',0
			EVEN

rl_DiskName:		dc.l	0,0,0,0,0,0,0,0,$0000542D
rl_ST00_defname:	dc.b	5
ST00.MSG:		dc.b	'ST-00'
			dcb.b	16,0
			EVEN

WARNINGAlldat.MSG:	dc.b	10,10
			dc.b	'      W A R N I N G !',$A,$A
			dc.b	'  All data will be lost.',0
			EVEN

Formatting.MSG: 	dc.b	'FORMATTING...',0
			EVEN

Initializing.MSG:	dc.b	'INITIALIZING...',0
			EVEN

Formattingabo.MSG:	dc.b	'FORMATTING ABORTED',0
			EVEN

Harderrorondi.MSG:	dc.b	'HARD ERROR ON DISK',0
			EVEN

Unabletoopent.MSG:	dc.b	'CAN''T OPEN TRACKDISKDEVICE',0
			EVEN

Nodiskindrive.MSG:	dc.b	'NO DISK IN DRIVE',0
			EVEN

calcmodsmp.msg: 	dc.b	'CALCULATING SAMPLE...',0
			EVEN

;********************************
;* format disk from dirscreen   *
;********************************

Format_Disk:
	CALL	fdisk_makerequester
	BPL.S	fdisk_sure
	RTS

fdisk_sure:
	LEA	WARNINGAlldat.MSG(PC),A0
	CALL	mt_formatreq
	BEQ.S	lbC007EEA
	RTS

lbC007EEA:
	BRA.W	fdi_stact


fdisk_makerequester:
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	fdi_lwores
	BSR.W	ClearRightAreaReq
	SUB.L	A0,A0
	LEA	ClearSongGFXdata,A1
	LEA	FormatGadGFX,A2
	MOVE.L	#$00000140,D0
	BSR.W	SwapBoxMem
	BSR.W	fdi_dname
	BSR.W	fdi_lwchks
	BSR.W	fdi_lwkos3
	BSR.W	fdi_lwkmka
	BSR.W	fdi_lwkmera
fdi_reg1:
	BSR.W	ResetKeyTimer
	checklmb
	BNE.S	fdi_reg1
	MOVEM.W (MouseX),D0/D1
	LEA	lbL0194FC,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.B	fdi_reg1
	CMP.W	#1,D2
	BEQ.S	fdi_reg3
	CMP.W	#2,D2
	BEQ.S	fdi_reg4
	CMP.W	#3,D2
	BEQ.S	fdi_reg5
	PEA	fdi_reg1(PC)
	CMP.W	#10,D2
	BNE.S	fdi_reg2
	BSR.W	Screenswitch
fdi_reg2:
	CMP.W	#4,D2
	BEQ.W	fdi_lwkmki
	CMP.W	#5,D2
	BEQ.W	fdi_lwkmerk
	CMP.W	#6,D2
	BEQ.B	fdi_lwchk
	CMP.W	#7,D2
	BEQ.W	fdi_lwffs
	CMP.W	#8,D2
	BEQ.S	fdi_regask
	RTS

fdi_reg3:
	MOVEQ	#0,D0
	BRA.S	fdi_regop

fdi_reg4:
	MOVEQ	#1,D0
	BRA.S	fdi_regop

fdi_reg5:
	MOVEQ	#-1,D0

fdi_regop:
	BSR.W	OpenRequester
	CLR.W	DirCopFlag
	MOVE.W	D0,lbW008176
	RTS

fdi_regask:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	LEA	empty.MSG(PC),A6
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,TextEndPtr
	ADD.L	#$00000020,TextEndPtr
	MOVE.W	#$0015,TextLength
	MOVE.W	#$010D,D0
	MOVEQ	#$56,D1
	BSR.W	EnterTextNow
	BSR.W	RestorePtrCol
fdi_dname:
	LEA	empty.MSG(PC),A0
	MOVE.W	#$010D,D0
	MOVEQ	#$56,D1
	MOVEQ	#$15,D3
	GOTO	Write_Text

fdi_lwchk:
	BSR.W	WaitForButtonUp
fdi_lwchkw:
	ADDQ.W	#1,lbB00816E
	CMP.W	#4,lbB00816E
	BMI.S	fdi_lwchks
	CLR.W	lbB00816E
fdi_lwchks:
	MOVE.W	lbB00816E(PC),D0
	MOVE.W	lbB008178(PC),D1
	AND.W	#15,D1
	BEQ.S	fdi_lwchkg
	BTST	D0,D1
	BEQ.S	fdi_lwchkw
fdi_lwchkg:
	LEA	DF0DF1DF2DF3.MSG(PC),A0
	MULU	#3,D0
	ADD.L	D0,A0
	MOVE.W	#$019F,D0
	MOVEQ	#$3A,D1
	MOVEQ	#3,D3
	GOTO	Wr_Message

fdi_lwffs:
	BSR.W	WaitForButtonUp
	ADDQ.W	#1,FileSysControl
	CMP.W	#34,CheckKickSeteg	;Kick v1.3?
	BPL.S	fdi_lwffsc
	CLR.W	FileSysControl
	BRA.S	fdi_lwkos3

fdi_lwffsc
	CMP.W	#36,CheckKickSeteg	;Kick v2.0?
	BPL.S	fdi_lwkic
	CMP.W	#2,FileSysControl
	BMI.S	fdi_lwkos3
	CLR.W	FileSysControl
	BRA.S	fdi_lwkos3

fdi_lwkic:
	CMP.W	#3,FileSysControl
	BMI.S	fdi_lwkos3
	CLR.W	FileSysControl
fdi_lwkos3:
	LEA	OFSFFSINT.MSG(PC),A0
	MOVE.W	FileSysControl(PC),D0
	MULU	#3,D0
	ADD.L	D0,A0
	MOVE.W	#$019F,D0
	MOVEQ	#$47,D1
	MOVEQ	#3,D3
	GOTO	Wr_Message

fdi_lwkmki:
	BSR.W	WaitForButtonUp
	EOR.W	#1,lbW008172
fdi_lwkmka:
	LEA	t.MSG(PC),A0
	TST.W	lbW008172
	BNE.S	fdi_lwkmko
	ADDQ.L	#1,A0
fdi_lwkmko:
	MOVE.W	#$0143,D0
	MOVEQ	#$3A,D1
	MOVEQ	#1,D3
	GOTO	Wr_Message

fdi_lwkmerk:
	BSR.W	WaitForButtonUp
	EOR.W	#1,lbW008174
fdi_lwkmera:
	LEA	t.MSG(PC),A0
	TST.W	lbW008174
	BNE.S	fdi_lwkmerb
	ADDQ.L	#1,A0
fdi_lwkmerb:
	MOVE.W	#$0143,D0
	MOVEQ	#$47,D1
	MOVEQ	#1,D3
	GOTO	Wr_Message

;**************************
DF0DF1DF2DF3.MSG:
	dc.b	'DF0DF1DF2DF3'

OFSFFSINT.MSG:	dc.b	'OFSFFSINT'

t.MSG:		dc.b	'` t'
		EVEN

empty.MSG:	dc.b	'empty',0,0
		dcb.b	27,0
		EVEN

lbB00816E:	dc.b	0,0
FileSysControl:	dc.b	0
lbB008171:	dc.b	0
lbW008172:	dc.w	1
lbW008174:	dc.w	0
lbW008176:	dc.w	1
lbB008178:	dc.b	0
fdi_resource:	dc.b	0
		EVEN

***************************
fdi_lwores:
	LEA	diskresource.MSG(PC),A1
	MOVE.L	4.w,a6
	CALLSYS	OpenResource
	MOVE.L	D0,A0
	MOVEQ	#0,D0
	MOVE.B	$26(A0),fdi_resource
	RTS

diskresource.MSG:	dc.b	'disk.resource',0

fdi_stact:
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	ClearRightAreaReq
	SUB.L	A0,A0
	SUB.L	A1,A1
	LEA	lbL0196AE,A2
	BSR.W	SwapBoxMem
	LEA	Formatting.MSG(PC),A0
	MOVE.W	#$112,D0
	MOVEQ	#$3E,D1
	CALL	PrintTextInReqs
	CALL	ShowStatusText
	MOVE.W	lbB00816E(PC),D0
	AND.B	#3,D0
	ADD.B	#$30,D0
	MOVE.B	D0,ascii.MSG20
	LEA	lbL033718,A0
	LEA	DOS.MSG(PC),A1
	MOVE.L	(A1),D0
	MOVE.B	lbB008171(PC),D0
	MOVE.L	D0,(A0)
	BSR.W	AddFormatPort
	BNE.W	mt_formatnotopened
	BSR.W	lbC008746
	BNE.W	mt_formatnodisk
	BSR.W	lbC00869A
	BSR.W	StorePtrCol
	BSR.W	SetDiskPtrCol
	CMP.W	#1,lbW008176
	BEQ.S	fdi_stain
	BSR.W	fdi_stados
	BMI.S	mt_formatmediaerr
	BNE.S	mt_formataborted
fdi_stain:
	LEA	Initializing.MSG(PC),A0
	MOVE.W	#$010B,D0
	MOVEQ	#$3E,D1
	CALL	PrintTextInReqs
	CALL	ShowStatusText
	BSR.W	lbC0084BA
	BNE.S	mt_formatmediaerr
	CALL	ShowAllRight
fdi_stainb:
	BSR.W	lbC008678
	CLR.L	lbL0087A0
	BSR.W	lbC00869A
	MOVE.L	#$FFFFFFFF,lbL0087A0
	BSR.W	CloseTDPort
	CALL	RestorePtrCol
fdi_stainbg:
	BSR.W	OpenRequester
	CLR.W	DirCopFlag
	CALL	ClearAllKeys
	MOVEQ	#0,D0
	RTS

mt_formataborted:
	BSR.S	fdi_stainb
	LEA	Formattingabo.MSG(PC),A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol

mt_formatmediaerr:
	BSR.W	lbC00865E
	BSR.S	fdi_stainb
	LEA	Harderrorondi.MSG(PC),A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol

mt_formatnotopened:
	BSR.S	fdi_stainbg
	LEA	Unabletoopent.MSG(PC),A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol

mt_formatnodisk:
	BSR.S	fdi_stainb
	LEA	Nodiskindrive.MSG(PC),A0
	CALL	ShowStatusText
	BRA.W	SetErrorPtrCol


fdi_stados:
	LEA	DOS0.MSG(PC),A0
	LEA	lbL030B18,A1
	MOVE.L	#$0000057F,D0
fdi_stadosb:
	MOVE.L	(A0),(A1)+
	DBRA	D0,fdi_stadosb
	MOVE.W	#1,lbW0083DC
	MOVEQ	#0,D5
	MOVE.L	#$0000009F,D7
fdi_stadosc:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	lbW0083DC(PC),D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	MOVE.W	D2,lbW0083DC
	LSR.W	#1,D0
	LSR.W	#1,D2
	MULU	#$00EC,D0
	DIVU	#$0050,D0
	MULU	#$00EC,D2
	DIVU	#$0050,D2

	ADD.W	#$00CA,D0
	ADD.W	#$00CA,D2
	MOVEQ	#$4D,D1
	MOVE.W	#$0056,D3
	MOVEQ	#1,D5
	CALL	DrawRecBox			; clears formatreq area

	MOVEM.L (SP)+,D0-D7/A0-A6
	BSR.S	lbC0083DE
	BNE.S	fdi_stadort
	ADD.L	#$00001600,D5
	MOVEM.L D0-D7/A0-A6,-(SP)
	CMP.W	#2,lbW0083DC
	BNE.S	fdi_stadosd
	BSR.W	lbC00865E
fdi_stadosd:
	CALL	DoKeyBuffer
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.B	RawKeyCode,D0
	CMP.B	#$45,D0
	BEQ.S	fdi_stadorta
	DBRA	D7,fdi_stadosc
	MOVEQ	#0,D0
	RTS

fdi_stadort:
	MOVEQ	#-1,D0
	RTS

fdi_stadorta:
	MOVEQ	#1,D0
	RTS

*---
lbW0083DC:	dc.w	0

lbC0083DE:
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.L	#lbL030B18,$28(A1)
	MOVE.L	D5,$2C(A1)
	MOVE.L	#$1600,$24(A1)
	MOVE.W	#11,$1C(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	TST.L	D0
	BNE.S	lbC008480
	TST.B	$1F(A1)
	BNE.S	lbC008480
	TST.W	lbW008172
	BEQ.S	lbC00847C
	LEA	lbL030B18,A0
	BSR.S	lbC008484
	MOVE.L	D0,lbL008798
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.L	#lbL032118,$28(A1)
	MOVE.L	D5,$2C(A1)
	MOVE.L	#$1600,$24(A1)
	MOVE.W	#2,$1C(A1)
	CALLSYS	DoIO
	TST.L	D0
	BNE.S	lbC008480
	TST.B	$1F(A1)
	BNE.S	lbC008480
	LEA	lbL032118,A0
	BSR.S	lbC008484
	CMP.L	lbL008798(PC),D0
	BNE.S	lbC008480
lbC00847C:
	MOVEQ	#0,D0
	RTS

lbC008480:
	MOVEQ	#-1,D0
	RTS

lbC008484:
	MOVE.L	A0,-(SP)
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.W	#4,$1C(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	MOVE.L	(SP)+,A0
	MOVE.L	#$57F,D1
	MOVEQ	#0,D0
.l1:
	SUB.L	(A0)+,D0
	DBRA	D1,.l1
	MOVE.L	D0,lbL00879C
	RTS

lbC0084BA:
	LEA	lbL033B18,A1
	MOVE.L	A1,D1
	ADD.L	#$000001E4,D1
	MOVE.L	DOSBase,A6
	CALLSYS	DateStamp
	LEA	lbL033B18,A0
	MOVE.L	#$FFFFFFFF,$0138(A0)
	MOVE.L	#$00000371,$013C(A0)
	LEA	$01B0(A0),A0
	LEA	1(A0),A2
	LEA	empty.MSG(PC),A1
	MOVEQ	#0,D1
	MOVEQ	#$1F,D0
lbC0084F8:
	MOVE.B	(A1)+,D2
	BEQ.S	lbC008504
	MOVE.B	D2,(A2)+
	ADDQ.B	#1,D1
	DBRA	D0,lbC0084F8
lbC008504:
	MOVE.B	D1,(A0)
	LEA	lbL033B18,A0
	MOVE.L	#2,(A0)+
	CLR.L	(A0)+
	CLR.L	(A0)+
	MOVE.L	#$00000048,(A0)+
	CLR.L	(A0)+
	LEA	lbL033B18,A0
	LEA	$01FC(A0),A0
	MOVE.L	#1,(A0)
	BSR.S	lbC008592
	LEA	lbL033B18,A0
	MOVE.L	D0,$0014(A0)
	MOVE.L	#$0006E000,D5
	BSR.W	lbC0085C4
	BNE.S	lbC00858E
	LEA	lbL033B18,A0
	MOVEQ	#$1B,D0
lbC00854E:
	MOVE.L	#$FFFFFFFF,(A0)+
	DBRA	D0,lbC00854E
	MOVE.L	#$FFFF3FFF,(A0)+
	MOVEQ	#$1A,D0
lbC008560:
	MOVE.L	#$FFFFFFFF,(A0)+
	DBRA	D0,lbC008560
	MOVEQ	#$48,D0
lbC00856C:
	CLR.L	(A0)+
	DBRA	D0,lbC00856C
	BSR.S	lbC0085AC
	LEA	lbL033B18,A0
	MOVE.L	D0,(A0)
	MOVE.L	#$0006E200,D5
	BSR.S	lbC0085C4
	BNE.S	lbC00858E
	BSR.B	lbC008604
	BNE.S	lbC00858E
	MOVEQ	#0,D0
	RTS

lbC00858E:
	MOVEQ	#-1,D0
	RTS

lbC008592:
	LEA	lbL033B18,A0
	LEA	$0014(A0),A1
	MOVEQ	#$7F,D1
	MOVEQ	#0,D0
	MOVE.L	D0,(A1)
lbC0085A2:
	SUB.L	(A0)+,D0
	DBRA	D1,lbC0085A2
	MOVE.L	D0,(A1)
	RTS

lbC0085AC:
	LEA	lbL033B18,A0
	LEA	(A0),A1
	MOVEQ	#$7F,D1
	MOVEQ	#0,D0
	MOVE.L	D0,(A1)
lbC0085BA:
	SUB.L	(A0)+,D0
	DBRA	D1,lbC0085BA
	MOVE.L	D0,(A1)
	RTS

lbC0085C4:
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.L	#lbL033B18,$28(A1)
	MOVE.L	D5,$2C(A1)
	MOVE.L	#$200,$24(A1)
	MOVE.W	#3,$1C(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	TST.B	$1F(A1)
	BNE.S	lbC008600
	BSR.S	lbC008644
	MOVEQ	#0,D0
	RTS

lbC008600:
	MOVEQ	#-1,D0
	RTS

lbC008604:
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.L	#lbL033718,$28(A1)
	CLR.L	$2C(A1)
	MOVE.L	#$400,$24(A1)
	MOVE.W	#3,$1C(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	TST.B	$1F(A1)
	BNE.S	lbC008640
	BSR.S	lbC008644
	MOVEQ	#0,D0
	RTS

lbC008640:
	MOVEQ	#-1,D0
	RTS

lbC008644:
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.W	#4,$1C(A1)
	CALLSYS	DoIO
	RTS

lbC00865E:
	MOVE.L	lbL033718,-(SP)
	MOVE.L	#'BAD!',lbL033718
	BSR.S	lbC008604
	MOVE.L	(SP)+,lbL033718
	RTS

lbC008678:
	LEA	TrackDiskIORequest,A1
	MOVE.L	#TrackDiskPort,14(A1)
	MOVE.W	#9,$1C(A1)
	CLR.L	$24(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	RTS

lbC00869A:
	LEA	MsgPortAddr,A5
	LEA	$14(A5),A4
	MOVE.L	A4,10(A5)
	LEA	0(A5),A0
	MOVE.L	A0,0(A4)
	MOVE.L	PTProcess(PC),A0
	LEA	$5C(A0),A0
	MOVE.L	A0,4(A4)
	MOVE.L	#$1F,8(A4)
	MOVE.L	lbL0087A0(PC),$14(A4)	;prfen
	LEA	DF.MSG(PC),A0
	MOVE.L	A0,D1
	MOVE.L	DOSBase,A6
	CALLSYS	DeviceProc
	MOVE.L	D0,A0
	LEA	MsgPortAddr,A1
	MOVE.L	4.w,a6
	CALLSYS	PutMsg
	MOVE.L	PTProcess(PC),A0
	LEA	$5C(A0),A0
	CALLSYS	WaitPort
	MOVE.L	PTProcess(PC),A0
	LEA	$5C(A0),A0
	CALLSYS	GetMsg
	RTS

AddFormatPort:
	MOVE.L	PTProcess(PC),D0
	MOVE.L	D0,TaskAddr
	LEA	TrackDiskPort,A1
	MOVE.L	4.w,a6
	CALLSYS	AddPort
	LEA	TrackDiskIORequest,A1
	MOVEQ	#0,D0
	MOVE.W	lbB00816E(PC),D0
	MOVEQ	#0,D1
	LEA	TrackDiskName,A0
	CALLSYS	OpenDevice
	BNE.S	lbC008742
	MOVEQ	#0,D0
	RTS

lbC008742:
	MOVEQ	#-1,D0
	RTS

lbC008746:
	LEA	TrackDiskIORequest,A1
	MOVE.B	#1,$001E(A1)
	MOVE.W	#14,$001C(A1)
	MOVE.L	4.w,a6
	CALLSYS	DoIO
	TST.L	$0020(A1)
	BNE.S	lbC00876A
	MOVEQ	#0,D0
	RTS

lbC00876A:
	MOVEQ	#-1,D0
	RTS

CloseTDPort:
	LEA	TrackDiskIORequest,A1
	MOVE.L	4.w,a6
	CALLSYS	CloseDevice
	LEA	TrackDiskPort,A1
	CALLSYS	RemPort
	RTS

DOS0.MSG:	dc.b	'DOS0',0,0
DOS.MSG:	dc.b	'DOS',0
DF.MSG: 	dc.b	'DF'
ascii.MSG20:	dc.b	'0:',0,0,0,0
lbL008798:	dc.l	0
lbL00879C:	dc.l	0
lbL0087A0:	dc.l	$FFFFFFFF

;********************************
;* clear data/sample ... request*
;********************************

mt_cleardatas:

	cmp.l	#'CHG!',changeflag
	bne.s	cldtga
	CALL	modischanged
	cmp	#2,d0
	beq.s	cldtga
	rts
cldtga:
	LEA	ClearDatas.MSG(PC),A0
	MOVE.L	A0,-(SP)
	MOVE.W	#$FFFF,DirCopFlag
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	BSR.W	Wait_4000
	BSR.W	ClearRightAreaReq
	MOVE.L	(SP)+,A0
	LEA	SureBoxData,A1
	LEA	lbL0198AA,A2
	MOVE.L	#$00000460,D0
	BSR.W	SwapBoxMem
mt_cldta:
	BSR.W	ResetKeyTimer
	CALL	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	CMP.B	#$21,D0
	BEQ.S	lbC008860
	CMP.B	#$18,D0
	BEQ.S	lbC00885A
	CMP.B	#$20,D0
	BEQ.S	lbC008866
	CMP.B	#$33,D0
	BEQ.S	lbC008854
	CMP.B	#$45,D0
	BEQ.S	lbC008854
	checklmb
	BNE.S	mt_cldta
	MOVEM.W (MouseX),D0/D1
	LEA	TRTGadgData,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.S	mt_cldta
	CMP.W	#10,D2
	BNE.S	lbC008842
	BSR.W	Screenswitch
	BRA.S	mt_cldta

lbC008842:
	CMP.W	#1,D2
	BEQ.S	lbC00885A
	CMP.W	#2,D2
	BEQ.S	lbC008860
	CMP.W	#3,D2
	BEQ.S	lbC008866
lbC008854:
	BSR.S	lbC00886C
	MOVEQ	#-1,D0
	RTS

lbC00885A:
	BSR.S	lbC00886C
	MOVEQ	#1,D0
	RTS

lbC008860:
	BSR.S	lbC00886C
	MOVEQ	#2,D0
	RTS

lbC008866:
	BSR.S	lbC00886C
	MOVEQ	#3,D0
	RTS

lbC00886C:
	BSR.W	OpenRequester
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	BSR.W	Wait_4000
	BSR.W	WaitForButtonUp
	CLR.W	DirCopFlag
	RTS

ClearDatas.MSG:
	dc.b	10
	dc.b	10
	dc.b	'  Select what data you',$A
	dc.b	'     wish to clear.',0
	EVEN

;********************************
ClearData:
	BSR.W	mt_cleardatas
	BMI.S	.cerr
	CMP.W	#1,D0
	BEQ.S	.c_so
	CMP.W	#2,D0
	BEQ.S	.c_sa
	CMP.W	#3,D0
	BEQ.S	.c_al

.cerr:	BRA.W	SetErrorPtrCol

.c_al:	BSR.S	DoClearSong
	BSR.S	DoClearSamples
	BSR.W	SetNormalPtrCol
	BSR.W	clearcomments
	BRA.W	DisplayMainAll

.c_sa:	BSR.W	StopIt
	BSR.S	DoClearSamples
	BSR.W	SetNormalPtrCol
	MOVE.W	#1,InsNum
	BRA.W	DisplayMainAll

.c_so:	BSR.S	DoClearSong
	BSR.W	clearcomments
	BSR.W	SetNormalPtrCol
	BRA.W	DisplayMainAll


;********************************
;* Clears all samples ...       *
;********************************

DoClearSamples:
	BSR.W	FreeMemSample
	MOVE.L	mt_songdataptr,A0
	LEA	sd_sampleinfo(A0),A0	; name
	MOVE.W	#sd_numofpatt-21,D0	; #$3A1 clear samplearea after freemem

.l1:	CLR.B	(A0)+			;clear whole samplearea from #21-patternstart
	DBRA	D0,.l1

	MOVE.L	mt_songdataptr,A1
	LEA	sd_sampleinfo(A1),A1	; point to first sample
	MOVEQ	#MaxInsNum-1,D0
.lob:
	MOVE.W	#1,n_tremolocmd(A1)	; set (replen?) tremolocmd to 1
	LEA	30(A1),A1		; next samplestart
	DBRA	D0,.lob			; loop until last sample

	LEA	SamplePointers(PC),A3	; clear sample pointers
	MOVEQ	#MaxInsNum,D0
.loc:
	CLR.W	(A3)+
	DBRA	D0,.loc
	GOTO	RedrawSample

;********************************
;* Clear songdatas   ...        *
;********************************
DoClearSong:
	BSR.W	StopIt
	CLR.B	RawKeyCode
	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,A1
	MOVEQ	#20-1,D0		;clear samplename
.l1:
	CLR.B	(A0)+
	DBRA	D0,.l1
	MOVE.L	A1,A2
	add.l	PatternMemAllocSize,A2
	ADD.L	#sd_numofpatt,A1
	MOVEQ	#0,D0
.l2:
	MOVE.W	D0,(A1)+
	CMP.L	A1,A2
	BNE.S	.l2
	MOVE.L	mt_songdataptr,A0

	MOVE.W	#$017F,sd_numofpatt(A0)
	MOVE.L	#'M.K.',sd_mahokakt(A0)

	CLR.L	playpos
	CLR.L	mt_songpos
	CLR.L	mt_patternpos
	;CLR.L	PatternPtr
	CLR.L	TimerTicks
	CLR.W	BlockMarkFlag
	CLR.B	MetroChannel
	MOVE.W	#1,EditMoveAdd
	MOVEQ	#0,D0
	MOVE.W	DefaultSpeed,D0
	MOVE.L	D0,mt_speed
	MOVE.W	BPMTempo,RealTempo			;nuke
	CALL	SetTempo
	BSR.W	RestoreEffects2
	BSR.W	RestoreFKeyPos2
	BSR.W	UnMuteAll				;dont remove this
	MOVE.W	#1,InsNum
	MOVE.L	#6,mt_speed
	CLR.L	PatternNumber
	CLR.W	ScrPattPos
	BSR.W	SetScrPatternPos
	bsr.S	ClearIFFChunks
	clr.l	changeflag
	GOTO	RedrawPattern

ClearIFFChunks:
	move.l TuneRAMBit,d0
	add.l	iffmhunklength,d0
	move.l	d0,fo_length

	lea	fo_songname2,a0
	lea	fo_songname,a1
	moveq	#32,d0
clsnam:
	move.b	(A0)+,(A1)+
	dbra	d0,clsnam

	lea	fo_author2,a0
	lea	fo_author,a1
	moveq	#32,d0
clsaut:
	move.b	(A0)+,(A1)+
	dbra	d0,clsaut

	clr.w	fo_instr
	clr.w	fo_positions
	clr.w	fo_patterns
	move.w	#125,fo_dspeed
	move.w	Packetfield,fo_packetf

	clr.w	fo_creatdat_da
	clr.w	fo_creatdat_mo
	clr.w	fo_creatdat_ye
	clr.w	fo_creattime_h
	clr.w	fo_creattime_m
	clr.w	fo_creattime_s
	clr.w	fo_playtime_h
	clr.w	fo_playtime_m
	clr.w	fo_playtime_s
	clr.w	fo_playtime_ms
	clr.l	fo_modver

	lea	copintname,a0
	lea	fo_ver,a1
	moveq	#5,d0
copyrver:
	move.b	(a0)+,(A1)+
	dbra	d0,copyrver
	RTS

;***************************************
;* 2 x called (doclearall and CTRL-Q   *
;* unmute all channels                 *
;***************************************
UnMuteAll:
	MOVE.W	#1,audchan1toggle
	MOVE.W	#1,audchan2toggle
	MOVE.W	#1,audchan3toggle
	MOVE.W	#1,audchan4toggle
	MOVE.W	#1,audchan5toggle
	MOVE.W	#1,audchan6toggle
	MOVE.W	#1,audchan7toggle
	MOVE.W	#1,audchan8toggle

	;chn8test
	;bne.s	.chn4
	MOVE.W	#255,ActiveChannels
	GOTO	valmaga

;.chn4:	move.w	#$000F,ActiveChannels
;	GOTO	valmaga

;***************************************
;* 1x jumped if pressed ctrl-A         *
;* mute all channels                   *
;***************************************

ToggleMute:
	CLR.B	RawKeyCode
	TST.B	ShiftKeyStatus
	BEQ.S	.skip

	CLR.W	audchan1toggle
	CLR.W	audchan2toggle
	CLR.W	audchan3toggle
	CLR.W	audchan4toggle
	CLR.W	audchan5toggle
	CLR.W	audchan6toggle
	CLR.W	audchan7toggle
	CLR.W	audchan8toggle

.skip:
	MOVEQ	#0,D0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	MULU	#11,D0
	add.w	numchans,d0
	GOTO	ToggleChannels

RestoreEffects:
	CLR.B	RawKeyCode
	MOVEQ	#0,D0
	MOVE.W	DefaultSpeed,D0
	MOVE.L	D0,mt_speed
	MOVE.W	BPMTempo,RealTempo
	CALL	SetTempo
	BSR.S	RestoreEffects2
	CLR.B	RawKeyCode
	LEA	Effectsrestor.MSG(PC),A0
	CALL	ShowStatusText
	BSR.W	WaitALittle
	GOTO	ShowAllRight

RestoreEffects2:
	LEA	audchan1temp,A0
	BSR.S	lbC008AD4
	LEA	audchan2temp,A0
	BSR.S	lbC008AD4
	LEA	audchan3temp,A0
	BSR.S	lbC008AD4
	LEA	audchan4temp,A0
lbC008AD4:
	CLR.B	$001E(A0)
	CLR.B	$001F(A0)
	CLR.B	$0012(A0)
	CLR.B	$0022(A0)
	RTS

RestoreFKeyPos:
	CLR.B	RawKeyCode
	LEA	Positionresmt_mixfsecondtxt(PC),A0
	CALL	ShowStatusText
	CALL	WaitALittle
	CALL	ShowAllRight
RestoreFKeyPos2:
	MOVE.W	#0,F6Pos
	MOVE.W	#$0010,F7Pos
	MOVE.W	#$0020,F8Pos
	MOVE.W	#$0030,F9Pos
	MOVE.W	#$003F,F10Pos
	RTS

Effectsrestor.MSG:		dc.b	'EFFECTS RESTORED!',0
Positionresmt_mixfsecondtxt:	dc.b	'POSITION RESTORED!',0,0

;************************************
;* from Clearsamples & errorexit    *
;************************************
FreeMemSample:
	CLR.L	mt_mxbuf4base
	MOVEQ	#1,D7			; first sample
	MOVE.L	4.w,a6

.flop1:	MOVE.W	D7,D2
	LSL.W	#2,D2			; counter*20
	LEA	mt_songdataptr,A0
	MOVE.L	0(A0,D2.W),D1		; start act sample in d1
	BEQ.S	.l1
	MOVE.L	$7C(A0,D2.W),D0
	CLR.L	0(A0,D2.W)
	CLR.L	$7C(A0,D2.W)
	MOVE.L	D1,A1
	CALLSYS	FreeMem

.l1:	MOVE.W	D7,D2
	LSL.W	#3,D2			; Counter *30
	LEA	MSamPointer,A0
	ADD.W	D2,A0
	MOVE.L	(A0),D1			; samplepointer act sample
	BEQ.S	.l2
	MOVE.L	4(A0),D0		; samplelength word in d0
	CLR.L	(A0)
	CLR.L	4(A0)
	MOVE.L	D1,A1
	CALLSYS	FreeMem

.l2:	ADDQ.W	#1,D7			; add counter
	CMP.W	#MaxInsNum+1,D7		; to last sample
	BNE.S	.flop1

	MOVE.W	#1,UpdateFreeMem
	GOTO	ClearCopyBufPtr

;*************************************
;* setup screen routines             *
;*************************************

Setup:
	CMP.W	#5,CurrScreen
	BEQ.W	ExitFromSetup
	bsr.w	TopExit
	BSR.W	WaitForButtonUp
	MOVE.W	#5,CurrScreen
;	ST	NoSampleInfo
	BSR.W	Clear120Lines

	BSR.S	SwapSetupScreen
RefrSetupNow:
	BSR.W	SetScreenColors
	BSR.W	Show_MS
	cmp.w	#5,CurrScreen
	beq.s	RefreshSetup
	rts

RefreshSetup:
	BSR.W	CopyCfgData
	BSR.W	MarkColor
	BSR.W	ShowRainbow
	BSR.W	SpreadBaa
	BSR.W	RefrSetupReg
	BSR.W	ShowSplit
	BSR.W	ShowPrintPath
	;BSR.W	ShowKeyRepeat
	BSR.W	ShowConfigNumber
	BSR.W	ShowIntMode
	CALL	ShowTempo
	BSR.W	ShowSpeed
	BSR.W	GetColPos
	BSR.W	ShowColSliders
	BSR.W	ShowS2TuneNote
	BRA.W	ShowAccidental
SwapSetupScreen:
	lea	SetupScreenData,a0
	BSR.W	UpperDecrunch
	RTS



CheckSetupGadgs:
	TST.L	SplitAddress
	BEQ.S	csgskip
	CLR.L	SplitAddress
	BSR.W	ShowSplit
csgskip:
	MOVEM.W (MouseX2),D0/D1
	LEA	SetupGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	csgskip2
	RTS

csgskip2:
	CMP.W	#1,D2
	BEQ.W	ExitFromSetup
	CMP.W	#2,D2
	BEQ.W	LoadConf
	CMP.W	#3,D2
	BEQ.W	SaveConfig			;Save Config
	CMP.W	#4,D2
	BEQ.W	EnterConfigNumber
	CMP.W	#5,D2
	BEQ.W	ResetAll
	CMP.W	#7,D2
	BNE.S	nTemUp
	GOTO	TemUp
nTemUp:
	CMP.W	#8,D2
	BNE.S	nTmDown
	GOTO	TemDown
nTmDown:
	CMP.W	#10,D2
	BEQ.W	ChangeSpeed
	CMP.W	#11,D2
	BEQ.W	SpeedDown
	CMP.W	#12,D2
	BEQ.W	ToggleIntMode
	CMP.W	#14,D2
	BEQ.W	maxdmad			;dmatup
	CMP.W	#15,D2
	BEQ.W	maxdma 			;dmadown


	cmp.w	#$10,d2
	BEQ.W	maxplstd		;maxplstdown
	CMP.W	#$11,D2
	BEQ.W	maxplst 		;maxplst up
	cmp.w	#$12,d2
	beq.w	chgtestdma

	cmp.w	#$13,d2
	beq.w	setdefconf1
	cmp.w	#$14,d2
	beq.w	setdefconf3
	cmp.w	#$15,d2
	beq.w	setdefconf5
	cmp.w	#$16,d2
	beq.w	setdefconf2
	cmp.w	#$17,d2
	beq.w	setdefconf4
	cmp.w	#$18,d2
	beq.w	setdefconf6

	cmp.w	#$19,d2
	beq.w	ToggleColEdit

	CMP.W	#$1A,D2
	BEQ.W	ClearSplitTransp
	CMP.W	#$1B,D2
	BEQ.W	SetSplit
	CMP.W	#$2B,D2
	BEQ.W	ToggleAccidental
	CMP.W	#$2C,D2
	BEQ.W	PrintSong		;print the song
	CMP.W	#$2D,D2
	BEQ.W	EnterPrintPath
	CMP.W	#$2E,D2
	BEQ.W	ChgPoPacRatio
	CMP.W	#$2F,D2
	BEQ.W	VUModChg		;vumeter fake/real/none
	CMP.W	#$4C,D2
	BEQ.W	MoveScreen
	CMP.W	#$51,D2
	BEQ.W	SetS2TuneNote
	CMP.W	#$52,D2
	BEQ.W	ShowTToneVol
	CMP.W	#$53,D2
	BEQ.W	ss2tvol
	CMP.W	#$54,D2
	BEQ.W	TToneVold
	CMP.W	#$63,D2
	BEQ.W	Screenswitch
	CMP.W	#$64,D2
	BEQ.W	ToggleSplit
	CMP.W	#$65,D2
	BEQ.W	Myst1
	CMP.W	#$66,D2
	BEQ.W	NextScope
	CMP.W	#$67,D2
	BEQ.W	lbC009090
	CMP.W	#$68,D2
	BEQ.W	ChgHexDez
	CMP.W	#$69,D2
	BEQ.W	ToggleFilter
	CMP.W	#$6A,D2
	BEQ.W	ToggleNTSC
	CMP.W	#$6B,D2
	BEQ.W	ToggleLace
	CMP.W	#$6C,D2
	BEQ.W	lbC0091C4
	CMP.W	#$6D,D2
	BEQ.W	XDmaMode
	CMP.W	#$6E,D2
	BEQ.W	ToggleOverride
	CMP.W	#$6F,D2
	BEQ.W	ToggleNoSamples
	CMP.W	#$70,D2
	BEQ.W	ToggleShowDirs
	CMP.W	#$71,D2
	BEQ.W	ToggleLoadLoop
	CMP.W	#$72,D2
	BEQ.W	ToggleAutoDir
	CMP.W	#$73,D2
	BEQ.W	ToggleAutoExit
	CMP.W	#$74,D2
	BEQ.W	ToggleMultiCache
	CMP.W	#$75,D2
	BEQ.W	ToggleCutToBuf
	CMP.W	#$47,D2
	BEQ.W	SelectColor
	CMP.W	#$48,D2
	BEQ.W	SelectColor2
	CMP.W	#$76,D2
	BEQ.W	xpkeffup
	CMP.W	#$86,D2
	BEQ.W	xpkeffdo
	cmp.w	#$77,d2
	beq.w	xpkpackchg
	cmp.w	#$78,d2
	beq.w	togxpkpp		; toggle between xpk and pp save
	;cmp.w	#$79,d2
	;beq.w	SetKeyRepeat
	cmp.w	#$80,D2
	beq.w	cryptchange
	cmp.w	#$81,d2
	beq.w	modshortchange
	cmp.w	#$82,d2
	beq.w	showdatechange
	cmp.w	#$83,d2
	beq.w	Patt100Toggle
	cmp.w	#$84,D2
	BEQ.W	SoftIntOnOff

	;cmp.w	#$85,d2
	;beq.w	skrep2			; keyrepspeed
	;cmp.w	 #$86,d2
	;beq.w	 modmodechg

	cmp.w	#$87,d2
	beq.w	changemode
	cmp.w	#$88,d2
	beq.w	recoversong		;recover
	cmp.w	#$89,d2
	beq.w	fontchg
	cmp.w	#$8A,d2
	beq.w	NextFont

	TST.W	AllowColorEdit
	BNE.S	csgskip3

	CMP.W	#$40,D2
	BEQ.W	lbC00A020
	CMP.W	#$42,D2
	BEQ.W	lbC00A03A
	CMP.W	#$43,D2
	BEQ.W	CancelCol
	CMP.W	#$44,D2
	BEQ.W	SetDefaultCol
	CMP.W	#$40,D2
	BEQ.W	lbC00A020
	CMP.W	#$49,D2
	BEQ.W	SetRed2
	CMP.W	#$4A,D2
	BEQ.W	SetGreen2
	CMP.W	#$4B,D2
	BEQ.W	SetBlue2
	RTS

csgskip3:
	CMP.W	#$40,D2
	BEQ.W	lbC00A880
	CMP.W	#$41,D2
	BEQ.W	SpreadColors
	CMP.W	#$42,D2
	BEQ.W	lbC00A8A0
	CMP.W	#$43,D2
	BEQ.W	CancelCol2
	CMP.W	#$44,D2
	BEQ.W	SetDefaultCol2
	CMP.W	#$45,D2
	BEQ.W	RotColUp
	CMP.W	#$46,D2
	BEQ.W	RotColDown
	CMP.W	#$49,D2
	BEQ.W	SetRed3
	CMP.W	#$4A,D2
	BEQ.W	SetGreen3
	CMP.W	#$4B,D2
	BEQ.W	SetBlue3
	RTS

ExitFromSetup:
	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3

	BSR.W	WaitForButtonUp
	bsr.w	SwapSetupScreen
	BSR.W	mt_initbars
	CLR.L	SplitAddress
;	SF	NoSampleInfo
	CALL	mt_setupvucols
	BSR.W	Clear120Lines

	BRA.W	DisplayMainAll

RefrSetupReg:
	CMP.W	#5,CurrScreen
	BEQ.B	RefrSetupRegs2
	RTS

RefrSetupRegs2:
	BSR.W	DoMultiM
	BSR.W	ShowSetupToggles
	BSR.W	InitPacketField
	BSR.W	Myst12
	BSR.W	ChgHexchg2
	BSR.W	ShowTogAutoDir
	BSR.W	ShowTogAutoExit
	BSR.W	ShowTogOverride
	BSR.W	ShowTogNoSamples
	BSR.W	lbC00909E
	BSR.W	lbC0090B8
	BSR.W	lbC0090D2
	BSR.W	lbC0090EC
	BSR.W	lbC009132
	BSR.W	lbC0091CC
	BSR.W	lbC0091E6
	BSR.W	ShowSoftInt
	BSR.W	lbC009106
	BSR.W	lbC009200
	BSR.W	ShowFontg
	BSR.W	showtestdma
	BSR.W	vuchg2			; vumeter status
	BSR.W	xpkchg2 		; xpk packer status
	BSR.W	ShowColEdit		; analyzer/vumeter
	BSR.W	PoPacratio2
	BSR.W	togpack2		; save method packer
	BSR.W	cryptch2
	BSR.W	modshortchg2
	BSR.W	showdatechg2
	BSR.W	pattmdchg2
	;BSR.W	ShowKeyRepeat
	BSR.W	showmaxplst
	BSR.W	showmaxdma
	BSR.W	showxdma
	BSR.W	showchn
	BSR.W	showxpkeff
	BSR.W	ViewFont
	RTS

;*********************************
;* msg statustxt on/off in setup *
;*********************************

ViewOnOff:
	MOVE.W	D6,TextOffset
	LEA	off.MSG(PC),A0
	TST.B	D0
	BEQ.S	.l1
	LEA	on.MSG(PC),A0
.l1:	MOVE.W	#3,TextLength
	GOTO	ShowText2

on.MSG0:	dc.b	' ',0
on.MSG: 	dc.b	'ON ',0
off.MSG:	dc.b	'OFF ',0,0

;**********************************
ToggleSplit:
	CLR.B	RawKeyCode
	BCHG	#4,CutToBufFlag
DoMultiM:
	CALL	PrintmultiM
	BSR.W	showskips
	CMP.W	#5,CurrScreen
	BEQ.B	.l1
	RTS
.l1:	BTST	#4,CutToBufFlag
	SNE	D0
	MOVE.W	#$049E,D6
	BSR.S	ViewOnOff
	GOTO	PrintmultiM

;**********************************

xpkeffup:
	CMP.B	#100,xpkeff
	BGE.S	showxpkeff
	ADDQ.B	#1,xpkeff
	BRA.S	showxpkeff

xpkeffdo:
	TST.B	xpkeff
	BEQ.S	showxpkeff
	SUBQ.B	#1,xpkeff
	BRA.W	showxpkeff
;---
showxpkeff:

	MOVEQ	#0,D0
	MOVE.B	xpkeff,D0
	MOVE.W	D0,WordNumber
	MOVE.W	#33+113*80,TextOffset
	CALL	Print3DecDigits_2
	RTS

xpkeff:	dc.w	0

;**********************************

gto8chan:
	bclr	#5,Packetfield
	MOVE.W	#1,newalloc
	BRA.S	showmode


gto4chan:
	bset	#5,Packetfield
	MOVE.W	#1,newalloc
	BRA.S	showmode

;*******************************
;* Toggle 4/8 channel mode     *
;*******************************

changemode:
	CALL	WaitForButtonUp
	LEA	t8channel.msg,A0
	CALL	AreYouSure
	BEQ.S	.doit
	RTS

.doit:	BCHG	#5,Packetfield
	MOVE.W	#1,newalloc
	BSR.S	showmode
	;bra	showchn
	CALL	ExitFromSetup
	GOTO	RefreshScope

;*********************************
;* Draws the tracksfield in PT   *
;*********************************
showmode:
	MOVEM.L D0-A6,-(SP)
	LEA	PattBlkSize,A0
	LEA	15120-1(A0),A0			;15376 was error!
	MOVE.L	#11276,D0
.l1:	CLR.L	(A0)+				; clear patterndata
	DBRA	D0,.l1

	MOVEM.L (SP)+,D0-A6

	chn8test
	BEQ.S	.chan8

;--------------------
.chan4:
	move.w	#4,numchans
	;MOVE.W	#$000F,ActiveChannels

	LEA	audchan1toggle,A0		;VUSpriteData Pos 4chn-mode
	MOVE.W	#$3a,2(a0)
	LEA	audchan2toggle,A0
	MOVE.W	#$82,2(a0)
	LEA	audchan3toggle,A0
	MOVE.W	#$ca,2(a0)
	LEA	audchan4toggle,A0
	MOVE.W	#$112,2(a0)
	TST.W	SamScrEnable
	BEQ.S	.l5
	CALL	ExitFromSam
.l5:	TST.W	newalloc
	BEQ.S	.l6
	BSR	allocatepattbuff
.l6:	MOVE.L	#Channels4,A0
	BSR.W	LowerDecrunch
	CALL	gagame

	BSR	rd_upddirlist			;reset cursorsprite
	MOVE.B	#$F8,EmptySprite+1

	BSR	RefreshScope
	MOVE.W	#0,PattCurPos
	BRA.W	UpdateCursorPos

;----------------

.chan8:
	move.w	#8,numchans
	;MOVE.W	#255,ActiveChannels

	LEA	audchan1toggle,A0		;VUSpriteData Pos 8chn-mode
	MOVE.W	#38,2(a0)
	LEA	audchan2toggle,A0
	MOVE.W	#74,2(a0)
	LEA	audchan3toggle,A0
	MOVE.W	#110,2(a0)
	LEA	audchan4toggle,A0
	MOVE.W	#146,2(a0)

	LEA	audchan5toggle,A0
	MOVE.W	#182,2(a0)
	LEA	audchan6toggle,A0
	MOVE.W	#218,2(a0)
	LEA	audchan7toggle,A0
	MOVE.W	#254,2(a0)
	LEA	audchan8toggle,A0
	MOVE.W	#290,2(a0)

	TST.W	SamScrEnable
	BEQ.S	.l7

	CALL	ExitFromSam

.l7:	TST.W	newalloc
	BEQ.S	.l8
	BSR.S	allocatepattbuff
.l8:	MOVE.L	#Channels8,A0
	BSR.W	LowerDecrunch
	CALL	gagame

	BSR	rd_upddirlist		;reset cursorsprite
	MOVE.B	#$F8,EmptySprite+1

	BSR	RefreshScope
	MOVE.W	#0,PattCurPos
	BSR.W	UpdateCursorPos
	RTS
;---
showchn:
	lea	channeltxt(pc),a0
	moveq	#0,d0

	chn8test
	bne.s	.chn4
	moveq	#4,d0
.chn4:	lea	0(a0,d0.w),a0
	move.w	#$071E-100+16+146,d0
	move.w	#$0071-11-2,d1
	moveq	#4,d3
	GOTO	Write_Text

;***********************************
;* called from 4/8channel switcher *
;***********************************

allocatepattbuff:

	CLR.W	newalloc
	MOVE.L	mt_songdataptr,D1
	BEQ.S	.skip

	;clear song in mem

	MOVE.L	D1,A1
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem

.skip:	BSR.W	DoClearSamples
	MOVE.L	#sd_patterndata+64*1024,PatternMemAllocSize
	MOVE.L	#63,MaxPattLength

	chn8test
	BNE.S	.chn4

	;alloc for 8 chanels

	MOVE.L	#sd_patterndata+128*1024*2,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
	BRA.S	.chn4_63

	;alloc for 4 channels
.chn4:
	TST.B	patt100flag
	BEQ.S	.chn4_63
	MOVE.L	#sd_patterndata+100*1024,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength

	;alloc 4 channels 63 patterns

.chn4_63:
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,mt_songdataptr
	BNE.S	.memok

	CALL	OutOfMemErr
	BRA.W	ToggleTo100_2
.memok:
	BSR.W	DoClearSong
	CALL	DoClearSamples
	CALL	ShowSampleInfo
	CALL	RefrSetupReg
	RTS

newalloc:	dc.w	0


RefreshScope:
	cmp.w	#1,CurrScreen
	beq.b	.doit
	;cmp.w	#9,CurrScreen
	;beq.b	.doit
	RTS

.doit:	SUBQ.B	#1,ScopeAct
	CALL	ViewScopes
	BSR	WaitForButtonUp
	RTS

;***********************************

XDmaMode:
	CALL	NotAvailable
	;BCHG	#3,VModeField		;Not Yet!
	BTST	#3,VModeField
	BEQ.S	XDmaFast
	move.l	#$10002,XDmaType	;Switch to $10001!
	bra.s	showxdma

XDmaFast:
	move.l	#$10002,XDmaType
	bra.w	showxdma

showxdma:
	bclr	#3,VModeField		;cludge
	BTST	#3,VModeField
	SNE	D0
	MOVE.W	#62+113*80,D6
	BRA.W	ViewOnOff



XDmaType:	dc.l	$10002

NextFont:
		BSR.S	NextFontCh
		BSR.S	ViewFont
		bra.w	showmode

NextFontCh:	ADDQ.B	#1,FontNr
		CMP.B	#3,FontNr
		BLT.S	FontNoRes
		MOVE.b	#0,FontNr
FontNoRes:	RTS

ViewFont:
		BSR.S	ViewFont2
		;MULU	#8,D0
		LSL.L	#3,D0			;orgmulu
		LEA	FontName,A0
		ADD.L	D0,A0
		MOVE.W	#8,TextLength
		MOVE.W	#71+113*80,TextOffset
		MOVE.L	a0,ShowTextPtr
		GOTO	ShowText

ViewFont2:
		MOVEQ	#0,D0
		MOVE.B	FontNr,D0
		MOVE.L	D0,D1
		;MULU	#$800,D1
		LSL.L	#8,D1
		LSL.L	#3,D1			;orgmulu
		MOVE.L	D1,FontAdr
		RTS

FontName:	dc.b	'TOPAZ   '
		dc.b	'POTNOODL'
		dc.b	'BOLD    '

ScopeNr: 	dc.b	0,0
FontNr:		dc.b	0,0
FontAdr: 	dc.l	0
ScopeAct:	dc.w	-1


NextScope:
	BSR.S	NextScopeCh
	bra.s	ShowSetupToggles

NextScopeCh:
		ADDQ.B	#1,ScopeNr
		CMP.B	#6,ScopeNr
		BLT.S	ScopeNoRes
		MOVE.B	#0,ScopeNr
ScopeNoRes:
		RTS

NextScope2:	BSR.B	NextScopeCh
		CALL	ViewScopes
		bra.w	WaitForButtonUp

ShowSetupToggles:
	CLR.B	RawKeyCode
	CALL	PrintmultiM
	CMP.W	#5,CurrScreen
	BEQ.B	lbC008F9C
	RTS

lbC008F9C:					;View ScopeGadget
	move.w	#58+36*80,TextOffset
	move.w	#8,TextLength
	lea	ScopeText,a0
	moveq	#0,d0
	cmp.b	#6,ScopeNr
	blt.s	NoScopeRes2
	move.b	#0,ScopeNr
NoScopeRes2:
	move.b	ScopeNr,d0
	LSL.L	#3,D0				;orgmulu
	add.l	d0,a0
	move.l	a0,ShowTextPtr
	GOTO	ShowText

ScopeText:
	dc.b	'    NONE'
	dc.b	'STANDARD'
	dc.b	'   SOLID'
	dc.b	'   LINES'
	dc.b	'    2WAY'
	dc.b	'  2WAY-S'

;*****************************
ToggleFilter:
	CLR.B	RawKeyCode
	BCHG	#1,Packetfield
InitPacketField:
	BTST	#1,Packetfield
	SNE	D0
	MOVE.B	D0,D1
	NOT.B	D1
	AND.B	#1,D1
	LSL.B	#1,D1
	BCLR	#1,$BFE001
	OR.B	D1,$BFE001

	CMP.W	#5,CurrScreen
	BEQ.B	lbC008FE4
	RTS

lbC008FE4:
	MOVE.W	#$15CE,D6
	BRA.W	ViewOnOff

Myst1:
	BCHG	#1,CutToBufFlag
Myst12:
	BTST	#1,CutToBufFlag
	SNE	D0
	MOVE.W	#$080E,D6
	BRA.W	ViewOnOff

ChgHexDez:
	BCHG	#7,Packetfield
	MOVE.W	#1,UpdateFreeMem
ChgHexchg2:
	BTST	#7,Packetfield
	SNE	D0
	MOVE.W	#$125E,D6
	BRA.W	ViewOnOff


ToggleAutoDir:
		BCHG	#3,PackMode
ShowTogAutoDir:	BTST	#3,PackMode
		SNE	D0
		MOVE.W	#$126C,D6
		BRA.W	ViewOnOff

ToggleAutoExit:
		BCHG	#4,PackMode
ShowTogAutoExit:
		BTST	#4,PackMode
		SNE	D0
		MOVE.W	#$15DC,D6
		BRA.W	ViewOnOff

ToggleOverride:
		BCHG	#7,PackMode
ShowTogOverride:
		BTST	#7,PackMode
		SNE	D0
		MOVE.W	#$04AC,D6
		BRA.W	ViewOnOff

ToggleNoSamples:
		BCHG	#5,PackMode
ShowTogNoSamples:
		BTST	#5,PackMode
		SNE	D0
		MOVE.W	#$081C,D6
		BRA.W	ViewOnOff

lbC009090:	BCHG	#3,CutToBufFlag
		PEA	RedrawPattern
lbC00909E:	BTST	#3,CutToBufFlag
		SNE	D0
		MOVE.W	#$0EEE,D6
		BRA.W	ViewOnOff

ToggleShowDirs:	BCHG	#2,PackMode
lbC0090B8:	BTST	#2,PackMode
		SNE	D0
		MOVE.W	#$0B8C,D6
		BRA.W	ViewOnOff

ToggleCutToBuf:	BCHG	#5,CutToBufFlag
lbC0090D2:	BTST	#5,CutToBufFlag
		SNE	D0
		MOVE.W	#$1CBC,D6
		BRA.W	ViewOnOff

ToggleLoadLoop:	BCHG	#6,PackMode
lbC0090EC:	BTST	#6,PackMode
		SNE	D0
		MOVE.W	#$0EFC,D6
		BRA.W	ViewOnOff

ToggleNTSC:	BCHG	#0,VModeField
lbC009106:	BTST	#0,VModeField
		SNE	D0
		MOVE.W	#$193E,D6
		BSR.W	ViewOnOff
		CLR.W	ResKeyTiByte
		CLR.W	ScrPosYValue
		BTST	#0,VModeField
		BEQ.s	itspal

	move.w	#NTSCSYNC,BEAMCON0		; set display to ntsc 3.61
	bra.s	itsntsc

itspal:		move.w	#PALSYNC,BEAMCON0
itsntsc:	BSR.W	Show_MS
		RTS

ToggleLace:	BCHG	#1,VModeField
lbC009132:	BTST	#1,VModeField
		SNE	D0
		MOVE.B	D0,D1
		AND.W	#4,D1
		MOVEQ	#-5,D2
		AND.W	D2,SamCopFT+2
		OR.W	D1,SamCopFT+2
		TST.W	SamScrEnable
		BNE.S	lbC00917C
		AND.W	D2,NoteColoB+2
		OR.W	D1,NoteColoB+2
		AND.W	D2,VALCopLisa+2
		OR.W	D1,VALCopLisa+2
		AND.W	D2,VALCopLisb+2
		OR.W	D1,VALCopLisb+2

lbC00917C:	CMP.W	#5,CurrScreen
		BEQ.B	lbC009188
		RTS
;----------
lbC009188:	MOVE.W	#$1CAE,D6
		BRA.W	ViewOnOff

lbC009190:	BCHG	#0,CutToBufFlag
lbC009198:	BTST	#0,CutToBufFlag
		SNE	D0
		MOVE.W	#$2017,D6
		BRA.W	ViewOnOff

SoftIntOnOff:	BCHG	#3,Packetfield
ShowSoftInt:	BTST	#3,Packetfield
		SNE	D0
		tst.b	d0		;textoutput routine changed
		bne.s	softvbion
		moveq	#0,d0
		move.b	#$00,D0
		bra.s	softvbioff

softvbion:	moveq	#0,d0
		move.b	#$01,d0

softvbioff:	lea	onofftxt(pc),a0
		lsl.w	#2,d0
		lea	0(a0,d0.w),a0
		move.w	#$017E+13,d0
		move.w	#$0071-11-11-11-11-11,d1
		moveq	#4,d3
		GOTO	Write_Text



lbC0091C4:	BCHG	#3,InfoOnOff
lbC0091CC:	BTST	#3,InfoOnOff
		SNE	D0
		MOVE.W	#$201E,D6
		BRA.W	ViewOnOff

lbC0091E6:	BTST	#4,InfoOnOff
		SNE	D0
		MOVE.W	#$238E,D6
		BRA.W	ViewOnOff

ToggleMultiCache:
		BCHG	#2,InfoOnOff
lbC009200:	BTST	#2,InfoOnOff
		SNE	D0
		MOVE.W	#$194C,D6
		BRA.W	ViewOnOff

VUModChg:	ADDQ.B	#1,VUShowMode
		CMP.B	#3,VUShowMode
		BMI.S	VUModChg2
		CLR.B	VUShowMode
VUModChg2:	CALL	valgask
vuchg2: 	LEA	NoneFakeReal.MSG(PC),A0
		MOVEQ	#0,D0
		MOVE.B	VUShowMode,D0
		LSL.W	#2,D0
		LEA	0(A0,D0.W),A0
		MOVE.W	#$017E,D0
		MOVE.W	#$0071,D1
		MOVEQ	#4,D3
		GOTO	Write_Text

NoneFakeReal.MSG:
		dc.b	'NoneFakeReal',0
		EVEN

xpkdumtxt:	dc.b	'BLZWCBR0CRM2CRMSDMCBDUKEFASTFEALFRLEGZIPHFMNHUFFILHLBLZRIMPLLHLBLZCBMASHNUKEPASTPPMQPWPKRAKERDCNRLENSHRISQSHSMPL',0
		EVEN

packmeth:	dc.b	'PP20XPK ',0
		EVEN

onofftxt:	dc.b	'OFF ON  ',0
		EVEN

keyboardtxt:	dc.b	'USA GER EXT ',0
		EVEN

PattModeTxt:	dc.b	'64  100 ',0
		EVEN

channeltxt:	dc.b	'4CHN8CHN',0
		EVEN

pattmodeind:	dc.b	0
		EVEN

;--------------------------------------
maxplst:
	move.w	MaxPLSTEntries,d0
	add.w	#10,d0
	cmp.w	#9999,d0
	bls.s	s2pu
	move.w	#9999,d0
s2pu:	move.w	d0,MaxPLSTEntries
	bra.s	showmaxplst

maxplstd:
	moveq	#0,d0
	move	MaxPLSTEntries,D0
	addq	#1,d0
	divu.w	#10,d0
	subq	#1,d0
	bpl.s	s2pd
	moveq	#0,d0
	bra.s	s2pu
s2pd:	mulu.w	#10,d0
	bra.s	s2pu


showmaxplst:
		move.w	MaxPLSTEntries,WordNumber
		move.w	#1939+480+480+13,TextOffset
		GOTO	Print4DecDigits


maxdma:
	move.w	DMAWait,d0
	add.W	#100,d0
	cmp.w	#49999,d0
	bls.s	s2puw
	move.w	#49999,d0
s2puw:	move.w	d0,DMAWait
	bra.s	showmaxdma

maxdmad:
	moveq	#0,d0
	move.w	DMAWait,D0
	addq	#1,d0
	divu	#10,d0
	subq	#1,d0
	bpl.s	s2pdw
	moveq	#0,d0
	bra.s	s2puw
s2pdw:	mulu	#10,d0
	bra.s	s2puw

showmaxdma:
		move.w	DMAWait,D0
		move.w	DMAWait,mixingrate+2
		move.w	#1939+480+480-1,TextOffset
		GOTO	Print6DecDigits

DMAWait:	dc.w	0

;*************************
ToggleColEdit:
	CLR	SpreadFlag
	LEA	VUMeterColors,A0
	MOVEQ	#48,D0
	CMP.L	TheRightColors(PC),A0
	BNE.S	tced2
	LEA	AnalyzerColors,A0
	MOVEQ	#36,D0
tced2:	MOVE.L	A0,TheRightColors
	MOVE	D0,ColorsMax
	CMP	RainbowPos(PC),D0
	BHI.S	tced3
	CLR	RainbowPos
tced3:	BSR.W	ShowRainbow
	BSR.S	ShowColEdit
	BRA.W	WaitForButtonUp

ShowColEdit:
	LEA	cedtxt1(PC),A0
	LEA	VUMeterColors,A1
	CMP.L	TheRightColors(PC),A1
	BEQ.S	shcoed
	LEA	cedtxt2(PC),A0
shcoed:	MOVEQ	#8,D0
	move.w	#$201E-40+2-$1E0-$1E0-$1E0-240-46-40,d1
	GOTO	ShowText3

cedtxt1:	dc.b "VU-METER",0,0
cedtxt2:	dc.b "ANALYZER",0,0

;*************************
xpkpackchg:
		addq.b	#1,xpkmode
		cmp.b	#7+16+2+3,xpkmode
		bmi.s	xpkchg2
		clr.b	xpkmode
xpkchg2:
		lea	xpkdumtxt(PC),A0
		moveq	#0,D0
		move.b	xpkmode,d0
		lsl.w	#2,d0
		lea	0(a0,d0.w),a0
		move.w	#$017E-100,d0		;x-pos txt
		move.w	#$0071-11,d1		;y-pos txt
		moveq	#4,d3
		GOTO	Write_Text



fontchg:	bchg	#1,CfgFlag
ShowFontg:	btst	#1,CfgFlag
		sne	d0
		;move.w #$2371+43,D6
		move.w	#$201E-40+2,D6
		BRA.W	ViewOnOff



chgtestdma:	bchg	#1,TESTDMAFLAG
showtestdma:
		btst	#1,TESTDMAFLAG
		sne	d0
		move.w	#$201E-40+2-$1E0-$1E0+120-40,d6
		BRA.W	ViewOnOff

;-------------------------------------
recoversong:	LEA	recovertxt,A0
		BSR.W	AreYouSure
		beq.s	recoverme
		RTS

recoverme:
		BSR.W	ExitFromSetup
recovermain:
		BSR.W	StopIt
		move.w	InsNum,InsNumStore
		move.w	#$00,InsNum

		CALL	ClearSamStarts
		move.l	mt_songdataptr,a0
		lea	12(a0),a0
		moveq	#0,d0
recnext:
		move.w	InsNum,d0
		mulu	#$001E,d0
		add.l	d0,a0
		cmp.w	#0,6(a0)
		bne.s	noreprep1
		addq.w	#1,6(A0)		;min 1


noreprep1:	ADDQ	#1,InsNum		;--- repair if first 2 bytes <>0 --
		CMP.W	#MaxInsNum,InsNum
		BEQ.B	repoki
		addq.w	#1,InsNum
		BSR.W	Wait_4000
		CALL	ShowSampleInfo
		move.w	InsNum,TuneUp
		CALL	DoShowFreeMem
		bra.s	recnext

repoki:
		move.w	InsNumStore,InsNum
		CALL	ShowSampleInfo
		move.w	InsNum,TuneUp
		CALL	DoShowFreeMem
		RTS

InsNumStore:	dc.w	0

;-------------------------------------
cryptchange:	addq.b	#1,kbdmode
		cmp.b	#3,kbdmode
		bmi.s	cryptch2
		clr.b	kbdmode

cryptch2:	lea	keyboardtxt(pc),a0
		moveq	#0,d0
		move.b	kbdmode,d0
		lsl.w	#2,d0
		lea	0(a0,d0.w),a0
		move.w	#$017E-100,d0
		move.w	#$0071-11-11-11,d1
		moveq	#4,d3
		GOTO	Write_Text

modshortchange: addq.b	#1,modshortmode
		cmp.b	#2,modshortmode
		bmi.s	modshortchg2
		clr.b	modshortmode

modshortchg2:	lea	onofftxt(pc),a0
		moveq	#0,d0
		move.b	modshortmode,d0
		lsl.w	#2,d0
		lea	0(a0,d0.w),a0
		move.w	#$017E-100,d0
		move.w	#$0071-11-11-11-11-11-11,d1
		moveq	#4,d3
		GOTO	Write_Text

showdatechange: addq.b	#1,showdateflag
		cmp.b	#2,showdateflag
		bmi.s	showdatechg2
		clr.b	showdateflag
showdatechg2:	lea	onofftxt(pc),a0
		moveq	#0,d0
		move.b	showdateflag,d0
		lsl.w	#2,d0
		lea	0(a0,d0.w),a0
		move.w	#$017E-100,d0
		move.w	#$0071-11-11-11-11-11,d1
		moveq	#4,d3
		GOTO	Write_Text

Patt100Toggle:
		;chn8test
		;BEQ	no8modex
		CALL	WaitForButtonUp
		LEA	Areyousure100TXT,A0
		CALL	AreYouSure
		BEQ.S	ToggleTo100_2
no8modex:
		RTS

ToggleTo100_2:
	MOVE.L	mt_songdataptr,D1
	BEQ.S	togempsong_100
	MOVE.L	D1,A1
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
togempsong_100:
	BSR.W	DoClearSamples
	EOR.B	#1,patt100flag
	MOVE.L	#sd_patterndata+64*1024,PatternMemAllocSize
no8mode71:
	MOVE.L	#63,MaxPattLength

	chn8test
	BNE.S	.chn4

	MOVE.L	#sd_patterndata+64*1024*2,PatternMemAllocSize
	MOVE.L	#63,MaxPattLength
	bra.s	tog100small

.chn4:	TST.B	patt100flag
	BEQ.S	tog100small
	MOVE.L	#sd_patterndata+100*1024,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength

	chn8test
	bne.s	tog100small

	MOVE.L	#sd_patterndata+100*1024*2,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
tog100small:
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,mt_songdataptr
	BNE.S	tog100allok
	CALL	OutOfMemErr
	BRA.W	ToggleTo100_2

tog100allok:
	BSR.W	DoClearSong
	CALL	DoClearSamples
	CALL	ShowSampleInfo

pattmdchg2:

	lea	PattModeTxt(pc),a0
	moveq	#0,d0
	move.b	patt100flag,d0
	lsl.w	#2,d0
	lea	0(a0,d0.w),a0
	move.w	#$017E-100,d0
	move.w	#$0071-11-11-11-11,d1
	moveq	#4,d3
	GOTO	Write_Text

PatternMemAllocSize:	dc.l	sd_patterndata+64*1024
MaxPattLength:		dc.b	0,0,0,0
patt64length:		dc.b	$3F,0


;------- toggle between pp and xpk save packmethod
togxpkpp:
	addq.b	#1,xpackmode
	cmp.b	#2,xpackmode
	bmi.s	togpack2
	clr.b	xpackmode

togpack2:
	lea	packmeth(PC),a0
	moveq	#0,d0
	move.b	xpackmode,d0
	lsl.w	#2,d0
	lea	0(a0,d0.w),a0
	move.w	#$017E-100,d0
	move.w	#$0071-11-11,d1
	moveq	#4,d3
	GOTO	Write_Text


;***********************************
;* PPackerlib ratio preferences    *
;***********************************

ChgPoPacRatio:
	ADDQ.B	#1,PoPacratio
	CMP.B	#5,PoPacratio
	BMI.S	PoPacratio2
	CLR.B	PoPacratio
PoPacratio2:
	LEA	FASTMEDIUMGOO.MSG(PC),A0
	MOVEQ	#0,D0
	MOVE.B	PoPacratio,D0
	MULU	#6,D0
	LEA	0(A0,D0.W),A0
	MOVE.W	#$0172,D0
	MOVEQ	#$66,D1
	MOVEQ	#6,D3
	GOTO	Write_Text

FASTMEDIUMGOO.MSG:
	dc.b	'  FASTMEDIUM  GOODBETTER  BEST',0
	EVEN

;***********************************
;* Clear Transposes preferences    *
;***********************************

ClearSplitTransp:
	BSR.W	WaitForButtonUp
	LEA	Clearsplitand.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	Clearsplitsnow
	RTS

Clearsplitsnow:
	LEA	SplitData,A0
	MOVEQ	#15,D0
clrsplit_lp:
	CLR.B	(A0)+
	DBRA	D0,clrsplit_lp
ShowSplit:
	BSR.S	CalculateSplit
	LEA	SplitData,A3
	MOVE.L	NoteNamesPtr,A4
	MOVEQ	#0,D5
	MOVE.W	#$0488,D6
	CLR.W	WordNumber
shsploop:
	MOVE.W	D6,TextOffset
	MOVE.B	0(A3,D5.W),WordNumber+1
	CALL	PrintHexByte
	ADDQ.W	#4,D6
	MOVE.W	D6,D1
	MOVEQ	#0,D0
	MOVE.B	1(A3,D5.W),D0
	LSL.W	#2,D0
	LEA	0(A4,D0.W),A0
	MOVEQ	#4,D0
	CALL	ShowText3
	ADDQ.L	#5,D6
	MOVE.W	D6,D1
	MOVEQ	#0,D0
	MOVE.B	2(A3,D5.W),D0
	LSL.W	#2,D0
	LEA	0(A4,D0.W),A0
	MOVEQ	#4,D0
	CALL	ShowText3
	ADD.W	#$0367,D6
	ADDQ.W	#4,D5
	CMP.W	#$0010,D5
	BNE.S	shsploop
	RTS

CalculateSplit:
	LEA	SplitTransTable,A0
	LEA	SplitInstrTable,A1
	LEA	SplitData,A2
	MOVEQ	#0,D0
casploop:
	MOVE.B	D0,0(A0,D0.W)
	CLR.B	0(A1,D0.W)
	ADDQ.W	#1,D0
	CMP.W	#$0025,D0
	BLS.S	casploop
	MOVE.B	1(A2),-(SP)
	MOVE.B	5(A2),-(SP)
	MOVE.B	9(A2),-(SP)
	MOVE.B	13(A2),-(SP)		;note
	MOVEQ	#3,D4
	;move	numchans,d4
	;subq	#1,d4
caspbigloop:
	MOVEQ	#$7F,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
casploop2:
	CMP.B	1(A2,D1.W),D0	;note
	BLS.S	caspskip
	MOVE.L	D1,D2
	MOVE.B	1(A2,D1.W),D0	;note
caspskip:
	ADDQ.W	#4,D1
	CMP.W	#$0010,D1
	BNE.S	casploop2
	MOVEQ	#0,D0
	MOVE.B	1(A2,D2.W),D0		;note
	MOVE.B	#$7F,1(A2,D2.W) 	;note
	MOVE.B	2(A2,D2.W),D1		;trans
casploop3:
	MOVE.B	D1,0(A0,D0.W)
	MOVE.B	0(A2,D2.W),0(A1,D0.W)	;instr
	ADDQ.W	#1,D1
	CMP.W	#$0024,D1
	BCS.S	caspskip2
	MOVEQ	#$23,D1
caspskip2:
	ADDQ.W	#1,D0
	CMP.W	#$0024,D0
	BCS.S	casploop3
	DBRA	D4,caspbigloop

	MOVE.B	(SP)+,13(A2)
	MOVE.B	(SP)+,9(A2)
	MOVE.B	(SP)+,5(A2)
	MOVE.B	(SP)+,1(A2)		;note
	RTS

SetSplit:
	LEA	SplitData,A2
	SUBQ.W	#1,D1
	DIVU	#11,D1
	SUBQ.W	#1,D1
	MOVE.W	D1,D7
	LSL.W	#2,D7
	MULU	#$0370,D1
	ADD.W	#$0460,D1
	CMP.W	#$0182,D0
	BCC.S	SetSplitTranspose
	CMP.W	#$015A,D0
	BCC.S	SetSplitNote
	ADD.W	#$0028,D1
	MOVE.W	D1,TextOffset
	BSR.W	GetHexByte

	CMP.B	#31,D0
	BLS.S	setskip
	MOVE.B	#31,D0
setskip:
	MOVE.B	D0,0(A2,D7.W)		;instr
	BRA.W	ShowSplit

SetSplitNote:
	MOVE.L	D1,-(SP)
	BSR.W	ShowSplit
	MOVE.L	(SP)+,D1
	ADD.W	#$002C,D1
	MOVEQ	#3,D0
	LEA	SpcNoteText,A0
	CALL	ShowText3
	LEA	1(A2,D7.W),A0
	MOVE.L	A0,SplitAddress
	BRA.W	WaitForButtonUp

SetSplitTranspose:
	MOVE.L	D1,-(SP)
	BSR.W	ShowSplit
	MOVE.L	(SP)+,D1
	ADD.W	#$0031,D1
	MOVEQ	#3,D0
	LEA	SpcNoteText,A0
	CALL	ShowText3
	LEA	2(A2,D7.W),A0
	MOVE.L	A0,SplitAddress
	BRA.W	WaitForButtonUp


;***********************************
;* Keyreperat/delay preferences    *
;* included: V3.55     11.06.96    *
;* removed:  V4.0 A5   23.01.97    *
;* author:   Tom Beyer             *
;***********************************


;SetKeyRepeat:
;	move.w	#1939+480+480+15,TextOffset
;	BSR.W	GetHexByte
;	move.b	d0,KeyRepDelay+1
;	BRA.S	ShowKeyRepeat
;skrep2:
;	move.w	#1939+480+480+15+3,TextOffset
;	bsr.w	GetHexByte
;	move.b	d0,KeyRepSpeed+1
;
;ShowKeyRepeat:
;	move.w	#1939+480+480+15,TextOffset
;	move.w	KeyRepDelay,WordNumber
;	CALL	PrintHexByte
;	addq.w	#1,TextOffset
;	move.w	KeyRepSpeed,WordNumber
;	GOTO	PrintHexByte


;***********************************
;* note accidental preferences     *
;***********************************



ToggleAccidental:
	MOVE.L	#NoteNames1,NoteNamesPtr
	BCHG	#2,CutToBufFlag
	BNE.S	ShowAccidental
	MOVE.L	#NoteNames2,NoteNamesPtr


ShowAccidental:
	LEA	BA.MSG0(PC),A0
	BTST	#2,CutToBufFlag
	BEQ.S	shacskp 		;#
	LEA	BA.MSG(PC),A0		;b
shacskp:
	MOVE.W	#$0194,D0
	MOVEQ	#$45,D1
	MOVEQ	#1,D3
	CALL	Write_Text
	GOTO	RedrawPattern

BA.MSG0:	dc.b	'#',0
BA.MSG: 	dc.b	'B',0

;************************************
;* Default color config buttons 1-6 *
;* included: 24.01.97               *
;* author:   tom beyer              *
;************************************

setdefconf1:
	move.l	#def1data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.W	DefMessage
	BRA.W	RefrSetupNow

setdefconf3:
	move.l	#def3data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.S	DefMessage
	BRA.W	RefrSetupNow
setdefconf5:
	move.l	#def5data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.S	DefMessage
	BRA.W	RefrSetupNow
setdefconf2:
	move.l	#def2data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.S	DefMessage
	BRA.W	RefrSetupNow
setdefconf4:
	move.l	#def4data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.S	DefMessage
	BRA.W	RefrSetupNow
setdefconf6:
	move.l	#def6data,SCRNConfBuf
	bsr.s	defcopy
	BSR.W	SetSCRNSettings
	BSR.S	DefMessage
	BRA.W	RefrSetupNow


defcopy:
	MOVE.L	SCRNConfBuf(PC),A0
	SUB.L	#SetupData,A0
	ADD.L	#InternalCfgData,A0
	MOVE.L	A0,DefCol
	LEA	$0010(A0),A0
	MOVE.L	A0,ColorBuf2
	rts

DefMessage:
	lea	DefMessage.MSG,a0
	CALL	ShowStatusText
	CALL	WaitALittle
	GOTO	ShowAllRight

DefMessage.MSG:
	dc.b	'USE QUICKSET-COLORS',0

;************************************
;* Load configuration from setup    *
;************************************
LoadConf:
	LEA	LoadConfig.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	LoadConf2
	RTS

LoadConf2:
	BSR.W	WaitForButtonUp
	LEA	loadingconfig.MSG(PC),A0
	CALL	ShowStatusText

DoLoadConfig:
	BSR.W	StorePtrCol
	BSR.W	PutConfigNumber
	LEA	FileNameCfg,A1
	MOVE.W	#'S:',(A1)+
	LEA	ConfigName(PC),A0
	MOVEQ	#12,D0
.loo:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo

	MOVE.L	#FileNameCfg,D1
	MOVE.L	#$000003ED,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	ConfigErr
	BSR.W	SetDiskPtrCol
	BSR.W	ReadHeader		;read first 8 bytes
	BEQ.W	ErrorReadConf		;error while reading

	CMP.L	#'FORM',(A0)
	BNE.W	ConfigErr2
	CMP.L	#'PTCO',8(A0)
	BNE.W	ConfigErr2		;not a config file

mt_ldconfloop:
	BSR.W	read8bytes
	BMI.W	ErrorReadConf
	BEQ.S	CloseConfigLoad 	;end loading
	MOVE.L	D0,byteslbm8buf
	CMP.L	#'MISC',(A0)
	BEQ.W	ld_miscsettings
	CMP.L	#'SCRN',(A0)
	BEQ.W	ld_scrnsettings
	CMP.L	#'EDIT',(A0)
	BEQ.W	ld_editsettings
	CMP.L	#'DISK',(A0)
	BEQ.W	ld_disksettings
	BSR.W	SeekReadConfig
	BNE.W	ErrorReadConf		;error
	BRA.S	mt_ldconfloop		;loop

CloseConfigLoad:
	;bclr	#5,Packetfield		;cludge
	CLR.L	DiskDataLength
	MOVE.L	FileHandle,D1
	BEQ.S	mt_confclos
	MOVE.L	DOSBase,A6
	CALLSYS	Close
mt_confclos:
	CLR.W	checknewmode

	chn8test
	BNE.S	oh4mode
	MOVE.W	#1,checknewmode

oh4mode:
	CALL	ShowAllRight
	BSR.W	RestorePtrCol
	BSR.W	SetAllSettings
	bra.s	oh4mode2
setthis:
	CLR.W	checknewmode

	chn8test
	BNE.S	oh4mode2
	MOVE.W	#1,checknewmode
oh4mode2:
	BSR.W	InitPacketField

	CALL	mt_setupvucols		;samscrenable

	chn8test
	BNE.S	.chn4

	CMP.W	#1,checknewmode
	BEQ.S	checkmodesokay
	move.w	#1,newalloc
	CALL	showmode
	bra.s	checkmodesokay

.chn4:	TST.W	checknewmode
	BEQ.S	checkmodesokay
	move.w	#1,newalloc
	CALL	showmode

checkmodesokay:

;*****************************
;* included for correct      *
;* accidental showing at the *
;* start                     *
;*****************************

	BSR.W	RefrSetupNow
	btst	#2,CutToBufFlag 	;accidental test from config
	beq.s	skipbflag
	move.l	#NoteNames2,NoteNamesPtr

skipbflag:
	RTS

checknewmode	dc.w	0
byteslbm8buf:	dc.l	0

;*****************************
;* gets loaded config parts  *
;*****************************

ld_miscsettings:
	MOVE.L	MiscConfBuf(PC),D2
	BEQ.W	mt_ldconfloop		;back
	MOVE.L	D2,A0
	MOVE.L	byteslbm8buf(PC),D0
	BSR.W	CalcChunkLength
	BEQ.W	  CloseConfigLoad
	BMI.B	ErrorReadConf
	BRA.W	mt_ldconfloop		;back

ld_scrnsettings:
	MOVE.L	SCRNConfBuf(PC),D2
	BEQ.W	mt_ldconfloop
	MOVE.L	D2,A0
	MOVE.L	byteslbm8buf(PC),D0
	BSR.W	CalcChunkLength
	BEQ.W	CloseConfigLoad
	BMI.S	ErrorReadConf
	BRA.W	mt_ldconfloop

ld_editsettings:
	MOVE.L	EDITConfBuf(PC),D2
	BEQ.W	mt_ldconfloop
	MOVE.L	D2,A0
	MOVE.L	byteslbm8buf(PC),D0
	BSR.W	CalcChunkLength
	BEQ.W	CloseConfigLoad
	BMI.S	ErrorReadConf
	BRA.W	mt_ldconfloop

ld_disksettings:
	MOVE.L	DISKConfBuf(PC),D2
	BEQ.W	mt_ldconfloop
	MOVE.L	D2,A0
	MOVE.L	byteslbm8buf(PC),D0
	BSR.W	CalcChunkLength
	BEQ.W	CloseConfigLoad
	BMI.S	ErrorReadConf
	BRA.W	mt_ldconfloop

ConfigErr:
	LEA	FileNotFoundText(PC),A0
	BRA.S	lcfgend

ConfigErr2:
	LEA	NotAConfFileText(PC),A0
	BRA.S	lcfgend

ErrorReadConf:
	LEA	ConfWhileRead.MSG(PC),A0

lcfgend:
	CALL	ShowStatusText
	TST.L	CopListPtr	;valid pt screen?
	BNE.S	lcfgend2
	RTS

lcfgend2:
	BRA.W	CloseConfigLoad

MiscConfBuf:	dc.l	0
SCRNConfBuf:	dc.l	0
EDITConfBuf:	dc.l	0
DISKConfBuf:	dc.l	0
DefCol:		dc.l	0
ColorBuf2:	dc.l	0

;*******************************
;* save config button in setup *
;*******************************

SaveConfig:
	LEA	Saveconfigura.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	saveconfigyes
	RTS

saveconfigyes:
	BSR.W	StorePtrCol
	BSR.W	SetDiskPtrCol
	BSR.W	PutConfigNumber
	LEA	savingconfig.MSG(PC),A0
	CALL	ShowStatusText
	BSR.W	PutAllSettings
	MOVE.L	DOSBase,A6
	LEA	FileNameCfg,A1
	MOVE.W	#'S:',(A1)+
	LEA	ConfigName(PC),A0
	MOVEQ	#12,D0
conffilesieve:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,conffilesieve
	MOVE.L	#FileNameCfg,D1
	MOVE.L	#$000003EE,D2
	CALLSYS	Open
	MOVE.L	D0,D7
	BEQ.S	ConfigErr3
	MOVE.L	D0,D1			;file
	LEA	SetupData,A0
	MOVE.L	A0,D2			;buffer
	MOVE.L	4(A0),D3		;length
	ADDQ.L	#8,D3			;old
	CALLSYS	Write
	MOVE.L	D7,D1
	CALLSYS	Close
	CALL	ShowAllRight
	BRA.W	RestorePtrCol

ConfigErr3:
	LEA	CantCreateFiText(PC),A0
	CALL	ShowStatusText
	TST.L	CopListPtr
	BNE.S	PrintAndWait
	RTS

PrintAndWait:
	BSR	WaitALittle
	BRA.W	ErrorRestoreCol



;*************************
;* config number part    *
;*************************

EnterConfigNumber:
	MOVE.W	#$07DB,TextOffset
	BSR.W	GetHexByte
	MOVE.W	D0,ConfigNumSlot

ShowConfigNumber:
	MOVE.W	#$07DB,TextOffset
	MOVE.W	ConfigNumSlot(PC),WordNumber
	GOTO	PrintHexByte

PutConfigNumber:
	MOVE.W	ConfigNumSlot(PC),D0
	LEA	ConfigNumber(PC),A0
	GOTO	IntToHex2

loadingconfig.MSG:	dc.b	'LOADING CONFIG',0
			EVEN

savingconfig.MSG:	dc.b	'SAVING CONFIG',0
			EVEN

configpath:		dc.b	'S:'
			EVEN

FileNotFoundText:	dc.b	'CONFIG NOT FOUND!',0
			EVEN

NotAConfFileText:	dc.b	'NOT A CONFIG FILE',0
			EVEN

CantCreateFiText:	dc.b	'CAN''T CREATE FILE',0
			EVEN

ConfWhileRead.MSG:	dc.b	'ERROR WHILE READING CONFIG',0
			EVEN

ConfigName:		dc.b	'PT.config-00'
ConfigNumber:		dc.w	0
ConfigNumSlot:		dc.w	0
			EVEN

;**************************
;* internal config datas  *
;**************************

GetStandardConfig:
	LEA	PTConfHeader,A0
	LEA	SetupData,A1
	move.w	#configlength+8-1,d0
.loo:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo			;to setupdata

	LEA	CfgBuf,A0
	MOVE.L	(A0)+,D1
	BEQ.S	mt_setoldcolors
	BTST	#0,D1
	BNE.S	mt_setoldcolors
	LEA	0(A0,D1.L),A1
	LEA	4(A0),A0

GetMiscST:
	MOVE.L	(A0),D1
	CMP.L	#'MISC',D1
	BNE.S	GetSCRNST
	MOVE.L	A0,MiscConfBuf

GetSCRNST:
	CMP.L	#'SCRN',D1
	BNE.S	GetEDITST
	MOVE.L	A0,SCRNConfBuf

GetEDITST:
	CMP.L	#'EDIT',D1
	BNE.S	GetDISKST
	MOVE.L	A0,EDITConfBuf

GetDISKST:
	CMP.L	#'DISK',D1
	BNE.S	StdCfgOkExit
	MOVE.L	A0,DISKConfBuf

StdCfgOkExit:
	ADDQ.L	#4,A0
	MOVE.L	(A0)+,D1
	BLE.S	mt_setoldcolors
	BTST	#0,D1
	BNE.S	mt_setoldcolors
	ADD.L	D1,A0
	CMP.L	A1,A0
	BLE.S	GetMiscST

mt_setoldcolors:
	MOVE.L	SCRNConfBuf(PC),A0
	SUB.L	#SetupData,A0
	ADD.L	#InternalCfgData,A0
	MOVE.L	A0,DefCol
	LEA	$0010(A0),A0
	MOVE.L	A0,ColorBuf2
	BSR.S	SetAllSettings
	BSR.W	InitPacketField
	RTS

;********************************
;* reset to internal config data*
;********************************

ResetAll:
	LEA	Resettheconfi.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	DoResetAll
	RTS

DoResetAll:
	BSR.W	GetStandardConfig
	MOVE.L	GfxBase,A0
	MOVE.W	$00CE(A0),D0			; DisplayFlags
	BTST	#2,D0				; NTSC?
	BEQ.S	mt_resetall			; NTSC
	BCLR	#0,VModeField			; allow refresh
	BRA.S	mt_resetall_rt

mt_resetall:
	BSET	#0,VModeField
mt_resetall_rt:
	BRA.W	RefrSetupNow

;******************************
;* get taken settings ...     *
;******************************

SetAllSettings:
	BSR.S	SetMiscSettings
	BSR.W	SetSCRNSettings
	BSR.W	SetEditSettings
	BSR.W	SetDISKSettings
	move.w	#125,BPMTempo
	move.w	#6,DefaultSpeed
	RTS

SetMiscSettings:
	MOVE.L	MiscConfBuf(PC),D0
	BEQ.W	MSCSetRet
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	MOVE.L	(A0)+,CfgDummy4		;Packetfield
	MOVE.W	(A0)+,TuneTone
	MOVE.W	(A0)+,TToneVol

	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,BPMTempo

	MOVE.W	BPMTempo,RealTempo
	MOVE.W	(A0)+,DefaultSpeed
	MOVE.W	(A0)+,D0

	LEA	PrintSongPath,A1
	MOVEQ	#$1F,D0
.loo:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo

	move.w	(A0)+,OptScrFlag
	move.w	(A0)+,RecordMode	;new in 3.55
	move.b	(A0)+,xpkmode
	move.b	(A0)+,modmode
	move.b	(A0)+,xpkeff
	move.b	(A0)+,xpackmode
	move.w	(A0)+,modshortmode
	move.b	(A0)+,showdateflag
	move.b	(A0)+,CfgFlag

	move.b	(A0)+,patt100flag
	move.b	(A0)+,kbdmode
	move.w	(A0)+,KeyRepDelay
	move.w	(A0)+,KeyRepSpeed
	move.w	(A0)+,Volume
	move.w	(A0)+,MaxPLSTEntries
	move.w	(A0)+,ScopeNr
	move.w	(A0)+,FilterArt
	move.b	(A0)+,MultiFlag
	move.b	(A0)+,SampleAllFlag
	move.b	(A0)+,QuantizeValue
	move.b	(A0)+,MetroSpeed
	move.b	(A0)+,MetroChannel
	move.b	(A0)+,AutoInsFlag
	move.b	(A0)+,CutToBufFlag
	move.b	(A0)+,TESTDMAFLAG
	move.w	(A0)+,DMAWait
	move.b	(A0)+,pnoteflag
	move.b	(A0)+,sam_editflag
	move.b	(A0)+,HalfClipFlag
	move.b	(A0)+,VUSpriteMode

	cmp.b	#100,xpkeff
	blt.s	MSCSetRet
	move.b	#100,xpkeff

MSCSetRet:
	CMP.b	#3,FontNr
	BLT.S	MSCSetRet2
	CLR.B	FontNr

MSCSetRet2:

;	cmp.w	#6,ScopeNr
;	bhi.s	clrsco
;	move.w	#1,ScopeNr
clrsco:

	;CALL	settofour		;4channel mode on 4.0
	RTS


;*********************************
;* 1x called from SetallSettings *
;*********************************

SetSCRNSettings:
	MOVE.L	SCRNConfBuf(PC),D0
	BEQ.S	SCRSetRet
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	MOVE.L	(A0)+,CfgDummy2		;VModeField
	MOVE.W	(A0)+,ScreenPosX
	MOVE.W	(A0)+,ScreenPosY
	LEA	ColorTable,A1

	MOVEQ	#7,D0			;8 colors
.loo:	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.loo

	LEA	VUMeterColors,A1
	MOVEQ	#48-1,D0
.lob:
	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.lob
	MOVE.B	(A0)+,VUShowMode

	lea	AnalyzerColors,a1
	move.w	#40-1+151,d0
.loc:
	move.w	(A0)+,(A1)+
	dbra	d0,.loc

SCRSetRet:
	RTS

;********************************

SetEditSettings:
	MOVE.L	EDITConfBuf(PC),D0
	BEQ.S	EDITSetRet
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	MOVE.L	(A0)+,CfgDummy3		;CutToBufFlag
	MOVE.L	(A0)+,MultiModeNext
	move.l	(a0)+,MultiModeNext8
	LEA	SplitData,A1
	MOVEQ	#15,D0			;16 splitdatas

.loo:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loo
	LEA	EffectMacros,A1
	MOVEQ	#9,D0			;10 effectmacros
.lob:	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.lob
EDITSetRet:
	RTS

;*******************************

SetDISKSettings:
	MOVE.L	DISKConfBuf(PC),D0
	BEQ.S	SetDISKRet
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	move.w	(A0)+,CfgDummy1
	move.b	(A0)+,InfoOnOff
	move.b	(A0)+,PackMode
	MOVE.B	(A0)+,RAWIFFMode
	MOVE.B	(A0)+,PoPacratio

	LEA	ModulesPath2,A1
	LEA	FilePatternData,A2
	MOVEQ	#5,D0			;6 patterns

.lob:	MOVEQ	#32-1+50,D1
.loo:	MOVE.B	(A0),(A1)+
	MOVE.B	(A0)+,(A2)+
	DBRA	D1,.loo
	LEA	45+32-1(A0),A0
	DBRA	D0,.lob

	LEA	MatchPatterns,A1
	MOVE.W	#32*6-1,D0
.loc:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loc

SetDISKRet:
	RTS


;*******************************
;*  cfg-parameters for saving  *
;*******************************

PutAllSettings:
	BSR.S	sa_miscsettings
	BSR.W	sa_scrnsettings
	BSR.W	sa_editsettings
	BSR.W	sa_disksettings
	RTS

;**************************

sa_miscsettings:
	MOVE.L	MiscConfBuf(PC),D0
	BEQ.W	PtMscSet_rt
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	move.l	CfgDummy4,(A0)+		;Packetfield
	MOVE.W	TuneTone,(A0)+
	MOVE.W	TToneVol,(A0)+
	move.w	#$1F,(A0)+
	MOVE.W	BPMTempo,(A0)+
	MOVE.W	DefaultSpeed,(A0)+
	CLR.W	(A0)+

	LEA	PrintSongPath,A1
	MOVEQ	#$1F,D0
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loo

	move.w	OptScrFlag,(A0)+
	move.w	RecordMode,(A0)+
	move.b	xpkmode,(A0)+
	move.b	modmode,(a0)+
	move.b	xpkeff,(a0)+
	move.b	xpackmode,(A0)+
	move.w	modshortmode,(a0)+
	move.b	showdateflag,(a0)+
	move.b	CfgFlag,(A0)+

	move.b	patt100flag,(a0)+
	move.b	kbdmode,(a0)+
	move.w	KeyRepDelay,(a0)+
	move.w	KeyRepSpeed,(a0)+
	move.w	Volume,(a0)+
	move.w	MaxPLSTEntries,(A0)+
	move.w	ScopeNr,(A0)+
	move.w	FilterArt,(A0)+
	move.b	MultiFlag,(A0)+
	move.b	SampleAllFlag,(A0)+
	move.b	QuantizeValue,(A0)+
	move.b	MetroSpeed,(A0)+
	move.b	MetroChannel,(A0)+
	move.b	AutoInsFlag,(A0)+
	move.b	CutToBufFlag,(A0)+
	move.b	TESTDMAFLAG,(A0)+
	move.w	DMAWait,(A0)+
	move.b	pnoteflag,(A0)+
	move.b	sam_editflag,(A0)+
	move.b	HalfClipFlag,(A0)+
	move.b	VUSpriteMode,(A0)+
PtMscSet_rt:
	RTS

;**************************

sa_scrnsettings:
	MOVE.L	SCRNConfBuf(PC),D0
	BEQ.S	PtScrnSet_rt
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	MOVE.L	CfgDummy2,(A0)+		;VModeField
	MOVE.W	ScreenPosX,(A0)+
	MOVE.W	ScreenPosY,(A0)+
	LEA	ColorTable,A1
	MOVEQ	#7,D0

.loo:
	MOVE.W	(A1)+,(A0)+
	DBRA	D0,.loo

	LEA	VUMeterColors,A1
	MOVEQ	#48-1,D0
.lob:
	MOVE.W	(A1)+,(A0)+
	DBRA	D0,.lob

	MOVE.B	VUShowMode,(A0)+

	lea	AnalyzerColors,a1
	move.w	#40-1+151,d0
.loc:
	move.w	(A1)+,(A0)+
	dbra	d0,.loc

PtScrnSet_rt:
	RTS

;***************************

sa_editsettings:
	MOVE.L	EDITConfBuf(PC),D0
	BEQ.S	sa_edstgrt
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	MOVE.L	CfgDummy3,(A0)+		;CutToBufFlag
	MOVE.L	MultiModeNext,(A0)+
	move.l	MultiModeNext8,(A0)+
	LEA	SplitData,A1
	MOVEQ	#15,D0
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loo
	LEA	EffectMacros,A1
	MOVEQ	#10-1,D0
.lob:
	MOVE.W	(A1)+,(A0)+
	DBRA	D0,.lob

sa_edstgrt:
	RTS

;***************************
sa_disksettings:
	MOVE.L	DISKConfBuf(PC),D0
	BEQ.S	sa_dskstgskp
	ADDQ.L	#8,D0
	MOVE.L	D0,A0
	move.w	CfgDummy1,(A0)+
	move.b	InfoOnOff,(A0)+
	move.b	PackMode,(A0)+
	MOVE.B	RAWIFFMode,(A0)+
	MOVE.B	PoPacratio,(A0)+
	LEA	ModulesPath2,A1
	MOVEQ	#5,D0
.lob:
	MOVEQ	#32-1+50,D1
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D1,.loo
	LEA	45+32-1(A0),A0
	DBRA	D0,.lob

	LEA	MatchPatterns,A1
	MOVE.W	#32*6-1,D0
.loc:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.loc

sa_dskstgskp:
	RTS


;********************************
;* load config, check IFF header*
;********************************

ReadHeader:
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#12,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Read
	CMP.L	#12,D3
	BNE.S	ConfHeadShorter		;shorter than 12 Bytes?
	LEA	fourbytebuf,A0
	MOVE.L	4(A0),D0
	SUBQ.L	#4,D0
	;MOVE.L	D0,ConfSubPointer	;useless, removed
	MOVE.L	D0,mt_seekconfigcounter
	RTS

ConfHeadShorter:
	MOVEQ	#0,D0
	RTS

read8bytes:
	TST.L	mt_seekconfigcounter
	BEQ.S	mt_cfgseekend
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#8,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Read
	CMP.L	#8,D0			;8 Bytes
	BNE.S	lbm_rderr
	SUB.L	D0,mt_seekconfigcounter
	BMI.S	lbm_rderr
	LEA	fourbytebuf,A0
	MOVE.L	4(A0),D0
	RTS

mt_cfgseekend:
	MOVEQ	#0,D0
	RTS

lbm_rderr:
	MOVEQ	#-1,D0
	RTS

;***************************

SeekReadConfig:
	SUB.L	D0,mt_seekconfigcounter
	BMI.S	mt_cfgskrderr
	MOVE.L	FileHandle,D1
	MOVE.L	D0,D2
	MOVEQ	#0,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Seek
	MOVEQ	#0,D0
	RTS

mt_cfgskrderr:
	MOVEQ	#-1,D0
	RTS

;***************************

mt_seekread:
	MOVE.L	FileHandle,D1
	MOVE.L	A0,D2
	MOVE.L	D0,D3
	MOVE.L	DOSBase,A6
	MOVE.L	D3,-(SP)
	CALLSYS	Read
	MOVE.L	(SP)+,D3
	CMP.L	D0,D3
	BNE.S	mt_seekreaderr
	SUB.L	D0,mt_seekconfigcounter
	BMI.S	mt_seekreaderr
	MOVE.L	mt_seekconfigcounter(PC),D0
	RTS

mt_seekreaderr:
	MOVEQ	#-1,D0
	RTS

;***************************
;calculates chunk length   *
;***************************

CalcChunkLength:
	MOVE.L	4(A0),D1
	MOVE.L	D0,D2
	SUB.L	D1,D2
	BPL.S	clcchlgt2
	MOVEQ	#0,D2
	EXG	D0,D1
clcchlgt2:
	MOVE.L	D1,D0
	LEA	8(A0),A0
	MOVE.L	D2,D7
	BSR.B	mt_seekread
	BMI.S	clcchlgt5
	BEQ.S	clcchlgt4
	MOVE.L	D7,D0
	BEQ.S	clcchlgt3
	BSR.B	SeekReadConfig
	BNE.S	clcchlgt5
clcchlgt3:
	MOVEQ	#1,D0
	RTS

clcchlgt4:
	MOVEQ	#0,D0
	RTS

clcchlgt5:
	MOVEQ	#-1,D0
	RTS

mt_seekconfigcounter:
	dc.l	0

;********************************
;* color slider in setup screen *
;********************************

SetRed2:

	;BSR.W	ResetKeyTimer
	BSR.S	GetColPos
	AND.W	#$0F00,D2	;red
	LSR.W	#8,D2
	CMP.B	D2,D0
	BEQ.S	setrsk2
	AND.W	#$00FF,D1	;red
	LSL.W	#8,D0
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.W	ShowColSliders
	BSR.W	SetScreenColors
setrsk2:
	checklmb
	BEQ.S	SetRed2
	RTS

SetGreen2:
	;BSR.W	ResetKeyTimer
	BSR.S	GetColPos
	AND.W	#$00F0,D2	;green
	LSR.W	#4,D2
	CMP.B	D2,D0
	BEQ.S	ChGreenNo
	AND.W	#$0F0F,D1	;green
	LSL.W	#4,D0
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.B	ShowColSliders
	BSR.W	SetScreenColors
ChGreenNo:
	checklmb
	BEQ.S	SetGreen2
	RTS

SetBlue2:
	;BSR.W	ResetKeyTimer
	BSR.S	GetColPos
	AND.W	#15,D2		;blue
	CMP.B	D2,D0
	BEQ.S	ChBlueNo
	AND.W	#$0FF0,D1	;blue
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.S	ShowColSliders
	BSR.W	SetScreenColors
ChBlueNo:
	checklmb
	BEQ.S	SetBlue2
	RTS

;********************************
;* called from colorsliders and *
;* analyzercolorclicks          *
;********************************

;D2 returns color

GetColPos:

	MOVEQ	#0,D0
	MOVE.W	MouseX,D0
	CMP.W	#$001A,D0
	BCC.S	gcpskp
	MOVEQ	#0,D0
	BRA.S	gcpskp2

gcpskp:
	SUB.W	#$001A,D0
	DIVU	#3,D0
	AND.L	#$FF,D0
	CMP.W	#15,D0
	BLS.S	gcpskp2
	MOVEQ	#15,D0
gcpskp2:
	TST.W	AllowColorEdit
	BNE.W	GetColAddr
	LEA	ColorTable,A0
	MOVE.W	CurrColor,D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	(A0),D1
	MOVE.W	D1,D2
	RTS

;***************************

ShowColSliders:
	LEA	ColSliders(PC),A2
	MOVE.L	TextBplPtr,A1
	ADD.L	#$15E2,A1
	BSR.S	gcpskp2
	AND.W	#15,D1
	BSR.S	ShowOneSlider
	MOVE.L	TextBplPtr,A1
	ADD.L	#$1272,A1
	BSR.S	gcpskp2
	AND.W	#$00F0,D1
	LSR.W	#4,D1
	BSR.S	ShowOneSlider
	MOVE.L	TextBplPtr,A1
	ADD.L	#$0F02,A1
	BSR.S	gcpskp2
	AND.W	#$0F00,D1
	LSR.W	#8,D1
ShowOneSlider:
	CLR.L	(A1)
	CLR.L	4(A1)
	CLR.L	$0050(A1)
	CLR.L	$0054(A1)
	CLR.L	$00A0(A1)
	CLR.L	$00A4(A1)
	MOVE.W	D1,D3
	ADD.W	D3,D3
	ADD.W	D3,D3
	MOVE.W	2(A2,D3.W),D4
	MOVE.B	0(A2,D3.W),0(A1,D4.W)
	MOVE.B	1(A2,D3.W),1(A1,D4.W)
	MOVE.B	0(A2,D3.W),$50(A1,D4.W)
	MOVE.B	1(A2,D3.W),$51(A1,D4.W)

	MOVE.L	A1,-(SP)
	ADD.L	#$000000A0,A1
	MOVE.B	0(A2,D3.W),0(A1,D4.W)
	MOVE.B	1(A2,D3.W),1(A1,D4.W)
	MOVE.L	(SP)+,A1
	RTS

ColSliders:

	dc.w %0000000001111100,0
	dc.w %0000111110000000,1
	dc.w %0000000111110000,1
	dc.w %0000000000111110,1
	dc.w %0000011111000000,2
	dc.w %0000000011111000,2
	dc.w %0000000000011111,2
	dc.w %0000001111100000,3
	dc.w %0000000001111100,3
	dc.w %0000111110000000,4
	dc.w %0000000111110000,4
	dc.w %0000000000111110,4
	dc.w %0000011111000000,5
	dc.w %0000000011111000,5
	dc.w %0000000000011111,5
	dc.w %0000001111100000,6

;*****************************************
;* select one of the eight screen colors *
;*****************************************

SelectColor:

	TST.W	AllowColorEdit
	BEQ.S	mt_colfield
	MOVEM.W D0/D1,-(SP)
	BSR.W	SpreadBab
	MOVEM.W (SP)+,D0/D1

mt_colfield:
	CLR.W	AllowColorEdit
	MOVE.L	TextBplPtr,A0
	LEA	$0F0A(A0),A0
	MOVEQ	#$18,D2

.loo:
	CLR.L	(A0)
	LEA	$0050(A0),A0
	DBRA	D2,.loo

	SUB.W	#$0052,D0
	DIVU	#13,D0
	SUB.W	#$0031,D1
	DIVU	#6,D1
	MOVE.W	D0,D2
	LSL.W	#2,D2
	ADD.W	D1,D2
	MOVE.W	D2,CurrColor

MarkColor:

	BSR.W	gcpskp2
	MOVE.L	A0,UndoColAddr
	MOVE.W	D1,UndoCol
	BSR.W	ShowColSliders
	BSR.S	BlockColors
	MOVE.W	CurrColor,D0
	MOVE.W	D0,D1
	AND.W	#3,D1
	MULU	#12*40,D1
	MOVE.L	TextBplPtr,A0
	ADD.L	D1,A0
	LEA	$0F0A(A0),A0
	BTST	#2,D0
	BNE.S	slcskip
	MOVE.W	#$3FF0,(A0)
	MOVE.W	#$3FF0,$01E0(A0)
	MOVEQ	#4,D0
.loo:
	LEA	$0050(A0),A0
	MOVE.W	#$2010,(A0)
	DBRA	D0,.loo

	BSR.S	lbC009FAE
	BSR.W	lbC009FE8
	BRA.W	WaitForButtonUp

slcskip:
	MOVE.L	#$0001FF80,(A0)
	MOVE.L	#$0001FF80,$01E0(A0)
	MOVEQ	#4,D0
.lob:
	LEA	$0050(A0),A0
	MOVE.L	#$0001FF80,(A0)
	DBRA	D0,.lob

	BSR.S	lbC009FAE
	BSR.S	lbC009FE8
	BRA.W	WaitForButtonUp

BlockColors:
	MOVE.L	TextBplPtr,A0
	LEA	$0F5C(A0),A0
	MOVEQ	#3,D1
.lod:
	MOVEQ	#4,D0
.loc:
	MOVE.B	#$FF,(A0)
	ADD.L	#$00000050,A0
	DBRA	D0,.loc
	ADD.L	#$00000050,A0
	DBRA	D1,.lod
	RTS

lbC009FAE:
	TST.W	lbW00A056
	BNE.S	lbC009FB8
	RTS

lbC009FB8:
	CLR.W	lbW00A056
	LEA	ColorTable,A0
	MOVE.W	lbW00A054(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	(A0),D2
	LEA	ColorTable,A0
	MOVE.W	CurrColor(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	D2,(A0)
	BSR.W	SetScreenColors
	RTS

lbC009FE8:
	TST.W	lbW00A05A
	BNE.S	lbC009FF2
	RTS

lbC009FF2:
	CLR.W	lbW00A05A
	LEA	ColorTable,A0
	MOVE.L	A0,A1
	MOVE.W	lbW00A058(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	CurrColor(PC),D1
	ADD.W	D1,D1
	LEA	0(A1,D1.W),A1
	MOVE.W	(A0),D2
	MOVE.W	(A1),(A0)
	MOVE.W	D2,(A1)
	BSR.W	SetScreenColors
	RTS

lbC00A020:
	MOVE.W	CurrColor,lbW00A054
	MOVE.W	#1,lbW00A056
	CLR.W	lbW00A05A
	RTS

lbC00A03A:
	MOVE.W	CurrColor,lbW00A058
	MOVE.W	#1,lbW00A05A
	CLR.W	lbW00A056
	RTS

lbW00A054:	dc.w	0
lbW00A056:	dc.w	0
lbW00A058:	dc.w	0
lbW00A05A:	dc.w	0,$2079
		dc.l	UndoColAddr
		dc.w	$3039
		dc.l	UndoCol
		dc.w	$33D0
		dc.l	UndoCol
		dc.w	$3080,$6100,$FD6E,$6000,$00C6


;****************************
lbC00A078:
	MOVE.L	TextBplPtr,A0
	LEA	$0F0A(A0),A0
	MOVEQ	#3,D0
lbC00A084:
	CLR.L	(A0)
	MOVE.L	#$0000FF00,$0050(A0)
	MOVE.L	#$0000FF00,$00A0(A0)
	MOVE.L	#$0000FF00,$00F0(A0)
	MOVE.L	#$0000FF00,$0140(A0)
	MOVE.L	#$0000FF00,$0190(A0)
	CLR.L	$01E0(A0)
	LEA	$01E0(A0),A0
	DBRA	D0,lbC00A084
	CLR.W	lbW00A056
	CLR.W	lbW00A05A
	RTS

CancelCol:
	LEA	CanCols(PC),A0
	LEA	ColorTable,A1
	MOVEQ	#7,D0
.loo:
	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.loo

	BSR.W	ShowColSliders
	BRA.S	SetScreenColors

CopyCfgData:
	LEA	ColorTable,A0
	LEA	CanCols(PC),A1
	MOVEQ	#7,D0
.loo:
	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.loo
	LEA	VUMeterColors,A0
	LEA	SaveColors,A1
	MOVEQ	#$57,D0
.lob:
	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.lob
	RTS

UndoCol:	dc.w	0
UndoColAddr:	dc.l	0
CanCols:	dc.w	0,0,0,0,0,0,0,0

;****************************
SetDefaultCol:
	MOVE.L	DefCol,A0
	LEA	ColorTable,A1
	MOVEQ	#7,D0
.loo:
	MOVE.W	(A0)+,(A1)+
	DBRA	D0,.loo

	BSR.W	ShowColSliders

SetScreenColors:
	LEA	ColorTable,A0
	LEA	CopCol0,A1
	MOVE.W	(A0),(A1)
	MOVE.W	2(A0),4(A1)
	MOVE.W	4(A0),8(A1)
	MOVE.W	6(A0),12(A1)
	MOVE.W	8(A0),$0010(A1)
	MOVE.W	10(A0),$0014(A1)
	MOVE.W	12(A0),$0018(A1)
	MOVE.W	14(A0),$001C(A1)
	MOVE.W	14(A0),D0
	TST.W	SamScrEnable
	BEQ.S	sscnosc
	MOVE.W	8(A0),NoteColoB+2
	BRA.S	sscnosd

sscnosc:
	MOVE.W	D0,NoteCol+2
	MOVE.W	10(A0),NoteColoCo+2
sscnosd:
	MOVE.W	10(A0),D0
	MOVE.W	D0,D4
	MOVE.W	#5,FadeX
	BSR.S	FadeCol
	MOVE.W	D0,$0020(A1)
	MOVE.W	D4,$0024(A1)
	MOVE.W	D4,D0
	MOVE.W	#$FFFC,FadeX
	BSR.S	FadeCol
	MOVE.W	D0,$0028(A1)
	RTS

FadeCol:
	MOVE.W	D0,D1
	MOVE.W	D0,D2
	MOVE.W	D0,D3
	LSR.W	#8,D1
	ADD.W	FadeX(PC),D1
	BPL.S	redskp
	MOVEQ	#0,D1
redskp:
	CMP.W	#15,D1
	BLS.S	redskp2
	MOVEQ	#15,D1
redskp2:
	AND.W	#$00F0,D2
	LSR.W	#4,D2
	ADD.W	FadeX(PC),D2
	BPL.S	grnskp
	MOVEQ	#0,D2
grnskp:
	CMP.W	#15,D2
	BLS.S	grnskp2
	MOVEQ	#15,D2
grnskp2:
	AND.W	#15,D3
	ADD.W	FadeX(PC),D3
	BPL.S	blueskp
	MOVEQ	#0,D3
blueskp:
	CMP.W	#15,D3
	BLS.S	blueskp2
	MOVEQ	#15,D3
blueskp2:
	MOVE.W	D3,D0
	LSL.W	#4,D2
	OR.W	D2,D0
	LSL.W	#8,D1
	OR.W	D1,D0
	RTS

CurrColor:	dc.w	0
FadeX:		dc.w	-3

EnterPrintPath:
	BSR.W	StorePtrCol
	BSR.W	SetWaitPtrCol
	LEA	PrintSongPath,A6
	MOVE.L	A6,ShowTextPtr
	MOVE.L	A6,TextEndPtr
	add.l	#$1E,TextEndPtr
	;ADD.L	#$1F,TextEndPtr
	MOVE.W	#12,TextLength
	MOVE.W	#$1C98,A4
	BSR.W	GetTextLine
	BRA.W	RestorePtrCol

ShowPrintPath:
	LEA	PrintSongPath,A0
	MOVE.W	#$1C98,D1
	MOVEQ	#12,D0
	GOTO	ShowText3

PrintSong:
	LEA	Printthesong.MSG,A0
	BSR.W	AreYouSure
	BEQ.S	PrintSong2
	RTS

PrintSong2:
	BSR.W	StorePtrCol
	MOVE.L	#PrintSongPath,D1
	MOVE.L	#$000003EE,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BNE.S	PrintSongG
	GOTO	CantOpenFile

PrintSongG:
	BSR.W	SetDiskPtrCol
	LEA	Printingsong.MSG,A0
	CALL	ShowStatusText
	MOVE.L	FileHandle,D1
	MOVE.L	#SongDumpText,D2
	MOVEQ	#$44,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Write
	MOVE.L	FileHandle,D1
	MOVE.L	mt_songdataptr,D2
	MOVEQ	#$14,D3
	CALLSYS	Write
	BSR.W	PrintCRLF
	BSR.W	PrintCRLF
	BSR.S	PrintSong3
	BSR.W	PrintCRLF
	BSR.W	PrintSong4
	BSR.W	PrintFormFeed
	MOVE.L	mt_songdataptr,A0
	MOVEQ	#0,D0

	MOVE.B	sd_numofpatt(A0),D0
	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D7
ps_loop:
	CMP.B	0(A0,D0.W),D7
	BGT.S	ps_skip
	MOVE.B	0(A0,D0.W),D7
ps_skip:
	SUBQ.W	#1,D0
	BPL.S	ps_loop
	MOVEQ	#0,D1
ps_loop2:
	MOVEM.L D1-D7/A0-A6,-(SP)
	BSR.W	PrintPattern
	MOVEM.L (SP)+,D1-D7/A0-A6
	TST.L	D0
	BNE.S	ps_skip2
	MOVEM.L D1/D7,-(SP)
	BSR.W	PrintFormFeed
	MOVEM.L (SP)+,D1/D7
	ADDQ.W	#1,D1
	CMP.W	D7,D1
	BCS.S	ps_loop2
ps_skip2:
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	CALLSYS	Close
	CLR.L	FileHandle
	CALL	ShowAllRight
	BRA.W	RestorePtrCol

PrintSong3:
	MOVEQ	#1,D7
ps2_2:
	MOVE.L	D7,D0
	LSR.B	#4,D0
	CMP.B	#9,D0
	BLS.S	spujk
	ADDQ.B	#7,D0
spujk:
	ADD.B	#$30,D0
	MOVE.B	D0,PattXText1
	MOVE.B	D7,D0
	AND.B	#15,D0
	CMP.B	#9,D0
	BLS.S	spujk2
	ADDQ.B	#7,D0
spujk2:
	ADD.B	#$30,D0
	MOVE.B	D0,PattXText2
	MOVE.L	mt_songdataptr,A0
	MOVE.W	D7,D0
	MULU	#30,D0
	LEA	-10(A0,D0.W),A0
	LEA	PpText,A1
	MOVEQ	#$15,D0
.loo:
	MOVE.B	#32,(A1)+
	DBRA	D0,.loo

	LEA	PpText,A1
	MOVE.L	A0,SavIt
ps2_loop2:
	MOVE.B	(A0)+,D0
	BEQ.S	mt_printsong3
	MOVE.B	D0,(A1)+
	BRA.S	ps2_loop2

SavIt:	dc.l	0

mt_printsong3:
	MOVE.L	D7,-(SP)
	MOVE.L	SavIt(PC),A0
	MOVE.W	$0016(A0),D0
	ADD.W	D0,D0
	LEA	ascii.MSG1,A0
	CALL	IntToHexASCII			;!!!
	MOVE.L	SavIt(PC),A0
	MOVE.W	$001A(A0),D0
	ADD.W	D0,D0
	LEA	ascii.MSG2,A0
	CALL	IntToHexASCII
	MOVE.L	SavIt(PC),A0
	MOVE.W	$001C(A0),D0
	ADD.W	D0,D0
	LEA	ascii.MSG3,A0
	CALL	IntToHexASCII
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	#PtotText,D2
	MOVEQ	#$34,D3
	CALLSYS	Write
	MOVE.L	(SP)+,D7
	ADDQ.W	#1,D7
	CMP.W	#$0020,D7
	BNE.W	ps2_2
	RTS



PrintSong4:
	MOVE.L	mt_songdataptr,A0
	MOVEQ	#0,D7

	MOVE.B	sd_numofpatt(A0),D7
	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D5
ps4_loop1:
	MOVEQ	#0,D6
ps4_loop2:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	MOVE.W	D0,D1
	LSR.W	#4,D1
	ADD.B	#$30,D1
	CMP.B	#$39,D1
	BLS.S	ps4_skip2
	ADDQ.B	#7,D1
ps4_skip2:
	AND.B	#15,D0
	ADD.B	#$30,D0
	CMP.B	#$39,D0
	BLS.S	ps4_skip
	ADDQ.B	#7,D0
ps4_skip:
	LEA	PnText,A1
	MOVE.B	D1,(A1)+
	MOVE.B	D0,(A1)
	MOVEM.L D5-D7/A0,-(SP)
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	#PnText,D2
	MOVEQ	#4,D3
	CALLSYS	Write
	MOVEM.L (SP)+,D5-D7/A0
	ADDQ.W	#1,D5
	CMP.W	D5,D7
	BNE.S	ps4_cont
	RTS

ps4_cont:
	ADDQ.W	#1,D6
	CMP.W	#$0010,D6
	BNE.S	ps4_loop2
	MOVEM.L D5-D7/A0,-(SP)
	BSR.S	PrintCRLF
	MOVEM.L (SP)+,D5-D7/A0
	BRA.S	ps4_loop1

PrintCRLF:
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	#CRLF_Text,D2
	MOVEQ	#2,D3
	CALLSYS	Write
	RTS

PrintFormFeed:
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	#FF_Text,D2
	MOVEQ	#1,D3
	CALLSYS	Write
	RTS

PrintPattern:
	MOVE.L	D1,D6
	DIVU	#10,D6
	ADD.B	#$30,D6
	MOVE.B	D6,PattNumText1
	SWAP	D6
	ADD.B	#$30,D6
	MOVE.B	D6,PattNumText2
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	FileHandle,D1
	MOVE.L	#PatternNumText,D2
	MOVEQ	#$12,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Write
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	D1,D6
	MOVE.L	mt_songdataptr,A6
	LEA	sd_patterndata(A6),A6
	LSL.L	#8,D6
	LSL.L	#2,D6

	chn8test
	BNE.S	.chn4
	LSL.L	#1,D6

.chn4:	ADD.L	D6,A6
	CLR.L	PPattPos
	MOVEQ	#0,D6
pp_posloop:
	MOVEQ	#0,D7
	MOVE.W	#2,TextLength
	MOVE.L	PPattPos,D1
	LEA	PattPosText,A5
	DIVU	#10,D1
	ADD.B	#$30,D1
	MOVE.B	D1,(A5)+
	CLR.W	D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,(A5)+
	ADDQ.L	#5,A5
pp_noteloop:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.W	#3,TextLength
	MOVE.W	(A6),D1
	AND.W	#$0FFF,D1
	LEA	mt_periodtable,A0
pp_findloop:
	CMP.W	0(A0,D0.L),D1
	BEQ.S	PrintNote
	ADDQ.L	#2,D0
	BRA.S	pp_findloop

PrintNote:
	ADD.L	D0,D0
	ADD.L	NoteNamesPtr,D0
	MOVE.L	D0,A0
	MOVE.L	(A0),(A5)+
	CMP.B	#$A1,-3(A5)
	BNE.S	prnoxyz
	MOVE.B	#$62,-3(A5)
prnoxyz:
	ADDQ.L	#1,A5
	MOVEQ	#0,D0
	MOVE.W	(A6),D0
	AND.W	#$F000,D0
	LSR.W	#8,D0
	LSL.L	#1,D0
	LEA	FastHexTable,A0
	ADD.L	D0,A0
	MOVE.B	(A0),(A5)+
	MOVEQ	#0,D0
	MOVE.B	2(A6),D0
	LSL.L	#1,D0
	LEA	FastHexTable,A0
	ADD.L	D0,A0
	MOVE.W	(A0),(A5)+
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	LSL.L	#1,D0
	LEA	FastHexTable,A0
	ADD.L	D0,A0
	MOVE.W	(A0),(A5)+
	ADDQ.L	#4,A5
	ADDQ.L	#4,A6
	ADDQ.L	#1,D7
	CMP.L	#4,D7
	BNE.W	pp_noteloop
	ADDQ.L	#1,PPattPos
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	#ascii.MSG9,D2
	MOVEQ	#$44,D3
	CALLSYS	Write
	BSR.W	PrintCRLF
	MOVEM.L (SP)+,D0-D7/A0-A6
	checkrmb
	BEQ.S	NegativeReturn
	ADDQ.L	#1,D6
	CMP.L	#64,D6				; pattern end ?
	BNE.W	pp_posloop
	MOVEQ	#0,D0
	RTS

NegativeReturn:
	MOVEQ	#-1,D0
	RTS

;******************************
;* Setup 2                    *
;******************************

ToggleIntMode:
	BCHG	#0,Packetfield
	CALL	SetTempo
ShowIntMode:
	LEA	VBLANK.MSG(PC),A0
	BTST	#0,Packetfield
	BEQ.S	simskip
	LEA	CIA.MSG(PC),A0
simskip:
	MOVEQ	#6,D0
	MOVE.W	#$07E4,D1
	GOTO	ShowText3

VBLANK.MSG:	dc.b	'VBLANK',0,0
CIA.MSG:	dc.b	' CIA  ',0,0

;******************************
ChangeSpeed:
	MOVE.W	DefaultSpeed,D1
	ADDQ.B	#1,D1
	CMP.B	#$FF,D1
	BLS.S	speedup2
	MOVE.W	#$FF,D1
speedup2:
	MOVE.W	D1,DefaultSpeed
	MOVE.L	D1,mt_speed
	BSR.S	ShowSpeed
	BSR.W	Wait_4000
	BRA.W	Wait_4000

ShowSpeed:
	MOVE.W	#$0474,TextOffset
	MOVE.W	DefaultSpeed,WordNumber
	GOTO	PrintHexByte

SpeedDown:
	MOVE.W	DefaultSpeed,D1
	SUBQ.B	#1,D1
	CMP.B	#1,D1
	BCC.S	speedup2
	MOVEQ	#1,D1
	BRA.S	speedup2

SetS2TuneNote:
	LEA	SpcNoteText,A0
	MOVE.W	#$011C,D0
	MOVEQ	#14,D1
	MOVEQ	#3,D3
	CALL	Write_Text
	MOVE.W	#3,SamNotetype
	MOVE.L	#TuneTone,SplitAddress
	BRA.W	WaitForButtonUp

ShowS2TuneNote:
	MOVE.L	NoteNamesPtr,A4
	MOVE.W	TuneTone,D0
	LSL.W	#2,D0
	LEA	0(A4,D0.W),A0
	MOVE.W	#$011C,D0
	MOVEQ	#14,D1
	MOVEQ	#4,D3
	CALL	Write_Text
	MOVE.W	TToneVol,WordNumber
	MOVE.W	#$0116,D0
	MOVEQ	#$19,D1
	GOTO	lbC013442

ss2tvol:
	BSR.W	WaitForButtonUp
	ADDQ.W	#1,TToneVol
	CMP.W	#$0040,TToneVol
	BMI.S	ss2tvol2
	MOVE.W	#$0040,TToneVol
ss2tvol2:
	BRA.S	ShowS2TuneNote

TToneVold:
	BSR.W	WaitForButtonUp
	SUBQ.W	#1,TToneVol
	BPL.S	TToneVol3
	CLR.W	TToneVol
TToneVol3:
	BRA.S	ShowS2TuneNote

ShowTToneVol:
	MOVE.W	#$0116,D0
	MOVEQ	#$1A,D1
	BSR.W	GetHexByte3
	MOVE.W	D0,TToneVol
	BRA.S	ShowS2TuneNote

;******************************

RotColUp:
	CLR.W	SpreadFlag
	MOVE.L	TheRightColors(PC),A0
	MOVE.W	(A0),D0
	MOVEQ	#$30,D1
	SUBQ.W	#2,D1
.loo:
	MOVE.W	2(A0),(A0)+
	DBRA	D1,.loo
	MOVE.W	D0,(A0)
rocoup2:
	BSR.W	GetColPos
	BSR.W	ShowColSliders
	BSR.W	ShowRainbow
	GOTO	mt_setupvucols

RotColDown:
	CLR.W	SpreadFlag
	MOVE.L	TheRightColors(PC),A0
	MOVEQ	#$30,D1
	ADD.W	D1,A0
	ADD.W	D1,A0
	MOVE.W	-(A0),D0
	SUBQ.W	#2,D1
.loo:
	MOVE.W	-2(A0),(A0)
	SUBQ.L	#2,A0
	DBRA	D1,.loo
	MOVE.W	D0,(A0)
	BRA.S	rocoup2

SpreadColors:
	MOVE.W	RainbowPos,SpreadFrom
	MOVE.W	#1,SpreadFlag
	CLR.W	lbW00A8C6
	CLR.W	lbW00A8CA
	RTS

lbC00A880:
	MOVE.W	RainbowPos,lbW00A8C4
	MOVE.W	#1,lbW00A8C6
	CLR.W	lbW00A8CA
	CLR.W	SpreadFlag
	RTS

lbC00A8A0:
	MOVE.W	RainbowPos,lbW00A8C8
	MOVE.W	#1,lbW00A8CA
	CLR.W	lbW00A8C6
	CLR.W	SpreadFlag
	RTS

SpreadFrom:	dc.w	0
SpreadFlag:	dc.w	0
lbW00A8C4:	dc.w	0
lbW00A8C6:	dc.w	0
lbW00A8C8:	dc.w	0
lbW00A8CA:
	dc.w	0,$2079
	dc.l	UndoColAddr
	dc.w	$3239
	dc.l	UndoCol
	dc.w	$33D0
	dc.l	UndoCol
	dc.w	$3081,$6000,$FF4A

;************************************

SetDefaultCol2:
	MOVE.L	TheRightColors(PC),A0
	MOVE.L	ColorBuf2,A1
sedeco4:
	MOVEQ	#$30,D0
	BRA.S	sedeco3

sedeko4:
	MOVE.W	(A1)+,(A0)+
sedeco3:
	DBRA	D0,sedeco4
	BRA.W	rocoup2

CancelCol2:
	MOVE.L	TheRightColors(PC),A0
	MOVE.L	A0,A1
	SUB.L	#VUMeterColors,A1
	ADD.L	#SaveColors,A1
	BRA.S	sedeco4

GetColAddr:
	MOVE.L	TheRightColors(PC),A0
	MOVE.W	RainbowPos,D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	(A0),D1
	MOVE.W	D1,D2
	RTS

SetRed3:
	;BSR.W	ResetKeyTimer
	BSR.W	GetColPos
	AND.W	#$0F00,D2
	LSR.W	#8,D2
	CMP.B	D2,D0
	BEQ.S	settrsk22
	AND.W	#$00FF,D1
	LSL.W	#8,D0
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.W	ShowColSliders
	BSR.W	ShowRainbow
	CALL	mt_setupvucols
settrsk22:
	checklmb
	BEQ.S	SetRed3
	RTS

SetGreen3:
	;BSR.W	ResetKeyTimer
	BSR.W	GetColPos
	AND.W	#$00F0,D2
	LSR.W	#4,D2
	CMP.B	D2,D0
	BEQ.S	setgsk22
	AND.W	#$0F0F,D1
	LSL.W	#4,D0
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.W	ShowColSliders
	BSR.W	ShowRainbow
	CALL	mt_setupvucols
setgsk22:
	checklmb
	BEQ.S	SetGreen3
	RTS

SetBlue3:
	BSR.W	ResetKeyTimer
	BSR.W	GetColPos
	AND.W	#$000F,D2
	CMP.B	D2,D0
	BEQ.S	setbsk22
	AND.W	#$0FF0,D1
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	BSR.W	ShowColSliders
	BSR.W	ShowRainbow
	CALL	mt_setupvucols
setbsk22:
	checklmb
	BEQ.S	SetBlue3
	RTS

SelectColor2:
	TST.W	AllowColorEdit
	BNE.S	selcolo22
	BSR.W	lbC00A078
selcolo22:
	MOVE.W	#$FFFF,AllowColorEdit
	MOVEQ	#0,D7
setcolp:
	BSR.W	ResetKeyTimer
	checklmb
	BNE.S	ChkSpread
	MOVEQ	#$30,D0
	MOVE.W	MouseY,D1
	CMP.W	D7,D1
	BEQ.S	setcolp
	MOVE.W	D1,D7
	CMP.W	#$0030,D1
	BCC.S	setcolv
	MOVEQ	#$30,D1
setcolv:
	SUB.W	#$0030,D1
	CMP.W	D0,D1
	BLT.S	setcol2
	MOVE.W	D0,D1
	SUBQ.W	#1,D1
setcol2:
	MOVE.W	D1,RainbowPos
	BSR.W	ShowRainbow
	BSR.W	GetColPos
	MOVE.L	A0,UndoColAddr
	MOVE.W	D1,UndoCol
	BSR.W	ShowColSliders
	BRA.B	setcolp

ChkSpread:
	TST.W	SpreadFlag
	BEQ.W	SpreadBez 		;3.15
	CLR.W	SpreadFlag
	BSR.W	GetColPos
	MOVE.W	SpreadFrom,D0
	MOVE.W	RainbowPos,D1
	CMP.W	D1,D0
	BCS.S	chkspr2
	EXG	D0,D1
chkspr2:
	MOVE.W	D1,D4
	SUB.W	D0,D4
	CMP.W	#1,D4
	BHI.S	chkspraf
	RTS

chkspraf:
	MOVE.L	D4,A2
	ADD.W	D4,D4
	MOVE.L	TheRightColors(PC),A0
	MOVE.L	A0,A1
	ADD.W	D0,D0
	ADD.W	D1,D1
	LEA	0(A0,D0.W),A0	;1st col
	MOVE.W	(A0),D2
	LEA	0(A1,D1.W),A1	;2th col
	MOVE.W	(A1),D3
	MOVEQ	#0,D5
sprdlop:
	MOVE.W	D2,D0		;red
	LSR.W	#8,D0
	MOVE.W	D3,D1
	LSR.W	#8,D1
	BSR.S	ColCrossFade
	LSL.W	#8,D0
	MOVE.W	D0,D7
	MOVE.W	D2,D0		;green
	LSR.W	#4,D0
	AND.W	#15,D0
	MOVE.W	D3,D1
	LSR.W	#4,D1
	AND.W	#15,D1
	BSR.S	ColCrossFade
	LSL.W	#4,D0
	OR.W	D0,D7
	MOVE.W	D2,D0		;blue
	AND.W	#15,D0
	MOVE.W	D3,D1
	AND.W	#15,D1
	BSR.S	ColCrossFade
	OR.W	D0,D7
	ADDQ.W	#2,D5
	MOVE.W	D7,(A0)+
	CMP.L	A1,A0
	BCS.B	sprdlop
	BRA.W	rocoup2

ColCrossFade:
	MOVE.W	D4,D6
	SUB.W	D5,D6
	MULU	D6,D0
	ADD.L	A2,D0
	MULU	D5,D1
	ADD.W	D1,D0
	DIVU	D4,D0
	CMP.W	#15,D0
	BHI.S	ColCrossFade1a
	RTS

ColCrossFade1a:
	MOVEQ	#15,D0
	RTS

;*********************************

SpreadBez:
	TST.W	lbW00A8C6
	BEQ.S	SpreadBoz
	CLR.W	lbW00A8C6
	MOVE.L	TheRightColors(PC),A0
	MOVE.W	lbW00A8C4(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	(A0),D2
	MOVE.L	TheRightColors(PC),A0
	MOVE.W	RainbowPos(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	D2,(A0)
	BRA.W	rocoup2

SpreadBoz:
	TST.W	lbW00A8CA
	BNE.S	SpreadBcz
	RTS

SpreadBcz:
	CLR.W	lbW00A8CA
	MOVE.L	TheRightColors(PC),A0
	MOVE.L	A0,A1
	MOVE.W	lbW00A8C8(PC),D1
	ADD.W	D1,D1
	LEA	0(A0,D1.W),A0
	MOVE.W	RainbowPos(PC),D1
	ADD.W	D1,D1
	LEA	0(A1,D1.W),A1
	MOVE.W	(A0),D2
	MOVE.W	(A1),(A0)
	MOVE.W	D2,(A1)
	BRA.W	rocoup2

SpreadBaa:
	TST.W	AllowColorEdit
	BNE.W	lbC00A078
SpreadBab:
	MOVE.W	RainbowPos(PC),-(SP)
	MOVE.W	#$FFFF,RainbowPos
	BSR.S	ShowRainbow
	MOVE.W	(SP)+,RainbowPos
	CLR.W	SpreadFlag
	CLR.W	lbW00A8C6
	CLR.W	lbW00A8CA
	RTS

;*****************************

ShowRainbow:
	CALL	UpdIfCfgOpen			;3.15
	MOVE.L	TextBplPtr,A0
	LEA	$0EBD(A0),A0
	MOVEQ	#0,D1
	MOVE.L	#$0007FF00,D2
	MOVE.W	RainbowPos,D3
rainlop:
	MOVE.L	D2,D0
	CMP.W	D3,D1
	BNE.S	rainsk1
	MOVE.L	#$00F7FF78,D0
rainsk1:
	MOVE.L	D0,basejumpk
	MOVE.B	basejumpk(PC),(A0)	;1
	MOVE.B	basejumpk+1(PC),1(A0)	;2
	MOVE.B	basejumpk+2(PC),2(A0)	;3
	MOVE.B	basejumpk+3(PC),3(A0)	;4
	LEA	$0050(A0),A0
	ADDQ.W	#1,D1
	CMP.W	#$0030,D1
	BCS.S	rainlop
rainsk5:
	LEA	CopListAnalyzer,A0
	MOVE.L	TheRightColors(PC),A1
	MOVE.W	#$005B,D0
	ADD.W	ScreenPosY,D0
	SUB.W	ScrPosYValue,D0
	LSL.W	#8,D0
	OR.B	#7,D0
	MOVEQ	#$2F,D1
	MOVEQ	#0,D2
rainsk4:
	MOVE.W	D0,(A0)+
	MOVE.W	#$FFFE,(A0)+
	MOVE.W	#$01AA,(A0)+
	CMP.W	#$0030,D2
	BCS.S	rainsk2
	CLR.W	(A0)+
	BRA.S	rainsk3

rainsk2:
	MOVE.W	(A1)+,(A0)+
rainsk3:
	ADD.W	#256,D0			;screenheight
	ADDQ.W	#1,D2
	DBRA	D1,rainsk4
	MOVEQ	#63,D0
.loo:
	MOVE.L	#$01A80000,(A0)+
	DBRA	D0,.loo
	RTS

;*******************************
mt_initbars:
	MOVE.B	#$F8,ScrollerSprite1+1
	LEA	CopListAnalyzer,A0
	MOVE.W	#91,D0
	ADD.W	ScreenPosY,D0
	SUB.W	ScrPosYValue,D0
	LSL.W	#8,D0
	OR.B	#7,D0
	MOVEQ	#47,D1
	MOVEQ	#0,D2
rainlp22:
	MOVE.W	D0,(A0)+
	MOVE.W	#$FFFE,(A0)+
	MOVE.W	#424,(A0)+
	CMP.W	#48,D2
	BCS.S	mtvaltu
	CLR.W	(A0)+
	BRA.S	rainsk33
;-----
mtvaltu:
	CLR.W	(A0)+
rainsk33:
	ADD.W	#256,D0			;screenheight
	ADDQ.W	#1,D2
	DBRA	D1,rainlp22

	MOVEQ	#MaxPattPos,D0
.loo:	MOVE.L	#$01A80000,(A0)+
	DBRA	D0,.loo
	RTS

AllowColorEdit:	dc.w	0
basejumpk:	dc.l	0
RainbowPos:	dc.w	0
TheRightColors: dc.l	0
ColorsMax:	dc.w	48


MoveScreen:
	MOVE.W	#$FFFF,MouseFreezeFlag		;freeze mousesprite
	CLR.L	MouseFlag
MScreenlop:
	checklmb
	BNE.S	EndMoveScreen
	TST.L	MouseFlag
	BEQ.S	MScreenlop
	MOVEM.W (MouseFlag),D0/D1
	CLR.L	MouseFlag
	ADD.W	D0,ScreenPosX
	ADD.W	D1,ScreenPosY
	BSR.S	Show_MS
	BRA.S	MScreenlop

EndMoveScreen:
	CLR.L	MouseFlag
	CLR.W	MouseFreezeFlag
	RTS

Show_MS:
	MOVE.W	ScreenPosX(PC),D0
	CMP.W	#$FFF0,D0
	BPL.S	Show_MS1
	MOVEQ	#-$10,D0
Show_MS1:
	CMP.W	#15,D0
	BMI.S	Show_MS2
	MOVEQ	#15,D0
Show_MS2:
	MOVE.W	ScreenPosY(PC),D1
	CMP.W	#$FFF3,D1
	BPL.S	Show_MS3
	MOVEQ	#-13,D1
Show_MS3:
	CMP.W	#13,D1
	BMI.S	Show_MS4
	MOVEQ	#13,D1
Show_MS4:
	MOVE.W	D0,ScreenPosX
	MOVE.W	D1,ScreenPosY
	BSR.W	OLotScrenPos
	MOVE.W	ScreenPosX(PC),D0
	MOVE.W	D0,D1
	ADD.W	#129,D1
	MOVE.B	D1,lbB02F79A+3		;ok
	ADD.W	#64,D1
	MOVE.B	D1,lbB02F79E+3		;ok
	MOVE.W	D0,D1
	AND.W	#15,D1
	MOVE.W	D1,D2
	LSL.W	#4,D2
	OR.W	D2,D1
	MOVE.W	D1,lbW02F7B2+2
	MOVE.W	D0,D1
	AND.W	#$FFF8,D1
	LSR.W	#1,D1
	ADD.W	#60,D1
	MOVE.W	D1,lbW02F7A2+2
	ADD.W	#152,D1
	MOVE.W	D1,lbW02F7A6+2
	MOVE.W	ScreenPosY(PC),D1
	MOVEQ	#44,D2
	ADD.W	D1,D2
	MOVE.W	D2,D3
	MOVE.B	D2,lbB02F79A+2		;ok
	MOVE.B	D2,lbB02F7B8

	BTST	#0,VModeField		; NTSC?
	BEQ.S	Show_MS5
	SUB.W	#50,D2			; -50 screenlines
Show_MS5:
	MOVE.B	D2,lbB02F79E+2
	SUB.W	ScrPosYValue(PC),D1
	SUB.W	ScrPosYValue(PC),D3
	MOVE.W	D3,SprPos1
	MOVEQ	#88,D2
	ADD.W	D1,D2
	MOVE.B	D2,lbB02F7C0
	MOVEQ	#125,D2
	ADD.W	D0,D2
	MOVE.W	D2,SprPos2
	CALL	UpdatePointerPos	; refresh mouse
	BSR.W	lbC009132
	TST.W	SamScrEnable
	BNE.S	Show_MS7
	MOVE.W	ScreenPosY(PC),D1
	SUB.W	ScrPosYValue(PC),D1
	MOVE.W	#187,D2
	ADD.W	D1,D2
	MOVE.B	D2,CopListInsPos
	MOVE.W	#194,D2
	ADD.W	D1,D2
	MOVE.B	D2,lbB02FA64
	MOVE.W	#240,D2
	ADD.W	D1,D2
	MOVE.B	D2,lbB02FFB0
	MOVE.W	#297,D2
	ADD.W	D1,D2
	MOVE.B	D2,lbB02FFD0
	MOVE.W	#510,D0

	CMP.W	#256,D2
	BMI.S	Show_MS6
	MOVE.W	#$FFDF,D0
Show_MS6:
	MOVE.W	D0,lbW02FFCC
Show_MS7:
	CMP.W	#5,CurrScreen
	BNE.B	Show_ms8
	CALL	rainsk5
	CALL	UpdIfCfgOpen
	BRA.S	Show_msA

Show_ms8:
	BSR.W	mt_initbars
Show_msA:
	CMP.W	#3,CurrScreen
	BNE.B	Show_msB
	CALL	rd_upddirlist			;org bsr 3.62
Show_msB:
	BSR.S	UpdCurAndPatt
	TST.W	SamScrEnable
	BNE.S	Show_msE
	MOVE.W	ScreenPosY(PC),D1
	SUB.W	ScrPosYValue(PC),D1
	CALL	mt_setupvucols
	BRA.S	Show_msF

Show_msE:
	MOVE.W	ScreenPosY(PC),D1
	SUB.W	ScrPosYValue(PC),D1
	MOVE.W	#182,D2
	ADD.W	D1,D2
	MOVE.B	D2,CopListInsPos
	CALL	StealLoopSprit
Show_msF:
	BSR	UpdateLineCurPos
	BSR.S	StoreCopPtrF
	RTS

;********************************

UpdCurAndPatt:
	CALL	valgask
	CALL	UpdateCursorPos
	CALL	SetScrPatternPos
	RTS

UpdIfCfgOpen:
	LEA	ScrollerSprite1,A0
	MOVEQ	#59,D0
	CMP.W	#5,CurrScreen
	BEQ.B	mt_updcfgo
	MOVEQ	#-$20,D0
mt_updcfgo:
	MOVEQ	#47,D1
	MOVEQ	#48,D2
	CALL	SetSpritePos
	RTS

StoreCopPtrF:
	MOVE.L	GfxBase,A6
	MOVE.W	$A4(A6),D1
	MOVE.W	#$F014,D2
	AND.W	D2,SamCopFT+2
	OR.W	D1,SamCopFT+2
	TST.W	SamScrEnable
	BNE.S	StoreCopPtrFRT
	AND.W	D2,NoteColoB+2
	OR.W	D1,NoteColoB+2
	AND.W	D2,VALCopLisa+2
	OR.W	D1,VALCopLisa+2
	AND.W	D2,VALCopLisb+2
	OR.W	D1,VALCopLisb+2
StoreCopPtrFRT:
	RTS

OLotScrenPos:
	MOVE.W	ScrPosYValue(PC),D1
	MULU	#$50,D1
	MOVE.L	#PTBitMap,D0
	ADD.L	D1,D0
	LEA	CopListBitPlanes,A1
	MOVE.W	D0,6(A1)
	SWAP	D0
	MOVE.W	D0,2(A1)
	SWAP	D0

	ADD.L	#$5000,D0			;20480
	MOVE.W	D0,14(A1)
	SWAP	D0
	MOVE.W	D0,10(A1)
	MOVE.L	#PattBlkSize,D0
	ADD.L	D1,D0
	MOVE.W	D0,NoteBplptrLow
	SWAP	D0
	MOVE.W	D0,NoteBplptrHigh
	RTS

;***********************************
;---Subroutine from keycodes ----
;***********************************

ResetKeyTimer:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.W	ResKeyTiByte
	BEQ.S	ResKeyTi_Ret		;back
	BTST	#0,VModeField		;NTSC?
	BEQ.S	ReskeyTi3		;clr
	MOVE.W	ResKeyTiByte(PC),D0
	CLR.W	ResKeyTiByte
	ADD.W	D0,ScrPosYValue
	BPL.S	ReskeyTi1
	CLR.W	ScrPosYValue
ReskeyTi1:
	CMP.W	#$32,ScrPosYValue
	BMI.S	ReskeyTi2
	MOVE.W	#$32,ScrPosYValue
ReskeyTi2:
	BSR.W	Show_MS
	BRA.S	ResKeyTi_Ret

ReskeyTi3:
	CLR.W	ResKeyTiByte
	CLR.W	ScrPosYValue
ResKeyTi_Ret:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

MouseFreezeFlag:	dc.w	0
ScreenPosX:		dc.w	0
ScreenPosY:		dc.w	0
ScrPosYValue:		dc.w	0
ResKeyTiByte:		dc.w	0

;***********************************
;* fremem for unpacked iff gui     *
;***********************************


FreeDecompMem:
	MOVE.L	DecompMemPtr,D0
	BNE.B	.memda
	RTS

.memda:
	MOVE.L	D0,A1
	MOVE.L	DecompMemSize,D0
	MOVE.L 	4.w,A6
	CALLSYS	FreeMem
	CLR.L	DecompMemPtr
	RTS


C_FreeDecompMem:
	MOVE.L	C_DecompMemPtr,D0
	BNE.B	Cmemda
	RTS

Cmemda:
	MOVE.L	D0,A1
	MOVE.L	C_DecompMemSize,D0
	MOVE.L	4.w,A6
	CALLSYS	FreeMem
	CLR.L	C_DecompMemPtr
	RTS

;--- 1_7gadgets iff

G_FreeDecompMem:
	MOVE.L	G_DecompMemPtr,D0
	BNE.B	Gmemda
	RTS

Gmemda:
	MOVE.L	D0,A1
	MOVE.L	G_DecompMemSize,D0
	MOVE.L	4.w,A6
	CALLSYS	FreeMem
	CLR.L	G_DecompMemPtr
	RTS

;***********************************
;* high parts of screen 640x138    *
;***********************************
;dir, help, setup, plst+pos, info

UpperDecrunch:

	move.l	A0,upperdata
	move.l	DecompMemPtr,d0
	beq.s	udec
	movea.l d0,a1
	bsr.s	udec1
	bra.b	FreeDecompMem

udec:
	move.l	upperdata,A0
	bsr.S	Decompact
	bne.s	udec1
	rts

udec1:
	lea	PTBitMap,a0
	moveq	#1,d2
	moveq	#0,d3
udec3:
	MOVE.W	#$0973,D0
.loo:
	MOVE.L	(A0),D1
	MOVE.L	(A1),(A0)+
	MOVE.L	D1,(A1)+
	DBRA	D0,.loo
	LEA	$2A30(A0),A0
	DBRA	D2,udec3
	MOVEQ	#0,D0
	RTS


upperdata:	dc.l	0

;***********************************
;* low parts of screen 640 x 118   *
;***********************************
;4 channel, 8 channel, sampler

LowerDecrunch:
	BSR.W	C_DecompactIFF
	bne.s	ldec
	RTS

ldec:
	lea	PTBitMap+UnderPartPos,a0
	moveq	#1,d2
	moveq	#0,d3
	MOVEQ	#1,D2

ldec1:
	MOVE.W	#$0937,D0

.loo:
	MOVE.L	(A1)+,(A0)+
	DBRA	D0,.loo
	LEA	$2B20(A0),A0
	DBRA	D2,ldec1
	MOVEQ	#0,D0
	BSR.W	C_FreeDecompMem
	tst.l	ffpointer
	beq.s	ldec2
	GOTO	fimpclean		;freemem imploded datas
ldec2:
	RTS


;***********************************
;-- Decompactor for GFX Datas -----*
;***********************************


;A0 = GFX data
;upperdecrunch, posed

Decompact:

	cmp.l	#'IMP!',(A0)
	bne.s	.l1
	bsr.w	fimpdecrunch

.l1:	MOVE.L	A0,pic_buf
	BSR.W	iff_search
	MOVE	width_bytes(pc),D0
	MULU	height(pc),D0
	MULU	planes_num(pc),D0
	MOVE.L	D0,DecompMemSize
	MOVE.L	#$10000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,DecompMemPtr
	BEQ.W	SamMemError		;OutOfMemErr
	MOVE.L	D0,bitplane		;store where to decompact into
	BSR.W	colors_init
	BSR.W	unpacker

	tst.l	ffpointer
	beq.s	.l2
	bsr.w	fimpclean		;freemem imploded datas

.l2:	MOVE.L	DecompMemPtr,A1
	MOVEQ	#-1,D0
	RTS

;***********************************
;* opt 1-8 GFX                     *
;***********************************
G_DecompactIFF:
	cmp.l	#'IMP!',(A0)
	bne.s	.l1
	bsr.w	fimpdecrunch

.l1:	move.l	pic_buf,apic_buf

	MOVE.L	A0,pic_buf
	BSR.W	iff_search
	MOVE	width_bytes(pc),D0
	MULU	height(pc),D0
	MULU	planes_num(pc),D0
	MOVE.L	D0,G_DecompMemSize
	MOVE.L	#$10000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,G_DecompMemPtr
	BEQ.W	SamMemError		;OutOfMemErr
	MOVE.L	D0,bitplane		;store where to decompact into
	BSR.W	colors_init
	BSR.W	unpacker

	tst.l	ffpointer
	beq.s	.l2
	bsr.w	fimpclean

.l2:	MOVE.L	G_DecompMemPtr,A1
	move.l	apic_buf,pic_buf
	MOVEQ	#-1,D0
	RTS

;*********************************
;* lowerdata GFX                 *
;*********************************
C_DecompactIFF:
	cmp.l	#'IMP!',(A0)
	bne.s	.l1
	bsr.w	fimpdecrunch

.l1:	move.l	pic_buf,apic_buf 	;mainscreen

	MOVE.L	A0,pic_buf
	BSR.W	iff_search
	MOVE	width_bytes(pc),D0
	MULU	height(pc),D0
	MULU	planes_num(pc),D0
	MOVE.L	D0,C_DecompMemSize
	MOVE.L	#$10000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,C_DecompMemPtr
	BEQ.W	SamMemError		;OutOfMemErr
	MOVE.L	D0,bitplane		;store where to decompact into
	BSR.W	colors_init
	BSR.W	unpacker

	tst.l	ffpointer
	beq.s	.l2
	bsr.w	fimpclean

.l2:	MOVE.L	C_DecompMemPtr,A1
	move.l	apic_buf,pic_buf
	MOVEQ	#-1,D0
	RTS

;********************************
;*depacks iff file into bitmap  *
;* using pic_buf                *
;********************************

doiff:	bsr.w	iff_search
	bsr.w	colors_init
	bsr.w	unpacker
	rts

;*********************************	;resulting output info..
width:		dc.w	320		;pixels
height: 	dc.w	200
modes:		dc.l	$12345678
planes: 	dcb.l	6,0
bitplane:	dc.l	$40000		;start address of output bitmap
color_map:	dcb.w	64,0

;*********************************

iff_search:
	move.l	pic_buf(pc),a0		;address of IFF file
	add.l	#4+8,a0
	move.l	a0,bmhd_chunk
	move.l	4(a0),d0
	add.l	d0,a0
	addq.l	#8,a0
	move.l	a0,cmap_chunk
iff_l1:
	move.l	4(a0),d0
	add.l	d0,a0
	addq.l	#8,a0
	move.l	#"BODY",d1
	cmp.l	(a0),d1
	bne.s	iff_l1
	move.l	a0,body_chunk
	move.l	bmhd_chunk(pc),a2
	move.l	a2,a1
	add.l	#16,a1
	moveq	#0,d0
	move.b	(a1),d0
	cmp	#6,d0
	blt.s	iff_cont
	moveq	#6,d0
iff_cont:
	move	d0,planes_num
	move.l	a2,a1
	add.l	#18,a1
	move.b	(a1),comp_flag
	move.l	a2,a1
	addq.l	#8,a1
	moveq	#0,d0
	move	(a1)+,d0
	move	d0,width
	moveq	#0,d3
	cmp	#640,d0
	blt.s	iff_cont3
	or.w	#$8000,d3
iff_cont3:
	move	d0,d1
	and	#7,d1
	beq.s	iff_cont2
	or	#8,d0
iff_cont2:
	lsr	#3,d0			;divu #8,D0
	move	d0,width_bytes
	moveq	#0,d0
	move	(a1),d0
	move	d0,height
	cmp	#400,d0
	blt.s	iff_cont4
	or	#4,d3
iff_cont4:
	move	d3,modes
	rts


;**** colors initialize *****

colors_init:
	move.l	cmap_chunk(pc),a0
	addq.l	#8,a0
	lea	color_map(pc),a1
	moveq	#31,d7			;number of colors!!
co_loop1:
	moveq	#0,d0
	move.b	(a0)+,d0
	and.b	#$f0,d0
	lsl.w	#4,d0
	move.b	(a0)+,d0
	and.w	#$0ff0,d0
	moveq	#0,d1
	move.b	(a0)+,d1
	lsr.b	#4,d1
	and.b	#$0f,d1
	or.b	d1,d0
	move.w	d0,(a1)+
	dbra	d7,co_loop1
	rts

;****************************
;*IFF   U N P A C K E R     *
;****************************

unpacker:
	lea	planes(pc),a2
	moveq	#5,d7
	move.l	bitplane(pc),d6
	moveq	#0,d0
	move	width_bytes(pc),d0
	mulu	height(pc),d0
fillad: move.l	d6,(a2)+
	add.l	d0,d6
	dbra	d7,fillad

	lea	planes(pc),a2
	move.l	body_chunk(pc),a0
	lea	4(a0),a0
	move.l	(a0),d7
	move.l	a0,a3
	add.l	d7,a3
	lea	2(a3),a3
	lea	4(a0),a0
	move	planes_num(pc),d2	;number of planes loop cntr
unp_loop:
	cmp.l	a3,a0
	bgt.s	unpacker-2
	moveq	#0,d3
pic_loop1:
	move.l	d3,d4
	lsl	#2,d4			;mulu #4,d4
	move.l	(a2,d4.w),a5
	bsr.s	unpack_row
	move.l	a5,(a2,d4.w)
	addq	#1,d3			;add 1 to plane count
	cmp	d2,d3			;if hit max then stop end
	blt.s	pic_loop1
	move.l	bmhd_chunk(pc),a5
	and.b	#1,17(a5)
	beq.s	unp_loop
	lea	mask_dummy(pc),a5
	bsr.s	unpack_row
	bra.s	unp_loop

unpack_row:
	move.l	d2,-(sp)
	move	width_bytes(pc),d2

unp_loop1:
	cmp.l	a3,a0
	bgt.s	unpack_row_end
	tst	d2
	beq.s	unpack_row_end
	moveq	#0,d0
	tst	comp_flag
	bne.s	unp_comp
	move	width_bytes(pc),d0
	subq	#1,d0
	bra.s	unp_loop2

unp_comp:
	move.b	(a0)+,d0		;copy it
	bmi.s	packed
	and	#$7f,d0

unp_loop2:
	sub	d0,d2
	subq	#1,d2

unp_loop2a:
	move.b	(a0)+,(a5)+
	dbra	d0,unp_loop2a
	bra.s	unp_loop1

packed:
	neg.b	d0			;fill it
	and	#$7f,d0
	move.b	(a0)+,d1

unp_loop3:
	sub	d0,d2
	subq	#1,d2

unp_loop3a:
	move.b	d1,(a5)+
	dbra	d0,unp_loop3a
	bra.s	unp_loop1

unpack_row_end:
	move.l (sp)+,d2

unpack_end:
	rts


*------- chunk-Data ---------------*
bmhd_chunk:		dc.l 0			;address of IFF file + 12
cmap_chunk:		dc.l 0			;address of Color MAP
body_chunk:		dc.l 0			;address of the packed BitMAP
planes_num:		dc.l 0
comp_flag:		dc.l 0
width_bytes:		dc.w 0			;width of screen   pixels/8
pic_buf:		dc.l 0
mask_dummy:		dcb.l	32,0
apic_buf:		dc.l	0

;********************************************
;new in 4.0: datas can be crunched with finf*
;from imploder package                      *
;********************************************

;--- clears temporary decrunchmem ---

fimpclean:
	move.l	ffpointer,a1
	move.l  declength,d0
	move.l	4.w,a6
	CALLSYS	FreeMem
	clr.l	ffpointer
	clr.l	ffdata
	rts

;--- the decrunch routine from finf ---

fimpdecrunch:
	tst.l	ffpointer
	bne.s	fimpdecrunch

	move.l	a0,ffdata
	move.l  4(a0),d0		;get decrunched length
	move.l	d0,declength
	move.l	XDmaType,d1
	move.l	4.w,a6
	CALLSYS	AllocMem
	tst.l	d0
	bne.b	ffdecr
	BRA.W	OutOfMemErr
ffdecr:
	move.l	d0,ffpointer		;allocated memblock for dec data
	move.l	4.w,a6
	move.l	ffdata,a0		;source
	move.l	ffpointer,a1		;dest
	move.l	declength,d0
	CALLSYS	CopyMem

	move.l	ffpointer,a0
	bsr.s	FImp_decrunch		;decrunch it
	move.l	ffpointer,a0		;pointer datas to a0
	rts

; Decrunch routine from FImp v2.34 by A.J. Brouwer
; A0 must be pointing at the start of the decrunched data

FImp_decrunch:
	MOVEM.L D0-D7/A0-A6,-(SP)
	move.l	a0,a3
	move.l	a0,a4
	tst.l	(a0)+
	adda.l	(a0)+,a4
	adda.l	(a0)+,a3
	move.l	a3,a2
	move.l	(a2)+,-(a0)
	move.l	(a2)+,-(a0)
	move.l	(a2)+,-(a0)
	move.l	(a2)+,d2
	move	(a2)+,d3
	bmi.b	lb_180e
	subq.l	#1,a3
lb_180e:
	lea	-$1c(a7),a7
	move.l	a7,a1
	moveq	#6,d0
lb_1816:
	move.l	(a2)+,(a1)+
	dbf	d0,lb_1816
	move.l	a7,a1
	bra.b	lb_1e90
lb_1822:
	moveq	#0,d0
	rts
lb_1e90:
	tst.l	d2
	beq.b	lb_1e9a
lb_1e94:
	move.b	-(a3),-(a4)
	subq.l	#1,d2
	bne.b	lb_1e94
lb_1e9a:
	cmpa.l	a4,a0
	bcs.b	lb_1eb2
	lea	$1c(a7),a7
	moveq	#-1,d0
	cmpa.l	a3,a0
	beq.b	lb_1eaa
	moveq	#0,d0
lb_1eaa:
	MOVEM.L (SP)+,D0-D7/A0-A6
	tst.l	d0
	rts
lb_1eb2:
	add.b	d3,d3
	bne.b	lb_1eba
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1eba:
	bcc.b	lb_1f24
	add.b	d3,d3
	bne.b	lb_1ec4
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1ec4:
	bcc.b	lb_1f1e
	add.b	d3,d3
	bne.b	lb_1ece
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1ece:
	bcc.b	lb_1f18
	add.b	d3,d3
	bne.b	lb_1ed8
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1ed8:
	bcc.b	lb_1f12
	moveq	#0,d4
	add.b	d3,d3
	bne.b	lb_1ee4
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1ee4:
	bcc.b	lb_1eee
	move.b	-(a3),d4
	moveq	#3,d0
	subq.b	#1,d4
	bra.b	lb_1f28
lb_1eee:
	add.b	d3,d3
	bne.b	lb_1ef6
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1ef6:
	addx.b	d4,d4
	add.b	d3,d3
	bne.b	lb_1f00
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f00:
	addx.b	d4,d4
	add.b	d3,d3
	bne.b	lb_1f0a
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f0a:
	addx.b	d4,d4
	addq.b	#5,d4
	moveq	#3,d0
	bra.b	lb_1f28
lb_1f12:
	moveq	#4,d4
	moveq	#3,d0
	bra.b	lb_1f28
lb_1f18:
	moveq	#3,d4
	moveq	#2,d0
	bra.b	lb_1f28
lb_1f1e:
	moveq	#2,d4
	moveq	#1,d0
	bra.b	lb_1f28
lb_1f24:
	moveq	#1,d4
	moveq	#0,d0
lb_1f28:
	moveq	#0,d5
	move	d0,d1
	add.b	d3,d3
	bne.b	lb_1f34
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f34:
	bcc.b	lb_1f4c
	add.b	d3,d3
	bne.b	lb_1f3e
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f3e:
	bcc.b	lb_1f48
	move.b	lb_1fac(pc,d0),d5
	addq.b	#8,d0
	bra.b	lb_1f4c
lb_1f48:
	moveq	#2,d5
	addq.b	#4,d0
lb_1f4c:
	move.b	lb_1fb0(pc,d0),d0
lb_1f50:
	add.b	d3,d3
	bne.b	lb_1f58
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f58:
	addx	d2,d2
	subq.b	#1,d0
	bne.b	lb_1f50
	add	d5,d2
	moveq	#0,d5
	move.l	d5,a2
	move	d1,d0
	add.b	d3,d3
	bne.b	lb_1f6e
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f6e:
	bcc.b	lb_1f8a
	add	d1,d1
	add.b	d3,d3
	bne.b	lb_1f7a
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f7a:
	bcc.b	lb_1f84
	move	8(a1,d1),a2
	addq.b	#8,d0
	bra.b	lb_1f8a
lb_1f84:
	move	(a1,d1),a2
	addq.b	#4,d0
lb_1f8a:
	move.b	16(a1,d0),d0
lb_1f8e:
	add.b	d3,d3
	bne.b	lb_1f96
	move.b	-(a3),d3
	addx.b	d3,d3
lb_1f96:
	addx.l	d5,d5
	subq.b	#1,d0
	bne.b	lb_1f8e
	addq	#1,a2
	adda.l	d5,a2
	adda.l	a4,a2
lb_1fa2:
	move.b	-(a2),-(a4)
	dbf	d4,lb_1fa2
	bra.w	lb_1e90

lb_1fac:	dc.b	6,10,10,18
lb_1fb0:	dc.b	1,1,1,1,2,3,3,4
		dc.b	4,5,7,14

fimpbase:	dc.l	0
fimpmem:	dc.l	0
ffpointer:	dc.l	0
ffdata:		dc.l	0
declength:	dc.l	0

;***********************************
PosInsert:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	ADD.L	#126,A0
	MOVEQ	#127,D0
	MOVE.L	playpos,D1
	AND.L	#127,D1
posinsloop:
	MOVE.B	(A0),1(A0)
	SUBQ.L	#1,A0
	SUBQ.L	#1,D0
	CMP.L	D1,D0
	BHI.S	posinsloop
	CLR.B	1(A0)
	cmp.w	#9,CurrScreen
	beq.b	inspa2
	CALL	ShowPosition
	CLR.W	UpOrDown
	BSR.W	SongLengthGadg
	GOTO	WaitForButtonUp
inspa2:
	CLR.W	UpOrDown
	BSR.W	SongLengthGadg
	CALL	WaitForButtonUp
	GOTO	PoEDs

;***********************************
PosDelete:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	MOVE.L	playpos,D0
	AND.L	#127,D0
	ADD.L	D0,A0
posdelloop:
	MOVE.B	1(A0),(A0)
	ADDQ.L	#1,A0
	ADDQ.L	#1,D0
	CMP.L	#127,D0
	BLS.S	posdelloop
	CLR.B	-1(A0)
	cmp.w	#9,CurrScreen
	beq.b	delpa2
	CALL	ShowPosition
	MOVE.W	#-1,UpOrDown
	BSR.W	SongLengthGadg
	GOTO	WaitForButtonUp
delpa2:
	MOVE.W	#-1,UpOrDown
	BSR.W	SongLengthGadg
	CALL	WaitForButtonUp
	GOTO	PoEDs

;***********************************
EnterPosGadg:
	MOVE.W	#$004C,LineCurX
	MOVE.W	#$0034,LineCurY
	MOVE.W	#$0EB9,TextOffset
	BSR.W	GetDec3Dig		;cursor
	TST.W	AbortDecFlag
	BNE.W	pogskip 		;wait always here
	CMP.W	#127,D0
	BLS.S	eposgok
	MOVEQ	#127,D0
eposgok:
	MOVE.L	D0,playpos
	BRA.W	pogskip

;***********************************
EnterPattGadg:
	MOVE.W	#$0054,LineCurX
	MOVE.W	#$003F,LineCurY
	MOVE.W	#$122A,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	pogskip
	cmp.b	patt64length,d0
	BLS.S	epgok
	move.l	MaxPattLength,d0	; max patterns in song
epgok:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	ADD.L	playpos,A0
	MOVE.B	D0,(A0)
	BRA.W	pogskip

;***********************************
EnterlenGadg:
	MOVE.W	#$004C,LineCurX
	MOVE.W	#$004A,LineCurY
	MOVE.W	#$1599,TextOffset
	BSR.S	GetDec3Dig
	TST.W	AbortDecFlag
	BNE.B	hslgthret
	CMP.W	#$0080,D0
	BLS.S	hslgth2
	MOVE.B	#$80,D0
hslgth2:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_numofpatt(A0),A0
	MOVE.B	D0,(A0)
hslgthret:
	GOTO	ShowSongLength

;***********************************
; 4 byte numeric input from gadgets
;***********************************
GetDec3Dig:
	MOVE.W	#1,AbortDecFlag
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	BSR.W	UpdateLineCurPos
gd3loop:
	BSR.W	GetKey0_9
	CMP.W	#$44,D1
	BEQ.S	gd3exit
	CMP.W	#2,D1
	BHI.S	gd3loop
	MOVE.W	D1,D0
	MULU	#$0064,D0
	MOVE.W	D0,gd3temp
	BSR.W	mt_clarconv
	ADDQ.W	#8,LineCurX
	BSR.W	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	gd3exit
	MOVE.W	D1,D0
	MULU	#10,D0
	ADD.W	D0,gd3temp
	BSR.W	mt_clarconv
	ADDQ.W	#8,LineCurX
	BSR.W	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	gd3exit
	ADD.W	D1,gd3temp
	CLR.W	AbortDecFlag
gd3exit:
	CLR.W	LineCurX
	MOVE.W	#$010E,LineCurY
	BSR.W	UpdateLineCurPos
	CALL	RestorePtrCol
	MOVEQ	#0,D0
	MOVE.W	gd3temp(PC),D0
	RTS

gd3temp:	dc.w	0

;***********************************
; move pattern position up or down *
;***********************************
PositionUpDown:					; from check of mainscreen gadgets
	TST.W	UpOrDown
	BMI.B	PositionDown
PositionUp:
	ADDQ.L	#1,playpos
	checkrmb
	BNE.S	pogskp2
	ADD.L	#9,playpos
pogskp2:
	CMP.L	#127,playpos
	BLS.S	pogskip
	MOVE.L	#127,playpos
pogskip:
	MOVE.L	playpos,mt_songpos
	CALL	ShowPosition
	CMP.W	#9,CurrScreen
	bne.b	poui
	CALL	PosEDstart
poui:
	CLR.B	RawKeyCode
	BSR.W	Wait_4000

	MOVE.L	PattRfshNum,PatternNumber
	CALL	RedrawPattern	 		; 3.57, redraw patterns by shift+cursors
	BSR.W	ResetKeyTimer
	CLR.B	RawKeyCode
	BRA.W	Wait_4000

PositionDown:
	SUBQ.L	#1,playpos
	checkrmb
	BNE.S	pogskp3
	SUB.L	#9,playpos
pogskp3:
	TST.L	playpos
	BPL.S	pogskip
	CLR.L	playpos
	BRA.S	pogskip

;***********************************
PatternGadg:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	TST.W	UpOrDown
	BMI.S	PatternDown
	ADD.L	playpos,A0
	ADDQ.B	#1,(A0)
	checkrmb
	BNE.S	pagaskp
	ADD.B	#9,(A0)
pagaskp:
	move.b	(A0),d0
	cmp.b	patt64length,D0
	BLS.W	pogskip
	MOVE.B	patt64length,(A0)
	BRA.W	pogskip

;***********************************
PatternDown:
	ADD.L	playpos,A0
	SUBQ.B	#1,(A0)
	checkrmb
	BNE.S	lbC00B444
	SUB.B	#9,(A0)
lbC00B444:
	TST.B	(A0)
	BPL.W	pogskip
	CLR.B	(A0)
	BRA.W	pogskip

;***********************************
SongLengthGadg:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_numofpatt(A0),A0
	TST.W	UpOrDown
	BMI.S	SongLengthDown
	ADDQ.B	#1,(A0)
	checkrmb
	BNE.S	SlengthChg
	ADD.B	#9,(A0)
SlengthChg:
	CMP.B	#127,(A0)
	BMI.S	SlengthRet
	MOVE.B	#127,(A0)
SlengthRet:
	cmp.w	#9,CurrScreen
	beq.b	sslgt
	CALL	ShowSongLength
sslgt:
	BSR.W	Wait_4000
	BSR.W	Wait_4000
	BRA.W	Wait_4000

;*******************************
SongLengthDown:
	SUBQ.B	#1,(A0)
	checkrmb
	BNE.S	sldoskp
	SUB.B	#9,(A0)
sldoskp:
	CMP.B	#1,(A0)
	BGE.S	SlengthRet
	MOVE.B	#1,(A0)
	BRA.S	SlengthRet

SampleNumGadg:
	checkrmb
	BNE.S	SampeNum2
	TST.W	InsNum
	BEQ.S	ssint
	MOVE.W	InsNum,LastInsNum
	CLR.W	InsNum

ssint:	GOTO	ShowSampleInfo

SampeNum2:
	TST.W	UpOrDown
	BMI.S	SampleNumDown
SampleNumUp:
	ADDQ.W	#1,InsNum
	CMP.W	#MaxInsNum,InsNum
	BMI.S	snuskipaa
	MOVE.W	#MaxInsNum,InsNum
snuskipaa:
	CALL	mt_redrsaUU
	BSR.W	Wait_4000
	BRA.W	Wait_4000

SampleNumDown:
	TST.W	InsNum
	BEQ.S	snuskip
	SUBQ.W	#1,InsNum
	CMP.W	#1,InsNum
	BGE.S	snuskipaa
	MOVE.W	#1,InsNum
	BRA.S	snuskipaa

;********************************
FineTuneGadg:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVE.W	InsNum,D0
	BNE.S	.true
	RTS

.true:	MULU	#30,D0
	ADD.L	D0,A0
	checkrmb
	BNE.S	ftgskip
	AND.B	#$F0,2(A0)
	BRA.S	snuskip

ftgskip:
	TST.W	UpOrDown
	BMI.S	FineTuneUp
	AND.B	#15,2(A0)
	CMP.B	#7,2(A0)
	BEQ.S	snuskip
	ADDQ.B	#1,2(A0)
	AND.B	#15,2(A0)
snuskip:
	CALL	ShowSampleInfo
	BSR.W	Wait_4000
	BRA.W	Wait_4000

FineTuneUp:
	AND.B	#15,2(A0)
	CMP.B	#8,2(A0)
	BEQ.S	snuskip
	SUBQ.B	#1,2(A0)
	AND.B	#15,2(A0)
	BRA.S	snuskip

;********************************
VolumeGadg:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVE.W	InsNum,D0
	BNE.S	.doit
	RTS

.doit:	MULU	#30,D0
	ADD.L	D0,A0
	TST.W	UpOrDown
	BMI.S	VolumeDown

	CMP.B	#64,3(A0)
	BEQ.S	.ret
	ADDQ.B	#1,3(A0)
	checkrmb
	BNE.S	.l1
	ADD.B	#15,3(A0)
.l1:
	CMP.B	#64,3(A0)
	BLS.S	.l2
	MOVE.B	#64,3(A0)
.l2:
	BSR.S	UpdSVol_Scop
	CALL	MkVolSet
.ret:
	BRA.S	snuskip

;***************************
VolumeDown:
	SUBQ.B	#1,3(A0)
	checkrmb
	BNE.S	.l1
	SUB.B	#15,3(A0)

.l1:	TST.B	3(A0)
	BPL.S	.l2
	CLR.B	3(A0)

.l2:	BSR.S	UpdSVol_Scop
	CALL	MkVolSet
	BRA.W	snuskip

;*******************************
UpdSVol_Scop:
	LEA	audchan1temp,A1
	BSR.S	.l1
	LEA	audchan2temp,A1
	BSR.S	.l1
	LEA	audchan3temp,A1
	BSR.S	.l1
	LEA	audchan4temp,A1
	BSR.S	.l1
	RTS

.l1:	MOVE.W	InsNum,D0
	CMP.B	43(A1),D0
	BEQ.S	.l2
	RTS

.l2:	MOVE.B	3(A0),19(A1)
	RTS

;*************************************
;* numeric samplelength input gadget *
;*************************************
InpSampleLength:
	MOVE.W	#1,SampleLengthFlag
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0
	bne.s	.l1
	GOTO	ShowSampleInfo

.l1:	MULU	#30,D0				; insnum*30
	ADD.L	D0,A0

	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVEQ	#0,D2
	MOVE.W	(A0),D2
	ADD.L	D2,D2
	MOVEQ	#6,D3
	MOVE.W	#$00A9,D0
	MOVEQ	#$5B,D1
	BSR.W	lbC00C3F6
	MOVEM.L (SP)+,D1-D7/A0-A6

	CMP.L	#MaxSamLen,D0			; max inputgadget
	BMI.S	.l2
	MOVE.L	#MaxSamLen,D0

.l2:	LSR.L	#1,D0
	MOVE.W	D0,(A0)
	BSR.W	CalcSmplMaximas
	BRA.W	replen_set

SampleLengthGadg:
	MOVE.W	#1,SampleLengthFlag
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum.L,D0
	bne.s	.l1
	GOTO	ShowSampleInfo2

.l1:	MULU	#30,D0
	ADD.L	D0,A0
	TST.W	UpOrDown
	BMI.S	SampleLengthDown
	MOVEQ	#0,D0
	MOVE.W	(A0),D0
	ADDQ.L	#1,D0
	checkrmb
	BNE.S	.l2

	CMP.L	#(MaxSamLen/2)-15,D0
	BCC.S	.l2
	ADDQ.L	#7,D0

.l2:	CMP.L	#(MaxSamLen/2),D0
	BCS.S	.l3
	MOVE.L	#(MaxSamLen/2),D0

.l3:	MOVE.W	D0,(A0)
	GOTO	ShowSampleInfo2

SampleLengthDown:
	MOVEQ	#0,D0
	MOVE.W	4(A0),D0
	ADD.W	6(A0),D0
	MOVEQ	#0,D1
	MOVE.W	(A0),D1
	SUBQ.L	#1,D1
	checkrmb
	BNE.S	.l1
	SUBQ.L	#7,D1

.l1:	BMI.S	.l2
	CMP.L	D1,D0
	BLS.S	.l3
	MOVE.L	D0,D1
	BRA.S	.l3

.l2:	MOVEQ	#0,D1
.l3:	MOVE.W	D1,(A0)
	GOTO	ShowSampleInfo2

SampleLengthFlag:	dc.w	0

;********************************
;* 1x called from mainloop      *
;********************************
CheckSampleLength:
	TST.W	SampleLengthFlag
	BNE.S	.l1
	RTS

.l1:	CLR.W	SampleLengthFlag
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0
	BNE.S	.l2
	RTS

.l2:	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVE.L	D0,D1
	LSL.W	#2,D1
	MULU	#30,D0
	ADD.L	D0,A0

	LEA	mt_songdataptr,A1
	LEA	0(A1,D1.W),A1	     ;actual sample
	MOVE.L	A0,PlaySamPtr
	MOVE.L	A1,RealSamPtr
	MOVE.L	$7C(A1),D0
	LSR.L	#1,D0
	MOVE.W	(A0),D1
	CMP.W	D0,D1
	BHI.S	ItsTooMuch
	RTS

ItsTooMuch:
	LEA	AddWorkSpaceText(PC),A0
	CALL	AreYouSure
	BNE.B	RestoreLength

;--- begin add workspace to sample ---

	BSR.W	TurnOffVoices
	MOVE.L	PlaySamPtr,A0
	MOVEQ	#0,D0
	MOVE.W	(A0),D0
	LSL.L	#1,D0
	MOVE.L	D0,SamAllocLen
	MOVE.L	XDmaType,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,SamAllocPtr
	BEQ.S	RestoreLength

	MOVE.L	D0,A1
	MOVE.L	RealSamPtr,A0
	MOVE.L	(A0),D0
	BEQ.S	nosamth
	MOVE.L	D0,A2
	MOVE.L	$7C(A0),D1
	BEQ.S	nosamth

.loop:
	MOVE.B	(A2)+,(A1)+
	SUBQ.L	#1,D1
	BPL.S	.loop

	MOVE.L	(A0),A1
	MOVE.L	$7C(A0),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
nosamth:
	MOVE.L	RealSamPtr,A0
	MOVE.L	SamAllocPtr,(A0)
	MOVE.L	SamAllocLen,$7C(A0)
	CALL	ShowSampleInfo
	CALL	RedrawSample
	GOTO	WaitForButtonUp

RestoreLength:
	MOVE.L	PlaySamPtr,A0
	MOVE.L	RealSamPtr,A1
	MOVE.L	$7C(A1),D0
	LSR.L	#1,D0
	MOVE.W	D0,(A0)
	GOTO	ShowSampleInfo

AddWorkSpaceText:	dc.b	10,10,'  Add workspace ?',0
			EVEN

PlaySamPtr:		dc.l	0
RealSamPtr:		dc.l	0
SamAllocPtr:		dc.l	0
SamAllocLen:		dc.l	0

;********************************
RepeatGadg:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0
	bne.s	.l1
	GOTO	ShowSampleInfo
.l1:
	MULU	#30,D0
	ADD.L	D0,A0
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVEQ	#0,D2
	MOVE.W	n_start(A0),D2
	ADD.L	D2,D2
	MOVEQ	#6,D3
	MOVE.W	#$00A9,D0
	MOVEQ	#$66,D1
	BSR.W	lbC00C3F6
	MOVEM.L (SP)+,D1-D7/A0-A6
	LSR.L	#1,D0
	MOVE.W	D0,4(A0)
	BSR.W	CalcSmplMaximas
	BRA.S	replen_set

;Repeatlow:
;	MOVE.L	mt_songdataptr,A0
;	LEA	12(A0),A0
;	MOVEQ	#0,D0
;	MOVE.W	InsNum,D0
;	MULU	#$001E,D0
;	ADD.L	D0,A0
;	BRA.S	lbC00B8E8


Repeathigh:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0
	;BEQ.W	ShowSampleInfo
	MULU	#$001E,D0
	ADD.L	D0,A0
	TST.W	UpOrDown
	BMI.S	lbC00B8E8
	ADDQ.W	#4,n_start(A0)
	checkrmb
	BNE.S	lbC00B8C8
	ADDQ.W	#7,4(A0)
lbC00B8C8:
	MOVE.W	(A0),D0
	BEQ.S	replen_set
	SUB.W	6(A0),D0
	CMP.W	n_start(A0),D0
	BHI.S	replen_set
	MOVE.W	D0,n_start(A0)
replen_set:
	CALL	ShowSampleInfo		;fix for loopbug
	BSR.W	UpdateRepeats
	CALL	SetLoopSprites2
	RTS
lbC00B8E8:
	SUBQ.W	#4,n_start(A0)
	checkrmb
	BNE.S	lbC00B8FA
	SUBQ.W	#7,n_start(A0)
lbC00B8FA:
	TST.W	n_start(A0)
	BPL.S	replen_set
	CLR.W	n_start(A0)
	BRA.S	replen_set

lbC00B906:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0

	bne.b	ragas
	GOTO	ShowSampleInfo
ragas:
	MULU	#30,D0
	ADD.L	D0,A0
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVEQ	#0,D2
	MOVE.W	6(A0),D2
	ADD.L	D2,D2
	MOVEQ	#6,D3
	MOVE.W	#$00A9,D0
	MOVEQ	#$71,D1
	BSR.W	lbC00C3F6		;!!
	MOVEM.L (SP)+,D1-D7/A0-A6
	LSR.L	#1,D0
	MOVE.W	D0,6(A0)
	BSR.W	CalcSmplMaximas
	BRA.B	replen_set


;Replenlow:
;	MOVE.L	mt_songdataptr,A0
;	LEA	12(A0),A0
;	MOVEQ	#0,D0
;	MOVE.W	InsNum,D0
;	;BEQ.W	ShowSampleInfo
;	MULU	#$001E,D0
;	ADD.L	D0,A0
;	BRA.S	subreplen_min
ReplenHigh:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVEQ	#0,D0
	MOVE.W	InsNum,D0
	;BEQ.W	ShowSampleInfo
	MULU	#$001E,D0
	ADD.L	D0,A0
	TST.W	UpOrDown
	BMI.S	subreplen_min
	ADDQ.W	#4,6(A0)
	checkrmb
	BNE.S	subreplen
	ADDQ.W	#7,6(A0)
subreplen:
	MOVE.W	(A0),D0
	BEQ.W	replen_set
	SUB.W	n_start(A0),D0
	CMP.W	6(A0),D0
	BHI.W	replen_set
	BRA.S	chkreplen_min

subreplen_min:
	MOVEQ	#0,D0
	MOVE.W	6(A0),D0
	SUBQ.L	#4,D0
	checkrmb
	BNE.S	chkreplen_min
	SUBQ.L	#7,D0
	subq.l	#7,d0
chkreplen_min:
	CMP.L	#1,D0		;min replen = 2
	BGE.S	replen_setme
	MOVEQ	#1,D0
replen_setme:
	MOVE.W	D0,6(A0)
	BRA.W	replen_set


;************************************
;* The timing delay routine from    *
;* protracker, waits 2 ticks        *
;************************************

Wait_4000:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DOSBase,A6
	MOVEQ	#2,D1
	CALLSYS	Delay
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
;* Additional timing routine for    *
;* longer waiting (2 secs=100 Ticks *
;************************************
WaitALittle:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	DOSBase,A6
	MOVEQ	#100,D1
	CALLSYS	Delay
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;************************************
CalcSmplMaximas:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0

	MOVEQ	#0,D0			; clear D0
	MOVE.W	InsNum,D0		; insnum to D0
	bne.s	.doit			; insnum ~0?
	GOTO	ShowSampleInfo		; no, exit
.doit:
	MULU	#30,D0			; insnum*30 (30 Bytes = 1 Sampleheader)
	ADD.L	D0,A0			; now we have the startaddr of act sample in D0

	MOVEQ	#0,D0			; clear D0
	MOVEQ	#0,D1			; clear D1
	MOVEQ	#0,D2			; clear D2

	;(samplelength are number of words, multiple *2 = reallength)

	MOVE.W	(A0),D0			; n_note to D0
	MOVE.W	n_start(A0),D1		; 4, get samplelength hibyte to D1
	MOVE.W	n_start+2(A0),D2	; 6, get samplelength lowbyte to D2

	CMP.L	D1,D0			; cmp sample hibyte with
	BPL.S	.l1			; Plus (N-Bit clear)
	MOVE.L	D0,D1			; samplestart to D1
.l1:
	MOVE.L	D1,D3			; n_start hibyte to D3
	ADD.L	D2,D3			; add n_start lowbyte to hibyte in D3
	CMP.L	D3,D0			; cmp smplstart with length
	BPL.S	.l2			; Plus (N-Bit clear)
	MOVE.L	D0,D2			; move Samplestart to D2
	SUB.L	D1,D2			; sub n_start
.l2:
	TST.L	D2
	BNE.S	.l3			; valid samplelength?
	MOVEQ	#1,D2			; zero-length
.l3:
	MOVE.W	D1,n_start(A0)		; write lobyte back
	MOVE.W	D2,n_start+2(A0)	; write hibyte back

	MOVEQ	#0,D0			; clear D0
	MOVE.B	n_cmdlo(A0),D0		; n_cmdlo in D0
	CMP.W	#64,D0			; volume of sample =64?
	BMI.S	.l4			; if lower than skip
	MOVEQ	#64,D0			; set to max 64
.l4:
	MOVE.B	D0,n_cmdlo(A0)		; write samplevolume back
	RTS

;*********************************
UpdateRepeats:
	LEA	audchan1temp,A1
	LEA	AUD0,A2
	LEA	ScopeInfo,A3
	BSR.B	.doit

	LEA	audchan2temp,A1
	LEA	AUD1,A2
	LEA	ScopeInfo+20,A3
	BSR.B	.doit

	LEA	audchan3temp,A1
	LEA	AUD2,A2
	LEA	ScopeInfo+40,A3
	BSR.S	.doit

	LEA	audchan4temp,A1
	LEA	AUD3,A2
	LEA	ScopeInfo+60,A3


.doit:	MOVE.W	InsNum,D0
	CMP.B	n_samplenum(A1),D0		; n_samplenum
	BEQ.S	.l0
	RTS

.l0:	MOVE.L	n_start(A1),A1
	MOVEQ	#0,D0
	MOVE.W	n_start(A0),D0			; repeat
	ADD.L	D0,A1
	ADD.L	D0,A1				; *2
	MOVE.L	A1,(A2)
	MOVE.W	6(A0),D0

	MOVE.W	D0,n_start(A2)			; replen
	MOVE.L	A1,n_length(A3)			; ns_repeatptr
	ADD.L	D0,A1
	ADD.L	D0,A1				; *2
	MOVE.L	A1,12(A3)			; ns_rependptr
	RTS

;***************************************
;* set patternposition and refresh     *
;***************************************

SetPatternPos:
	MOVE.L	mt_patternpos,D0
	LSR.L	#4,D0

	chn8test
	BNE.S	ssppskip
	LSR.L	#1,D0
	BRA.S	ssppskip

SetScrPatternPos:
	MOVE.W	ScrPattPos,D0
ssppskip:
	TST.W	SamScrEnable
	BNE.S	UpdatePattScroller
	MOVE.W	D0,-(SP)
	MOVE.W	D0,PlayFromPos
	MULU	#640,D0
	MOVE.L	TextBplPtr,A0
	LEA	$2DA0(A0),A0
	ADD.L	A0,D0
	MOVE.L	CopListBpl4Ptr,A1
	MOVE.W	D0,6(A1)
	SWAP	D0
	MOVE.W	D0,2(A1)
	SWAP	D0
	MOVE.W	#316+1,D0		;x-pos old 13C
	MOVE.W	(SP)+,D1
	MULU	#$004F,D1
	LSR.L	#6,D1
	ADD.W	#$0097,D1		;y-pos
	MOVE.W	#$0018,D2
	LEA	ScrollerSprite2,A0
	GOTO	SetSpritePos

UpdatePattScroller:
	MOVEQ	#-$20,D0
	MOVE.W	#$0097,D1
	MOVEQ	#$18,D2
	LEA	ScrollerSprite2,A0
	GOTO	SetSpritePos

PlayFromPos:	dc.w	0
PattScrollBuf:	dc.w	0

;******************************
;*  lmb click mainscreen      *
;******************************

WantedPattGadg:
	TST.W	SamScrEnable
	BEQ.S	.doit
	GOTO	CheckSamGadgets

.doit:	SF	lmb_or_rmb
	MOVEM.W (MouseX),D0/D1
	CMP.W	#$7B,D1
	BCC.S	.gftA
	RTS

.gftA:	chn8test
	BEQ.S	.chn8

	LEA	DownGadData4,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.dchk
	RTS

.chn8:	LEA	DownGadData8,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.dchk
	RTS

.dchk:	BTST	#0,Packetfield
	BEQ.S	.trk1			; no temp, vblank

	CMP.W	#5,D2
	BNE.S	.gftb
	GOTO	TemUp

.gftb:	CMP.W	#6,D2
	BNE.S	.trk1
	GOTO	TemDown

.trk1:	CMP.W	#$29,D2
	BNE.S	.trk2
	GOTO	FindPosTrack1

.trk2:	CMP.W	#$2A,D2
	BNE.S	.trk3
	GOTO	FindPosTrack2

.trk3:	CMP.W	#$2B,D2
	BNE.S	.trk4
	GOTO	FindPosTrack3

.trk4:	CMP.W	#$2C,D2
	BNE.S	.trk5
	GOTO	FindPosTrack4

.trk5:	cmp.w	#$2D,d2
	bne.s	.trk6
	GOTO	FindPosTrack5

.trk6:	cmp.w	#$2E,d2
	bne.s	.trk7
	GOTO	FindPosTrack6

.trk7:	cmp.w	#$2F,d2
	bne.S	.trk8
	GOTO	FindPosTrack7

.trk8:	cmp.w	#$30,d2
	bne.s	.tend
	GOTO	FindPosTrack8

;*** lmb channel on/of click in trackwin ***

.tend:	CMP.W	#$31,D2
	BEQ.W	Track1OnOff
	CMP.W	#$32,D2
	BEQ.W	Track2OnOff
	CMP.W	#$33,D2
	BEQ.W	Track3OnOff
	CMP.W	#$34,D2
	BEQ.W	Track4OnOff
	CMP.W	#$35,D2
	BEQ.W	Track5OnOff
	CMP.W	#$36,D2
	BEQ.W	Track6OnOff
	CMP.W	#$37,D2
	BEQ.W	Track7OnOff
	CMP.W	#$38,D2
	BEQ.W	Track8OnOff

	CMP.L	#'patp',RunMode
	BNE.S	cact
	RTS

cact:	CMP.W	#1,D2
	BEQ.W	DownEnterPattNum
	CMP.W	#7,D2
	BEQ.W	PatternOneDown0
	CMP.W	#8,D2
	BEQ.W	PatternOneUp2

	MOVEM.L D2,-(SP)
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVEM.L (SP)+,D2

	TST.L	RunMode
	BEQ.S	pslider
	RTS
pslider:
	CMP.W	#4,D2
	BEQ.W	patternslider
	RTS

;********************************
;* rmb click mainscreen         *
;* 1x jumped from DoRightButton *
;********************************

RMBPosTrGet:
	ST	lmb_or_rmb
	MOVEM.W (MouseX),D0/D1
	CMP.W	#$7B,D1
	BCC.S	.doit
	RTS

.doit:	chn8test
	bne.s	.chn4

	lea	TrackClickGad8,A0
	bra.s	.chn8

.chn4:	LEA	TrackClickGad4,A0
.chn8:	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.l0
	RTS

.l0:	CMP.W	#$29,D2
	BNE.S	.l1
	GOTO	FindPosTrack1

.l1:	CMP.W	#$2A,D2
	BNE.S	.l2
	GOTO	FindPosTrack2

.l2:	CMP.W	#$2B,D2
	BNE.S	.l3
	GOTO	FindPosTrack3

.l3:	CMP.W	#$2C,D2
	BNE.B	.ml4
	GOTO	FindPosTrack4

.ml4:	chn8test
	BNE.S	.chn8d
	RTS

.chn8d:	cmp.w	#$2D,d2
	bne.S	.l5
	GOTO	FindPosTrack5
.l5:	cmp.w	#$2E,d2
	bne.S	.l6
	GOTO	FindPosTrack6
.l6:	cmp.w	#$2F,d2
	bne.S	.l7
	GOTO	FindPosTrack7
.l7:	cmp.w	#$30,d2
	bne.s	.l8
	GOTO	FindPosTrack8
.l8:	RTS

;*******************************

Track1OnOff:
	GOTO	ToggleCh1
Track2OnOff:
	GOTO	ToggleCh2
Track3OnOff:
	GOTO	ToggleCh3
Track4OnOff:
	GOTO	ToggleCh4
Track5OnOff:
	GOTO	ToggleCh5
Track6OnOff:
	GOTO	ToggleCh6
Track7OnOff:
	GOTO	ToggleCh7
Track8OnOff:
	GOTO	ToggleCh8
;***********************************
;* patternstruct init called on    *
;* protracker start (ShowTracks)   *
;***********************************
bltvalg:
	LEA	audchan1temp,A0
	MOVEQ	#4-1,D1
	chn8test
	bne.s	.l1
	moveq	#7,D1
.l1:
	MOVE.B	$2C(A0),D0
	NOT.B	D0
	MOVE.B	D0,$2D(A0)
	ADD.L	#$58,A0
	DBRA	D1,.l1

;--- shows on/off status as text over the pattern ---

ShowTracks:
	TST.W	SamScrEnable
	BEQ.S	.doit
	RTS

.doit:	LEA	audchan1temp,A5
	MOVEQ	#0,D0
	MOVEQ	#3,D7

	chn8test
	BNE.S	.chn4
	MOVEQ	#7,D7

.chn4:	BSR.S	.sub
	ADDQ.W	#1,D0
	ADD.L	#$58,A5
	DBRA	D7,.chn4		; loop until last pattern
	MOVE.W	#0,NewChannels

;--------------------------------
.sub:	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.B	$002C(A5),D1
	TST.W	NewChannels
	BNE.S	.chgchnl

	CMP.B	$002D(A5),D1
	BEQ.W	.end

.chgchnl:
	MOVE.B	D1,$2D(A5)
	MOVE.W	D0,D6
	MULU	#72,D0			; old #$78

	chn8test
	BEQ.S	.chn81

	LSL.L	#1,D0
	ADD.W	#8*4,D0

.chn81:	ADD.W	#$0030,D0		; xpos start
	MOVE.W	D0,D2
	ADD.W	#$0060,D2		; xpos end

	chn8test
	BNE.S	.chn41
	SUB.W	#32,D2

.chn41:	MOVE.W	#$008D,D1
	MOVE.W	#$0093,D3
	MOVEQ	#2,D5
	CALL	BlitToMain
	LEA	Track8x.MSG(PC),A0

	MOVE.L	A0,A1
	MOVE.L	A0,A2
	MOVEQ	#8,D3

	chn8test
	BEQ.B	.chn82

	ADD.L	#10,A0
	ADD.L	#13,A1
	ADD.L	#14,A2
	ADD.L	#4,D3

.chn82:	ADD.L	#4,A1
	ADD.L	#4,A2
	MOVEQ	#0,D2
	MOVE.W	ActiveChannels,D2	;%00001111
	BTST	D6,D2
	BNE.B	.tkon

	MOVE.L	#' OFF',(A2)
	BRA.B	.tkoff

.tkon:	MOVE.L	#' ON ',(A2)

.tkoff:	ADD.B	#$31,D6
	MOVE.B	D6,(A1)
	ADDQ.W	#1,D0
	ADDQ.W	#1,D1
	;MOVEQ	#8,D3				;Textlen
	MOVEQ	#3,D2
	CALL	BlitText2

	TST.B	$002C(A5)
	BNE.S	.end

	SUBQ.W	#1,D0
	SUBQ.W	#1,D1
	MOVEQ	#1,D2
	CALL	BlitText2
.end:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

Track8x.MSG	dc.b	'TRK#x   ',0,0
Trackx.MSG:	dc.b	'TRACK #x    ',0,$61
		EVEN

NewChannels:	dc.w	0

;***********************************
PatternOneUp:
	CMP.L	#'patp',RunMode
	BNE.S	PatternOneUp2
	RTS

PatternOneUp2:
	ADDQ.L	#1,PatternNumber
	move.l	PatternNumber,d0
	cmp.l	MaxPattLength,d0
	ble.s	poiuw
	move.l	#0,PatternNumber
poiuw:
	BRA.S	PatternOneDown2

PatternOneDown:
	CMP.L	#'patp',RunMode
	BNE.S	PatternOneDown0
	RTS

PatternOneDown0:
	SUBQ.L	#1,PatternNumber
	tst.l	PatternNumber
	BPL.S	PatternOneDown2
	move.l	MaxPattLength,PatternNumber
	;CLR.L	PatternNumber
	BRA.S	PatternOneDown2

DownEnterPattNum:
	MOVE.W	#$0156,LineCurX
	MOVE.W	#$0085,LineCurY
	MOVE.W	#$0152,D4
	MOVE.W	#$0080,D5
	BSR.W	lbC00FB1E
	TST.W	AbortDecFlag
	BNE.S	PatternOURedr
	MOVE.B	D0,PatternNumber+3
PatternOneDown2:
	move.l	PatternNumber,d0
	cmp.l	MaxPattLength,d0
	BLS.S	PatternOURedr
	move.l	MaxPattLength,PatternNumber
PatternOURedr:
	GOTO	RedrawPattern

;***********************************

GetKey0_9:
	BSR.W	ResetKeyTimer
	checkrmb
	BEQ.S	mt_clarenter
	MOVEQ	#0,D0
	CALL	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	BEQ.S	GetKey0_9
	CMP.B	#$44,D0
	BEQ.S	mt_clarenter
	CMP.B	#$45,D0
	BEQ.S	mt_clarenter
	CMP.B	#10,D0
	BEQ.S	mt_clacharent			; Zero or non-decimal?
	BHI.S	GetKey0_9
	CMP.B	#1,D0
	BCS.S	GetKey0_9
	MOVE.L	D0,D1
	;CLR.B	RawKeyCode			;for Pattern insert gadgets
	CALL	ClearAllKeys
	RTS

;* clear whole field **

mt_clacharent:
	MOVEQ	#0,D1
	CALL	ClearAllKeys
	RTS

mt_clarenter:
	MOVEQ	#$44,D1 			;ENTER
	CALL	ClearAllKeys
	RTS

mt_clarconv:
	ADD.B	#$30,D1
	MOVE.B	D1,convprbyte
	CLR.W	D1
	SWAP	D1
	MOVE.W	#1,TextLength
	MOVE.L	#convprbyte,ShowTextPtr
	CALL	ShowText
	CLR.L	convprbyte
	CLR.W	WordNumber
	RTS

mt_clarconv1:
	ADD.B	#$30,D3
	MOVE.B	D3,convprbyte
	CLR.W	D3
	SWAP	D3
	MOVEQ	#1,D3
	MOVE.L	#convprbyte,A0
	MOVE.W	#$0203,D2
	CALL	BlitText1
	CLR.L	convprbyte
	CLR.W	WordNumber
	RTS

;***************************************
; Propscrollslider for mt_patternpos   *
;***************************************

pymin:	EQU	79
pymax:	EQU	151
plim:	EQU	63

patternslider:
	MOVE.W	ScrPattPos,D0
	MULU	#$4F,D0
	LSR.L	#6,D0
	ADD.W	#$97,D0
	SUB.W	D0,D1
	BMI.S	.slidersub		; minus n-bit set
	CMP.W	#$18,D1
	BPL.W	.slideradd		; plus carry clr
	BSR.W	.slidset2		;fix !

	MOVE.W	D1,D2
	MOVE.W	MouseY,D1

.psliderloop:
	BSR.W	ResetKeyTimer
	BTST	#6,$BFE001
	BNE.S	.psliderexit

	MOVE.W	D1,D3
	MOVE.W	MouseY,D1
	CMP.W	D3,D1
	BEQ.S	.psliderloop		; no mouse event

	SUB.W	D2,D1
	SUB.W	#$97,D1
	MULS	#$40,D1
	DIVS	#$4F,D1
	TST.W	D1
	BPL.S	.psmax				; plus
	MOVEQ	#0,D1

.psmax:	CMP.W	#63,D1
	BMI.S	.pssl
	moveq	#63,D1

.pssl:	MOVE.W	D1,ScrPattPos
	MOVE.W	D2,-(SP)
	CALL	SetScrPatternPos
	MOVE.W	(SP)+,D2
	BTST	#6,$BFE001
	BEQ.B	.psliderloop

.psliderexit:
	BSR.S	.slidset1
	RTS
;---
.slidersub:
	SUB.W	#$13,ScrPattPos
	BPL.S	.psmin
	CLR.W	ScrPattPos

.psmin:	MOVE.L	DOSBase,A6
	MOVEQ	#1,D1
	CALLSYS	Delay
	GOTO	SetScrPatternPos

;---
.slideradd:
	ADD.W	#$13,ScrPattPos
	CMP.W	#$3F,ScrPattPos
	BMI.S	.sliddelay
	MOVE.W	#$3F,ScrPattPos

.sliddelay:
	MOVE.L	DOSBase,A6
	MOVEQ	#1,D1
	CALLSYS	Delay
	GOTO	SetScrPatternPos

;--- set sprite

.slidset1:
	MOVE.L	#$F800F000,D4
	MOVE.L	#$F0008800,D5
	MOVE.L	#$80007800,D6
	BRA.S	.slidgo

.slidset2:
	MOVE.L	#$8000F00,D4
	MOVE.L	#$78008800,D5
	MOVE.L	#$F8007800,D6

.slidgo:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	ScrollerSprite2+4,A0
	MOVEQ	#$15,D0
	MOVE.L	D4,(A0)+

.rlop:	MOVE.L	D5,(A0)+
	DBRA	D0,.rlop

	MOVE.L	D6,(A0)+
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***************************************

EnterTextNow:
	MOVE.W	D0,LineCurXStore
	MOVE.W	D1,LineCurYStore
	MOVE.W	#$FFFF,mt_gtkyflag
	SUB.W	A4,A4
	BRA.S	GTTXl


;***********************************
;*     -- get text line ------     *
;***********************************

GetTextLine:
	move.b	KeyRepeat,mt_savekeyRepeat ;keyrepeat on
	ST	KeyRepeat
	CLR.W	mt_gtkyflag


GTTXl:
	MOVEQ	#0,D0
	MOVE.W	A4,D0
	DIVU	#$50,D0
	ADDQ.W	#5,D0
	MOVE.W	D0,LineCurY
	SWAP	D0
	LSL.W	#3,D0
	ADDQ.W	#4,D0
	MOVE.W	D0,LineCurX
	TST.W	mt_gtkyflag
	BEQ.S	mt_wfoku
	MOVE.W	LineCurXStore(PC),D0
	ADDQ.W	#4,D0
	MOVE.W	D0,LineCurX
	MOVE.W	LineCurYStore(PC),D0
	ADDQ.W	#5,D0
	MOVE.W	D0,LineCurY

;***********************************

mt_wfoku:
	BSR.W	UpdateLineCurPos
	MOVE.L	ShowTextPtr,DSTPtr
	CLR.L	DSTOffset
	CLR.L	DSTPos
	MOVE.W	#1,GetLineFlag
	MOVE.L	A4,A5
	MOVE.W	LineCurX,D5
	CLR.B	RawKeyCode
	BSR.W	UpdateText

WaitForKey:
	CLR.B	RawKeyCode
	MOVE.B	RawKeyCode,RepeatKey
	tst.b	mt_savekeyRepeat
	BSR.W	ResetKeyTimer
	checkrmb
	BEQ.W	AbortGetLine

	checklmb
	BEQ.W	LineClicked

	CALL	DoKeyBuffer
	CALL	CheckLAmigaKeys
	MOVEQ	#0,D1
	MOVE.B	RawKeyCode,D1
	BEQ.S	WaitForKey
	CMP.B	#$4E,D1 		;curs r
	BEQ.W	MoveCharRight
	CMP.B	#$4F,D1 		;curs l
	BEQ.W	MoveCharLeft
	CMP.B	#2,EnterTextFlag
	BEQ.S	mt_wfokywt
	CMP.B	#$46,D1 		;DEL
	BEQ.W	DeleteChar
	CMP.B	#$41,D1 		;backspace
	BEQ.W	BackSpaceChar
mt_wfokywt:
	CMP.B	#68,D1			;enter
	BEQ.W	GetLineReturn
	CMP.B	#69,D1			;escape
	BEQ.W	ESCLineReturn
	BTST	#7,D1
	BNE.W	WaitForKey

	cmp.b	#1,kbdmode
	BNE.S	itkex1

	lea	GUnShiftedKeymap,A4	;german
	bra.s	itk2


itkex1:
	cmp.b	#0,kbdmode
	beq.s	itk1			;4.0

	tst	keymapmem
	beq.s	itk1

	move.l	keymapmem,a4
	bra.s	itk2
itk1:
	LEA	UnShiftedKeymap,A4
itk2:	MOVE.B	ShiftKeyStatus,D0
	AND.B	#3,D0
	TST.B	ShiftKeyStatus
	BEQ.S	gtlskip

	cmp.b	#1,kbdmode
	bne.s	itkex3
	LEA	GShiftedKeymap,A4
	bra.s	gtlskip

itkex3:
	cmp.b	#0,kbdmode
	beq.s	itk3			;4.0

	tst	keymapmem
	beq.s	itk3
	move.l	keymapmem,a4
	add.l	#$65,a4
	bra.s	gtlskip

itk3:	LEA	ShiftedKeymap,A4	;with shift
gtlskip:
	AND.W	#$007F,D1
	CMP.B	#$40,D1 		;space
	BHI.W	WaitForKey
	MOVE.B	0(A4,D1.W),D1
	BEQ.W	WaitForKey
	TST.B	EnterTextFlag
	BEQ.S	TextLineKey

	CMP.B	#'0',D1
	BCS.W	WaitForKey
	CMP.B	#'f',D1
	BHI.W	WaitForKey
	CMP.B	#2,EnterTextFlag
	BEQ.S	mt_wfokywa
	CMP.B	#'a',D1
	BCC.S	TextLineKey
mt_wfokywa:
	CMP.B	#'9',D1
	BHI.W	WaitForKey

TextLineKey:
	CMP.L	TextEndPtr,A6
	BEQ.W	WaitForKey
	CMP.B	#2,EnterTextFlag
	BEQ.S	mt_wfokywb
	MOVE.L	TextEndPtr,A4

tlkloop:
	MOVE.B	-(A4),1(A4)
	CMP.L	A4,A6
	BNE.S	tlkloop

mt_wfokywb:
	MOVE.L	TextEndPtr,A4
	CLR.B	(A4)			;clear end
	MOVE.B	D1,(A6)+
	BSR.S	PosMoveRight
	BSR.W	UpdateText
	CLR.B	RawKeyCode
	BRA.W	WaitForKey

;***********************************
;* clicked with mouse at textline  *
;***********************************

LineClicked:
	MOVE.W	MouseY,D1
	SUB.W	LineCurY,D1
	CMP.W	#2,D1
	BGT.W	GetLineReturn
	CMP.W	#$FFF8,D1
	BLT.W	GetLineReturn
	MOVE.W	MouseX,D1
	SUB.W	LineCurX,D1
	ADDQ.W	#4,D1
	ASR.W	#3,D1
	BEQ.W	WaitForKey
	BPL.S	mt_lkcl2
	CMP.L	DSTPtr(PC),A6
	BEQ.W	WaitForKey
	SUBQ.L	#1,A6
	BSR.S	mt_posmvr2
mt_lkcl1:
	BSR.W	UpdateText
	BRA.W	WaitForKey

mt_lkcl2:
	CMP.L	TextEndPtr,A6
	BEQ.W	WaitForKey
	TST.B	(A6)
	BEQ.W	WaitForKey
	ADDQ.L	#1,A6
	BSR.S	PosMoveRight
	BRA.S	mt_lkcl1

PosMoveRight:
	MOVE.L	DSTPos,D0
	MOVEQ	#0,D1
	MOVE.W	TextLength,D1
	TST.B	EnterTextFlag
	BNE.S	mt_posmvr
	SUBQ.W	#1,D1
mt_posmvr:
	CMP.L	D1,D0
	BCS.S	mt_posmvr1
	ADDQ.L	#1,DSTOffset
	BRA.W	UpdateLineCurPos

mt_posmvr1:
	ADDQ.L	#1,DSTPos
	ADDQ.W	#8,LineCurX
	BRA.W	UpdateLineCurPos

mt_posmvr2:
	TST.L	DSTPos
	BNE.S	mt_posmvr3
	SUBQ.L	#1,DSTOffset
	BRA.W	UpdateLineCurPos

mt_posmvr3:
	SUBQ.L	#1,DSTPos
	SUBQ.W	#8,LineCurX
	BRA.W	UpdateLineCurPos

;***********************************

BackSpaceChar:
	CMP.L	DSTPtr(PC),A6
	BEQ.W	WaitForKey
	SUBQ.L	#1,A6
	MOVE.L	A6,A4
lbC00C2E6:
	MOVE.B	1(A4),(A4)+
	CMP.L	TextEndPtr,A4
	BNE.B	lbC00C2E6
	BSR.B	mt_posmvr2
upwake:
	BSR.W	UpdateText
	BRA.W	WaitForKey

DeleteChar:
	MOVE.L	A6,A4
dechloop:
	MOVE.B	1(A4),(A4)+
	CMP.L	TextEndPtr,A4
	BCS.B	dechloop
	BRA.S	upwake

;***********************************

MoveCharRight:
	CMP.L	TextEndPtr,A6
	BEQ.W	WaitForKey
	TST.B	(A6)
	BEQ.W	WaitForKey
	ADDQ.L	#1,A6
	BSR.W	PosMoveRight
	BRA.S	upwake

MoveCharLeft:
	CMP.L	DSTPtr(PC),A6
	BEQ.W	WaitForKey
	SUBQ.L	#1,A6
	BSR.B	mt_posmvr2
	BRA.S	upwake


;***********************************

GetLineReturn:
	move.b	mt_savekeyRepeat,KeyRepeat 	;restore keyrepeat status
	MOVE.W	#$FFFF,mt_getlineflag
	BRA.S	GetLineReturn2

ESCLineReturn:
	CLR.W	mt_getlineflag



GetLineReturn2:
	CALL	ClearAllKeys
	MOVE.L	DSTPtr,A6
	MOVE.L	A6,A4
dlrloop:
	TST.B	(A4)+
	BNE.B	dlrloop
	SUBQ.L	#1,A4

dlrloop2:
	CMP.L	TextEndPtr,A4
	BCC.S	dlrexit
	CLR.B	(A4)+
	BRA.B	dlrloop2

dlrexit:
	CLR.W	LineCurX
	MOVE.W	#$010E,LineCurY
	BSR.W	UpdateLineCurPos
	CLR.W	GetLineFlag
	MOVE.B	RawKeyCode,RepeatKey
	CALL	ClearAllKeys
	CLR.L	DSTOffset
	BSR.S	UpdateText
	CALL	WaitForButtonUp
	TST.W	mt_getlineflag
	RTS

AbortGetLine:
	MOVE.L	DSTPtr,A6
	MOVE.L	A6,A4
clliloop:
	CLR.B	(A4)+
	CMP.L	TextEndPtr,A4
	BNE.S	clliloop
	BSR.S	UpdateText
	BRA.W	GetLineReturn

UpdateText:
	TST.W	mt_gtkyflag
	BEQ.S	UpdText2
	MOVEM.L D0/D1/D3,-(SP)
	MOVE.W	LineCurXStore(PC),D0
	MOVE.W	LineCurYStore(PC),D1
	MOVE.L	DSTPtr,A0
	ADD.L	DSTOffset,A0
	MOVE.W	TextLength,D3
	CALL	Write_Text
	MOVEM.L (SP)+,D0/D1/D3
	RTS

UpdText2:
	MOVE.W	A5,TextOffset
	MOVE.L	DSTPtr,A0
	ADD.L	DSTOffset,A0
	GOTO	ShowText2

;---------
lbC00C3F6:
	MOVEM.L D1-D7/A0-A6,-(SP)
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEM.L D0-D3,-(SP)
	MOVE.L	D2,D0
	MOVE.L	D3,D1
	LEA	lbL00C480(PC),A0
	CALL	lbC0132B6
	CLR.B	0(A0,D3.W)
	MOVE.L	A0,ShowTextPtr
	MOVE.L	A0,TextEndPtr
	ADD.L	D3,TextEndPtr
	MOVE.W	D3,TextLength
	MOVEM.L (SP)+,D0-D3
	MOVE.B	#2,EnterTextFlag
	MOVE.B	ShowZeroFlag,D4
	MOVEM.L D4,-(SP)
	MOVE.B	#$20,ShowZeroFlag
	MOVE.L	ShowTextPtr,A6
	BSR.W	EnterTextNow
	MOVEM.L (SP)+,D4
	MOVE.B	D4,ShowZeroFlag
	CLR.B	EnterTextFlag
	LEA	lbL00C480(PC),A0
	MOVE.W	TextLength,D0
	CALL	lbC01332E
	CALL	RestorePtrCol		;3.56
	MOVEM.L (SP)+,D1-D7/A0-A6
	TST.L	D0
	RTS


lbL00C480:	dc.l	0,0,0,0,0,0,0,0
mt_getlineflag:	dc.w	0
DSTPtr: 	dc.l	0
DSTPos: 	dc.l	0
LineCurXStore:	dc.w	0
LineCurYStore:	dc.w	0
mt_gtkyflag:	dc.w	0
DSTOffset:	dc.l	0

EnterSongName:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	mt_songdataptr,A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#$00000013,TextEndPtr
	MOVE.W	#$0014,TextLength
	MOVE.W	#$07D8,A4
	BSR.W	GetTextLine
	CLR.L	TextEndPtr
	GOTO	RestorePtrCol

HitSampleName:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	mt_songdataptr,A6
	LEA	-10(A6),A6
	MOVE.W	InsNum,D7
	BNE.S	HitSampleName2
	MOVE.W	LastInsNum,D7
HitSampleName2:
	MULU	#30,D7
	ADD.L	D7,A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#$15,TextEndPtr 	;15
	MOVE.W	#$16,TextLength 	;16
	MOVE.W	#$190A-4,A4		;-4
	BSR.W	GetTextLine
	CLR.L	TextEndPtr
	;move.l	savesamadr,a6
	;move.w	savesambyt,$16(a6)
	GOTO	RestorePtrCol


CheckForIFF2:
	MOVEQ	#-1,D2
	BRA.B	ciff2

CheckForIFF:
	MOVEQ	#0,D2
ciff2:	MOVEQ	#0,D1
	CMP.L	#'FORM',(A0)
	BNE.S	wiskip
	CMP.L	#'8SVX',8(A0)
	BNE.S	wiskip
	MOVE.L	A0,A2
	MOVE.L	A1,D0
	ADD.L	A0,A1
	TST.L	D2
	BEQ.S	cfiloop
	BSR.S	CheckIFFLoop
cfiloop:
	CMP.L	#'BODY',(A0)
	BEQ.S	wasIFF
	ADDQ.L	#2,A0
	CMP.L	A1,A0
	BLS.S	cfiloop
	RTS

wasIFF:
	ADDQ.L	#8,A0
	ADD.L	A2,D0
	SUB.L	A0,D0
wiloop:
	MOVE.B	(A0)+,(A2)+
	CMP.L	A1,A0
	BLS.S	wiloop
	MOVE.L	ActSamplePointer(PC),A3
	LSR.L	#1,D0
	MOVE.W	$0016(A3),D1
	SUB.W	D0,D1
	MOVE.W	D0,$0016(A3)
wiskip:
	LEA	SamplePointers(PC),A3
	MOVE.W	InsNum,D0
	LSL.W	#1,D0
	MOVE.W	D1,0(A3,D0.W)
	RTS

CheckIFFLoop:
	BTST	#6,PackMode
	BNE.S	CheckIFFLoop_o
	RTS

CheckIFFLoop_o:
	MOVEM.L D0/A0,-(SP)
CheckIFFLoop_l:
	CMP.L	#'VHDR',(A0)
	BEQ.S	Return6
	ADDQ.L	#2,A0
	CMP.L	A1,A0
	BLS.S	CheckIFFLoop_l
cilend:
	MOVEM.L (SP)+,D0/A0
	RTS

Return6:
	MOVE.L	ActSamplePointer(PC),A3
	MOVE.L	12(A0),D0
	BEQ.S	cilend
	LSR.L	#1,D0
	MOVE.W	D0,$001C(A3)
	MOVE.L	8(A0),D0
	BNE.S	lbC00C5E4
	MOVEQ	#2,D0
lbC00C5E4:
	LSR.L	#1,D0
	MOVE.W	D0,$001A(A3)
	BRA.S	cilend

ActSamplePointer:	dc.l	0			; actual active sample
SamplePointers:		dc.w	31			; V3.15 dc.w 31

NotAvailable:
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.L	A0,-(SP)
	CALL	ClearRightAreaReq
	MOVE.L	(SP)+,A0
	LEA	CopyrightBoxGFX,A1
	LEA	lbL0197D4,A2		;ok
	MOVE.L	#$00000460,D0
	CALL	SwapBoxMem
	LEA	notavailable.MSG,A0
	MOVE.W	#$0112,D0
	MOVEQ	#$3E,D1
	CALL	PrintTextInReqs
navlop:
	BSR.W	ResetKeyTimer
	CALL	DoKeyBuffer
	CALL	CheckLAmigaKeys

	checklmb
	BNE.S	navlop

	MOVEM.W (MouseX),D0/D1
	LEA	CopyrightsGadData,A0
	CALL	MousXTablKonv
	TST.W	D2
	BEQ.B	navlop
	CMP.W	#2,D2
	BEQ.B	navret
	BRA.B	navlop

navret:
	CALL	OpenRequester
	CLR.W	DirCopFlag
	RTS

;**********************************
;* from checkiffsamtypes          *
;**********************************
NavailMess:
	LEA	notavailable.MSG,A0
	MOVEQ	#20,D0
Navaillop:
	MOVE.B	(A0)+,D1
	BEQ.S	Navailret
	MOVE.B	D1,(A1)+
	SUBQ.W	#1,D0
	BGT.S	Navaillop
	RTS

Navailret:
	MOVE.B	#$20,(A1)+
	SUBQ.W	#1,D0
	BGT.S	Navailret
	RTS

CheckIFFSamTypes:
	LEA	AUTH.MSG,A1
	BSR.S	NavailMess
	LEA	COPY.MSG,A1
	BSR.S	NavailMess
	LEA	ANNO.MSG,A1
	BSR.S	NavailMess
	LEA	DYN.MSG,A1
	BSR.S	NavailMess
	LEA	ascii.MSG,A1
	BSR.S	NavailMess

	MOVE.B	#$FF,MaesErrorFlag
	SF	SmplErrFlag
	SF	EightBitSampleFlag
	CLR.L	AddedMSamLength
	CLR.L	CheckedMSamLength
	CLR.L	SumMSamLength
	CLR.L	lbL017C32
	CLR.L	lbL017C36
	CLR.L	lbL017C3A
	CLR.L	UndynStore
	CLR.W	lbW017C30

	MOVE.L	SampleDataPtr,A0
	MOVE.L	A0,IFF8SVXPTR
	MOVE.L	(A0)+,D0
	CMP.L	#'MAES',D0
	BEQ.W	LoadMaestroSam

	CMP.L	#'FORM',D0
	BNE.W	MaesLDBg		; RAW

	MOVE.L	(A0)+,IFF8SVXR1
	CMP.L	#'8SVX',(A0)+
	BNE.S	No8SVXIFF		; strange IFF

;--- prepare and check IFF 8SVX sample ---

	ST	EightBitSampleFlag
	MOVE.L	IFF8SVXPTR,D0
	ADD.L	IFF8SVXR1,D0
	MOVE.L	D0,IFF8SVXSum

.loop1:	CMP.L	IFF8SVXSum,A0
	BGE.S	IFFBodyError
	TST.B	SmplErrFlag
	BEQ.S	.l2
	RTS

.l2:	LEA	VHDR.MSG,A1
	MOVE.L	(A0)+,D0
.loop2:
	MOVE.L	(A1)+,D1
	BEQ.S	.l4
	CMP.L	D1,D0
	BNE.S	.l3
	MOVE.L	(A1),A1
	JSR	(A1)
	BRA.S	.loop1

.l3:	ADDQ.W	#4,A1
	BRA.S	.loop2

.l4:	BSR.S	MaesChk6
	ADDQ.W	#1,lbW017C30
	BRA.S	.loop1

;********************************
No8SVXIFF:
	ST	SmplErrFlag
	MOVE.L	#No8SVXIFF.MSG,SmplErrMsg
	RTS

IFFBodyError:
	MOVE.B	#1,MaesErrorFlag
	TST.L	AddedMSamLength
	BNE.S	MaesChk6
	ST	SmplErrFlag
	MOVE.L	#IFFBodyFail.MSG,SmplErrMsg
	RTS

MaesChk6:
	MOVE.L	(A0)+,D0
	MOVE.L	A0,A2
	ADDQ.L	#1,D0
	BCLR	#0,D0
	ADD.L	D0,A0
	RTS

MaesChk7:
	BSR.S	MaesChk6
	MOVE.L	A2,AddedMSamLength
	MOVE.L	D0,CheckedMSamLength
	RTS

MaesChk8:
	BSR.S	MaesChk6
	MOVE.L	A2,lbL017C3A
	MOVE.L	D0,UndynStore
	RTS

MaesChk9:
	BSR.S	MaesChk6
	MOVE.L	(A2)+,lbL017C32
	MOVE.L	(A2)+,D0
	MOVE.L	D0,lbL017C36
	ADDQ.W	#4,A2
	MOVEQ	#0,D0
	MOVE.W	(A2)+,D0
	MOVE.L	D0,lbL017C46
	MOVE.B	(A2)+,D0
	CMP.B	#1,D0
	BEQ.S	MaesErrFibon
	ST	SmplErrFlag
	MOVE.L	#IFFerroronly1.MSG,SmplErrMsg
	BRA.S	MaesChk10

MaesErrFibon:
	TST.B	(A2)+
	BEQ.S	MaesChk10
	ST	SmplErrFlag
	MOVE.L	#IFFerrorFibon.MSG,SmplErrMsg
MaesChk10:
	RTS

MaesAuthor:
	LEA	AUTH.MSG,A3
	BRA.S	MaesChk11

MaesCopyright:
	LEA	COPY.MSG,A3
	BRA.S	MaesChk11

MaesAnno:
	LEA	ANNO.MSG,A3
	BRA.S	MaesChk11

MaesDyn:
	LEA	DYN.MSG,A3
MaesChk11:
	BSR.W	MaesChk6
	MOVE.L	D0,D7
	MOVEQ	#$14,D7
	BRA.S	MaesChk17

MaesChk12:
	MOVE.B	(A2)+,D0
	BNE.S	MaesChk15
MaesChk13:
	MOVE.B	#$20,(A3)+
	DBRA	D7,MaesChk13
	rts

MaesChk14:
	MOVEQ	#$20,D0
	BRA.S	MaesChk16

MaesChk15:
	CMP.B	#10,D0
	BEQ.S	MaesChk14
MaesChk16:
	MOVE.B	D0,(A3)+
MaesChk17:
	DBRA	D7,MaesChk12
	RTS

MaesLDBg:
	SF	EightBitSampleFlag
	MOVE.B	#2,MaesErrorFlag
	MOVE.L	#$000020AB,lbL017C46
	MOVE.L	SampleDataPtr,AddedMSamLength
	MOVE.L	SampleDataLength,CheckedMSamLength
	RTS

LoadMaestroSam:
	CMP.L	#('TRO'<<8),(A0)+
	BNE.S	NoMaestroMess
	;CMP.L	#$01010200,(A0)+
	;CMP.L	#$00010000,(A0)+
	;BNE.S	NoMaestroMess
	MOVE.L	(A0)+,D0
	MOVE.L	D0,CheckedMSamLength
	MOVE.L	(A0)+,lbL017C46
	MOVE.L	A0,AddedMSamLength
	CMP.L	#$00006D60,lbL017C46
	BLE.S	MaesLDBo
	LSR.L	#1,D0
	MOVE.L	D0,CheckedMSamLength
MaesLDBo:
	MOVE.B	#0,MaesErrorFlag
	SF	EightBitSampleFlag
	RTS

NoMaestroMess:
	ST	SmplErrFlag
	MOVE.L	#NotaMaestro16.MSG,SmplErrMsg
	RTS


;***************************
;* examine opened sample at*
;* his length. return in D0*
;***************************

ExamineAndAlloc:
	MOVEQ	#-2,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Lock
	MOVE.L	D0,FileLock
	bne.s	gagamel
	GOTO	CantFindFile

gagamel:
	MOVE.L	D0,D1
	MOVE.L	#FileInfoBlock,D2
	CALLSYS	Examine
	TST.L	FIB_EntryType
	BPL.S	CantExam2
	MOVE.L	FileLock,D1
	CALLSYS	UnLock
	MOVE.L	FIB_FileSize,D0
	BNE.S	fiesm
	GOTO	FileIsEmpty
fiesm:
	RTS

CantExam2:
	GOTO	CantExamFile

;****************************
;* after sam examine alloc  *
;****************************

AllocSampleMem:
	MOVE.L	D0,SampleDataLength
	CLR.L	SampleDataPtr
	MOVEQ	#0,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,SampleDataPtr
	BNE.S	AllocSamMemOK
	LEA	Couldnotalloc.MSG,A0
	CALL  	ShowStatusText
	BRA.W	OutOfMemErr

AllocSamMemOK:
	RTS

FreeSampleMem:
	MOVE.L	SampleDataPtr,D0
	BEQ.S	.skip
	MOVE.L	D0,A1
	MOVE.L	SampleDataLength,D0
	BEQ.S	.skip
	MOVE.L	4.w,a6
	CALLSYS	FreeMem

.skip:	RTS

SetUndynBase:
	MOVE.L	D1,-(SP)
	MOVE.L	mt_mxbuf4base,D1
	BSET	D0,D1
	MOVE.L	D1,mt_mxbuf4base
	MOVE.L	(SP)+,D1
	RTS

ClrUndynBase:
	MOVE.L	D1,-(SP)
	MOVE.L	mt_mxbuf4base,D1
	BCLR	D0,D1
	MOVE.L	D1,mt_mxbuf4base
	MOVE.L	(SP)+,D1
	RTS


NotSampleNull2:
	GOTO	NotSampleNull

;*************************************
;* Load Sample from DirScreen        *
;*************************************

LoadSample:
	TST.W	InsNum
	BEQ.S	NotSampleNull2
	CALL	StorePtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath

	LEA	DirInputName,A0
	MOVEQ	#30-1,D0
.lp1:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.lp1

	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	MULU	#30,D0
	LEA	-10(A0),A0		; first sample
	ADD.L	D0,A0			; actual sample
	LEA	DirInputName,A1
	MOVEQ	#22-1,D0
.lp2:
	MOVE.B	(A1)+,(A0)+
	DBRA	D0,.lp2			; clear samplenamearea, 22 byte

	CALL	SetDiskPtrCol
	MOVE.L	#FileName,D1
	BSR.W	ExamineAndAlloc
	;MOVE.L	FIB_FileSize,D0		;useless, already in examine

	BSR.W	AllocSampleMem
	tst.l	d0			;included 4.01
	bne.s	.doit
	JMP	CantOpenFile

.doit:	LEA	LoadingSampleText,A0
	CALL   ShowStatusText
	MOVE.L	#FileName,D1
ralgas:
	MOVE.L	DOSBase,A6
	MOVE.L	#$000003ED,D2
	CALLSYS	Open
	MOVE.L	D0,D7			;file D0 to d7
	bne.s	.ra
	GOTO	CantOpenFile

.ra:	MOVE.L	D0,D1
	MOVE.L	SampleDataPtr,D2
	MOVE.L	SampleDataLength,D3
	CALLSYS	Read

	MOVE.L	D7,D1				;file from open to d1
	CALLSYS	Close

	move.l	SampleDataPtr,A0		;fix 401
	move.l	SampleDataLength,A1		;fix 401 length

	BSR.W	CheckIFFSamTypes
	TST.B	SmplErrFlag			; errors ?
	BEQ.S	.l0

	MOVE.L	SmplErrMsg,A0			; print sampleerror statusmsg
	CALL   ShowStatusText
	BSR.W	FreeSampleMem
	CALL	SetErrorPtrCol
	RTS

.l0:	BSR.W	TurnOffVoices
	BSR.W	FreeSample
	CMP.L	#MaxSamLen,CheckedMSamLength	; max loadsample length
	BLE.S	.l1
	MOVE.L	#MaxSamLen,CheckedMSamLength

.l1:	cmp.w	#3,CurrScreen			; 3.61, update samplefilname in dir
	bne.b	.rb
	lea	DirInputName,a0
	move.w	#$2355,d1
	moveq	#$16,d0
	CALL	ShowText3

.rb:	MOVE.L	AddedMSamLength,D0
	ADD.L	CheckedMSamLength,D0
	MOVE.L	D0,SumMSamLength
	MOVE.L	CheckedMSamLength,D0
	LEA	mt_songdataptr,A4
	MOVE.W	InsNum,D1
	LSL.W	#2,D1			;*20
	ADD.W	D1,A4
	MOVE.L	D0,$007C(A4)		;length
	MOVE.L	4.w,a6
	MOVE.L	XDmaType,D1
	CALLSYS	AllocMem
	MOVE.L	D0,(A4)
	MOVE.L	D0,DiskDataPtr
	BNE.S	.rc
	LEA	Couldnotalloc.MSG0,A0
	CALL	ShowStatusText
	BRA.W	OutOfMemErr

.rc:
	MOVE.L	UndynStore,D0
	BEQ.W	CaSamAgain
	BTST	#3,InfoOnOff
	BNE.S	UndynningSample

	LEA	MSamPointer,A4
	MOVE.W	InsNum,D1
	LSL.W	#3,D1
	ADD.W	D1,A4
	MOVE.L	D0,n_start(A4)
	MOVE.L	4.w,a6
	MOVEQ	#0,D1
	CALLSYS	AllocMem
	MOVE.L	D0,(A4)
	MOVE.L	D0,UnDynMemPtr
	BNE.S	.rd

	CLR.L	4(A0)
	LEA	Couldnotalloc.MSG1,A0
	CALL  	ShowStatusText
	BRA	OutOfMemErr

.rd:	MOVE.L	lbL017C3A,A0
	MOVE.L	UnDynMemPtr,A1
	MOVE.L	A1,A2
	ADD.L	UndynStore,A2
.lopa:
	MOVE.W	(A0)+,(A1)+
	CMP.L	A2,A1
	BLT.S	.lopa

	MOVE.W	InsNum,D0
	BSR.W	SetUndynBase		;fix 4.01
	BRA.S	contnoundyn

;*******************************
UndynningSample:
	LEA	Undynning.MSG,A0
	CALL  	ShowStatusText
	MOVE.L	AddedMSamLength,A0
	MOVE.L	lbL017C3A,A1
	MOVE.L	A0,A2
	ADD.L	CheckedMSamLength,A2
	MOVE.W	(A1)+,D1
	ADDQ.W	#2,A1

.loopk:	MOVEQ	#0,D7
	MOVE.W	(A1)+,D7
	ADD.L	D7,D7
	MOVE.W	(A1)+,D2

.rf:	CMP.L	A2,A0
	BGE.S	CaSamAgain
	MOVE.B	(A0),D0
	EXT.W	D0
	MULS	D2,D0
	DIVS	#$0040,D0
	MOVE.B	D0,(A0)+
	SUBQ.L	#1,D7
	BGT.S	.rf
	SUBQ.W	#1,D1
	BGT.S	.loopk
CaSamAgain:
	MOVE.W	InsNum,D0
	BSR.W	ClrUndynBase

;************************************
;* sample load continue (no undyn)  *
;************************************
contnoundyn:
	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	MULU	#$001E,D0
	LEA	-10(A0),A0
	ADD.L	D0,A0
	MOVE.L	A0,ActSamplePointer
	MOVE.L	CheckedMSamLength,D0
	LSR.L	#1,D0
	;add.l	d0,d0
	MOVE.W	D0,$0016(A0)
	MOVE.L	#$00400000,$0018(A0)
	MOVE.W	#1,$001C(A0)

	BTST	#6,PackMode
	BEQ.S	SamNoLoops

	MOVE.L	lbL017C36,D0
	BEQ.S	SamNoLoops

	LSR.L	#1,D0
	;add.l	d0,d0
	MOVE.W	D0,$001C(A0)
	MOVE.L	lbL017C32,D0
	BNE.S	SNLoops
	MOVEQ	#2,D0
SNLoops:
	LSR.L	#1,D0
	;add.l	d0,d0
	MOVE.W	D0,$1A(A0)
SamNoLoops:
	MOVE.L	DiskDataPtr,A1
	MOVE.L	AddedMSamLength,A0
	MOVE.L	A1,A2
	ADD.L	CheckedMSamLength,A2
	CMP.B	#0,MaesErrorFlag
	BEQ.S	UpSamMaestro
.lp:
	MOVE.W	(A0)+,(A1)+
	CMP.L	A2,A1
	BLT.S	.lp
	BRA.S	SamLoadFin

;************************
UpSamMaestro:
	CMP.L	#$00006D60,lbL017C46
	BLE.S	USMa4
	MOVEM.L A0-A2,-(SP)
	LEA	UpsamplingMae.MSG,A0
	CALL  	ShowStatusText
	MOVEM.L (SP)+,A0-A2
	MOVEQ	#9,D2
USMa1:
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	EXT.L	D0
	EXT.L	D1
	ADD.L	D1,D0
	BMI.S	USMa2
	LSR.L	D2,D0
	BRA.S	USMa3

USMa2:
	NEG.L	D0
	LSR.L	D2,D0
	NEG.L	D0
USMa3:
	MOVE.B	D0,(A1)+
	CMP.L	A2,A1
	BLT.S	USMa1
	BRA.S	SamLoadFin

USMa4:
	MOVE.B	(A0)+,(A1)+
	ADDQ.W	#1,A0
	CMP.L	A2,A1
	BLT.S	USMa4

;****************************
;* sample loading finnished *
;****************************
SamLoadFin:
	BSR.W	FreeSampleMem
	BSR.W	ValidateLoops
	CALL  	ShowSampleInfo
	MOVE.L	DiskDataPtr,A0
	CLR.W	(A0)
	CALL	RedrawSample
	CALL	ShowAllRight
	GOTO	RestorePtrCol


;***************************
CreateSampleName:
	LEA	SampleFileName,A0
	MOVEQ	#$1B,D0
csnloop:
	CLR.B	(A0)+
	DBRA	D0,csnloop
	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	MULU	#30,D0
	LEA	-10(A0),A0
	ADD.L	D0,A0
	MOVE.L	A0,ActSamplePointer
	MOVEQ	#0,D0
	MOVE.W	22(A0),D0
	ADD.L	D0,D0
	MOVE.L	D0,DiskDataLength
	MOVE.L	D0,lbL003890
	ADD.L	#$60,D0			;96
	MOVE.L	D0,IFFSa_Length		;IFF headerlength
	MOVEQ	#0,D0
	MOVE.W	22(A0),D0
	ADD.L	D0,D0
	MOVEQ	#0,D1
	MOVE.W	28(A0),D1
	CMP.W	#1,D1
	BLS.S	csnskp2
	ADD.L	D1,D1
	MOVEQ	#0,D0
	MOVE.W	26(A0),D0
	ADD.L	D0,D0
	BRA.S	csnskp3

csnskp2:
	MOVEQ	#0,D1
csnskp3:
	MOVE.L	D0,lbL003840
	MOVE.L	D1,lbB003844

	LEA	SampleFileName,A1
	LEA	IFFSa_Name,A2

	MOVEQ	#21,D0
.loop:	MOVE.B	(A0),(A1)+
	MOVE.B	(A0)+,(A2)+
	DBRA	D0,.loop

	MOVE.L	#SampleFileName,D1
	MOVE.L	D1,FileNamePtr
	BSR.S	FindColon
	BEQ.S	CheckOverride
	MOVE.L	DirPath,A0
	CALL	CopyPath
	MOVE.L	#SampleFileName,A0
csnloop3:
	MOVE.B	(A0)+,(A1)+
	BNE.B	csnloop3
	MOVE.L	#FileName,FileNamePtr
	RTS

FindColon:
	MOVE.L	D1,A0
fcloop:
	MOVE.B	(A0)+,D0
	BEQ.S	FindColonFail
	CMP.B	#':',D0
	BEQ.S	FindColonSuccess
	BRA.B	fcloop

FindColonFail:
	MOVEQ	#-1,D0
	RTS

FindColonSuccess:
	MOVEQ	#0,D0
	RTS

CheckOverride:
	BTST	#7,PackMode
	BNE.S	CheckOverride2
	RTS

CheckOverride2:
	MOVE.L	#SampleFileName,A0
	MOVE.L	A0,A1
	LEA	21(A1),A1
	MOVE.L	A1,A2
chkovlp:
	MOVE.B	-(A1),D0
	CMP.B	#':',D0
	BEQ.S	chkovok
	CMP.B	#'/',D0
	BEQ.S	chkovok
	MOVE.L	A1,A2
	CMP.L	A0,A1
	BHI.S	chkovlp
chkovok:
	MOVE.L	DirPath,A0
	CALL	CopyPath
chkov12:
	MOVE.B	(A2)+,(A1)+
	BNE.S	chkov12
	MOVE.L	#FileName,FileNamePtr
	RTS

;***********************************
;* check if loops valid in sample  *
;***********************************

ValidateLoops:
	MOVE.L	mt_songdataptr,A0
	LEA	$0014(A0),A0
	MOVEQ	#30,D0
valolop:
	MOVE.W	22(A0),D1
	MOVE.W	26(A0),D2
	MOVE.W	28(A0),D3
	CMP.W	D1,D2
	BCC.S	valosk1
	ADD.W	D2,D3
	CMP.W	D1,D3
	BHI.S	valosk2
valoque:
	TST.W	28(A0)
	BNE.S	valosk3
	MOVE.W	#1,28(A0)
valosk3:
	LEA	30(A0),A0
	DBRA	D0,valolop
	RTS

valosk2:
	SUB.W	D2,D1
	MOVE.W	D1,28(A0)
	BRA.S	valoque

valosk1:
	MOVEQ	#1,D1
	MOVE.L	D1,26(A0)
	BRA.S	valoque

;***********************************
;* load sample from plst and song  *
;***********************************

LoadPreset:
	CLR.B	RawKeyCode
	TST.W	InsNum
	BEQ.W	NotSampleNull2
	BSR.W	TurnOffVoices
	BSR.W	FreeSample
	BSR.W	CreateSampleName
	MOVE.L	FileNamePtr,A0
	TST.B	(A0)
	BNE.S	.l0
	RTS

.l0:	MOVE.L	DiskDataLength,D0
	BNE.S	.l1
	RTS

.l1:	MOVE.L	DiskDataLength,D0
	BSR.B	AllocSample
	MOVE.L	DiskDataPtr,D0
	BEQ.B	PtrRedrSam
	CALL	ShowSampleInfo
	CALL	DoLoadData
	CALL	ShowAllRight
	MOVE.L	DiskDataPtr,A0

xsampleret:
	MOVE.L	DiskDataPtr,A0
	MOVE.L	DiskDataLength,A1
	BSR.W	CheckForIFF
	BSR.W	ValidateLoops
	CALL	ShowSampleInfo
	MOVE.L	DiskDataPtr,A0
	CLR.W	(A0)
	;clr.w	 xpkflag
	CALL	RedrawSample
	MOVE.W	#1,UpdateFreeMem
	RTS
;---------------------
PtrRedrSam:
	CALL	StorePtrCol
	BSR.W	OutOfMemErr
	CALL	RestorePtrCol
	GOTO	RedrawSample

;***********************************
;* Sampe Allocation Memory Routine *
;***********************************
AllocSample:
	MOVE.L	D0,-(SP)
	MOVE.L	XDmaType,D1		;Changed to Public for Fast Replay!
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,DiskDataPtr
	LEA	mt_songdataptr,A0
	MOVE.W	InsNum,D1
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVE.L	DiskDataPtr,(A0)
	MOVE.L	(SP)+,$007C(A0)
	RTS

;***********************************
;* Sample Freeing Memory Routine   *
;***********************************

FreeSample:
	LEA	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	BNE.S	.l1
	RTS

.l1:	LSL.W	#2,D0
	LEA	0(A0,D0.W),A0
	MOVE.L	(A0),D1
	BNE.S	.l2
	RTS

.l2:	CLR.L	(A0)
	MOVE.L	$7C(A0),D0
	BNE.S	.l3
	RTS

.l3:	CLR.L	$7C(A0)
	MOVE.L	D1,A1
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	LEA	MSamPointer,A0
	MOVE.W	InsNum,D0
	BNE.S	.l4
	RTS

.l4:	LSL.W	#3,D0
	ADD.W	D0,A0
	MOVE.L	(A0),D1
	BNE.S	.l5
	RTS

.l5:	CLR.L	(A0)
	MOVE.L	4(A0),D0
	BNE.S	.l6
	RTS

.l6:	CLR.L	4(A0)
	MOVE.L	D1,A1
	CALLSYS	FreeMem
	RTS

;***********************************
;* Delete File in DirScreen        *
;***********************************

DelFile:
	MOVE.W	DirFBitt2,DirFBitt
	LEA	Deletethisfil.MSG,A0
	CALL	AreYouSure
	BEQ.S	DelFileYes
	RTS

DelFileYes:
	LEA	Deletingfile.MSG,A0
	CALL	ShowStatusText
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#$1D,D0 		;+50
DelFilLp:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,DelFilLp
	MOVE.L	#FileName,FileNamePtr
	MOVE.L	DOSBase,A6
	MOVE.L	FileNamePtr,D1
	MOVE.L	D1,A0
	CALLSYS	DeleteFile
	CALL	ShowAllRight
	CALL	SetNormalPtrCol
	CALL	StorePtrCol
	BTST	#3,PackMode
	BNE.S	DelFilRDir
	RTS

DelFilRDir:
	MOVE.B	#$FF,di_readdirnew
	GOTO	ReadDir

;***********************************
;* Rename File in DirScreen        *
;***********************************

RenameFile:
	LEA	DirInputName,A0
	LEA	NewInputName,A1
	MOVEQ	#$17,D0
RenameFile1:
	MOVE.B	(A0)+,(A1)+
	BNE.S	RenameFile3
	SUBQ.L	#1,A0
RenameFile3:
	DBRA	D0,RenameFile1
	MOVE.W	DirFBitt2,DirFBitt
	LEA	Renamefileas.MSG(PC),A0
	LEA	NewInputName,A1
	MOVEQ	#$18,D0
	LEA	NotStandardSongData,A2
	CALL	mt_makereqindir
	BEQ.S	RenameFile4
	RTS

RenameFile4:
	LEA	Renamingfile.MSG,A0
	CALL	ShowStatusText
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	NewInputName,A0
	MOVEQ	#$17,D0
RenClrLp:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,RenClrLp
	LEA	FileName,A0
	LEA	NewFileName,A1
RenStrLp:
	MOVE.B	(A0)+,(A1)+
	BNE.S	RenStrLp
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#$1D,D0 		;+50
RenStrLpt:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,RenStrLpt
	MOVE.L	#FileName,D1
	MOVE.L	#NewFileName,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Rename
	CALL	RestorePtrCol
	CALL	ShowAllRight
	BTST	#3,PackMode
	BNE.S	RenStrEnd
	RTS

RenStrEnd:
	MOVE.B	#$FF,di_readdirnew
	GOTO	ReadDir

Renamefileas.MSG:
	dc.b	10,10,'   RENAME FILE AS:',0
	EVEN

;*********************************
LoadSong:

	cmp.l	#'CHG!',changeflag
	bne.s	lsongchg
	CALL	modischanged
	cmp	#2,d0
	beq.s	lsongchg
	rts

lsongchg:
	clr.l	changeflag
	;BSET	 #1,$00BFE001
	;BCLR	 #1,Packetfield 	 	;Filter off
	clr.w	xpkflag
	clr.w	patt100memflag
	bsr.w	  clearcomments
	MOVE.W	#1,LoadingInProgress

so_allcm100mod5:
	BSR.W	DoClearSong
	BSR.W	DoClearSamples
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#30-1,D0
losoloop2:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,losoloop2
	MOVE.L	mt_songdataptr,DiskDataPtr
	MOVE.L	#FileName,FileNamePtr
	move.l	PatternMemAllocSize,DiskDataLength
	LEA	Loadingsong.MSG,A0
	CALL	ShowStatusText

	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1
	MOVE.L	#$000003ED,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile
	PEA	ModReadClose
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				;buffer
	MOVEQ	#4,D3				;length 4 bytes
	CALLSYS	Read
	CMP.L	#4,D0
	BNE.W	FileLoadError
	LEA	fourbytebuf,A0

	cmp.l	#'FORM',(A0)
	beq.w	LoadIFFSong
	CMP.L	#'PP20',(A0)
	BEQ.W	PowerPacked
	CMP.L	#'XPKF',(A0)
	BEQ.B	xpkloadsong
	BRA.B	ReadSongAfterCheck		;load rest of song

xpkloadsong:
	bsr.w	xpkload
	CALL	ExitFromDir

ReadSongAfterCheck:
	CALL	DoClearSong
	CALL	DoClearSamples
	move.l	DOSBase,a6
	move.l	FileHandle,d1
	moveq	#0,d2
	moveq	#-1,d3
	bsr.w	ModSeekRead
	move.l	FileHandle,d1
	move.l	mt_songdataptr,d2
	move.l	#sd_patterndata,d3	;1084
	bsr.w	ModReadRead
	;bne	FileLoadError
	move.l	mt_songdataptr,a0

	lea	sd_pattpos(a0),a0
	moveq	#0,d0
	move.b	-1(a0),d0
	moveq	#0,d3
chksoanf:
	cmp.b	(a0)+,d3
	bhi.s	chksoend
	move.b	-1(A0),d3
chksoend:
	dbra	d0,chksoanf
	addq.w	#1,d3
	;mulu	 #$0400,d3
	LSL.L	#8,D3
	LSL.L	#2,D3			;orgmulu
	move.l	FileHandle,d1
	move.l	mt_songdataptr,d2
	add.l	#sd_patterndata,d2
	move.l	DOSBase,a6
	BSR.W	ModReadRead

	move.l	FileHandle,d1
	beq.s	lososkip
	move.l	DOSBase,a6
	CALLSYS	Close
	clr.l	FileHandle
	clr.l	LoadingInProgress
	clr.w	xpkflag

lososkip:
	move.l	mt_songdataptr,a0
	cmp.l	#'PAKK',(A0)
	beq.s	DepackSong
	CMP.L	#'PACK',(A0)
	BNE.S	lososskip5

DepackSong:

	MOVE.L	4(A0),CrunchedSongLength
	MOVE.L	8(A0),RealSongLength
	MOVE.L	mt_songdataptr,D0
	ADD.L	#$0001143C,D0		;70716
	SUB.L	RealSongLength(PC),D0
	MOVE.L	D0,EndOfSongPtr
	LEA	DecrunchingText,A0
	CALL	ShowStatusText
	CALL	Decruncher
	CALL	ShowAllRight

lososskip5:
	MOVE.L	mt_songdataptr,A0
	CMP.L	#'M!K!',sd_mahokakt(A0)
	BNE.W	try64pattsong

	TST.W	patt100memflag
	BNE.W	mt_loadnormsong
	TST.B	patt100flag
	BNE.W	mt_loadnormsong		;100pattmode is on

;alloc pattern stuff for 100patterns

allocmeto100:
	move.l	FileHandle,d1
	move.l	DOSBase,a6
	CALLSYS	Close
	clr.l	LoadingInProgress
	clr.w	xpkflag
	BSR.W	DoClearSong
	BSR.W	DoClearSamples

	MOVE.L	mt_songdataptr,D1
	BEQ.S	tryallocnoemp
	MOVE.L	D1,A1
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
tryallocnoemp:
	move.b	#1,patt100flag			;set 100patternmode
no8mode73:

	chn8test
	BNE.S	no8mode74

;8channels

	MOVE.L	#sd_patterndata+100*1024*2,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
	bra.s	mall100rd

;4channels
no8mode74:
	MOVE.L	#sd_patterndata+100*1024,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
mall100rd:
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,mt_songdataptr
	BNE.S	mall100rdok
	GOTO	OutOfMemErr

mall100rdok:
	BRA.W	LoadSong			; Loadsong new if allocated unpacked 100patt

;*********************************
;* normal 64pattern song loading *
;*********************************

try64pattsong:

	MOVE.L	mt_songdataptr,A0
	CMP.L	#'M.K.',sd_mahokakt(A0)
	BEQ.S	mt_loadnormsong

	BSR.W   LoadMahoneyAndKaktus
	CMP.W   #2,D0

	BEQ.W	CantOpenFile			; unknown format

;**********************************
;* loading after M.K. and M!K!    *
;**********************************

mt_loadnormsong:
	LEA	Loadingsong.MSG,A0
	BSR.W	ShowStatusText
	BSR.W	CheckAbort
	BEQ.W	EndSongLoad
	BTST	#4,PackMode
	BEQ.S	NoSongAutoExit
	CALL	ExitFromDir

	cmp.w	#1,CurrScreen
	bne.b	NoSongAutoExit
	lea	fo_comments,a0
	tst.l	(a0)
	bne.s	showcmntsso
	bra.s	NoSongAutoExit
showcmntsso:
	BSR.W	entercomment

NoSongAutoExit:
	CLR.L	PatternNumber
	CLR.L	playpos
	BSR.W	RedrawPattern
	CLR.W	ScrPattPos
	BSR.W	SetScrPatternPos
	BSR.W	SortDisks
	LEA	SampleSortList,A0
	MOVE.W	#MaxInsNum-1,D0
losoloop3:
	BTST	#5,PackMode
	BNE.B	EndSongLoading
	BSR.W	CheckAbort
	BEQ.S	EndSongLoad
	MOVE.W	InsNum,TuneUp
	CALL	DoShowFreeMem
	MOVE.L	(A0)+,D1
	MOVE.W	D1,InsNum
	MOVEM.L D0/D1/A0,-(SP)
	BSR.W	LoadPreset
	CALL	ShowSampleInfo
	MOVEM.L (SP)+,D0/D1/A0
	DBRA	D0,losoloop3
EndSongLoad:
	MOVE.W	#1,InsNum
	MOVE.L	#6,mt_speed
	CLR.W	LoadingInProgress
	BSR.W	ShowAllRight
	CALL	SetNormalPtrCol
	CALL	DoShowFreeMem
	BSR.W	CheckInstrLengths
	CALL	ShowSampleInfo
noxpksong:

	GOTO	RedrawSample

EndSongLoading:
	BSR.W	DoClearSamples			; fix, if nosample-load than memory free for samples
	bra.s	EndSongLoad
;----------------

LoadIFFSong:
	MOVE.L	DOSBase,a6
	MOVE.L	FileHandle,D1
	MOVEQ	#$8,D2				; offset
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead			; seek read
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				; buffer in d2
	MOVEQ	#4,D3				; length
	BSR.W	ModReadRead			; read
	CMP.L	#4,D0
	BNE.W	FileLoadError			; file type mismatch
	LEA	fourbytebuf,A0			; buffer
	CMP.L	#'MODL',(A0)
	beq.s	itsnewsong
	cmp.l	#'8SVX',(A0)
	beq.w	ItsSample
	BRA.W	ReadSongAfterCheck

itsnewsong:
	move.l	#0,iffscount
	lea	modform.txt,a0
	BSR.W	ShowStatusText
	CALL	DoClearSong
	CALL	DoClearSamples


lsongsearchloop:

	MOVE.L	DOSBase,a6
	MOVE.L	FileHandle,D1

	move.l	iffscount,d2

	MOVEQ	#-1,D3
	BSR.W	ModSeekRead			;seek read

	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				;buffer in d2
	MOVEQ	#4,D3				;length
	BSR.W	ModReadRead			;read
	CMP.L	#4,D0
	BNE.W	FileLoadError			;file type mismatch
	addq.l	#$00000001,iffscount
	LEA	fourbytebuf,A0			;buffer
	cmp.l	#'VERS',(A0)
	beq.w	so_setversion

	cmp.l	#'INFO',(A0)
	beq.w	so_setmodparams
	cmp.l	#'CMNT',(A0)
	beq.W	so_setcomments

	CMP.L	#'PTDT',(A0)
	beq.s	so_itsiffstart

	bra.s	lsongsearchloop


so_itsiffstart:
	cmp.w	#64,fo_patterns		;more than 64 patts?
	bcs.w	so_itsno100patt
	tst.w	patt100memflag		;already allocated?
	bne.w	so_itsno100patt 	;yeah load
	TST.B	patt100flag
	bne.w	so_itsno100patt 	;in prefs

;reallocate for 100pat
so_iff100alloc:
	move.l	mt_songdataptr,d1
	beq.s	so_iff100alloc2
	move.l	d1,a1
	move.l	PatternMemAllocSize,d0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem


so_iff100alloc2:
	EOR.B	#1,patt100flag

	chn8test
	BNE.S	no8mode77

	MOVE.L	#sd_patterndata+100*1024*2,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
	bra.s	so_iff100alloc3

;4channels
no8mode77:
	MOVE.L	#sd_patterndata+100*1024,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength

so_iff100alloc3:
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,mt_songdataptr
	BNE.S	so_iff100alloc4
	GOTO	OutOfMemErr
	;MOVE.W	#1,patt100memflag
	;BRA.W	so_iff100alloc

;sucessful allocated, close file and reload
so_iff100alloc4:
	MOVE.L	FileHandle,D1
	MOVE.L	DOSBase,A6
	CALLSYS	Close
	BRA.W	so_allcm100mod5


;4chan iff song
so_itsno100patt:

	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,D2				;4 offset, spring over PTRN
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead
	bsr.w	lmnorml 			;read normal mod


so_SPrfroIFFM:

	move.w	fo_patterns,HighPattNum
	move.w	fo_volume,TremoloByte
	move.w	fo_dspeed,RealTempo
	;move.w fo_dspeed,BPMTempo

	bchg	#5,fo_packetf
	move.w	fo_packetf,Packetfield

	;cmp.w	#22,Volume
	;bcs.s	snewvol 			; old config, volume over 22?
	;move.w #00,Volume			; max volume

so_snewvol:
	CALL	BlitManyThings
	BSR.W	RfshChanTog 			;
	CALL	SetTempo
	BSR.W	NoSongAutoExit
	BTST	#4,PackMode			;autoexit?
	beq.s	so_skipiffshow
	GOTO	DctMainScr1_7

so_skipiffshow:
	MOVEQ	#15,D7
	GOTO	DoShowFreeMem

;vers hunk
so_setversion:
	LEA	verhunk.txt,A0
	BSR.W	ShowStatusText


	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,d2
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead
	MOVE.L	FileHandle,D1
	lea	fo_modver,a0			;buffer
	move.l	a0,d2
	moveq	#6+4+2,d3			;length
	bsr.w	ModReadRead			;get real pt version
	BRA.W	lsongsearchloop 		;get next chunk


; info hunk
so_setmodparams:
	LEA	infohunk.txt,A0
	BSR.W	ShowStatusText


	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,d2				;skip infochunk+length
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead


;songname
	MOVE.L	FileHandle,D1
	lea	fo_songname,a0			;buffer
	move.l	a0,d2
	moveq	#64,d3				;length
	bsr.w	ModReadRead			;get real songname


	BRA.W	lsongsearchloop ;tom 4.0



	CLR.W	checkfornew
	chn8test
	BNE.S	iffchk4
	MOVE.W	#1,checkfornew
iffchk4:
	BTST	#5,fo_packetf
	BEQ.S	iffchk5
	CMP.W	#1,checkfornew
	BEQ.W	lsongsearchloop 		;get next chunk
	bra.s	iffchk6
iffchk5:
	TST.W	checkfornew
	BEQ.W	lsongsearchloop 		;get next chunk
iffchk6:
	move.w	fo_packetf,Packetfield
	move.w	#1,newalloc
	MOVEM.L D0-A6,-(SP)
	CALL	showmode
	MOVEM.L (SP)+,D0-A6
	BRA.W	so_allcm100mod5


;cmnt chunk
so_setcomments:
	LEA	cmnthunk.txt,A0
	BSR.W	ShowStatusText


	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$3,d2				;skip cmntchunk+length
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead

	move.l	FileHandle,d1
	lea	lengthbit,a0			;read chunklength of CMNT
	move.l	a0,d2
	moveq	#4,d3
	bsr.w	ModReadRead



	;songname
	MOVE.L	FileHandle,D1
	lea	fo_author,a0			;buffer
	move.l	a0,d2
	moveq	#32,d3				;length
	LEA	modhunk.txt,A0
	BSR.W	ShowStatusText
	bsr.w	ModReadRead			;get real songname

	move.l	FileHandle,d1
	lea	fo_comments,a0
	move.l	a0,d2
	move.l	lengthbit,d3
	sub.l	#32,d3
	bsr.w	ModReadRead			;comments

	BRA.W	lsongsearchloop 		;get next chunk

;------------
SortDisks:
	MOVEM.L D0-D4/A0/A1,-(SP)
	MOVE.L	mt_songdataptr,A0
	LEA	$0017(A0),A0
	LEA	SampleSortList,A1
	MOVEQ	#1,D0
losoloop4:
	MOVE.B	(A0)+,(A1)+	;ST-(0)1
	MOVE.B	(A0),(A1)+
	MOVE.W	D0,(A1)+	;insnum
	LEA	$001D(A0),A0
	ADDQ.L	#1,D0
	CMP.L	#$00000020,D0
	BCS.S	losoloop4
losoloop5:
	CLR.W	MoreInstrFlag
	LEA	SampleSortList,A0
	MOVEQ	#$1D,D2
losoloop6:
	MOVE.W	(A0),D0
	MOVE.W	4(A0),D1
	CMP.W	D0,D1
	BCC.S	loso2_2
	MOVE.W	#1,MoreInstrFlag
	MOVE.L	(A0),D3
	MOVE.L	4(A0),D4
	MOVE.L	D4,(A0)
	MOVE.L	D3,4(A0)
loso2_2:
	ADDQ.L	#4,A0
	DBRA	D2,losoloop6
	TST.W	MoreInstrFlag
	BNE.S	losoloop5
	LEA	SampleSortList,A0
	MOVEQ	#$1E,D0
losoloop7:
	CLR.W	(A0)
	ADDQ.L	#4,A0
	DBRA	D0,losoloop7
	MOVEM.L (SP)+,D0-D4/A0/A1
	RTS

;*******************************

CheckInstrLengths:
	MOVE.L	mt_songdataptr,A0
	ADD.L	#$00000014,A0
	MOVEQ	#$1E,D1
xilloop:
	MOVE.W	$001A(A0),D0
	ADD.W	$001C(A0),D0
	CMP.W	$0016(A0),D0
	BLS.S	xilskip
	MOVE.W	$001A(A0),D0
	LSR.W	#1,D0
	MOVE.W	D0,$001A(A0)
xilskip:
	ADD.L	#$0000001E,A0
	DBRA	D1,xilloop
	RTS

CheckAbort:
	checkrmb
	BEQ.S	CheckAbort_2
	RTS

CheckAbort_2:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	Abortloading.MSG,A0
	CALL	AreYouSure
	BNE.S	chabno
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D7
	RTS

chabno:
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#-1,D7
	RTS

;******************************
StopIt:
	BSR.S	DoStopIt

TurnOffVoices:
	MOVEM.L D0/A0/A1,-(SP)
	MOVE.W	#$0780,INTENA
	MOVE.W	#15,DMACON
	CLR.W	AUD0VOL
	CLR.W	AUD1VOL
	CLR.W	AUD2VOL
	CLR.W	AUD3VOL
	CLR.B	RawKeyCode
	LEA	audchan1temp,A0

	;MOVEQ	#3,D0
	move	numchans,D0
	subq	#1,d0


.loop:	CLR.B	$13(A0)
	CLR.L	$40(A0)
	CLR.B	$36(A0)
	CLR.B	$37(A0)
	LEA	$58(A0),A0
	DBRA	D0,.loop

	LEA	ScopeInfo,A0
	LEA	BlankSample,A1
	MOVE.L	A1,(A0)
	MOVE.L	A1,$14(A0)
	MOVE.L	A1,$28(A0)
	MOVE.L	A1,$3C(A0)
	MOVEM.L (SP)+,D0/A0/A1
	RTS

;******************************

DoStopIt:
	CALL	SetNormalPtrCol
	CLR.L	EditMode
	CLR.L	RunMode
	CLR.B	mt_pattdeltime
	CLR.B	mt_pattdeltime2
	BRA.W	RestoreEffects2


;******************************

UsePreset:
	CALL	StorePtrCol
	TST.L	PLSTmem
	BEQ.B	upend
	TST.W	InsNum
	BEQ.B	upend
	CLR.B	RawKeyCode
	MOVE.W	CurrentPreset,D0
	SUBQ.W	#1,D0
	MULU.W	#$001E,D0
	MOVE.L	PLSTmem,A0
	ADD.L	D0,A0
	MOVE.W	InsNum,D0
	MULU.W	#$001E,D0
	MOVE.L	mt_songdataptr,A1
	LEA	-10(A1,D0.W),A1
	MOVE.L	A1,A2
	MOVEQ	#$1D,D0
uploop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,uploop
	MOVE.L	(A2),D0
	AND.L	#$DFDFFFFF,D0
	CMP.L	#$53540000,D0		;ST__
	BNE.B	upok
	CLR.W	(A2)
	CLR.L	$0016(A2)
	MOVE.L	#1,$001A(A2)
upok:
	CALL	LoadPreset		;load the sample
upend:
	BSR.W	ShowSampleInfo
	CALL	RedrawPLST
	GOTO	RestorePtrCol


;*******************************

DctMainScr1_7:
	MOVE.W	OptScrFlag(PC),D0
	CMP.W	#1,D0
	BEQ.B	EditOptions
	CMP.W	#2,D0
	BEQ.W	SampleOptions
	CMP.W	#3,D0
	BEQ.W	ChordEditor
	CMP.W	#4,D0
	BEQ.W	FilterEditor
	CMP.W	#5,D0
	BEQ.W	Opt5RotChk
	CMP.W	#6,D0
	BEQ.W	Reserved2
	CMP.W	#7,D0
	BEQ.W	OptionCommands7
	CMP.W	#8,d0
	BEQ.W	entercomment
	RTS



CheckOpt1_4Gadg:
	MOVE.W	OptScrFlag(PC),D0
	CMP.W	#1,D0
	BEQ.S	CheckOpt1Gadg
	CMP.W	#2,D0
	BEQ.W	CheckOpt2Gadg
	CMP.W	#3,D0
	BEQ.W	CheckOpt3Gadg
	CMP.W	#4,D0
	BEQ.W	CheckOpt4Gadg
	cmp.w	#5,d0
	beq.w	CheckOpt5Gadg
	cmp.w	#6,d0
	beq.w	CheckOpt6Gadg
	cmp.w	#7,D0
	beq.w	CheckOpt7Gadg
	cmp.w	#8,d0
	beq.w	CheckOpt8Gadg
	RTS

EditOptions:
	MOVEQ	#1,D0		;optionflag
	move.w	#1,OptScrFlag
	lea	Opt1Data,a0
	BSR.W	OptDecrunch
	BSR.W	lbC00FA70
	BSR.W	lbC00FBF6
	BSR.W	lbC00FCB0	;showmultimode
	BSR.W	ssinsmodq
	BSR.W	ssinsmodq2	;showsplitmode
	BSR.W	lbC00FC6A
	BSR.W	ShowMultiChans
	BSR.W	ShowMRecMode
	BSR.W	lbC00D6E0
	BSR.W	lbC009198
	RTS

CheckOpt1Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt1GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	CheckOpt_1
	RTS

CheckOpt_1:
	CMP.W	#1,D2
	BEQ.W	lbC00FBC2
	CMP.W	#2,D2
	BEQ.W	lbC00FB9E
	CMP.W	#3,D2
	BEQ.W	lbC00FBAE
	CMP.W	#7,D2
	BEQ.W	lbC00FC12
	CMP.W	#8,D2
	BEQ.S	EnterMultiTracks
	CMP.W	#9,D2
	BEQ.W	lbC009190
	CMP.W	#11,D2
	BEQ.W	SwitchRecMode
	CMP.W	#12,D2
	BEQ.W	lbC00FA62
	CMP.W	#13,D2
	BEQ.W	ToggleMultiMode
	CMP.W	#14,D2
	BEQ.S	lbC00D6DA
	CMP.W	#15,D2
	BEQ.W	ToggleInsertMode
	cmp.w	#16,d2
	beq.w	ToggleSplitMode
	RTS

lbC00D6DA:
	MOVE.B	EditMovRightFlag,D0
	NOT.B	D0
	MOVE.B	D0,EditMovRightFlag
lbC00D6E0:
	MOVEQ	#5,D3
	MOVE.W	#$0246,D0
	MOVEQ	#$5B,D1
	LEA	Right.MSG(PC),A0
	TST.B	EditMovRightFlag
	BNE.S	lbC00D6F8
	LEA	Down.MSG(PC),A0
lbC00D6F8:
	GOTO	Wr_Message


;*******************************
;* enter multimode channels    *
;* in optionscreen 1           *
;* (CTRL-M trackfolge)         *
;*******************************

EnterMultiTracks:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.W	#1,GetLineFlag
	MOVE.W	MouseX2,D0
	SUB.W	#$0198,D0
	BPL.S	.doit
	MOVEQ	#0,D0

.doit:	LSR.W	#4,D0
	CMP.W	numchans,D0
	BMI.S	.chn4
	move.w	numchans,d0
	subq	#1,d0
.chn4:	MOVE.B	D0,MulChanCounter

.loop:	MOVEQ	#0,D1
	MOVE.B	MulChanCounter,D1
	LSL.W	#4,D1			;nextpos4
	chn8test
	bne.s	.chn4_2
	divu.w	#2,d1			;nextpos8
.chn4_2:
	MOVE.W	#$01A0,LineCurX
	MOVE.W	#$0060,LineCurY
	ADD.W	D1,LineCurX
	BSR.W	UpdateLineCurPos
	CALL	GetHexKey
	CMP.B	#0,D1
	BEQ.S	.l1
	CMP.w	numchans,D1		;maxpatt insertion
	BHI.S	.l2
	MOVE.B	MulChanCounter,D0
	move.w	numchans,d4
	subq	#1,d4
	AND.W	d4,D0
	LEA	MultiModeNext,A1
	MOVE.B	D1,0(A1,D0.W)
	BSR.S	ShowMultiChans
	MOVEQ	#1,D0
.l1:	TST.B	D0
	BEQ.S	.l2
	ADD.B	D0,MulChanCounter
	move.w	numchans,d4
	subq	#1,d4
	AND.B	d4,MulChanCounter
	BSR.W	Wait_4000
	BRA.W	.loop			;loop upto esc pressed

.l2:	CALL	RestorePtrCol
	CLR.W	GetLineFlag
	MOVE.W	#$FFF0,LineCurX
	MOVE.W	#0,LineCurY
	BRA.W	UpdateLineCurPos

;---
ShowMultiChans:
	chn8test
	bne.w	.chn4

	MOVE.W	#$019C,D0
	MOVEQ	#$5B,D1
	MOVE.B	MultiModeNext,D3
	CALL	ShowHexByte
	ADDQ.W	#$008,D0
	MOVE.B	MultiModeNext+1,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+2,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+3,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+4,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+5,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+6,D3
	CALL	ShowHexByte
	ADDQ.W	#$08,D0
	MOVE.B	MultiModeNext+7,D3
	GOTO	ShowHexByte

.chn4:	MOVE.W	#$019C,D0
	MOVEQ	#$5B,D1
	MOVE.B	MultiModeNext,D3
	CALL	ShowHexByte
	ADD.W	#$0010,D0
	MOVE.B	MultiModeNext+1,D3
	CALL	ShowHexByte
	ADD.W	#$0010,D0
	MOVE.B	MultiModeNext+2,D3
	CALL	ShowHexByte
	ADD.W	#$0010,D0
	MOVE.B	MultiModeNext+3,D3
	GOTO	ShowHexByte

MulChanCounter:		dc.w	0
Down.MSG:		dc.b	'Down ',0
Right.MSG:		dc.b	'Right',0
EditMovRightFlag:	dc.b	0,0

;***********************************
;* option 2 sampleroptions         *
;***********************************

SampleOptions:
	MOVEQ	#2,D0		;optionflag
	move.w	#2,OptScrFlag
	lea	Opt2Data,a0
	BSR.W	OptDecrunch
	BSR.W	lbC00F9F8
	BSR.W	lbC00FA46
	BSR.W	ShowVol
	BSR.W	sam_sposupdate
	BSR.W	ShowMod
	BSR.W	HalfClipMsg
	BSR.W	sam_togmodeshow
	RTS

CheckOpt2Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt2GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	.l0
	RTS

.l0:	MOVEM.L D2,-(SP)
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVE.L	mt_songdataptr,A5
	LEA	-10(A5),A5
	MOVE.W	InsNum,D0
	BNE.S	.l1
	MOVE.W	LastInsNum,D0
.l1:
	MULU	#30,D0
	ADD.L	D0,A5
	MOVEM.L (SP)+,D2
	CMP.W	#1,D2
	BEQ.W	sam_delete
	CMP.W	#2,D2
	BEQ.W	sam_exchange
	CMP.W	#5,D2
	BEQ.W	KillSample
	CMP.W	#6,D2
	BEQ.W	sam_exchg
	CMP.W	#13,D2
	BEQ.W	Mix
	CMP.W	#14,D2
	BEQ.W	Boost
	CMP.W	#15,D2
	BEQ.W	XFade
	CMP.W	#$0010,D2
	BEQ.W	UpSamSample
	CMP.W	#$0011,D2
	BEQ.W	Echo
	CMP.W	#$0012,D2
	BEQ.W	Filter
	CMP.W	#$0013,D2
	BEQ.W	BackwardsSample
	CMP.W	#$0014,D2
	BEQ.W	DownSamSample
	CMP.W	#3,D2
	BEQ.W	lbC00F9C4
	CMP.W	#7,D2
	BEQ.W	lbC00F9C4
	CMP.W	#8,D2
	BEQ.W	lbC00F9E4
	CMP.W	#9,D2
	BEQ.W	lbC00F9CE
	CMP.W	#4,D2
	BEQ.W	lbC00FA12
	CMP.W	#10,D2
	BEQ.W	lbC00FA12
	CMP.W	#11,D2
	BEQ.W	lbC00FA32
	CMP.W	#12,D2
	BEQ.W	lbC00FA1C
	CMP.W	#$0015,D2
	BEQ.W	sam_setpos
	CMP.W	#$0016,D2
	BEQ.W	sam_setpos
	CMP.W	#$0017,D2
	BEQ.W	sam_setposup
	CMP.W	#$0018,D2
	BEQ.W	sam_setposdown
	CMP.W	#$0019,D2
	BEQ.W	ModulateSample
	CMP.W	#$001A,D2
	BEQ.W	SetModSpeed
	CMP.W	#$001B,D2
	BEQ.W	semoup
	CMP.W	#$001C,D2
	BEQ.W	DrwFiCuSub
	CMP.W	#$0020,D2
	BEQ.W	DoChangeVol
	CMP.W	#$0021,D2
	BEQ.W	ChangeVolume
	CMP.W	#$0022,D2
	BEQ.W	shvoup
	CMP.W	#$0023,D2
	BEQ.W	SampleVol1
	CMP.W	#$001D,D2
	BEQ.W	CutBeg
	CMP.W	#$001E,D2
	BEQ.W	FadeDown
	CMP.W	#$001F,D2
	BEQ.W	FadeUp
	CMP.W	#$0024,D2
	BEQ.W	sam_halfcliptoggle
	CMP.W	#$0025,D2
	BEQ.W	sam_togmode
	RTS

ChordEditor:
	MOVEQ	#3,D0		;optionflag
	move.w	#3,OptScrFlag
	lea	Opt3Data,a0
	BSR.W	OptDecrunch
	BSR.W	mt_showsampnum1
	BSR.W	lbC00E614
	BSR.W	lbC00E664
	BSR.W	lbC00E750
	BSR.W	lbC00E54E
	RTS

CheckOpt3Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt3GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	lbC00D8E8
	RTS

lbC00D8E8:
	CMP.W	#1,D2
	BEQ.W	mt_showsampnum
	CMP.W	#2,D2
	BEQ.W	mt_emaxsam
	CMP.W	#3,D2
	BEQ.W	mt_submaxsam
	CMP.W	#4,D2
	BEQ.W	O3_ToSampleGad
	CMP.W	#5,D2
	BEQ.W	lbC00E5D2
	CMP.W	#6,D2
	BEQ.W	lbC00E5F0
	CMP.W	#7,D2
	BEQ.W	lbC00E664
	CMP.W	#8,D2
	BEQ.W	lbC00E62A
	CMP.W	#9,D2
	BEQ.W	lbC00E648
	CMP.W	#10,D2
	BEQ.W	lbC00E876
	CMP.W	#11,D2
	BEQ.W	lbC00E548
	CMP.W	#$0014,D2
	BEQ.W	lin_v1
	CMP.W	#$0015,D2
	BEQ.W	lin_v2
	CMP.W	#$0016,D2
	BEQ.W	lin_v3
	CMP.W	#$0017,D2
	BEQ.W	lin_v5
	CMP.W	#$0018,D2
	BEQ.W	lin_v7
	CMP.W	#$0019,D2
	BEQ.W	lin_v9
	CMP.W	#$001A,D2
	BEQ.W	lin_v11
	RTS

FilterEditor:
	MOVEQ	#4,D0		;optionflag
	move.w	#4,OptScrFlag
	lea	Opt4Data,a0
	BSR.W	OptDecrunch
	BSR.W	lbC00DB62
	BSR.W	mt_selectfilterl
	RTS

CheckOpt4Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt4GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	CheckOpt4Gadg2
	RTS

CheckOpt4Gadg2:
	CMP.W	#1,D2
	BEQ.W	CurveArea
	CMP.W	#2,D2
	BEQ.W	lbC00DB5C
	CMP.W	#3,D2
	BEQ.W	mt_selectfilter
	CMP.W	#4,D2
	BEQ.W	FilterEDDoIt
	MOVE.L	fi_memad(PC),A0
	TST.L	(A0)
	BEQ.S	lbC00D9F4
	LEA	4(A0),A0
	MOVE.W	#$01AB,D0
	MOVEQ	#$66,D1
	CMP.W	#11,D2
	BEQ.W	lbC00DB04
	CMP.W	#12,D2
	BEQ.W	lbC00DB18
	CMP.W	#13,D2
	BEQ.W	lbC00DB2A
lbC00D9F4:
	MOVE.L	fi_memad(PC),A0
	TST.L	$0010(A0)
	BEQ.S	lbC00DA20
	LEA	$0014(A0),A0
	MOVE.W	#$01AB,D0
	MOVEQ	#$71,D1
	CMP.W	#15,D2
	BEQ.W	lbC00DB04
	CMP.W	#$0010,D2
	BEQ.W	lbC00DB18
	CMP.W	#$0011,D2
	BEQ.W	lbC00DB2A
lbC00DA20:
	MOVE.L	fi_memad(PC),A0
	TST.L	$0020(A0)
	BEQ.S	lbC00DA4C
	LEA	$0024(A0),A0
	MOVE.W	#$0237,D0
	MOVEQ	#$66,D1
	CMP.W	#$0013,D2
	BEQ.W	lbC00DB04
	CMP.W	#$0014,D2
	BEQ.W	lbC00DB18
	CMP.W	#$0015,D2
	BEQ.W	lbC00DB2A
lbC00DA4C:
	RTS

;********************************
;* option 7 window              *
;********************************

OptionCommands7:

	MOVEQ	#7,D0				; optionflag
	move.w	#7,OptScrFlag
	lea	Opt7Data,a0
	BSR.W	OptDecrunch
	BSR.W	ShowBlockMode
	RTS

CheckOpt7Gadg:

	MOVEM.W (MouseX2),D0/D1
	LEA	Opt7GadData,A0
	CALL	ConvMousTabl

TestReally:
	TST.W	D2
	BNE.S	CheckOpt_7
	RTS

CheckOpt_7:
	CMP.W	#1,D2
	BEQ.W	Opt7Change

	CMP.L	#$70617470,RunMode
	BNE.S	CheckOpt7NoRun
	RTS

CheckOpt7NoRun:
	MOVEM.L D2,-(SP)
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	MOVEM.L (SP)+,D2
	CMP.W	#$5,D2
	BEQ.W	Opt7Clear
	CMP.W	#$8,D2
	BEQ.W	Opt7Flip
	CMP.W	#$A,D2
	BEQ.W	Opt7OctUp
	CMP.W	#$C,D2
	BEQ.W	Opt7NoteUp
	CMP.W	#$E,D2
	BEQ.W	Opt7ScrollUp
	CMP.W	#$10,D2
	BEQ.W	Opt7RotateUp
	CMP.W	#$B,D2
	BEQ.W	Opt7OctDown
	CMP.W	#$D,D2
	BEQ.W	Opt7NoteDown
	CMP.W	#$F,D2
	BEQ.W	Opt7ScrollDown
	CMP.W	#$11,D2
	BEQ.W	Opt7RotateDown

	MOVE.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D0
	LSL.L	#8,D0
	LSL.L	#2,D0
	chn8test
	BNE.S	no8mode25
	LSL.L	#1,D0
no8mode25:
	ADD.L	D0,A0
	CMP.W	#1,mt_TrackPattGad	;1=Pattern
	BNE.S	Check4Track

	CMP.W	#$2,D2
	BEQ.W	xCutPattern
	CMP.W	#$3,D2
	BEQ.W	xCopyPattern
	CMP.W	#$4,D2
	BEQ.W	xPastePattern
	CMP.W	#$6,D2
	BEQ.W	xInsNotePattern
	CMP.W	#$7,D2
	BEQ.W	xDelNotePattern
Check4Track:
	MOVEQ	#0,D0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0
	AND.L	#7,D0			;7+1chans
	chn8test		;4.0
	beq.b	no8ztd
	and.l	#3,d0

no8ztd:
	LSL.L	#2,D0		;2
	ADD.L	D0,A0
	TST.W	mt_TrackPattGad		;0=Track

	BNE.S	Check4Command
	CMP.W	#$2,D2
	BEQ.W	xCutTrack
	CMP.W	#$3,D2
	BEQ.W	xCopyTrack
	CMP.W	#$4,D2
	BEQ.W	xPasteTrack
	CMP.W	#$6,D2
	BEQ.W	xInsNoteTrack
	CMP.W	#$7,D2
	BEQ.W	xDelNoteTrack
Check4Command:
	CMP.W	#2,mt_TrackPattGad	;2=Commands
	BNE.S	Check4Block
	CMP.W	#$2,D2
	BEQ.B	xCutCmds
	CMP.W	#$3,D2
	BEQ.B	xCopyCmds
	CMP.W	#$4,D2
	BEQ.B	xPasteCmds
	CMP.W	#$6,D2
	BEQ.B	xInsCMDTrack
	CMP.W	#$7,D2
	BEQ.B	xDelCMDTrack
Check4Block:
	CMP.W	#3,mt_TrackPattGad	;3=Block
	BNE.S	Check4Nope
	CMP.W	#$2,D2
	BEQ.W	xCutBlock
	CMP.W	#$3,D2
	BEQ.W	xCopyBlock
	CMP.W	#$4,D2
	BEQ.W	xPasteBlock
Check4Nope:
	RTS

xCutPattern	GOTO	CutPattern
xCopyPattern	GOTO	CopyPattern
xPastePattern	GOTO	PastePattern
xInsNotePattern GOTO	InsNotePattern
xDelNotePattern GOTO	DelNotePattern
xCutTrack	GOTO	CutTrack
xCopyTrack	GOTO	CopyTrack
xPasteTrack	GOTO	PasteTrack
xInsNoteTrack	GOTO	InsNoteTrack
xDelNoteTrack	GOTO	DelNoteTrack
xCutCmds	GOTO	CutCmds
xCopyCmds	GOTO	CopyCmds
xPasteCmds	GOTO	PasteCmds
xInsCMDTrack	GOTO	InsCMDTrack
xDelCMDTrack	GOTO	DelCMDTrack
xabout: 	GOTO	remember
xdiskopt:	GOTO	ShowDirScreen

;***********************************

Reserved2:

	MOVEQ	#6,D0		;optionflag
	move.w	#6,OptScrFlag
	lea	Opt6Data,a0
	BSR.W	OptDecrunch
	BSR.W	ShowMixPattern
	RTS

CheckOpt6Gadg:

	MOVEM.W (MouseX2),D0/D1
	LEA	Opt6GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	CheckOpt_6
	RTS

CheckOpt_6:

	cmp.w	#1,d2
	beq.W	hitmixpattern
	cmp.w	#2,d2
	beq.w	hitm_start
	cmp.w	#3,d2
	beq.W	hitm_end
	cmp.w	#4,d2
	beq.W	hitm_to
	cmp.w	#7,d2
	beq.w	hitpitch
	cmp.w	#8,d2
	beq.w	hitmcia
	cmp.w	#$0B,d2
	beq.w	Boost
	cmp.w	#$0A,d2
	beq.w	Filter
	;cmp.w	#$0D,d2
	;beq	BackwardsSample
	;cmp.w	#$0E,d2
	;beq	MaximizeSample
	;cmp.w	#$0F,d2
	;beq	NormalizeSample
	cmp.w	#$D,d2
	beq.w	grabmix
	cmp.w	#$E,d2
	beq.w	grabpatt
	cmp.w	#$F,d2
	beq.w	grabstart
	cmp.w	#9,d2
	beq.w	grabend
	cmp.w	#6,d2
	beq.w	grabsample
	cmp.w	#5,d2
	beq.W	grabcia

	cmp.w	#$10,d2
	beq.w	sixnoteup
	cmp.w	#$11,d2
	beq.w	sixnotedo
	cmp.w	#$12,d2
	beq.w	sixpattup
	cmp.w	#$13,d2
	beq.w	sixpattdo
	cmp.w	#$14,d2
	beq.w	sixstartup
	cmp.w	#$15,d2
	beq.w	sixstartdo
	cmp.w	#$16,d2
	beq.w	sixendup
	cmp.w	#$17,d2
	beq.w	sixenddo
	cmp.w	#$18,d2
	beq.w	sixsamup
	cmp.w	#$19,d2
	beq.w	sixsamdo
	cmp.w	#$1a,d2
	beq.w	sixciaup
	cmp.w	#$1b,d2
	beq.w	sixciado
	cmp.w	#$1c,d2
	beq.w	mixit
	RTS

;********************************************
;* the mod2smp interface routines           *
;********************************************

mixpattern:	dc.w	0
startmix:	dc.w	0
endmix: 	dc.w	63
mixsample:	dc.w	31
mixcia		dc.w	125

grabpatt:
	move.l	mt_songdataptr,a0
	lea	sd_pattpos(a0),a0
	add.l	playpos,a0
	move.b	#0,mixpattern			; first byte empty
	move.b	(a0),mixpattern+1
	bra.w	ShowMixPattern

grabstart:
	move.w	ScrPattPos,d0
	move.w	endmix,d1
	cmp.w	#MaxPattPos,d0
	blt.s	grabstart3
	move.w	#MaxPattPos-1,d0
grabstart3:
	cmp.w	d1,d0
	blt.s	grabstart2
	move.w	d0,d1
	addq.w	#1,d1
grabstart2:
	move.w	d0,startmix
	move.w	d1,endmix
	bra.s	ShowMixPattern



grabend:
	move.w	ScrPattPos,d0
	move.w	startmix,d1
	cmp.w	#0,d0
	bgt.s	grabend3
	move.w	#1,d0
grabend3:
	cmp.w	d0,d1
	blt.s	grabend2
	move.w	d0,d1
	subq.w	#1,d1
grabend2:
	move.w	d0,endmix
	move.w	d1,startmix
	bra.s	ShowMixPattern

grabsample:
	move.w	InsNum,mixsample
	bra.s	ShowMixPattern


grabcia:
	move.w	RealTempo,mixcia
	BRA.S	ShowMixPattern

grabmix:
	move.w	InsNum,mixsample
	move.l	mt_songdataptr,a0
	lea	sd_pattpos(a0),a0
	add.l	playpos,a0
	move.b	#0,mixpattern			; first byte empty
	move.b	(a0),mixpattern+1
	move.w	RealTempo,mixcia

ShowMixPattern:
	move.w	endmix,d0
	move.w	startmix,d1
	cmp.w	d0,d1				; start greater than end ?
	bls.s	notcrush2
	move.w	endmix,d0
	subq.w	#1,d0
	move.w	d0,startmix

notcrush2
	tst.w	endmix
	bne.s	notcrush
	addq.w	#1,endmix

notcrush:
	BSR.W	ShowModSampleNote
	move.w	#$15C6,TextOffset
	move.w	mixpattern,WordNumber
	BSR.W	Print2DecDigits
;startmix
	move.w	#$1936,TextOffset
	move.w	startmix,WordNumber
	BSR.W	Print2DecDigits
;endmix
	move.w	#$1CA6,TextOffset
	move.w	endmix,WordNumber
	bsr.w	Print2DecDigits
;mixsample:
	move.w	#$2016,TextOffset
	move.w	mixsample,d0
	tst.w	d0
	bne.s	notcrush3
	move.w	#1,mixsample
notcrush3:
	move.w	mixsample,WordNumber
	bsr.w	Print2DecDigits
;ciaspeed
	move.w	#$2016+$0370,TextOffset
	move.w	#3,TextLength
	BSR.S	mixciamcia
	move.b	#'-',mcia+6
	lea	(mcia+2),a0
	move.l	a0,ShowTextPtr
	GOTO	ShowText

mixciamcia:
	moveq	#0,d0
	cmp.w	#32,mixcia
	bge.s	mixcia2
	move.w	#32,mixcia
mixcia2:
	cmp.w	#255,mixcia
	ble.s	mixcia3
	move.w	#255,mixcia
mixcia3:
	move.w	mixcia,d0
	moveq	#2,d1
	moveq	#10,d2
	lea	(mcia+2),a0
	BSR.s	ValToStr
	rts

ValToStr:
	movem.l d3/d4/a1,-(a7)
	subq.l	#2,d2
	cmp.l	#16-2,d2
	bls.s	.ok
	moveq	#-1,d0
	movem.l d3/d4/a1,-(a7)
	rts
.ok:
	addq.l	#2,d2			; base could only be 2 between 2 and 16
	lea	.vts_mask(pc),a1
	add.l	d1,d1
	add.l	d1,d1
	move.l	0(a1,d1.w),d3
	and.l	d3,d0			; mask out LONG,WORD or BYTE
	not.l	d3			; invert mask
	lea	.vts_chartab(pc),a1
	moveq	#0,d1			; init value
	bsr.s	.rek_val		; val=d0/c,count=d1/v,base=d2/c,InvMask=d3/c

	moveq	#0,d0			; delete leading mask values if avl.
	movem.l (a7)+,d3/d4/a1
	rts

.rek_val:
	movem.l d1/d4/d5,-(a7)
	tst.l	d1
	bne.s	.okrek
	moveq	#1,d1
	bra.s	.rek			; 1 as mt_counter beginning
.okrek:
	move.l	d2,d4
	subq.w	#2,d4			; dbra and 1 as start value
	move.l	d1,d5
.mul_loop:
	add.l	d5,d1
	dbcs	d4,.mul_loop
	bcs.s	.out			; if carry then return()
	move.l	d1,d4
	and.l	d3,d4
	bne.s	.out			; if WORD or BYTE overwritten
.rek:
	bsr.b	.rek_val
	moveq	#0,d5			; 0 is first num
	move.l	d1,d4
	bra.s	.cmp

.loop:	addq.w	#1,d5
	add.l	d1,d4
	bcs.s	.cs			; highest nibble? no 33th bit
.cmp:	cmp.l	d0,d4
	bls.s	.loop
.cs:	sub.l	d1,d4
	sub.l	d4,d0
	move.b	0(a1,d5.w),(a0)+	;xte num

.out:	movem.l (a7)+,d1/d4/d5
	rts

.vts_mask:	dc.l	$ffffffff,$ffff,$ff
.vts_chartab:	dc.b	'0123456789ABCDEF',0
		EVEN

*********************************
sixnoteup:
	cmp.w	#35,ModSampleNote
	beq.s	sixnoteup2
	addq.w	#1,ModSampleNote
	BRA.W	ShowMixPattern
sixnoteup2:
	GOTO	WaitForButtonUp

sixnotedo:
	cmp.w	#0,ModSampleNote
	beq.s	sixnotedo2
	subq.w	#1,ModSampleNote
	BRA.W	ShowMixPattern
sixnotedo2:
	GOTO	WaitForButtonUp

sixpattup:
	addq.w	#1,mixpattern
	checkrmb
	bne.s	sixnoteupx
	add.w	#9,mixpattern
sixnoteupx:
	tst.b	patt100flag
	bne.s	sixpattup4
	cmp.w	#63,mixpattern
	bge.s	sixpattup2
	bra.s	sixpattup3
sixpattup4:
	cmp.w	#99,mixpattern
	bge.s	sixpattup2
sixpattup3:
	BRA.W	ShowMixPattern
sixpattup2:
	tst.b	patt100flag
	bne.s	sixpattup5
	move.w	#63,mixpattern
	BRA.W	ShowMixPattern
sixpattup5:
	move.w	#99,mixpattern
	BRA.W	ShowMixPattern

sixpattdo:
	subq.w	#1,mixpattern
	checkrmb
	bne.s	sixnotedox
	sub.w	#9,mixpattern
sixnotedox:
	cmp.w	#0,mixpattern
	ble.s	sixpattdo2
	BRA.W	ShowMixPattern
sixpattdo2:
	move.w	#0,mixpattern
	BRA.W	ShowMixPattern

sixstartup:
	move.w	endmix,d0
	subq.w	#1,d0
	cmp.w	startmix,d0
	ble.s	sixstartup2
	addq.w	#1,startmix
	BRA.W	ShowMixPattern
sixstartup2:
	GOTO	WaitForButtonUp

sixstartdo:
	cmp.w	#0,startmix
	beq.s	sixstartdo2
	subq.w	#1,startmix
	BRA.W	ShowMixPattern
sixstartdo2:
	GOTO	WaitForButtonUp

sixendup:
	cmp.w	#63,endmix
	beq.s	sixendup2
	addq.w	#1,endmix
	BRA.W	ShowMixPattern
sixendup2:
	GOTO	WaitForButtonUp

sixenddo:
	move.w	startmix,d0
	addq.w	#1,d0
	cmp.w	endmix,d0
	bge.s	sixenddo2
	subq.w	#1,endmix
	BRA.W	ShowMixPattern
sixenddo2:
	GOTO	WaitForButtonUp

sixsamup:
	cmp.w	#MaxInsNum,mixsample
	beq.s	sixsamup2
	addq.w	#1,mixsample
	BRA.W	ShowMixPattern
sixsamup2:
	GOTO	WaitForButtonUp

sixsamdo:
	cmp.w	#1,mixsample
	beq.s	sixsamdo2
	subq.w	#1,mixsample
	BRA.W	ShowMixPattern
sixsamdo2:
	GOTO	WaitForButtonUp

sixciaup:
	addq.w	#1,mixcia
	checkrmb
	BNE.W	ShowMixPattern
	add.w	#9,mixcia
	BRA.W	ShowMixPattern

sixciado:
	subq.w	#1,mixcia
	checkrmb
	BNE.W	ShowMixPattern
	sub.w	#9,mixcia
	BRA.W	ShowMixPattern

hitmcia:

	MOVE.W	#$01A6+6+8,LineCurX
	MOVE.W	#$0079-2,LineCurY
	MOVE.W	#$2016+$370,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	ShowMixPattern
	cmp.w	#26,d0
	bge.s	hitmcia2
	mulu.w	#10,d0
hitmcia2:
	move.w	d0,mixcia
	bra.w	ShowMixPattern

hitpitch:
	BSR.S	ShowModSampleNote
	MOVE.W	#$15c6-$370,TextOffset
	MOVE.W	#3,TextLength
	MOVE.L	#SpcNoteText,ShowTextPtr
	BSR.W	ShowText
	MOVE.W	#4,SamNotetype
	MOVE.L	#ModSampleNote,SplitAddress
	GOTO	WaitForButtonUp

ShowModSampleNote:
	LEA	(mpitch),a6
	lea	NoteNames1,a5
	move.w	ModSampleNote,d0
	LSL.W	#2,d0
	LEA	(A5,D0.w),A0
	move.l	(a0),(a6)
	move.w	#$15C6-$370,TextOffset
	move.w	#3,TextLength
	lea	(mpitch),a0
	move.l	a0,ShowTextPtr
	CALL	ShowText
	RTS

hitmixpattern:
	MOVE.W	#$01A6+6+8,LineCurX
	MOVE.W	#$004C-2,LineCurY
	MOVE.W	#$15C6,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	ShowMixPattern
	cmp.b	patt64length,d0
	bls.s	to_m64
	move.l	MaxPattLength,d0
to_m64:
	move.b	d0,mixpattern+1
	bra.w	  ShowMixPattern

hitm_start:
	MOVE.W	#$01A6+6+8,LineCurX
	MOVE.W	#$004C+9,LineCurY
	MOVE.W	#$1936,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	ShowMixPattern
	cmp.b	#62,d0
	bls.s	to_m641
	moveq	#62,d0
to_m641:
	move.b	d0,startmix+1
	bra.w	  ShowMixPattern

hitm_end:
	MOVE.W	#$01A6+6+8,LineCurX
	MOVE.W	#$004C+9+9+2,LineCurY
	MOVE.W	#$1CA6,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	ShowMixPattern
	cmp.b	#63,d0
	bls.s	to_m642
	moveq	#63,d0
to_m642:
	move.b	d0,endmix+1
	bra.w	  ShowMixPattern

hitm_to:
	MOVE.W	#$01A6+6+8,LineCurX
	MOVE.W	#$004C+9+9+9+4,LineCurY
	MOVE.W	#$2016,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.W	ShowMixPattern
	cmp.b	#MaxInsNum,d0
	bls.s	to_m643
	moveq	#MaxInsNum,d0
to_m643:
	move.b	d0,mixsample+1
	bra.w	ShowMixPattern

;--- save temporary mod ---
mixit:
	chn8test
	bne.s	.no8smp				; only 4 channel mode supported

	lea	no8modtxt,a0
	CALL	AreYouSure
	RTS

.no8smp:
	move.b	modmode,savmodmod
	clr.b	modmode
	BSR.W	CalcSaveMod
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0		; Song positions
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	CLR.W	HighPattNum
.loop:
	MOVE.B	0(A0,D0.W),D1
	ADDQ.W	#1,D0
	CMP.W	#127,D0
	BHI.S	m_DoSaveModule
	MOVE.W	HighPattNum,D2
	CMP.W	D2,D1
	BLS.S	.loop

	MOVE.W	D1,HighPattNum
	BRA.S	.loop

m_DoSaveModule:
	lea	tempPath,a0
	CALL	CopyPath
	MOVE.B	#'m',(A1)+
	MOVE.B	#'o',(A1)+
	MOVE.B	#'d',(A1)+
	MOVE.B	#'.',(A1)+
	lea	tmpmname,A0
	MOVEQ	#20-1,D0
.loop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loop

	CLR.W	PPSetSvFlag
	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,DiskDataPtr
	MOVE.L	#sd_patterndata,DiskDataLength
	MOVEQ	#0,D0
	MOVE.W	HighPattNum,D0
	ADDQ.L	#1,D0
	LSL.L	#8,D0
	LSL.L	#2,D0
	ADD.L	D0,DiskDataLength
	MOVE.B	#$7F,sd_ntflag(A0)
	MOVE.L	#'M.K.',sd_mahokakt(A0)
	cmp.w	#64,HighPattNum
	bcs.s	.doit
	move.l	#'M!K!',sd_mahokakt(a0)

.doit:
	BSR.W	wr_savmoddatas			; save patterns
	move.b	savmodmod,modmode
	lea	calcmodsmp.msg,a0
	BSR.W	ShowStatusText
MixIt:
	move.w	mixpattern,d0
	BSR.W	convhexg
	move.w	d1,mpattern
	move.w	startmix,d0
	bsr.w	convhexg
	move.w	d1,mstart
	move.w	endmix,d0
	bsr.w	convhexg
	move.w	d1,mend
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	tst.l	RunMode
	bne.s	.dostop
	CALL	StopIt

.dostop:

;--- open invisible cli window dummy ---

	move.l	#ExtCmdConsole,d1
	move.l	#1006,d2
	move.l	DOSBase,a6
	CALLSYS	Open
	move.l	d0,ExtCmdWindow
	bne.s	.nowinderr

	LEA	ConsoleErrText,A0
	CALL	ShowStatusText
	GOTO	SetErrorPtrCol

.nowinderr:
	lea	smpcommandline,a0
	move.l	a0,d1
	move.l	ExtCmdWindow,d2
	moveq	#0,d3				; output
	move.l	DOSBase,a6
	CALLSYS	Execute				; execute mod2smp

;--- close cli window ---
	MOVE.L	ExtCmdWindow,D1
	BNE.S	.closecli
	RTS

.closecli:
	MOVE.L	DOSBase,A6
	CALLSYS	Close
	CLR.L	ExtCmdWindow
	CALL	RestorePtrCol
	BSR.W	ShowAllRight
	move.l	DOSBase,a6
	lea	tmp2name,a0
	move.l	a0,d1
	CALLSYS	DeleteFile			; del temporary module

;--- load calculated sample ---

	move.w	mixsample,InsNum
	tst.w	InsNum
	beq.w	NotSampleNull2
	move.l	tempsamname,DirInputName
	lea	DirInputName,a0
	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	MULU	#30,D0
	LEA	-10(A0),A0
	ADD.L	D0,A0

;--- load sample to pos ---

	move.l	#tempsamname,d1
	bsr.w	ExamineAndAlloc
	MOVE.L	FIB_FileSize,D0
	BSR.W	AllocSampleMem
	move.l	#tempsamname,d1
	bsr.w	ralgas		  		; load

;--- delete temp sample ---

	move.l	DOSBase,a6
	lea	tempsamname,a0
	move.l	a0,d1
	CALLSYS	DeleteFile			; del temporary sample
	clr.b	RawKeyCode
	bra.w	Wait_4000

tempPath:	dc.b	'T:',0,0
tmpmname:	dc.b	'temp',0,0
tmp2name:	dc.b	'T:mod.temp',0,0
tempsamname:	dc.b	'T:tsample',0
smpcommandline: dc.b	'LIBS:mod2smp.library T:mod.temp T:tsample '
mpattern:	dc.b	'1   '
mstart: 	dc.b	'0   '		;!
mend:		dc.b	'63  '
mvolume:	dc.b	'85  '
mpitch: 	dc.b	'C-3 '		;!
mcia:		dc.b	'-c125 '	;!
moption:	dc.b	'-r0',0
		EVEN

ExtCmdConsole:	dc.b	"NIL:",0,0
ExtCmdAddress:	dc.l	0
ExtCmdWindow:	dc.l	0

ccontable:	dc.b	'0000010203040506070809'
ccontable1:	dc.b	'10111213141516171819'
ccontable2:	dc.b	'20212223242526272829'
ccontable3:	dc.b	'30313233343536373839'
ccontable4:	dc.b	'40414243444546474849'
ccontable5:	dc.b	'50515253545556575859'
ccontable6:	dc.b	'60616263646566676869'
		EVEN

*****************************
convhexg:
	cmp.w	#60,d0
	bmi.s	ccc59
	MOVE.L	ccontable6,d1
	sub.w	#61,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc59:	cmp.w	#50,d0
	bmi.s	ccc49
	MOVE.L	ccontable5,d1
	sub.w	#51,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc49:	cmp.w	#40,d0
	bmi.s	ccc39
	MOVE.L	ccontable4,d1
	sub.w	#41,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc39:	cmp.w	#30,d0
	bmi.s	ccc29
	MOVE.L	ccontable3,d1
	sub.w	#31,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc29:	cmp.w	#20,d0
	bmi.s	ccc19
	MOVE.L	ccontable2,d1
	sub.w	#21,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc19:	cmp.w	#10,d0
	bmi.s	ccc09
	MOVE.L	ccontable1,d1
	sub.w	#11,d0
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS
ccc09:	MOVE.L	ccontable,d1
	add.w	d0,d1
	move.l	d1,a0
	LEA	(A0),A2
	move.w	a2,d1
	RTS

;**********************************
;* file info bar option 7         *
;**********************************
entercomment:
	MOVEQ	#8,D0				; optionflag
	move.w	#8,OptScrFlag
	lea	Opt8Data,a0
	BSR.W	OptDecrunch

ShowComment:
	moveq	#8,d6				; lines+1
	MOVE.W	#$1255-8-5,TextOffset		; offset
	moveq	#0,d3

shcolp:
	move.l	#fo_comments,a0
	add.l	d3,a0
	move.l	A0,ShowTextPtr
	MOVE.W	#40,TextLength
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	add.w	#480-40,TextOffset
	add.w	#40,d3
	dbra	d6,shcolp
	rts

enterline1:
	move.w	#0,d6
	move.w	#0,d5
	bra.s	elinec

enterline2:
	move.w	#40,d6
	move.w	#480,d5
	bra.s	elinec

enterline3:
	move.w	#80,d6
	move.w	#960,d5
	bra.s	elinec

enterline4:
	move.w	#120,d6
	move.w	#1440,d5
	bra.s	elinec

enterline5:
	move.w	#160,d6
	move.w	#1920,d5
	bra.s	elinec

enterline6:
	move.w	#200,d6
	move.w	#2400,d5
	bra.s	elinec

enterline7:
	move.w	#240,d6
	move.w	#2880,d5
	bra.s	elinec

enterline8:
	move	#280,d6
	move.w	#3360,d5
	bra.s	elinec

enterline9:
	move	#320,d6
	move.w	#3840,d5

elinec:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	move.l	#fo_comments,a6
	add.l	d6,A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#39,TextEndPtr
	MOVE.W	#40,TextLength
	MOVE.W	#$1255-8-5,d7
	add.w	d5,d7
	move.w	d7,a4
	BSR.W	GetTextLine
	CLR.L	TextEndPtr
	CALL	RestorePtrCol
	BRA.W	  ShowComment

clearcmnt:
	bsr.s	clearcomments
	bra.w	ShowComment

clearcomments:
	move.w	#360,d7
	lea	fo_comments,a0
.loop:
	move.b	#0,(a0,d7)
	dbra	d7,.loop
	RTS

;***********************************
;* option 8 routines               *
;***********************************

CheckOpt8Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt8GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	CheckOpt_8
	RTS

CheckOpt_8:
	cmp.w	#1,d2
	beq.s	createcomment
	cmp.w	#2,d2
	beq.w	enterline1
	cmp.w	#3,d2
	beq.w	enterline2
	cmp.w	#4,d2
	beq.w	enterline3
	cmp.w	#5,d2
	beq.w	enterline4
	cmp.w	#6,d2
	beq.w	enterline5
	cmp.w	#7,d2
	beq.w	enterline6
	cmp.w	#8,d2
	beq.w	enterline7
	cmp.w	#9,d2
	beq.w	enterline8
	cmp.w	#10,d2
	beq.w	enterline9
	cmp.w	#11,d2
	beq.w	clearcmnt
	RTS

createcomment:

Opt5RotChk:

	MOVEQ	#5,D0			;optionflag
	move.w	#5,OptScrFlag
	lea	Opt5Data,a0
	BSR.W	OptDecrunch

trackme:
	cmp.w	#0,fo_creatdat_da
	beq.w	noinfosfor		;no IFF mod loaded

;tracker
	LEA	fo_ver,A0
	MOVE.W	#$1CA0+5,D1
	MOVEQ	#6,D0
	BSR.W	ShowText3


	lea	fo_songname,a0
	MOVE.W	#$1256-1,D1
	MOVEQ	#$14+6,D0
	BSR.W	ShowText3


	;author
	lea	fo_author,A0
	MOVE.W	#$15C0+5,D1
	MOVEQ	#$14+6,D0
	BSR.W	ShowText3


	move.w	#$192A+11,TextOffset
	move.w	fo_creatdat_da,WordNumber
	bsr.w	Print2DecDigits

	addq.w	#1,TextOffset
	LEA	Months.MSG,A0		;buffer
	MOVE.W	fo_creatdat_mo,D0
	SUBQ.W	#1,D0
	MULU	#5,D0
	ADD.W	D0,A0
	MOVE.W	#$192A+11+2,D1		;offset
	MOVE.W	#5,D0
	CALL	ShowText3
	move.w	#$192A+11+2+5,TextOffset
	move.w	fo_creatdat_ye,WordNumber
	bsr.w	Print2DecDigits


	addq.w	#4,TextOffset

	move.w	fo_creattime_h,WordNumber
	bsr.w	Print2DecDigits
	addq.w	#1,TextOffset
	move.w	fo_creattime_m,WordNumber
	bsr.w	Print2DecDigits
	addq.w	#1,TextOffset
	;move.w fo_creattime_s,WordNumber
	;bsr	Print2DecDigits

	addq.w	#1,TextOffset

	;move.w fo_playtime_h,WordNumber
	;bsr	Print2DecDigits
	move.w	fo_playtime_m,WordNumber
	bsr.w	Print2DecDigits
	addq.w	#1,TextOffset
	move.w	fo_playtime_s,WordNumber
	bsr.w	Print2DecDigits


	move.w	#$192A+$036A+$036A+26,TextOffset
	move.w	fo_patterns,WordNumber			;fo_patterns
	bsr.w	Print2DecDigits


	add.w	#$036A+4,TextOffset

	chn8test
	beq.s	i8voices
	move.w	#$04,WordNumber
	bra.s	i4voices
i8voices:
	move.w	#$08,WordNumber
i4voices:
	bsr.w	Print2DecDigits

	move.w	#$192A+$036A+$036A+$036A+43,TextOffset
	move.w	RealTempo,WordNumber
	bsr.w	Print4DecDigits


showrevision:
	move.w	fo_modver,WordNumber
	move.w	#$192A+$036A+37,TextOffset
	CALL	Print4DecDigits



	btst	#0,Packetfield
	beq.s	itsciatime
	move.w	#$192A+$036A+$036A+36,d1
	moveq	#4,d0
	lea	CIA.MSG,a0
	BRA.W	ShowText3

itsciatime:
	move.w	#$192A+$036A+$036A+36,d1
	moveq	#4,d0
	lea	VBLANK.MSG,a0
	BRA.W	ShowText3


noinfosfor:
	move.w	#$15C0+6,d1
	moveq	#23,d0
	lea	noifo.txt,a0
	BRA.W	ShowText3

noifo.txt:
	dc.b	'-=* NO IFF FORM MOD *=-',0

CheckOpt5Gadg:
	MOVEM.W (MouseX2),D0/D1
	LEA	Opt5GadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BNE.S	CheckOpt_5
	RTS

CheckOpt_5:

	cmp.w	#1,d2
	beq.s	createform

	cmp.w	#0,fo_creatdat_da
	beq.s	niffok			;no IFF mod loaded

	CMP.W	#2,D2
	BEQ.W	erealsg 		;modname
	cmp.w	#3,d2
	beq.w	erealaut		;author
	CMP.W	#4,D2
	BEQ.W	enterrev
	cmp.w	#5,d2
	beq.w	  entercomment
niffok: RTS


createform:
	move.w	fa_creatdat_da,fo_creatdat_da
	move.w	fa_creatdat_mo,fo_creatdat_mo
	move.w	fa_creatdat_ye,fo_creatdat_ye
	move.w	fa_creattime_h,fo_creattime_h
	move.w	fa_creattime_m,fo_creattime_m
	move.w	fa_creattime_s,fo_creattime_s
	move.w	#23,TextLength
	move.w	#$192A+11+1,TextOffset

	CALL	CalTime 		;calculate playtime of song
	LEA	Timer,a0
	move.l	(A0),D0
	move.w	d0,fo_playtime_h
	move.l	4(A0),d0
	move.w	d0,fo_playtime_m
	move.l	8(A0),d0
	move.w	d0,fo_playtime_s
	move.l	12(A0),d0
	move.w	d0,fo_playtime_ms

	lea	fo_songname,a0
	cmp.l	#'UNNA',(A0)		;unnamed song?
	bne.s	snamleavit

	move.l	mt_songdataptr,a0
	lea	fo_songname,a1
	moveq	#$13,D0
copysname1:

	move.b	(a0)+,(A1)+
	dbra	d0,copysname1

snamleavit:

	move.w	#MaxInsNum+1,fo_instr
	move.w	#64,fo_positions

	;calculate patterns

	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	CLR.W	HighPattNum

.loop:	MOVE.B	0(A0,D0.W),D1
	ADDQ.W	#1,D0
	CMP.W	#128,D0
	BHI.S	.l1
	MOVE.W	HighPattNum,D2
	CMP.W	D2,D1
	BLS.B	.loop
	MOVE.W	D1,HighPattNum
	BRA.B	.loop


.l1:	move.w	HighPattNum,fo_patterns

	move.w	fa_creatdat_da,fo_creatdat_da
	move.w	fa_creatdat_mo,fo_creatdat_mo
	move.w	fa_creatdat_ye,fo_creatdat_ye
	move.w	fa_creattime_h,fo_creattime_h
	move.w	fa_creattime_m,fo_creattime_m
	move.w	fa_creattime_s,fo_creattime_s


	MOVE.L	#EmptyTextField,ShowTextPtr
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	bra.w	trackme

enterrev:

	MOVE.W	#$024C+8,LineCurX
	MOVE.W	#$0060,LineCurY
	move.w	#$192A+$036A+37+1,TextOffset
	BSR.W	GetDec3Dig
	TST.W	AbortDecFlag
	BNE.S	revrets

	move.l	gd3temp,fo_modver
revrets:
	bra.w	showrevision


erealsg:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	LEA	fo_songname,A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#31,TextEndPtr
	MOVE.W	#26,TextLength
	MOVE.W	#$1256-1,A4
	BSR.W	GetTextLine
	CLR.L	TextEndPtr
	GOTO	RestorePtrCol


erealaut:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	LEA	fo_author,A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#31,TextEndPtr
	MOVE.W	#26,TextLength
	MOVE.W	#$15C0+5,A4
	BSR.W	GetTextLine
	CLR.L	TextEndPtr
	GOTO	RestorePtrCol


OptScrFlag:	dc.w	1
OptScrFlagOld:	dc.w	0

;***********************************
FilterEDDoIt:
	BSR.W	NotAvailable
	MOVE.W  #$0F0F,COLOR	       ;screen blitz
	RTS


;***********************************
;* option 1-8 screens depacker     *
;***********************************

OptDecrunch:

	CMP.W	OptScrFlagOld,D0
	BEQ.S	optd6
	MOVE.W	D0,OptScrFlagOld
	CMP.L	#0,a0
	BEQ.S	optd6

	bsr.w	G_DecompactIFF
	LEA	PTBitMap+OptionsPos,A0

	MOVEQ	#1,D2

dcclr:	MOVE.W	#$004C,D0
daclr:	MOVEQ	#9,D1
.loo:
	MOVE.L	(A1)+,(A0)+
	DBRA	D1,.loo
	LEA	$0028(A0),A0
	DBRA	D0,daclr
	LEA	$37F0(A0),A0
	DBRA	D2,dcclr

	MOVE.W	#$0140,D0
	MOVE.W	#$002D,D1
	MOVE.W	#$027F,D2
	MOVE.W	#$0079,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox			; clears optiongadgets 1_7 area
	MOVEQ	#0,D0

	move.l	G_DecompMemPtr,d0
	BSR.W	G_FreeDecompMem
optd6:	RTS



lbC00DA84:
	MOVE.L	fi_memad(PC),A1
	LEA	lbL00DAEC(PC),A2
	MOVEQ	#2,D7
lbC00DA8E:
	MOVE.L	(A1)+,D0
	MOVE.L	D0,A0
	BNE.S	lbC00DAB6
	LEA	ascii.MSG17(PC),A0
	MOVE.W	(A2)+,D0
	MOVE.W	(A2)+,D1
	MOVEQ	#8,D3
	CALL	Wr_Message
	ADD.W	#$003E,D0
	MOVEQ	#6,D3
	BSR.W	Write_Text
	ADD.L	#12,A1
	BRA.S	lbC00DAE6

lbC00DAB6:
	MOVE.L	(A1),D2
	CMP.L	4(A1),D2
	BPL.S	lbC00DAC2
	MOVE.L	4(A1),D2
lbC00DAC2:
	CMP.L	8(A1),D2
	BMI.S	lbC00DACC
	MOVE.L	8(A1),D2
lbC00DACC:
	MOVE.L	D2,(A1)+
	ADDQ.L	#8,A1
	MOVE.W	(A2)+,D0
	MOVE.W	(A2)+,D1
	MOVEQ	#8,D3
	CALL	Wr_Message
	ADD.W	#$003E,D0
	MOVEQ	#6,D3
	BSR.W	PrintHexWord2
lbC00DAE6:
	DBRA	D7,lbC00DA8E
	RTS

lbL00DAEC:	dc.l	$016D0066,$016D0071,$01F90066,$01F90071
ascii.MSG17:	dc.b	'        ',0,0

;***********************************

lbC00DB04:
	MOVE.L	(A0),D2
	MOVEM.L D0/D1,-(SP)
	MOVEQ	#6,D3
	BSR.W	lbC00C3F6		;!!!
	MOVE.L	D0,(A0)
	MOVEM.L (SP)+,D0/D1
	BRA.S	lbC00DB3E

lbC00DB18:
	MOVEQ	#1,D3
	checkrmb
	BNE.S	lbC00DB26
	MOVEQ	#10,D3
lbC00DB26:
	ADD.L	D3,(A0)
	BRA.S	lbC00DB3E

lbC00DB2A:
	MOVEQ	#1,D3
	checkrmb
	BNE.S	lbC00DB38
	MOVEQ	#10,D3
lbC00DB38:
	SUB.L	D3,(A0)
	BPL.S	lbC00DB3E
	CLR.L	(A0)
lbC00DB3E:
	MOVE.L	(A0),D2
	CMP.L	4(A0),D2
	BPL.S	lbC00DB4A
	MOVE.L	4(A0),D2
lbC00DB4A:
	CMP.L	8(A0),D2
	BMI.S	lbC00DB54
	MOVE.L	8(A0),D2
lbC00DB54:
	MOVE.L	D2,(A0)
	MOVEQ	#6,D3
	BRA.W	PrintHexWord2

lbC00DB5C:
	ADDQ.W	#1,lbW00DC6E
lbC00DB62:
	MOVE.W	lbW00DC6E(PC),D0
	CMP.W	#6,D0
	BMI.S	lbC00DB74
	MOVEQ	#0,D0
	MOVE.W	D0,lbW00DC6E
lbC00DB74:
	MOVE.W	D0,D1
	LSL.W	#2,D1
	;MULU	 #$0010,D0
	LSL.L	#4,D0					;orgmulu
	MOVE.L	mt_filtartadrs(PC,D1.W),fi_memad
	LEA	mt_filtpassnam(PC,D0.L),A0
	MOVE.W	#$0182,D0
	MOVEQ	#$5B,D1
	MOVEQ	#$10,D3
	CALL	Wr_Message
	BSR.W	lbC00DA84
	BRA.W	mt_selectfilterl


;******************************

mt_filtartadrs:
	dc.l	mt_filtartadrs1
	dc.l	mt_filtartadrs2
	dc.l	mt_filtartadrs3
	dc.l	mt_filtartadrs4
	dc.l	mt_filtartadrs5
	dc.l	mt_filtartadrs6
	dc.l	mt_filtartadrs7
	dc.l	mt_filtartadrs8
	dc.l	mt_filtartadrs9
	dc.l	mt_filtartadrsA

mt_filtpassnam:
	dc.b	'Lowpass 1 pole  Highpass 1 pole Bandpass 2 polesShelving low    Shelving high   Loop Comb       Loop Allpass    Delay Feedback  MultiTapDelay   Waveshaping     ',0

fi_memac:	dc.l	0
fi_memad:	dc.l	0
lbW00DC6E:	dc.w	0
FilterArt:	dc.w	0
mt_filtartadrs1:
		dc.l	Freeqcy.MSG,0,$0000006E,$00000370,0,0,0,0,0,0,0,0
		dc.l	fi_GFXBUF
Freeqcy.MSG:	dc.b	'Freeqcy.'
mt_filtartadrs2:
		dc.l	Freeqcy.MSG0,0,$0000006E,$00000370,0,0,0,0,0,0,0
		dc.l	0
		dc.l	fi_GFXBUF
Freeqcy.MSG0:	dc.b	'Freeqcy.'

mt_filtartadrs3:
		dc.l	Freeqcy.MSG1,0,$0000006E,$00000370
		dc.l	Quality.MSG,0,$FFFFFFFF,1,0,0,0,0,0

Freeqcy.MSG1:	dc.b	'Freeqcy.'
Quality.MSG:	dc.b	'Quality '
mt_filtartadrs4:
		dc.l	Freeqcy.MSG2,0,$0000006E,$00000370
		dc.l	Gain.MSG,0,$FFFFFFFF,1,0,0,0,0
		dc.l	fi_GFXBUF
Freeqcy.MSG2:	dc.b	'Freeqcy.'
Gain.MSG:	dc.b	'Gain    '

mt_filtartadrs5:
		dc.l	Freeqcy.MSG3,0,$0000006E,$00000370
		dc.l	Gain.MSG0,0,$FFFFFFFF,1,0,0,0,0
		dc.l	fi_GFXBUF
Freeqcy.MSG3:	dc.b	'Freeqcy.'
Gain.MSG0:	dc.b	'Gain    '

mt_filtartadrs6:
		dc.l	Looptime.MSG,0,0,$00000064
		dc.l	Feedback.MSG,0,0,$00001000,0,0,0,0
		dc.l	fi_GFXBUF

Looptime.MSG:	dc.b	'Looptime'
Feedback.MSG:	dc.b	'Feedback'

mt_filtartadrs7:
		dc.l	Looptime.MSG0,0,0,$00000064
		dc.l	Feedback.MSG0,0,0,$00001000,0,0,0,0
		dc.l	fi_GFXBUF

Looptime.MSG0:	dc.b	'Looptime'
Feedback.MSG0:	dc.b	'Feedback'

mt_filtartadrs8:
		dc.l	Delay.MSG,0,0,$00001000
		dc.l	Feedback.MSG1,0,0,$00001000
		dc.l	Output.MSG,0,0,$00001000,0,0,0,0
		dc.l	fi_GFXBUF

Delay.MSG:	dc.b	'Delay   '
Feedback.MSG1:	dc.b	'Feedback'
Output.MSG:	dc.b	'Output  '

mt_filtartadrs9:
		dc.l	Output.MSG0,0,0,$00001000,0,0,0,0,0,0,0,0
		dc.l	fi_GFXBUF
Output.MSG0:	dc.b	'Output  '

mt_filtartadrsA:
		dc.l	0,0,0,0,0,0,0,0,0,0,0,0
		dc.l	fi_GFXBUF
		EVEN

mt_selectfilter:
	ADDQ.W	#1,FilterArt
mt_selectfilterl:
	MOVE.W	FilterArt(PC),D0
	CMP.W	#5,D0
	BMI.S	mt_getfilter
	MOVEQ	#0,D0
	MOVE.W	D0,FilterArt

mt_getfilter:
	LSL.L	#3,D0
	LEA	NoneFreehandS.MSG(PC,D0.L),A0
	MOVE.W	#$020E,D0
	MOVEQ	#$5B,D1
	MOVEQ	#8,D3
	CALL	Wr_Message
	BRA.S	mt_playwithfil


NoneFreehandS.MSG:
	dc.b	'None    FreehandSinus   Max->MinMin->Max',0
	EVEN

;***********************************
mt_playwithfil:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#$016D,D0
	MOVE.W	#$0038,D1
	MOVE.W	#$027B,D2
	MOVE.W	#$0057,D3
	MOVEQ	#0,D5
	BSR.W	DrawRecBox			; clear filtercurve area
	MOVE.L	fi_memad(PC),A0
	MOVE.L	$0030(A0),D0
	BEQ.W	filtdoret
	TST.W	FilterArt
	BEQ.W	filtdoret
	CMP.W	#2,FilterArt
	BNE.S	mt_ttfila

	;draw sinus in filtered

	LEA	mt_vibratotable,A1
	LEA	fi_GFXCHI,A0
	MOVE.L	A0,D0
	MOVE.W	#$010D,D1
.loo:
	MOVEQ	#0,D2
	MOVE.B	(A1)+,D2
	MULS	#$001E,D2
	DIVS	#$00FF,D2
	MOVE.B	D2,(A0)+
	DBRA	D1,.loo

mt_ttfila:
	CMP.W	#3,FilterArt
	BNE.S	filtdoaf
	LEA	fi_GFXCHI,A0
	MOVE.L	A0,D0
	MOVEQ	#0,D1
	MOVE.W	#$010D,D2
.loa:
	MOVE.L	D1,D3
	DIVU	#9,D3
	MOVE.B	D3,(A0)+
	ADDQ.L	#1,D1
	DBRA	D2,.loa
filtdoaf:
	CMP.W	#4,FilterArt
	BNE.S	filtdoaa
	LEA	fi_GFXCHI,A0
	MOVE.L	A0,D0
	MOVE.W	#$010E,D1
	MOVE.W	#$010D,D2
.loa:
	MOVE.L	D1,D3
	DIVU	#9,D3
	MOVE.B	D3,(A0)+
	SUBQ.L	#1,D1
	DBRA	D2,.loa
filtdoaa:
	MOVE.L	D0,fi_memac
	MOVE.L	D0,A0
	MOVEQ	#0,D4
filtdoa1:
	MOVEQ	#0,D5
	MOVE.B	(A0)+,D5
	BSR.W	RefreshCurv
	ADDQ.W	#1,D4
	CMP.W	#$010E,D4
	BMI.S	filtdoa1
filtdoret:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*********************************
;* draws the filtercurve         *
;*********************************
CurveArea:
	CMP.W	#1,FilterArt
	BNE.W	.end
	MOVE.L	fi_memac(PC),D0
	BEQ.W	.end
	MOVEQ	#-1,D0

.loop:	MOVEM.W (MouseX),D2/D3

	CMP.W	#365,D2			;left limit
	BPL.S	.l1
	MOVE.W	#365,D2

.l1:	CMP.W	#56,D3
	BPL.S	.l2
	MOVEQ	#56,D3

.l2:	CMP.W	#634,D2			;right limit
	BMI.S	.l3
	MOVE.W	#634,D2

.l3:	CMP.W	#86,D3
	BMI.S	.l4
	MOVEQ	#86,D3

.l4:	SUB.W	#365,D2
	SUB.W	#56,D3

	MOVEM.W D2/D3,-(SP)
	TST.W	D0
	BMI.S	.noset
	CMP.W	D0,D2
	BEQ.S	.noset
	BGT.S	.slk
	EXG	D0,D2
	EXG	D1,D3
.slk:
	SUB.W	D0,D2
	MOVE.W	D0,D4
	SUB.W	D1,D3
	MOVE.W	D2,D0
	MOVE.W	D2,D7
	SUBQ.W	#1,D7
	MOVEQ	#0,D2

.lp:	MOVE.W	D2,D5
	MULS	D3,D5
	DIVS	D0,D5
	ADD.W	D1,D5
	BSR.S	RefreshCurv
	ADDQ.W	#1,D2
	ADDQ.W	#1,D4
	DBRA	D7,.lp

.noset:	MOVEM.W (SP)+,D0/D1
	MOVE.W	D0,D4
	MOVE.W	D1,D5
	BSR.S	RefreshCurv
	CALL	ResetKeyTimer

	checklmb
	BEQ.B	.loop
.end:	RTS

;********************************
RefreshCurv:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	fi_memac(PC),A1
	MOVEQ	#0,D1
	MOVE.B	0(A1,D4.W),D1
	MOVE.B	D5,0(A1,D4.W)
	ADD.W	#$0038,D1
	ADD.W	#$0038,D5
	ADD.W	#$016D,D4
	MULS	#$0050,D1
	MULS	#$0050,D5
	MOVE.W	D4,D3
	ASR.W	#3,D4
	ADD.W	D4,D1
	ADD.W	D4,D5
	NOT.B	D3
	MOVE.L	TextBplPtr,A0
	BCLR	D3,0(A0,D1.W)
	BSET	D3,0(A0,D5.W)
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************
lbC00E548:
	MOVE.W	lbW00E57E,D0
	NOT.W	D0
	MOVE.W	D0,lbW00E57E		;for OMA 68030
lbC00E54E:
	LEA	Adjust.MSG(PC),A0
	TST.W	lbW00E57E
	BEQ.S	lbC00E55E
	LEA	NoAdjust.MSG(PC),A0
lbC00E55E:
	MOVE.W	#$01CB,D0
	MOVE.W	#$0050,D1
	MOVEQ	#8,D3
	GOTO	Wr_Message

Adjust.MSG:	dc.b	' Adjust ',0
		EVEN

NoAdjust.MSG:	dc.b	'NoAdjust',0
		EVEN

lbW00E57E:	dc.w	0

;***********************************
mt_emaxsam:
	ADDQ.W	#1,InstrNum
	CMP.W	#MaxInsNum,InstrNum
	BMI.S	.l1
	MOVE.W	#MaxInsNum,InstrNum

.l1:	BSR.W	Wait_4000
	BRA.S	mt_showsampnum1
;---
mt_submaxsam:
	SUBQ.W	#1,InstrNum
	BPL.S	.l1
	CLR.W	InstrNum
.l1:	BSR.W	Wait_4000
	BRA.S	mt_showsampnum1

;---
mt_showsampnum:
	MOVE.W	InsNum,InstrNum
mt_showsampnum1:
	MOVE.W	InstrNum(PC),WordNumber
	MOVE.W	#$15C0,TextOffset
	BRA.W	PrintHexWord

;***********************************

lbC00E5D2:
	ADDQ.W	#1,mt_samnum
	CMP.W	#MaxInsNum,mt_samnum
	BMI.S	lbC00E5EA
	MOVE.W	#MaxInsNum,mt_samnum
lbC00E5EA:
	BSR.W	Wait_4000
	BRA.S	lbC00E614
;---
lbC00E5F0:
	SUBQ.W	#1,mt_samnum
	BPL.S	.l1
	CLR.W	mt_samnum
.l1:	BSR.W	Wait_4000
	BRA.S	lbC00E614

;*** value entry with 'to sample' ****

O3_ToSampleGad:
	MOVE.W	InstrNum(PC),D0
	ADDQ.W	#1,D0
	AND.W	#31,D0
	MOVE.W	D0,mt_samnum
lbC00E614:
	MOVE.W	mt_samnum(PC),WordNumber
	MOVE.W	#$1CA0,TextOffset
	BRA.W	PrintHexWord

;***********************************
lbC00E62A:
	ADDQ.W	#1,lin_bufx
	CMP.W	#7,lin_bufx
	BMI.S	lbC00E642
	MOVE.W	#7,lin_bufx
lbC00E642:
	BSR.W	Wait_4000
	BRA.S	lbC00E664

lbC00E648:
	SUBQ.W	#1,lin_bufx
	CMP.W	#2,lin_bufx
	BPL.S	lbC00E660
	MOVE.W	#2,lin_bufx
lbC00E660:
	BSR.W	Wait_4000
lbC00E664:
	MOVE.W	#$15CD,TextOffset
	MOVE.W	lin_bufx(PC),D0
	BSR.W	PrintHexDigit
	BRA.W	lbC00E750

;***********************************

lin_v1:
	MOVEQ	#1,D7
	MOVE.W	#$0174,LineCurX
	LEA	lbW00ECD4(PC),A6
	BRA.W	lin_vmak

lin_v2:
	MOVEQ	#2,D7
	MOVE.W	#$019C,LineCurX
	LEA	lbW00ECD6(PC),A6
	BRA.S	lin_vmak

lin_v3:
	MOVEQ	#3,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_v4
	RTS

lin_v4:
	MOVE.W	#$01C4,LineCurX
	LEA	lbW00ECD8(PC),A6
	BRA.S	lin_vmak

lin_v5:
	MOVEQ	#4,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_v6
	RTS

lin_v6:
	MOVE.W	#$01EC,LineCurX
	LEA	lbW00ECDA(PC),A6
	BRA.S	lin_vmak

lin_v7:
	MOVEQ	#5,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_v8
	RTS

lin_v8:
	MOVE.W	#$0214,LineCurX
	LEA	lbW00ECDC(PC),A6
	BRA.S	lin_vmak

lin_v9:
	MOVEQ	#6,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_v10
	RTS

lin_v10:
	MOVE.W	#$023C,LineCurX
	LEA	lbW00ECDE(PC),A6
	BRA.S	lin_vmak

lin_v11:
	MOVEQ	#7,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_v12
	RTS

lin_v12:
	MOVE.W	#$0264,LineCurX
	LEA	lbB00ECE0(PC),A6
lin_vmak:
	BSR.W	mt_kbdrt
	BMI.S	lin_vmake
	MOVE.W	D0,(A6)
	BSR.S	lbC00E750
	ADD.W	#$0028,LineCurX
	LEA	2(A6),A6
	ADDQ.W	#1,D7
	CMP.W	lin_bufx(PC),D7
	BLE.S	lin_vmak
	BRA.W	lin_v1

lin_vmake:
	MOVE.W	#$FFF0,LineCurX
	CLR.W	LineCurY
	CALL   UpdateLineCurPos		;org bsr
	RTS

;***********************************

lbC00E750:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	NoteNamesPtr,A1
	MOVE.W	#$0171,D0
	MOVE.W	#$0071,D1
	LEA	lbW00ECD4(PC),A6
	MOVE.W	lin_bufx(PC),D7
	SUBQ.W	#1,D7
lbC00E76C:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	(A6),D2
	LSL.W	#2,D2
	LEA	0(A1,D2.W),A0
	MOVEQ	#3,D3
	CALL	Write_Text
	MOVEM.L (SP)+,D0-D7/A0-A6
	ADD.W	#$0028,D0
	LEA	2(A6),A6
	DBRA	D7,lbC00E76C
lbC00E790:
	CMP.L	#lbB00ECE0,A6
	BGT.S	lbC00E7B0
	LEA	fourspaces.msg(PC),A0
	MOVEQ	#3,D3
	CALL	Write_Text
	ADD.W	#$0028,D0
	LEA	2(A6),A6
	BRA.B	lbC00E790

lbC00E7B0:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

fourspaces.msg: dc.b	'    ',0,0


mt_kbdrt:
	MOVEM.L D1-D7/A0-A6,-(SP)
	CALL	WaitForButtonUp
	MOVE.W	#$0076,LineCurY
	CALL	UpdateLineCurPos	;org bsr
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
ChkEntESC:
	BSR.W	ResetKeyTimer
	BTST	#6,$00BFE001
	BEQ.S	lbC00E834
	checkrmb
	BEQ.S	lbC00E834
	CALL	DoKeyBuffer
	MOVEQ	#0,D1
	MOVE.B	RawKeyCode,D1
	BEQ.S	ChkEntESC
	CMP.B	#$44,D1 		;enter
	BEQ.S	lbC00E834
	CMP.B	#$45,D1 		;escape
	BEQ.S	lbC00E834
	CALL	CheckF1_F2		;org BSR check f1 & f2
	MOVE.B	RawKeyCode,D1
	LEA	RawKeyScaleTable,A0
	MOVEQ	#38,D0			;38 notes
.loo:
	CMP.B	0(A0,D0.W),D1
	BEQ.S	lbC00E842
	DBRA	D0,.loo
	BRA.S	ChkEntESC

lbC00E834:
	CALL	RestorePtrCol
	MOVEM.L (SP)+,D1-D7/A0-A6
	MOVEQ	#-1,D0
	RTS

lbC00E842:
	MOVE.L	KeyTransTabPtr,A0
	MOVE.B	0(A0,D0.W),D0
	AND.L	#$000000FF,D0
	MOVE.L	D0,-(SP)
	MOVE.L	EditMode,-(SP)
	CLR.L	EditMode
	CALL	CheckNoteKeys
	MOVE.L	(SP)+,EditMode
	MOVE.L	(SP)+,D0
	MOVEM.L (SP)+,D1-D7/A0-A6
	TST.L	D0
	RTS

lbC00E876:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVE.W	InstrNum(PC),D5
	MULU	#$001E,D5
	MOVE.W	4(A0,D5.L),lbW00ECC8
	MOVE.W	6(A0,D5.L),lbW00ECCA
	MOVEQ	#0,D6
	MOVE.B	2(A0,D5.L),D6
	AND.B	#15,D6
	MULU	#$004A,D6
	LEA	mt_periodtable,A0
	ADD.L	D6,A0
	MOVEQ	#$24,D2
	MOVE.L	D2,D3
	MOVE.L	D2,D4
	MOVE.L	D2,D5
	MOVE.L	D2,D6
	MOVE.W	lbW00ECD4(PC),D0
	MOVE.W	lbW00ECD6(PC),D1
	CMP.W	#3,lin_bufx
	BLT.S	smo_v1
	MOVE.W	lbW00ECD8(PC),D2
	CMP.W	#4,lin_bufx
	BLT.S	smo_v1
	MOVE.W	lbW00ECDA(PC),D3
	CMP.W	#5,lin_bufx
	BLT.S	smo_v1
	MOVE.W	lbW00ECDC(PC),D4
	CMP.W	#6,lin_bufx
	BLT.S	smo_v1
	MOVE.W	lbW00ECDE(PC),D5
	CMP.W	#7,lin_bufx
	BLT.S	smo_v1
	MOVE.W	lbB00ECE0(PC),D6
smo_v1:
	MOVEQ	#6,D7
smo_v2:
	CMP.W	D0,D1
	BPL.S	smo_v3
	EXG	D0,D1
smo_v3:
	CMP.W	D1,D2
	BPL.S	smo_v4
	EXG	D1,D2
smo_v4:
	CMP.W	D2,D3
	BPL.S	smo_v5
	EXG	D2,D3
smo_v5:
	CMP.W	D3,D4
	BPL.S	smo_v6
	EXG	D3,D4
smo_v6:
	CMP.W	D4,D5
	BPL.S	smo_v7
	EXG	D4,D5
smo_v7:
	CMP.W	D5,D6
	BPL.S	smo_vr
	EXG	D5,D6
smo_vr:
	DBRA	D7,smo_v2
	MOVE.W	D0,lbW00ECE2
	MOVE.W	D1,lbW00ECE4
	MOVE.W	D2,lbW00ECE6
	MOVE.W	D3,lbW00ECE8
	MOVE.W	D4,lbW00ECEA
	MOVE.W	D5,lbW00ECEC
	MOVE.W	D6,lbW00ECEE
	ADD.W	D0,D0
	ADD.W	D1,D1
	ADD.W	D2,D2
	ADD.W	D3,D3
	ADD.W	D4,D4
	ADD.W	D5,D5
	ADD.W	D6,D6
	MOVE.W	0(A0,D0.W),D0
	MOVE.W	0(A0,D1.W),D1
	MOVE.W	0(A0,D2.W),D2
	MOVE.W	0(A0,D3.W),D3
	MOVE.W	0(A0,D4.W),D4
	MOVE.W	0(A0,D5.W),D5
	MOVE.W	0(A0,D6.W),D6
	MOVE.W	D0,lbW00ECFA
	BNE.S	lbC00E992
	GOTO	SetErrorPtrCol

lbC00E992:
	MOVE.W	D1,lbW00ED06
	BNE.S	lbC00E9A0
	GOTO	SetErrorPtrCol

lbC00E9A0:
	MOVEQ	#2,D7
	MOVE.W	D2,lbW00ED12
	BEQ.S	lbC00E9D4
	ADDQ.W	#1,D7
	MOVE.W	D3,lbW00ED1E
	BEQ.S	lbC00E9D4
	ADDQ.W	#1,D7
	MOVE.W	D4,lbW00ED2A
	BEQ.S	lbC00E9D4
	ADDQ.W	#1,D7
	MOVE.W	D5,lbW00ED36
	BEQ.S	lbC00E9D4
	ADDQ.W	#1,D7
	MOVE.W	D6,lbW00ED42
	BEQ.S	lbC00E9D4
	ADDQ.W	#1,D7
lbC00E9D4:
	MOVE.W	D7,lbW00ECD2
	MOVE.W	InstrNum(PC),D5
	CMP.W	mt_samnum(PC),D5
	BNE.S	lbC00E9EA
	GOTO	SetErrorPtrCol

lbC00E9EA:
	LSL.W	#2,D5
	LEA	mt_songdataptr,A0
	ADD.W	D5,A0
	MOVE.L	$007C(A0),D4
	BNE.S	lbC00EA00
	GOTO	SetErrorPtrCol

lbC00EA00:
	MOVE.L	D4,mt_samomem
	MOVE.L	(A0),D0
	BNE.S	lbC00EA10
	GOTO	SetErrorPtrCol

lbC00EA10:
	MOVE.L	D0,lbL00ECBC
	MOVE.W	mt_samnum(PC),D5
	BNE.S	lbC00EA22
	GOTO	SetErrorPtrCol

lbC00EA22:
	LSL.W	#2,D5
	LEA	mt_songdataptr,A5
	ADD.W	D5,A5
	MOVE.L	(A5),D0
	BEQ.S	mt_ovwrsample
	LEA	OverwrSample.MSG(PC),A0
	CALL	AreYouSure
	BEQ.S	mt_ovwrsample
	RTS

mt_ovwrsample:
	MOVE.W	mt_samnum(PC),InsNum
	CALL	FreeSample
	MOVE.L	mt_samomem(PC),D0
	LEA	mt_songdataptr,A4
	MOVE.W	InsNum,D1
	LSL.W	#2,D1
	ADD.W	D1,A4
	MOVE.L	D0,$007C(A4)
	MOVE.L	4.w,a6
	MOVE.L	XDmaType,D1		;Changed to Public for Fast Replay!
	CALLSYS	AllocMem
	MOVE.L	D0,(A4)
	BEQ.W	OutOfMemErr
	MOVE.L	D0,lbL00ECC0
	MOVE.L	mt_songdataptr,A0
	MOVE.W	InstrNum,D0
	MULU	#$001E,D0
	MOVE.W	mt_samnum,D1
	MULU	#$001E,D1
	LEA	-10(A0),A0
	LEA	0(A0,D1.L),A1
	LEA	0(A0,D0.L),A0
	MOVE.L	A1,A2
	MOVEQ	#$1D,D0
lbC00EAAA:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,lbC00EAAA
	MOVE.L	A2,A0
	MOVEQ	#$13,D0
	TST.B	(A0)
	BEQ.S	lbC00EAF2
lbC00EAB8:
	TST.B	(A0)+
	BEQ.S	lbC00EAC2
	DBRA	D0,lbC00EAB8
	BRA.S	lbC00EAF6

lbC00EAC2:
	SUBQ.L	#1,A0
	ADDQ.W	#1,D0
	MOVE.W	lbW00ECD2(PC),D1
	SUBQ.W	#2,D1
	BMI.S	lbC00EAF2
	CMP.W	D1,D0
	BLT.S	lbC00EAF2
	LEA	lbW00ECE2(PC),A1
	MOVE.W	(A1)+,D2
lbC00EAD8:
	MOVE.W	(A1)+,D0
	SUB.W	D2,D0
	ADD.B	#$30,D0
	CMP.B	#$39,D0
	BLS.S	lbC00EAEA
	ADDQ.B	#8,D0
lbC00EAEA:
	MOVE.B	D0,(A0)+
	DBRA	D1,lbC00EAD8
	BRA.S	lbC00EAF6

lbC00EAF2:
	MOVE.B	#$23,(A0)
lbC00EAF6:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	LEA	Pleasewaitcom.MSG(PC),A0
	CALL	ShowStatusText
	MOVE.L	lbL00ECBC(PC),A0
	LEA	lbL00ECF0(PC),A6
	MOVE.L	A0,6(A6)
	MOVEQ	#0,D0
	MOVE.W	10(A6),D0
	MOVE.W	lbW00ECD2(PC),D7
	SUBQ.W	#2,D7
	BMI.S	lbC00EB34
	LEA	lbL00EC4C(PC),A5
lbC00EB2A:
	MOVE.L	(A5)+,A6
	BSR.S	lbC00EB92
	DBRA	D7,lbC00EB2A
lbC00EB34:
	MOVE.L	lbL00ECC0(PC),A5
	MOVE.L	mt_samomem(PC),D7
	MOVE.L	A0,A4
	ADD.L	D7,A4
	SUBQ.L	#2,D7
	MOVE.L	A4,D6
	CMP.W	#1,lbW00ECCA
	BLE.S	lbC00EB64
	MOVEQ	#0,D6
	MOVE.W	lbW00ECC8(PC),D6
	ADD.L	D6,D6
	ADD.L	A0,D6
	MOVEQ	#0,D0
	MOVE.W	lbW00ECCA(PC),D0
	ADD.L	D0,D0
	ADD.L	D6,D0
	MOVE.L	D0,A4
lbC00EB64:
	CLR.W	lbW00ECB8
	CLR.W	lbW00ECBA
	MOVEQ	#0,D0
	MOVE.B	D0,(A5)+
	MOVE.B	D0,(A5)+
	BSR.S	lbC00EBAA
	MOVE.W	mt_samnum(PC),InsNum
	BSR.W	ShowAllRight
	CALL	RestorePtrCol
	BSR.W	ShowSampleInfo
	GOTO	RedrawSample

lbC00EB92:
	MOVE.L	D0,D1
	MOVE.W	10(A6),D2
	DIVU	D2,D1
	MOVE.L	D1,(A6)
	LSR.W	#1,D2
	MOVE.W	D2,4(A6)
	MOVE.L	A0,6(A6)
	RTS

lbC00EBAA:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	MOVE.L	D0,-(SP)
	TST.W	D0
	BPL.S	lbC00EBB6
	NEG.W	D0
lbC00EBB6:
	CMP.W	lbW00ECB8,D0
	BMI.S	lbC00EBC4
	MOVE.W	D0,lbW00ECB8
lbC00EBC4:
	MOVE.L	(SP)+,D0
	LEA	lbL00EC48(PC),A3
	MOVE.W	lbW00ECD2(PC),D3
	SUBQ.W	#1,D3
lbC00EBD0:
	MOVE.L	(A3)+,A6
	BSR.S	lbC00EC18
	DBRA	D3,lbC00EBD0
	EXT.L	D0
	DIVS	lbW00ECD2(PC),D0
	CMP.W	#$FF80,D0
	BPL.S	lbC00EBE8
	MOVE.W	#$FF80,D0
lbC00EBE8:
	CMP.W	#$007F,D0
	BMI.S	lbC00EBF2
	MOVE.W	#$007F,D0
lbC00EBF2:
	MOVE.B	D0,(A5)+
	EXT.W	D0
	TST.W	D0
	BPL.S	lbC00EBFC
	NEG.W	D0
lbC00EBFC:
	CMP.W	lbW00ECBA,D0
	BMI.S	lbC00EC0A
	MOVE.W	D0,lbW00ECBA
lbC00EC0A:
	SUBQ.L	#1,D7
	BNE.S	lbC00EBAA
	TST.W	lbW00E57E
	BEQ.S	lbC00EC64
	RTS

lbC00EC18:
	MOVE.W	2(A6),D4
	MOVE.W	(A6),D5
	SUB.W	D5,4(A6)
	BCC.S	lbC00EC30
	MOVE.W	10(A6),D5
	ADD.W	D5,4(A6)
	ADDQ.W	#1,D4
lbC00EC30:
	MOVE.L	6(A6),A1
	ADD.W	D4,A1
	CMP.L	A4,A1
	BLT.S	lbC00EC3C
	MOVE.L	D6,A1
lbC00EC3C:
	MOVE.L	A1,6(A6)
	MOVE.B	(A1),D1
	EXT.W	D1
	ADD.W	D1,D0
	RTS

lbL00EC48:
	dc.l	lbL00ECF0
lbL00EC4C:
	dc.l	lbL00ECFC
	dc.l	lbL00ED08
	dc.l	lbL00ED14
	dc.l	lbL00ED20
	dc.l	lbL00ED2C
	dc.l	lbL00ED38

lbC00EC64:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	lbW00ECB8,D0
	MOVE.W	lbW00ECBA,D1
	MULU	#$0064,D0
	TST.W	D1
	BNE.S	lbC00EC82
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

lbC00EC82:
	DIVU	D1,D0
	MOVE.L	lbL00ECC0,A1
	MOVE.L	mt_samomem,D3
	SUBQ.L	#1,D3
lbC00EC92:
	MOVE.B	(A1),D1
	EXT.W	D1
	MULS	D0,D1
	DIVS	#$0064,D1
	CMP.W	#$007F,D1
	BLE.S	lbC00ECA4
	MOVEQ	#$7F,D1
lbC00ECA4:
	CMP.W	#$FF80,D1
	BGE.S	lbC00ECAC
	MOVEQ	#-$80,D1
lbC00ECAC:
	MOVE.B	D1,(A1)+
	DBRA	D3,lbC00EC92
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

lbW00ECB8:	dc.w	0
lbW00ECBA:	dc.w	0
lbL00ECBC:	dc.l	0
lbL00ECC0:	dc.l	0
mt_samomem:	dc.l	0
lbW00ECC8:	dc.w	0
lbW00ECCA:	dc.w	0
InstrNum:	dc.w	1
mt_samnum:	dc.w	2
lin_bufx:	dc.w	3
lbW00ECD2:	dc.w	0
lbW00ECD4:	dc.w	0
lbW00ECD6:	dc.w	0
lbW00ECD8:	dc.w	0
lbW00ECDA:	dc.w	0
lbW00ECDC:	dc.w	0
lbW00ECDE:	dc.w	0
lbB00ECE0:	dc.b	0,0
lbW00ECE2:	dc.w	0
lbW00ECE4:	dc.w	0
lbW00ECE6:	dc.w	0
lbW00ECE8:	dc.w	0
lbW00ECEA:	dc.w	0
lbW00ECEC:	dc.w	0
lbW00ECEE:	dc.w	0
lbL00ECF0:	dc.l	0,0
		dc.w	0
lbW00ECFA:	dc.w	0
lbL00ECFC:	dc.l	0,0
		dc.w	0
lbW00ED06:	dc.w	0
lbL00ED08:	dc.l	0,0
		dc.w	0
lbW00ED12:	dc.w	0
lbL00ED14:	dc.l	0,0
		dc.w	0
lbW00ED1E:	dc.w	0
lbL00ED20:	dc.l	0,0
		dc.w	0
lbW00ED2A:	dc.w	0
lbL00ED2C:	dc.l	0,0
		dc.w	0
lbW00ED36:	dc.w	0
lbL00ED38:	dc.l	0,0
		dc.w	0
lbW00ED42:	dc.w	0

OverwrSample.MSG:
		dc.b	10,10,' Overwrite the sample?',0
		EVEN
Pleasewaitcom.MSG:
		dc.b	'PLEASE WAIT, CALCULATING...',0
		dc.b	'ADJUSTING RESULT...',0
		EVEN

;***********************************
GetPositionPtr:
	MOVE.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D2
	LSL.L	#8,D2
	LSL.L	#2,D2
	chn8test
	BNE.S	no8mode27
	LSL.L	#1,D2
no8mode27:
	ADD.L	D2,A0
	MOVEQ	#0,D2
	MOVE.W	D0,D2
	DIVU	#6,D2
	LSL.W	#2,D2
	ADD.W	D2,A0
soklk:
	RTS

;***********************************

Opt7Change:
	ADDQ.W	#1,mt_TrackPattGad
	CMP.W	#4,mt_TrackPattGad
	BMI.S	ShowBlockMode
	CLR.W	mt_TrackPattGad


ShowBlockMode:
	cmp.w	#7,OptScrFlag
	bne.s	soklk			;4.0 fix

	cmp.w	#1,CurrScreen		;4.0 fix
	bne.b	soklk

	MOVE.W	mt_TrackPattGad(PC),D0
	LSL.W	#2,D0
	MOVE.L	TrackPattGad.TXT(PC,D0.W),A0
	MOVEQ	#8,D3
	MOVE.W	#$0189,D0
	MOVE.W	#$003A,D1
	GOTO	Wr_Message

TrackPattGad.TXT:
	dc.l	Track.MSG	;0
	dc.l	Patt.MSG	;1
	dc.l	Cmds.MSG	;2
	dc.l	Block.MSG	;3

Track.MSG:		dc.b	'Track   ',0,0
Patt.MSG:		dc.b	'Pattern ',0,0
Cmds.MSG:		dc.b	'Commands',0,0
Block.MSG:		dc.b	'Block   ',0,0
mt_TrackPattGad:	dc.w	0

;***********************************
SwitchRecMode:
	CALL	WaitForButtonUp
	MOVE.B	SampleAllFlag,D0
	NOT.B	D0
	MOVE.B	D0,SampleAllFlag	;for OMA 68030
ShowMRecMode:
	MOVEQ	#6,D3
	MOVE.W	#$0246,D0
	MOVEQ	#$3A,D1
	LEA	All.MSG(PC),A0
	TST.B	SampleAllFlag
	BNE.S	smesskl
	LEA	Single.MSG(PC),A0
smesskl:
	GOTO	Wr_Message

Single.MSG:	dc.b	'Single',0,0
All.MSG:	dc.b	'All   ',0,0

;************************************
Opt7RotateUp:
	ST	lbB00F49C
	BRA.S	lbC00EE4A

Opt7ScrollUp:
	SF	lbB00F49C
lbC00EE4A:
	SF	lbB00F49D
	SF	lbB00F49E
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	TST.W	mt_TrackPattGad
	BEQ.S	lbC00EEAE
	CMP.W	#2,mt_TrackPattGad
	BEQ.B	lbC00EEC2
	CMP.W	#3,mt_TrackPattGad
	BEQ.W	lbC00EEE8
	CMP.W	#1,mt_TrackPattGad
	BEQ.S	lbC00EE8A
	RTS

lbC00EE8A:
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00EF1A
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00EF1A
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00EF1A
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00EF1A
	chn8test
	BNE.S	lbC00EEAE
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00EF1A
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00EF1A
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00EF1A
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
lbC00EEAE:
	BSR.S	lbC00EF1A
	CALL	EndXOps
	CALL	RealRedrawPattern
	GOTO	EndXOps

lbC00EEC2:
	MOVE.W	PattCurPos,PattCurStore
	CLR.W	StartblockPos
	MOVE.W	#MaxPattPos-1,EndBlockPos
	ST	lbB00F49D
	SF	lbB00F49E
	BRA.S	lbC00EEF2

lbC00EEE8:
	CALL	GetMarkPointers
	BEQ.S	lbC00EEF2
	RTS

lbC00EEF2:
	MOVE.W	PattCurStore(PC),D0
	BSR.W	GetPositionPtr
	MOVE.W	StartblockPos(PC),D0
	LSL.W	#4,D0
	ADD.W	D0,A0
	MOVE.W	EndBlockPos(PC),D0
	SUBQ.W	#1,D0
	BSR.S	lbC00EF1C
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

lbC00EF1A:
	MOVEQ	#MaxPattPos,D0
lbC00EF1C:
	SUBQ.L	#1,D0
	BMI.W	lbC00EFA6
	MOVE.W	(A0),D1
	MOVE.W	2(A0),D2
	TST.B	lbB00F49C
	BNE.S	lbC00EF34
	MOVEQ	#0,D1
	MOVEQ	#0,D2
lbC00EF34:
	TST.B	lbB00F49D
	BNE.S	lbC00EF52
	chn8test
	BNE.S	no8mode140
	MOVE.W	$0020(A0),(A0)
	MOVE.W	$0022(A0),D3
	AND.W	#$F000,D3
	AND.W	#$0FFF,2(A0)
	OR.W	D3,2(A0)
	bra.s	lbC00EF52
no8mode140:
	MOVE.W	$0010(A0),(A0)
	MOVE.W	$0012(A0),D3
	AND.W	#$F000,D3
	AND.W	#$0FFF,2(A0)
	OR.W	D3,2(A0)
lbC00EF52:
	TST.B	lbB00F49E
	BNE.S	lbC00EF6C
	chn8test
	BNE.S	no8mode150
	MOVE.W	$0022(A0),D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,2(A0)
	OR.W	D3,2(A0)
	bra.s	lbC00EF6C
no8mode150:
	MOVE.W	$0012(A0),D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,2(A0)
	OR.W	D3,2(A0)
lbC00EF6C:
	LEA	$0010(A0),A0
	chn8test
	BNE.S	no8mode137
	LEA	$10(A0),A0
no8mode137:
	DBRA	D0,lbC00EF34
	TST.B	lbB00F49D
	BNE.S	lbC00EF8E
	MOVE.W	D1,(A0)
	AND.W	#$0FFF,2(A0)
	MOVE.W	D2,D3
	AND.W	#$F000,D3
	OR.W	D3,2(A0)
lbC00EF8E:
	TST.B	lbB00F49E
	BNE.S	lbC00EFA6
	MOVE.W	D2,D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,2(A0)
	OR.W	D2,2(A0)
lbC00EFA6:
	RTS

Opt7RotateDown:
	ST	lbB00F49C
	BRA.S	lbC00EFB8

Opt7ScrollDown:
	SF	lbB00F49C
lbC00EFB8:
	SF	lbB00F49D
	SF	lbB00F49E
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	TST.W	mt_TrackPattGad
	BEQ.S	lbC00F01C
	CMP.W	#2,mt_TrackPattGad
	BEQ.S	lbC00F030
	CMP.W	#3,mt_TrackPattGad
	BEQ.W	  lbC00F056
	CMP.W	#1,mt_TrackPattGad
	BEQ.S	lbC00EFF8
	RTS

lbC00EFF8:
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F088
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.W	  lbC00F088
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.W	  lbC00F088
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F088
	chn8test
	BNE.S	lbC00F01C
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F088
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F088
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F088
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
lbC00F01C:
	BSR.S	lbC00F088
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

lbC00F030:
	MOVE.W	PattCurPos,PattCurStore
	CLR.W	StartblockPos
	MOVE.W	#$0040,EndBlockPos
	ST	lbB00F49D
	SF	lbB00F49E
	BRA.S	lbC00F060

lbC00F056:
	CALL	GetMarkPointers
	BEQ.S	lbC00F060
	RTS

lbC00F060:
	MOVE.W	PattCurStore(PC),D0
	BSR.W	GetPositionPtr
	MOVE.W	StartblockPos(PC),D0
	LSL.W	#4,D0
	ADD.W	D0,A0
	MOVE.W	EndBlockPos(PC),D0
	SUBQ.W	#1,D0
	BSR.S	lbC00F08A
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

lbC00F088:
	MOVEQ	#MaxPattPos,D0
lbC00F08A:
	SUBQ.L	#1,D0
	BMI.W	lbC00F11E
	MOVE.L	D0,D3
	LSL.L	#4,D3
	chn8test
	BNE.S	no8mode153
	LSL.L	#1,D3
no8mode153:
	ADD.L	D3,A0
	chn8test
	BNE.S	no8mode141
	MOVE.W	$0020(A0),D1
	MOVE.W	$0022(A0),D2
no8mode141:
	MOVE.W	$0010(A0),D1
	MOVE.W	$0012(A0),D2
	TST.B	lbB00F49C
	BNE.S	lbC00F0AA
	MOVEQ	#0,D1
	MOVEQ	#0,D2
lbC00F0AA:
	TST.B	lbB00F49D
	BNE.S	lbC00F0C8
	chn8test
	BNE.S	no8mode142
	MOVE.W	(A0),$0020(A0)
	MOVE.W	2(A0),D3
	AND.W	#$F000,D3
	AND.W	#$0FFF,$0022(A0)
	OR.W	D3,$0022(A0)
	bra.s	lbC00F0C8
no8mode142:
	MOVE.W	(A0),$0010(A0)
	MOVE.W	2(A0),D3
	AND.W	#$F000,D3
	AND.W	#$0FFF,$0012(A0)
	OR.W	D3,$0012(A0)
lbC00F0C8:
	TST.B	lbB00F49E
	BNE.S	lbC00F0E2
	chn8test
	BNE.S	no8mode151
	MOVE.W	2(A0),D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,$0022(A0)
	OR.W	D3,$0022(A0)
	bra.s	lbC00F0E2
no8mode151:
	MOVE.W	2(A0),D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,$0012(A0)
	OR.W	D3,$0012(A0)
lbC00F0E2:
	LEA	-$0010(A0),A0
	chn8test
	BNE.S	no8mode138
	LEA	-$10(A0),A0
no8mode138:
	DBRA	D0,lbC00F0AA
	TST.B	lbB00F49D
	BNE.S	lbC00F106
	chn8test
	BNE.S	no8mode143
	MOVE.W	D1,$0020(A0)
	AND.W	#$0FFF,$0022(A0)
	MOVE.W	D2,D3
	AND.W	#$F000,D3
	OR.W	D3,$0022(A0)
	bra.s	lbC00F106
no8mode143:
	MOVE.W	D1,$0010(A0)
	AND.W	#$0FFF,$0012(A0)
	MOVE.W	D2,D3
	AND.W	#$F000,D3
	OR.W	D3,$0012(A0)
lbC00F106:
	TST.B	lbB00F49E
	BNE.S	lbC00F11E
	MOVE.W	D2,D3
	AND.W	#$0FFF,D3
	chn8test
	BNE.S	no8mode152
	AND.W	#$F000,$0022(A0)
	OR.W	D2,$0022(A0)
	RTS
no8mode152:
	AND.W	#$F000,$0012(A0)
	OR.W	D2,$0012(A0)
lbC00F11E:
	RTS

Opt7Flip:
	SF	lbB00F49D
	SF	lbB00F49E
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	TST.W	mt_TrackPattGad
	BEQ.S	mt_fliptrack
	CMP.W	#2,mt_TrackPattGad
	BEQ.S	mt_flipcommands
	CMP.W	#3,mt_TrackPattGad
	BEQ.W	mt_flipblock
	CMP.W	#1,mt_TrackPattGad
	BEQ.S	mt_flippattern
	RTS

mt_flippattern:
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.W	mt_flip1track
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.W	mt_flip1track
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.W	mt_flip1track
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.W	mt_flip1track

	chn8test
	BNE.S	mt_fliptrack

	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.W	mt_flip1track
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	mt_flip1track
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	mt_flip1track
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
mt_fliptrack:
	BSR.S	mt_flip1track
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

mt_flipcommands:
	MOVE.W	PattCurPos,PattCurStore
	CLR.W	StartblockPos
	MOVE.W	#MaxPattPos+1,EndBlockPos
	ST	lbB00F49D
	SF	lbB00F49E
	BRA.S	mt_flipbln

mt_flipblock:
	CALL	GetMarkPointers
	BEQ.S	mt_flipbln
	RTS

mt_flipbln:
	MOVE.W	PattCurStore(PC),D0
	BSR.W	GetPositionPtr		;leeh
	MOVE.W	StartblockPos(PC),D0
	LSL.W	#4,D0
	ADD.W	D0,A0
	MOVE.W	EndBlockPos(PC),D0
	SUBQ.W	#1,D0
	BSR.S	mt_flip1tr
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

;*****************************
mt_flip1track:
	MOVEQ	#MaxPattPos,D0		; whole track
mt_flip1tr:
	LEA	vartrackbuffer,A1
	MOVE.L	A0,A2
	MOVE.L	A1,A3
	MOVE.L	D0,D1
cltrbuf:
	MOVE.L	(A2),(A3)+
	LEA	$0010(A2),A2
	chn8test
	BNE.S	no8mode130
	LEA	$0010(A2),A2
no8mode130:
	DBRA	D1,cltrbuf
	MOVE.L	D0,D1
	LSL.L	#2,D1
	ADD.L	D1,A1

lbC00F20E:
	TST.B	lbB00F49D
	BNE.S	lbC00F22A
	MOVE.W	(A1),(A0)
	MOVE.W	2(A1),D3
	AND.W	#$F000,D3
	AND.W	#$0FFF,2(A0)
	OR.W	D3,2(A0)
lbC00F22A:
	TST.B	lbB00F49E
	BNE.S	lbC00F244
	MOVE.W	2(A1),D3
	AND.W	#$0FFF,D3
	AND.W	#$F000,2(A0)
	OR.W	D3,2(A0)
lbC00F244:
	chn8test
	BNE.S	no8mode131
	LEA	$0010(A0),A0
no8mode131:
	LEA	$0010(A0),A0
	LEA	-4(A1),A1
	DBRA	D0,lbC00F20E
	RTS

;*********************************

Opt7Clear:
	SF	lbB00F49D
	SF	lbB00F49E
	MOVE.W	PattCurPos,D0
	CALL	GetPositionPtr
	TST.W	mt_TrackPattGad
	BEQ.S	lbC00F2B8
	CMP.W	#2,mt_TrackPattGad
	BEQ.S	lbC00F2CC
	CMP.W	#3,mt_TrackPattGad
	BEQ.W	lbC00F2F2
	CMP.W	#1,mt_TrackPattGad
	BEQ.S	lbC00F294
	RTS

lbC00F294:
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F318
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F318
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F318
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.W	lbC00F318
	chn8test
	BNE.S	lbC00F2B8
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.B	lbC00F318
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F318
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F318
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
lbC00F2B8:
	BSR.S	lbC00F318
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	GOTO	EndXOps

lbC00F2CC:
	MOVE.W	PattCurPos,PattCurStore
	CLR.W	StartblockPos
	MOVE.W	#MaxPattPos+1,EndBlockPos
	ST	lbB00F49D
	SF	lbB00F49E
	BRA.S	lbC00F2FC

lbC00F2F2:
	CALL	GetMarkPointers
	BEQ.S	lbC00F2FC
	RTS

lbC00F2FC:
	MOVE.W	PattCurStore(PC),D0
	BSR.W	GetPositionPtr
	MOVE.W	StartblockPos(PC),D0
	LSL.W	#4,D0


	ADD.W	D0,A0
	MOVE.W	EndBlockPos(PC),D0
	SUBQ.W	#1,D0
	BSR.S	lbC00F31A
	BRA.W	RedrawPattern

lbC00F318:
	MOVEQ	#MaxPattPos,D0
lbC00F31A:
	TST.B	lbB00F49D
	BNE.S	lbC00F32A
	CLR.W	(A0)
	AND.W	#$0FFF,2(A0)
lbC00F32A:
	TST.B	lbB00F49E
	BNE.S	lbC00F338
	AND.W	#$F000,2(A0)
lbC00F338:
	chn8test
	BNE.S	no8mode132
	LEA	$0010(A0),A0
no8mode132:
	LEA	$0010(A0),A0
	DBRA	D0,lbC00F31A
	RTS


;*********************************
;* marked block commands main    *
;*********************************	;3.15
xCutBlock:
	CMP.W	#3,mt_TrackPattGad
	BEQ.S	xcutpbl
	RTS

xcutpbl:
	BSR.S	xCopyBlock
	BSR.W	Opt7Clear
	RTS

xCopyBlock:
	SF	lbB00F49D
	SF	lbB00F49E
	CMP.W	#3,mt_TrackPattGad
	BEQ.S	xcopbl
	RTS

xcopbl:
	CALL	GetMarkPointers
	BEQ.S	xcopbln
	RTS

xcopbln:
	MOVE.W	PattCurStore(PC),D0
	BSR.W	GetPositionPtr
	MOVE.W	StartblockPos(PC),D0
	LSL.W	#4,D0

	chn8test
	bne.s	nohhk
	lsl.w	#1,d0
nohhk:

	ADD.W	D0,A0
	MOVE.W	EndBlockPos(PC),D0
	SUBQ.W	#1,D0
	BSR.S	lbC00F3B2
	ST	MarkBufferFull
	MOVE.B	lbB00F49D(PC),lbB00F4A0
	MOVE.B	lbB00F49E(PC),lbB00F4A1
	MOVE.W	EndBlockPos(PC),SEndBlockPos
	RTS

lbC00F3B2:
	LEA	Blocks2Buffer,A1
lbC00F3B8:
	TST.B	lbB00F49D
	BNE.S	lbC00F3CE
	MOVE.W	(A0),(A1)
	MOVE.W	2(A0),D1
	AND.W	#$F000,D1
	MOVE.W	D1,2(A1)
lbC00F3CE:
	TST.B	lbB00F49E
	BNE.S	lbC00F3E8
	MOVE.W	2(A0),D1
	AND.W	#$0FFF,D1
	AND.W	#$F000,2(A1)
	OR.W	D1,2(A1)
lbC00F3E8:
	chn8test
	BNE.S	no8mode133
	LEA	$10(A0),A0
no8mode133:
	LEA	$0010(A0),A0
	LEA	4(A1),A1
	DBRA	D0,lbC00F3B8
	RTS

;*********************************

xPasteBlock:
	CMP.W	#3,mt_TrackPattGad
	BEQ.S	xpasbl1
	RTS

xpasbl1:
	TST.B	MarkBufferFull
	BNE.S	xpasbl2
	RTS

xpasbl2:
	MOVE.W	PattCurPos,D0
	BSR.W	GetPositionPtr
	MOVE.W	ScrPattPos,D0
	LSL.W	#4,D0

	chn8test
	bne.s	nohhj
	lsl.w	#1,d0			;4.0
nohhj:

	ADD.W	D0,A0
	MOVE.W	SEndBlockPos(PC),D0	;stored from xcopy
	MOVE.W	D0,D1
	ADD.W	ScrPattPos,D1

	CMP.W	#MaxPattPos+1,D1
	BMI.S	xpasspos

	SUB.W	#MaxPattPos+1,D1
	SUB.W	D1,D0

xpasspos:
	SUBQ.W	#1,D0
	BMI.S	xpasend
	BSR.S	xpassnn
	CALL	EndXOps
	BSR.W	RealRedrawPattern
	CALL	EndXOps
xpasend:
	RTS

xpassnn:
	LEA	Blocks2Buffer,A1
xpassnd:
	TST.B	lbB00F4A0
	BNE.S	lbC00F46C
	MOVE.W	(A1),(A0)
	MOVE.W	2(A1),D1
	AND.W	#$F000,D1
	MOVE.W	D1,2(A0)
lbC00F46C:
	TST.B	lbB00F4A1
	BNE.S	lbC00F486
	MOVE.W	2(A1),D1
	AND.W	#$0FFF,D1
	AND.W	#$F000,2(A0)
	OR.W	D1,2(A0)
lbC00F486:
	chn8test
	BNE.S	no8mode134
	LEA	$10(A0),A0
no8mode134:
	LEA	$0010(A0),A0
	LEA	4(A1),A1
	DBRA	D0,xpassnd
	RTS

PattCurStore:	dc.w	0
StartblockPos:	dc.w	0
EndBlockPos:	dc.w	0
SEndBlockPos:	dc.w	0
lbB00F49C:	dc.b	0
lbB00F49D:	dc.b	0
lbB00F49E:	dc.b	0
MarkBufferFull:	dc.b	0
lbB00F4A0:	dc.b	0
lbB00F4A1:	dc.b	0

;*********************************
Opt7OctUp:
	CMP.W	#1,mt_TrackPattGad
	BLS.S	xoctup1
	RTS

xoctup1:
	MOVEQ	#0,D0
	TST.W	mt_TrackPattGad
	BEQ.S	xoctup2
	MOVE.W	#$012C,D0
xoctup2:
	MOVE.W	#$0018,NoteShift
	BRA.S	xnotup3

Opt7NoteUp:
	CMP.W	#1,mt_TrackPattGad
	BLS.S	xnotup1
	RTS

xnotup1:
	MOVEQ	#0,D0
	TST.W	mt_TrackPattGad
	BEQ.S	xnotup2
	MOVE.W	#$012C,D0
xnotup2:
	MOVE.W	#2,NoteShift
xnotup3:
	CALL	SaveUndo
	CMP.W	#$00D6,D0
	BLS.S	xnotup4
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4

	chn8test
	BNE.S	xnotup4

	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	xcnotup4
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
xnotup4:
	BSR.S	xcnotup4
	BRA.W	RedrawPattern

xcnotup4:
	MOVEQ	#MaxPattPos,D6
	MOVE.L	A0,A3
	MOVE.W	InsNum,D3
	TST.B	SampleAllFlag
	BEQ.S	sanulo2
	MOVEQ	#0,D3
sanulo2:
	MOVE.L	D6,D0
	MOVE.L	A3,A0
xcnotup3:
	TST.B	SampleAllFlag
	BNE.S	xcnotup2
	MOVE.B	2(A0),D1
	LSR.B	#4,D1


	MOVE.B	(A0),D2
	AND.B	#$F0,D2
	OR.B	D2,D1
	CMP.B	D3,D1
	BNE.S	xcnotup6
xcnotup2:
	MOVE.W	(A0),D1
	MOVE.W	D1,D2
	AND.W	#$F000,D2
	AND.W	#$0FFF,D1
	BEQ.S	xcnotup6
	BSR.W	lbC00F672
	BNE.S	xcnotup6
	ADD.W	NoteShift(PC),D5
	CMP.W	#$0048,D5
	BCS.S	xcnotup5
	BTST	#1,CutToBufFlag
	BEQ.S	xcnotup6
	AND.L	#$00000FFF,(A0)
	BRA.S	xcnotup6

xcnotup5:
	MOVE.W	0(A2,D5.W),D1
	OR.W	D2,D1
	MOVE.W	D1,(A0)
xcnotup6:
	chn8test
	BNE.S	no8mode120
	LEA	$0020(A0),A0
	DBRA	D0,xcnotup3
	RTS
no8mode120:
	LEA	$0010(A0),A0
	DBRA	D0,xcnotup3
	RTS


;*********************************

Opt7OctDown:
	CMP.W	#1,mt_TrackPattGad
	BLS.S	lbC00F598
	RTS

lbC00F598:
	MOVEQ	#0,D0
	TST.W	mt_TrackPattGad
	BEQ.S	lbC00F5A6
	MOVE.W	#$012C,D0
lbC00F5A6:
	MOVE.W	#$0018,NoteShift
	BRA.S	lbC00F5D2

Opt7NoteDown:
	CMP.W	#1,mt_TrackPattGad
	BLS.S	lbC00F5BC
	RTS

lbC00F5BC:
	MOVEQ	#0,D0
	TST.W	mt_TrackPattGad
	BEQ.S	lbC00F5CA
	MOVE.W	#$012C,D0
lbC00F5CA:
	MOVE.W	#2,NoteShift
lbC00F5D2:
	CALL	SaveUndo
	CMP.W	#$00D6,D0
	BLS.S	lbC00F5FC
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	chn8test
	BNE.S	lbC00F5FC
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	lbC00F602
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
lbC00F5FC:
	BSR.S	lbC00F602
	BRA.W	RedrawPattern

lbC00F602:
	MOVEQ	#MaxPattPos,D6
	MOVE.L	A0,A3
	MOVE.W	InsNum,D3
	TST.B	SampleAllFlag
	BEQ.S	sandlo2
	MOVEQ	#0,D3
sandlo2:
	MOVE.W	D6,D0
	MOVE.L	A3,A0
lbC00F61A:
	TST.B	SampleAllFlag
	BNE.S	lbC00F634
	MOVE.B	2(A0),D1
	LSR.B	#4,D1
	MOVE.B	(A0),D2
	AND.B	#$F0,D2
	OR.B	D2,D1
	CMP.B	D1,D3
	BNE.S	lbC00F666
lbC00F634:
	MOVE.W	(A0),D1
	MOVE.W	D1,D2
	AND.W	#$F000,D2
	AND.W	#$0FFF,D1
	BEQ.S	lbC00F666
	BSR.S	lbC00F672
	BNE.S	lbC00F666
	SUB.W	NoteShift(PC),D5
	BPL.S	lbC00F65E
	BTST	#1,CutToBufFlag
	BEQ.S	lbC00F666
	AND.L	#$00000FFF,(A0)
	BRA.S	lbC00F666

lbC00F65E:
	MOVE.W	0(A2,D5.W),D1
	OR.W	D2,D1
	MOVE.W	D1,(A0)
lbC00F666:
	chn8test
	BNE.S	no8mode121
	LEA	$0020(A0),A0
	DBRA	D0,lbC00F61A
	RTS
no8mode121:
	LEA	$0010(A0),A0
	DBRA	D0,lbC00F61A
	RTS

lbC00F672:
	LEA	mt_periodtable,A2
	MOVEQ	#-2,D5
lbC00F67A:
	ADDQ.L	#2,D5
	MOVE.W	0(A2,D5.W),D4
	BEQ.S	lbC00F68C
	CMP.W	D4,D1
	BEQ.S	lbC00F688
	BRA.S	lbC00F67A

lbC00F688:
	MOVEQ	#0,D4
	RTS

lbC00F68C:
	MOVEQ	#-1,D4
	RTS

NoteShift:	dc.w	0

;*******************************
;* pattern/sample/track toggle *
;*******************************

sam_togmode:
	CALL	WaitForButtonUp
	ADDQ.B	#1,sam_editflag
	CMP.B	#3,sam_editflag
	BCS.S	sam_togmodeshow
	CLR.B	sam_editflag
sam_togmodeshow:
	MOVE.W	#$016C,D0
	MOVEQ	#$3A,D1
	MOVEQ	#7,D3
	TST.B	sam_editflag
	BNE.S	sam_togsmodpatt
	LEA	Track.MSG0(PC),A0
	GOTO	Wr_Message

sam_togsmodpatt:
	CMP.B	#1,sam_editflag
	BNE.S	sam_togsshrt
	LEA	Pattern.MSG0(PC),A0
	GOTO	Wr_Message

sam_togsshrt:
	LEA	Sample.MSG(PC),A0
	GOTO	Wr_Message

Track.MSG0:	dc.b	' Track ',0
Pattern.MSG0:	dc.b	'Pattern',0
Sample.MSG:	dc.b	' Sample',0

;***********************************
KillInstrTrack:
	CALL	SaveUndo
	MOVE.W	PattCurPos,D0
	BSR.W	GetPositionPtr
	BRA.S	sam_del1

;******************************
sam_delete:
	CALL	SaveUndo
	TST.B	sam_editflag
	BEQ.S	sam_del1		;track del
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	chn8test
	BNE.S	sam_del1
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_delcalc
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
sam_del1:
	BSR.S	sam_delcalc
	BRA.W	RedrawPattern

sam_delcalc:
	MOVEQ	#MaxPattPos,D0
	MOVE.W	InsNum,D3
	BEQ.W	NotSampleNull
sam_delcala:
	MOVE.B	2(A0),D1
	LSR.B	#4,D1
	MOVE.B	(A0),D2
	AND.B	#$F0,D2
	OR.B	D2,D1
	CMP.B	D1,D3
	BNE.S	sam_delcalb
	CLR.L	(A0)
sam_delcalb:
	LEA	$0010(A0),A0
	chn8test
	BNE.S	no8mode135
	LEA	$10(a0),a0
no8mode135:
	DBRA	D0,sam_delcala
	RTS


;***********************************
;* killsample gadget in sampoptions*
;***********************************

KillSample:
	LEA	Killthissampl.MSG,A0
	CALL	AreYouSure
	BEQ.S	Destroy
	RTS

Destroy:
	CALL	StorePtrCol
	MOVE.W	InsNum,D0
	BNE.S	mt_killsample
	GOTO	ErrorRestoreCol

mt_killsample:
	BSR.W	TurnOffVoices
	BSR.W	FreeSample
	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	MULU	#30,D0
	LEA	-10(A0),A0
	ADD.L	D0,A0
	MOVE.L	A0,A1
	MOVEQ	#30-1,D0
.loo:
	CLR.B	(A0)+
	DBRA	D0,.loo

	MOVE.W	#1,n_tremolocmd(A1)
	BSR.W	ShowSampleInfo
	CALL	RedrawSample
	GOTO	RestorePtrCol

;***********************************
;* exchange, swap 2 samplepositions*
;* 1x called from opt2             *
;***********************************

sam_exchange:
	CMP.B	#2,sam_editflag
	BEQ.W	sam_exerrrt
	MOVEQ	#0,D4
	BRA.S	sam_exchbg

sam_exchg:
	CMP.B	#2,sam_editflag
	BEQ.W	lbC00F908
sam_exchbg:
	TST.B	sam_editflag
	BEQ.S	sam_exrt
	MOVEQ	#0,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#6,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#12,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#18,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	chn8test
	BNE.S	sam_exrt
	MOVEQ	#24,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#30,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#36,D0
	BSR.W	GetPositionPtr
	BSR.S	sam_exchcal
	MOVEQ	#42,D0
	BSR.W	GetPositionPtr
sam_exrt:
	BSR.S	sam_exchcal
	BRA.W	RedrawPattern

sam_exchcal:
	MOVEQ	#MaxPattPos,D0
sam_exlop:
	MOVE.B	2(A0),D1
	LSR.B	#4,D1
	MOVE.B	(A0),D2
	AND.B	#$F0,D2
	OR.B	D2,D1
	CMP.B	bu_InsNum1(PC),D1
	BNE.S	sam_exlgog
	AND.L	#$0FFF0FFF,(A0)
	MOVE.B	bu_InsNum(PC),D2
	MOVE.B	D2,D3
	AND.B	#$F0,D2
	OR.B	D2,(A0)
	LSL.B	#4,D3
	OR.B	D3,2(A0)
	BRA.S	sam_exlbgf

sam_exlgog:
	TST.B	D4
	BNE.S	sam_exlbgf
	CMP.B	bu_InsNum(PC),D1
	BNE.S	sam_exlbgf
	AND.L	#$0FFF0FFF,(A0)
	MOVE.B	bu_InsNum1(PC),D2
	MOVE.B	D2,D3
	AND.B	#$F0,D2
	OR.B	D2,(A0)
	LSL.B	#4,D3
	OR.B	D3,2(A0)
sam_exlbgf:
	LEA	$0010(A0),A0
	chn8test
	BNE.S	.chn4
	LEA	$10(a0),A0

.chn4:	DBRA	D0,sam_exlop
	RTS

;******************

sam_exerrrt:
	CALL	StorePtrCol
	MOVEQ	#0,D0
	MOVE.B	bu_InsNum1(PC),D0
	BNE.S	.l1
	GOTO	ErrorRestoreCol

.l1:	MOVEQ	#0,D1
	MOVE.B	bu_InsNum(PC),D1
	BNE.S	.l2
	GOTO	ErrorRestoreCol

.l2:	MOVE.W	D0,D2
	MOVE.W	D1,D3
	LEA	SamplePointers+2,A2		;(Sample 1 Pointer)
	LSL.W	#1,D2
	LSL.W	#1,D3
	LEA	0(A2,D2.W),A0
	LEA	0(A2,D3.W),A1
	MOVE.W	(A0),D4
	MOVE.W	(A1),(A0)
	MOVE.W	D4,(A1)
	LEA	mt_songdataptr,A2
	LSL.W	#1,D2
	LSL.W	#1,D3
	LEA	0(A2,D2.W),A0
	LEA	0(A2,D3.W),A1
	MOVE.L	(A0),D4
	MOVE.L	(A1),(A0)
	MOVE.L	D4,(A1)
	MOVE.L	$7C(A0),D4
	MOVE.L	$7C(A1),$007C(A0)
	MOVE.L	D4,$007C(A1)
	SUBQ.W	#1,D0
	SUBQ.W	#1,D1
	MULU	#30,D0
	MULU	#30,D1
	MOVE.L	mt_songdataptr,A2
	LEA	20(A2),A2
	LEA	0(A2,D0.W),A0
	LEA	0(A2,D1.W),A1

	MOVEQ	#MaxInsNum-2,D0

.lop:	MOVE.B	(A0),D1
	MOVE.B	(A1),(A0)+
	MOVE.B	D1,(A1)+
	DBRA	D0,.lop

	BSR.W	ShowSampleInfo
	CALL	RedrawSample
	GOTO	RestorePtrCol

lbC00F908:
	CALL	StorePtrCol
	MOVEQ	#0,D0
	MOVE.B	bu_InsNum1(PC),D0
	BNE.S	.l1
	GOTO	ErrorRestoreCol

.l1:	MOVEQ	#0,D1
	MOVE.B	bu_InsNum(PC),D1
	BNE.S	.l2
	GOTO	ErrorRestoreCol

.l2:	LEA	mt_songdataptr,A2
	LSL.W	#2,D0
	LSL.W	#2,D1
	LEA	0(A2,D0.W),A3
	LEA	0(A2,D1.W),A4
	MOVE.L	(A3),D0
	BNE.S	.l3
	GOTO	ErrorRestoreCol

.l3:	MOVE.L	$7C(A3),D0
	MOVE.L	XDmaType,D1		;Changed to Public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	TST.L	D0
	BEQ.W	OutOfMemErr
	MOVE.L	D0,A5
	MOVEQ	#0,D0
	MOVE.B	bu_InsNum(PC),D0
	MOVE.W	D0,InsNum
	BSR.W	Destroy
	MOVE.L	A5,(A4)
	MOVE.L	$7C(A3),D0
	MOVE.L	D0,$007C(A4)
	MOVE.L	(A3),A0
lbC00F97C:
	MOVE.B	(A0)+,(A5)+
	SUBQ.L	#1,D0
	BNE.S	lbC00F97C
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.B	bu_InsNum1(PC),D0
	MOVE.B	bu_InsNum(PC),D1
	MOVE.W	D1,InsNum
	MULU	#30,D0
	MULU	#30,D1
	MOVE.L	mt_songdataptr,A2
	LEA	-10(A2),A2
	LEA	0(A2,D0.W),A0
	LEA	0(A2,D1.W),A1
	MOVEQ	#MaxInsNum-2,D0

.loop:	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.loop

	BSR.W	ShowSampleInfo
	CALL	RedrawSample
	GOTO	RestorePtrCol

;---
lbC00F9C4:
	MOVE.W	InsNum,D2
	BRA.S	lbC00F9D8

lbC00F9CE:
	MOVE.B	bu_InsNum1(PC),D2
	SUBQ.B	#1,D2
	BPL.S	lbC00F9D8
	MOVEQ	#0,D2
lbC00F9D8:
	MOVE.B	D2,bu_InsNum1
	BSR.W	Wait_4000
	BRA.S	lbC00F9F8

;---
lbC00F9E4:
	MOVE.B	bu_InsNum1(PC),D2
	ADDQ.B	#1,D2
	CMP.B	#MaxInsNum,D2
	BLS.S	lbC00F9D8
	MOVE.B	#MaxInsNum,bu_InsNum1
lbC00F9F8:
	MOVE.W	#$1CA3,TextOffset
	CLR.W	WordNumber
	MOVE.B	bu_InsNum1(PC),WordNumber+1
	BRA.W	PrintHexByte

lbC00FA12:
	MOVE.W	InsNum,D2
	BRA.S	sallk

lbC00FA1C:
	MOVE.B	bu_InsNum(PC),D2
	SUBQ.B	#1,D2
	BPL.S	sallk
	MOVEQ	#0,D2

sallk:	MOVE.B	D2,bu_InsNum
	BSR.W	Wait_4000
	BRA.S	lbC00FA46

;---
lbC00FA32:
	MOVE.B	bu_InsNum(PC),D2
	ADDQ.B	#1,D2
	CMP.B	#MaxInsNum,D2
	BLS.S	sallk
	MOVE.B	#MaxInsNum,bu_InsNum
lbC00FA46:
	MOVE.W	#$2013,TextOffset
	CLR.W	WordNumber
	MOVE.B	bu_InsNum(PC),WordNumber+1
	BRA.W	PrintHexByte

bu_InsNum1:	dc.b	0
bu_InsNum:	dc.b	0


lbC00FA62:
	CALL	WaitForButtonUp
	EOR.B	#1,RecordMode
lbC00FA70:
	MOVE.W	#$0246,D0
	MOVEQ	#$45,D1
	MOVEQ	#7,D3
	LEA	Pattern.MSG1(PC),A0
	TST.B	RecordMode
	BEQ.S	lbC00FA88
	LEA	Song.MSG(PC),A0
lbC00FA88:
	GOTO	Wr_Message

Pattern.MSG1:	dc.b	'Pattern',0
Song.MSG:	dc.b	'Song   ',0
RecordMode:	dc.b	0
QuantizeValue:	dc.b	1
MetroSpeed:	dc.b	4
MetroChannel:	dc.b	0
MultiFlag:	dc.b	0
SampleAllFlag:	dc.b	$FF
sam_editflag:	dc.b	0,0
AbortDecFlag:	dc.w	0

;***********************************
Get2DigitKeys:
	MOVE.W	#1,AbortDecFlag
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	CALL	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	lbC00FAFC
	MOVE.B	D1,D0
	MULU	#10,D0
	MOVE.B	D0,lbB017E94
	BSR.W	mt_clarconv
	ADDQ.W	#8,LineCurX
	CALL	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	lbC00FAFC
	ADD.B	D1,lbB017E94
	CLR.W	AbortDecFlag
lbC00FAFC:
	MOVE.W	#$FFF0,LineCurX
	CLR.W	LineCurY
	CALL	UpdateLineCurPos
	CALL	RestorePtrCol
	MOVEQ	#0,d0
	MOVE.B	lbB017E94,D0
	RTS

lbC00FB1E:
	MOVE.W	#1,AbortDecFlag
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	CALL	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	lbC00FB7C
	MOVE.B	D1,D0
	MULU	#10,D0
	MOVE.B	D0,lbB017E94
	MOVE.L	D1,D3
	MOVE.W	D4,D0
	MOVE.W	D5,D1
	BSR.W	mt_clarconv1
	MOVE.L	D3,D1
	ADDQ.W	#8,LineCurX
	CALL	UpdateLineCurPos
	BSR.W	GetKey0_9
	CMP.B	#$44,D1
	BEQ.S	lbC00FB7C
	ADD.B	D1,lbB017E94
	CLR.W	AbortDecFlag
lbC00FB7C:
	MOVE.W	#$FFF0,LineCurX
	CLR.W	LineCurY
	CALL	UpdateLineCurPos
	CALL	RestorePtrCol
	MOVE.B	lbB017E94,D0
	RTS

lbC00FB9E:
	CALL	Wait_4000
	MOVEQ	#0,D0
	MOVE.B	QuantizeValue(PC),D0
	ADDQ.W	#1,D0
	BRA.S	lbC00FBE8

lbC00FBAE:
	CALL	Wait_4000
	MOVEQ	#0,D0
	MOVE.B	QuantizeValue(PC),D0
	SUBQ.W	#1,D0
	BPL.S	lbC00FBC0
	MOVEQ	#0,D0
lbC00FBC0:
	BRA.S	lbC00FBE8

lbC00FBC2:
	MOVE.W	#$01B4,LineCurX
	MOVE.W	#$003F,LineCurY
	MOVE.W	#$1256,TextOffset
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.S	lbC00FBF6
lbC00FBE8:
	CMP.B	#MaxPattPos,D0
	BLS.S	lbC00FBF0
	MOVEQ	#MaxPattPos,D0
lbC00FBF0:
	MOVE.B	D0,QuantizeValue
lbC00FBF6:
	MOVE.W	#$1256,TextOffset
	CLR.W	WordNumber
	MOVE.B	QuantizeValue,WordNumber+1
	BRA.W	Print2DecDigits

lbC00FC12:
	CMP.W	#$01C2,D0
	BCC.S	lbC00FC4E
	MOVE.W	#$1936,TextOffset
	MOVE.W	#$01B4,LineCurX
	MOVE.W	#$0055,LineCurY
	BSR.W	Get2DigitKeys
	TST.W	AbortDecFlag
	BNE.S	lbC00FC6A
	CMP.B	#$40,D0
	BLS.S	lbC00FC46
	MOVEQ	#$40,D0
lbC00FC46:
	MOVE.B	D0,MetroSpeed
	BRA.S	lbC00FC6A

lbC00FC4E:
	MOVE.W	#$1939,TextOffset
	CALL	GetHexByte
	CMP.W	#4,D0
	BLS.S	lbC00FC64
	MOVEQ	#4,D0
lbC00FC64:
	MOVE.B	D0,MetroChannel
lbC00FC6A:
	MOVE.W	#$1936,TextOffset
	CLR.W	WordNumber
	MOVE.B	MetroSpeed,WordNumber+1
	BSR.W	Print2DecDigits
	MOVE.W	#$1939,TextOffset
	CLR.W	WordNumber
	MOVE.B	MetroChannel,WordNumber+1
	BRA.W	Print2DecDigits

;***********************************

ToggleMultiMode:
	CALL	WaitForButtonUp
	CLR.B	RawKeyCode
	EOR.B	#1,MultiFlag
lbC00FCB0:
	BSR.W	PrintmultiM
	CMP.W	#3,CurrScreen		;dir open?
	BEQ.B	MultSingMsg_rt		;yes
	cmp.w	#5,CurrScreen		;setup open?
	beq.b	MultSingMsg_rt

MultSingMsg:
	CMP.W	#1,OptScrFlag
	BEQ.S	MultSingMsg1
	RTS

MultSingMsg1:
	MOVE.W	#$0246,D0
	MOVEQ	#$50,D1
	MOVEQ	#6,D3
	LEA	Single.MSG0(PC),A0
	TST.B	MultiFlag
	BEQ.S	MultSingMsg3
	LEA	Multi.MSG(PC),A0
MultSingMsg3:
	BSR.W	Wr_Message
MultSingMsg_rt:
	GOTO	showskips

;***********************************

ToggleInsertMode:

	CALL	WaitForButtonUp
	CLR.B	RawKeyCode
	EOR.B	#1,AutoInsFlag

ssinsmodq:
	cmp.w	#3,CurrScreen		;dir open?
	beq.b	PrintAutoInsert
	cmp.w	#5,CurrScreen		;setup open?
	beq.b	PrintAutoInsert
tttinshow:
	cmp.w	#1,OptScrFlag
	beq.s	sstinshow
	bra.s	PrintAutoInsert

sstinshow:
	move.w	#$0246,d0
	moveq	#$50+22,d1
	moveq	#6,d3
	lea	NoInsert.MSG(PC),a0
	tst.b	AutoInsFlag
	beq.b	tinsshow
	lea	insert.msg(pc),a0
tinsshow:
	bsr.w	Wr_Message

PrintAutoInsert:

auins3: 	MOVE.B	#' ',D0
		TST.B	AutoInsFlag
		BEQ.S	auins2
		MOVE.B	#'I',D0
auins2: 	MOVE.B	D0,AutoInsText
		MOVE.W	#$2803,D1
		MOVEQ	#1,D0
		LEA	AutoInsText(PC),A0
		BRA.W	ShowText3

AutoInsText:	dc.b	0
AutoInsFlag:	dc.b	0

;***********************************
ToggleSplitMode:
	CALL	WaitForButtonUp
	CLR.B	RawKeyCode
	BCHG	#4,CutToBufFlag

ssinsmodq2:
	cmp.w	#3,CurrScreen		;dir open?
	beq.b	togsplit_ret
	cmp.w	#5,CurrScreen		;setup open?
	beq.b	togsplit_ret
tttinshow2:
	cmp.w	#1,OptScrFlag
	beq.s	sstinshow2
	GOTO	PrintmultiM

sstinshow2:
	move.w	#$0246,d0
	moveq	#$50+33,d1
	moveq	#7,d3
	lea	nosplit.msg(PC),a0
	btst	#4,CutToBufFlag
	beq.b	tinsshow2
	lea	split.msg(pc),a0
tinsshow2:
	bsr.w	Wr_Message
togsplit_ret:
	GOTO	PrintmultiM


Multi.MSG:	dc.b	'MULTI ',0,0
Single.MSG0:	dc.b	'SINGLE',0,0
NoInsert.MSG:	dc.b	'NOINS.',0,0
insert.msg:	dc.b	'INSERT',0,0
split.msg:	dc.b	'SPLIT  ',0
nosplit.msg:	dc.b	'NOSPLIT',0

PrintmultiM:
	MOVE.B	#$20,D0
	TST.B	MultiFlag
	BEQ.S	PrintmultiM2
	MOVE.B	#'M',D0
PrintmultiM2:
	MOVE.B	#$20,D1
	BTST	#4,CutToBufFlag
	BEQ.S	PrintmultiM3
	MOVE.B	#$53,D1
PrintmultiM3:
	MOVE.B	D0,PrintFlagPos1
	MOVE.B	D1,PrintFlagPos2
	MOVE.W	#$2801,D1
	MOVEQ	#2,D0
	LEA	PrintFlagPos1(PC),A0
	BSR.W	ShowText3
	BRA.W	PrintAutoInsert

PrintFlagPos1:	dc.b	$5F
PrintFlagPos2:	dc.b	$5F

;***********************************

sam_halfcliptoggle:
	CALL	WaitForButtonUp
	EOR.B	#1,HalfClipFlag
HalfClipMsg:
	MOVE.W	#$0251,D0
	MOVEQ	#$3A,D1
	MOVEQ	#6,D3
	TST.B	HalfClipFlag
	BEQ.S	ClipMsg
	LEA	Half.MSG(PC),A0
	GOTO	Wr_Message

ClipMsg:
	LEA	Clip.MSG(PC),A0
	GOTO	Wr_Message

Half.MSG:	dc.b	' Half ',0,0
Clip.MSG:	dc.b	' Clip ',0,0

;***********************************
;* POS gadget in sample options    *
;***********************************
sam_setpos:
	MOVE.L	sam_sposflag(PC),D2
	BRA.S	sam_sspos

sam_setposdown:
	MOVE.L	sam_sposflag(PC),D2
	SUBQ.L	#1,D2
	checkrmb
	BNE.S	sam_sposdwnl
	SUB.L	#15,D2
sam_sposdwnl:
	BPL.S	sam_sspos
	MOVEQ	#0,D2
sam_sspos:
	MOVE.L	D2,sam_sposflag
	BRA.S	sam_sposupdate

sam_setposup:
	MOVE.L	sam_sposflag(PC),D2
	ADDQ.L	#1,D2
	checkrmb
	BNE.S	sam_sposupl
	ADD.L	#15,D2
sam_sposupl:
	MOVEQ	#0,D3
	MOVE.W	$0016(A5),D3
	LSL.L	#1,D3
	CMP.L	D3,D2
	BLS.S	sam_sspos
	MOVE.L	D3,sam_sposflag

sam_sposupdate:
	CMP.W	#1,CurrScreen
	beq.B	rrc
	CMP.W	#2,CurrScreen
	beq.b	rrc
	CMP.W	#6,CurrScreen
	beq.b	rrc
	CMP.W	#8,CurrScreen
	beq.b	rrc
	BRA.S	sam_skipposshow


rrc:	CMP.W	#2,OptScrFlag
	BNE.S	sam_skipposshow
	MOVE.W	#$15D9,TextOffset
	MOVE.W	sam_samposlen(PC),WordNumber
	LEA	BlankSample,A0
	CMP.L	SamStart,A0
	BNE.S	sam_showposopt2
	CLR.W	WordNumber

;show pos if opt2 activated

sam_showposopt2:
	BSR.W	PrintHexWord


sam_skipposshow:
	TST.W	SamScrEnable
	BEQ.S	sam_posclrt
	MOVE.L	sam_sposflag(PC),D2
	LEA	BlankSample,A0
	CMP.L	SamStart,A0
	BNE.S	sam_samlnozer
	MOVEQ	#0,D2
sam_samlnozer:
	MOVE.W	#$01A8,D0
	MOVE.W	#$00E2,D1
	MOVEQ	#7,D3
	BSR.W	PrintHexWord2
	MOVE.L	MarkEndOfs(PC),D2
	MOVE.L	MarkStartOfs(PC),D0
	BPL.S	sam_posclfa
	MOVEQ	#0,D0
	MOVEQ	#0,D2
sam_posclfa:
	SUB.L	D0,D2
	BPL.S	sam_posclfb
	NEG.L	D2
sam_posclfb:
	LEA	BlankSample,A0
	CMP.L	SamStart,A0
	BNE.S	sam_posclfc
	MOVEQ	#0,D2
sam_posclfc:
	MOVE.W	#$01A8,D0
	MOVE.W	#$00ED,D1
	MOVEQ	#7,D3
	BSR.W	PrintHexWord2
sam_posclrt:
	RTS

;*******************************

SetModSpeed:
	MOVEQ	#0,D2
	checkrmb
	BEQ.S	semoskp
	MOVE.B	ModSpeed,D2
	BRA.S	semoskp

DrwFiCuSub:
	MOVE.B	ModSpeed,D2
	SUBQ.B	#1,D2
	CMP.B	#$7F,D2
	BNE.S	semoskp
	MOVE.B	#$80,D2
	BRA.S	semoskp

semoup:
	MOVE.B	ModSpeed,D2
	ADDQ.B	#1,D2
	CMP.B	#$80,D2
	BNE.S	semoskp
	MOVEQ	#$7F,D2
semoskp:
	MOVE.B	D2,ModSpeed
	BSR.W	Wait_4000
ShowMod:
	LEA	PlusMinusText(PC),A0
	MOVEQ	#0,D6
	MOVE.B	ModSpeed,D6
	BPL.S	shmoskp
	NEG.B	D6
	ADDQ.L	#1,A0
shmoskp:
	MOVEQ	#1,D0
	MOVE.W	#$1949,D1
	BSR.W	ShowText3
	MOVE.W	D6,WordNumber
	BRA.W	Print3DecDigits_2

PlusMinusText:
	dc.b	' -',0,0

;***********************************
ModulateSample:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D2
	MOVE.W	SampleInfo,D2
	BNE.S	ModulateSample1
	GOTO	ErrorRestoreCol

ModulateSample1:
	ADD.L	D2,D2
	SUBQ.L	#1,D2
	MOVE.L	si_pointer,D0
	BNE.S	DoMod
	GOTO	ErrorRestoreCol

DoMod:
	BSR.W	AllocWorkSamBuf
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	MOVE.L	A1,A4
	ADD.L	D2,A3
	CLR.L	ModOffset
	CLR.L	ModPos
dmoloop:
	CMP.L	A3,A2
	BCC.S	dmoskip
	MOVE.B	(A1),(A2)+
	BSR.S	UpdateMod
	BRA.S	dmoloop

dmoskip:
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
	BSR.W	FreeBuffer
	CALL	RestorePtrCol
	BRA.W	DisplaySample

UpdateMod:
	MOVE.B	ModSpeed(PC),D0
	BEQ.S	upmplus
	EXT.W	D0
	EXT.L	D0
	MOVE.L	ModPos(PC),D1
	ADD.L	D0,D1
	MOVE.L	D1,ModPos
	ASR.L	#8,D1
	ASR.L	#4,D1
	MOVE.L	D1,D3
	AND.W	#$001F,D1
	LEA	mt_vibratotable,A0
	MOVEQ	#0,D0
	MOVE.B	0(A0,D1.W),D0
	LSR.B	#2,D0
	MOVE.L	ModOffset(PC),D1
	BTST	#5,D3
	BEQ.S	upmskip
	SUB.L	D0,D1
	BRA.S	upmskp2

upmskip:
	ADD.L	D0,D1
upmskp2:
	ADD.L	#$800,D1
	MOVE.L	D1,ModOffset
	ASR.L	#8,D1
	ASR.L	#3,D1
	BPL.S	upmskp3
	MOVEQ	#0,D1
upmskp3:
	CMP.L	D2,D1
	BCS.S	upmskp4
	MOVE.L	D2,D1
upmskp4:
	MOVE.L	A4,A1
	ADD.L	D1,A1
	RTS

upmplus:
	ADDQ.L	#1,A1
	RTS

;****************************

CutBeg:
	CMP.W	#$011B,D0
	BHI.W	FadeDown
	CMP.W	#$0103,D0
	BHI.S	FadeUp
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D3
	MOVE.W	SampleInfo,D3
	BNE.S	CutBeg1
	GOTO	ErrorRestoreCol

CutBeg1:
	ADD.L	D3,D3
	SUBQ.L	#1,D3
	MOVE.L	si_pointer,D0
	BNE.S	CutBeg2
	GOTO	ErrorRestoreCol

CutBeg2:
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	ADD.L	sam_sposflag(PC),A2
	ADD.L	D3,A3
cheloop:
	CMP.L	A3,A2
	BCC.S	cheskip
	MOVE.B	(A2),D0
	CLR.B	(A2)+
	MOVE.B	D0,(A1)+
	BRA.S	cheloop

cheskip:
	MOVE.L	si_pointer,A2
	CLR.W	(A2)
	SUB.L	A2,A1
	MOVE.L	A1,D0
	LSR.L	#1,D0
	ADDQ.L	#1,D0
	AND.L	#(MaxSamLen/2),D0
	MOVE.W	D0,$0016(A5)
	BSR.W	ShowSampleInfo
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;****************************

FadeUp:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D3
	MOVE.W	SampleInfo,D3
	BNE.S	Fdup1
	GOTO	ErrorRestoreCol

Fdup1:
	MOVEQ	#0,D1
	MOVE.L	sam_sposflag(PC),D2
	BNE.S	Fdup2
	GOTO	ErrorRestoreCol

Fdup2:
	MOVE.L	si_pointer,D0
	BNE.S	Fdup3
	GOTO	ErrorRestoreCol

Fdup3:
	MOVE.L	D0,A0
	LSR.L	#1,D2
	BNE.S	Fdup4
	GOTO	ErrorRestoreCol

Fdup4:
	MOVEQ	#0,D4
fuloop:
	MOVE.B	(A0),D0
	EXT.W	D0
	MULS	D1,D0
	DIVS	D2,D0
	MOVE.B	D0,(A0)+
	ADDQ.W	#1,D4
	MOVE.W	D4,D1
	LSR.W	#1,D1
	CMP.W	D2,D1
	BCS.S	fuloop
	CALL	RestorePtrCol
	BRA.W	DisplaySample

FadeDown:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D3
	MOVE.W	SampleInfo,D3
	BNE.S	Fddwn1
	GOTO	ErrorRestoreCol

Fddwn1:
	LSL.L	#1,D3
	SUBQ.L	#1,D3
	MOVE.L	sam_sposflag(PC),D2
	CMP.L	D3,D2
	BCS.S	Fddwn2
	GOTO	ErrorRestoreCol

Fddwn2:
	MOVE.L	D3,D4
	SUB.L	D2,D3
	MOVE.L	D3,D2
	MOVE.L	si_pointer,D0
	BNE.S	Fddwn3
	GOTO	ErrorRestoreCol

Fddwn3:
	MOVE.L	D0,A0
	LEA	0(A0,D4.L),A0
	LSR.L	#1,D2
	BNE.S	Fddwn4
	GOTO	ErrorRestoreCol

Fddwn4:
	MOVEQ	#0,D1
	MOVEQ	#0,D4
fdloop:
	MOVE.B	(A0),D0
	EXT.W	D0
	MULS	D1,D0
	DIVS	D2,D0
	MOVE.B	D0,(A0)
	SUBQ.L	#1,A0
	ADDQ.W	#1,D4
	MOVE.W	D4,D1
	LSR.W	#1,D1
	CMP.W	D2,D1
	BCS.S	fdloop
	CALL	RestorePtrCol
	BRA.W	DisplaySample

ChangeVolume:
	MOVE.W	SampleVol(PC),D2
	BRA.S	SampleVol3

SampleVol1:
	MOVE.W	SampleVol(PC),D2
	SUBQ.W	#1,D2
	checkrmb
	BNE.S	SampleVol2
	SUB.W	#9,D2
SampleVol2:
	BPL.S	SampleVol3
	MOVEQ	#0,D2
SampleVol3:
	MOVE.W	D2,SampleVol
	BSR.W	Wait_4000
	BRA.S	ShowVol

shvoup:
	MOVE.W	SampleVol(PC),D2
	ADDQ.L	#1,D2
	checkrmb
	BNE.S	shvoskip3
	ADD.W	#9,D2
shvoskip3:
	CMP.W	#$03E7,D2
	BLS.S	SampleVol3
	MOVE.W	#$03E7,SampleVol
	BSR.W	Wait_4000
ShowVol:
	MOVE.W	#$2029,TextOffset
	MOVE.W	SampleVol(PC),WordNumber
	BSR.W	Print3DecDigits_2
	LEA	PercentText(PC),A0
	MOVE.W	#1,TextLength
	BRA.W	ShowText2

PercentText:
	dc.b	'%',0

;****************************
DoChangeVol:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D3
	MOVE.W	SampleInfo,D3
	BNE.S	DoChangeVol1
	GOTO	ErrorRestoreCol

DoChangeVol1:
	ADD.L	D3,D3
	SUBQ.L	#1,D3
	MOVE.L	si_pointer,D0
	BNE.S	DoChangeVol2
	GOTO	ErrorRestoreCol

DoChangeVol2:
	MOVE.L	D0,A1
	MOVE.W	SampleVol(PC),D0
dcvloop:
	MOVE.B	(A1),D1
	EXT.W	D1
	MULS	D0,D1
	DIVS	#$0064,D1
	CMP.W	#$007F,D1
	BLE.S	dcvskip
	MOVEQ	#$7F,D1
dcvskip:
	CMP.W	#$FF80,D1
	BGE.S	dcvskp2
	MOVEQ	#-$80,D1
dcvskp2:
	MOVE.B	D1,(A1)+
	DBRA	D3,dcvloop
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;*******************************
;* mix sample x+y to z optscr1 *
;*******************************

Mix:
	checkrmb
	BEQ.W	wk_sample
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.W	#1,GetLineFlag
	MOVE.W	#4,MixCurPos
mt_mixloop:
	BSR.W	DisplayMix
	CALL	GetHexKey
	TST.B	D0
	BNE.S	MixMoveLeft
	CMP.B	#$44,RepeatKey
	BEQ.W	Mix2
	CMP.B	#$45,RepeatKey
	BEQ.W	mt_mixerr
	checkrmb
	BEQ.W	mt_mixerr
	LEA	MixText(PC),A0
	LEA	FastHexTable+1,A1
	LSL.W	#1,D1
	MOVE.W	MixCurPos(PC),D0
	MOVE.B	0(A1,D1.W),0(A0,D0.W)
MixMoveRight:
	MOVE.W	MixCurPos,D0
	ADDQ.W	#1,D0
	CMP.W	#6,D0
	BEQ.S	mt_mixla2
	CMP.W	#9,D0
	BEQ.S	mt_mixla3
	CMP.W	#15,D0
	BCC.S	mt_mixla4
mt_mixla1:
	MOVE.W	D0,MixCurPos
	BRA.B	mt_mixloop

mt_mixla2:
	MOVEQ	#7,D0
	BRA.S	mt_mixla1

mt_mixla3:
	MOVEQ	#13,D0
	BRA.S	mt_mixla1

mt_mixla4:
	MOVEQ	#14,D0
	BRA.S	mt_mixla1

MixMoveLeft:
	CMP.B	#1,D0
	BEQ.S	MixMoveRight
	MOVE.W	MixCurPos,D0
	SUBQ.W	#1,D0
	CMP.W	#4,D0
	BCS.S	MixMoveLeft2
	CMP.W	#6,D0
	BEQ.S	MixMoveLeft3
	CMP.W	#12,D0
	BEQ.S	MixMoveLeft4
	BRA.S	mt_mixla1

MixMoveLeft2:
	MOVEQ	#4,D0
	BRA.S	mt_mixla1

MixMoveLeft3:
	MOVEQ	#5,D0
	BRA.S	mt_mixla1

MixMoveLeft4:
	MOVEQ	#8,D0
	BRA.S	mt_mixla1

DisplayMix:
	MOVE.W	#$0040,LineCurY
	MOVE.W	MixCurPos,D0
	LSL.W	#3,D0
	ADD.W	#$01BC,D0
	MOVE.W	D0,LineCurX
	CALL	UpdateLineCurPos
	LEA	MixText(PC),A0
	MOVE.W	#$12A7,D1
	MOVEQ	#$16,D0
	BSR.W	ShowText3
	BRA.W	Wait_4000

MixText:		dc.b	'mix '
mt_mixfirsttxt:		dc.b	'01+'
mt_mixfsecondtxt:	dc.b	'02 to '
ascii.MSG12:		dc.b	'03       '
			EVEN

mx_cleartxt:		dc.b	'                 ',0
			EVEN

RepeatKey:	dc.w	0
MixCurPos:	dc.w	0
mt_mixsams3:	dc.w	0
mt_mixsams1:	dc.l	0
FromPtr2:	dc.l	0
mt_mixresult:	dc.l	0
SamMemStor:	dc.l	0
MixLength:	dc.l	0

;********************************
mt_mixerr:
	BSR.S	RestoreMix
	LEA	mx_cleartxt(PC),A0		;4.0 included
	MOVE.W	#$12A7,D1
	MOVEQ	#$16-5,D0
	BSR.W	ShowText3
	GOTO	RestorePtrCol

RestoreMix:
	CLR.W	GetLineFlag
	MOVE.W	#$FFF0,LineCurX
	CLR.W	LineCurY
	CALL	UpdateLineCurPos
	BRA.W	SampleOptions

Mix2:
	BSR.B	RestoreMix
	BSR.W	TurnOffVoices
	LEA	mt_songdataptr,A2
	MOVEQ	#0,D0
	LEA	mt_mixfirsttxt(PC),A0
	BSR.W	HexToInteger2
	TST.W	D0
	BEQ.W	SamNotInRange

	CMP.W	#MaxInsNum,D0
	BHI.W	SamNotInRange

	LSL.W	#2,D0
	LEA	0(A2,D0.W),A3
	MOVE.L	A3,mt_mixsams1
	MOVEQ	#0,D0
	LEA	mt_mixfsecondtxt(PC),A0
	BSR.W	HexToInteger2
	TST.W	D0
	BEQ.W	SamNotInRange
	CMP.W	#MaxInsNum,D0
	BHI.W	SamNotInRange
	LSL.W	#2,D0
	LEA	0(A2,D0.W),A3
	MOVE.L	A3,FromPtr2
	MOVEQ	#0,D0
	LEA	ascii.MSG12(PC),A0
	BSR.W	HexToInteger2
	MOVE.W	D0,mt_mixsams3
	BEQ.W	SamNotInRange
	CMP.W	#MaxInsNum,D0
	BHI.W	SamNotInRange

	LSL.W	#2,D0
	LEA	0(A2,D0.W),A3
	MOVE.L	A3,mt_mixresult
	MOVE.L	mt_mixsams1,A1
	MOVE.L	FromPtr2,A2
	MOVE.L	$007C(A1),D1
	MOVE.L	$007C(A2),D2
	CMP.L	D1,D2
	BCS.S	mixnswp
	EXG	D1,D2

mixnswp:
	TST.L	D1
	BEQ.W	SamEmptyError		;both samples has length=0
	MOVE.L	D1,D0
	AND.L	#(MaxSamLen/2),D0
	MOVE.L	D0,MixLength

	MOVE.L	XDmaType,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,SamMemStor
	BEQ.W	SamMemError
	LEA	missingtext(PC),A0
	BSR.W	ShowStatusText
	MOVE.L	mt_mixsams1(PC),A1
	MOVE.L	$007C(A1),D1
	MOVE.L	(A1),A1
	MOVE.L	FromPtr2(PC),A2
	MOVE.L	$007C(A2),D2
	MOVE.L	(A2),A2
	MOVE.L	SamMemStor(PC),A3
	MOVE.L	MixLength,D3
	TST.W	D1
	BEQ.S	mixnd1
	SUBQ.W	#1,D1
mixnd1:
	TST.W	D2
	BEQ.S	mixlop2
	SUBQ.L	#1,D2
mixlop2:
	MOVE.B	(A1),D4
	EXT.W	D4
	MOVE.B	(A2),D0
	EXT.W	D0
	ADD.W	D4,D0
	TST.B	HalfClipFlag
	BEQ.S	mixhalf
	CMP.W	#$007F,D0	;127
	BLE.S	mixnbig
	MOVEQ	#127,D0
mixnbig:
	CMP.W	#-128,D0
	BGE.S	mixokok
	MOVEQ	#-$80,D0
	BRA.S	mixokok

mixhalf:
	ASR.W	#1,D0
mixokok:
	MOVE.B	D0,(A3)+
	TST.W	D1
	BEQ.S	mt_mixa
	ADDQ.L	#1,A1
	SUBQ.W	#1,D1
	BNE.S	mt_mixa
	SUB.L	A1,A1
mt_mixa:
	TST.W	D2
	BEQ.S	mt_mixb
	ADDQ.L	#1,A2
	SUBQ.W	#1,D2
	BNE.S	mt_mixb
	SUB.L	A2,A2
mt_mixb:
	SUBQ.L	#1,D3
	BGE.S	mixlop2
	MOVE.W	mt_mixsams3(PC),InsNum
	BSR.W	FreeSample		;kill temp sample
	MOVE.L	mt_mixresult(PC),A0
	MOVE.L	SamMemStor(PC),A1
	CLR.W	(A1)
	MOVE.L	A1,(A0)
	MOVE.L	MixLength(PC),$007C(A0)
	MOVE.L	mt_songdataptr,A0
	MOVE.W	mt_mixsams3(PC),D0
	SUBQ.W	#1,D0
	MULU	#$001E,D0
	LEA	n_dmabit(A0,D0.W),A0
	MOVE.L	MixLength(PC),D0
	LSR.L	#1,D0
	MOVE.W	D0,n_toneportdirec(A0)
	MOVE.W	#$0040,n_wantedperiod(A0)
	MOVE.W	#0,n_vibratocmd(A0)
	MOVE.W	#1,n_vibratopos(A0)
	CALL	RestorePtrCol
	BSR.W	ShowAllRight
	BSR.W	ShowSampleInfo
	BRA.W	DisplaySample

SamNotInRange:
	LEA	Samplenotinra.MSG(PC),A0
	BSR.W	ShowStatusText
	CALL	ErrorRestoreCol
	BRA.W	mt_mixerr		;4.0

SamEmptyError:
	LEA	Theseareempty.MSG(PC),A0
	BSR.W	ShowStatusText
	CALL	ErrorRestoreCol
	BRA.W	mt_mixerr		;4.0

SamMemError:
	LEA	Notenoughmemo.MSG(PC),A0
	CALL	NoMemoryRequester
	CALL	ErrorRestoreCol
	BRA.W	mt_mixerr		;4.0

OutOfMemErr:
	LEA	Notenoughmemo.MSG(PC),A0
	CALL	NoMemoryRequester
	CALL	SetErrorPtrCol
	MOVEQ	#0,D0
	RTS

Samplenotinra.MSG:	dc.b	'SAMPLE NOT IN RANGE 01-1F!',0
			EVEN

Theseareempty.MSG:	dc.b	'THESE ARE NO EMPTY SAMPLES!',0
			EVEN

missingtext:		dc.b	'MIXING CHOSEN SAMPLES...',0
			EVEN

Notenoughmemo.MSG:	dc.b	10,10,10,'   NOT ENOUGH MEMORY!',0
			EVEN

;***********************************
;* filter gadget in sampleroptions *
;***********************************
wk_sample:
	MOVE.L	sam_sposflag(PC),FlangePos
wk_sast:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D2
	MOVE.W	SampleInfo,D2
	BNE.S	wk_bg
	RTS

wk_bg:
	ADD.L	D2,D2
	MOVE.L	si_pointer,D0
	BNE.S	wk_clc
	GOTO	ErrorRestoreCol

wk_clc:
	BSR.W	AllocWorkSamBuf
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	MOVE.L	A1,A4
	ADD.L	D2,A3
	ADD.L	FlangePos(PC),A2
	CLR.L	ModOffset
	CLR.L	ModPos
	MOVEQ	#-1,D7
wk_sst:
	ADDQ.L	#1,D7
	CMP.L	A3,A2
	BCC.S	wk_cted
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	wk_smx
	MOVE.L	MarkEndOfs(PC),D1
	CMP.L	D0,D1
	BEQ.S	wk_smx
	CMP.L	D0,D7
	BCS.S	wk_ciao
	CMP.L	D1,D7
	BHI.S	wk_ciao
wk_smx:
	MOVE.B	(A2),D0
	EXT.W	D0
	MOVE.B	(A1),D1
	EXT.W	D1
	ADD.W	D1,D0
	TST.B	HalfClipFlag
	BEQ.S	wk_cnt
	CMP.W	#$007F,D0
	BLE.S	wk_snd
	MOVEQ	#$7F,D0
wk_snd:
	CMP.W	#$FF80,D0
	BGE.S	wk_cbfa
	MOVEQ	#-$80,D0
	BRA.S	wk_cbfa

wk_cnt:
	ASR.W	#1,D0
wk_cbfa:
	MOVE.B	D0,(A2)+
	BSR.W	UpdateMod
	BRA.S	wk_sst

wk_ciao:
	ADDQ.L	#1,A2
	BSR.W	UpdateMod
	BRA.S	wk_sst

wk_cted:
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
	BSR.S	FreeBuffer
	CALL	RestorePtrCol
	CALL	WaitForButtonUp
	TST.W	wk_bufflag
	BEQ.W	DisplaySample
	CLR.W	wk_bufflag
	BRA.W	RedrawSample

wk_bufflag:	dc.w	0

;***********************************

AllocWorkSamBuf:
	MOVE.L	D0,D7
	MOVE.L	D2,D0
	MOVE.L	D2,BufMemSize
	MOVE.L	#$00010000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,BufMemPtr
	BEQ.W	OutOfMemErr
	MOVE.L	D7,A0
	MOVE.L	D0,A1
	MOVE.L	BufMemSize(PC),D0
	SUBQ.L	#1,D0
lbC0106A2:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,lbC0106A2
	MOVE.L	BufMemPtr(PC),A1
	MOVE.L	D7,D0
	RTS

FreeBuffer:
	MOVE.L	BufMemPtr(PC),D0
	BNE.S	lbC0106B8
	RTS

lbC0106B8:
	MOVE.L	D0,A1
	MOVE.L	BufMemSize(PC),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	BufMemPtr
	RTS

;***********************************

Echo:
	MOVE.L	sam_sposflag(PC),FlangePos
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D2
	MOVE.W	SampleInfo,D2		;3.10 (PC)
	BNE.S	Echo1
	GOTO	ErrorRestoreCol

Echo1:
	ADD.L	D2,D2
	MOVE.L	si_pointer,D0
	BNE.S	Echo2
	GOTO	ErrorRestoreCol

Echo2:
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	MOVE.L	D0,A3
	MOVE.L	D0,A4
	ADD.L	D2,A3
	ADD.L	FlangePos(PC),A2
	CLR.L	ModOffset
	CLR.L	ModPos
flaloop:
	CMP.L	A3,A2
	BCC.S	flaskip
	MOVE.B	(A2),D0
	EXT.W	D0
	MOVE.B	(A1),D1
	EXT.W	D1
	ADD.W	D1,D0
	ASR.W	#1,D0
	MOVE.B	D0,(A2)+
	BSR.W	UpdateMod
	BRA.B	flaloop

flaskip:
	MOVE.L	si_pointer,A1		;3.10 (PC)
	CLR.W	(A1)
	CALL	RestorePtrCol
	TST.B	HalfClipFlag
	BEQ.W	DisplaySample
	MOVE.W	SampleVol,-(SP)
	MOVE.W	#$00C8,SampleVol
	BSR.W	DoChangeVol
	MOVE.W	(SP)+,SampleVol
	BRA.W	DisplaySample

;***********************************
;* filter an sample                *
;***********************************

Filter2:
	bsr.s	filters
	bra.w	DisplaySample

filters:

	MOVE.W	#1,wk_bufflag
Filter:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol

	LEA	filtering.MSG,A0
	BSR.W	ShowStatusText
	CALL	WaitForButtonUp

	MOVE.L	#1,FlangePos
	MOVE.B	ModSpeed(PC),-(SP)
	MOVE.B	HalfClipFlag,-(SP)
	CLR.B	ModSpeed
	CLR.B	HalfClipFlag
	BSR.W	wk_sast
	MOVE.B	(SP)+,HalfClipFlag
	MOVE.B	(SP)+,ModSpeed
	BSR.W	ShowAllRight
	CALL	RestorePtrCol
	GOTO	SetNormalPtrCol

filtering.MSG:
	dc.b	'FILTERING',0
;***********************************
;* Boost an sample                 *
;***********************************
Boost:
	BSR.S	mt_boostsam
	BRA.W	DisplaySample

mt_boostsam:
	;CLR.B	RawKeyCode
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	LEA	boosting.MSG,A0
	BSR.W	ShowStatusText
	CALL	WaitForButtonUp

	MOVEQ	#0,D3
	MOVE.W	SampleInfo,D3
	BEQ.S	mt_nboost
	ADD.L	D3,D3
	SUBQ.L	#1,D3
	MOVE.L	si_pointer,D0
	BEQ.S	mt_nboost
	MOVE.L	D0,A1
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	mt_boostkpf
	MOVE.L	MarkEndOfs(PC),D1
	SUB.L	D0,D1
	BEQ.S	mt_boostkpf
	MOVE.L	D1,D3
	MOVE.L	SamStart(PC),A1
	ADD.L	D0,A1
mt_boostkpf:
	MOVEQ	#0,D0
mt_boostkpa:
	MOVE.B	(A1),D1
	EXT.W	D1
	MOVE.W	D1,D2
	SUB.W	D0,D1
	MOVE.W	D2,D0
	TST.W	D1
	BMI.S	mt_boostca1
	ASR.W	#2,D1
	ADD.W	D1,D2
	BRA.S	mt_boostmper

mt_boostca1:
	NEG.W	D1
	ASR.W	#2,D1
	SUB.W	D1,D2
mt_boostmper:
	CMP.W	#$007F,D2
	BLE.S	mt_boostmpera
	MOVEQ	#$7F,D2
mt_boostmpera:
	CMP.W	#$FF80,D2
	BGE.S	mt_boostmperf
	MOVEQ	#-$80,D2
mt_boostmperf:
	MOVE.B	D2,(A1)+
	DBRA	D3,mt_boostkpa
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
mt_nboost:
	BSR.W	ShowAllRight
	GOTO	RestorePtrCol

boosting.MSG:	dc.b	'BOOSTING',0,0

BoostAllText:	dc.b	10,10,'   BOOST ALL SAMPLES  ?',0
FilterAllText:	dc.b	10,10,'   FILTER ALL SAMPLES ?',0

;***********************************
;* X-FADE in sample edit options   *
;***********************************
XFade:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D2
	MOVE.W	SampleInfo,D2
	BNE.S	xf_bg
	GOTO	ErrorRestoreCol

xf_bg:
	ADD.L	D2,D2
	MOVE.L	si_pointer,D0
	BNE.S	xf_st
	GOTO	ErrorRestoreCol

xf_st:
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	ADD.L	D2,A2
xf_lp:
	MOVE.B	(A1),D0
	EXT.W	D0
	MOVE.B	-(A2),D1
	EXT.W	D1
	ADD.W	D1,D0
	TST.B	HalfClipFlag
	BEQ.S	xf_mk
	CMP.W	#$007F,D0
	BLE.S	xf_vf
	MOVEQ	#$7F,D0
xf_vf:
	CMP.W	#$FF80,D0
	BGE.S	xf_nd
	MOVEQ	#-$80,D0
	BRA.S	xf_nd

xf_mk:
	ASR.W	#1,D0
xf_nd:
	MOVE.B	D0,(A1)+
	MOVE.B	D0,(A2)
	CMP.L	A2,A1
	BCS.S	xf_lp
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;***********************************

BackwardsSample:
	CALL	WaitForButtonUp
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D2
	MOVE.W	$0016(A5),D2
	BNE.S	mt_bwsamn
	GOTO	ErrorRestoreCol

mt_bwsamn:
	MOVE.L	si_pointer,D0
	BNE.S	mt_bwsamo
	GOTO	ErrorRestoreCol

mt_bwsamo:
	MOVE.L	D0,A1
	MOVE.L	D0,A2
	ADD.L	D2,D2
	ADD.L	D2,A2
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	mt_bwsaml
	MOVE.L	MarkEndOfs(PC),D1
	SUB.L	D0,D1
	BEQ.S	mt_bwsaml
	MOVE.L	SamStart(PC),A1
	ADD.L	D0,A1
	MOVE.L	A1,A2
	ADD.L	D1,A2
mt_bwsaml:
	MOVE.B	(A1),D0
	MOVE.B	-(A2),(A1)+
	MOVE.B	D0,(A2)
	CMP.L	A2,A1
	BCS.S	mt_bwsaml
	MOVE.L	si_pointer,A1
	CLR.W	(A1)
	CALL	RestorePtrCol
	BRA.W	DisplaySample


;***********************************

UpSamSample:
	CALL	WaitForButtonUp
	LEA	Upsample.MSG,A0
	CALL	AreYouSure
	BEQ.S	upsam_beg
	RTS

upsam_beg:
	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.W	InsNum,D0
	LSL.W	#2,D0
	LEA	mt_songdataptr,A0
	LEA	0(A0,D0.W),A0
	MOVE.L	$007C(A0),D3
	CMP.L	#2,D3
	BHI.S	upsam_err
	GOTO	ErrorRestoreCol

upsam_err:
	MOVE.L	(A0),D0
	BNE.S	upsam_calc
	GOTO	ErrorRestoreCol

upsam_calc:
	MOVE.L	D0,A2
	MOVE.L	D0,A4
	MOVE.L	D3,D4
	LSR.L	#1,D3
	BCLR	#0,D3
	MOVE.L	D3,D0
	MOVE.L	XDmaType,D1		;Changed to Public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	TST.L	D0
	BEQ.S	upsam_noo
	MOVE.L	D0,A3
	MOVE.L	D0,D2
	MOVE.L	D3,D5
upsam_stro:
	MOVE.B	(A2)+,(A3)+
	ADDQ.L	#1,A2
	SUBQ.L	#1,D3
	BGE.S	upsam_stro
	MOVE.L	A4,A1
	MOVE.L	D4,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	MOVE.W	InsNum,D0
	LSL.W	#2,D0
	LEA	mt_songdataptr,A0
	LEA	0(A0,D0.W),A0
	MOVE.L	D2,(A0)
	MOVE.L	D5,$007C(A0)
	MOVE.L	D2,A0
	CLR.W	(A0)
	MOVE.W	$0016(A5),D0
	LSR.W	#1,D0
	MOVE.W	D0,$0016(A5)
	MOVE.W	$001A(A5),D0
	LSR.W	#1,D0
	MOVE.W	D0,$001A(A5)
	MOVE.W	$001C(A5),D0
	LSR.W	#1,D0
	BNE.S	upsam_rdy
	MOVEQ	#1,D0
upsam_rdy:
	MOVE.W	D0,$001C(A5)
	BSR.W	ShowSampleInfo
	CALL	WaitForButtonUp
	CALL	RestorePtrCol
	BRA.W	RedrawSample

upsam_noo:
	CALL	RestorePtrCol
	BRA.W	OutOfMemErr

;***********************************

DownSamSample:
	CALL	WaitForButtonUp
	TST.W	InsNum
	BEQ.W	NotSampleNull
	LEA	Downsample.MSG,A0
	CALL	AreYouSure
	BEQ.S	.doit
	RTS

.doit:	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	si_pointer,D0
	BNE.S	.doio
	GOTO	ErrorRestoreCol

.doio:	MOVEQ	#0,D0
	MOVE.W	SampleInfo,D0
	BNE.S	.do
	GOTO	ErrorRestoreCol

.do:	LSL.L	#1,D0
	CMP.L	#MaxSamLen,D0
	BLS.S	.l0
	GOTO	ErrorRestoreCol

.l0:	LSL.L	#1,D0
	CMP.L	#MaxSamLen,D0
	BLS.S	.l1
	MOVE.L	#MaxSamLen,D0

.l1:	MOVE.L	D0,BufMemSize
	MOVE.L	XDmaType,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,BufMemPtr
	BEQ.W	SamMemError
	MOVE.L	si_pointer,A1
	MOVE.L	D0,A2
	MOVE.L	BufMemSize,D3
	LSR.L	#1,D3
	SUBQ.L	#1,D3

.lop1:	MOVE.B	(A1)+,D0
	MOVE.B	D0,(A2)+
	MOVE.B	D0,(A2)+
	DBRA	D3,.lop1

	BSR.W	FreeSample
	LEA	mt_songdataptr,A0
	MOVE.W	InsNum,D0
	LSL.W	#2,D0
	MOVE.L	BufMemPtr,0(A0,D0.W)
	MOVE.L	BufMemSize,$007C(A0,D0.W)
	MOVEQ	#0,D0
	MOVE.W	22(A5),D0
	LSL.L	#1,D0
	CMP.L	#(MaxSamLen/2),D0
	BLS.S	.l2
	MOVE.L	#(MaxSamLen/2),D0

.l2:	MOVE.W	D0,22(A5)
	MOVEQ	#0,D0
	MOVE.W	26(A5),D0
	LSL.L	#1,D0
	CMP.L	#(MaxSamLen/2),D0
	BLS.S	.l3
	MOVE.L	#(MaxSamLen/2),D0

.l3:	MOVE.W	D0,26(A5)
	MOVEQ	#0,D0
	MOVE.W	28(A5),D0
	CMP.L	#1,D0
	BEQ.S	.l4
	LSL.L	#1,D0
	CMP.L	#(MaxSamLen/2),D0
	BLS.S	.l4
	MOVE.L	#(MaxSamLen/2),D0

.l4:	MOVE.W	D0,28(A5)
	BSR.W	ShowSampleInfo
	CALL	WaitForButtonUp
	CALL	RestorePtrCol
	BRA.W	RedrawSample

;***********************************
lbC010B88:
	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	si_pointer,D0
	BNE.S	.l1
	GOTO	ErrorRestoreCol

.l1:
	MOVEQ	#0,D0
	MOVE.W	SampleInfo,D0
	BNE.S	.l2
	GOTO	ErrorRestoreCol

.l2:	BSR.W	lbC011348
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;***********************************

NormAllocSample:
	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	si_pointer,D0
	BNE.S	Normlal1
	GOTO	ErrorRestoreCol

Normlal1:
	MOVEQ	#0,D0
	MOVE.W	SampleInfo,D0
	BNE.S	Normlal2
	GOTO	ErrorRestoreCol

Normlal2:
	BSR.W	lbC01129C
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;***********************************

NormalizeSample:
	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	si_pointer,D0
	BNE.S	Normlz1
	GOTO	ErrorRestoreCol

Normlz1:
	MOVEQ	#0,D0
	MOVE.W	SampleInfo,D0
	BNE.S	Normlz2
	GOTO	ErrorRestoreCol

Normlz2:
	BSR.W	lbC01124E
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;***********************************

MaximizeSample:
	BSR.W	TurnOffVoices
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	si_pointer,D0
	BNE.S	mt_maxsa1
	GOTO	ErrorRestoreCol

mt_maxsa1:
	MOVEQ	#0,D0
	MOVE.W	SampleInfo,D0
	BNE.S	mt_maxsa2
	GOTO	ErrorRestoreCol

mt_maxsa2:
	BSR.W	lbC0112E2
	CALL	RestorePtrCol
	BRA.W	DisplaySample

;**********************************
lbC010E58:
	MOVEQ	#1,D0
	MOVE.L	MarkStartOfs(PC),D1
	BMI.S	.l1
	CMP.L	MarkEndOfs(PC),D1
	BEQ.S	.l1
	MOVEQ	#2,D0

.l1:	LEA	mt_songdataptr,A0
	MOVE.W	InsNum,D1
	LSL.W	#2,D1
	MOVE.L	0(A0,D1.W),A1
	MOVE.L	$7C(A0,D1.W),D1
	CMP.W	#1,D0
	BEQ.S	.l3
	CMP.W	#2,D0
	BEQ.S	.l4
	RTS

.l3:	ADD.L	SamOffSet,A1
	MOVE.L	SamDisplay,D1
	RTS

.l4:	MOVE.L	MarkStartOfs,D0
	ADD.L	D0,A1
	MOVE.L	MarkEndOfs,D1
	SUB.L	D0,D1
	RTS

;***********************************
lbC01124E:
	MOVEM.L D2-D4,-(SP)
	BSR.B	lbC010E58
	MOVE.L	A1,A0
	MOVE.L	D1,D0
	MOVEQ	#0,D2
.lopa:
	MOVE.B	(A0)+,D3
	EXT.W	D3
	BPL.S	.l1
	NEG.W	D3

.l1:	CMP.W	D2,D3
	BCS.S	.l2
	MOVE.W	D3,D2

.l2:	SUBQ.L	#1,D1
	BNE.S	.lopa
	TST.W	D2
	BEQ.S	.skip
	MOVE.L	#$00004000,D3
	DIVU	D2,D3
	MOVEQ	#7,D2
	MOVEQ	#$40,D4

.lopb:	MOVE.B	(A1),D1
	EXT.W	D1
	MULS	D3,D1
	ADD.L	D4,D1
	ASR.L	D2,D1
	CMP.W	#127,D1
	BLE.S	.l3
	MOVEQ	#127,D1

.l3:	MOVE.B	D1,(A1)+
	SUBQ.L	#1,D0
	BNE.S	.lopb
.skip:
	MOVEM.L (SP)+,D2-D4
	RTS

;*******************************
lbC01129C:
	MOVEM.L D2/D3,-(SP)
	BSR.W	lbC010E58
	MOVE.L	A1,A0
	MOVE.L	D1,D3
	MOVEQ	#0,D2
lbC0112AA:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	EXT.L	D0
	ADD.L	D0,D2
	SUBQ.L	#1,D1
	BNE.S	lbC0112AA
	MOVE.L	D2,D0
	MOVE.L	D3,D1
	BSR.W	lbC011356
lbC0112BE:
	MOVE.B	(A1),D1
	EXT.W	D1
	SUB.W	D0,D1
	CMP.W	#$007F,D1
	BLE.S	lbC0112CE
	MOVEQ	#$7F,D1
	BRA.S	lbC0112D6

lbC0112CE:
	CMP.W	#$FF80,D1
	BGE.S	lbC0112D6
	MOVEQ	#-$80,D1
lbC0112D6:
	MOVE.B	D1,(A1)+
	SUBQ.L	#1,D3
	BNE.S	lbC0112BE
	MOVEM.L (SP)+,D2/D3
	RTS

lbC0112E2:
	MOVEM.L D2/D3,-(SP)
	BSR.W	lbC010E58
	MOVE.L	A1,A0
	MOVE.L	D1,D3
	MOVEQ	#-$80,D2
	MOVEQ	#$7F,D4
lbC0112F2:
	MOVE.B	(A0)+,D0
	EXT.W	D0
	CMP.W	D0,D2
	BPL.S	lbC0112FC
	MOVE.W	D0,D2
lbC0112FC:
	CMP.W	D0,D4
	BMI.S	lbC011302
	MOVE.W	D0,D4
lbC011302:
	SUBQ.L	#1,D1
	BNE.S	lbC0112F2
	MOVE.W	D2,D0
	SUB.W	D4,D0
	BEQ.S	lbC01132E
	MOVE.W	D2,D6
	SUB.W	#$007F,D6
	MOVE.W	D4,D5
	SUB.W	#$FF80,D5
	ADD.W	D6,D5
	ASR.W	#1,D5
lbC01131C:
	MOVE.B	(A1),D1
	EXT.W	D1
	SUB.W	D5,D1
	MULS	#$00FF,D1
	DIVS	D0,D1
	MOVE.B	D1,(A1)+
	SUBQ.L	#1,D3
	BNE.S	lbC01131C
lbC01132E:
	MOVEM.L (SP)+,D2/D3
	RTS

lbC011348:
	BSR.W	lbC010E58
	MOVEQ	#-1,D0
lbC01134E:
	EOR.B	D0,(A1)+
	SUBQ.L	#1,D1
	BNE.S	lbC01134E
	RTS

lbC011356:
	DIVS	D1,D0
	RTS



sam_sposflag:	dc.b	0,0
sam_samposlen:	dc.w	0
SampleVol:	dc.w	100
FlangePos:	dc.l	0
ModSpeed:	dc.b	0
HalfClipFlag:	dc.b	0
ModPos:		dc.l	0
ModOffset:	dc.l	0
BufMemPtr:	dc.l	0
BufMemSize:	dc.l	0

;***********************************
;* save protracker song            *
;***********************************
SaveSong:
	BSR.W	StopIt
	CLR.B	RawKeyCode
	MOVE.L	mt_songdataptr,A0
	LEA	SamplePointers(PC),A1
	MOVEQ	#0,D0
	MOVEQ	#2,D1
sadloop:
	MOVE.W	0(A1,D1.W),D2
	ADD.W	D2,$2A(A0,D0.W)
	ADD	#30,D0
	ADDQ.W	#2,D1
	CMP.W	#62,D1
	BNE.B	sadloop

	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	CLR.W	HighPattNum
ssloop:
	MOVE.B	0(A0,D0.W),D1
	ADDQ.W	#1,D0
	CMP.W	#$0080,D0
	BHI.S	DoSaveSong
	MOVE.W	HighPattNum,D2
	CMP.W	D2,D1
	BLS.B	ssloop
	MOVE.W	D1,HighPattNum
	BRA.B	ssloop

DoSaveSong:
	tst.b	modmode
	beq.s	oldsthd

	move.l	DirPath,a0
	CALL	CopyPath
	move.b	#'p',(A1)+
	move.b	#'t',(A1)+
	move.b	#'s',(A1)+
	move.b	#'.',(A1)+
	move.l	mt_songdataptr,a0
	moveq	#13,d0
nwsolp:
	move.b	(A0)+,(A1)+
	dbra	d0,nwsolp
	bra.s	owhdd1

oldsthd:
	MOVE.L	DirPath,A0
	CALL	CopyPath

	move.b	#'s',(a1)+
	move.b	#'t',(a1)+
	move.b	#'.',(A1)+


	MOVE.L	mt_songdataptr,A0
	MOVEQ	#$13,D0 		;+50

dssloop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dssloop

owhdd1:
	MOVE.L	#FileName,FileNamePtr

	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,DiskDataPtr
	move.l	#$00,DiskDataLength

	tst.b	modmode 			; old moduleformat?
	beq.w	savesongold

;---- prepare IFF headers

	BSET	#2,Packetfield			; song set 1
	move.l	TuneRAMBit,d0
	add.l	iffmhunklength,d0
	move.l	d0,fo_length			; modlength


	lea	fo_songname,a0
	cmp.l	#'UNNA',(A0)			; unnamed song?
	bne.s	snamleav1

	move.l	mt_songdataptr,a0
	lea	fo_songname,a1
	moveq	#$13,D0
copysnamekt:

	move.b	(a0)+,(A1)+
	dbra	d0,copysnamekt
snamleav1:

	move.w	#MaxInsNum+1,fo_instr
	move.w	#64,fo_positions
	move.w	HighPattNum,fo_patterns
	move.w	TremoloByte,fo_volume
	move.w	RealTempo,fo_dspeed
	move.w	Packetfield,fo_packetf		; packet field bit
	bchg	#5,fo_packetf

	CALL	CalTime 			; calculate playtime of song
	LEA	Timer,a0
	move.l	(A0),D0
	move.w	d0,fo_playtime_h
	move.l	4(A0),d0
	move.w	d0,fo_playtime_m
	move.l	8(A0),d0
	move.w	d0,fo_playtime_s
	move.l	12(A0),d0
	move.w	d0,fo_playtime_ms

	move.w	fa_creatdat_da,fo_creatdat_da
	move.w	fa_creatdat_mo,fo_creatdat_mo
	move.w	fa_creatdat_ye,fo_creatdat_ye
	move.w	fa_creattime_h,fo_creattime_h
	move.w	fa_creattime_m,fo_creattime_m
	move.w	fa_creattime_s,fo_creattime_s

;---- calculate tune ram and set in PTDT chunk
	;CALL	CalcTuneRAM
	move.l	TuneRAMBit,d0
	move.l	d0,fo_ptrnlgth

;---------
	lea	ModConfHeader,a0
	move.l	a0,DiskDataPtr
	move.l	#fo_formModend-ModConfHeader,d0 	;IFF-Headerlength
	move.l	d0,DiskDataLength


	BSR.W	wr_savmodopen			; open
	BNE.W	CantOpenFile
	BSR.W	WriteDataBlock			; Write iffheader
	BNE.W	wr_savmoderror

savesongold:
		move.l	mt_songdataptr,A0
		MOVE.L	mt_songdataptr,DiskDataPtr
		MOVE.L	#sd_patterndata,DiskDataLength
		MOVEQ	#0,D0
		MOVE.W	HighPattNum,D0
		ADDQ.L	#1,D0
		LSL.L	#8,D0
		LSL.L	#2,D0
		chn8test
		BNE.S	no8mode28
		LSL.L	#1,D0
no8mode28:
		ADD.L	D0,DiskDataLength

		move.b	#$7F,sd_ntflag(a0)

		;tst.b	modmode
		;bne.s	no100patsong
		move.l	#'M.K.',sd_mahokakt(A0)
		cmp.w	#$0040,HighPattNum
		bcs.s	no100patsong
		move.l	#'M!K!',sd_mahokakt(A0)
no100patsong:
		BTST	#1,PackMode
		BEQ.S	dssnocr			 	;beq
		LEA	Crunching.MSG,A0
		BSR.W	ShowStatusText
		BSR.W	Cruncher
dssnocr:

		tst.b	modmode
		bne.s	soskip1
		bsr.w	wr_savmodopen
		bne.w	CantOpenFile
soskip1:	bsr.w	WriteDataBlock
		bne.w	wr_savmoderror
		bsr.w	wr_savmodclose

		BTST	#1,PackMode
		BEQ.S	dssnocr2
		LEA	DecrunchingText,A0
		BSR.W	ShowStatusText
		BSR.W	Decruncher
dssnocr2:	MOVE.L	mt_songdataptr,A0
		LEA	SamplePointers(PC),A1
		MOVEQ	#0,D0
		MOVEQ	#2,D1
ssuloop:	MOVE.W	0(A1,D1.W),D2
		SUB.W	D2,$2A(A0,D0.W)
		ADD	#30,D0
		ADDQ	#2,D1
		CMP	#62,D1
		BNE.B	ssuloop
		BSR.W	ShowAllRight
		GOTO	SetNormalPtrCol

CrunchData1:	dc.l	0
CrunchData2:	dc.b	0,0
CrunchData3:	dc.w	$0100,$0200,$0400,$1000,8,9,10,8
		dc.w	0,0,0,8,2,3,3,3,1,4,5,6,0,0,0,0
CrunchData4:	dc.w	0
CrunchData5:	dc.w	0

;***********************************
;*  cruncher for PACK format       *
;***********************************
Cruncher:
	CALL	SetNormalPtrCol
	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,A1
	LEA	12(A1),A1
	MOVE.L	A1,SongPlus12Ptr
	MOVE.L	A0,A1
	add.l	PatternMemAllocSize,A1
	MOVE.L	A1,SongPlus70kPtr
	MOVE.L	A0,A1
	add.l	PatternMemAllocSize,A1
	SUB.L	DiskDataLength,A1
	MOVE.L	A1,EndOfSongPtr
	MOVE.L	DiskDataLength,RealSongLength
	MOVE.L	mt_songdataptr,A0
	ADD.L	DiskDataLength,A0
	MOVE.L	mt_songdataptr,A1
	add.l	PatternMemAllocSize,A1
	MOVE.L	DiskDataLength,D0
cloop:
	MOVE.B	-(A0),-(A1)
	SUBQ.L	#1,D0
	BNE.B	cloop
	BSR.S	DoCrunch
	SUB.L	SongPlus12Ptr(PC),A2
	MOVE.L	A2,D0
	MOVE.L	D0,CrunchedSongLength
	MOVE.L	D0,D1
	ADD.L	SongPlus12Ptr(PC),D1
	MOVE.L	D1,DontKnowWhat
	MOVE.L	mt_songdataptr,A0
	MOVE.L	#'PACK',(A0)
	cmp.w	#$0040,HighPattNum
	bcs.s	no100header
	move.l	#'PAKK',(A0)
no100header:
	MOVE.L	CrunchedSongLength,4(A0)
	MOVE.L	RealSongLength(PC),8(A0)
	MOVE.L	mt_songdataptr,DiskDataPtr
	MOVE.L	CrunchedSongLength(PC),D0
	ADD.L	#12,D0
	MOVE.L	D0,DiskDataLength
	RTS


DoCrunch:
	MOVE.L	EndOfSongPtr(PC),A0
	MOVE.L	SongPlus70kPtr(PC),A1
	MOVE.L	SongPlus12Ptr(PC),A2
	MOVEQ	#1,D2
	CLR.W	D1
dcloop: BSR.S	DoCrunch2
	TST.B	D0
	BEQ.S	dcskip
	ADDQ.W	#1,D1
	CMP.W	#$0108,D1
	BNE.S	dcskip
	BSR.W	DoCrunch6
dcskip: CMP.L	A0,A1
	BGT.B	dcloop
	BSR.W	DoCrunch6
	BRA.W	DoCrunch8

DoCrunch2:
	MOVE.L	A0,A3
	LEA	$007F(A3),A3
	CMP.L	A1,A3
	BLE.S	dc2skip
	MOVE.L	A1,A3
dc2skip:
	MOVEQ	#1,D5
	MOVE.L	A0,A5
	ADDQ.L	#1,A5
dc2_1:
	MOVE.B	(A0),D3
	MOVE.B	1(A0),D4
	MOVE.W	D3,$DFF1A2			; colortable 17
dc2loop:
	CMP.B	(A5)+,D3
	BNE.S	dc2skip2
	CMP.B	(A5),D4
	BEQ.S	DoCrunch3
dc2skip2:
	CMP.L	A5,A3
	BGT.B	dc2loop
	BRA.S	dc4_3

DoCrunch3:
	SUBQ.L	#1,A5
	MOVE.L	A0,A4
dc3loop:
	MOVE.B	(A4)+,D3
	CMP.B	(A5)+,D3
	BNE.S	dc3skip
	CMP.L	A5,A3
	BGT.B	dc3loop
dc3skip:
	MOVE.L	A4,D3
	SUB.L	A0,D3
	SUBQ.L	#1,D3
	CMP.L	D3,D5
	BGE.S	dc4_2
	MOVE.L	A5,D4
	SUB.L	A0,D4
	SUB.L	D3,D4
	SUBQ.L	#1,D4
	CMP.L	#4,D3
	BLE.S	DoCrunch4
	MOVEQ	#6,D6
	CMP.L	#$00000101,D3
	BLT.S	dc3skip2
	MOVE.W	#$0100,D3
dc3skip2:
	BRA.S	dc4_1

DoCrunch4:
	MOVE.W	D3,D6
	SUBQ.W	#2,D6
	LSL.W	#1,D6
dc4_1:
	LEA	CrunchData3(PC),A6
	CMP.W	0(A6,D6.W),D4
	BGE.S	dc4_2
	MOVE.L	D3,D5
	MOVE.L	D4,CrunchData1
	MOVE.B	D6,CrunchData2
dc4_2:
	CMP.L	A5,A3
	BGT.B	dc2_1
dc4_3:
	CMP.L	#1,D5
	BEQ.S	DoCrunch5
	BSR.B	DoCrunch6
	MOVE.B	CrunchData2(PC),D6
	MOVE.L	CrunchData1(PC),D3
	MOVE.W	8(A6,D6.W),D0
	BSR.B	DoCrunch7
	MOVE.W	$0010(A6,D6.W),D0
	BEQ.S	dc4skip
	MOVE.L	D5,D3
	SUBQ.W	#1,D3
	BSR.B	DoCrunch7
dc4skip:
	MOVE.W	$0018(A6,D6.W),D0
	MOVE.W	$0020(A6,D6.W),D3
	BSR.B	DoCrunch7
	ADDQ.W	#1,$28(A6,D6.W)
	ADD.L	D5,A0
	CLR.B	D0
	RTS

DoCrunch5:
	MOVE.B	(A0)+,D3
	MOVEQ	#8,D0
	BSR.B	DoCrunch7
	MOVEQ	#1,D0
	RTS

DoCrunch6:	TST.W	D1
		BNE.S	DoCrunch6_2
		RTS

DoCrunch6_2:	MOVE.W	D1,D3
		CLR.W	D1
		CMP.W	#9,D3
		BGE.S	dc6_2
		ADDQ.W	#1,CrunchData4
		SUBQ.W	#1,D3
		MOVEQ	#5,D0
		BRA.S	DoCrunch7

dc6_2:		ADDQ.W	#1,CrunchData5
		SUB.W	#9,D3
		OR.W	#$0700,D3
		MOVEQ	#11,D0
DoCrunch7:	SUBQ.W	#1,D0
dc7loop:	LSR.L	#1,D3
		ROXL.L	#1,D2
		BCS.S	dc8_2
		DBRA	D0,dc7loop
		RTS

DoCrunch8:	CLR.W	D0
dc8_2:		MOVE.L	D2,(A2)+
		MOVEQ	#1,D2
		DBRA	D0,dc7loop
		RTS

;***********************************
;* PACK decruncher, used in Songs  *
;***********************************


Decruncher:
	MOVE.L	mt_songdataptr,A0
	LEA	12(A0),A0
	MOVE.L	EndOfSongPtr(PC),A1
	MOVE.L	CrunchedSongLength(PC),D0
	MOVE.L	RealSongLength(PC),D1
	BSR.S	DoDecrunch
	MOVE.L	EndOfSongPtr(PC),A0
	MOVE.L	mt_songdataptr,A1
	MOVE.L	RealSongLength(PC),D0

ddcloop:
	MOVE.B	(A0)+,(A1)+
	SUBQ.L	#1,D0
	BNE.B	ddcloop
	MOVE.L	mt_songdataptr,A0
	add.l	PatternMemAllocSize,A0
	MOVE.L	mt_songdataptr,A1
	ADD.L	RealSongLength(PC),A1
	SUB.L	A1,A0
	MOVE.L	A0,D0

ddcloop2:
	CLR.B	(A1)+
	SUBQ.L	#1,D0
	BNE.B	ddcloop2
	RTS

DoDecrunch:
	ADD.L	D0,A0
	MOVE.L	D1,A2
	ADD.L	A1,A2
	MOVE.L	-(A0),D0

dec_1:
	LSR.L	#1,D0
	BNE.S	decskip
	BSR.S	dec5

decskip:
	BCS.S	dec3
	MOVEQ	#8,D1
	MOVEQ	#1,D3
	LSR.L	#1,D0
	BNE.S	decskip2
	BSR.S	dec5

decskip2:
	BCS.S	dec4_1
	MOVEQ	#3,D1
	CLR.W	D4

dec_2:
	BSR.S	dec6
	MOVE.W	D2,D3
	ADD.W	D4,D3

decloop1:
	MOVEQ	#7,D1

decloop2:
	LSR.L	#1,D0
	BNE.S	decskip3
	BSR.S	dec5

decskip3:
	ROXL.L	#1,D2
	DBRA	D1,decloop2
	MOVE.B	D2,-(A2)
	DBRA	D3,decloop1
	BRA.S	dec4_3

dec2:
	MOVEQ	#8,D1
	MOVEQ	#8,D4
	BRA.S	dec_2

dec3:	MOVEQ	#2,D1
	BSR.S	dec6
	CMP.B	#2,D2
	BLT.S	dec4
	CMP.B	#3,D2
	BEQ.S	dec2
	MOVEQ	#8,D1
	BSR.S	dec6
	MOVE.W	D2,D3
	MOVE.W	#8,D1
	BRA.S	dec4_1

dec4:	MOVE.W	#9,D1
	ADD.W	D2,D1
	ADDQ.W	#2,D2
	MOVE.W	D2,D3
dec4_1: BSR.S	dec6
dec4_2: SUBQ.W	#1,A2
	MOVE.B	0(A2,D2.W),(A2)
	DBRA	D3,dec4_2
dec4_3: CMP.L	A2,A1
	BLT.S	dec_1
	RTS

dec5:	MOVE.L	-(A0),D0
	MOVE.W	D0,$DFF1A2			; colortable 17
	MOVE	#$0010,CCR
	ROXR.L	#1,D0
	RTS

dec6:	SUBQ.W	#1,D1
	CLR.W	D2
dec6loop:
	LSR.L	#1,D0
	BNE.S	dec6skip
	MOVE.L	-(A0),D0
	MOVE.W	D0,$DFF1A2			; colortable 17
	MOVE	#$0010,CCR
	ROXR.L	#1,D0
dec6skip:
	ROXL.L	#1,D2
	DBRA	D1,dec6loop
	RTS

patt100memflag: dc.w	0

;***********************************
;* load protracker module          *
;***********************************

LoadModule:
	cmp.l	#'CHG!',changeflag
	bne.s	lmodnochg

	CALL	modischanged
	cmp	#2,d0
	beq.s	lmodnochg
	rts
lmodnochg:
	clr.l	changeflag
	;BSET	 #1,$00BFE001
	;BCLR	 #1,Packetfield 	 	; Filter off
	clr.w	patt100memflag
	CLR.W	xpkflag
	bsr.w	clearcomments

ReNewMod:
	MOVE.W	#1,LoadingInProgress
	CALL	SetDiskPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#30-1,D0
.l1:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,.l1

	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1			; name
	MOVE.L	#$000003ED,D2			; accessmode
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile
	PEA	ModReadClose
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				; buffer
	MOVEQ	#4,D3				; length 4 bytes
	CALLSYS	Read
	CMP.L	#4,D0
	BNE.W	FileLoadError
	LEA	fourbytebuf,A0
	CMP.L	#'PP20',(A0)
	BEQ.W	PowerPacked			; PowerPacked
	cmp.l	#'PX20',(A0)
	beq.w	tryPowerPacker
	CMP.L	#'FORM',(A0)
	BEQ.W	LoadIFFMod
	CMP.L	#'XPKF',(A0)
	BEQ.w	xpkload
	cmp.l	#'MMD1',(A0)
	beq.w	medmodule
	cmp.l	#'MMD0',(A0)
	beq.w	medmodule
	cmp.l	#'MMD1',(A0)
	beq.w	medmodule
	cmp.l	#'MMD2',(A0)
	beq.w	medmodule
	cmp.l	#'MMD3',(A0)
	beq.w	medmodule
	cmp.l	#$000003F3,(A0)
	beq.w	isexefile
	cmp.l	#'SymM',(A0)
	beq.w	issymmod
	cmp.l	#'DIGI',(A0)
	beq.w	digiboost
	cmp.l	#'TFMX',(A0)
	beq.w	tfmx
	cmp.l	#'FC14',(A0)
	beq.w	fc14
	cmp.l	#'SOAR',(a0)
	beq.w	soar
	cmp.l	#'OCTA',(A0)
	beq.w	octasong
	cmp.l	#'IMP!',(A0)
	beq.s	fimpmodule
	bra.w	ReadMODAfterCheck

;imploded module depack

fimpmodule:
	LEA	implodedmod.MSG,A0
	CALL	ShowStatusText
	BSR.W	ModReadClose
	;MOVE.W	#$10,xpkflag
	;tst.l	ffpointer
	;beq.s	.rt
	;MOVEM.L D0-D7/A1-A6,-(SP)
	;bsr	fimpclean
	;MOVEM.L (SP)+,D0-D7/A1-A6

.rt:	RTS

;***********************************
;*powerpacker.lib depacker         *
;***********************************

PowerPacked:
	tst.l	xpkbase				;xpkmaster.lib opened ?
	beq.b	tryPowerPacker
	lea	pplibtxt,a0
	bra.s	xpkload2

tryPowerPacker:
	tst.l	PPackBase			;powerpacker.lib opened ?
	bne.s	.l1

	MOVEM.L D0-D7/A1-A6,-(SP)
	CALL	openpplib
	MOVEM.L (SP)+,D0-D7/A1-A6
.l1:
	tst.l	PPackBase
	beq	ErrorPPLib

	LEA	ReadingPowerP.MSG,A0
	CALL	ShowStatusText			;alright messy in a0
	BSR.W	ModReadClose			;close file, freemem
	MOVE.L	D0,A6
	LEA	FileName,A0			;name
	MOVEQ	#2,D0
	MOVE.L	#$00010000,D1
	LEA	ppflag(PC),A1
	LEA	PPDecrL(PC),A2
	LEA	DecrPPLib(PC),A3		;routine
	MOVE.L	PPackBase(PC),A6
	CALLSYS	Open
	MOVE.L	D0,-(SP)
	MOVE.L	ppflag(PC),outlen
	MOVE.L	(SP)+,D0			;messages in d0

	BNE.W	DecrPPLibErr			;show powerpacker.lib errormessage
	BRA.W	ReadMODAfterCheck		;no error

;**************************************
;*------ xpkmaster.library loading ---*
;**************************************

xpkload:
	tst.l	xpkbase 			;xpklib available?
	beq.s	noxpk
	lea	xpklibtxt,a0
xpkload2:
	bsr.w	ShowStatusText
	MOVE.W	#$10,xpkflag
	move.l	#FileName,A0
	move.l	A0,filename			;filename for tags
	move.l	xpkbase,a6
	lea	xpktags,a0
	CALLSYS	XpkUnpack
	tst.l	d0
	bne.s	.fail
	BRA.W	LoadIFFMod
.fail:	lea	xpkerrtxt,a0
	bsr.w	ShowStatusText
	bra	xpkclr

noxpk:	LEA	noxpklibtxt,a0
	BSR.W	ShowStatusText
	RTS

;*******************************
;* pp20 loadmessages checker   *
;*******************************

DecrPPLibErr:
	MOVE.L	D0,PPBasic
	MOVE.L	PPBasic(PC),D0
	CMP.L	#$FFFFFFFF,D0
	BNE.S	.l1
	LEA	PPOpenerror.MSG(PC),A0
	BRA.S	ErrPPLibMsg

.l1:
	CMP.L	#$FFFFFFFE,D0
	BNE.S	.l2
	LEA	PPReaderror.MSG(PC),A0
	BRA.S	ErrPPLibMsg

.l2:
	CMP.L	#$FFFFFFFD,D0
	BNE.S	.l3
	LEA	Notenoughmemo.MSG0(PC),A0
	CALL	NoMemoryRequester
	BRA.S	ErrPPLibMsg_rt

.l3:
	CMP.L	#$FFFFFFFC,D0
	BNE.S	.l4
	LEA	PowerPackedmo.MSG(PC),A0
	BRA.S	ErrPPLibMsg

.l4:
	CMP.L	#$FFFFFFFB,D0
	BNE.S	.l5
	LEA	Permissionden.MSG(PC),A0
	BRA.S	ErrPPLibMsg

.l5:
	CMP.L	#$FFFFFFFA,D0
	BNE.S	.l6
	LEA	UnknownPowerP.MSG(PC),A0
	BRA.S	ErrPPLibMsg

.l6:
	CMP.L	#$FFFFFFF9,D0
	BNE.S	PPLibWeirdErr
	LEA	PowerPackedfi.MSG(PC),A0		; empty file msg
	BRA.S	ErrPPLibMsg

PPLibWeirdErr:	LEA	WeirdPowerPac.MSG(PC),A0
		BRA.S	ErrPPLibMsg

ErrorPPLib:	LEA	CantopenPower.MSG,A0

ErrPPLibMsg:	BSR.W	ShowStatusText
ErrPPLibMsg_rt:	CLR.W	LoadingInProgress
		CLR.L	ppflag
		CALL	SetErrorPtrCol
		GOTO	DoShowFreeMem

;********************************
DecrPPLib:
	MOVE.L	4(SP),PPDecPWTag8
	MOVE.L	8(SP),PPDecPWTag6
	MOVE.W	#3,PPDecPWTag5
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	PrepScreenSwitch
	MOVE.L	IntuiBase,A6
	LEA	PPLibPWWindow(PC),A0
	CALLSYS	OpenWindow
	MOVE.L	D0,PPwordWinAdr
	BEQ.W	CantOpenPPWin
DecrPPLib1:
	CLR.W	PPDecPWTag4
	MOVE.L	PPDecPWTag8(PC),PPDecPWTag7

DecrPPLib2:
	MOVE.L	4.w,A6
	MOVE.L	PPwordWinAdr(PC),A0
	MOVE.L	$0056(A0),A0			;Port
	CALLSYS	WaitPort

	MOVE.L	PPwordWinAdr(PC),A0
	MOVE.L	$0056(A0),A0
	CALLSYS	GetMsg
	MOVE.L	D0,A0

	MOVE.L	$0014(A0),PPDecPWTag1
	MOVE.L	$0018(A0),PPWinCloseButton
	MOVE.L	D0,A1
	CALLSYS	ReplyMsg

	MOVE.L	PPDecPWTag1(PC),D0
	CMP.L	#$00200000,D0
	BNE.S	DecrPPLib2
	MOVE.W	PPWinCloseButton(PC),D0
	CMP.W	#13,D0
	BEQ.S	PPLibPWFinished

	MOVE.L	PPDecPWTag7(PC),A0
	CMP.W	#8,D0
	BNE.S	DecrPPLib3

	SUBQ.L	#1,A0
	SUBQ.W	#1,PPDecPWTag4
	BPL.S	DecrPPLib4
	MOVE.L	PPDecPWTag8(PC),A0
	CLR.W	PPDecPWTag4
	BRA.S	DecrPPLib4

DecrPPLib3:
	MOVE.B	D0,(A0)+
	ADDQ.W	#1,PPDecPWTag4
	CMP.W	#$0010,PPDecPWTag4
	BNE.S	DecrPPLib4
	SUBQ.L	#1,A0
	SUBQ.W	#1,PPDecPWTag4
DecrPPLib4:
	MOVE.L	A0,PPDecPWTag7
	BRA.W	DecrPPLib2

*---
PPLibPWFinished:
	MOVE.L	PPDecPWTag7(PC),A0
	CLR.B	(A0)
	MOVE.L	PPDecPWTag8(PC),A0
	MOVE.L	PPackBase(PC),A6
	JSR	-$002A(a6)
	CMP.L	PPDecPWTag6(PC),D0
	BEQ.S	PPOkPass			; password ok

	BSR.B	PPNoPass
	SUBQ.W	#1,PPDecPWTag5
	BGT.W	DecrPPLib1
	MOVE.L	IntuiBase,A6			; org(PC)
	MOVE.L	PPwordWinAdr(PC),A0
	CALLSYS	CloseWindow

CantOpenPPWin:
	CALL	ScrSwitch2
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D0
	RTS

;--- Password ok, close requester and load --
PPOkPass:
	MOVE.L	IntuiBase,A6
	MOVE.L	PPwordWinAdr(PC),A0
	CALLSYS	CloseWindow
	CALL	ScrSwitch2
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#-1,D0
	RTS

;--- no correct password, alert and close ---
PPNoPass:
	SUB.L	A0,A0
	MOVE.L	IntuiBase,A6
	CALLSYS	DisplayBeep
	MOVE.L	PPwordWinAdr(PC),A0		; windows addr
	LEA	Incorrectpass.MSG(PC),A1
	MOVE.L	#$FFFFFFFF,A2			; clone screenvars
	CALLSYS	SetWindowTitles
	MOVE.L	DOSBase,A5
	MOVEQ	#$50,D1
	JSR	_LVODelay(A5)			; wait 1/2 sec
	MOVE.L	PPwordWinAdr(PC),A0
	LEA	PPWinTitle(PC),A1
	MOVE.L	#$FFFFFFFF,A2
	CALLSYS	SetWindowTitles
	RTS

PPDecPWTag1:		dc.l	0
PPwordWinAdr:		dc.l	0
PPWinCloseButton:	dc.l	0
PPDecPWTag4:		dc.w	0
PPDecPWTag5:		dc.w	0
PPDecPWTag6:		dc.l	0
PPDecPWTag7:		dc.l	0
PPDecPWTag8:		dc.l	0


*********************************
* powerpacked password input    *
* window                        *
*********************************

PPLibPWWindow:		dc.w	$00E1		;225, leftedge
			dc.w	$0032		;50,  topedge
			dc.w	$00D0		;208, width
			dc.w	$0016		;11,  height

			dc.b	$01,$03		;DetailPen, BlockPen

			dc.l	$00201000	;IDCMPFlags
			dc.l	$00001006	;Flags
			dc.l	0		;Gadget firstgadget
			dc.l	0		;Image CheckMark
			dc.l	PPWinTitle	;WindowTitle
			dc.l	0		;Screen
			dc.l	0		;own bitmap for window

			dc.w	$0096		;minwidth
			dc.w	$0032		;minheight
			dc.w	$0140		;maxwidth
			dc.w	$00C8		;maxheight
			dc.w	$0001		;windowtype

PPWinTitle:		dc.b	'  ENTER PASSWORD',0

			EVEN
Incorrectpass.MSG:	dc.b	'INCORRECT PASSWORD',0
			EVEN
ReadingPowerP.MSG:	dc.b	'READING POWERPACKED MODULE',0
			EVEN
implodedmod.MSG:	dc.b	'READING IMPLODED MODULE',0
			EVEN

Notenoughmemo.MSG0:	dc.b	10,10,10,'   Not enough memory',$A
			dc.b	'    for decruncher!',0
			EVEN

PPOpenerror.MSG:	dc.b	'PP20 OPEN ERROR!!',0
			EVEN

PPReaderror.MSG:	dc.b	'PP20 READ ERROR!!',0
			EVEN

PowerPackedmo.MSG:	dc.b	'ENCRYPTED MODULE!',0
			EVEN

Permissionden.MSG:	dc.b	'PERMISSION DENIED!',0
			EVEN

UnknownPowerP.MSG:	dc.b	'UNKNOWN PP20 VERSION!',0
			EVEN

PowerPackedfi.MSG:	dc.b	'POWERPACKED FILE EMPTY!',0
			EVEN

WeirdPowerPac.MSG:	dc.b	'WEIRD PP20 ERROR!?',0
			EVEN

PPBasic:	dc.l	0
ppflag: 	dc.l	0
PPDecrL:	dc.l	0
ppoutlen:	dc.l	0
PPackBase:	dc.l	0

;***********************************
;* initial checks done, read mod   *
;***********************************
ReadMODAfterCheck:
	MOVE.L	DOSBase,a6
	MOVE.L	FileHandle,D1
	MOVE.L	#sd_mahokakt,D2 	;pos offst
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead		;seek read
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2			;buffer in d2
	MOVEQ	#4,D3			;length
	BSR.W	ModReadRead		;read
	CMP.L	#4,D0
	BNE.W	FileLoadError		;file type mismatch
	LEA	fourbytebuf,A0		;buffer
	CMP.L	#'M.K.',(A0)		;check m.k.
	BEQ.W	lmskip			;yep, 2.X or 3.X valid
	cmp.l	#'!PM!',(A0)
	beq.w	lmskip
	cmp.l	#'FLT4',(A0)
	beq.w	lmskip
	cmp.l	#'EXO4',(a0)
	beq.w	lmskip
	cmp.l	#'8CHN',(a0)
	beq.w	get8chn
	cmp.l	#'6CHN',(A0)
	beq	get6chn
	CMP.L	#'M!K!',(A0)			; 100 pattern 2.3 MOD
	beq.w	get100pat
	;bra.w	lmskip

	BSR.B   MahoneyAndKaktus                ; msg no standard mod
	CMP.L   #2,D0
	BNE.w   loadoldsoundtracker

	bsr.w	ModReadClose
	lea	unknownmodtxt(PC),a0
	bra.w	mismret

;************************************
;* load old 15-Sample Soundtracker  *
;* module format (with request)     *
;************************************
MahoneyAndKaktus:
	MOVE.W  #$FFFF,DirCopFlag
	CALL   ClearRightAreaReq
	LEA     Thisfileisnot.MSG(PC),A0
	LEA     NotStandardSongData,A1
	LEA     lbL019804,A2
	MOVE.L  #$00000460,D0
	CALL	SwapBoxMem
.l1:
	CALL	DoKeyBuffer
	BTST    #6,$00BFE001
	BNE.S   .l1

	MOVEM.W (MouseX),D0/D1
	LEA     lbL019418,A0
	CALL	MousXTablKonv
	TST.W   D2
	BEQ.B   .l1

	CMP.W   #1,D2
	BEQ.S   .l2
	CMP.W   #2,D2
	BEQ.S   .l3
	CMP.W   #3,D2
	BEQ.S   .l4
	CMP.W   #10,D2
	BNE.S   .l1

	CALL	Screenswitch
	BRA.B   .l1

.l2:	MOVEQ   #1,D0
	BRA.S   .ret

.l3:	MOVEQ   #2,D0
	BRA.S   .ret

.l4:	MOVEQ   #3,D0
.ret:	MOVE.L  D0,-(SP)
	CALL	OpenRequester
	CLR.W   DirCopFlag
	MOVE.L  (SP)+,D0
	RTS

;**************************************

Thisfileisnot.MSG:
	dc.b    10,10,'This file is not a standard',$A
	dc.b    'ProTracker module! Load as',$A
	dc.b    '31 or 15 instruments module?',0
	EVEN

;**************************************
LoadMahoneyAndKaktus:
	BSR.W   MahoneyAndKaktus
	CMP.W   #2,D0
	BEQ.S   .skip

	CMP.W   #3,D0
	BEQ.S   .putmk				; load as 31 instr mod
	MOVE.L  mt_songdataptr,A0
	LEA     $01D2(A0),A1
	ADD.L   #$000101D6,A0
.l1:
	MOVE.L  (A0),$01E4(A0)
	CLR.L   (A0)
	SUBQ.L  #4,A0
	CMP.L   A0,A1
	BNE.B   .l1

	MOVE.L  mt_songdataptr,A0
	LEA     sd_mahokakt(A0),A1
	LEA     sd_numofpatt(A0),A0
.l2:
	MOVE.W  4(A0),(A0)+
	CMP.L   A0,A1
	BNE.S   .l2
	MOVE.L  #'M.K.',(A0)
	MOVEQ   #0,D0
	RTS

.putmk:
	MOVE.L  mt_songdataptr,A0
	MOVE.L  #'M.K.',sd_mahokakt(A0)
	MOVEQ   #-1,D0
	RTS

.skip:	MOVEQ   #-2,D0
	RTS

;****************************
loadoldsoundtracker:
	bsr.w	settofour			; always 4channelmode
	CMP.L   #1,D0
	BEQ.W   lmskip
	CALL	DoClearSong
	CALL	DoClearSamples
	LEA     Loadingmodule.MSG,A0
	BSR.W   ShowStatusText
	MOVE.L  DOSBase,A6
	MOVE.L  FileHandle,D1
	MOVEQ   #0,D2
	MOVEQ   #-1,D3
	BSR.W   ModSeekRead
	MOVE.L  FileHandle,D1
	MOVE.L  mt_songdataptr,D2       	; buffer
	MOVE.L  #470,D3 	          	; length
	BSR.W   ModReadRead             	; read
	CMP.L   #470,D0
	BNE.W   FileLoadError
	MOVE.L  mt_songdataptr,A0
	ADD.L   #470,A0
	MOVEQ   #15,D0				; 15 samples
.l1:	MOVEQ   #20-1,D1
.l2:	CLR.B   (A0)+
	DBRA    D1,.l2
	CLR.W   (A0)+
	CLR.W   (A0)+
	CLR.W   (A0)+
	CLR.W   (A0)+
	MOVE.W  #1,(A0)+
	DBRA    D0,.l1

	MOVE.L  FileHandle,D1
	MOVE.L  mt_songdataptr,D2
	ADD.L   #sd_numofpatt,D2		; 950
	MOVE.L  #$00000082,D3
	BSR.W   ModReadRead
	CMP.L   #$00000082,D0
	BNE.W   FileLoadError
	MOVE.L  mt_songdataptr,A0
	MOVE.B  #$7F,sd_ntflag(A0)
	BRA.W	GetSamples

;************************************
;* allocate more mem, you have only *
;* 63 pattmode and mod has more     *
;************************************

get100pat:

	TST.W	patt100memflag			; already 100patternmode?
	BNE.W	lmskip				; yes
	TST.B	patt100flag
	BNE.W	lmskip				; 100pattmode is on

	BSR.W	ModReadClose
	lea	mod100first.msg,a0
	CALL	ShowStatusText
	rts
;*************************************
;* 6 channel mod alloc               *
;*************************************

get6chn:
	chn8test
	BEQ.S	.l1

	move.w	#1,newalloc			;switch to 8channelmode
	bclr	#5,Packetfield
	CALL	showmode
	move.w	#6,numchans
	bra.b	lmskip2

.l1:	CALL	DoClearSong
	CALL	DoClearSamples
	move.w	#6,numchans
	bra.s	lmskip2

;*************************************
;* 8 channel mod alloc               *
;*************************************

get8chn:
	chn8test
	BEQ.S	.l1

	move.w	#1,newalloc			;switch to 8channelmode
	bclr	#5,Packetfield
	CALL	showmode
	move.w	#8,numchans
	bra.b	lmskip2

.l1:	CALL	DoClearSong
	CALL	DoClearSamples
	move.w	#8,numchans
	bra.s	lmskip2


;*************************************
;* begin of standard PT load routine *
;* get mod songdatas ($43C Bytes)    *
;*************************************

lmskip:
	chn8test
	BNE.S	.l0	 			;8channelmode ?
	move.w	#1,convert2_8			;yes

.l0:	CALL	DoClearSong
	CALL	DoClearSamples			;message out

lmskip2:
	LEA	Loadingmodule.MSG,A0
	chn8test
	BNE.S	noconvert1
	TST.W	convert2_8
	BEQ.S	noconvert1
	LEA	ConvertingModule.MSG,A0
noconvert1:
	BSR.W	ShowStatusText
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVEQ	#0,D2
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead
lmnorml:
	MOVE.L	FileHandle,D1
	MOVE.L	mt_songdataptr,D2		;Buffer
	MOVE.L	#sd_patterndata,D3		;length
	BSR.W	ModReadRead
	CMP.L	#sd_patterndata,D0
	BNE.W	FileLoadError			;file type mismatch
	MOVE.L	mt_songdataptr,A0
	MOVE.B	#$7F,sd_ntflag(A0)

GetSamples:
	LEA	Loadingmodule.MSG,A0
	chn8test
	BNE.S	.chn8_2

	TST.W	convert2_8
	BEQ.S	.chn8_2
	LEA	ConvertingModule.MSG,A0

.chn8_2:
	BSR.W	ShowStatusText
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D0
	MOVE.B	-1(A0),D0
	MOVEQ	#0,D3
.sloop:
	CMP.B	(A0)+,D3
	BHI.S	.getsamples
	MOVE.B	-1(A0),D3

;***********************************
;* sample loading part routine     *
;***********************************

.getsamples:

	DBRA	D0,.sloop

	ADDQ.W	#1,D3
	lsl.l	#8,d3
	LSL.L	#2,D3

	chn8test
	BNE.s	.load4chn

	TST.W	convert2_8
	BEQ.S	.im4

	MOVE.L	D3,d5

	move.w	numchans,d6
	cmp.w	#4,d6
	beq.s	.chn4
	cmp.w	#6,d6
	beq.s	.chn6
	cmp.w	#8,d6
	beq.s	.chn8

.chn4:	lsr.l	#4,d3
	bra.s	.chnc

.chn6:	lsr.l	#6,d3
	bra.s	.chnc

.chn8:	LSR.L	#8,D3

.chnc:	LSR.L	#2,D3
	;SUB.L	#1,D3
	MOVE.L	D3,D5
	;MULU	#64,D5
	LSL.L	#6,D5				; orgmulu
	SUBQ.L	#1,D5
	MOVE.L	mt_songdataptr,D2
	ADD.L	#sd_patterndata,D2		; after the $43C Bytes
	MOVEQ	#0,D4
.cloop:
	MOVEM.L D3-D5,-(SP)
	MOVE.L	FileHandle,D1
	MOVE.L	mt_songdataptr,D2
	ADD.L	#sd_patterndata,D2		; after the $43C Bytes
	LSL.L	#5,D4
	ADD.L	D4,D2
	MOVE.L	DOSBase,A6
	MOVEQ	#16,D3
	BSR.W	ModReadRead			; read
	MOVEM.L (Sp)+,D3-D5
	ADDQ.L	#1,D4
	DBRA	D5,.cloop

	BRA.S	.convtok

;**************************************
.im4:
	LSL.L	#1,D3
.load4chn:
	MOVE.L	FileHandle,D1
	MOVE.L	mt_songdataptr,D2		; Buffer
	ADD.L	#sd_patterndata,D2		; after the $43C Bytes
	MOVE.L	DOSBase,A6
	BSR.W	ModReadRead			; read

.convtok:
	CLR.W	convert2_8
	CLR.L	PatternNumber
	CLR.L	playpos
	BSR.W	RedrawPattern
	CLR.W	ScrPattPos
	BSR.W	SetScrPatternPos
	MOVE.W	#1,InsNum
	BSR.W	CheckAbort
	BEQ	.instend

	BTST	#4,PackMode
	BEQ.S	.instlop
	CALL	ExitFromDir

.instlop:
	BTST	#5,PackMode			; load without samples flag?
	BEQ.S	.rmi

	CALL	DoClearSamples
	bra	.instend

.rmi:	BSR.W	CheckAbort
	BEQ.W	.instend

	BSR.W	ShowSampleInfo
	MOVE.W	InsNum,TuneUp
	CALL	DoShowFreeMem

	MOVE.L	mt_songdataptr,A0
	MOVE.W	InsNum,D7
	MULU	#$001E,D7			; counter of act smpl-startadr in d7

	MOVEQ	#0,D0
	MOVE.W	12(A0,D7.W),D0			; sample with loop?
	BEQ.W	.rnext				; no

	MOVE.B	14(A0,D7.W),D1
	BTST	#7,D1
	SNE	D1
	MOVE.B	D1,SmplLopTBuf
	ADD.L	D0,D0
	MOVE.L	4.w,a6
	MOVE.L	XDmaType,D1			; change to public for Fast Replay!
	MOVE.L	D0,-(SP)
	CALLSYS	AllocMem
	MOVE.L	(SP)+,D6
	TST.L	D0
	BNE.S	.ok

	BSR.W	OutOfMemErr
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	D6,D2
	MOVEQ	#0,D3
	BRA	.rnext

.ok:	MOVE.W	InsNum,D7
	LSL.W	#2,D7
	LEA	mt_songdataptr,A0
	MOVE.L	D0,0(A0,D7.W)
	MOVE.L	D6,$7C(A0,D7.W)
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	D0,D2
	MOVE.L	D6,D3
	BSR.W	ModReadRead
	TST.B	SmplLopTBuf
	BEQ	.rdraw

	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1			; file
	MOVE.L	#SmplLoad4Buf,D2		; buffer
	MOVEQ	#4,D3				; 4 bytes
	BSR.W	ModReadRead
	MOVE.L	SmplLoad4Buf,D2
	BEQ.S	.rdraw

	MOVE.L	D2,D0
	MOVE.L	D2,-(SP)
	MOVE.L	4.w,a6
	MOVEQ	#0,D1
	CALLSYS	AllocMem
	MOVE.L	(SP)+,D2
	TST.L	D0
	BNE.S	.ok2

	BSR.W	OutOfMemErr
	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	MOVE.L	D6,D2
	MOVEQ	#0,D3
	BRA.S	.rnext

.ok2:	LEA	MSamPointer,A0
	MOVE.W	InsNum,D1
	LSL.W	#3,D1
	ADD.W	D1,A0
	MOVE.L	D0,(A0)
	MOVE.L	D2,4(A0)
	MOVE.L	D2,D3					; length for read
	MOVE.L	D0,D2					; bufferaddress to d2 for read
	MOVE.L	mt_mxbuf4base,D1
	MOVE.W	InsNum,D0
	BSET	D0,D1
	MOVE.L	D1,mt_mxbuf4base

	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1				; file for read
	BSR	ModReadRead				; load sample

.rdraw:	BSR.W	RedrawSample
.rnext:	cmp.w	#6,numchans				; 6CHN?
	bne.s	.rfix
	move.w	#8,numchans


;  included to check first 2 bytes of sample
;  if replen = 0 sample will be fixed

.rfix:
	BSR.W	ClearSamStarts
	move.l	mt_songdataptr,a0
	lea	12(a0),a0
	moveq	#0,d0
	move.w	InsNum,d0
	mulu	#$001E,d0
	add.l	d0,a0
	cmp.w	#0,6(a0)
	bne.s	.no
	addq.w	#1,6(A0)		; fix to minlen = 1 if its 0
.no:	ADDQ	#1,InsNum
	CMP.w	#MaxInsNum+1,InsNum
	BNE	.instlop
;---
.instend:
	MOVE.L	FileHandle,D1
	BEQ.S	.pack
	MOVE.L	DOSBase,A6
	CALLSYS	Close
	CLR.L	FileHandle
.pack:
	MOVE.W	#1,InsNum
	MOVE.L	#6,mt_speed
	CLR.W	LoadingInProgress
	BSR.W	ShowAllRight
	CALL	SetNormalPtrCol
	BSR.W	CheckInstrLengths
	BSR.W	ShowSampleInfo
	BSR.W	RedrawSample

	BTST	#4,PackMode
	BNE.S	letdirscopen
	CALL	FNameInDir
letdirscopen:
	MOVEQ	#15,D7
	CALL	DoShowFreeMem
	cmp.w	#1,CurrScreen
	bne.b	.skip
	lea	fo_comments,a0
	tst.l	(a0)
	bne.w	entercomment
.skip:	RTS

convert2_8:	dc.w	0

;***********************************
;* pt's _LVORead subroutine        *
;***********************************

ModReadRead:
	tst.l	ppflag
	bne.s	.p1
	TST.W	xpkflag
	BNE.S	.x1
	JMP	_LVORead(A6)

.x1:	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	outlen,A1
	MOVE.L	D2,A0
.x2:	MOVE.B	(A1)+,(A0)+
	SUBQ.L	#1,D3
	BNE.S	.x2
	MOVE.L	A1,outlen
	MOVEM.L (SP)+,D1-D7/A0-A6
	MOVE.L	D3,D0
	RTS
.p1:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	ppoutlen(PC),A1
	MOVE.L	D2,A0
.p2:	MOVE.B	(A1)+,(A0)+
	SUBQ.L	#1,D3
	BNE.S	.p2
	MOVE.L	A1,ppoutlen
	MOVEM.L (SP)+,D1-D7/A0-A6
	MOVE.L	D3,D0
	RTS

;***********************************
;*   seek parts of mod load        *
;***********************************

ModSeekRead:
	tst.l	ppflag
	bne.s	ppseek
	TST.W	xpkflag
	BNE.S	xpkseek
	TST.W	ExeRead
	BEQ.S	.nor
	ADD.L	#5520+4,D2
.nor:	JMP	_LVOSeek(A6)

;***********************************

xpkseek:
	CMP.L	#$FFFFFFFF,D3
	BEQ.S	.x5
	CMP.L	#1,D3
	BEQ.S	.x6
	TST.L	D3
	BEQ.S	.x7
	RTS
.x7:	ADD.L	D2,outlen
	MOVE.L	D2,D0
	RTS
.x5	MOVE.L	outbuf,outlen
	ADD.L	D2,outlen
	MOVE.L	D2,D0
	RTS
.x6:	MOVE.L	outbuf,outlen
	SUB.L	D2,outlen
	MOVE.L	D2,D0
	RTS

;***************************

ppseek:	CMP.L	#$FFFFFFFF,D3
	BEQ.S	.p5
	CMP.L	#1,D3
	BEQ.S	.p6
	TST.L	D3
	BEQ.S	.p7
	RTS
.p7:	ADD.L	D2,ppoutlen
	MOVE.L	D2,D0
	RTS
.p5:	MOVE.L	ppflag(PC),ppoutlen
	ADD.L	D2,ppoutlen
	MOVE.L	D2,D0
	RTS
.p6:	MOVE.L	ppflag(PC),ppoutlen
	SUB.L	D2,ppoutlen
	MOVE.L	D2,D0
	RTS

;***********************************

ModReadClose:
	MOVE.L	FileHandle,D1
	BEQ.S	.packed

	MOVE.L	DOSBase,A6
	CALLSYS	Close
	CLR.L	FileHandle
.packed:
	TST.W	xpkflag
	BEQ.S	noxpkc

xpkclr:	CLR.W	LoadingInProgress
	move.l	outbuf,d0
	beq.s	.x1
	move.l	d0,a1
	move.l	outbuflen,d0
	move.l	4.w,a6
	CALLSYS	FreeMem
.x1:	moveq	#0,D0
	RTS

noxpkc:	move.l	ppflag,d0
	tst.l	ppflag
	beq.s	.ret
	move.l	ppflag(PC),d0
	MOVE.L	D0,A1
	MOVE.L	PPDecrL(PC),D0
	MOVE.L	4.w,A6
	CALLSYS	FreeMem
	CLR.L	ppflag

.ret:	CLR.W	LoadingInProgress
	RTS

;***********************************
;* misc format known               *
;***********************************

medmodule:
	bsr.s	ModReadClose
	LEA	medmod.txt(PC),A0
	bra.s	mismret
isexefile:
	bsr.s	ModReadClose
	GOTO	LoadExecutable
issymmod:
	bsr	ModReadClose
	lea	issymmodtxt(PC),a0
	bra.s	mismret
digiboost:
	bsr	ModReadClose
	lea	digiboosttxt(PC),a0
	bra.s	mismret

tfmx:	bsr	ModReadClose
	lea	tfmxtxt(PC),a0
	bra.s	mismret
fc14:
	bsr	ModReadClose
	lea	fc14txt(PC),a0
	bra.s	mismret

soar:	bsr.w	ModReadClose
	lea	soartxt(PC),a0
	bra.s	mismret

octasong:
	bsr.w	ModReadClose
	lea	octalyzertxt(PC),a0
	bra.s	mismret
;**********************************
FileLoadError:
	BSR.W	ModReadClose
	CALL	DoClearSong
	CALL	DoClearSamples
	LEA	Mismatchfilet.MSG(PC),A0
mismret:
	BSR.W	ShowStatusText
	CALL	WaitALittle
	GOTO	SetErrorPtrCol

;***********************************
;* load an iff-modl pt module      *
;***********************************

LoadIFFMod:

	MOVE.L	DOSBase,a6
	MOVE.L	FileHandle,D1
	MOVEQ	#$8,D2				; offset
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead			; seek read
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				; buffer in d2
	MOVEQ	#4,D3				; length
	BSR.W	ModReadRead			; read
	CMP.L	#4,D0
	BNE.B	FileLoadError			; file type mismatch
	LEA	fourbytebuf,A0			; buffer
	CMP.L	#'MODL',(A0)
	beq.s	itsnew
	cmp.l	#'8SVX',(A0)
	beq.w	ItsSample
	cmp.l	#'PTCF',(A0)
	beq.w	itstrack
	BRA.W	ReadMODAfterCheck

itsnew:
	move.l	#0,iffscount			; clear mt_seekcounter
	LEA	modform.txt,A0
	BSR.W	ShowStatusText
;load iff
	CALL	DoClearSong
	CALL	DoClearSamples			; message out

loadlp:

	MOVE.L	DOSBase,a6
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead			; seek read
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2				; buffer in d2
	MOVEQ	#4,D3				; length
	BSR.W	ModReadRead			; read
	CMP.L	#4,D0
	BNE.W	FileLoadError			; file type mismatch
	addq.l	#$00000001,iffscount
	LEA	fourbytebuf,A0			; buffer
	cmp.l	#'VERS',(A0)
	beq.w	setversion
	cmp.l	#'INFO',(A0)
	beq.w	setmodparams
	cmp.l	#'CMNT',(A0)
	beq.W	setcomments
	CMP.L	#'PTDT',(A0)
	beq.s	itsiffstart

	bra.s	loadlp

itsiffstart:
	cmp.w	#$40,fo_patterns
	bcs.w	itsno100patt
	tst.w	patt100memflag			; already allocated?
	bne.w	itsno100patt			; yeah load
	TST.B	patt100flag
	bne.w	itsno100patt			; in prefs
iff100alloc:
	move.l	mt_songdataptr,d1
	beq.s	iff100alloc2
	move.l	d1,a1
	move.l	PatternMemAllocSize,d0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
iff100alloc2:
	EOR.B	#1,patt100flag
	MOVE.L  #sd_patterndata+64*1024,PatternMemAllocSize

no8mode80:
	MOVE.L	#63,MaxPattLength
	chn8test
	BNE.S	no8mode81

	MOVE.L	#sd_patterndata+128*1024*2,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
	bra.s	iff100alloc3

no8mode81:
	TST.B	patt100flag
	beq.s	iff100alloc3
	MOVE.L  #sd_patterndata+100*1024,PatternMemAllocSize
	MOVE.L	#99,MaxPattLength
iff100alloc3:
	MOVE.L	PatternMemAllocSize,D0
	MOVE.L	#64*1024+1,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,mt_songdataptr
	BNE.S	iff100alloc4
	CALL	OutOfMemErr
	MOVE.W	#1,patt100memflag
	BRA.W	iff100alloc

iff100alloc4:
	MOVE.L	FileHandle,D1
	MOVE.L	DOSBase,A6
	CALLSYS	Close
	BRA.W	ReNewMod

itsno100patt:

	MOVE.L	DOSBase,A6
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,D2				; 4 offset, skip PTRN
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead
	bsr.w	lmnorml 			; read normal mod

SPrfroIFFM:
	move.w	fo_patterns,HighPattNum
	move.w	fo_volume,TremoloByte
	move.w	fo_dspeed,RealTempo
	;move.w fo_dspeed,BPMTempo

	bchg	#5,fo_packetf
	move.w	fo_packetf,Packetfield

	;cmp.w	#22,Volume
	;bcs.s	-l1	 			; old config, volume over 22?
	;move.w #00,Volume			; max volume

.l1:	CALL	BlitManyThings
	BSR.W	RfshChanTog
	CALL	SetTempo

	BTST	#4,PackMode			; autoexit?
	beq.s	.l2
	GOTO	DctMainScr1_7
.l2:
	MOVEQ	#15,D7
	GOTO	DoShowFreeMem

;*********************************
;--- from INFO chunk > vers hunk *
;*********************************

setversion:
	LEA	verhunk.txt,A0
	BSR.W	ShowStatusText
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,d2
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead
	MOVE.L	FileHandle,D1
	lea	fo_modver,a0			; buffer
	move.l	a0,d2
	moveq	#6+4+2,d3			; length
	bsr.w	ModReadRead			; get real pt version
	BRA.W	loadlp				; get next chunk

;--- info hunk
setmodparams:
	LEA	infohunk.txt,A0
	BSR.W	ShowStatusText
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$7,d2				; skip infochunk+length
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead

;---songname
	MOVE.L	FileHandle,D1
	lea	fo_songname,a0			; buffer
	move.l	a0,d2
	moveq	#64,d3				; length
	bsr	ModReadRead			; get real songname
	BRA	loadlp

	chn8test			; 8 channels in prefs on?
	BNE.S	.chn4	 			; no
	MOVE.W	#1,checkfornew
.chn4:	BTST	#5,fo_packetf			; has iff mod 8chn flag?
	BEQ.S	.chn8 				; no
	TST.W	checkfornew
	BEQ	loadlp	 			; get next chunk
	bra.s	.chn82
.chn8:	CMP.W	#1,checkfornew
	BEQ.W	loadlp	 			; get next chunk

.chn82:	move.w  fo_packetf,Packetfield
	move.w #1,newalloc
	MOVEM.L	D0-A6,-(SP)
	CALL	showmode
	MOVEM.L	(SP)+,D0-A6
	BRA.W	ReNewMod

checkfornew:	dc.w	0

;*******************************
setcomments:
	LEA	cmnthunk.txt,A0
	BSR.W	ShowStatusText
	MOVE.L	FileHandle,D1
	move.l	iffscount,d2
	addq.l	#$3,d2				; skip cmntchunk
	MOVEQ	#-1,D3
	BSR.W	ModSeekRead

	move.l	FileHandle,d1
	lea	lengthbit,a0			; read chunklength of CMNT
	move.l	a0,d2
	moveq	#4,d3
	bsr.w	ModReadRead

	;songname
	MOVE.L	FileHandle,D1
	lea	fo_author,a0			; buffer
	move.l	a0,d2
	moveq	#32,d3				; length
	LEA	modhunk.txt,A0
	BSR.W	ShowStatusText
	bsr.w	ModReadRead			; author
	move.l	FileHandle,d1
	lea	fo_comments,a0
	move.l	a0,d2
	move.l	lengthbit,d3
	sub.l	#32,d3
	bsr.w	ModReadRead			; comments
	BRA	loadlp				; get next chunk

ItsSample:
	BSR.W	ModReadClose
	CALL	DoClearSamples
	BRA.W	LoadSample

itstrack:
	bsr.w	FileLoadError
	bsr.w	ModReadClose
	RTS

;***********************************
;* updates iff chunks to screenpara*
;* (configuration load and update) *
;***********************************

RfshChanTog:
	chn8test
	bne.w	settofour

	bclr	#5,Packetfield
	move.w	#8,numchans

	LEA	audchan1toggle,A0
	MOVE.W	#38,2(a0)
	LEA	audchan2toggle,A0
	MOVE.W	#74,2(a0)
	LEA	audchan3toggle,A0
	MOVE.W	#110,2(a0)
	LEA	audchan4toggle,A0
	MOVE.W	#146,2(a0)

	LEA	audchan5toggle,A0
	MOVE.W	#182,2(a0)
	LEA	audchan6toggle,A0
	MOVE.W	#218,2(a0)
	LEA	audchan7toggle,A0
	MOVE.W	#254,2(a0)
	LEA	audchan8toggle,A0
	MOVE.W	#290,2(a0)

	TST.W	SamScrEnable
	BEQ.S	sgto8chan2
	BSR.W	ExitFromSam

sgto8chan2:
	TST.W	newalloc
	BEQ.S	sgto8chan3
	CALL	allocatepattbuff

sgto8chan3:
	MOVE.L	#Channels8,A0
	CALL	LowerDecrunch
	CALL	gagame

	MOVE.W	#0,PattCurPos
	CALL	UpdateCursorPos
	RTS

;********************************
;4 channels
settofour:
	bset	#5,Packetfield
	move.w	#4,numchans

	LEA	audchan1toggle,A0
	MOVE.W	#$3a,2(a0)
	LEA	audchan2toggle,A0
	MOVE.W	#$82,2(a0)
	LEA	audchan3toggle,A0
	MOVE.W	#$ca,2(a0)
	LEA	audchan4toggle,A0
	MOVE.W	#$112,2(a0)
	TST.W	SamScrEnable
	BEQ.S	sgto4chan2
	BSR.W	ExitFromSam

sgto4chan2:
	TST.W	newalloc
	BEQ.S	sgto4chan3
	CALL	allocatepattbuff

sgto4chan3:
	MOVE.L	#Channels4,A0
	CALL	LowerDecrunch
	CALL	gagame
	MOVE.W	#0,PattCurPos
	CALL	UpdateCursorPos
	RTS

;*************************************

LoadPattern:

	MOVE.W	#6,DirFBitt

	MOVE.W	#1,LoadingInProgress
	CALL	SetDiskPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#$1D,D0
leloop3:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,leloop3

	LEA	LoadPatternTxt,A0
	CALL	ShowStatusText

	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1
	MOVE.L	#$3ED,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile

	MOVE.L	FileHandle,D1
	LEA	eightbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#16,D3
	CALLSYS	Read
	CMP.L	#16,D0
	BNE.W	FileLoadError

	LEA	eightbytebuf,A0
	CMP.L	#'FORM',(A0)+
	BNE.W	NoPattFile
	CMP.L	#'PATT',$8(A0)
	beq.s	itpattf
	cmp.l	#'TRCK',$8(A0)
	beq.w	ittrckf

	BRA.B	NoPattFile

itpattf:
	MOVE.L	FileHandle,D1
	MOVE.L	#PatternBuffer,D2

	chn8test
	BNE.S	load4track

	MOVE.L	#2048,D3
	CALLSYS	Read
	CMP.L	#2048,D0
	BNE.S	NoPattFile
	bra.s	ldtrcen
load4track:
	MOVE.L	#1024,D3
	CALLSYS	Read
	CMP.L	#1024,D0
	BNE.S	NoPattFile

ldtrcen:
	BSR.B	calcloadtr
	CALL	PastePattern

	move.l	DOSBase,a6
	move.l	FileHandle,d1
	CALLSYS	Close

	LEA	Allright.MSG,A0
	CALL	ShowStatusText
	CALL	SetNormalPtrCol
	BRA.W	RedrawPattern

NoPattFile:
	LEA	NoPatternTxt,A0
	CALL	ShowStatusText

	moveq	#5,d3
.loo:	CALL	Wait_4000
	dbra	d3,.loo

	LEA	Allright.MSG,A0
	CALL	ShowStatusText
	move.l	DOSBase,a6
	move.l	FileHandle,d1
	CALLSYS	Close
	BRA.W	RedrawPattern

;---
calcloadtr:
	moveq	#0,d0
	MOVE.W	PattCurPos,D0
	DIVU	#6,D0

	AND.L	#3,D0
	LSL.L	#2,D0
	MOVE.L	D0,A0
	ADD.L	mt_songdataptr,A0
	LEA	sd_patterndata(A0),A0
	MOVE.L	PatternNumber,D0
	LSL.L	#8,D0
	LSL.L	#2,D0


	chn8test
	bne.s	nocloa
	lsl.l	#1,d0
nocloa:
	ADD.L	D0,A0
	RTS

;***********************************

LoadTrack:

	MOVE.W	#1,LoadingInProgress
	CALL	SetDiskPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#$1D,D0
leloop4:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,leloop4

	LEA	LoadTrackTxt,A0
	CALL	ShowStatusText

	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1
	MOVE.L	#$3ED,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile

	MOVE.L	FileHandle,D1
	LEA	eightbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#16,D3
	CALLSYS	Read
	CMP.L	#16,D0
	BNE.W	FileLoadError

	LEA	eightbytebuf,A0
	CMP.L	#'FORM',(A0)+
	BNE.B	NoTrackFile
	CMP.L	#'TRCK',$8(A0)
	beq.s	ittrckf
	cmp.l	#'PATT',$8(A0)
	beq.w	itpattf

	BRA.B	NoTrackFile

ittrckf:
	MOVE.L	FileHandle,D1
	MOVE.L	#TrackBuffer,D2
	MOVE.L	#256,D3
	CALLSYS	Read
	CMP.L	#256,D0
	BNE.S	NoTrackFile

	BSR.W	calcloadtr			; calc buffer
	CALL	PasteTrack
	BSR.W	RedrawPattern

	LEA	Allright.MSG,A0
	CALL	ShowStatusText
	CALL	SetNormalPtrCol
	move.l	DOSBase,a6
	move.l	FileHandle,d1
	CALLSYS	Close
	BRA.W	RedrawPattern

NoTrackFile:
	LEA	NoTrackTxt,A0
	CALL	ShowStatusText
	moveq	#8,d3
.loo:
	CALL	Wait_4000
	dbra	d3,.loo

	LEA	Allright.MSG,A0
	CALL	ShowStatusText
	move.l	DOSBase,a6
	move.l	FileHandle,d1
	CALLSYS	Close
	BRA.W	RedrawPattern

;***********************************
LoadExecutable:
	BSET	#1,$00BFE001
	BCLR	#1,Packetfield
	clr.w	patt100memflag
	CLR.W	xpkflag
	bsr.w	clearcomments
	MOVE.W	#1,LoadingInProgress
	CALL	SetDiskPtrCol
	MOVE.L	DirPath,A0
	CALL	CopyPath
	LEA	DirInputName,A0
	MOVEQ	#$1D,D0
leloop2:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,leloop2

	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1
	MOVE.L	#$000003ED,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile
	PEA	ModReadClose
	MOVE.L	FileHandle,D1
	LEA	fourbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#4,D3
	CALLSYS	Read
	CMP.L	#4,D0
	BNE.W	FileLoadError
	LEA	fourbytebuf,A0
	CMP.L	#$000003F3,(A0)
	BNE.B	NoExeFile
	MOVE.L	FileHandle,D1
	MOVEQ	#$28,d2
	MOVEQ	#-1,d3
	CALLSYS	Seek
	MOVE.L	FileHandle,D1
	LEA	eightbytebuf,A0
	MOVE.L	A0,D2
	MOVEQ	#8,D3
	CALLSYS	Read
	CMP.L	#8,D0
	BNE.W	FileLoadError
	LEA	eightbytebuf,A0
	;CMP.L	 #'$VER',(A0)+
	;BNE.W	 NoExeFile
	;CMP.L	#':Pro',(a0)
	;BNE.W	NoExeFile
	move.w	#1,ExeRead
	bsr.w	ReadMODAfterCheck
	clr.w	ExeRead
	RTS


NoExeFile:
	bsr.w	ModReadClose
	lea	NoExeFileTxt(PC),a0
	bra.w	mismret

eightbytebuf:	ds.l	2
ExeRead:	dc.w	0

;***********************************

CalcSaveMod:
	MOVE.L	mt_songdataptr,A1
	LEA	20(A1),A1			; begin of sample 1
	MOVE.L	mt_mxbuf4base,D1
	MOVEQ	#1,D0				; loop counter to 1 (sample 1)

.loop1:
	BTST	D0,D1
	BEQ.S	.loop2
	OR.B	#128,n_wantedperiod(A1)		;set period

.loop2:
	LEA	30(A1),A1			; start of next sample in a1
	ADDQ.W	#1,D0				; counter +1
	CMP.W	#MaxInsNum+1,D0			; last sample ?
	BLE.S	.loop1				; no
	RTS

;***********************************
;* set period and calc sampleend   *
;* called from modsave routine     *
;***********************************

CalcSavSampl:
	MOVE.L	mt_songdataptr,A1
	LEA	$20(A1),A1			; start of first sample, samplename
	MOVEQ	#1,D0				; sample counter to 1

.loop:
	AND.B	#127,n_wantedperiod(A1)		; and 127
	LEA	30(A1),A1			; start of next sample in A1
	ADDQ.W	#1,D0				; next sample (+1)
	CMP.W	#MaxInsNum+1,D0			; last sample ?
	BLE.S	.loop				; no
	RTS

;***********************************
;* save an pt executable module    *
;***********************************
savetheexe2:
	CALL	StorePtrCol
	CALL	SetDiskPtrCol
	BSR.B	CalcSaveMod

	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	CLR.W	HighPattNum
seloop:
	MOVE.B	0(A0,D0.W),D1
	ADDQ.W	#1,D0
	CMP.W	#$0080,D0
	BHI.S	DoSaveExe
	MOVE.W	HighPattNum(PC),D2
	CMP.W	D2,D1
	BLS.B	seloop
	MOVE.W	D1,HighPattNum
	BRA.B	seloop
DoSaveExe:
	MOVE.L	DirPath,A0
	CALL	CopyPath
	move.l	a1,-(sp)
	MOVE.L	mt_songdataptr,A0
	MOVEQ	#$13,D0
dseloop2:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dseloop2
	move.l	(sp),a1
	subq.l	#1,a1
dseloop3:
	addq.l	#1,a1
	cmp.b	#0,(a1)
	bne.b	dseloop3

	move.b	#'.',(a1)+
	move.b	#'E',(a1)+
	move.b	#'X',(a1)+
	move.b	#'E',(a1)+
	move.b	#0,(a1)+
	move.l	(SP)+,a1

	CALL	CalcTuneRAM
	move.l	d0,-(sp)
	move.l	d0,d1
	;divu.l #4,d0				; logical shift
	;mulu.l #4,d0
	lsr.l	#2,d0
	lsl.l	#2,d0
	cmp.l	d0,d1
	beq.s	sehunkok
	addq.l	#4,d0
sehunkok:
	move.l	d0,-(sp)
	;divu.l #4,d0
	lsr.l	#2,d0
	lea	ExePlayer,a0
	add.l	#5520,a0
	move.l	d0,(a0) 			; put modlength in replayer
	lea	ExePlayer,a0			; for correct Hunk structure
	add.l	#24,a0
	add.l	#$40000000,d0
	move.l	d0,(a0)

	CALL	OpenSaveMod
	BNE.B	CantOpenFileExe
	lea	SavingExecutableText,a0
	bsr.w	ShowStatusText
	move.l	#5524,DiskDataLength		; save replayer
	move.l	#ExePlayer,DiskDataPtr
	CALL	WriteDataBlock

	bsr.s	savemodexe			; insert module in replayer

	move.l	#4,DiskDataLength
	move.l	#ExeEnd,DiskDataPtr

	move.l	(sp)+,d0
	move.l	(sp)+,d1
	cmp.l	d0,d1
	beq.s	sehunkok2
	addq.l	#2,DiskDataLength
	subq.l	#2,DiskDataPtr
sehunkok2:
	CALL	WriteDataBlock			; save replayer end
	CALL	WriteClose
	RTS

CantOpenFileExe
	addq.l	#8,sp
	bra.w	CantOpenFile

CantOpenFile:
	LEA	CantOpenFileText(PC),A0
caopfil:
	BSR.W	ShowStatusText
	CALL	SetErrorPtrCol
	clr	DiskDataLength
	MOVEQ	#0,D0
	RTS

savemodexe:
	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,DiskDataPtr
	MOVE.L	#sd_patterndata,DiskDataLength
	MOVEQ	#0,D0
	MOVE.W	HighPattNum(PC),D0
	ADDQ.L	#1,D0
	LSL.L	#8,D0
	LSL.L	#2,D0
	;chn8test
	;BEQ	no8mode29
	;LSL.L	#1,D0
;no8mode29:
	ADD.L	D0,DiskDataLength		; number of patterns
	MOVE.B	#$7F,sd_ntflag(A0)
	MOVE.L	#$00,sd_mahokakt(A0)

	MOVE.L	#'M.K.',sd_mahokakt(A0)
	cmp.w	#$0040,HighPattNum
	bcs.s	wr_skipififfexe
	move.l	#'M!K!',sd_mahokakt(a0)

wr_skipififfexe:
	BSR.W	WriteDataBlock			; write
	BNE.W	wr_savmoderror

	MOVE.W	InsNum,InsNumToSave
	MOVEQ	#1,D6
wr_modsamplesexe:
	MOVE.W	D6,InsNum

.loop:
	BSR.W	wr_sav1samFromMod		; save 1 sample
	BNE.W	wr_savmoderror
	ADDQ.B	#1,D6				; +1 next sample
	CMP.B	#MaxInsNum+1,D6 		; last sample?
	BNE.S	.loop				; no, write again
	RTS

ExeAdd:	dc.l	0
ExeEnd:	dc.l	$000003F2

;***********************************
;* save an pt music module         *
;***********************************

SaveModule3:
	CALL	StorePtrCol
	CALL	SetDiskPtrCol
	BSR.W	CalcSaveMod

	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0		; song positions
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	CLR.W	HighPattNum
smloop:
	MOVE.B	0(A0,D0.W),D1
	ADDQ.W	#1,D0
	CMP.W	#$0080,D0
	BHI.S	DoSaveModule
	MOVE.W	HighPattNum(PC),D2
	CMP.W	D2,D1
	BLS.B	smloop
	MOVE.W	D1,HighPattNum
	BRA.B	smloop

DoSaveModule:
	BTST	#4,Setup
	BSR.W	CheckModIndex
	BTST	#1,PackMode
	BNE.W	PackModule			; pack module routines

	CLR.L	CrunchBufferPtr
	CLR.W	PPSetSvFlag

;--- begin of normal module saving ---

NormSavModOpen:
	MOVE.L	mt_songdataptr,A0
	MOVE.L	A0,DiskDataPtr
	move.l	#$00,DiskDataLength

	tst.b	modmode 			; old moduleformat?
	beq.w	savinoldmode

;--- iff modl format saving ---

saveiff4:
	BCLR	#2,Packetfield			; mod with samples
	move.l	TuneRAMBit,d0
	add.l	iffmhunklength,d0
	move.l	d0,fo_length			; modlength
	lea	fo_songname,a0
	cmp.l	#'UNNA',(A0)			; unnamed song?
	bne.s	snamleav

	move.l	mt_songdataptr,a0
	lea	fo_songname,a1
	moveq	#$13,D0

copysname:
	move.b	(a0)+,(A1)+
	dbra	d0,copysname

snamleav:
	move.w	#MaxInsNum+1,fo_instr
	move.w	#64,fo_positions
	move.w	HighPattNum,fo_patterns
	move.w	TremoloByte,fo_volume
	move.w	RealTempo,fo_dspeed
	move.w	Packetfield,fo_packetf		; packetfield bit
	bchg	#5,fo_packetf

	CALL	CalTime 			; calculate playtime of song
	LEA	Timer,a0
	move.l	(A0),D0
	move.w	d0,fo_playtime_h
	move.l	4(A0),d0
	move.w	d0,fo_playtime_m
	move.l	8(A0),d0
	move.w	d0,fo_playtime_s
	move.l	12(A0),d0
	move.w	d0,fo_playtime_ms

	move.w	fa_creatdat_da,fo_creatdat_da
	move.w	fa_creatdat_mo,fo_creatdat_mo
	move.w	fa_creatdat_ye,fo_creatdat_ye
	move.w	fa_creattime_h,fo_creattime_h
	move.w	fa_creattime_m,fo_creattime_m
	move.w	fa_creattime_s,fo_creattime_s

;---- calculate tune ram and set in PTDT chunk
	;CALL	CalcTuneRAM
	move.l	TuneRAMBit,d0
	move.l	d0,fo_ptrnlgth
;---------
	lea	ModConfHeader,a0
	move.l	a0,DiskDataPtr
	move.l	#fo_formModend-ModConfHeader,d0 ; IFF-Headerlength
	move.l	d0,DiskDataLength


	BSR.W	wr_savmodopen			; open
	BNE.W	CantOpenFile
	BSR.W	WriteDataBlock			; write iffheader
	BNE.W	wr_savmoderror

savinoldmode:
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.L	A0,DiskDataPtr
	MOVE.L	#sd_patterndata,DiskDataLength
	MOVEQ	#0,D0
	MOVE.W	HighPattNum(PC),D0
	ADDQ.L	#1,D0
	LSL.L	#8,D0
	LSL.L	#2,D0
	chn8test
	BNE.S	no8mode30
	LSL.L	#1,D0

no8mode30:
	ADD.L	D0,DiskDataLength		; number of patterns
	;tst.b	modmode 			; old moduleformat?
	;beq.b	saveold1
	;move.l	#'PATT',sd_mahokakt(A0)
	;bra.s	n100ims
saveold1:
	MOVE.B	#$7F,sd_ntflag(A0)
	MOVE.L	#$00,sd_mahokakt(A0)		; clear M.K. if IFF MOD

	MOVE.L	#'M.K.',sd_mahokakt(A0)

	chn8test
	BNE.S	no8mode90
	MOVE.L	#'8CHN',sd_mahokakt(A0)
	BRA.S	n100ims
no8mode90:
	cmp.w	#$0040,HighPattNum
	bcs.s	n100ims
	move.l	#'M!K!',sd_mahokakt(a0)
n100ims:
	TST.W	PPSetSvFlag
	BNE.S	wr_savmoddatas
	TST.L	CrunchBufferPtr
	BNE.S	wr_savmoddatas
wr_savmodbeg:
	LEA	Savingmodule.MSG(PC),A0
	BSR.W	ShowStatusText

wr_savmoddatas:
	tst.b	modmode
	bne.s	wr_skipififf

	BSR.W	wr_savmodopen			; open
	BNE.W	CantOpenFile

wr_skipififf:
	BSR.W	WriteDataBlock			; write
	BNE.S	wr_savmoderror

	MOVE.W	InsNum(PC),InsNumToSave
	MOVEQ	#1,D6				; counter start

.loop:
	MOVE.W	D6,InsNum			; counter to insnum
	TST.W	PPSetSvFlag
	BNE.S	.skip
	TST.L	CrunchBufferPtr			; activated cruncher ?
	BNE.S	.skip				; yes
	BSR.W	ShowSampleInfo			; no, show smpldatas

.skip:
	BSR.S	wr_sav1samFromMod		; save 1 sample
	BNE.S	wr_savmoderror
	ADDQ.B	#1,D6				; +1 next sample
	CMP.B	#MaxInsNum+1,D6 		; last sample?
	BNE.S	.loop				; no, write again


	BSR.W	wr_savmodclose			; close
	MOVE.W	InsNumToSave(PC),InsNum
	TST.W	PPSetSvFlag
	BEQ.S	.skip2
	RTS

.skip2:
	TST.L	CrunchBufferPtr			; with packing?
	BEQ.S	SavNoPckg			; no
	RTS

SavNoPckg:
	BSR.W	ShowSampleInfo
	BSR.W	ShowAllRight
	BSR.W	CalcSavSampl
	GOTO	RestorePtrCol

;***********************************
;* error by saving routine         *
;***********************************
wr_savmoderror:
	BSR.W	wr_savmodclose
	BRA.W	CantSaveFile


InsNumToSave:		dc.w	0

;************************************
;*    save 1 sample routine         *
;* in:  D6 = act samplenumber       *
;* out: D0 = 0>OK 1>ERROR           *
;************************************

wr_sav1samFromMod:
	MOVE.W	D6,D0
	LSL.W	#2,D0
	LEA	mt_songdataptr(PC),A0
	MOVE.L	n_note(A0,D0.W),D1
	BNE.S	.skipit				; sample not empty?
	RTS
.skipit:
	MOVE.L	$7C(A0,D0.W),D0
	BNE.S	.leavit
	RTS
.leavit:
	MOVE.L	D1,DiskDataPtr			; note start
	MOVE.L	mt_songdataptr(PC),A0
	LEA	12(A0),A0
	MOVE.W	D6,D0				; act sample number
	MULU	#30,D0
	ADD.L	D0,A0

	MOVEQ	#0,D0
	MOVE.W	(A0),D0
	MOVE.B	n_cmd(A0),D1
	BTST	#7,D1
	SNE	D1
	MOVE.B	D1,SmplLopTBuf
	LSL.L	#1,D0
	MOVE.L	D0,DiskDataLength
	BNE.S	.doit				; calc is valid ?
	MOVEQ	#0,D0				; no, but return without error
	RTS

.doit:
	BSR.W	WriteDataBlock
	TST.B	SmplLopTBuf
	BEQ.S	.skip

	LEA	MSamPointer,A0
	MOVE.W	D6,D1
	LSL.W	#3,D1
	ADD.W	D1,A0
	MOVE.L	(A0)+,D1
	BEQ.S	.skip

	MOVE.L	(A0)+,D0
	BEQ.S	.skip

	MOVE.L	D1,SmplWr4Buf
	MOVE.L	D0,SmplLoad4Buf
	MOVE.L	#SmplLoad4Buf,DiskDataPtr
	MOVE.L	#4,DiskDataLength
	BSR.S	WriteDataBlock
	MOVE.L	SmplWr4Buf,DiskDataPtr
	MOVE.L	SmplLoad4Buf,DiskDataLength
	BSR.S	WriteDataBlock
.skip:
	RTS

SmplLopTBuf:	dc.b	0,0
SmplWr4Buf:	dc.l	0
SmplLoad4Buf:	dc.l	0			;4 Byte temp buffer for smpl load check

wr_savmodopen:
	TST.W	PPSetSvFlag
	BNE.S	lbC012502
	TST.L	CrunchBufferPtr
	BNE.S	lbC012502

OpenSaveMod:					;from PP Packing
	MOVE.L	DOSBase,A6
	MOVE.L	#FileName,D1
	MOVE.L	#$000003EE,D2
	CALLSYS	Open
	MOVE.L	D0,D7
	BEQ.S	WriteDataBlockErr
lbC012502:
	MOVEQ	#0,D0
	RTS

WriteDataBlock:
	MOVE.L	DOSBase,A6
	MOVE.L	D7,D1
	MOVE.L	DiskDataPtr,D2
	MOVE.L	DiskDataLength,D3
	BSR.S	WriteDatas
	TST.L	D0
	BEQ.S	WriteDataBlockErr
	MOVEQ	#0,D0
	RTS

WriteDataBlockErr:
	MOVEQ	#-1,D0
	RTS

wr_savmodclose:
	TST.W	PPSetSvFlag
	BEQ.S	lbC012532
	RTS

lbC012532:
	TST.L	CrunchBufferPtr
	BEQ.S	WriteClose
	RTS

WriteClose:
	MOVE.L	DOSBase,A6
	MOVE.L	D7,D1
	JMP	_LVOClose(A6)

WriteDatas:
	TST.W	PPSetSvFlag
	BNE.S	lbC01257A
	TST.L	CrunchBufferPtr
	BNE.S	lbC01255C
	JMP	_LVOWrite(A6)

lbC01255C:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	S_PPModLength(PC),A0
	MOVE.L	D2,A1
lbC012566:
	MOVE.B	(A1)+,(A0)+
	SUBQ.L	#1,D3
	BGT.S	lbC012566
	MOVE.L	A0,S_PPModLength
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	D3,D0
	RTS

lbC01257A:
	ADD.L	D3,lbL0125BA
	MOVE.L	D3,D0
	RTS

CalcDskLgtForPPSave:
	MOVEM.L D1-D7/A0-A6,-(SP)
	MOVE.L	DiskDataLength,-(SP)
	MOVE.W	#$FFFF,PPSetSvFlag
	CLR.L	lbL0125BA
	BSR.W	NormSavModOpen
	CLR.W	PPSetSvFlag
	MOVE.L	(SP)+,DiskDataLength
	MOVEM.L (SP)+,D1-D7/A0-A6
	MOVE.L	lbL0125BA(PC),D0
	RTS

PPSetSvFlag:	dc.w	0
lbL0125BA:	dc.l	0

;***********************************

PackModule:
	cmp.b	#1,xpackmode			; xpk settings flag ?
	bne.w	packpp20			; use powerpacker.lib

	BSR.B	CalcDskLgtForPPSave
	MOVE.L	D0,DiskDataLength
	MOVE.L	4.w,a6
	MOVE.L	#$00010000,D1
	MOVE.L	DiskDataLength,D0
	CALLSYS	AllocMem
	MOVE.L	D0,CrunchBufferPtr
	BEQ.S	NoMemForXPKPack
	MOVE.L	D0,S_PPModLength
	MOVE.L	DiskDataLength,-(SP)
	BSR.W	NormSavModOpen
	MOVE.L	(SP)+,DiskDataLength

	TST.L	xpkbase
	BNE.S	BeginXPKPacking			; xpkmaster.lib opened ?
	LEA	Cantopenxpk.MSG(PC),A0
	BSR.W	ShowStatusText
	GOTO	SetErrorPtrCol

NoMemForXPKPack:
	LEA	noxpkmempacktxt(PC),A0
	CALL	NoMemoryRequester
	BRA	EndPPPackMessage

;************************************

BeginXPKPacking:
	MOVE.L	xpkbase,A6
	MOVEQ	#0,D0
	MOVEQ	#1,D1
	LEA	PPCrunchFunction(PC),A0
	SUB.L	A1,A1

	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	StanbyPacking.MSG(PC),A0
	CALL	ShowStatusText
	CALL	SetWaitPtrCol
	MOVEM.L (SP)+,D0-D7/A0-A6

	lea	xpkdumtxt,A0
	moveq	#0,D0
	move.b	xpkmode,d0
	lsl.w	#2,d0
	lea	0(a0,d0.w),a0
	MOVE.L	(A0),xpkpacker

	move.l	CrunchBufferPtr,packadr
	move.l	DiskDataLength,packlen
	BSR.W	CheckModIndex
	move.l	#FileName,packname
	MOVEQ	#0,d0
	move.b	xpkeff,D0
	MOVE.L	D0,packeff

	LEA	xpkpacktags,a0
	CALLSYS	XpkPack
	BEQ.S	ReturnXPK

	LEA	errorxpk.MSG(PC),A0
	CALL	NoMemoryRequester
	BRA.W	EndPPPackMessage


ReturnXPK:
	MOVE.L	CrunchBufferPtr(PC),D0
	MOVE.L	D0,A1
	MOVE.L	DiskDataLength(pc),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	CrunchBufferPtr

	CLR.W	LoadingInProgress
	CALL	DoShowFreeMem
	GOTO	RestorePtrCol
	RTS

;****************************************
;* pack a file with powerpacker.library *
;****************************************

packpp20:
	BSR.W	CalcDskLgtForPPSave
	MOVE.L	D0,DiskDataLength
	MOVE.L	4.w,a6
	MOVE.L	#$00010000,D1
	MOVE.L	DiskDataLength,D0
	CALLSYS	AllocMem
	MOVE.L	D0,CrunchBufferPtr
	BEQ.W	NoMemForPPPack
	MOVE.L	D0,S_PPModLength
	MOVE.L	DiskDataLength,-(SP)
	BSR.W	NormSavModOpen
	MOVE.L	(SP)+,DiskDataLength
	tst.l	PPackBase
	BNE.S	packpp20_2
	BSR.W	PPCrunchClosResources
	LEA	CantopenPower.MSG(PC),A0
	BSR.W	ShowStatusText
	GOTO	SetErrorPtrCol

packpp20_2:
	MOVE.L	PPackBase(PC),A6
	MOVEQ	#0,D0
	MOVE.B	PoPacratio,D0			; efficiency
	MOVEQ	#1,D1				; speedup
	LEA	PPCrunchFunction(PC),A0		; function (pass lensofar,crunlen,totlen, userdata)
	SUB.L	A1,A1				; userdata
	CALLSYS	ppAllocCrunchInfo		;-$0060
	MOVE.L	D0,crunchinfo
	BNE.S	CrunchBeg
	BSR.W	PPCrunchClosResources		; no valid crunchinfo allocated
	LEA	Notenoughmemo.MSG1(PC),A0
	CALL	NoMemoryRequester
	BRA.W	EndPPPackMessage

CrunchBeg:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	StanbyPacking.MSG(PC),A0
	CALL	ShowStatusText
	CALL	SetWaitPtrCol
	MOVEM.L (SP)+,D0-D7/A0-A6
	BSR.W	CrunchReq

	MOVE.L	crunchinfo(PC),A0		; crunchinfo
	MOVE.L	CrunchBufferPtr(PC),A1		; buffer
	MOVE.L	DiskDataLength(pc),D0		; length
	CALLSYS	ppCrunchBuffer			;-$006C
	MOVE.L	D0,crunchedlen			; crunched len
	BNE.S	CrunchBeg2			; ~0 if valid

	BSR.W	OpenPPackRequester
	BSR.W	PPCrunchClosResources
	LEA	Errorwhilecru.MSG(PC),A0
	BRA.W	PPSavShowStatusText

CrunchBeg2:
	BSR.W	OpenPPackRequester
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	WritingPPmodu.MSG(PC),A0
	CALL	ShowStatusText
	MOVEM.L (SP)+,D0-D7/A0-A6
	BSR.W	OpenSaveMod
	TST.L	D0
	BEQ.S	PPSavCont
	BSR.W	PPCrunchClosResources
	LEA	Errorwhilewri.MSG(PC),A0
	BRA.W	PPSavShowStatusText

PPSavCont:
	MOVE.L	D7,lbL0127B0
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	WritingPPhead.MSG(PC),A0
	CALL	ShowStatusText
	CALL	SetDiskPtrCol
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	lbL0127B0(PC),D0
	MOVEQ	#0,D1
	MOVE.B	PoPacratio,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVE.L	PPackBase(PC),A6
	JSR	-$0072(a6)
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	WritingPPdata.MSG(PC),A0
	CALL	ShowStatusText
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVE.L	lbL0127B0(PC),D1		; file
	MOVE.L	CrunchBufferPtr(PC),D2		; buffer
	MOVE.L	crunchedlen(PC),D3		; length
	MOVE.L	DOSBase,A6
	CALLSYS	Write
	TST.L	D0
	BNE.S	PPSavWError

	MOVE.L	lbL0127B0(PC),D7
	BSR.W	WriteClose
	BSR.S	PPCrunchClosResources
	LEA	Errorwhilewri.MSG(PC),A0
	BRA.B	PPSavShowStatusText

PPSavWError:
	MOVE.L	lbL0127B0(PC),D7
	BSR.W	WriteClose
	BSR.S	PPCrunchClosResources
	BSR.W	ShowAllRight
	GOTO	RestorePtrCol


PPCrunchClosResources:
	MOVE.L	crunchinfo(PC),D0
	BEQ.S	NoPPResources
	MOVE.L	D0,A0
	MOVE.L	PPackBase,A6
	CALLSYS	ppFreeCrunchInfo			;-$0066
	CLR.L	crunchinfo

NoPPResources:
	MOVE.L	CrunchBufferPtr(PC),D0
	BEQ.S	NoPPMemS
	MOVE.L	D0,A1
	MOVE.L	DiskDataLength(pc),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	CrunchBufferPtr
NoPPMemS:
	CLR.W	LoadingInProgress
	CALL	DoShowFreeMem
	GOTO	RestorePtrCol

NoMemForPPPack:
	LEA	Notenoughmemo.MSG2(PC),A0
	CALL	NoMemoryRequester
	BRA.S	EndPPPackMessage

PPSavShowStatusText:
	BSR.W	ShowStatusText
EndPPPackMessage:
	CALL	SetErrorPtrCol
	GOTO	DoShowFreeMem


CrunchBufferPtr:	dc.l	0	; pointer to allocated mem for xpk/pp crunch

crunchinfo:	dc.l	0	; pointer to private powerpacker.library crunchinfo structure
crunchedlen:	dc.l	0	; crunched len of ppacked file
S_PPModLength:	dc.l	0
lbL0127B0:	dc.l	0
iffscount:	dc.l	0

errorxpk.MSG:
		dc.b	10,10,10,'     Error while',$A
		dc.b	'     XPK-Packing!',0
		EVEN

noxpkmempacktxt:
		dc.b	10,10,10,'  Not enough memory',$A
		dc.b	'   for XPK-Packing!',0
		EVEN

Notenoughmemo.MSG2:
		dc.b	10,10,10,'  Not enough memory',$A
		dc.b	'  for PowerPacking!',0
		EVEN

Notenoughmemo.MSG1:
	dc.b	10,10,10,'  Not enough memory',$A
		dc.b	'   for CrunchInfo!',0
		EVEN

Errorwhilecru.MSG:	dc.b	'ERROR WHILE CRUNCHING! ',0
			EVEN
Errorwhilewri.MSG:	dc.b	'ERROR WHILE WRITING FILE!',0
			EVEN
StanbyPacking.MSG:	dc.b	'STANDBY, PACKING...',0
			EVEN
WritingPPmodu.MSG:	dc.b	'WRITING PP MODULE... ',0
			EVEN
WritingPPhead.MSG:	dc.b	'WRITING PP HEADER... ',0
			EVEN
WritingPPdata.MSG:	dc.b	'WRITING PP DATA... ',0
			EVEN
Crunching.MSG0: 	dc.b	'CRUNCHING... ',0
			EVEN
modform.txt:		dc.b	'LOADING PT4.0 FORMAT ',0
			EVEN
verhunk.txt:		dc.b	'READING VERSIONSHUNK ',0
			EVEN
infohunk.txt:		dc.b	'READING INFOPARAMETERS ',0
			EVEN
cmnthunk.txt:		dc.b	'READING COMMENTS ',0
			EVEN
modhunk.txt:		dc.b	'READING SONGDATAS',0
			EVEN
Mismatchfilet.MSG:	dc.b	'MISMATCH FILE TYPE !?',0
			EVEN
medmod.txt:		dc.b	'IT''S (OCTA)MED!',0
			EVEN
issymmodtxt:		dc.b	'IT''S SYMPHONIE!',0
			EVEN
digiboosttxt:		dc.b	'IT''S DIGIBOOSTER!',0
			EVEN
tfmxtxt:		dc.b	'IT''S TFMX!',0,0
			EVEN
fc14txt:		dc.b	'IT''S FUTURE COMPOSER!',0
			EVEN
soartxt:		dc.b	'IT''S SONIC ARRANGER! ',0
			EVEN
octalyzertxt:		dc.b	'IT''S OCTALYZER!',0
			EVEN
unknownmodtxt:		dc.b	'UNKNOWN FORMAT!',0
			EVEN
NoExeFileTxt:		dc.b	'NO PT4.0 EXE-MODULE',0
			EVEN
CantopenPower.MSG:	dc.b	'CAN''T OPEN PP.LIBRARY',0
			EVEN
Cantopenxpk.MSG:	dc.b	'CAN''T OPEN XPK.LIBRARY ',0
			EVEN
mod100first.msg:	dc.b	'SWITCH TO 100PATT-MODE!',0
			EVEN

xpkflag:		dc.w	0
EndOfSongPtr:		dc.l	0
SongPlus70kPtr: 	dc.l	0
RealSongLength: 	dc.l	0
SongPlus12Ptr:		dc.l	0
DontKnowWhat:		dc.l	0
CrunchedSongLength:	dc.l	0

;***********************************
;* crunchrquester from ppacker     *
;* while packing ...               *
;***********************************

CrunchReq:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#$FFFF,DirCopFlag
	CALL	ClearRightAreaReq
	SUB.L	A0,A0
	SUB.L	A1,A1
	LEA	lbL0196AE,A2
	CALL	SwapBoxMem
	LEA	Crunching.MSG0(PC),A0
	MOVE.W	#$0116,D0
	MOVEQ	#$3E,D1
	CALL	PrintTextInReqs
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***********************************

OpenPPackRequester:
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	OpenRequester
	CLR.W	DirCopFlag
	CALL	ClearAllKeys
	;CLR.B	RawKeyCode
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D0
	RTS

;***********************************
;* The PPAllocCrunchInfo Function  *
;* Requester of Crunchstatus       *
;***********************************

PPCrunchFunction:
	MOVE.L	4(SP),pplensofar	; lensofar => length of part crunched buffer so far
	MOVE.L	8(SP),ppcrunlen		; crunlen  => crunched length of lensofar
	MOVE.L	12(SP),pptotlen		; totlen   => total length of buffer

	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	pp_percA(PC),D0
	MOVE.L	pplensofar(PC),D2
	MOVE.L	D2,pp_percA
	MOVE.L	pptotlen(PC),D3
	CMP.L	D0,D2			; reg <=> pplensofar
	BHI.S	pp_percst		; higher than?
	MOVEQ	#0,D0
pp_percst:
	LSR.L	#6,D0
	LSR.L	#6,D2
	LSR.L	#6,D3
	MULU	#$00EC,D0
	MULU	#$00EC,D2
	DIVU	D3,D0
	DIVU	D3,D2
	ADD.W	#$00CA,D0
	ADD.W	#$00CA,D2
	MOVEQ	#$4D,D1
	MOVE.W	#$0056,D3
	MOVEQ	#1,D5
	CALL	DrawRecBox		; clears requester area

; check to abort
pp_percco:
	CALL	DoKeyBuffer
	MOVE.B	RawKeyCode,D0
	CMP.B	#$45,D0 			; ESC?
	BEQ.S	PPCrunchAborted
	TST.B	D0
	BNE.S	pp_percco
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#-1,D0
	RTS

PPCrunchAborted:
	MOVEM.L (SP)+,D0-D7/A0-A6
	MOVEQ	#0,D0
	RTS

pp_percA:	dc.l	0
pplensofar:	dc.l	0
ppcrunlen:	dc.l	0
pptotlen:	dc.l	0

;************************************

CheckModIndex:
	tst.b	modmode
	beq.s	oldheader
	move.l	DirPath,a0
	CALL	CopyPath
	move.b	#'p',(A1)+
	move.b	#'t',(A1)+
	move.b	#'m',(A1)+
	move.b	#'.',(A1)+
	move.l	mt_songdataptr(PC),a0
	moveq	#$13,d0

nwhdd:	move.b	(A0)+,(A1)+
	dbra	d0,nwhdd
	RTS

oldheader:
	MOVE.L	DirPath,A0
	CALL	CopyPath
	MOVE.B	#'m',(A1)+
	MOVE.B	#'o',(A1)+
	MOVE.B	#'d',(A1)+
	MOVE.B	#'.',(A1)+
	MOVE.L	mt_songdataptr(PC),A0	;add mod. to filename
	MOVEQ	#$13,D0
dsmloop2:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dsmloop2		;name out
	RTS

;*********************************
;* showstatus ok                 *
;*********************************

ShowAllRight:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	Allright.MSG(PC),A0
	BSR.S	ShowStatusText
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*********************************
;* showstatustext, text in a0    *
;*********************************

ShowStatusText:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	TextBplPtr,A1
	ADD.L	#$0000280D,A1
	MOVEQ	#4,D0
showstt_lp1:
	MOVEQ	#$25,D1
showstt_cl:
	CLR.B	(A1)+
	DBRA	D1,showstt_cl
	LEA	$002A(A1),A1
	DBRA	D0,showstt_lp1
	MOVE.L	A0,A1
	MOVE.W	#$280D,D1
	MOVEQ	#-1,D0
showstt_ro:
	ADDQ.W	#1,D0
	TST.B	(A1)+
	BNE.S	showstt_ro
	BSR.W	ShowText3
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*********************************
;* redraw tracks at scroller     *
;*********************************

;--- from edit commands ---
RealRedrawPattern:
	TST.W	LoadingInProgress
	BNE.S	.doit
	CALL	ClearAllKeys

.doit:	TST.W	SamScrEnable
	BEQ.S	RedrawPattern4
	RTS

;--- with reinit blit ---
RedrawPattern:
	TST.W	LoadingInProgress
	BNE.S	.doit
	CLR.B	RawKeyCode
.doit:
	TST.W	SamScrEnable
	BEQ.S	.rok
	RTS
.rok:	CALL	ReBlitTrack

;--- main part ---
RedrawPattern4:
	MOVEM.L D0-D7/A0-A6,-(SP)
	TST.B	AllowRedrPattSc
	BNE.W	pocobas
	ST	AllowRedrPattSc
	SF	PattRfsh
	MOVE.W	#323,fl3DecDigit1
	MOVE.W	#128,fl3DecDigit2
	MOVE.W	PatternNumber+2(pc),WordNumber
	BSR.W	Print2DecDigits_RD		;print patternnumber
	MOVE.L	mt_songdataptr(PC),A6
	LEA	sd_patterndata(A6),A6
	MOVE.L	PatternNumber,D6
	LSL.L	#8,D6
	LSL.L	#2,D6

	chn8test
	BNE.S	.chn4
	LSL.L	#1,D6

.chn4:
	ADD.L	D6,A6
	MOVE.W	#$3ca2,TextOffset
	CLR.L	PPattPos
	LEA	mt_periodtable(PC),A2
	LEA	RedrawBuffer(PC),A3
	LEA	FastHexTable(PC),A4
	MOVEQ	#'0',D4

	BTST	#3,CutToBufFlag			; zero blanking?
	SNE	D5
	MOVEQ	#MaxPattPos,D6

;--- loop for 1 complete track ---
; rpnxpos =MaxPattPos loop in D6

rpnxpos:
	move.w	numchans,d7			;d7 loop
	subq	#1,d7
	MOVE.W	PPattPos+2(pc),WordNumber
	MOVEQ	#1,D1

	BSR.W	PrintPatternPos 		;print mt_patternpos

	chn8test
	BNE.S	.chn4
	ADDQ.W	#2,TextOffset

.chn4:	SUBQ.W	#1,TextOffset
	ADDQ.L	#1,PPattPos
ztrploop:
	BSR.S	FillEmptyRedraw
	DBRA	D7,ztrploop

	ADD.W	#(576-1)-12,TextOffset
	chn8test
	BNE.S	.chn4
	ADDQ.W	#1,TextOffset
.chn4:	DBRA	D6,rpnxpos

pocobas:					; allow refresh toggle
	SF	AllowRedrPattSc
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

RedrawNotes:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	A0,A6
	LEA	mt_periodtable(PC),A2
	LEA	RedrawBuffer(PC),A3
	LEA	FastHexTable(PC),A4
	MOVEQ	#48,D4
	BTST	#3,CutToBufFlag
	SNE	D5
	BSR.S	FillEmptyRedraw
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;---
linestringredr: 	dc.b	' -  ',0,0
pointstringredr:	dc.b	'  . ',0,0
			EVEN

FillEmptyRedraw:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVE.W	(A6),D1
	AND.W	#$0FFF,D1
	BNE.S	rpfind
	MOVE.L	linestringredr,(A3)
	BRA.S	rpskip

rpfind:
	MOVEQ	#36,D2
rpfindloop:
	CMP.W	0(A2,D0.W),D1
	BEQ.S	rpfound
	ADDQ.L	#2,D0
	DBRA	D2,rpfindloop
	MOVE.L	#'??? ',(A3)
	BRA.S	rpskip

rpfound:
	LSL.L	#1,D0
	ADD.L	NoteNamesPtr(PC),D0
	MOVE.L	D0,A0
	MOVE.L	(A0),(A3)
	MOVEQ	#-1,D2
rpskip:
	MOVEQ	#0,D0
	MOVE.B	(A6),D0
	ADD.W	D0,D0
	MOVE.B	0(A4,D0.W),3(A3)
	MOVEQ	#0,D0
	MOVE.B	2(A6),D0
	ADD.W	D0,D0
	MOVE.B	0(A4,D0.W),4(A3)
	MOVE.B	1(A4,D0.W),5(A3)
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	ADD.W	D0,D0
	MOVE.B	0(A4,D0.W),6(A3)
	MOVE.B	1(A4,D0.W),7(A3)
	LEA	4(A6),A6
	TST.B	D5
	BEQ.S	ofartf
	CMP.B	3(A3),D4
	BNE.S	ofaprt
	MOVE.B	#' ',3(A3)
	CMP.B	4(A3),D4
	BNE.S	ofaprt
	MOVE.B	#'-',4(A3)
ofaprt:
	MOVE.B	5(A3),D1
	OR.B	6(A3),D1
	OR.B	7(A3),D1
	CMP.B	D4,D1
	BNE.S	ofartf
	LEA	pointstringredr,A0
	MOVE.B	(A0)+,5(A3)
	MOVE.B	(A0)+,5(A3)
	MOVE.B	(A0)+,6(A3)
	MOVE.B	(A0)+,7(A3)
ofartf:
	MOVE.W	#8,TextLength
	MOVE.L	A3,ShowTextPtr
	MOVEQ	#0,D1
	BSR.S	pposmetoc
	ADDQ.W	#2,TextOffset

	chn8test
	BNE.S	.chn4
	SUBQ.W	#1,TextOffset
.chn4:
	RTS

RedrawBuffer:	dc.b	'---00000',0
		EVEN

;***********************************
PrintPatternPos:
	MOVEM.L D1,-(SP)
	MOVE.W	#3,TextLength
	MOVEQ	#0,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	DIVU	#10,D1
	BSR.W	lbC01308E
	BSR.W	lbC01308E
	LEA	convprbyte(PC),A0
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#'  ',2(A0)
	MOVEM.L (SP)+,D1
pposmetoc:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVEQ	#0,D0
	MOVE.W	TextLength,D0
	MOVE.L	ShowTextPtr,A0
	LEA	PattBlkSize,A1
	MOVEQ	#0,D2
	MOVE.W	TextOffset,D2
	ADD.L	D2,A1
	LEA	Fonts,A2
	ADD.L	FontAdr,A2

	chn8test
	BNE.B	.chn4
	LEA	1024(A2),A2		;get font for 8 channels

.chn4:
	MOVE.L	D0,D7
	MOVE.L	D1,D6
	AND.L	#1,D6
	SUBQ.L	#1,D7
	BMI.W	acusem_rt
acusem:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BEQ.W	acusem_rt
	SUB.B	#32,D0
	ADD.L	D0,D0
	LEA	0(A2,D0.L),A3
	MOVE.B	(A3),(A1)
	MOVE.B	1(A3),1(A1)
	MOVE.B	$0080(A3),$0050(A1)
	MOVE.B	$0100(A3),$00A0(A1)
	MOVE.B	$0180(A3),$00F0(A1)
	MOVE.B	$0200(A3),$0140(A1)
	MOVE.B	$0280(A3),$0190(A1)
	MOVE.B	$0300(A3),$01E0(A1)
	MOVE.B	$0380(A3),$0230(A1)

	chn8test
	BEQ.S	nochn8

	MOVE.B	$0081(A3),$0051(A1)
	MOVE.B	$0101(A3),$00A1(A1)
	MOVE.B	$0181(A3),$00F1(A1)
	MOVE.B	$0201(A3),$0141(A1)
	MOVE.B	$0281(A3),$0191(A1)
	MOVE.B	$0301(A3),$01E1(A1)
	MOVE.B	$0381(A3),$0231(A1)
	ADDQ.L	#2,A1
	ADDQ.W	#2,TextOffset
	DBRA	D7,acusem

acusem_rt:
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

nochn8:
	ADDQ.L	#1,A1
	ADDQ.W	#1,TextOffset
	DBRA	D7,acusem
	BRA.S	acusem_rt

;***********************************

ShowPosition:
	MOVE.L	mt_songdataptr(PC),A0
	LEA	sd_pattpos(A0),A0
	ADD.L	playpos,A0
	MOVE.B	#0,WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.B	(A0),PattRfshNum+3
	MOVEQ	#0,D1
	MOVE.B	(A0),D1
	CMP.B	LongFFFF+3,D1
	BEQ.S	spskip2
	ST	PattRfsh

spskip2:
	MOVE.W	#$1228,TextOffset
	MOVE.B	(A0),LongFFFF+3
	CMP.W	#0,CurrScreen
	BEQ.B	spokok
	CMP.W	#1,CurrScreen
	BEQ.B	spokok
	RTS

spokok:
	BSR.W	Print4DecDigits
	MOVE.W	playpos+2,WordNumber
	MOVE.W	#$0EB8,TextOffset
	BRA.W	Print4DecDigits

;***********************************

ShowSongLength:
	CMP.W	#2,CurrScreen
	BEQ.B	ShowSongName
	CMP.W	#3,CurrScreen
	BEQ.B	ShowSongName
	CMP.W	#5,CurrScreen
	BEQ.B	ShowSongName
	CMP.W	#6,CurrScreen
	BEQ.B	ShowSongName
	CMP.W	#8,CurrScreen
	BEQ.B	ShowSongName
	cmp.w	#9,CurrScreen
	beq.b	ShowSongName
slgth:
	MOVE.L	mt_songdataptr(PC),A0

	LEA	sd_numofpatt(A0),A0		; number of patterns
	MOVE.L	A0,CurrCmds
	CLR.W	WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.W	#$1598,TextOffset
	BSR.W	Print4DecDigits 		; songlength mod
	MOVE.L	CurrCmds,A0

ShowSongName:

	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	#$07D8,D1
	MOVEQ	#$14,D0
	BRA.W	ShowText3


;***********************************
; sampleinfo + calc                *
;***********************************

ShowSampleInfo:
	CMP.W	#1,CurrScreen
	BEQ.B	ShowSampleInfo2
	;CMP.B	 #3,CurrScreen
	;BEQ.W	 ssiskp22
	RTS

ShowSampleInfo2:
	MOVEQ	 #0,D0
	MOVE.W	InsNum(PC),D0
	MOVE.W	D0,PlayInsNum
	BNE.S	ssiskipit
	MOVE.W	LastInsNum(PC),D0
ssiskipit:
	MOVE.W	D0,D1
	LSL.L	#2,D0
	LEA	mt_songdataptr(PC),A0
	MOVE.L	(A0,D0.W),si_pointer
	MOVE.L	mt_songdataptr(PC),A0
	LEA	-10(A0),A0
	MOVE.W	D1,D0
	MULU	#30,D0
	ADD.L	D0,A0
	MOVE.L	A0,CurrCmds
	MOVE.L	$0016(A0),SampleInfo
	MOVE.L	$001A(A0),si_long
	TST.B	NoSampleInfo
	BNE.W	ssiskip
	MOVE.L	A0,-(SP)
	MOVE.B	#' ',FineTuneSign
	MOVE.B	24(A0),D0
	BEQ.S	dopfitu
	AND.B	#15,D0
	MOVE.B	#'+',FineTuneSign
	BTST	#3,D0
	BEQ.S	dopfitu
	MOVE.B	#'-',FineTuneSign
	MOVEQ	#16,D1
	SUB.B	D0,D1
	MOVE.B	D1,D0
dopfitu:
	MOVE.W	#$235B,TextOffset
	BSR.W	PrintHexDigit			;finetune
	LEA	FineTuneSign(PC),A0
	MOVE.W	#$235A,D1
	MOVEQ	#1,D0
	BSR.W	ShowText3			;finetunesign
	MOVE.L	(SP)+,A0
	CLR.W	WordNumber
	MOVE.B	$0019(A0),WordNumber+1
	MOVE.W	WordNumber,VolumeEfx
	OR.W	#$0C00,VolumeEfx
	MOVE.W	#$1FEA,TextOffset

;	BTST	#7,Packetfield
;	BNE.S	saahowdec

	BSR.W	PrintHexByte			; akt. sample volume in hex
;	bra.s	saahowd

;saahowdec:
;	BSR.W	Print2DecDigits			; akt samplevolume in dec

saahowd:
	MOVEQ	#0,D2
	MOVE.W	SampleInfo(PC),D2
	ADD.L	D2,D2
	MOVE.L	sam_sposflag,D3
	CMP.L	D2,D3
	BLS.S	ShowLen
	MOVE.L	D2,sam_sposflag
	BSR.W	sam_sposupdate
	MOVEQ	#0,D2
	MOVE.W	SampleInfo(PC),D2
	ADD.L	D2,D2

ShowLen:
	MOVE.W	#$00A9,D0
	MOVEQ	#$5B,D1
	MOVEQ	#6,D3
	BSR.W	PrintHexWord2			; length
	MOVE.W	#$00A9,D0
	MOVEQ	#$66,D1
	MOVEQ	#0,D2
	MOVE.W	si_long,D2
	ADD.L	D2,D2
	MOVEQ	#6,D3
	BSR.W	PrintHexWord2			; repeat
	MOVE.W	#$00A9,D0
	MOVEQ	#$71,D1
	MOVEQ	#0,D2
	MOVE.W	si_long+2,D2
	ADD.L	D2,D2
	MOVEQ	#6,D3
	BSR.W	PrintHexWord2			; replen
	BSR.S	ssiinst
ssiskip:
	TST.B	NoSampleInfo
	BEQ.S	ssiskp2
	CMP.W	#3,CurrScreen
	BEQ.B	ssiskp2
	;CMP.W	 #5,CurrScreen
	;BEQ.S	 ssiskp22
efgg1:	RTS

ssiskp2:
	MOVE.L	CurrCmds,A0
	MOVE.W	#$190A-4,D1			; -4 showsamplename mainscreen
	MOVEQ	#$16,D0 			; 16
	BSR.W	ShowText3
	RTS
ssiinst:
	TST.B	NoSampleInfo
	BEQ.S	ssiint3
	RTS

ssiint3:
	MOVE.W	InsNum(PC),WordNumber
	MOVE.W	#$1C7A,TextOffset
;	BTST	#7,Packetfield
;	BNE.S	sashowdec

	BRA.W	PrintHexByte			; sample number in hex
;sashowdec:
;	BRA.S	Print2DecDigits			; sample number in dec

FineTuneSign:	dc.b	' ',0
VolumeEfx:	dc.w	0

;***********************************
;* numeric output routines         *
;***********************************

Print2DecDigits:
	MOVE.W	#2,TextLength
	MOVEQ	#0,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	BRA.S	cal2thdig

Print2DecDigits_RD:
	MOVE.W	#2,TextLength
	MOVEQ	#3,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	BRA.B	lbC01300A

Print3DecDigits_2:
	MOVE.W	#3,TextLength
	MOVEQ	#0,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	BRA.S	cal3thdig

Print3DecDigits:
	MOVE.W	#3,TextLength
	MOVEQ	#0,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	BRA.S	lbC013002

Print4DecDigits:
	MOVE.W	#4,TextLength
	MOVEQ	#0,D1
	MOVE.W	WordNumber(PC),D1
	LEA	convprbyte(PC),A0
	DIVU	#$03E8,D1		;4t
	BSR.B	lbC01308E
cal3thdig:
	DIVU	#$0064,D1		;3t
	BSR.B	lbC01308E
cal2thdig:
	DIVU	#10,D1			;2t
	BSR.B	lbC01308E
	BSR.B	lbC01308E
	MOVE.L	#convprbyte,A0
	BRA.W	ShowText2

;***********************************

lbC013002:
	DIVU	#$0064,D1
	BSR.B	lbC01308E
lbC01300A:
	DIVU	#10,D1
	BSR.B	lbC01308E
	BSR.B	lbC01308E
	MOVE.L	#convprbyte,A0
	MOVE.W	fl3DecDigit1,D0
	MOVE.W	fl3DecDigit2,D1
	MOVE.W	TextLength,D3
	MOVE.W	#$0203,D2
	BRA.W	BlitText1

lbC01308E:
	ADD.B	#$30,D1
	MOVE.B	D1,(A0)+
	CLR.W	D1
	SWAP	D1
	RTS

;***********************************
Print6DecDigits:

	LEA	convprbyte,A0
	MOVE.L	D0,D1

	cmp.l	#1000000000,D1
	bcc.w	itstbyte		; its GByte

	cmp.l	#100000000,D1
	bcc.w	itsgbyte

	cmp.l	#10000000,D1		; its MByte
	bcc.w	itsmbyte

	CMP.L	#$000F4240,D1		; its KByte
	BCC.W	itskbyte

;--- bytes calc & out ---

	SWAP	D1
	CLR.W	D1
	SWAP	D1
	DIVU	#10,D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,5(A0)
	CMP.L	#10,D0
	BCS.S	c4tbyte

	DIVU	#$0064,D0
	MOVE.L	D0,D1
	CLR.W	D0
	SWAP	D0
	DIVU	#10,D0
	ADD.B	#$30,D0
	MOVE.B	D0,4(A0)
	AND.L	#$0000FFFF,D1
	BEQ.S	c3tbyte

	DIVU	#10,D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,3(A0)
	CLR.W	D1
	SWAP	D1
	TST.W	D1
	BEQ.S	c2tbyte

	DIVU	#10,D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,2(A0)
	CLR.W	D1
	SWAP	D1
	TST.W	D1
	BEQ.S	c1tbyte

	DIVU	#10,D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,1(A0)
	CLR.W	D1
	SWAP	D1
	TST.W	D1
	BEQ.S	c0tbyte

	DIVU	#10,D1
	SWAP	D1
	ADD.B	#$30,D1
	MOVE.B	D1,(A0)
	BRA.S	palltbytes

c4tbyte:	MOVE.B	#$20,4(A0)
c3tbyte:	MOVE.B	#$20,3(A0)
c2tbyte:	MOVE.B	#$20,2(A0)
c1tbyte:	MOVE.B	#$20,1(A0)
c0tbyte:	MOVE.B	#$20,(A0)
palltbytes:	MOVE.W	#6,TextLength
		BRA.W	ShowText2

;-------- kbytes calc & out --------------

;----- hexvariable in D0  -----
itskbyte:
	move.b	#$20,D0 		; space first byte
	bsr.s	convout 		; print space
	divu	#$03E8,D0
	move.w	d0,WordNumber
	BSR.W	Print4DecDigits
	MOVE.B	#'K',D0

convout:
	LEA	convprbyte(PC),A0
	MOVE.B	D0,(A0)
	MOVE.W	#1,TextLength
	BRA.W	ShowText2

itsmbyte:
	divu.w	#$2710,D0		; 10000
	move.w	d0,WordNumber
	bsr.w	Print4DecDigits
	move.b	#'0',D0
	bsr.s	convout
	move.b	#'K',D0
	bra.s	convout

;Giga-Bytes
itstbyte:
	;IFEQ	highercpu

	move.l	#1000000,D1
	CALL	divu_32		;divu.l d0/d1
	move.w	d0,WordNumber

	;ELSE

	;divu.l	#1000000,d0
	;move.w	d0,WordNumber

	;ENDC

	bsr.w	Print4DecDigits
	subq.w	#1,TextOffset
	move.b	#' ',d0
	bsr.s	convout
	move.b	#'G',d0
	bsr.s	convout
	move.b	#'B',d0
	bra.s	convout

itsgbyte:

	;IFEQ	highercpu

	move.l	#100000,D1
	CALL	divu_32		;divu.l d0/d1
	move.w	d0,WordNumber

	;ELSE

	;divu.l	#100000,d0
	;move.w	d0,WordNumber

	;ENDC

	bsr.w	Print4DecDigits
	subq.w	#1,TextOffset
	move.b	#' ',d0
	bsr.s	convout
	move.b	#'M',d0
	bsr	convout
	move.b	#'B',d0
	bra.w	convout

fl3DecDigit1:	dc.w	0
fl3DecDigit2:	dc.w	0
convprbyte:	dc.b	0,0,0,0,0,0

;***********************************
PrintHexWord2:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	lbL0132AA(PC),A0
	MOVEM.W D0/D1,-(SP)
	MOVE.L	D2,D0
	MOVE.W	D3,D1
	BSR.S	lbC0132B6
	MOVEM.W (SP)+,D0/D1
	BSR.W	Write_Text
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

lbL0132AA:
	dc.l	0,0,0

lbC0132B6:
	MOVEM.L D0-D4/A0/A1,-(SP)
	MOVEQ	#10,D2
	SUB.W	D1,D2
	BMI.S	lbC0132FC
	LSL.W	#2,D2
	LEA	lbL013302(PC,D2.W),A1
	MOVEQ	#0,D4
lbC0132C8:
	MOVE.L	(A1)+,D3
	BEQ.S	lbC0132EE
	MOVEQ	#$30,D2
lbC0132CE:
	CMP.L	D3,D0
	BCS.S	lbC0132D8
	SUB.L	D3,D0
	ADDQ.B	#1,D2
	BRA.S	lbC0132CE

lbC0132D8:
	CMP.B	#$30,D2
	BNE.S	lbC0132E6
	TST.W	D4
	BNE.S	lbC0132E6
	MOVEQ	#$20,D2
	BRA.S	lbC0132E8

lbC0132E6:
	MOVEQ	#-1,D4
lbC0132E8:
	MOVE.B	D2,(A0)+
	BRA.B	lbC0132C8

lbC0132EE:
	CMP.B	#$20,-1(A0)
	BNE.S	lbC0132FC
	MOVE.B	#$30,-1(A0)
lbC0132FC:
	MOVEM.L (SP)+,D0-D4/A0/A1
	RTS


lbL013302:
	dc.l	$3B9ACA00,$05F5E100,$00989680,$000F4240,$000186A0
	dc.l	$00002710,$000003E8,$00000064,10,1,0

;***********************************
lbC01332E:
	MOVEM.L D1-D7/A0-A6,-(SP)
	LEA	0(A0,D0.W),A1
	LEA	lbL013384(PC),A2
	MOVEQ	#0,D3
lbC01333C:
	MOVE.B	-1(A1),D1
	CMP.B	#$30,D1
	BCS.S	lbC01334C
	CMP.B	#$39,D1
	BCS.S	lbC013354
lbC01334C:
	SUBQ.L	#1,A1
	SUBQ.W	#1,D0
	BNE.S	lbC01333C
	BRA.S	lbC01337C

lbC013354:
	MOVE.B	-(A1),D1
	CMP.B	#$30,D1
	BCS.S	lbC01337C
	CMP.B	#$39,D1
	BHI.S	lbC01337C
	SUB.B	#$30,D1
	AND.W	#15,D1
	MOVE.L	(A2)+,D2
	BEQ.S	lbC01337C
lbC01336E:
	TST.W	D1
	BEQ.S	lbC013378
	ADD.L	D2,D3
	SUBQ.W	#1,D1
	BPL.S	lbC01336E
lbC013378:
	SUBQ.W	#1,D0
	BNE.S	lbC01333C
lbC01337C:
	MOVE.L	D3,D0
	MOVEM.L (SP)+,D1-D7/A0-A6
	RTS

lbL013384:
	dc.l	1,10,$00000064,$000003E8,$00002710,$000186A0
	dc.l	$000F4240,$00989680,$05F5E100,$3B9ACA00,0

;***********************************
PrintHexDigit:
	AND.L	#15,D0
	ADD.L	D0,D0
	LEA	FastHexTable+1(PC),A0
	ADD.L	D0,A0
	MOVE	#1,TextLength
	BRA.W	ShowText2

;***********************************

ShowHexByte:
	AND.L	#15,D3
	ADD.L	D3,D3
	LEA	FastHexTable+1(PC),A0
	ADD.L	D3,A0
	MOVE.W	#1,D3
	BRA.W	Write_Text

PrintHexWord:
	LEA	WordNumber(PC),A0
	MOVEQ	#0,D0
	MOVE.B	(A0),D0
	LSL.L	#1,D0
	LEA	FastHexTable(PC),A0
	ADD.L	D0,A0
	MOVE.W	#2,TextLength
	BSR.W	ShowText2

PrintHexByte:
	LEA	WordNumber(PC),A0
	MOVEQ	#0,D0
	MOVE.B	1(A0),D0
	LSL.L	#1,D0
	MOVE.L	#FastHexTable,A0
	ADD.L	D0,A0
	MOVE	#2,TextLength
	BSR.W	ShowText2
	CLR	WordNumber
	RTS

lbC013442:
	LEA	WordNumber(PC),A0
	MOVEQ	#0,D3
	MOVE.B	1(A0),D3
	LSL.L	#1,D3
	MOVE.L	#FastHexTable,A0
	ADD.L	D3,A0
	MOVE.W	#2,D3
	BSR.W	Write_Text
	CLR.W	WordNumber
	RTS

;********************************
;* copper routines from pt      *
;********************************
;in = D1,D2,D3,D5

BlitToMain:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit

	LEA	PTBitMap,A4
	MOVEQ	#0,D6
	MOVE.W	#2,BlitControlBit
	BSR.W	mt_drawblitted			; now blit
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

ClrWhoSamScr:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	MOVE.L	LineScreen,A4
	MOVEQ	#0,D6
	MOVE.W	#1,BlitControlBit
	BSR.W	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

DrawRecBox:					; clears  area
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	MOVE.L	TextBplPtr(PC),A4
	MOVEQ	#0,D6
	MOVE.W	#1,BlitControlBit
	BSR.W	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

Blitcharge0:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit

	LEA	PTBitMap,A4
	MOVE.W	#$035A,D6
	MOVE.W	#2,BlitControlBit
	BSR.W	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

BlitCharge1:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	LEA	PTBitMap,A4			; mainscreen gfxdata
	ADD.L	#20480,A4
	MOVE.W	#$035A,D6
	MOVE.W	#1,BlitControlBit
	BSR.B	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

BlitCharge2:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	MOVE.L	LineScreen,A4
	MOVE.W	#$035A,D6
	MOVE.W	#1,BlitControlBit
	BSR.S	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;********************************

BlitTrackMarks:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	MOVE.L	TextBplPtr,A4
	MOVE.W	#$035A,D6
	MOVE.W	#1,BlitControlBit
	BSR.S	mt_drawblitted
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***********************************
;* the routine who draws on screen *
;* called from blitter routines    *
;***********************************

mt_drawblitted:
	LEA	BLTDDAT,A6		; $DFF000 blitter main addr
	CMP.W	#639,D0			; 641 xrmax
	BHI.W	blitterskip
	MOVEQ	#0,D7
mt_bltafg:
	BTST	#6,2(A6)
	BNE.S	mt_bltafg

	CMP.W	#$035A,D6		;858
	BEQ.S	.l0
	MOVE.W	#$030A,D6		;778
	BTST	D7,D5
	BEQ.S	.l0
	MOVE.W	#$03FA,D6

.l0:	MOVEM.W D0-D5,-(SP)
	MOVE.L	A4,A5
	ADD.W	#$0010,D2
	MOVE.W	D6,$0040(A6)
	CLR.W	$0042(A6)
	MOVE.W	D2,D4
	AND.W	#15,D4
	MOVE.W	#$FFFF,D5
	LSR.W	D4,D5
	EOR.W	#$FFFF,D5
	MOVE.W	D5,$0046(A6)
	MOVE.W	D0,D4
	AND.W	#15,D4
	MOVE.W	#$FFFF,D5
	LSR.W	D4,D5
	MOVE.W	D5,$0044(A6)
	SUB.W	D1,D3
	MULU	#$0050,D1
	ADD.L	D1,A5
	ADD.W	D4,D2
	SUB.W	D0,D2
	LSR.W	#3,D0
	AND.W	#$FFFE,D0
	EXT.L	D0
	ADD.L	D0,A5
	LSR.W	#3,D2
	AND.W	#$FFFE,D2
	MOVE.W	#$0050,D4
	NEG.W	D2
	ADD.W	D2,D4
	MOVE.W	D4,$0060(A6)
	MOVE.W	D2,$0064(A6)
	MOVE.W	D4,$0066(A6)
	NEG.W	D2
	MOVE.L	A5,$0048(A6)
	MOVE.W	#$FFFF,$0074(A6)
	MOVE.L	A5,$0054(A6)
	LSL.W	#6,D3
	LSR.W	#1,D2
	ADD.W	D2,D3
	MOVE.W	D3,$0058(A6)
	MOVEM.W (SP)+,D0-D5

	ADD.L	#20480,A4
	ADDQ.W	#1,D7
	CMP.W	BlitControlBit(PC),D7
	BMI.W	mt_bltafg

blitterskip:
	BTST	#6,2(A6)
	BNE.S	blitterskip
	RTS

BlitControlBit:
	dc.w	1

;************************************
;* alphanumeric output routines     *
;************************************

ShowText3:
	MOVE.W	D0,TextLength
	MOVE.W	D1,TextOffset

ShowText2:
	MOVE.L	A0,ShowTextPtr

ShowText:
	btst	#1,CfgFlag
	beq.s	ShowTextO


	MOVEM.L A2-A4,-(SP)
	LEA	TextTable(PC),A3
	LEA	FontData,A4		;FontGFX
	MOVE.W	TextLength(PC),D0
	MOVE.L	TextBplPtr(PC),A1
	MOVEQ	#0,D1			;new
	MOVE.W	TextOffset(PC),D1
	sub.w	#$50,D1 		;3.61
	LEA	0(A1,D1.W),A1
	ADD.W	D0,TextOffset
	MOVE.L	ShowTextPtr(PC),A0
	BRA.S	dstlope

dstloop:
	MOVEQ	#0,D1
	MOVE.B	(A0)+,D1
	BNE.S	dstskip
	MOVE.B	ShowZeroFlag(PC),D1

dstskip:
	MOVE.b	0(A3,D1.W),D1		;get asc a-z
	LSL.W	#3,D1
	MOVE.L	A4,A2
	ADD.L	D1,A2
	subq.l	#1,a2			;3.61
	MOVE.B	(A2)+,(A1)+
	MOVE.B	(A2)+,$004F(A1)
	MOVE.B	(A2)+,$009F(A1) 	;+$50
	MOVE.B	(A2)+,$00EF(A1)
	MOVE.B	(A2)+,$013F(A1) 	;3.61
	move.b	(a2)+,$018F(A1) 	;new in 3.61 for new font
	move.b	(a2),$01DF(a1)

dstlope:
	DBRA	D0,dstloop		;to last ascii
	MOVEM.L (SP)+,A2-A4

	RTS

;***********************************
; old 3.15 font showtext

ShowTextO:
	MOVEM.L A2-A4,-(SP)
	lea	TextTable3(PC),A3
	lea	FontData2,a4
	MOVE.W	TextLength(PC),D0
	MOVE.L	TextBplPtr(PC),A1
	MOVEQ	#0,D1			;new
	MOVE.W	TextOffset(PC),D1
	LEA	0(A1,D1.W),A1
	ADD.W	D0,TextOffset
	MOVE.L	ShowTextPtr(PC),A0
	BRA.S	dstlopeO

dstloopO:
	MOVEQ	#0,D1
	MOVE.B	(A0)+,D1
	BNE.S	dstskipO
	MOVE.B	ShowZeroFlag(PC),D1

dstskipO:
	MOVE.b	0(A3,D1.W),D1		;get asc a-z
	LSL.W	#3,D1
	MOVE.L	A4,A2
	ADD.L	D1,A2

	MOVE.B	(A2)+,(A1)+
	MOVE.B	(A2)+,$004F(A1)
	MOVE.B	(A2)+,$009F(A1) 	;+$50
	MOVE.B	(A2)+,$00EF(A1)

	MOVE.B	(A2),$013F(A1)		;3.61

dstlopeO:
	DBRA	D0,dstloopO		;to last ascii
	MOVEM.L (SP)+,A2-A4
	RTS


SpaceShowText:
	MOVE.B	ShowZeroFlag(PC),-(SP)
	MOVE.B	#' ',ShowZeroFlag
	BSR.W	ShowText
	MOVE.B	(SP)+,ShowZeroFlag
	RTS


;***********************************
; blit routines
; blit out text

BlitText1:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	LEA	BlitTable1(PC),A1

	LEA	PTBitMap,A4
	MOVEQ	#1,D7
	BSR.W	Wr_Txt1
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

BlitText2:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	LEA	BlitTable2(PC),A1

	LEA	PTBitMap,A4
	MOVEQ	#1,D7
	BSR.W	Wr_Txt1
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS


;***********************************

; a0=Text d0=xpos
; d1=ypos d3=length

Write_Text:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	LEA	BlitTable1(PC),A1
	MOVE.L	TextBplPtr,A4
	MOVEQ	#1,D2
	MOVEQ	#0,D7
	BSR.S	Wr_Txt1
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***********************************

Wr_Message:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit

	LEA	PTBitMap,A4
	MOVEQ	#1,D7
	BSR.W	Wr_Txt9
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;***********************************

PrintTextInReqs:
	MOVEM.L D0-D7/A0/A1,-(SP)
	MOVE.L	A0,A1
	MOVEQ	#-1,D3
txt_nlopa:
	ADDQ.L	#1,D3
	TST.B	(A0)+
	BNE.S	txt_nlopa
	MOVE.L	A1,A0
	BSR.B	Wr_Message
	MOVE.L	D5,A0
	MOVEM.L (SP)+,D0-D7/A0/A1
	RTS

Wr_Txt1:
	LEA	BLTDDAT,A6
	LEA	TextTable2(PC),A5
	MOVE.W	D2,TxtAdress
	MULU	#$0050,D1
	LEA	0(A4,D1.L),A4
	;SUB.L	#2,A4
	MOVE.W	D3,D6
	SUBQ.W	#1,D6
	BMI.W	Wr_Txt8
	MOVE.W	#$FFFC,$0062(A6)
	MOVE.W	#$005C,$0064(A6)
	MOVE.W	#$004C,$0060(A6)
	MOVE.W	#$004C,$0066(A6)
	MOVE.L	#Wr_TxtBuf,$004C(A6)
Wr_Txt2:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	BNE.S	Wr_Txt3
	MOVE.B	ShowZeroFlag(PC),D2
Wr_Txt3:
	MOVE.W	D0,D5
	ADDQ.W	#8,D0
	MOVE.L	A4,A3
	MOVE.B	0(A5,D2.W),D2
	CMP.W	#$00A0,D2			; a0
	BCS.S	Wr_Txt4
	SUB.W	#$0020,D2
Wr_Txt4:
	LEA	ReqTxtGFX1,A2
	LEA	0(A2,D2.W),A2
	MOVE.L	#$FF000000,D4
	AND.W	#1,D2
	BEQ.S	Wr_Txt5
	SUBQ.W	#8,D5
	LSR.L	#8,D4
Wr_Txt5:
	MOVE.W	D5,D1
	AND.W	#15,D1
	ROR.W	#4,D1
	ASR.W	#3,D5
	LEA	0(A3,D5.W),A3
	MOVE.B	TxtAdress(PC),D2
	MOVE.B	TxtAdress+1(PC),D3		  ;!!!
Wr_Txt6:
	BTST	#6,2(A6)
	BNE.S	Wr_Txt6
	MOVE.L	D4,Wr_TxtBuf
	MOVE.L	D4,$0044(A6)
	MOVE.W	D1,$0042(A6)
	OR.W	#$0F00,D1
	MOVE.W	D7,D4
Wr_Txt7:
	BTST	#6,2(A6)
	BNE.S	Wr_Txt7
	MOVEQ	#0,D5
	ROXR.B	#1,D2
	ROXL.B	#1,D5
	ROXR.B	#1,D3
	ROXL.B	#1,D5
	MOVE.B	0(A1,D5.W),D1
	MOVE.W	D1,$0040(A6)
	MOVE.L	A3,$0048(A6)
	MOVE.L	A2,$0050(A6)
	MOVE.L	A3,$0054(A6)
	MOVE.W	#$0142,$0058(A6)
	LEA	$5000(A3),A3
	DBRA	D4,Wr_Txt7
	DBRA	D6,Wr_Txt2
Wr_Txt8:
	BTST	#6,2(A6)
	BNE.S	Wr_Txt8
	RTS

TxtAdress:	dc.w 0
BlitTable1:	dc.l $02C20ECE
BlitTable2:	dc.l $0ACA0ACA

;***********************************

Wr_Txt9:
	LEA	BLTDDAT,A6
	LEA	TextTable2(PC),A5
	MOVE.W	D0,blttxt9flag
	MULU	#$0050,D1
	LEA	0(A4,D1.L),A4
	MOVE.W	D3,D6
	SUBQ.W	#1,D6
	BMI.W	txt_lp8
	MOVE.W	#$FFFC,$0062(A6)
	MOVE.W	#$005C,$0064(A6)
	MOVE.W	#$004C,$0060(A6)
	MOVE.W	#$004C,$0066(A6)
	MOVE.L	#Wr_TxtBuf,$004C(A6)
txt_lp1:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	BNE.S	txt_lp2
	MOVE.B	ShowZeroFlag(PC),D2
txt_lp2:
	CMP.W	#10,D2
	BNE.S	txt_lp3
	MOVE.W	blttxt9flag(PC),D0
	LEA	$0230(A4),A4
	DBRA	D6,txt_lp1
	BRA.W	txt_lp8

txt_lp3:
	MOVE.W	D0,D5
	MOVE.L	A4,A3
	CMP.W	#$00A0,D2
	BCS.S	txt_lp4
	SUB.W	#$0020,D2
txt_lp4:
	MOVE.B	0(A5,D2.W),D2
	ADDQ.W	#7,D0
	LEA	ReqTxtGFX2,A2
	LEA	0(A2,D2.W),A2
	MOVE.L	#$FE000000,D4
	AND.W	#1,D2
	BEQ.S	txt_lp5
	SUBQ.W	#8,D5
	LSR.L	#8,D4
txt_lp5:
	MOVE.W	D5,D1
	AND.W	#15,D1
	ROR.W	#4,D1
	ASR.W	#3,D5
	LEA	0(A3,D5.W),A3
txt_lp6:
	BTST	#6,2(A6)
	BNE.S	txt_lp6
	MOVE.L	D4,Wr_TxtBuf
	MOVE.L	D4,$0044(A6)
	MOVE.W	D1,$0042(A6)
	OR.W	#$0FC2,D1
	MOVE.W	D1,$0040(A6)
	MOVE.W	D7,D4
txt_lp7:
	BTST	#6,2(A6)
	BNE.S	txt_lp7
	MOVE.L	A3,$0048(A6)
	MOVE.L	A2,$0050(A6)
	MOVE.L	A3,$0054(A6)
	MOVE.W	#$0182,$0058(A6)
	LEA	$0240(A2),A2
	LEA	$5000(A3),A3
	DBRA	D4,txt_lp7
	DBRA	D6,txt_lp1
txt_lp8:
	BTST	#6,2(A6)
	BNE.S	txt_lp8
	RTS

;***********************************

blttxt9flag:	dc.w	0
ShowZeroFlag:	dc.b	$5F,0

TextTable:
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 0
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	;   SPC !  "  #        &  '			  /
	dc.b 00,01,02,03,04,05,06,07,08,09,10,11,12,13,14,15 ; 32
	;    0	1  2  3  4  5  6  7  8	9
	dc.b 16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31

	;    @	A  B  C  D  E  F  G  H	I  J  K  L  M  N  O
	dc.b 32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47 ; 64

	;    P	Q  R  S  T  U  V  W  X	Y  Z  [  \  ]  ^  _
	dc.b 48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63

	;	a  b  c  d  e  f  g  h	i  j  k  l  m  n  o
	dc.b 69,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85 ; 96

	;    p	q  r  s  t  u  v  w  x	y  z  <  |  >  ~
	dc.b 86,87,88,89,90,91,92,93,94,95,96,65,66,67,68,63

	dc.b 69,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; 128

	dc.b 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	;	!Nt
	dc.b 00,64,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; 160
	dc.b 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

;---
	dc.b 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00 ; 192

	;					  ;	     
	dc.b 00,00,00,00,00,00,101,00,00,00,00,00,103,00,00,100 ;n

	;		;!
	dc.b 00,00,00,00,98,00,00,00,00,00,00,00,00,00,00,00 ; 224

	;		       !		 
	dc.b 00,00,00,00,00,00,97,00,00,00,00,00,99,00,00,00


TextTable2:
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14
	dc.b	15,$10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A
	dc.b	$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,$26
	dc.b	$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$32
	dc.b	$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E
	dc.b	$3F,$40,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A
	dc.b	$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36
	dc.b	$37,$38,$39,$3A,$41,$42,$43,$44,$3F,$45,$46,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,$40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

TextTable3:
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 0
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b 00,01,02,03,04,05,06,07,08,09,10,11,12,13,14,15 ; 32
	dc.b 16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
	dc.b 32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47 ; 64
	dc.b 48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
	dc.b 69,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47 ; 96
	dc.b 48,49,50,51,52,53,54,55,56,57,58,65,66,67,68,63
	dc.b 69,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 128
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b 0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 160
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 192
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 224
	dc.b 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	EVEN

;***********************************
;* sprite positionizing of PT      *
;***********************************
;in => A0=Sprite D0=XPos D1=YPos D2=YLen

SetSpritePos:
	ADD.W	SprPos1(PC),D1
	ADD.W	D1,D2
	ROL.W	#7,D2
	ASL.W	#1,D2
	BCC.S	sppskip
	OR.W	#2,D2

sppskip:
	ROL.W	#7,D1
	ASL.W	#1,D1
	BCC.S	sppskip2
	OR.W	#4,D2

sppskip2:
	ADD.W	SprPos2(PC),D0
	ASR.W	#1,D0
	BCC.S	sppskip3
	OR.W	#1,D2

sppskip3:
	OR.W	D0,D1
	MOVE.W	D1,(A0)
	MOVE.W	D2,2(A0)
	RTS

;***********************************
;* protracker patternpropscroller  *
;  AND patterncursor sprite ...    *
;  the same sprite is used         *
;***********************************
SprPos1:	dc.w	$2C
SprPos2:	dc.w	$7D

UpdscrollSprite2:
	MOVE.L	#$800F000,D4
	MOVE.L	#$78008800,D5
	MOVE.L	#$F8007800,D6
	BRA.S	oposet_a

UpdscrollSprite1:
	MOVE.L	#$F800F000,D4
	MOVE.L	#$F0008800,D5
	MOVE.L	#$80007800,D6
oposet_a:
	CMP.W	#83,D2
	BMI.S	.l1
	MOVEQ	#83,D2

.l1:	CMP.W	#4,D2
	BPL.S	.l2
	MOVEQ	#4,D2

.l2:	MOVE.L CspritePtr,A0
	; CMP.L	#0,A0
	; BEQ.S	.l3					;nonewpos

	chn8test
	beq.s	.s1
	MOVE.L	(A0),Cursor4chn+8
	bra.s	.l3

.s1:	MOVE.L	(A0),Cursor8chn+8
.l3:	LEA	EmptySprite,A0
	LEA	4(A0),A0
	MOVE.L	D4,(A0)+
	MOVE.W	D2,D3
	SUB.W	#3,D3

.lop:	MOVE.L	D5,(A0)+
	DBRA	D3,.lop

	MOVE.L	D6,(A0)+
	MOVE.L	A0,CspritePtr
	chn8test
	beq.s	.sk1

	LEA	Cursor4chn+8,A1
	bra.s	.sk2
.sk1:	LEA	Cursor8chn+8,A1
.sk2:	MOVEQ	#43,D3
.lopa:
	MOVE.B	(A1)+,(A0)+
	DBRA	D3,.lopa

	LEA	EmptySprite,A0
	BRA.W	SetSpritePos

;***********************************
;* load raw data routine           *
;***********************************

;-- return DiskDataPtr=data
;          DiskDataLength=length

DoLoadData:
	TST.L	DiskDataLength
	BEQ.S	NoValidFile
	TST.L	DiskDataPtr
	BEQ.B	NoValidFile
	CALL	SetDiskPtrCol

nounpack2:
	LEA	LoadingText(PC),A0
	BSR.W	ShowStatusText
	MOVE.L	DOSBase,A6

	MOVE.L	FileNamePtr(PC),D1
	MOVE.L	#$000003ED,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile

	MOVE.L	FileHandle(PC),D1
	MOVE.L	DiskDataPtr(PC),D2
	MOVE.L	DiskDataLength(PC),D3
	CALLSYS	Read

	MOVE.L	FileHandle(PC),D1
	CALLSYS	Close
	clr.l	FileHandle

NoValidFile:
	CALL	SetNormalPtrCol
	BSR.W	ShowAllRight
	MOVEQ	#-1,D0
	RTS

;***********************************
;* save raw data file              *
;***********************************

DoSaveData:
	CALL	SetDiskPtrCol
	LEA	Saving.MSG(PC),A0
	BSR.W	ShowStatusText
	MOVE.L	DOSBase,A6
	MOVE.L	FileNamePtr(PC),D1
	MOVE.L	#$000003EE,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile
	MOVE.L	FileHandle(PC),D1
	MOVE.L	DiskDataPtr(PC),D2
	MOVE.L	DiskDataLength(PC),D3
	CALLSYS	Write
	MOVE.L	FileHandle(PC),D1
	CALLSYS	Close
	CLR.L	FileHandle
	GOTO	SetNormalPtrCol


;***********************************
CantSaveFile:	LEA	CantSaveFileText(PC),A0
		BRA.W	  caopfil
CantExamFile:	LEA	CantExamFileText(PC),A0
		BRA.W	  caopfil
CantFindFile:	LEA	CantFindFileText(PC),A0
		BRA.W	  caopfil
FileIsEmpty:	LEA	FileIsEmptyText(PC),A0
		BRA.W	  caopfil

CantOpenFileText:	dc.b	'CAN''T OPEN FILE!',0
			EVEN
CantSaveFileText:	dc.b	'CAN''T SAVE FILE!',0
			EVEN
CantExamFileText:	dc.b	'EXAMINE ERROR!',0
			EVEN
CantFindFileText:	dc.b	'CAN''T FIND FILE!',0
			EVEN
FileIsEmptyText:	dc.b	'FILE IS EMPTY !',0
			EVEN

;***********************************
;* PLST Samplelist editing for pt  *
;***********************************
PLST:	CLR.B	RawKeyCode
	CMP.W	#6,CurrScreen
	BEQ.W	ExitPLST
	CALL	TopExit
	CALL	WaitForButtonUp
	MOVE.W	#6,CurrScreen
	ST	NoSampleInfo				;no text infos about samples
	ST    	ScopeEnable
	BSR.B	SwapPLSTScreen
	BEQ.W	ExitPLST

PLST_rtsx:
      CLR.W   PED_Action
	MOVE.L  TextBplPtr(PC),A0
	MOVE.W  #$0987,D0

.loo:
       CLR.L   (A0)+
	DBRA    D0,.loo

PLST_rts:
	CALL	SetNormalPtrCol

PLST_Refresh:
	BSR.W	ShowPEDnumbers
	BSR.W	ShowPresetNames
PLST_Refresh2:
	BSR.B	PLSTCheckNum
	BSR.W	RedrawPLST
	BSR.W	rd_updplstlist
	;BSR	ShowPresetNames
	;BSR	PED_OneUp
	BSR.W	ShowPEDnumbers

PLST_rts2:
	RTS

;------ make bitmap for PLST ------

SwapPLSTScreen:
	lea	PLSTData,a0
	CALL	UpperDecrunch
	MOVEQ	#-1,D0
	rts

ShowDiskNames:
	MOVE.W	#$04C0,TextOffset
	MOVE.W	#5,TextLength
	MOVEA.L #STText1,A0
	BSR.W	ShowText2
	ADDQ.W	#1,TextOffset
	MOVE.L	#STText2,A0
	BSR.W	ShowText2
	ADDQ.W	#1,TextOffset
	MOVE.L	#STText3,A0
	BRA.W	ShowText2

PLSTCheckNum:
	TST.L	PLSTmem
	BEQ.W	NoPLST
	TST.L	MaxPLSTOffset
	BEQ.W	NoPLST
	MOVE.L	PLSTmem(PC),A0
	MOVE.W	PresetTotal(PC),D7
	SUBQ.W	#1,D7
	TST.B	STText1Number
	BNE.B	plstsskip
	TST.B	STText2Number
	BNE.B	plstsskip
	TST.B	STText3Number
	BEQ.B	PLSTMarkAll
plstsskip:
	MOVE.L	STText1Number-1(PC),A3
	MOVE.L	STText2Number-1(PC),A4
	MOVE.L	STText3Number-1(PC),A5
	MOVEQ	#0,D6
PLSTmarkloop:						;Set lowercase 'st'
	MOVE.W	#'st',(A0)
	MOVE.B	3(A0),D0
	CMP.B	#'a',D0
	BCS.S	pmlskp1
	SUB.B	#32,D0

pmlskp1:
	MOVE.B	D0,3(A0)
	MOVE.B	4(A0),D0
	CMP.B	#'a',D0
	BCS.S	pmlskp2
	SUB.B	#32,D0

pmlskp2:
	MOVE.B	D0,4(A0)
	MOVE.L	2(A0),D0

PLSTchk1:
	CMP.L	A3,D0
	BNE.B	PLSTchk2
	MOVE.W	#'ST',(A0)
	ADDQ	#1,D6
	BRA.S	PLSTmarknext

PLSTchk2:
	CMP.L	A4,D0
	BNE.S	PLSTchk3
	MOVE.W	#'ST',(A0)
	ADDQ	#1,D6
	BRA.B	PLSTmarknext

PLSTchk3:
	CMP.L	A5,D0
	BNE.S	PLSTmarknext
	MOVE.W	#'ST',(A0)
	ADDQ	#1,D6

PLSTmarknext:
	ADD.L	#30,A0
	DBRA	D7,PLSTmarkloop
	MOVE	D6,PresetMarkTotal
	CLR	PLSTpos
	CLR.L	PLSTOffset
	RTS

PLSTMarkAll:
	MOVE.W	#'ST',(A0)				;set uppercase 'ST'
	LEA	30(A0),A0
	DBRA	D7,PLSTMarkAll
	MOVE	PresetTotal(PC),PresetMarkTotal
	CLR	PLSTpos
	CLR.L	PLSTOffset
	RTS

NoPLST:
	CLR	PresetMarkTotal
	CLR	PLSTpos
	CLR.L	PLSTOffset
	RTS

RedrawPLST:
	MOVE.W	PresetMarkTotal(PC),WordNumber
	MOVE.W	#349,TextOffset

	BSR.W	Print4DecDigits
	BSR.W	ShowDiskNames

	;TST.L	PLSTmem 				;RAM valid
	;BEQ.W	PLST_rts2

	;TST.L	MaxPLSTOffset
	;BEQ.W	PLST_rts2

	MOVE.L	PLSTOffset(PC),D6
	MOVE.L	PLSTmem(PC),A6				;get the PLST
	;MOVE.W	#$0790-15-160,A5			;Textoffset

	move.w	#$169,A5
	LEA	PLSTOffset(PC),A4
	MOVEQ	#11+4+3,D7				;number of lines to print
	TST.L	D6
	BMI.W	EndOfPLST

dtplstloop:
	CMP	#'ST',(A6,D6.L) 			;check for 'ST'
	BNE.W	PLSTNext
	MOVE.L	D6,(A4)+
	MOVE	A5,TextOffset

	MOVE	#19,TextLength
	LEA	(A6,D6.L),A3

	btst	#1,CfgFlag
	beq.b	highok3
	bset	#1,CfgStore
	bclr	#1,CfgFlag

highok3:
	MOVE.L	A3,ShowTextPtr
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText				;print samplename
	MOVEM.L (SP)+,D0-D7/A0-A6

	btst	#1,CfgStore
	beq.s	highok4
	bset	#1,CfgFlag

highok4:

	BTST	#7,Packetfield				;hex or dec
	BNE.S	decplstll
;--hex
hexplstll:
	ADDQ.W	#3,TextOffset
	MOVE	22(A6,D6.L),WordNumber
	MOVE	WordNumber,D0
	LSL	#1,D0
	MOVE	D0,WordNumber
	BSR.W	PrintHexWord

	ADDQ.W	#1,TextOffset
	MOVE	$1A(A6,D6.L),WordNumber
	MOVE	WordNumber,D0
	LSL	#1,D0
	MOVE	D0,WordNumber
	BSR.W	PrintHexWord

	ADDQ.W	#1,TextOffset
	MOVE.W	$1C(A6,D6.L),WordNumber
	MOVE.W	WordNumber,D0
	LSL	#1,D0
	MOVE.W	D0,WordNumber
	BSR.W	PrintHexWord
	BRA.S	wwplstll

decplstll:
;--dec
	ADD.W	#8+3,TextOffset
	moveq	#0,d0
	MOVE.W	22(A6,D6.L),D0
	LSL	#1,D0
	;MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	Print6DecDigits
	;MOVEM.L (SP)+,D0-D7/A0-A6

wwplstll:
	ADD.L	#30,D6
	CMP.L	MaxPLSTOffset(PC),D6
	BHI.S	EndOfPLST
	ADD	#480,A5 				;next screen position
	DBRA	D7,dtplstloop
	RTS

PLSTNext:
	ADD.L	#30,D6
	CMP.L	MaxPLSTOffset(PC),D6
	BHI.S	EndOfPLST
	BRA.W	dtplstloop

EndOfPLST:
	MOVE.L	#$FFFFFFFF,(A4)+
	MOVE	A5,TextOffset
	MOVE	#38,TextLength
	MOVE.L	#EmptyTextField,ShowTextPtr
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	ADD	#480,A5 				;textoffset
	DBRA	D7,EndOfPLST
	RTS

TypeInDisk1:
	LEA	STText1Number(PC),A6
	MOVE	#156,LineCurX
	BRA.S	DoTypeInDisk

TypeInDisk2:
	LEA	STText2Number(PC),A6
	MOVE	#204,LineCurX
	BRA.S	DoTypeInDisk

TypeInDisk3:
	LEA	STText3Number(PC),A6
	MOVE	#252,LineCurX

DoTypeInDisk:
	MOVE.W	#1,MountFlag				;fix
	CLR.B	(A6)
	CLR.B	1(A6)
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	BSR.W	ShowDiskNames
	MOVE	#20,LineCurY
	CALL	UpdateLineCurPos
	CALL	GetHexKey
	TST.B	RawKeyCode
	BNE.W	ClearDiskNum
	checkrmb
	BEQ.W	ClearDiskNum
	ADD	D1,D1
	LEA	FastHexTable+1(PC),A0
	MOVE.B	(A0,D1.W),(A6)
	ADDQ	#8,LineCurX
	BSR.W	ShowDiskNames
	CALL	UpdateLineCurPos
	CALL	GetHexKey
	TST.B	RawKeyCode
	BNE.W	ClearDiskNum
	checkrmb
	BEQ.W	ClearDiskNum
	ADD	D1,D1
	LEA	FastHexTable+1(PC),A0
	MOVE.B	(A0,D1.W),1(A6)
	CALL	RestorePtrCol
	BSR.W	PLSTCheckNum
	BSR.W	RedrawPLST
	CLR	LineCurX
	MOVE	#270,LineCurY
	CALL	UpdateLineCurPos
	BRA.W	PLST_Refresh				;4.0

ClearAllDisks:
	CLR.W	MountFlag				;fix
	BSR.S	DoClearDisks
	BSR.W	PLSTCheckNum
	BRA.W	PLST_Refresh				;4.0

DoClearDisks:
	MOVEQ	#0,D0
	MOVE.B	D0,STText1Number
	MOVE.B	D0,STText1Number+1
	MOVE.B	D0,STText2Number
	MOVE.B	D0,STText2Number+1
	MOVE.B	D0,STText3Number
	MOVE.B	D0,STText3Number+1
	RTS

MountList:
	CALL	StorePtrCol
	CALL	SetDiskPtrCol
	BSR.B	DoClearDisks
	MOVE.W	#1,MountFlag
	LEA	df0text(PC),A4

	MOVEM.L D1-D7/A0-A6,-(SP)
	BSR.S	DoMountList
	MOVEM.L (SP)+,D1-D7/A0-A6

	LEA	STText1(PC),A0
	BSR.B	CheckMountName
	LEA	df1text(PC),A4

	MOVEM.L D1-D7/A0-A6,-(SP)
	BSR.S	DoMountList
	MOVEM.L (SP)+,D1-D7/A0-A6

	LEA	STText2(PC),A0
	BSR.S	CheckMountName
	LEA	df2text(PC),A4

	MOVEM.L D1-D7/A0-A6,-(SP)
	BSR.S	DoMountList
	MOVEM.L (SP)+,D1-D7/A0-A6

	LEA	STText3(PC),A0
	BSR.S	CheckMountName

	CLR.W	MountFlag
	CALL	RestorePtrCol
	BRA.W	cdisknum2

DoMountList:
	CLR.L	FIB_FileName
	CLR.L	FIB_FileName+4
	CLR.L	FIB_FileName+8
	MOVE.L	DOSBase,A6
	MOVE.L	A4,D1
	MOVEQ	#-2,D2
	CALLSYS	Lock
	MOVE.L	D0,FileLock
	BEQ.S	MountError
	MOVE.L	FileLock(PC),D1
	MOVE.L	#FileInfoBlock,D2
	CALLSYS	Examine
	TST.L	D0
	BEQ.S	MountError
	MOVE.L	FileLock(PC),D1
	CALLSYS	UnLock

MountError:
	MOVEQ	#-1,D0
	RTS

CheckMountName:
	MOVE	FIB_FileName,D0
	BEQ.B	MountError
	MOVE	#'ST',D1
	AND	#$1F1F,D0
	AND	#$1F1F,D1
	CMP	D0,D1
	BNE.S	ClearDiskNum
	MOVE.B	FIB_FileName+3,D0
	LSL	#8,D0
	MOVE.B	FIB_FileName+4,D0
	CMP	#'00',D0
	BEQ.S	ClearDiskNum
	MOVE.B	D0,4(A0)				;put disk number into st-xx
	LSR	#8,D0
	MOVE.B	D0,3(A0)
	MOVEQ	#0,D0
	RTS

ClearDiskNum:
	CLR.B	RawKeyCode
	CALL	RestorePtrCol
	CLR.B	(A6)
	CLR.B	1(A6)
	CLR	LineCurX
	MOVE	#270,LineCurY
	CALL	UpdateLineCurPos

cdisknum2:
	BSR.W	PLSTCheckNum
	BRA.W	RedrawPLST

df0text:	dc.b	'DF0:',0,0
df1text:	dc.b	'DF1:',0,0
df2text:	dc.b	'DF2:',0,0
		EVEN

CheckPLSTGadgs:
	MOVEM.W (MouseX2),D0/D1
	LEA	PLSTGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.W	cplstend
	CMP.W	#01,D2
	BEQ.W	ExitPLST
	CMP.W	#02,D2
	beq.w	xScreenSwitch
	CMP.W	#03,D2
	BEQ.W	PLSTpressed				;listview hit
	CMP.W	#04,D2
	BEQ.W	ExitPLST
	CMP.W	#05,D2
	BEQ.W	ClearAllDisks
	CMP.W	#06,D2
	BEQ.W	MountList
	CMP.W	#07,D2
	BEQ.W	TypeInDisk3
	CMP.W	#08,D2
	BEQ.W	TypeInDisk2
	CMP.W	#09,D2
	BEQ.W	TypeInDisk1

	CMP.W	#$0A,D2
	BEQ.W	PLSTOneUp
	CMP.W	#$0B,D2
	BEQ.W	PLSTOneDown
	CMP.W	#$0C,D2
	BEQ.W	PLSTTop			;PLSTTop
	CMP.W	#$0D,D2
	BEQ.W	PLSTBottom	 	;PLSTBottom
	CMP.W	#$0E,D2
	BEQ.W	PLSTPropScroller


	;cmp.w	#$0F,D2			;01
	;beq.w	CheckPEDnames
	cmp.w	#$11,D2			;03
	beq.w	PED_DeleteDisk
	cmp.w	#$12,D2			;04
	beq.w	PED_Delete
	cmp.w	#$13,D2			;05
	beq.w	PED_AddPathGadg
	cmp.w	#$15,d2			;07
	beq.w	PED_ClearPLST
	cmp.w	#$16,d2			;08
	beq.w	PED_EnterPath
	cmp.w	#$17,d2			;09
	beq.w	PED_Print
	cmp.w	#$18,d2			;0A
	beq.w	WritePLST
	cmp.w	#$19,d2  		;0B
	beq.w	LoadPLST
	;cmp.w	#$1A,d2			;0C
	;beq.w	PED_OneUp
	;cmp.w	#$1B,d2			;0D
	;beq.w	PED_OneDown
	;cmp.w	#$1C,d2			;0E
	;beq.w 	PED_Top
	;cmp.w	#$1D,d2			;0F
	;beq.w	PED_Bottom
	cmp.w	#$1E,d2			;12
	beq.w	PED_Disk
cplstend:
	CALL	ChkMainright
	RTS

ExitPLST:
	CLR.W	PProp_X
	MOVE.W	#$53,PProp_Y
	MOVE.B	#$F8,EmptySprite+1

	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3
	CMP.W	#$FFFF,scrtablecl
	BEQ.S	dpmain

	MOVEM.L D0-D3/A0,-(SP)
	CALL	ClrWhiteLines
	MOVEM.L (SP)+,D0-D3/A0
	MOVE.W	#$FFFF,scrtablecl
	MOVE.W	#$FFFF,DirCopFlag

dpmain:
	MOVE.W	#1,CurrScreen
	CALL	WaitForButtonUp
	CLR.B	RawKeyCode
	BSR.W	SwapPLSTScreen
	CALL	Clear120Lines
	GOTO	DisplayMainAll

PLSTOneUp:
	TST	PresetMarkTotal
	BNE.S	PLSTOneUp2
	RTS
PLSTOneUp2:
	CALL	Wait_4000
	BSR.W	rd_updplstlist
	MOVE	PLSTpos,D0
	MOVE	D0,D2
	SUBQ	#1,D0
	TST.B	ShiftKeyStatus
	BNE.S	pouski2
	checkrmb
	BNE.S	pouskip

pouski2:
	SUB	#9+5+3,D0

pouskip:
	TST	D0
	BPL.S	DoPLSTUpDown
	CLR	D0
	BRA.S	DoPLSTUpDown

PLSTOneDown:
	TST	PresetMarkTotal
	BNE.S	PLSTOneDown2
		RTS

PLSTOneDown2:
	CALL	Wait_4000
	BSR.W	rd_updplstlist
	MOVE	PLSTpos(PC),D0
	MOVE	D0,D2
	ADDQ	#1,D0
	TST.B	ShiftKeyStatus
	BNE.S	podski2
	checkrmb
	BNE.S	podskip

podski2:
	ADD	#9+5+3,D0

podskip:
	MOVE	PresetMarkTotal(PC),D1
	SUB	#12+5+3,D1
	CMP	D0,D1
	BHS.S	DoPLSTUpDown
	MOVE	D1,D0

DoPLSTUpDown:
	BSR.S	UpdateOffset
	BRA.W	RedrawPLST

PLSTTop:
	TST	PresetMarkTotal
	BNE.S	PLSTTop2
		RTS
PLSTTop2:
	MOVE	#1,PLSTpos
	BRA.W	PLSTOneUp2

PLSTBottom:
	TST	PresetMarkTotal
	BNE.S	PLSTBottom2
	RTS

PLSTBottom2:
	MOVE	PresetMarkTotal,PLSTpos
	SUBQ	#1,PLSTpos
	BRA.B	PLSTOneDown2
	BRA.W	RedrawPLST

UpdateOffset:
	MOVE	PLSTpos(PC),D1
	MOVE	D0,PLSTpos
	CMP	D0,D1
	BNE.S	UpdateOffset2
	RTS

UpdateOffset2:
	TST.W	D0
	BEQ.S	ZeroPLSTOffset
	SUBQ	#1,D0
	MOVE.L	PLSTmem(PC),A0
	MOVEQ	#0,D6

cpoloop:
	CMP	#'ST',(A0,D6.L) 			;check for 'ST'
	BEQ.S	NextPLSTOffset
	ADD.L	#30,D6
	BRA.B	cpoloop

NextPLSTOffset:
	ADD.L	#30,D6
	DBRA	D0,cpoloop
	MOVE.L	D6,PLSTOffset
	RTS

ZeroPLSTOffset:
	CLR.L	PLSTOffset
	RTS

PLSTpressed:

	;SUB	#24,D1					;mousecoordinate
	subq.l	#4,d1					;4.0
	AND.L	#$0000FFFF,D1
	DIVU	#6,D1
	LSL	#2,D1
	LEA	PLSTOffset(PC),A0
	MOVE.L	(A0,D1.W),D1
	BPL.B	PLSTpressed4
	RTS

PLSTpressed4:
	DIVU	#30,D1
	ADDQ	#1,D1
	MOVE.W	D1,CurrentPreset
	CALL	WaitForButtonUp
	GOTO	UsePreset				;fix


;------- PLST propscroller -------

PProp_X:	dc.w	0
PProp_Y:	dc.w	0
PCount:		dc.w	0

;PLSTpos=max scroll

PLSTPropScroller:

	move.w	PresetMarkTotal,PCount			;Anzahl Eintrge in PCount
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	MouseY,D1
	MOVE.W	PProp_X,D0
	ADD.W	#$0018,D0
	SUB.W	D0,D1
	BMI.W	ppropsc_sub
	CMP.W	PProp_Y,D1
	BPL.W	ppropsc_add
	MOVE.W	D1,D2
	MOVE.W	#$0053,D4
	SUB.W	PProp_Y,D4
	BSR.W	ppropsc10
	MOVE.W	MouseY,D1
ppropsc3:
	CALL	ResetKeyTimer				;org bsr 3.62
	BTST	#6,$00BFE001
	BNE.S	ppropsc6
	MOVE.W	D1,D3
	MOVE.W	MouseY,D1
	CMP.W	D1,D3
	BEQ.S	ppropsc3
	SUB.W	D2,D1
	SUB.W	#$0018,D1
	BPL.S	ppropsc4
	MOVEQ	#0,D1
ppropsc4:
	CMP.W	D4,D1
	BMI.S	ppropsc5
	MOVE.W	D4,D1
ppropsc5:
	MOVE.W	D1,PProp_X
	BSR.W	PressedPLSTScrollbar
	MOVEM.L D0-D7/A0-A6,-(SP)
	;MOVE.L	DirMousetable,A5
	MOVE.W	PCount,D0
	SUB.W	#$0013,D0
	MULU	PProp_X,D0
	MOVE.W	#$0053,D1
	SUB.W	PProp_Y,D1
	DIVU	D1,D0
	MOVE.W	D0,PLSTpos


	BSR.W	UpdateOffset2
	BSR.W	RedrawPLST


	MOVEM.L (SP)+,D0-D7/A0-A6
	BTST	#6,$00BFE001
	BEQ.B	ppropsc3
ppropsc6:
	BSR.W	UnPressedPLSTScrollbar
	;CLR.W	DirCopFlag
	RTS

ppropsc_sub:
	SUB.W	#$0013,PLSTpos
	BPL.S	ppropsc8
	;CLR.W	PLSTpos
	move.w	#1,PLSTpos
ppropsc8:
	BSR.W	rd_updplstlist
	MOVE.W	PLSTpos,D0

	BSR.W	UpdateOffset2
	BSR.W	RedrawPLST
	RTS

ppropsc_add:
	ADD.W	#$0013,PLSTpos
	MOVE.W	PCount,D0
	SUB.W	#$0013,D0
	CMP.W	PLSTpos,D0
	BPL.S	ppropsc9
	MOVE.W	D0,PLSTpos
ppropsc9:
	BSR.W	rd_updplstlist
	MOVE.W	PLSTpos,D0

	BSR.W	UpdateOffset2
	BSR.W	RedrawPLST

	;CLR.W	DirCopFlag
	RTS

PressedPLSTScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	PProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0				;x-pos sprite
	MOVE.W	PProp_Y,D2
	LEA	EmptySprite,A0
	CALL	SetSpritePos
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

UnPressedPLSTScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	PProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0				;x-pos sprite
	MOVE.W	PProp_Y,D2
	CALL	UpdscrollSprite1
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

ppropsc10:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	PProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0				;x-pos sprite
	MOVE.W	PProp_Y,D2
	CALL	UpdscrollSprite2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

rd_updplstlist:
	move.w	PresetMarkTotal,PCount

	MOVEM.L D0-D3,-(SP)
	MOVEQ	#0,D3
	MOVE.W	#$0053,PProp_Y
	CLR.W	PProp_X
	;MOVE.L	DirMousetable,A5
	MOVEQ	#$53,D0
	MOVE.W	#0,D1
	CMP.W	#$0013,PCount
	BMI.S	ppropsc14
	BEQ.S	ppropsc14
	MOVE.W	#$0629,D0
	MOVE.W	PCount,D1
	EXT.L	D0
	DIVU	D1,D0
	MOVE.W	D0,PProp_Y
	MOVE.W	PLSTpos,D1
	MOVE.W	PCount,D2
	MOVE.W	#$0053,D3
	SUB.W	D0,D3
	MULU	D1,D3
	SUB.W	#$0013,D2
	DIVU	D2,D3
	MOVE.W	D3,PProp_X
ppropsc14:
	MOVE.W	PProp_X(PC),D3
	ADD.W	PProp_Y(PC),D3
	CMP.W	#$0053,D3
	BMI.S	ppropsc15
	MOVEQ	#$53,D3
ppropsc15:
	SUB.W	PProp_Y(PC),D3
	MOVE.W	D3,PProp_X
	BSR.W	UnPressedPLSTScrollbar
	MOVEM.L (SP)+,D0-D3
	RTS


;------ preseteditor parts --------

PED_AddPathGadg:
	TST.L	PLSTmem
	BNE.B	pedawok
	BSR.W	AllocPLST
	TST.L	PLSTmem
	BEQ.W	cloplst
pedawok:
	MOVE.L	DOSBase,A6
	MOVE.L	#PEdDefaultPath,D1
	MOVEQ	#-2,D2
	CALLSYS	Lock
	MOVE.L	D0,FileLock
	BEQ.W	UnlockReadPath
	CALL	SetDiskPtrCol
	LEA	AddingPathText(PC),A0
	BSR.W	ShowStatusText
	MOVE.L	DOSBase,A6
	MOVE.L	FileLock(PC),D1
	MOVE.L	#FileInfoBlock,D2		; struct of name, size, date (longword)
	CALLSYS	Examine				; examine locked dir or file
	TST.L	D0				; fail ?
	BPL.W	UnlockReadPath
	TST.L	FIB_EntryType
	BPL.B	CheckPathDirName
	BSR.W	AddPreset
	BRA.S	IsPLSTFull

CheckPathDirName:
	CMP.B	#'-',FIB_FileName+2
	BNE.S	IsPLSTFull
	MOVE.B	FIB_FileName+3,SndDiskNum0
	MOVE.B	FIB_FileName+4,SndDiskNum1
	BSR.W	ShowPEDnumbers
IsPLSTFull:
	MOVE	PresetTotal(PC),D0
	CMP	MaxPLSTEntries,D0
	BCS.S	ReadPathNext
	BSR.W	PLSTisFull
	BRA.W	ReadPathEnd

ReadPathNext:
	MOVE.L	DOSBase,A6
	MOVE.L	FileLock(PC),D1
	MOVE.L	#FileInfoBlock,D2
	CALLSYS	ExNext					;Examine next entry in a dir
	TST.L	D0					;0=end of dir entries
	BPL.W	ReadPathEnd

	checkrmb
	BEQ.W	ReadPathEnd
	TST.L	FIB_EntryType
	BPL.B	IsPLSTFull
	CMP.L	#'.inf',FIB_FileName
	BEQ.B	IsPLSTFull
	CMP.L	#'.inf',FIB_FileName+4
	BEQ.B	IsPLSTFull
	LEA	FIB_FileName,A0
	MOVEQ	#$1C,D0

ckcou:	CMP.B	#$2E,(A0)+
	BEQ.W	CouldBeInfo
	DBRA	D0,ckcou

rpnskip:
	CLR	PresetRepeat
	MOVE	#1,PresetReplen
	LEA	PEdDefaultPath,A0			;get pointer to samples
	CALL	CopyPath
	LEA	FIB_FileName,A0

;--------- raw test ok, now check for IFF
rpncpfn:
	MOVE.B	(A0)+,(A1)+
	BNE.B	rpncpfn
	MOVE.L	#FileName,D1
	MOVE.L	#$000003ED,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.B	rpnskp2
	MOVE.L	D0,D1
	LEA	chkiffbuffer(PC),A2
	CLR.L	(A2)
	MOVE.L	A2,D2
	MOVEQ	#12,D3
	CALLSYS	Read
	CMP.L	#'FORM',(A2)
	BNE.B	rpnclse
	CMP.L	#'8SVX',8(A2)
	BNE.B	rpnclse
rpnvhdr:
	MOVE.L	FileHandle(PC),D1
	MOVE.L	A2,D2
	MOVEQ	#4,D3
	CALLSYS	Read
	TST.L	D0
	BEQ.B	rpnclse 				;read error
	CMP.L	#'VHDR',(A2)
	BNE.B	rpnvhdr
	MOVE.L	FileHandle(PC),D1
	MOVE.L	A2,D2
	MOVEQ	#12,D3
	CALLSYS	Read
	MOVE.L	8(A2),D0
	BEQ.B	rpnclse
	LSR.L	#1,D0
	MOVE.W	D0,PresetReplen
	MOVE.L	4(A2),D0
	LSR.L	#1,D0
	MOVE.W	D0,PresetRepeat
rpnclse:
	MOVE.L	FileHandle(PC),D1
	CALLSYS	Close


;-- both used, for IFF AND RAW ----
rpnskp2:
	BSR.S	AddPreset
	BSR.W	ShowPEDnumbers			;refresh preset numbers
	BSR.W	PLST_Refresh2			;4.0
	BRA.W	IsPLSTFull

CouldBeInfo:
	CMP.B	#$69,(A0)+
	BNE.W	rpnskip
	CMP.B	#$6E,(A0)+
	BNE.W	rpnskip
	CMP.B	#$66,(A0)+
	BNE.W	rpnskip
	CMP.B	#$6F,(A0)+
	BNE.W	rpnskip
	CMP.B	#0,(A0)+
	BNE.W	rpnskip
	BRA.W	IsPLSTFull

ReadPathEnd:
	MOVE.L	DOSBase,A6
	MOVE.L	FileLock(PC),D1
	BEQ.S	rpeskip
	CALLSYS	UnLock
rpeskip:
	CALL	SetNormalPtrCol
	BSR.W	ShowPresetNames
	BRA.W	ShowAllRight

UnlockReadPath:
	MOVE.L	DOSBase,A6
	MOVE.L	FileLock(PC),D1
	BEQ.B	urpend
	CALLSYS	UnLock

urpend: GOTO	SetErrorPtrCol

;********************************

AddPreset:
	LEA	PedDefaultVol(PC),A0
	LEA	PresetName(PC),A1
	MOVEQ	#21,D0				;#5
clearme:
	CLR.B	(A1)+
	DBRA	D0,clearme
	LEA	PresetName(PC),A1
	MOVEQ	#5,D0				;disk ST-XX

loopos:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,loopos
	LEA	FIB_FileName,A0
	MOVEQ	#14,D0				;name 16 chars

aploop2:
	MOVE.B	(A0)+,D1
	BEQ.S	aploop3
	MOVE.B	D1,(A1)+
	DBRA	D0,aploop2

aploop3:
	CLR.B	(A1)
	MOVE.L	FIB_FileSize,D0
	CMP.L	#MaxSamLen,D0
	BLS.S	apskip2
	MOVE.L	#MaxSamLen,D0

apskip2:
	LSR	#1,D0				;getme
	MOVE	D0,PresetLength
	CLR	PresetFineTune
	LEA	PresetName(PC),A6
	BSR.B	PED_CheckAdd			;check if real
	ADDQ	#1,PresetTotal
	ADD.L	#30,MaxPLSTOffset
	RTS

;********************************
;* check an added preset        *
;********************************

PED_CheckAdd:					;23 length
	MOVEQ	#$17,D0 			;max length of sample name in PED list
pedcaloop:
	SUBQ.W	#1,D0				;-1
	CMP.B	#' ',0(A6,D0.W) 		;space ?
	BEQ.B	pedcaloop			;yep, one back
	CLR.B	1(A6,D0.W)
	MOVE.L	PLSTmem(PC),A5
	SUB	#30,A5				;fix
	LEA	30(A5),A5
pedccnextloop:
	MOVEQ	#6,D0
	TST.B	6(A5)
	BEQ.S	PED_AddPreset
PED_ConvertLoop:
	MOVE.B	(A5,D0.W),D2
	BNE.S	PED_ConvertCase
	TST.B	(A6,D0.W)
	BNE.S	PED_ConvertCase
	CLR.B	6(A5)
	SUBQ	#1,PresetTotal
	BRA.S	PED_AddPreset

PED_ConvertCase:
	CMP.B	#'A',D2
	BCS.S	pedccskip
	CMP.B	#'Z',D2
	BHI.S	pedccskip
	ADD.B	#32,D2
pedccskip:
	MOVE.B	0(A6,D0.W),D1
	;CMP.B	#' ',D1
	;BEQ.S	pedccskip3
	CMP.B	#'A',D1
	BCS.S	pedccskip2
	CMP.B	#'Z',D1
	BHI.S	pedccskip2
	ADD.B	#32,D1
pedccskip2:
	CMP.B	D2,D1
	BEQ.S	pedccnext
	BHI.S	pedccskip3
	BRA.S	PED_AddPreset

pedccnext:
	ADDQ	#1,D0
	CMP.W	#$0016,D0
	BNE.B	PED_ConvertLoop
pedccskip3:
	LEA	30(A5),A5
	BRA.B	pedccnextloop

PED_AddPreset:
	TST.B	6(A5)				;file already in PLST?
	BEQ.S	pedapskip			;yep, skip it
	MOVE.L	PLSTmem(PC),A1
	SUB	#30,A1				;fix!
	MOVE	PresetTotal(PC),D0
	BEQ.S	pedapskip
	MULU	#30,D0
	ADD.L	D0,A1
	LEA	30(A1),A1
	CLR.B	31(A1)
pedaploop:
	MOVE	(A1),30(A1)
	SUBQ.L	#2,A1
	CMP.L	A1,A5
	BLS.B	pedaploop
pedapskip:
	MOVEQ	#21,D0
pedaploop2:
	MOVE.B	(A6,D0.W),D1
	ADD.B	#32,D1				;fix
	CMP.B	#'A',D1
	BCS.S	pedapskip2
	CMP.B	#'Z',D1
	;BHI	pedapskip2
	;ADD.B	#32,D1				;fix
pedapskip2:
	SUB.B	#32,D1				;fix
	;CMP.B	#' ',D1 			;space?
	;BNE.S	pedapskip3
	CMP.B	#$00,D1 			;fix
	BNE.S	pedapskip3			;fix
	MOVEQ	#0,D1
pedapskip3:
	MOVE.B	D1,(A5,D0.W)
	DBRA	D0,pedaploop2
	MOVE.W	PresetLength(PC),$0016(A5)
	MOVE.B	PresetFineTune+1(PC),$0018(A5)
	MOVE.B	#$40,$0019(A5)
	MOVE.W	PresetRepeat(PC),$001A(A5)
	MOVE.W	PresetReplen(PC),$001C(A5)
	RTS
;********************************

HexToInteger:
	MOVEQ	#0,D0
	BSR.S	Single_hti
	LSL	#8,D1
	LSL	#4,D1
	OR	D1,D0
	BSR.S	Single_hti
	LSL	#8,D1
	OR	D1,D0

HexToInteger2:
	BSR.S	Single_hti
	LSL	#4,D1
	OR	D1,D0
	BSR.S	Single_hti
	OR	D1,D0
	RTS

Single_hti:
	MOVEQ	#0,D1
	MOVE.B	(A0)+,D1
	CMP.B	#$60,D1
	BCS.S	shtiskip
	SUB.B	#$20,D1

shtiskip:
	SUB.B	#$30,D1
	CMP.B	#9,D1
	BLS.S	reet
	SUBQ.B	#7,D1
reet:	RTS

;********************************
PED_Delete:
	CALL	SetDeletePtrCol
	MOVE.W	#1,PED_Action
	LEA	SelectEntryText(PC),A0
	BRA.W	ShowStatusText

PED_ClearPLST:
	LEA	ClearPLSTText,A0
	CALL	AreYouSure
	BEQ.B	PED_ClearPLST2
	RTS

PED_ClearPLST2:
	BSR.W	FreePLST
	BRA.W	PLST_Refresh				;4.0


chkiffbuffer:	dc.l	0,0,0				;12 Bytes used
ClearPLSTText:	dc.b	10,10,10,'    Clear the PLST?',0
		EVEN

;********************************
PED_Print:
	LEA	PrintPLSTText,A0
	CALL	AreYouSure
	BEQ.B	PED_Print2
	RTS

PED_Print2:
	CALL	StorePtrCol
	MOVE.L	DOSBase,A6
	MOVE.L	#PrintSongPath,D1
	MOVE.L	#$000003EE,D2
	CALLSYS	Open
	MOVE.L	D0,FileHandle
	BEQ.W	CantOpenFile
	CALL	SetDiskPtrCol
	MOVE.L	D0,D1
	MOVE.L	#PsetPLSTtext,D2
	MOVEQ	#$38,D3
	CALLSYS	Write
	LEA	PrintingPLSTText(PC),A0
	BSR.W	ShowStatusText
	CLR.W	PsetNumTemp

pedpmainloop:
	MOVE.W	PsetNumTemp(PC),D0
	LEA	PsetPrtNumText(PC),A0
	BSR.W	IntToDecASCII		; 2 jumps
	MOVE.L	PLSTmem(PC),A0
	SUB	#30,A0			; fix
	MOVE.W	PsetNumTemp(PC),D0
	MULU.W	#30,D0
	ADD.L	D0,A0
	MOVE.L	A0,PsetPtrTemp
	LEA	PsetPrtNameText(PC),A1
	MOVE.L	A1,A2
	MOVEQ	#$13,D1
FillSpaceLoop:
	MOVE.B	#' ',(A2)+
	DBRA	D1,FillSpaceLoop
	MOVEQ	#$13,D1
pedploop:
	TST.B	(A0)
	BEQ.B	pedpskip
	MOVE.B	(A0)+,(A1)+
	DBRA	D1,pedploop
pedpskip:
	MOVE.L	PsetPtrTemp(PC),A1
	MOVE.W	$0016(A1),D0
	LEA	PsetPrtLenText(PC),A0
	BSR.W	IntToHexASCII
	MOVE.L	PsetPtrTemp(PC),A1
	MOVE.W	$001A(A1),D0
	LEA	PsetPrtRepeatText(PC),A0
	BSR.W	IntToHexASCII
	MOVE.L	PsetPtrTemp(PC),A1
	MOVE.W	$001C(A1),D0
	ADD.W	D0,D0
	LEA	PsetPrtRepLenText(PC),A0
	BSR.B	IntToHexASCII
	MOVE.L	FileHandle(PC),D1
	MOVE.L	#PsetPrtNumText,D2
	MOVEQ	#$35,D3
	CALLSYS	Write
	checkrmb
	BEQ.B	AbortPLSTPrint
	ADDQ.W	#1,PsetNumTemp
	MOVE.W	PsetNumTemp(PC),D0
	CMP.W	PresetTotal(PC),D0
	BNE.W	pedpmainloop
	BRA.B	pedpend

AbortPLSTPrint:
	LEA	OprAbortedText(PC),A0
	BSR.W	ShowStatusText
	CALL	SetErrorPtrCol
pedpend:
	MOVE.L	FileHandle(PC),D1
	CALLSYS	Close
	BSR.W	ShowAllRight
	GOTO	RestorePtrCol

IntToDecASCII:
	MOVEQ	#3,D3
	MOVE.L	#$000003E8,D2
itdloop:
	EXT.L	D0
	DIVU.W	D2,D0
	ADD.B	#$30,D0
	MOVE.B	D0,(A0)+
	DIVU.W	#10,D2
	SWAP	D0
	DBRA	D3,itdloop
	RTS

IntToHex2:
	MOVEQ	#1,D2
	BRA.B	ithaloop

IntToHexASCII:
	MOVEQ	#3,D2
ithaloop:
	MOVE.W	D0,D1
	AND.B	#15,D1
	CMP.B	#10,D1
	BCS.B	ithaskip
	ADDQ.B	#7,D1
ithaskip:
	ADD.B	#'0',D1
	MOVE.B	D1,-(A0)
	ROR.W	#4,D0
	DBRA	D2,ithaloop
	RTS
;********************************

WritePLST:
	LEA	SavePLSTText,A0
	CALL	AreYouSure
	BEQ.B	WritePLST2
	RTS

WritePLST2:
	CALL	StorePtrCol
	CALL	SetDiskPtrCol
	LEA	SavingPLSTText(PC),A0
	BSR.W	ShowStatusText
	LEA	PTPath,A0
	CALL	CopyPath
	LEA	PLSTName(PC),A0
	MOVEQ	#4,D0
dsploop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dsploop
	MOVE.L	#FileName,D1
	MOVE.L	#$000003EE,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,D7
	BEQ.W	CantOpenFile
	MOVE.L	D0,D1
	MOVE.L	PLSTmem(PC),D2
	MOVE.W	PresetTotal(PC),D3
	MULU.W	#$001E,D3
	CALLSYS	Write
	MOVE.L	D7,D1
	CALLSYS	Close
	BSR.W	ShowAllRight
	GOTO	RestorePtrCol

ShowPresetNames:
	rts

PED_EnterPath:
	MOVE	#$12,D1
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	CLR.L	EditMode
	LEA	PEdDefaultPath,A6		;old 6
	CALL	UpdateLineCurPos
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADD.L	#31,TextEndPtr
	MOVE.W	#20,TextLength

	MOVE.L	#178*2-17+320+320+320+320+320+160,A4	;fix x-position entertext

	CALL	GetTextLine
	CLR.L	TextEndPtr
	GOTO	RestorePtrCol

PED_Disk:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	CLR.L	EditMode
	CLR.B	SndDiskNum0
	CLR.B	SndDiskNum1
	LEA	SndDiskNum0(PC),A6
	MOVE.L	A6,TextEndPtr
	MOVE.L	A6,ShowTextPtr
	ADDQ.L	#2,TextEndPtr
	MOVE.W	#2,TextLength
	MOVE.L 	#$000004C5+320+320+320+320+320+160,A4
	MOVE.B	#3,EnterTextFlag
	CALL	GetTextLine
	LEA	SndDiskNum0(PC),A6
	MOVE.B	#':',2(A6)
	CLR.B	EnterTextFlag
	CLR.L	TextEndPtr
	CALL	RestorePtrCol
	BRA.W	PLST_Refresh	;4.0

ShowPEDnumbers:
	MOVE.W	PresetTotal,WordNumber
	MOVE.W	#$0835+320+320+160+320+320+320,TextOffset
	BSR.W	Print4DecDigits 			;preset numbers
	LEA	PEdDefaultPath,A0			;PEdDefaultPath
	MOVE.W	#$0835-2,D1				;152
	MOVEQ	#$14,D0
	BSR.W	ShowText3				;default path

	LEA	PedDefaultVol,A0
	MOVE.W	#$04C2+320+320+320+320+320+160,D1
	MOVEQ	#6,D0
	BRA.W	ShowText3
	RTS

PLSTisFull:
	LEA	PLSTFullText(PC),A0
	BSR.W	ShowStatusText
	GOTO	SetErrorPtrCol

PED_DeleteDisk:
	LEA	DelDiskText(PC),A0
	MOVE.B	SndDiskNum0(PC),10(A0)
	MOVE.B	SndDiskNum1(PC),11(A0)
	CALL	AreYouSure
	BEQ.B	PED_DelDD2
	RTS

PED_DelDD2:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	PLSTmem(PC),A0
	MOVE.L	A0,A1
	MOVE.W	PresetTotal(PC),D0
	MULU.W	#$001E,D0
	ADD.L	D0,A1
	MOVE.L	SndDiskNum0-1(PC),D1
	MOVE.L	#$FF5F5FFF,D2
	AND.L	D2,D1
peddslo:
	MOVE.L	2(A0),D0
	AND.L	D2,D0
	CMP.L	D1,D0
	BNE.B	peddsno
	MOVE.L	A0,A2
peddslp:
	MOVE.W	$001E(A0),(A0)+
	CMP.L	A1,A0
	BCS.B	peddslp
	SUBQ.W	#1,PresetTotal
	SUB.L	#30,MaxPLSTOffset
	MOVE.L	A2,A0
	BRA.B	peddsn1

peddsno:
	LEA	30(A0),A0
peddsn1:
	CMP.L	A1,A0
	BCS.B	peddslo
	MOVE.W	#1,PEDPos
	BSR.W	ShowPEDnumbers
	BSR.W	ShowPresetNames
	CALL	RestorePtrCol
	BRA.W	PLST_Refresh			; 4.0

DelDiskText:
	dc.b	'Delete ST-.. ?',0
	EVEN

;***********************************
;* PLST list loading /allocating   *
;***********************************

LoadPLST:
	LEA	LoadPLSTText,A0
	CALL	AreYouSure
	BEQ.S	trt15
	RTS

trt15:	CALL	WaitForButtonUp
	LEA	LoadingPLSTText(PC),A0
	BSR.W	ShowStatusText

DoLoadPLST:
	CALL	StorePtrCol
	LEA	PTPath,A0
	CALL	CopyPath
	LEA	PLSTName(PC),A0
	MOVEQ	#4,D0
dlploop:
	MOVE.B	(A0)+,(A1)+
	DBRA	D0,dlploop
	MOVE.L	#FileName,D1
	MOVE.L	#$000003ED,D2
	MOVE.L	DOSBase,A6
	CALLSYS	Open
	MOVE.L	D0,D7
	BEQ.B	PLSTOpenErr
	CALL	SetDiskPtrCol
	CLR.L	PresetTotal
	BSR.B	AllocPLST
	MOVE.L	PLSTmem(PC),D2
	BEQ.B	cloplst
	MOVE.L	D7,D1
	MOVE.L	PLSTAllocSize,D3
	MOVE.L	DOSBase,A6
	CALLSYS	Read
	MOVE.L	D0,MaxPLSTOffset	;filelen in offset
	DIVU	#30,D0			;/ 1 sample entry
	MOVE	D0,PresetTotal		;= anzahl presets
cloplst:
	MOVE.L	D7,D1
	MOVE.L	DOSBase,A6
	CALLSYS	Close
PLSTOpenErr:
	BSR.W	PLSTCheckNum
	BSR.W	ShowAllRight
	CALL	RestorePtrCol
	cmp.w	#6,CurrScreen
	bne.s	noplstsc
	BSR.W	ShowPresetNames
	BRA.W	PLST_Refresh
noplstsc:
	RTS

PTPath: 	dc.b	'S:',0,0
PLSTName:	dc.b	'PLST',0
		EVEN

*********************************
AllocPLST:
	BSR.B	FreePLST
	MOVE.W	MaxPLSTEntries,D0
	BNE.S	.doit
	RTS

.doit:
	MULU.W	#30,D0
	MOVE.L	D0,PLSTAllocSize
	MOVE.L	#$00010000,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,PLSTmem
	MOVE.W	MaxPLSTEntries,MaxPLSTEntries2
	RTS

FreePLST:
	CLR.W	MaxPLSTEntries2
	CLR.L	MaxPLSTOffset
	CLR.W	PresetTotal
	MOVE.L	PLSTmem,D0
	BNE.S	.doit
	RTS
.doit:
	MOVE.L	D0,A1
	MOVE.L	PLSTAllocSize,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	PLSTmem
	RTS

;***********************************
;* The protracker sample editor    *
;***********************************

SamplerScreen:
	CALL	WaitForButtonUp
	CALL	ReBlitTrack			; save D0-D3 in MarkReadyFlag
	TST.W	SamScrEnable
	BNE.S	ExitFromSam
	MOVE.W	#1,SamScrEnable
	CLR.B	ScrollerSprite2+1		; scroller sprite
	MOVE.L	EditMode(PC),SaveEditMode
	CLR.L	EditMode

	MOVEQ	#0,D0
	MOVE.W	#270,D1
	MOVEQ	#14,D2
	MOVE.L	CspritePtr,A0
	BSR.W	SetSpritePos
	CALL	SetSamSpritePtrs
	MOVE.W	CopCol4,cpl2ptr1		; copcol+16,CopList2+18
	BSR.W	SwapSamScreen
	BNE.S	exisam2
	BSR.W	ClearSamScr
	CALL	Show_MS
	BSR.W	saedpl4
	CALL	DoShowFreeMem
	BSR.W	ShowSamNote
	BSR.W	ShowResamNote
	BRA.W	RedrawSample

ExitFromSam:
	CALL	WaitForButtonUp
	BSR.W	ClearSamScr
	CLR.W	SamScrEnable
	BSR.B	SwapSamScreen

exisam2:
	BTST	#0,VUSpriteMode
	BEQ.S	.l0
	CALL	SetDefSpritePtrs_L		;re-init vumetersprites (fine) pos
	BRA.S	.l1

.l0:	CALL	SetDefSpritePtrs_B		;re-init vumetersprites (bold) pos
.l1:	CLR.B	RawKeyCode
	MOVE.B	#$DA,ScrollerSprite2		;enable Scroller
	MOVEQ	#-1,D0
	MOVE.L	D0,MarkStartOfs
	MOVE.L	SaveEditMode(PC),EditMode

gagame:
	CALL	SetScreenColors
	CALL	mt_setupvucols
	CALL	SetScrPatternPos
	CALL	Show_MS
	BSR.B	saedpl4
	CALL	UpdateCursorPos
	CALL	SetTempo
	MOVE.W	#1,NewChannels
	CALL	ShowTracks			;FOR VISIBLE AT START
	BRA.W	RedrawPattern

SwapSamScreen:
	TST.W	SamScrEnable
	BEQ.S	swaptotrack

	lea	SampScreenData,a0
	CALL	LowerDecrunch
	RTS

swaptotrack:
	chn8test
	bne.s	.chn4

	MOVE.L	#Channels8,A0
	CALL	LowerDecrunch
	rts
.chn4:
	MOVE.L	#Channels4,A0
	CALL	LowerDecrunch
	rts

**************************************

ClearSamScr:
	LEA	CopListInsPos,A0
	LEA	Coplist2,A1

saedpl3:
	MOVE.W	(A0),D0
	MOVE.W	(A1),(A0)+
	MOVE.W	D0,(A1)+
	CMP.L	#cpl2ptr2,A1
	BMI.S	saedpl3
	MOVEQ	#-1,D0
	RTS

saedpl4:
	MOVE.W	#$0923,D0
	MOVE.L	TextBplPtr,A0
	LEA	$2B70(A0),A0
	MOVE.L	A0,LineScreen
	MOVEQ	#0,D1

.loo:
	MOVE.L	D1,(A0)+
	DBRA	D0,.loo
	RTS
***************************************
ClearSamArea:
	MOVE.W	#$04FF,D0
	MOVE.L	TextBplPtr,A0
	LEA	$2B70(A0),A0
	MOVE.L	A0,LineScreen
	MOVEQ	#0,D1

.loo:
	MOVE.L	D1,(A0)+
	DBRA	D0,.loo
	RTS

lbC013F2A:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.W	#$0280,D2
	MOVEQ	#$40,D3
	MOVEQ	#0,D5
	BRA.W	ClrWhoSamScr


;*******************************

CheckSamGadgets:
	MOVEM.W (MouseX2),D0/D1
	LEA	SamplerGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.W	chksamga_rt	;rts

	CMP.W	#1,D2
	BEQ.W	ExitFromSam
	CMP.W	#2,D2
	BEQ.W	SamplePressed
	CMP.W	#3,D2
	BEQ.W	SamDragBar
	CMP.W	#4,D2
	BEQ.W	PlayWaveForm
	CMP.W	#5,D2
	BEQ.W	ShowRange
	CMP.W	#6,D2
	BEQ.W	ZoomOut
	CMP.W	#7,D2
	BEQ.W	chksamga_rt	;rts
	CMP.W	#10,D2
	BEQ.W	StopPlaying
	CMP.W	#11,D2
	BEQ.W	PlayDisplay
	CMP.W	#12,D2
	BEQ.W	ShowAll
	CMP.W	#13,D2
	BEQ.W	RangeAll
	CMP.W	#14,D2
	BEQ.W	LoopToggle
	CMP.W	#$0010,D2
	BEQ.W	PlayRange
	CMP.W	#$11,D2
	BEQ.W	CurToStart
	CMP.W	#$12,D2
	BEQ.W	CurToMid
	CMP.W	#$13,D2
	BEQ.W	lbC014264
	CMP.W	#$14,D2
	BEQ.W	xSampler
	CMP.W	#$15,D2
	BEQ.W	SetSamNote
	CMP.W	#$17,D2
	BEQ.W	SamCut
	CMP.W	#$18,D2
	BEQ.W	SamCopy
	CMP.W	#$19,D2
	BEQ.W	SamPaste
	CMP.W	#$1A,D2
	BEQ.W	RampVolume
	CMP.W	#$1B,D2
	BEQ.W	xTuningTone
	CMP.W	#$1C,D2
	BEQ.W	Resample
	CMP.W	#$1D,D2
	BEQ.W	SetResamNote


	MOVE.L	mt_songdataptr(pc),A5
	LEA	-10(A5),A5
	MOVE.W	InsNum,D0
	BNE.S	ichksalp
	MOVE.W	LastInsNum,D0

ichksalp:
	MULU	#$001E,D0
	ADD.L	D0,A5
	CMP.W	#$0022,D2
	BEQ.W	lbC010B88
	CMP.W	#$23,D2
	BEQ.W	MaximizeSample
	CMP.W	#$24,D2
	BEQ.W	NormalizeSample
	CMP.W	#$25,D2
	BEQ.W	NormAllocSample
	CMP.W	#$26,D2
	BEQ.W	BackwardsSample
	CMP.W	#$27,D2
	BEQ.W	Boost
	CMP.W	#$28,D2
	BEQ.W	Filter
	CMP.W	#$29,D2
	BEQ.W	UpSamSample
	CMP.W	#$2A,D2
	BEQ.W	DownSamSample

chksamga_rt:
	RTS

;*******************************
PlayWaveForm:
	CALL	PlayNote
	GOTO	WaitForButtonUp

;*******************************
PlayDisplay:
	LEA	SampleInfo,A0
	MOVE.L	SamOffSet(PC),StartOfs
	MOVE.L	SamDisplay(PC),D0
	LSR.L	#1,D0
	MOVE.W	D0,(A0)
	CLR.W	4(A0)
	MOVE.W	#1,6(A0)
	MOVE.W	PlayInsNum,-(SP)
	CLR.W	PlayInsNum
	CALL	PlayNote
	MOVE.W	(SP)+,PlayInsNum

	BSR.W	ShowSampleInfo
	GOTO	WaitForButtonUp

;*******************************
PlayRange:
	MOVE.L	MarkStartOfs(PC),D1
	BMI.W	NoRangeError
	MOVE.L	MarkEndOfs(PC),D0
	CMP.L	D0,D1
	BEQ.W	LargerRangeError
	LEA	SampleInfo,A0
	MOVE.L	D1,StartOfs
	SUB.L	D1,D0
	LSR.L	#1,D0
	MOVE.W	D0,(A0)
	CLR.W	4(A0)
	MOVE.W	#1,6(A0)
	MOVE.W	PlayInsNum,-(SP)
	CLR.W	PlayInsNum
	CALL	PlayNote
	MOVE.W	(SP)+,PlayInsNum
	BSR.W	ShowSampleInfo
	GOTO	WaitForButtonUp

;*******************************
StopPlaying:
	;chn8test
	;bne.s	dstop4
	;CALL	s3end
dstop4:
	GOTO	TurnOffVoices

StartOfs:	dc.l	0

;*******************************
ShowRange:
	MOVE.L	MarkStartOfs(PC),D0
	BMI.W	NoRangeError
	MOVE.L	MarkEndOfs(PC),D1
	CMP.L	D1,D0
	BEQ.W	LargerRangeError
	SUB.L	D0,D1
	BNE.S	shorano
	MOVEQ	#1,D1
shorano:
	MOVE.L	D1,SamDisplay
	MOVE.L	D0,SamOffSet
	MOVEQ	#-1,D0
	MOVE.L	D0,MarkStartOfs
	CLR.W	MarkStart
	BSR.W	DisplaySample
	GOTO	WaitForButtonUp

ZoomOut:
	MOVE.L	SamDisplay(PC),D0
	MOVE.L	SamLength(PC),D1
	MOVE.L	SamOffSet(PC),D2
	MOVE.L	D0,D3
	LSL.L	#1,D3
	CMP.L	D1,D3
	BHI.S	ShowAll
	LSR.L	#1,D0
	CMP.L	D2,D0
	BCS.S	zzou_1
	MOVEQ	#0,D0
zzou_1:
	SUB.L	D0,D2
	MOVE.L	D2,D0
	ADD.L	D3,D0
	CMP.L	D1,D0
	BLS.S	zzou_2
	SUB.L	D3,D1
	MOVE.L	D1,D2
zzou_2:
	MOVE.L	D2,SamOffSet
	MOVE.L	D3,SamDisplay
	BSR.W	OffsetToMark
	MOVE.L	MarkStartOfs(PC),D0
	CMP.L	MarkEndOfs(PC),D0
	BNE.S	zzou_3
	MOVEQ	#-1,D0
	MOVE.L	D0,MarkStartOfs
zzou_3:
	BSR.W	DisplaySample
	GOTO	WaitForButtonUp

;*******************************

ShowAll:
	CLR.L	SamOffSet
	MOVE.L	SamLength(PC),SamDisplay
	BSR.W	OffsetToMark
	MOVE.L	MarkStartOfs(PC),D0
	CMP.L	MarkEndOfs(PC),D0
	BNE.S	lbC0141EA
	MOVEQ	#-1,D0
	MOVE.L	D0,MarkStartOfs
	CLR.W	MarkStart
lbC0141EA:
	BSR.W	DisplaySample
	GOTO	WaitForButtonUp

;*******************************

RangeAll:
	BSR.W	invertRange
	MOVE.W	#3,MarkStart
	MOVE.W	#636,MarkEnd
	BSR.W	MarkToOffset
ranall2:
	BSR.W	invertRange
	GOTO	WaitForButtonUp

CurToStart:
	BSR.W	invertRange
	MOVEQ	#3,D0
	MOVE.W	D0,MarkStart
	MOVE.W	D0,MarkEnd
	MOVE.L	SamOffSet(PC),D0
	MOVE.L	D0,MarkStartOfs
	MOVE.L	D0,MarkEndOfs
	BRA.S	ranall2

CurToMid:
	BSR.W	invertRange
	MOVE.W	#636,D0
	MOVE.W	D0,MarkStart
	MOVE.W	D0,MarkEnd
	MOVE.L	SamOffSet(PC),D0
	ADD.L	SamDisplay(PC),D0
	MOVE.L	D0,MarkStartOfs
	MOVE.L	D0,MarkEndOfs
	BRA.S	ranall2

lbC014264:
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	LSL.W	#2,D1
	LEA	mt_songdataptr(pc),A0
	LEA	0(A0,D1.W),A0
	MOVE.L	CopyBufPtr(PC),D0
	MOVE.L	(A0),CopyBufPtr
	MOVE.L	D0,(A0)
	MOVE.L	D0,A1
	CLR.W	(A1)

	MOVE.L	CopyBufSize(PC),D0
	MOVE.L	$007C(A0),CopyBufSize
	MOVE.L	D0,$007C(A0)

	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU	#30,D1
	LEA	12(A0,D1.W),A0
	LSR.L	#1,D0
	MOVE.W	D0,(A0)
	MOVE.L	RepBuf(PC),D0
	MOVE.L	4(A0),RepBuf
	MOVE.L	D0,4(A0)

	MOVE.W	RepBuf2(PC),D0
	MOVE.W	2(A0),RepBuf2
	TST.B	D0
	BNE.S	swabuf2
	MOVE.B	#$40,D0
swabuf2:
	MOVE	D0,2(A0)
	CALL	TurnOffVoices
	CALL	ValidateLoops
	BSR.W	ShowSampleInfo
	CALL	UpdateRepeats
	BSR.W	RedrawSample
	GOTO	WaitForButtonUp


NoRangeError:
	LEA	norangeselect.MSG(PC),A0

nres2:
	BSR.W	ShowStatusText
	GOTO	SetErrorPtrCol

LargerRangeError:
	LEA	setlargerrang.MSG(PC),A0
	BRA.S	nres2

SetCursorPos:
	LEA	setcursorpos.MSG(PC),A0
	BRA.S	nres2

BufferIsEmpty:
	LEA	bufferisempty.MSG(PC),A0
	BRA.S	nres2

EmptySampleError:
	LEA	sampleisempty.MSG(PC),A0
	BRA.S	nres2

NotSampleNull:
	LEA	Thisisnotsamp.MSG(PC),A0
	bra.s	nres2


RepBuf: 	dc.l	1
RepBuf2:	dc.w	$0040

norangeselect.MSG:	dc.b	'NO RANGE SELECTED',0
			EVEN
setlargerrang.MSG:	dc.b	'SET LARGER RANGE ',0
			EVEN
setcursorpos.MSG:	dc.b	'SET CURSOR POS ',0
			EVEN
bufferisempty.MSG:	dc.b	'BUFFER IS EMPTY',0
			EVEN
sampleisempty.MSG:	dc.b	'SAMPLE IS EMPTY',0
			EVEN
Thisisnotsamp.MSG:	dc.b	'THIS IS NOT SAMPLE 0!',0
			EVEN

;*********************************
LoopToggle:
	CALL	WaitForButtonUp
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	MOVE.L	mt_songdataptr(PC),A0
	MULU	#30,D1
	LEA	12(A0,D1.W),A0
	TST.W	LoopOnOffFlag
	BEQ.S	loopton
	MOVE.L	4(A0),SavSamInf
	MOVEQ	#1,D0
	MOVE.L	D0,4(A0)
	CALL	ValidateLoops
	CALL	TurnOffVoices
looptlo:
	BSR.W	ShowSampleInfo
	CALL	UpdateRepeats
	BRA.W	DisplaySample

loopton:
	CALL	TurnOffVoices		;fix
	MOVE.L	SavSamInf(PC),D0
	BNE.S	loopto2
	MOVE	(A0),D0
loopto2:
	MOVE.L	D0,4(A0)
	CALL	ValidateLoops
	BRA.B	looptlo

ShowLoopToggle:
	MOVEM.L D0-D7/A0-A6,-(SP)
	LEA	off.MSG,A0
	TST.W	LoopOnOffFlag
	BEQ.S	sltskip
	LEA	on.MSG,A0
sltskip:
	moveq	#3,d0
	move	#$46CE,d1

	BSR.W	ShowText3
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

LoopOnOffFlag:	dc.w	0
SavSamInf:	dc.l	0

;*********************************

SetSamNote:
	BSR.W	ShowResamNote
	MOVE.W	#$4A3E,TextOffset
	MOVE.W	#3,TextLength
	MOVE.L	#SpcNoteText,ShowTextPtr
	BSR.W	ShowText
	MOVE.W	#1,SamNotetype
	MOVE.L	#SampleNote,SplitAddress
	GOTO	WaitForButtonUp

SetResamNote:
	BSR.W	ShowSamNote
	MOVE.W	#$4DAE,TextOffset
	MOVE.W	#3,TextLength
	MOVE.L	#SpcNoteText,ShowTextPtr
	BSR.W	ShowText
	MOVE.W	#2,SamNotetype
	MOVE.L	#ResampleNote,SplitAddress
	GOTO	WaitForButtonUp

Resample.MSG:	dc.b	10,10,'     RESAMPLE?',0
		EVEN
Resampling.MSG:	dc.b	'RESAMPLING...',0
		EVEN

;*********************************
Resample:
	LEA	Resample.MSG(PC),A0
	CALL	AreYouSure
	BEQ.S	.l1
	RTS

.l1:	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	LEA	Resampling.MSG(PC),A0
	BSR.W	ShowStatusText
	LEA	mt_songdataptr(pc),A0
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVE.L	(A0),D0
	BEQ.W	ERC2
	MOVE.L	D0,A2
	MOVE.L	$7C(A0),D6
	CMP.L	#2,D6
	BLS.W	ERC2

	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU	#30,D1
	MOVEQ	#0,D0
	MOVE.B	14(A0,D1.W),D0		;finetune
	AND.B	#15,D0
	MULU.W	#74,D0
	LEA	mt_periodtable(PC),A0
	ADD.L	D0,A0
	MOVEQ	#0,D1
	MOVE.W	ResampleNote(PC),D1
	LSL.W	#1,D1
	MOVE.W	0(A0,D1.W),D1
	BEQ.W	ERC2

	LEA	mt_periodtable,A0
	MOVEQ	#0,D5
	MOVE.W	TuneTone,D5
	LSL.W	#1,D5
	MOVE.W	0(A0,D5.W),D5
	BEQ.W	ERC2

;d1=resamperiod, d5=tuneperiod

	MOVE.L	D5,D0			; tune
	LSL.L	#8,D0
	LSL.L	#4,D0			; *4096
	DIVU	D1,D0			; resample
	MOVEQ	#0,D4
	MOVE.W	D0,D4
	LSL.L	#4,D4			; hi-word=add value, lo-word=fraction

	MOVE.W	D6,D7
	LSR.W	#1,D7
	MULU	D1,D7
	DIVU	D5,D7
	AND.L	#(MaxSamLen/2),D7 	; 32767 (*2)
	CMP.L	#2,D7
	BCS.W	ERC2
	CMP.L	#(MaxSamLen/2),D7
	BCS.S	resamlo
	MOVE.L	#(MaxSamLen/2),D7
resamlo:
	ADD.L	D7,D7
	MOVE.L	D7,D0
	MOVE.L	XDmaType,D1		; Changed to Public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	TST.L	D0
	BEQ.W	SamMemError
	MOVE.L	D0,A1
	MOVE.L	D0,A3
	CALL	TurnOffVoices
	MOVE.L	A2,A0

; D4=resample value, D6=old length, D7=new length
; A0/A2=old sample, A1/A3=new sample


	MOVE.l	#(MaxSamLen/2),D1
	MOVEQ	#0,D3
	MOVEQ	#0,D5

resampleloop:
	MOVE.B	1(A0),D0
	EXT.W	D0
	MULS	D1,D0
	MOVE.B	(A0),D2
	EXT.W	D2
	MULS	D3,D2
	ADD.L	D2,D0
	ASR.L	#8,D0
	ASR.L	#7,D0
	MOVE.B	D0,(A1)+
	ADD.L	D4,D5
	SWAP	D5
	MOVE.L	A2,A0
	MOVEQ	#0,D0
	MOVE.W	D5,D0
	ADD.L	D0,A0
	SWAP	D5
	MOVE.W	D5,D1
	LSR.W	#1,D1
	MOVE.l	#(MaxSamLen/2),D3	      	;$7FFF,D3
	SUB.W	D1,D3
	MOVE.L	A1,A4
	SUB.L	A3,A4
	CMP.L	D7,A4
	BCC.S	resamskip
	MOVE.L	A0,A4
	SUB.L	A2,A4
	CMP.L	D6,A4
	BCS.S	resampleloop
resamskip:
	MOVE.L	A2,A1
	MOVE.L	D6,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	MOVE.W	InsNum(PC),D1
	LSL.W	#2,D1
	LEA	mt_songdataptr(pc),A0
	LEA	0(A0,D1.W),A0
	MOVE.L	A3,(A0)
	MOVE.L	D7,$007C(A0)
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU.W	#30,D1
	LEA	12(A0,D1.W),A0
	LSR.L	#1,D7
	MOVE.W	D7,(A0)
	CLR.B	2(A0)
	CLR.W	4(A0)
	MOVE.W	#1,6(A0)
	CALL	RestorePtrCol
	BSR.W	ClearSamStarts
	BSR.W	ShowSampleInfo
	BSR.W	ShowAllRight
	BRA.W	RedrawSample

ERC2:
	GOTO	ErrorRestoreCol

;*********************************

SamCut:
	CLR.B	RawKeyCode
	MOVE.L	MarkStartOfs(PC),D0
	BMI.W	NoRangeError
	CMP.L	MarkEndOfs(PC),D0
	BEQ.W	LargerRangeError
	BTST	#5,CutToBufFlag
	BEQ.S	samcut2
	BSR.W	SamCopy
samcut2:
	CALL	TurnOffVoices
	LEA	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVE.L	(A0),D0
	BEQ.W	EmptySampleError
	MOVE.L	$7C(A0),D2
	CMP.L	#2,D2
	BCS.W	EmptySampleError

	MOVE.L	D0,A1
	MOVE.L	D0,A2			; sample start
	MOVE.L	D0,A3
	MOVE.L	D0,A4
	MOVE.L	D0,A5
	ADD.L	MarkStartOfs(PC),A3	; mark start
	MOVE.L	MarkEndOfs(PC),D0
	SUB.L	MarkStartOfs(PC),D0
	CMP.L	D2,D0
	BCC.W	Destroy
	MOVE.L	MarkEndOfs(PC),D0
	CMP.L	D2,D0
	BCS.S	samsome
	MOVE.L	D2,D0
	SUBQ.L	#1,D0
samsome:
	ADD.L	D0,A4
	ADD.L	D2,A5
	MOVE.L	A3,D0
	SUB.L	A2,D0
	ADD.L	A5,D0
	SUB.L	A4,D0
	BNE.S	sacut1
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	BRA.S	sacut6

sacut1:
	MOVE.L	D0,D3
	MOVE.L	XDmaType,D1		;Changed to Public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,D4
	BEQ.W	OutOfMemErr

	MOVE.L	D0,A0
	MOVE.L	A2,A1
	MOVE.L	A3,D0
	SUB.L	A2,D0
	BRA.S	sacut3

sacut2:
	MOVE.B	(A2)+,(A0)+
sacut3:
	DBRA	D0,sacut2
	MOVE.L	A5,D0
	SUB.L	A4,D0
	BRA.S	sacut5


sacut4:
	MOVE.B	(A4)+,(A0)+
sacut5:
	DBRA	D0,sacut4
sacut6:
	MOVE.L	4.w,a6
	MOVE.L	D2,D0
	BEQ.S	sacut7
	CALLSYS	FreeMem
sacut7:
	MOVE.W	InsNum(PC),D1
	LSL.W	#2,D1
	LEA	mt_songdataptr(PC),A0
	LEA	0(A0,D1.W),A0
	;MOVE.L	(A0),SCutAdr
	MOVE.L	D4,(A0)

	MOVE.L	D3,$007C(A0)			; test
	MOVE.L	D4,SamStart
	MOVE.L	D3,SamLength
	MOVE.L	SamOffSet(PC),D4
	ADD.L	SamDisplay(PC),D4
	CMP.L	D3,D4
	BCS.S	samcuto
	MOVE.L	SamDisplay(PC),D4
	CMP.L	D3,D4
	BCS.S	sacut9
sacut8:
	CLR.L	SamOffSet
	MOVE.L	D3,SamDisplay
	BRA.S	samcuto

sacut9:
	MOVE.L	D3,D4
	SUB.L	SamDisplay(PC),D4
	BMI.S	sacut8
	MOVE.L	D4,SamOffSet
samcuto:
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU	#30,D1
	LEA	12(A0,D1.W),A0
	LSR.L	#1,D3
	MOVE.W	D3,(A0)
	MOVE.W	4(A0),D0
	CMP.W	D3,D0
	BLS.S	sacut10
	MOVEQ	#1,D0
	MOVE.L	D0,4(A0)
	BRA.S	sacut11

sacut10:
	ADD.W	6(A0),D0
	CMP.W	D3,D0
	BLS.S	sacut11
	SUB.W	4(A0),D3
	MOVE.W	D3,6(A0)
sacut11:
	MOVE.L	MarkStartOfs(PC),MarkEndOfs
	BSR.W	ClearSamStarts
	CALL	ValidateLoops
	BSR.W	ShowSampleInfo
	BRA.W	DisplaySample

;SCutAdr:
;	dc.l	0

;*********************************

SamCopy:
	CLR.B	RawKeyCode
	MOVE.L	MarkStartOfs(PC),D0
	BMI.W	NoRangeError
	CMP.L	MarkEndOfs(PC),D0
	BEQ.W	LargerRangeError
	LEA	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVE.L	(A0),D0
	BEQ.W	EmptySampleError
	MOVE.L	$7C(A0),D2
	BEQ.W	EmptySampleError
	MOVE.L	D0,A3
	MOVE.L	D0,A4
	ADD.L	MarkStartOfs(PC),A3	; mark start
	MOVE.L	MarkEndOfs(PC),D0	; mark end
	CMP.L	D2,D0
	BCS.S	csamsom
	MOVE.L	D2,D0
	SUBQ.L	#1,D0
csamsom:
	ADD.L	D0,A4
	BSR.S	ClearCopyBufPtr
	MOVE.L	A4,D0
	SUB.L	A3,D0
	ADDQ.L	#1,D0
	MOVE.L	D0,CopyBufSize
	MOVE.L	XDmaType,D1		; Changed to Public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	MOVE.L	D0,CopyBufPtr
	BEQ.W	OutOfMemErr
	MOVE.L	D0,A5
csamslop:
	MOVE.B	(A3)+,(A5)+
	CMP.L	A4,A3
	BLS.S	csamslop
	BSR.W	invertRange
	BSR.W	invertRange
	GOTO	WaitForButtonUp

ClearCopyBufPtr:
	MOVE.L	CopyBufPtr(PC),D0
	BNE.S	FreeCopyBuf
	RTS

;*********************************

FreeCopyBuf:
	MOVE.L	D0,A1
	MOVE.L	CopyBufSize(PC),D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
	CLR.L	CopyBufPtr
	RTS

CopyBufPtr:	dc.l	0
CopyBufSize:	dc.l	0

;*********************************
SamPaste:
	CLR.B	RawKeyCode
	MOVE.L	MarkStartOfs(PC),D0
	BMI.W	SetCursorPos
	LEA	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	BEQ.W	NotSampleNull
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVEQ	#0,D2
	MOVE.L	(A0),D0
	BEQ.S	sapanul
	MOVE.L	$7C(A0),D2
sapanul:
	MOVE.L	D0,A2
	MOVE.L	CopyBufPtr(PC),D3
	BEQ.W	BufferIsEmpty
	MOVE.L	D3,A3
	MOVE.L	CopyBufSize(PC),D3
	BEQ.W	BufferIsEmpty

	MOVE.L	D3,D4			; copysize
	ADD.L	D2,D4			; + origsize

	CMP.L	#MaxSamLen,D4		; 1FFE 128k 131070 org FFFE
	BCS.S	sapaok
	MOVE.L	#MaxSamLen,D4
sapaok:
	MOVE.L	D4,D0
	MOVE.L	XDmaType,D1		; changed to public
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	TST.L	D0
	BEQ.W	OutOfMemErr
	MOVE.L	D0,A4
	MOVEQ	#0,D0
	TST.L	D2
	BEQ.S	sapask1
	MOVE.L	MarkStartOfs(PC),D0
sapask1:
	MOVE.L	D0,MarkStartOfs
	MOVE.L	A2,A1
	MOVE.L	D2,D1
	MOVE.L	A4,A5
	MOVE.L	A4,A0
	ADD.L	D4,A0
	BRA.S	sapask2

; D0    = paste position
; A0    = end of new sample
; A1/D1 = copy of A2/D2
; A2/D2 = original sample
; A3/D3 = copy buffer
; A4/D4 = new sample
; A5    = copy of A4

sapaslp1:
	MOVE.B	(A2)+,(A4)+ 		; copy first part
	CMP.L	A0,A4
	BCC.S	sapaski
	SUBQ.L	#1,D2
sapask2:
	DBRA	D0,sapaslp1
	BRA.S	sapask3

sapaslp2:
	MOVE.B	(A3)+,(A4)+		; copy from buffer
	CMP.L	A0,A4
	BCC.S	sapaski
sapask3:
	DBRA	D3,sapaslp2
	TST.L	D2
	BEQ.S	sapaski
	BMI.S	sapaski
sapaslp3:
	MOVE.B	(A2)+,(A4)+		; copy last part
	CMP.L	A0,A4
	BCC.S	sapaski
	SUBQ.L	#1,D2
	BNE.S	sapaslp3
sapaski:
	MOVE.L	D1,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem

	MOVE.W	InsNum(PC),D1
	LSL.W	#2,D1
	LEA	mt_songdataptr(PC),A0
	LEA	0(A0,D1.W),A0
	MOVE.L	A5,(A0)
	MOVE.L	D4,$007C(A0)
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU	#30,D1
	LEA	12(A0,D1.W),A0
	LSR.L	#1,D4
	MOVE.W	D4,(A0)

	MOVE.L	MarkStartOfs(PC),MarkEndOfs
	BSR.W	OffsetToMark
	BSR.W	ClearSamStarts
	BSR.W	ShowSampleInfo
	BRA.W	RedrawSample

;**************************************
RampVolume:
	MOVE.L	TextBplPtr(PC),A0
	LEA	$3079(A0),A0
	MOVEQ	#$20,D3
ravlap2:
	MOVEQ	#$10,D2
ravlap1:
	CLR.B	(A0)+
	DBRA	D2,ravlap1
	LEA	63(A0),A0
	DBRA	D3,ravlap2
	LEA	PTBitMap+VolBoxPos,A0
	LEA	VolBoxData,A1
	MOVEQ	#1,D4
ravlop3:
	MOVEQ	#$20,D3
ravlop2:
	MOVEQ	#$10,D2
.loo:
	MOVE.B	(A1)+,(A0)+
	DBRA	D2,.loo
	ADDQ.L	#1,A1
	LEA	63(A0),A0
	DBRA	D3,ravlop2
	LEA	$45B0(A0),A0
	DBRA	D4,ravlop3
	BSR.W	ShowVolSliders
	CALL	WaitForButtonUp
ravloop:
	CALL	ResetKeyTimer
	checkrmb
	BEQ.S	ExitVolBox
	CALL	DoKeyBuffer
	MOVE.B	RawKeyCode(PC),D2
	CMP.B	#$44,D2
	BEQ.S	ExitVolBox
	BTST	#6,$00BFE001
	BNE.S	ravloop
	MOVEM.W (MouseX),D0/D1
	CMP.W	#$0048,D0
	BCS.S	ravloop
	CMP.W	#$00D0,D0
	BCC.S	ravloop
	CMP.W	#$009B,D1
	BCS.S	ravloop
	CMP.W	#$00A6,D1
	BCS.S	Vol1Slider
	CMP.W	#$00B1,D1
	BCS.W	Vol2Slider
	CMP.W	#$00BC,D1
	BCS.W	VolGadgs
	BRA.S	ravloop

ExitVolBox:
	LEA	PTBitMap+VolBoxPos,A0
	MOVEQ	#1,D2


revlap3:
	MOVEQ	#$20,D1
revlap2:
	MOVEQ	#$10,D0
.loo:
	CLR.B	(A0)+
	DBRA	D0,.loo
	LEA	63(A0),A0
	DBRA	D1,revlap2
	LEA	$45B0(A0),A0
	DBRA	D2,revlap3
	BRA.W	DisplaySample

;*************************************
Vol1Slider:
	CMP.W	#$00A7,D0
	BHI.S	v1skip
	LEA	Vol1(PC),A4
	MOVEQ	#0,D7
v1oop1:
	BTST	#6,$00BFE001
	BNE.W	ravloop
	MOVE.W	MouseX(PC),D0
	CMP.W	D7,D0
	BEQ.S	v1oop1
	MOVE.W	D0,D7
	SUB.W	#$006B,D0
	BPL.S	v1skp2
	MOVEQ	#0,D0
v1skp2:
	CMP.W	#$003C,D0
	BLS.S	v1skp3
	MOVEQ	#$3C,D0
v1skp3:
	MULU	#$00C8,D0
	DIVU	#$003C,D0
	MOVE.W	D0,(A4)
shvosl:
	BSR.W	ShowVolSliders
	BRA.S	v1oop1

v1skip:
	MOVE.W	#$00B4,LineCurX
	MOVE.W	#$00A4,LineCurY
	MOVE.W	#$3176,TextOffset
	CALL	GetDec3Dig
	TST.W	AbortDecFlag
	BNE.B	shvosl
	CMP.W	#$00C8,D0
	BLS.S	v1skp4
	MOVE.W	#$00C8,D0
v1skp4:
	MOVE.W	D0,Vol1
	BRA.S	shvosl

Vol2Slider:
	CMP.W	#$00A7,D0
	BHI.S	v2skip
	LEA	Vol2(PC),A4
	MOVEQ	#0,D7
	BRA.B	v1oop1

v2skip:
	MOVE.W	#$00B4,LineCurX
	MOVE.W	#$00AF,LineCurY
	MOVE.W	#$34E6,TextOffset
	CALL	GetDec3Dig
	TST.W	AbortDecFlag
	BNE.B	shvosl
	CMP.W	#$00C8,D0
	BLS.S	v2sk2
	MOVE.W	#$00C8,D0
v2sk2:
	MOVE.W	D0,Vol2
	BRA.W	shvosl

VolGadgs:
	CMP.W	#$0064,D0
	BCS.W	DoRampVol
	CMP.W	#$0090,D0
	BCS.W	Normalize
	CMP.W	#$009A,D0
	BCS.S	SetRampDown
	CMP.W	#$00A4,D0
	BCS.S	SetRampUp
	CMP.W	#$00AE,D0
	BCS.S	SetRampUnity
	BRA.W	ExitVolBox

SetRampDown:
	MOVE.W	#$0064,Vol1
	CLR.W	Vol2
	BRA.S	sru2

SetRampUp:
	CLR.W	Vol1
	MOVE.W	#$0064,Vol2
	BRA.S	sru2

SetRampUnity:
	MOVE.W	#$0064,Vol1
	MOVE.W	#$0064,Vol2
sru2:
	BSR.S	ShowVolSliders
	CALL	WaitForButtonUp
	BRA.W	ravloop


;********************************
ShowVolSliders:
	MOVE.L	TextBplPtr(PC),A0
	LEA	$3079(A0),A0
	MOVEQ	#$15,D3
ravlip2:
	MOVEQ	#12,D2
.loo:
	CLR.B	(A0)+
	DBRA	D2,.loo
	LEA	$0043(A0),A0
	DBRA	D3,ravlip2
	MOVEQ	#0,D4
	MOVE.W	Vol1(PC),D4
	MOVEQ	#$14,D5
	BSR.S	OneSlider
	MOVEQ	#0,D4
	MOVE.W	Vol2(PC),D4
	MOVEQ	#$1F,D5
	BSR.S	OneSlider
	MOVE.W	Vol1(PC),WordNumber
	MOVE.W	#$3176,TextOffset
	BSR.W	Print3DecDigits_2
	MOVE.W	Vol2(PC),WordNumber
	MOVE.W	#$34E6,TextOffset
	BRA.W	Print3DecDigits_2

OneSlider:
	MOVE.W	D4,D6
	ADD.W	D4,D4
	ADD.W	D6,D4
	DIVU	#10,D4
	ADD.W	#$0069,D4
	MOVEQ	#2,D6
.loo:
	MOVE.W	D4,D0
	MOVE.W	D4,D2
	ADDQ.W	#5,D2
	MOVE.W	D5,D1
	MOVE.W	D5,D3
	BSR.W	DrawLine
	ADDQ.W	#1,D5
	DBRA	D6,.loo
	RTS

DoRampVol:
	CLR.B	RawKeyCode
	LEA	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	BEQ.S	nozerr1
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVEQ	#0,D2
	MOVE.L	(A0),D0
	BEQ.S	nozerr2
	MOVE.L	D0,A2
	MOVE.L	$007C(A0),D2
	BEQ.S	nozerr2
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	drvskip
	MOVE.L	MarkEndOfs(PC),D1
	SUB.L	D0,D1
	BEQ.S	drvskip
	ADD.L	D0,A2
	MOVE.L	D1,D2
	ADDQ.L	#1,D2
drvskip:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVE.L	D2,D5
	MOVEQ	#0,D3
drvloop:
	MOVE.W	D3,D1
	MULU	Vol2(PC),D1
	DIVU	D2,D1
	MOVE.W	D2,D4
	SUB.W	D3,D4
	MULU	Vol1(PC),D4
	DIVU	D2,D4
	ADD.W	D4,D1
	ADDQ.W	#1,D3
	MOVE.B	(A2),D0
	EXT.W	D0
	MULS	D1,D0
	DIVS	#$0064,D0
	CMP.W	#$007F,D0
	BLT.S	drvskp2
	MOVEQ	#$7F,D0
drvskp2:
	CMP.W	#$FF80,D0
	BGT.S	drvskp3
	MOVEQ	#-$80,D0
drvskp3:
	MOVE.B	D0,(A2)+
	SUBQ.L	#1,D5
	BNE.B	drvloop
	CALL	RestorePtrCol
	BRA.W	ExitVolBox

nozerr1:
	CALL	NotSampleNull
	BRA.W	ravloop

nozerr2:
	BSR.W	EmptySampleError
	BRA.W	ravloop

;****************
Normalize:
	CLR.B	RawKeyCode
	LEA	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	BEQ.B	nozerr1
	LSL.W	#2,D1
	LEA	0(A0,D1.W),A0
	MOVEQ	#0,D2
	MOVE.L	(A0),D0
	BEQ.B	nozerr2
	MOVE.L	D0,A2
	MOVE.L	$007C(A0),D2
	BEQ.B	nozerr2
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	nozskip
	MOVE.L	MarkEndOfs(PC),D1
	SUB.L	D0,D1
	BEQ.S	nozskip
	ADD.L	D0,A2
	MOVE.L	D1,D2
	ADDQ.L	#1,D2
nozskip:
	CALL	StorePtrCol
	CALL	SetWaitPtrCol
	MOVEQ	#0,D0
nozloop:
	MOVE.B	(A2)+,D1
	EXT.W	D1
	BPL.S	nozskp2
	NEG.W	D1
nozskp2:
	CMP.W	D0,D1
	BCS.S	nozskp3
	MOVE.W	D1,D0
nozskp3:
	SUBQ.L	#1,D2
	BNE.B	nozloop
	CALL	RestorePtrCol
	TST.W	D0
	BEQ.W	SetRampUnity
	CMP.W	#$007F,D0
	BHI.W	SetRampUnity
	CMP.W	#$0040,D0
	BCS.S	nozmax
	MOVE.L	#$0000319C,D1
	DIVU	D0,D1
	MOVE.W	D1,Vol1
	MOVE.W	D1,Vol2
	BRA.W	sru2

nozmax:
	MOVE.W	#$00C8,Vol1
	MOVE.W	#$00C8,Vol2
	BRA.W	sru2

dd16:	dc.w	$64
Vol1:	dc.w	$64
Vol2:	dc.w	$64

xTuningTone:
	CALL	WaitForButtonUp
	;CLR.B	RawKeyCode
	TST.W	TToneFlag
	BNE.W	TToneOff
	MOVE.W	#1,TToneFlag
	MOVE.W	PattCurPos,D2
	DIVU	#6,D2
	ADDQ.W	#1,D2
	AND.W	#3,D2
	MOVEQ	#1,D0
	LSL.W	D2,D0
	MOVE.W	D0,TToneBit
	LEA	AUD0,A0
	LSL.W	#4,D2
	LEA	0(A0,D2.W),A0
	LEA	mt_periodtable(PC),A1
	MOVE.W	TuneTone,D1
	LSL.W	#1,D1
	MOVE.W	0(A1,D1.W),D1
	MOVE.W	D0,D2
	LSL.W	#7,D2
	MOVE.W	D2,INTENA
	MOVE.W	D2,INTREQ
	MOVE.W	D0,DMACON
	MOVE.W	#1,6(A0)
	;CALL	DMAWaitLoop
	MOVE.W	#0,10(A0)
	MOVE.L	#TToneData,0(A0)
	MOVE.W	#$10,4(A0)
	MOVE.W	D1,6(A0)
	MOVE.W	TToneVol,D1
	MULU	TremoloByte(PC),D1
	ADD.L	#$20,D1
	LSR.L	#6,D1
	MOVE.W	D1,8(A0)
TToneLp5:
	MOVE.W	INTREQR,D1
	AND.W	D2,D1
	BEQ.S	TToneLp5
	OR.W	#$8000,D0
	MOVE.W	D0,DMACON
	RTS

TToneOff:
	CLR.W	TToneFlag
	MOVE.W	TToneBit(PC),D0
	MOVE.W	D0,D2
	LSL.W	#7,D2
	MOVE.W	D2,INTENA
	MOVE.W	D0,DMACON
	RTS

TToneFlag:	dc.w	0
TToneBit:	dc.w	0

;**********************************

SamplePressed:
	CMP.W	#$90,D1
	BCC.S	spruskp
	MOVE.W	LoopStartPos(PC),D2
	BEQ.S	spruskp5
	SUBQ.W	#6,D2
	CMP.W	D2,D0
	BLT.S	spruskp5
	ADDQ.W	#8,D2
	CMP.W	D2,D0
	BCS.W	LoopStartDrag
spruskp5:
	MOVE.W	LoopEndPos(PC),D2
	BEQ.S	spruskp
	SUBQ.W	#6,D2
	CMP.W	D2,D0
	BLT.S	spruskp
	ADDQ.W	#8,D2
	CMP.W	D2,D0
	BCS.W	LoopEndDrag
spruskp:
	CMP.W	#3,D0
	BCC.S	.l5
	RTS

.l5:	CMP.W	#634+3,D0
	BCS.S	.l4
	RTS

.l4:	MOVE.W	D0,LastSamPos
	BSR.W	invertRange
	MOVE.W	LastSamPos(PC),D0
	MOVE.W	D0,MarkStart
	MOVE.W	D0,MarkEnd
	MOVE.W	D0,lbW014F24
	BSR.W	lbC014EDC
	BSR.W	MarkToOffset
	MOVE.L	MarkEndOfs(PC),sam_sposflag
	CALL   sam_sposupdate
	CALL	lbC014F0C
	MOVE.l	#$0000FFFF,lbW014F26		;$FFFF,lbW014F26
sprulop:
	CALL	ResetKeyTimer
	BTST	#6,$00BFE001
	BNE.S	spruend
	MOVE.W	MouseX(PC),D0
	CMP.W	#3,D0
	BCS.S	.l2
	CMP.W	#634+3,D0
	BCC.S	.l1
	BRA.S	.l3

.l1:	MOVE.W	#634+2,D0
	BRA.S	.l3

.l2:	MOVEQ	#3,D0

.l3:	CMP.W	LastSamPos(PC),D0
	BEQ.B	sprulop
	MOVE.W	D0,LastSamPos
	BSR.S	lbC014EDC
	MOVE.W	LastSamPos(PC),MarkEnd
	BSR.S	lbC014EDC
	BSR.W	MarkToOffset
	MOVE.L	MarkEndOfs(PC),sam_sposflag
	CALL   sam_sposupdate
	BRA.B	sprulop

spruend:
	MOVE.W	MarkStart(PC),D0
	MOVE.W	MarkEnd(PC),D1
	CMP.W	D0,D1
	BCC.W	MarkToOffset
	MOVE.W	D0,MarkEnd
	MOVE.W	D1,MarkStart
	BRA.W	MarkToOffset

;**********************************
invertRange:
	TST.L	lbW014F26
	BNE.S	lbC014F0C
	MOVE.W	MarkStart(PC),D0
	BNE.S	.l1
	RTS

.l1:	MOVE.W	MarkEnd(PC),D2
	MOVEQ	#0,D1
	MOVEQ	#64,D3
	CMP.W	D0,D2
	BPL.S	.l2
	EXG	D0,D2

.l2:	BRA.W	BlitCharge2

;**********************************
lbC014EDC:
	TST.L	lbW014F26
	BEQ.S	.l1
	BSR.S	lbC014F0C

.l1:	MOVE.W	MarkStart(PC),D4
	BNE.S	.l2
	RTS

.l2:	MOVE.W	lbW014F24(PC),D0
	MOVE.W	MarkEnd(PC),D2
	MOVE.W	D2,lbW014F24
	MOVEQ	#0,D1
	MOVEQ	#64,D3
	CMP.W	D0,D2
	BPL.S	.l3
	EXG	D0,D2

.l3:	BRA.W	BlitCharge2

;**********************************
lbC014F0C:
	CLR.L	lbW014F26
	MOVEQ	#0,D1
	MOVEQ	#64,D3
	MOVE.W	MarkStart(PC),D0
	MOVE.W	D0,D2
	ADDQ.W	#1,D2
	BRA.W	BlitCharge2

lbW014F24:	dc.w	0
lbW014F26:	dc.l	0
LoopStartPos:	dc.w	0
LoopEndPos:	dc.w	0

;**********************************
;* Loop slider 1                  *
;**********************************
LoopStartDrag:
	CLR.W	DragType
LopDrgLop:
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D0
	BNE.S	.l1
	RTS

.l1:	MULU	#30,D0
	LEA	12(A0,D0.W),A0
	MOVE.W	MouseX(PC),D0

.l2:	CALL	ResetKeyTimer
	BTST	#6,$00BFE001
	BNE.S	lbC014FD0
	MOVE.W	MouseX(PC),D1
	CMP.W	D0,D1
	BEQ.S	.l2

	SUB.W	DragType,D1
	BPL.S	.l3
	MOVEQ	#0,D1

.l3:	CMP.W	#634,D1
	BCS.S	.l4
	MOVE.W	#634,D1

.l4:	MOVE.L	SamDisplay(PC),D0
	MULU	D0,D1
	DIVU	#634,D1
	AND.L	#$0000FFFF,D1
	MOVE.L	SamOffSet(PC),D0
	ADD.W	D1,D0
	BCLR	#0,D0
	MOVEQ	#0,D1
	MOVE.W	4(A0),D1
	ADD.W	D1,D1
	TST.W	DragType
	BNE.S	lbC014FEA
	MOVE.W	D1,D3
	SUB.W	D1,D0
	ADD.W	D0,D1
	MOVE.W	6(A0),D2
	ADD.W	D2,D2
	ADD.W	D2,D3
	SUBQ.W	#2,D3
	SUB.W	D0,D2
	CMP.W	D3,D1
	BLS.S	lbC014FBE
	MOVE.W	D3,D1
	MOVEQ	#2,D2
lbC014FBE:
	LSR.W	#1,D1
	MOVE.W	D1,4(A0)
	LSR.W	#1,D2
	MOVE.W	D2,6(A0)
	BSR.S	lbC014FD0
	BRA.W	LopDrgLop

lbC014FD0:
	BSR.W	ShowSampleInfo
	CALL	UpdateRepeats
	BSR.W	SetLoopSprites2
	RTS

LoopEndDrag:
	MOVE.W	#3,DragType
	BRA.W	LopDrgLop

lbC014FEA:
	MOVE.L	D0,D2
	SUB.L	D1,D2
	CMP.L	#2,D2
	BGT.S	lbC014FFA
	MOVEQ	#2,D2
	BRA.S	lbC014FBE

lbC014FFA:
	MOVE.W	D1,D0
	ADD.W	D2,D0
	MOVE.W	(A0),D3
	ADD.W	D3,D3
	CMP.W	D3,D0
	BLS.S	lbC014FBE
	SUB.W	D1,D3
	MOVE.W	D3,D2
	BRA.S	lbC014FBE


DragType:	dc.w	0

;*********************************
;* the sample slider for zooming *
;*********************************
SamDragBar:

	CMP.W	DragStart(PC),D0
	BCS.S	draglo
	CMP.W	DragEnd(PC),D0
	BHI.W	draghi
	MOVE.W	MouseX(PC),D0
	MOVE.W	D0,D1
	SUB.W	DragStart(PC),D1
	MOVE.W	D1,SaveMX
sdrlop1:
	CALL	ResetKeyTimer
	BTST	#6,$00BFE001
	BNE.W	DisplaySample4
trt18:
	MOVE.W	MouseX(PC),D1
	CMP.W	D0,D1
	BEQ.S	sdrlop1
	SUB	SaveMX(PC),D0
	SUBQ	#4,D0
	BPL.S	sdrskp1
	MOVEQ	#0,D0
sdrskp1:
	MOVE.L	SamLength(PC),D1
	BNE.S	trt19
	RTS

;show range slider

trt19:	MULU	D1,D0
	DIVU.W	#634-3,D0			; fix
	AND.L	#$0000FFFF,D0
	BSR.S	dragchk
	MOVE.W	MouseX(PC),D0
	BRA.S	sdrlop1

dragchk:
	MOVE.L	D0,D1
	ADD.L	SamDisplay(PC),D1
	CMP.L	SamLength(PC),D1
	BLS.S	draglo2
	MOVE.L	SamLength(PC),D0
	SUB.L	SamDisplay(PC),D0
	BRA.S	draglo2
draglo:
	MOVE.L	SamOffSet(PC),D0
	SUB.L	SamDisplay(PC),D0
	BPL.S	lbC0150A2
	MOVEQ	#0,D0
draglo2:
	CMP.L	SamOffSet(PC),D0
	BNE.S	auins30
	RTS
auins30:
	MOVE.L	D0,SamOffSet
	BRA.W	lbC015398
lbC0150A2:
	CMP.L	SamOffSet(PC),D0
	BNE.S	lbC0150AA
	RTS

lbC0150AA:
	MOVE.L	D0,SamOffSet
	BRA.W	DisplaySample

draghi:
	MOVE.L	SamOffSet(PC),D0
	ADD.L	SamDisplay(PC),D0
	MOVE.L	D0,D1
	ADD.L	SamDisplay(PC),D1
	CMP.L	SamLength(PC),D1
	BLS.S	lbC0150A2
	MOVE.L	SamLength(PC),D0
	SUB.L	SamDisplay(PC),D0
	BRA.S	lbC0150A2

SaveMX: dc.w	0

;********************************
MarkToOffset:
	MOVE.L	SamDisplay(PC),D0
	MOVEQ	#0,D1
	MOVE.W	MarkStart(PC),D1
	BNE.S	.l1
	RTS

.l1:	SUBQ.W	#3,D1
	MULU	D0,D1
	DIVU	#634,D1
	AND.L	#$0000FFFF,D1
	ADD.L	SamOffSet(PC),D1
	MOVE.L	D1,MarkStartOfs
	MOVE.W	MarkEnd(PC),D1
	CMP.W	#634+2,D1
	BCS.S	.l2
	MOVE.L	SamOffSet(PC),D1
	ADD.L	D0,D1
	BRA.S	.skip

.l2:	SUBQ.W	#3,D1
	MULU	D0,D1
	DIVU	#634,D1
	AND.L	#$0000FFFF,D1
	ADD.L	SamOffSet(PC),D1
.skip:
	MOVE.L	D1,MarkEndOfs
	RTS
;**********************************
OffsetToMark:
	MOVE.L	MarkStartOfs(PC),D0
	BMI.S	.skip
	MOVE.W	#3,MarkStart
	SUB.L	SamOffSet(PC),D0
	BMI.S	.l4
	MULU	#634,D0
	MOVE.L	SamDisplay(PC),D1
	BEQ.S	.l4
	DIVU	D1,D0
	CMP.W	#634,D0
	BHI.S	.skip
	ADD.W	D0,MarkStart

.l4:	MOVE.W	#3,MarkEnd
	MOVE.L	MarkEndOfs(PC),D0
	SUB.L	SamOffSet(PC),D0
	BMI.S	.skip
	MULU	#634,D0
	MOVE.L	SamDisplay(PC),D1
	BNE.S	.l0
	RTS

.l0:	DIVU	D1,D0
	CMP.W	#634-1,D0
	BLS.S	.l1
	MOVE.W	#634-1,D0

.l1:	ADD.W	D0,MarkEnd
	RTS

.skip:	CLR.W	MarkStart
	RTS

SamScrEnable:	dc.w	0
LastSamPos:	dc.w	0
MarkStart:	dc.w	0
MarkEnd:	dc.w	0
MarkStartOfs:	dc.l	0
MarkEndOfs:	dc.l	0

;**************************************
DisplaySample:
	TST.W	SamScrEnable
	BNE.S	.l1
	RTS

.l1:	BSR.W	rdsdoit
	TST.L	MarkStartOfs
	BPL.S	.l2
	RTS

.l2:	BSR.W	OffsetToMark
	BRA.W	invertRange

;**************************************
; displaysample jumped from loop check

DisplaySample4:
	TST.W	SamScrEnable
	BNE.S	.l1
	RTS

.l1:	BSR.W	invertRange
	BSR.S	.l3
	TST.L	MarkStartOfs
	BPL.S	.l2
	RTS

.l2:	BSR.W	OffsetToMark
	BRA.W	invertRange

.l3:	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	BRA.W	DisplaySample8

;----------------------------------------------
RedrawSample:
	TST.W	LoadingInProgress
	BNE.S	.l0
	CLR.B	RawKeyCode
	;CALL	ClearAllKeys

.l0:	TST.W	SamScrEnable
	BNE.S	.l1
	RTS

.l1:	MOVEQ	#-1,D0
	MOVE.L	D0,MarkStartOfs
	CLR.W	MarkStart
	MOVE.W	InsNum(PC),D0
	BEQ.S	rdsblnk			;blank Sample
	LEA	mt_samplestarts(PC),A1
	SUBQ.W	#1,D0
	LSL.W	#2,D0			;*20
	MOVE.L	0(A1,D0.W),SamStart
	BEQ.S	rdsblnk			;blank sample
	MOVE.L	$7C(A1,D0.W),D1		;get length
	BEQ.S	rdsblnk			;empty sample

	MOVE.L	D1,SamLength
	CLR.L	SamOffSet
	MOVE.L	D1,SamDisplay
	BRA.S	rdsdoit

;---------- base: an empty sample ------------
rdsblnk:
	LEA	BlankSample,A0
	MOVE.L	A0,SamStart
	MOVE.L	#634,SamLength
	CLR.L	SamOffSet
	MOVE.L	#634,SamDisplay

rdsdoit:
	MOVE.L	GfxBase,A6
	CALLSYS	OwnBlitter
	CALLSYS	WaitBlit
	BSR.W	ClearSamArea

;************************************
;* the basic blitting in sampler ...*
;************************************
DisplaySample8:
	MOVE.L	SamStart(PC),A0		; the sample to draw
	MOVEQ	#0,D4
	MOVE.L	#$FFFFFFFF,A2
	MOVE.L	SamOffSet(PC),D5
	MOVE.L	SamDisplay(PC),D6
	LEA	0(A0,D5.L),A0		; offset+samstart
	MOVE.L	A0,D0
	MOVE.L	D0,SamDrawStart
	ADD.L	D6,D0
	MOVE.L	D0,SamDrawEnd
	MOVEQ	#3,D0
	MOVEQ	#127,D1
	SUB.B	(A0),D1
	LSR.W	#2,D1

	MOVE.W	D0,PenX
	MOVE.W	D1,PenY

	CMP.L	#634,D6
	BLT.S	lbC01530E		;less than

	DIVU	#634,D6
	MOVE.L	D6,D5
	SWAP	D5
	MOVE.W	#317,D7
	MOVEQ	#0,D4

lbC0152E6:
	MOVE.W	D4,D0
	ADDQ.W	#3,D0
	MOVEQ	#$7F,D1		 	;127
	SUB.B	(A0),D1
	LSR.W	#2,D1
	BSR.W	DrawTo
	ADDQ.W	#1,D4
	LEA	0(A0,D6.W),A0
	SUB.W	D5,D7
	BGE.S	lbC015304
	ADD.W	#634,D7
	ADDQ.L	#1,A0
lbC015304:
	CMP.W	#634,D4
	BCS.S	lbC0152E6
	BRA.S	SetLoopGFX1

;********************************
lbC01530E:
	MOVE.L	#634,D7
	DIVU	D6,D7
	MOVE.L	D7,D5
	SWAP	D5
	MOVE.W	D6,lbW01535A
	LSR.W	#1,D6
	MOVEQ	#0,D4
lbC015324:
	MOVE.W	D4,D0
	ADDQ.W	#3,D0
	MOVEQ	#$7F,D1
	SUB.B	(A0),D1
	LSR.W	#2,D1
	BSR.W	DrawTo
	ADD.W	D7,D4
	LEA	1(A0),A0
	SUB.W	D5,D6
	BGE.S	lbC015342
	ADD.W	lbW01535A(PC),D6
	ADDQ.W	#1,D4
lbC015342:
	CMP.W	#634,D4
	BCS.S	lbC015324
	MOVE.W	#636,D0
	MOVEQ	#$7F,D1
	SUB.B	-1(A0),D1
	LSR.W	#2,D1
	BSR.W	DrawTo

SetLoopGFX1:
	MOVE.L	GfxBase,A6
	CALLSYS	DisownBlitter
	BSR.W	SetDragBar
	BSR.S	ShowSampleLength
	CALL   sam_sposupdate
	BRA.W	SetLoopSprites
	;BSR.W	ShowLoopToggle
	;RTS
ShowSampleLength:
	MOVE.L	SamDisplay(PC),D2
	LEA	BlankSample,A0
	CMP.L	SamStart,A0
	BNE.S	ShowSamlgt2
	MOVEQ	#0,D2
ShowSamlgt2:
	MOVE.W	#$01A8,D0
	MOVE.W	#$00D7,D1
	MOVEQ	#7,D3
	BRA.W	PrintHexWord2		; samplelength in samplerscreen

;********************************
lbC015398:
	TST.W	SamScrEnable
	BNE.S	.l1
	RTS

.l1:	BSR.S	lbC0153B8
	TST.L	MarkStartOfs
	BPL.S	.l2
	RTS

.l2:	BSR.W	OffsetToMark
	BRA.W	invertRange

;********************************
lbC0153B8:
	BSR.W	lbC013F2A
	MOVE.L	SamStart(PC),A0
	MOVEQ	#0,D4
	MOVEQ	#-1,D2
	MOVE.L	SamOffSet(PC),D5
	MOVE.L	SamDisplay(PC),D6
	LEA	0(A0,D5.L),A0
	MOVE.L	A0,D0
	MOVE.L	D0,SamDrawStart
	ADD.L	D6,D0
	MOVE.L	D0,SamDrawEnd
	CMP.L	#634,D6
	BLT.S	lbC015438
	DIVU	#634,D6
	MOVE.L	D6,D5
	SWAP	D5
	MOVE.W	#317,D7
	MOVEQ	#0,D4
lbC0153F8:
	MOVE.W	D4,D0
	ADDQ.W	#3,D0
	MOVEQ	#$7F,D1
	SUB.B	(A0),D1
	LSR.W	#2,D1
	MOVE.L	LineScreen(PC),A1
	MOVE.W	D1,D2
	LSL.W	#4,D2
	LSL.W	#6,D1
	ADD.W	D2,D1
	LEA	0(A1,D1.W),A1
	MOVE.W	D0,D1
	ASR.W	#3,D1
	EOR.B	#7,D0
	BSET	D0,0(A1,D1.W)
	ADDQ.W	#1,D4
	LEA	0(A0,D6.W),A0
	SUB.W	D5,D7
	BGE.S	lbC01542E
	ADD.W	#634,D7
	ADDQ.L	#1,A0
lbC01542E:
	CMP.W	#634,D4
	BCS.S	lbC0153F8
	BRA.S	SetLoopGFX2

lbC015438:
	MOVE.L	#634,D7
	DIVU	D6,D7
	MOVE.L	D7,D5
	SWAP	D5
	MOVE.W	D6,lbW01548C
	LSR.W	#1,D6
	MOVEQ	#0,D4
lbC01544E:
	MOVE.W	D4,D0
	ADDQ.W	#3,D0
	MOVEQ	#$7F,D1
	SUB.B	(A0),D1
	LSR.W	#2,D1
	MOVE.L	LineScreen(PC),A1
	MOVE.W	D1,D2
	LSL.W	#4,D2
	LSL.W	#6,D1
	ADD.W	D2,D1
	LEA	0(A1,D1.L),A1
	MOVE.W	D0,D1
	ASR.W	#3,D1
	EOR.B	#7,D0
	BSET	D0,0(A1,D1.W)
	ADD.W	D7,D4
	LEA	1(A0),A0
	SUB.W	D5,D6
	BGE.S	lbC015484
	ADD.W	lbW01548C(PC),D6
	ADDQ.W	#1,D4
lbC015484:
	CMP.W	#634,D4
	BCS.S	lbC01544E

SetLoopGFX2:
	BSR.S	SetDragBar
	BSR.W	ShowSampleLength
	CALL   sam_sposupdate
	BRA.W	SetLoopSprites
	;BSR.W	ShowLoopToggle
	;RTS

SamStart:	dc.l	0
SamLength:	dc.l	0
SamOffSet:	dc.l	0
SamDisplay:	dc.l	0
SaveSamIns:	dc.w	0
lbW01548C:	dc.w	0
lbW01535A:	dc.w	0

;- Called by Init Samplerscreen

SetDragBar:
	MOVE	#79,D0
	MOVE.L	TextBplPtr,A0
	LEA	16560(A0),A0
	MOVEQ	#0,D1

.loop1:	MOVE.L	D1,(A0)+
	DBRA	D0,.loop1

	MOVE.L	SamLength(PC),D0
	BNE.S	.doit
	RTS

.doit:	MOVE.L	SamOffSet(PC),D4
	MOVE.L	SamDisplay(PC),D5
	CMP.L	D0,D5
	BNE.S	.l1
	RTS

.l1:	ADD.L	D4,D5
	MULU	#631,D4
	DIVU	D0,D4
	ADDQ.W	#4,D4
	MOVE.W	D4,DragStart
	MULU	#631,D5      		; right zoomdragbar limit
	DIVU	D0,D5
	ADDQ.W	#5,D5
	MOVE.W	D5,DragEnd
	MOVE.W	D4,D0
	MOVE.W	D5,D2
	MOVEQ	#68,D1
	MOVEQ	#72,D3
	MOVEQ	#1,D5
	BRA.W	ClrWhoSamScr

DragStart:	dc.w	0
DragEnd:	dc.w	0

;********************************
;* pixel sampledraw add 3.15    *
;********************************

DrawThis:
	MOVEM.L D0/D1/A0,-(SP)

	LEA	PTBitMap,A0
	MULU	#$0050,D1
	LEA	0(A0,D1.L),A0
	MOVE.W	D0,D1
	EOR.B	#7,D0
	LSR.W	#3,D1
	LEA	0(A0,D1.W),A0
	MOVEQ	#0,D1
drwths1:
	BTST	D1,D5
	BNE.S	drwths2
	BCLR	D0,(A0)
	BRA.S	drwths3

drwths2:
	BSET	D0,(A0)
drwths3:
	LEA	$5000(A0),A0
	ADDQ.W	#1,D1
	CMP.W	#2,D1
	BCS.S	drwths1
	MOVEM.L (SP)+,D0/D1/A0
	RTS

drwths4:
	MOVE.L	LineScreen(PC),-(SP)
	MOVE.L	#PTBitMap,LineScreen
	MOVEQ	#0,D4
drwths5:
	MOVE.B	#$CA,MinTerm
	BTST	D4,D5
	BNE.S	drwths6
	MOVE.B	#10,MinTerm
drwths6:
	BSR.S	DrawLine
	ADD.L	#$00005000,LineScreen
	ADDQ.W	#1,D4
	CMP.W	#2,D4
	BCS.S	drwths5
	MOVE.B	#$C8,MinTerm
	MOVE.L	(SP)+,LineScreen
	RTS

;*******************************

DrawTo:
	MOVE.W	PenX(PC),D2
	MOVE.W	PenY(PC),D3
	MOVE.W	D0,PenX
	MOVE.W	D1,PenY
	CMP.W	D0,D2
	BNE.S	DrawLine
	CMP.W	D1,D3
	BEQ.W	DrwLine_rt
DrawLine:
	MOVEM.L D4-D7/A0,-(SP)
	MOVEQ	#0,D4
	SUB.W	D1,D3
	BGE.S	dypos
	NEG.W	D3
	BRA.S	dyneg

dypos:
	BSET	#0,D4
dyneg:
	SUB.W	D0,D2
	BGE.S	dxpos
	NEG.W	D2
	BRA.S	dxneg

dxpos:
	BSET	#1,D4
dxneg:
	MOVE.W	D2,D5
	SUB.W	D3,D5
	BGE.S	dxdypos
	EXG	D2,D3
	BRA.S	dxdyneg

dxdypos:
	BSET	#2,D4
dxdyneg:
	MOVEQ	#0,D5
	ROR.W	#4,D0
	OR.W	#$0B00,D0
	MOVE.B	D0,D5
	MOVE.B	MinTerm(PC),D0
	LSL.W	#1,D5
	MULS	#$0050,D1
	ADD.W	D5,D1
	ADD.L	LineScreen(PC),D1
blitrdy:
	BTST	#6,DMACONR			;!!! fixedorg #14, new 6
	BNE.S	blitrdy
	MOVE.W	#$4000,INTENA
	MOVE.B	Octants(PC,D4.W),D4
	ADD.L	D3,D3
	MOVE.W	D3,BLTBMOD
	SUB.W	D2,D3
	BGE.S	dldspos
	OR.B	#$40,D4
dldspos:
	MOVE.L	D3,BLTAPT
	SUB.W	D2,D3
	MOVE.W	D3,BLTAMOD
	MOVE.W	D4,BLTCON1
	MOVE.W	D0,BLTCON0
	MOVE.L	D1,BLTCPT
	MOVE.L	D1,BLTDPT
	MOVE.W	#$0050,BLTCMOD
	MOVE.W	#$0050,BLTDMOD
	MOVE.W	#$8000,BLTADAT
	MOVE.W	#$FFFF,BLTAFWM
	MOVE.W	LinMask(PC),BLTBDAT
	ASL.W	#6,D2
	ADDQ.W	#2,D2
	MOVE.W	D2,BLTSIZE
	MOVE.W	#$C000,INTENA
	MOVEM.L (SP)+,D4-D7/A0
DrwLine_rt:
	RTS


Octants:	dc.b	3*4+1,2*4+1,1*4+1,0*4+1,7*4+1,5*4+1,6*4+1,4*4+1
LinMask:	dc.w	$FFFF
MinTerm:	dc.b	$C8,0			;2.1 CA
PenX:		dc.w	0
PenY:		dc.w	0
LineScreen:	dc.l	0

;*****************************
SetLoopSprites:

	MOVEQ	#-1,D6
	MOVEQ	#-1,D7
	MOVE.W	InsNum(PC),D0
	BEQ.B	slsset
	MULU	#30,D0
	MOVE.L	mt_songdataptr(PC),A0
	LEA	12(A0,D0.W),A0
SetLoopSprites2:
	TST.W	SamScrEnable
	BNE.S	slopspr3
	RTS

slopspr3:
	CLR.W	LoopOnOffFlag
	MOVEQ	#-1,D6
	MOVEQ	#-1,D7
	MOVEQ	#0,D0
	MOVE.W	4(A0),D0
	ADD.L	D0,D0
	MOVEQ	#0,D1
	MOVE.W	6(A0),D1
	ADD.L	D1,D1
	MOVE.L	D0,D5
	ADD.L	D1,D5
	CMP.W	#2,D5
	BLS.S	slsset
	MOVE.W	#1,LoopOnOffFlag
	MOVE.L	SamOffSet(PC),D2
	MOVE.L	SamDisplay(PC),D3
	MOVE.L	D2,D4
	ADD.L	D3,D4
	CMP.L	D2,D0
	BCS.S	sgalset
	CMP.L	D4,D0
	BHI.S	sgalset
	SUB.L	D2,D0
	MULU	#314*2+6,D0			;!!!634
	DIVU	D3,D0
	ADDQ.W	#3,D0
	MOVE.W	D0,D6

sgalset:
	CMP.L	D2,D5
	BCS.S	slsset
	CMP.L	D4,D5
	BHI.S	slsset
	SUB.L	D2,D5
	MULU	#314*2+6,D5			;!!!634
	DIVU	D3,D5
	ADDQ.W	#6,D5
	MOVE.W	D5,D7

slsset:
	MOVE	#139,D1
	MOVE.W	D6,D0
	BPL.S	ssdlag
	MOVEQ	#0,D0
	MOVE.W	#270,D1

ssdlag:
	MOVEQ	#64,D2
	LEA	LoopSpriteData1,A0
	MOVE.W	D0,LoopStartPos
	LSR.W	#1,D0
	BSR.W	SetSpritePos
	MOVE.W	#139,D1
	MOVE.W	D7,D0
	BPL.S	ssdlah
	MOVEQ	#0,D0
	MOVE.W	#270,D1 			; 10e

ssdlah:	MOVEQ	#64,D2
	LEA	LoopSpriteData2,A0
	MOVE.W	D0,LoopEndPos
	LSR.W	#1,D0
	;ADDQ.W #1,D0				; fix
	BSR.W	SetSpritePos
	BRA.W  ShowLoopToggle

;--------------------------------------
StealLoopSprit:
	LEA	LoopSpriteData1,A0
	MOVE.W	LoopStartPos(PC),D0
	LSR.W	#1,D0
	ADDQ.W	#1,D0
	TST.W	LoopOnOffFlag
	BNE.S	ssdlai
	MOVEQ	#-$20,D0
ssdlai:
	MOVE.W	#$008B,D1
	MOVEQ	#$40,D2
	BSR.W	SetSpritePos
	LEA	LoopSpriteData2,A0
	MOVE.W	LoopEndPos(PC),D0
	LSR.W	#1,D0
	ADDQ.W	#1,D0
	TST.W	LoopOnOffFlag
	BNE.S	ssdlaf
	MOVEQ	#-$20,D0
ssdlaf:
	MOVE.W	#$008B,D1
	MOVEQ	#$40,D2
	BSR.W	SetSpritePos
	RTS

SamInfoPtr:	dc.l	0
SamInfoLen:	dc.l	0
SampleNote:	dc.w	24			; C-3
ResampleNote:	dc.w	24			; C-3
ModSampleNote	dc.w	24			; C-3
SamIntSave:	dc.w	0
SamDMASave:	dc.w    0


ClearTempSampArea:
	LEA	TempSampArea,A0
	MOVE.W	#$017B,D0
	MOVEQ	#0,D1
.loo:
	MOVE.W	D1,(A0)+
	DBRA	D0,.loo
	RTS

;**********************************
;*   - monitor sampler ---        *
;**********************************

xSampler:
	TST.W	SamScrEnable
	BNE.S	.doit
	RTS

.doit:	CLR.B	RawKeyCode
	MOVE.W	LoopOnOffFlag,-(SP)		; 3.15
	CLR.W	LoopOnOffFlag			; 3.15
	BSR.W	StealLoopSprit			; 3.15
	CALL	StopIt
	CALL	TopExit
	CALL	WaitForButtonUp
	CALL	SetWaitPtrCol
	BSR.W	ShowMon
	CALL	Wait_4000
	BSR.B	ClearTempSampArea
	BSR.W	WaitForDiskDrive
	MOVE.W	INTENAR,SamIntSave
	MOVE.W	#$7FFF,INTENA			; custom+intena
	CALL	TurnOffVoices
	MOVE.W	SampleNote,D0
	ASL.W	#1,D0
	LEA	mt_periodtable,A0
	MOVE.W	0(A0,D0.W),D0
	LSR.W	#1,D0
	LEA	BLTDDAT,A0
	LEA	$00AA(A0),A5
	LEA	$00BA(A0),A6
	MOVE.W	D0,$00A6(A0)
	MOVE.W	D0,$00B6(A0)
	MOVEQ	#$20,D0
	MULU	TremoloByte(PC),D0		; 3.15 fix
	ADD.L	#$00000020,D0
	LSR.L	#6,D0
	MOVE.W	D0,$00A8(A0)
	MOVE.W	D0,$00B8(A0)
	MOVEQ	#0,D0
	MOVE.W	D0,(A5)
	MOVE.W	D0,(A6)
	MOVE.B	#6,$BFD200
	MOVEQ	#2,D0
	MOVE.B	D0,$BFD000
	MOVE.B	#0,$BFE301
	LEA	GraphOffsets(PC),A0
	LEA	TempSampArea,A1
	MOVE.L	TextBplPtr,A2
	LEA	$321E(A2),A2
	LEA	$00BFE101,A3			; custom+intreqr
	LEA	INTREQR,A4
	MOVE.W	#$0180,D7
	MOVEQ	#6,D6
	MOVEQ	#10,D3
.lop1:
	MOVEQ	#$16,D5
.lop2:
	MOVEQ	#7,D4
.lop3:
	BTST	D7,(A4)
	BEQ.S	.lop3

	MOVE.W	D7,$007E(A4)
	MOVEQ	#0,D0
	MOVE.B	(A3),D0
	MOVE.W	D0,D1
	SUB.B	D7,D0
	MOVE.B	D0,(A5)
	MOVE.B	D0,(A6)
	LSR.W	#3,D1
	ADD.W	D1,D1
	MOVE.W	0(A0,D1.W),D0
	MOVE.W	(A1),D1
	MOVE.W	D0,(A1)+
	BCLR	D4,0(A2,D1.W)
	BSET	D4,0(A2,D0.W)
	DBRA	D4,.lop3

	ADDQ.L	#1,A2
	DBRA	D5,.lop2

	SUB.L	#$00000017,A2
	SUB.L	#$00000170,A1
	BTST	D6,-$0100(A3)
	BEQ.W	sampexit
	BTST	D3,-8(A4)
	BNE.S	.lop1

	MOVE.W	InsNum(PC),D1
	BEQ.W	sampexit

	LSL.W	#2,D1
	LEA	mt_songdataptr(pc),A0
	MOVE.L	0(A0,D1.W),D0

	BEQ.S	.l1
	CLR.L	0(A0,D1.W)
	MOVE.L	D0,A1
	MOVE.L	$7C(A0,D1.W),D0
	BEQ.S	.l1

	CLR.L	$7C(A0,D1.W)
	MOVE.L	4.w,a6
	CALLSYS	FreeMem

.l1:	move.l	#MaxSamLen,D6

.lop4:	MOVE.L	D6,D0
	MOVE.L	XDmaType,D1
	MOVE.L	4.w,a6
	CALLSYS	AllocMem
	TST.L	D0
	BNE.S	.l2

	SUB.L	#2048,D6			; try 2k less
	BPL.S	.lop4

	CALL	OutOfMemErr
	BRA.W	sampexit

.l2:
	MOVE.W	InsNum(PC),D1
	LSL.W	#2,D1
	LEA	mt_songdataptr(PC),A0
	MOVE.L	D0,0(A0,D1.W)

	MOVE.L	D6,$007C(A0,D1.W)
	MOVE.W	DMACONR,SamDMASave
	MOVE.W	#$03FF,DMACON
	BSR.W	GetSampleInfo
	MOVE.L	SamInfoLen,D4
	MOVE.W	#0,BPLCON0
	MOVE.W	#$555,COLOR			; Sampler Color
	MOVE.L	SamInfoPtr,A1
	LEA	INTREQ,A2
	LEA	$BFE101,A3
	LEA	INTREQR,A4
	LEA	AUD1DAT,A6

	MOVE.W	#$0180,D7
	MOVEQ	#6,D6
	MOVEQ	#0,D5
samploop:
	BTST	D7,(A4)
	BEQ.S	samploop

	MOVE.W	D7,(A2)
	MOVE.B	(A3),D0
	SUB.B	D7,D0
	MOVE.B	D0,(A5)
	MOVE.B	D0,(A6)
	MOVE.B	D0,(A1)+
	ADDQ.W	#1,D5
	CMP.W	D4,D5
	BEQ.S	sampend
	BTST	D6,-$0100(A3)
	BNE.S	samploop
sampend:
	MOVE.W	SamDMASave,D0
	OR.W	#$8000,D0
	MOVE.W	D0,DMACON

	MOVE.L	A1,D0
	SUB.L	SamInfoPtr(PC),D0
	MOVE.L	D0,SamInfoLen

	MOVE.L	mt_songdataptr(PC),A0
	MOVE.W	InsNum(PC),D1
	MULU.W	#30,D1
	LEA	12(A0,D1.W),A0
	MOVE.L	SamInfoLen(PC),D0
	LSR.L	#1,D0
	MOVE.W	D0,(A0)+
	MOVE.W	#64,(A0)+
	CLR.W	(A0)+
	MOVE.W	#1,(A0)

	MOVE.L	SamInfoLen(PC),D1
	NEG.L	D1
	AND.L	#$FFFFFFF8,D1
	NEG.L	D1
	MOVE.W	InsNum(PC),D0
	ASL.W	#2,D0
	LEA	mt_songdataptr(pc),A0
	CMP.L	$7C(A0,D0.W),D1
	BGE.S	sampexit

	MOVE.L	$7C(A0,D0.W),D2
	MOVE.L	D1,$007C(A0,D0.W)
	SUB.L	D1,D2
	MOVE.L	0(A0,D0.W),A1
	MOVE.L	$7C(A0,D0.W),D0
	ADD.L	D0,A1
	MOVE.L	D2,D0
	MOVE.L	4.w,a6
	CALLSYS	FreeMem
sampexit:
	MOVE.W	SamIntSave,D0
	BSET	#15,D0
	MOVE.W	D0,INTENA
	CALL	TurnOffVoices
	CALL	DisplayMainScreen
	BSR.W	samp315_ex
	BSR.W	ClearSamStarts
	CLR	mt_keybufpos
	CLR.B	RawKeyCode
	CLR.B	ShiftKeyStatus
	MOVE.W	(SP)+,LoopOnOffFlag
	BSR.W	StealLoopSprit
	BSR.W	ShowSampleInfo
	BSR.W	RedrawSample
	CALL	WaitForButtonUp
	GOTO	Wait_4000


;**** for xSampler ****

GetSampleInfo:
	MOVE.W	InsNum(PC),D0
	BEQ.S	SampleNullInfo
	LSL.W	#2,D0
	LEA	mt_songdataptr(PC),A0
	MOVE.L	0(A0,D0.W),SamInfoPtr
	MOVE.L	$7C(A0,D0.W),SamInfoLen
	MOVEQ	#0,D0
	RTS

;--- error ---
SampleNullInfo:
	CLR.L	SamInfoPtr
	CLR.L	SamInfoLen
	MOVEQ	#-1,D0
	RTS

;***********************************
ShowMon:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#$00E8,D0
	MOVE.W	#$0090,D1
	LEA	SampleMonGadGFX,A0
	CALL	BlitAllBasic
	MOVE.W	#$00E8,D0
	MOVE.W	#$0090,D1
	MOVE.W	#$01B0,D2
	MOVE.W	#$00C7,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox			; clears monitor area
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

samp315_ex:

	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#$00E8,D0
	MOVE.W	#$0090,D1
	LEA	SampClrGFX,A0
	CALL	BlitAllBasic
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*********************************
;* Waits for Diskdrive ready     *
;*********************************

WaitForDiskDrive:
	CALL	StorePtrCol
	MOVE.L	4.w,a6
	SUB.L	A1,A1			;(Taskname in A1)
	CALLSYS	FindTask
	MOVE.L	D0,TaskAddr		;prfen
	LEA	TrackDiskPort,A1
	CALLSYS	AddPort
	MOVE.L	4.w,a6
	LEA	TrackDiskIORequest,A1
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	LEA	TrackDiskName,A0
	CALLSYS	OpenDevice
	LEA	wfordiskA(PC),A0
	LEA	TrackDiskIORequest,A1
	MOVE.L	$14(A1),A2
	MOVE.L	A2,wfordiskB
	LEA	$24(A2),A2
	MOVEQ	#3,D1
.lop:
	MOVE.L	(A2)+,(A0)+
	DBRA	D1,.lop

	MOVEQ	#0,D0
	LEA	wfordiskA(PC),A4
	MOVE.L	(A4)+,A0
	MOVE.L	(A4)+,A1
	MOVE.L	(A4)+,A2
	MOVE.L	(A4)+,A3

	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	SetDiskPtrCol
	MOVEM.L (SP)+,D0-D7/A0-A6

.loop:	CMP.L	#0,A0
	BEQ.S	.l1
	MOVE.B	$22(A0),D0

.l1:	CMP.L	#0,A1
	BEQ.S	.l2
	OR.B	$22(A1),D0
.l2:
	CMP.L	#0,A2
	BEQ.S	.l3
	OR.B	$22(A2),D0

.l3:	CMP.L	#0,A3
	BEQ.S	.l4
	OR.B	$22(A3),D0

.l4:	TST.B	D0
	BNE.S	.loop

	LEA	TrackDiskIORequest,A1
	CALLSYS	CloseDevice
	LEA	TrackDiskPort,A1
	CALLSYS	RemPort
	CALL	RestorePtrCol
	RTS

wfordiskB:	dc.l	0
wfordiskA:	dc.l	0,0,0,0

;*********************************

ClearSamStarts:
	LEA	mt_samplestarts,A0
	MOVEQ	#MaxInsNum-1,D0

.loop:	MOVE.L	(A0)+,D1
	BEQ.S	.l0

	MOVE.L	D1,A1
	CLR.W	(A1)

.l0:	DBRA	D0,.loop
	RTS

;******************************
GraphOffsets:
	dc.l	$09B00960,$091008C0,$08700820,$07D00780,$073006E0
	dc.l	$06900640,$05F005A0,$05500500,$04B00460,$041003C0
	dc.l	$03700320,$02D00280,$023001E0,$01900140,$00F000A0
	dc.l	$00500000

SamNotetype:
	dc.w	0

;******************************
ShowSamNote:
	TST.W	SamScrEnable
	BNE.S	.doit
	RTS

.doit:	MOVE.L	NoteNamesPtr,A4
	MOVE.W	#$4A3E,TextOffset
	MOVE.W	SampleNote,D0
	LSL.W	#2,D0
	LEA	0(A4,D0.W),A0
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#4,TextLength
	BRA.W	ShowText

;*******************************
ShowResamNote:
	TST.W	SamScrEnable
	BNE.S	.doit
	RTS

.doit:	MOVE.L	NoteNamesPtr,A4
	MOVE.W	#$4DAE,TextOffset
	MOVE.W	ResampleNote,D0
	LSL.W	#2,D0
	LEA	0(A4,D0.W),A0
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#4,TextLength
	BRA.W	ShowText

Allchantempis:
	dc.l	audchan1temp
	dc.l	audchan2temp
	dc.l	audchan3temp
	dc.l	audchan4temp
	;dc.l	audchan5temp
	;dc.l	audchan6temp
	;dc.l	audchan7temp
	;dc.l	audchan8temp

;*******************************
;* the sound output routines   *
;*******************************
mt_music:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.S	.domusic
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

.domusic:
	BTST	#3,Packetfield
	BEQ.S	mt_musicsoft
	LEA	VBISoftIntStore,A1
	MOVE.L	4.w,a6
	JMP	_LVOCause(A6)			;software-interrupt, name in A1

mt_musicsoft:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.L	RunMode(PC),D0
	BEQ.W	mt_nonewposyet
	CMP.L	#'patt',D0 			; patternplay?
	BEQ.S	.s1				; no
	MOVE.L	mt_songpos(PC),playpos

.s1:
	MOVE.L	mt_songdataptr(PC),A0
	MOVE.B	sd_numofpatt(A0),TremBit	; realaudio scope+vumeter
	TST.W	StepPlayEnable
	BNE.S	.s2
	ADDQ.L	#1,mt_counter			; stepplay
	MOVE.L	mt_counter(PC),D0
	CMP.L	mt_speed(PC),D0
	BCS.S	NoNewNote
.s2:
	CLR.L	mt_counter
	;CALL	DMAWaitLoop
	TST.B	mt_pattdeltime2
	BEQ	GetNewNote
	BSR.S	NoNewAllChannels
	BRA	dskip

NoNewNote:
	BSR.S	NoNewAllChannels
	BRA	mt_nonewposyet

NoNewAllChannels:

	LEA	audchan1temp,A6
	LEA	AUD0,A5
	MOVEQ	#4-1,D7

nnewch4l:
	MOVEM.L D7,-(SP)
	BSR	CheckEffects
	MOVEM.L (SP)+,D7
	LEA	$0010(A5),A5
	LEA	$0058(A6),A6
	DBRA	D7,nnewch4l
	RTS
;*******************************
MyTiming:
	TST.B	$002C(A6)			; empty sample ?
	BEQ.S	.l1
	RTS

.l1:	TST.B	$0036(A6)
	BNE.S	.l2

	MOVEQ	#0,D0
	MOVE.B	$0013(A6),D0
	MULU	$0014(A6),D0

	ADD.W	#$0020,D0
	LSR.W	#6,D0
	MOVE.W	D0,8(A5)
	RTS

.l2:	MOVEQ	#0,D0
	MOVE.B	$0013(A6),D0
	MULU	$0014(A6),D0
	ADD.W	#$0020,D0
	LSR.W	#6,D0
	MOVE.W	D0,$004C(A6)
	MOVE.W	D2,-(SP)
	MOVE.W	$0048(A6),D2
	BNE.S	.l3
	MOVEQ	#0,D0
	BRA.S	.l4

.l3:	MULU	D2,D0
	ADD.W	#$0020,D0
	LSR.W	#6,D0
	BNE.S	.l4
	MOVEQ	#1,D0

.l4:	MOVE.W	D0,8(A5)
	MOVE.W	(SP)+,D2
	RTS

;*****************************
GetNewNote:
	LEA	12(A0),A3
	LEA	sd_pattpos(A0),A2
	LEA	sd_patterndata(A0),A0
	MOVEQ	#0,D1
	MOVE.L	mt_songpos(PC),D0
	MOVE.B	0(A2,D0.W),D1
	CMP.L	#'patt',RunMode
	BNE.S	gnnoa				; patternplay?
	MOVE.L	PatternNumber(PC),D1
gnnoa:
	ASL.L	#8,D1				;*1024
	ASL.L	#2,D1
	chn8test
	BNE.S	.chn4_1
	ASL.L	#1,D1
.chn4_1:
	ADD.L	mt_patternpos(PC),D1
	;MOVE.L	D1,PatternPtr			;useless ?

	moveq	#3,d7				;channels-1

	LEA	AUD0,A5
	LEA	audchan1temp,A6
bgaloo:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.S	PlayVoice
	BSR.W	MyTiming
	MOVEM.L (SP)+,D0-D7/A0-A6
	LEA	$0010(A5),A5
	LEA	$0058(A6),A6
	ADDQ.L	#4,D1				;next channel for playvoice
	DBRA	D7,bgaloo

	BRA.W	dskip

;***********************************
CheckMetronome:

	ADDQ.B	#1,D2
	CMP.B	MetroChannel,D2
	BEQ.S	.l1
	RTS

.l1:	MOVE.B	MetroSpeed,D2
	BNE.S	.l2
	RTS

.l2:	AND.W	#$00FF,D2
	MOVE.L	mt_patternpos,D3
	LSR.L	#4,D3

	chn8test
	BNE.S	.chn4
	LSR.L	#1,D3
.chn4:
	DIVU	D2,D3
	SWAP	D3
	TST.W	D3
	BEQ.S	.l3
	RTS

.l3:	AND.L	#$00000FFF,(A6)
	OR.L	#$10D6F000,(A6) 	; play sample $1F at period $0D6 (214)
	RTS
;******************************
;* playvoice routine          *
;******************************
PlayVoice:
	MOVE.B	$002C(A6),D5		; actual sample startaddress
	BNE.S	.doit			; no zero ?

	TST.L	(A6)
	BNE.S	plvskip

.doit:
	BSR	PerNop			; get actual note
	TST.B	D5
	BEQ.S	plvskip
	BSR.S	CheckMetronome
	RTS

plvskip:
	MOVE.L	(A0,D1.L),(A6)		;read one track from pattern
	BSR.S	CheckMetronome
	MOVEQ	#0,D2				;clear D2
	MOVE.B	n_cmd(A6),D2			;get lower 4 bits of instrument
	AND.B	#$F0,D2
	LSR.B	#4,D2
	MOVE.B	(A6),D0 			;get higher 4 bits of instrument
	AND.B	#$F0,D0
	OR.B	D0,D2
	TST.B	D2
	BEQ	SetRegisters			;instrument was zero

	MOVEQ	#0,D3
	LEA	mt_samplestarts(PC),A1
	MOVE.L	mt_mxbuf4base,D4		;changed for mastervolume
	BTST	D2,D4
	SNE	$0036(A6)
	MOVE.W	D2,D4
	MOVE.B	D2,n_samplenum(A6)		;n_samplenum

	SUBQ.L	#1,D2
	LSL.L	#2,D2
	MULU	#30,D4

	MOVE.L	(A1,D2.L),$002E(A6)
	MOVE.L	$002E(A6),n_start(A6)
	MOVE.W	(A3,D4.L),$0032(A6)

	MOVE.L	$0032(A6),n_length(A6)
	MOVE.W	(A3,D4.L),$0028(A6)
	MOVE.B	2(A3,D4.L),n_finetune(A6)

	MOVEQ	#0,D0
	MOVE.B	3(A3,D4.L),D0
	MOVE.B	D0,n_volume(A6)
	MOVEQ	#0,D3
	MOVE.W	4(A3,D4.L),D3			; get repeat

	TST.W	D3
	BEQ.S	NoLoop

	MOVE.L	n_start(A6),D2			;get start
	ASL	#1,D3
	ADD.L	D3,D2				;add repeat
	MOVE.L	D2,n_loopstart(A6)
	MOVE.L	D2,n_wavestart(A6)
	MOVE.W	4(A3,D4.L),D0			;get repeat
	ADD.W	6(A3,D4.L),D0			;add replen
	MOVE.W	D0,n_length(A6)
	MOVE.W	6(A3,D4.L),n_replen(A6)		;save replen
	BRA.S	SetRegisters

NoLoop: MOVE.L	n_start(A6),D2
	ADD.L	D3,D2
	MOVE.L	D2,n_loopstart(A6)
	MOVE.L	D2,n_wavestart(A6)
	MOVE.W	6(A3,D4.L),n_replen(A6)		;save replen

SetRegisters:
	MOVE.W	(A6),D0
	AND.W	#$0FFF,D0
	BEQ	CheckMoreEffects		;if no note ->

	MOVE.W	2(A6),D0
	AND	#$0FF0,D0
	CMP	#$0E50,D0			;finetune?
	BEQ.S	DoSetFineTune

	MOVE.B	2(A6),D0
	AND.B	#$0F,D0
	CMP.B	#3,D0				;toneportamento?
	BNE.B	.doit
	BSR	SetTonePorta
	BRA	CheckMoreEffects

.doit:	CMP.B	#5,D0				;toneportamento + volslide?
	BNE.B	.doit1
	BSR	SetTonePorta
	BRA	CheckMoreEffects

.doit1:	CMP.B	#12,D0				;new in 3.15, mastervolume?
	BNE.B	.doit2
	BSR	VolumeChange
	BRA.B	SetPeriod

.doit2:	CMP.B	#9,D0
	BNE.S	SetPeriod
	BSR	CheckMoreEffects		;sample offset?
	BRA.S	SetPeriod

DoSetFineTune:
	BSR.W	SetFineTune

SetPeriod:
	MOVEM.L D0/D1/A0/A1,-(SP)
	MOVE	(A6),D1
	AND	#$0FFF,D1
	LEA	mt_periodtable(PC),A1
	MOVEQ	#0,D0
	MOVEQ	#$24,D7

.loop:	CMP	(A1,D0.W),D1
	BHS.B	.ftufound
	ADDQ.L	#2,D0
	DBF	D7,.loop

.ftufound:
	MOVEQ	#0,D1

	MOVE.B	n_finetune(A6),D1

	;AND.B	#$0F,D1			;4.01 removed

	MULU	#37*2,D1
	ADD.L	D1,A1
	MOVE.W	(A1,D0.W),n_period(A6)
	MOVEM.L (SP)+,D0/D1/A0/A1

	MOVE	2(A6),D0
	AND	#$0FF0,D0
	CMP	#$0ED0,D0
	BEQ	CheckMoreEffects

	;MOVE	n_dmabit(A6),$DFF096	; V2 code, removed
	BTST	#2,n_wavecontrol(A6)
	BNE.B	vibnoc
	CLR.B	n_vibratopos(A6)
vibnoc:
	BTST	#6,n_wavecontrol(A6)
	BNE.B	trenoc
	CLR.B	n_tremolopos(A6)

trenoc:
	MOVE	n_length(A6),4(A5)	; Set length  reinserted 4.02
	MOVE.L	n_start(A6),(A5)	; Set start   reinserted 4.02
	BNE.B	sdmaskp
	CLR.L	n_loopstart(A6)
	MOVEQ	#1,D0
	MOVE	D0,4(A5)
	MOVE	D0,n_replen(A6)
sdmaskp:
	MOVE	n_period(A6),D0
	MOVE	D0,6(A5)
	;JSR	SpectrumAnalyzer

	TST.B	$0036(A6)
	BEQ.S	SetDMA
	BSR.W	PlayCold
	BRA.W	E_CommandsG

SetDMA:
	MOVEM.L D0/D1/A0,-(SP)
	MOVE.W	ActiveChannels,D0	;%00001111
	MOVE.W	$0056(A6),D1
	BTST	D1,D0
	BEQ.S	.playecom
	ST	$0038(A6)
	CLR.W	$003A(A6)
	CMP.W	#2,8(A6)
	BLS.S	.dma

	TST.L	4(A6)
	BNE.S	.dmado

.dma:	LEA	PTBitMap+ScopeBoxPos,A0
	MOVE.L	A0,4(A6)
	MOVE.L	A0,10(A6)
	MOVE.W	#$0010,14(A6)
	MOVE.W	#$0010,8(A6)

.dmado:	LEA	BLTDDAT,A0
	MOVE.W	$0052(A6),$009A(A0)
	MOVE.W	$0052(A6),$009C(A0)
	MOVE.W	$004E(A6),$0096(A0)

	MOVE.W	#1,6(A5)
	MOVE.W	#0,10(A5)
	MOVE.L	4(A6),0(A5)
	MOVE.W	8(A6),4(A5)
	MOVE.W	$0054(A6),$009A(A0)
	ST	$002A(A6)
.playecom:
	MOVEM.L (SP)+,D0/D1/A0
	BRA	E_CommandsG

;*********************************
;* Alternative SetDMA routine,   *
;*********************************

;	MOVEM.L	D0/D1,-(SP)
;	MOVE.L	PTBitMap+ScopeBoxPos,0(A5)
;	MOVEQ	#0,D0
;	MOVEQ	#1,D1
;	MOVE.W	D1,4(A5)
;	MOVE.W	D1,6(A5)
;	MOVE.W	D0,8(A5)
;	MOVE.W	D0,10(A5)
;	MOVEM.L	(SP)+,D0/D1
;	RTS

;*********************************
PlayCold:
	MOVEM.L D0-D2/A0/A1,-(SP)
	MOVE.W	#$4000,INTENA
	MOVE.W	ActiveChannels,D1	; %00001111
	MOVE.W	$0056(A6),D0
	BTST	D0,D1
	BEQ	.pcoldend

	MOVEQ	#0,D1
	MOVE.B	$002B(A6),D1
	CALL	mt_nsetplaynote		;play this voice

	MOVEQ	#0,D1
	MOVE.B	$0013(A6),D1
	MULU	TremoloByte,D1
	ADD.W	#$0020,D1
	LSR.W	#6,D1
	MOVE.W	D1,$004C(A6)
	SF	$0038(A6)
	CLR.W	$003A(A6)
	ST	$0036(A6)
	MOVE.L	$003C(A6),A0
	MOVE.L	A0,$0040(A6)
	TST.B	$0020(A6)
	BEQ.S	.l6
	MOVE.L	4(A6),D1
.l2:
	MOVE.L	(A0),D0
	BEQ.S	.l3
	CMP.L	D0,D1
	BLT.S	.l3
	ADDQ.W	#8,A0
	BRA.S	.l2
.l3:
	SUBQ.W	#8,A0
	MOVEQ	#0,D0
	MOVE.L	(A0),D0
	SUB.L	D1,D0
	NEG.L	D0
	LSR.L	#1,D0
	SUB.W	D0,4(A0)
	MOVE.L	D1,(A0)
	MOVE.L	A0,$0040(A6)
	MOVE.W	8(A6),D1
	MOVEQ	#0,D2
.l4:
	TST.L	(A0)
	BEQ.S	.l6
	MOVE.W	4(A0),D0
	ADD.W	D0,D2
	CMP.W	D1,D2
	BCC.S	.l5
	ADDQ.W	#8,A0
	BRA.S	.l4
.l5:
	SUB.W	D1,D2
	SUB.W	D2,D0
	MOVE.W	D0,4(A0)
	CLR.L	8(A0)
.l6:
	MOVE.L	$0040(A6),A1
	LEA	BLTDDAT,A0
	MOVE.W	2(A0),D0
	MOVE.W	$0056(A6),D1
	BTST	D1,D0
	BNE.S	.l7
	MOVE.W	$0052(A6),$009A(A0)
	BRA.S	.l8
.l7:
	MOVE.W	$0052(A6),$009A(A0)
	MOVE.W	$004E(A6),$0096(A0)
	MOVE.W	$0052(A6),$009C(A0)
.l8:
	MOVE.W	#1,6(A5)
	MOVE.L	(A1)+,0(A5)
	MOVE.W	(A1),4(A5)
	BRA.W	.l9			; useless, CRB forgotten
.l9:
	MOVE.W	#0,8(A5)
	MOVE.W	$0054(A6),$009A(A0)
	ST	$002A(A6)

.pcoldend:
	MOVEM.L (SP)+,D0-D2/A0/A1
	MOVE.W	#$C000,INTENA
	RTS

;***********************************
dskip:
	TST.L	RunMode
	BEQ.S	.doit
	CALL	SetPatternPos
.doit:
	MOVE.L	mt_patternpos(PC),D0
	LSR.L	#4,D0

	MOVE.W	D0,ScrPattPos

	moveq	#4,d0
	mulu.w	numchans,d0
	add.l	d0,mt_patternpos

	MOVE.B	mt_pattdeltime,D0
	BEQ.S	.del
	MOVE.B	D0,mt_pattdeltime2
	CLR.B	mt_pattdeltime
.del:
	TST.B	mt_pattdeltime2
	BEQ.S	.del2
	SUBQ.B	#1,mt_pattdeltime2
	BEQ.S	.del2

	moveq	#4,d0
	mulu.w	numchans,d0
	sub.l	d0,mt_patternpos
.del2:
	TST.B	PBreakFlag
	BEQ.S	mnpysk
	SF	PBreakFlag
	MOVEQ	#0,D0
	MOVE.B	mt_pbreakpos(PC),D0
	LSL.W	#4,D0

	MOVE.L	D0,mt_patternpos
	CLR.B	mt_pbreakpos
mnpysk:
	TST.W	StepPlayEnable
	BEQ.S	mnpysk2

;step play
	CALL	DoStopIt
	CLR.W	StepPlayEnable
	MOVE.L	mt_patternpos(PC),D0

	LSR.L	#4,D0
	chn8test
	bne.s	.chn4
	lsr.l	#1,d0
.chn4:
	AND.W	#MaxPattPos,D0
	MOVE.W	D0,ScrPattPos
mnpysk2:
	chn8test
	BEQ.S	.chn8

	CMP.L	#1024,mt_patternpos
	BNE.S	mt_nonewposyet
	BRA.S	mt_nextposition
.chn8:
	CMP.L	#2048,mt_patternpos
	BNE.S	mt_nonewposyet

mt_nextposition:
	MOVEQ	#0,D0
	MOVE.B	mt_pbreakpos(PC),D0
	LSL.W	#4,D0
	MOVE.L	D0,mt_patternpos
	CLR.B	mt_pbreakpos
	CLR.B	mt_posjumpflag
	CMP.L	#'patp',RunMode
	BNE.S	mt_nonewposyet
	ADDQ.L	#1,mt_songpos
	ST	AllowRedrPattPos
	AND.L	#$7F,mt_songpos
	MOVE.L	mt_songpos(PC),D1
	MOVE.L	mt_songdataptr(PC),A0

	CMP.B	sd_numofpatt(A0),D1
	BCS.S	mt_nonewposyet
	CLR.L	mt_songpos
	TST.W	StepPlayEnable
	BEQ.S	mt_nonewposyet

;step play
	CALL	DoStopIt
	CLR.W	StepPlayEnable
	MOVE.L	mt_patternpos(PC),D0
	LSR.L	#4,D0
	MOVE.W	D0,ScrPattPos

mt_nonewposyet:
	TST.B	mt_posjumpflag
	BNE.S	mt_nextposition
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

;*********************************
;* check sound effects 1-9       *
;*********************************
CheckEffects:
	TST.B	$002C(A6)
	BEQ.S	.doit
	RTS

.doit:	BSR.S	.now
	BSR.W	MyTiming
	RTS

.now:
	BSR.W	pt_funkend
	MOVE.W	2(A6),D0
	AND.W	#$0FFF,D0
	BNE.S	.effound
	RTS

.effound:
	MOVE.B	2(A6),D0
	AND.B	#15,D0
	TST.B	D0
	BEQ.S	Arpeggio
	CMP.B	#1,D0
	BEQ.W	PortaUp
	CMP.B	#2,D0
	BEQ.W	PortaDown
	CMP.B	#3,D0
	BEQ.W	TonePortamento
	CMP.B	#4,D0
	BEQ.W	Vibrato
	CMP.B	#5,D0
	BEQ.W	TonePlusVolSlide
	CMP.B	#6,D0
	BEQ.W	VibratoPlusVolSlide
	CMP.B	#14,D0
	BEQ.W	E_Commands
	MOVE.W	n_period(A6),6(A5)
	CMP.B	#7,D0
	BEQ.W	Tremolo
;	cmp.b	#8,d0
;	beq.w	checkneweffects
	CMP.B	#10,D0
	BEQ.W	VolumeSlide
	RTS

PerNop:
	MOVE.W	n_period(A6),6(A5)		; read note from pattern
	RTS

;*********************************
;* Begin of the PT effectcommands*
;*********************************

Arpeggio:
	MOVEQ	#0,D0
	MOVE.L	mt_counter(PC),D0
	DIVS	#3,D0
	SWAP	D0
	CMP.W	#1,D0
	BEQ.S	Arpeggio1
	CMP.W	#2,D0
	BEQ.S	Arpeggio2
	MOVE.W	n_period(A6),D2
	BRA.S	ArpeggioSet

Arpeggio1:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	LSR.B	#4,D0
	BRA.S	ArpeggioFind

Arpeggio2:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
ArpeggioFind:
	ASL.W	#1,D0
	MOVEQ	#0,D1
	MOVE.B	n_finetune(A6),D1
	AND.B	#15,D1			;fix ok
	MULU	#$004A,D1
	LEA	mt_periodtable(PC),A0
	ADD.L	D1,A0
	MOVEQ	#0,D1
	MOVE.W	n_period(A6),D1
	MOVEQ	#$24,D7
arploop:
	MOVE.W	0(A0,D0.W),D2
	CMP.W	(A0),D1
	BCC.S	ArpeggioSet
	ADDQ.L	#2,A0
	DBRA	D7,arploop
	RTS

ArpeggioSet:
	MOVE.W	D2,6(A5)
	RTS

;*********************************

FinePortaUp:
	TST.L	mt_counter
	BEQ.S	FinePortaUp2
	RTS

FinePortaUp2:
	MOVE.B	#15,LowMask
PortaUp:
	MOVEQ	#0,D0
	MOVE.B	3(A6),D0
	AND.B	LowMask,D0
	MOVE.B	#$FF,LowMask
	SUB.W	D0,n_period(A6)
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	CMP.W	#$0071,D0
	BPL.S	PortaUskip
	AND.W	#$F000,n_period(A6)
	OR.W	#$0071,n_period(A6)
PortaUskip:
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	MOVE.W	D0,6(A5)
	RTS

;*********************************

FinePortaDown:
	TST.L	mt_counter
	BEQ.S	FinePortaDown2
	RTS

FinePortaDown2:
	MOVE.B	#15,LowMask
PortaDown:
	CLR.W	D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	LowMask,D0
	MOVE.B	#$FF,LowMask
	ADD.W	D0,n_period(A6)
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	CMP.W	#$0358,D0
	BMI.S	PortaDskip
	AND.W	#$F000,n_period(A6)
	OR.W	#$0358,n_period(A6)
PortaDskip:
	MOVE.W	n_period(A6),D0
	AND.W	#$0FFF,D0
	MOVE.W	D0,6(A5)
	RTS

;*********************************

SetTonePorta:
	MOVE.L	A0,-(SP)
	MOVE.W	(A6),D2
	AND.W	#$0FFF,D2
	MOVEQ	#0,D0
	MOVE.B	n_finetune(A6),D0
	AND.B	#15,D0
	MULU	#$004A,D0
	LEA	mt_periodtable(PC),A0
	ADD.L	D0,A0
	MOVEQ	#0,D0
StpLoop:
	CMP.W	0(A0,D0.W),D2
	BCC.S	StpFound
	ADDQ.W	#2,D0
	CMP.W	#$004A,D0
	BCS.S	StpLoop
	MOVEQ	#$46,D0
StpFound:
	MOVE.B	n_finetune(A6),D2
	AND.B	#8,D2
	BEQ.S	StpGoss
	TST.W	D0
	BEQ.S	StpGoss
	SUBQ.W	#2,D0
StpGoss:
	MOVE.W	0(A0,D0.W),D2
	MOVE.L	(SP)+,A0
	MOVE.W	D2,n_wantedperiod(A6)
	MOVE.W	n_period(A6),D0
	CLR.B	n_toneportdirec(A6)
	CMP.W	D0,D2
	BEQ.S	ClearTonePorta
	BLT.S	StpGoss_ret
	RTS

StpGoss_ret:
	MOVE.B	#1,n_toneportdirec(A6)
	RTS

ClearTonePorta:
	CLR.W	n_wantedperiod(A6)
	RTS

TonePortamento:
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	TonePortNoChange
	MOVE.B	D0,n_toneportspeed(A6)
	CLR.B	n_cmdlo(A6)
TonePortNoChange:
	TST.W	n_wantedperiod(A6)
	BNE.S	tpnochg2
	RTS

tpnochg2:
	MOVEQ	#0,D0
	MOVE.B	n_toneportspeed(A6),D0
	TST.B	n_toneportdirec(A6)
	BNE.S	TonePortaUp

	ADD.W	D0,n_period(A6)
	MOVE.W	n_wantedperiod(A6),D0
	CMP.W	n_period(A6),D0
	BGT.S	TonePortaSetPer
	MOVE.W	n_wantedperiod(A6),n_period(A6)
	CLR.W	n_wantedperiod(A6)
	BRA.S	TonePortaSetPer

TonePortaUp:
	SUB.W	D0,n_period(A6)
	MOVE.W	n_wantedperiod(A6),D0
	CMP.W	n_period(A6),D0
	BLT.S	TonePortaSetPer
	MOVE.W	n_wantedperiod(A6),n_period(A6)
	CLR.W	n_wantedperiod(A6)
TonePortaSetPer:
	MOVE.W	n_period(A6),D2
	MOVE.B	n_glissfunk(A6),D0
	AND.B	#15,D0
	BEQ.S	GlissSkip
	MOVEQ	#0,D0
	MOVE.B	n_finetune(A6),D0
	AND.B	#15,D0
	MULU	#$004A,D0
	LEA	mt_periodtable(PC),A0
	ADD.L	D0,A0
	MOVEQ	#0,D0
GlissLoop:
	CMP.W	0(A0,D0.W),D2
	BCC.S	GlissFound
	ADDQ.W	#2,D0
	CMP.W	#$004A,D0
	BCS.S	GlissLoop
	MOVEQ	#$46,D0
GlissFound:
	MOVE.W	0(A0,D0.W),D2
GlissSkip:
	MOVE.W	D2,6(A5)			; set period
	RTS

Vibrato:
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	Vibrato2
	MOVE.B	n_vibratocmd(A6),D2
	AND.B	#15,D0
	BEQ.S	vibskip
	AND.B	#$F0,D2
	OR.B	D0,D2
vibskip:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	BEQ.S	vibskip2
	AND.B	#15,D2
	OR.B	D0,D2
vibskip2:
	MOVE.B	D2,n_vibratocmd(A6)
Vibrato2:
	MOVE.L	A4,-(SP)
	MOVE.B	n_vibratopos(A6),D0
	LEA	mt_vibratotable(PC),A4
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	n_wavecontrol(A6),D2
	AND.B	#3,D2
	BEQ.S	vib_sine
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	vib_rampdown
	MOVE.B	#255,D2
	BRA.S	vib_set

vib_rampdown:
	TST.B	n_vibratopos(A6)
	BPL.S	vib_rampdown2
	MOVE.B	#$FF,D2
	SUB.B	D0,D2
	BRA.S	vib_set

vib_rampdown2:
	MOVE.B	D0,D2
	BRA.S	vib_set

vib_sine:
	MOVE.B	0(A4,D0.W),D2
vib_set:
	MOVE.B	n_vibratocmd(A6),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#7,D2
	MOVE.W	n_period(A6),D0
	TST.B	n_vibratopos(A6)
	BMI.S	VibratoNeg
	ADD.W	D2,D0
	BRA.S	Vibrato3

VibratoNeg:
	SUB.W	D2,D0
Vibrato3:
	MOVE.W	D0,6(A5)
	MOVE.B	n_vibratocmd(A6),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,n_vibratopos(A6)
	MOVE.L	(SP)+,A4
	RTS

TonePlusVolSlide:
	BSR.W	TonePortNoChange
	BRA.W	VolumeSlide

VibratoPlusVolSlide:
	BSR.B	Vibrato2
	BRA.W	VolumeSlide

;----------------------

Tremolo:
	MOVE.L	A4,-(SP)
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	Tremolo2
	MOVE.B	n_tremolocmd(A6),D2
	AND.B	#15,D0
	BEQ.S	treskip
	AND.B	#$F0,D2
	OR.B	D0,D2
treskip:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#$F0,D0
	BEQ.S	treskip2
	AND.B	#15,D2
	OR.B	D0,D2
treskip2:
	MOVE.B	D2,n_tremolocmd(A6)
Tremolo2:
	MOVE.B	n_tremolopos(A6),D0
	LEA	mt_vibratotable(PC),A4
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	n_wavecontrol(A6),D2
	LSR.B	#4,D2
	AND.B	#3,D2
	BEQ.S	tre_sine
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	tre_rampdown
	MOVE.B	#$FF,D2
	BRA.S	tre_set

tre_rampdown:
	TST.B	n_vibratopos(A6)
	BPL.S	tre_rampdown2
	MOVE.B	#$FF,D2
	SUB.B	D0,D2
	BRA.S	tre_set

tre_rampdown2:
	MOVE.B	D0,D2
	BRA.S	tre_set

tre_sine:
	MOVE.B	0(A4,D0.W),D2
tre_set:
	MOVE.B	n_tremolocmd(A6),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#6,D2
	MOVEQ	#0,D0
	MOVE.B	n_volume(A6),D0
	TST.B	n_tremolopos(A6)
	BMI.S	TremoloNeg
	ADD.W	D2,D0
	BRA.S	Tremolo3

TremoloNeg:
	SUB.W	D2,D0
Tremolo3:
	BPL.S	TremoloSkip
	CLR.W	D0
TremoloSkip:
	CMP.W	#$0040,D0
	BLS.S	TremoloOk
	MOVE.W	#$0040,D0
TremoloOk:
	MULU	TremoloByte(PC),D0		; new in 3.0
	ADD.L	#$00000020,D0
	LSR.L	#6,D0

	MOVE.W	D0,8(A5)
	MOVE.B	n_tremolocmd(A6),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,n_tremolopos(A6)
	MOVE.L	(SP)+,A4
	ADDQ.L	#4,SP
	RTS

SampleOffsets:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	BEQ.S	sononew
	MOVE.B	D0,n_sampleoffset(A6)
sononew:
	MOVE.B	n_sampleoffset(A6),D0
	LSL.L	#7,D0
	CMP	n_length(A6),D0		; sampleoffset longer than sample?
	BGE.B	sofskip

	;MOVE.W	$32(A6),D1		; new in 3.0
	;SUB.W	D0,D1


	;MOVE.W	D1,8(A6)		;n_length
	;ADD.L	D0,D0
	;ADD.L	$2E(A6),D0
	;MOVE.L	D0,4(A6)		;n_start
	;RTS

	sub	d0,n_length(A6)		; re-inserted old V2 routine
	lsl	#1,d0
	add.l	d0,n_start(a6)
	rts


;sampleoffset longer than sample, skip

sofskip:
	MOVE	#$0001,n_length(A6)	; fix 4.0 Alpha 6, high beeps otherwise
	RTS

VolumeSlide:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	LSR.B	#4,D0
	TST.B	D0
	BEQ.S	VolSlDo
VolSlideUp:
	ADD.B	D0,n_volume(A6)
	CMP.B	#$40,$0013(A6)
	BMI.S	VolSlOki
	MOVE.B	#$40,n_volume(A6)
VolSlOki:
	MOVE.B	n_volume(A6),D0
	RTS

VolSlDo:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
VolSlideDown2:
	SUB.B	D0,n_volume(A6)
	BPL.S	VolSlskip
	CLR.B	n_volume(A6)
VolSlskip:
	MOVE.B	n_volume(A6),D0
	RTS

PositionJump:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	SUBQ.B	#1,D0
	MOVE.L	D0,mt_songpos
pj2:
	CLR.B	mt_pbreakpos
	ST	mt_posjumpflag
	RTS

VolumeChange:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	CMP.B	#$40,D0
	BLS.S	VolumeOk
	MOVEQ	#$40,D0
VolumeOk:
	MOVE.B	D0,n_volume(A6)
	RTS

PatternBreak:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	MOVE.L	D0,D2
	LSR.B	#4,D0
	MULU	#10,D0
	AND.B	#15,D2
	ADD.B	D2,D0

	chn8test
	BNE.S	.chn4

	LSL.W	#1,D0
	cmp.b	#MaxPattPos*2,d0
	bhi.b	pj2
	bra.s	pj3
.chn4:

	CMP.B	#MaxPattPos,D0
	BHI.B	pj2
pj3:
	MOVE.B	D0,mt_pbreakpos
	ST	mt_posjumpflag
	RTS

SetSpeed:
	MOVE.B	n_cmdlo(A6),D0
	AND.W	#$FF,D0
	BEQ.S	SpeedNull
	BTST	#0,Packetfield			; IntMode
	BEQ.S	normspd 			; VBLANK, standard speed
	CMP.W	#32,D0
	BCS.S	normspd
	MOVE.W	D0,RealTempo
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	SamScrEnable,-(SP)
	ST	SamScrEnable
	ST	UpdateTempo
	CALL	SetTempo
	MOVE.W	(SP)+,SamScrEnable
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

normspd:
	CLR.L	mt_counter
	MOVE.W	D0,mt_speed+2
	RTS

SpeedNull:
	CLR.L	RunMode
	CALL	SetNormalPtrCol
	RTS

;*****************************
;* new 8'er commands         *
;*****************************

;checkneweffects:
;	move.b	n_cmdlo(a6),d0
;	and.b	#$F0,d0
	lsr.b	#4,d0

;	cmp.b	#1,d0
;	beq.s	new1com
;	cmp.b	#2,d0
;	beq.s	new2com
;	cmp.b	#3,d0
;	beq.s	new3com
;	cmp.b	#4,d0
;	beq.s	new4com
;	cmp.b	#5,d0
;	beq.s	new5com
;	cmp.b	#6,d0
;	beq.s	new6com
;	cmp.b	#7,d0
;	beq.b	new7com
;	cmp.b	#8,d0
;	beq.w	new8com
;	cmp.b	#9,d0
;	beq.w	new9com
;	cmp.b	#$A,d0
;	beq.w	newacom
;	cmp.b	#$B,d0
;	beq.w	newbcom
;	cmp.b	#$C,d0
;	beq.w	newccom
;	cmp.b	#$D,d0
;	beq.w	newdcom
;	cmp.b	#$E,d0
;	beq.w	newecom
;	cmp.b	#$F,d0
;	beq.w	newfcom
;	rts
;new1com:
;	MOVE.W  #$f000,COLOR	       ;screen blitz
;	rts

;new2com:
;	MOVE.W  #$fd00,COLOR	       ;screen blitz
;	rts
;new3com:
;	MOVE.W  #$FFA0,COLOR	       ;screen blitz
;	rts
;new4com:
;	MOVE.W  #$FF0A,COLOR	       ;screen blitz
;	rts

;new5com:
;	MOVE.W  #$0FF0,COLOR	       ;screen blitz
;	rts

;new6com:
;	MOVE.W  #$0F0F,COLOR	       ;screen blitz
;	rts
;new7com:
;	MOVE.W  #$00FF,COLOR	       ;screen blitz
;	rts
;new8com:
;	MOVE.W  #$FFF0,COLOR	       ;screen blitz
;	rts
;new9com:
;	MOVE.W  #$AA0A,COLOR	       ;screen blitz
;	rts
;newacom:
;	MOVE.W  #$7777,COLOR	       ;screen blitz
;	rts
;newbcom:
;	MOVE.W  #$1FFD,COLOR	       ;screen blitz
;	rts
;newccom:
;	MOVE.W  #$FF04,COLOR	       ;screen blitz
;	rts
;newdcom:
;	MOVE.W  #$4F4F,COLOR	       ;screen blitz
;	rts
;newecom:
;	MOVE.W  #$F4F4,COLOR	       ;screen blitz
;	rts
;newfcom:
;	MOVE.W  #$FFFF,COLOR	       ;screen blitz
;	rts


;*****************************

CheckMoreEffects:
	MOVE.B	2(A6),D0
	AND.B	#15,D0
	CMP.B	#9,D0
	BEQ	SampleOffsets
	CMP.B	#11,D0
	BEQ	PositionJump
	CMP.B	#13,D0
	BEQ	PatternBreak
	CMP.B	#14,D0
	BEQ.B	E_Commands
	CMP.B	#15,D0
	BEQ	SetSpeed
	CMP.B	#12,D0
	BEQ	VolumeChange
	BRA	PerNop

E_CommandsG:
	MOVE.B	2(A6),D0
	AND.B	#15,D0
	CMP.B	#11,D0
	BEQ.W	PositionJump
	CMP.B	#13,D0
	BEQ.W	PatternBreak
	CMP.B	#14,D0
	BEQ.S	E_Commands
	CMP.B	#15,D0
	BEQ.W	SetSpeed
	RTS

E_Commands:
	MOVE.B	3(A6),D0
	AND.B	#$F0,D0
	LSR.B	#4,D0
	BEQ.S	FilterOnOff
	CMP.B	#1,D0
	BEQ.W	FinePortaUp
	CMP.B	#2,D0
	BEQ.W	FinePortaDown
	CMP.B	#3,D0
	BEQ.B	SetGlissControl
	CMP.B	#4,D0
	BEQ.W	SetVibratoControl
	CMP.B	#5,D0
	BEQ.W	SetFineTune
	CMP.B	#6,D0
	BEQ.W	JumpLoop
	CMP.B	#7,D0
	BEQ.W	SetTremoloControl
	;CMP.B	#8,D0
	;BEQ.W	KarplusStrong
	CMP.B	#14,D0
	BEQ.W	PatternDelay
	CMP.B	#9,D0
	BEQ.W	RetrigNote
	CMP.B	#10,D0
	BEQ.W	VolumeFineUp
	CMP.B	#11,D0
	BEQ.W	VolumeFineDown
	CMP.B	#12,D0
	BEQ.W	NoteCut
	CMP.B	#13,D0
	BEQ.W	NoteDelay
	CMP.B	#15,D0
	BEQ.W	FunkIt
	RTS

FilterOnOff:
	MOVE.B	3(A6),D0
	AND.B	#1,D0
	ASL.B	#1,D0
	AND.B	#$FD,$BFE001
	OR.B	D0,$BFE001
	RTS

SetGlissControl:
	MOVE.B	3(A6),D0
	AND.B	#15,D0
	AND.B	#$F0,n_glissfunk(A6)
	OR.B	D0,n_glissfunk(A6)
	RTS

SetVibratoControl:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	AND.B	#$F0,n_wavecontrol(A6)
	OR.B	D0,n_wavecontrol(A6)
	RTS

SetFineTune:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	MOVE.B	D0,n_finetune(A6)
	RTS

JumpLoop:
	TST.L	mt_counter
	BEQ.S	JumpLoop2
	RTS

JumpLoop2:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	BEQ.S	SetLoop
	TST.B	n_loopcount(A6)
	BEQ.S	jumpcnt
	SUBQ.B	#1,n_loopcount(A6)
	BNE.S	JumpLoop3
	RTS

JumpLoop3:
	MOVE.B	n_pattpos(A6),mt_pbreakpos
	ST	PBreakFlag
	RTS

jumpcnt:
	MOVE.B	D0,n_loopcount(A6)
	BRA.B	JumpLoop3

SetLoop:
	chn8test
	bne.s	jumplo4
	MOVE.L	mt_patternpos,D0
	LSR.L	#4,D0
	AND.B	#MaxPattPos*2,D0
	MOVE.B	D0,n_pattpos(A6)
	RTS

jumplo4:
	MOVE.L	mt_patternpos,D0
	LSR.L	#4,D0
	AND.B	#MaxPattPos,D0
	MOVE.B	D0,n_pattpos(A6)
	RTS

;********************************

SetTremoloControl:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	LSL.B	#4,D0
	AND.B	#15,n_wavecontrol(A6)
	OR.B	D0,n_wavecontrol(A6)
	RTS

;KarplusStrong:
;	MOVEM.L D1/D2/A0/A1,-(SP)
;	MOVE.L	10(A6),A0
;	MOVE.L	A0,A1
;	MOVE.W	14(A6),D0
;	ADD.W	D0,D0
	SUBQ.W	#2,D0
;karplop:
;	MOVE.B	(A0),D1
;	EXT.W	D1
;	MOVE.B	1(A0),D2
;	EXT.W	D2
;	ADD.W	D1,D2
;	ASR.W	#1,D2
;	MOVE.B	D2,(A0)+
;	DBRA	D0,karplop
;	MOVE.B	(A0),D1
;	EXT.W	D1
;	MOVE.B	(A1),D2
;	EXT.W	D2
;	ADD.W	D1,D2
;	ASR.W	#1,D2
;	MOVE.B	D2,(A0)
;	MOVEM.L (SP)+,D1/D2/A0/A1
;	RTS

RetrigNote:
	MOVE.L	D1,-(SP)
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	BEQ.W	rtnend
	MOVE.L	mt_counter,D1
	BNE.S	rtnskp
	MOVE.W	(A6),D1
	AND.W	#$0FFF,D1
	BNE.S	rtnend
	MOVE.L	mt_counter,D1
rtnskp:
	DIVU	D0,D1
	SWAP	D1
	TST.W	D1
	BNE.S	rtnend
DoRetrg:				; rewritten
	TST.B	54(A6)
	BNE.S	lbC016AC6
	MOVE.L	A0,-(SP)
	MOVE.W	ActiveChannels,D0	; %00001111
	MOVE.W	$0056(A6),D1
	BTST	D1,D0
	BEQ.S	rettrigg_rt
	LEA	BLTDDAT,A0
	ST	$0038(A6)
	CLR.W	$003A(A6)
	MOVE.W	2(A0),D0
	BTST	D1,D0
	BNE.S	rettrigg_dmaw
	MOVE.W	$0052(A6),$009A(A0)
	BRA.S	rettrigg_nowa

rettrigg_dmaw:
	MOVE.W	$0052(A6),$009A(A0)
	MOVE.W	$0052(A6),$009C(A0)
	MOVE.W	$004E(A6),$0096(A0)
rettrigg_nowa:
	MOVE.W	#1,6(A5)
	MOVE.L	n_start(A6),n_note(A5)
	MOVE.W	n_length(A6),n_start(A5)
	MOVE.W	$0054(A6),$009A(A0)
	ST	$002A(A6)
rettrigg_rt:
	MOVE.L	(SP)+,A0
	BRA.S	rtnend

lbC016AC6:
	BSR.W	PlayCold
rtnend:
	MOVE.L	(SP)+,D1
	RTS

VolumeFineUp:
	TST.L	mt_counter
	BEQ.S	volfinup2
	RTS

volfinup2:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	BRA.W	VolSlideUp

VolumeFineDown:
	TST.L	mt_counter
	BEQ.S	volfindwn2
	RTS

volfindwn2:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	BRA.W	VolSlideDown2

NoteCut:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	CMP.L	mt_counter,D0
	BEQ.S	ntcut2
	RTS

ntcut2:
	CLR.B	n_volume(A6)
	RTS

NoteDelay:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	CMP.L	mt_counter,D0
	BEQ.S	notdel_ok
	RTS

notdel_ok:
	MOVE.W	(A6),D0
	AND.W	#$0FFF,D0
	BNE.S	notdel_rt
	RTS

notdel_rt:
	MOVE.L	D1,-(SP)
	BRA.W	DoRetrg

PatternDelay:
	TST.L	mt_counter
	BEQ.S	pttdel_ok
	RTS

pttdel_ok:
	MOVEQ	#0,D0
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	TST.B	mt_pattdeltime2
	BEQ.S	pttdel_rt
	RTS

pttdel_rt:
	ADDQ.B	#1,D0
	MOVE.B	D0,mt_pattdeltime
	RTS

FunkIt:
	TST.L	mt_counter
	BEQ.S	funk_ok
	RTS

funk_ok:
	MOVE.B	n_cmdlo(A6),D0
	AND.B	#15,D0
	LSL.B	#4,D0
	AND.B	#15,n_glissfunk(A6)
	OR.B	D0,n_glissfunk(A6)
	TST.B	D0
	BNE.S	pt_funkend
	RTS

pt_funkend:
	MOVEM.L D1/A0,-(SP)
	MOVEQ	#0,D0
	MOVE.B	n_glissfunk(A6),D0
	LSR.B	#4,D0
	BEQ.S	updfu_rt
	LEA	mt_funktable(PC),A0
	MOVE.B	0(A0,D0.W),D0
	ADD.B	D0,$0023(A6)
	BTST	#7,$0023(A6)
	BEQ.S	updfu_rt
	CLR.B	$0023(A6)
	MOVE.L	n_loopstart(A6),D0
	MOVEQ	#0,D1
	MOVE.W	n_replen(A6),D1
	ADD.L	D1,D0
	ADD.L	D1,D0
	MOVE.L	n_wavestart(A6),A0
	ADDQ.L	#1,A0
	CMP.L	D0,A0
	BCS.S	updfu_st
	MOVE.L	10(A6),A0
updfu_st:
	MOVE.L	A0,n_wavestart(A6)
	MOVEQ	#-1,D0
	SUB.B	(A0),D0
	MOVE.B	D0,(A0)
updfu_rt:
	MOVEM.L (SP)+,D1/A0
	RTS

;***********************************
;* infoscreen                      *
;***********************************

InfoScreen:
	CMP.W	#8,CurrScreen
	BEQ.B	Info_Exit

	CALL	TopExit 			; included
	CALL	WaitForButtonUp
	MOVE.W	#8,CurrScreen
	ST	ScopeEnable
	ST	NoSampleInfo
	BSR.B	SwapInfoScreen
	BEQ.B	Info_Exit

Info_Refresh2:
	CALL	Clear120Lines
	CALL	SetNormalPtrCol
	BSR.W	ShowInfos
	BSR.W	rd_updinfolist			; scroller
	RTS

Info_Exit:
	CLR.W	DProp_X
	MOVE.W	#$0053,DProp_Y
	MOVE.B	#$F8,EmptySprite+1

	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3
;	CMP.W	#$FFFF,scrtablecl

	CALL	WaitForButtonUp
	BSR.S	SwapInfoScreen
	CALL	Clear120Lines

;	BSR.W	TopExit 			; useless
	GOTO	DisplayMainAll

SwapInfoScreen:
	lea	InfoGFXData,a0
	CALL	UpperDecrunch
	moveq	#-1,d0
	rts

CheckInfoGadgs:
	MOVEM.W (MouseX2),D0/D1
	LEA	InfoGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.W	infmend
	CMP.W	#01,D2
	BEQ.B	Info_Exit
	CMP.W	#02,D2
	BEQ.W	ToggleInfos
	CMP.W	#03,D2
	beq.w	xScreenSwitch
	cmp.w	#4,d2
	beq.w	Info_Exit
	cmp.w	#5,d2
	beq.w	ToggleInfosDown
	cmp.w	#6,d2
	beq.w	ToggleInfosUp
	cmp.w	#7,d2
	beq.w	InfoPropScroller

	CMP.W	#$10,D2
	beq.w	EnterSam1
	CMP.W	#$11,D2
	beq.w	EnterSam2
	CMP.W	#$12,D2
	beq.w	EnterSam3
	CMP.W	#$13,D2
	beq.w	EnterSam4
	CMP.W	#$14,D2
	beq.w	EnterSam5
	CMP.W	#$15,D2
	beq.w	EnterSam6
	CMP.W	#$16,D2
	beq.w	EnterSam7
	CMP.W	#$17,D2
	beq.w	EnterSam8
	CMP.W	#$18,D2
	beq.w	EnterSam9
	CMP.W	#$19,D2
	beq.w	EnterSamA
	CMP.W	#$1A,D2
	beq.w	EnterSamB
	CMP.W	#$1B,D2
	beq.w	EnterSamC
	CMP.W	#$1C,D2
	beq.w	EnterSamD
	CMP.W	#$1D,D2
	beq.w	EnterSamE
	CMP.W	#$1E,D2
	beq.w	EnterSamF
	CMP.W	#$1F,D2
	beq.w	EnterSam10

infmend:
	RTS

ShowInfos:
	MOVE.L	#0,InfoSamData
	MOVE.W	#0,InfoSamUse
	BSR.W	CalTime

;-------------------- Mod name ---------------

sstinfo2:
	lea	fo_songname,a1
	cmp.l	#'UNNA',(A1)
	bne.s	fonameno

	;btst	#1,CfgFlag
	;beq.b	highok15
	;bset	#1,CfgStore			; mem
	;bclr	#1,CfgFlag			; lower chars

highok15:

	MOVE.L	mt_songdataptr(PC),ShowTextPtr
	MOVE.W	#14+14*80,TextOffset
	MOVE.W	#$14,TextLength
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText			; author
	MOVEM.L (SP)+,D0-D7/A0-A6

	;btst	#1,CfgStore
	;beq.s	highok16
	;bset	#1,CfgFlag

highok16:

	bra.s	fonameyes
fonameno:
	;btst	#1,CfgFlag
	;beq.b	highok17
	;bset	#1,CfgStore			; mem
	;bclr	#1,CfgFlag			; lower chars
highok17:

	MOVE.L	#fo_songname,ShowTextPtr
	MOVE.W	#14+14*80,TextOffset
	MOVE.W	#$14,TextLength
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText			; songname
	MOVEM.L (SP)+,D0-D7/A0-A6

	;btst	#1,CfgStore
	;beq.s	highok18
	;bset	#1,CfgFlag

highok18:

fonameyes:

	BSR.W	InfoViewPos2
	MOVE.W	#14+36*80,TextOffset

;hours
	LEA	Timer,A1
	MOVE.L	(A1),D0
	MOVE.W	D0,WordNumber
	CALL	Print2DecDigits
	ADDQ.W	#4,TextOffset

;minutes
	LEA	Timer,A1
	MOVE.L	4(A1),D0
	MOVE.W	D0,WordNumber
	CALL	Print2DecDigits
	ADDQ.W	#4,TextOffset


;seconds
	LEA	Timer,A1
	MOVE.L	8(A1),D0
	MOVE.W	D0,WordNumber
	CALL	Print2DecDigits
	ADDQ.W	#4,TextOffset
;milliseconds
	LEA Timer,A1
	MOVE.L	12(A1),D0
	MOVE.W	D0,WordNumber
	CALL	Print2DecDigits

;------- sample infos 1-32 ----
ShowInfos2:
	MOVE.W	#41+12*80,A3			; textoffset
	MOVE.L	#0,InfoSamData
	MOVE.W	#0,InfoSamUse
	MOVEQ	#0,D7
	MOVEQ	#0,D5
	MOVE.W	sampletoggler,d5
	MOVE.L	D5,D6
	ADD.L	#16,d6
	MOVEQ	#1,D4				; CheckFirstComposer only
ssinfo2:
	MOVE.W	A3,TextOffset
	MOVEQ	#0,D0
	MOVE.W	D7,D0
	ADDQ.W	#1,D0
	;ADD.W	 sampletoggler,D0	 	; +16 if switch
	CLR.W	InfoShowVar

	CMP.W	d5,D7
	BLT.S	NoShowInfo
	CMP.W	d6,D7
	BGE.S	NoShowInfo
	MOVE.W	#1,InfoShowVar

NoShowInfo:
	TST.W	InfoShowVar
	BEQ.S	DontShowSam1

	ADD.W	#480,A3
	MOVE.W	D0,WordNumber
	MOVEM.L D0-A6,-(SP)
	CALL	Print2DecDigits
	MOVEM.L (SP)+,D0-A6

DontShowSam1:

ssinfo4:
	btst	#1,CfgFlag
	beq.b	highok
	bset	#1,CfgStore			; mem
	bclr	#1,CfgFlag			; lower chars

highok:

	MOVE.W	D0,D1
	MOVE.L	mt_songdataptr(pc),A0
	LEA	-10(A0),A0
	MOVE.W	D1,D0
	MULU	#30,D0
	ADD.L	D0,A0
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#$16,TextLength

	TST.W	InfoShowVar
	BEQ.S	DontShowSam

	MOVEM.L D0-D7/A0-A6,-(SP)
	ADDQ.W	#2,TextOffset
	CALL	SpaceShowText			; print sample name
	ADDQ.W	#4,TextOffset
	MOVEM.L (SP)+,D0-A6

DontShowSam:

	btst	#1,CfgStore
	beq.s	highok2
	bset	#1,CfgFlag
highok2:
	MOVEM.L D0-A6,-(SP)
	ADD.L	#22,A0
	MOVEQ	#0,D0
	MOVE.W	(A0),D0
	LSL.L	#1,D0

	TST.L	D0
	BEQ.S	InfoNoSam
	ADDQ.W	#1,InfoSamUse
InfoNoSam:
	ADD.L	D0,InfoSamData
	TST.W	InfoShowVar
	BEQ.S	DontShowSam2
	CALL	Print6DecDigits 		; print sample length

DontShowSam2:
	MOVEM.L (SP)+,D0-D7/A0-A6
	TST.L	D4
	BEQ.S	NoCompAgain
	BSR.W	composer			; search for author
NoCompAgain:
	CMP.L	#30,D7
	BEQ.S	InfoShowEnd
	ADDQ.L	#1,D7
	BRA.W	  ssinfo2
InfoShowEnd:
	MOVEM.L D0-A6,-(SP)
	MOVE.W	#18+102*80,TextOffset
	MOVE.L	InfoSamData,D0
	CALL	Print6DecDigits 		; samples sumlength
	MOVE.W	#32+80*80,TextOffset
	MOVE.W	InfoSamUse,WordNumber
	CALL	Print2DecDigits 		; count of samples
	MOVE.W	#18+91*80,TextOffset
	MOVE.L	TuneRAMBit,D0
	SUB.L	InfoSamData,D0
	CALL	Print6DecDigits 		; patterns sumlength
	MOVE.W	#18+113*80,TextOffset
	MOVE.L	TuneRAMBit,D0
	CALL	Print6DecDigits 		; module length
	MOVE.W	#21+80*80,TextOffset
	MOVE.L	TuneRAMBit,D0
	SUB.L	InfoSamData,D0
	SUB.L	#sd_patterndata,D0
	LSR.L	#8,D0
	LSR.L	#2,D0

	chn8test
	BNE.S	.chn4
	LSR.L	#1,D0
.chn4:	MOVE.W	D0,WordNumber
	CALL	Print3DecDigits_2		; count of patterns
	MOVEM.L (SP)+,D0-A6
	RTS

InfoSamData:	dc.l	0
InfoSamUse:	dc.w	0
InfoShowVar:	dc.w	0

InfoViewPos:
	CMP.W	#8,CurrScreen
	BNE.S	InfoRet
	;TST.L	RunMode
	;BNE	InfoRet
InfoViewPos2:
	MOVEM.L D0-A6,-(SP)
	move.l	mt_songdataptr(pc),A0
	LEA	sd_numofpatt(A0),A0		; number of patterns
	CLR.W	WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.W	#35+113*80,TextOffset
	BSR.W	Print4DecDigits 		; length
	MOVE.L	mt_songdataptr(pc),A0
	LEA	sd_pattpos(A0),A0
	ADD.L	playpos,A0
	MOVE.B	#0,WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.B	(A0),PattRfshNum+3
	MOVEQ	#0,D1
	MOVE.B	(A0),D1
	MOVE.W	#35+102*80,TextOffset
	MOVE.B	(A0),LongFFFF+3
	BSR.W	Print4DecDigits 		; akt pattern
	MOVE.W	playpos+2,WordNumber
	MOVE.W	#35+91*80,TextOffset
	BSR.W	Print4DecDigits 		; akt position
	MOVEM.L (SP)+,D0-A6
InfoRet:
	RTS

EnterSam1:
	MOVEQ	#1,D0
	BRA.B	EnterSampleName
EnterSam2:
	MOVEQ	#2,D0
	BRA.B	EnterSampleName
EnterSam3:
	MOVEQ	#3,D0
	BRA.B	EnterSampleName
EnterSam4:
	MOVEQ	#4,D0
	BRA.B	EnterSampleName
EnterSam5:
	MOVEQ	#5,D0
	BRA.B	EnterSampleName
EnterSam6:
	MOVEQ	#6,D0
	BRA.B	EnterSampleName
EnterSam7:
	MOVEQ	#7,D0
	BRA.B	EnterSampleName
EnterSam8:
	MOVEQ	#8,D0
	BRA.B	EnterSampleName
EnterSam9:
	MOVEQ	#9,D0
	BRA.B	EnterSampleName
EnterSamA:
	MOVEQ	#$A,D0
	BRA.B	EnterSampleName
EnterSamB:
	MOVEQ	#$B,D0
	BRA.B	EnterSampleName
EnterSamC:
	MOVEQ	#$C,D0
	BRA.B	EnterSampleName
EnterSamD:
	MOVEQ	#$D,D0
	BRA.B	EnterSampleName
EnterSamE:
	MOVEQ	#$E,D0
	BRA.B	EnterSampleName
EnterSamF:
	MOVEQ	#$F,D0
	BRA.B	EnterSampleName
EnterSam10:
	MOVEQ	#$10,D0
	BRA.W	EnterSampleName



EnterSampleName:
	MOVE.L	D0,-(SP)
	CALL     StorePtrCol
	CALL     SetWaitPtrCol
	MOVE.L	(SP)+,D0
	MOVE.L  mt_songdataptr(pc),A6
	LEA     -10(A6),A6
	MOVE.L	D0,D7
	ADD.W	sampletoggler,D7
	;SUB.W	#1,D7
	MULU    #30,D7
	ADD.L   D7,A6
	MOVE.L  A6,TextEndPtr
	;move.w  $16(A6),savesambyt
	MOVE.L  A6,ShowTextPtr
	ADD.L   #$15,TextEndPtr         ; 15
	MOVE.W  #$16,TextLength         ; 16
	MOVE.L  #45,A4		        ; -4
	SUBQ.L	#1,D0
	MULU    #6,D0
	ADD.L	#12,D0
	MULU	#80,D0
	ADD.L	D0,A4
	CALL     GetTextLine
	CLR.L   TextEndPtr
	;move.w  savesambyt,$16(a6)
	CALL     RestorePtrCol
	BSR.W	ShowInfos2
	RTS

;------------------------------------
;samplename => composer in a0

composer:
	lea	fo_author,a1
	cmp.l	#'UNNA',(a1)		; in new IFF-MOD author available?
	bne.w	  compyesiff
	move.w	ShowTextPtr,saveptr
	moveq	#$14,D0
	CMP.W	#1,compnext
	beq.s	compyes
colopp:
	CMP.W	#'BY',(A0,d0)
	BEQ.W	  checkbycomp
	CMP.W	#'by',(A0,d0)
	BEQ.W	  checkbycomp
	CMP.W	#'(c',(A0,d0)
	BEQ.s	compyes
	CMP.W	#'(C',(A0,D0)
	BEQ.S	compyes
	cmp.b	#'#',(a0,d0)
	beq.s	compyes
	CMP.B	#'/',(a0,d0)
	beq.s	compyes
nocomposer:
	dbra	d0,colopp
	move.w	saveptr,ShowTextPtr
	RTS

compyes:
	CLR.W	compnext
	CLR.L	D4
	MOVE.W	#14+25*80,TextOffset
	MOVE.L	A0,ShowTextPtr
	MOVE.W	#$16,TextLength
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	move.w	saveptr,ShowTextPtr
	RTS

compyesiff:
	MOVE.W	#14+25*80,TextOffset
	MOVE.L	#fo_author,ShowTextPtr
	MOVE.W	#$16,TextLength
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	SpaceShowText
	MOVEM.L (SP)+,D0-D7/A0-A6
	move.w	saveptr,ShowTextPtr
	RTS
checkbycomp:
	TST.L	D0
	BEQ.S	nocompfirstcheck
	CMP.B	#' ',-1(A0,D0)
	BNE.W	nocomposer
nocompfirstcheck:
	CMP.W	#$0000,2(A0,D0)
	BEQ.S	compnextline
	CMP.W	#$2000,2(A0,D0)
	BEQ.S	compnextline
	CMP.W	#$2020,2(A0,D0)
	BEQ.S	compnextline
	CMP.W	#'..',2(A0,D0)
	BEQ.S	compnextline
	CMP.W	#$13,d0
	BGE.S	compnextline
	CMP.B	#' ',2(A0,D0)
	BNE.W	nocomposer
	bra.w	compyes
compnextline:
	move.w	#1,compnext
	bra.w	nocomposer

compnext	dc.w	0
;-------------

ToggleInfos:
	CMP.W	#15,sampletoggler
	BNE.S	tgl2

	MOVE.W	#00,sampletoggler
	BRA.S	tgl3
	addq.w	#1,sampletoggler
tgl2:
	MOVE.W	#15,sampletoggler
tgl3:
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	sstinfo2
	MOVEM.L (SP)+,D0-D7/A0-A6
	CLR.B	RawKeyCode
	CLR.W	mt_keybufpos
	BSR.W	rd_updinfolist			; 4,0 update propscroller
	RTS

ToggleInfosUp:
	CMP.W	#0,sampletoggler
	BEQ.S	toggleinfosup3

	BSR.W	rd_updinfolist
	subq.w	#1,sampletoggler
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	sstinfo2
	MOVEM.L (SP)+,D0-D7/A0-A6
	CLR.W	mt_keybufpos
	CALL	Wait_4000
toggleinfosup3:
	RTS

ToggleInfosDown:
	CMP.W	#15,sampletoggler
	BEQ.S	toggleinfosdown3

	BSR.W	rd_updinfolist
	addq.w	#1,sampletoggler
	MOVEM.L D0-D7/A0-A6,-(SP)
	BSR.W	sstinfo2
	MOVEM.L (SP)+,D0-D7/A0-A6
	CLR.W	mt_keybufpos
	CALL	Wait_4000
toggleinfosdown3:
	RTS



Timer:		dc.l	0,0,0,0 		; Hours, Minutes,
						; Seconds, 1/100s
sampletoggler:	dc.w	0
saveptr:	dc.w	0
CfgStore:	dc.w	0

;***********************************
;* proportionalscroller for info   *
;***********************************

IProp_X:	dc.w	0
IProp_Y:	dc.w	0
ICount:		dc.w	MaxInsNum+3		;33+3

InfoPropScroller:
	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	MouseY,D1
	MOVE.W	IProp_X,D0
	ADD.W	#$0018,D0
	SUB.W	D0,D1
	BMI.W	ipropsc_sub
	CMP.W	IProp_Y,D1
	BPL.W	ipropsc_add
	MOVE.W	D1,D2
	MOVE.W	#$0053,D4
	SUB.W	IProp_Y,D4
	BSR.W	ipropsc10
	MOVE.W	MouseY,D1
ipropsc3:
	CALL	ResetKeyTimer
	BTST	#6,$00BFE001
	BNE.S	ipropsc6
	MOVE.W	D1,D3
	MOVE.W	MouseY,D1
	CMP.W	D1,D3
	BEQ.S	ipropsc3
	SUB.W	D2,D1
	SUB.W	#$0018,D1
	BPL.S	ipropsc4
	MOVEQ	#0,D1
ipropsc4:
	CMP.W	D4,D1
	BMI.S	ipropsc5
	MOVE.W	D4,D1
ipropsc5:
	MOVE.W	D1,IProp_X
	BSR.W	PressedInfoScrollbar
	MOVEM.L D0-D7/A0-A6,-(SP)
	;MOVE.L	DirMousetable,A5
	MOVE.W	ICount,D0
	SUB.W	#$0013,D0
	MULU	IProp_X,D0
	MOVE.W	#$0053,D1
	SUB.W	IProp_Y,D1
	DIVU	D1,D0
	MOVE.W	D0,sampletoggler
	BSR.W	sstinfo2
	MOVEM.L (SP)+,D0-D7/A0-A6
	BTST	#6,$00BFE001
	BEQ.B	ipropsc3
ipropsc6:
	BSR.B	UnPressedInfoScrollbar
	;CLR.W	DirCopFlag
	RTS

ipropsc_sub:
	SUB.W	#$0013,sampletoggler
	BPL.S	ipropsc8
	CLR.W	sampletoggler
ipropsc8:
	BSR.W	rd_updinfolist
	MOVE.W	sampletoggler,D0
	BSR.W	sstinfo2
	;CLR.W	DirCopFlag
	RTS

ipropsc_add:
	ADD.W	#$0013,sampletoggler
	MOVE.W	ICount,D0
	SUB.W	#$0013,D0
	CMP.W	sampletoggler,D0
	BPL.S	ipropsc9
	MOVE.W	D0,sampletoggler
ipropsc9:
	BSR.B	rd_updinfolist
	MOVE.W	sampletoggler,D0
	BSR.W	sstinfo2
	;CLR.W	DirCopFlag
	RTS

PressedInfoScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	IProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0
	MOVE.W	IProp_Y,D2
	LEA	EmptySprite,A0
	CALL	SetSpritePos
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

UnPressedInfoScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	IProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0
	MOVE.W	IProp_Y,D2
	CALL	UpdscrollSprite1
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

ipropsc10:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	IProp_X,D1
	ADD.W	#$0018,D1
	MOVE.W	#$013D,D0
	MOVE.W	IProp_Y,D2
	CALL	UpdscrollSprite2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

rd_updinfolist:
	MOVEM.L D0-D3,-(SP)
	MOVEQ	#0,D3
	MOVE.W	#$0053,IProp_Y
	CLR.W	IProp_X
	;MOVE.L	DirMousetable,A5
	MOVEQ	#$53,D0
	MOVE.W	#0,D1
	CMP.W	#$0013,ICount
	BMI.S	ipropsc14
	BEQ.S	ipropsc14
	MOVE.W	#$0629,D0
	MOVE.W	ICount,D1
	EXT.L	D0
	DIVU	D1,D0
	MOVE.W	D0,IProp_Y
	MOVE.W	sampletoggler,D1
	MOVE.W	ICount,D2
	MOVE.W	#$0053,D3
	SUB.W	D0,D3
	MULU	D1,D3
	SUB.W	#$0013,D2
	DIVU	D2,D3
	MOVE.W	D3,IProp_X
ipropsc14:
	MOVE.W	IProp_X(PC),D3
	ADD.W	IProp_Y(PC),D3
	CMP.W	#$0053,D3
	BMI.S	ipropsc15
	MOVEQ	#$53,D3
ipropsc15:
	SUB.W	IProp_Y(PC),D3
	MOVE.W	D3,IProp_X
	BSR.W	UnPressedInfoScrollbar
	MOVEM.L (SP)+,D0-D3
	RTS

;***********************************
;* PC relative variables for pt    *
;***********************************

Saveplaypos:	    	dc.w    0
HighPattNum:		dc.w	0
numchans:		dc.w	0
mixingrate:		dc.l	16000

PLSTAllocSize:		dc.l	0
MaxPLSTEntries2:	dc.w	0
MaxPLSTEntries: 	ds.w	1
PresetLength:		dc.w	0
PresetFineTune: 	dc.w	0
PresetRepeat:		dc.w	0
PresetReplen:		dc.w	0
PED_Action:		dc.w	0
PsetNumTemp:		dc.w	0
PsetPtrTemp:		dc.l	0

;definitions for pt.help
ST.MSG: 		dc.b	'ST'
ST.MSG0:		dc.b	'ST'
ST.MSG1:		dc.b	'ST'

G_DecompMemPtr: 	dc.l	0
G_DecompMemSize:	dc.l	0
C_DecompMemPtr: 	dc.l	0
C_DecompMemSize:	dc.l	0
DecompMemPtr:		dc.l	0
DecompMemSize:		dc.l	0

changeflag:		dc.l	0	;CHG! if song changed
PLSTmem:		dc.l	0
PresetTotal:		dc.w	0
PEDPos: 		dc.w	0
PLSTpos:		dc.w	0
MaxPLSTOffset:		dc.l	0
PresetMarkTotal:	dc.w	0
PLSTOffset:		dcb.b	14*4,0
CurrentPreset:		dc.w	1


	cnop 0,2

mt_funktable:
	dc.b 	0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128

mt_vibratotable:
	dc.b 0,24,49,74,97,120,141,161
	dc.b 180,197,212,224,235,244,250,253
	dc.b 255,253,250,244,235,224,212,197
	dc.b 180,161,141,120,97,74,49,24

Allright.MSG:
	dc.b	'ALL RIGHT',0				;1
	dc.b	'THE DISK IS WRITEPROTECTED!',0 	;2
	dc.b	'PRINT ABORTED! ',0			;3
	dc.b	'ENTER DATA ',0				;4
	dc.b	'DISK ERROR!! ',0			;5
	EVEN

PLSTFullText:		dc.b	'PLST IS FULL!',0
OprAbortedText: 	dc.b	'PRINT ABORTED! ',0
;EnterDataText:		dc.b	'ENTER DATA ',0
AddingPathText: 	dc.b	'ADDING PATH... ',0
			dc.b	'DISK ERROR!',0
LoadingText:		dc.b	'LOADING... ',0
Loadingsong.MSG:	dc.b	'LOADING SONG...',0
Loadingmodule.MSG:	dc.b	'LOADING MODULE...',0
			dc.b	'LOADING SAMPLE...',0
LoadPatternTxt:		dc.b	'LOADING PATTERN... ',0
LoadTrackTxt:		dc.b	'LOADING TRACK... ',0
Saving.MSG:		dc.b	'SAVING...',0
			dc.b	'SAVING SONG',0
Savingmodule.MSG:	dc.b	'SAVING MODULE... ',0
SavingSampleText:	dc.b	'SAVING YOUR SAMPLE...',0
SavingExecutableText	dc.b	'SAVING EXECUTABLE... ',0
SavingPatternText	dc.b	'SAVING PATTERN...',0
SavingTrackText 	dc.b	'SAVING TRACK...',0
LoadingPLSTText:	dc.b	'LOADING PLST...',0
SavingPLSTText: 	dc.b	'SAVING PLST... ',0
Deletingfile.MSG:	dc.b	'DELETING FILE... ',0
Renamingfile.MSG:	dc.b	'RENAMING FILE... ',0
DecrunchingText:	dc.b	'DECRUNCHING... ',0
Crunching.MSG:		dc.b	'CRUNCHING... ',0
SelectEntryText:	dc.b	'SELECT ENTRY BELOW IN LIST ',0
SelectSongTXT:		dc.b	'SELECT SONG',0
SelectExeTXT:		dc.b	'SELECT EXECUTABLE',0
SelectModuleTXT:	dc.b	'SELECT MODULE',0
SelectSampleTXT:	dc.b	'SELECT SAMPLE',0
SelectPatternTXT:	dc.b	'SELECT PATTERN ',0
SelectTrackTXT: 	dc.b	'SELECT TRACK ',0
RenameFileTXT:		dc.b	'SELECT FILE TO RENAME',0
DeleteFileTXT:		dc.b	'SELECT FILE TO DELETE! ',0
Readingdir.MSG: 	dc.b	'READING DIR... ',0
Positionnowse.MSG:	dc.b	'POSITION NOW SET.',0
Printingsong.MSG:	dc.b	'PRINTING SONG... ',0
PrintingPLSTText:	dc.b	'PRINTING PLST',0
Useopt7.MSG:		dc.b	'USE OPT7 MENU FOR MARKED.',0
ConvertingModule.MSG	dc.b	'CONVERTING MODULE... ',0
NoPatternTxt:		dc.b	'NO PT4 PATTERNFILE!',0
NoTrackTxt:		dc.b	'NO PT4 TRACKFILE!',0
			EVEN
pplibtxt:		dc.b	'LOADING POWERPACKED FILE!',0
			EVEN

xpklibtxt:		dc.b	'LOADING XPK-CRUNCHED FILE!',0
			EVEN

fimptext:		dc.b	'LOADING IMPLODED FILE!',0
			EVEN

noxpklibtxt:		dc.b	'XPKMASTER.LIB NOT FOUND!',0
			EVEN

xpkerrtxt:		dc.b	'XPK-PACKER FAILED!',0
			EVEN

ConsoleErrText: 	dc.b	'CAN''T OPEN WINDOW',0
			EVEN

***********************************

SaveSongTXT:		dc.b	10,10,'   Do you want to save',$A
			dc.b	'       the song?',0
			EVEN

SavePattTXT:		dc.b	10,10,'   Do you want to save',$A
			dc.b	'     the pattern?',0
			EVEN

SaveTrackTXT:		dc.b	10,10,'   Do you want to save',$A
			dc.b	'     the Track?',0
			EVEN

SaveExeTXT:		dc.b	10,10,'   Do you want to save',$A
			dc.b	'     as executable?',0
			EVEN

SaveModuleTXT:		dc.b	10,10,'  Do you want to save',$A
			dc.b	'      the module?',0
			EVEN

Deletethisfil.MSG:	dc.b	10,10,'  Delete this file?',0
			EVEN

PrintPLSTText:		dc.b	10,10,'   Print presetlist ?',0
			EVEN

Printthesong.MSG:	dc.b	10,10,'  Do you want to print',$A
			dc.b	'      the song?',0
			EVEN

QuitProgram.MSG:	dc.b	10,10,'   Are you sure you',$A
			dc.b	'    want to quit?',0
			EVEN

ChangedMod.TXT:		dc.b	10,10,'   Your module is changed!',$A
			dc.b	'   Do you really want to',$A
			dc.b	'        loose it?',0
			EVEN

Areyousure100TXT:	dc.b	10,10,'  Do you want to change',$A
			dc.b	' the actual patternmode?',$A
			dc.b	' All sounddatas are lost!',0
			EVEN

t8channel.msg:		dc.b	10,10,' Do you want to change',$A
			dc.b	' the channels to 4/8 ?',$A
			dc.b	' All sounddatas are lost!',0
			EVEN

recovertxt:		dc.b	10,10,'   Are you sure you want',$A
			dc.b	' to repair actual module?',0
			EVEN

no8modtxt:		dc.b	10,10,'    This function works',$A
			dc.b	'  only in 4 channel mode',$A
			dc.b	'  at the current version.',0
			EVEN

SaveAllSamplesText:	dc.b	10,10,'   Save all samples',$A
			dc.b	'   to current samplepath?',0
			EVEN

Upsample.MSG:		dc.b	10,10,'     Upsample?',0
			EVEN

Downsample.MSG: 	dc.b	10,10,'     Downsample?',0
			EVEN

Clearsplitand.MSG:	dc.b	10,10,'     Clear split',$A
			dc.b	'    and transpose?',0
			EVEN

Resettheconfi.MSG:	dc.b	10,10,'Reset the configuration?',0
			EVEN

DeletePresetText:	dc.b	10,10,'    Delete preset?',0
			EVEN

LoadPLSTText:		dc.b	10,10,'   Load presetlist?',0
			EVEN

SavePLSTText:		dc.b	10,10,'   Save presetlist?',0
			EVEN

Killthissampl.MSG:	dc.b	10,10,'   Kill this sample?',0
			EVEN

Abortloading.MSG:	dc.b	10,10,'    Abort loading?',0
			EVEN

LoadConfig.MSG:		dc.b	10,10,'   Load configuration?',0
			EVEN

Saveconfigura.MSG:	dc.b	10,10,'  Save configuration?',0
			EVEN

PEdDefaultPath: 	dc.b	'ST-00:SAMPLES',0
			dcb.b	38,0

PedDefaultVol:		dc.b	'ST'
ped2def:		dc.b	'-'
SndDiskNum0:		dc.b	'0'
SndDiskNum1:		dc.b	'1:',0

PresetName:		dc.b	'   ',0
newpresetname:		dc.b	'   ',0
PsetNameText:		dc.b	'                 ',0
PsetVolText:		dc.b	'   ',0
PsetLenText:		dc.b	'     ',0
PsetRepeatText: 	dc.b	'     ',0
PsetReplenText: 	dc.b	'    ',0

InsertPsetText: 	dc.b	'ST-01:                  0 0000 0000 0002',0
PsetPLSTtext:		dc.b	'No.    Samplename               '
			dc.b	'Length  Repeat  RepLen',$A,$A
PsetPrtNumText: 	dc.b	'    :  '
PsetPrtNameText:	dc.b	'                             '
PsetPrtLenText: 	dc.b	'        '
PsetPrtRepeatText:	dc.b	'        '
PsetPrtRepLenText:	dc.b	10,0

SongDumpText:		dc.b	9,'Protracker Song-Dump -- Made with Protracker 4.0  ',$D,$A,$A,9
			dc.b	'Songname:  '
			EVEN

CRLF_Text:	dc.b	13,10
FF_Text:	dc.b	12,0

PatternNumText: dc.b	9,9,9,'Pattern: '
PattNumText1:	dc.b	'0'
PattNumText2:	dc.b	'0',$D,$A,$D,$A
PtotText:	dc.b	9
PattXText1:	dc.b	'0'
PattXText2:	dc.b	'0 : '
PpText:		dc.b	'                        0000'
ascii.MSG1:	dc.b	'  0000'
ascii.MSG2:	dc.b	'  0000'
ascii.MSG3:	dc.b	'    ',$D,$A
ascii.MSG9:	dc.b	'        ',0,0

PattPosText:	dc.b	'00  :                                       '
		dc.b	'                '
PnText: 	dc.b	'    ',0,0

STText1:	dc.b	'ST'
STText1Num:	dc.b	'-'
STText1Number:	dc.b	0,0,':'

STText2:	dc.b	'ST'
STText2Num:	dc.b	'-'
STText2Number:	dc.b	0,0,':'

STText3:	dc.b	'ST'
STText3Num:	dc.b	'-'
STText3Number:	dc.b	0,0,':'
		EVEN

FastHexTable:
	dc.b	'000102030405060708090A0B0C0D0E0F1011121314151'
	dc.b	'61718191A1B1C1D1E1F202122232425262728292A2B2'
	dc.b	'C2D2E2F303132333435363738393A3B3C3D3E3F40414'
	dc.b	'2434445464748494A4B4C4D4E4F50515253545556575'
	dc.b	'8595A5B5C5D5E5F606162636465666768696A6B6C6D6'
	dc.b	'E6F707172737475767778797A7B7C7D7E7F808182838'
	dc.b	'485868788898A8B8C8D8E8F909192939495969798999'
	dc.b	'A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB'
	dc.b	'0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C'
	dc.b	'6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBD'
	dc.b	'CDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F'
	dc.b	'2F3F4F5F6F7F8F9FAFBFCFDFEFF'


TrackDiskName:	dc.b	'trackdisk.device',0
		EVEN

InputDevice:	dc.b	'input.device',0
		EVEN

DOSBase:	dc.l	0
IntuiBase:	dc.l	0
GfxBase:	dc.l	0
xpkbase:	dc.l	0
ReqBase:	dc.l	0

RawKeyHexTable:
	;0123456789ABCDEF

	dc.l	$0A010203,$04050607,$08092035,$33221223

RawKeyScaleTable:
	dc.l	$31213222,$33342435,$25362637,$38283929,$3A100211
	dc.l	$03121305,$14061507,$16170918,$0A191A0C,$1B464600

KbdTransTable1:
	dc.b  	00,01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16
	dc.b	12,13,14,15,16,17,18,19,20,21,22,23
	dc.b	24,25,26,27,28,29,30,31,36,36

KbdTransTable2:
	dc.b	12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28
	dc.b	24,25,26,27,28,29,30,31,32,33,34,35
	dc.b	36,36,36,36,36,36,36,36,36,36

NoteNames1:
	dc.b	'C-1 C#1 D-1 D#1 E-1 F-1 F#1 G-1 G#1 A-1 A#1 '
	dc.b	'B-1 C-2 C#2 D-2 D#2 E-2 F-2 F#2 G-2 G#2 A-2 '
	dc.b	'A#2 B-2 C-3 C#3 D-3 D#3 E-3 F-3 F#3 G-3 G#3 '
	dc.b	'A-3 A#3 B-3 '

SpcNoteText:
	dc.b	'--- '

NoteNames2:
	dc.b	'C-1 D^1 D-1 E^1 E-1 F-1 G^1 G-1 A^1 A-1 B^1 '
	dc.b	'B-1 C-2 D^2 D-2 E^2 E-2 F-2 G^2 G-2 A^2 A-2 '
	dc.b	'B^2 B-2 C-3 D^3 D-3 E^3 E-3 F-3 G^3 G-3 A^3 '
	dc.b	'A-3 B^3 B-3 --- '

mt_periodtable:
; Tuning 0
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113,0
; Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113,0
; Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112,0
; Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111,0
; Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110,0
; Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109,0
; Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109,0
; Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108,0
; Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120,0
; Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119,0
; Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118,0
; Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118,0
; Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117,0
; Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116,0
; Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115,0
; Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114,0


CursPosTable:
	dc.b	08,14,16,18,20,22
	dc.b	26,32,34,36,38,40
	dc.b	44,50,52,54,56,58
	dc.b    62,68,70,72,74,76
	dc.b	80,86,88,90,92,94
	dc.b	98,104,106,108,110,112
	dc.b    116,122,124,126,128,130
	dc.b    134,140,142,144,146,148

GUnShiftedKeymap:
	dc.b	"`1234567890'",$5C,"*0"
	dc.b	"qwertzuiop+*123"
	dc.b	"asdfghjkl#",0,"456"
	dc.b	"<yxcvbnm,.-",0,".","789 "

GShiftedKeymap:
	dc.b	'~!"$%&/()=?`|*0'
	dc.b	'QWERTZUIOP**123'
	dc.b	'ASDFGHJKLA^',0,'456'
	dc.b	'>YXCVBNM;:_',0,'.','789 '

UnShiftedKeymap:
	dc.b	"`1234567890-=",$5C,"*0"
	dc.b	"qwertyuiop[]*123"
	dc.b	'asdfghjkl;',39,'#',0,'456'
	dc.b	'<zxcvbnm,./',0,'.','789 '

ShiftedKeymap:
	dc.b	'~!@#$%^&*()_+|*0'
	dc.b	'QWERTYUIOP{}*123'
	dc.b	'ASDFGHJKL:',34,'^',0,'456'
	dc.b	'>ZXCVBNM<>?',0,'.','789 '

LoadingSampleText:	dc.b	'LOADING SAMPLE...',0
IFFerrorFibon.MSG:	dc.b	'FIBONACCI COMPRESSION UNSUPPORTED! ',0
IFFerroronly1.MSG:	dc.b	'ONLY 1 OCTAVE SAMPLES SUPPORTED! ',0
IFFBodyFail.MSG:	dc.b	'IFF ERROR: BODY NOT FOUND! ',0
No8SVXIFF.MSG:		dc.b	'IFF ERROR: NOT AN 8SVX FILE! ',0
			dc.b	'IFF ERROR: VHDR NOT FOUND! ',0
NotaMaestro16.MSG:	dc.b	'NOT A 16 BIT MONO SAMPLE!',0
UpsamplingMae.MSG:	dc.b	'UPSAMPLING MAESTRO FILE',0
Couldnotalloc.MSG0:	dc.b	'COULD''NT ALLOCATE CHIPMEM! ',0
Couldnotalloc.MSG1:	dc.b	'COULD''NT ALLOCATE DYN MEMORY!',0
Couldnotalloc.MSG:	dc.b	'COULD NOT ALLOCATE ANY MEMORY!',0
Undynning.MSG:		dc.b	'UNDYNNING',0
			dc.b	'IFF HEADER INFORMATION:',$A
			dc.b	'NAME: '
AUTH.MSG:		dc.b	'                    ',$A
			dc.b	'AUTH: '
COPY.MSG:		dc.b	'                    ',$A
			dc.b	'COPY: '
ANNO.MSG:		dc.b	'                    ',$A
			dc.b	'ANNO: '
DYN.MSG:		dc.b	'                    ',$A
			dc.b	'DYN : '
ascii.MSG:		dc.b	'                    ',0
notavailable.MSG:	dc.b	'- Not available -',0

VHDR.MSG:
	dc.b	'VHDR'
	dc.l	MaesChk9
	dc.b	'NAME'
	dc.l	MaesAuthor
	dc.b	'AUTH'
	dc.l	MaesCopyright
	dc.b	'ANNO'
	dc.l	MaesDyn
	dc.b	'(c) '
	dc.l	MaesAnno
	dc.b	'DYN '
	dc.l	MaesChk8
	dc.b	'BODY'
	dc.l	MaesChk7
	dc.l	0

AddedMSamLength:	dc.l	0
CheckedMSamLength:	dc.l	0
SumMSamLength:		dc.l	0
SampleDataPtr:		dc.l	0
SampleDataLength:	dc.l	0
IFF8SVXPTR:		dc.l	0
IFF8SVXR1:		dc.l	0
IFF8SVXSum:		dc.l	0
lbW017C30:		dc.w	0
lbL017C32:		dc.l	0
lbL017C36:		dc.l	0
lbL017C3A:		dc.l	0
UndynStore:		dc.l	0
UnDynMemPtr:		dc.l	0
lbL017C46:		dc.l	0
SmplErrMsg:		dc.l	0
SmplErrFlag:		dc.b	0
MaesErrorFlag:		dc.b	0
EightBitSampleFlag:	dc.b	0,0

mt_mxbuf4base:		dc.l	0
mt_mxbuf4chan:		dc.l	SPOINT1
			dc.l	SPOINT2
			dc.l	SPOINT3
			dc.l	SPOINT4
			;dc.l	SPOINT5
			;dc.l	SPOINT6
			;dc.l	SPOINT7
			;dc.l	SPOINT8

TremoloByte:		dc.w 	$40
			dc.b	0
TremBit:		dc.b	1

KeyTransTabPtr: 	dc.l	0
NoteNamesPtr:		dc.l	0	;3.30
CspritePtr:		dc.l	0
;********************************
;* the sprite pointers          *
;********************************
SpritePtrsPtr:		dc.l	0	;sprite 0
LineCurPosPtr:		dc.l	0	;sprite 1
NoSpritePtr2:		dc.l	0	;sprite 2
CursorPosPtr:		dc.l	0	;sprite 3
Ch1SpritePtr:		dc.l	0	;sprite 4 > vumeter1, loopsprite1 in sampler
Ch2SpritePtr:		dc.l	0	;sprite 5 > vumeter2, loopsprite2 in sampler
Ch3SpritePtr:		dc.l	0	;sprite 6 > vumeter3, playpositiobsprite in sampler
Ch4SpritePtr:		dc.l	0	;sprite 7 > vumeter4, trackcursor

;Ch5SpritePtr:		dc.l	0	;vumeter5
;Ch6SpritePtr:		dc.l	0	;vumeter6
;Ch7SpritePtr:		dc.l	0	;vumeter7
;Ch8SpritePtr:		dc.l	0	;vumeter8

PPattPos:		dc.l	0
SaveEditMode:		dc.l	0
EditMode:		dc.l	0
RunMode:		dc.l	0
CurrCmds:		dc.w	0,0
TextBplPtr:		dc.l	0
TextOffset:		dc.w	0
TextLength:		dc.w	0
ShowTextPtr:		dc.l	0
PatternNumber:		dc.l	0
playpos:		dc.l	0
mt_speed:		dc.l	0
CopListBpl4Ptr: 	dc.l	0
CmdOffset:		dc.w	0
RawKeyCode:		dc.b	0
ShiftKeyStatus: 	dc.b	0
PattRfsh:		dc.b	0,0
MountFlag:		dc.w	0
GetLineFlag:		dc.w	0
LoadingInProgress:	dc.w	0
CurrentPlayNote:	dc.w	$D6
LineCurX:		dc.w	$FFF0
LineCurY:		dc.w	0
TextEndPtr:		dc.l	0
ScrPattPos:		dc.w	0
PattCurPos:		dc.l	0
WordNumber:		dc.w	0
UpOrDown:		dc.w	0
InsNum: 		dc.w	0
LastInsNum:		dc.w	1
PlayInsNum:		dc.b	0,1

MouseY3:		dc.w	0
MouseX: 		dc.w	0
MouseY: 		dc.w	0
MouseX2:		dc.w	0
MouseY2:		dc.w	0
MouseX3:		dc.w	0
MouseY4:		dc.w	0
MouseFlag:		dc.l	0

SampleInfo:		dc.w	0,0
si_long:		dc.l	0
si_pointer:		dc.l	0,0,0,0,0
SampleInfo2:		dc.l	0
si_long2:		dc.l	0
si_pointer2:		dc.l	0,0,0,0,0
LongFFFF:		dc.l	0
mt_posjumpflag:		dc.b	0
mt_pbreakpos: 		dc.b	0
PBreakFlag:		dc.b	0
LEDStatus:		dc.b	0
mt_pattdeltime:		dc.b	0
mt_pattdeltime2: 	dc.b	0
PattRfshNum:		dc.l	0
DidQuantize:		dc.w	0,0,0
FileNamePtr:		dc.l	0
DiskDataPtr:		dc.l	0
FileHandle:		dc.l	0
DiskDataLength: 	dc.l	0
LowMask:		dc.b	$FF
AllowRedrPattSc:	dc.b	0
AllowRedrPattPos:	dc.w	0
mt_patternpos:		dc.l	0
mt_songpos:		dc.l	0
mt_counter:		dc.l	0
PatternPtr:		dc.l	0
mt_songdataptr:		dc.l	0
mt_samplestarts:	dcb.l	(MaxInsNum*2)+1,0		;63*0.l
ProgStackSave:		dc.l	0,0,0,0
DirFBitt:		dc.w	0
DirFBitt2:		dc.w	0
DirPath:		dc.l	0
FileLock:		dc.l	0
CurrScreen:		dc.w	1,0
PointerCol1Save:	dc.w	0
PointerCol2Save:	dc.w	0
PointerCol3Save:	dc.w	0
lbB017E94:		dc.b	0
UpdateTempo:		dc.b	0
MoreInstrFlag:		dc.w	0
SampleSortList: 	dcb.l	32,0			;MaxInsNum+1

			dc.w	0
			dc.b	40

AutoReqRunning: 	dc.b	0
NoSampleInfo:		dcb.b	60,0			;fixed 4.01
EnterTextFlag:		dc.b	0,0
SplitAddress:		dc.l	0
HelpTextFlag:		dc.l	$12345678

PosEDf2:		dc.l	0
EmptyTextField: 	dc.b	'                                       ',0
			EVEN

;***************************
;* Positionseditor         *
;***************************
PosED:
	CLR.B	RawKeyCode
	cmp.w	#9,CurrScreen
	beq.b	exitposed
	CALL	TopExit
	CALL	WaitForButtonUp
	move.w	#9,CurrScreen
	st	NoSampleInfo
	bsr.b	swapposed
	beq.b	exitposed

posed_rts:
	movea.l TextBplPtr(PC),A0
	MOVE.W	#$0987,D0
pospeds4:
	CLR.L	(A0)+
	DBRA	D0,pospeds4

	bsr.w	PosEDstart		;redraw posed
	CALL	DctMainScr1_7
	BSR.W	InitPosScroller
	BSR.W	rd_updposlist		;scroller
;	bsr	hardwareout
	rts

exitposed:
	CLR.W	oProp_X
	move.w	ok_dim,oProp_Y 		;53
	MOVE.B	#$F8,EmptySprite+1
	MOVE.L	#$FFFFFFFF,scrtable1
	MOVE.L	#$FFFFFFFF,scrtable2
	MOVE.L	#$FFFFFFFF,scrtable3
	CALL	WaitForButtonUp
	move.w	#1,CurrScreen
	bsr.s	swapposed
	MOVEA.L TextBplPtr(PC),A0
	MOVE.W	#$0987,D0
pkdeloop:
	CLR.L	(A0)+
	DBRA	D0,pkdeloop
	GOTO	DisplayMainAll

swapposed:
	MOVE.L	DecompMemPtr,D0 	;get decompress address
	BEQ.B	posl5
	MOVEA.L D0,A1			;if true the de-allocate it
	BSR.B	posl4
	GOTO	FreeDecompMem
posl5:
	lea	PosGFXData,a0
	CALL	Decompact
	BNE.B	posl4
	rts

posl4:
	LEA	PTBitMap,A0
	MOVEQ	#1,D2
	MOVEQ	#0,D3

posl1:	MOVE.W	#$04b9,D0		;999
posl2:	MOVE.L	(A0),D1
	MOVE.L	(A1),(A0)+
	ADDQ.W	#4,D3
	CMP.W	#$0028,D3		;40
	BNE.B	posl3
	LEA	$0028(A0),A0
	moveq	#0,D3
posl3:
	move.l	D1,(A1)+
	DBRA	D0,posl2
	LEA	$29E0(A0),A0		;12480
	DBRA	D2,posl1
	MOVEQ	#-1,D0
	RTS

;---------- gadgets for positioneditor

CheckPosGadgs:
	MOVEM.W (MouseX2),D0/D1
	LEA	PosGadData,A0
	CALL	ConvMousTabl
	TST.W	D2
	BEQ.S	skis2p
	CMP.W	#01,D2			;exit_gadget
	BEQ.W	gtoexitposed
	CMP.W	#02,D2
	BEQ.S	gtoposinsert
	CMP.W	#03,D2
	BEQ.S	gtoposdelete
	cmp.w	#04,d2
	beq.s	gtoposincr
	cmp.w	#05,d2
	beq.s	gtoposdecr
	CMP.W	#08,D2
	BEQ.S	gtoposup
	CMP.W	#09,D2
	BEQ.S	gtoposdown
	CMP.W	#$0A,D2
	BEQ.S	gtoexitposed		;exit_button
	CMP.W	#$0B,D2
	beq.s	gtoposup		;arrow
	cmp.w	#$0C,d2
	beq.s	gtoposdown		;arrow
	cmp.w	#$0D,d2
	beq.s	xScreenSwitch
	cmp.w	#$0E,d2			;propscroller
	beq.w	PosPropScroller

skis2p: CALL	ChkMainright
	RTS


gtoposinsert:	GOTO	PosInsert
gtoposdelete:	GOTO	PosDelete
gtoposup:
		tst.l	RunMode
		bne.s	poedsto2	;only clear screen if mod is running
		bsr.s	clearposed
poedsto2:
		GOTO	PositionDown
gtoposdown:
		tst.l	RunMode
		bne.s	poedsto3	;only clear screen if mod is running
		bsr.s	clearposed
poedsto3:
		GOTO	PositionUp
gtoposdecr:
		MOVE.W	#$FFFF,UpOrDown
		CALL	PatternGadg
		BRA.S	PoEDs
gtoposincr:
		CLR.W	UpOrDown
		CALL	PatternGadg
		BRA.S	PoEDs
gtoexitposed:	GOTO	exitposed
xScreenSwitch:	GOTO	Screenswitch

clearposed:

	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	#146,D0
	MOVEQ	#10,D1
	MOVE.W	#228,D2
	MOVEQ	#108,D3
	MOVEQ	#0,D5
	CALL	DrawRecBox		;clears requester area 146-228 x
	MOVEM.L (SP)+,D0-D7/A0-A6	;                      10-108  y
	RTS

;***********************************
;* Positionseditor view            *
;***********************************

PosEDstart:
	cmp.w	#9,CurrScreen
	beq.s	PoEDs
	RTS
PoEDs:

	tst.l	RunMode
	beq.s	poedsto 			;only clear screen if mod is running

	bsr.b	clearposed

poedsto:
	move.l	playpos,D7
	move.l	mt_songdataptr,a0

	cmp.b	sd_numofpatt(A0),D7
	BCS.S	nPoEDs

	move.b	sd_numofpatt(a0),D7
	subq.l	#1,D7
nPoEDs: move.l	d7,PosEDf2
	MOVE.W	#$03D0+3,A5
	MOVEQ	#15,D6				;11
	MOVEQ	#5,D5
	MOVE.L	PosEDf2,D7
	CMP.L	#5,D7
	BGE.S	poedgt
	NEG.L	D7
	ADDQ.L	#4,D7
poedga:
	ADD.W	#$01E0,A5			;#$00F0,A5
	SUBQ.L	#1,D6
	SUBQ.L	#1,D5
	DBRA	D7,poedga
poedgt:
	MOVE.L	PosEDf2,D7
	SUB.L	D5,D7
	MOVE.L	mt_songdataptr,A1
	MOVEQ	#0,D4
	MOVE.B	sd_numofpatt(A1),D4
	LEA	sd_pattpos(A1),A1

poedgb:
	MOVE.L	D7,D0
	MOVEQ	#0,D1
	MOVE.B	0(A1,D0.W),D1
	MOVE.L	D1,D2
	;MULU	 #$0010,D2
	LSL.L	#4,D2				;orgmulu
	;LEA	EmptyTextField,A2		;!!!
	ADD.L	D2,A2
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	A5,TextOffset
	MOVE.W	D0,WordNumber
	CALL	Print4DecDigits 	;1
	MOVEM.L (SP)+,D0-D7/A0-A6
	ADDQ.W	#2,TextOffset
	MOVE.W	D1,WordNumber
	MOVEM.L D0-D7/A0-A6,-(SP)
	CALL	Print2DecDigits 	;2
	MOVEM.L (SP)+,D0-D7/A0-A6

	ADDQ.L	#1,D7
	CMP.L	D4,D7
	BEQ.S	poedgc
	ADD.L	#$000001E0,A5
	DBRA	D6,poedgb
poedgc:
	BSR.W	rd_updposlist			;update scroller
	move.l	mt_songdataptr,A0

	LEA	sd_numofpatt(A0),A0		;number of patterns
	CLR.W	WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.W	#2321*3-160,TextOffset
	BSR.W	Print4DecDigits 		;length

;---akt mt_patternpos-------
	MOVE.L	mt_songdataptr,A0
	LEA	sd_pattpos(A0),A0
	ADD.L	playpos,A0
	MOVE.B	#0,WordNumber
	MOVE.B	(A0),WordNumber+1
	MOVE.B	(A0),PattRfshNum+3
	MOVEQ	#0,D1
	MOVE.B	(A0),D1
	MOVE.W	#2321*3+480,TextOffset
	MOVE.B	(A0),LongFFFF+3
	BSR.W	Print4DecDigits 		;akt pattern
	MOVE.W	playpos+2,WordNumber
	MOVE.W	#2321*3+480+480+160,TextOffset
	BSR.W	Print4DecDigits 		;akt position

	RTS

;***********************************
;* propoprtional scroller for POS  *
;***********************************

oProp_X:	dc.w	0
oProp_Y:	dc.w	0
oCount:		dc.w	0			;propvalue max

oCountValue:	EQU	$13

ok_posx:	EQU	119			;x-positon propscroller
ok_posy:	EQU	$16			;y-pos propscroller 18
ok_dim:		EQU	$4A			;dimensions of scroller 53


InitPosScroller:
	move.l	mt_songdataptr,A0
	LEA	sd_numofpatt(A0),A0		;number of patterns
	CLR.W	oCount
	move.b	(A0),d0
	add.b	#18,d0
	move.b	d0,oCount+1
	RTS


PosPropScroller:
opropsc2:
	move.l	mt_songdataptr,A0

	LEA	sd_numofpatt(A0),A0
	cmp.b	#4,(A0)				;songlength=1 = empty song ?
	bgt.s	proplet
	RTS
proplet:

	MOVE.W	#$FFFF,DirCopFlag
	MOVE.W	MouseY,D1
	MOVE.W	oProp_X,D0
	ADD.W	#ok_posy,D0
	SUB.W	D0,D1
	BMI.W	opropsc_sub
	CMP.W	oProp_Y,D1
	BPL.W	opropsc_add
	MOVE.W	D1,D2
	MOVE.W	#ok_dim,D4
	SUB.W	oProp_Y,D4
	BSR.W	opropsc10
	MOVE.W	MouseY,D1
opropsc3:
	CALL	ResetKeyTimer		;org bsr 3.62
	BTST	#6,$00BFE001
	BNE.S	opropsc6
	MOVE.W	D1,D3
	MOVE.W	MouseY,D1
	CMP.W	D1,D3
	BEQ.S	opropsc3
	SUB.W	D2,D1
	SUB.W	#ok_posy,D1
	BPL.S	opropsc4
	MOVEQ	#0,D1
opropsc4:
	CMP.W	D4,D1
	BMI.S	opropsc5		;max position?
	MOVE.W	D4,D1
opropsc5:
	MOVE.W	D1,oProp_X
	BSR.W	PressedPosScrollbar
	MOVEM.L D0-D7/A0-A6,-(SP)
	;MOVE.L	DirMousetable,A5
	MOVE.W	oCount,D0
	SUB.W	#oCountValue,D0
	MULU	oProp_X,D0
	MOVE.W	#ok_dim,D1
	SUB.W	oProp_Y,D1
	DIVU	D1,D0
	MOVE.W	D0,playpos+2
	CALL	PositionUpDown
	MOVEM.L (SP)+,D0-D7/A0-A6
	BTST	#6,$00BFE001
	BEQ.B	opropsc3
opropsc6:
	BSR.W	UnPressedPosScrollbar
	;CLR.W	DirCopFlag
	RTS

opropsc_sub:
	SUB.L	#oCountValue,playpos
	BPL.S	opropsc8
	CLR.W	playpos+2
opropsc8:
	BSR.W	rd_updposlist
	MOVE.W	playpos+2,D0
	CALL	pogskp3

	;CLR.W	DirCopFlag
	RTS

opropsc_add:
	ADD.W	#oCountValue,playpos+2
	MOVE.W	oCount,D0
	SUB.W	#oCountValue,D0
	CMP.W	playpos+2,D0
	BPL.S	opropsc9
	MOVE.W	D0,playpos+2
opropsc9:
	BSR.w	rd_updposlist
	MOVE.W	playpos+2,D0
	CALL	pogskp3
	;CLR.W	DirCopFlag
	RTS

PressedPosScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	oProp_X,D1
	ADD.W	#ok_posy,D1
	MOVE.W	#ok_posx,D0
	MOVE.W	oProp_Y,D2
	LEA	EmptySprite,A0
	CALL	SetSpritePos
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

UnPressedPosScrollbar:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	oProp_X,D1
	ADD.W	#ok_posy,D1
	MOVE.W	#ok_posx,D0
	MOVE.W	oProp_Y,D2
	CALL	UpdscrollSprite1
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

opropsc10:
	MOVEM.L D0-D7/A0-A6,-(SP)
	MOVE.W	oProp_X,D1
	ADD.W	#ok_posy,D1
	MOVE.W	#ok_posx,D0
	MOVE.W	oProp_Y,D2
	CALL	UpdscrollSprite2
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTS

rd_updposlist:

	MOVEM.L D0-D3,-(SP)
	MOVEQ	#0,D3
	MOVE.W	#ok_dim,oProp_Y
	CLR.W	oProp_X
	;MOVE.L	DirMousetable,A5
	MOVE.w	#ok_dim,D0
	MOVE.W	#0,D1
	CMP.W	#oCountValue,oCount
	BMI.S	opropsc14
	BEQ.S	opropsc14
	MOVE.W	#$0629,D0
	MOVE.W	oCount,D1
	EXT.L	D0
	DIVU	D1,D0
	MOVE.W	D0,oProp_Y
	MOVE.W	playpos+2,D1
	MOVE.W	oCount,D2
	MOVE.W	#ok_dim,D3
	SUB.W	D0,D3
	MULU	D1,D3
	SUB.W	#oCountValue,D2
	DIVU	D2,D3
	MOVE.W	D3,oProp_X
opropsc14:
	MOVE.W	oProp_X(PC),D3
	ADD.W	oProp_Y(PC),D3
	CMP.W	#ok_dim,D3
	BMI.S	opropsc15
	MOVE.w	#ok_dim,D3
opropsc15:
	SUB.W	oProp_Y(PC),D3
	MOVE.W	D3,oProp_X
	BSR.W	UnPressedPosScrollbar
	MOVEM.L (SP)+,D0-D3
	RTS


;***********************************
;* howards nice playtime calculate *
;***********************************

CalTime:
	clr.l	Timer
	clr.l	Timer+4
	clr.l	Timer+8
	clr.l	Timer+12

	moveq.l #0,d0
	move.l	#25000/50,d1		;50Hz
	moveq.l #1,d2
	move.l	mt_songdataptr,a0	;Module
	lea.l	Timer,a1
	BSR.S	PTCalcTime

	moveq.l #0,d0
	rts

PTCalcTime:
	move.l	#6,.Speed
	move.l	#0,.PattPos
	move.l	d0,.SongPos
	move.l	#0,.PattLoopPos
	move.l	#0,.PosJumpPos
	move.b	d2,.CIAFlag

.MainLoop:
	lea.l	sd_pattpos(a0),a2	; Get position
	add.l	.SongPos,a2
	moveq.l #0,d0
	move.b	(a2),d0 		; Get pattern at current pos
	lsl.l	#8,d0			; *1024
	lsl.l	#2,d0
	chn8test
	BNE.S	.no8mode210
	LSL.L	#1,D0

.no8mode210:
	lea.l	sd_patterndata(a0),a2
	add.l	d0,a2			; Address for pattern

.StepLoop:
	lea.l	sd_pattpos(a0),a2	       ; Get position
	add.l	.SongPos,a2
	moveq.l #0,d0
	move.b	(a2),d0 		; Get pattern at current pos
	chn8test
	BNE.S	.no8mode33
	LSL.L	#1,D0

.no8mode33:

	lsl.l	#8,d0			; *1024
	lsl.l	#2,d0
	lea.l	sd_patterndata(a0),a2
	add.l	d0,a2			; Address for pattern

	move.l	.PattPos,d0
	lsl.l	#4,d0
	chn8test
	BNE.S	.no8mode211
	LSL.L	#1,D0

.no8mode211:
	add.l	d0,a2

	moveq.l #4-1,d7 		; Loop
	chn8test
	BNE.S	.VoiceLoop
	MOVEQ.L #8-1,D7

.VoiceLoop:
	checkrmb
	beq.w	.OkMins 		;CalcErrorExit!
	lea.l	.CmdsTab,a3
	move.l	(a2),d0 		; Get stuff
	and.l	#$00000ff0,d0		; Get command

	move.l	d0,d2
	and.l	#$00000f00,d2
	cmp.l	#$00000e00,d2		; Misc cmds?
	beq.s	.TabLoop

	and.l	#$00000f00,d0

.TabLoop:
	cmp.l	#-1,(a3)
	beq.s	.NoneFound

	cmp.l	(a3),d0
	bne.s	.NoMatch

	move.l	4(a3),a3
	jsr	(a3)
	bra.s	.NoneFound

.NoMatch:
	addq.l	#8,a3
	bra.s	.TabLoop

.NoneFound:
	addq.l	#4,a2
	dbra	d7,.VoiceLoop

	bsr.w	.AddSpeed

	addq.l	#1,.PattPos

	tst.b	.BreakFlag
	bne.s	.NewPos

	cmp.l	#64,.PattPos
	bne.w	.StepLoop

.NewPos:
	move.b	#0,.BreakFlag

	move.l	.PattBreakPos,.PattPos
	move.l	#0,.PattBreakPos	; Default pattern break pos

	tst.l	.PosJumpPos
	beq.s	.NoPosJump

	move.l	.PosJumpPos,.SongPos
	move.l	#0,.PosJumpPos
	bra.s	.EndIt

.NoPosJump:
	addq.l	#1,.SongPos
	move.l	.SongPos,d0
	lea.l	sd_numofpatt(a0),a3
	cmp.b	(a3),d0
	bcs.w	.MainLoop

.EndIt:
	move.l	12(a1),d0
	divu.w	#250,d0
	and.l	#$ffff,d0
	move.l	d0,12(a1)		; Convert to 100/s.
	rts

.AddSpeed:	move.l	.Speed,d0
		subq.l	#1,d0
.SpeedLoop:	add.l	d1,12(a1)
		dbra	d0,.SpeedLoop
.AddSpeedLoop:	cmp.l	#25000,12(a1)
		bcs.s	.OkIRQs
		sub.l	#25000,12(a1)
		addq.l	#1,8(a1)
.OkIRQs:		cmp.l	#60,8(a1)
		bcs.s	.OkSecs
		sub.l	#60,8(a1)
		addq.l	#1,4(a1)
.OkSecs:	cmp.l	#60,4(a1)
		bcs.s	.OkMins
		sub.l	#60,4(a1)
		addq.l	#1,(a1)
.OkMins:	rts

.CmdsTab:	dc.l	$00000b00,._PosJump
		dc.l	$00000d00,._PattBreak
		dc.l	$00000f00,._SetSpeed
		dc.l	$00000e60,._PatLoop
		dc.l	$00000ee0,._PatDelay
		dc.l	-1,-1


._PosJump:	move.l	(a2),d0 		; Get stuff
		and.l	#$ff,d0
		move.l	d0,.PosJumpPos
		move.b	#-1,.BreakFlag
		rts

._PattBreak:	move.l	(a2),d0 		; Get stuff
		and.l	#$ff,d0
		move.l	d0,.PattBreakPos
		move.b	#-1,.BreakFlag
		rts

._SetSpeed:	move.l	(a2),d0 		; Get stuff
		and.l	#$ff,d0
		beq.s	.Halt

		tst.b	.CIAFlag
		beq.s	.VBL

		cmp.b	#$20,d0
		bcs.s	.VBL

		; Do some CIA->Hz converting!

		move.l	#62500,d1
		divu.w	d0,d1
		and.l	#$ffff,d1

		rts

.VBL:		move.l	d0,.Speed
		rts

.Halt:		move.l	#-1,.PosJumpPos 	; Halt module
		move.b	#-1,.BreakFlag
		rts

._PatLoop:	move.l	(a2),d0 		; Get stuff
		and.l	#$f,d0
		tst.l	d0
		beq.s	.SetLoop
		tst.l	.PattLoopCnt
		beq.s	.SetLoopCnt
		subq.l	#1,.PattLoopCnt
		bne.s	.DoLoop
		rts

.SetLoop:	move.l	.PattPos,.PattLoopPos
		rts

.SetLoopCnt:	move.l	d0,.PattLoopCnt

.DoLoop:	move.l	.PattLoopPos,.PattBreakPos	; Force loop
		subq.l	#1,.SongPos
		move.b	#-1,.BreakFlag

		rts

.PattLoopIt:	subq.l	#1,.PattLoopCnt
		tst.l	.PattLoopCnt
		beq.s	.Return
		move.l	.PattLoopPos,.PattPos
.Return:	rts

._PatDelay:	move.l	(a2),d0 		; Get stuff
		and.l	#$f,d0
		tst.l	d0
		beq.s	.PatDelNo
		subq.l	#1,d0
		move.l	d0,d3
.PatDelLoop:	bsr.w	.AddSpeed
		dbra	d3,.PatDelLoop
.PatDelNo:	rts

.Speed: 	dc.l	0
.PattPos:	dc.l	0
.SongPos:	dc.l	0
.PattLoopPos:	dc.l	0
.PattLoopCnt:	dc.l	0
.PosJumpPos:	dc.l	0
.PattBreakPos:	dc.l	0
.BreakFlag:	dc.b	0
.CIAFlag:	dc.b	0

;********************************
;* divu_32 routine for MC68000  *
;* d0 = d0/d1                   *
;********************************
divu_32:
	move.l	d3,-(a7)
	swap	d1
	tst	d1
	bne.b	lb_5f8c
	swap	d1
	move.l	d1,d3
	swap	d0
	move	d0,d3
	beq.b	lb_5f7c
	divu	d1,d3
	move	d3,d0
lb_5f7c:
	swap	d0
	move	d0,d3
	divu	d1,d3
	move	d3,d0
	swap	d3
	move	d3,d1
	move.l	(a7)+,d3
	rts

lb_5f8c:
	swap	d1
	move	d2,-(a7)
	moveq	#16-1,d3
	move	d3,d2
	move.l	d1,d3
	move.l	d0,d1
	clr	d1
	swap	d1
	swap	d0
	clr	d0
lb_5fa0:
	add.l	d0,d0
	addx.l	d1,d1
	cmp.l	d1,d3
	bhi.b	lb_5fac
	sub.l	d3,d1
	addq	#1,d0
lb_5fac:
	dbf	d2,lb_5fa0
	move	(a7)+,d2
	move.l	(a7)+,d3
	rts

;**********************************
xpktags:	dc.l	XPK_InName
filename:	dc.l	0			; The file name to be read
		dc.l	XPK_GetOutBuf
		dc.l	outbuf			; Sets a pointer to the output buffer
		dc.l	XPK_GetOutLen
		dc.l	outlen			; Sets the number of bytes written
		dc.l	XPK_GetOutBufLen
		dc.l	outbuflen		; Sets the length of the output buffer
		dc.l	0,0

outbuf:		dc.l	0
outlen:		dc.l	0
outbuflen:	dc.l	0
xpkpacktags:	dc.l	XPK_InBuf
packadr:	dc.l	0
		dc.l	XPK_InLen
packlen:	dc.l	0
		dc.l	XPK_OutName
packname:	dc.l	0
		dc.l	XPK_PackMethod
packmethod:	dc.l	xpkpacker
		dc.l	XPK_PackMode
packeff:	dc.l	100
		ds.l	2
xpkpacker:	dc.b	'NONE'
		EVEN

;********************************
;*** iff MODL module chunks

ModConfHeader:	dc.b	'FORM'
fo_length:	dc.l	0			; modlength

fo_verh:	dc.b	'MODLVERS'		; 0 chunk version
		dc.l	fo_infoh-fo_verh	; 4 versionschunklength
fo_modver:	dc.l	0			; 8 module versionsnumber
fo_ver: 	dc.b	'PT'
		Revision	 		; Protracker Version, Long dc.l


fo_infoh:	dc.b	'INFO'
		dc.l	fo_cmnthead-fo_infoh	; chunklength
fo_songname:	dc.b	'UNNAMED SONG'
		dcb.b	20,0			; songname
fo_instr:	dc.w	0			; numbers of instruments
fo_positions:	dc.w	0			; positions
fo_patterns:	dc.w	0			; patterns
fo_volume:	dc.w	0			; mastervolume
fo_dspeed:	dc.w	125			; defaultspeed
fo_packetf:	dc.w	0			; packetfield

fo_creatdat_da: dc.w	0
fo_creatdat_mo: dc.w	0
fo_creatdat_ye: dc.w	0

fo_creattime_h: dc.w	0
fo_creattime_m: dc.w	0
fo_creattime_s: dc.w	0

fo_playtime_h:	dc.w	0
fo_playtime_m:	dc.w	0
fo_playtime_s:	dc.w	0
fo_playtime_ms: dc.w	0

;---------------- packetfield meaning	-------------
;Bit	Meaning 	0			1			 Default
;--------------------------------------------------------------------------------
; 0	Timing method.	VBlank. 		CIA timing (BPM).	      0
; 1	Filter flag.	Filter off.		Filter on.		      0
; 2	File type.	Module. 		Song (no instruments).	      0
; 3	Soft IRQ	on/off						      0
; 4	Length flag.	Equal pattern length.	Variable pattern length.      0
; 5	Voices flag.	4 voices.		8 voices.		      0
; 6	Sample res.	8 bit.			16 bit. 		      0
; 7	Packstatus.	Packed patterns.	Raw patterns.		      1
; 8	*Reserved*							      x
; 9	*Reserved*							      x
;10	*Reserved*							      x
;11	*Reserved*							      x
;12	*Reserved*							      x
;13	*Reserved*							      x
;14	*Reserved*							      x
;15	*Reserved*							      x
;--------------------------------------------------------------------------------

;*** comment and greetings chunk

fo_cmnthead:	dc.b	'CMNT'
fo_cmntlgth:	dc.l	fo_ptrnhead-fo_cmnthead
fo_author:	dc.b	'UNNAMED AUTHOR'
		dcb.b	 18,0
;fo_commlgth:	dc.l	fo_ptrnhead-fo_cmnthead ;+(fo_comments)
fo_comments:
		dcb.b	380,0			;40*9

;*** pattern chunk header

fo_ptrnhead:	dc.b	'PTDT'
fo_ptrnlgth:	dc.l	fo_formModend-fo_ptrnhead

fo_formModend:

;***

iffmhunklength: dc.l	fo_formModend-fo_verh	;length of iffmod chunk
fo_songname2:	dc.b	'UNNAMED SONG'
		dcb.b	20,0

fo_author2:	dc.b	'UNNAMED AUTHOR'
		dcb.b	 18,0

fa_creatdat_da: dc.w	0
fa_creatdat_mo: dc.w	0
fa_creatdat_ye: dc.w	0
fa_creattime_h: dc.w	0
fa_creattime_m: dc.w	0
fa_creattime_s: dc.w	0
lengthbit:	dc.l	0		; length of commentchunk

;******************************
;* internal config list       *
;******************************

PTConfHeader:
	dc.b	'FORM',0,0
	dc.w	configlength		; configlength, 476 old; $640
	dc.b	'PTCOVERS'
InternalCfgData:
	dc.w	$0000
	dc.w	$0026
	dc.w	$0000
	dc.b	1

	dc.b	'.$VER: ProTracker V'
	Revision			; Long
	dc.b	' ('
	RevDate
	dc.b	')',0

;misc config data chunk

cfgmisclgbg:

	dc.b	'MISC'
	dc.w	0
	dc.w	cfgmisclg	;$56 chunklength
	dc.w	0               ;Setbitsall, dummy
	dc.w	$A1		;Packetfield
	dc.w	$18		;TuneTone
	dc.b	0,$20		;tunevolume
	dc.b	0,$1F		;immer 1F
	dc.b	0,$7D		;bpmtempo 125
	dc.b	0,6		;defaultspeed 6
	dc.b	0,0

	dc.b	'PRT:'
	dcb.b	28,0

	dc.w	$01		;OptScrFlag
	dc.w	0		;recordmode pattern/song
	dc.b	$1A		;xpkmode
	dc.b	0		;modmode
	dc.w	$6401		;xpackmode 0=PP20 1=xpk
	dc.w	$0102		;modshortmode
	dc.b	0		;showdateflag
	dc.b	0		;cfgflag
	dc.b	01		;patt100flag
	dc.b	01		;kbdmode
	dc.w	$20,2		;KeyRepDelay
	dc.w	$0		;Volume 	00=min, B4=min
	dc.w	$01F4		;MaxPLSTEntries
	dc.w	$0001		;ScopeNumber
	dc.w	$0002		;FilterArt
	dc.b	0		;MultiFlag
	dc.b	0		;SampleAllFlag
	dc.b	0		;QuantizeValue
	dc.b	0		;MetroSpeed
	dc.b	0		;MetroChannel
	dc.b	0		;AutoInsFlag
	dc.b	$2C		;CutToBufFlag
	dc.b	$2C             ;TESTDMAFLAG
	dc.w	$01F4		;DefaultDMAWait
	dc.b	0		;pnoteflag
	dc.b	0		;sam_editflag
	dc.b	0		;HalfClipFlag
	dc.b	1		;VUSpriteMode

cfgmisclgend:

;screen config data chunk

cfgscrnlgbg:

	dc.b	'SCRN'
	dc.w	$00
	dc.w	cfgscrnlg	;$013A		;chunklength


	dc.w	$0000
	dc.w	$0008		;VModefield
	dc.w	$FFFF		;posx
	dc.w	$FFF3 		;posy

	dc.w	$0003		;color 0-8 (4Bit!)
	dc.w	$0FFF
	dc.w	$0999
	dc.w	$0000
	dc.w	$0FE0
	dc.w	$0F00
	dc.w	$000B
	dc.w	$08DE

;scope colorspread

	dc.w	$0F00,$0003,$0F20,$0003,$0F30,$0003
	dc.w	$0F50,$0003,$0F60,$0003,$0F80,$0003
	dc.w	$0F90,$0003,$0FB0,$0003,$0FC0,$0003
	dc.w	$0FE0,$0003,$0EE0,$0003,$0EF0,$0003
	dc.w	$0DF0,$0003,$0CF0,$0003,$0AE0,$0003
	dc.w	$09D0,$0003,$07C0,$0003,$06A0,$0003
	dc.w	$0490,$0003,$03A3,$0003,$03A5,$0003
	dc.w	$02B8,$0003,$01CB,$0003,$00DE,$0003

;	dc.w	$0810,$0810,$0810,$0920,$0A20,$0B30	;vumetercolors
;	dc.w	$0C30,$0D40,$0D50,$0E60,$0E60,$0F70
;	dc.w	$0F80,$0F90,$0FA0,$0FB0,$0FC0,$0FD0
;	dc.w	$0FE0,$0EE0,$0EE0,$0EF0,$0EF0,$0DF0
;	dc.w	$0DF0,$0CF0,$0CF0,$0BF0,$0AE0,$09E0
;	dc.w	$09D0,$08C0,$07C0,$06B0,$06A0,$05A0
;	dc.w	$0490,$0390,$0380,$0380,$0270,$0270
;	dc.w	$0260,$0160,$0150,$0150,$0040,$0040


	dc.w	$0254					;vushowmode

	dc.w	$0FF3,$0FE3,$0FD3,$0EC3,$0EC4,$0EB4	;analyzercolors
	dc.w	$0EA4,$0E94,$0D84,$0D74,$0D64,$0D65
	dc.w	$0C55,$0C45,$0C35,$0C26,$0C26,$0C16
	dc.w	$0C26,$0C26,$0C37,$0C37,$0B47,$0B47
	dc.w	$0B58,$0B58,$0B68,$0B68,$0B78,$0B79
	dc.w	$0B89,$0A89,$0A99,$0A9A,$0AAA,$0AAA
	dc.w	$0090,$0080,$0070,$0060

	dcb.w	151,0					;pad to 1024 bytess

cfgscrnlgend:

;edit config data chunk

cfgeditlgbg:

	dc.b	'EDIT'
	dc.w	0
	dc.w	cfgeditlg		;Chunklength

	dc.b	0
	dc.b	0
	dc.b	0
	dc.b	$2C

	dc.l	$02030401		;Multimodenext
	dc.l	$05060708

	dc.b	1
	dc.b	$18,$18,$00,$02		;splitdata
	dc.b	$1A,$18,$00,$03
	dc.b	$1C,$18,$00,$04
	dc.b	$1D,$18,$00,$01
	dc.b	$02,$02,$02,$00

	dc.b	$37,$00,$47,$03,$04

	dc.b	$0F,$06,$0C,$10,$0C	;effectmacros
	dc.b	$20,$0E,$93,$0A,$0F

cfgeditlgend:

;disk configdatas chunk

cfgdisklgbg:

	dc.b	'DISK'
	dc.w	$00
	dc.w	cfgdisklg		;chunklength
	dc.w	$0000
	dc.w	$0044			;dummy
	dc.b	1			;rawiff
	dc.b	0			;Powerpacker ratio

	;108+50 per entry

	dc.b	'ST-00:EXECUTABLE'
	dcb.b	92+50,0

	dc.b	'ST-00:MODULES'
	dcb.b	95+50,0

	dc.b	'ST-00:SONGS'
	dcb.b	97+50,0

	dc.b	'ST-00:TRACKS'
	dcb.b	96+50,0

	dc.b	'ST-01:'
	dcb.b	102+50,0

	dc.b	'ST-00:PATTERNS'
	dcb.b	94+50,0

	dc.b	'#?.EXE'
	dcb.b	26,0

	dc.b	'#?'			;#?MOD#?
	dcb.b	30,0

	dc.b	'#?'
	dcb.b	30,0

	dc.b	'#?.INS'
	dcb.b	26,0

	dc.b	'#?'
	dcb.b	30,0

	dc.b	'#?.PAT'
	dcb.b	26,0

icfgend:

configlength:	EQU icfgend-PTConfHeader-8
cfgmisclg:	EQU cfgmisclgend-cfgmisclgbg-8
cfgscrnlg:	EQU cfgscrnlgend-cfgscrnlgbg-8
cfgeditlg:	EQU cfgeditlgend-cfgeditlgbg-8
cfgdisklg:	EQU icfgend-cfgdisklgbg-8

		EVEN

;gadget coordinates for the screens

DirGadData:
	dc.l	$00010001,$00000000,$0063000A	;main menu
	dc.l	$00020001,$0000000B,$00630015	;pack on/off
	dc.l	$00030001,$00000016,$00630020	;raw/iff
	dc.l	$00040001,$00000021,$0063002B	;modmode
	dc.l	$00050001,$0000002C,$00630036	;hide/show icons
	dc.l	$00060001,$00000037,$00630041	;reset paths
	dc.l	$00070001,$00000042,$0063004C	;format disk
	dc.l	$00080001,$0000004D,$00630057	;relabel disk
	dc.l	$00090000,$00000058,$00630062	;filepattern input
	dc.l	$000A0001,$00640000,$00C7000A	;makedir
	dc.l	$000B0001,$0064000B,$00C70015
	dc.l	$000C0001,$00640016,$00C70020
	dc.l	$000D0000,$00000063,$00D8006D	;path
	dc.l	$000E0000,$0000006E,$00D80078	;filename
	dc.l	$000F0001,$02700000,$027F000A	;togglescreen
	dc.l	$00100001,$00C80000,$0103000A	;read dir
	dc.l	$00110001,$01040000,$013F000A
	dc.l	$00120001,$00D9006E,$013F0078	;dirtypetoggle
	dc.l	$00140000,$00640021,$006E002B
	dc.l	$00150001,$006F0021,$00C7002B	;save exe
	dc.l	$00160000,$0064002C,$006E0036
	dc.l	$00170001,$006F002C,$00C70036	;save module
	dc.l	$00180000,$00640037,$006E0041
	dc.l	$00190001,$006F0037,$00C70041	;save song
	dc.l	$001A0000,$00640042,$006E004C	;instrcheckmark
	dc.l	$001B0001,$006F0042,$00C7004C	;save instr
	dc.l	$001C0000,$0064004D,$006E0057
	dc.l	$001D0001,$006F004D,$00C70057	;save sample
	dc.l	$001E0000,$00640058,$006E0062
	dc.l	$001F0001,$006F0058,$00C70062	;save pattern
	dc.l	$00200000,$0270000B,$027F0015	;upgaddget scroll
	dc.l	$00210000,$02700016,$027F006C	;propscroller
	dc.l	$00220000,$0270006D,$027F0078	;downgadget scroll
	dc.l	$00250001,$00D90063,$013F006D	;FREE
	dc.l	$00260000,$01420003,$02700075
	dc.l	$00640001,$00C8000B,$01030015
	dc.l	$00650001,$0104000B,$013F0015
	dc.l	$00660001,$00C80016,$01030020
	dc.l	$00670001,$01040016,$013F0020
	dc.l	$00680001,$00C80021,$0103002B
	dc.l	$00690001,$01040021,$013F002B
	dc.l	$006A0001,$00C8002C,$01030036
	dc.l	$006B0001,$0104002C,$013F0036
	dc.l	$006C0001,$00C80037,$01030041
	dc.l	$006D0001,$01040037,$013F0041
	dc.l	$006E0001,$00C80042,$0103004C
	dc.l	$006F0001,$01040042,$013F004C
	dc.l	$00700001,$00C8004D,$01030057
	dc.l	$00710001,$0104004D,$013F0057
	dc.l	$00720001,$00C80058,$01030062
	dc.l	$00730001,$01040058,$013F0062
	dc.l	0,0,0
DirCacheGadData:
	dc.l	$00010000,$00C8000B,$013F0062
	dc.l	$000A0000,$00640021,$006E002B
	dc.l	$000B0000,$0064002C,$006E0036
	dc.l	$000C0000,$00640037,$006E0041
	dc.l	$000D0000,$00640042,$006E004C
	dc.l	$000E0000,$0064004D,$006E0057
	dc.l	$000F0000,$00640058,$006E0062
	dc.l	0,0,0
SamplerGadData:
	dc.l	$00010001,$000000D4,$002B00DE	;exit
	dc.l	$00020000,$0000008A,$027F00CB
	dc.l	$00030000,$000200CD,$027D00D4	;samdragbar X 2-27D Y CD-D4
	dc.l	$00040001,$002C00D4,$007B00DE
	dc.l	$00050001,$007C00D4,$00EF00DE
	dc.l	$00060001,$00F000D4,$013F00DE
	dc.l	$000A0001,$000000DF,$002B00F4
	dc.l	$000B0001,$002C00DF,$007B00E9
	dc.l	$000C0001,$007C00DF,$00EF00E9
	dc.l	$000D0001,$00F000DF,$013F00E9
	dc.l	$000E0001,$014000DF,$018F00E9
	dc.l	$00100001,$002C00EA,$007B00F4
	dc.l	$00110001,$007C00EA,$009600F4
	dc.l	$00120001,$009700EA,$00B100F4
	dc.l	$00130001,$00B200EA,$00EF00F4
	dc.l	$00140001,$00F000EA,$013F00F4
	dc.l	$00150001,$014000EA,$018F00F4
	dc.l	$00170001,$000000F5,$002B00FF
	dc.l	$00180001,$002C00F5,$005000FF
	dc.l	$00190001,$005100F5,$007B00FF
	dc.l	$001A0001,$007C00F5,$00B100FF
	dc.l	$001B0001,$00B200F5,$00EF00FF
	dc.l	$001C0001,$00F000F5,$013F00FF
	dc.l	$001D0001,$014000F5,$018F00FF
	dc.l	$001E0000,$019000D4,$01DF00DE
	dc.l	$001F0000,$019000DF,$01DF00E9
	dc.l	$00200000,$019000EA,$01DF00F4
	dc.l	$00220001,$019000F5,$01DF00FF
	dc.l	$00230001,$01E000D4,$022F00DE	;maximize
	dc.l	$00240001,$01E000DF,$022F00E9	;normalize
	dc.l	$00250001,$01E000EA,$022F00F4	;normalalloc
	dc.l	$00260001,$01E000F5,$022F00FF	;backwards
	dc.l	$00270001,$023000D4,$027F00DE	;Boost
	dc.l	$00280001,$023000DF,$027F00E9	;interpol
	dc.l	$00290001,$023000EA,$027F00F4	;upsample
	dc.l	$002A0001,$023000F5,$027F00FF	;downsample
	dc.l	0,0,0

SetupGadData:
	dc.l	$00010001,$00000000,$006B000A	;exit setup
	dc.l	$00020001,$0000000B,$00530015	;load config
	dc.l	$00030001,$00000016,$00530020
	dc.l	$00040000,$0054000B,$006B0020
	dc.l	$00050001,$00000021,$006B002B
	dc.l	$00060000,$006C0000,$00C1000A
	dc.l	$00070000,$00C20000,$00CC000A
	dc.l	$00080000,$00CD0000,$00D7000A
	dc.l	$00090000,$006C000B,$00C10015
	dc.l	$000A0000,$00C2000B,$00CC0015
	dc.l	$000B0000,$00CD000B,$00D70015
	dc.l	$000C0001,$006C0016,$00D70020
	dc.l	$000E0000,$00CE0021,$00D7002B	;dma down
	dc.l	$000F0000,$00C30021,$00CC002B	;dma up
	dc.l	$00100000,$01330021,$013D002B	;maxplst down
	dc.l	$00110000,$01280021,$0132002B	;maxplst up
	dc.l	$00120001,$00890058,$00D70062	;TestDMAFLAG


;*def config buttons 1-6 upto V4.0

	dc.l	$00130001,$00200063,$0042006D	;def1
	dc.l	$00140001,$00430063,$0065006D	;def3
	dc.l	$00150001,$00660063,$0088006D	;def5

	dc.l	$00160001,$0020006E,$00420078	;def2
	dc.l	$00170001,$0043006E,$00650078	;def4
	dc.l	$00180001,$0066006E,$00880078	;def6

	dc.l	$00190001,$0089004D,$00D70057	;analyz/vumeter

	dc.l	$001A0001,$01080000,$013D000A
	dc.l	$001B0000,$013E000B,$01A30036
	dc.l	$002B0001,$013E0042,$01A3004C
	dc.l	$002C0001,$013E004D,$01A30057
	dc.l	$002D0000,$013E0058,$01A30062
	dc.l	$002E0001,$013E0063,$01A3006D
	dc.l	$002F0001,$013E006E,$01A30078	;vumeter fake/real/none
	dc.l	$00400001,$0000004D,$001F0057	;copy
	dc.l	$00410001,$0020004D,$004D0057	;spread
	dc.l	$00420001,$00000058,$001F0062	;swap
	dc.l	$00430001,$00200058,$004D0062	;cancel
	dc.l	$00440001,$004E0058,$006B0062	;def
	dc.l	$00450001,$004E004D,$005C0057	;arrow up
	dc.l	$00460001,$005D004D,$006B0057	;arrow down
	dc.l	$00470000,$0051002F,$00690047	;8col block
	dc.l	$00480000,$006C002C,$00880062	;analyzer sprite
	dc.l	$00490000,$0016002E,$004E0033	;red color scroller
	dc.l	$004A0000,$00160039,$004E003E	;green slider
	dc.l	$004B0000,$00160044,$004E0049	;blue slider
	dc.l	$004C0000,$0089002C,$00D7004A	;screen movement
	dc.l	$00500001,$00D80000,$0107000A
	dc.l	$00510000,$00D8000B,$013D0015
	dc.l	$00520000,$00D80016,$01270020
	dc.l	$00530000,$01280016,$01320020
	dc.l	$00540000,$01330016,$013D0020
	dc.l	$00620000,$01A40000,$026F000A
	dc.l	$00630001,$02700000,$027F000A
	dc.l	$00640001,$01A4000B,$02110015
	dc.l	$00650001,$01A40016,$02110020
	dc.l	$00660001,$01A40021,$0211002B
	dc.l	$00670001,$01A4002C,$02110036
	dc.l	$00680001,$01A40037,$02110041
	dc.l	$00690001,$01A40042,$0211004C
	dc.l	$006A0001,$01A4004D,$02110057
	dc.l	$006B0001,$01A40058,$02110062	;Lace
	dc.l	$006C0001,$01A40063,$0211006D
	dc.l	$006D0001,$01A4006E,$02110078
	dc.l	$006E0001,$0212000B,$027F0015	;override
	dc.l	$006F0001,$02120016,$027F0020	;nosamples
	dc.l	$00700001,$02120021,$027F002B	;showdirs
	dc.l	$00710001,$0212002C,$027F0036	;loadloop
	dc.l	$00720001,$02120037,$027F0041	;autodir
	dc.l	$00730001,$02120042,$027F004C	;autoexit
	dc.l	$00740001,$0212004D,$027F0057	;multicache
	dc.l	$00750001,$02120058,$027F0062	;cuttobuff
	dc.l	$00760000,$0128006E,$01320078	;effi up
	dc.l	$00770001,$00D80063,$013D006D	;xpk mode
	dc.l	$00780001,$00D80058,$013D0062	;keyboardchange
	;dc.l	$00790000,$00D80021,$0122002B	;Setkeyrepeat (keyrepdelay)
	dc.l	$00800001,$00D8004D,$013D0057	;xpk or pp packmethod
	dc.l	$00810001,$00D8002C,$013D0036	;modshortchange
	dc.l	$00820001,$00D80037,$013D0041	;Showdate in DirWin
	dc.l	$00830001,$00D80042,$013D004C	;Modsavemethod
	dc.l	$00840001,$013E0037,$01A30041	;maxplst
	;dc.l	$00850000,$01240021,$013D002B	;KeyRepSpeed
	dc.l	$00860000,$0133006e,$013D0078	;effidown
	dc.l	$00870001,$02120063,$027F006D	;chanmode
	dc.l	$00880001,$0089006E,$00D70078	;recoversong
	dc.l	$00890001,$00890063,$00D7006D	;fontchg inputfields
	dc.l	$008A0001,$0212006E,$027F0078

	dc.l	0,0,0

DownGadData4:
	dc.l	$00010000,$0140007E,$01530086	;input patternnumber
	dc.l	$00040000,$02720097,$027B00FB	;PatternSlider
	dc.l	$00050000,$01850080,$018F0085	;Bmp Up
	dc.l	$00060000,$01900080,$019A0085	;Bmp Down
	dc.l	$00070000,$015F0080,$01690085	;Pattern Down
	dc.l	$00080000,$01540080,$015E0085	;Pattern Up

	dc.l	$00290000,$00360095,$00C100FD	;Track 1 Data
	dc.l	$002A0000,$00CA0095,$015100FD	;Track 2 Data
	dc.l	$002B0000,$015A0095,$01E200FD	;Track 3 Data
	dc.l	$002C0000,$01EA0095,$026F00FD	;Track 4 Data

	dc.l	$00310000,$004A008D,$00a80092	;Track 1 On/Off Mode 4
	dc.l	$00320000,$00dA008D,$01380092	;Track 2 On/Off Mode 4
	dc.l	$00330000,$016A008D,$01c80092	;Track 3 On/Off Mode 4
	dc.l	$00340000,$01fA008D,$02580092	;Track 4 On/Off Mode 4
	dc.l	0,0,0

DownGadData8:
	dc.l	$00010000,$0140007E,$01530086	;Pattern Nummer eingeben
	dc.l	$00040000,$02720097,$027B00FB	;PatternSlider
	dc.l	$00050000,$01850080,$018F0085	;Bmp Up
	dc.l	$00060000,$01900080,$019A0085	;Bmp Down
	dc.l	$00070000,$015F0080,$01690085	;Pattern Down
	dc.l	$00080000,$01540080,$015E0085	;Pattern Up


	dc.l	$00290000,$002E0095,$007300FD	;track 1
	dc.l	$002A0000,$00760095,$00BB00FD	;track 2
	dc.l	$002B0000,$00BC0095,$010300FD	;track 3
	dc.l	$002C0000,$01040095,$014600FD	;track 4
	dc.l	$002D0000,$01470095,$019300FD	;track 5
	dc.l	$002E0000,$01940095,$01DB00FD	;track 6
	dc.l	$002F0000,$01DC0095,$022300FD	;track 7
	dc.l	$00300000,$02240095,$027100FD	;track 8

	dc.l	$00310000,$0030008D,$006C0092	;Track 1 On/Off Mode 8
	dc.l	$00320000,$0078008D,$00B40092	;Track 2 On/Off Mode 8
	dc.l	$00330000,$00C0008D,$00FC0092	;Track 3 On/Off Mode 8
	dc.l	$00340000,$0108008D,$01440092	;Track 4 On/Off Mode 8
	dc.l	$00350000,$0150008D,$018C0092	;Track 5 On/Off Mode 8
	dc.l	$00360000,$0198008D,$01D40092	;Track 6 On/Off Mode 8
	dc.l	$00370000,$01E0008D,$021C0092	;Track 7 On/Off Mode 8
	dc.l	$00380000,$0228008D,$02640092	;Track 8 On/Off Mode 8
	dc.l	0,0,0

TrackClickGad4:

	dc.l	$00290000,$00350095,$00C300FD	;track 1	4.0
	dc.l	$002A0000,$00C50095,$015300FD	;track 2
	dc.l	$002B0000,$01540095,$01E300FD	;track 3
	dc.l	$002C0000,$01E40095,$027000FD	;track 4
	dc.l	0,0,0

TrackClickGad8:

	dc.l	$00290000,$002E0095,$007300FD	;track 1
	dc.l	$002A0000,$00760095,$00BB00FD	;track 2
	dc.l	$002B0000,$00BC0095,$010300FD	;track 3
	dc.l	$002C0000,$01040095,$014600FD	;track 4
	dc.l	$002D0000,$01470095,$019300FD	;track 5
	dc.l	$002E0000,$01940095,$01DB00FD	;track 6
	dc.l	$002F0000,$01DC0095,$022300FD	;track 7
	dc.l	$00300000,$02240095,$027100FD	;track 8

;-------------------------------------------------------------------
MainGadData:
	dc.l	$00010001,$00000000,$000A0009	;exit
	dc.l	$00020001,$02700000,$027F000A	;sreentoggle
	dc.l	$00030000,$00000016,$00F30020	;songname
	dc.l	$00040000,$00620021,$006C002B	;volume up
	dc.l	$00050000,$006D0021,$0077002B	;volume down
	dc.l	$00060000,$01330000,$013F002B	;volume slider
	dc.l	$00070001,$0028002C,$00320036	;'' insert pattern
	dc.l	$00080001,$0033002C,$003D0036	;'d' delete pattern
	dc.l	$00090000,$003E002C,$00610036	;hit pattern
	dc.l	$000A0000,$003E0037,$00610041	;numPatternlength
	dc.l	$000B0000,$003E0042,$0061004C	;num Songlength

	dc.l	$000C0001,$00F40021,$0131002B	;12 PLST
	dc.l	$000D0001,$00B60021,$00F3002B	;13 PED

	dc.l	$000E0000,$0062002C,$006C0036
	dc.l	$000F0000,$006D002C,$00770036
	dc.l	$00100000,$00620037,$006C0041
	dc.l	$00110000,$006D0037,$00770041
	dc.l	$00120000,$00620042,$006C004C
	dc.l	$00130000,$006D0042,$0077004C

	dc.l	$00140001,$0078002C,$00B50036	;play
	dc.l	$00150001,$00780037,$00B50041	;stop
	dc.l	$00160001,$00780042,$00B5004C	;continue
	dc.l	$00170001,$00B6002C,$00F30036	;pattern
	dc.l	$00180001,$00B60037,$00F30041	;record
	dc.l	$00190001,$00B60042,$00F3004C	;edit
	dc.l	$001A0001,$00F4002C,$01310036	;clear
	dc.l	$001B0001,$00F40037,$01310041	;setup
	dc.l	$001C0001,$00F40042,$0131004C	;Disk Op
	dc.l	$001D0000,$0000004D,$00F30057	;samplename
	dc.l	$001E0000,$00620058,$006C0062
	dc.l	$001F0000,$006D0058,$00770062
	dc.l	$00200000,$00620063,$006C006D
	dc.l	$00210000,$006D0063,$0077006D
	dc.l	$00220000,$0062006E,$006C0078	;
	dc.l	$00230000,$006D006E,$00770078	;
	dc.l	$00240000,$00DA0058,$00E40062
	dc.l	$00250000,$00E50058,$00EF0062
	dc.l	$00260000,$00DA0063,$00E4006D
	dc.l	$00270000,$00E50063,$00EF006D
	dc.l	$00280000,$00DA006E,$00E40078	;repeathigh
	dc.l	$00290000,$00E5006E,$00EF0078	;replenhigh
	dc.l	$002A0000,$002D0058,$00610062
	dc.l	$002B0000,$002D0063,$0061006D
	dc.l	$002C0000,$003B006E,$00610078	;
	dc.l	$002D0000,$00A50058,$00D90062
	dc.l	$002E0000,$00A50063,$00D9006D
	dc.l	$002F0000,$00A5006E,$00D90078	;
	dc.l	$00300001,$00F00058,$013F0062
	dc.l	$00310001,$00F00063,$013F006D
	dc.l	$00320001,$00F0006E,$013F0078	;samplerscreen
	dc.l	$00440001,$00F40016,$01310020	;help	 y 16-20  x FD-13F
	dc.l	$00450001,$00F4004D,$01310057	;Info button
	dc.l	$00460001,$00780021,$00B5002B	;print song
	dc.l	$00480000,$00120004,$012F0012	;copyright
	dc.l	$00490001,$0000002C,$00270036	;PosED small button
	dc.l	$004A0001,$0132002C,$013F0036	;4channel-button
	dc.l	$004B0001,$01320037,$013F0041	;8channel-button chanmode
	dc.l	$004C0001,$01320042,$013F004C	;vumetermode (none, fake, real)
	dc.l	$004D0001,$0132004D,$013F0057	; big or little vumetersprites

MainGadData2:
	;dc.l	$00330000,$01470005,$01700027	;chan1
	;dc.l	$00340000,$01770005,$01A00027	;chan2
	;dc.l	$00350000,$01A70005,$01D00027	;chan3
	;dc.l	$00360000,$01D70005,$02000027	;chan4
	dc.l	$003C0000,$0168002C,$027F0078	;gad1_7 pos
	dc.l	$003D0001,$0140002C,$01670036	;gad_1
	dc.l	$003E0001,$01400037,$01670041	;gad_2
	dc.l	$003F0001,$01400042,$0167004C	;gad_3
	dc.l	$00400001,$0140004D,$01670057	;gad_4
	dc.l	$00410001,$01400058,$01670062	;gad_5
	dc.l	$00420001,$01400063,$0167006D	;gad_6
	dc.l	$00430001,$0140006E,$01670078	;gad_7
	dc.l	$00470000,$000B0000,$027F0004	; screen move upper screen
	dc.l	$004F0001,$02080000,$023b000A	;Help
	dc.l	$004E0001,$023C0000,$026f000A	;Exit!
	dc.l	$00560001,$01400000,$0207002B	;Toggle Scope
	dc.l	0,0,0



InfoGadData:
	dc.l	$00010001,$00000000,$006b000A	;exit
	dc.l	$00020001,$01040000,$013f000A	;toggleswitch	 y=04-0E x F6-137
	dc.l	$00030001,$02700000,$027F000A	;screenswitch
	dc.l	$00040001,$00c80000,$0103000A	;exit
	dc.l	$00050000,$0270006D,$027f0078	;Down
	dc.l	$00060000,$0270000B,$027f0015	;Up
	dc.l	$00070000,$02700016,$027F006C	;propscroller
	dc.l	$00100000,$015E000C,$021D0011	;Hit First
	dc.l	$00110000,$015E0012,$021D0017
	dc.l	$00120000,$015E0018,$021D001D
	dc.l	$00130000,$015E001E,$021D0023
	dc.l	$00140000,$015E0024,$021D0029
	dc.l	$00150000,$015E002A,$021D002F
	dc.l	$00160000,$015E0030,$021D0035
	dc.l	$00170000,$015E0036,$021D003B
	dc.l	$00180000,$015E003C,$021D0041
	dc.l	$00190000,$015E0042,$021D0047
	dc.l	$001A0000,$015E0048,$021D004D
	dc.l	$001B0000,$015E004E,$021D0053
	dc.l	$001C0000,$015E0054,$021D0059
	dc.l	$001D0000,$015E005A,$021D005F
	dc.l	$001E0000,$015E0060,$021D0065
	dc.l	$001F0000,$015E0066,$021D006B
	dc.l	$0,0,0



HelpGadData:
	dc.l	$00010001,$00000000,$000A0009	;exit
	dc.l	$00020001,$026E0000,$027D0009	;screenswitch
	dc.l	$00030001,$0141006E,$01900078	;Left
	dc.l	$00040001,$0191006E,$01E00078	;empty
	dc.l	$00050001,$01E1006E,$02300078	;empty
	dc.l	$00060001,$0231006E,$027D0078	;right

	dc.l	$0,0,0

PosGadData:
	dc.l	$00010001,$00000000,$000B0009	;exit_gadget
	dc.l	$00020001,$00F6000A,$012C0014	;Insert
	dc.l	$00030001,$00F60015,$012C001F	;delete
	dc.l	$00040001,$00F60020,$012C002A	;increase
	dc.l	$00050001,$00F6002B,$012C0035	;decrease
	dc.l	$00060001,$00F60036,$012C0040	;1_empty
	dc.l	$00070001,$00F60041,$012C004B	;2_empty

	dc.l	$00080001,$00F6004C,$012C0056	;up
	dc.l	$00090001,$00F60057,$012C0061	;down

	dc.l	$000A0001,$00F60062,$012C006C	;exit_button
	dc.l	$000B0000,$00E5000B,$00F40014	;arrow up
	dc.l	$000C0000,$00E50064,$00F4006E	;arrow down
	dc.l	$000D0001,$02700000,$027F000A	;screenswitch
	dc.l	$000E0000,$00E50015,$00F0C063	;propscroller
	dc.l	$0,0,0
;-----------------------------------------------------------------
PLSTGadData:
	dc.l	$00010001,$00000000,$000B0009	;exit
	dc.l	$00020001,$02700000,$027F000A	;screenswitch
	dc.l	$00030000,$01410004,$026F0076	;23  PLSTpressed listview hit 18-63 Y, 7A-114 X
	dc.l	$00040001,$010D0000,$0140000A	;010C ExitPLST
	dc.l	$00050001,$00790000,$00AC000A	;168 ClearAllDisks
	dc.l	$00060001,$010D000B,$01400015	;010C Mountlist
	dc.l	$00070000,$00DA000B,$010B0015	;00DA TypeinDisk3
	dc.l	$00080000,$00AA000B,$00D90015	;00A8 TypeinDisk2
	dc.l	$00090000,$0078000B,$00A90015	;     TypeInDisk1
	dc.l	$000A0000,$0270000B,$027F0015	;one up 	21 2A  135 13F
	dc.l	$000B0000,$0270006D,$027F0078	;one down	65 6D  135 13F
	;dc.l	$000C0001,$01340016,$013F0020	;top		17 1F  135 13F
	;dc.l	$000D0001,$0134006E,$013F0078	;bottom 	6E 78  135 13F
	dc.l	$000E0000,$02700016,$027F006C	;propscroller

;PEDGadData:

	dc.l	$000F0000,$0002004D,$012F0076	;checkpednames 38-76   02-12F(A2)
	dc.l	$00110001,$00010037,$00660041	;Delete Disk   21-2D   00-63
	dc.l	$00120001,$0001002C,$00660036	;Deletepreset  16-20   00-63
	;dc.l	$00140001,$00010021,$0066002B	;Insert        0D-15   00-63
	dc.l	$00130001,$00010016,$00660020	;AddPath       00-0C   0B-63
	dc.l	$00150001,$00670037,$00D20041	;ClearPLST     21-2D   64-D0
	dc.l	$00160000,$008A0016,$01330020	;EnterPath     00-0C   8A-131
	dc.l	$00170001,$00D30037,$01400041	;Print	       21-2D   D0-131
	dc.l	$00180001,$00D3002C,$01400036	;WritePLST     16-20   D0-131
	dc.l	$00190001,$00D30021,$0140002B	;LoadPLST      0D-15   D0-131
	;dc.l	$001A0000,$0135004D,$01400056	;one up        39-41   135-13E
	;dc.l	$001B0000,$01350063,$0140006D	;one down      66-6D   135-13E
	;dc.l	$001C0001,$01350042,$0140004C	;start	       2E-36   135-13E
	;dc.l	$001D0001,$0135006E,$01400078	;end	       70-78   135-13E
	dc.l	$001E0000,$00640021,$00D0002B	;enter disk    0D-15	64 D0
	dc.l	0,0,0

Opt1GadData:
	dc.l	$00010000,$01680037,$01C40041
	dc.l	$00020000,$01C50037,$01CF0041
	dc.l	$00030000,$01D00037,$01DA0041
	dc.l	$00040000,$01680042,$01C4004C
	dc.l	$00050000,$01C50042,$01CF004C
	dc.l	$00060000,$01D00042,$01DA004C
	dc.l	$00070000,$0168004D,$01DA0057
	dc.l	$00080000,$01680058,$01DA0062
	dc.l	$00090001,$01680063,$01DA006D
	dc.l	$000A0001,$0168006E,$01DA0078
	dc.l	$000B0001,$022C0037,$027F0041
	dc.l	$000C0001,$022C0042,$027F004C
	dc.l	$000D0001,$022C004D,$027F0057
	dc.l	$000E0001,$022C0058,$027F0062
	dc.l	$000F0001,$022C0063,$027F006D
	dc.l	$00100001,$022C006E,$027F0078
	dc.l	0,0,0
Opt2GadData:
	dc.l	$00010001,$01680042,$0196004C
	dc.l	$00020001,$0168004D,$01960057
	dc.l	$00030001,$01680058,$01960062
	dc.l	$00040001,$01680063,$0196006D
	dc.l	$00050001,$01970042,$01C4004C
	dc.l	$00060001,$0197004D,$01C40057
	dc.l	$00070000,$01970058,$01AE0062
	dc.l	$00080000,$01AF0058,$01B90062
	dc.l	$00090000,$01BA0058,$01C40062
	dc.l	$000A0000,$01970063,$01AE006D
	dc.l	$000B0000,$01AF0063,$01B9006D
	dc.l	$000C0000,$01BA0063,$01C4006D
	dc.l	$000D0001,$01C50042,$01F2004C
	dc.l	$000E0001,$01C5004D,$01F20057
	dc.l	$000F0001,$01C50058,$01F20062
	dc.l	$00100001,$01C50063,$01F2006D
	dc.l	$00110001,$01F30042,$0221004C
	dc.l	$00120001,$01F3004D,$02210057
	dc.l	$00130001,$01F30058,$02210062
	dc.l	$00140001,$01F30063,$0221006D
	dc.l	$00150001,$02220042,$0240004C
	dc.l	$00160000,$02410042,$0269004C
	dc.l	$00170000,$026A0042,$0274004C
	dc.l	$00180000,$02750042,$027F004C
	dc.l	$00190001,$0222004D,$02400057
	dc.l	$001A0000,$0241004D,$02690057
	dc.l	$001B0000,$026A004D,$02740057
	dc.l	$001C0000,$0275004D,$027F0057
	dc.l	$001D0001,$02220058,$02500062	;FU
	dc.l	$001E0001,$026A0058,$027F0062	;FD
	dc.l	$001F0001,$02510058,$02690062
	dc.l	$00200001,$02220063,$0240006D
	dc.l	$00210000,$02410063,$0269006D
	dc.l	$00220000,$026A0063,$0274006D
	dc.l	$00230000,$02750063,$027F006D
	dc.l	$00240001,$02470037,$027F0041
	dc.l	$00250001,$01680037,$01A00041
	dc.l	0,0,0
Opt3GadData:
	dc.l	$00010000,$01680042,$01A5004C
	dc.l	$00020000,$01A60042,$01B0004C
	dc.l	$00030000,$01B10042,$01BB004C
	dc.l	$00040000,$01680058,$01A50062
	dc.l	$00050000,$01A60058,$01B00062
	dc.l	$00060000,$01B10058,$01BB0062
	dc.l	$00070000,$01BC0042,$01F9004C
	dc.l	$00080000,$01FA0042,$0204004C
	dc.l	$00090000,$02050042,$020F004C
	dc.l	$000A0001,$01BC0058,$020F0062
	dc.l	$000B0001,$01BC004D,$020F0057
	dc.l	$00140000,$0168006E,$018F0078
	dc.l	$00150000,$0190006E,$01B70078
	dc.l	$00160000,$01B8006E,$01DF0078
	dc.l	$00170000,$01E0006E,$02070078
	dc.l	$00180000,$0208006E,$022F0078
	dc.l	$00190000,$0230006E,$02570078
	dc.l	$001A0000,$0258006E,$027F0078
	dc.l	0,0,0
Opt4GadData:
	dc.l	$00010000,$01680037,$027F0057
	dc.l	$00020001,$01680058,$01F30062
	dc.l	$00030001,$01F40058,$027F0062
	dc.l	$00040001,$01F4006E,$02390078
	dc.l	$00050001,$023A006E,$027F0078
	dc.l	$000A0000,$01680063,$01A8006D
	dc.l	$000B0000,$01A90063,$01DD006D
	dc.l	$000C0000,$01DE0063,$01E8006D
	dc.l	$000D0000,$01E90063,$01F3006D
	dc.l	$000E0000,$0168006E,$01A80078
	dc.l	$000F0000,$01A9006E,$01DD0078
	dc.l	$00100000,$01DE006E,$01E80078
	dc.l	$00110000,$01E9006E,$01F30078
	dc.l	$00120000,$01F40063,$0234006D
	dc.l	$00130000,$02350063,$0269006D
	dc.l	$00140000,$026A0063,$0274006D
	dc.l	$00150000,$02750063,$027F006D
	dc.l	0,0,0


Opt5GadData:
	dc.l	$00010001,$023B006E,$027F0078	;create
	dc.l	$00020000,$01A40037,$027F0041	;modname
	dc.l	$00030000,$01A40042,$027f004C	;author
	dc.l	$00040000,$023B0058,$027f0062	;revision
	dc.l	$00050001,$023B0063,$027F006D	;comment
	dc.l	0,0,0

Opt6GadData:
	dc.l	$00010000,$01A60043,$01CE004C	;pattern
	dc.l	$00020000,$01A6004D,$01CE0056	;start
	dc.l	$00030000,$01A60058,$01CE0061	;end
	dc.l	$00040000,$01A60063,$01CE006C	;to
	dc.l	$00050001,$01E5006E,$02230078	;grabspeed
	dc.l	$00060001,$01E50063,$0223006D	;grabsample
	dc.l	$00070000,$01A60037,$01CE0041	;hitpitch
	dc.l	$00080000,$01A6006E,$01CE0078	;cia speed
	dc.l	$00090001,$01E50058,$02230062	;grab endpos
	dc.l	$000A0001,$02240037,$027F0041	;filter
	dc.l	$000B0001,$02240042,$027F004C	;boost
	dc.l	$000C0000,$0224004D,$027F0057	;?
	dc.l	$000D0001,$01E50037,$02230041	;grab all
	dc.l	$000E0001,$01E50042,$0223004C	;grab pattern
	dc.l	$000F0001,$01E5004d,$02230057	;grab startpos
	dc.l	$00100000,$01Cf0037,$01d90041	;ButtonUp
	dc.l	$00110000,$01da0037,$01E40041	;ButtonDown
	dc.l	$00120000,$01Cf0042,$01d9004c	;.
	dc.l	$00130000,$01da0042,$01E4004c	;.
	dc.l	$00140000,$01Cf004d,$01d90057
	dc.l	$00150000,$01da004d,$01E40057
	dc.l	$00160000,$01Cf0058,$01d90062
	dc.l	$00170000,$01da0058,$01E40062
	dc.l	$00180000,$01Cf0063,$01d9006d
	dc.l	$00190000,$01da0063,$01E4006d
	dc.l	$001A0000,$01Cf006e,$01d90078
	dc.l	$001B0000,$01da006e,$01E40078
	dc.l	$001C0001,$0224006e,$027F0078	;New Mix It
	dc.l	0,0,0

Opt7GadData:
	dc.l	$00010001,$01680037,$01C70041	;Change
	dc.l	$00020001,$01C80037,$01F50041	;Cut
	dc.l	$00030001,$01F60037,$02230041	;Copy
	dc.l	$00040001,$02240037,$02510041	;Paste
	dc.l	$00050001,$02520037,$027f0041	;Clear
	dc.l	$00060001,$01C80042,$01F5004C	;Insert
	dc.l	$00070001,$01F60042,$0223004C	;Delete
	dc.l	$00080001,$02240042,$0251004C	;Flip
	dc.l	$00090001,$02520042,$027F004C	;Exchange
	dc.l	$000A0001,$01680042,$0197004C	;OctUp
	dc.l	$000B0001,$01980042,$01C7004C	;OctDown
	dc.l	$000C0001,$0168004D,$01970057	;NoteUp
	dc.l	$000D0001,$0198004D,$01C70057	;NoteDown
	dc.l	$000E0001,$01C8004D,$01F50057	;Scroll Up
	dc.l	$000F0001,$01F6004D,$02230057	;Scroll Down
	dc.l	$00100001,$0224004D,$02510057	;Rotate Up
	dc.l	$00110001,$0252004D,$027F0057	;Rotate Down

	dc.l	0,0,0

Opt8GadData:
	dc.l	$00010001,$02540070,$027F0078	;exit
	dc.l	$00020000,$01410039,$027F003F	;l1
	dc.l	$00030000,$0141003F,$027F0045	;l2
	dc.l	$00040000,$01410045,$027F004B	;l3
	dc.l	$00050000,$0141004B,$027F0051	;l4
	dc.l	$00060000,$01410051,$027F0057	;l5
	dc.l	$00070000,$01410057,$027F005D	;l6
	dc.l	$00080000,$0141005D,$027F0063	;l7
	dc.l	$00090000,$01410063,$027F0069	;l8
	dc.l	$000A0000,$01410069,$027F006F	;l9
	dc.l	$000B0001,$022A0070,$02550078	;clear
	dc.l	0,0,0
MousXKoorTabl:
	dc.l	$00010001,$00C90062,$00F9006C
	dc.l	$00030001,$01870062,$01B7006C
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0
lbL019418:
	dc.l	$00010001,$00C90062,$00F9006C
	dc.l	$00020001,$01280062,$0158006C
	dc.l	$00030001,$01870062,$01B7006C
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0
CopyrightsGadData:
	dc.l	$00020001,$01280062,$0158006C
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0
TRTGadgData:
	dc.l	$00010001,$00CA0062,$00FF006C
	dc.l	$00020001,$01070062,$013C006C
	dc.l	$00030001,$01440062,$0179006C
	dc.l	$00040001,$01810062,$01B6006C
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0
lbL0194C0:
	dc.l	$00010001,$00C90062,$00F9006C
	dc.l	$00030001,$01870062,$01B7006C
	dc.l	$00040000,$0108004C,$01B60056
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0
lbL0194FC:
	dc.l	$00010001,$00CA0062,$00F8006C
	dc.l	$00020001,$01250062,$015B006C
	dc.l	$00030001,$01880062,$01B6006C
	dc.l	$00040000,$013F0037,$014C0041
	dc.l	$00050000,$013F0044,$014C004E
	dc.l	$00060001,$019C0037,$01B60041
	dc.l	$00070001,$019C0044,$01B6004E
	dc.l	$00080000,$01080053,$01B6005D
	dc.l	$000A0001,$02700000,$027F000A
	dc.l	0,0,0


;---------------------------------------------

SampleMonGadGFX:
	dc.l	$00010000,$000000C8,$000B0006,$00350003
	dc.b	'Sample Monitor',0,0
	dc.l	$00010000,$000B00C8
	dc.l	$002C0002,$00070010,$00BA0022,$00050000,$00080011
	dc.l	$00B80020,$00090003,$00060020,$00090001,$00C10020
	dc.w	0
SampClrGFX:
	dc.l	$00050000,0,$00C80037
	dc.w	0
FormatGadGFX:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0006,$004E0008
	dc.b	'Verify',0,0

	dc.l	$0001007F,$0005000E,$000B0006,$00480015
	dc.b	'Icons',0

	dc.l	$0001007F,$0012000E,$000B0006,$00B00008

	dc.b	'Floppy',0,0
	dc.l	$000100DC,$0005001B,$000B0006,$00A50015

	dc.b	'FileSys',0
	dc.l	$000100DC,$0012001B,$000B0006,$000A0024

	dc.b	'DiskName'
	dc.l	2,$00480021,$00AF000B
	dc.l	$0001000A,$0030002F,$000B0006,$000D0033

	dc.b	'Format',0,0
	dc.l	$00010065,$00300037,$000B0006,$00680033

	dc.b	'QFormat',0
	dc.l	$000100C8,$0030002F,$000B0006,$00CB0033

	dc.b	'Cancel',0,0,0,0
lbL0196AE:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0002,$0009001A,$00EE000B,$0006003C,$00325072
	dc.l	$65737320,$45534320,$746F2061,$626F7274,$2E2E2E00
	dc.w	0
SureYesNoData:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$00090030,$0031000B,$000100C7,$00300031
	dc.l	$000B0006,$00170033,$59657300,$000600D9,$00334E6F
	dc.l	0
lbL01972C:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$00090030,$0031000B,$000100C7,$00300031
	dc.l	$000B0006,$000C0033,$52657375,$6D650000,$000600CA
	dc.l	$00334361,$6E63656C,0
ReqGFXCopyRight:
	dc.l	$00050000,0,$02000067,$00030002,$000101FC
	dc.l	$00650001,$00E80057,$0031000B,$000600EB,$005A5265
	dc.l	$73756D65,0
lbL0197A4:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$00680030,$0031000B,$0006006B,$00335265
	dc.l	$73756D65,0
lbL0197D4:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$00680030,$0031000B,$0006006B,$00335265
	dc.l	$73756D65,0
lbL019804:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$00090030,$0031000B,$00010068,$00300031
	dc.l	$000B0001,$00C70030,$0031000B,$0006001B,$00333331
	dc.l	6,$006B0033,$43616E63,$656C0000,$000600D8
	dc.l	$00333135,0
lbL01985C:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0002,$0048001A,$00AF000B,$00010009,$00300031
	dc.l	$000B0001,$00C70030,$0031000B,$0006001B,$00334F4B
	dc.l	6,$00CA0033,$43616E63,$656C0000
	dc.w	0
lbL0198AA:
	dc.l	$00050000,0,$01000040,$00030002,$000100FC
	dc.l	$003E0001,$000A0030,$0036000B,$00010047,$00300036
	dc.l	$000B0001,$00840030,$0036000B,$000100C1,$00300036
	dc.l	$000B0006,$00180033,$536F6E67,6,$00490033
	dc.l	$53616D70,$6C657300,$00060095,$0033416C,$6C000006
	dc.l	$00C70033,$43616E63,$656C0000
	dc.w	0

;********************************

	IFEQ	packedpics

PTPic:			INCBIN 'ptsource:data/ptmain4.fimp'
Opt1Data:		INCBIN 'ptsource:Data/1_Opt.fimp'
Opt2Data:		INCBIN 'ptsource:Data/2_Opt.fimp'
Opt3Data:		INCBIN 'ptsource:Data/3_Opt.fimp'
Opt4Data:		INCBIN 'ptsource:Data/4_Opt.fimp'
Opt5Data:		INCBIN 'ptsource:Data/5_Opt.fimp'
Opt6Data:		INCBIN 'ptsource:Data/6_Opt.fimp'
Opt7Data:		INCBIN 'ptsource:Data/7_Opt.fimp'
Opt8Data:		INCBIN 'ptsource:Data/8_Opt.fimp'
DirScreenData:		INCBIN 'ptsource:Data/DirScreen.fimp'
SetupScreenData:	INCBIN 'ptsource:Data/Setupscreen.fimp'
SampScreenData: 	INCBIN 'ptsource:Data/SamplScreen.fimp'
Channels4:		INCBIN 'ptsource:Data/Channels_4.fimp'
Channels8:		INCBIN 'ptsource:Data/Channels_8.fimp'
HelpScreenData: 	INCBIN 'ptsource:Data/HelpScreen.fimp'
PLSTData:		INCBIN 'ptsource:Data/PosPLST2.fimp'
InfoGFXData:		INCBIN 'ptsource:Data/InfoScreen.fimp'
PosGFXData:		INCBIN 'ptsource:Data/PosEdScreen.fimp'

	ELSE

PTPic:			INCBIN 'ptsource:data/ptmain4.iff'
Opt1Data:		INCBIN 'ptsource:Data/1_Opt.iff'
Opt2Data:		INCBIN 'ptsource:Data/2_Opt.iff'
Opt3Data:		INCBIN 'ptsource:Data/3_Opt.iff'
Opt4Data:		INCBIN 'ptsource:Data/4_Opt.iff'
Opt5Data:		INCBIN 'ptsource:Data/5_Opt.iff'
Opt6Data:		INCBIN 'ptsource:Data/6_Opt.iff'
Opt7Data:		INCBIN 'ptsource:Data/7_Opt.iff'
Opt8Data:		INCBIN 'ptsource:Data/8_Opt.iff'
DirScreenData:		INCBIN 'ptsource:Data/DirScreen.iff'
SetupScreenData:	INCBIN 'ptsource:Data/Setupscreen.iff'
SampScreenData: 	INCBIN 'ptsource:Data/SamplScreen.iff'
Channels4:		INCBIN 'ptsource:Data/Channels_4.iff'
Channels8:		INCBIN 'ptsource:Data/Channels_8.iff'
HelpScreenData: 	INCBIN 'ptsource:Data/HelpScreen.iff'
PLSTData:		INCBIN 'ptsource:Data/PosPLST2.iff'
InfoGFXData:		INCBIN 'ptsource:Data/InfoScreen.iff'
PosGFXData:		INCBIN 'ptsource:Data/PosEdScreen.iff'

	ENDC

VolBoxData:   		INCBIN 'ptsource:Data/PTVolume.RAW'
SureBoxData:		INCBIN 'ptsource:Data/SureBox.RAW'
NotStandardSongData:	INCBIN 'ptsource:Data/NStand_req.RAW'
NoMemGFXData:		INCBIN 'ptsource:Data/NoMem_req.RAW'
ClearSongGFXdata:	INCBIN 'ptsource:Data/ClearSong_req.RAW'
FontData:		INCBIN 'ptsource:Data/PTFont_nor.RAW'
FontData2:		INCBIN 'ptsource:Data/PTFont_old.RAW'
Fonts:			INCBIN 'ptsource:data/fontdatas.raw'
CopyrightBoxGFX:	INCBIN 'ptsource:data/copyright2.raw'

	IFEQ	packedpics

ScopeGfxData1:		INCBIN 'ptsource:Data/scope1.fimp' 	; PTLogo
ScopeGfxData2:		INCBIN 'ptsource:Data/scope2.fimp' 	; 4 ChannelScope
ScopeGfxData3:		INCBIN 'ptsource:Data/scope3.fimp' 	; Analyzer
ScopeGfxData4:		INCBIN 'ptsource:Data/scope4.fimp' 	; StereoScope
;ScopeGfxData5:		INCBIN 'ptsource:Data/scope5.fimp'
ScopeGfxData6:		INCBIN 'ptsource:data/scope6.fimp'	; octascope

	ELSE

ScopeGfxData1:		INCBIN 'ptsource:Data/scope1.raw' 	; PTLogo
ScopeGfxData2:		INCBIN 'ptsource:Data/scope2.raw' 	; 4 ChannelScope
;ScopeGfxData3:		INCBIN 'ptsource:Data/scope3.raw' 	; Analyzer
ScopeGfxData4:		INCBIN 'ptsource:Data/scope4.raw' 	; StereoScope
;ScopeGfxData5:		INCBIN 'ptsource:Data/scope5.raw' 	; MonoScope
ScopeGfxData6:		INCBIN 'ptsource:data/scope6.raw'	; octascope

	ENDC

ExePlayer:		incbin 'ptsource:data/exeplayer.bin'

;**************************
;* internal defcolors 1-6 *
;**************************

def1data:		INCBIN 'PTSource:data/configs/confdata1.bin'
def2data:		INCBIN 'PTSource:data/configs/confdata2.bin'
def3data:		INCBIN 'PTSource:data/configs/confdata3.bin'
def4data:		INCBIN 'PTSource:data/configs/confdata4.bin'
def5data:		INCBIN 'PTSource:data/configs/confdata5.bin'
def6data:		INCBIN 'PTSource:data/configs/confdata6.bin'

;***************************
;*   tunetone values       *
;***************************
TToneData:		dc.b	0,25,49,71,91,106,118,126
			dc.b	127,126,118,106,91,71,49,25
			dc.b    0,-25,-49,-71,-91,-106,-118,-126
			dc.b 	-127,-126,-118,-106,-91,-71,-49,-25


;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

	SECTION	 ProtrackerBitmap,DATA_C


PTBitMap:	ds.b	40960
ReqTxtGFX1:	INCBIN 'ptsource:Data/ReqTxt1.RAW'
ReqTxtGFX2:	INCBIN 'ptsource:Data/ReqTxt2.RAW'

;*********** Beginn regulre 3.15 copperlist ******

copper:
CopperList:
	dc.l    $01fc0000	; MAKES ECS-COPPERLIST WORK IN AGA MODE 100%
	dc.l	$01003300	; bplcon0
	dc.l	$01020000	; bplcon1
	dc.l	$01040024	; bplcon2 (24)
				; bb=sprite color bank ???
	dc.l	$01060063	; bplcon3, bank0
					; x4x=lores sprite
					; x8x=hires sprite
					; xCx=superhires sprite
					; x0x=normal ECS sprite
					; Exx=set lo=nibbles of 24bit palette $180..
					; Cxx=set hi-nibbles of 24bit palette



copper_bpl_regs:
	dc.l	$01080000	; BPL1MOD
	dc.l	$010A0000	; BPL2MOD
	dc.l	$01000211	; BPLCON0
	dc.l	$010c0011	; aabb	aa=bitplane color bank ???

copper_spr_pt:
copsprit:
	dc.l	$01200000	; sprite 0 high
	dc.l	$01220000	; sprite 0 low
	dc.l	$01240000	; sprite 1 high
	dc.l	$01260000	; sprite 1 low
	dc.l	$01280000	; sprite 2 high
	dc.l	$012A0000	; sprite 2 low
	dc.l	$012C0000	; sprite 3 high
	dc.l	$012E0000	; sprite 3 low
	dc.l	$01300000	; sprite 4 high
	dc.l	$01320000	; sprite 4 low
	dc.l	$01340000	; sprite 5 high
	dc.l	$01360000	; sprite 5 low
	dc.l	$01380000	; sprite 6 high
	dc.l	$013A0000	; sprite 6 low
	dc.l	$013C0000	; sprite 7 high
	dc.l	$013E0000	; sprite 7 low


copper_bpl_pt:
CopListBitPlanes:
	dc.l	$00E00000	; Bitplane 0 high
	dc.l	$00E20000	; Bitplane 0 low
	dc.l	$00E40000	; Bitplane 1 high
	dc.l	$00E60000	; Bitplane 1 low
	dc.l	$00E80000	; Bitplane 2 high

NoteBplptrHigh=*-2

	dc.l	$00EA0000	; Bitplane 2 low

NoteBplptrLow=*-2

;*****************************************
CopListColors:

col32:
	dc.l	$01A20AAA	; Color 17
	dc.l	$01A40888	; Color 18
	dc.l	$01A60666	; Color 19
	dc.l	$01A00000	; Color 16
	dc.l	$01800000	; Color 0
CopCol0=*-2
	dc.l	$01820AAA	; Color 1
	dc.l	$01840777	; Color 2
	dc.l	$01860444	; Color 3
	dc.l	$01880CCC	; Color 4
CopCol4=*-2
	dc.l	$018A0A00	; Color 5
	dc.l	$018C0000	; Color 6
	dc.l	$018E004D	; Color 7
	dc.l	$01AE0A00	; Color 23
	dc.l	$01AA0700	; Color 21
	dc.l	$01AC0400	; Color 22

;********************************
lbB02F79A:	dc.l	$008E2C81
lbB02F79E:	dc.l	$00902CC1

lbW02F7A2:	dc.l	$0092003C
lbW02F7A6:	dc.l	$009400D4
		dc.l	$01080000
		dc.l	$010A0000

lbW02F7B2:	dc.l	$01020000
		dc.l	$01040024
;********************************
lbB02F7B8:	dc.l	$2C07FFFE	; wait 2C, pos 07
SamCopFT:	dc.l	$0100B300	; bplcon0

;********************************
lbB02F7C0:	dc.l	$5801FF00
		dc.l	$009C8010
;********************************

CopListAnalyzer:
		dcb.l	162,$01FE0000

CopListInsPos:	dc.l	$BB07FFFE	; wait for line b8,pos 07

NoteColoB:	dc.l	$0100A300	; bplcon0

;CopListColors=+1

CopListBpl4:	dc.l	$00E80000	; Bitplane 4 high
		dc.l	$00EA0000	; Bitplane 4 low
NoteCol:	dc.l	$0188004D	; color 4

lbB02FA64:	dc.l	$C207FFFE	; Wait for line C2, pos 07
VALCopLisa:	dc.l	$0100B300	; bplcon0
;********************************
NoteColoCo:	dc.l	$01AA0000
;********************************

CopListMark2:	dcb.l	672/2,$01FE01FE

lbB02FFB0:	dc.l	$F007FFFE	; wait for line $F0, pos 07

;col32:	MACRO
		dc.l	$01B20000	; color 1
		dc.l	$01B40000	; color 2
		dc.l	$01B60000	; color 3
		dc.l	$01BA0000	; color 5
		dc.l	$01BC0000	; color 6
		dc.l	$01BE0000	; color 7
;	ENDM

copper_color_hi_256:

		dc.l	$01060063	; bplcon3, bank0
					; x4x=lores sprite
					; x8x=hires sprite
					; xCx=superhires sprite
					; x0x=normal ECS sprite
					; Exx=set lo=nibbles of 24bit palette $180..
					; Cxx=set hi-nibbles of 24bit palette

;		col32

lbW02FFCC:	dc.l	$FFDFFFFE	; Wait for line $FF, pos $DF
lbB02FFD0:	dc.l	$2907FFFE	; Wait for line $29, pos $07
VALCopLisb:	dc.l	$0100A300	; bplcon0

copper_spr_res:	DC.L	$010600A3	;$0063=140ns  $00A3=70ns

		dc.l	$FFFFFFFE	; wait for Line $FF,pos FF

;****************************

Coplist2:
	dc.l	$B607FFFE	; Wait for line $B6, pos $07
	dc.l	$0188004D	; Color 4
cpl2ptr1=*-2

	dc.l	$01B200F0	; LoopSprite color
	dc.l	$01BA00FF	; PlayPos Sprite color
	dc.l	$FFFFFFFE	; Wait for line $FF, pos $FE
cpl2ptr2:
	dc.l	0,0
	dc.w	0

;******************************
;* PT's MousePointer-Sprite   *
;******************************
PointerSpriteData:
	dc.b	%11000101,%01100000,%11010101,%00000001
	dc.b	%11000000,%00000000,%01000000,%00000000
	dc.b	%01110000,%00000000,%10110000,%00000000
	dc.b	%00111100,%00000000,%01001100,%00000000
	dc.b	%00111111,%00000000,%01000011,%00000000
	dc.b	%00011111,%11000000,%00100000,%11000000
	dc.b	%00011111,%11000000,%00100000,%00000000
	dc.b	%00001111,%00000000,%00010001,%00000000
	dc.b	%00001101,%10000000,%00010010,%10000000
	dc.b	%00000100,%11000000,%00001001,%01000000
	dc.b	%00000100,%01100000,%00001000,%10100000
	dc.b	%00000000,%00100000,%00000000,%01000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

;******************************
;* Edit-Cursor in 8chn-mode   *
;* old Name: CursorSpriteData *
;******************************
Cursor8chn:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00011110,%00000000,%00011110,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00010010,%00000000,%00000000,%00000000
	dc.b	%00011110,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00011110,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

;******************************
;* Edit-Cursor in 4chn-mode   *
;******************************

Cursor4chn:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11111110,%00000000,%11111110,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%10000010,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%11111110,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

EmptySprite:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

;******************************
;* Text-Cursor in edit-mode   *
;******************************

LineCurSpriteData:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00111100,%00000000,%00000000,%00000000
	dc.b	%00111100,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

;******************************

;******************************

ScrollerSprite1:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000
	dc.b	%00111111,%00000000,%00000000,%00000000

ScrollerSprite2:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11111000,%00000000,%11110000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%11110000,%00000000,%10001000,%00000000
	dc.b	%10000000,%00000000,%01111000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11000000,%11000000,%00111111,%11000000

; sprite for vumetersprites below in trackerlistview, big

vumetersprite_big:	macro
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%11000000,%11000000,%00111111,%11000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11000000,%11000000,%00111111,%11000000

	endm

vumetersprite_little:	macro
	dc.b	%11101001,%01101001,%11101010
	dc.b	%00000001,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00100001,%00000000,%00011111
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%01100101,%01101110,%01100100
	dc.b	%01100101,%00000000,%00000000

	endm

VUSpriteData1B:	vumetersprite_big
VUSpriteData2B:	vumetersprite_big
VUSpriteData3B:	vumetersprite_big
VUSpriteData4B:	vumetersprite_big
VUSpriteData5B:	vumetersprite_big
VUSpriteData6B:	vumetersprite_big
VUSpriteData7B:	vumetersprite_big
VUSpriteData8B:	vumetersprite_big

VUSpriteData1L:	vumetersprite_little
VUSpriteData2L:	vumetersprite_little
VUSpriteData3L:	vumetersprite_little
VUSpriteData4L:	vumetersprite_little
VUSpriteData5L:	vumetersprite_little
VUSpriteData6L:	vumetersprite_little
VUSpriteData7L:	vumetersprite_little
VUSpriteData8L:	vumetersprite_little

LoopSpriteData1:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00010000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

LoopSpriteData2:
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%11110000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000

PlayPosSpriteData:

	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000
	dc.b	%00000000,%00000000,%00000000,%00000000
	dc.b	%10000000,%00000000,%00000000,%00000000


;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

	SECTION  ProtrackerTrackdisk,BSS_C

lbL030B18:	ds.l	1408		;trackdisk buf
lbL032118:	ds.l	1408		;dito
lbL033718:	ds.l	256		;dito
lbL033B18:	ds.l	128		;dito
Wr_TxtBuf:	ds.l	1
PattBlkSize:	ds.l	15120		;old 15120		;sum 18321

;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*

	SECTION  ProtrackerRegs,BSS

;MSamPointer:	ds.b	256+800+800+800+800+8
;SPOINT1:	EQU	MSamPointer+800
;SPOINT2:	EQU	MSamPointer+800+800
;SPOINT3:	EQU	MSamPointer+800+800+800
;SPOINT4:	EQU	MSamPointer+800+800+800+800

MSamPointer:	ds.l	$0040
SPOINT1:	ds.l	$00C8
SPOINT2:	ds.l	$00C8
SPOINT3:	ds.l	$00C8
SPOINT4:	ds.l	$00C9

;*************************************
;* 1 channel = 44 bytes		     *
;* ds.b	=> 44*32 32 chans            *
;*************************************

audchan1temp:	ds.l	5
audchan11temp:	ds.w	12
audchan12temp:	ds.b	$002C		; on/off

audchan2temp:	ds.l	5
audchan21temp:	ds.w	12
audchan22temp:	ds.b	$002C

audchan3temp:	ds.l	5
audchan31temp:	ds.w	12
audchan32temp:	ds.b	$002C

audchan4temp:	ds.l	5
audchan41temp:	ds.w	12
audchan42temp:	ds.b	$002C

audchan5temp:	ds.l	5
audchan51temp:	ds.w	12
audchan52temp:	ds.b	$002C

audchan6temp:	ds.l	5
audchan61temp:	ds.w	12
audchan62temp:	ds.b	$002C

audchan7temp:	ds.l	5
audchan71temp:	ds.w	12
audchan72temp:	ds.b	$002C

audchan8temp:	ds.l	5
audchan81temp:	ds.w	12
audchan82temp:	ds.b	$002C

irq0veks:	ds.l	1
irq1veks:	ds.l	1
irq2veks:	ds.l	1
irq3veks:	ds.l	1

FileInfoBlock:	ds.b	256
FIB_EntryType:	EQU	FileInfoBlock+4
FIB_FileName:	EQU	FileInfoBlock+8
FIB_FileSize:	EQU	FileInfoBlock+124
FIB_DateStamp:	EQU	FileInfoBlock+132
InfoData:	ds.b	586			; LockAndGetInfo LVOInfo struct

DecrunchBig:	ds.b	6144			; DecrPointer for Requesters

TrackBuffer:	ds.b	256
CmdsBuffer:	ds.b	256
BlockBuffer:	ds.b	256
Blocks2Buffer:	ds.b	256
PatternBuffer:	ds.b	1024*2
UndoBuffer:	ds.b	1024*2
vartrackbuffer:	ds.l	MaxPattPos+1		; buf for 1 track flip

DecrCopyPtr:	ds.b	146818			; buf for copyright requester
		EVEN

;--- trackdisk.device pointers ---

TrackDiskIORequest:	ds.l	20
TrackDiskPort:		ds.l 	4
TaskAddr:		ds.l 	4
MsgPortAddr:		ds.l 	17

SplitTransTable:	ds.b 	38
SplitInstrTable:	ds.b 	39

VUSpriteMode:	ds.b	1			; vumeterspritemode little/big flag
PoPacratio:	ds.b	1
RAWIFFMode:	ds.b	1
VUShowMode:	ds.b	2
xpkmode:	ds.b	2
TESTDMAFLAG:	ds.b	2
patt100flag:	ds.b	2
kbdmode:	ds.b	2			; keyboard us-english or german
xpackmode:	ds.b	2
modshortmode:	ds.b	2			; mod in filenames yes or no
showdateflag:	ds.b	2
CfgFlag:	ds.b	2
modmode:	ds.b	2			; save iff v3 or old PT modules
savmodmod:	ds.b	2
CfgDummy4:	ds.b	3
Packetfield:	ds.b	1
CfgDummy2:	ds.b	3
VModeField:	ds.b	1
CfgDummy3:	ds.b	3
CutToBufFlag:	ds.b	1
CfgDummy1:	ds.w	1
InfoOnOff:	ds.b	1
PackMode:	ds.b	1

PrintSongPath:	ds.b	32
ColorTable:	ds.b	16			; 16 colors from screen

VUMeterColors:	ds.w	48
AnalyzerColors:	ds.l	20

SplitData:	ds.l	4
MultiModeNext:	ds.l	1
MultiModeNext8:	ds.l	1
KeyRepDelay:	ds.w	1
KeyRepSpeed:	ds.w	1

EffectMacros:	ds.w	10
BPMTempo:	ds.w	1
TuneTone:	ds.w	1
TToneVol:	ds.w	1
DefaultSpeed:	ds.w	1

ModulesPath2:	ds.b	98	; 48+50	;exe
		ds.b	98	; 48+50	;mod
		ds.b	98	; 48+50	;song
		ds.b	98	; 48+50	;track
		ds.b	98	; 48+50	;sample
		ds.b	98	; 48+50	;pattern
		ds.b	98
		ds.b	98

FilePatternData:
		ds.b	98	; 48+50
		ds.b	98	; 48+50
		ds.b	98	; 48+50
		ds.b	98	; 48+50
		ds.b	98	; 48+50
		ds.b	98	; 48+50
		ds.b	98
		ds.b	98

MatchPatterns:	ds.b	48
		ds.b	48
		ds.b	48
		ds.b	48
		ds.b	48
		ds.b	48
		ds.b	48
		ds.b	48

InpDefBuf:	ds.l	8
		ds.w	1
inputdevtags:	ds.l	12

ScopeInfo:	ds.b	20*8			;20*4
ScopeSamInfo:	ds.l	$007C			; 124
BlankSample:	ds.l	$00A0			;640 try 320*2 from V2.1

FileName:	ds.b	110			; many filename rotines
NewFileName:	ds.b	110			; filename for rename function
FileNameCfg:	ds.b	110			; included since 3.5X for configfile

SampleFileName: ds.b	28
DirInputName:	ds.b	30
NewInputName:	ds.b	30
TempSampArea:	ds.l	190
SaveColors:	ds.l	44

PresetNameText: ds.b	22

AudioDevbuf:	ds.l	17
		ds.w	1
audiodevtags:	ds.l	20
lbL0504A0:	ds.l	2048

fi_GFXBUF:	ds.l	67	; buffer for the unfinnished extra sample part of V3.15
		ds.w	1

fi_GFXCHI:	ds.l	67
		ds.w	1

fourbytebuf:	ds.l	4

SetupData:	ds.l	1
CfgBuf:		ds.l	configlength
		;ds.w	1

HelpTextIndex:	ds.l	256
HelpTextData:	ds.b	(ScreenWidth*2)*16+16



	END
