;****************************************************************************
; Filename: REALLOC.ASM
;   Author: Peter Andersson
;  Version: 0.3
;  Created: 1995.03.12
;  Updated: -
;****************************************************************************
; Copyright 1994, Peter Andersson.
; All rights reserved.
;****************************************************************************
; Function: PVOID @realloc(PVOID ptr,ULONG size)
;  Comment: Resizes a previously allocated block. If the block pointer is NULL
;           a new block will be allocated and if the block size if zero then
;           it will free the block.
;    Input: Eax - memory block to resize
;           Edx - new size of the block
;  Returns: Pointer to the resized memory block (except when freeing when it
;           returns a NULL(0) pointer) or 0 if it failed.
;****************************************************************************

	Include	STDDEF.INC
	Include	"MEMORY.INC"

	Codeseg

Proc	realloc ,2
		TestZ	Edx
		Jz	@@FreeBlk
		Cmp	[Eax-Size AllocBlock+AllocBlock.Ident],ALLOCID
		Jne	@@Exit01
		TestZ	Eax
		Jz	@@AllocBlk
		Push	Eax,Edx
		Call	@resize
		TestZ	Eax
		Jz	@@MoveBlk
		Add	Esp,8
		Ret
	Align	4
@@FreeBlk:	Call	@free
@@Exit01:	Clear	Eax
@@Exit02:	Ret
	Align	4
@@AllocBlk:	Mov	Eax,Edx
		Call	@malloc
		Ret
	Align	4
@@MoveBlk:	Mov	Eax,[Esp]
		Call	@malloc
		TestZ	Eax
		Jz	@@Exit02
		Mov	Edx,[Esp+4]
		Mov	Ecx,[Esp]
		Add	esp,8
		Call	@memcpy
		Ret
Endp

	End
