;
;                        Mouse routines for DOS32
;
;                        Written by Adam Seychell
;
;
;Comments:      All mouse functions here except "MouseDriver" must not be
;               called unlease a mouse driver is installed in the system.
;
;****************************************************************************
;    Function: int MouseDriver();
; Description: Resets the mouse driver.
;      Return: nonzero if mouse driver is installed and zero if not.
;
;****************************************************************************
;    Function: void SetMouseHandler(void * event_hanlder);
; Description: Sets the current mouse event handler and will be called when
;              the mouse is moved or a button is pressed/released.
;              When the handler is called the following external
;              varibles are set with the mouse information
;
;              integer  Micky_X              ; Horizontal micky count
;              integer  Micky_Y              ; Vertical micky count
;              byte     LeftButton           ; 1 if pressed and 0 if released
;              byte     RightButton          ; 1 if pressed and 0 if released
;
;              To free the current mouse event handler simply reset the
;              mouse driver by calling "MouseDriver"
;
;    Returns: nothing
;      Notes: When the program terminates it must reset the mouse driver
;              (by calling MosueDriver) to disable the current mouse event 
;              handler. Otherwise the mouse driver will continue calling the
;              mouse event procedure.
;****************************************************************************
;
.386
.Model Flat ,C

Include MOUSE.INC

        .CODE


;----------------------------------------------------------------------------
MouseDriver PROC
        Mov     Ax,0000h
        Int     33h
        Movsx   Eax,ax
        Ret
MouseDriver ENDP



;----------------------------------------------------------------------------
;
;  Format of the Real Mode Call frame used by the DPMI service for switching
; to and from Real Mode
;
Real_mode_Call_Struct STRUC
RealMode_EDI         DD     ?
RealMode_ESI         DD     ?
RealMode_EBP         DD     ?
                     DD     ?                  ; Unused
RealMode_EBX         DD     ?
RealMode_EDX         DD     ?
RealMode_ECX         DD     ?
RealMode_EAX         DD     ?
RealMode_flags       DW     ?
RealMode_ES          DW     ?
RealMode_DS          DW     ?
RealMode_FS          DW     ?
RealMode_GS          DW     ?
RealMode_IP          DW     ?
RealMode_CS          DW     ?
RealMode_SP          DW     ?
RealMode_SS          DW     ?
Real_mode_Call_Struct ENDS

Align 4

Micky_X                 DD      ?
Micky_Y                 DD      ?
Current_Event_Handler   DD      ?
LeftButton              DB      ?
RightButton             DB      ?
MiddleButton            DB      ?


Mouse_RM_CallStruct     Real_mode_Call_Struct <>



SetMouseHandler PROC  Event_HandlerPtr :Dword

        mov     eax,Event_HandlerPtr
        mov     Current_Event_Handler,eax

        mov     Esi,Offset ISR_Handler
        mov     Ax,0EE20h               ; Set real mode call back ( RETF )
        int     31h
        jc ExitError                  ; returns CX:DX -> real mode call back

        mov     BX,CX


        Mov     ax,000Ch               ; DEFINE mouse event handler
        mov     cx,01111111b
                                       ; ES:DX -> handler


        push dword ptr   0              ; set  SS:SP = 00:00
        sub     esp,10                  ; ignore  CS, IP ,FS, GS, DS
        push    BX
        db 66h,9Ch              	; pushf  16bit
        pushad
        mov     edi,esp
        mov     ax,0300h
        xor     cx,cx
        mov     bl,33h                  ; call mouse handler
        int     31h                     ; Emulate V86 interrupt
        popad
        db 66h,9Dh                      ; popf  16bit
        lea     esp,[esp+16]            ; Ignore SS,SP,CS,IP,FS,GS,ES & DS
        dec     ax
        jz ExitError

okk:
        mov     eax,-1
        Ret

ExitError:
        xor     eax,eax
        Ret

SetMouseHandler ENDP




;-------------------------------------------------------------------------
;
;                        THE  MAIN  MOUSE  HANDLER
;
;-------------------------------------------------------------------------
ISR_Handler PROC FAR
        retf
        push    es
        push    ds

        mov     ax,SEG ISR_Handler
        mov     ds,ax
        mov     es,ax

        Test    bl, 001b
        Setne   LeftButton
        Test    bl, 010b
        Setne   RightButton
        Test    bl, 100b
        Setne   MiddleButton
        Movsx   Edi,di
        Movsx   Esi,si
        Mov     Micky_X, esi
        Mov     Micky_Y, edi

        Call    [Current_Event_Handler]
        pop     ds
        pop     es
        retf

;                       MOUSE HANDLER ENDS
;
ISR_Handler ENDP


End
