; REALMODE.ASM
;
;     Example on hooking a real mode interrupt.
;
; This program will hook real mode interrupt 24h which is the DOS critical
; error handler. Normally the command interpreter ( e.g COMMAND.COM )
; hooks this interrupt and displays a message on the screen asking the user
; to Abort, Ignore, Fail or Retry the operation.
; The protected mode critical error handler below works in a similar way.
;
;
.386
.model flat
.stack

.data

Address_Zero            DD ?
Old_RM_Int24h_vector    DD ?
return_code             db ?

.code

dummyfile    db 'a:\d',0
mesg1        db ' Please remove disk from drive A, so that the INT 24h critical error is called.'
             db 13,10,13,10,'Press any key ...',13,10,36
exit_mesg    db 'Program is exiting ',13,10,36


start:

  ; Call get DOS32 address information. We need to find a pointer that
  ; will address physical location zero.

    mov    AX,0EE02h
    int    31h
    neg    ebx
    mov    Address_Zero,ebx

  ;
  ; Save the real mode INT 24h vector before we modify it
  ;
    mov    esi,Address_Zero
    mov    eax,[esi+24h*4]
    mov    Old_RM_Int24h_vector,eax


   ;
   ; Allocate a real mode call back address ( for an IRET stack frame).
   ;
    mov     ax,0EE21h
    mov     esi,Offset CallBack_Handler
    int     31h
    jc Exit


   ;
   ; Set the real mode INT 24h vector to the returned real mode address (CX:DX)
   ;
    mov    esi,Address_Zero
    mov    [esi+24h*4],dx
    mov    [esi+24h*4+2],cx


  ; Display a message to let the user know the critical error handler
  ; is about to be invoked.
    mov     edx,offset mesg1
    mov     ah,9
    int     21h
    mov     ah,0            ; wait for a key
    int     16h

  ;
  ; Access drive A just to make DOS invoke INT 24h.
  ;
    mov     ax,3D00h
    mov     edx,offset dummyfile
    int     21h

   ;
   ; Restore the origonal real mode INT 24h vector
   ;
    mov    esi,Address_Zero
    mov    eax,Old_RM_Int24h_vector
    mov    [esi+24h*4],eax

   ;
   ; Exit program with a message.
   ;
        mov     edx,offset exit_mesg
        mov     ah,9
        int     21h
Exit:   mov     ax,4c00h
        int     21h


;************************************************************************
;
; THE CRITICAL ERROR HANDLER
;
;************************************************************************
CallBack_Handler PROC FAR
        push 	ds                                 ; Save registers used
    	pushad
        mov    	ax,_DATA                           ; load DS with data selector
        mov     ds,ax

        mov     edx,offset Error_message
        mov     ah,9
        int     21h

  ; Loop around to read the keyboard
  ;

getkeyLOOP:
        mov     ah,0            ; get key
        int     16h
        cmp     ah,17h
        jne  J09
         mov    return_code,0   ; ignore
         jmp gotkey
J09:
        cmp     ah,21h
        jne  J08
         mov    return_code,3   ; Fail
         jmp gotkey
J08:
        cmp     ah,13h
        jne  J07
         mov    return_code,1   ; Try again
         jmp gotkey
J07:
	jmp getkeyLOOP
gotkey:


        popad
        mov     al,return_code
        pop     ds
    	retf                    ; Return from the Real Mode call back.

Error_message  LABEL BYTE
db 13,10
db ' The critical error handler has been invoked (protected mode) ',10,13,10
db ' Please select one of the following actions ',13,10
db ' F) fail',13,10
db ' R) retry',13,10
db ' I) ignore',13,10
db '$'

CallBack_Handler ENDP

end start
