;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; FunkyOBJ - interface to FUNKLITE.ASM                                     ;
;                                                                          ;
; FunkTracker by JsNO/SuperReal - 1994,1995                                ;
;                                                                          ;
; This routine is for people who are coding in anything other than TASM    ;
; ideal mode. An "INCLUDE attachment" is alot more convinent, as you can   ;
; access any internal memory references or routines without the headache of;
; defining them globally. However this is totally impractical for DOS32    ;
; ASM, DOS32 C or MASM people.                                             ;
;                                                                          ;
; It's also handly if you have any variable references that clash with any ;
; existing code.                                                           ;
;                                                                          ;
; Following is an explaination of each of the essential routines needed    ;
; to play a FNK module in memory.                                          ;
;                                                                          ;
;CF FNK_autodetect(BL)                                                     ;
;---------------------                                                     ;
;expects BL : 0 = PAS16 card override                                      ;
;             1 = GUS card override                                        ;
;             2 = Creative Labs cards override                             ;
;            FF = at routines discretion (will typically be this value)    ;
;                                                                          ;
;Returns CF :CY = detection failed. no card detected                       ;
;            CN = Card found, proceed.                                     ;
;                                                                          ;
;Will autodetect your soundcard. It will test and detect soundcards in     ;
;the order of PAS, GUS and CT cards, so if you have a GUS and a CT card    ;
;in the one machine (like me), and you want to play music thru your SB16   ;
;card, then you're going to have to override the thing.                    ;
;                                                                          ;
;NB/ Only run this once at the start of your demo.                         ;
;                                                                          ;
;CF FNK_card_init(EAX,EBX)                                                 ;
;---------------------                                                     ;
;expects EAX:   = pointer to allocated DMA memory                          ;
;                                                                          ;
;Returns CF :CY = init failed....halt and catch fire                       ;
;            CN = inited, proceed.                                         ;
;                                                                          ;
;This routine setups up the mixxing routines so that it's paging           ;
;DMA in backround.                                                         ;
;                                                                          ;
;void FNK_setup_player(EAX)                                                ;
;--------------------------                                                ;
;expects EAX:   = funksong pointer                                         ;
;                                                                          ;
;Returns    :   = nothing                                                  ;
;                                                                          ;
;This inits, resets all the trackers variables etc. It accepts (EAX)       ;
;a pointer, pointing to your funk song in memory, as your load a funk      ;
;file _whole_ in memory, or your fuknsong could even be attached           ;
;to an executable, whatever, you must have a contingous funky song         ;
;in memory from header to sample block.                                    ;
;                                                                          ;
;void FNK_PLAY(void)                                                       ;
;-------------------                                                       ;
;expects    :nothing                                                       ;
;                                                                          ;
;Returns    :nothing                                                       ;
;                                                                          ;
;This tells the tracker to PLAY                                            ;
;                                                                          ;
;void FNK_STOP(void)                                                       ;
;-------------------                                                       ;
;expects    :nothing                                                       ;
;                                                                          ;
;Returns    :nothing                                                       ;
;                                                                          ;
;This tells the tracker to STOP                                            ;
;                                                                          ;
;void FNK_card_deinit(void)                                                ;
;--------------------------                                                ;
;expects    :nothing                                                       ;
;                                                                          ;
;Returns    :nothing                                                       ;
;                                                                          ;
;Deinits the card. To be used at the very end of your demo. Never run      ;
;this twice in a row. and don't ever run this without initialising the     ;
;card first.                                                               ;
;                                                                          ;
;ZF FNK_teststatus(void)                                                   ;
;-----------------------                                                   ;
;expects    :nothing                                                       ;
;                                                                          ;
;Returns    :ZY = Song currently playing                                   ;
;            ZN = Song has stopped                                         ;
;                                                                          ;
;void FNK_set_mvolume(AL)                                                  ;
;------------------------                                                  ;
;expects    :AL = master volume value to set                               ;
;                                                                          ;
;Returns    :nothing                                                       ;
;                                                                          ;
;use this to set the current master volume (handly for fading songs in     ;
;and out)                                                                  ;
;                                                                          ;
;AL FNK_get_mvolume(void)                                                  ;
;------------------------                                                  ;
;expects    :nothing                                                       ;
;                                                                          ;
;Returns    :AL = current master volume                                    ;
;                                                                          ;
;used to get the current master volume (ditto)                             ;
;                                                                          ;
;Instructions for general operation                                        ;
;----------------------------------                                        ;
;                                                                          ;
;After you have ran FNK_autodetect and CF FNK_card_init(EAX), you would    ;
;use the three followiing routines to setup and play a song.               ;
;                                                                          ;
;FNK_setup_player                                                          ;
;FNK_PLAY                                                                  ;
;FNK_STOP                                                                  ;
;                                                                          ;
;you can use these any number of times, typically in this sequence:        ;
;                                                                          ;
;FNK_setup_player                                                          ;
;FNK_PLAY                                                                  ;
;                                                                          ;
;(first song playing)                                                      ;
;                                                                          ;
;FNK_STOP                                                                  ;
;FNK_setup_player                                                          ;
;FNK_PLAY                                                                  ;
;                                                                          ;
;(second song playing)                                                     ;
;                                                                          ;
;.                                                                         ;
;.                                                                         ;
;.                                                                         ;
;.                                                                         ;
;FNK_STOP                                                                  ;
;                                                                          ;
;etc                                                                       ;
;                                                                          ;
;COMPILING                                                                 ;
;---------                                                                 ;
; tasmx funkobj                                                            ;
; tasmx <your code>                                                        ;
; dlink [-Sdos32.exe] [debug.obj] funkobj <your OBJ> [, <your EXE>]        ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 0
codeseg

public                FNK_autodetect
public                FNK_card_deinit
public                FNK_card_init
public                FNK_setup_player
public                FNK_PLAY
public                FNK_STOP
public                FNK_teststatus
public                FNK_set_mvolume
public                FNK_get_mvolume

include "funklite.asm"

end
