#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "libbr404.h"
#include "tune.h"

static HANDLE stdout;
static void *Track;

void print(const char *bla)
{
	unsigned long bw;
	int len=-1;
	while (bla[++len]);
	WriteFile(stdout,bla,len,&bw,0);
}


#ifdef NDEBUG
extern "C" void mainCRTStartup()
#else
void main()
#endif
{
	stdout=GetStdHandle(STD_OUTPUT_HANDLE);

	print("\nFarbrausch BR404 Tiny Music Player\n");
	print("BR404 Code Copyright (C) 2004-2008 BeRo^Farbrausch\n");

  Track=SynthCreate(SynthReadBMFSampleRate((void *)&TrackData,TrackSize),2048,1,1);

  SynthReadBMF(Track,(void *)&TrackData,TrackSize);

  print("\n\nPlaying \"");
  print(SynthGetTrackName(Track));
  print("\" from \"");
  print(SynthGetTrackAuthor(Track));
  print("\"...\n");

  print("\nComments: \"");
  print(SynthGetTrackComments(Track));
  print("\"...\n");

  SynthPlay(Track);

  int startTicks = GetTickCount();

	print("\n\npress ESC to quit\n");
	while (GetAsyncKeyState(VK_ESCAPE)>=0)
  {
    Sleep(10);
  }

  SynthEnter(Track);
  SynthStop(Track);
  SynthLeave(Track);

  SynthDestroy(Track);
	ExitProcess(0);
}
