#ifndef LIBBR404_H_
#define LIBBR404_H_

#ifdef __cplusplus
extern "C"
{
#endif

#define slNONE 0
#define slFORWARD 1
#define slPINGPONG 2
#define slBACKWARD 3

#pragma pack(push,1)
struct SynthEvent {
 long long Time;
 long long ID;
 char Command;
 char Data[4];
 SynthEvent *Previous;
 SynthEvent *Next;
 long long SampleIndex;
};
#pragma pack(pop)

void*__stdcall SynthCreate(int SampleRate,int BufferSize,int ThreadPlay,int SoundOutput);
void __stdcall SynthDestroy(void *Track);

int __stdcall SynthGetTrackSize();

void* __stdcall SynthInit(void *Track,int SampleRate,int BufferSize,int ThreadPlay,int SoundOutput);
void* __stdcall SynthReinit(void *Track,int SampleRate,int BufferSize);
void __stdcall SynthDone(void *Track);

void __stdcall SynthLink(void *Track,void *ToTrack);
void __stdcall SynthUnlink(void *Track);

void __stdcall SynthSetAGC(void *Track,int AGC);
void __stdcall SynthSetClipping(void *Track,int Clipping);
void __stdcall SynthSetLooping(void *Track,int Looping);

char* __stdcall SynthGetTrackName(void *Track);
char* __stdcall SynthGetTrackAuthor(void *Track);
char* __stdcall SynthGetTrackComments(void *Track);
void* __stdcall SynthGetBuffer(void *Track);
SynthEvent* __stdcall SynthGetRootEvent(void *Track);

void __stdcall SynthSetBufferStartHook(void *Track,void* __stdcall Hook(void *));
void __stdcall SynthSetBufferEndHook(void *Track,void* __stdcall Hook(void *));
void __stdcall SynthSetEventHook(void *Track,void* __stdcall Hook(void *,void *));

void* __stdcall SynthCreateTrackSample(void *Track,int LoopMode,int LoopStart,int LoopEnd,int SustainLoopMode,int SustainLoopStart,int SustainLoopEnd);
void __stdcall SynthDestroyTrackSample(void *TrackSample);

void* __stdcall SynthCreateTrackSampleInstance(void *TrackSample);
void __stdcall SynthDestroyTrackSampleInstance(void *TrackSampleInstance);

void __stdcall SynthStartTrackSampleInstance(void *TrackSampleInstance); 
void __stdcall SynthStopTrackSampleInstance(void *TrackSampleInstance); 

void __stdcall SynthKeyOffTrackSampleInstance(void *TrackSampleInstance);
void __stdcall SynthUpdateTrackSampleInstance(void *TrackSampleInstance);

void __stdcall SynthSetTrackSampleInstanceVolume(void *TrackSampleInstance,float Volume);
void __stdcall SynthSetTrackSampleInstancePanning(void *TrackSampleInstance,float Panning);
void __stdcall SynthSetTrackSampleInstancePanningLeftRight(void *TrackSampleInstance,float PanningLeft,float PanningRight);
void __stdcall SynthSetTrackSampleInstancePitch(void *TrackSampleInstance,float Pitch);

void __stdcall SynthResetVoices(void *Track);
void __stdcall SynthResetChannels(void *Track); 
void __stdcall SynthReset(void *Track); 

void __stdcall SynthAddEvent(void *Track,SynthEvent *NewEvent); 

int __stdcall SynthReadBankInformations(void *Track,char *Data,unsigned int DataSize); 
int __stdcall SynthReadBank(void *Track,void *Data,unsigned int DataSize); 
int __stdcall SynthReadSMF(void *Track,void *Data,unsigned int DataSize); 
int __stdcall SynthReadBMFInformations(void *Track,void *Data,unsigned int DataSize); 
unsigned int __stdcall SynthReadBMFSampleRate(void *Data,unsigned int DataSize); 
int __stdcall SynthReadBMF(void *Track,void *Data,unsigned int DataSize); 

void __stdcall SynthFreeTrack(void *Track); 
void __stdcall SynthClearTrack(void *Track); 

void __stdcall SynthChangeTempo(void *Track);
void __stdcall SynthChangeTempoEx(void *Track,int NewTicksPerQuarterNote,int NewTempo);

void __stdcall SynthResetEventQuery(void *Track);

void __stdcall SynthFillBuffer(void *Track,int Samples); 
void __stdcall SynthFillOutputBuffer(void *Track,void *OutputData); 

long long __stdcall SynthSeekToSample(void *Track,long long DestSample); 
long long __stdcallSynthSeekToMS(void *Track,long long DestMS); 

long long __stdcall SynthTimePosition(void *Track); 
long long __stdcall SynthSamplePosition(void *Track); 

long long __stdcall SynthGetTimePosition(void *Track); 
long long __stdcall SynthGetSamplePosition(void *Track); 

void __stdcall SynthPoll(void *Track); 

void __stdcall SynthCreateThread(void *Track); 
void __stdcall SynthExitThread(void *Track); 

void __stdcall SynthPlay(void *Track); 
void __stdcall SynthStop(void *Track); 

void __stdcall SynthEnter(void *Track); 
void __stdcall SynthLeave(void *Track); 

#ifdef __cplusplus
}
#endif

#endif
