Program SBI2INS;       {SBI to INS converter, made by Lone Ranger/AcmE}

Uses CRT,DOS;

type
    SBIformat = record
              ID      : array[0..3] of char;
              Name    : array[0..31] of byte;
              Multi   : word;
              Volume  : word;
              Attack  : word;
              Sustain : word;
              Waveform: word;
              FMFB    : byte;
              Dummy   : array[0..3] of byte;
              end;
    INSformat = record
              FMFB    : byte;
              Multi   : word;
              Attack  : word;
              Sustain : word;
              WaveForm: word;
              Volume  : word;
              Name    : array[0..15] of byte;
              end;

var
   DirInfo      : SearchRec;

   Fin          : File of SBIformat;
   Fout         : File of INSformat;
   InBuf        : SBIformat;
   OutBuf       : INSformat;

   SearchStringPos:integer;

   x            : integer;

begin
     WriteLn('SBI to INS converter, (c) Copyright 1993 by Lone Ranger/AcmE');
     WriteLn;

     FindFirst('*.SBI', Archive, DirInfo);
     if DosError <> 0 then
        begin
             WriteLn('No SBI files found in current directory!');
             WriteLn;
             Halt(1)
        end;
     while DosError = 0 do
           begin
                Write('Converting '''+DirInfo.Name+'''..        '+chr(13));

                Assign(Fin,DirInfo.Name);
                ReSet(Fin);
                Read(Fin, InBuf);
                close(Fin);

{-- converting values from SBIformat to INSformat (InBuf to OutBuf) --}

                for x:=0 to 15 do OutBuf.Name[x]:=InBuf.Name[x];
                OutBuf.FMFB:=InBuf.FMFB;
                OutBuf.Multi:=InBuf.Multi;
                OutBuf.Attack:=InBuf.Attack;
                OutBuf.Sustain:=InBuf.Sustain;
                OutBuf.WaveForm:=InBuf.WaveForm;
                OutBuf.Volume:=InBuf.Volume;

                SearchStringPos:=Pos('.SBI', DirInfo.Name);
                Delete(DirInfo.Name, SearchStringPos, 4);
                Insert('.INS', DirInfo.Name, SearchStringPos);

                Assign(Fout, DirInfo.Name);
                ReWrite(Fout);
                Write(Fout, OutBuf);
                Close(Fout);

                FindNext(DirInfo);
           end;
     WriteLn('All SBI files converted.           ');
     WriteLn;
end.
