; FastCD
; A small and fast Audio CD Player
;
;           Author: Johan Prins
; Internet address: jprins@dmrt.nl

.model small
.code
.286

org	 100h

FastCD:

jmp start

NoMSCDEX	db	'FastCD requires MSCDEX.EXE',0Dh,0Ah,'$'
Drive		db	?
Key		dw	?
data		dd	?
Tracks		dd	30 dup (?)
DEC8		dd	?

old_bar		db	104 dup (?)

BAR LABEL BYTE
        DB      '',3,'',115,'',115,''
        DB      115,' ',121,'F',117,'a',117,'s',117,'t',117,'C',117,'D'
        DB      117,' ',117,'',127,' ',127,'T',113,'r',113,'a',113,'c'
        DB      113,'k',113,':',113,' ',113,' ',113,' ',113,' ',113,''
        DB      113,' ',113,' ',113,' ',113,':',113,' ',113,' ',113,':'
        DB      113,' ',113,' ',113,' ',127,'',127,' ',127,'V',117,'o'
        DB      117,'l',117,':',117,' ',117,' ',117,' ',117,'',112,' '
        DB      117,' ',117,' ',117,'',115,'',115,'',115,'',115

IOCTL		db	13 dup (0)	;ReqHdr
		db	0		;media descriptor byte
		dd	?		;transfer address
		dw	?		;bytes to transfer
		dw	0		;starting sector
		dd	0		;pointer to req. volume

DiskInfo	db	10		;control block code
		db	?		;lowest track
		db	?		;highest track
		dd	?		;starting point of lead-out track

TrakInfo	db	11		;control block code
		db	?		;Track number
		dd	?		;starting point of track
		db	?		;Track control info

LocHead		db	1		;control block code
		db	0		;addressing mode
		dd	?		;location of drivehead

Play		db	13 dup (0)	;request header
		db	1		;addressing mode
		dd	?		;starting sector
		dd	?		;number of sector to play

Stop		db	13 dup(0)	;request header

AudInfo		db	3		;control block code
		db	?		;input channel for output channel 0
		db	?		;volume for output channel 0
		db	?		;input channel for output channel 1
		db	?		;volume for output channel 1
		db	?		;input channel for output channel 2
		db	?		;volume for output channel 2
		db	?		;input channel for output channel 3
		db	?		;volume for output channel 3

QInfo		db	12		;control block code
		db	?		;Control and ADR byte
		db	?		;Track #
		db	?		;point/index
		db	?		;Track min
		db	?		;Track sec
		db	?		;Track frame
		db	?		;Track zero
		db	?		;disk min
		db	?		;disk sec
		db	?		;disk frame

start:	
	xor	bx,bx
	mov	ax,1500h
	int	2Fh			;Get Nr of CD-ROM drives
	cmp	bx,0			;Nr of CD-ROM drives
	jz	NoMSCD			;0 -> driver not installed
	mov	Drive,cl		;CL contains 1st drive letter
	jmp	Found
NoMSCD:	mov	dx,offset NoMSCDEX
	mov	ah,09h
	int	21h
	jmp	exit

Found:	mov	Drive,cl		;CL contains 1st drive letter
	call	getbar
	lea	si,bar
	call	putbar

	call	GetAudInfo
	mov	dl,AudInfo[2]
	shr	dl,2
	mov	si,112
	call	dec8out
	mov	dl,AudInfo[4]
	shr	dl,2
	mov	si,118
	call	dec8out

	call	GetDiskInfo		;Get # of tracks
	call	GetDiskInfo		;Twice if first time failed...

	xor	ch,ch
	mov	cl,DiskInfo[2]		;Last track
	cmp	cl,0			;No tracks...exit
	jne	Trks
	jmp	exit

Trks:	call	GetTrackInfo
	les	ax,dword ptr TrakInfo[2]
	mov	di,cx
	shl	di,2
	mov	word ptr Tracks[di+2],es
	mov	word ptr Tracks[di],ax
	loop	Trks

	call	GetAudInfo

no_key:
	call	QChannelInfo
	mov	al,QInfo[2]		;contains track nr. as it appears on CD
					;AL needs conversion:
	mov	dl,al
	and	dl,000001111b		;save low nibble
	and	al,011110000b		;save high nibble
	shr	al,4
	mov	bl,0Ah
	mul	bl			;multiply high nibble by 10
	add	dl,al
	xor	dh,dh
	mov	di,dx
	mov	si,70
	call	dec8out
	mov	dl,QInfo[4]
	mov	si,80
	call	dec8out
	mov	dl,QInfo[5]
	mov	si,86
	call	dec8out
	mov	dl,QInfo[6]
	mov	si,92
	call	dec8out

	mov	ah,01h
	int	16h
	jz	no_key			;keypressed?
	xor	ah,ah
	int	16h
	mov	key,ax			;read scancode and char
	
	cmp	ah,19h			; P or p    (play)
	jne	Key_S
	mov	di,1
	call	StopCD
	call	PlayCD
	jmp	no_key

Key_S:	cmp	ah,1Fh			;S or s     (stop)
	jne	KeyPgUp
	call	StopCD
	jmp	no_key

KeyPgUp:cmp	ax,4900h		;PgUp       (skip to next track)
	jne	KeyPgDn
	xor	cx,cx
	mov	cl,byte ptr DiskInfo[2]
	cmp	cx,di
	jne	nomax
	mov	di,0
 nomax:	inc	di
	call	StopCD
	call	PlayCD
	jmp	no_key

KeyPgDn:cmp	ax,5100h		;PgDn       (skip to prev. track)
	jne	Key_Up
	cmp	di,1
	jne	nomin
	mov	cx,0001
	add	cl,byte ptr DiskInfo[2]
	mov	di,cx
 nomin:	dec	di
	call	StopCD
	call	PlayCD
	jmp	no_key

Key_Up: cmp	ax,4800h
	jne	Key_Dn
	add	AudInfo[2],4
	add	AudInfo[4],4
	call	PutAudInfo
	mov	dl,AudInfo[2]
	shr	dl,2
	mov	si,112
	call	dec8out
	mov	dl,AudInfo[4]
	shr	dl,2
	mov	si,118
	call	dec8out
	jmp	no_key

Key_Dn: cmp	ax,5000h
	jne	Key_Lf
	sub	AudInfo[2],4
	sub	AudInfo[4],4
	call	PutAudInfo
	mov	dl,AudInfo[2]
	shr	dl,2
	mov	si,112
	call	dec8out
	mov	dl,AudInfo[4]
	shr	dl,2
	mov	si,118
	call	dec8out
	jmp	no_key

Key_Lf: cmp	ax,4B00h
	jne	Key_Rg
	sub	AudInfo[4],4
	call	PutAudInfo
	mov	dl,AudInfo[4]
	shr	dl,2
	mov	si,118
	call	dec8out
	jmp	no_key

Key_Rg: cmp	ax,4D00h
	jne	Key_ESC
	sub	AudInfo[2],4
	call	PutAudInfo
	mov	dl,AudInfo[2]
	shr	dl,2
	mov	si,112
	call	dec8out
	jmp	no_key

Key_ESC:cmp	ax,011Bh		;ESC (exit program)
	je	exit
	jmp	no_key


exit:	
	lea	si,old_bar
	call	putbar
	mov ax,4C00h
	int 21h

ToCD	proc
	push	ax
	push	bx
	push	cx
	mov	ax,1510h
	xor	ch,ch
	mov	cl,Drive
	les	bx,data
	int	2Fh
	pop	cx
	pop	bx
	pop	ax
	ret
endp	ToCD

GetDiskInfo	proc
	mov	IOCTL[2],3		;Command code

	mov	ax,cs
	mov	word ptr IOCTL[16],ax	;transfer address
	mov	ax,offset DiskInfo
	mov	word ptr IOCTL[14],ax	;transfer address

	mov	IOCTL[18],7		;bytes to transfer

	mov	ax,cs
	mov	word ptr data[2],ax	;address of IOCTL record
	mov	ax,offset IOCTL
	mov	word ptr data,ax	;address of IOCTL record

	call	ToCD			; Diskinfo[1,2] contains 1st & last trk

	xor	bx,bx
	mov	bl, byte ptr DiskInfo[2]
	mov	di,bx
	inc	di
	shl	di,2
	les	ax,dword ptr DiskInfo[3]
	mov	word ptr Tracks[di+2],es	;end of disc
	mov	word ptr Tracks[di],ax
	ret

endp	GetDiskInfo

GetTrackInfo	proc
	mov	IOCTL[2],3		;command code
	
	mov	ax,cs
	mov	word ptr IOCTL[16],ax	;transfer address
	mov	ax,offset TrakInfo
	mov	word ptr IOCTL[14],ax	;transfer address

	mov	IOCTL[18],7

	mov	TrakInfo[1],cl		;contains track number

	mov	ax,cs
	mov	word ptr data[2],ax	;address of IOCTL record
	mov	ax,offset IOCTL
	mov	word ptr data,ax

	call	ToCD
	ret
endp	GetTrackInfo

PutAudInfo	proc			;DL=left, DH=right volume
	mov	IOCTL[2],12		;command code
	
	mov	ax,cs
	mov	word ptr IOCTL[16],ax	;transfer address
	mov	ax,offset AudInfo
	mov	word ptr IOCTL[14],ax	;transfer address

	mov	IOCTL[18],9

	mov	ax,cs
	mov	word ptr data[2],ax	;address of IOCTL record
	mov	ax,offset IOCTL
	mov	word ptr data,ax

	call	ToCD
	ret
endp	PutAudInfo

GetAudInfo	proc
	mov	IOCTL[2],3		;command code
	inc	AudInfo[0]
	
	mov	ax,cs
	mov	word ptr IOCTL[16],ax	;transfer address
	mov	ax,offset AudInfo
	mov	word ptr IOCTL[14],ax	;transfer address

	mov	IOCTL[18],9

	mov	ax,cs
	mov	word ptr data[2],ax	;address of IOCTL record
	mov	ax,offset IOCTL
	mov	word ptr data,ax

	call	ToCD
	dec	AudInfo[0]
	ret
endp	GetAudInfo


PlayCD	proc				;DI must contain track number
	push	di
	mov	Play[2],132		;command code

	shl	di,2

	les	bx,dword ptr Tracks[di]
	mov	word ptr Play[16],es
	mov	word ptr Play[14],bx
	mov	cx,es

	call	RedBook2HSG
	mov	bx,ax
	mov	cx,dx
	push	bx
	push	cx
	
	mov	al,DiskInfo[2]		;begin of last track
	inc	al
	xor	ah,ah
	shl	ax,2			;it are dwords
	mov	di,ax

	call	RedBook2HSG

	pop	cx
	pop	bx

	sub	ax,bx
	jnc	@1
	dec	dx
@1:	sub	dx,cx
	
	mov	word ptr Play[20],dx
	mov	word ptr Play[18],ax

	mov	ax,cs
	mov	word ptr data[2],ax	;address of Play record
	mov	ax,offset Play
	mov	word ptr data,ax

	call	ToCD

	pop	di
	ret
endp PlayCD

QChannelInfo	proc
	mov	IOCTL[2],3		;command code
	
	mov	ax,cs
	mov	word ptr IOCTL[16],ax	;transfer address
	mov	ax,offset QInfo
	mov	word ptr IOCTL[14],ax	;transfer address

	mov	IOCTL[18],11

	mov	ax,cs
	mov	word ptr data[2],ax	;address of IOCTL record
	mov	ax,offset IOCTL
	mov	word ptr data,ax

	call	ToCD
	ret
endp	QChannelInfo


StopCD proc
	mov	Stop[2],133		;command code
	
	mov	ax,cs
	mov	word ptr data[2],ax	;address of Stop record
	mov	ax,offset Stop
	mov	word ptr data,ax

	call	ToCD

	ret
endp StopCD


RedBook2HSG proc

	mov	ax,word ptr Tracks[di+2]	;get high word
	mov	cx,4500
	mul	cx

	push	ax			;put ax aside

	mov	al,byte ptr Tracks[di+1]
	mov	cl,75
	mul	cl
	mov	bx,ax

	pop	ax			;get ax back

	add	ax,bx
	jnc	@2			;carry? then decrease high word
	inc	dx
@2:	mov	cl,byte ptr Tracks[di]
	xor	ch,ch
	add	ax,cx
	jnc	@3
	inc	dx
@3:	sub	ax,150
	jnc	@4
	dec	dx
@4:	
	ret
endp RedBook2HSG

dec8out	proc

	push	di
	mov	bx,0B800h
	mov	ds,bx
	xor	cx,cx			; initialize a counter
	mov	di,1			; point to a buffer
	mov	byte ptr DEC8[1],'0'	; zero unused var's
	mov	byte ptr DEC8[2],'0'	;  "     "      "
	mov	byte ptr DEC8[3],'0'	;  "     "      "

dec8out1:
	push	cx		; save the count
	mov	al,dl		; AX has the numerator
	xor	ah,ah		; clear upper half
	mov	cl,10		; divisor of 10
	div	cl		; divide
	mov	dl,al		; get quotient
	mov	al,ah		; get remainder
	add	al,30h		; increase to ASCII
	mov	byte ptr DEC8[di],al; put in tbuff
	inc	di		; point to next byte
	pop	cx		; restore count
	inc	cx		; count the digit
	cmp	dl,0		; done ?
	jnz	dec8out1

	mov	al,byte ptr DEC8[2]
	mov	ds:[si],al
	mov	al,byte ptr DEC8[1]
	mov	ds:[si+2],al
	pop	di
	ret			; return
dec8out	endp









putbar	proc
	push	di
	cld
	mov	dx,cs
	mov	ds,dx
	mov	dx,0B800h
	mov	es,dx
;	lea	si,bar
	mov	di,28
	mov	cx,104
	rep	movsb
	pop	di
	ret
putbar	endp

getbar	proc
	push	di
	cld
	mov	dx,cs
	mov	es,dx
	mov	dx,0B800h
	mov	ds,dx
	mov	si,28
	lea	di,old_bar
	mov	cx,104
	rep	movsb
	pop	di
	ret
getbar	endp

end FastCD
end


