;****************************************************************************
;*	Module contenant des fonctions DOS de base pour rserver de la
;*	RAM, ATTENTION toutes ces fonctions sont de type NEAR
;*
;* Programm par Sbastien Granjoux
;* Commenc le 20/12/94
;* Modification le 02/01/95

IDEAL
P386N

PUBLIC	USEEMS


INCLUDE "CRYSLOAD.INC"
INCLUDE	"CRYSERR.INC"

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

;***************************************************************************
;*	Interdit l'usage de l'ems pour charger les samples

PROC	USEEMS FAR

	push	ds
	mov	ax,SEG EmsSeg
	mov	ds,ax

	call	initems
	jc	@@no_ems
	mov	[word ptr ds:OFFSET EmsSeg],ax
@@no_ems:
	pop	ds

	ret

ENDP



;***************************************************************************
;*	Libre la mmoire prise par le player dans les fonctions ?LOAD*

PROC    Unloadmod FAR

	push	ds

	mov	ax,SEG PatternSeg
	mov	ds,ax
	mov     dx,[ds:PatternSeg]
	mov	al,[ds:PatternType]
	mov	[ds:PatternSeg],0
	call	freemem

	mov	dx,[ds:VolumeSeg]
	xor	ax,ax
	mov	[ds:VolumeSeg],ax
	call	freemem

	mov	bx,OFFSET Instrument1
	mov	cl,MAX_INST
@@sample:
	xor	dx,dx
	xchg	dx,[(INSTRUMENT PTR ds:bx).adrseg]
	mov	al,[(INSTRUMENT PTR ds:bx).type]
	call	freemem

	add	bx,SIZE INSTRUMENT
	dec	cl
	jne	@@sample

	pop	ds

	ret

ENDP

;**************************************************************************
;*	Remet  zros les donnes des instruments avant le chargement d'un
;*	module et alloue l'instrument nulle
;*
;* Sortie:
;*	DS	segment de donnes du player

PROC	ClearMod

	mov	ax,SEG EmsSeg
	mov	ds,ax

	mov	bx,(SAMPLE_BORDER+MIN_REPEAT+15)/16
	call	allocsamp

	push	ebx
	push	dx
	push	ax
	mov	cx,SAMPLE_BORDER+MIN_REPEAT
	mov	ax,SILENT
	rep	stosb

	mov	ecx,MIN_REPEAT
	call	copymem
	pop	bx
	pop	dx
	jc	@@error

	mov	si,OFFSET Instrument1
	mov	bh,MAX_INST
	pop	eax
	mov	ecx,MIN_REPEAT
	add	ecx,eax
@@voidsample:
	mov	[(INSTRUMENT PTR ds:si).endadr],ecx
	mov	[(INSTRUMENT PTR ds:si).sampadr],eax
	mov	[(INSTRUMENT PTR ds:si).replen],MIN_REPEAT
	mov	[(INSTRUMENT PTR ds:si).volume],0
	mov	[(INSTRUMENT PTR ds:si).type],bl
	mov	[(INSTRUMENT PTR ds:si).adrseg],dx
	or	bl,4
	add	si,SIZE INSTRUMENT
	dec	bh
	jne	@@voidsample

	clc
	ret

@@error:
	pop	edx
	stc
	ret

ENDP

UsedFs	DW	0

;**************************************************************************
;*	ouvre un fichier suivant diffrent mode
;*
;* Entre:
;*	CS:BX	adresse du driver de fichier  utiliser
;*	DS:DX   paramtre pour le driver (gnralement nom du fichier)
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	open

	mov     [cs:UsedFs],bx
	mov	bx,[(FILESYS PTR cs:bx).open]
	jmp	bx
ENDP

;***************************************************************************
;*	lit des informations dans un fichier
;*
;* Entre:
;*	CX	nombre d'octet  lire
;*	DS:DX	pointeur sur le buffer
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	read

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).read]
	jmp	bx

ENDP

;***************************************************************************
;*	se dplace dans un fichier par rapport  la position courante
;*
;* Entre:
;*	CX:DX   dplacement dans le fichier
;*
;* Sortie:
;*	AX	erreur si C=1


PROC	seek

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).seek]
	jmp	bx

ENDP

;***************************************************************************
;*	Ferme un fichier
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	close

	mov	bx,[cs:UsedFs]
	mov	bx,[(FILESYS PTR cs:bx).close]
	jmp	bx

ENDP

TypeMem	DB	0
LastBlk DW	0
LastPos2 DW	0

;**************************************************************************
;*	Procdure l'allocation de mmoire
;*
;* Entre:
;*      BX	nombre de paragraphe  allouer (16 octets)
;*	DS	segment des donnes du player
;*
;* Sortie:
;*	AL	type de mmoire allou 0 conventionnel,1 ems si C=0
;*	AX	code d'erreur si C=1
;*	DX	handle sur le bloc allou
;*	ES:DI	pointeur sur le dbut du bloc
;*	EBX	adresse de dpart de l'instrument

PROC	allocsamp

	cmp	[word ptr ds:MemDev+2],0
	je	allocpat

allocgus:
	push	bx
	mov	ah,1
	call	[dword ptr ds:MemDev]
	mov	eax,ebx
	pop	bx
	jc	@@error
	push	eax
	push	dx
	call	allocmem
	pop     dx
	pop	ebx
	jc	@@error
	mov	al,2
	mov	[cs:TypeMem],al
	ret

@@error:
	ret
ENDP

PROC	allocpat
	cmp	[word ptr ds:FlatDev],0
	je	allocems
	push	bx
	mov	ah,1
	call	[word ptr ds:FlatDev]
	mov	eax,ebx
	pop	bx
	jc	@@error

	push	eax
	push	dx
	call	allocmem
	pop     dx
	pop	ebx
	jc	@@error
	mov	al,3
	mov	[cs:TypeMem],al
@@error:
	ret

ENDP

PROC	allocems

	cmp	[ds:EmsSeg],NO_EMS
	je	allocmem

	push	bx
	mov	ah,43h
	add	bx,1023
	shr	bx,10
	int	67h
	pop	bx
	or	ah,ah
	jne	allocmem

	mov	ax,4400h
	xor	bx,bx
	int	67h

        xor	ebx,ebx
	mov	es,[ds:EmsSeg]
	xor	di,di
	mov	[cs:LastPos2],di
	mov	al,1
	mov	[cs:TypeMem],al
	mov	[cs:LastBlk],dx

	ret

ENDP

PROC	allocmem

	mov	ah,48h
	int	21h
	jc	@@fin
	mov	dx,ax
	mov	es,ax
	xor	di,di

	movzx	ebx,ax
	shl	ebx,4
	mov	al,0
	mov	[cs:TypeMem],al
	mov	[cs:LastBlk],dx

@@fin:
	ret

ENDP

;***************************************************************************
;*	Pointe le bloc suivant avec ES:DI
;*
;* Entre:
;*	ES ancien segment du bloc
;*
;* Sortie:
;*	ES:DI	nouvelle position

PROC	nextmem

	test	[cs:TypeMem],1
	jz	@@conv
	test	[cs:TypeMem],2
	jnz	@@conv

	mov	ax,4400h
	mov	dx,[cs:LastBlk]
	mov	bx,[cs:LastPos2]
	inc	bx
	mov	[cs:LastPos2],bx

	int	67h

	xor	di,di

	ret

@@conv:
	mov	ax,es
	add	ax,MAX_BLOCK/16
	mov	es,ax
	xor	di,di

	ret
ENDP

;***************************************************************************
;*	Retourne l'adresse du bloc de mmoire prcdament allou  la
;*	position edx
;*
;* Entre:
;*	EBX	position dans le bloc
;*
;* Sortie:
;*	ES:DI	position en mmoire

PROC	seekblk

	test	[cs:TypeMem],1
	jz	@@seekconv
	test	[cs:TypeMem],2
	jnz	@@seekconv

	mov	al,[cs:TypeMem]
	and	ax,4
	shr	ax,1
	mov	ah,44h
	push	ax
	mov	dx,[cs:LastBlk]
	mov	edi,ebx
	shr	ebx,14
	int	67h

	pop	ax
	inc	al
	inc	bx
	int	67h
	and	edi,03FFFh
	mov	al,[cs:TypeMem]
	ror	ax,3
	and	ax,8000h
	or	di,ax
	xor	[cs:TypeMem],4

	ret

@@seekconv:
	mov     di,bx
	and	di,0Fh
	shr	ebx,4
	add	bx,[cs:LastBlk]
	mov	es,bx

	ret

ENDP

;***************************************************************************
;*	Transfert eventuellement un sample dans la mmoire d'une carte
;*	sonore
;*
;* Entre:
;*	DS	segment des donnes du player
;*	ECX	longeur du bloc mmoire
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	copymem

	mov	al,[cs:TypeMem]
	and	al,3
	cmp	al,2
	je	@@transfert
	cmp	al,3
	je	@@flat_transfert
	clc
	ret

@@transfert:
	mov	ah,3
	mov	dx,[cs:LastBlk]
	call	[dword ptr ds:OFFSET MemDev]
	clc
	ret
@@flat_transfert:
	mov	ah,3
	mov	dx,[cs:LastBlk]
	call	[word ptr ds:OFFSET FlatDev]
	clc
	ret

ENDP

;***************************************************************************
;*	Rend un bloc mmoire de mmoire conventionel au systme
;*
;* Entre:
;*	AL	type de mmoire  rendre
;*	DX	handle sur la mmoire
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	freemem

	or	dx,dx
	je	@@already_free
	test	al,4
	jnz	@@already_free
	test	al,1
	jz	@@free_conv
	test	al,2
	jnz	@@free_frm

	mov	ah,45h
	int	67h
	or	ah,ah
	je	@@already_free
	stc
	ret

@@free_frm:
	mov	ah,2
	call    [word ptr ds:OFFSET FlatDev]
	ret

@@free_conv:
	test	al,2
	jnz	@@free_dev

	push	es
	mov	es,dx
	mov	ah,49h
	int	21h
	pop	es
	jmp	@@already_free

@@free_dev:
	mov	ah,2
	call	[dword ptr ds:OFFSET MemDev]

@@already_free:
	ret

ENDP

;**************************************************************************
;*	Verifie qu'un gestionnaire de mmoire type emm386 est prsent
;*
;* Sortie:
;*	AX = segment et C=0 si le gestionnaire est prsent

PROC	initems

	push	es
	push	bx
	mov	ax,3567h
	int	21h
	cmp	[dword ptr es:10],'XMME'
	jne	@@no_ems
	cmp	[dword ptr es:14],'0XXX'
	jne	@@no_ems
	mov	ah,41h
	int	67h
	or	ah,ah
	jne	@@no_ems
	mov	ax,bx
	pop	bx
	pop	es
	clc
	ret

@@no_ems:
	pop	bx
	pop	es
	stc
	ret
ENDP

;**************************************************************************
;*	Recupre l'adresse du bloc d'environnement
;*
;* Sortie
;*	AX	adresse du bloc d'environnement

PROC	getenvadr FAR

	mov	ah,62h
	int	21h
	mov	es,bx
	mov	ax,[es:2Ch]
	ret

ENDP

ENDS
END
