;****************************************************************************
;*	Module contenant des fonctions DOS de base pour lire un fichier
;*	ATTENTION toutes ces fonctions sont de type NEAR
;*
;* Programm par Sbastien Granjoux
;* Commenc le 20/12/94
;* Modification le 01/02/95

IDEAL

INCLUDE "CRYSLOAD.INC"

PUBLIC	USEFILE

SEGMENT CSEG PARA PUBLIC USE16 'CODE'

ASSUME	cs:CSEG

UseFile:
	FILESYS <OFFSET openfile,OFFSET closefile,OFFSET seekfile,OFFSET readfile>

Handle	DW	-1

;***************************************************************************
;*	Ouvre un fichier en mode lecture, ATTENTION il ne peut y avoir
;*	qu'un seul fichier ouvert en mme temps
;*
;* Entre:
;*	DS:DX	nom du fichier
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	openfile

	mov	ax,3D00h
	int	21h
	jc	@@error
	mov	[cs:Handle],ax
@@error:
	ret
ENDP

;***************************************************************************
;*	Lit un block d'octet dans un fichier prcdament ouvert
;*
;* Entre:
;*	CX	nombre d'octet  lire
;*	DS:DX	adresse du buffer recevant les donnes
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	readfile

	mov	bx,[cs:Handle]
	mov	ah,3Fh
	int	21h
	ret

ENDP

;***************************************************************************
;*	Se dplace dans le fichier par rapport  la position courante
;*
;* Entre:
;*      CX:DX	nouvelle position dans le fichier
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	seekfile

	mov	ax,4201h
	mov	bx,[cs:Handle]
	int	21h
	ret

ENDP

;***************************************************************************
;*	Ferme le fichier ouvert prcdament
;*
;* Sortie:
;*	AX	erreur si C=1

PROC	closefile

	mov	ah,3eh
	mov	bx,[cs:Handle]
	int	21h
	ret

ENDP

ENDS

END
