{**************************************************************************}
{*   Voici un petit programme d'exemple d'intgration de mes routines     *}
{*   dans un programme en pascal.                                         *}
{*              							  *}
{*   L'ordre d'appel des fonctions est important.                         *}
{*   Ce programme utilise l'unit pascal CRYSTAL.TPU dont la source est   *}
{*   CRYSTAL.PAS							  *}
{*									  *}
{* Programm par Sbastien Granjoux                                       *}
{* Commenc le 06/01/93                                                   *}
{* Modification le 25/10/94						  *}

PROGRAM CRYSEXP;

{$M 4096,0,8192} { Comme mes routines se chargent seules d'allouer la place
		   mmoire ncessaire au chargement du MOD, il faut leur
		   laisser de la place.                                     }


Uses CRYSTAL;    { Utilise l'unit                                          }

VAR
   Fichier:STRING;
   Test:INTEGER;
   Device,Irq,Dma:BYTE;
   Dport:WORD;

BEGIN


   Fichier:='c:patega.mod'+chr(0);  { J'utilise la convention du C qui est
				     diffrentes de celle du pascal pour
				     la reprsentation des chaines de
				     de caractres. Elles doivent se
				     terminer par 0 et commencer au
				     premier caractre.                    }

  Dport:=0;
  Irq:=0;
  Dma:=0;
  Device:=5;

  DETECTSND(Device,Dport,Irq,Dma);    { Cherche la meilleur cartes sonore
				       dans les variables d'environnements  }

  Test:=FLOADMOD(Addr(Fichier[1]));   { Charge le MOD. Le nom est pass sous
				       la forme d'une chaine C              }

  Test:=SETMOD(180,Device,Dport,Irq); { Prepare la MOD  18kHz avec la carte
				       son trouv                           }

  STARTMOD;			      { Commence la musique		    }

  { A partir de ce moment il ne peut y avoir que les interruptions clavier
   ou horloge, vous devez donc dmasquer les interruptions qui pourraient
   vous tre utile comme celle du disque dur ou de la souris. Toutefois si
   vous tenez  avoir une musique de la meilleur qualit possible vitez
   de le faire et n'utilisez que des routines simples.		            }

   REPEAT
   BEGIN
	MAKEMOD;                      { Calcule 1/50s de musique            }
   END
   UNTIL PORT[$60]<$80;               { Beaucoup plus rapide qu'une fonction
				       du genre de keypress et donc meilleur
				       pour la qualit de la musique	    }

   STOPMOD;         		      { Arrte la musique et remet le PC dans
				       son tat initial			    }

   UNLOADMOD;          		      { Rend la mmoire utilis pour charger
				       le MOD au DOS		           }

END.
